<?php
/****************优客365网址导航系统 商业版********************/
/*                                                            */
/*  Youke365.com (C)2017 Youke365 Inc.                        */
/*  This is NOT a freeware, use is subject to license terms   */
/*  优客365网址导航系统是商业软件,使用于商业用途请购买授权    */
/*  V1.0 2017                                                 */
/*  技术支持：1513773524@qq.com                               */
/*  官方网址：http://www.youke365.com                         */
/*  官方论坛：http://bbs.youke365.com                         */                           
/**************************************************************/
require('common.php');
$fileurl = 'website.php';
$tempfile = 'website.html';
$table = $DB->table('website');

if (empty($action)) $action = 'list';

/** list */
if ($action == 'list') {
	$pagetitle = '站点列表';
	
	$status = isset($_GET['status'])?intval($_GET['status']):'';
	$user_id =  isset($_GET['user_id'])?intval($_GET['user_id']):'';;
	$cate_id =  isset($_GET['cate_id'])?intval($_GET['cate_id']):'0';
	$sort =  isset($_GET['sort'])?intval($_GET['sort']):'';
	$order = isset($_GET['order'])?strtoupper(trim($_GET['order'])):'';
	$get_keywords = isset($_GET['keywords'])?htmlcpecialchars($_GET['keywords']):'';
	$keywords =isset($_POST['keywords'])?addslashes(trim($_POST['keywords'])):$get_keywords; 
	if (empty($order)) $order = 'DESC';
	
	$pageurl = $fileurl.'?status='.$status.'&user_id='.$user_id.'&cate_id='.$cate_id.'&sort='.$sort.'&order='.$order;
	$keyurl = !empty($keywords) ? '&keywords='.urlencode($keywords) : '';
	$pageurl .= $keyurl;
	
	$category_option = get_category_option(0,$cate_id, 0);
	
	$smarty->assign('status', $status);
	$smarty->assign('user_id', $user_id);
	$smarty->assign('cate_id', $cate_id);
	$smarty->assign('sort', $sort);
	$smarty->assign('order', $order);
	$smarty->assign('keywords', $keywords);
	$smarty->assign('keyurl', $keyurl);
	$smarty->assign('category_option', $category_option);
	
	$where = '';
	$sql = "SELECT a.web_id, a.user_id, a.cate_id, a.web_name, a.web_url, a.web_ico,a.web_istop,a.web_ispay,a.web_isbest, a.web_status, a.web_ctime, b.web_ip, b.web_r360, b.web_brank, b.web_srank, b.web_arank, b.web_instat, b.web_outstat, b.web_views, b.web_errors, c.cate_name, u.nick_name FROM $table a LEFT JOIN ".$DB->table('webdata')." b ON a.web_id=b.web_id LEFT JOIN ".$DB->table('categories')." c ON a.cate_id=c.cate_id LEFT JOIN ".$DB->table('users')." u ON a.user_id=u.user_id WHERE";

	switch ($status) {
		case 1 :
			$where .= " a.web_status=1";
			break;
		case 2 :
			$where .= " a.web_status=2";
			break;
		case 3 :
			$where .= " a.web_status=3";
			break;
		default :
			$where .= " a.web_status>-1";
			break;
	}
	
	if ($user_id > 0) {
		$where .= " AND a.user_id = '$user_id'";
	}
	
	if ($cate_id > 0) {
		$cate = get_one_category($cate_id);
		$where .= " AND a.cate_id IN (".$cate['cate_arrchildid'].")";
	}
	
	if ($keywords) $where .= " AND a.web_name like '%$keywords%'";
	
	switch ($sort) {
		case 1 :
			$field = "a.web_ctime";
			break;
		case 2 :
			$field = "b.web_r360";
			break;
		case 3 :
			$field = "b.web_brank";
			break;
		case 4 :
			$field = "b.web_srank";
			break;
		case 5 :
			$field = "b.web_arank";
			break;
		case 6 :
			$field = "b.web_instat";
			break;
		case 7 :
			$field = "b.web_outstat";
			break;
		case 8 :
			$field = "b.web_views";
			break;
		case 9 :
			$field = "b.web_errors";
			break;
		default :
			$field = "a.web_ctime";
			break;
	}
	
	$sql .= $where." ORDER BY a.web_istop DESC, $field $order LIMIT $start, $pagesize";
	$query = $DB->query($sql);
	
	$website = array();
	while ($web = $DB->fetch_array($query)) {
		switch ($web['web_status']) {
			case 1 :
				$web_status = '<font color="#333333">黑名单</font>';
				break;
			case 2 :
				$web_status = '<font color="#ff3300">待审核</font>';
				break;
			case 3 :
				$web_status = '<font color="#008800">已审核</font>';
				break;
		}

		$web_ispay = $web['web_ispay'] > 0 ? '<font color="#ff0000">付费</font>' : '<font color="#cccccc">未付费</font>';
		$web_istop = $web['web_istop'] > 0 ? '<font color="#ff0000">置顶</font>' : '<font color="#cccccc">置顶</font>';
		$web_isbest = $web['web_isbest'] > 0 ? '<font color="#ff3300">推荐</font>' : '<font color="#cccccc">推荐</font>';
		$web['web_attr'] = $web_istop.' - '.$web_isbest.' - '.$web_ispay.' - '.$web_status;
		$web['web_cate'] = '<a href="'.$fileurl.'?cate_id='.$web['cate_id'].'">'.$web['cate_name'].'</a>';
		$web['nick_name'] = '<a href="'.$fileurl.'?user_id='.$web['user_id'].'" title="查看该用户提交的所有站点">'.$web['nick_name'].'</a>';
		$web['web_name'] = '<a href="'.format_url($web['web_url']).'" target="_blank">'.$web['web_name'].'</a> '.($web['web_errors'] > 0 ? '<sup style="color: #f00;">error!</sup>' : '');
		$web['web_ip'] = long2ip($web['web_ip']);
		$web['web_arank'] = number_format($web['web_arank']);
		$web['web_ctime'] = date('Y-m-d', $web['web_ctime']);
		$web['web_operate'] = '<a href="'.$fileurl.'?act=edit&web_id='.$web['web_id'].'">编辑</a>&nbsp;|&nbsp;<a href="'.$fileurl.'?act=del&web_id='.$web['web_id'].'" onClick="return confirm(\'确认删除此内容吗？\');">删除</a>';
		$website[] = $web;
	}
	unset($web);
	$DB->free_result($query);
	
	$total = $DB->get_count($table.' a', $where);
	$showpage = showpage($pageurl, $total, $curpage, $pagesize);
	
	$smarty->assign('website', $website);
	$smarty->assign('showpage', $showpage);
	unset($website);
}

/** down */
if ($action == 'down') {
	$pagetitle = '下载站点图片';
}

/** add */
if ($action == 'add') {
	$pagetitle = '添加站点';

	$cate_id = isset($_GET['cate_id'])?intval($_GET['cate_id']):0;
	$category_option = get_category_option(0, $cate_id, 0);
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('status', 3);
	$smarty->assign('h_action', 'saveadd');
}

/** edit */
if ($action == 'edit') {
	$pagetitle = '编辑站点';
	
	$web_id = intval($_GET['web_id']);
	$where = "a.web_id=$web_id";
	$web = get_one_website($where);

	if (!$web) {
		msgbox('指定的内容不存在！');
	}
	
	#分类ID
	$parent_cids = get_category_parent_ids($web['cate_id']).','.$web['cate_id'];
	if (strpos($parent_cids, ',') !== false) {
		$cate_pids = explode(',', $parent_cids);
		array_shift($cate_pids);
	} else {
		$cate_pids = (array) $parent_cids;
	}
	
	#IP
	$row['web_ip'] = long2ip($row['web_ip']);
	
	#状态
	$status = isset($row['web_status'])?$row['web_status']:'';
	
	$smarty->assign('cate_pids', $cate_pids);
	$smarty->assign('status', $web['web_status']);
	$smarty->assign('web', $web);
	$smarty->assign('h_action', 'saveedit');
}

/** move */
if ($action == 'move') {
	$pagetitle = '移动站点';
			
	$web_ids = (array) ($_POST['web_id'] ? $_POST['web_id'] : $_GET['web_id']);
	if (empty($web_ids)) {
		msgbox('请选择要移动的站点！');
	} else {
		$wids = dimplode($web_ids);
	}
	
	$category_option = get_category_option(0, 0, 0);
	$websites = $DB->fetch_all("SELECT web_id, web_name FROM $table WHERE web_id IN ($wids)");
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('websites', $websites);
	$smarty->assign('h_action', 'savemove');
}

/** attr */
if ($action == 'attr') {
	$pagetitle = '属性设置';
	
	$web_ids = (array) ($_POST['web_id'] ? $_POST['web_id'] : $_GET['web_id']);
	if (empty($web_ids)) {
		msgbox('请选择要设置的站点！');
	} else {
		$wids = dimplode($web_ids);
	}
	
	$category_option = get_category_option(0, 0, 0);
	$websites = $DB->fetch_all("SELECT web_id, web_name FROM $table WHERE web_id IN ($wids)");
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('websites', $websites);
	$smarty->assign('h_action', 'saveattr');
}

/** save data */
if (in_array($action, array('saveadd', 'saveedit'))) {
	$cate_id = intval($_POST['cate_id']);
	$web_name = I($_POST['web_name']);
	$web_ico = I($_POST['web_ico']);
	$web_url = trim($_POST['web_url']);
	$web_tags = strtolower(addslashes(trim($_POST['web_tags'])));
	$web_intro = addslashes(trim($_POST['web_intro']));
	$web_ip = I($_POST['web_ip']);
	$web_r360 = intval($_POST['web_r360']);
	$web_brank = intval($_POST['web_brank']);
	$web_srank = intval($_POST['web_srank']);
	$web_arank = intval($_POST['web_arank']);
	$web_instat = intval($_POST['web_instat']);
	$web_outstat = intval($_POST['web_outstat']);
	$web_views = intval($_POST['web_views']);
	$web_errors = intval($_POST['web_errors']);
	$web_ispay = intval($_POST['web_ispay']);

	$web_istop = intval($_POST['web_istop']);
	$web_isbest = intval($_POST['web_isbest']);
	$web_status = intval($_POST['web_status']);
	$web_time = time();


	
	if ($cate_id <= 0) {
		msgbox('请选择网站所属分类！');
	} else {
		$cate = get_one_category($cate_id);
		if ($cate['cate_childcount'] > 0) {
			msgbox('指定的分类下有子分类，请选择子分类进行操作！');
		}
	}
	
	if (empty($web_name)) {
		msgbox('请输入网站名称！');
	}
	
	if (empty($web_url)) {
		msgbox('请输入网站域名！');
	} else {
		if (!is_valid_domain($web_url)) {
			msgbox('请输入正确的网站域名！');
		}
	}
	
	if (empty($web_intro)) {
		msgbox('请输入网站简介！');
	}
   


  //   if(!empty($_FILES['web_ico']['name'])){
		// //上传封面
		// 	 $Upload = new FileUpload;
		// 	 $Upload->set('path',ROOT_PATH.$options['upload_dir'].'/ico');
		// 	 if(!$Upload->upload('web_ico')){
		//        msgbox($Upload->getErrorMsg()); 
		// 	 }else{

		// 	   $web_ico = '/'.$options['upload_dir'].'/ico/'.$Upload->getFileName();
		// 	 }
		//      if($Upload->getFileName()){
		//      	$web_data['web_ico'] = $web_ico;
		//      }

  //   }


	$web_tags = str_replace('，', ',', $web_tags);
	$web_tags = str_replace(',,', ',', $web_tags);
	if (substr($web_tags, -1) == ',') {
		$web_tags = substr($web_tags, 0, strlen($web_tags) - 1);
	}
	
	$web_ip = sprintf("%u", ip2long($web_ip));
	$web_data['web_ico'] = $web_ico;
	$web_data['cate_id'] = $cate_id;
	$web_data['web_name'] = $web_name;
	$web_data['web_url'] = $web_url;
	$web_data['web_tags'] = $web_tags;
	$web_data['web_intro'] = $web_intro;
	$web_data['web_ispay'] = $web_ispay;
	$web_data['web_istop'] = $web_istop;
	$web_data['web_isbest'] = $web_isbest;
	$web_data['web_status'] = $web_status;
	$web_data['web_ctime'] = $web_ctime;


	
	$stat_data = array(
		'web_ip' => $web_ip,
		'web_r360' => $web_r360,
		'web_brank' => $web_brank,
		'web_srank' => $web_srank,
		'web_arank' => $web_arank,
		'web_instat' => $web_instat,
		'web_outstat' => $web_outstat,
		'web_views' => $web_views,
		'web_errors' => $web_errors,
		'web_utime' => $web_time,
	);
	
	if ($action == 'saveadd') {
    	$query = $DB->query("SELECT web_id FROM $table WHERE web_url='$web_url'");
    	if ($DB->num_rows($query)) {
        	msgbox('您所添加的网站已存在！');
    	}
		
		$web_data['user_id'] = $myself['user_id'];
		$DB->insert($table, $web_data);
		$stat_data['web_id'] = $DB->insert_id();
		$DB->insert($DB->table('webdata'), $stat_data);
		$DB->query("UPDATE ".$DB->table('categories')." SET cate_postcount=cate_postcount+1 WHERE cate_id=$cate_id");
		update_cache('archives');
		
		msgbox('网站添加成功！', $fileurl.'?act=add&cate_id='.$cate_id);	
	} elseif ($action == 'saveedit') {
		$web_id = intval($_POST['web_id']);
		$where = array('web_id' => $web_id);
		unset($web_data['web_ctime']);
		
		$DB->update($table, $web_data, $where);
		$DB->update($DB->table('webdata'), $stat_data, $where);
		
		$DB->query("UPDATE ".$DB->table('categories')." SET cate_postcount=cate_postcount+1 WHERE cate_id=$cate_id");
		update_cache('archives');
		
		msgbox('网站修改成功！', $fileurl);
	}
}

/** del */
if ($action == 'del') {
	$web_ids = (array) ($_POST['web_id'] ? $_POST['web_id'] : $_GET['web_id']);
	
	$DB->delete($table, 'web_id IN ('.dimplode($web_ids).')');
	$DB->delete($DB->table('webdata'), 'web_id IN ('.dimplode($web_ids).')');
	update_cache('archives');
	unset($web_ids);
	
	msgbox('网站删除成功！', $fileurl);
}

/** move */
if ($action == 'savemove') {
	$web_ids = (array) $_POST['web_id'];
	$cate_id = intval($_POST['cate_id']);
	if (empty($web_ids)) {
		msgbox('请选择要移动的内容！');
	}
	if ($cate_id <= 0) {
		msgbox('请选择分类！');
	} else {
		$cate = get_one_category($cate_id);
		if ($cate['cate_childcount'] > 0) {
			msgbox('指定的分类下有子分类，请选择子分类进行操作！');
		}
	}
	
	$DB->update($table, array('cate_id' => $cate_id), 'web_id IN ('.dimplode($web_ids).')');
	update_cache('archives');
	
	msgbox('网站移动成功！', $fileurl);
}

/** attr */
if ($action == 'saveattr') {
	$web_ids = (array) $_POST['web_id'];
	$web_ispay = intval($_POST['web_ispay']);
	$web_istop = intval($_POST['web_istop']);
	$web_isbest = intval($_POST['web_isbest']);
	$web_status = intval($_POST['web_status']);
	if (empty($web_ids)) {
		msgbox('请选择要设置的内容！');
	}
	


	
	$websites = $DB->fetch_all("SELECT w.web_id, w.web_name, u.user_email FROM $table w LEFT JOIN ".$DB->table("users")." u ON w.user_id=u.user_id WHERE w.web_id IN (".dimplode($web_ids).")");
	foreach ($websites as $row) {
		if ($web_status == 3) {
			$site_link = get_website_url($row['web_id'], true);
			//发送邮件
			if (!empty($options['smtp_host']) && !empty($options['smtp_port']) && !empty($options['smtp_auth']) && !empty($options['smtp_user'])  && !empty($options['smtp_pass'])) {	
				$smarty->assign('site_name', $options['site_name']);
				$smarty->assign('site_url', $options['site_url']);
				$smarty->assign('web_name', $row['web_name']);
				$smarty->assign('site_link', $site_link);
				$mailbody = $smarty->fetch('audit_mail.html');
				sendmail($row['user_email'], '['.$options['site_name'].'] 网站已通过审核！', $mailbody);
			}
		}		
		$DB->update($table, array('web_istop' => $web_istop, 'web_isbest' => $web_isbest, 'web_status' => $web_status), array('web_id' => $row['web_id']));
	}
	
	$DB->update($table, array('web_ispay' => $web_ispay,'web_istop' => $web_istop, 'web_isbest' => $web_isbest, 'web_status' => $web_status), 'web_id IN ('.dimplode($web_ids).')');
	
	msgbox('网站属性设置成功！', $fileurl);
}

/** metainfo */
if ($action == 'metainfo') {
	$url = trim($_GET['url']);
	if (empty($url)) {
		exit('-2'); //请输入网站域名！
	} else {
		if (!is_valid_domain($url)) {
			exit('-1');  //'请输入正确的网站域名！'
		}
	}
	

	$meta = get_sitemeta($url);	
    $url = rtrim($url,'/');
    $ico_status  = get_ico($url);
    if($ico_status){
      $ico = $url.'/favicon.ico';
    }
	echo '<script type="text/javascript">';
	echo '$("#web_name").val("'.$meta['title'].'");';
	echo '$("#web_tags").val("'.$meta['keywords'].'");';
	echo '$("#web_intro").val("'.$meta['description'].'");';
	echo '$("#web_ico").val("'.$ico.'");';
	echo '</script>';
	unset($meta);
}

/** webdata */
if ($action == 'webdata') {
	$url = trim($_GET['url']);
	if (empty($url)) {
		exit('-2'); //请输入网站域名！
	} else {
		if (!is_valid_domain($url)) {
			exit('-1');  //'请输入正确的网站域名！'
		}
	}
	
	$url = str_replace('http://','',$url);
	$url = str_replace('https://','',$url);
	$ip = get_serverip($url);
	$brank = get_baidurank($url);
	$srank = get_sogourank($url);
	$arank = get_alexarank($url);
	$r360 =  get_r360($url);
	echo '<script type="text/javascript">';
	echo '$("#web_ip").val("'.$ip.'");';
	echo '$("#web_brank").val("'.$brank.'");';
	echo '$("#web_r360").val("'.$r360.'");';
	echo '$("#web_srank").val("'.$srank.'");';
	echo '$("#web_arank").val("'.$arank.'");';
	echo '</script>';
}

smarty_output($tempfile);
?>


