<?php

function smarty_output($template, $cache_id = NULL, $compile_id = NULL) {
	global $smarty, $options;
	

	template_exists($template);
	
	$options = stripslashes_deep($options);
	
	$smarty->assign('site_root', $options['site_root']);
	$smarty->assign('site_name', $options['site_name']);
	$smarty->assign('site_url', $options['site_url']);
	$smarty->assign('site_copyright', $options['site_copyright']);
	$smarty->assign('cfg', $options); #options
	$smarty->display($template, $cache_id, $compile_id);

	if ($options['is_enabled_rewrite'] == 'yes') {
		$content = rewrite_output($content);
	}
	unset($options);
	echo $content;
	
	#gzip
	if($options['is_enabled_gzip'] == 'yes') {
		$buffer = ob_get_contents();
		ob_end_clean();
		if(extension_loaded('zlib')) { 
			ob_start('ob_gzhandler');
		} else {
			ob_start();
		}

		echo $buffer;
	}
}



	
/** site path */
function get_sitepath() {
	global $options;
	
	$strpath = '当前位置：<a href="'.$options['site_url'].'">'.$options['site_name'].'</a> &raquo; <a href="'.$options['site_root'].'member/?mod=home">会员中心</a>';
	
	return $strpath;
}
?>