DROP TABLE IF EXISTS `admin_action`;
CREATE TABLE IF NOT EXISTS `admin_action` (
  `actionID` int(11) NOT NULL auto_increment,
  `cDate` varchar(10) NOT NULL default '',
  `mDate` varchar(10) NOT NULL default '',
  `actionName` varchar(20) default NULL,
  `moduleID` int(11) NOT NULL default '0',
  `actionStr` varchar(50) NOT NULL default '',
  `actionState` varchar(20) NOT NULL default '1',
  PRIMARY KEY  (`actionID`),
  KEY `actionModuleID` (`moduleID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=176 ;

INSERT INTO `admin_action` (`actionID`, `cDate`, `mDate`, `actionName`, `moduleID`, `actionStr`, `actionState`) VALUES
(1, '', '1208687310', '会员列表', 8, 'viewUser', '1'),
(2, '', '1208687310', '修改会员', 8, 'updateUser', '1'),
(4, '', '1208687310', '锁定会员', 8, 'lockUser', '1'),
(5, '', '1208687310', '删除会员', 8, 'delUser', '1'),
(70, '', '1208078540', '管理组列表', 35, 'viewAdminGroup', '1'),
(71, '', '1208078540', '添加管理组', 35, 'addAdminGroup', '1'),
(72, '', '1208078540', '修改管理组', 35, 'updateAdminGroup', '1'),
(73, '', '1208078540', '删除管理组', 35, 'delAdminGroup', '1'),
(74, '', '1208078540', '管理员列表', 36, 'viewMaster', '1'),
(75, '', '1208078540', '添加管理员', 36, 'addMaster', '1'),
(76, '', '1208078540', '修改管理员', 36, 'updateMaster', '1'),
(77, '', '1208078540', '删除管理员', 36, 'delMaster', '1'),
(78, '', '1208078540', '权限管理列表', 37, 'viewAdminAction', '1'),
(79, '', '1208078540', '添加权限', 37, 'addAdminAction', '1'),
(80, '', '1208078540', '禁用权限', 37, 'updateAdminAction', '1'),
(81, '', '1208078540', '删除权限', 37, 'delAdminAction', '1'),
(82, '', '1208078540', '查看管理模块', 38, 'viewAdminModule', '1'),
(83, '', '1208078540', '添加管理模块', 38, 'addAdminModule', '1'),
(84, '', '1208078540', '修改管理模块', 38, 'updateAdminModule', '1'),
(85, '', '1208078540', '删除管理模块', 38, 'delAdminModule', '1'),
(93, '', '1208061825', '系统工具', 39, 'useTools', '1'),
(94, '', '1208061825', '密码修改', 40, 'updateMasterPwd', '1'),
(106, '', '1213263532', '查看管理日志', 44, 'viewAdminLog', '1'),
(155, '1223974952', '1223974952', '查看站点列表', 71, 'viewSite', '1'),
(156, '1223974952', '1223974952', '添加站点', 71, 'addSite', '1'),
(157, '1223974952', '1223974952', '删除站点', 71, 'delSite', '1'),
(158, '1223974952', '1223974952', '修改站点', 71, 'updateSite', '1'),
(159, '1223975037', '1223975037', '查看分类表', 70, 'viewSiteType', '1'),
(160, '1223975037', '1223975037', '添加分类', 70, 'addSiteType', '1'),
(161, '1223975037', '1223975037', '删除分类', 70, 'delSiteType', '1'),
(162, '1223975037', '1223975037', '修改分类', 70, 'updateSiteType', '1'),
(163, '1278585153', '1278585153', '站点审核', 72, 'checkSite', '1'),
(164, '1278916057', '1278916057', '查看留言列表', 74, 'viewMessage', '1'),
(165, '1278916057', '1278916057', '删除留言', 74, 'delMessage', '1'),
(166, '1279353505', '1279353505', '用户站点', 75, 'viewUserSite', '1'),
(167, '1280312584', '1280312584', '静态管理', 76, 'doCache', '1'),
(168, '', '', '页面修改', 80, 'domodify', '1'),
(169, '', '', '添加新闻', 79, 'addnews', '1'),
(170, '', '', '添加新闻', 79, 'doaddnews', '1'),
(171, '', '', '新闻管理', 81, 'newsManage', '1'),
(172, '', '', '管理新闻', 82, 'manageNews', '1'),
(173, '', '', '管理类别', 83, 'manageNewsType', '1'),
(174, '', '', '配置修改', 77, 'adminSiteSetting', '1'),
(175, '', '', '广告管理', 84, 'adminAd', '1');

DROP TABLE IF EXISTS `admin_ad`;
CREATE TABLE IF NOT EXISTS `admin_ad` (
  `autoID` int(50) NOT NULL AUTO_INCREMENT,
  `id` varchar(10) NOT NULL,
  `title` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `orders` int(12) NOT NULL DEFAULT '1',
  `status` tinyint(2) NOT NULL DEFAULT '1',
  `wide` int(10) DEFAULT '0',
  `high` int(10) DEFAULT '0',
  PRIMARY KEY (`autoID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=42 ;

INSERT INTO `admin_ad` (`autoID`, `id`, `title`, `content`, `orders`, `status`, `wide`, `high`) VALUES
(1, 'index01', '首页头部广告', '<iframe src="http://www.5w.com/data/html/tmall.htm" width="390" height="60" SCROLLING="no" FRAMEBORDER="0" style="top:0px;left:0px;"></iframe>', 1, 1, 390, 60),
(2, 'index02', '首页头部右边广告', '<a href="http://union.dangdang.com/transfer/transfer.aspx?from=P-283517&backurl=http://www.dangdang.com/"><img src="http://www.5w.com/images/dangdang10060.gif" /></a>', 2, 1, 100, 60),
(3, 'index02', '首页头部右边广告', '<a href="http://www.zhitui.com/iclk/?zoneid=109&uid=10022"><img src="http://www.5w.com/images/vancl0425.jpg" ></a>', 1, 1, 100, 60),
(4, 'index02', '首页头部右边广告', '<a href="http://www.vancl.com/WebSource/WebSource.aspx?source=taoku&url=http://www.vancl.com/"><img src="http://www.5w.com/images/vancl10060.jpg" /></a>', 3, 1, 100, 60),
(5, 'index03', '搜索右侧广告', '<a href="http://s.click.taobao.com/t_3?&p=mm_19869273_2351859_9092254&n=23&l=http%3A%2F%2Fs8.taobao.com%2Fbrowse%2F0%2Fn-g%2Cnvqxq3lbny----------------40--commend-0-1%2C2-0.htm%3Fpid%3Dmm_19869273_2351859_9092254">男根增大增粗</a>', 6, 0, 100, 25),
(6, 'index03', '搜索右侧广告', '<a href="http://tuan.5w.com/">今日团购</a>', 4, 0, 100, 25),
(9, 'index02', '首页头部右边广告', '<a href="http://www.doudou.com/reg1.php?from=5wcom&a=6"><img src="http://www.5w.com/images/doudou10060.jpg" /></a>', 4, 1, 100, 60),
(10, 'index03', '搜索右侧广告', '<a href="http://www.7808.cn/cy.shtml?site=dh?5w">1000元开店</a>', 3, 1, 100, 25),
(13, 'index04', '中间文字广告', '<a href="http://dianpu.tao123.com/?pid=mm_19869273_2351859_9092254"><font color="#539043">淘</font><font color="#3b5998">宝</font><font color="#ca9333">皇</font><font color="#3b5998">冠</font><font color="#539043">店</font></a>', 1, 1, 80, 25),
(30, 'index06', '内页广告', '<iframe src="http://www.5w.com/data/html/neiye_alimama.htm" width="128" height="75" SCROLLING="no" FRAMEBORDER="0" style="top:0px;left:0px;"></iframe>', 1, 1, 120, 60),
(15, 'index04', '中间文字广告', '<a href="http://www.sjjtk8.com/">手机追踪定位</a>', 9, 1, 80, 25),
(16, 'index04', '中间文字广告', '<a href="http://tuan.5w.com/">团购大全</a>', 2, 1, 80, 25),
(17, 'index04', '中间文字广告', '<a href="http://www.aata.at/?id=5w">免费电视棒</a>', 4, 1, 80, 25),
(41, 'index04', '中间文字广告', '<a href="http://www.hgsyb.com/?id=555">女性塑阴秘诀</a>', 5, 1, 80, 25),
(33, 'mztop', '名站首行百度', '<iframe width="70" height="19" frameborder="0" scrolling="no" style="border-style:none;border-width:0px;_margin-top:-5px;" vspace="0" hspace="0" marginwidth="0" marginheight="0" framespacing="0"  allowtransparency="true" src="http://www.wuxuewang.cn/s3.html"></iframe><em class="baidu" onmouseover="mmover(this)" onmouseout="mmout()"></em class="baidu"></em><div class="tsbox" style="display: none;"><span class="arrow">baidu</span><a href="http://zhidao.baidu.com/q?pt=5wcom">百度知道</a><a href="http://video.baidu.com/?tn=5wcom&ch=4">百度视频</a><a href="http://baike.baidu.com/?source=5w.com">百度百科</a><a href="http://hi.baidu.com">百度空间</a><a href="http://youa.baidu.com/?tn=5wcom&ctn=0&styleid=1&unionfrom=baidu&c=929">百度有啊</a></div>', 1, 1, 0, 0),
(18, 'index04', '中间文字广告', '<a href="http://www.k015.com/3/index.asp?id=1128">减肥瘦到尖叫</a>', 6, 1, 80, 25),
(19, 'index04', '中间文字广告', '<a href="http://www.kdtx888.com/">一折充值卡</a>', 7, 1, 80, 25),
(20, 'index04', '中间文字广告', '<a href="http://www.3158.cn/?site=dh5w">99个好项目</a>', 7, 0, 80, 25),
(39, 'index03', '搜索右侧广告', '<a href="http://gb.36578.com/gbook_admin/getgo.php?id=3662">2011赚钱生意</a>', 2, 1, 100, 25),
(21, 'index04', '中间文字广告', '<a href="http://www.52tata.com/?2018">成人充气娃娃</a>', 8, 1, 80, 25),
(22, 'index04', '中间文字广告', '<a href="http://cnrdn.com/rd.htm?id=1022101&r=http%3A%2F%2Fwww.lhad.com.cn%2Fzs_20.html">1年能赚100万</a>', 9, 0, 80, 25),
(23, 'index04', '中间文字广告', '<a href="http://www.viger.la/?code=5w">男根尺寸排行</a>', 3, 1, 80, 25),
(24, 'index05', '名站导航广告', '<a href="http://gb.36578.com/gbook_admin/getgo.php?id=3662" style="color:#fd5151">打工不如开店</a>', 1, 1, 123, 30),
(25, 'index05', '名站导航广告', '<a href="http://www.3158.cn/?site=dh5w" style="color:#fd5151">3158致富网</a>', 2, 1, 123, 30),
(26, 'index05', '名站导航广告', '<a href="http://www.gowolo.com/www/?jf5w" style="color:#178517">夏季减肥妙招</a>', 3, 1, 123, 30),
(27, 'index05', '名站导航广告', '<a href="http://p.yiqifa.com/c?s=cff5e66f&w=220184&c=4566&i=6222&l=0&e=c&t=http://www.vipshop.com/index.php" style="color:#178517">唯品会折扣</a>', 4, 1, 123, 30),
(28, 'index05', '名站导航广告', '<a href="http://www.7808.cn/cy.shtml?site=dh?5w" style="color:#fd5151">1000元开店</a>', 5, 1, 123, 30),
(29, 'index05', '名站导航广告', '<a href="http://gb.36589.com/gbook_admin/getgo.php?id=9356" style="color:#fd5151">2011赚钱生意</a>', 6, 1, 123, 30),
(34, 'mztop', '名站首行新浪', '<a href="http://www.sina.com.cn/">新浪</a> - <a href="http://37540.z1z8.com/click?pid=38&mid=37540&channel=1&pt=index">微博</a><em class="sina" onmouseover="mmover(this)" onmouseout="mmout()"></em><div class="tsbox" style="display: none;"><span class="arrow">sina</span><a href="http://news.sina.com.cn">新浪新闻</a><a href="http://finance.sina.com.cn">新浪财经</a><a href="http://sports.sina.com.cn">新浪体育</a><a href="http://blog.sina.com.cn">新浪博客</a><a href="http://auto.sina.com.cn">新浪汽车</a><a href="http://video.sina.com.cn">新浪宽频</a><a href="http://tech.sina.com.cn">新浪科技</a></div>', 3, 1, 0, 0),
(32, 'index06', '内页广告', '<iframe src="http://www.5w.com/data/html/neiye_google.htm" width="128" height="75" SCROLLING="no" FRAMEBORDER="0" style="top:0px;left:0px;"></iframe>', 2, 1, 120, 60),
(35, 'mztop', '名站首行淘宝', '<a href="http://www.taobao.com/go/chn/tbk_channel/onsale.php?pid=mm_19869273_2351859_9092254&eventid=101586"><font color="#ff0000">淘宝特卖</font></a><em class="taobao" onmouseover="mmover(this)" onmouseout="mmout()"></em><div class="tsbox" style="display: none;"><span class="arrow">taobao</span><a href="http://www.taobao.com/go/chn/tbk_channel/lady.php?pid=mm_19869273_2351859_9092254&eventid=101345">淘宝女装</a><a href="http://www.taobao.com/go/chn/tbk_channel/huangguan.php?pid=mm_19869273_2351859_9092254&eventid=101858">淘宝皇冠</a><a href="http://www.tmall.com/go/chn/tbk_channel/tmall_new.php?pid=mm_19869273_2351859_9092254&eventid=101334">淘宝商城</a><a href="http://www.taobao.com/go/chn/tbk_channel/jewelry.php?pid=mm_19869273_2351859_9092254&eventid=101331">淘宝鞋包</a><a href="http://www.taobao.com/go/chn/tbk_channel/baby.php?pid=mm_19869273_2351859_9092254&eventid=101326">居家玩具</a></div>', 2, 1, 0, 0),
(36, 'mztop', '名站首行搜狐', '<a href="http://www.sohu.com/">搜狐</a> - <a href="http://37540.z1z8.com/click?pid=76&mid=37540">微博</a><em class="sohu" onmouseover="mmover(this)" onmouseout="mmout()"></em><div class="tsbox" style="display: none;"><span class="arrow">sohu</span><a href="http://sports.sohu.com">搜狐体育</a><a href="http://blog.sohu.com">搜狐博客</a><a href="http://business.sohu.com">搜狐财经</a><a href="http://auto.sohu.com">搜狐汽车</a><a href="http://it.sohu.com">搜狐科技</a><a href="http://club.sohu.com">搜狐社区</a></div>', 4, 1, 0, 0),
(37, 'mztop', '名站首行网易', '<a href="http://www.163.com">网易</a> - <a href="http://email.163.com">邮箱</a><em class="netease" onmouseover="mmover(this)" onmouseout="mmout()"></em><div class="tsbox" style="display: none;"><span class="arrow">163</span><a href="http://news.163.com">网易新闻</a><a href="http://game.163.com/">网易游戏</a><a href="http://auto.163.com/">网易汽车</a><a href="http://money.163.com">网易财经</a><a href="http://blog.163.com">网易博客</a><a href="http://photo.163.com">网易相册</a><a href="http://tech.163.com">网易科技</a></div>', 6, 1, 0, 0),
(38, 'mztop', '名站首行腾讯', '<a href="http://www.qq.com/">腾讯</a> - <a href="http://www.soso.com/?unc=b400056&cid=union.s.wh">搜搜</a><em class="tencent" onmouseover="mmover(this)" onmouseout="mmout()"></em><div class="tsbox" style="display: none;"><span class="arrow">qq</span><a href="http://qzone.qq.com/">腾讯空间</a><a href="http://t.qq.com/">腾讯微博</a><a href="http://news.qq.com/">腾讯新闻</a><a href="http://finance.qq.com">腾讯财经</a><a href="http://ent.qq.com">腾讯娱乐</a><a href="http://auto.qq.com">腾讯汽车</a><a href="http://games.qq.com/">腾讯游戏</a></div>', 5, 1, 0, 0),
(40, 'index03', '搜索右侧广告', '<a href="http://mk.1819365.com/?id=55">男性补肾秘诀</a>', 1, 1, 100, 25);

DROP TABLE IF EXISTS `admin_ag`;
CREATE TABLE IF NOT EXISTS `admin_ag` (
  `agID` int(11) NOT NULL auto_increment,
  `actionStr` varchar(50) NOT NULL default '',
  `groupID` int(11) NOT NULL default '0',
  PRIMARY KEY  (`agID`),
  KEY `groupID` (`groupID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3055 ;

INSERT INTO `admin_ag` (`agID`, `actionStr`, `groupID`) VALUES
(3005, 'viewUser', 1),
(3006, 'updateUser', 1),
(3007, 'lockUser', 1),
(3008, 'delUser', 1),
(3009, 'viewAdminGroup', 1),
(3010, 'addAdminGroup', 1),
(3011, 'updateAdminGroup', 1),
(3012, 'delAdminGroup', 1),
(3013, 'viewMaster', 1),
(3014, 'addMaster', 1),
(3015, 'updateMaster', 1),
(3016, 'delMaster', 1),
(3017, 'viewAdminAction', 1),
(3018, 'addAdminAction', 1),
(3019, 'updateAdminAction', 1),
(3020, 'delAdminAction', 1),
(3021, 'viewAdminModule', 1),
(3022, 'addAdminModule', 1),
(3023, 'updateAdminModule', 1),
(3024, 'delAdminModule', 1),
(3025, 'useTools', 1),
(3026, 'updateMasterPwd', 1),
(3027, 'viewAdminLog', 1),
(3028, 'viewSite', 1),
(3029, 'addSite', 1),
(3030, 'delSite', 1),
(3031, 'updateSite', 1),
(3032, 'viewSiteType', 1),
(3033, 'addSiteType', 1),
(3034, 'delSiteType', 1),
(3035, 'updateSiteType', 1),
(3036, 'checkSite', 1),
(3037, 'viewMessage', 1),
(3038, 'delMessage', 1),
(3039, 'viewUserSite', 1),
(3040, 'doCache', 1),
(3041, 'updatemodify', 1),
(3042, 'domodify', 1),
(3043, 'addnews', 1),
(3044, 'doaddnews', 1),
(3045, 'newsManage', 1),
(3047, 'manageNews', 1),
(3048, 'updatenews', 1),
(3049, 'doupdatenews', 1),
(3050, 'deletenews', 1),
(3051, 'manageNewsType', 1),
(3052, 'addNewsType', 1),
(3053, 'adminSiteSetting', 1),
(3054, 'adminAd', 1);

DROP TABLE IF EXISTS `admin_group`;
CREATE TABLE IF NOT EXISTS `admin_group` (
  `groupID` int(11) NOT NULL auto_increment,
  `cDate` varchar(10) NOT NULL default '',
  `mDate` varchar(10) NOT NULL default '',
  `groupName` varchar(20) NOT NULL default '',
  `groupInfo` varchar(255) default NULL,
  `groupState` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`groupID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `admin_group` (`groupID`, `cDate`, `mDate`, `groupName`, `groupInfo`, `groupState`) VALUES
(1, '1', '1', '系统管理组', '系统管理组', 1);

DROP TABLE IF EXISTS `admin_log`;
CREATE TABLE IF NOT EXISTS `admin_log` (
  `logID` int(11) NOT NULL auto_increment,
  `cDate` varchar(10) NOT NULL default '',
  `masterMail` varchar(50) NOT NULL default '',
  `actStr` varchar(50) NOT NULL default '',
  `actIP` varchar(15) NOT NULL default '',
  `actPage` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`logID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

DROP TABLE IF EXISTS `admin_master`;
CREATE TABLE IF NOT EXISTS `admin_master` (
  `masterMail` varchar(50) NOT NULL default '',
  `groupID` int(10) unsigned NOT NULL,
  `cDate` varchar(10) NOT NULL default '',
  `mDate` varchar(10) NOT NULL default '',
  `masterPwd` varchar(41) NOT NULL default '',
  `masterName` varchar(20) NOT NULL default '',
  `masterPhone` varchar(12) default NULL,
  `masterLoginTimes` int(11) NOT NULL default '0',
  `masterLastIP` varchar(15) default NULL,
  `masterLastDate` varchar(10) default NULL,
  `masterState` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`masterMail`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `admin_mg`;
CREATE TABLE IF NOT EXISTS `admin_mg` (
  `mgID` int(11) NOT NULL auto_increment,
  `masterMail` varchar(50) NOT NULL default '',
  `groupID` int(11) NOT NULL default '0',
  PRIMARY KEY  (`mgID`),
  KEY `masterMail` (`masterMail`,`groupID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `apply_site`;
CREATE TABLE IF NOT EXISTS `apply_site` (
  `siteID` int(10) unsigned NOT NULL auto_increment,
  `cDate` int(10) unsigned NOT NULL,
  `siteName` varchar(100)  NOT NULL,
  `siteUrl` varchar(200)  NOT NULL,
  `stpID` int(10) unsigned NOT NULL,
  `alexa` int(10) unsigned NOT NULL default '0',
  `contact` varchar(100)  NOT NULL,
  `buildDate` varchar(50) default NULL,
  PRIMARY KEY  (`siteID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `defaultsite`;
CREATE TABLE IF NOT EXISTS `defaultsite` (
  `siteID` int(11) NOT NULL AUTO_INCREMENT,
  `siteName` varchar(250) NOT NULL,
  `siteUrl` text NOT NULL,
  `siteSort` int(11) NOT NULL DEFAULT '100',
  `stpID` int(7) NOT NULL,
  PRIMARY KEY (`siteID`),
  KEY `stpID` (`stpID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12006 ;

INSERT INTO `defaultsite` (`siteID`, `siteName`, `siteUrl`, `siteSort`, `stpID`) VALUES
(11972, '腾讯新闻', 'http://news.qq.com/', 2, 6),
(11973, '搜狐新闻', 'http://news.sohu.com/', 3, 6),
(11968, '豆豆网', 'http://www.doudou.com/', 5, 5),
(11967, '腾讯游戏', 'http://games.qq.com/', 4, 5),
(11965, '魔兽世界', 'http://www.warcraftchina.com/', 2, 5),
(11963, '乐视网', 'http://www.letv.com/', 7, 4),
(11960, '搜狐高清', 'http://tv.sohu.com/hdtv', 4, 4),
(11958, '土豆网', 'http://www.tudou.com/', 2, 4),
(11955, '团秀网', 'http://p.yiqifa.com/c?s=1db52acd&amp;w=220184&amp;c=5371&amp;i=11502&amp;l=0&amp;e=&amp;t=http://tuanxiu.cn', 6, 3),
(11954, '满座网', 'http://p.yiqifa.com/c?s=7e3584ea&amp;w=220184&amp;c=5330&amp;i=11422&amp;l=0&amp;e=&amp;t=http://www.manzuo.com/', 5, 3),
(11953, '团宝网', 'http://p.yiqifa.com/c?s=0d254847&amp;w=220184&amp;c=5278&amp;i=11082&amp;l=0&amp;e=&amp;t=http://www.groupon.cn', 4, 3),
(11952, '聚美优品', 'http://p.yiqifa.com/c?s=5cc8a44d&amp;w=220184&amp;c=5227&amp;i=10462&amp;l=0&amp;e=&amp;t=http://www.jumei.com/', 3, 3),
(11977, '央视网', 'http://www.cntv.cn/index.shtml', 7, 6),
(11976, '中国政府网', 'http://www.gov.cn/', 6, 6),
(11975, '凤凰新闻', 'http://news.ifeng.com/', 5, 6),
(11974, '网易新闻', 'http://news.163.com/', 4, 6),
(11971, '新浪新闻', 'http://news.sina.com.cn/', 1, 6),
(11970, '多玩网', 'http://www.duowan.com/', 7, 5),
(11969, '新浪游戏', 'http://game.sina.com.cn/', 6, 5),
(11966, '休闲小游戏', 'http://game.doudou.com/', 3, 5),
(11964, '17173', 'http://www.17173.com/', 1, 5),
(11962, '酷6网', 'http://www.ku6.com/', 6, 4),
(11961, '新浪视频', 'http://video.sina.com.cn/', 5, 4),
(11959, '奇艺高清', 'http://www.qiyi.com/', 3, 4),
(11957, '优酷网', 'http://www.youku.com/', 1, 4),
(11956, '团购导航', 'http://tuan.5w.com/', 7, 3),
(11950, '饭团网', 'http://p.yiqifa.com/c?s=5769343b&amp;w=220184&amp;c=4373&amp;i=9482&amp;l=0&amp;e=&amp;t=http://tuan.fantong.com/23/1/cps', 2, 3),
(11951, '拉手网', 'http://p.yiqifa.com/c?s=fa812b72&amp;w=220184&amp;c=5298&amp;i=10942&amp;l=0&amp;e=&amp;t=http://www.lashou.com/', 1, 3),
(11936, '百度', 'http://www.baidu.com/index.php?tn=5wcom_pg&amp;ch=3', 1, 1),
(11937, '&lt;font color=red&gt;搜搜&lt;/font&gt;', 'http://www.soso.com/?unc=b400056&cid=union.s.wh', 2, 1),
(11938, '搜狗', 'http://www.sogou.com/index.php?pid=sogou-site-8725fb777f25776f', 3, 1),
(11939, '谷歌', 'http://www.google.com.hk/webhp?prog=aff&amp;client=pub-9491289701756083&amp;channel=3192690012', 4, 1),
(11940, '有道', 'http://www.youdao.com/', 5, 1),
(11941, '必应', 'http://cn.bing.com/', 6, 1),
(11942, '雅虎', 'http://www.yahoo.cn/', 7, 1),
(11943, '淘宝特卖', 'http://www.taobao.com/go/chn/tbk_channel/onsale.php?pid=mm_19869273_2351859_9092254&eventid=101586', 1, 2),
(11944, '当当网', 'http://p.yiqifa.com/c?s=09594d42&w=220184&c=247&i=159&l=0&e=c&t=http://www.dangdang.com', 2, 2),
(11945, '卓越网', 'http://p.yiqifa.com/c?s=5e5ae424&w=220184&c=245&i=201&l=0&e=c&t=http://www.amazon.cn', 5, 2),
(11946, '凡客诚品', 'http://www.gouwuluo.com/zt/?5w', 4, 2),
(11947, '京东商城', 'http://p.yiqifa.com/c?s=2d61eddb&w=220184&c=4509&i=5862&l=0&e=c&t=http://www.360buy.com', 3, 2),
(11948, '梦芭萨', 'http://www.gouwuluo.com/www/?moonbasa', 6, 2),
(11949, '淘宝网', 'http://www.taobao.com/', 7, 2),
(11978, '天籁村音乐网', 'http://www.6621.com/', 1, 7),
(11979, '九天音乐', 'http://www.9sky.com/', 2, 7),
(11980, '百度MP3', 'http://mp3.baidu.com/', 3, 7),
(11981, '虾米音乐', 'http://www.xiami.com/', 4, 7),
(11982, '酷狗音乐', 'http://www.kugou.com/', 5, 7),
(11983, '音悦台', 'http://www.yinyuetai.com/', 6, 7),
(11984, '一听音乐', 'http://www.1ting.com/', 7, 7),
(11985, '163邮箱', 'http://mail.163.com/', 1, 8),
(11986, '126邮箱', 'http://mail.126.com/', 2, 8),
(11987, '139邮箱', 'http://mail.10086.cn/', 3, 8),
(11988, '雅虎邮箱', 'http://mail.cn.yahoo.com/', 4, 8),
(11989, 'QQ邮箱', 'http://mail.qq.com/', 5, 8),
(11990, '新浪邮箱', 'http://mail.sina.com.cn/', 6, 8),
(11991, 'Hotmail', 'http://www.hotmail.com/', 7, 8),
(11992, '起点', 'http://www.qidian.com/', 1, 9),
(11993, '潇湘书院', 'http://www.xxsy.net/', 2, 9),
(11994, '红袖添香', 'http://www.hongxiu.com/', 3, 9),
(11995, '纵横中文', 'http://www.zongheng.com/', 4, 9),
(11996, '小说阅读网', 'http://www.readnovel.com/', 5, 9),
(11997, '看书网', 'http://book.qukanshu.com/', 6, 9),
(11998, '言情小说吧', 'http://www.xs8.cn/', 7, 9),
(11999, 'QQ空间', 'http://qzone.qq.com/', 1, 10),
(12000, '天涯社区', 'http://www.tianya.cn/', 2, 10),
(12001, '猫扑', 'http://www.mop.com/', 3, 10),
(12002, '百度贴吧', 'http://tieba.baidu.com/', 4, 10),
(12003, '蹦蹦家园', 'http://www.bengbeng.com/', 5, 10),
(12004, '搜狐微博', 'http://37540.18bm.com/click?pid=76&amp;mid=37540&amp;pt=love', 6, 10),
(12005, '新浪微博', 'http://37540.18bm.com/click?pid=38&amp;mid=37540&amp;channel=1&amp;pt=df', 7, 10);

DROP TABLE IF EXISTS `defaultsitetype`;
CREATE TABLE IF NOT EXISTS `defaultsitetype` (
  `stpID` int(7) NOT NULL AUTO_INCREMENT,
  `stpName` varchar(20) NOT NULL,
  `stpSort` int(7) NOT NULL DEFAULT '100',
  `stpImg` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`stpID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=52 ;

INSERT INTO `defaultsitetype` (`stpID`, `stpName`, `stpSort`, `stpImg`) VALUES
(3, '团购', 3, 'z_17.gif'),
(2, '购物', 2, 'z_19.gif'),
(4, '视频', 4, 'z_9.gif'),
(5, '游戏', 5, 'z_13.gif'),
(1, '搜索', 1, 'z_0.gif'),
(6, '新闻', 6, 'z_2.gif'),
(7, '音乐', 7, 'z_4.gif'),
(8, '邮箱', 8, 'z_18.gif'),
(9, '小说', 9, 'z_7.gif'),
(10, '社区', 10, 'z_5.gif');

DROP TABLE IF EXISTS `tag_nav_img`;
CREATE TABLE IF NOT EXISTS `tag_nav_img` (
  `iid` int(11) NOT NULL AUTO_INCREMENT,
  `iname` varchar(50) DEFAULT NULL,
  `name` varchar(8) DEFAULT '',
  PRIMARY KEY (`iid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=22 ;

INSERT INTO `tag_nav_img` (`iid`, `iname`, `name`) VALUES
(1, 'z_0.gif', '默认'),
(2, 'z_1.gif', '笑话'),
(3, 'z_2.gif', '新闻'),
(4, 'z_3.gif', '金融'),
(5, 'z_4.gif', '音乐'),
(6, 'z_5.gif', '社区'),
(7, 'z_6.gif', '摄影'),
(8, 'z_7.gif', '小说'),
(9, 'z_8.gif', '美食'),
(10, 'z_9.gif', '视频'),
(11, 'z_10.gif', '聊天'),
(12, 'z_11.gif', '交友'),
(13, 'z_12.gif', '收藏'),
(14, 'z_13.gif', '游戏'),
(15, 'z_14.gif', '天气'),
(16, 'z_15.gif', '艺术'),
(17, 'z_16.gif', '技术'),
(18, 'z_17.gif', '团购'),
(19, 'z_18.gif', '邮箱'),
(20, 'z_19.gif', '购物'),
(21, 'z_20.gif', '搜索');

DROP TABLE IF EXISTS `tag_site_nav`;
CREATE TABLE IF NOT EXISTS `tag_site_nav` (
  `navID` int(10) NOT NULL AUTO_INCREMENT,
  `userID` int(10) NOT NULL,
  `navName` varchar(20) NOT NULL,
  `cDate` int(10) NOT NULL DEFAULT '0',
  `navSort` int(4) NOT NULL DEFAULT '100',
  `navImg` varchar(50) DEFAULT 'z_0.gif',
  PRIMARY KEY (`navID`),
  KEY `userID` (`userID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12220 ;

DROP TABLE IF EXISTS `members`;
CREATE TABLE IF NOT EXISTS `members` (
  `userID` int(10) unsigned NOT NULL auto_increment,
  `userMail` varchar(100) default NULL,
  `userName` varchar(100) NOT NULL,
  `userPwd` varchar(100) NOT NULL,
  `userLoginTimes` int(10) unsigned NOT NULL default '1',
  `userLastIP` varchar(15) NOT NULL,
  `userStatus` tinyint(1) unsigned NOT NULL,
  `userLastDate` int(10) unsigned NOT NULL,
  `userRegDate` int(10) unsigned NOT NULL,
  `userRegIP` varchar(15) NOT NULL,
  `from` varchar(10) NOT NULL,
  `domain` varchar(25) NOT NULL,
  `setdomain` tinyint default 0,
  `jifen` int default 0,
  `freezen` int default 0,
  `used` int default 0,
  `dstatus` tinyint default 0,
  PRIMARY KEY  (`userID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8186 ;

DROP TABLE IF EXISTS `member_setting`;
CREATE TABLE IF NOT EXISTS `member_setting` (
  `userID` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL COMMENT '首页自定义标题',
  `search` varchar(50) NOT NULL default '1' COMMENT '1百度。2搜狗，3谷歌，4淘宝',
  PRIMARY KEY  (`userID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户个性设置表';

DROP TABLE IF EXISTS `message`;
CREATE TABLE IF NOT EXISTS `message` (
  `mid` int(10) unsigned NOT NULL auto_increment,
  `type` tinyint(1) NOT NULL default '4',
  `title` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `contact` varchar(50) NOT NULL,
  `createDate` int(10) unsigned NOT NULL DEFAULT '0',
  `reply` varchar(255) default NULL,
  `urlfrom` varchar(120) NOT NULL,
  `urluser` varchar(50) default NULL,
  PRIMARY KEY  (`mid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

DROP TABLE IF EXISTS `site_setting`;
CREATE TABLE IF NOT EXISTS `site_setting` (
  `id` tinyint(1) unsigned NOT NULL AUTO_INCREMENT,
  `logo` varchar(255) DEFAULT NULL,
  `siteName` varchar(255) DEFAULT NULL,
  `siteDomain` varchar(50) DEFAULT NULL,
  `logoTitle` varchar(255) DEFAULT NULL,
  `favoriteName` varchar(255) DEFAULT NULL,
  `adminEmail` varchar(255) DEFAULT NULL,
  `cacheLifeTime` int(10) unsigned NOT NULL DEFAULT '3600',
  `indexKeywords` varchar(255) DEFAULT NULL,
  `indexDescription` varchar(255) DEFAULT NULL,
  `indexTitle` varchar(255) DEFAULT NULL,
  `commonTitle` varchar(255) DEFAULT NULL,
  `commonKeywords` varchar(255) DEFAULT NULL,
  `commonDescription` varchar(255) DEFAULT NULL,
  `applyTitle` varchar(255) DEFAULT NULL,
  `applyKeywords` varchar(255) DEFAULT NULL,
  `applyDescription` varchar(255) DEFAULT NULL,
  `countCode` text,
  `icp` varchar(255) DEFAULT NULL,
  `icpurl` varchar(255) DEFAULT NULL,
  `htmlpath` varchar(255) DEFAULT NULL,
  `theme` varchar(255) DEFAULT NULL,
  `version` varchar(255) DEFAULT NULL,
  `usersite` tinyint(4) DEFAULT '1',
  `mail_server` varchar(30) DEFAULT NULL,
  `mail_port` smallint(6) DEFAULT '25',
  `mail_user` varchar(30) DEFAULT NULL,
  `mail_password` varchar(30) DEFAULT NULL,
  `mail_nick` varchar(30) DEFAULT '5w.com',
  `usecache` tinyint(4) DEFAULT '1',
  `sptime` int(11) DEFAULT '0',
  `ver` int(8) NOT NULL DEFAULT '0',
  `misver` int(8) NOT NULL DEFAULT '0',
  `dataver` int(8) NOT NULL DEFAULT '0',
  `misdataver` int(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `site_setting` (`id`, `logo`, `siteName`, `siteDomain`, `logoTitle`, `favoriteName`, `adminEmail`, `cacheLifeTime`, `indexKeywords`, `indexDescription`, `indexTitle`, `commonTitle`, `commonKeywords`, `commonDescription`, `applyTitle`, `applyKeywords`, `applyDescription`, `countCode`, `icp`, `icpurl`, `htmlpath`, `theme`, `version`, `usersite`, `mail_server`, `mail_port`, `mail_user`, `mail_password`, `mail_nick`, `usecache`, `sptime`, `ver`, `misver`, `dataver`, `misdataver`) VALUES
(1, 'static/images/logo.gif', '导航网大全', 'www.5w.com', '网址导航大全|自定义网址导航|网址之家|5w个性导航', '5w网址导航', 'admin@5w.com', 86400, '网址导航，上网导航，知名网址导航，网址大全，购物网址大全，手机网站大全', '5w.com网址导航收集互联网的知名网站地址，及时更新，提供网络站点导航服务，包括知名站点导航，知名站点网址大全，购物网址大全,手机网址大全，汽车网址大全，动漫网址大全，交友网址大全等。上网导航从5w.com开始。', '网址导航_网址之家_网址大全_我的网址导航_5w.com', '网址导航_网址之家_网址大全_我的网网址导航', '网址大全,上网导航,网址,网址导航,网址之家', '我的网网址导航大全是一家最全的网址之家，提供新闻,音乐,娱乐,图片,小游戏,社区,通讯薄,博客,天气预', '网站收录_网址导航站收录_新站提交_网址收录大全_我的网网址导航', '网站收录查询_免费收录网站_新站提交收录', '我的网网址导航站新站收录大全，为广大站长提供新站提交收录，友情链接互换，以及网站收录入口，免费收录网站，网站收录口提交等', '<div style="display:none"><script language="javascript" type="text/javascript" src="http://js.users.51.la/4293455.js"></script></div>', '蜀ICP备06005947号-1', 'http://www.miibeian.gov.cn/', 'html/', 'default/', '8.0', 1, NULL, 25, NULL, NULL, '5w.com', 1, 0, 20110815, 20110815, 20110515, 20110515);

DROP TABLE IF EXISTS `tag_site_url`;
CREATE TABLE IF NOT EXISTS `tag_site_url` (
  `siteID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `siteName` varchar(100) NOT NULL,
  `siteUrl` text NOT NULL,
  `usedate` int(10) DEFAULT NULL,
  `userID` int(11) DEFAULT NULL,
  `siteSort` int(11) DEFAULT '100',
  `navID` int(11) NOT NULL,
  PRIMARY KEY (`siteID`),
  KEY `userID` (`userID`),
  KEY `navID` (`navID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `templates`;
CREATE TABLE IF NOT EXISTS `templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `listorder` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='模板表' AUTO_INCREMENT=10 ;

INSERT INTO `templates` (`id`, `name`, `url`, `listorder`) VALUES
(1, '购物', 'gouwu.tpl', 1),
(2, '彩票', 'caipiao.tpl', 2),
(4, '游戏', 'game.tpl', 3),
(5, '小说', 'xiaoshuo.tpl', 4),
(6, '视频', 'shipin.tpl', 5);

DROP TABLE IF EXISTS `site`;
CREATE TABLE IF NOT EXISTS `site` (
  `siteID` int(11) NOT NULL AUTO_INCREMENT,
  `siteCreateDate` char(10) NOT NULL DEFAULT '0',
  `siteName` varchar(250) NOT NULL,
  `siteUrl` text NOT NULL,
  `siteProvince` int(4) DEFAULT '0',
  `siteCity` int(4) DEFAULT '0',
  `siteTown` int(4) DEFAULT '0',
  `stpID` int(11) NOT NULL,
  `siteFamous` tinyint(1) NOT NULL DEFAULT '0',
  `siteStatus` tinyint(1) NOT NULL DEFAULT '1',
  `cDate` int(10) unsigned NOT NULL DEFAULT '0',
  `siteDefine` varchar(200) DEFAULT NULL,
  `siteSort` int(11) NOT NULL DEFAULT '100',
  `siteColor` varchar(7) NOT NULL DEFAULT '',
  `dsiteColor` varchar(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`siteID`),
  KEY `stpID` (`stpID`),
  KEY `siteFamous` (`siteFamous`),
  KEY `siteName` (`siteName`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='网址' AUTO_INCREMENT=12878 ;

INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(1, '1279617741', '拍拍网', 'http://www.paipai.com/', 0, 0, 0, 1001, 0, 1, 1289664393, NULL, 6, '', ''),
(2, '1279617741', '淘宝网', 'http://www.taobao.com/', 0, 0, 0, 1001, 0, 1, 1301384276, NULL, 11, '', ''),
(82, '1289664439', '百度有啊', 'http://youa.baidu.com/', 0, 0, 0, 1001, 0, 1, 1289664439, NULL, 9, '', ''),
(83, '1289664532', '淘宝商城', 'http://pindao.huoban.taobao.com/tms/channel/channelmall.htm?pid=mm_19869273_2351859_9092254&eventid=101334', 0, 0, 0, 1001, 0, 1, 1298269281, NULL, 10, '', ''),
(4, '1279617741', '淘宝特卖', 'http://www.taobao.com/go/chn/tbk_channel/onsale.php?pid=mm_19869273_2351859_9092254&eventid=101586', 0, 0, 0, 1001, 0, 1, 1303799857, NULL, 1, '#FF0000', ''),
(5, '1279617741', '卓越网', 'http://www.gouwuluo.com/www/?joyo5w', 0, 0, 0, 1001, 0, 1, 1303222154, NULL, 5, '', ''),
(88, '1289664814', '东方cj', 'http://p.yiqifa.com/c?s=bce3eb92&w=220184&c=360&i=8382&l=0&e=c&t=/event_main.jsp', 0, 0, 0, 1002, 0, 1, 1295921899, NULL, 11, '', ''),
(89, '1289664816', '诺基亚官方网店', 'http://www.shop.nokia.com.cn/', 0, 0, 0, 1002, 0, 1, 1289664871, NULL, 12, '', ''),
(81, '1289664335', '银泰网', 'http://p.yiqifa.com/c?s=d3c44142&w=220184&c=5331&i=11202&l=0&e=&t=http://www.yintai.com/', 0, 0, 0, 1001, 0, 1, 1298272034, NULL, 12, '', ''),
(79, '1289664229', '京东商城', 'http://www.gouwuluo.com/www/?360buy5w', 0, 0, 0, 1001, 0, 1, 1303287281, NULL, 3, '', ''),
(8220, '1289887014', '淘酷女装', 'http://www.taoku.com/', 0, 0, 0, 1062, 0, 1, 1289887014, NULL, 21, '', ''),
(90, '1289664970', '玛萨玛索男装', 'http://p.yiqifa.com/c?s=791d7e5e&w=220184&c=900&i=1682&l=0&e=c&t=http://www.masamaso.com', 0, 0, 0, 1003, 0, 1, 1298456674, NULL, 1, '', ''),
(91, '1289664996', '时尚起义', 'http://www.shishangqiyi.com/', 0, 0, 0, 1003, 0, 1, 1289664996, NULL, 2, '', ''),
(92, '1289665025', 'D1优尚网', 'http://p.yiqifa.com/c?s=7ca701c2&amp;w=220184&amp;c=4599&amp;i=6283&amp;l=0&amp;e=c&amp;t=http://www.d1.com.cn/', 0, 0, 0, 1003, 0, 1, 1294736327, NULL, 3, '', ''),
(93, '1289665050', '乐淘网上鞋城', 'http://p.yiqifa.com/c?s=b8d38eea&w=220184&c=5069&i=9202&l=0&e=c&t=http://www.letao.com', 0, 0, 0, 1003, 0, 1, 1294736327, NULL, 4, '', ''),
(94, '1289665080', '好乐买品牌鞋城', 'http://www.okaybuy.com.cn/', 0, 0, 0, 1003, 0, 1, 1289665080, NULL, 5, '', ''),
(95, '1289665119', '凡客诚品服饰', 'http://www.gouwuluo.com/zt/?5w', 0, 0, 0, 1003, 0, 1, 1289665119, NULL, 6, '', ''),
(12699, '1300088096', '图片网', 'http://www.tupian.com/', 0, 0, 0, 2028, 0, 1, 1300088096, NULL, 14, '', ''),
(21, '1279617741', '当当网', 'http://www.gouwuluo.com/www/?dd5w', 0, 0, 0, 1001, 0, 1, 1303222141, NULL, 2, '', ''),
(12867, '1303443800', '火影忍者', 'http://naruto.xxdm.com/', 0, 0, 0, 2030, 0, 1, 1303443800, NULL, 9, '', ''),
(86, '1289664738', '库巴购物网', 'http://p.yiqifa.com/c?s=d03a960b&amp;w=216662&amp;c=3461&amp;i=2462&amp;l=0&amp;e=&amp;t=http://www.coo8.com', 0, 0, 0, 1002, 0, 1, 1294736305, NULL, 9, '', ''),
(87, '1289664759', '迪信通', 'http://www.dixintong.com/', 0, 0, 0, 1002, 0, 1, 1289664871, NULL, 10, '', ''),
(80, '1289664312', '易迅商城', 'http://p.yiqifa.com/c?s=c9030f36&w=220184&c=4330&i=4984&l=0&e=c&t=http://www.icson.com/Items/Default.aspx?ls=eqifa', 0, 0, 0, 1001, 0, 1, 1298269768, NULL, 8, '', ''),
(25, '1279617741', '孔夫子旧书网', 'http://www.kongfz.com', 1, 0, 0, 1004, 0, 1, 0, NULL, 8, '', ''),
(26, '1279617741', '互动出版网', 'http://p.yiqifa.com/c?s=226bc15f&w=220184&c=821&i=506&l=0&e=&t=http://www.china-pub.com', 0, 0, 0, 1004, 0, 1, 1295922904, NULL, 6, '', ''),
(27, '1279617741', '中国音像商务网', 'http://www.cnave.com/', 0, 0, 0, 1004, 0, 1, 1291971448, NULL, 9, '', ''),
(28, '1279617741', '蔚蓝书店', 'http://click.linktech.cn/?m=welan&amp;a=A100096524&amp;l=99999&amp;l_cd1=0&amp;l_cd2=1&amp;u_id=&amp;tu=http://www.wl.cn', 0, 0, 0, 1004, 0, 1, 1294736356, NULL, 7, '', ''),
(105, '1289665798', '中粮我买购物网', 'http://p.yiqifa.com/c?s=28bbafc8&amp;w=216662&amp;c=4102&amp;i=3542&amp;l=0&amp;e=&amp;t=http://www.womai.com', 0, 0, 0, 1006, 0, 1, 1294736398, NULL, 3, '', ''),
(106, '1289665809', '快乐购', 'http://p.yiqifa.com/c?s=77e4f9f1&w=220184&c=4415&i=5402&l=0&e=c&t=http://www.happigo.com', 0, 0, 0, 1006, 0, 1, 1295923687, NULL, 4, '', ''),
(30, '1279617741', '16388音像网', 'http://www.16388.com', 1, 0, 0, 1004, 0, 1, 1291971453, NULL, 10, '', ''),
(6871, '1289792118', '三亚市', 'http://www.sanya.gov.cn/', 0, 0, 0, 4201, 0, 1, 1298456674, NULL, 1, '', ''),
(103, '1289665771', '橡果国际购物', 'http://p.yiqifa.com/c?s=093355cb&w=216662&c=1680&i=1243&l=0&e=&t=http://www.chinadrtv.com', 0, 0, 0, 1006, 0, 1, 1298456674, NULL, 1, '', ''),
(104, '1289665781', '1号店', 'http://p.yiqifa.com/c?s=7addb666&amp;w=220184&amp;c=139&amp;i=802&amp;l=0&amp;e=&amp;t=http://www.yihaodian.com/product/index.do', 0, 0, 0, 1006, 0, 1, 1294736394, NULL, 2, '', ''),
(32, '1279617741', '99网上书城', 'http://p.yiqifa.com/c?s=9fa7f15d&w=220184&c=262&i=152&l=0&e=c&t=http://www.99read.com', 0, 0, 0, 1004, 0, 1, 1295922581, NULL, 3, '', ''),
(33, '1279617741', '新华书店', 'http://p.yiqifa.com/c?s=caeb6778&w=220184&c=299&i=188&l=0&e=c&t=http://www.xinhuabookstore.com', 0, 0, 0, 1004, 0, 1, 1294736353, NULL, 4, '', ''),
(42, '1279617741', '支付宝', 'http://www.alipay.com/', 0, 0, 0, 1034, 0, 1, 1298456674, NULL, 1, '', ''),
(41, '1279617741', '快钱', 'http://www.99bill.com/', 0, 0, 0, 1034, 0, 1, 0, NULL, 5, '', ''),
(40, '1279617741', '移动支付', 'http://www.umpay.com/', 0, 0, 0, 1034, 0, 1, 0, NULL, 10, '', ''),
(39, '1279617741', '云网支付', 'http://www.cncard.net/', 0, 0, 0, 1034, 0, 1, 0, NULL, 4, '', ''),
(38, '1279617741', '银联支付', 'http://www.chinapay.com/', 0, 0, 0, 1034, 0, 1, 0, NULL, 8, '', ''),
(37, '1279617741', '首信易支付', 'http://www.beijing.com.cn/', 0, 0, 0, 1034, 0, 1, 0, NULL, 7, '', ''),
(36, '1279617741', '易宝支付', 'http://www.yeepay.com/', 0, 0, 0, 1034, 0, 1, 0, NULL, 9, '', ''),
(35, '1279617741', '贝宝', 'http://www.paypal.com/cn', 0, 0, 0, 1034, 0, 1, 0, NULL, 2, '', ''),
(34, '1279617741', '财付通', 'http://www.tenpay.com/', 0, 0, 0, 1034, 0, 1, 0, NULL, 3, '', ''),
(44, '1279617741', 'YY比较购物搜索', 'http://www.askyaya.com', 0, 0, 0, 1007, 0, 1, 0, NULL, 3, '', ''),
(45, '1279617741', '肯德基电子优惠券', 'http://www.kfc.com.cn/kfccda/', 0, 0, 0, 1007, 0, 1, 0, NULL, 13, '', ''),
(46, '1279617741', '查价网', 'http://www.chajia.com/', 0, 0, 0, 1007, 0, 1, 0, NULL, 4, '', ''),
(47, '1279617741', '大拿网', 'http://www.danawa.com.cn/', 0, 0, 0, 1007, 0, 1, 0, NULL, 7, '', ''),
(48, '1279617741', '试试网-免费试用', 'http://www.trybb.com/', 0, 0, 0, 1007, 0, 1, 0, NULL, 8, '', ''),
(49, '1279617741', '必胜客电子优惠券', 'http://kfc.xixik.com/?bsk', 0, 0, 0, 1007, 0, 1, 0, NULL, 15, '', ''),
(50, '1279617741', '精品购物指南', 'http://www.sg.com.cn/', 0, 0, 0, 1007, 0, 1, 1298456674, NULL, 1, '', ''),
(51, '1279617741', '易购网上购物论坛', 'http://bbs.egou.com/', 0, 0, 0, 1007, 0, 1, 0, NULL, 11, '', ''),
(52, '1279617741', '酷鹏网优惠券', 'http://www.icoupon.com.cn/', 0, 0, 0, 1007, 0, 1, 1294720179, NULL, 21, '', ''),
(53, '1279617741', '麦当劳电子优惠券', 'http://www.mcdonalds.com.cn/coupon/cp.asp', 0, 0, 0, 1007, 0, 1, 0, NULL, 14, '', ''),
(54, '1279617741', '中国折', 'http://www.zhe.cn/', 0, 0, 0, 1007, 0, 1, 1294720163, NULL, 22, '', ''),
(55, '1279617741', '就爱点评网', 'http://www.92dp.com', 0, 0, 0, 1007, 0, 1, 0, NULL, 6, '', ''),
(56, '1279617741', '特价王购物搜索', 'http://www.tejiawang.com', 0, 0, 0, 1007, 0, 1, 0, NULL, 5, '', ''),
(57, '1279617741', '爱比网', 'http://www.aibiwang.com/', 0, 0, 0, 1007, 0, 1, 0, NULL, 9, '', ''),
(11986, '1290415244', '71755小游戏', 'http://www.71755.com', 0, 0, 0, 0, 0, 1, 1292070059, NULL, 11, '', ''),
(60, '1289544178', '团购大全', 'http://tuan.5w.com/', 0, 0, 0, 1007, 0, 1, 1298266042, NULL, 16, '#178517', ''),
(61, '1279617741', '北斗手机网', 'http://www.139shop.com/', 0, 0, 0, 1002, 0, 1, 1289664871, NULL, 3, '', ''),
(62, '1279617741', '骏网', 'http://www.jcard.cn/', 0, 0, 0, 1002, 0, 1, 1289664871, NULL, 5, '', ''),
(85, '1289664713', '锐意网', 'http://www.rayi.cn/', 0, 0, 0, 1002, 0, 1, 1289664871, NULL, 8, '', ''),
(64, '1279617741', '新蛋网', 'http://p.yiqifa.com/c?s=49467fe8&w=220184&c=280&i=240&l=0&e=&t=http://www.newegg.com.cn', 0, 0, 0, 1002, 0, 1, 1298456674, NULL, 1, '', ''),
(84, '1289664687', '绿森数码', 'http://p.yiqifa.com/c?s=4b8e83d4&amp;w=216662&amp;c=4744&amp;i=7162&amp;l=0&amp;e=&amp;t=http://www.lusen.cn', 0, 0, 0, 1002, 0, 1, 1294736295, NULL, 2, '', ''),
(65, '1279617741', '阿拉丁科技-智能手机', 'http://www.aladin.com.cn/', 0, 0, 0, 1002, 0, 1, 1289664871, NULL, 13, '', ''),
(66, '1279617741', '国美电器', 'http://www.gome.com.cn/', 1, 0, 0, 1002, 0, 1, 1289664871, NULL, 7, '', ''),
(67, '1279617741', '大中电器', 'http://www.dazhongdianqi.com.cn/', 0, 0, 0, 1002, 0, 1, 1289664871, NULL, 4, '', ''),
(68, '1279617741', '苏宁电器', 'http://p.yiqifa.com/c?s=e663f9ac&w=220184&c=4459&i=5662&l=0&e=c&t=http://www.suning.cn/webapp/wcs/stores/servlet/TopCategoriesDisplayView?storeId=10052&catalogId=10051', 0, 0, 0, 1002, 0, 1, 1294736300, NULL, 6, '', ''),
(69, '1279617741', '乐淘', 'http://p.yiqifa.com/c?s=b8d38eea&w=220184&c=5069&i=9202&l=0&e=c&t=http://www.letao.com', 0, 0, 0, 1005, 0, 1, 1294736382, NULL, 10, '', ''),
(70, '1279617741', 'Face7中国', 'http://www.face7.com/', 0, 0, 0, 1005, 0, 1, 0, NULL, 6, '', ''),
(71, '1279617741', 'NO5时尚广场', 'http://p.yiqifa.com/c?s=f56727e6&w=220184&c=315&i=224&l=0&e=c&t=http://www.no5.com.cn', 0, 0, 0, 1005, 0, 1, 1298456674, NULL, 1, '', ''),
(72, '1279617741', '梦露时尚', 'http://p.yiqifa.com/c?s=ba85582c&amp;w=216662&amp;c=267&amp;i=135&amp;l=0&amp;e=$u&amp;t=http://www.menglu.com/index.html', 0, 0, 0, 1005, 0, 1, 1294736371, NULL, 4, '', ''),
(73, '1279617741', '麦考林', 'http://p.yiqifa.com/c?s=f999541a&w=220184&c=4275&i=4662&l=0&e=&t=http://www.m18.com', 0, 0, 0, 1005, 0, 1, 1294736367, NULL, 2, '', ''),
(74, '1279617741', '果皮网', 'http://www.guopi.com/', 0, 0, 0, 1005, 0, 1, 0, NULL, 3, '', ''),
(75, '1279617741', '希琪手工坊', 'http://www.xiqifang.com/', 0, 0, 0, 1005, 0, 1, 0, NULL, 9, '', ''),
(76, '1279617741', '红孩子母婴', 'http://p.yiqifa.com/c?s=df6f9994&w=220184&c=249&i=148&l=0&e=c&t=http://www.redbaby.com.cn', 0, 0, 0, 1005, 0, 1, 1294736375, NULL, 7, '', ''),
(77, '1279617741', '乐友儿童用品', 'http://p.yiqifa.com/c?s=6b9ccf8a&amp;w=216662&amp;c=252&amp;i=284&amp;l=0&amp;e=&amp;t=http://www.leyou.com', 0, 0, 0, 1005, 0, 1, 1294736379, NULL, 8, '', ''),
(78, '1279617741', '八佰拜', 'http://www.800buy.com.cn/', 0, 0, 0, 1005, 0, 1, 0, NULL, 5, '', ''),
(96, '1289665188', 'V 名品折扣区', 'http://p.yiqifa.com/c?s=61e44e69&amp;w=216662&amp;c=4753&amp;i=7082&amp;l=0&amp;e=&amp;t=http://www.vjia.com/', 0, 0, 0, 1003, 0, 1, 1294736327, NULL, 7, '', ''),
(97, '1289665284', '上品折扣特卖会', 'http://p.yiqifa.com/c?s=d2943801&w=220184&c=5302&i=11002&l=0&e=c&t=http://www.shopin.net', 0, 0, 0, 1003, 0, 1, 1294736346, NULL, 14, '', ''),
(98, '1289665320', '名鞋库折扣鞋城', 'http://p.yiqifa.com/c?s=636c8095&w=220184&c=4965&i=8362&l=0&e=c&t=http://www.s.cn', 0, 0, 0, 1003, 0, 1, 1294736327, NULL, 9, '', ''),
(99, '1289665361', '唯品会名牌折扣', 'http://p.yiqifa.com/c?s=cff5e66f&amp;w=220184&amp;c=4566&amp;i=6222&amp;l=0&amp;e=c&amp;t=http://www.vipshop.com/index.php', 0, 0, 0, 1003, 0, 1, 1294736332, NULL, 10, '', ''),
(100, '1289665363', '欧莱诺服饰', 'http://p.yiqifa.com/c?s=abef79f9&w=220184&c=275&i=172&l=0&e=c&t=http://www.olomo.com', 0, 0, 0, 1003, 0, 1, 1294736336, NULL, 11, '', ''),
(101, '1289665398', '奕尚网名牌服饰', 'http://www.sasacity.com/', 0, 0, 0, 1003, 0, 1, 1289665398, NULL, 12, '', ''),
(102, '1289665454', '银泰官方购物网', 'http://p.yiqifa.com/c?s=d3c44142&w=220184&c=5331&i=11202&l=0&e=&t=http://www.yintai.com/', 0, 0, 0, 1003, 0, 1, 1294736342, NULL, 13, '', ''),
(107, '1289665833', '趣玩创意百货', 'http://p.yiqifa.com/c?s=39080104&w=220184&c=1800&i=1362&l=0&e=c&t=http://www.quwan.com', 0, 0, 0, 1006, 0, 1, 1289665833, NULL, 5, '', ''),
(108, '1289665844', '乐酷天', 'http://www.rakuten.com.cn/', 0, 0, 0, 1006, 0, 1, 1289665844, NULL, 6, '', ''),
(109, '1289665855', '2688网店', 'http://www.2688.com/', 0, 0, 0, 1006, 0, 1, 1289665855, NULL, 7, '', ''),
(110, '1289665978', '拉手网', 'http://p.yiqifa.com/c?s=fa812b72&w=220184&c=5298&i=10942&l=0&e=&t=http://www.lashou.com', 0, 0, 0, 1008, 0, 1, 1298456674, NULL, 1, '', ''),
(111, '1289666006', '美团网', 'http://www.meituan.com/', 0, 0, 0, 1008, 0, 1, 1289666006, NULL, 2, '', ''),
(114, '1289666079', '团宝网', 'http://p.yiqifa.com/c?s=0d254847&w=220184&c=5278&i=11082&l=0&e=&t=http://www.groupon.cn', 0, 0, 0, 1008, 0, 1, 1295932432, NULL, 5, '', ''),
(115, '1289666102', '24卷', 'http://p.yiqifa.com/c?s=c684724b&amp;w=216662&amp;c=4755&amp;i=7142&amp;l=0&amp;e=&amp;t=http://www.24quan.com/', 0, 0, 0, 1008, 0, 1, 1294736459, NULL, 9, '', ''),
(220, '1279617741', '178彩票网', 'http://www.178cpw.com', 0, 0, 0, 1010, 0, 1, 1297841225, NULL, 34, '', ''),
(221, '1289542606', '中国天气网', 'http://www.weather.com.cn/', 0, 0, 0, 1021, 0, 1, 1298456674, NULL, 1, '', ''),
(219, '1279617741', '预测推荐', 'http://infor.cpdyj.com/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1298011875, NULL, 33, '', ''),
(217, '1279617741', 'Tom-体育博彩', 'http://sports.tom.com/caipiao.html', 0, 0, 0, 1010, 0, 1, 0, NULL, 31, '', ''),
(218, '1279617741', '七乐彩', 'http://qlc.cpdyj.com/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1298011875, NULL, 32, '', ''),
(216, '1279617741', '中国体彩网-足彩胜负', 'http://www.lottery.gov.cn/winlose/', 0, 0, 0, 1010, 0, 1, 0, NULL, 30, '', ''),
(215, '1279617741', '雅虎足彩', 'http://sports.cn.yahoo.com/zucai/', 0, 0, 0, 1010, 0, 1, 0, NULL, 29, '', ''),
(214, '1279617741', '搜狐足彩', 'http://sports.sohu.com/zuqiucaipiao.shtml', 0, 0, 0, 1010, 0, 1, 0, NULL, 28, '', ''),
(212, '1279617741', '体彩开奖查询', 'http://tool.115.com/?ct=live&ac=caipiao', 0, 0, 0, 1010, 0, 1, 0, NULL, 26, '', ''),
(210, '1279617741', '排列5', 'http://p5.cpdyj.com/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1298011875, NULL, 24, '', ''),
(211, '1279617741', '七星彩', 'http://qxc.cpdyj.com/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1298011875, NULL, 25, '', ''),
(209, '1279617741', '排列3', 'http://p3.cpdyj.com/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1301286947, NULL, 35, '', ''),
(208, '1279617741', '22选5', 'http://22x5.cpdyj.com/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1298011875, NULL, 22, '', ''),
(206, '1279617741', '福彩开奖查询', 'http://kj.cpdyj.com/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1302664122, NULL, 36, '', ''),
(207, '1279617741', '足球单场', 'http://zc.cpdyj.com/zqdc/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1298011770, NULL, 21, '', ''),
(205, '1279617741', '胜负彩', 'http://zc.cpdyj.com/sfc/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1302664156, NULL, 21, '', ''),
(204, '1279617741', '时时彩', 'http://caipiao.cpdyj.com/ssc_cq/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1298011630, NULL, 4, '', ''),
(203, '1279617741', '福彩3D-投注', 'http://caipiao.cpdyj.com/ssq/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1302664154, NULL, 21, '', ''),
(202, '1279617741', '11选5', 'http://caipiao.cpdyj.com/dlc_jx/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1298011480, NULL, 17, '', ''),
(201, '1279617741', '双色球-投注', 'http://caipiao.cpdyj.com/ssq/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1298011273, NULL, 16, '', ''),
(200, '1279617741', '彩票走势图', 'http://zst.cpdyj.com/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1302657207, NULL, 15, '', ''),
(199, '1279617741', '超级大乐透', 'http://dlt.cpdyj.com/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1301488292, NULL, 13, '', ''),
(198, '1279617741', '网上买彩票', 'http://www.cpdyj.com/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1301450714, NULL, 25, '', ''),
(197, '1279617741', '爱彩票网', 'http://www.2caipiao.com/lott/index.jhtml', 0, 0, 0, 1010, 0, 1, 1301450711, NULL, 12, '', ''),
(195, '1279617741', '500WAN彩票', 'http://www.500wan.com', 0, 0, 0, 1010, 0, 1, 1301450710, NULL, 11, '', ''),
(194, '1279617741', '星彩网', 'http://www.starlott.com/', 0, 0, 0, 1010, 0, 1, 0, NULL, 9, '', ''),
(193, '1279617741', '羊彩网', 'http://www.ycw8.com/', 0, 0, 0, 1010, 0, 1, 0, NULL, 8, '', ''),
(192, '1279617741', '新浪彩票', 'http://sports.sina.com.cn/lottery/', 0, 0, 0, 1010, 0, 1, 0, NULL, 7, '', ''),
(190, '1279617741', '彩票大赢家', 'http://www.cpdyj.com/?regfrom=w5wcom', 0, 0, 0, 1010, 0, 1, 1298011221, NULL, 5, '#FF0000', ''),
(188, '1279617741', '中华彩票网', 'http://www.china-lottery.net/', 0, 0, 0, 1010, 0, 1, 0, NULL, 3, '', ''),
(187, '1279617741', '中国体彩网', 'http://www.lottery.gov.cn/', 0, 0, 0, 1010, 0, 1, 0, NULL, 2, '', ''),
(222, '1289542606', '天气在线', 'http://www.t7online.com/', 0, 0, 0, 1021, 0, 1, 0, NULL, 2, '', ''),
(223, '1289542606', '天气预报-新浪网', 'http://weather.news.sina.com.cn/', 0, 0, 0, 1021, 0, 1, 0, NULL, 3, '', ''),
(224, '1289542606', '中央气象台', 'http://www.nmc.gov.cn/', 0, 0, 0, 1021, 0, 1, 0, NULL, 4, '', ''),
(225, '1289542606', '世界天气预报', 'http://www.worldweather.cn/', 0, 0, 0, 1021, 0, 1, 1304680695, NULL, 6, '', ''),
(226, '1289542606', '中国气象局', 'http://www.cma.gov.cn/', 0, 0, 0, 1021, 0, 1, 0, NULL, 6, '', ''),
(227, '1289542606', '中国地震台网', 'http://www.csndmc.ac.cn/', 0, 0, 0, 1021, 0, 1, 0, NULL, 7, '', ''),
(228, '1289542606', '中国地震局', 'http://www.cea.gov.cn/', 0, 0, 0, 1021, 0, 1, 0, NULL, 8, '', ''),
(229, '1289542606', '中国台风网', 'http://www.typhoon.gov.cn/', 0, 0, 0, 1021, 0, 1, 0, NULL, 9, '', ''),
(230, '1289667313', '天气查询', 'http://tianqi.5w.com/', 0, 0, 0, 1021, 0, 1, 1289667313, NULL, 10, '', ''),
(231, '1279617741', '东方财富网', 'http://www.eastmoney.com/', 0, 0, 0, 1022, 0, 1, 1302748280, NULL, 2, '', ''),
(232, '1279617741', '新浪财经', 'http://finance.sina.com.cn', 0, 0, 0, 1022, 0, 1, 0, NULL, 2, '', ''),
(233, '1279617741', '搜狐财经', 'http://business.sohu.com/', 0, 0, 0, 1022, 0, 1, 0, NULL, 3, '', ''),
(234, '1279617741', '中国经济网', 'http://www.ce.cn/', 0, 0, 0, 1022, 0, 1, 0, NULL, 4, '', ''),
(235, '1279617741', '证券之星', 'http://www.stockstar.com/', 0, 0, 0, 1022, 0, 1, 0, NULL, 5, '', ''),
(236, '1279617741', '中金在线', 'http://www.cnfol.com', 0, 0, 0, 1022, 0, 1, 0, NULL, 6, '', ''),
(237, '1279617741', '中国经济网', 'http://www.ce.cn/', 0, 0, 0, 1022, 0, 1, 0, NULL, 7, '', ''),
(238, '1279617741', '中国财经信息网', 'http://www.cfi.cn', 0, 0, 0, 1022, 0, 1, 0, NULL, 8, '', ''),
(239, '1279617741', '百度财经', 'http://finance.baidu.com/', 0, 0, 0, 1022, 0, 1, 0, NULL, 9, '', ''),
(240, '1279617741', '网易财经', 'http://money.163.com/', 0, 0, 0, 1022, 0, 1, 0, NULL, 10, '', ''),
(241, '1279617741', '凤凰财经', 'http://finance.ifeng.com/', 0, 0, 0, 1022, 0, 1, 0, NULL, 11, '', ''),
(242, '1279617741', '新华网财经', 'http://www.xinhuanet.com/fortune/index.htm', 0, 0, 0, 1022, 0, 1, 0, NULL, 12, '', ''),
(243, '1279617741', '金融界', 'http://www.jrj.com.cn/default.htm', 0, 0, 0, 1022, 0, 1, 0, NULL, 13, '', ''),
(244, '1279617741', '腾讯财经', 'http://finance.qq.com', 0, 0, 0, 1022, 0, 1, 0, NULL, 14, '', ''),
(245, '1279617741', '21CN财经', 'http://finance.21cn.com/', 0, 0, 0, 1022, 0, 1, 0, NULL, 15, '', ''),
(246, '1279617741', '《财经网》', 'http://www.caijing.com.cn', 0, 0, 0, 1022, 0, 1, 0, NULL, 16, '', ''),
(247, '1279617741', '和讯财经', 'http://www.hexun.com/', 0, 0, 0, 1022, 0, 1, 0, NULL, 17, '', ''),
(248, '1279617741', '中国财经网', 'http://www.fec.com.cn', 0, 0, 0, 1022, 0, 1, 0, NULL, 18, '', ''),
(249, '1279617741', '股天下', 'http://www.gutx.com/', 0, 0, 0, 1022, 0, 1, 0, NULL, 19, '', ''),
(250, '1279617741', '黑马营', 'http://www.heimaying.com/', 0, 0, 0, 1022, 0, 1, 0, NULL, 20, '', ''),
(251, '1279617741', '股吧', 'http://guba.eastmoney.com/', 0, 0, 0, 1025, 0, 1, 1298456674, NULL, 1, '', ''),
(252, '1279617741', '股票吧论坛', 'http://bbs.gupiao8.com/', 0, 0, 0, 1025, 0, 1, 0, NULL, 2, '', ''),
(253, '1279617741', '金融界股票论坛', 'http://bbs.jrj.com.cn/', 0, 0, 0, 1025, 0, 1, 0, NULL, 3, '', ''),
(254, '1279617741', '老钱庄股票论坛', 'http://www.laoqianzhuang.com/', 0, 0, 0, 1025, 0, 1, 0, NULL, 4, '', ''),
(255, '1279617741', '搜狐股市论坛', 'http://business.sohu.com/upload/clubnew.htm', 0, 0, 0, 1025, 0, 1, 0, NULL, 5, '', ''),
(256, '1279617741', 'MACD股市技术论坛', 'http://bbs.macd.cn', 0, 0, 0, 1025, 0, 1, 0, NULL, 6, '', ''),
(257, '1279617741', '创幻财经论坛', 'http://www.chcj.net/bbs.php', 0, 0, 0, 1025, 0, 1, 0, NULL, 7, '', ''),
(258, '1279617741', '黑马屋股票论坛', 'http://www.Gupiao-bbs.com', 0, 0, 0, 1025, 0, 1, 0, NULL, 8, '', ''),
(259, '1279617741', '金融吧论坛', 'http://bbs.jinrong8.com/', 0, 0, 0, 1025, 0, 1, 0, NULL, 9, '', ''),
(260, '1279617741', '新浪财经论坛', 'http://finance.sina.com.cn/bbs/index.shtml', 0, 0, 0, 1025, 0, 1, 0, NULL, 10, '', ''),
(261, '1279617741', '中金博客', 'http://blog.cnfol.com/', 0, 0, 0, 1025, 0, 1, 0, NULL, 11, '', ''),
(262, '1279617741', '和讯股票博客', 'http://blog.hexun.com/class20.htm', 0, 0, 0, 1025, 0, 1, 0, NULL, 12, '', ''),
(263, '1279617741', '中国证券网博客', 'http://blog.cnstock.com/', 0, 0, 0, 1025, 0, 1, 0, NULL, 13, '', ''),
(264, '1279617741', '新浪财经博客', 'http://blog.sina.com.cn/lm/finance/index.html', 0, 0, 0, 1025, 0, 1, 0, NULL, 14, '', ''),
(265, '1279617741', '东方财富财经博客', 'http://blog.eastmoney.com/', 0, 0, 0, 1025, 0, 1, 0, NULL, 15, '', ''),
(266, '1279617741', '搜狐财经博客', 'http://blog.sohu.com/business/', 0, 0, 0, 1025, 0, 1, 0, NULL, 16, '', ''),
(267, '1279617741', '鼎砥投资论坛', 'http://bbs.dingdi.com', 0, 0, 0, 1025, 0, 1, 0, NULL, 21, '', ''),
(268, '1279617741', '今日财经论坛', 'http://www.caijing.name/', 0, 0, 0, 1025, 0, 1, 0, NULL, 25, '', ''),
(269, '1279617741', '金融界-股评天地', 'http://invest.jrj.com.cn/invest/', 0, 0, 0, 1026, 0, 1, 1298456674, NULL, 1, '', ''),
(270, '1279617741', '东方财富网-行情', 'http://quote.eastmoney.com/', 0, 0, 0, 1026, 0, 1, 0, NULL, 2, '', ''),
(272, '1279617741', '新浪-股市行情', 'http://biz.finance.sina.com.cn/hq/', 0, 0, 0, 1026, 0, 1, 0, NULL, 4, '', ''),
(273, '1279617741', '777606', 'http://www.777606.com/', 0, 0, 0, 1026, 0, 1, 0, NULL, 5, '', ''),
(274, '1279617741', '全景网-股评', 'http://www.p5w.net/stock/hydx/', 0, 0, 0, 1026, 0, 1, 0, NULL, 6, '', ''),
(275, '1279617741', '搜狐-千股千评', 'http://stock.business.sohu.com/m/ma.php', 1, 0, 0, 1026, 0, 1, 0, NULL, 7, '', ''),
(276, '1279617741', '腾讯-财经天下评', 'http://finance.qq.com/tianxiaping/index.htm', 0, 0, 0, 1026, 0, 1, 0, NULL, 8, '', ''),
(277, '1279617741', '证券之星-行情', 'http://quote.stockstar.com/stock/', 0, 0, 0, 1026, 0, 1, 0, NULL, 9, '', ''),
(278, '1279617741', '和讯评论', 'http://opinion.hexun.com/', 0, 0, 0, 1026, 0, 1, 0, NULL, 10, '', ''),
(279, '1279617741', '新浪-股市行情', 'http://finance.sina.com.cn/realstock/index.shtml', 0, 0, 0, 1023, 0, 1, 1298456674, NULL, 1, '', ''),
(280, '1279617741', '东方财富网行情', 'http://quote.eastmoney.com/quote1_1.html', 0, 0, 0, 1023, 0, 1, 0, NULL, 2, '', ''),
(281, '1279617741', '机构当日增减仓', 'http://www.zhicheng.com/jgcc/2.htm', 0, 0, 0, 1023, 0, 1, 0, NULL, 3, '', ''),
(282, '1279617741', '证券之星-行情频道', 'http://quote.stockstar.com/stock/', 0, 0, 0, 1023, 0, 1, 0, NULL, 4, '', ''),
(283, '1279617741', '金融界-港股行情', 'http://hk.jrj.com.cn/bmp/', 0, 0, 0, 1023, 0, 1, 1289800902, NULL, 5, '', ''),
(284, '1279617741', '和讯-股票数据', 'http://datainfo.stock.hexun.com/', 0, 0, 0, 1023, 0, 1, 0, NULL, 6, '', ''),
(285, '1279617741', '金融界-数据中心', 'http://summary.jrj.com.cn/hqstat/hqstat.shtml', 0, 0, 0, 1023, 0, 1, 0, NULL, 7, '', ''),
(286, '1279617741', '外汇牌价', 'http://www.boc.cn/cn/common/whpj.html', 0, 0, 0, 1023, 0, 1, 0, NULL, 8, '', ''),
(287, '1279617741', '最近发行基金', 'http://baidu.hexun.com/fund/nf.php', 0, 0, 0, 1023, 0, 1, 0, NULL, 9, '', ''),
(288, '1279617741', '股票数据下载专家', 'http://www.duote.com/soft/1550.html', 0, 0, 0, 1023, 0, 1, 0, NULL, 10, '', ''),
(289, '1279617741', '封闭式基金行情', 'http://quote.eastmoney.com/jijingbaojia.html', 0, 0, 0, 1023, 0, 1, 0, NULL, 11, '', ''),
(290, '1279617741', '新股发行/中签查询', 'http://data.eastmoney.com/xg/xg/', 0, 0, 0, 1023, 0, 1, 0, NULL, 12, '', ''),
(292, '1279617741', '今日黄金价格', 'http://gold.baidu.com/price/index.html', 0, 0, 0, 1023, 0, 1, 0, NULL, 14, '', ''),
(293, '1279617741', '搜股网-主力查询', 'http://www.sosostock.com/searchdde.asp', 0, 0, 0, 1023, 0, 1, 0, NULL, 15, '', ''),
(294, '1279617741', '中国证监会', 'http://www.csrc.gov.cn/', 0, 0, 0, 1024, 0, 1, 1298456674, NULL, 1, '', ''),
(295, '1279617741', '上海证券交易所', 'http://www.sse.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 2, '', ''),
(296, '1279617741', '深圳证券交易所', 'http://www.szse.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 3, '', ''),
(297, '1279617741', '香港交易所', 'http://www.hkex.com.hk/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 4, '', ''),
(298, '1279617741', '上海黄金交易所', 'http://www.sge.sh/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 5, '', ''),
(299, '1279617741', '国泰君安', 'http://www.gtja.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 6, '', ''),
(300, '1279617741', '广发证券', 'http://www.gf.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 7, '', ''),
(301, '1279617741', '华泰证券', 'http://www.htsc.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 8, '', ''),
(302, '1279617741', '银河证券', 'http://www.chinastock.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 9, '', ''),
(303, '1279617741', '西部证券', 'http://www.westsecu.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 10, '', ''),
(304, '1279617741', '招商证券', 'http://www.newone.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 11, '', ''),
(305, '1279617741', '西南证券', 'http://www.swsc.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 12, '', ''),
(306, '1279617741', '中信证券', 'http://www.cs.ecitic.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 13, '', ''),
(307, '1279617741', '财富证券', 'http://www.cfzq.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 14, '', ''),
(308, '1279617741', '国信证券', 'http://www.guosen.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 15, '', ''),
(309, '1279617741', '海通证券', 'http://www.htsec.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 16, '', ''),
(310, '1279617741', '华安证券', 'http://www.huaans.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 17, '', ''),
(311, '1279617741', '国盛证券', 'http://www.gsstock.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 18, '', ''),
(312, '1279617741', '财达证券', 'http://www.s10000.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 19, '', ''),
(313, '1279617741', '长江证券', 'http://www.95579.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 20, '', ''),
(314, '1279617741', '光大证券', 'http://www.ebscn.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 21, '', ''),
(315, '1279617741', '国都证券', 'http://www.guodu.com/', 0, 0, 0, 1024, 0, 1, 1300673591, NULL, 22, '', ''),
(316, '1279617741', '国海证券', 'http://www.ghzq.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 23, '', ''),
(317, '1279617741', '万联证券', 'http://www.wlzq.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 24, '', ''),
(318, '1279617741', '华西证券', 'http://www.hx168.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 25, '', ''),
(319, '1279617741', '中银国际', 'http://www.bocionline.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 26, '', ''),
(320, '1279617741', '兴业证券', 'http://www.xyzq.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 27, '', ''),
(321, '1279617741', '山西证券', 'http://www.i618.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 28, '', ''),
(322, '1279617741', '信达证券', 'http://www.cindasc.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 29, '', ''),
(323, '1279617741', '东北证券', 'http://www.nesc.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 30, '', ''),
(324, '1279617741', '中投证券', 'http://www.cjis.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 31, '', ''),
(325, '1279617741', '安信证券', 'http://www.essence.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 32, '', ''),
(326, '1279617741', '东海证券', 'http://www.longone.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 33, '', ''),
(327, '1279617741', '东莞证券', 'http://www.dgzq.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 34, '', ''),
(328, '1279617741', '财通证券', 'http://www.ctsec.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 35, '', ''),
(329, '1279617741', '浙商证券', 'http://www.stocke.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 36, '', ''),
(330, '1279617741', '国元证券', 'http://www.gyzq.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 37, '', ''),
(331, '1279617741', '联合证券', 'http://www.lhzq.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 38, '', ''),
(332, '1279617741', '中信建投', 'http://www.csc108.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 39, '', ''),
(333, '1279617741', '恒泰证券', 'http://www.cnht.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 40, '', ''),
(334, '1279617741', '东方证券', 'http://www.dfzq.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 41, '', ''),
(335, '1279617741', '东吴证券', 'http://www.dwjq.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 42, '', ''),
(336, '1279617741', '中原证券', 'http://www.ccnew.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 43, '', ''),
(337, '1279617741', '齐鲁证券', 'http://www.qlzq.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 44, '', ''),
(338, '1279617741', '国联证券', 'http://www.glsc.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 45, '', ''),
(339, '1279617741', '南京证券', 'http://www.njzq.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 46, '', ''),
(340, '1279617741', '上海证券', 'http://www.962518.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 47, '', ''),
(341, '1279617741', '方正证券', 'http://www.foundersc.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 48, '', ''),
(342, '1279617741', '湘财证券', 'http://www.xcsc.com/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 49, '', ''),
(343, '1279617741', '国金证券', 'http://www.gjzq.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708289, NULL, 50, '', ''),
(344, '1279617741', '申银万国', 'http://www.sw2000.com.cn/', 0, 0, 0, 1024, 0, 1, 1289708311, NULL, 51, '', ''),
(345, '1279617741', '民生证券', 'http://www.mszq.com/', 0, 0, 0, 1024, 0, 1, 1289708311, NULL, 52, '', ''),
(346, '1279617741', '宏源证券', 'http://www.hysec.com/', 0, 0, 0, 1024, 0, 1, 1289708311, NULL, 53, '', ''),
(347, '1279617741', '天天基金', 'http://www.1234567.com.cn/', 0, 0, 0, 1027, 0, 1, 1298456674, NULL, 1, '', ''),
(348, '1279617741', '新浪基金', 'http://finance.sina.com.cn/fund/index.shtml', 0, 0, 0, 1027, 0, 1, 0, NULL, 2, '', ''),
(349, '1279617741', '金融界基金', 'http://fund.jrj.com.cn/', 0, 0, 0, 1027, 0, 1, 0, NULL, 3, '', ''),
(350, '1279617741', '和讯基金', 'http://funds.money.hexun.com/', 0, 0, 0, 1027, 0, 1, 0, NULL, 4, '', ''),
(351, '1279617741', '中国基金网', 'http://www.cnfund.cn/', 0, 0, 0, 1027, 0, 1, 0, NULL, 5, '', ''),
(352, '1279617741', '搜狐基金', 'http://money.business.sohu.com/fund/', 0, 0, 0, 1027, 0, 1, 0, NULL, 6, '', ''),
(353, '1279617741', '基金天下', 'http://www.tttz.com/', 0, 0, 0, 1027, 0, 1, 0, NULL, 7, '', ''),
(354, '1279617741', '证券之星-基金', 'http://fund.stockstar.com/', 0, 0, 0, 1027, 0, 1, 0, NULL, 8, '', ''),
(355, '1279617741', '中金在线基金', 'http://fund.cnfol.com/', 0, 0, 0, 1027, 0, 1, 0, NULL, 9, '', ''),
(356, '1279617741', '全景网-基金', 'http://www.p5w.net/fund/', 0, 0, 0, 1027, 0, 1, 0, NULL, 10, '', ''),
(357, '1279617741', '和讯网', 'http://www.hexun.com/', 0, 0, 0, 1029, 0, 1, 1298456674, NULL, 1, '', ''),
(358, '1279617741', '搜狐理财', 'http://money.business.sohu.com/', 0, 0, 0, 1029, 0, 1, 0, NULL, 2, '', ''),
(359, '1279617741', '新浪网理财', 'http://finance.sina.com.cn/money/index.shtml', 0, 0, 0, 1029, 0, 1, 0, NULL, 3, '', ''),
(360, '1279617741', '网易理财', 'http://finance.163.com/money/', 0, 0, 0, 1029, 0, 1, 0, NULL, 4, '', ''),
(361, '1279617741', '东方财富网', 'http://www.eastmoney.com/', 0, 0, 0, 1029, 0, 1, 0, NULL, 5, '', ''),
(362, '1279617741', '世界财经报道-理财', 'http://finance.icxo.com/money/index.html', 0, 0, 0, 1029, 0, 1, 0, NULL, 6, '', ''),
(363, '1279617741', '金融界理财', 'http://money.jrj.com.cn/money/', 0, 0, 0, 1029, 0, 1, 0, NULL, 7, '', ''),
(364, '1279617741', '挖贝网', 'http://www.wabei.com/', 0, 0, 0, 1029, 0, 1, 0, NULL, 8, '', ''),
(365, '1279617741', '中金在线', 'http://www.cnfol.com', 0, 0, 0, 1029, 0, 1, 0, NULL, 9, '', ''),
(366, '1279617741', '第一理财网', 'http://www.amoney.com.cn/cms.php', 0, 0, 0, 1029, 0, 1, 0, NULL, 10, '', ''),
(367, '1279617741', '至诚理财网', 'http://www.zhicheng.com/', 0, 0, 0, 1029, 0, 1, 0, NULL, 11, '', ''),
(368, '1279617741', 'FT中文网', 'http://www.ftchinese.com', 0, 0, 0, 1029, 0, 1, 0, NULL, 12, '', ''),
(369, '1279617741', '中信金融网', 'http://www.ecitic.com', 0, 0, 0, 1029, 0, 1, 0, NULL, 13, '', ''),
(370, '1279617741', '商业英才网', 'http://www.bnet.com.cn/', 0, 0, 0, 1029, 0, 1, 0, NULL, 14, '', ''),
(371, '1279617741', '理财计算器大全', 'http://pub-edu.cbrc.gov.cn/pesw/info/sygj/', 0, 0, 0, 1029, 0, 1, 0, NULL, 15, '', ''),
(372, '1279617741', '华夏基金', 'http://www.chinaamc.com/portal/cn/index.html', 0, 0, 0, 1028, 0, 1, 1298456674, NULL, 1, '', ''),
(373, '1279617741', '南方基金', 'http://www.nffund.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 2, '', ''),
(374, '1279617741', '嘉实基金', 'http://www.jsfund.cn/jswz/index.html', 0, 0, 0, 1028, 0, 1, 0, NULL, 3, '', ''),
(375, '1279617741', '广发基金', 'http://www.gffunds.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 4, '', ''),
(376, '1279617741', '鹏华基金', 'http://www.phfund.com.cn/phfund/', 0, 0, 0, 1028, 0, 1, 0, NULL, 5, '', ''),
(377, '1279617741', '大成基金', 'http://www.dcfund.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 6, '', ''),
(378, '1279617741', '易方达基金', 'http://www.efunds.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 7, '', ''),
(379, '1279617741', '博时基金', 'http://www.bosera.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 8, '', ''),
(380, '1279617741', '上投摩根基金', 'http://www.51fund.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 9, '', ''),
(381, '1279617741', '富国基金', 'http://www.fullgoal.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 10, '', ''),
(382, '1279617741', '银华基金', 'http://www.yhfund.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 11, '', ''),
(383, '1279617741', '工银瑞信基金', 'http://www.icbccs.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 12, '', ''),
(384, '1279617741', '长城基金', 'http://www.ccfund.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 13, '', ''),
(385, '1279617741', '国泰基金', 'http://www.gtfund.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 14, '', ''),
(386, '1279617741', '华商基金', 'http://www.hsfund.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 15, '', ''),
(387, '1279617741', '中邮基金', 'http://www.postfund.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 16, '', ''),
(388, '1279617741', '景顺基金', 'http://www.invescogreatwall.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 17, '', ''),
(389, '1279617741', '新华基金', 'http://www.ncfund.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 18, '', ''),
(390, '1279617741', '融通基金', 'http://www.rtfund.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 19, '', ''),
(391, '1279617741', '万家基金', 'http://www.wjasset.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 20, '', ''),
(392, '1279617741', '华安基金', 'http://www.huaan.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 21, '', ''),
(393, '1279617741', '长盛基金', 'http://www.csfunds.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 22, '', ''),
(394, '1279617741', '国投瑞银', 'http://www.ubssdic.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 23, '', ''),
(395, '1279617741', '诺安基金', 'http://www.lionfund.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 24, '', ''),
(396, '1279617741', '中银基金', 'http://www.bociim.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 25, '', ''),
(397, '1279617741', '汇添富基金', 'http://www.99fund.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 26, '', ''),
(398, '1279617741', '建信基金', 'http://www.ccbfund.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 27, '', ''),
(399, '1279617741', '泰达宏利', 'http://www.mfcteda.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 28, '', ''),
(400, '1279617741', '华宝兴业', 'http://www.fsfund.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 29, '', ''),
(401, '1279617741', '中海基金', 'http://www.zhfund.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 30, '', ''),
(402, '1279617741', '光大保德信基金', 'http://www.epf.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 31, '', ''),
(403, '1279617741', '兴业全球基金', 'http://www.xyfunds.com.cn/', 0, 0, 0, 1028, 0, 1, 0, NULL, 32, '', ''),
(404, '1279617741', '招商基金', 'http://www.cmfchina.com/', 0, 0, 0, 1028, 0, 1, 0, NULL, 33, '', ''),
(405, '1279617741', '中国工商银行代销基金', 'http://www.icbc.com.cn/icbc/%e7%bd%91%e4%b8%8a%e5%9f%ba%e9%87%91', 0, 0, 0, 1028, 0, 1, 0, NULL, 34, '', ''),
(406, '1279617741', '中国建设银行代销基金', 'http://fund.ccb.com/fund/index.html', 0, 0, 0, 1028, 0, 1, 0, NULL, 35, '', ''),
(407, '1279617741', '邮政储蓄代销基金', 'http://www.psbc.com/portal/zh_CN/Fund/index.html', 0, 0, 0, 1028, 0, 1, 0, NULL, 36, '', ''),
(408, '1279617741', '工商银行', 'http://www.icbc.com.cn', 0, 0, 0, 1030, 0, 1, 1298456674, NULL, 1, '', ''),
(409, '1279617741', '招商银行', 'http://www.cmbchina.com', 0, 0, 0, 1030, 0, 1, 0, NULL, 2, '', ''),
(410, '1279617741', '农业银行', 'http://www.abchina.com', 0, 0, 0, 1030, 0, 1, 0, NULL, 3, '', ''),
(411, '1279617741', '建设银行', 'http://www.ccb.com/portal/cn/home/index.html', 0, 0, 0, 1030, 0, 1, 0, NULL, 4, '', ''),
(412, '1279617741', '中国银行', 'http://www.boc.cn/cn/static/index.html', 0, 0, 0, 1030, 0, 1, 0, NULL, 5, '', ''),
(413, '1279617741', '中国民生银行', 'http://www.cmbc.com.cn/', 0, 0, 0, 1030, 0, 1, 0, NULL, 6, '', ''),
(414, '1279617741', '中国光大银行', 'http://www.cebbank.com/ceb/html/index.html', 0, 0, 0, 1030, 0, 1, 0, NULL, 7, '', ''),
(415, '1279617741', '交通银行', 'http://www.bankcomm.com/jh/cn/index.html', 0, 0, 0, 1030, 0, 1, 0, NULL, 8, '', ''),
(416, '1279617741', '中信银行', 'http://www.ecitic.com/bank/', 0, 0, 0, 1030, 0, 1, 0, NULL, 9, '', ''),
(417, '1279617741', '兴业银行', 'http://www.cib.com.cn/netbank/cn/index.html', 0, 0, 0, 1030, 0, 1, 0, NULL, 9, '', ''),
(418, '1279617741', '上海浦东发展银行', 'http://www.spdb.com.cn/chpage/c414/', 0, 0, 0, 1030, 0, 1, 0, NULL, 10, '', ''),
(419, '1279617741', '中国人民银行', 'http://www.pbc.gov.cn/', 0, 0, 0, 1030, 0, 1, 0, NULL, 11, '', ''),
(420, '1279617741', '华夏银行', 'http://www.hxb.com.cn/chinese/', 0, 0, 0, 1030, 0, 1, 0, NULL, 12, '', ''),
(421, '1279617741', '深圳发展银行', 'http://www.sdb.com.cn/', 0, 0, 0, 1030, 0, 1, 0, NULL, 13, '', ''),
(422, '1279617741', '广东发展银行', 'http://ebank.gdb.com.cn/comminfo/index.jsp', 0, 0, 0, 1030, 0, 1, 0, NULL, 14, '', ''),
(423, '1279617741', '国家开发银行', 'http://www.cdb.com.cn/web/', 0, 0, 0, 1030, 0, 1, 0, NULL, 15, '', ''),
(424, '1279617741', '中国邮政储蓄银行', 'http://www.psbc.com/', 0, 0, 0, 1030, 0, 1, 0, NULL, 16, '', ''),
(425, '1279617741', '中国进出口银行', 'http://www.eximbank.gov.cn/', 0, 0, 0, 1030, 0, 1, 1289712181, NULL, 17, '', ''),
(426, '1279617741', '北京银行', 'http://www.bankofbeijing.com.cn/', 0, 0, 0, 1031, 0, 1, 0, NULL, 1, '', ''),
(427, '1279617741', '平安银行', 'http://bank.pingan.com/', 0, 0, 0, 1031, 0, 1, 0, NULL, 2, '', ''),
(428, '1279617741', '北京农村商业银行', 'http://www.bjrcb.com/', 0, 0, 0, 1031, 0, 1, 0, NULL, 3, '', ''),
(429, '1279617741', '天津银行', 'http://www.tccb.com.cn/', 0, 0, 0, 1031, 0, 1, 0, NULL, 4, '', ''),
(430, '1279617741', '渤海银行', 'http://www.cbhb.com.cn/', 0, 0, 0, 1031, 0, 1, 0, NULL, 5, '', ''),
(431, '1279617741', '上海银行', 'http://www.bankofshanghai.com/', 0, 0, 0, 1031, 0, 1, 0, NULL, 6, '', ''),
(432, '1279617741', '上海农村商业银行', 'http://www.srcb.com/', 0, 0, 0, 1031, 0, 1, 0, NULL, 7, '', ''),
(433, '1279617741', '南京银行', 'http://www.njcb.com.cn/', 0, 0, 0, 1031, 0, 1, 0, NULL, 8, '', ''),
(434, '1279617741', '宁波银行', 'http://www.nbcb.com.cn/', 0, 0, 0, 1031, 0, 1, 0, NULL, 9, '', ''),
(435, '1279617741', '包商银行', 'http://www.bcb.com.cn/', 0, 0, 0, 1031, 0, 1, 0, NULL, 10, '', ''),
(436, '1279617741', '杭州银行', 'http://www.hccb.com.cn/', 0, 0, 0, 1031, 0, 1, 0, NULL, 11, '', ''),
(437, '1279617741', '江苏银行', 'http://www.jsbchina.cn/', 0, 0, 0, 1031, 0, 1, 0, NULL, 12, '', ''),
(438, '1279617741', '深圳农村商业银行', 'http://www.961200.net/', 0, 0, 0, 1031, 0, 1, 0, NULL, 13, '', ''),
(439, '1279617741', '重庆银行', 'http://www.cqcbank.com/', 0, 0, 0, 1031, 0, 1, 0, NULL, 14, '', ''),
(440, '1279617741', '浙商银行', 'http://www.czbank.com/czbank/', 0, 0, 0, 1031, 0, 1, 0, NULL, 15, '', ''),
(441, '1279617741', '青岛银行', 'http://www.qdccb.com/', 0, 0, 0, 1031, 0, 1, 0, NULL, 16, '', ''),
(442, '1279617741', '成都银行', 'http://www.bocd.com.cn/', 0, 0, 0, 1031, 0, 1, 0, NULL, 17, '', ''),
(443, '1279617741', '哈尔滨银行', 'http://www.hrbcb.com.cn/', 0, 0, 0, 1031, 0, 1, 0, NULL, 18, '', ''),
(444, '1279617741', '徽商银行', 'http://www.hsbank.com.cn/', 0, 0, 0, 1031, 0, 1, 0, NULL, 19, '', ''),
(445, '1279617741', '中国人民银行', 'http://www.pbc.gov.cn/', 0, 0, 0, 1032, 0, 1, 0, NULL, 1, '', ''),
(446, '1279617741', '银监会', 'http://www.cbrc.gov.cn/', 0, 0, 0, 1032, 0, 1, 0, NULL, 2, '', ''),
(447, '1279617741', '中国银联', 'http://www.chinaunionpay.com/', 0, 0, 0, 1032, 0, 1, 0, NULL, 3, '', ''),
(448, '1279617741', '国家开发银行', 'http://www.cdb.com.cn/', 0, 0, 0, 1032, 0, 1, 0, NULL, 4, '', ''),
(449, '1279617741', '中国农业发展银行', 'http://www.adbc.com.cn/', 0, 0, 0, 1032, 0, 1, 0, NULL, 5, '', ''),
(450, '1279617741', '人民币存/贷款利率', 'http://www.ccb.com/cn/personal/deposit/rmbdeposit.html', 0, 0, 0, 1032, 0, 1, 0, NULL, 6, '', ''),
(451, '1279617741', '中国银行业协会', 'http://www.china-cba.net/', 0, 0, 0, 1032, 0, 1, 0, NULL, 7, '', ''),
(452, '1279617741', '花旗银行', 'http://www.citibank.com.cn/', 0, 0, 0, 1033, 0, 1, 0, NULL, 1, '', ''),
(453, '1279617741', '汇丰银行', 'http://www.hsbc.com.cn/', 0, 0, 0, 1033, 0, 1, 0, NULL, 2, '', ''),
(454, '1279617741', '渣打银行', 'http://pc.heima8.com/index.php?p=121950391&c=0011&sc=[subcode]&durl=121902651&a=121902611&cc=121903422', 0, 0, 0, 1033, 0, 1, 1296035206, NULL, 3, '', ''),
(455, '1279617741', '恒生银行', 'http://www.hangseng.com/', 0, 0, 0, 1033, 0, 1, 0, NULL, 4, '', ''),
(456, '1279617741', '东亚银行', 'http://www.hkbea.com.cn/', 0, 0, 0, 1033, 0, 1, 0, NULL, 5, '', ''),
(43, '1279617741', '百付宝', 'http://www.baifubao.com/', 0, 0, 0, 1034, 0, 1, 0, NULL, 6, '', ''),
(457, '1279617741', '携程旅行网', 'http://www.ctrip.com/', 0, 0, 0, 1035, 0, 1, 0, NULL, 1, '', ''),
(458, '1279617741', '去哪儿', 'http://www.qunar.com/', 0, 0, 0, 1035, 0, 1, 1289801364, NULL, 2, '', ''),
(459, '1279617741', '芒果网', 'http://www.mangocity.com/', 0, 0, 0, 1035, 0, 1, 0, NULL, 3, '', ''),
(460, '1279617741', '艺龙旅行网', 'http://travel.elong.com/hotels/default.aspx', 0, 0, 0, 1035, 0, 1, 1289801383, NULL, 4, '', ''),
(461, '1279617741', '同程网', 'http://www.17u.com/', 0, 0, 0, 1035, 0, 1, 0, NULL, 5, '', ''),
(462, '1279617741', '张家界旅游信息网', 'http://www.gozjj.net', 0, 0, 0, 1035, 0, 1, 0, NULL, 6, '', ''),
(463, '1279617741', '穷游网', 'http://www.go2eu.com/', 0, 0, 0, 1035, 0, 1, 0, NULL, 7, '', ''),
(464, '1279617741', '张家界自助旅游网', 'http://www.zjj1.com/', 0, 0, 0, 1035, 0, 1, 0, NULL, 8, '', ''),
(465, '1279617741', '乐途旅游网', 'http://www.lotour.com/', 0, 0, 0, 1035, 0, 1, 0, NULL, 9, '', ''),
(466, '1279617741', '国家旅游局', 'http://www.cnta.com/', 0, 0, 0, 1035, 0, 1, 0, NULL, 10, '', ''),
(467, '1279617741', '中国通用旅游', 'http://www.51766.com/', 0, 0, 0, 1035, 0, 1, 0, NULL, 11, '', ''),
(468, '1279617741', '搜狐旅游', 'http://travel.sohu.com', 0, 0, 0, 1035, 0, 1, 0, NULL, 12, '', ''),
(469, '1279617741', '新华网-旅游', 'http://www.xinhuanet.com/travel/', 0, 0, 0, 1035, 0, 1, 0, NULL, 13, '', ''),
(470, '1279617741', '21CN-旅游', 'http://travel.21cn.com/', 0, 0, 0, 1035, 0, 1, 0, NULL, 14, '', ''),
(471, '1279617741', '人民网旅游', 'http://travel.people.com.cn/', 0, 0, 0, 1035, 0, 1, 0, NULL, 15, '', ''),
(472, '1279617741', '途牛旅游网', 'http://www.tuniu.com/', 0, 0, 0, 1035, 0, 1, 1289801319, NULL, 16, '', ''),
(473, '1279617741', '到到旅游点评网', 'http://www.daodao.com/', 0, 0, 0, 1035, 0, 1, 1289801333, NULL, 17, '', ''),
(474, '1279617741', '全游网', 'http://www.3608.com/', 0, 0, 0, 1035, 0, 1, 0, NULL, 18, '', ''),
(475, '1279617741', '酷讯旅游', 'http://www.kuxun.cn/', 0, 0, 0, 1035, 0, 1, 0, NULL, 19, '', ''),
(476, '1279617741', '绿人网', 'http://www.lvren.cn/', 0, 0, 0, 1035, 0, 1, 0, NULL, 20, '', ''),
(477, '1279617741', '九游网', 'http://www.9tour.cn/', 0, 0, 0, 1035, 0, 1, 0, NULL, 21, '', ''),
(478, '1279617741', '麒迅旅行网', 'http://www.oyesgo.com/', 0, 0, 0, 1035, 0, 1, 0, NULL, 22, '', ''),
(479, '1279617741', '世博订房网', 'http://www.expotia.com/', 0, 0, 0, 1035, 0, 1, 1291873618, NULL, 23, '', ''),
(480, '1279617741', '中国旅行社总社', 'http://ctsho.com/', 0, 0, 0, 1036, 0, 1, 0, NULL, 1, '', ''),
(481, '1279617741', '中国国际旅行社', 'http://www.cits.cn/', 0, 0, 0, 1036, 0, 1, 0, NULL, 2, '', ''),
(482, '1279617741', '中国康辉', 'http://www.cct.cn/', 0, 0, 0, 1036, 0, 1, 0, NULL, 3, '', ''),
(483, '1279617741', '中青旅傲游网', 'http://www.aoyou.com/', 0, 0, 0, 1036, 0, 1, 0, NULL, 4, '', ''),
(484, '1279617741', '广之旅', 'http://www.cnto.com/', 0, 0, 0, 1036, 0, 1, 0, NULL, 5, '', ''),
(485, '1279617741', '南湖国旅', 'http://www.nanhutravel.com/', 0, 0, 0, 1036, 0, 1, 0, NULL, 6, '', ''),
(486, '1279617741', '凯撒国旅', 'http://www.caissa.com.cn/', 0, 0, 0, 1036, 0, 1, 0, NULL, 7, '', ''),
(487, '1279617741', '昆明青年旅行社', 'http://www.yts88.com/', 0, 0, 0, 1036, 0, 1, 0, NULL, 8, '', ''),
(488, '1279617741', '中国国旅', 'http://www.cits.cn/', 0, 0, 0, 1037, 0, 1, 0, NULL, 1, '', ''),
(489, '1279617741', '中旅总社', 'http://ctsho.com', 0, 0, 0, 1037, 0, 1, 0, NULL, 2, '', ''),
(490, '1279617741', '中青旅遨游', 'http://www.aoyou.com/', 0, 0, 0, 1037, 0, 1, 0, NULL, 3, '', ''),
(491, '1279617741', '游易航空旅游网', 'http://www.yoee.com/', 0, 0, 0, 1037, 0, 1, 0, NULL, 4, '', ''),
(492, '1279617741', '信天游', 'http://www.travelsky.com/', 0, 0, 0, 1037, 0, 1, 1304680881, NULL, 7, '', ''),
(493, '1279617741', '黄金假日', 'http://www.goldenholiday.com/', 0, 0, 0, 1037, 0, 1, 1304680881, NULL, 7, '', ''),
(494, '1279617741', '中国康辉', 'http://www.cct.cn/', 0, 0, 0, 1037, 0, 1, 0, NULL, 7, '', ''),
(495, '1279617741', '酒店特价预订', 'http://hotels.ctrip.com/Domestic/SearchHotel.aspx', 0, 0, 0, 1037, 0, 1, 0, NULL, 8, '', ''),
(6707, '1289791828', '中山大学', 'http://www.sysu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 1, '', ''),
(496, '1279617741', '春秋航空旅游网', 'http://www.china-sss.com/index.asp', 0, 0, 0, 1037, 0, 1, 0, NULL, 9, '', ''),
(497, '1279617741', '汉庭连锁酒店', 'http://www.htinns.com/', 0, 0, 0, 1037, 0, 1, 0, NULL, 10, '', ''),
(498, '1279617741', '7天连锁酒店', 'http://www.7daysinn.cn/marketact/active/com_reg/reg.php', 0, 0, 0, 1037, 0, 1, 1289801416, NULL, 11, '', ''),
(499, '1279617741', '如家酒店连锁', 'http://www.homeinns.com/', 0, 0, 0, 1037, 0, 1, 0, NULL, 12, '', ''),
(500, '1279617741', '快乐e行商务旅行网', 'http://www.etpass.com', 0, 0, 0, 1037, 0, 1, 0, NULL, 13, '', ''),
(501, '1279617741', '火车票网', 'http://www.huochepiao.com/', 0, 0, 0, 1037, 0, 1, 0, NULL, 14, '', ''),
(502, '1279617741', '酷讯火车票', 'http://piao.kuxun.cn/', 0, 0, 0, 1037, 0, 1, 0, NULL, 15, '', ''),
(503, '1279617741', '189酒店预订', 'http://www.189uu.com/', 0, 0, 0, 1037, 0, 1, 0, NULL, 16, '', ''),
(504, '1279617741', '中国户外资料网', 'http://www.8264.com/', 0, 0, 0, 1038, 0, 1, 0, NULL, 1, '', ''),
(505, '1279617741', '户外探险网', 'http://www.out99.com/', 0, 0, 0, 1038, 0, 1, 0, NULL, 2, '', ''),
(506, '1279617741', '中华驴友社区', 'http://www.china69.com.cn', 0, 0, 0, 1038, 0, 1, 0, NULL, 3, '', ''),
(507, '1279617741', 'ZEEU自游天下', 'http://www.zeeu.cn/', 0, 0, 0, 1038, 0, 1, 0, NULL, 4, '', ''),
(508, '1279617741', '游多多自助游', 'http://www.yododo.com', 0, 0, 0, 1038, 0, 1, 0, NULL, 5, '', ''),
(509, '1279617741', '百度地图', 'http://map.baidu.com/', 0, 0, 0, 1039, 0, 1, 0, NULL, 1, '', ''),
(510, '1279617741', '图行天下', 'http://www.go2map.com/', 0, 0, 0, 1039, 0, 1, 0, NULL, 2, '', ''),
(511, '1279617741', '谷歌地图', 'http://ditu.google.cn/', 0, 0, 0, 1039, 0, 1, 0, NULL, 3, '', ''),
(512, '1279617741', '我要地图', 'http://www.51ditu.com/', 0, 0, 0, 1039, 0, 1, 0, NULL, 4, '', ''),
(513, '1279617741', '相约久久景点地图', 'http://www.meet99.com/', 0, 0, 0, 1039, 0, 1, 0, NULL, 5, '', ''),
(514, '1279617741', '搜房网', 'http://www.soufun.com/', 0, 0, 0, 1040, 0, 1, 0, NULL, 1, '', ''),
(515, '1279617741', '焦点房地产网', 'http://house.focus.cn/', 0, 0, 0, 1040, 0, 1, 0, NULL, 2, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(516, '1279617741', '新浪房产', 'http://house.sina.com.cn', 0, 0, 0, 1040, 0, 1, 0, NULL, 3, '', ''),
(517, '1279617741', '搜狐房产', 'http://house.sohu.com', 0, 0, 0, 1040, 0, 1, 0, NULL, 4, '', ''),
(518, '1279617741', '口碑网房产', 'http://fang.koubei.com', 0, 0, 0, 1040, 0, 1, 0, NULL, 5, '', ''),
(519, '1279617741', '新华网房产频道', 'http://www.xinhuanet.com/house/', 0, 0, 0, 1040, 0, 1, 0, NULL, 7, '', ''),
(520, '1279617741', '雅虎房地产', 'http://cn.realestate.yahoo.com', 0, 0, 0, 1040, 0, 1, 0, NULL, 8, '', ''),
(521, '1279617741', '赶集网租房二手房', 'http://www.ganji.com/fang/', 0, 0, 0, 1040, 0, 1, 0, NULL, 9, '', ''),
(522, '1279617741', '和讯房产', 'http://house.hexun.com/', 0, 0, 0, 1040, 0, 1, 0, NULL, 10, '', ''),
(523, '1279617741', '九九房产网', 'http://www.99fang.com/', 0, 0, 0, 1040, 0, 1, 1299162842, NULL, 11, '', ''),
(524, '1279617741', '房老大', 'http://www.foloda.com/', 0, 0, 0, 1040, 0, 1, 0, NULL, 12, '', ''),
(525, '1279617741', '全房网', 'http://tj.allfang.com/', 0, 0, 0, 1040, 0, 1, 1300674199, NULL, 13, '', ''),
(526, '1279617741', '大中华地产', 'http://re.icxo.com', 0, 0, 0, 1040, 0, 1, 0, NULL, 14, '', ''),
(527, '1279617741', '易居网', 'http://www.eeju.com/', 0, 0, 0, 1040, 0, 1, 0, NULL, 15, '', ''),
(528, '1279617741', '人民网房产', 'http://house.people.com.cn/', 0, 0, 0, 1040, 0, 1, 0, NULL, 16, '', ''),
(529, '1279617741', '21CN房产', 'http://house.21cn.com/', 0, 0, 0, 1040, 0, 1, 0, NULL, 17, '', ''),
(530, '1279617741', '房王网', 'http://www.ihouseking.com', 0, 0, 0, 1040, 0, 1, 0, NULL, 18, '', ''),
(531, '1279617741', '我来房产网', 'http://www.wolai.com/', 0, 0, 0, 1040, 0, 1, 0, NULL, 19, '', ''),
(532, '1279617741', '房东网', 'http://www.fundon.cn', 0, 0, 0, 1040, 0, 1, 0, NULL, 20, '', ''),
(533, '1279617741', '家和网视频看房', 'http://www.homhow.com/', 0, 0, 0, 1040, 0, 1, 0, NULL, 21, '', ''),
(534, '1279617741', '易易网', 'http://www.yaoee.com', 0, 0, 0, 1040, 0, 1, 0, NULL, 22, '', ''),
(535, '1279617741', '房产超市网', 'http://www.fccs.com', 0, 0, 0, 1040, 0, 1, 0, NULL, 23, '', ''),
(536, '1279617741', '房途网', 'http://www.fangtoo.com', 0, 0, 0, 1040, 0, 1, 0, NULL, 24, '', ''),
(537, '1279617741', '安居客租房二手房', 'http://www.anjuke.com/', 0, 0, 0, 1040, 0, 1, 0, NULL, 25, '', ''),
(538, '1279617741', '装修图满多', 'http://www.tumanduo.com', 0, 0, 0, 1041, 0, 1, 0, NULL, 1, '', ''),
(539, '1279617741', '搜房装修家居网', 'http://home.soufun.com/', 0, 0, 0, 1041, 0, 1, 0, NULL, 2, '', ''),
(540, '1279617741', '焦点装修家居网', 'http://home.focus.cn', 0, 0, 0, 1041, 0, 1, 0, NULL, 3, '', ''),
(541, '1279617741', '和家网', 'http://www.51hejia.com/', 0, 0, 0, 1041, 0, 1, 0, NULL, 4, '', ''),
(542, '1279617741', '新浪装修家居网', 'http://jiaju.sina.com.cn/', 0, 0, 0, 1041, 0, 1, 1300674217, NULL, 6, '', ''),
(543, '1279617741', '颐家家居网', 'http://www.e-jjj.com/', 0, 0, 0, 1041, 0, 1, 0, NULL, 7, '', ''),
(544, '1279617741', '我爱我家', 'http://www.525j.com.cn/', 0, 0, 0, 1041, 0, 1, 0, NULL, 8, '', ''),
(545, '1279617741', '中国智能家居网', 'http://www.smarthomecn.com/', 0, 0, 0, 1041, 0, 1, 0, NULL, 9, '', ''),
(546, '1279617741', '家天下', 'http://www.jiatx.com', 1, 0, 0, 1041, 0, 1, 0, NULL, 10, '', ''),
(547, '1279617741', '中国室内设计网', 'http://www.ciid.com.cn', 0, 0, 0, 1041, 0, 1, 0, NULL, 11, '', ''),
(548, '1279617741', '中国地板信息网', 'http://www.flooring.com.cn/', 0, 0, 0, 1041, 0, 1, 1300674245, NULL, 12, '', ''),
(549, '1279617741', '中国装修网', 'http://www.cool-de.com/', 0, 0, 0, 1041, 0, 1, 0, NULL, 13, '', ''),
(550, '1279617741', '香巴拉家居网', 'http://sunbala.cn/ehome/', 0, 0, 0, 1041, 0, 1, 0, NULL, 14, '', ''),
(551, '1279617741', '我饰我家网', 'http://www.5s5j.com/', 0, 0, 0, 1041, 0, 1, 0, NULL, 15, '', ''),
(552, '1279617741', '中装网', 'http://www.roomage.com', 0, 0, 0, 1041, 0, 1, 0, NULL, 16, '', ''),
(553, '1279617741', '装算网', 'http://www.zsuan.com/', 0, 0, 0, 1041, 0, 1, 0, NULL, 17, '', ''),
(554, '1279617741', '喜悦家居网', 'http://www.joyju.com/', 0, 0, 0, 1041, 0, 1, 0, NULL, 18, '', ''),
(555, '1279617741', '装修问答网', 'http://www.zxask.cn', 0, 0, 0, 1041, 0, 1, 0, NULL, 19, '', ''),
(556, '1279617741', 'ABBS建筑论坛', 'http://www.abbs.com.cn/', 0, 0, 0, 1042, 0, 1, 0, NULL, 1, '', ''),
(557, '1279617741', '筑龙网', 'http://www.zhulong.com/', 0, 0, 0, 1042, 0, 1, 0, NULL, 2, '', ''),
(558, '1279617741', '天工网', 'http://www.tgnet.cn/', 0, 0, 0, 1042, 0, 1, 0, NULL, 3, '', ''),
(559, '1279617741', '中国建造师网', 'http://www.coc.gov.cn/', 0, 0, 0, 1042, 0, 1, 0, NULL, 4, '', ''),
(560, '1279617741', '土木在线', 'http://www.co188.com/', 0, 0, 0, 1042, 0, 1, 0, NULL, 5, '', ''),
(561, '1279617741', '房策天下', 'http://www.fdc100.com/', 0, 0, 0, 1042, 0, 1, 0, NULL, 6, '', ''),
(562, '1279617741', '室内人', 'http://www.snren.com/', 0, 0, 0, 1042, 0, 1, 0, NULL, 7, '', ''),
(563, '1279617741', '建E网', 'http://www.justeasy.cn/', 0, 0, 0, 1042, 0, 1, 0, NULL, 8, '', ''),
(564, '1279617741', '太平洋汽车', 'http://www.pcauto.com.cn/', 0, 0, 0, 1043, 0, 1, 1289801512, NULL, 1, '', ''),
(565, '1279617741', '爱卡汽车网', 'http://www.xcar.com.cn/', 0, 0, 0, 1043, 0, 1, 0, NULL, 2, '', ''),
(566, '1279617741', '新浪汽车', 'http://auto.sina.com.cn', 0, 0, 0, 1043, 0, 1, 0, NULL, 3, '', ''),
(567, '1279617741', '中国汽车网', 'http://www.chinacars.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 4, '', ''),
(568, '1279617741', '汽车之家', 'http://www.autohome.com.cn', 0, 0, 0, 1043, 0, 1, 0, NULL, 5, '', ''),
(569, '1279617741', '网上车市', 'http://www.cheshi.com.cn', 0, 0, 0, 1043, 0, 1, 0, NULL, 6, '', ''),
(570, '1279617741', '搜狐汽车', 'http://auto.sohu.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 7, '', ''),
(571, '1279617741', '雅虎汽车', 'http://cn.autos.yahoo.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 8, '', ''),
(572, '1279617741', '腾讯汽车', 'http://auto.qq.com/', 0, 0, 0, 1043, 0, 1, 0, NULL, 9, '', ''),
(573, '1279617741', 'TOM汽车', 'http://auto.tom.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 10, '', ''),
(574, '1279617741', '网易汽车', 'http://auto.163.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 11, '', ''),
(575, '1279617741', '中华网汽车频道', 'http://auto.china.com/zh_cn/', 0, 0, 0, 1043, 0, 1, 0, NULL, 12, '', ''),
(576, '1279617741', '新锐车网', 'http://www.chelink.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 13, '', ''),
(577, '1279617741', '汽车天下', 'http://www.chetx.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 14, '', ''),
(578, '1279617741', '易车网', 'http://www.bitauto.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 15, '', ''),
(579, '1279617741', '环球网汽车', 'http://auto.huanqiu.com/', 0, 0, 0, 1043, 0, 1, 0, NULL, 16, '', ''),
(580, '1279617741', '车盟网', 'http://www.cars.com.cn/', 0, 0, 0, 1043, 0, 1, 0, NULL, 17, '', ''),
(581, '1279617741', '21CN汽车频道', 'http://auto.21cn.com/', 0, 0, 0, 1043, 0, 1, 0, NULL, 18, '', ''),
(582, '1279617741', '万车网', 'http://www.webcars.com.cn/', 0, 0, 0, 1043, 0, 1, 0, NULL, 20, '', ''),
(583, '1279617741', 'CHE168', 'http://www.che168.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 21, '', ''),
(584, '1279617741', '亚讯车网', 'http://www.yescar.cn', 0, 0, 0, 1043, 0, 1, 0, NULL, 22, '', ''),
(585, '1279617741', '猫扑汽车频道', 'http://auto.mop.com/', 0, 0, 0, 1043, 0, 1, 0, NULL, 23, '', ''),
(586, '1279617741', '汽车之友', 'http://www.autofan.com.cn', 0, 0, 0, 1043, 0, 1, 0, NULL, 24, '', ''),
(587, '1279617741', '我爱车', 'http://www.52che.com/', 0, 0, 0, 1043, 0, 1, 0, NULL, 25, '', ''),
(588, '1279617741', '爱意汽车', 'http://www.ieche.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 26, '', ''),
(589, '1279617741', '凤凰网汽车频道', 'http://auto.ifeng.com/', 0, 0, 0, 1043, 0, 1, 0, NULL, 27, '', ''),
(590, '1279617741', '汽车殿堂', 'http://www.car136.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 28, '', ''),
(591, '1279617741', '新车评网', 'http://www.xincheping.com/', 0, 0, 0, 1043, 0, 1, 0, NULL, 29, '', ''),
(592, '1279617741', 'XGO汽车网', 'http://www.xgo.com.cn/', 0, 0, 0, 1043, 0, 1, 0, NULL, 30, '', ''),
(593, '1279617741', '汽车改装网', 'http://www.t139.com', 0, 0, 0, 1043, 0, 1, 0, NULL, 31, '', ''),
(594, '1279617741', '驾校一点通', 'http://www.jxedt.com/', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 1, '', ''),
(595, '1279617741', '驾驶员考试网', 'http://www.jsyks.com/', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 2, '', ''),
(596, '1279617741', '驾驶技巧', 'http://auto.sina.com.cn/using/skill/index.shtml', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 3, '', ''),
(597, '1279617741', '百度知道-购车养车', 'http://zhidao.baidu.com/browse/155', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 4, '', ''),
(598, '1279617741', '驾驶员模拟考试', 'http://kaoshi.jxedt.com/', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 5, '', ''),
(599, '1279617741', '各地交通违章查询', 'http://weizhang.5w.com/', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 6, '', ''),
(600, '1279617741', '改吧', 'http://www.gaibar.com/', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 7, '', ''),
(601, '1279617741', '中国石化加油卡', 'http://www.saclub.com.cn/', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 8, '', ''),
(602, '1279617741', '油耗计算工具', 'http://www.skycn.com/soft/41661.html', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 9, '', ''),
(603, '1279617741', '无敌改装', 'http://bbs.modi-auto.com.cn/', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 10, '', ''),
(604, '1279617741', '汽车投诉网', 'http://www.qctsw.com/', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 11, '', ''),
(605, '1279617741', '汽车摩托车下乡', 'http://qcxx.mof.gov.cn/', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 12, '', ''),
(606, '1279617741', '汽车标志', 'http://www.che168.com/brand_list.htm', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 13, '', ''),
(607, '1279617741', '道路交通安全法', 'http://wenku.baidu.com/view/8076d87101f69e3143329474.html', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 14, '', ''),
(608, '1279617741', '交通标志大全', 'http://wenku.baidu.com/view/580a06c24028915f804dc234.html', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 15, '', ''),
(609, '1279617741', '车贷计算器', 'http://car.bitauto.com/qichedaikuanjisuanqi/', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 16, '', ''),
(610, '1279617741', '中国汽车影音网', 'http://www.carcav.com/', 0, 0, 0, 1044, 0, 1, 1289715193, NULL, 17, '', ''),
(611, '1279617741', '太平洋汽车论坛', 'http://autobbs.pconline.com.cn/', 0, 0, 0, 1045, 0, 1, 0, NULL, 1, '', ''),
(612, '1279617741', '爱卡汽车俱乐部', 'http://www.xcar.com.cn/b/104/', 1, 0, 0, 1045, 0, 1, 0, NULL, 2, '', ''),
(613, '1279617741', '新浪汽车社区', 'http://auto.sina.com.cn/shequ/', 0, 0, 0, 1045, 0, 1, 0, NULL, 3, '', ''),
(614, '1279617741', 'Tom汽车论坛', 'http://club.auto.tom.com/', 0, 0, 0, 1045, 0, 1, 0, NULL, 4, '', ''),
(615, '1279617741', '汽车点评网', 'http://www.xche.com.cn/', 0, 0, 0, 1045, 0, 1, 0, NULL, 5, '', ''),
(616, '1279617741', '我车俱乐部', 'http://www.5qiche.com/', 0, 0, 0, 1045, 0, 1, 0, NULL, 6, '', ''),
(617, '1279617741', '网上车市汽车社区', 'http://bbs.cheshi.com.cn/', 0, 0, 0, 1045, 0, 1, 0, NULL, 7, '', ''),
(618, '1279617741', '汽车之家社区', 'http://club.autohome.com.cn/', 0, 0, 0, 1045, 0, 1, 0, NULL, 8, '', ''),
(619, '1279617741', '汽车天下论坛', 'http://bbs.chetx.com/', 0, 0, 0, 1045, 0, 1, 0, NULL, 9, '', ''),
(620, '1279617741', '越野ｅ族', 'http://bbs.fblife.com/', 0, 0, 0, 1045, 0, 1, 0, NULL, 10, '', ''),
(621, '1279617741', 'Google地图', 'http://ditu.google.cn/maps?hl=zh-CN&tab=Ul', 0, 0, 0, 1046, 0, 1, 1289801590, NULL, 1, '', ''),
(622, '1279617741', '百度地图搜索', 'http://map.baidu.com/', 0, 0, 0, 1046, 0, 1, 0, NULL, 2, '', ''),
(623, '1279617741', '城市吧三维实景地图', 'http://www.city8.com/', 0, 0, 0, 1046, 0, 1, 0, NULL, 3, '', ''),
(624, '1279617741', '我要地图', 'http://www.51ditu.com/', 0, 0, 0, 1046, 0, 1, 0, NULL, 4, '', ''),
(625, '1279617741', '中华地图网', 'http://www.hua2.com/', 0, 0, 0, 1046, 0, 1, 0, NULL, 6, '', ''),
(626, '1279617741', 'Mapbar图吧', 'http://www.mapbar.com/', 0, 0, 0, 1046, 0, 1, 0, NULL, 7, '', ''),
(627, '1279617741', '搜狗地图搜索', 'http://map.sogou.com/', 0, 0, 0, 1046, 0, 1, 0, NULL, 7, '', ''),
(628, '1279617741', 'Mapabc图盟', 'http://www.mapabc.com/', 0, 0, 0, 1046, 0, 1, 0, NULL, 9, '', ''),
(629, '1279617741', 'E都市-三维地图', 'http://www.edushi.com/', 0, 0, 0, 1046, 0, 1, 0, NULL, 10, '', ''),
(630, '1279617741', '我爱地图网', 'http://www.52maps.com', 0, 0, 0, 1046, 0, 1, 0, NULL, 11, '', ''),
(631, '1279617741', '列车时刻查询', 'http://lieche.5w.com/', 0, 0, 0, 1047, 0, 1, 0, NULL, 1, '', ''),
(632, '1279617741', 'mapbar公交查询', 'http://bus.mapbar.com/', 0, 0, 0, 1047, 0, 1, 0, NULL, 2, '', ''),
(633, '1279617741', '铁流网', 'http://www.tieliu.com.cn/', 0, 0, 0, 1047, 0, 1, 0, NULL, 2, '', ''),
(634, '1279617741', '交通部', 'http://www.moc.gov.cn/', 0, 0, 0, 1047, 0, 1, 0, NULL, 3, '', ''),
(635, '1279617741', '公路信息服务网', 'http://www.chinahighway.gov.cn/', 0, 0, 0, 1047, 0, 1, 0, NULL, 4, '', ''),
(636, '1279617741', '北京地铁', 'http://www.bjsubway.com/', 0, 0, 0, 1047, 0, 1, 0, NULL, 5, '', ''),
(637, '1279617741', '广州地铁', 'http://www.gzmtr.com/', 0, 0, 0, 1047, 0, 1, 0, NULL, 6, '', ''),
(638, '1279617741', '航班查询', 'http://www.qunar.com/', 0, 0, 0, 1047, 0, 1, 0, NULL, 7, '', ''),
(639, '1279617741', '上海地铁', 'http://www.shmetro.com/', 0, 0, 0, 1047, 0, 1, 0, NULL, 8, '', ''),
(640, '1279617741', '交通违章查询', 'http://weizhang.5w.com/', 0, 0, 0, 1047, 0, 1, 0, NULL, 10, '', ''),
(641, '1279617741', '厦门航空', 'http://www.xiamenair.com.cn/', 0, 0, 0, 1048, 0, 1, 0, NULL, 1, '', ''),
(642, '1279617741', '东方航空', 'http://www.ce-air.com/', 0, 0, 0, 1048, 0, 1, 0, NULL, 2, '', ''),
(643, '1279617741', '深圳航空', 'http://www.shenzhenair.com/', 0, 0, 0, 1048, 0, 1, 0, NULL, 3, '', ''),
(644, '1279617741', '春秋航空', 'http://www.china-sss.com/', 0, 0, 0, 1048, 0, 1, 0, NULL, 4, '', ''),
(645, '1279617741', '四川航空', 'http://www.scal.com.cn/', 0, 0, 0, 1048, 0, 1, 0, NULL, 5, '', ''),
(646, '1279617741', '民航资源网', 'http://www.carnoc.com/', 0, 0, 0, 1048, 0, 1, 0, NULL, 6, '', ''),
(647, '1279617741', '上海航空公司', 'http://www.shanghai-air.com/', 0, 0, 0, 1048, 0, 1, 0, NULL, 7, '', ''),
(648, '1279617741', '海南航空', 'http://www.hnair.com/', 0, 0, 0, 1048, 0, 1, 0, NULL, 8, '', ''),
(649, '1279617741', '南方航空', 'http://www.cs-air.com/', 0, 0, 0, 1048, 0, 1, 0, NULL, 9, '', ''),
(650, '1279617741', '中国国际航空公司', 'http://www.airchina.com.cn/', 0, 0, 0, 1048, 0, 1, 0, NULL, 10, '', ''),
(651, '1279617741', '海子铁路网', 'http://bbs.hasea.com/', 0, 0, 0, 1049, 0, 1, 0, NULL, 1, '', ''),
(652, '1279617741', '上海铁路局', 'http://www.shrail.com/', 0, 0, 0, 1049, 0, 1, 0, NULL, 2, '', ''),
(653, '1279617741', '铁路在线', 'http://bbs.ourail.com/', 0, 0, 0, 1049, 0, 1, 0, NULL, 3, '', ''),
(654, '1279617741', '中国铁道论坛', 'http://bbs.railcn.net/', 0, 0, 0, 1049, 0, 1, 0, NULL, 4, '', ''),
(655, '1279617741', '武汉铁路局', 'http://www.whrailway.cn/', 0, 0, 0, 1049, 0, 1, 0, NULL, 5, '', ''),
(656, '1279617741', '郑州火车站', 'http://www.zzhcz.com/', 0, 0, 0, 1049, 0, 1, 0, NULL, 6, '', ''),
(657, '1279617741', '神州租车', 'http://www.rentauto.net/', 0, 0, 0, 1050, 0, 1, 0, NULL, 1, '', ''),
(658, '1279617741', '大众点评网', 'http://www.dianping.com/', 0, 0, 0, 1051, 0, 1, 0, NULL, 1, '', ''),
(659, '1279617741', '美食天下', 'http://www.meishichina.com/', 0, 0, 0, 1051, 0, 1, 0, NULL, 2, '', ''),
(660, '1279617741', '饭统网', 'http://p.yiqifa.com/c?s=5769343b&amp;w=220184&amp;c=4373&amp;i=9482&amp;l=0&amp;e=&amp;t=http://tuan.fantong.com/23/1/cps', 0, 0, 0, 1051, 0, 1, 0, NULL, 3, '', ''),
(661, '1279617741', '贝太厨房', 'http://www.bettyskitchen.com.cn/', 0, 0, 0, 1051, 0, 1, 0, NULL, 4, '', ''),
(662, '1279617741', '中华美食网', 'http://www.zhms.cn/', 0, 0, 0, 1051, 0, 1, 0, NULL, 5, '', ''),
(663, '1279617741', '天天营养网', 'http://www.51ttyy.com/', 0, 0, 0, 1051, 0, 1, 0, NULL, 6, '', ''),
(664, '1279617741', '雅虎口碑网-餐饮休闲', 'http://koubei.com/cate', 0, 0, 0, 1051, 0, 1, 0, NULL, 7, '', ''),
(665, '1279617741', '新浪美食', 'http://eat.sina.com.cn/', 0, 0, 0, 1051, 0, 1, 0, NULL, 8, '', ''),
(666, '1279617741', '搜狐吃喝', 'http://chihe.sohu.com/', 0, 0, 0, 1051, 0, 1, 0, NULL, 9, '', ''),
(667, '1279617741', '39健康饮食频道', 'http://food.39.net/', 0, 0, 0, 1051, 0, 1, 0, NULL, 10, '', ''),
(668, '1279617741', '好心情美食站', 'http://www.goodmood.com.cn/food/', 0, 0, 0, 1051, 0, 1, 0, NULL, 11, '', ''),
(669, '1279617741', 'POCO中国美食网', 'http://food.poco.cn/', 0, 0, 0, 1051, 0, 1, 0, NULL, 12, '', ''),
(670, '1279617741', '天下美食', 'http://www.foood.com.cn/', 0, 0, 0, 1051, 0, 1, 0, NULL, 13, '', ''),
(671, '1279617741', '咕嘟妈咪', 'http://www.gudumami.cn/', 0, 0, 0, 1051, 0, 1, 0, NULL, 14, '', ''),
(672, '1279617741', '食品价格查询网', 'http://search.foodqs.com/pr/', 1, 0, 0, 1051, 0, 1, 0, NULL, 15, '', ''),
(673, '1279617741', '营养成分查询', 'http://www.tnbway.com/tools/diet/', 0, 0, 0, 1051, 0, 1, 0, NULL, 16, '', ''),
(674, '1279617741', '名厨网', 'http://www.greatchef.com.cn', 0, 0, 0, 1051, 0, 1, 0, NULL, 17, '', ''),
(675, '1279617741', '豆果美食菜谱', 'http://www.douguo.com/', 0, 0, 0, 1051, 0, 1, 0, NULL, 18, '', ''),
(676, '1279617741', '美食杰', 'http://www.meishij.net', 0, 0, 0, 1051, 0, 1, 0, NULL, 19, '', ''),
(677, '1279617741', '麦当劳电子优惠券', 'http://www.mcdonalds.com.cn/coupon/cp.asp', 0, 0, 0, 1052, 0, 1, 0, NULL, 1, '', ''),
(678, '1279617741', '肯德基优惠券', 'http://www.kfc.com.cn/kfccda/', 0, 0, 0, 1052, 0, 1, 0, NULL, 2, '', ''),
(679, '1279617741', '必胜客优惠券', 'http://www.phdelivery.com.cn/', 0, 0, 0, 1052, 0, 1, 0, NULL, 3, '', ''),
(680, '1279617741', '肯德基宅急送', 'http://www.4008823823.com.cn/', 0, 0, 0, 1052, 0, 1, 0, NULL, 4, '', ''),
(681, '1279617741', '必胜宅急送', 'http://www.phdelivery.com.cn/', 0, 0, 0, 1052, 0, 1, 0, NULL, 5, '', ''),
(682, '1279617741', '39健康网', 'http://www.39.net', 0, 0, 0, 1053, 0, 1, 0, NULL, 1, '', ''),
(683, '1279617741', '搜狐健康', 'http://health.sohu.com', 0, 0, 0, 1053, 0, 1, 0, NULL, 2, '', ''),
(684, '1279617741', '中国健康网', 'http://www.healthoo.com/', 0, 0, 0, 1053, 0, 1, 0, NULL, 3, '', ''),
(685, '1279617741', '飞华健康网', 'http://www.fh21.com.cn/', 0, 0, 0, 1053, 0, 1, 0, NULL, 4, '', ''),
(686, '1279617741', '健康120', 'http://www.7120.com/', 0, 0, 0, 1053, 0, 1, 0, NULL, 6, '', ''),
(687, '1279617741', '新华网健康', 'http://www.xinhuanet.com/health/', 0, 0, 0, 1053, 0, 1, 0, NULL, 7, '', ''),
(688, '1279617741', '中华网健康', 'http://health.china.com/', 0, 0, 0, 1053, 0, 1, 0, NULL, 8, '', ''),
(689, '1279617741', '人民网健康', 'http://health.people.com.cn/', 0, 0, 0, 1053, 0, 1, 0, NULL, 9, '', ''),
(690, '1279617741', '新浪健康', 'http://news.sina.com.cn/health/', 0, 0, 0, 1053, 0, 1, 0, NULL, 10, '', ''),
(691, '1279617741', '康贝网', 'http://www.kb120.com/', 0, 0, 0, 1053, 0, 1, 0, NULL, 11, '', ''),
(692, '1279617741', '千龙健康', 'http://health.qianlong.com', 0, 0, 0, 1053, 0, 1, 0, NULL, 12, '', ''),
(693, '1279617741', '中国心理学门户', 'http://www.nlp.cn/', 0, 0, 0, 1053, 0, 1, 0, NULL, 13, '', ''),
(694, '1279617741', '康易网', 'http://www.511511.com', 0, 0, 0, 1053, 0, 1, 0, NULL, 14, '', ''),
(695, '1279617741', '健康时报', 'http://www.jksb.com.cn', 0, 0, 0, 1053, 0, 1, 0, NULL, 15, '', ''),
(696, '1279617741', '全民健康网', 'http://www.qm120.com/', 0, 0, 0, 1053, 0, 1, 0, NULL, 16, '', ''),
(697, '1279617741', '吾健吾康', 'http://www.5j5k.com/', 0, 0, 0, 1053, 0, 1, 0, NULL, 17, '', ''),
(698, '1279617741', '健康服务导航', 'http://www.haodf.com/', 0, 0, 0, 1053, 0, 1, 0, NULL, 18, '', ''),
(699, '1279617741', '爱丽健康', 'http://www.27.cn/nxjk/index.html', 0, 0, 0, 1053, 0, 1, 0, NULL, 19, '', ''),
(700, '1279617741', '久久健康网', 'http://www.9939.com', 0, 0, 0, 1053, 0, 1, 0, NULL, 20, '', ''),
(701, '1279617741', '39健康社区', 'http://bbs.39.net/', 0, 0, 0, 1054, 0, 1, 0, NULL, 1, '', ''),
(702, '1279617741', '糖尿病论坛', 'http://bbs.tnbz.com/', 0, 0, 0, 1054, 0, 1, 0, NULL, 2, '', ''),
(703, '1279617741', '搜狐健康社区', 'http://club.health.sohu.com/', 0, 0, 0, 1054, 0, 1, 0, NULL, 3, '', ''),
(704, '1279617741', '马悦凌健康养生网', 'http://www.mayueling.com/', 0, 0, 0, 1054, 0, 1, 0, NULL, 4, '', ''),
(705, '1279617741', '牙套之家', 'http://www.yataohome.com/', 0, 0, 0, 1054, 0, 1, 0, NULL, 5, '', ''),
(706, '1279617741', '肝胆相照', 'http://www.hbvhbv.com/', 0, 0, 0, 1054, 0, 1, 0, NULL, 6, '', ''),
(707, '1279617741', '39健康问答', 'http://ask.39.net/', 0, 0, 0, 1054, 0, 1, 0, NULL, 7, '', ''),
(708, '1279617741', '药房网', 'http://www.yaofang.cn/', 0, 0, 0, 1055, 0, 1, 0, NULL, 1, '', ''),
(709, '1279617741', '金象大药房', 'http://www.jxdyf.com/', 0, 0, 0, 1055, 0, 1, 0, NULL, 2, '', ''),
(710, '1279617741', '上海药房网', 'http://www.818shyf.com/', 0, 0, 0, 1055, 0, 1, 0, NULL, 3, '', ''),
(711, '1279617741', '导药网', 'http://www.daoyao.com/', 0, 0, 0, 1055, 0, 1, 0, NULL, 4, '', ''),
(712, '1279617741', '健客网', 'http://www.jianke.com/', 0, 0, 0, 1055, 0, 1, 0, NULL, 5, '', ''),
(713, '1279617741', '中国宠物网', 'http://www.chinapet.net/', 0, 0, 0, 1057, 0, 1, 0, NULL, 1, '', ''),
(714, '1279617741', '宠物中国', 'http://www.chinapet.com/', 0, 0, 0, 1057, 0, 1, 0, NULL, 2, '', ''),
(715, '1279617741', '中华宠物网', 'http://b.cnhhcw.com/', 0, 0, 0, 1057, 0, 1, 0, NULL, 3, '', ''),
(716, '1279617741', '海网宠物', 'http://www.hainet.cn/', 0, 0, 0, 1057, 0, 1, 0, NULL, 4, '', ''),
(717, '1279617741', '新浪宠物', 'http://pet.sina.com.cn/', 0, 0, 0, 1057, 0, 1, 0, NULL, 5, '', ''),
(718, '1279617741', '宠物之家', 'http://www.mypethome.com/', 0, 0, 0, 1057, 0, 1, 0, NULL, 6, '', ''),
(719, '1279617741', '宠物王', 'http://www.petking.cn/', 0, 0, 0, 1057, 0, 1, 0, NULL, 7, '', ''),
(720, '1279617741', '中国宠物网', 'http://www.chinapet.net', 0, 0, 0, 1057, 0, 1, 0, NULL, 8, '', ''),
(721, '1279617741', '宠趣网', 'http://www.chongqu.com/', 1, 0, 0, 1057, 0, 1, 0, NULL, 9, '', ''),
(722, '1279617741', '天天宠物网', 'http://www.ttpet.com/', 0, 0, 0, 1057, 0, 1, 0, NULL, 10, '', ''),
(723, '1279617741', 'POCO宠物网', 'http://pet.poco.cn/', 0, 0, 0, 1057, 0, 1, 0, NULL, 10, '', ''),
(724, '1279617741', '一起遛宠物网', 'http://www.176pet.com', 0, 0, 0, 1057, 0, 1, 0, NULL, 11, '', ''),
(725, '1279617741', '偶偶宠物网', 'http://www.oopet.com', 0, 0, 0, 1057, 0, 1, 0, NULL, 12, '', ''),
(726, '1279617741', '99pet宠物世界', 'http://www.99pet.com/', 0, 0, 0, 1057, 0, 1, 0, NULL, 13, '', ''),
(727, '1279617741', '中国宠物论坛', 'http://www.pet86.com', 0, 0, 0, 1057, 0, 1, 0, NULL, 14, '', ''),
(728, '1279617741', '中国名犬网', 'http://www.cndog.net/', 0, 0, 0, 1058, 0, 1, 0, NULL, 1, '', ''),
(729, '1279617741', '狗民网', 'http://www.goumin.com/', 0, 0, 0, 1058, 0, 1, 0, NULL, 2, '', ''),
(730, '1279617741', '爱狗网', 'http://www.aigou.com/', 0, 0, 0, 1058, 0, 1, 0, NULL, 3, '', ''),
(731, '1279617741', '搜狗天下', 'http://sougou.com', 0, 0, 0, 1058, 0, 1, 0, NULL, 4, '', ''),
(732, '1279617741', '搜搜狗网', 'http://www.sosgou.com', 0, 0, 0, 1058, 0, 1, 0, NULL, 5, '', ''),
(733, '1279617741', '中华藏獒网', 'http://c.cnhhcw.com/', 0, 0, 0, 1058, 0, 1, 0, NULL, 6, '', ''),
(734, '1279617741', '藏獒信息网论坛', 'http://bbs.zangao123.com', 0, 0, 0, 1058, 0, 1, 0, NULL, 7, '', ''),
(735, '1279617741', '中国警犬网', 'http://www.policedog.com.cn/', 0, 0, 0, 1058, 0, 1, 0, NULL, 8, '', ''),
(736, '1279617741', '猛犬俱乐部', 'http://www.bandog.cn/', 0, 0, 0, 1058, 0, 1, 0, NULL, 9, '', ''),
(737, '1279617741', '幸运土猫', 'http://www.luckycats.net', 0, 0, 0, 1058, 0, 1, 0, NULL, 10, '', ''),
(738, '1279617741', '搜鱼网', 'http://www.fish-soso.com/', 0, 0, 0, 1059, 0, 1, 0, NULL, 1, '', ''),
(739, '1279617741', '海网-水族之窗', 'http://fish.hainet.cn/', 0, 0, 0, 1059, 0, 1, 0, NULL, 2, '', ''),
(740, '1279617741', '中国宠物水族行业网', 'http://cn.chinapets.com/', 0, 0, 0, 1059, 0, 1, 0, NULL, 3, '', ''),
(741, '1279617741', '中国兰寿网', 'http://www.lanshou.net/index.php', 0, 0, 0, 1059, 0, 1, 0, NULL, 4, '', ''),
(742, '1279617741', '中国锦鲤俱乐部', 'http://bbs.koiclub.net/', 0, 0, 0, 1059, 0, 1, 0, NULL, 5, '', ''),
(743, '1279617741', '中国钓鱼频道', 'http://www.chinafishtv.com/index.asp', 0, 0, 0, 1059, 0, 1, 0, NULL, 6, '', ''),
(744, '1279617741', '贼喜欢罗汉鱼', 'http://www.zeixihuan.com/index.php', 0, 0, 0, 1059, 0, 1, 0, NULL, 7, '', ''),
(745, '1279617741', '罗汉鱼天下', 'http://bbs.myluohan.com/', 0, 0, 0, 1059, 0, 1, 0, NULL, 8, '', ''),
(746, '1279617741', '观赏鱼之家', 'http://bbs.cnfish.com/', 0, 0, 0, 1059, 0, 1, 0, NULL, 9, '', ''),
(747, '1279617741', '龙鱼之家', 'http://www.arowanahome.com/', 0, 0, 0, 1059, 0, 1, 0, NULL, 10, '', ''),
(748, '1279617741', '龟友之家', 'http://www.cngui.com/', 0, 0, 0, 1059, 0, 1, 0, NULL, 11, '', ''),
(749, '1279617741', '灵龟之家两爬论坛', 'http://www.reptilesworld.com/bbs/index.asp', 0, 0, 0, 1059, 0, 1, 0, NULL, 12, '', ''),
(750, '1279617741', '壹升鱼水族部落', 'http://www.afish.cn/', 0, 0, 0, 1059, 0, 1, 0, NULL, 13, '', ''),
(751, '1279617741', '巴西龟乐园', 'http://www.bxgly.com', 0, 0, 0, 1059, 0, 1, 0, NULL, 14, '', ''),
(752, '1279617741', 'CTA南美水族论坛', 'http://www.tropica.cn/bbs/', 0, 0, 0, 1059, 0, 1, 0, NULL, 15, '', ''),
(753, '1279617741', '中国花卉网', 'http://www.china-flower.com/', 0, 0, 0, 1060, 0, 1, 0, NULL, 1, '', ''),
(754, '1279617741', '花卉世界网', 'http://www.flowerworld.com.cn/', 0, 0, 0, 1060, 0, 1, 0, NULL, 2, '', ''),
(755, '1279617741', '中国花卉园艺在线', 'http://www.21yyw.com/', 0, 0, 0, 1060, 0, 1, 0, NULL, 3, '', ''),
(756, '1279617741', '花卉中国', 'http://www.flowerchina.net/', 0, 0, 0, 1060, 0, 1, 0, NULL, 4, '', ''),
(757, '1279617741', '中国花卉报', 'http://www.china-flower.com', 0, 0, 0, 1060, 0, 1, 0, NULL, 5, '', ''),
(758, '1279617741', '藏花阁', 'http://bbs.mychg.org/', 0, 0, 0, 1060, 0, 1, 0, NULL, 6, '', ''),
(759, '1279617741', '园林花卉网', 'http://www.yuanlin.com.cn', 0, 0, 0, 1060, 0, 1, 0, NULL, 7, '', ''),
(760, '1279617741', '中国兰花网', 'http://www.hainet.cn/orchid/', 0, 0, 0, 1060, 0, 1, 0, NULL, 8, '', ''),
(761, '1279617741', '花卉图片网', 'http://www.fpcn.net/', 0, 0, 0, 1060, 0, 1, 0, NULL, 9, '', ''),
(762, '1279617741', '亚洲动物基金会中文', 'http://www.animalsasia.org/', 0, 0, 0, 1061, 0, 1, 0, NULL, 1, '', ''),
(763, '1279617741', '中国野生动物保护协会', 'http://www.cwca.org.cn/', 0, 0, 0, 1061, 0, 1, 0, NULL, 2, '', ''),
(764, '1279617741', '中国小动物保护协会', 'http://www.csapa.org/', 0, 0, 0, 1061, 0, 1, 0, NULL, 3, '', ''),
(765, '1279617741', '世界自然基金会', 'http://www.wwf.ch/', 0, 0, 0, 1061, 0, 1, 0, NULL, 4, '', ''),
(766, '1279617741', '湿地中国', 'http://www.shidi.org/', 0, 0, 0, 1061, 0, 1, 0, NULL, 5, '', ''),
(767, '1279617741', '爱尼宠物认养', 'http://i.ani8.com/', 0, 0, 0, 1061, 0, 1, 0, NULL, 6, '', ''),
(768, '1279617741', '爱护动物协会', 'http://www.spca.org.hk/', 0, 0, 0, 1061, 0, 1, 0, NULL, 7, '', ''),
(769, '1279617741', 'Best Friends', 'http://www.bestfriends.org/', 0, 0, 0, 1061, 0, 1, 0, NULL, 8, '', ''),
(770, '1279617741', '中国信鸽信息网', 'http://www.chinaxinge.com/', 0, 0, 0, 1061, 0, 1, 0, NULL, 9, '', ''),
(771, '1279617741', '青鸟社区', 'http://bbs.18888.com/', 0, 0, 0, 1061, 0, 1, 0, NULL, 10, '', ''),
(772, '1279617741', '全球赛鸽资讯网', 'http://www.hpw-js.com/', 0, 0, 0, 1061, 0, 1, 0, NULL, 11, '', ''),
(773, '1279617741', '瑞丽女性网', 'http://www.rayli.com.cn/', 0, 0, 0, 1062, 0, 1, 0, NULL, 1, '', ''),
(774, '1279617741', '太平洋时尚女性', 'http://www.pclady.com.cn', 0, 0, 0, 1062, 0, 1, 0, NULL, 2, '', ''),
(775, '1279617741', '爱丽女性网', 'http://www.27.cn/', 0, 0, 0, 1062, 0, 1, 0, NULL, 3, '', ''),
(776, '1279617741', '腾讯女性', 'http://lady.qq.com/', 0, 0, 0, 1062, 0, 1, 0, NULL, 4, '', ''),
(777, '1279617741', 'TOM女性', 'http://lady.tom.com/', 0, 0, 0, 1062, 0, 1, 0, NULL, 5, '', ''),
(778, '1279617741', '新浪女性', 'http://eladies.sina.com.cn/', 0, 0, 0, 1062, 0, 1, 0, NULL, 6, '', ''),
(779, '1279617741', '悦己女性网', 'http://www.self.com.cn/', 0, 0, 0, 1062, 0, 1, 0, NULL, 7, '', ''),
(780, '1279617741', '21CN女人帮', 'http://she.21cn.com', 0, 0, 0, 1062, 0, 1, 0, NULL, 8, '', ''),
(781, '1279617741', '搜狐女人', 'http://women.sohu.com/', 0, 0, 0, 1062, 0, 1, 0, NULL, 9, '', ''),
(782, '1279617741', '网易女人', 'http://lady.163.com/', 0, 0, 0, 1062, 0, 1, 0, NULL, 10, '', ''),
(783, '1279617741', '伊秀女性网', 'http://www.yxlady.com/', 0, 0, 0, 1062, 0, 1, 0, NULL, 11, '', ''),
(784, '1279617741', '爱靓网', 'http://www.2liang.net/', 0, 0, 0, 1062, 0, 1, 0, NULL, 12, '', ''),
(785, '1279617741', 'poco女性频道', 'http://lady.poco.cn/', 0, 0, 0, 1062, 0, 1, 0, NULL, 13, '', ''),
(786, '1279617741', '魅网女性', 'http://www.meyol.com', 0, 0, 0, 1062, 0, 1, 0, NULL, 14, '', ''),
(787, '1279617741', '主妇网', 'http://www.izhufu.com', 0, 0, 0, 1062, 0, 1, 0, NULL, 15, '', ''),
(788, '1279617741', 'elle女性网', 'http://www.ellechina.com/', 0, 0, 0, 1062, 0, 1, 0, NULL, 16, '', ''),
(789, '1279617741', '39健康女性', 'http://woman.39.net/', 0, 0, 0, 1062, 0, 1, 0, NULL, 17, '', ''),
(790, '1279617741', '七月七女性网', 'http://www.7y7.com/index.html', 0, 0, 0, 1062, 0, 1, 0, NULL, 18, '', ''),
(791, '1279617741', '空姐网', 'http://www.kongjie.com/', 0, 0, 0, 1062, 0, 1, 0, NULL, 19, '', ''),
(793, '1279617741', '0nlylady女人志', 'http://www.onlylady.com/', 0, 0, 0, 1062, 0, 1, 0, NULL, 21, '', ''),
(794, '1279617741', '她生活', 'http://www.shelive.net/', 0, 0, 0, 1062, 0, 1, 0, NULL, 22, '', ''),
(795, '1279617741', '新民bella', 'http://www.xmbella.cn/', 0, 0, 0, 1062, 0, 1, 0, NULL, 23, '', ''),
(796, '1279617741', '嘉人网', 'http://www.marieclairechina.com/', 0, 0, 0, 1062, 0, 1, 0, NULL, 24, '', ''),
(797, '1279617741', 'HERS女性网', 'http://www.herschina.com', 0, 0, 0, 1062, 0, 1, 0, NULL, 25, '', ''),
(798, '1279617741', '瑞丽美容频道', 'http://www.rayli.com.cn/beauty/', 0, 0, 0, 1063, 0, 1, 0, NULL, 1, '', ''),
(799, '1279617741', '新浪美容美颜', 'http://eladies.sina.com.cn/beauty/index.shtml', 0, 0, 0, 1063, 0, 1, 0, NULL, 2, '', ''),
(800, '1279617741', '爱丽美容', 'http://www.27.cn/', 0, 0, 0, 1063, 0, 1, 0, NULL, 3, '', ''),
(801, '1279617741', '闺蜜网', 'http://www.kimiss.com', 0, 0, 0, 1063, 0, 1, 0, NULL, 4, '', ''),
(802, '1279617741', '网易美容美体', 'http://lady.163.com/beauty/', 0, 0, 0, 1063, 0, 1, 0, NULL, 5, '', ''),
(803, '1279617741', 'TOM美丽美体', 'http://lady.tom.com/beauty/index.html', 0, 0, 0, 1063, 0, 1, 0, NULL, 6, '', ''),
(804, '1279617741', 'No5化妆品网', 'http://p.yiqifa.com/c?s=f56727e6&w=220184&c=315&i=224&l=0&e=c&t=http://www.no5.com.cn', 0, 0, 0, 1063, 0, 1, 0, NULL, 7, '', ''),
(805, '1279617741', '太平洋女性网-美容', 'http://www.pclady.com.cn/beauty/', 0, 0, 0, 1063, 0, 1, 0, NULL, 8, '', ''),
(806, '1279617741', 'YOKA时尚-美容健康', 'http://www.yoka.com/beauty/', 0, 0, 0, 1063, 0, 1, 0, NULL, 9, '', ''),
(807, '1279617741', '女刊瘦美人女性网', 'http://www.nvkan.com', 0, 0, 0, 1063, 0, 1, 0, NULL, 10, '', ''),
(808, '1279617741', '时尚网-美容频道', 'http://www.trends.com.cn/beauty/', 0, 0, 0, 1063, 0, 1, 0, NULL, 11, '', ''),
(809, '1279617741', '中国国际美容网', 'http://www.prccn.com/', 0, 0, 0, 1063, 0, 1, 0, NULL, 12, '', ''),
(810, '1279617741', '大旗美容', 'http://beauty.daqi.com/', 0, 0, 0, 1063, 0, 1, 0, NULL, 13, '', ''),
(811, '1279617741', '维娜美容网', 'http://www.vina.cn/', 0, 0, 0, 1063, 0, 1, 0, NULL, 14, '', ''),
(813, '1279617741', '美容护肤每日推荐', 'http://www.99meili.com/', 0, 0, 0, 1063, 0, 1, 0, NULL, 16, '', ''),
(814, '1279617741', '果皮网', 'http://www.guopi.com/', 0, 0, 0, 1063, 0, 1, 0, NULL, 17, '', ''),
(815, '1279617741', '唯伊网', 'http://www.weyii.com/', 0, 0, 0, 1063, 0, 1, 0, NULL, 18, '', ''),
(816, '1279617741', '新浪网-男性频道', 'http://eladies.sina.com.cn/man/', 0, 0, 0, 1064, 0, 1, 0, NULL, 1, '', ''),
(817, '1279617741', '男人帮', 'http://www.vmans.com/', 0, 0, 0, 1064, 0, 1, 0, NULL, 2, '', ''),
(818, '1279617741', 'Tom男性部落', 'http://lady.tom.com/man', 0, 0, 0, 1064, 0, 1, 0, NULL, 3, '', ''),
(819, '1279617741', '39健康网-男性', 'http://man.39.net/', 0, 0, 0, 1064, 0, 1, 0, NULL, 4, '', ''),
(820, '1279617741', '男士生活网', 'http://www.menslive.com/', 0, 0, 0, 1064, 0, 1, 0, NULL, 6, '', ''),
(821, '1279617741', '男人频道-YOKA', 'http://www.yoka.com/men/', 0, 0, 0, 1064, 0, 1, 0, NULL, 7, '', ''),
(822, '1279617741', '男性天下', 'http://www.jttop.com/man/', 0, 0, 0, 1064, 0, 1, 0, NULL, 8, '', ''),
(823, '1279617741', '时尚先生网', 'http://www.mister.org.cn/', 0, 0, 0, 1064, 0, 1, 0, NULL, 9, '', ''),
(825, '1279617741', '全型男', 'http://www.allcoolmen.com/', 0, 0, 0, 1064, 0, 1, 0, NULL, 11, '', ''),
(826, '1279617741', '39健康', 'http://sex.39.net/', 0, 0, 0, 1065, 0, 1, 0, NULL, 1, '', ''),
(827, '1279617741', '《家庭医生》性知识', 'http://www.familydoctor.com.cn/SexGarden/', 0, 0, 0, 1065, 0, 1, 0, NULL, 2, '', ''),
(828, '1279617741', '人民网-两性健康', 'http://health.people.com.cn/GB/14744/index.html', 0, 0, 0, 1065, 0, 1, 0, NULL, 3, '', ''),
(829, '1279617741', '放心120两性', 'http://eden.fx120.net/', 0, 0, 0, 1065, 0, 1, 1304071087, NULL, 8, '', ''),
(830, '1279617741', '搜狐健康社区', 'http://club.health.sohu.com/', 1, 0, 0, 1065, 0, 1, 0, NULL, 5, '', ''),
(831, '1279617741', '39两性健康论坛', 'http://bbs.39.net/sex/forum/456-1-1.html', 0, 0, 0, 1065, 0, 1, 0, NULL, 7, '', ''),
(832, '1279617741', '时尚网', 'http://www.trends.com.cn/', 0, 0, 0, 1066, 0, 1, 0, NULL, 1, '', ''),
(833, '1279617741', '凤凰网-时尚', 'http://fashion.ifeng.com/', 0, 0, 0, 1066, 0, 1, 0, NULL, 2, '', ''),
(834, '1279617741', '腾讯-时尚', 'http://luxury.qq.com', 0, 0, 0, 1066, 0, 1, 0, NULL, 3, '', ''),
(835, '1279617741', 'Yoka时尚网', 'http://www.yoka.com/', 0, 0, 0, 1066, 0, 1, 0, NULL, 4, '', ''),
(836, '1279617741', '爱美网', 'http://www.lady8844.com', 0, 0, 0, 1066, 0, 1, 0, NULL, 5, '', ''),
(837, '1279617741', '天极时尚', 'http://fashion.yesky.com/', 0, 0, 0, 1066, 0, 1, 0, NULL, 6, '', ''),
(838, '1279617741', '猫扑-时尚系', 'http://fashion.mop.com/', 0, 0, 0, 1066, 0, 1, 0, NULL, 7, '', ''),
(839, '1279617741', 'ELLE中国', 'http://www.ellechina.com/', 0, 0, 0, 1066, 0, 1, 1289801762, NULL, 8, '', ''),
(840, '1279617741', 'Somode摩得互动', 'http://www.somode.com/', 0, 0, 0, 1066, 0, 1, 0, NULL, 9, '', ''),
(841, '1279617741', '海报时尚网', 'http://www.haibao.tv/', 0, 0, 0, 1066, 0, 1, 0, NULL, 10, '', ''),
(842, '1279617741', '摩登绅士网', 'http://www.mrmodern.com/', 0, 0, 0, 1066, 0, 1, 0, NULL, 11, '', ''),
(843, '1279617741', '爱丽女性网', 'http://www.27.cn/', 0, 0, 0, 1066, 0, 1, 0, NULL, 12, '', ''),
(844, '1279617741', '发型屋', 'http://faxingw.cn', 0, 0, 0, 1066, 0, 1, 0, NULL, 13, '', ''),
(845, '1279617741', '她生活时尚', 'http://www.shelive.net/ChFashion/', 0, 0, 0, 1066, 0, 1, 0, NULL, 14, '', ''),
(846, '1279617741', '薇薇时尚杂志下载', 'http://www.vvshu.com/', 0, 0, 0, 1066, 0, 1, 0, NULL, 15, '', ''),
(847, '1279617741', '世界时装之苑-ELLE', 'http://www.ellechina.com/', 0, 0, 0, 1067, 0, 1, 0, NULL, 1, '', ''),
(848, '1279617741', 'BAZAAR-时尚芭莎', 'http://www.trendsmag.com/trendsmag/bazaar/', 0, 0, 0, 1067, 0, 1, 0, NULL, 2, '', ''),
(849, '1279617741', 'ZCOM-电子杂志', 'http://www.zcom.com/', 0, 0, 0, 1067, 0, 1, 0, NULL, 3, '', ''),
(850, '1279617741', '时尚系列刊物', 'http://www.trendsmag.com/trendsmag/', 0, 0, 0, 1067, 0, 1, 0, NULL, 4, '', ''),
(851, '1279617741', '时尚先生', 'http://esquire.trends.com.cn/', 0, 0, 0, 1067, 0, 1, 0, NULL, 5, '', ''),
(852, '1279617741', '香港JESSICA', 'http://www.jessicahk.com/', 0, 0, 0, 1067, 0, 1, 0, NULL, 6, '', ''),
(853, '1279617741', '大都市杂志', 'http://www.metropolis-mag.com/', 0, 0, 0, 1067, 0, 1, 0, NULL, 7, '', ''),
(854, '1279617741', '时尚.娇点', 'http://www.trendsmag.com/trendsmag/cosmogirl/', 0, 0, 0, 1067, 0, 1, 0, NULL, 8, '', ''),
(855, '1279617741', '男人时尚网', 'http://www.mensuno.com.tw', 0, 0, 0, 1067, 0, 1, 0, NULL, 9, '', ''),
(856, '1279617741', 'GQ男人网[繁]', 'http://www.gq.com.tw', 0, 0, 0, 1067, 0, 1, 0, NULL, 10, '', ''),
(857, '1279617741', 'Figaro madame[法]', 'http://madame.lefigaro.fr/', 0, 0, 0, 1067, 0, 1, 0, NULL, 11, '', ''),
(858, '1279617741', 'Marie Claire[法]', 'http://www.marieclaire.com/', 0, 0, 0, 1067, 0, 1, 0, NULL, 12, '', ''),
(859, '1279617741', 'FLARE[英]', 'http://www.flare.com/', 0, 0, 0, 1067, 0, 1, 0, NULL, 13, '', ''),
(860, '1279617741', 'Vogue[英]', 'http://www.vogue.co.uk/', 0, 0, 0, 1067, 0, 1, 0, NULL, 14, '', ''),
(861, '1279617741', '新浪-奢华名品', 'http://eladies.sina.com.cn/lux/', 0, 0, 0, 1068, 0, 1, 0, NULL, 1, '', ''),
(862, '1279617741', '搜狐-奢华风尚', 'http://women.sohu.com/luxury/', 0, 0, 0, 1068, 0, 1, 0, NULL, 2, '', ''),
(863, '1279617741', '太平洋女性网-奢华风尚', 'http://luxury.pclady.com.cn/', 0, 0, 0, 1068, 0, 1, 0, NULL, 3, '', ''),
(864, '1279617741', '奢侈报道', 'http://luxury.icxo.com/', 0, 0, 0, 1068, 0, 1, 0, NULL, 4, '', ''),
(865, '1279617741', '风尚中国', 'http://www.voguechinese.com/', 0, 0, 0, 1068, 0, 1, 0, NULL, 5, '', ''),
(866, '1279617741', '新浪亲子中心', 'http://baby.sina.com.cn/', 0, 0, 0, 1069, 0, 1, 0, NULL, 1, '', ''),
(867, '1279617741', 'CCTV少儿频道', 'http://edu.cctv.com/01/index.shtml', 0, 0, 0, 1069, 0, 1, 0, NULL, 2, '', ''),
(868, '1279617741', '太平洋亲子网', 'http://www.pckids.com.cn/', 0, 0, 0, 1069, 0, 1, 0, NULL, 3, '', ''),
(869, '1279617741', '育儿网', 'http://www.ci123.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 4, '', ''),
(870, '1279617741', '中国母亲网', 'http://www.muqin.com.cn/', 0, 0, 0, 1069, 0, 1, 0, NULL, 5, '', ''),
(871, '1279617741', '腾讯儿童', 'http://kid.qq.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 6, '', ''),
(872, '1279617741', '好孩子', 'http://www.goodbaby.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 7, '', ''),
(873, '1279617741', '宝宝树', 'http://www.babytree.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 8, '', ''),
(874, '1279617741', '摇篮网', 'http://www.yaolan.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 9, '', ''),
(875, '1279617741', '妈妈说', 'http://www.0-6.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 10, '', ''),
(876, '1279617741', '9ye育儿园', 'http://www.9ye.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 11, '', ''),
(877, '1279617741', '丫丫网', 'http://www.iyaya.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 12, '', ''),
(878, '1279617741', '小精灵儿童网站', 'http://www.060s.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 13, '', ''),
(879, '1279617741', '趣吧贝贝', 'http://www.78baby.com', 0, 0, 0, 1069, 0, 1, 0, NULL, 14, '', ''),
(880, '1279617741', '播种网', 'http://www.seedit.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 15, '', ''),
(881, '1279617741', '中国少年雏鹰网', 'http://www.chinakids.net.cn/', 0, 0, 0, 1069, 0, 1, 0, NULL, 16, '', ''),
(882, '1279617741', '中国儿童网', 'http://www.chinakids.com.cn/', 0, 0, 0, 1069, 0, 1, 0, NULL, 17, '', ''),
(883, '1279617741', '中国早教网', 'http://www.zaojiao.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 18, '', ''),
(884, '1279617741', '一搜宝宝网', 'http://www.yisou.cc/', 0, 0, 0, 1069, 0, 1, 0, NULL, 20, '', ''),
(885, '1279617741', '小儿按摩网', 'http://www.12anmo.cn', 1, 0, 0, 1069, 0, 1, 0, NULL, 21, '', ''),
(886, '1279617741', '妈咪宝贝', 'http://www.mumbaby.cn/', 0, 0, 0, 1069, 0, 1, 0, NULL, 22, '', ''),
(887, '1279617741', '宝贝岛', 'http://www.babydao.com/', 0, 0, 0, 1069, 0, 1, 0, NULL, 23, '', ''),
(888, '1279617741', '亲亲宝宝网', 'http://www.qqbaobao.com', 0, 0, 0, 1069, 0, 1, 0, NULL, 24, '', ''),
(889, '1279617741', '爱丽亲子频道', 'http://www.27.cn/qinzi/index.html/', 0, 0, 0, 1069, 0, 1, 0, NULL, 25, '', ''),
(890, '1279617741', '中华网幼儿频道', 'http://baobao.china.com/zh_cn/parent/index.html', 0, 0, 0, 1069, 0, 1, 0, NULL, 26, '', ''),
(891, '1279617741', '新浪亲子中心', 'http://baby.sina.com.cn/', 0, 0, 0, 1070, 0, 1, 0, NULL, 1, '', ''),
(892, '1279617741', '中国母亲网', 'http://www.muqin.com.cn/', 0, 0, 0, 1070, 0, 1, 0, NULL, 2, '', ''),
(893, '1279617741', '太平洋亲子网', 'http://www.pcbaby.com.cn/', 0, 0, 0, 1070, 0, 1, 0, NULL, 3, '', ''),
(894, '1279617741', '中国早教网', 'http://www.zaojiao.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 4, '', ''),
(895, '1279617741', '育婴网', 'http://www.babyschool.com.cn/', 0, 0, 0, 1070, 0, 1, 0, NULL, 5, '', ''),
(896, '1279617741', '少年雏鹰网', 'http://www.chinakids.net.cn/', 0, 0, 0, 1070, 0, 1, 0, NULL, 6, '', ''),
(897, '1279617741', '摇篮网', 'http://www.yaolan.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 7, '', ''),
(898, '1279617741', '亲亲宝贝', 'http://www.qbaobei.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 8, '', ''),
(899, '1279617741', '金苗网', 'http://www.jinmiao.cn/', 0, 0, 0, 1070, 0, 1, 0, NULL, 9, '', ''),
(900, '1279617741', '百家胎教家园', 'http://www.taijiaobb.cn/', 0, 0, 0, 1070, 0, 1, 0, NULL, 10, '', ''),
(901, '1279617741', '趣吧贝贝', 'http://www.78baby.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 11, '', ''),
(902, '1279617741', '爱孕网', 'http://sh.iyun.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 12, '', ''),
(903, '1279617741', '腾讯儿童', 'http://kid.qq.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 13, '', ''),
(904, '1279617741', '童年网', 'http://www.tongnian.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 14, '', ''),
(905, '1279617741', '妈妈100', 'http://www.mama100.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 15, '', ''),
(906, '1279617741', '丫丫网', 'http://www.iyaya.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 16, '', ''),
(907, '1279617741', '宝宝树', 'http://www.babytree.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 17, '', ''),
(908, '1279617741', '妈妈说', 'http://www.0-6.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 18, '', ''),
(909, '1279617741', '育儿网', 'http://www.ci123.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 19, '', ''),
(910, '1279617741', '宝宝中心', 'http://cn.babycenter.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 20, '', ''),
(911, '1279617741', '儿童医院大全', 'http://www.haodf.com/keshi/list.htm#DE4r0u-lSI6Bu44SQTjeOWWDnLVkjst', 0, 0, 0, 1070, 0, 1, 0, NULL, 21, '', ''),
(912, '1279617741', '好孩子', 'http://www.goodbaby.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 22, '', ''),
(913, '1279617741', '播种网', 'http://www.seedit.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 23, '', ''),
(914, '1279617741', '预产期计算器', 'http://baby.sina.com.cn/jj/prem_huli.html', 0, 0, 0, 1070, 0, 1, 0, NULL, 24, '', ''),
(915, '1279617741', '宝宝吧', 'http://www.baobao88.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 25, '', ''),
(916, '1279617741', '中国人幼儿园', 'http://kids.chinaren.com/', 0, 0, 0, 1070, 0, 1, 0, NULL, 26, '', ''),
(917, '1279617741', '新浪亲子论坛', 'http://bbs.baby.sina.com.cn/group.php?tree=0&gid=18', 0, 0, 0, 1071, 0, 1, 0, NULL, 1, '', ''),
(918, '1279617741', '和谐亲子社区', 'http://www.jiahexie.com/', 0, 0, 0, 1071, 0, 1, 0, NULL, 2, '', ''),
(919, '1279617741', '宝宝树-育儿论坛', 'http://www.babytree.com/forum/', 0, 0, 0, 1071, 0, 1, 0, NULL, 3, '', ''),
(920, '1279617741', '搜狐母婴社区', 'http://club.baby.sohu.com/', 0, 0, 0, 1071, 0, 1, 0, NULL, 4, '', ''),
(921, '1279617741', '丫丫社区', 'http://bbs.iyaya.com', 0, 0, 0, 1071, 0, 1, 0, NULL, 5, '', ''),
(922, '1279617741', '中国孕育网论坛', 'http://forum.5721.net/', 0, 0, 0, 1071, 0, 1, 0, NULL, 6, '', ''),
(923, '1279617741', '39育儿论坛', 'http://community.39.net/mainframe.aspx?boardid=72', 0, 0, 0, 1071, 0, 1, 0, NULL, 7, '', ''),
(924, '1279617741', '摇篮网论坛', 'http://bbs.yaolan.com/', 0, 0, 0, 1071, 0, 1, 0, NULL, 8, '', ''),
(925, '1279617741', '广州妈妈网', 'http://www.gzmama.com/index.php', 0, 0, 0, 1071, 0, 1, 0, NULL, 9, '', ''),
(926, '1279617741', '中国网络电视台', 'http://www.cntv.cn/', 0, 0, 0, 1072, 0, 1, 0, NULL, 1, '', ''),
(927, '1279617741', '凤凰直播', 'http://v.ifeng.com/live/', 0, 0, 0, 1072, 0, 1, 0, NULL, 2, '', ''),
(928, '1279617741', 'CCTV搜视指南', 'http://bugu.cntv.cn/column_cctv/index.shtml', 0, 0, 0, 1072, 0, 1, 0, NULL, 3, '', ''),
(929, '1279617741', '电视节目预告', 'http://tvguide.ent.sina.com.cn/', 0, 0, 0, 1072, 0, 1, 0, NULL, 4, '', ''),
(930, '1279617741', '湖南卫视', 'http://www.hunantv.com/', 0, 0, 0, 1072, 0, 1, 0, NULL, 5, '', ''),
(931, '1279617741', '江苏卫视', 'http://www.jstv.com/', 0, 0, 0, 1072, 0, 1, 0, NULL, 6, '', ''),
(932, '1279617741', '北京电视台', 'http://www.btv.com.cn/', 0, 0, 0, 1072, 0, 1, 0, NULL, 7, '', ''),
(933, '1279617741', '山东电视台', 'http://v.iqilu.com/', 0, 0, 0, 1072, 0, 1, 0, NULL, 8, '', ''),
(934, '1279617741', '新浪电视', 'http://ent.sina.com.cn/tv/', 0, 0, 0, 1072, 0, 1, 0, NULL, 9, '', ''),
(935, '1279617741', '搜狐电视', 'http://tv.sohu.com/', 0, 0, 0, 1072, 0, 1, 0, NULL, 10, '', ''),
(936, '1279617741', '东方卫视', 'http://www.dragontv.cn/', 0, 0, 0, 1072, 0, 1, 0, NULL, 11, '', ''),
(937, '1279617741', '浙江卫视', 'http://www.zjstv.com/', 0, 0, 0, 1072, 0, 1, 0, NULL, 12, '', ''),
(938, '1279617741', '安徽卫视', 'http://www.ahtv.cn/', 0, 0, 0, 1072, 0, 1, 0, NULL, 13, '', ''),
(939, '1279617741', '广东卫视', 'http://www.gdtv.com.cn/', 0, 0, 0, 1072, 0, 1, 0, NULL, 14, '', ''),
(940, '1279617741', '星空卫视', 'http://www.xingkong.com.cn/', 0, 0, 0, 1072, 0, 1, 0, NULL, 15, '', ''),
(941, '1279617741', '湖北电视台', 'http://www.hbtv.com.cn/', 0, 0, 0, 1072, 0, 1, 0, NULL, 16, '', ''),
(942, '1279617741', '江西电视台', 'http://www.cjxtv.com/', 0, 0, 0, 1072, 0, 1, 0, NULL, 17, '', ''),
(943, '1279617741', '电视猫', 'http://www.tvmao.com/', 0, 0, 0, 1072, 0, 1, 0, NULL, 18, '', ''),
(944, '1279617741', '热门娱乐节目贴吧', 'http://tieba.baidu.com/f?kw=%D3%E9%C0%D6%BD%DA%C4%BF', 0, 0, 0, 1072, 0, 1, 0, NULL, 19, '', ''),
(945, '1279617741', '在线电台大全', 'http://list.mp3.baidu.com/radio/', 0, 0, 0, 1072, 0, 1, 0, NULL, 20, '', ''),
(946, '1279617741', 'PPS', 'http://www.pps.tv/', 0, 0, 0, 1073, 0, 1, 0, NULL, 1, '', ''),
(947, '1279617741', 'PPTV', 'http://www.pptv.com/', 0, 0, 0, 1073, 0, 1, 0, NULL, 2, '', ''),
(948, '1279617741', 'QQLive', 'http://live.qq.com/', 0, 0, 0, 1073, 0, 1, 0, NULL, 3, '', ''),
(949, '1279617741', 'UUSee', 'http://www.uusee.tv/', 0, 0, 0, 1073, 0, 1, 0, NULL, 4, '', ''),
(950, '1279617741', '非诚勿扰', 'http://video.baidu.com/v?word=%B7%C7%B3%CF%CE%F0%C8%C5&ct=301989888&rn=20&pn=0&db=0&s=0&fbl=800', 0, 0, 0, 1074, 0, 1, 0, NULL, 1, '', ''),
(951, '1279617741', '中国达人秀', 'http://video.baidu.com/v?ct=301989888&rn=20&pn=0&db=0&s=25&word=%D6%D0%B9%FA%B4%EF%C8%CB%D0%E3', 0, 0, 0, 1074, 0, 1, 0, NULL, 2, '', ''),
(952, '1279617741', '快乐大本营', 'http://video.baidu.com/v?word=%BF%EC%C0%D6%B4%F3%B1%BE%D3%AA&ct=301989888&rn=20&pn=0&db=0&s=0&fbl=800', 0, 0, 0, 1074, 0, 1, 0, NULL, 3, '', ''),
(953, '1279617741', '快乐男声', 'http://video.baidu.com/v?word=%BF%EC%C0%D6%C4%D0%C9%F9&ct=301989888&rn=20&pn=0&db=0&s=0&fbl=800', 0, 0, 0, 1074, 0, 1, 0, NULL, 4, '', ''),
(954, '1279617741', '天天向上', 'http://video.baidu.com/v?ct=301989888&rn=20&pn=0&db=0&s=25&word=%CC%EC%CC%EC%CF%F2%C9%CF', 0, 0, 0, 1074, 0, 1, 0, NULL, 5, '', ''),
(955, '1279617741', '幸福魔方', 'http://video.baidu.com/v?ct=301989888&rn=20&pn=0&db=0&s=25&word=%D0%D2%B8%A3%C4%A7%B7%BD', 0, 0, 0, 1074, 0, 1, 0, NULL, 6, '', ''),
(956, '1279617741', '康熙来了', 'http://video.baidu.com/v?word=%BF%B5%CE%F5%C0%B4%C1%CB&ct=301989888&rn=20&pn=0&db=0&s=0&fbl=800', 0, 0, 0, 1074, 0, 1, 0, NULL, 7, '', ''),
(957, '1279617741', '我们约会吧', 'http://video.baidu.com/v?ct=301989888&rn=20&pn=0&db=0&s=25&word=%CE%D2%C3%C7%D4%BC%BB%E1%B0%C9', 0, 0, 0, 1074, 0, 1, 0, NULL, 8, '', ''),
(958, '1279617741', '红楼梦', 'http://www.qiyi.com/dianshiju/xhlm.html', 0, 0, 0, 1075, 0, 1, 0, NULL, 1, '', ''),
(959, '1279617741', '泡沫之夏', 'http://www.qiyi.com/dianshiju/pmzx.html', 0, 0, 0, 1075, 0, 1, 0, NULL, 2, '', ''),
(960, '1279617741', '大丫鬟', 'http://www.qiyi.com/dianshiju/dyh.html', 0, 0, 0, 1075, 0, 1, 0, NULL, 3, '', ''),
(961, '1279617741', '永不消逝的电波', 'http://www.qiyi.com/dianshiju/ybxsddb.html', 0, 0, 0, 1075, 0, 1, 0, NULL, 4, '', ''),
(962, '1279617741', '我的女友是九尾狐', 'http://tv.sohu.com/s2010/wdnysjwh/', 0, 0, 0, 1075, 0, 1, 0, NULL, 5, '', ''),
(963, '1279617741', '雪豹', 'http://www.qiyi.com/dianshiju/xuebao.html', 0, 0, 0, 1075, 0, 1, 0, NULL, 6, '', ''),
(964, '1279617741', '真情错爱', 'http://www.qiyi.com/dianshiju/zqca.html', 0, 0, 0, 1075, 0, 1, 0, NULL, 7, '', ''),
(965, '1279617741', '高粱红了', 'http://www.qiyi.com/dianshiju/glhl.html', 0, 0, 0, 1075, 0, 1, 0, NULL, 8, '', ''),
(966, '1279617741', '中国移动话费查询', 'http://10086.cn/service/quick/index.htm', 0, 0, 0, 1076, 0, 1, 1289801843, NULL, 1, '', ''),
(967, '1279617741', '动感地带', 'http://mzone.139.com/', 0, 0, 0, 1076, 0, 1, 0, NULL, 2, '', ''),
(968, '1279617741', '移动梦网', 'http://www.monternet.com/', 0, 0, 0, 1076, 0, 1, 0, NULL, 3, '', ''),
(969, '1279617741', '互联星空', 'http://www.vnet.cn/', 0, 0, 0, 1076, 0, 1, 0, NULL, 4, '', ''),
(970, '1279617741', '通信产业网', 'http://www.ccidcom.com/', 0, 0, 0, 1076, 0, 1, 0, NULL, 5, '', ''),
(971, '1279617741', '中国通信网', 'http://www.c114.net/', 0, 0, 0, 1076, 0, 1, 0, NULL, 6, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(972, '1279617741', '中国无线论坛', 'http://www.wlanbbs.com/', 0, 0, 0, 1076, 0, 1, 0, NULL, 7, '', ''),
(973, '1279617741', '移动通信论坛', 'http://www.mscbsc.com/bbs/', 0, 0, 0, 1076, 0, 1, 0, NULL, 8, '', ''),
(974, '1279617741', '赛迪通信产业', 'http://comm.ccidnet.com/', 0, 0, 0, 1076, 0, 1, 0, NULL, 9, '', ''),
(975, '1279617741', '比特网通信频道', 'http://telecom.chinabyte.com/', 0, 0, 0, 1076, 0, 1, 0, NULL, 10, '', ''),
(976, '1279617741', '手机之家', 'http://www.imobile.com.cn', 0, 0, 0, 1077, 0, 1, 0, NULL, 1, '', ''),
(977, '1279617741', '太平洋手机频道', 'http://mobile.pconline.com.cn/', 0, 0, 0, 1077, 0, 1, 0, NULL, 2, '', ''),
(978, '1279617741', '友人网', 'http://www.younet.com/', 0, 0, 0, 1077, 0, 1, 0, NULL, 3, '', ''),
(979, '1279617741', '新浪手机频道', 'http://tech.sina.com.cn/mobile/', 0, 0, 0, 1077, 0, 1, 0, NULL, 4, '', ''),
(980, '1279617741', '手机乐园', 'http://www.shouji.com.cn/', 0, 0, 0, 1077, 0, 1, 0, NULL, 5, '', ''),
(981, '1279617741', 'IT168手机', 'http://mobile.it168.com', 0, 0, 0, 1077, 0, 1, 0, NULL, 6, '', ''),
(982, '1279617741', '泡泡手机网', 'http://mobile.pcpop.com/', 0, 0, 0, 1077, 0, 1, 0, NULL, 7, '', ''),
(983, '1279617741', '腾讯手机频道', 'http://digi.tech.qq.com/mobile/', 0, 0, 0, 1077, 0, 1, 0, NULL, 8, '', ''),
(984, '1279617741', '网易手机频道', 'http://mobile.163.com', 0, 0, 0, 1077, 0, 1, 0, NULL, 9, '', ''),
(985, '1279617741', '3533手机世界', 'http://www.3533.com/', 0, 0, 0, 1077, 0, 1, 0, NULL, 10, '', ''),
(986, '1279617741', '搜娱网', 'http://www.sooyuu.com', 0, 0, 0, 1077, 0, 1, 0, NULL, 11, '', ''),
(987, '1279617741', '搜狐手机', 'http://digi.it.sohu.com/mobile.shtml', 0, 0, 0, 1077, 0, 1, 0, NULL, 12, '', ''),
(988, '1279617741', '手机中国', 'http://www.cnmo.com/', 0, 0, 0, 1077, 0, 1, 0, NULL, 13, '', ''),
(989, '1279617741', '中关村手机频道', 'http://mobile.zol.com.cn/', 0, 0, 0, 1077, 0, 1, 0, NULL, 14, '', ''),
(990, '1279617741', 'IT世界手机', 'http://www.it.com.cn/mobile/', 0, 0, 0, 1077, 0, 1, 0, NULL, 15, '', ''),
(991, '1279617741', '中华网时尚手机', 'http://tech.china.com/zh_cn/mobile/index.html', 0, 0, 0, 1077, 0, 1, 0, NULL, 16, '', ''),
(992, '1279617741', '百信手机网', 'http://www.958shop.com', 0, 0, 0, 1077, 0, 1, 0, NULL, 17, '', ''),
(993, '1279617741', '塞班智能手机网', 'http://www.dospy.com/', 0, 0, 0, 1077, 0, 1, 0, NULL, 18, '', ''),
(994, '1279617741', '手机真伪查询', 'http://www.tenaa.com.cn/(S(m52dvt55shqfukii2eetye45))/WSFW/FlagValidate.aspx', 0, 0, 0, 1077, 0, 1, 0, NULL, 19, '', ''),
(995, '1279617741', '手机在线', 'http://www.showji.com/', 0, 0, 0, 1077, 0, 1, 0, NULL, 20, '', ''),
(996, '1279617741', '诺基亚', 'http://www.nokia.com.cn', 0, 0, 0, 1078, 0, 1, 0, NULL, 1, '', ''),
(997, '1279617741', '三星', 'http://www.samsung.com.cn', 0, 0, 0, 1078, 0, 1, 0, NULL, 2, '', ''),
(998, '1279617741', '摩托罗拉', 'http://www.motorola.com.cn', 0, 0, 0, 1078, 0, 1, 0, NULL, 3, '', ''),
(999, '1279617741', '索尼爱立信', 'http://www.sonyericsson.com', 0, 0, 0, 1078, 0, 1, 0, NULL, 4, '', ''),
(1000, '1279617741', '西门子', 'http://www.siemens.com', 0, 0, 0, 1078, 0, 1, 0, NULL, 5, '', ''),
(1001, '1279617741', '飞利浦', 'http://www.philips.com.cn/', 0, 0, 0, 1078, 0, 1, 0, NULL, 6, '', ''),
(1002, '1279617741', 'LG', 'http://www.lg.com.cn/', 0, 0, 0, 1078, 0, 1, 0, NULL, 7, '', ''),
(1003, '1279617741', '联想手机', 'http://www.lenovomobile.com/', 0, 0, 0, 1078, 0, 1, 0, NULL, 8, '', ''),
(1004, '1279617741', '夏新', 'http://www.amobile.com.cn/', 1, 0, 0, 1078, 0, 1, 0, NULL, 9, '', ''),
(1005, '1279617741', '多普达', 'http://www.dopod.com/', 0, 0, 0, 1078, 0, 1, 0, NULL, 10, '', ''),
(1006, '1279617741', 'iPhone手机', 'http://www.iphone.com.cn/', 0, 0, 0, 1078, 0, 1, 0, NULL, 11, '', ''),
(1007, '1279617741', '明基中国', 'http://www.BenQ.com.cn', 0, 0, 0, 1078, 0, 1, 0, NULL, 12, '', ''),
(1008, '1279617741', '手机之家论坛', 'http://bbs.imobile.com.cn', 0, 0, 0, 1079, 0, 1, 0, NULL, 1, '', ''),
(1009, '1279617741', '3g365智能手机论坛', 'http://www.3g365.com/', 0, 0, 0, 1079, 0, 1, 0, NULL, 2, '', ''),
(1010, '1279617741', '捉鱼手机论坛', 'http://club.joyes.com', 0, 0, 0, 1079, 0, 1, 0, NULL, 3, '', ''),
(1011, '1279617741', 'TomPDA智能手机论坛', 'http://bbs.tompda.com/', 0, 0, 0, 1079, 0, 1, 0, NULL, 4, '', ''),
(1012, '1279617741', '塞班智能手机论坛', 'http://bbs.dospy.com/', 0, 0, 0, 1079, 0, 1, 0, NULL, 5, '', ''),
(1013, '1279617741', 'IT168索爱专业论坛', 'http://sebbs.it168.com/', 0, 0, 0, 1079, 0, 1, 0, NULL, 6, '', ''),
(1014, '1279617741', '摩托罗拉手机论坛', 'http://www.motobbs.com', 0, 0, 0, 1079, 0, 1, 0, NULL, 7, '', ''),
(1015, '1279617741', '忧郁的蓝色手机论坛', 'http://bbs.blueshow.net/', 0, 0, 0, 1079, 0, 1, 0, NULL, 8, '', ''),
(1016, '1279617741', '百信手机论坛', 'http://bbs.958shop.com', 0, 0, 0, 1079, 0, 1, 0, NULL, 9, '', ''),
(1018, '1279617741', '威锋网', 'http://www.weiphone.com', 0, 0, 0, 1079, 0, 1, 0, NULL, 11, '', ''),
(1019, '1279617741', '多普达智能手机论坛', 'http://www.dpdbbs.cn/', 0, 0, 0, 1079, 0, 1, 1300673029, NULL, 12, '', ''),
(1022, '1279617741', '12530彩铃', 'http://www.monternet.com/moneditor/cs/mring/', 0, 0, 0, 1080, 0, 1, 1300672910, NULL, 1, '', ''),
(1023, '1279617741', '强档图铃秀', 'http://mmscode3.3bu.com/mmscode/fullscreen/09271704435101519376.htm', 0, 0, 0, 1080, 0, 1, 1289801924, NULL, 2, '', ''),
(1024, '1279617741', '新浪回铃音', 'http://cl.sina.com.cn', 0, 0, 0, 1080, 0, 1, 0, NULL, 3, '', ''),
(1025, '1279617741', '图铃快车', 'http://mmscode1.3bu.com/mmscode/fullscreen/02261017556997866535.htm', 0, 0, 0, 1080, 0, 1, 1289801942, NULL, 4, '', ''),
(7851, '1289802154', '中华英才网北京站', 'http://beijing.chinahr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 1, '', ''),
(1026, '1279617741', '精彩图铃', 'http://www.cai8cai.com/', 0, 0, 0, 1080, 0, 1, 1300672857, NULL, 5, '', ''),
(1027, '1279617741', '新浪短信', 'http://sms.sina.com.cn/', 0, 0, 0, 1080, 0, 1, 0, NULL, 6, '', ''),
(1029, '1279617741', '信息美眉', 'http://www.smsmm.com/', 0, 0, 0, 1080, 0, 1, 0, NULL, 8, '', ''),
(1030, '1279617741', '爱短信', 'http://www.aiduanxin.com/', 0, 0, 0, 1080, 0, 1, 1300672787, NULL, 9, '', ''),
(1031, '1279617741', '搞笑短信网', 'http://www.gxdxw.cn', 0, 0, 0, 1080, 0, 1, 0, NULL, 10, '', ''),
(1032, '1279617741', '新兵下载', 'http://www.sisdown.com/', 0, 0, 0, 1080, 0, 1, 0, NULL, 11, '', ''),
(1033, '1279617741', '前线数码', 'http://www.3gfan.com/index.htm', 0, 0, 0, 1080, 0, 1, 0, NULL, 12, '', ''),
(1034, '1279617741', 'Tompda智能手机软件', 'http://soft.tompda.com/', 0, 0, 0, 1080, 0, 1, 0, NULL, 13, '', ''),
(1035, '1279617741', '魔秀手机主题', 'http://www.moxiu.com/', 0, 0, 0, 1080, 0, 1, 0, NULL, 14, '', ''),
(1036, '1279617741', '炫手机主题', 'http://www.3g37.com/', 0, 0, 0, 1080, 0, 1, 0, NULL, 15, '', ''),
(1037, '1279617741', '飞库网', 'http://www.feiku.com/', 0, 0, 0, 1080, 0, 1, 0, NULL, 16, '', ''),
(1038, '1279617741', '掌上书院电子书搜索', 'http://www.mbook.com.cn/', 0, 0, 0, 1080, 0, 1, 0, NULL, 17, '', ''),
(1039, '1279617741', '猪猪电子书', 'http://www.cczz.com/index.php', 0, 0, 0, 1080, 0, 1, 0, NULL, 18, '', ''),
(1040, '1279617741', '溜达电子书库', 'http://www.txtku.cn', 0, 0, 0, 1080, 0, 1, 0, NULL, 19, '', ''),
(1041, '1279617741', '小说迷', 'http://www.xiaoshuom.com', 0, 0, 0, 1080, 0, 1, 0, NULL, 20, '', ''),
(1042, '1279617741', '手机版QQ', 'http://mobile.qq.com/', 0, 0, 0, 1081, 0, 1, 0, NULL, 1, '', ''),
(1043, '1279617741', '飞信', 'http://feixin.10086.cn/', 0, 0, 0, 1081, 0, 1, 0, NULL, 2, '', ''),
(1044, '1279617741', '来电通', 'http://www.blovestorm.com/', 0, 0, 0, 1081, 0, 1, 0, NULL, 3, '', ''),
(1045, '1279617741', 'UCWEB', 'http://www.uc.cn/', 0, 0, 0, 1081, 0, 1, 0, NULL, 4, '', ''),
(1046, '1279617741', 'uc桌面', 'http://www.uc.cn/product/product_ucdesk.shtml', 0, 0, 0, 1081, 0, 1, 0, NULL, 5, '', ''),
(1047, '1279617741', '天天动听', 'http://www.ttpod.com/', 0, 0, 0, 1081, 0, 1, 0, NULL, 6, '', ''),
(1048, '1279617741', '手机酷狗', 'http://www.ddong.com/', 0, 0, 0, 1081, 0, 1, 0, NULL, 7, '', ''),
(1049, '1279617741', 'opera浏览器', 'http://www.opera.com/', 0, 0, 0, 1081, 0, 1, 0, NULL, 8, '', ''),
(1050, '1279617741', '暴风转码', 'http://zm.baofeng.com/', 0, 0, 0, 1081, 0, 1, 0, NULL, 9, '', ''),
(1051, '1279617741', '985高校名单', 'http://gkcx.eol.cn/schoolInfoSearch/985/985_1.htm', 0, 0, 0, 1082, 0, 1, 0, NULL, 1, '', ''),
(1052, '1279617741', '大学排名(仅供参考)', 'http://gaokao.eduu.com/b2009z/2010dxpm/', 0, 0, 0, 1082, 0, 1, 0, NULL, 1, '', ''),
(1053, '1279617741', '阳光高考', 'http://gaokao.chsi.com.cn/', 0, 0, 0, 1082, 0, 1, 0, NULL, 1, '', ''),
(1054, '1279617741', '大学专业介绍', 'http://zhuanye.eol.cn/', 0, 0, 0, 1082, 0, 1, 0, NULL, 1, '', ''),
(1055, '1279617741', '高等院校信息库', 'http://gaokao.chsi.com.cn/sch/', 0, 0, 0, 1082, 0, 1, 0, NULL, 1, '', ''),
(1056, '1279617741', '高考志愿填报指南', 'http://gaokao.eol.cn/html/g/zhiyuan/index.shtml', 0, 0, 0, 1082, 0, 1, 0, NULL, 1, '', ''),
(1057, '1279617741', '新浪高考站', 'http://edu.sina.com.cn/gaokao/', 0, 0, 0, 1082, 0, 1, 0, NULL, 1, '', ''),
(1058, '1279617741', '腾讯高考频道', 'http://edu.qq.com/gaokao/', 0, 0, 0, 1082, 0, 1, 0, NULL, 1, '', ''),
(1059, '1279617741', '人民网高考频道', 'http://edu.people.com.cn/GB/gaokao/', 0, 0, 0, 1082, 0, 1, 0, NULL, 1, '', ''),
(1060, '1279617741', '百度知道-高考频道', 'http://edu.zhidao.baidu.com/gaokao/index.html', 0, 0, 0, 1082, 0, 1, 0, NULL, 1, '', ''),
(1061, '1279617741', '中华英才网', 'http://www.chinahr.com', 0, 0, 0, 1083, 0, 1, 1289802040, NULL, 1, '', ''),
(1062, '1279617741', '前程无忧', 'http://www.51job.com', 0, 0, 0, 1083, 0, 1, 1289802039, NULL, 2, '', ''),
(1063, '1279617741', '中国人才热线', 'http://www.cjol.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 3, '', ''),
(1064, '1279617741', '528招聘网', 'http://www.528.com.cn/', 0, 0, 0, 1083, 0, 1, 0, NULL, 4, '', ''),
(1065, '1279617741', '智联招聘网', 'http://www.zhaopin.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 5, '', ''),
(1066, '1279617741', '卓博人才网', 'http://www.jobcn.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 6, '', ''),
(1067, '1279617741', '职酷招聘', 'http://www.jobkoo.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 7, '', ''),
(6872, '1289792118', '儋州市', 'http://www.danzhou.gov.cn/', 0, 0, 0, 4201, 0, 1, 0, NULL, 2, '', ''),
(1068, '1279617741', '中国就业网', 'http://www.china91.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 8, '', ''),
(1069, '1279617741', '南方人才网', 'http://www.job168.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 9, '', ''),
(1070, '1279617741', '中国招聘热线', 'http://www.hr33.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 10, '', ''),
(1071, '1279617741', '易才网', 'http://www.job1998.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 11, '', ''),
(1072, '1279617741', '应届生求职网', 'http://www.yingjiesheng.com', 0, 0, 0, 1083, 0, 1, 0, NULL, 12, '', ''),
(1073, '1279617741', '英才网联', 'http://www.800hr.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 13, '', ''),
(1074, '1279617741', '国际人才网', 'http://www.job001.cn/', 0, 0, 0, 1083, 0, 1, 0, NULL, 14, '', ''),
(1075, '1279617741', '人才新干线', 'http://www.siphrd.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 15, '', ''),
(1076, '1279617741', '赶集网招聘', 'http://www.ganji.com/zhaopin/', 0, 0, 0, 1083, 0, 1, 0, NULL, 16, '', ''),
(1077, '1279617741', '搜狐-招聘频道', 'http://career.sohu.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 17, '', ''),
(1078, '1279617741', '大中华人才网', 'http://www.job110.cn/', 0, 0, 0, 1083, 0, 1, 0, NULL, 18, '', ''),
(1079, '1279617741', '智通人才招聘网', 'http://www.job5156.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 19, '', ''),
(1080, '1279617741', '潜力新人', 'http://www.qianlijob.com', 0, 0, 0, 1083, 0, 1, 0, NULL, 20, '', ''),
(1081, '1279617741', '厦门人才网', 'http://www.xmrencai.com', 0, 0, 0, 1083, 0, 1, 0, NULL, 21, '', ''),
(1082, '1279617741', '广东人才网', 'http://www.gdrc.com/', 0, 0, 0, 1083, 0, 1, 0, NULL, 22, '', ''),
(1083, '1279617741', '过来人求职网', 'http://www.guolairen.com', 0, 0, 0, 1083, 0, 1, 0, NULL, 23, '', ''),
(1084, '1279617741', '全国招聘会信息网', 'http://www.zph.com.cn', 0, 0, 0, 1083, 0, 1, 0, NULL, 24, '', ''),
(1085, '1279617741', '中劳网', 'http://www.chinalao.com', 0, 0, 0, 1083, 0, 1, 0, NULL, 25, '', ''),
(1086, '1279617741', 'job36行业招聘网', 'http://www.job36.com/', 0, 0, 0, 1084, 0, 1, 1289722119, NULL, 1, '', ''),
(1087, '1279617741', '万行工作网', 'http://www.114job.com.cn/', 1, 0, 0, 1084, 0, 1, 0, NULL, 2, '', ''),
(1088, '1279617741', '外贸英才网', 'http://www.tradehr.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 3, '', ''),
(1089, '1279617741', '百大英才网', 'http://www.baidajob.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 4, '', ''),
(1090, '1279617741', '中国外语人才网', 'http://www.jobeast.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 5, '', ''),
(1091, '1279617741', '中华IT人才网', 'http://www.citvip.com/', 1, 0, 0, 1084, 0, 1, 0, NULL, 6, '', ''),
(1092, '1279617741', '中国程序员人才网', 'http://www.cxyrc.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 7, '', ''),
(1093, '1279617741', '中国服装人才网', 'http://www.cfw.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 8, '', ''),
(1094, '1279617741', '中国食品招聘网', 'http://www.gofood.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 9, '', ''),
(1095, '1279617741', '中国水利人才网', 'http://rencai.chinawater.net.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 10, '', ''),
(1096, '1279617741', '中国卫生人才网', 'http://www.21wecan.com.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 11, '', ''),
(1097, '1279617741', '中国传媒人才网', 'http://www.mediaren.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 12, '', ''),
(1098, '1279617741', '中国化工人才网', 'http://www.chemjobs.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 13, '', ''),
(1099, '1279617741', '中国游戏人才网', 'http://www.gamejob.net/', 0, 0, 0, 1084, 0, 1, 0, NULL, 14, '', ''),
(1100, '1279617741', '中国农业人才网', 'http://www.5ajob.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 15, '', ''),
(1101, '1279617741', '健康英才网', 'http://www.jkyc.com', 0, 0, 0, 1084, 0, 1, 0, NULL, 16, '', ''),
(1102, '1279617741', '中国工程师黄页', 'http://www.jobs114.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 17, '', ''),
(1103, '1279617741', '中国旅游人才网', 'http://www.tourjob.net/', 0, 0, 0, 1084, 0, 1, 0, NULL, 18, '', ''),
(1104, '1279617741', '中国照明人才网', 'http://www.lightingjob.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 19, '', ''),
(1105, '1279617741', '中国汽车人才网', 'http://www.carjob.com.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 20, '', ''),
(1106, '1279617741', '中国餐饮人才网', 'http://www.cyjob.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 21, '', ''),
(1107, '1279617741', '中国医疗人才网', 'http://www.doctorjob.com.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 22, '', ''),
(1108, '1279617741', '中国教师人才网', 'http://www.jiaoshi.com.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 23, '', ''),
(1109, '1279617741', '中国皮革人才网', 'http://www.leatherhr.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 24, '', ''),
(1110, '1279617741', '中国印刷人才网', 'http://www.pjob.net/', 0, 0, 0, 1084, 0, 1, 0, NULL, 25, '', ''),
(1111, '1279617741', '中国交通人才网', 'http://www.hrcc.com.cn/', 1, 0, 0, 1084, 0, 1, 0, NULL, 26, '', ''),
(1112, '1279617741', '中国服装人才网', 'http://www.efjob.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 27, '', ''),
(1113, '1279617741', '中国酒店人才网', 'http://www.triphr.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 28, '', ''),
(1114, '1279617741', '中国建筑人才网', 'http://www.buildjob.net/', 0, 0, 0, 1084, 0, 1, 0, NULL, 29, '', ''),
(1115, '1279617741', '水利英才网', 'http://www.waterhr.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 30, '', ''),
(1116, '1279617741', '农博人才', 'http://job.aweb.com.cn/', 0, 0, 0, 1084, 0, 1, 0, NULL, 31, '', ''),
(1117, '1279617741', '中国起重人才网', 'http://qz.baidajob.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 32, '', ''),
(1118, '1279617741', '世贸人才网', 'http://www.wtojob.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 33, '', ''),
(1119, '1279617741', '中国酒店招聘网', 'http://www.hoteljob.cn', 0, 0, 0, 1084, 0, 1, 0, NULL, 34, '', ''),
(1120, '1279617741', '电子人才招聘网', 'http://www.ejob100.cn', 0, 0, 0, 1084, 0, 1, 0, NULL, 35, '', ''),
(1121, '1279617741', '中国钢结构人才网', 'http://sc.baidajob.com', 0, 0, 0, 1084, 0, 1, 0, NULL, 36, '', ''),
(1122, '1279617741', '中国酒店人才网', 'http://www.veryeast.cn', 0, 0, 0, 1084, 0, 1, 0, NULL, 37, '', ''),
(1123, '1279617741', '中国光电人才网', 'http://pe.baidajob.com', 0, 0, 0, 1084, 0, 1, 0, NULL, 38, '', ''),
(1124, '1279617741', '中国化工招聘网', 'http://www.chemjob.com.cn', 0, 0, 0, 1084, 0, 1, 0, NULL, 39, '', ''),
(1125, '1279617741', '中国演艺人才网', 'http://www.c008.cn/', 1, 0, 0, 1084, 0, 1, 0, NULL, 40, '', ''),
(1126, '1279617741', '精英前程-猎头人才', 'http://www.vipcareer.com/', 0, 0, 0, 1084, 0, 1, 0, NULL, 41, '', ''),
(1127, '1279617741', '中国美容人才网', 'http://www.138job.com', 0, 0, 0, 1084, 0, 1, 0, NULL, 42, '', ''),
(1128, '1279617741', '一听音乐网', 'http://www.1ting.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 1, '', ''),
(1129, '1279617741', 'QQ163 音乐网', 'http://www.qq163.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 2, '', ''),
(1130, '1279617741', 'SoGua音乐网', 'http://www.sogua.com', 0, 0, 0, 2001, 0, 1, 0, NULL, 3, '', ''),
(1131, '1279617741', '爱听音乐网', 'http://www.aiting.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 4, '', ''),
(1133, '1279617741', '音乐快车', 'http://www.yykc.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 6, '', ''),
(1134, '1279617741', 'A8原创音乐网', 'http://www.a8.com', 0, 0, 0, 2001, 0, 1, 0, NULL, 7, '', ''),
(1136, '1279617741', '56流行音乐', 'http://www.565656.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 9, '', ''),
(1137, '1279617741', '一听音乐网', 'http://www.1ting.com/', 1, 0, 0, 2001, 0, 1, 0, NULL, 10, '', ''),
(1138, '1279617741', '七音音乐网', 'http://www.7yin.com', 0, 0, 0, 2001, 0, 1, 0, NULL, 11, '', ''),
(1139, '1279617741', '一起来音乐社区', 'http://www.yiqilai.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 12, '', ''),
(1140, '1279617741', 'YYMP3音乐网', 'http://www.yymp3.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 13, '', ''),
(1141, '1279617741', '无忧音乐网', 'http://www.51y.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 14, '', ''),
(1142, '1279617741', '5nd音乐网', 'http://www.5nd.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 15, '', ''),
(1144, '1279617741', '51wma音乐网', 'http://www.51wma.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 17, '', ''),
(1145, '1279617741', '视听天空', 'http://www.stsky.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 18, '', ''),
(1146, '1279617741', '音乐天空', 'http://www.yysky.com', 0, 0, 0, 2001, 0, 1, 0, NULL, 19, '', ''),
(1147, '1279617741', '世纪音乐网', 'http://www.ssjj.com', 0, 0, 0, 2001, 0, 1, 0, NULL, 20, '', ''),
(1148, '1279617741', '我爱音乐网', 'http://www.520music.com/', 0, 0, 0, 2001, 0, 1, 0, NULL, 21, '', ''),
(1149, '1279617741', '中华好歌网', 'http://www.t8c8.com', 0, 0, 0, 2001, 0, 1, 0, NULL, 23, '', ''),
(1150, '1279617741', '酷猪音乐', 'http://www.kupig.cc/', 0, 0, 0, 2001, 0, 1, 1301535932, NULL, 24, '', ''),
(1152, '1279617741', 'DJ舞曲网', 'http://www.dj527.com', 0, 0, 0, 2002, 0, 1, 1290757810, NULL, 1, '', ''),
(1153, '1279617741', 'DJRRR舞曲网', 'http://www.djrrr.com/', 0, 0, 0, 2002, 0, 1, 0, NULL, 2, '', ''),
(1154, '1279617741', 'DJ先锋网', 'http://www.dj-dj.net/', 0, 0, 0, 2002, 0, 1, 0, NULL, 3, '', ''),
(1155, '1279617741', 'DJ舞曲图铃', 'http://mmscode3.3bu.com/mmscode/fullscreen/11061203178645911046.htm', 0, 0, 0, 2002, 0, 1, 1289802266, NULL, 4, '', ''),
(1156, '1279617741', '深港DJ舞曲', 'http://www.ik123.com/', 0, 0, 0, 2002, 0, 1, 0, NULL, 5, '', ''),
(1157, '1279617741', '中国DJ舞曲网', 'http://www.djtoo.com/', 0, 0, 0, 2002, 0, 1, 0, NULL, 6, '', ''),
(1158, '1279617741', 'DJ嗨嗨网', 'http://www.djkk.com/', 0, 0, 0, 2002, 0, 1, 1290757810, NULL, 7, '', ''),
(1159, '1279617741', 'DjWmA舞曲网', 'http://www.djwma.com/', 0, 0, 0, 2002, 0, 1, 0, NULL, 8, '', ''),
(1160, '1279617741', '要听dj舞曲网', 'http://www.111ttt.com/', 0, 0, 0, 2002, 0, 1, 0, NULL, 9, '', ''),
(1161, '1279617741', '嗨嗨吧DJ音乐', 'http://www.hh8.cn/', 1, 0, 0, 2002, 0, 1, 0, NULL, 10, '', ''),
(1162, '1279617741', '音悦台高清mv', 'http://www.yinyuetai.com/', 1, 0, 0, 2003, 0, 1, 0, NULL, 1, '', ''),
(1163, '1279617741', '优酷音乐', 'http://music.youku.com/', 1, 0, 0, 2003, 0, 1, 0, NULL, 2, '', ''),
(1164, '1279617741', '土豆音乐', 'http://music.tudou.com/', 1, 0, 0, 2003, 0, 1, 0, NULL, 3, '', ''),
(1165, '1279617741', '酷6音乐', 'http://mv.ku6.com/', 1, 0, 0, 2003, 0, 1, 0, NULL, 4, '', ''),
(1166, '1279617741', '真乐网mv下载', 'http://www.truemv.com/', 1, 0, 0, 2003, 0, 1, 0, NULL, 5, '', ''),
(1167, '1279617741', 'KuGou酷狗音乐', 'http://www.kugou.com', 0, 0, 0, 2004, 0, 1, 0, NULL, 1, '', ''),
(1168, '1279617741', 'SongTaste 音乐分享', 'http://songtaste.com/', 0, 0, 0, 2004, 0, 1, 0, NULL, 2, '', ''),
(1169, '1279617741', '千千音乐在线', 'http://www.qianqian.com/', 0, 0, 0, 2004, 0, 1, 0, NULL, 3, '', ''),
(1170, '1279617741', '百度MP3音乐掌门人', 'http://zhangmen.baidu.com/', 0, 0, 0, 2004, 0, 1, 0, NULL, 4, '', ''),
(1171, '1279617741', '雅虎音乐', 'http://music.cn.yahoo.com/', 0, 0, 0, 2004, 0, 1, 0, NULL, 5, '', ''),
(1172, '1279617741', '搜狐音乐', 'http://music.sohu.com', 0, 0, 0, 2004, 0, 1, 0, NULL, 6, '', ''),
(1173, '1279617741', '音乐之声', 'http://musicradio.cnr.cn/', 0, 0, 0, 2004, 0, 1, 0, NULL, 7, '', ''),
(1174, '1279617741', '虫虫吉他', 'http://www.ccjt.net/', 0, 0, 0, 2004, 0, 1, 0, NULL, 8, '', ''),
(1175, '1279617741', '中国古曲网', 'http://www.guqu.net/', 0, 0, 0, 2004, 0, 1, 0, NULL, 9, '', ''),
(1176, '1279617741', '醉声梦色', 'http://www.023x.com', 0, 0, 0, 2004, 0, 1, 0, NULL, 10, '', ''),
(1177, '1279617741', '17173网游天下', 'http://www.17173.com/', 0, 0, 0, 2005, 0, 1, 0, NULL, 1, '', ''),
(1178, '1279617741', '新浪游戏', 'http://games.sina.com.cn', 0, 0, 0, 2005, 0, 1, 0, NULL, 2, '', ''),
(1180, '1279617741', '最新小游戏', 'http://www.20000n.com', 0, 0, 0, 2005, 0, 1, 1303915556, NULL, 4, '', '#FF0000'),
(1181, '1279617741', '多玩游戏', 'http://www.duowan.com/', 0, 0, 0, 2005, 0, 1, 0, NULL, 5, '', ''),
(1182, '1279617741', '52PK游戏网', 'http://www.52pk.com/', 0, 0, 0, 2005, 0, 1, 1298438810, NULL, 6, '', ''),
(1183, '1279617741', '中华网游戏', 'http://game.china.com/zh_cn/', 0, 0, 0, 2005, 0, 1, 0, NULL, 7, '', ''),
(1184, '1279617741', 'GameSpot中文站', 'http://www.gamespot.com.cn/', 0, 0, 0, 2005, 0, 1, 0, NULL, 8, '', ''),
(1185, '1279617741', '天极网游戏中心', 'http://game.yesky.com', 0, 0, 0, 2005, 0, 1, 0, NULL, 9, '', ''),
(1186, '1279617741', '中关村游戏', 'http://game.zol.com.cn/', 0, 0, 0, 2005, 0, 1, 0, NULL, 10, '', ''),
(1187, '1279617741', '178游戏网', 'http://www.178.com/', 0, 0, 0, 2005, 0, 1, 1298438828, NULL, 11, '', ''),
(1188, '1279617741', '网游网', 'http://www.5617.com', 0, 0, 0, 2005, 0, 1, 0, NULL, 12, '', ''),
(1189, '1279617741', '联众世界', 'http://www.ourgame.com/', 0, 0, 0, 2005, 0, 1, 1298438873, NULL, 13, '', ''),
(1190, '1279617741', '久游网', 'http://www.9you.com', 0, 0, 0, 2005, 0, 1, 0, NULL, 14, '', ''),
(1191, '1279617741', '中国游戏中心', 'http://www.chinagames.net/', 0, 0, 0, 2005, 0, 1, 0, NULL, 15, '', ''),
(1192, '1279617741', '131游戏之家', 'http://www.131.com/', 0, 0, 0, 2005, 0, 1, 0, NULL, 16, '', ''),
(1193, '1279617741', '游久网', 'http://www.uuu9.com/', 0, 0, 0, 2005, 0, 1, 0, NULL, 17, '', ''),
(1194, '1279617741', '万宇在线', 'http://www.92wy.com', 0, 0, 0, 2005, 0, 1, 0, NULL, 18, '', ''),
(1195, '1279617741', '游牧民族', 'http://games.cnool.net', 0, 0, 0, 2005, 0, 1, 0, NULL, 19, '', ''),
(1196, '1279617741', '766游戏网', 'http://www.766.com/', 0, 0, 0, 2005, 0, 1, 1298438897, NULL, 20, '', ''),
(1197, '1279617741', '浩方对战平台', 'http://www.cga.com.cn/', 0, 0, 0, 2005, 0, 1, 1298438916, NULL, 21, '', ''),
(1198, '1279617741', '狗狗游戏搜索', 'http://game.gougou.com/', 0, 0, 0, 2005, 0, 1, 1298438932, NULL, 22, '', ''),
(1199, '1279617741', '激动网游戏', 'http://games.joy.cn/', 0, 0, 0, 2005, 0, 1, 1298438957, NULL, 23, '', ''),
(1200, '1279617741', '豆豆游戏', 'http://game.doudou.com/', 0, 0, 0, 2005, 0, 1, 1298438978, NULL, 24, '', ''),
(1202, '1279617741', '4399小游戏', 'http://www.4399.com/', 0, 0, 0, 2006, 0, 1, 0, NULL, 1, '', ''),
(1203, '1279617741', '小游戏', 'http://www.game.com.cn/', 0, 0, 0, 2006, 0, 1, 0, NULL, 2, '', ''),
(1204, '1279617741', '休闲小游戏', 'http://www.xiaoyouxi.cn/', 0, 0, 0, 2006, 0, 1, 1292222841, NULL, 4, '', ''),
(1205, '1279617741', '4399积分小游戏', 'http://pk.4399.com/', 0, 0, 0, 2006, 0, 1, 1292222860, NULL, 5, '', ''),
(1206, '1279617741', '3366小游戏', 'http://www.3366.com/', 0, 0, 0, 2006, 0, 1, 1303460962, NULL, 17, '', ''),
(1207, '1279617741', '2144小游戏', 'http://www.2144.net/', 0, 0, 0, 2006, 0, 1, 1300422001, NULL, 7, '', ''),
(1208, '1279617741', 'flash小游戏', 'http://game.doudou.com/', 0, 0, 0, 2006, 0, 1, 0, NULL, 8, '', ''),
(1209, '1279617741', '93小游戏', 'http://www.93.cn/', 0, 0, 0, 2006, 0, 1, 0, NULL, 9, '', ''),
(1210, '1279617741', '魔兽世界', 'http://www.warcraftchina.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 1, '', ''),
(1211, '1279617741', '地下城与勇士', 'http://dnf.qq.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 2, '', ''),
(1212, '1279617741', '跑跑卡丁车', 'http://popkart.tiancity.com/homepage/', 0, 0, 0, 2007, 0, 1, 0, NULL, 3, '', ''),
(1213, '1279617741', '龙之谷', 'http://dn.sdo.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 4, '', ''),
(1214, '1279617741', 'QQ炫舞', 'http://x5.qq.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 5, '', ''),
(1215, '1279617741', '泡泡堂', 'http://home.bnb.sdo.com/web2/home/index.asp', 0, 0, 0, 2007, 0, 1, 0, NULL, 6, '', ''),
(1216, '1279617741', '反恐精英Online', 'http://csol.tiancity.com/homepage/v3/', 0, 0, 0, 2007, 0, 1, 0, NULL, 7, '', ''),
(1217, '1279617741', '征途', 'http://zt.ztgame.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 8, '', ''),
(1218, '1279617741', '梦幻西游', 'http://xyq.163.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 9, '', ''),
(1219, '1279617741', 'QQ飞车', 'http://speed.qq.com/index.shtml', 0, 0, 0, 2007, 0, 1, 0, NULL, 10, '', ''),
(1220, '1279617741', '万王之王3', 'http://kok3.ztgame.com/project/fbb/index.shtml', 0, 0, 0, 2007, 0, 1, 1289802595, NULL, 11, '', ''),
(1221, '1279617741', '完美世界', 'http://world2.wanmei.com/', 0, 0, 0, 2007, 0, 1, 1292222880, NULL, 12, '', ''),
(1222, '1279617741', '穿越火线', 'http://cf.qq.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 13, '', ''),
(1223, '1279617741', '天龙八部', 'http://tl.changyou.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 14, '', ''),
(1224, '1279617741', '诛仙2', 'http://zhuxian.wanmei.com/', 0, 0, 0, 2007, 0, 1, 1292222897, NULL, 15, '', ''),
(1225, '1279617741', '武林外传', 'http://wulin2.wanmei.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 16, '', ''),
(1226, '1279617741', '天朝ol', 'http://tc.zqgame.com/', 0, 0, 0, 2007, 0, 1, 1289802306, NULL, 17, '', ''),
(1227, '1279617741', '特种部队', 'http://sf.17game.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 18, '', ''),
(1228, '1279617741', '热血传奇', 'http://mir2.sdo.com/10years/index.asp', 0, 0, 0, 2007, 0, 1, 1289802324, NULL, 19, '', ''),
(1229, '1279617741', '问道', 'http://wd.gyyx.cn/', 0, 0, 0, 2007, 0, 1, 0, NULL, 20, '', ''),
(1230, '1279617741', '街头篮球', 'http://www.fsjoy.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 21, '', ''),
(1231, '1279617741', '幻想三国', 'http://77.198game.net/', 0, 0, 0, 2007, 0, 1, 1289802341, NULL, 22, '', ''),
(1232, '1279617741', '千年3', 'http://1000y.sdo.com/web2/index/index.asp', 0, 0, 0, 2007, 0, 1, 1289802355, NULL, 23, '', ''),
(1233, '1279617741', '蜀门', 'http://www.shumenol.com/', 0, 0, 0, 2007, 0, 1, 1289802402, NULL, 24, '', ''),
(1234, '1279617741', '英雄之城', 'http://hero.woniu.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 25, '', ''),
(1235, '1279617741', '武神', 'http://www.wushen.com/', 0, 0, 0, 2007, 0, 1, 1292222968, NULL, 26, '', ''),
(1236, '1279617741', '亮剑OL', 'http://lj.zqgame.com/default.html', 0, 0, 0, 2007, 0, 1, 1289802424, NULL, 27, '', ''),
(1237, '1279617741', '永恒之塔', 'http://aion.sdo.com/Web1/aion.asp', 0, 0, 0, 2007, 0, 1, 0, NULL, 28, '', ''),
(1238, '1279617741', '神话', 'http://media.wushen.com/399079128794/index.html', 0, 0, 0, 2007, 0, 1, 0, NULL, 29, '', ''),
(1239, '1279617741', '远征OL', 'http://yz.szgla.com/zt/login.html', 0, 0, 0, 2007, 0, 1, 1289802495, NULL, 30, '', ''),
(1240, '1279617741', '征途怀旧版', 'http://zthj.ztgame.com/', 0, 0, 0, 2007, 0, 1, 1289802516, NULL, 31, '', ''),
(1241, '1279617741', '十年一剑', 'http://10.uuzu.com/', 0, 0, 0, 2007, 0, 1, 1289802534, NULL, 32, '', ''),
(1242, '1279617741', '网球宝贝', 'http://wq.mangogame.com/', 0, 0, 0, 2007, 0, 1, 0, NULL, 33, '', ''),
(1243, '1279617741', '巨人时空争霸', 'http://jr.ztgame.com/cm.html', 0, 0, 0, 2007, 0, 1, 0, NULL, 34, '', ''),
(1244, '1279617741', '圣魔之血', 'http://sm.kongzhong.com/', 0, 0, 0, 2007, 0, 1, 1289802550, NULL, 35, '', ''),
(1245, '1279617741', '恶魔法则', 'http://em.kongzhong.com/', 0, 0, 0, 2007, 0, 1, 1289802563, NULL, 36, '', ''),
(1246, '1279617741', '醉逍遥', 'http://www.zuixiaoyao.com/', 0, 0, 0, 2007, 0, 1, 1289802574, NULL, 37, '', ''),
(1247, '1279617741', '265G网页游戏', 'http://www.265g.com/', 0, 0, 0, 2008, 0, 1, 0, NULL, 1, '', ''),
(1248, '1279617741', '91wan网页游戏', 'http://www.91wan.com/', 0, 0, 0, 2008, 0, 1, 0, NULL, 2, '', ''),
(1249, '1279617741', '我要玩网页游戏', 'http://www.51wan.com', 0, 0, 0, 2008, 0, 1, 0, NULL, 3, '', ''),
(1250, '1279617741', '游戏盒子', 'http://www.boxgm.com/', 0, 0, 0, 2008, 0, 1, 0, NULL, 4, '', ''),
(1251, '1279617741', '武林帝国', 'http://www.dadaxia.com/passport.php?m=ctl_register&sp_id=900&target=2', 0, 0, 0, 2008, 0, 1, 0, NULL, 5, '', ''),
(1252, '1279617741', '4399网页游戏', 'http://web.4399.com/', 0, 0, 0, 2008, 0, 1, 0, NULL, 6, '', ''),
(1253, '1279617741', '游艺世界', 'http://www.yyge.com', 0, 0, 0, 2008, 0, 1, 0, NULL, 7, '', ''),
(1256, '1279617741', '明朝时代', 'http://www.91wan.com/mcsd/', 0, 0, 0, 2008, 0, 1, 0, NULL, 10, '', ''),
(1257, '1279617741', '电玩巴士', 'http://www.tgbus.com/', 0, 0, 0, 2009, 0, 1, 0, NULL, 1, '', ''),
(1258, '1279617741', '玩家网', 'http://www.cngba.com/', 0, 0, 0, 2009, 0, 1, 0, NULL, 2, '', ''),
(1259, '1279617741', 'PSP中文网', 'http://psp.tgbus.com/', 0, 0, 0, 2009, 0, 1, 0, NULL, 3, '', ''),
(1260, '1279617741', 'NDS中文网', 'http://nds.tgbus.com/', 0, 0, 0, 2009, 0, 1, 0, NULL, 4, '', ''),
(1261, '1279617741', '手游天下', 'http://www.155.cn/', 0, 0, 0, 2009, 0, 1, 0, NULL, 5, '', ''),
(1262, '1279617741', '任天堂世界', 'http://www.nwbbs.com/', 0, 0, 0, 2009, 0, 1, 0, NULL, 6, '', ''),
(1263, '1279617741', 'NDS掌机天堂', 'http://www.ndsbbs.com/', 0, 0, 0, 2009, 0, 1, 0, NULL, 7, '', ''),
(1264, '1279617741', '街机中国', 'http://www.mamecn.com/', 0, 0, 0, 2009, 0, 1, 0, NULL, 8, '', ''),
(1265, '1279617741', 'A9VG电玩部落', 'http://bbs.a9vg.com/', 0, 0, 0, 2009, 0, 1, 0, NULL, 9, '', ''),
(1266, '1279617741', '玩家网', 'http://www.cngba.com/', 0, 0, 0, 2010, 0, 1, 0, NULL, 1, '', ''),
(1267, '1279617741', '太平洋电视游戏', 'http://www.pcgames.com.cn/tvgames', 0, 0, 0, 2010, 0, 1, 0, NULL, 2, '', ''),
(1268, '1279617741', '兔友网', 'http://www.2u.com.cn/', 0, 0, 0, 2010, 0, 1, 0, NULL, 3, '', ''),
(1270, '1279617741', '街机中国', 'http://www.mamecn.com/', 0, 0, 0, 2010, 0, 1, 0, NULL, 5, '', ''),
(1271, '1279617741', 'a9vg电玩部落', 'http://bbs.a9vg.com/', 0, 0, 0, 2010, 0, 1, 0, NULL, 6, '', ''),
(1272, '1279617741', '任天堂世界', 'http://www.nwbbs.com/', 0, 0, 0, 2010, 0, 1, 0, NULL, 7, '', ''),
(1273, '1279617741', '游侠网', 'http://www.ali213.net', 0, 0, 0, 2010, 0, 1, 0, NULL, 8, '', ''),
(1274, '1279617741', 'PSP玩家网', 'http://www.psper.net/', 0, 0, 0, 2010, 0, 1, 0, NULL, 9, '', ''),
(1276, '1279617741', '浩方对战平台', 'http://www.cga.com.cn', 0, 0, 0, 2011, 0, 1, 1292223011, NULL, 1, '', ''),
(1277, '1279617741', 'QQ对战平台', 'http://games.qq.com/esports/qqbattle/', 0, 0, 0, 2011, 0, 1, 0, NULL, 2, '', ''),
(1278, '1279617741', 'VS对战平台', 'http://game.vsa.com.cn/', 0, 0, 0, 2011, 0, 1, 0, NULL, 3, '', ''),
(1279, '1279617741', '统一加速器', 'http://www.tyjsq.com/', 0, 0, 0, 2011, 0, 1, 0, NULL, 4, '', ''),
(1280, '1279617741', '简单加速器', 'http://www.jdjsq.com/', 0, 0, 0, 2011, 0, 1, 0, NULL, 5, '', ''),
(1281, '1279617741', '新浪网电子竞技', 'http://games.sina.com.cn/esports/', 0, 0, 0, 2011, 0, 1, 0, NULL, 6, '', ''),
(1282, '1279617741', '太平洋网电子竞技', 'http://www.pcgames.com.cn/fight/', 0, 0, 0, 2011, 0, 1, 0, NULL, 7, '', ''),
(1283, '1279617741', 'Tom电子竞技', 'http://game.tom.com/', 0, 0, 0, 2011, 0, 1, 1292223026, NULL, 8, '', ''),
(1284, '1279617741', 'ECP电子竞技', 'http://www.esport.com.cn/', 0, 0, 0, 2011, 0, 1, 0, NULL, 9, '', ''),
(1285, '1279617741', '5173 游戏服务网', 'http://www.5173.com/', 0, 0, 0, 2011, 0, 1, 0, NULL, 10, '', ''),
(1286, '1279617741', '模拟999', 'http://www.emu999.net/', 0, 0, 0, 2011, 0, 1, 0, NULL, 11, '', ''),
(1287, '1279617741', '我要nes游戏网', 'http://www.51nes.cn', 0, 0, 0, 2011, 0, 1, 0, NULL, 12, '', ''),
(1288, '1279617741', '简单游', 'http://www.jdyou.com/', 0, 0, 0, 2011, 0, 1, 0, NULL, 13, '', ''),
(1289, '1279617741', '优久网-游戏音乐', 'http://tingyx.uuu9.com/', 0, 0, 0, 2011, 0, 1, 0, NULL, 14, '', ''),
(1290, '1279617741', '叶子猪游戏乐园', 'http://www.yzz.cn/', 0, 0, 0, 2011, 0, 1, 1292223042, NULL, 15, '', ''),
(1291, '1279617741', '酷6网', 'http://www.ku6.com/', 0, 0, 0, 2012, 0, 1, 1292221641, NULL, 1, '', ''),
(1292, '1279617741', '优酷网', 'http://www.youku.com/', 0, 0, 0, 2012, 0, 1, 0, NULL, 2, '', ''),
(1293, '1279617741', '土豆网', 'http://www.tudou.com/', 0, 0, 0, 2012, 0, 1, 0, NULL, 3, '', ''),
(1294, '1279617741', '六间房', 'http://6.cn/', 0, 0, 0, 2012, 0, 1, 1292221647, NULL, 4, '', ''),
(1295, '1279617741', '56网', 'http://www.56.com', 0, 0, 0, 2012, 0, 1, 0, NULL, 5, '', ''),
(1296, '1279617741', '新浪播客', 'http://v.sina.com.cn/', 0, 0, 0, 2012, 0, 1, 0, NULL, 6, '', ''),
(1297, '1279617741', '搜狐视频', 'http://tv.sohu.com/hdtv/', 0, 0, 0, 2012, 0, 1, 0, NULL, 7, '', ''),
(1298, '1279617741', 'QQ播客', 'http://video.qq.com/', 0, 0, 0, 2012, 0, 1, 0, NULL, 8, '', ''),
(1299, '1279617741', '激动网', 'http://www.joy.cn/', 0, 0, 0, 2012, 0, 1, 0, NULL, 9, '', ''),
(1300, '1279617741', 'ZOL视频', 'http://v.zol.com.cn/', 0, 0, 0, 2012, 0, 1, 0, NULL, 10, '', ''),
(1301, '1279617741', '新华视频', 'http://www.xinhuanet.com/video/', 0, 0, 0, 2012, 0, 1, 0, NULL, 11, '', ''),
(1302, '1279617741', '琥珀网', 'http://www.hupo.tv/', 0, 0, 0, 2012, 0, 1, 0, NULL, 12, '', ''),
(1303, '1279617741', '东方宽频', 'http://www.smgbb.cn/', 0, 0, 0, 2012, 0, 1, 0, NULL, 13, '', ''),
(1304, '1279617741', 'CCTV视频点播', 'http://vod.cctv.com/', 0, 0, 0, 2012, 0, 1, 0, NULL, 14, '', ''),
(1306, '1279617741', '17173游戏视频', 'http://media.17173.com/', 0, 0, 0, 2012, 0, 1, 0, NULL, 16, '', ''),
(1307, '1279617741', '第一视频', 'http://www.vodone.com/', 0, 0, 0, 2012, 0, 1, 0, NULL, 17, '', ''),
(1308, '1279617741', '凤凰宽频', 'http://vip.v.ifeng.com/', 0, 0, 0, 2012, 0, 1, 1292221681, NULL, 18, '', ''),
(1309, '1279617741', '爆米花视频', 'http://www.pomoho.com/', 0, 0, 0, 2012, 0, 1, 0, NULL, 19, '', ''),
(1310, '1279617741', '播视网', 'http://www.boosj.com', 0, 0, 0, 2012, 0, 1, 1300705132, NULL, 21, '', ''),
(1311, '1279617741', 'PPLive网络电视', 'http://www.pptv.com/', 0, 0, 0, 2013, 0, 1, 1300704445, NULL, 1, '', ''),
(1312, '1279617741', 'PPS网络电视', 'http://www.pps.tv/', 0, 0, 0, 2013, 0, 1, 1300704454, NULL, 2, '', ''),
(1313, '1279617741', 'QQ直播', 'http://live.qq.com/', 0, 0, 0, 2013, 0, 1, 1300704471, NULL, 3, '', ''),
(1314, '1279617741', 'PIPI影视', 'http://www.pipi.cn/', 0, 0, 0, 2013, 0, 1, 1300704500, NULL, 4, '', ''),
(1315, '1279617741', 'UUSee网络电视', 'http://www.uusee.com/', 0, 0, 0, 2013, 0, 1, 1300704550, NULL, 5, '', ''),
(1316, '1279617741', '一起又看流星雨', 'http://www.qiyi.com/dianshiju/yqyklxy.html', 0, 0, 0, 2014, 0, 1, 1300669879, NULL, 11, '', ''),
(1317, '1279617741', '大西南剿匪记', 'http://www.qiyi.com/dianshiju/dxnjfj.html', 0, 0, 0, 2014, 0, 1, 1300669879, NULL, 12, '', ''),
(1318, '1279617741', '单身公主相亲记', 'http://www.qiyi.com/dianshiju/dsgzxqj.html', 0, 0, 0, 2014, 0, 1, 1300669879, NULL, 13, '', ''),
(1319, '1279617741', '娘家的故事第2部', 'http://www.qiyi.com/dianshiju/njdgszadjz.html', 0, 0, 0, 2014, 0, 1, 1300669879, NULL, 14, '', ''),
(1320, '1279617741', 'TOM365免费电影', 'http://www.tom365.cc/', 0, 0, 0, 2015, 0, 1, 1302972329, NULL, 8, '', ''),
(1321, '1279617741', '播放免费电影', 'http://www.bofang.la/', 0, 0, 0, 2015, 0, 1, 1302972408, NULL, 9, '', ''),
(1322, '1279617741', '9036免费电影', 'http://www.9036.com/', 0, 0, 0, 2015, 0, 1, 1302972414, NULL, 10, '', ''),
(1323, '1279617741', '52PZ免费影视', 'http://www.52pz.com/', 0, 0, 0, 2015, 0, 1, 1302972418, NULL, 11, '', ''),
(1324, '1279617741', '跑跑免费电影', 'http://www.ddoo.cc/', 0, 0, 0, 2015, 0, 1, 1302972439, NULL, 12, '', ''),
(1325, '1279617741', 'BTchina', 'http://www.btchina.net/', 0, 0, 0, 2015, 0, 1, 1302972439, NULL, 13, '', ''),
(1326, '1279617741', 'VeryCD', 'http://www.verycd.com/', 0, 0, 0, 2015, 0, 1, 1302972440, NULL, 14, '', ''),
(1327, '1279617741', '电影天堂', 'http://www.dygod.net/', 0, 0, 0, 2015, 0, 1, 1302972441, NULL, 15, '', ''),
(1328, '1279617741', '冰鱼综艺BT下载', 'http://bt.icefish.org/', 0, 0, 0, 2015, 0, 1, 1302972442, NULL, 16, '', ''),
(1329, '1279617741', '贪婪大陆', 'http://bt.greedland.net/', 0, 0, 0, 2015, 0, 1, 1302972447, NULL, 17, '', ''),
(1330, '1279617741', '影视帝国', 'http://cnxp.77ck.com/', 0, 0, 0, 2015, 0, 1, 1302972509, NULL, 25, '', ''),
(1331, '1279617741', '狗狗影视搜索', 'http://www.gougou.com/', 0, 0, 0, 2015, 0, 1, 1302972508, NULL, 27, '', ''),
(1332, '1279617741', '极影动漫BT', 'http://bt.ktxp.com/', 0, 0, 0, 2015, 0, 1, 1302972507, NULL, 28, '', ''),
(1333, '1279617741', '黑亮综艺BT', 'http://bt.hliang.com/', 0, 0, 0, 2015, 0, 1, 1302972507, NULL, 29, '', ''),
(1334, '1279617741', '快车电影下载', 'http://movie.kuaiche.com/', 1, 0, 0, 2015, 0, 1, 1302972506, NULL, 30, '', ''),
(1335, '1279617741', '网易娱乐-电影频道', 'http://ent.163.com/movie/', 0, 0, 0, 2016, 0, 1, 0, NULL, 1, '', ''),
(1336, '1279617741', '腾讯娱乐-电影频道', 'http://ent.qq.com/movie/', 0, 0, 0, 2016, 0, 1, 0, NULL, 2, '', ''),
(1337, '1279617741', '新浪-电影频道', 'http://ent.sina.com.cn/film', 0, 0, 0, 2016, 0, 1, 0, NULL, 3, '', ''),
(1338, '1279617741', 'Mtime时光网', 'http://www.mtime.com/', 0, 0, 0, 2016, 0, 1, 0, NULL, 4, '', ''),
(1339, '1279617741', '雅虎电影频道', 'http://ent.cn.yahoo.com/movies/', 0, 0, 0, 2016, 0, 1, 0, NULL, 5, '', ''),
(1340, '1279617741', '凤凰影视娱乐', 'http://ent.ifeng.com/movie/', 0, 0, 0, 2016, 0, 1, 0, NULL, 6, '', ''),
(1341, '1279617741', '穿帮网', 'http://www.chinabug.net', 0, 0, 0, 2016, 0, 1, 0, NULL, 7, '', ''),
(1342, '1279617741', '中国影视资料馆', 'http://www.cnmdb.com', 0, 0, 0, 2016, 0, 1, 0, NULL, 8, '', ''),
(1343, '1279617741', '中国电影网', 'http://www.chinafilm.com/', 0, 0, 0, 2016, 0, 1, 0, NULL, 9, '', ''),
(1344, '1279617741', '碟友网', 'http://www.dvd.com.cn/', 0, 0, 0, 2016, 0, 1, 0, NULL, 10, '', ''),
(1345, '1279617741', 'DVD新天地', 'http://www.dvd288.com', 0, 0, 0, 2016, 0, 1, 0, NULL, 11, '', ''),
(1346, '1279617741', 'DVD导刊', 'http://www.dvdspring.com', 0, 0, 0, 2016, 0, 1, 0, NULL, 12, '', ''),
(1347, '1279617741', '电影风向标', 'http://www.insun.com.cn', 0, 0, 0, 2016, 0, 1, 0, NULL, 15, '', ''),
(1349, '1279617741', '射手网', 'http://www.shooter.com.cn/', 0, 0, 0, 2017, 0, 1, 0, NULL, 1, '', ''),
(1350, '1279617741', '人人影视字幕站', 'http://yyets.net/listsubtitle.html', 0, 0, 0, 2017, 0, 1, 0, NULL, 2, '', ''),
(1351, '1279617741', 'SuBom中文字幕下载', 'http://www.subom.com/', 0, 0, 0, 2017, 0, 1, 0, NULL, 3, '', ''),
(1352, '1279617741', 'TLF中文字幕', 'http://tlfsubs.eastgame.net/', 0, 0, 0, 2017, 0, 1, 0, NULL, 4, '', ''),
(1353, '1279617741', 'OpenSuber字幕下载站', 'http://www.opensubtitles.com/zh', 0, 0, 0, 2017, 0, 1, 0, NULL, 5, '', ''),
(1354, '1279617741', '新浪新闻', 'http://news.sina.com.cn', 0, 0, 0, 2018, 0, 1, 0, NULL, 1, '', ''),
(1355, '1279617741', '新华网', 'http://www.xinhuanet.com/', 0, 0, 0, 2018, 0, 1, 0, NULL, 2, '', ''),
(1356, '1279617741', '腾讯新闻', 'http://news.qq.com', 0, 0, 0, 2018, 0, 1, 0, NULL, 3, '', ''),
(1357, '1279617741', '网易新闻', 'http://news.163.com', 0, 0, 0, 2018, 0, 1, 0, NULL, 4, '', ''),
(1358, '1279617741', '中新网', 'http://www.chinanews.com.cn', 0, 0, 0, 2018, 0, 1, 0, NULL, 5, '', ''),
(1359, '1279617741', '中国雅虎', 'http://cn.yahoo.com/?id=40020', 0, 0, 0, 2018, 0, 1, 0, NULL, 6, '', ''),
(1360, '1279617741', '搜狐新闻', 'http://news.sohu.com', 0, 0, 0, 2018, 0, 1, 0, NULL, 7, '', ''),
(1361, '1279617741', '人民网', 'http://www.people.com.cn', 0, 0, 0, 2018, 0, 1, 0, NULL, 8, '', ''),
(1362, '1279617741', '中华网新闻', 'http://news.china.com/', 0, 0, 0, 2018, 0, 1, 0, NULL, 9, '', ''),
(1363, '1279617741', 'CCTV新闻', 'http://news.cctv.com/', 0, 0, 0, 2018, 0, 1, 0, NULL, 10, '', ''),
(1364, '1279617741', '凤凰网', 'http://www.ifeng.com/', 0, 0, 0, 2018, 0, 1, 0, NULL, 11, '', ''),
(1365, '1279617741', '中国网', 'http://www.china.com.cn/index.htm', 0, 0, 0, 2018, 0, 1, 0, NULL, 12, '', ''),
(1366, '1279617741', '大洋网', 'http://www.dayoo.com', 0, 0, 0, 2018, 0, 1, 0, NULL, 13, '', ''),
(1367, '1279617741', '千龙网', 'http://www.qianlong.com', 0, 0, 0, 2018, 0, 1, 0, NULL, 14, '', ''),
(1368, '1279617741', '东方网', 'http://www.eastday.com', 0, 0, 0, 2018, 0, 1, 0, NULL, 15, '', ''),
(1369, '1279617741', 'CRI国际在线', 'http://gb.cri.cn/', 0, 0, 0, 2018, 0, 1, 0, NULL, 16, '', ''),
(1370, '1279617741', 'TOM新闻', 'http://news.tom.com', 0, 0, 0, 2018, 0, 1, 0, NULL, 17, '', ''),
(1371, '1279617741', '21CN新闻', 'http://news.21cn.com', 0, 0, 0, 2018, 0, 1, 0, NULL, 18, '', ''),
(1372, '1279617741', '光明网', 'http://www.gmw.cn', 0, 0, 0, 2018, 0, 1, 0, NULL, 19, '', ''),
(1373, '1279617741', '南方网', 'http://www.southcn.com/', 0, 0, 0, 2018, 0, 1, 0, NULL, 20, '', ''),
(1374, '1279617741', '中国经济网', 'http://www.ce.cn/', 0, 0, 0, 2018, 0, 1, 0, NULL, 21, '', ''),
(1375, '1279617741', '中国军网', 'http://www.pladaily.com.cn/', 0, 0, 0, 2018, 0, 1, 0, NULL, 22, '', ''),
(1376, '1279617741', '中国台湾网', 'http://www.chinataiwan.org/', 0, 0, 0, 2018, 0, 1, 0, NULL, 23, '', ''),
(1377, '1279617741', '中国海峡网', 'http://www.haixiachina.com', 0, 0, 0, 2018, 0, 1, 0, NULL, 24, '', ''),
(1378, '1279617741', '星岛环球网', 'http://www.stnn.cc', 0, 0, 0, 2018, 0, 1, 0, NULL, 25, '', ''),
(1379, '1279617741', '环球时报', 'http://www.huanqiu.com/', 0, 0, 0, 2018, 0, 1, 0, NULL, 26, '', ''),
(1380, '1279617741', '联合早报', 'http://www.zaobao.com', 0, 0, 0, 2018, 0, 1, 0, NULL, 27, '', ''),
(1381, '1279617741', '红网', 'http://www.rednet.cn/', 0, 0, 0, 2018, 0, 1, 0, NULL, 28, '', ''),
(1382, '1279617741', '长江网', 'http://www.cjn.cn', 0, 0, 0, 2018, 0, 1, 0, NULL, 29, '', ''),
(1383, '1279617741', '每日经济新闻', 'http://www.nbd.com.cn/', 0, 0, 0, 2018, 0, 1, 0, NULL, 30, '', ''),
(1384, '1279617741', '人民网强国社区', 'http://bbs.people.com.cn/', 0, 0, 0, 2019, 0, 1, 0, NULL, 1, '', ''),
(1385, '1279617741', '新华网论坛', 'http://forum.home.news.cn/', 0, 0, 0, 2019, 0, 1, 1292223097, NULL, 2, '', ''),
(1386, '1279617741', '凤凰网论坛', 'http://bbs.ifeng.com/', 0, 0, 0, 2019, 0, 1, 0, NULL, 3, '', ''),
(1387, '1279617741', '铁血社区', 'http://bbs.tiexue.net/', 0, 0, 0, 2019, 0, 1, 0, NULL, 4, '', ''),
(1388, '1279617741', '天涯国际观察', 'http://www.tianya.cn/Publicforum/ArticlesList/0/worldlook.shtml', 0, 0, 0, 2019, 0, 1, 0, NULL, 5, '', ''),
(1389, '1279617741', 'AB报-在线读报', 'http://www.abbao.cn/', 0, 0, 0, 2020, 0, 1, 0, NULL, 1, '', ''),
(1390, '1279617741', '南风窗', 'http://www.nfcmag.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 2, '', ''),
(1391, '1279617741', '南方周末', 'http://www.infzm.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 3, '', ''),
(1392, '1279617741', '华商报', 'http://hsb.hsw.cn/', 0, 0, 0, 2020, 0, 1, 0, NULL, 4, '', ''),
(1393, '1279617741', '大河报', 'http://www.dahe.cn/', 0, 0, 0, 2020, 0, 1, 0, NULL, 5, '', ''),
(1394, '1279617741', '香港文汇报', 'http://www.wenweipo.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 6, '', ''),
(1395, '1279617741', '大公报', 'http://www.takungpao.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 7, '', ''),
(1396, '1279617741', '中国日报', 'http://www.chinadaily.com.cn/', 0, 0, 0, 2020, 0, 1, 0, NULL, 8, '', ''),
(1397, '1279617741', '广西新闻网', 'http://www.gxnews.com.cn/', 0, 0, 0, 2020, 0, 1, 0, NULL, 9, '', ''),
(1398, '1279617741', '北京青年报', 'http://bjyouth.ynet.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 10, '', ''),
(1399, '1279617741', '山西新闻网', 'http://www.daynews.com.cn/', 0, 0, 0, 2020, 0, 1, 0, NULL, 11, '', ''),
(1400, '1279617741', '黑龙江东北网', 'http://www.dbw.cn/', 0, 0, 0, 2020, 0, 1, 0, NULL, 12, '', ''),
(1401, '1279617741', '福建东南新闻网', 'http://www.fjsen.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 13, '', ''),
(1402, '1279617741', '新京报', 'http://www.bjnews.com.cn/', 0, 0, 0, 2020, 0, 1, 1292223130, NULL, 14, '', ''),
(1403, '1279617741', '南方都市报', 'http://nd.oeeee.com/', 0, 0, 0, 2020, 0, 1, 1292223160, NULL, 15, '', ''),
(1404, '1279617741', '燕赵都市报', 'http://yzdsb.hebnews.cn/', 0, 0, 0, 2020, 0, 1, 0, NULL, 16, '', ''),
(1405, '1279617741', '天津北方网', 'http://www.enorth.com.cn/', 0, 0, 0, 2020, 0, 1, 0, NULL, 17, '', ''),
(1406, '1279617741', '羊城晚报', 'http://www.ycwb.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 18, '', ''),
(1407, '1279617741', '扬子晚报', 'http://www.yangtse.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 19, '', ''),
(1408, '1279617741', '山东大众网', 'http://www.dzwww.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 20, '', ''),
(1409, '1279617741', 'ZCOM电子杂志', 'http://www.zcom.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 21, '', ''),
(1410, '1279617741', '楚天都市报', 'http://ctdsb.cnhubei.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 22, '', ''),
(1411, '1279617741', '三秦都市报', 'http://www.sanqindaily.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 23, '', ''),
(1412, '1279617741', '重庆华龙网', 'http://www.cqnews.net/', 0, 0, 0, 2020, 0, 1, 0, NULL, 24, '', ''),
(1413, '1279617741', '辽宁北国网', 'http://www.lnd.com.cn/', 0, 0, 0, 2020, 0, 1, 0, NULL, 25, '', ''),
(1414, '1279617741', '英国BBC', 'http://www.bbc.co.uk/china/', 0, 0, 0, 2020, 0, 1, 0, NULL, 26, '', ''),
(1415, '1279617741', '纽约时报', 'http://www.nytimes.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 27, '', ''),
(1416, '1279617741', '美国CNN', 'http://www.cnn.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 28, '', ''),
(1417, '1279617741', '美国时代周刊', 'http://www.time.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 29, '', ''),
(1418, '1279617741', '德国之声', 'http://www.dw-world.de/chinese/', 1, 0, 0, 2020, 0, 1, 0, NULL, 30, '', ''),
(1419, '1279617741', '俄罗斯之声', 'http://www.ruvr.ru/index.php?lng=pek', 0, 0, 0, 2020, 0, 1, 0, NULL, 31, '', ''),
(1420, '1279617741', '环球时报英文版', 'http://www.globaltimes.cn/', 0, 0, 0, 2020, 0, 1, 0, NULL, 32, '', ''),
(1421, '1279617741', '华尔街日报', 'http://www.chinese.wsj.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 33, '', ''),
(1422, '1279617741', '韩国中央日报', 'http://chinese.joins.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 34, '', ''),
(1423, '1279617741', '英国路透社', 'http://www.reuters.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 35, '', ''),
(1424, '1279617741', '纽约每日新闻', 'http://www.nydailynews.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 36, '', ''),
(1425, '1279617741', '华盛顿新闻报', 'http://www.newsday.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 37, '', ''),
(1426, '1279617741', '美国新闻周刊', 'http://www.newsweek.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 38, '', ''),
(1427, '1279617741', '英国泰晤士报', 'http://www.timesonline.co.uk/', 0, 0, 0, 2020, 0, 1, 0, NULL, 39, '', ''),
(1428, '1279617741', '朝鲜日报(韩国)', 'http://chn.chosun.com/', 0, 0, 0, 2020, 0, 1, 0, NULL, 40, '', ''),
(1429, '1279617741', '起点中文网', 'http://www.qidian.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 1, '', ''),
(1430, '1279617741', '读小说', 'http://www.duxiaoshuo.com', 0, 0, 0, 2021, 0, 1, 1303880530, NULL, 2, '', '#FF0000'),
(1431, '1279617741', '红袖添香', 'http://www.hongxiu.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 3, '', ''),
(1432, '1279617741', '原文小说网', 'http://www.yuanwen.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 4, '', ''),
(1433, '1279617741', '来书小说', 'http://www.laishu.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 5, '', ''),
(1434, '1279617741', '幻剑书盟', 'http://html.hjsm.tom.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 6, '', ''),
(1435, '1279617741', '言情小说吧', 'http://www.xs8.cn', 0, 0, 0, 2021, 0, 1, 0, NULL, 7, '', ''),
(1436, '1279617741', '晋江原创网', 'http://www.jjwxc.net/', 0, 0, 0, 2021, 0, 1, 0, NULL, 8, '', ''),
(1437, '1279617741', '17K文学网', 'http://www.17k.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 9, '', ''),
(1438, '1279617741', '潇湘言情小说', 'http://www.xxsy.net/', 0, 0, 0, 2021, 0, 1, 0, NULL, 10, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(1439, '1279617741', '逐浪文学网', 'http://www.zhulang.com', 0, 0, 0, 2021, 0, 1, 0, NULL, 11, '', ''),
(1440, '1279617741', '看书小说网', 'http://www.qukanshu.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 12, '', ''),
(1441, '1279617741', '翠微居小说', 'http://www.cuiweiju.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 13, '', ''),
(1442, '1279617741', '九滨免费小说', 'http://www.9bin.com', 0, 0, 0, 2021, 0, 1, 0, NULL, 14, '', ''),
(1443, '1279617741', '四月天原创网', 'http://www.4yt.net/', 0, 0, 0, 2021, 0, 1, 0, NULL, 15, '', ''),
(1444, '1279617741', '心动言情网', 'http://www.xdyqw.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 16, '', ''),
(1445, '1279617741', '梦想文学网', 'http://www.mx99.com', 0, 0, 0, 2021, 0, 1, 0, NULL, 17, '', ''),
(1446, '1279617741', '小说天下网', 'http://www.e193.net', 0, 0, 0, 2021, 0, 1, 1300672459, NULL, 18, '', ''),
(1447, '1279617741', '玄幻天空小说网', 'http://www.xhsky.net/', 0, 0, 0, 2021, 0, 1, 0, NULL, 19, '', ''),
(1448, '1279617741', '好心情原创文学', 'http://www.goodmood.cn', 0, 0, 0, 2021, 0, 1, 0, NULL, 20, '', ''),
(1449, '1279617741', '玄幻小说林', 'http://www.22xs.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 21, '', ''),
(1450, '1279617741', '爱小说网', 'http://www.22xs.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 22, '', ''),
(1451, '1279617741', '风云小说', 'http://www.fy01.cc/', 0, 0, 0, 2021, 0, 1, 1292903667, NULL, 24, '', ''),
(1452, '1279617741', '世纪小说网', 'http://www.2100book.com/', 0, 0, 0, 2021, 0, 1, 0, NULL, 25, '', ''),
(1453, '1279617741', '在线漫画', 'http://www.9ro.com', 0, 0, 0, 2021, 0, 1, 1302317351, NULL, 26, '', ''),
(1454, '1279617741', '飞库', 'http://www.feiku.com/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1455, '1279617741', '天下电子书', 'http://www.txdzs.com/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1456, '1279617741', '云轩阁', 'http://www.yunxuange.net/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1457, '1279617741', '狗狗书籍', 'http://book.gougou.com/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1458, '1279617741', '久久小说网', 'http://www.txt99.com/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1459, '1279617741', '悠悠书盟', 'http://uutxt.com/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1460, '1279617741', '派派小说论坛', 'http://www.paipaitxt.com/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1462, '1279617741', '爱txt电子书论坛', 'http://www.aitxt.com/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1463, '1279617741', '书香门第', 'http://bbs.txtnovel.com/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1464, '1279617741', '爬书网', 'http://www.pashu.org/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1465, '1279617741', 'txt论坛', 'http://www.txtbbs.com/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1466, '1279617741', '非凡txt论坛', 'http://www.txtxz.com/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1467, '1279617741', '橘园小说社区', 'http://bbs.jooyoo.net/', 0, 0, 0, 2022, 0, 1, 0, NULL, 1, '', ''),
(1468, '1279617741', '腾讯读书', 'http://book.qq.com/', 0, 0, 0, 2023, 0, 1, 0, NULL, 1, '', ''),
(1469, '1279617741', '搜狐读书', 'http://book.sohu.com/', 0, 0, 0, 2023, 0, 1, 0, NULL, 2, '', ''),
(1470, '1279617741', '新浪读书', 'http://book.sina.com.cn/', 0, 0, 0, 2023, 0, 1, 0, NULL, 3, '', ''),
(1471, '1279617741', '且听风吟', 'http://wind.yinsha.com/', 0, 0, 0, 2023, 0, 1, 0, NULL, 4, '', ''),
(1472, '1279617741', '豆瓣读书-书评', 'http://www.douban.com/book', 0, 0, 0, 2023, 0, 1, 0, NULL, 5, '', ''),
(1473, '1279617741', '和讯读书', 'http://book.hexun.com', 0, 0, 0, 2023, 0, 1, 0, NULL, 6, '', ''),
(1474, '1279617741', '书生读吧', 'http://www.du8.com/', 0, 0, 0, 2023, 0, 1, 0, NULL, 7, '', ''),
(1475, '1279617741', '言兑网-经典语录', 'http://www.yandui.com/', 0, 0, 0, 2023, 0, 1, 0, NULL, 8, '', ''),
(1476, '1279617741', '榕树下', 'http://www.rongshuxia.com/', 0, 0, 0, 2023, 0, 1, 0, NULL, 9, '', ''),
(1477, '1279617741', '《读者》网络版', 'http://www.duzhe.com/', 0, 0, 0, 2023, 0, 1, 0, NULL, 10, '', ''),
(1478, '1279617741', '中华诗词网', 'http://www.zhsc.net/', 0, 0, 0, 2023, 0, 1, 0, NULL, 11, '', ''),
(1479, '1279617741', '文章阅读网', 'http://www.duwenzhang.com', 0, 0, 0, 2023, 0, 1, 0, NULL, 12, '', ''),
(1480, '1279617741', '国家图书馆', 'http://www.nlc.gov.cn/', 0, 0, 0, 2023, 0, 1, 0, NULL, 13, '', ''),
(1481, '1279617741', '白鹿书院', 'http://www.cnblsy.com/', 0, 0, 0, 2023, 0, 1, 0, NULL, 14, '', ''),
(1482, '1279617741', '小故事网', 'http://www.xiaogushi.com', 0, 0, 0, 2023, 0, 1, 0, NULL, 15, '', ''),
(1483, '1279617741', '福昕pdf阅读器', 'http://www.fuxinsoftware.com.cn/pdf/reader/', 0, 0, 0, 2024, 0, 1, 0, NULL, 1, '', ''),
(1484, '1279617741', '书之城小说下载阅读器', 'http://www.mybook66.com/', 0, 0, 0, 2024, 0, 1, 0, NULL, 2, '', ''),
(1485, '1279617741', '最爱小说下载阅读器', 'http://www.incrm.cn/', 0, 0, 0, 2024, 0, 1, 0, NULL, 3, '', ''),
(1486, '1279617741', 'TXT小说阅读器', 'http://www.txtzao.com/', 0, 0, 0, 2024, 0, 1, 0, NULL, 4, '', ''),
(1487, '1279617741', '中华网军事', 'http://military.china.com/', 0, 0, 0, 2025, 0, 1, 0, NULL, 1, '', ''),
(1488, '1279617741', '铁血军事', 'http://www.tiexue.net', 0, 0, 0, 2025, 0, 1, 1301325679, NULL, 3, '', ''),
(1489, '1279617741', '新华网-军事', 'http://www.xinhua.org/mil/', 0, 0, 0, 2025, 0, 1, 0, NULL, 3, '', ''),
(1490, '1279617741', '新浪军事', 'http://mil.news.sina.com.cn/', 0, 0, 0, 2025, 0, 1, 1292897167, NULL, 4, '', ''),
(1491, '1279617741', '凤凰网军事', 'http://news.ifeng.com/mil/', 0, 0, 0, 2025, 0, 1, 0, NULL, 5, '', ''),
(1492, '1279617741', '腾讯-军事', 'http://news.qq.com/militery.shtml', 0, 0, 0, 2025, 0, 1, 0, NULL, 6, '', ''),
(1493, '1279617741', '千龙军事', 'http://mil.qianlong.com', 0, 0, 0, 2025, 0, 1, 0, NULL, 7, '', ''),
(1494, '1279617741', '人民网-军事', 'http://military.people.com.cn/', 0, 0, 0, 2025, 0, 1, 0, NULL, 8, '', ''),
(1495, '1279617741', '搜狐军事', 'http://mil.news.sohu.com', 0, 0, 0, 2025, 0, 1, 0, NULL, 9, '', ''),
(1496, '1279617741', '西陆军事', 'http://junshi.xilu.com/', 0, 0, 0, 2025, 0, 1, 0, NULL, 10, '', ''),
(1497, '1279617741', '复兴网军事', 'http://www.fxingw.com/', 0, 0, 0, 2025, 0, 1, 1301637544, NULL, 11, '', ''),
(1498, '1279617741', '米尔军事网', 'http://www.junshijia.com/', 0, 0, 0, 2025, 0, 1, 0, NULL, 12, '', ''),
(1499, '1279617741', '海峡军事频道', 'http://mil.fjii.com/', 0, 0, 0, 2025, 0, 1, 0, NULL, 13, '', ''),
(1500, '1279617741', '中国军网', 'http://www.chinamil.com.cn', 0, 0, 0, 2025, 0, 1, 0, NULL, 14, '', ''),
(1501, '1279617741', '中国军人网', 'http://www.junren.net/', 0, 0, 0, 2025, 0, 1, 0, NULL, 15, '', ''),
(1502, '1279617741', '中国国防部', 'http://www.mod.gov.cn/', 0, 0, 0, 2025, 0, 1, 0, NULL, 16, '', ''),
(1503, '1279617741', '新军事网', 'http://www.xinjunshi.com/', 0, 0, 0, 2025, 0, 1, 0, NULL, 18, '', ''),
(1504, '1279617741', '全球军事网', 'http://www.militaryy.cn', 0, 0, 0, 2025, 0, 1, 0, NULL, 21, '', ''),
(1506, '1279617741', '中国空军网', 'http://www.plaaf.net', 0, 0, 0, 2025, 0, 1, 0, NULL, 23, '', ''),
(1507, '1279617741', '新华网军事论坛', 'http://forum.xinhuanet.com/listtopic.jsp?bid=92', 0, 0, 0, 2026, 0, 1, 0, NULL, 1, '', ''),
(1508, '1279617741', '中华网军事论坛', 'http://bbs.military.china.com', 0, 0, 0, 2026, 0, 1, 0, NULL, 2, '', ''),
(1509, '1279617741', '铁血论坛', 'http://bbs.tiexue.net', 0, 0, 0, 2026, 0, 1, 0, NULL, 3, '', ''),
(1510, '1279617741', '超级大本营军事论坛', 'http://bbs.cjdby.net/', 0, 0, 0, 2026, 0, 1, 0, NULL, 4, '', ''),
(1511, '1279617741', '大旗军事论坛', 'http://junshi.daqi.com/', 0, 0, 0, 2026, 0, 1, 0, NULL, 5, '', ''),
(1512, '1279617741', '新浪军事论坛', 'http://club.mil.news.sina.com.cn/', 0, 0, 0, 2026, 0, 1, 1292897170, NULL, 6, '', ''),
(1513, '1279617741', '环球军事论坛', 'http://bbs.huanqiu.com/huanqiujunshi/forum-7-1.html', 0, 0, 0, 2026, 0, 1, 0, NULL, 7, '', ''),
(1514, '1279617741', '前线军事社区', 'http://www.qxwar.net/', 0, 0, 0, 2026, 0, 1, 1300672203, NULL, 8, '', ''),
(1515, '1279617741', '西陆军事论坛', 'http://club.xilu.com/mainpagelist.php?typeid=2', 0, 0, 0, 2026, 0, 1, 0, NULL, 10, '', ''),
(1516, '1279617741', '华声军事天地', 'http://bbs.voc.com.cn/forum-12-1.html', 0, 0, 0, 2026, 0, 1, 0, NULL, 11, '', ''),
(1517, '1279617741', '中国军网国防社区', 'http://www.chinamil.com.cn/site1/gwgfsq/index.htm', 0, 0, 0, 2026, 0, 1, 0, NULL, 12, '', ''),
(1518, '1279617741', '军人论坛', 'http://bbs.junren.net/', 0, 0, 0, 2026, 0, 1, 0, NULL, 13, '', ''),
(1519, '1279617741', '八一军事论坛', 'http://bbs.81jun.com', 0, 0, 0, 2026, 0, 1, 0, NULL, 14, '', ''),
(1520, '1279617741', '大旗贴图', 'http://pic.daqi.com', 0, 0, 0, 2027, 0, 1, 0, NULL, 1, '', ''),
(1521, '1279617741', '雅虎图片', 'http://image.cn.yahoo.com/', 0, 0, 0, 2027, 0, 1, 0, NULL, 2, '', ''),
(1522, '1279617741', '腾讯图库', 'http://ent.qq.com/picture.shtml', 0, 0, 0, 2027, 0, 1, 0, NULL, 3, '', ''),
(1523, '1279617741', '扫图地带', 'http://www.youzi4.com/', 0, 0, 0, 2027, 0, 1, 0, NULL, 4, '', ''),
(1524, '1279617741', '新华网图片', 'http://www.xinhuanet.com/photo/', 0, 0, 0, 2027, 0, 1, 0, NULL, 5, '', ''),
(1525, '1279617741', 'TIME时代图片', 'http://www.phototime.cn/', 0, 0, 0, 2027, 0, 1, 0, NULL, 6, '', ''),
(1526, '1279617741', '新浪图酷', 'http://news.sina.com.cn/photo/', 0, 0, 0, 2027, 0, 1, 0, NULL, 7, '', ''),
(1527, '1279617741', '爱丽图库', 'http://www.27.cn/jptk/index.html', 0, 0, 0, 2027, 0, 1, 0, NULL, 8, '', ''),
(1528, '1279617741', '太平洋时尚图库', 'http://www.pclady.com.cn/photo/', 0, 0, 0, 2027, 0, 1, 0, NULL, 9, '', ''),
(1529, '1279617741', '中国学生网图片', 'http://www.6to23.com/pic/', 0, 0, 0, 2027, 0, 1, 0, NULL, 10, '', ''),
(1530, '1279617741', 'ChinaRen图吧', 'http://pic.chinaren.com', 0, 0, 0, 2027, 0, 1, 0, NULL, 11, '', ''),
(1531, '1279617741', '网易-图片中心', 'http://news.163.com/photo/', 0, 0, 0, 2027, 0, 1, 0, NULL, 12, '', ''),
(1532, '1279617741', '太平洋摄影部落', 'http://www.pconline.com.cn/digital/photo/', 0, 0, 0, 2027, 0, 1, 0, NULL, 13, '', ''),
(1533, '1279617741', '时尚男人', 'http://www.mrmodern.com/', 0, 0, 0, 2027, 0, 1, 0, NULL, 14, '', ''),
(1534, '1279617741', '美图秀秀', 'http://xiuxiu.meitu.com/', 0, 0, 0, 2027, 0, 1, 0, NULL, 15, '', ''),
(1535, '1279617741', '6188美图', 'http://www.6188.net/', 0, 0, 0, 2028, 0, 1, 1302173530, NULL, 1, '', ''),
(1536, '1279617741', '22mm美女写真', 'http://www.22mm.cn/', 0, 0, 0, 2028, 0, 1, 0, NULL, 2, '', ''),
(1537, '1279617741', '八百美女', 'http://www.800meinv.com/', 0, 0, 0, 2028, 0, 1, 1292567082, NULL, 3, '', ''),
(1538, '1279617741', '靓丽美图', 'http://www.meinvtp.net/', 0, 0, 0, 2028, 0, 1, 1292567106, NULL, 4, '', ''),
(1539, '1279617741', '909美女网', 'http://www.909mm.com/', 0, 0, 0, 2028, 0, 1, 1292567127, NULL, 5, '', ''),
(1540, '1279617741', '粉红家园', 'http://www.notome.com/', 0, 0, 0, 2028, 0, 1, 1292567143, NULL, 6, '', ''),
(1541, '1279617741', '美女图片', 'http://www.meinv86.com/', 0, 0, 0, 2028, 0, 1, 1292567160, NULL, 7, '', ''),
(1542, '1279617741', '美女车模', 'http://www.bitauto.com/meinv/', 0, 0, 0, 2028, 0, 1, 1292567175, NULL, 8, '', ''),
(1543, '1279617741', '美女之家', 'http://www.meinvzj.com/', 0, 0, 0, 2028, 0, 1, 1292567194, NULL, 9, '', ''),
(1544, '1279617741', '明星秀', 'http://www.mingxing.com/', 0, 0, 0, 2028, 0, 1, 1292567208, NULL, 10, '', ''),
(1545, '1279617741', '3lian素材', 'http://www.3lian.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1546, '1279617741', '思缘论坛', 'http://www.missyuan.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1547, '1279617741', 'GettyImages', 'http://www.gettyimages.cn/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1548, '1279617741', '昵图网', 'http://www.nipic.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1549, '1279617741', '素材天下', 'http://www.sucaitianxia.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1550, '1279617741', '猫猫壁纸酷', 'http://www.wallcoo.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1551, '1279617741', '桌面城市', 'http://www.deskcity.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1552, '1279617741', '爱图网', 'http://www.aiimg.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1553, '1279617741', 'picasa', 'http://picasa.google.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1554, '1279617741', '吐司网', 'http://cn.tucia.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1555, '1279617741', '美图秀秀', 'http://xiuxiu.meitu.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1556, '1279617741', '我图网', 'http://www.ooopic.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1557, '1279617741', '中华图网', 'http://www.cntuw.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1558, '1279617741', '粉泥网', 'http://www.funnywow.cn/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1559, '1279617741', '可牛影像', 'http://yx.keniu.com/', 0, 0, 0, 2029, 0, 1, 0, NULL, 1, '', ''),
(1560, '1279617741', '土豆动漫频道', 'http://cartoon.tudou.com/', 0, 0, 0, 2030, 0, 1, 0, NULL, 1, '', ''),
(1561, '1279617741', '56动漫频道', 'http://dm.56.com/', 0, 0, 0, 2030, 0, 1, 0, NULL, 2, '', ''),
(1562, '1279617741', 'ku6动漫频道', 'http://www.ku6.com/comic/', 0, 0, 0, 2030, 0, 1, 0, NULL, 3, '', ''),
(1563, '1279617741', 'B9高清动漫', 'http://up.b9dm.com', 0, 0, 0, 2030, 0, 1, 0, NULL, 4, '', ''),
(1564, '1279617741', '看撒动漫', 'http://www.kan3.com', 0, 0, 0, 2030, 0, 1, 0, NULL, 5, '', ''),
(1565, '1279617741', '死神中文网', 'http://sishen.52pk.com/', 0, 0, 0, 2030, 0, 1, 0, NULL, 6, '', ''),
(1566, '1279617741', '海贼王中文网', 'http://op.52pk.com/', 0, 0, 0, 2030, 0, 1, 0, NULL, 7, '', ''),
(1567, '1279617741', '火影忍者中文网', 'http://www.narutom.com/', 0, 0, 0, 2030, 0, 1, 0, NULL, 8, '', ''),
(1568, '1279617741', '腾讯动漫频道', 'http://comic.qq.com', 0, 0, 0, 2031, 0, 1, 0, NULL, 1, '', ''),
(1569, '1279617741', '闲人动漫', 'http://www.idler-et.com/', 0, 0, 0, 2031, 0, 1, 0, NULL, 2, '', ''),
(1570, '1279617741', '搜狐动漫频道', 'http://comic.chinaren.com', 0, 0, 0, 2031, 0, 1, 0, NULL, 3, '', ''),
(1571, '1279617741', '中国动画网', 'http://www.chinanim.com/', 0, 0, 0, 2031, 0, 1, 0, NULL, 4, '', ''),
(1572, '1279617741', '中国漫画网', 'http://www.zhongman.com/', 0, 0, 0, 2031, 0, 1, 0, NULL, 5, '', ''),
(1573, '1279617741', '枫雪动漫', 'http://www.fxdm.net/', 0, 0, 0, 2031, 0, 1, 0, NULL, 6, '', ''),
(1574, '1279617741', '新浪卡通动漫', 'http://comic.book.sina.com.cn/', 0, 0, 0, 2031, 0, 1, 0, NULL, 7, '', ''),
(1575, '1279617741', '盒子动漫', 'http://comic.zanba.com/', 0, 0, 0, 2031, 0, 1, 0, NULL, 8, '', ''),
(1576, '1279617741', 'COMICV 动漫情报网', 'http://www.comicv.com/', 0, 0, 0, 2031, 0, 1, 0, NULL, 9, '', ''),
(1577, '1279617741', '凯神网', 'http://www.kaicn.com/index.html', 1, 0, 0, 2031, 0, 1, 0, NULL, 10, '', ''),
(1578, '1279617741', '动漫国动漫网', 'http://www.dmguo.com', 0, 0, 0, 2031, 0, 1, 0, NULL, 11, '', ''),
(1579, '1279617741', '动漫无限', 'http://www.comicer.com/', 0, 0, 0, 2031, 0, 1, 0, NULL, 12, '', ''),
(1580, '1279617741', '动漫歌曲试听', 'http://www.haoting.com/index/haoting_10.htm', 0, 0, 0, 2031, 0, 1, 0, NULL, 13, '', ''),
(1581, '1279617741', '每日动漫', 'http://www.aicomic.com/', 1, 0, 0, 2031, 0, 1, 0, NULL, 14, '', ''),
(1582, '1279617741', '动漫网', 'http://www.dongman.net', 1, 0, 0, 2031, 0, 1, 0, NULL, 15, '', ''),
(1583, '1279617741', 'BTchina-动漫', 'http://bt.btchina.net/?categoryid=4', 0, 0, 0, 2032, 0, 1, 0, NULL, 1, '', ''),
(1584, '1279617741', '动漫花园BT下载', 'http://share.dmhy.org/', 0, 0, 0, 2032, 0, 1, 0, NULL, 2, '', ''),
(1585, '1279617741', 'VeryCd 动漫下载', 'http://www.verycd.com/sto/cartoon/', 0, 0, 0, 2032, 0, 1, 0, NULL, 3, '', ''),
(1586, '1279617741', '卡通空间-动漫下载', 'http://bt.ktkj.com', 1, 0, 0, 2032, 0, 1, 0, NULL, 4, '', ''),
(1587, '1279617741', '贪婪大陆-BT动漫下载', 'http://share.greedland.net/cache_html/0/default/DESC/1.htm', 0, 0, 0, 2032, 0, 1, 0, NULL, 5, '', ''),
(1588, '1279617741', '极影BT发布-动漫', 'http://bt.ktxp.com', 0, 0, 0, 2032, 0, 1, 0, NULL, 6, '', ''),
(1589, '1279617741', 'BT动漫城', 'http://bbs.yingkong.net/forum-index-9.htm', 0, 0, 0, 2032, 0, 1, 0, NULL, 7, '', ''),
(1590, '1279617741', '东西论坛社', 'http://www.520dx.com/', 0, 0, 0, 2032, 0, 1, 0, NULL, 8, '', ''),
(1591, '1279617741', '新浪星座', 'http://astro.sina.com.cn', 0, 0, 0, 2033, 0, 1, 0, NULL, 1, '', ''),
(1592, '1279617741', '网易星座', 'http://lady.163.com/special/00261PJK/constellation.html', 0, 0, 0, 2033, 0, 1, 0, NULL, 2, '', ''),
(1593, '1279617741', 'TOM星座', 'http://astro.tom.com/', 0, 0, 0, 2033, 0, 1, 0, NULL, 3, '', ''),
(1594, '1279617741', '雅虎星座', 'http://cn.astrology.yahoo.com', 0, 0, 0, 2033, 0, 1, 0, NULL, 4, '', ''),
(1595, '1279617741', '搜狐星相', 'http://astro.women.sohu.com/', 0, 0, 0, 2033, 0, 1, 1304680623, NULL, 6, '', ''),
(1596, '1279617741', '腾讯星座', 'http://astro.lady.qq.com', 0, 0, 0, 2033, 0, 1, 0, NULL, 6, '', ''),
(1597, '1279617741', '阿启网', 'http://www.aqioo.com', 0, 0, 0, 2033, 0, 1, 0, NULL, 7, '', ''),
(1598, '1279617741', '第一星座', 'http://www.d1xz.net', 0, 0, 0, 2033, 0, 1, 0, NULL, 8, '', ''),
(1599, '1279617741', '网络中国-星座', 'http://astro.httpcn.com', 0, 0, 0, 2033, 0, 1, 0, NULL, 9, '', ''),
(1600, '1279617741', '21CN星座', 'http://life.21cn.com/horoscope/horoscope/', 0, 0, 0, 2033, 0, 1, 0, NULL, 10, '', ''),
(1601, '1279617741', 'MSN星座', 'http://astro.msn.com.cn/', 0, 0, 0, 2033, 0, 1, 0, NULL, 11, '', ''),
(1602, '1279617741', 'VV星座站', 'http://astro.sunvv.com', 1, 0, 0, 2033, 0, 1, 0, NULL, 13, '', ''),
(1603, '1279617741', '好运网星座', 'http://www.1518.com/xzpd/index.html', 0, 0, 0, 2033, 0, 1, 0, NULL, 14, '', ''),
(1604, '1279617741', '星座算命网', 'http://www.05133.com/', 0, 0, 0, 2033, 0, 1, 0, NULL, 15, '', ''),
(1605, '1279617741', '奇摩星相', 'http://tw.astrology.yahoo.com/', 1, 0, 0, 2033, 0, 1, 0, NULL, 16, '', ''),
(1606, '1279617741', '新浪星座心理测试', 'http://astro.sina.com.cn/test', 0, 0, 0, 2033, 0, 1, 0, NULL, 22, '', ''),
(1607, '1279617741', '心理测试-39健康', 'http://xl.39.net/xlcs/', 0, 0, 0, 2033, 0, 1, 0, NULL, 23, '', ''),
(1608, '1279617741', '专业心理测验大全', 'http://www.psy-test.net', 0, 0, 0, 2033, 0, 1, 0, NULL, 24, '', ''),
(1609, '1279617741', 'Sohu心理测试', 'http://astro.women.sohu.com/ceshi.shtml', 0, 0, 0, 2033, 0, 1, 0, NULL, 25, '', ''),
(1610, '1279617741', '心理测试-硅谷动力', 'http://www.enet.com.cn/eschool/includes/zhuanti/zt/xinliceshi/40.shtml', 0, 0, 0, 2033, 0, 1, 0, NULL, 26, '', ''),
(1611, '1279617741', '瓷都取名算命', 'http://www.xingming.net/', 0, 0, 0, 2034, 0, 1, 0, NULL, 1, '', ''),
(1612, '1279617741', '逸名网', 'http://www.uname.cn/', 0, 0, 0, 2034, 0, 1, 0, NULL, 2, '', ''),
(1613, '1279617741', '中华取名网', 'http://www.chinaname.cn/', 0, 0, 0, 2034, 0, 1, 0, NULL, 3, '', ''),
(1614, '1279617741', '算命起名馆', 'http://www.zhangyufeng.com/', 0, 0, 0, 2034, 0, 1, 0, NULL, 4, '', ''),
(1615, '1279617741', '美名腾智能起名', 'http://www.meimingteng.com', 0, 0, 0, 2034, 0, 1, 0, NULL, 4, '', ''),
(1616, '1279617741', '三藏算命网', 'http://www.sheup.com', 0, 0, 0, 2034, 0, 1, 0, NULL, 6, '', ''),
(1617, '1279617741', '卜易居算命网', 'http://www.buyiju.com', 0, 0, 0, 2034, 0, 1, 0, NULL, 7, '', ''),
(1618, '1279617741', '中华隆起名网', 'http://www.qihaoming.com.cn/', 0, 0, 0, 2034, 0, 1, 0, NULL, 8, '', ''),
(1619, '1279617741', '科技紫微网', 'http://www.go108.com.cn/', 0, 0, 0, 2034, 0, 1, 0, NULL, 9, '', ''),
(1620, '1279617741', '非常运势网', 'http://www.99166.com/', 0, 0, 0, 2034, 0, 1, 0, NULL, 10, '', ''),
(1621, '1279617741', '元亨利贞网论坛', 'http://bbs.china95.net', 0, 0, 0, 2034, 0, 1, 0, NULL, 11, '', ''),
(1622, '1279617741', '中国周易预测网', 'http://www.chinazyycw.com', 0, 0, 0, 2034, 0, 1, 0, NULL, 12, '', ''),
(1623, '1279617741', '华易算命网', 'http://www.k366.com/', 0, 0, 0, 2034, 0, 1, 0, NULL, 13, '', ''),
(1624, '1279617741', '安康网起名算命', 'http://www.ankangwang.com/', 0, 0, 0, 2034, 0, 1, 0, NULL, 14, '', ''),
(1625, '1279617741', '吉祥起名网', 'http://www.51jixiang.com/', 0, 0, 0, 2034, 0, 1, 0, NULL, 15, '', ''),
(1626, '1279617741', '塔罗牌在线占卜', 'http://www.d1xz.net/tl/zb/', 0, 0, 0, 2034, 0, 1, 0, NULL, 17, '', ''),
(1627, '1279617741', '腾讯塔罗占卜', 'http://astro.lady.qq.com/tarot/', 0, 0, 0, 2034, 0, 1, 0, NULL, 19, '', ''),
(1628, '1279617741', '中华塔罗网', 'http://www.chinatarot.com/html/index.html', 0, 0, 0, 2034, 0, 1, 0, NULL, 20, '', ''),
(1629, '1279617741', '中华农历网', 'http://www.nongli.com/', 0, 0, 0, 2034, 0, 1, 0, NULL, 21, '', ''),
(1630, '1279617741', '中国起名网', 'http://www.nnn666.com/', 0, 0, 0, 2034, 0, 1, 0, NULL, 22, '', ''),
(1631, '1279617741', '新浪竞技风暴', 'http://sports.sina.com.cn/', 0, 0, 0, 2036, 0, 1, 0, NULL, 1, '', ''),
(1632, '1279617741', '搜狐体育', 'http://sports.sohu.com', 0, 0, 0, 2036, 0, 1, 0, NULL, 2, '', ''),
(1633, '1279617741', '鲨威体坛', 'http://sports.tom.com', 0, 0, 0, 2036, 0, 1, 0, NULL, 3, '', ''),
(1634, '1279617741', '华体网', 'http://www.sportscn.com', 0, 0, 0, 2036, 0, 1, 0, NULL, 4, '', ''),
(1635, '1279617741', '网易体育', 'http://sports.163.com', 0, 0, 0, 2036, 0, 1, 0, NULL, 5, '', ''),
(1636, '1279617741', '雅虎体育', 'http://sports.cn.yahoo.com/', 0, 0, 0, 2036, 0, 1, 0, NULL, 6, '', ''),
(1637, '1279617741', '腾讯体育', 'http://sports.qq.com', 0, 0, 0, 2036, 0, 1, 0, NULL, 7, '', ''),
(1638, '1279617741', 'ESPNSTAR中文网', 'http://www.espnstar.com.cn', 0, 0, 0, 2036, 0, 1, 0, NULL, 8, '', ''),
(1639, '1279617741', 'CCTV体育频道', 'http://sports.cctv.com/', 0, 0, 0, 2036, 0, 1, 0, NULL, 9, '', ''),
(1640, '1279617741', '人民网体育', 'http://sports.people.com.cn/', 0, 0, 0, 2036, 0, 1, 0, NULL, 10, '', ''),
(1641, '1279617741', '中华网体育', 'http://sports.china.com/zh_cn/', 0, 0, 0, 2036, 0, 1, 0, NULL, 11, '', ''),
(1642, '1279617741', '华奥星空', 'http://www.sports.cn', 0, 0, 0, 2036, 0, 1, 0, NULL, 12, '', ''),
(1643, '1279617741', '7M体育即时比分', 'http://www.7m.cn/', 0, 0, 0, 2036, 0, 1, 0, NULL, 12, '', ''),
(1644, '1279617741', '新华网体育', 'http://www.xinhuanet.com/sports/', 0, 0, 0, 2036, 0, 1, 0, NULL, 13, '', ''),
(1645, '1279617741', '21CN体育', 'http://sports.21cn.com', 0, 0, 0, 2036, 0, 1, 0, NULL, 14, '', ''),
(1646, '1279617741', '体坛网', 'http://www.titan24.com/', 0, 0, 0, 2036, 0, 1, 0, NULL, 15, '', ''),
(1647, '1279617741', '体总网', 'http://www.sport.gov.cn', 0, 0, 0, 2036, 0, 1, 0, NULL, 16, '', ''),
(1648, '1279617741', '新浪国际足球', 'http://sports.sina.com.cn/global/', 0, 0, 0, 2037, 0, 1, 0, NULL, 1, '', ''),
(1649, '1279617741', '新浪国内足球', 'http://sports.sina.com.cn/china/', 0, 0, 0, 2037, 0, 1, 0, NULL, 2, '', ''),
(1650, '1279617741', '搜狐国际足球', 'http://sports.sohu.com/guojizuqiu.shtml', 0, 0, 0, 2037, 0, 1, 0, NULL, 3, '', ''),
(1651, '1279617741', 'ESPN国际足球', 'http://www.espnstar.com.cn/new/international/', 0, 0, 0, 2037, 0, 1, 0, NULL, 4, '', ''),
(1652, '1279617741', '腾讯国际足球', 'http://sports.qq.com/isocce/', 0, 0, 0, 2037, 0, 1, 0, NULL, 5, '', ''),
(1653, '1279617741', '雪缘园', 'http://www.gooooal.com/', 0, 0, 0, 2037, 0, 1, 0, NULL, 6, '', ''),
(1654, '1279617741', '网易国际足球', 'http://sports.163.com/world/', 0, 0, 0, 2037, 0, 1, 0, NULL, 7, '', ''),
(1655, '1279617741', '第一足球网', 'http://www.1soccer.com/', 0, 0, 0, 2037, 0, 1, 0, NULL, 8, '', ''),
(1656, '1279617741', '江城足球网', 'http://www.jczqw.com/', 0, 0, 0, 2037, 0, 1, 0, NULL, 9, '', ''),
(1657, '1279617741', '中国足协', 'http://www.fa.org.cn/', 0, 0, 0, 2037, 0, 1, 0, NULL, 10, '', ''),
(1658, '1279617741', '完全实况论坛', 'http://bbs.winning11cn.com/', 0, 0, 0, 2037, 0, 1, 0, NULL, 11, '', ''),
(1659, '1279617741', '豪门球队贴吧', 'http://tieba.baidu.com/f?kw=football', 0, 0, 0, 2037, 0, 1, 0, NULL, 12, '', ''),
(1660, '1279617741', '天下足球网', 'http://www.qxzqw.com/', 0, 0, 0, 2037, 0, 1, 0, NULL, 13, '', ''),
(1661, '1279617741', '优酷足球视频', 'http://www.youku.com/v_showlist/t2c98g2085.html', 0, 0, 0, 2037, 0, 1, 0, NULL, 14, '', ''),
(1662, '1279617741', '新浪篮球', 'http://sports.sina.com.cn/basketball/', 0, 0, 0, 2038, 0, 1, 0, NULL, 1, '', ''),
(1663, '1279617741', 'cba官网', 'http://cbachina.163.com/', 0, 0, 0, 2038, 0, 1, 0, NULL, 2, '', ''),
(1664, '1279617741', 'CUBA', 'http://www.cuba.com.cn/', 0, 0, 0, 2038, 0, 1, 0, NULL, 3, '', ''),
(1665, '1279617741', 'ESPN篮球', 'http://www.espnstar.com.cn/new/basketball/', 0, 0, 0, 2038, 0, 1, 0, NULL, 4, '', ''),
(1666, '1279617741', '网易篮球', 'http://sports.163.com/page04/', 0, 0, 0, 2038, 0, 1, 0, NULL, 5, '', ''),
(1667, '1279617741', '搜狐篮球', 'http://sports.sohu.com/lanqiu.shtml', 0, 0, 0, 2038, 0, 1, 0, NULL, 6, '', ''),
(1668, '1279617741', '中国篮协', 'http://www.cba.gov.cn/', 0, 0, 0, 2038, 0, 1, 0, NULL, 7, '', ''),
(1669, '1279617741', '新新球鞋论坛', 'http://bbs.x-kicks.com/', 0, 0, 0, 2038, 0, 1, 0, NULL, 8, '', ''),
(1670, '1279617741', '新华网篮球', 'http://www.xinhuanet.com/sports/lqfb.htm', 0, 0, 0, 2038, 0, 1, 0, NULL, 9, '', ''),
(1671, '1279617741', '百度篮球吧', 'http://tieba.baidu.com/f?kw=%C0%BA%C7%F2', 0, 0, 0, 2038, 0, 1, 0, NULL, 10, '', ''),
(1672, '1279617741', '男篮世锦赛官网', 'http://fiba.qq.com/2010/', 0, 0, 0, 2038, 0, 1, 0, NULL, 11, '', ''),
(1673, '1279617741', 'NBA', 'http://sports.sina.com.cn/nba/', 0, 0, 0, 2039, 0, 1, 0, NULL, 1, '', ''),
(1674, '1279617741', '欧冠', 'http://sports.sina.com.cn/z/1011championsleague/', 0, 0, 0, 2039, 0, 1, 0, NULL, 2, '', ''),
(1675, '1279617741', '西甲', 'http://soccer.titan24.com/spain/', 0, 0, 0, 2039, 0, 1, 0, NULL, 3, '', ''),
(1676, '1279617741', '意甲', 'http://soccer.titan24.com/italy/', 0, 0, 0, 2039, 0, 1, 0, NULL, 4, '', ''),
(1677, '1279617741', '英超', 'http://soccer.titan24.com/england/', 0, 0, 0, 2039, 0, 1, 0, NULL, 5, '', ''),
(1678, '1279617741', 'wwe中文网', 'http://wwe.nubb.com/', 0, 0, 0, 2040, 0, 1, 0, NULL, 1, '', ''),
(1679, '1279617741', '39健身', 'http://sports.39.net/', 0, 0, 0, 2040, 0, 1, 0, NULL, 2, '', ''),
(1680, '1279617741', '拳击帝国', 'http://www.quanji.net/', 0, 0, 0, 2040, 0, 1, 0, NULL, 3, '', ''),
(1681, '1279617741', '新浪f1赛车', 'http://f1.sina.com.cn/', 0, 0, 0, 2040, 0, 1, 0, NULL, 1, '', ''),
(1682, '1279617741', '海峡钓鱼论坛', 'http://bbs.chinafishing.com/', 0, 0, 0, 2040, 0, 1, 0, NULL, 4, '', ''),
(1683, '1279617741', '中国羽球在线', 'http://www.badmintoncn.com/', 0, 0, 0, 2040, 0, 1, 0, NULL, 5, '', ''),
(1684, '1279617741', '天天羽毛球', 'http://www.ttymq.com/', 0, 0, 0, 2040, 0, 1, 0, NULL, 6, '', ''),
(1685, '1279617741', '新浪台球', 'http://sports.sina.com.cn/others/snooker.shtml', 0, 0, 0, 2040, 0, 1, 0, NULL, 7, '', ''),
(1686, '1279617741', '精英乒乓论坛', 'http://www.pingpang.info/bbs/index.asp', 0, 0, 0, 2040, 0, 1, 0, NULL, 8, '', ''),
(1687, '1279617741', '中国象棋大师网', 'http://www.zgxqds.com/', 0, 0, 0, 2040, 0, 1, 0, NULL, 9, '', ''),
(1688, '1279617741', 'NBA中文网', 'http://nba.tom.com/', 0, 0, 0, 2041, 0, 1, 0, NULL, 1, '', ''),
(1689, '1279617741', '新浪NBA', 'http://sports.sina.com.cn/nba/', 0, 0, 0, 2041, 0, 1, 0, NULL, 2, '', ''),
(1690, '1279617741', '搜狐NBA', 'http://sports.sohu.com/nba.shtml', 0, 0, 0, 2041, 0, 1, 0, NULL, 3, '', ''),
(1691, '1279617741', '网易NBA', 'http://sports.163.com/nba/', 0, 0, 0, 2041, 0, 1, 0, NULL, 4, '', ''),
(1692, '1279617741', '腾讯NBA', 'http://sports.qq.com/nba/', 0, 0, 0, 2041, 0, 1, 0, NULL, 5, '', ''),
(1693, '1279617741', '新华网NBA', 'http://www.xinhuanet.com/sports/nba.htm', 0, 0, 0, 2041, 0, 1, 0, NULL, 6, '', ''),
(1694, '1279617741', '虎扑NBA', 'http://www.hoopchina.com', 0, 0, 0, 2041, 0, 1, 0, NULL, 7, '', ''),
(1695, '1279617741', '21CN体育-NBA', 'http://sports.21cn.com/basketball/nba/', 0, 0, 0, 2041, 0, 1, 0, NULL, 8, '', ''),
(1696, '1279617741', 'WNBA官方网站', 'http://www.wnba.com/', 0, 0, 0, 2041, 0, 1, 0, NULL, 9, '', ''),
(1697, '1279617741', 'NBA官网直播', 'http://nba.tom.com/video', 0, 0, 0, 2042, 0, 1, 0, NULL, 1, '', ''),
(1698, '1279617741', '新传NBA视频', 'http://sports.nubb.com/nba/', 0, 0, 0, 2042, 0, 1, 0, NULL, 2, '', ''),
(1699, '1279617741', 'PPNBA直播', 'http://www.ppnba.com/', 0, 0, 0, 2042, 0, 1, 0, NULL, 3, '', ''),
(1700, '1279617741', '360播', 'http://www.360bo.com/', 0, 0, 0, 2042, 0, 1, 0, NULL, 4, '', ''),
(1701, '1279617741', '中国婚礼网', 'http://www.1wed.cn/', 0, 0, 0, 2043, 0, 1, 1301360715, NULL, 2, '', ''),
(1702, '1279617741', '中国结婚网', 'http://www.chinajiehun.com/', 0, 0, 0, 2043, 0, 1, 0, NULL, 2, '', ''),
(1703, '1279617741', '爱丽婚嫁网', 'http://wed.27.cn/', 0, 0, 0, 2043, 0, 1, 0, NULL, 3, '', ''),
(1704, '1279617741', '国际在线婚嫁', 'http://gb.cri.cn/fashion/brides.htm', 0, 0, 0, 2043, 0, 1, 0, NULL, 4, '', ''),
(1705, '1279617741', '世纪佳缘', 'http://www.love21cn.com', 0, 0, 0, 2043, 0, 1, 0, NULL, 5, '', ''),
(1706, '1279617741', '幸福婚嫁网', 'http://www.xfwed.com/', 0, 0, 0, 2043, 0, 1, 0, NULL, 6, '', ''),
(1707, '1279617741', '搜狐婚嫁频道', 'http://women.sohu.com/womenmarry/', 0, 0, 0, 2043, 0, 1, 0, NULL, 7, '', ''),
(1708, '1279617741', '非常婚礼', 'http://verywed.com/', 0, 0, 0, 2043, 0, 1, 0, NULL, 8, '', ''),
(1710, '1279617741', '我愿意结婚网', 'http://www.idoido.com.cn/', 0, 0, 0, 2043, 0, 1, 0, NULL, 10, '', ''),
(1711, '1279617741', '久久婚嫁网', 'http://www.99wed.com/', 0, 0, 0, 2043, 0, 1, 0, NULL, 11, '', ''),
(1712, '1279617741', '嫁我网', 'http://www.marry5.com/', 0, 0, 0, 2043, 0, 1, 0, NULL, 12, '', ''),
(1713, '1279617741', '591结婚网', 'http://www.591wed.com', 0, 0, 0, 2043, 0, 1, 0, NULL, 13, '', ''),
(1714, '1279617741', '军人征婚交友网', 'http://www.8181.com.cn/feeling/feeling.asp', 0, 0, 0, 2043, 0, 1, 0, NULL, 14, '', ''),
(1715, '1279617741', '中国婚纱摄影网', 'http://www.wedchina.com/', 0, 0, 0, 2043, 0, 1, 1300673331, NULL, 15, '', ''),
(1716, '1279617741', '人人网', 'http://www.renren.com', 0, 0, 0, 2044, 0, 1, 0, NULL, 1, '', ''),
(1717, '1279617741', '百合网', 'http://www.baihe.com/?policy=1&Channel=zyzt-wzz&Code=140026-5w', 0, 0, 0, 2044, 0, 1, 1295231463, NULL, 2, '', ''),
(1718, '1279617741', '爱情公寓', 'http://www.ipart.cn/show/market_frish_1.html', 0, 0, 0, 2044, 0, 1, 1289802910, NULL, 3, '', ''),
(1719, '1279617741', 'QQ交友中心', 'http://www.trueqq.com/', 0, 0, 0, 2044, 0, 1, 1300673369, NULL, 4, '', ''),
(1720, '1279617741', '猫扑Hi', 'http://hi.mop.com/', 0, 0, 0, 2044, 0, 1, 0, NULL, 5, '', ''),
(1721, '1279617741', '珍爱网', 'http://love.zhenai.com/901173.html', 0, 0, 0, 2044, 0, 1, 1301360617, NULL, 6, '', ''),
(1723, '1279617741', '51交友空间', 'http://www.51.com/', 0, 0, 0, 2044, 0, 1, 0, NULL, 8, '', ''),
(1724, '1279617741', '知己交友网', 'http://www.zhiji.com/', 0, 0, 0, 2044, 0, 1, 0, NULL, 9, '', ''),
(1725, '1279617741', 'MySpace聚友网', 'http://www.myspace.cn/', 0, 0, 0, 2044, 0, 1, 0, NULL, 10, '', ''),
(1726, '1279617741', '若邻网络', 'http://www.wealink.com/', 0, 0, 0, 2044, 0, 1, 0, NULL, 11, '', ''),
(1727, '1279617741', '我邻网', 'http://www.5lin.com', 0, 0, 0, 2044, 0, 1, 0, NULL, 12, '', ''),
(1728, '1279617741', '网易佳人有约', 'http://idate.163.com/', 0, 0, 0, 2044, 0, 1, 0, NULL, 13, '', ''),
(1729, '1279617741', '亿友交友网', 'http://www.yeeyoo.com', 0, 0, 0, 2044, 0, 1, 0, NULL, 14, '', ''),
(1730, '1279617741', '中国学生网-交友', 'http://www.6to23.com/', 0, 0, 0, 2044, 0, 1, 0, NULL, 15, '', ''),
(1731, '1279617741', '爱在这儿', 'http://www.loveinhere.com', 0, 0, 0, 2044, 0, 1, 0, NULL, 16, '', ''),
(1732, '1279617741', '白社会', 'http://bai.sohu.com/', 0, 0, 0, 2044, 0, 1, 0, NULL, 17, '', ''),
(1733, '1279617741', '网友天下', 'http://www.wangyou.com/', 0, 0, 0, 2044, 0, 1, 0, NULL, 18, '', ''),
(1734, '1279617741', '未名交友中国站', 'http://jiaoyou8.com/', 0, 0, 0, 2044, 0, 1, 0, NULL, 19, '', ''),
(1735, '1279617741', '赛我网', 'http://www.cyworld.com.cn/', 0, 0, 0, 2044, 0, 1, 0, NULL, 20, '', ''),
(1736, '1279617741', '知音', 'http://www.zhiyin.com.cn/', 0, 0, 0, 2045, 0, 1, 0, NULL, 1, '', ''),
(1737, '1279617741', '天涯社区情感天地', 'http://www.tianya.cn/publicforum/articleslist/0/feeling.shtml', 0, 0, 0, 2045, 0, 1, 1300673405, NULL, 2, '', ''),
(1738, '1279617741', '爱丽情感', 'http://www.27.cn/qgsh/index.html', 0, 0, 0, 2045, 0, 1, 0, NULL, 3, '', ''),
(1739, '1279617741', '新浪情感', 'http://eladies.sina.com.cn/feel/index.shtml', 0, 0, 0, 2045, 0, 1, 0, NULL, 4, '', ''),
(1740, '1279617741', '新情感网', 'http://www.e58.net', 0, 0, 0, 2045, 0, 1, 0, NULL, 5, '', ''),
(1741, '1279617741', '婚姻-搜狐女人', 'http://women.sohu.com/hunyinjiating.shtml', 0, 0, 0, 2045, 0, 1, 0, NULL, 6, '', ''),
(1743, '1279617741', '中国失恋网', 'http://www.loselove.cn', 0, 0, 0, 2045, 0, 1, 0, NULL, 8, '', ''),
(1744, '1279617741', '众心塔', 'http://www.zhongxinta.com', 0, 0, 0, 2045, 0, 1, 0, NULL, 9, '', ''),
(1745, '1289543571', '蹦蹦家园', 'http://www.bengbeng.com/', 0, 0, 0, 2045, 0, 1, 1289543571, NULL, 10, '', ''),
(1746, '1279617741', '新浪娱乐', 'http://ent.sina.com.cn/', 0, 0, 0, 2046, 0, 1, 0, NULL, 1, '', ''),
(1747, '1279617741', '腾讯娱乐', 'http://ent.qq.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 2, '', ''),
(1748, '1279617741', 'E视网娱乐', 'http://www.ewang.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 3, '', ''),
(1749, '1279617741', '百度娱乐', 'http://yule.baidu.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 4, '', ''),
(1750, '1279617741', '激动网-娱乐', 'http://ent.joy.cn/', 0, 0, 0, 2046, 0, 1, 0, NULL, 5, '', ''),
(1751, '1279617741', '搜狐娱乐', 'http://yule.sohu.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 6, '', ''),
(1752, '1279617741', '天涯娱乐八卦', 'http://www.tianya.cn/publicforum/articleslist/0/funinfo.shtml', 0, 0, 0, 2046, 0, 1, 0, NULL, 7, '', ''),
(1753, '1279617741', '网易娱乐', 'http://ent.163.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 8, '', ''),
(1754, '1279617741', '凤凰网娱乐', 'http://ent.ifeng.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 9, '', ''),
(1755, '1279617741', '明星博客', 'http://blog.sina.com.cn/lm/search/ent/index.html', 0, 0, 0, 2046, 0, 1, 0, NULL, 10, '', ''),
(1756, '1279617741', '明星全接触-新浪网', 'http://ent.sina.com.cn/star/', 0, 0, 0, 2046, 0, 1, 0, NULL, 11, '', ''),
(1757, '1279617741', '雅虎娱乐', 'http://ent.cn.yahoo.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 12, '', ''),
(1758, '1279617741', 'TOM娱乐', 'http://ent.tom.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 13, '', ''),
(1759, '1279617741', '粉丝网', 'http://www.ifensi.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 14, '', ''),
(1760, '1279617741', '中演票务通', 'http://www.piaowutong.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 15, '', ''),
(1761, '1279617741', '香港TVB娱乐', 'http://entertainment.tvb.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 16, '', ''),
(1762, '1279617741', '明星档案', 'http://data.yule.baidu.com/f', 0, 0, 0, 2046, 0, 1, 0, NULL, 17, '', ''),
(1763, '1279617741', '中国娱乐网', 'http://www.67.com/', 0, 0, 0, 2046, 0, 1, 0, NULL, 18, '', ''),
(1764, '1279617741', '百度贴吧-明星大全', 'http://tieba.baidu.com/f?ct=536870912&rn=200&pn=0&cm=1101&tn=simpleCategory&sn=%C3%F7%D0%C7%C8%CB%CE%EF', 0, 0, 0, 2046, 0, 1, 0, NULL, 19, '', ''),
(1765, '1279617741', '穿帮网', 'http://www.chinabug.net/', 0, 0, 0, 2046, 0, 1, 0, NULL, 20, '', ''),
(1766, '1279617741', '非诚勿扰', 'http://fcwr.jstv.com/', 0, 0, 0, 2047, 0, 1, 0, NULL, 1, '', ''),
(1767, '1279617741', '快乐大本营', 'http://video.baidu.com/v?word=%BF%EC%C0%D6%B4%F3%B1%BE%D3%AA&ct=301989888&rn=20&pn=0&db=0&s=0&fbl=800', 0, 0, 0, 2047, 0, 1, 0, NULL, 1, '', ''),
(1768, '1279617741', '幸福魔方', 'http://video.baidu.com/v?word=%D0%D2%B8%A3%C4%A7%B7%BD&ct=301989888&rn=20&pn=0&db=0&s=0&fbl=800', 0, 0, 0, 2047, 0, 1, 0, NULL, 2, '', ''),
(1769, '1279617741', '天天向上', 'http://video.baidu.com/v?word=%CC%EC%CC%EC%CF%F2%C9%CF&ct=301989888&rn=20&pn=0&db=0&s=0&fbl=800', 0, 0, 0, 2047, 0, 1, 0, NULL, 3, '', ''),
(1770, '1279617741', '康熙来了', 'http://video.baidu.com/v?word=%BF%B5%CE%F5%C0%B4%C1%CB&ct=301989888&rn=20&pn=0&db=0&s=0&fbl=800', 0, 0, 0, 2047, 0, 1, 0, NULL, 4, '', ''),
(1771, '1279617741', '国光帮帮忙', 'http://video.baidu.com/v?word=%B9%FA%B9%E2%B0%EF%B0%EF%C3%A6&ct=301989888&rn=20&pn=0&db=0&s=0&fbl=800', 0, 0, 0, 2047, 0, 1, 0, NULL, 5, '', ''),
(1772, '1279617741', '天涯社区', 'http://www.tianya.cn/', 0, 0, 0, 2048, 0, 1, 0, NULL, 1, '', ''),
(1773, '1279617741', '猫扑贴贴', 'http://tt.mop.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 2, '', ''),
(1774, '1279617741', '新浪论坛', 'http://bbs.sina.com.cn/', 0, 0, 0, 2048, 0, 1, 0, NULL, 3, '', ''),
(1775, '1279617741', '搜狐社区', 'http://club.sohu.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 4, '', ''),
(1776, '1279617741', 'QQ论坛', 'http://bbs.qq.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 5, '', ''),
(1777, '1279617741', '网易论坛', 'http://bbs.163.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 6, '', ''),
(1778, '1279617741', '华声论坛', 'http://bbs.hnol.net/', 0, 0, 0, 2048, 0, 1, 0, NULL, 7, '', ''),
(1779, '1279617741', '西祠胡同', 'http://www.xici.net', 0, 0, 0, 2048, 0, 1, 0, NULL, 8, '', ''),
(1780, '1279617741', '猫扑大杂烩', 'http://dzh.mop.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 9, '', ''),
(1781, '1279617741', '广州论坛', 'http://www.bbs020.com/', 0, 0, 0, 2048, 0, 1, 1289887037, NULL, 20, '', ''),
(1782, '1279617741', '新华网论坛', 'http://forum.home.news.cn/', 0, 0, 0, 2048, 0, 1, 1292223099, NULL, 11, '', ''),
(1783, '1279617741', '奇虎中文', 'http://www.qihoo.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 12, '', ''),
(1784, '1279617741', 'Chinaren社区', 'http://club.chinaren.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 13, '', ''),
(1785, '1279617741', '央视网论坛', 'http://bbs.cctv.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 14, '', ''),
(1786, '1279617741', '中华网论坛', 'http://bbs.china.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 15, '', ''),
(1787, '1279617741', '凤凰论坛', 'http://bbs.phoenixtv.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 16, '', ''),
(1788, '1279617741', '凯迪社区', 'http://club.cat898.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 17, '', ''),
(1789, '1279617741', '西陆社区', 'http://www.xilu.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 18, '', ''),
(1790, '1279617741', '泡泡俱乐部', 'http://pop.pcpop.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 19, '', ''),
(1791, '1279617741', '豆豆网', 'http://www.doudou.com/', 0, 0, 0, 2048, 0, 1, 1289887036, NULL, 10, '', ''),
(1792, '1279617741', '京华论坛', 'http://bbs.qianlong.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 21, '', ''),
(1793, '1279617741', '四川麻辣社区', 'http://bbs.newssc.org/', 0, 0, 0, 2048, 0, 1, 0, NULL, 23, '', ''),
(1794, '1279617741', '蹦蹦家园', 'http://www.bengbeng.com/', 0, 0, 0, 2048, 0, 1, 1289543451, NULL, 25, '', ''),
(1795, '1279617741', '国际在线论坛', 'http://bbs.cri.cn/', 0, 0, 0, 2048, 0, 1, 0, NULL, 26, '', ''),
(1796, '1279617741', '瑞丽论坛', 'http://bbs.rayli.com.cn/', 0, 0, 0, 2048, 0, 1, 0, NULL, 27, '', ''),
(1797, '1279617741', '福建论坛', 'http://bbs.66163.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 28, '', ''),
(1798, '1279617741', 'Tom社区', 'http://club.tom.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 29, '', ''),
(1799, '1279617741', '人民网强国社区', 'http://bbs.people.com.cn', 0, 0, 0, 2048, 0, 1, 0, NULL, 30, '', ''),
(1800, '1279617741', '19楼论坛', 'http://www.19lou.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 31, '', ''),
(1801, '1279617741', '大河论坛', 'http://bbs.dahe.cn/bbs/', 0, 0, 0, 2048, 0, 1, 0, NULL, 32, '', ''),
(1802, '1279617741', '水木社区', 'http://www.newsmth.net/', 0, 0, 0, 2048, 0, 1, 0, NULL, 33, '', ''),
(1803, '1279617741', '中国学生网社区', 'http://city.6to23.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 35, '', ''),
(1804, '1279617741', '广西红豆社区', 'http://hongdou.gxnews.com.cn/', 0, 0, 0, 2048, 0, 1, 0, NULL, 36, '', ''),
(1805, '1279617741', '上海热线互动社区', 'http://bbs.online.sh.cn/', 0, 0, 0, 2048, 0, 1, 0, NULL, 37, '', ''),
(1806, '1279617741', '青青岛社区', 'http://club.qingdaonews.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 38, '', ''),
(1807, '1279617741', '杭州网论坛', 'http://bbs.hangzhou.com.cn/', 0, 0, 0, 2048, 0, 1, 0, NULL, 39, '', ''),
(1808, '1279617741', '数动连线论坛', 'http://bbs.shudoo.com/index.php', 0, 0, 0, 2048, 0, 1, 0, NULL, 40, '', ''),
(1809, '1279617741', '湖北东湖社区', 'http://bbs.cnhubei.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 41, '', ''),
(1810, '1279617741', '21CN社区', 'http://free.21cn.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 42, '', ''),
(1811, '1279617741', '南方社区', 'http://bbs.southcn.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 43, '', ''),
(1812, '1279617741', '深圳论坛', 'http://szbbs.sznews.com/', 0, 0, 0, 2048, 0, 1, 0, NULL, 44, '', ''),
(1813, '1279617741', '青年论坛', 'http://bbs.ynet.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 45, '', ''),
(1814, '1279617741', '大旗网口碑门户', 'http://www.daqi.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 47, '', ''),
(1815, '1279617741', '天极群乐', 'http://q.yesky.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 48, '', ''),
(1816, '1279617741', '环球时报论坛', 'http://bbs.huanqiu.com', 0, 0, 0, 2048, 0, 1, 0, NULL, 49, '', ''),
(1817, '1279617741', '很搞笑', 'http://www.hengaoxiao.com/', 0, 0, 0, 2050, 0, 1, 0, NULL, 1, '', ''),
(1818, '1279617741', '八目妖', 'http://www.haha168.com/', 0, 0, 0, 2050, 0, 1, 0, NULL, 2, '', ''),
(1819, '1279617741', '好笑啦', 'http://www.haoxiaola.com/', 0, 0, 0, 2050, 0, 1, 0, NULL, 3, '', ''),
(1820, '1279617741', '来福岛', 'http://www.laifu.org', 0, 0, 0, 2050, 0, 1, 0, NULL, 4, '', ''),
(1821, '1279617741', '嘻嘻哈哈', 'http://www.xxhh.net', 0, 0, 0, 2050, 0, 1, 0, NULL, 5, '', ''),
(1822, '1279617741', '腾讯笑话', 'http://joke.qq.com', 0, 0, 0, 2050, 0, 1, 0, NULL, 6, '', ''),
(1823, '1279617741', '开心驿站', 'http://www.rhui.net/', 0, 0, 0, 2050, 0, 1, 0, NULL, 7, '', ''),
(1824, '1279617741', '幽默百分百', 'http://www.xiaohuayoumo.com', 0, 0, 0, 2050, 0, 1, 0, NULL, 8, '', ''),
(1825, '1279617741', 'TOM笑话', 'http://happy.tom.com/', 0, 0, 0, 2050, 0, 1, 0, NULL, 9, '', ''),
(1826, '1279617741', '21cn幽默', 'http://life.21cn.com/humour/', 0, 0, 0, 2050, 0, 1, 0, NULL, 10, '', ''),
(1827, '1279617741', '嘘嘘乐爆笑娱乐', 'http://xuxule.net', 0, 0, 0, 2050, 0, 1, 0, NULL, 11, '', ''),
(1828, '1279617741', '唧唧地笑话网', 'http://www.jijidi.com/', 0, 0, 0, 2050, 0, 1, 0, NULL, 12, '', ''),
(1830, '1279617741', '优酷搞笑频道', 'http://www.youku.com/v_showlist/t2d1c94.html', 0, 0, 0, 2051, 0, 1, 0, NULL, 1, '', ''),
(1831, '1279617741', '酷6搞笑视频', 'http://www.ku6.com/gaoxiao', 0, 0, 0, 2051, 0, 1, 0, NULL, 2, '', ''),
(1832, '1279617741', '土豆搞笑频道', 'http://fun.tudou.com/', 0, 0, 0, 2051, 0, 1, 0, NULL, 3, '', ''),
(1833, '1279617741', 'QQ搞笑视频', 'http://joke.qq.com/jokevideo/video.shtml', 0, 0, 0, 2051, 0, 1, 0, NULL, 4, '', ''),
(1834, '1279617741', '来福岛搞笑视频', 'http://www.laifu.org/movie/', 0, 0, 0, 2051, 0, 1, 0, NULL, 5, '', ''),
(1835, '1279617741', '搞搞吧', 'http://www.gaogao8.com/', 0, 0, 0, 2052, 0, 1, 0, NULL, 1, '', ''),
(1836, '1279617741', '搞笑吧', 'http://www.gaoxiao8.com', 0, 0, 0, 2052, 0, 1, 0, NULL, 2, '', ''),
(1837, '1279617741', '冷笑话吧', 'http://tieba.baidu.com/f?kw=%C0%E4%D0%A6%BB%B0', 0, 0, 0, 2052, 0, 1, 0, NULL, 3, '', ''),
(1838, '1279617741', '华声在线-哈哈笑话', 'http://bbs.voc.com.cn/forumdisplay.php?fid=52', 0, 0, 0, 2052, 0, 1, 0, NULL, 4, '', ''),
(1839, '1279617741', '搜狐社区-笑话天地', 'http://club.yule.sohu.com/l-joke-0-0-0-0.html', 0, 0, 0, 2052, 0, 1, 0, NULL, 5, '', ''),
(1840, '1279617741', '天空软件站', 'http://www.skycn.com', 0, 0, 0, 3001, 0, 1, 0, NULL, 1, '', ''),
(1841, '1279617741', '华军软件园', 'http://www.onlinedown.net', 0, 0, 0, 3001, 0, 1, 0, NULL, 2, '', ''),
(1842, '1279617741', '非凡软件站', 'http://www.crsky.com/', 0, 0, 0, 3001, 0, 1, 0, NULL, 3, '', ''),
(1843, '1279617741', '太平洋软件下载', 'http://dl.pconline.com.cn/', 0, 0, 0, 3001, 0, 1, 0, NULL, 4, '', ''),
(1844, '1279617741', '狗狗软件搜索', 'http://soft.gougou.com/', 0, 0, 0, 3001, 0, 1, 0, NULL, 5, '', ''),
(1845, '1279617741', '泡泡网下载', 'http://download.pcpop.com', 0, 0, 0, 3001, 0, 1, 0, NULL, 6, '', ''),
(1846, '1279617741', '源码之家', 'http://www.mycodes.net/', 0, 0, 0, 3001, 0, 1, 0, NULL, 7, '', ''),
(1847, '1279617741', 'IT世界-下载', 'http://download.it.com.cn/', 0, 0, 0, 3001, 0, 1, 0, NULL, 8, '', ''),
(1848, '1279617741', '电脑之家软件下载', 'http://download.pchome.net/', 0, 0, 0, 3001, 0, 1, 0, NULL, 9, '', ''),
(1849, '1279617741', 'eNet下载', 'http://download.enet.com.cn/', 0, 0, 0, 3001, 0, 1, 0, NULL, 10, '', ''),
(1850, '1279617741', 'IT168下载', 'http://download.it168.com/', 0, 0, 0, 3001, 0, 1, 0, NULL, 11, '', ''),
(1851, '1279617741', '腾讯下载', 'http://download.qq.com/', 0, 0, 0, 3001, 0, 1, 0, NULL, 12, '', ''),
(1852, '1279617741', '新浪软件下载', 'http://tech.sina.com.cn/down', 0, 0, 0, 3001, 0, 1, 0, NULL, 13, '', ''),
(1853, '1279617741', '中关村在线-软件下载', 'http://download.zol.com.cn/', 0, 0, 0, 3001, 0, 1, 0, NULL, 14, '', ''),
(1854, '1279617741', '绿色下载站', 'http://www.greendown.cn/default.html', 0, 0, 0, 3001, 0, 1, 0, NULL, 15, '', ''),
(1855, '1279617741', '绿色软件联盟', 'http://xdowns.com/', 0, 0, 0, 3001, 0, 1, 0, NULL, 16, '', ''),
(1856, '1279617741', '红软基地', 'http://www.rsdown.cn/', 0, 0, 0, 3001, 0, 1, 0, NULL, 17, '', ''),
(1857, '1279617741', '绿色软件站', 'http://www.onegreen.net/index.html', 0, 0, 0, 3001, 0, 1, 0, NULL, 18, '', ''),
(1858, '1279617741', '飞翔下载站', 'http://www.52z.com/', 0, 0, 0, 3001, 0, 1, 0, NULL, 19, '', ''),
(1859, '1279617741', '完美天空下载站', 'http://www.wmzhe.com/', 0, 0, 0, 3001, 0, 1, 0, NULL, 20, '', ''),
(1860, '1279617741', '河源下载站', 'http://www.cngr.cn/', 0, 0, 0, 3001, 0, 1, 0, NULL, 21, '', ''),
(1861, '1279617741', '太平洋软件论坛', 'http://softbbs.pconline.com.cn/', 0, 0, 0, 3002, 0, 1, 0, NULL, 1, '', ''),
(1862, '1279617741', '电脑报论坛', 'http://bbs.shudoo.com/', 0, 0, 0, 3002, 0, 1, 0, NULL, 2, '', ''),
(1863, '1279617741', '雨林木风论坛', 'http://www.ylmf.net/', 0, 0, 0, 3002, 0, 1, 0, NULL, 3, '', ''),
(1864, '1279617741', '电脑爱好者论坛', 'http://bbs.cfan.com.cn/', 0, 0, 0, 3002, 0, 1, 0, NULL, 4, '', ''),
(1865, '1279617741', '木蚂蚁社区', 'http://bbs.mumayi.net/', 0, 0, 0, 3002, 0, 1, 0, NULL, 5, '', ''),
(1866, '1279617741', '箫心IT乐园', 'http://it.crfly.com/', 1, 0, 0, 3002, 0, 1, 0, NULL, 6, '', ''),
(1867, '1279617741', '远景论坛　', 'http://bbs.pcbeta.com/', 0, 0, 0, 3002, 0, 1, 0, NULL, 7, '', ''),
(1868, '1279617741', '999宝藏网', 'http://www.in9.cn/', 0, 0, 0, 3002, 0, 1, 0, NULL, 8, '', ''),
(1869, '1279617741', '驱动之家论坛', 'http://bbs.mydrivers.com/', 0, 0, 0, 3002, 0, 1, 0, NULL, 9, '', ''),
(1870, '1289544023', '站长小助手', 'http://www.aosoo.com/', 0, 0, 0, 3002, 0, 1, 1289544023, NULL, 10, '', ''),
(1871, '1289544033', '广告联盟', 'http://www.ete.cn/', 0, 0, 0, 3002, 0, 1, 1289544033, NULL, 11, '', ''),
(1872, '1279617741', '网易Yeah.net邮箱', 'http://www.yeah.net/', 0, 0, 0, 3003, 0, 1, 0, NULL, 1, '', ''),
(1873, '1279617741', '网易163邮箱', 'http://mail.163.com', 0, 0, 0, 3003, 0, 1, 0, NULL, 2, '', ''),
(1874, '1279617741', '网易126邮箱', 'http://www.126.com', 0, 0, 0, 3003, 0, 1, 0, NULL, 3, '', ''),
(1875, '1279617741', '搜狐闪电邮件', 'http://login.mail.sohu.com', 0, 0, 0, 3003, 0, 1, 0, NULL, 4, '', ''),
(1876, '1279617741', '新浪邮箱', 'http://mail.sina.com.cn', 0, 0, 0, 3003, 0, 1, 0, NULL, 5, '', ''),
(1877, '1279617741', '雅虎无限量邮箱', 'http://cn.mail.yahoo.com/', 0, 0, 0, 3003, 0, 1, 1289802193, NULL, 6, '', ''),
(1878, '1279617741', 'TOM免费邮箱', 'http://mail.tom.com', 0, 0, 0, 3003, 0, 1, 0, NULL, 7, '', ''),
(1879, '1279617741', 'G-Mail', 'http://www.gmail.com', 0, 0, 0, 3003, 0, 1, 0, NULL, 8, '', ''),
(1880, '1279617741', 'MSN邮箱', 'http://login.live.com/', 0, 0, 0, 3003, 0, 1, 0, NULL, 9, '', ''),
(1881, '1279617741', 'QQ邮箱', 'http://mail.qq.com', 0, 0, 0, 3003, 0, 1, 0, NULL, 10, '', ''),
(1882, '1279617741', '21CN免费邮箱', 'http://mail.21cn.com/', 0, 0, 0, 3003, 0, 1, 0, NULL, 11, '', ''),
(1883, '1279617741', '中国移动139邮箱', 'http://mail.139.com/', 0, 0, 0, 3003, 0, 1, 0, NULL, 12, '', ''),
(1884, '1279617741', '263邮箱', 'http://www.263.net/', 0, 0, 0, 3003, 0, 1, 0, NULL, 13, '', ''),
(1885, '1279617741', '中华网邮箱', 'http://mail.china.com', 1, 0, 0, 3003, 0, 1, 0, NULL, 14, '', ''),
(1886, '1279617741', '亿邮电子信箱', 'http://www.eyou.com', 1, 0, 0, 3003, 0, 1, 0, NULL, 15, '', ''),
(1887, '1279617741', '115网络U盘', 'http://u.115.com/', 0, 0, 0, 3004, 0, 1, 0, NULL, 1, '', ''),
(1888, '1279617741', '永硕网络硬盘', 'http://www.ys168.com/', 0, 0, 0, 3004, 0, 1, 0, NULL, 2, '', ''),
(1889, '1279617741', '纳米盘', 'http://www.namipan.com/index.php', 0, 0, 0, 3004, 0, 1, 0, NULL, 3, '', ''),
(1890, '1279617741', 'G宝盘', 'http://www.gbaopan.com', 0, 0, 0, 3004, 0, 1, 0, NULL, 4, '', ''),
(1891, '1279617741', 'RayFile网络硬盘', 'http://www.rayfile.com/zh-cn/', 0, 0, 0, 3004, 0, 1, 0, NULL, 5, '', ''),
(1892, '1279617741', '哔哔嘟网络硬盘', 'http://www.bibidu.com', 0, 0, 0, 3004, 0, 1, 0, NULL, 6, '', ''),
(1893, '1279617741', '千脑', 'http://www.qiannao.com/', 0, 0, 0, 3004, 0, 1, 0, NULL, 7, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(1894, '1279617741', '趣盘', 'http://www.qupan.com/', 0, 0, 0, 3004, 0, 1, 0, NULL, 8, '', ''),
(1895, '1279617741', 'QQ网络硬盘', 'http://disk.qq.com/', 0, 0, 0, 3004, 0, 1, 0, NULL, 9, '', ''),
(1896, '1279617741', 'QQ空间', 'http://qzone.qq.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 1, '', ''),
(1897, '1279617741', '网易博客', 'http://blog.163.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 2, '', ''),
(1898, '1279617741', '新浪博客', 'http://blog.sina.com.cn/', 0, 0, 0, 3005, 0, 1, 0, NULL, 3, '', ''),
(1899, '1279617741', '百度空间', 'http://hi.baidu.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 4, '', ''),
(1900, '1279617741', '人人网', 'http://www.renren.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 5, '', ''),
(1901, '1279617741', '搜狐博客', 'http://blog.sohu.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 6, '', ''),
(1902, '1279617741', '聚友网', 'http://www.myspace.cn/', 0, 0, 0, 3005, 0, 1, 0, NULL, 7, '', ''),
(1903, '1279617741', '天涯博客', 'http://blog.tianya.cn/', 0, 0, 0, 3005, 0, 1, 0, NULL, 8, '', ''),
(1904, '1279617741', '雨后池塘', 'http://www.trueme.net/', 0, 0, 0, 3005, 0, 1, 0, NULL, 9, '', ''),
(1905, '1279617741', '博客大巴', 'http://www.blogbus.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 10, '', ''),
(1906, '1279617741', '凤凰博客', 'http://blog.ifeng.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 11, '', ''),
(1907, '1279617741', '和讯博客', 'http://blog.hexun.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 12, '', ''),
(1908, '1279617741', '百度博客搜索', 'http://blogsearch.baidu.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 13, '', ''),
(1909, '1279617741', '阿里巴巴博客', 'http://blog.china.alibaba.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 14, '', ''),
(1910, '1279617741', '瑞丽博客', 'http://blog.rayli.com.cn/', 0, 0, 0, 3005, 0, 1, 0, NULL, 15, '', ''),
(1911, '1279617741', '教育人博客', 'http://www.blog.edu.cn/', 0, 0, 0, 3005, 0, 1, 0, NULL, 16, '', ''),
(1912, '1279617741', '嫣牛博', 'http://www.bullock.cn/', 0, 0, 0, 3005, 0, 1, 0, NULL, 17, '', ''),
(1913, '1279617741', '东方财富博客', 'http://blog.eastmoney.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 18, '', ''),
(1914, '1279617741', '中金博客', 'http://blog.cnfol.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 19, '', ''),
(1915, '1279617741', '博客中国', 'http://vip.bokee.com/', 0, 0, 0, 3005, 0, 1, 0, NULL, 20, '', ''),
(1916, '1279617741', '新浪微博', 'http://t.sina.com.cn/', 0, 0, 0, 3006, 0, 1, 0, NULL, 1, '', ''),
(1917, '1279617741', '腾讯微博', 'http://t.qq.com/', 0, 0, 0, 3006, 0, 1, 0, NULL, 2, '', ''),
(1918, '1279617741', '网易微博', 'http://t.163.com/', 0, 0, 0, 3006, 0, 1, 0, NULL, 3, '', ''),
(1919, '1279617741', '搜狐微博', 'http://t.sohu.com/', 0, 0, 0, 3006, 0, 1, 0, NULL, 4, '', ''),
(1920, '1279617741', '凤凰微博', 'http://t.ifeng.com/', 0, 0, 0, 3006, 0, 1, 0, NULL, 5, '', ''),
(1921, '1279617741', '嘀咕', 'http://www.digu.com/', 0, 0, 0, 3006, 0, 1, 0, NULL, 6, '', ''),
(1922, '1279617741', '139说客', 'http://www.139.com/home/', 0, 0, 0, 3006, 0, 1, 0, NULL, 7, '', ''),
(1923, '1279617741', '网易相册', 'http://photo.163.com', 0, 0, 0, 3007, 0, 1, 0, NULL, 1, '', ''),
(1924, '1279617741', '雅虎相册', 'http://i.cn.yahoo.com/', 0, 0, 0, 3007, 0, 1, 0, NULL, 2, '', ''),
(1925, '1279617741', 'QQ相册', 'http://photo.qq.com', 0, 0, 0, 3007, 0, 1, 0, NULL, 3, '', ''),
(1926, '1279617741', '搜狐相册', 'http://pp.sohu.com/', 0, 0, 0, 3007, 0, 1, 0, NULL, 4, '', ''),
(1927, '1279617741', '新浪相册', 'http://photo.sina.com.cn/', 0, 0, 0, 3007, 0, 1, 0, NULL, 5, '', ''),
(1928, '1279617741', '多拍网络相册', 'http://reg.dpdp.net/', 0, 0, 0, 3007, 0, 1, 1289802260, NULL, 6, '', ''),
(1929, '1279617741', '和讯相册', 'http://photo.hexun.com/', 0, 0, 0, 3007, 0, 1, 0, NULL, 7, '', ''),
(1930, '1279617741', 'SAYJOY-视频相册', 'http://www.sayjoy.com', 1, 0, 0, 3007, 0, 1, 0, NULL, 8, '', ''),
(1931, '1279617741', 'Mofile网络相册', 'http://photo.mofile.com/', 0, 0, 0, 3007, 0, 1, 0, NULL, 9, '', ''),
(1932, '1279617741', 'Flickr相册', 'http://www.flickr.com/', 0, 0, 0, 3007, 0, 1, 0, NULL, 10, '', ''),
(1933, '1279617741', '博客网图片博客', 'http://photo.bokee.com/', 1, 0, 0, 3007, 0, 1, 0, NULL, 11, '', ''),
(1934, '1279617741', 'poco免费相册', 'http://tu.poco.cn/', 0, 0, 0, 3007, 0, 1, 0, NULL, 12, '', ''),
(1935, '1279617741', 'Yupoo|又拍网', 'http://www.yupoo.com', 0, 0, 0, 3007, 0, 1, 0, NULL, 13, '', ''),
(1936, '1279617741', '图海TuHigh', 'http://www.tuhigh.com', 0, 0, 0, 3007, 0, 1, 0, NULL, 14, '', ''),
(1937, '1279617741', '拍拍乐FLASH相册', 'http://www.886.cn/', 0, 0, 0, 3007, 0, 1, 0, NULL, 15, '', ''),
(1938, '1279617741', 'Google Reader', 'http://www.google.com/reader/view/', 0, 0, 0, 3008, 0, 1, 0, NULL, 1, '', ''),
(1939, '1279617741', '鲜果网', 'http://www.xianguo.com/', 0, 0, 0, 3008, 0, 1, 0, NULL, 2, '', ''),
(1940, '1279617741', '抓虾', 'http://www.zhuaxia.com/', 0, 0, 0, 3008, 0, 1, 0, NULL, 3, '', ''),
(1941, '1279617741', '有道阅读', 'http://reader.youdao.com/', 0, 0, 0, 3008, 0, 1, 0, NULL, 4, '', ''),
(1942, '1279617741', '周博通资讯阅读器', 'http://www.potu.com/', 0, 0, 0, 3008, 0, 1, 0, NULL, 5, '', ''),
(1943, '1279617741', '飞递网', 'http://www.feedsky.com/', 0, 0, 0, 3008, 0, 1, 0, NULL, 6, '', ''),
(1944, '1279617741', '哪吒网', 'http://www.inezha.com/', 0, 0, 0, 3008, 0, 1, 0, NULL, 7, '', ''),
(1945, '1279617741', '豆瓣九点', 'http://9.douban.com/', 0, 0, 0, 3008, 0, 1, 0, NULL, 8, '', ''),
(1946, '1279617741', '博客搬家工具', 'http://banjia.blogbus.com/', 0, 0, 0, 3008, 0, 1, 0, NULL, 9, '', ''),
(1947, '1279617741', 'Diglog', 'http://www.diglog.com/', 0, 0, 0, 3008, 0, 1, 0, NULL, 10, '', ''),
(1948, '1279617741', '瑞星', 'http://www.rising.com.cn/', 0, 0, 0, 3009, 0, 1, 0, NULL, 1, '', ''),
(1949, '1279617741', '卡巴斯基', 'http://www.kaspersky.com.cn/', 0, 0, 0, 3009, 0, 1, 0, NULL, 2, '', ''),
(1950, '1279617741', '江民科技', 'http://www.jiangmin.com/index.htm', 0, 0, 0, 3009, 0, 1, 0, NULL, 3, '', ''),
(1951, '1279617741', '诺顿Norton', 'http://www.symantec.com/zh/cn/index.jsp', 0, 0, 0, 3009, 0, 1, 0, NULL, 4, '', ''),
(1952, '1279617741', '东方微点', 'http://www.micropoint.com.cn/', 0, 0, 0, 3009, 0, 1, 0, NULL, 5, '', ''),
(1953, '1279617741', '金山毒霸', 'http://www.duba.net/', 0, 0, 0, 3009, 0, 1, 0, NULL, 6, '', ''),
(1954, '1279617741', '360杀毒', 'http://sd.360.cn/', 0, 0, 0, 3009, 0, 1, 0, NULL, 7, '', ''),
(1955, '1279617741', 'NOD32', 'http://www.eset.com.cn/', 0, 0, 0, 3009, 0, 1, 0, NULL, 8, '', ''),
(1956, '1279617741', 'avast!', 'http://www.avast.com/zh-cn/index', 0, 0, 0, 3009, 0, 1, 0, NULL, 9, '', ''),
(1957, '1279617741', '小红伞', 'http://www.free-av.com/', 0, 0, 0, 3009, 0, 1, 0, NULL, 10, '', ''),
(1958, '1279617741', '江民在线杀毒', 'http://online.jiangmin.com/', 0, 0, 0, 3009, 0, 1, 0, NULL, 11, '', ''),
(1959, '1279617741', '可牛杀毒', 'http://sd.keniu.com/index.html', 0, 0, 0, 3009, 0, 1, 0, NULL, 12, '', ''),
(1960, '1279617741', '大蜘蛛', 'http://www.drweb.com.cn/', 0, 0, 0, 3009, 0, 1, 0, NULL, 13, '', ''),
(1961, '1279617741', '金山在线杀毒', 'http://scan.duba.net/', 0, 0, 0, 3009, 0, 1, 0, NULL, 14, '', ''),
(1962, '1279617741', '瑞星卡卡', 'http://www.ikaka.com/', 0, 0, 0, 3010, 0, 1, 0, NULL, 1, '', ''),
(1963, '1279617741', '金山卫士', 'http://www.ijinshan.com/', 0, 0, 0, 3010, 0, 1, 0, NULL, 2, '', ''),
(1964, '1279617741', '超级兔子', 'http://www.pctutu.com/', 0, 0, 0, 3010, 0, 1, 0, NULL, 3, '', ''),
(1965, '1279617741', 'Windows清理助手', 'http://www.arswp.com/', 0, 0, 0, 3010, 0, 1, 0, NULL, 4, '', ''),
(1966, '1279617741', '鲁大师', 'http://www.ludashi.com/', 0, 0, 0, 3010, 0, 1, 0, NULL, 5, '', ''),
(1967, '1279617741', '360系统急救箱', 'http://www.360.cn/killer/360compkill.html', 0, 0, 0, 3010, 0, 1, 0, NULL, 6, '', ''),
(1968, '1279617741', '优化大师', 'http://www.youhua.com/', 0, 0, 0, 3010, 0, 1, 0, NULL, 7, '', ''),
(1969, '1279617741', '360安全卫士', 'http://www.360.cn/', 0, 0, 0, 3010, 0, 1, 0, NULL, 8, '', ''),
(1970, '1279617741', 'QQ电脑管家', 'http://pcmgr.qq.com/', 0, 0, 0, 3010, 0, 1, 0, NULL, 9, '', ''),
(1971, '1279617741', '金山急救箱', 'http://labs.duba.net/jjx.shtml', 0, 0, 0, 3010, 0, 1, 0, NULL, 10, '', ''),
(1972, '1279617741', '卡饭论坛', 'http://bbs.kafan.cn/', 0, 0, 0, 3011, 0, 1, 0, NULL, 1, '', ''),
(1973, '1279617741', '剑盟中国社区', 'http://bbs.janmeng.com/', 0, 0, 0, 3011, 0, 1, 0, NULL, 1, '', ''),
(1974, '1279617741', '金山毒霸论坛', 'http://bbs.duba.net/', 0, 0, 0, 3011, 0, 1, 0, NULL, 1, '', ''),
(1975, '1279617741', '我是网管论坛', 'http://bbs.54master.com/', 0, 0, 0, 3011, 0, 1, 0, NULL, 1, '', ''),
(1976, '1279617741', '爱卡巴论坛', 'http://bbs.aikaba.com/', 0, 0, 0, 3011, 0, 1, 0, NULL, 1, '', ''),
(1977, '1279617741', '精睿论坛', 'http://bbs.vc52.cn/', 0, 0, 0, 3011, 0, 1, 0, NULL, 1, '', ''),
(1978, '1279617741', '卡卡社区', 'http://bbs.ikaka.com/', 0, 0, 0, 3011, 0, 1, 0, NULL, 1, '', ''),
(1979, '1279617741', '中天在线', 'http://bbs.366tian.com/', 0, 0, 0, 3011, 0, 1, 0, NULL, 1, '', ''),
(1980, '1279617741', '中国平面设计在线', 'http://gra.dolcn.com/', 0, 0, 0, 3012, 0, 1, 0, NULL, 1, '', ''),
(1981, '1279617741', '圆点视线', 'http://www.apoints.com/', 0, 0, 0, 3012, 0, 1, 0, NULL, 2, '', ''),
(1982, '1279617741', '视觉中国', 'http://www.chinavisual.com/', 0, 0, 0, 3012, 0, 1, 0, NULL, 3, '', ''),
(1983, '1279617741', '黑秀网', 'http://www.heyshow.com/', 0, 0, 0, 3012, 0, 1, 0, NULL, 4, '', ''),
(1984, '1279617741', '4A酒吧', 'http://www.4a98.com/', 0, 0, 0, 3012, 0, 1, 0, NULL, 5, '', ''),
(1985, '1279617741', '第六感', 'http://www.the6cn.com/', 0, 0, 0, 3012, 0, 1, 0, NULL, 6, '', ''),
(1986, '1279617741', '图片处理教程网', 'http://www.23ps.com/', 0, 0, 0, 3012, 0, 1, 0, NULL, 7, '', ''),
(1987, '1279617741', '数码资源网', 'http://www.smzy.com/', 0, 0, 0, 3012, 0, 1, 0, NULL, 8, '', ''),
(1988, '1279617741', '形色主义', 'http://www.swcool.com/', 0, 0, 0, 3012, 0, 1, 0, NULL, 9, '', ''),
(1989, '1279617741', 'Photoshop教程论坛', 'http://bbs.16xx8.com', 0, 0, 0, 3012, 0, 1, 0, NULL, 10, '', ''),
(1990, '1279617741', '中国室内设计网', 'http://www.ciid.com.cn/', 0, 0, 0, 3013, 0, 1, 0, NULL, 1, '', ''),
(1991, '1279617741', '中国室内设计联盟', 'http://bbs.cool-de.com/', 0, 0, 0, 3013, 0, 1, 0, NULL, 2, '', ''),
(1992, '1279617741', '室内设计资料网', 'http://www.maxsou.com/', 0, 0, 0, 3013, 0, 1, 0, NULL, 3, '', ''),
(1993, '1279617741', '中国室内装饰网', 'http://www.cool-de.com/', 0, 0, 0, 3013, 0, 1, 0, NULL, 4, '', ''),
(1994, '1279617741', '大室网', 'http://www.z6.cn/index.html', 0, 0, 0, 3013, 0, 1, 0, NULL, 5, '', ''),
(1995, '1279617741', '美国室内设计中文网', 'http://www.idchina.net/', 0, 0, 0, 3013, 0, 1, 0, NULL, 6, '', ''),
(1996, '1279617741', '深圳室内设计网', 'http://www.tianwu.com.cn/', 0, 0, 0, 3013, 0, 1, 0, NULL, 7, '', ''),
(1997, '1279617741', '中国室内人设计师网', 'http://www.snren.com/', 0, 0, 0, 3013, 0, 1, 0, NULL, 8, '', ''),
(1998, '1279617741', '室内设计师联盟', 'http://www.dr.eju.cn/', 0, 0, 0, 3013, 0, 1, 0, NULL, 9, '', ''),
(1999, '1279617741', '建筑与室内设计网', 'http://www.china-designer.com/', 0, 0, 0, 3013, 0, 1, 0, NULL, 10, '', ''),
(2000, '1279617741', '国家建筑标准设计网', 'http://www.chinabuilding.com.cn/', 0, 0, 0, 3013, 0, 1, 0, NULL, 11, '', ''),
(2001, '1279617741', 'ABBS建筑论坛', 'http://www.abbs.com.cn/', 0, 0, 0, 3013, 0, 1, 0, NULL, 12, '', ''),
(2002, '1279617741', '中国设计在线-建筑设计', 'http://www.333cn.com/architecture/', 0, 0, 0, 3013, 0, 1, 0, NULL, 13, '', ''),
(2003, '1279617741', '中国服装设计网', 'http://www.a1988.com/', 0, 0, 0, 3014, 0, 1, 0, NULL, 1, '', ''),
(2004, '1279617741', '服装设计吧', 'http://bbs.3fnet.com/', 0, 0, 0, 3014, 0, 1, 0, NULL, 2, '', ''),
(2005, '1279617741', '服饰流行前线', 'http://www.pop-fashion.com/', 0, 0, 0, 3014, 0, 1, 0, NULL, 3, '', ''),
(2006, '1279617741', '国际服装设计网', 'http://www.topsjs.com/', 0, 0, 0, 3014, 0, 1, 0, NULL, 4, '', ''),
(2007, '1279617741', '中国服装网-服装设计', 'http://www.efu.com.cn/design/', 0, 0, 0, 3014, 0, 1, 0, NULL, 5, '', ''),
(2008, '1279617741', '中国服装设计师论坛', 'http://www.coldress.com/', 0, 0, 0, 3014, 0, 1, 0, NULL, 6, '', ''),
(2009, '1279617741', '怒放服装设计论坛', 'http://nufang.net.cn/', 0, 0, 0, 3014, 0, 1, 0, NULL, 7, '', ''),
(2010, '1279617741', '蝶讯网', 'http://www.sxxl.com/', 0, 0, 0, 3014, 0, 1, 0, NULL, 8, '', ''),
(2011, '1279617741', '素材中国', 'http://www.sc-cn.net/', 0, 0, 0, 3015, 0, 1, 0, NULL, 1, '', ''),
(2012, '1279617741', '站酷', 'http://www.zcool.com.cn/', 0, 0, 0, 3015, 0, 1, 0, NULL, 2, '', ''),
(2013, '1279617741', '站长素材', 'http://sc.chinaz.com/', 0, 0, 0, 3015, 0, 1, 0, NULL, 3, '', ''),
(2014, '1279617741', '图酷', 'http://www.tucoo.com', 0, 0, 0, 3015, 0, 1, 0, NULL, 4, '', ''),
(2015, '1279617741', '3lian素材网', 'http://www.3lian.com/', 0, 0, 0, 3015, 0, 1, 0, NULL, 5, '', ''),
(2016, '1279617741', '简洁设计网', 'http://www.jianjie8.com', 0, 0, 0, 3015, 0, 1, 0, NULL, 6, '', ''),
(2017, '1279617741', '52design素材库', 'http://sc.52design.com/', 0, 0, 0, 3015, 0, 1, 0, NULL, 7, '', ''),
(2018, '1279617741', '好素材网!', 'http://www.haosc.cn/', 0, 0, 0, 3015, 0, 1, 0, NULL, 8, '', ''),
(2019, '1279617741', '素材黄页', 'http://www.114sucai.com', 0, 0, 0, 3015, 0, 1, 0, NULL, 9, '', ''),
(2020, '1279617741', '我图网', 'http://www.ooopic.com/', 0, 0, 0, 3015, 0, 1, 0, NULL, 10, '', ''),
(2021, '1279617741', '懒人图库', 'http://www.lanrentuku.com/', 0, 0, 0, 3015, 0, 1, 0, NULL, 11, '', ''),
(2022, '1279617741', '模板天下', 'http://www.mbsky.com', 0, 0, 0, 3015, 0, 1, 0, NULL, 12, '', ''),
(2023, '1279617741', '最好模版', 'http://bestmoban.com/', 0, 0, 0, 3015, 0, 1, 0, NULL, 13, '', ''),
(2024, '1279617741', '模板无忧', 'http://www.mb5u.com', 0, 0, 0, 3015, 0, 1, 0, NULL, 14, '', ''),
(2025, '1279617741', '设计前沿', 'http://www.wzsky.net/', 0, 0, 0, 3015, 0, 1, 0, NULL, 15, '', ''),
(2026, '1279617741', '维奇素材网', 'http://www.veeqi.com', 0, 0, 0, 3015, 0, 1, 0, NULL, 16, '', ''),
(2027, '1279617741', '火星时代网', 'http://www.hxsd.com/', 0, 0, 0, 3016, 0, 1, 0, NULL, 1, '', ''),
(2028, '1279617741', '中国数码视频在线', 'http://www.chinadv.com/', 0, 0, 0, 3016, 0, 1, 0, NULL, 2, '', ''),
(2029, '1279617741', 'CG橙子', 'http://www.86cg.com/', 0, 0, 0, 3016, 0, 1, 0, NULL, 3, '', ''),
(2030, '1279617741', 'CGFinal', 'http://www.cgfinal.com/', 0, 0, 0, 3016, 0, 1, 0, NULL, 4, '', ''),
(2031, '1230191774', '太平洋电脑网', 'http://www.pconline.com.cn', 0, 0, 0, 3017, 0, 1, 0, NULL, 1, '', ''),
(2032, '1230191774', '中关村在线', 'http://product.zol.com.cn', 0, 0, 0, 3017, 0, 1, 0, NULL, 2, '', ''),
(2033, '1230191774', 'IT世界', 'http://www.it.com.cn/', 0, 0, 0, 3017, 0, 1, 0, NULL, 3, '', ''),
(2034, '1230191774', '天极网', 'http://www.yesky.com/', 0, 0, 0, 3017, 0, 1, 0, NULL, 4, '', ''),
(2035, '1230191774', 'IT168', 'http://www.it168.com', 0, 0, 0, 3017, 0, 1, 0, NULL, 5, '', ''),
(2036, '1230191774', '小熊在线', 'http://www.beareyes.com.cn', 0, 0, 0, 3017, 0, 1, 0, NULL, 6, '', ''),
(2037, '1230191774', '泡泡网', 'http://www.pcpop.com/', 0, 0, 0, 3017, 0, 1, 0, NULL, 7, '', ''),
(2038, '1230191774', '走进中关村', 'http://www.intozgc.com', 0, 0, 0, 3017, 0, 1, 0, NULL, 8, '', ''),
(2039, '1230191774', '电脑商情在线', 'http://www.cbinews.com/', 0, 0, 0, 3017, 0, 1, 0, NULL, 9, '', ''),
(2040, '1230191774', '驱动之家', 'http://www.mydrivers.com/default.shtml', 0, 0, 0, 3017, 0, 1, 0, NULL, 10, '', ''),
(2041, '1230191774', 'eNet-硬件DIY', 'http://www.enet.com.cn/hardwares/', 0, 0, 0, 3017, 0, 1, 0, NULL, 11, '', ''),
(2042, '1230191774', '新浪网-硬件', 'http://tech.sina.com.cn/hardware/', 0, 0, 0, 3017, 0, 1, 0, NULL, 12, '', ''),
(2043, '1230191774', '电脑之家-硬件中心', 'http://hardware.pchome.net', 0, 0, 0, 3017, 0, 1, 0, NULL, 13, '', ''),
(2044, '1230191774', '电脑秀', 'http://www.pcshow.net', 0, 0, 0, 3017, 0, 1, 0, NULL, 14, '', ''),
(2045, '1230191774', '52硬件', 'http://www.52hardware.com', 0, 0, 0, 3017, 0, 1, 0, NULL, 15, '', ''),
(2046, '1230191774', '慧聪网IT市场', 'http://it.hc360.com/', 0, 0, 0, 3017, 0, 1, 0, NULL, 16, '', ''),
(2047, '1230191774', '第三媒体', 'http://www.thethirdmedia.com', 0, 0, 0, 3017, 0, 1, 0, NULL, 17, '', ''),
(2048, '1230191774', '天空软件站', 'http://www.skycn.com/', 0, 0, 0, 3018, 0, 1, 0, NULL, 1, '', ''),
(2049, '1230191774', '华军软件园', 'http://www.onlinedown.net/', 0, 0, 0, 3018, 0, 1, 0, NULL, 2, '', ''),
(2050, '1230191774', '太平洋下载', 'http://dl.pconline.com.cn/', 0, 0, 0, 3018, 0, 1, 0, NULL, 3, '', ''),
(2051, '1230191774', '新浪下载', 'http://tech.sina.com.cn/down/', 0, 0, 0, 3018, 0, 1, 0, NULL, 4, '', ''),
(2052, '1230191774', 'win7之家', 'http://www.win7china.com/', 0, 0, 0, 3018, 0, 1, 0, NULL, 5, '', ''),
(2053, '1230191774', '狗狗软件搜索', 'http://soft.gougou.com/', 0, 0, 0, 3018, 0, 1, 0, NULL, 6, '', ''),
(2054, '1230191774', '驱动之家', 'http://www.mydrivers.com/', 0, 0, 0, 3018, 0, 1, 0, NULL, 7, '', ''),
(2055, '1230191774', '非凡软件', 'http://www.crsky.com/', 0, 0, 0, 3018, 0, 1, 0, NULL, 8, '', ''),
(2056, '1230191774', 'PChome下载', 'http://download.pchome.net/', 0, 0, 0, 3018, 0, 1, 0, NULL, 9, '', ''),
(2057, '1230191774', '百度知道-常用软件', 'http://zhidao.baidu.com/browse/864', 0, 0, 0, 3018, 0, 1, 0, NULL, 10, '', ''),
(2058, '1230191774', '中关村下载', 'http://xiazai.zol.com.cn/', 0, 0, 0, 3018, 0, 1, 0, NULL, 11, '', ''),
(2059, '1230191774', '手机常用软件', 'http://www.ruan8.com/', 0, 0, 0, 3018, 0, 1, 0, NULL, 12, '', ''),
(2060, '1230191774', 'IT168下载', 'http://download.it168.com/', 0, 0, 0, 3018, 0, 1, 0, NULL, 13, '', ''),
(2061, '1230191774', '常用软件下载', 'http://www.soft8.net/', 0, 0, 0, 3018, 0, 1, 0, NULL, 14, '', ''),
(2062, '1230191774', '驱动人生', 'http://www.updrv.com/', 0, 0, 0, 3018, 0, 1, 0, NULL, 15, '', ''),
(2063, '1230191774', '系统之家', 'http://www.xtzj.com/index.php', 0, 0, 0, 3018, 0, 1, 0, NULL, 16, '', ''),
(2064, '1230191774', '远景论坛', 'http://bbs.pcbeta.com/', 0, 0, 0, 3018, 0, 1, 0, NULL, 17, '', ''),
(2065, '1230191774', '太平洋数码', 'http://digital.pconline.com.cn/', 0, 0, 0, 3019, 0, 1, 0, NULL, 1, '', ''),
(2066, '1230191774', '中关村在线数码', 'http://dcdv.zol.com.cn/', 0, 0, 0, 3019, 0, 1, 0, NULL, 2, '', ''),
(2067, '1230191774', '搜狐数码', 'http://digi.it.sohu.com', 0, 0, 0, 3019, 0, 1, 0, NULL, 3, '', ''),
(2068, '1230191774', '新浪数码', 'http://tech.sina.com.cn/digi', 0, 0, 0, 3019, 0, 1, 0, NULL, 4, '', ''),
(2069, '1230191774', '腾讯数码', 'http://digi.qq.com', 0, 0, 0, 3019, 0, 1, 0, NULL, 5, '', ''),
(2070, '1230191774', '网易数码', 'http://digi.163.com', 0, 0, 0, 3019, 0, 1, 0, NULL, 6, '', ''),
(2071, '1230191774', 'eNet数码', 'http://www.enet.com.cn/edigi/index.shtml', 0, 0, 0, 3019, 0, 1, 0, NULL, 7, '', ''),
(2072, '1230191774', '雅虎数码', 'http://xk.cn.yahoo.com/digi/index.html', 0, 0, 0, 3019, 0, 1, 0, NULL, 8, '', ''),
(2073, '1230191774', '环球网科技', 'http://tech.huanqiu.com/', 0, 0, 0, 3019, 0, 1, 0, NULL, 9, '', ''),
(2074, '1230191774', '天极网数码', 'http://digital.yesky.com/', 0, 0, 0, 3019, 0, 1, 0, NULL, 10, '', ''),
(2075, '1230191774', '泡泡网数码', 'http://digi.pcpop.com', 0, 0, 0, 3019, 0, 1, 0, NULL, 11, '', ''),
(2076, '1230191774', 'IT168消费数码', 'http://digital.it168.com', 0, 0, 0, 3019, 0, 1, 0, NULL, 12, '', ''),
(2077, '1230191774', '随身数码网', 'http://www.itime.cn/Index.html', 0, 0, 0, 3019, 0, 1, 0, NULL, 13, '', ''),
(2078, '1230191774', '小熊在线数码', 'http://digi.beareyes.com.cn/', 0, 0, 0, 3019, 0, 1, 0, NULL, 14, '', ''),
(2079, '1230191774', '电脑之家-数码中心', 'http://digi.pchome.net/', 0, 0, 0, 3019, 0, 1, 0, NULL, 15, '', ''),
(2080, '1230191774', 'IT世界网-数码', 'http://www.it.com.cn', 0, 0, 0, 3019, 0, 1, 0, NULL, 16, '', ''),
(2081, '1230191774', 'GPS之家', 'http://www.55gps.com/', 0, 0, 0, 3019, 0, 1, 0, NULL, 17, '', ''),
(2082, '1230191774', '迅雷', 'http://dl.xunlei.com/index.htm?tag=1', 0, 0, 0, 3020, 0, 1, 0, NULL, 1, '', ''),
(2083, '1230191774', '金山网盾', 'http://www.duba.net/', 0, 0, 0, 3020, 0, 1, 0, NULL, 2, '', ''),
(2084, '1230191774', '驱动精灵', 'http://www.drivergenius.com/', 0, 0, 0, 3020, 0, 1, 0, NULL, 3, '', ''),
(2085, '1230191774', 'PPS', 'http://www.pps.tv/', 0, 0, 0, 3020, 0, 1, 0, NULL, 4, '', ''),
(2086, '1230191774', 'WinRAR', 'http://www.winrar.com.cn/download.htm', 0, 0, 0, 3020, 0, 1, 0, NULL, 5, '', ''),
(2087, '1230191774', '搜狗输入法', 'http://pinyin.sogou.com/', 0, 0, 0, 3020, 0, 1, 0, NULL, 6, '', ''),
(2088, '1230191774', '大智慧', 'http://www.gw.com.cn/download/level1/index.htm', 0, 0, 0, 3020, 0, 1, 0, NULL, 7, '', ''),
(2089, '1230191774', '腾讯QQ', 'http://im.qq.com/', 0, 0, 0, 3020, 0, 1, 0, NULL, 8, '', ''),
(2090, '1230191774', 'MSN', 'http://www.windowslive.cn/', 0, 0, 0, 3020, 0, 1, 0, NULL, 9, '', ''),
(2091, '1230191774', '千千静听', 'http://ttplayer.qianqian.com/', 0, 0, 0, 3020, 0, 1, 0, NULL, 10, '', ''),
(2092, '1230191774', '暴风影音', 'http://www.baofeng.com/', 0, 0, 0, 3020, 0, 1, 0, NULL, 11, '', ''),
(2093, '1230191774', '酷狗', 'http://www.kugou.com/', 0, 0, 0, 3020, 0, 1, 0, NULL, 12, '', ''),
(2094, '1230191774', '360安全卫士', 'http://www.360.cn/', 0, 0, 0, 3020, 0, 1, 0, NULL, 13, '', ''),
(2095, '1230191774', '联想', 'http://www.lenovo.com.cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 1, '', ''),
(2096, '1230191774', '索尼Sony', 'http://www.sony.com.cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 2, '', ''),
(2097, '1230191774', '苹果Apple', 'http://www.apple.com.cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 3, '', ''),
(2098, '1230191774', '戴尔Dell', 'http://www.dell.com.cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 4, '', ''),
(2099, '1230191774', 'nvidia', 'http://cn.nvidia.com/', 0, 0, 0, 3021, 0, 1, 0, NULL, 5, '', ''),
(2100, '1230191774', '惠普Hp', 'http://www.hp.com.cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 6, '', ''),
(2101, '1230191774', '宏碁Acer', 'http://www.acer.com.cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 7, '', ''),
(2102, '1230191774', '华硕Asus', 'http://www.asus.com.cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 8, '', ''),
(2103, '1230191774', '佳能Canon', 'http://www.canon.com.cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 9, '', ''),
(2104, '1230191774', '神州数码', 'http://www.digitalchina.com/Public/Home.aspx', 0, 0, 0, 3021, 0, 1, 0, NULL, 10, '', ''),
(2105, '1230191774', '微星', 'http://www.msi-china.com.cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 11, '', ''),
(2106, '1230191774', '文曲星', 'http://www.ggv.com.cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 12, '', ''),
(2107, '1230191774', '三星Samsung', 'http://www.samsung.com/cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 13, '', ''),
(2108, '1230191774', '神舟', 'http://www.hasee.com/', 0, 0, 0, 3021, 0, 1, 0, NULL, 14, '', ''),
(2109, '1230191774', '思科', 'http://www.cisco.com.cn/', 0, 0, 0, 3021, 0, 1, 0, NULL, 15, '', ''),
(2110, '1279617741', '桌面城市', 'http://www.deskcity.com/', 0, 0, 0, 3022, 0, 1, 0, NULL, 1, '', ''),
(2111, '1279617741', '天极桌面', 'http://desktop.yesky.com/', 0, 0, 0, 3022, 0, 1, 0, NULL, 2, '', ''),
(2112, '1279617741', '中国站长站-壁纸', 'http://desk.chinaz.com', 0, 0, 0, 3022, 0, 1, 0, NULL, 3, '', ''),
(2113, '1279617741', '猫猫壁纸酷', 'http://www.wallcoo.com/', 0, 0, 0, 3022, 0, 1, 0, NULL, 4, '', ''),
(2114, '1279617741', '清风桌面', 'http://www.winddesktop.com/', 0, 0, 0, 3022, 0, 1, 0, NULL, 5, '', ''),
(2115, '1279617741', '腾讯-壁纸站', 'http://comic.qq.com/wp/', 0, 0, 0, 3022, 0, 1, 0, NULL, 6, '', ''),
(2116, '1279617741', '宽屏壁纸网', 'http://www.kpbz.net/', 0, 0, 0, 3022, 0, 1, 0, NULL, 7, '', ''),
(2117, '1279617741', '桌酷壁纸', 'http://www.zhuoku.com/', 0, 0, 0, 3022, 0, 1, 0, NULL, 8, '', ''),
(2118, '1279617741', 'TOM-游戏壁纸', 'http://games.tom.com/pic/', 0, 0, 0, 3022, 0, 1, 0, NULL, 9, '', ''),
(2119, '1279617741', '雅虎精美壁纸', 'http://image.cn.yahoo.com/imglist.html', 0, 0, 0, 3022, 0, 1, 1289802420, NULL, 10, '', ''),
(2120, '1279617741', '图坊', 'http://www.leafweb.cn/', 0, 0, 0, 3022, 0, 1, 0, NULL, 11, '', ''),
(2121, '1279617741', '卡七七', 'http://www.ka77.com/', 0, 0, 0, 3022, 0, 1, 0, NULL, 12, '', ''),
(2122, '1279617741', '商都桌面', 'http://desk.shangdu.com', 0, 0, 0, 3022, 0, 1, 0, NULL, 13, '', ''),
(2123, '1279617741', '极酷桌面', 'http://kuoo8.com', 0, 0, 0, 3022, 0, 1, 0, NULL, 14, '', ''),
(2124, '1279617741', '酷酷桌面', 'http://www.kkdesk.com', 0, 0, 0, 3022, 0, 1, 0, NULL, 15, '', ''),
(2125, '1279617741', 'TopWalls', 'http://www.topwalls.com/', 0, 0, 0, 3022, 0, 1, 0, NULL, 16, '', ''),
(2126, '1279617741', 'DeviantART', 'http://www.deviantart.com/', 0, 0, 0, 3022, 0, 1, 0, NULL, 17, '', ''),
(2127, '1279617741', 'The Yellow Icon', 'http://www.yellowicon.com/', 0, 0, 0, 3022, 0, 1, 0, NULL, 18, '', ''),
(2128, '1279617741', 'WallpaperBase', 'http://www.wallpaperbase.com/', 0, 0, 0, 3022, 0, 1, 0, NULL, 19, '', ''),
(2129, '1279617741', '天天壁纸', 'http://www.ttbz8.com', 0, 0, 0, 3022, 0, 1, 0, NULL, 20, '', ''),
(2130, '1279617741', '经典桌面壁纸站', 'http://www.seedesk.cn/', 0, 0, 0, 3022, 0, 1, 0, NULL, 21, '', ''),
(2131, '1279617741', '壁纸千寻', 'http://www.cndesk.com', 0, 0, 0, 3022, 0, 1, 0, NULL, 22, '', ''),
(2132, '1279617741', '站酷', 'http://www.zcool.com.cn/', 0, 0, 0, 3023, 0, 1, 0, NULL, 1, '', ''),
(2133, '1279617741', '素材中国', 'http://www.sccnn.com/', 0, 0, 0, 3023, 0, 1, 0, NULL, 2, '', ''),
(2134, '1279617741', '天堂图库', 'http://www.ivsky.com/', 0, 0, 0, 3023, 0, 1, 0, NULL, 3, '', ''),
(2135, '1279617741', '酷素材', 'http://www.coolsc.net/', 0, 0, 0, 3023, 0, 1, 0, NULL, 4, '', ''),
(2136, '1279617741', 'GettyImages中国', 'http://www.gettyimages.cn/', 0, 0, 0, 3023, 0, 1, 0, NULL, 5, '', ''),
(2137, '1279617741', '视觉中国', 'http://www.chinavisual.com/', 0, 0, 0, 3024, 0, 1, 0, NULL, 1, '', ''),
(2138, '1279617741', '中国插画网', 'http://www.chahua.org/', 0, 0, 0, 3024, 0, 1, 0, NULL, 2, '', ''),
(2139, '1279617741', '红动中国', 'http://bbs.redocn.com/', 0, 0, 0, 3024, 0, 1, 0, NULL, 3, '', ''),
(2140, '1279617741', '视觉同盟', 'http://www.visionunion.com/', 0, 0, 0, 3024, 0, 1, 0, NULL, 4, '', ''),
(2141, '1279617741', '设计吧廊', 'http://www.balang88.cn/', 0, 0, 0, 3024, 0, 1, 0, NULL, 5, '', ''),
(2142, '1279617741', '设计在线', 'http://www.dolcn.com/', 0, 0, 0, 3024, 0, 1, 0, NULL, 6, '', ''),
(2143, '1279617741', '我爱制图', 'http://www.52zt.cn/', 0, 0, 0, 3024, 0, 1, 0, NULL, 7, '', ''),
(2144, '1279617741', '中国艺术设计联盟', 'http://www.arting365.com/', 0, 0, 0, 3024, 0, 1, 0, NULL, 8, '', ''),
(2145, '1279617741', 'ps联盟', 'http://www.68ps.com/', 0, 0, 0, 3024, 0, 1, 0, NULL, 10, '', ''),
(2146, '1279617741', '字体下载大宝库', 'http://font.knowsky.com/', 0, 0, 0, 3024, 0, 1, 0, NULL, 11, '', ''),
(2147, '1279617741', '腾讯QQ', 'http://im.qq.com/', 0, 0, 0, 3025, 0, 1, 0, NULL, 1, '', ''),
(2148, '1279617741', 'MSN', 'http://im.live.cn/', 0, 0, 0, 3025, 0, 1, 0, NULL, 2, '', ''),
(2149, '1279617741', 'Skype语音沟通', 'http://skype.tom.com', 0, 0, 0, 3025, 0, 1, 0, NULL, 3, '', ''),
(2150, '1279617741', '新浪UC', 'http://uc.sina.com.cn/', 0, 0, 0, 3025, 0, 1, 0, NULL, 4, '', ''),
(2151, '1279617741', '飞信', 'http://www.fetion.com.cn/', 0, 0, 0, 3025, 0, 1, 0, NULL, 5, '', ''),
(2152, '1279617741', '雅虎通', 'http://cn.messenger.yahoo.com/', 0, 0, 0, 3025, 0, 1, 0, NULL, 6, '', ''),
(2153, '1279617741', '网易泡泡', 'http://popo.163.com', 0, 0, 0, 3025, 0, 1, 0, NULL, 7, '', ''),
(2154, '1279617741', '阿里旺旺', 'http://alitalk.alibaba.com.cn/', 0, 0, 0, 3025, 0, 1, 0, NULL, 8, '', ''),
(2155, '1279617741', '百度HI', 'http://im.baidu.com/', 0, 0, 0, 3025, 0, 1, 0, NULL, 9, '', ''),
(2156, '1279617741', '校内通', 'http://xiaonei.com/pages/im.jsp', 0, 0, 0, 3025, 0, 1, 0, NULL, 10, '', ''),
(2157, '1279617741', 'ICQ', 'http://www.icq.com', 0, 0, 0, 3025, 0, 1, 0, NULL, 11, '', ''),
(2158, '1279617741', 'Google Talk', 'http://www.google.com/talk/', 0, 0, 0, 3025, 0, 1, 0, NULL, 12, '', ''),
(2159, '1279617741', 'TS-Teamspeak', 'http://ts.youxia.com/', 0, 0, 0, 3025, 0, 1, 0, NULL, 13, '', ''),
(2160, '1279617741', '小i机器人', 'http://www.xiaoi.com/', 0, 0, 0, 3025, 0, 1, 1289802466, NULL, 14, '', ''),
(2161, '1279617741', 'UUCall网络电话', 'http://www.uucall.com/', 0, 0, 0, 3025, 0, 1, 0, NULL, 15, '', ''),
(2162, '1279617741', 'MSNshell', 'http://www.msnshell.com/', 0, 0, 0, 3025, 0, 1, 0, NULL, 16, '', ''),
(2163, '1279617741', '手机版QQ', 'http://mobile.qq.com/', 0, 0, 0, 3025, 0, 1, 0, NULL, 17, '', ''),
(2164, '1279617741', '手机版MSN', 'http://mobile.msn.com.cn/', 0, 0, 0, 3025, 0, 1, 0, NULL, 18, '', ''),
(2165, '1279617741', '爱聊视频聊天室', 'http://www.loveliao.com/', 0, 0, 0, 3026, 0, 1, 0, NULL, 1, '', ''),
(2166, '1279617741', '新浪UC视频聊天室', 'http://chat.sina.com.cn/homepage/chat_index.shtml', 0, 0, 0, 3026, 0, 1, 0, NULL, 2, '', ''),
(2167, '1279617741', '碧聊聊天大观园', 'http://bliao.com/', 0, 0, 0, 3026, 0, 1, 0, NULL, 3, '', ''),
(2168, '1279617741', 'QQ聊天室', 'http://chat.qq.com/', 0, 0, 0, 3026, 0, 1, 0, NULL, 4, '', ''),
(2169, '1279617741', '聊聊语音聊天', 'http://www.liaoliao.com', 0, 0, 0, 3026, 0, 1, 0, NULL, 5, '', ''),
(2170, '1279617741', '鹏城聊天室', 'http://chat.sz.net.cn/', 0, 0, 0, 3026, 0, 1, 0, NULL, 6, '', ''),
(2171, '1279617741', '乐趣聊天室　', 'http://chat.netsh.com/', 0, 0, 0, 3026, 0, 1, 0, NULL, 7, '', ''),
(2172, '1279617741', 'DoShow', 'http://www.doshow.cn/', 0, 0, 0, 3026, 0, 1, 0, NULL, 10, '', ''),
(2173, '1279617741', 'VQQ围圈圈聊天室', 'http://beta.vqq.com/', 0, 0, 0, 3026, 0, 1, 0, NULL, 11, '', ''),
(2174, '1279617741', '泉州聊天室', 'http://chat.qz.fj.cn', 0, 0, 0, 3026, 0, 1, 0, NULL, 12, '', ''),
(2175, '1279617741', '银河网-聊天', 'http://chat.inhe.net/', 0, 0, 0, 3026, 0, 1, 0, NULL, 13, '', ''),
(2176, '1279617741', '中国学生网-学生聊天', 'http://chat.6to23.com/', 0, 0, 0, 3026, 0, 1, 0, NULL, 14, '', ''),
(2177, '1279617741', '七聊', 'http://www.7liao.com/', 0, 0, 0, 3026, 0, 1, 0, NULL, 15, '', ''),
(2178, '1279617741', '网聊娱乐网', 'http://www.netliao.com/', 0, 0, 0, 3026, 0, 1, 0, NULL, 16, '', ''),
(2179, '1279617741', '胖鼠表情网', 'http://www.pangshu.com/', 0, 0, 0, 3027, 0, 1, 0, NULL, 1, '', ''),
(2180, '1279617741', 'QQ家园', 'http://www.qqjia.com/', 0, 0, 0, 3027, 0, 1, 0, NULL, 2, '', ''),
(7854, '1289802154', '北京人才招聘网', 'http://www.beijingjob.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 4, '', ''),
(2182, '1279617741', '字Q', 'http://www.ziq.com/', 0, 0, 0, 3027, 0, 1, 0, NULL, 4, '', ''),
(2183, '1279617741', 'QQ极速网', 'http://www.uiqq.cn/', 0, 0, 0, 3027, 0, 1, 0, NULL, 5, '', ''),
(2184, '1279617741', '彩字秀', 'http://www.czxiu.com/', 0, 0, 0, 3027, 0, 1, 0, NULL, 6, '', ''),
(2185, '1279617741', 'QQ个性头像网', 'http://www.touxiang.cn/', 0, 0, 0, 3027, 0, 1, 0, NULL, 7, '', ''),
(2186, '1279617741', '火星文输入法', 'http://hx.173fzl.cn/', 0, 0, 0, 3027, 0, 1, 0, NULL, 8, '', ''),
(2187, '1279617741', 'QQ聊天宝典', 'http://www.oicq88.com/', 0, 0, 0, 3027, 0, 1, 0, NULL, 9, '', ''),
(2188, '1279617741', '明星头像网', 'http://www.12127.net', 0, 0, 0, 3027, 0, 1, 0, NULL, 10, '', ''),
(2189, '1279617741', 'QQ网名', 'http://www.qqwangming.org/', 0, 0, 0, 3027, 0, 1, 0, NULL, 11, '', ''),
(2190, '1279617741', 'QQ个性网', 'http://qqgexing.com/', 0, 0, 0, 3027, 0, 1, 0, NULL, 12, '', ''),
(2191, '1279617741', '欣欣社区', 'http://bbs.xinxin2008.com/', 0, 0, 0, 3027, 0, 1, 0, NULL, 13, '', ''),
(2192, '1279617741', '佳友在线摄影网', 'http://www.photofans.cn/forum.php', 0, 0, 0, 3028, 0, 1, 0, NULL, 1, '', ''),
(2193, '1279617741', '太平洋摄影部落', 'http://www.pconline.com.cn/digital/photo/', 0, 0, 0, 3028, 0, 1, 0, NULL, 2, '', ''),
(2194, '1279617741', '浮光掠影论坛', 'http://www.fgly.cn/bbs/index.php', 0, 0, 0, 3028, 0, 1, 0, NULL, 3, '', ''),
(2195, '1279617741', '中华相机网', 'http://www.camgle.com/', 0, 0, 0, 3028, 0, 1, 0, NULL, 4, '', ''),
(2196, '1279617741', 'PChome-数码影像俱乐部', 'http://club.pchome.net/', 0, 0, 0, 3028, 0, 1, 1289802494, NULL, 5, '', ''),
(2197, '1279617741', '成名数码社区', 'http://bbs.cmd365.com/', 0, 0, 0, 3028, 0, 1, 0, NULL, 6, '', ''),
(2198, '1279617741', '火烈鸟摄影论坛', 'http://www.huolieniao.net/', 0, 0, 0, 3028, 0, 1, 0, NULL, 7, '', ''),
(2199, '1279617741', '东北风摄影论坛', 'http://www.dongbeifeng.com/bbs/index.php', 0, 0, 0, 3028, 0, 1, 0, NULL, 8, '', ''),
(2200, '1279617741', '中国婚纱摄影网论坛', 'http://bbs.wedchina.com/', 0, 0, 0, 3028, 0, 1, 0, NULL, 9, '', ''),
(2201, '1279617741', '色影无忌', 'http://www.xitek.com/', 0, 0, 0, 3029, 0, 1, 0, NULL, 1, '', ''),
(2202, '1279617741', '大众摄影', 'http://www.pop-photo.com.cn/', 0, 0, 0, 3029, 0, 1, 0, NULL, 2, '', ''),
(2203, '1279617741', '中国摄影在线', 'http://www.cphoto.net/', 0, 0, 0, 3029, 0, 1, 0, NULL, 3, '', ''),
(2204, '1279617741', '蜂鸟在线', 'http://www.fengniao.com/', 0, 0, 0, 3029, 0, 1, 0, NULL, 4, '', ''),
(2205, '1279617741', '中国摄影家协会', 'http://www.cpanet.cn/', 0, 0, 0, 3029, 0, 1, 0, NULL, 5, '', ''),
(2206, '1279617741', '橡树摄影网', 'http://www.xiangshu.com/', 0, 0, 0, 3029, 0, 1, 0, NULL, 6, '', ''),
(2207, '1279617741', '新摄影', 'http://www.nphoto.net/', 0, 0, 0, 3029, 0, 1, 0, NULL, 7, '', ''),
(2208, '1279617741', '天涯社区摄影', 'http://www.tianya.cn/new/Publicforum/ArticlesList.asp?strItem=tianyaphoto&idWriter=0&Key=0&Part=0', 0, 0, 0, 3029, 0, 1, 0, NULL, 8, '', ''),
(2209, '1279617741', '迪派影像', 'http://www.dpnet.com.cn/', 0, 0, 0, 3029, 0, 1, 0, NULL, 9, '', ''),
(2210, '1279617741', '摄影吧', 'http://www.der8.cn/', 0, 0, 0, 3029, 0, 1, 0, NULL, 10, '', ''),
(2211, '1279617741', '图说天下', 'http://www.fotosay.com/', 0, 0, 0, 3029, 0, 1, 0, NULL, 11, '', ''),
(2212, '1279617741', '照片处理网', 'http://www.photops.com/', 0, 0, 0, 3029, 0, 1, 0, NULL, 12, '', ''),
(2213, '1279617741', '新摄影论坛', 'http://forums.nphoto.net/', 0, 0, 0, 3029, 0, 1, 0, NULL, 13, '', ''),
(2214, '1279617741', '教你用相机', 'http://www.pconline.com.cn/digital/dc/jiqiao/', 0, 0, 0, 3029, 0, 1, 0, NULL, 14, '', ''),
(2215, '1279617741', '尼康', 'http://www.nikon.com.cn/', 0, 0, 0, 3030, 0, 1, 0, NULL, 1, '', ''),
(2216, '1279617741', '佳能', 'http://www.canon.com.cn/', 0, 0, 0, 3030, 0, 1, 0, NULL, 2, '', ''),
(2217, '1279617741', '索尼', 'http://www.sonystyle.com.cn/products/cyber-shot/index.htm', 0, 0, 0, 3030, 0, 1, 0, NULL, 3, '', ''),
(2218, '1279617741', '奥林巴斯', 'http://www.olympus.com.cn/', 0, 0, 0, 3030, 0, 1, 0, NULL, 4, '', ''),
(2219, '1279617741', '富士', 'http://www.fujifilm.com.cn/', 0, 0, 0, 3030, 0, 1, 0, NULL, 5, '', ''),
(2220, '1279617741', '柯达', 'http://www.kodak.com.cn/', 0, 0, 0, 3030, 0, 1, 0, NULL, 6, '', ''),
(2221, '1279617741', '爱国者', 'http://www.aigo.com/ProductCategory-4.aspx', 0, 0, 0, 3030, 0, 1, 0, NULL, 7, '', ''),
(2222, '1279617741', '新东方在线', 'http://www.koolearn.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 1, '', ''),
(2223, '1279617741', '中国英语学习网', 'http://www.24en.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 2, '', ''),
(2224, '1279617741', '新浪外语', 'http://edu.sina.com.cn/en/', 0, 0, 0, 3031, 0, 1, 0, NULL, 3, '', ''),
(2225, '1279617741', '沪江英语', 'http://www.hjenglish.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 4, '', ''),
(2226, '1279617741', '中国日报英文版', 'http://www.chinadaily.net/', 0, 0, 0, 3031, 0, 1, 0, NULL, 5, '', ''),
(2227, '1279617741', '我爱英语网', 'http://www.52en.com', 0, 0, 0, 3031, 0, 1, 0, NULL, 6, '', ''),
(2228, '1279617741', '21世纪在线', 'http://www.21stcentury.com.cn/', 0, 0, 0, 3031, 0, 1, 0, NULL, 7, '', ''),
(2229, '1279617741', '旺旺英语学习网', 'http://www.wwenglish.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 8, '', ''),
(2230, '1279617741', '无忧雅思网', 'http://www.51ielts.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 9, '', ''),
(2231, '1279617741', '普特英语听力', 'http://www.putclub.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 10, '', ''),
(2232, '1279617741', '英文写作网', 'http://www.4ewriting.com', 0, 0, 0, 3031, 0, 1, 0, NULL, 11, '', ''),
(2233, '1279617741', '英语学习频道', 'http://www.unsv.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 12, '', ''),
(2234, '1279617741', '英语点津', 'http://language.chinadaily.com.cn', 0, 0, 0, 3031, 0, 1, 0, NULL, 13, '', ''),
(2235, '1279617741', '中国英语网', 'http://www.chinaenglish.com.cn/', 0, 0, 0, 3031, 0, 1, 0, NULL, 14, '', ''),
(2236, '1279617741', '可可听力网', 'http://www.kekenet.com', 0, 0, 0, 3031, 0, 1, 0, NULL, 15, '', ''),
(2237, '1279617741', '英语辅导报', 'http://www.ecp.com.cn/', 0, 0, 0, 3031, 0, 1, 0, NULL, 16, '', ''),
(2238, '1279617741', '英语周报', 'http://www.ew.com.cn/', 0, 0, 0, 3031, 0, 1, 0, NULL, 17, '', ''),
(2239, '1279617741', '学英语报', 'http://www.e-l-e.net.cn/', 0, 0, 0, 3031, 0, 1, 0, NULL, 18, '', ''),
(2240, '1279617741', '中国四六级考试网', 'http://www.china-cet.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 19, '', ''),
(2241, '1279617741', 'CET考试成绩查询', 'http://cet.99sushe.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 20, '', ''),
(2242, '1279617741', '听力课堂', 'http://www.tingclass.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 21, '', ''),
(2243, '1279617741', '原版英语小说', 'http://www.en8848.com', 0, 0, 0, 3031, 0, 1, 0, NULL, 22, '', ''),
(2244, '1279617741', '大耳朵英语', 'http://www.ebigear.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 23, '', ''),
(2245, '1279617741', '外研社', 'http://www.fltrp.com/', 0, 0, 0, 3031, 0, 1, 0, NULL, 24, '', ''),
(2246, '1279617741', '环球时报英文版', 'http://www.globaltimes.cn', 0, 0, 0, 3031, 0, 1, 0, NULL, 25, '', ''),
(2247, '1279617741', '爱词霸在线翻译', 'http://www.iciba.net', 0, 0, 0, 3032, 0, 1, 0, NULL, 1, '', ''),
(2248, '1279617741', '百度词典', 'http://www.baidu.com/search/dict.html', 0, 0, 0, 3032, 0, 1, 0, NULL, 2, '', ''),
(2249, '1279617741', 'Google在线翻译', 'http://www.google.com/language_tools?hl=zh-CN', 0, 0, 0, 3032, 0, 1, 0, NULL, 3, '', ''),
(2250, '1279617741', '雅虎在线翻译', 'http://fanyi.cn.yahoo.com/', 0, 0, 0, 3032, 0, 1, 0, NULL, 4, '', ''),
(2251, '1279617741', '沪江小D在线词典', 'http://dict.hjenglish.com/', 0, 0, 0, 3032, 0, 1, 0, NULL, 6, '', ''),
(2252, '1279617741', '句酷例句搜索', 'http://www.jukuu.com', 0, 0, 0, 3032, 0, 1, 0, NULL, 7, '', ''),
(2253, '1279617741', '剑桥词典', 'http://dictionary.cambridge.org/', 0, 0, 0, 3032, 0, 1, 0, NULL, 8, '', ''),
(2254, '1279617741', '韦氏词典', 'http://www.m-w.com/', 0, 0, 0, 3032, 0, 1, 0, NULL, 9, '', ''),
(2255, '1279617741', 'Dict.cn海词', 'http://www.dict.cn', 0, 0, 0, 3032, 0, 1, 0, NULL, 10, '', ''),
(2256, '1279617741', '查单词', 'http://www.chadanci.com', 0, 0, 0, 3032, 0, 1, 0, NULL, 11, '', ''),
(2257, '1279617741', '金桥翻译', 'http://www.netat.net/', 0, 0, 0, 3032, 0, 1, 0, NULL, 12, '', ''),
(2258, '1279617741', '金山词霸免费版下载', 'http://www.xiazaiba.com/downinfo/4419.html', 0, 0, 0, 3032, 0, 1, 0, NULL, 13, '', ''),
(2259, '1279617741', '滴答网', 'http://www.tigtag.com/', 0, 0, 0, 3032, 0, 1, 0, NULL, 1, '', ''),
(2260, '1279617741', '中国留学网', 'http://www.cscse.edu.cn/', 0, 0, 0, 3032, 0, 1, 0, NULL, 2, '', ''),
(2261, '1279617741', '太傻网', 'http://www.taisha.org/', 0, 0, 0, 3032, 0, 1, 0, NULL, 3, '', ''),
(2262, '1279617741', '国家留学基金委', 'http://www.csc.edu.cn/', 0, 0, 0, 3032, 0, 1, 0, NULL, 4, '', ''),
(2263, '1279617741', '寄托家园', 'http://bbs.gter.net/bbs/', 0, 0, 0, 3032, 0, 1, 0, NULL, 5, '', ''),
(2264, '1279617741', '留学e网', 'http://www.eduwo.com/', 0, 0, 0, 3032, 0, 1, 0, NULL, 6, '', ''),
(2265, '1279617741', 'abcdv德国留学', 'http://www.abcdvbbs.net/', 0, 0, 0, 3032, 0, 1, 0, NULL, 7, '', ''),
(2266, '1279617741', '金吉列', 'http://www.jjl.cn/', 0, 0, 0, 3032, 0, 1, 0, NULL, 8, '', ''),
(2267, '1279617741', '小春日本留学', 'http://www.xiaochuncnjp.com/', 0, 0, 0, 3032, 0, 1, 0, NULL, 9, '', ''),
(2268, '1279617741', '百度知道-留学', 'http://edu.zhidao.baidu.com/liuxue/', 0, 0, 0, 3032, 0, 1, 0, NULL, 10, '', ''),
(2269, '1279617741', '小春日语论坛', 'http://www.xiaochuncnjp.com/', 0, 0, 0, 3034, 0, 1, 0, NULL, 1, '', ''),
(2270, '1279617741', '贯通日本语', 'http://www.kantsuu.com', 0, 0, 0, 3034, 0, 1, 0, NULL, 2, '', ''),
(2271, '1279617741', '沪江日语', 'http://jp.hjenglish.com/', 0, 0, 0, 3034, 0, 1, 0, NULL, 3, '', ''),
(2272, '1279617741', '和风日语网', 'http://www.jpwind.com/', 0, 0, 0, 3034, 0, 1, 0, NULL, 4, '', ''),
(2273, '1279617741', '咖啡日语', 'http://coffeejp.com/', 0, 0, 0, 3034, 0, 1, 0, NULL, 5, '', ''),
(2274, '1279617741', '韩国新网', 'http://www.koreaxin.com/', 0, 0, 0, 3034, 0, 1, 0, NULL, 6, '', ''),
(2275, '1279617741', '我爱韩语网', 'http://www.52kr.com/', 0, 0, 0, 3034, 0, 1, 0, NULL, 7, '', ''),
(2276, '1279617741', '中韩翻译网', 'http://www.chi2ko.com/index-chi.htm', 0, 0, 0, 3034, 0, 1, 0, NULL, 8, '', ''),
(2277, '1279617741', '缘缘法语', 'http://www.yuanfr.com/', 0, 0, 0, 3034, 0, 1, 0, NULL, 9, '', ''),
(2278, '1279617741', '西班牙语角', 'http://www.iniy.com/', 0, 0, 0, 3034, 0, 1, 0, NULL, 10, '', ''),
(2279, '1279617741', '德语德国', 'http://www.dedecn.com/', 0, 0, 0, 3034, 0, 1, 0, NULL, 11, '', ''),
(2280, '1279617741', '疯狂俄语', 'http://www.aif.cn/', 0, 0, 0, 3034, 0, 1, 0, NULL, 12, '', ''),
(2281, '1279617741', '阿拉伯语教学', 'http://www.alaboyu.com', 0, 0, 0, 3034, 0, 1, 0, NULL, 13, '', ''),
(2282, '1289541880', '新浪公务员考试', 'http://edu.sina.com.cn/focus/official.html', 0, 0, 0, 3035, 0, 1, 0, NULL, 1, '', ''),
(2283, '1289541880', '无忧考网公务员考试', 'http://www.51test.net/indexmain.asp?classid=5&amp;amp;Nclassid=44', 0, 0, 0, 3035, 0, 1, 0, NULL, 2, '', ''),
(2284, '1289541880', '腾讯公务员考试', 'http://edu.qq.com/official/', 0, 0, 0, 3035, 0, 1, 0, NULL, 3, '', ''),
(2285, '1289541880', '人力资源和社会保障部', 'http://www.mohrss.gov.cn/', 0, 0, 0, 3035, 0, 1, 0, NULL, 4, '', ''),
(2286, '1289541880', '中公教育网', 'http://www.offcn.com/', 0, 0, 0, 3035, 0, 1, 0, NULL, 5, '', ''),
(2287, '1289541880', '华图教育-公务员', 'http://www.htexam.com/Index.html', 0, 0, 0, 3035, 0, 1, 0, NULL, 6, '', ''),
(2288, '1289541880', '国家公务员网', 'http://www.chinagwy.org/', 0, 0, 0, 3035, 0, 1, 0, NULL, 7, '', ''),
(2289, '1289541880', '中招在线-公务员考试', 'http://gwy.yuloo.com/', 0, 0, 0, 3035, 0, 1, 0, NULL, 8, '', ''),
(2290, '1289541880', '国公网', 'http://www.21gwy.com', 0, 0, 0, 3035, 0, 1, 0, NULL, 9, '', ''),
(2291, '1289541972', '海关公务员考试', 'http://www1.customs.gov.cn/default.aspx?tabid=5046', 0, 0, 0, 3035, 0, 1, 0, NULL, 10, '', ''),
(2292, '1289541972', '新浪考研', 'http://edu.sina.com.cn/kaoyan/', 0, 0, 0, 3036, 0, 1, 0, NULL, 1, '', ''),
(2293, '1289541972', '研究生招生信息网', 'http://yz.chsi.com.cn/', 0, 0, 0, 3036, 0, 1, 0, NULL, 2, '', ''),
(2294, '1289541972', '中国考研网', 'http://www.chinakaoyan.com/', 0, 0, 0, 3036, 0, 1, 0, NULL, 3, '', ''),
(2295, '1289541972', '考研论坛', 'http://bbs.kaoyan.com/', 0, 0, 0, 3036, 0, 1, 0, NULL, 4, '', ''),
(2296, '1289541972', '医学考研社区', 'http://www.medkaoyan.net/myforum/', 0, 0, 0, 3036, 0, 1, 0, NULL, 5, '', ''),
(2297, '1289541972', '腾讯考研', 'http://edu.qq.com/y/', 0, 0, 0, 3036, 0, 1, 0, NULL, 6, '', ''),
(2298, '1289541972', '考研教育网', 'http://www.cnedu.cn/', 0, 0, 0, 3036, 0, 1, 0, NULL, 7, '', ''),
(2299, '1289541972', '考研加油站', 'http://www.kaoyan.com/', 0, 0, 0, 3036, 0, 1, 0, NULL, 8, '', ''),
(2300, '1289541972', '医学考研网', 'http://www.medkaoyan.net/', 0, 0, 0, 3036, 0, 1, 0, NULL, 9, '', ''),
(2301, '1289541972', '跨考网', 'http://www.kuakao.com/', 0, 0, 0, 3036, 0, 1, 0, NULL, 10, '', ''),
(2302, '1289541972', '搜狐考研', 'http://learning.sohu.com/kaoyan.shtml', 0, 0, 0, 3036, 0, 1, 0, NULL, 11, '', ''),
(2303, '1289541972', '文登教育', 'http://www.wendeng.com.cn/', 0, 0, 0, 3036, 0, 1, 0, NULL, 12, '', ''),
(2304, '1289541972', '考研共济网', 'http://www.kaoyantj.com/', 0, 0, 0, 3036, 0, 1, 0, NULL, 13, '', ''),
(2305, '1289541972', '知识宝库', 'http://www.1zhao.org/', 0, 0, 0, 3036, 0, 1, 0, NULL, 14, '', ''),
(2306, '1289541972', '小木虫', 'http://emuch.net/bbs/', 0, 0, 0, 3036, 0, 1, 0, NULL, 15, '', ''),
(2307, '1289541972', '人大经济论坛', 'http://www.pinggu.org/bbs/', 0, 0, 0, 3036, 0, 1, 1289802661, NULL, 16, '', ''),
(2308, '1289542018', '自考365', 'http://www.zikao365.com', 0, 0, 0, 3037, 0, 1, 0, NULL, 1, '', ''),
(2309, '1289542018', '各地自考办联系方式', 'http://edu.sina.com.cn/zikao/0/17.html', 0, 0, 0, 3037, 0, 1, 0, NULL, 2, '', ''),
(2310, '1289542018', '中国自考网', 'http://www.chinazikao.com/', 0, 0, 0, 3037, 0, 1, 0, NULL, 3, '', ''),
(2311, '1289542018', '中国教育在线-自考', 'http://zikao.eol.cn/', 0, 0, 0, 3037, 0, 1, 0, NULL, 4, '', ''),
(2312, '1289542018', '搜狐自考辅导站', 'http://learning.sohu.com/zikaozhan.shtml', 0, 0, 0, 3037, 0, 1, 0, NULL, 5, '', ''),
(2313, '1289542018', '新浪自考频道', 'http://edu.sina.com.cn/zikao/', 0, 0, 0, 3037, 0, 1, 0, NULL, 6, '', ''),
(2314, '1289542018', '腾讯自考站', 'http://edu.qq.com/zikao.shtml', 0, 0, 0, 3037, 0, 1, 0, NULL, 7, '', ''),
(2315, '1289542018', '自考频道-中招在线', 'http://www.zhongzhao.com/zikao/916/', 0, 0, 0, 3037, 0, 1, 0, NULL, 8, '', ''),
(2316, '1289542018', '中华网自学考试', 'http://edu.china.com/zh_cn/level/', 0, 0, 0, 3037, 0, 1, 0, NULL, 9, '', ''),
(2317, '1289542018', '考易网成人高考频道', 'http://www.kao100.com/ChengKao/Default.aspx', 0, 0, 0, 3037, 0, 1, 0, NULL, 10, '', ''),
(2318, '1289542018', '全国大学四六级考试', 'http://www.cet.edu.cn/', 0, 0, 0, 3038, 0, 1, 0, NULL, 1, '', ''),
(2319, '1289542018', '四六级考试网', 'http://www.china-cet.com/', 0, 0, 0, 3038, 0, 1, 0, NULL, 2, '', ''),
(2320, '1289542018', '英语四六级-新浪考试', 'http://edu.sina.com.cn/exam/cet/index.shtml', 0, 0, 0, 3038, 0, 1, 0, NULL, 3, '', ''),
(2321, '1289542018', '新东方英语', 'http://www.neworiental.org/', 0, 0, 0, 3038, 0, 1, 0, NULL, 4, '', ''),
(2322, '1289542018', '我要模考网', 'http://www.51mokao.com/', 0, 0, 0, 3038, 0, 1, 0, NULL, 5, '', ''),
(2323, '1289542018', '托福网考网上报名', 'http://toefl.etest.net.cn/', 0, 0, 0, 3038, 0, 1, 0, NULL, 6, '', ''),
(2324, '1289542018', '太傻留学论坛', 'http://bbs.taisha.org/', 0, 0, 0, 3038, 0, 1, 0, NULL, 7, '', ''),
(2325, '1289542018', '雅思网上报名', 'http://ielts.etest.edu.cn/', 0, 0, 0, 3038, 0, 1, 0, NULL, 8, '', ''),
(2326, '1289542018', '中国雅思网', 'http://www.cnielts.com/', 0, 0, 0, 3038, 0, 1, 0, NULL, 9, '', ''),
(2327, '1289541901', '全国计算机等级考试', 'http://www.ncre.cn', 0, 0, 0, 3039, 0, 1, 0, NULL, 1, '', ''),
(2328, '1289541901', '东方教育网', 'http://www.eastedu.com.cn', 0, 0, 0, 3039, 0, 1, 0, NULL, 2, '', ''),
(2329, '1289541901', '思达网校IT认证', 'http://www.staredu.net', 0, 0, 0, 3039, 0, 1, 0, NULL, 3, '', ''),
(2330, '1289541901', '计算机-新浪考试', 'http://edu.sina.com.cn/exam/pc/', 0, 0, 0, 3039, 0, 1, 0, NULL, 4, '', ''),
(2331, '1289541901', 'IT教育培训-搜狐教育', 'http://learning.sohu.com/s2005/jisuanji.shtml', 0, 0, 0, 3039, 0, 1, 0, NULL, 5, '', ''),
(2332, '1289541901', '育路网-计算机考试认证', 'http://www.yuloo.com/jsjks/', 0, 0, 0, 3039, 0, 1, 0, NULL, 6, '', ''),
(2333, '1289541901', '网大-计算机考试', 'http://cce.netbig.com/', 0, 0, 0, 3039, 0, 1, 0, NULL, 7, '', ''),
(2334, '1289541901', '考试吧-计算机考试', 'http://www.exam8.com/computer/djks/', 0, 0, 0, 3039, 0, 1, 0, NULL, 8, '', ''),
(2335, '1289541851', '财考网', 'http://www.ck100.com', 0, 0, 0, 3039, 0, 1, 0, NULL, 9, '', ''),
(2336, '1289541851', '中国财会网', 'http://www.kj2000.com', 0, 0, 0, 3039, 0, 1, 0, NULL, 10, '', ''),
(2337, '1289541851', '金榜网', 'http://www.goodedu.cn/Article/exam/caikuai/', 0, 0, 0, 3039, 0, 1, 0, NULL, 11, '', ''),
(2338, '1289541851', '青年人财考网', 'http://www.qnr.cn/caihui/', 0, 0, 0, 3039, 0, 1, 0, NULL, 12, '', ''),
(2339, '1289541851', '考试大财考网', 'http://www.examda.com/Accountant/', 0, 0, 0, 3039, 0, 1, 0, NULL, 13, '', ''),
(2340, '1289541851', '新浪-会计考试', 'http://edu.sina.com.cn/cpa/index.shtml', 0, 0, 0, 3039, 0, 1, 0, NULL, 14, '', ''),
(2341, '1289541851', '腾讯-会计考试', 'http://edu.qq.com/caikao.htm', 0, 0, 0, 3039, 0, 1, 0, NULL, 15, '', ''),
(2342, '1289541851', '中国会计师视野', 'http://www.esnai.com/', 0, 0, 0, 3039, 0, 1, 0, NULL, 16, '', ''),
(2343, '1289541851', '中国财税网', 'http://www.edu110.com/', 0, 0, 0, 3039, 0, 1, 0, NULL, 17, '', ''),
(2344, '1289541851', '中国精品教育网', 'http://www.edu24h.com/caikuai/main/', 0, 0, 0, 3039, 0, 1, 0, NULL, 18, '', ''),
(2345, '1289541851', '中国财考网', 'http://www.ckexam.com', 0, 0, 0, 3039, 0, 1, 0, NULL, 19, '', ''),
(2346, '1289541851', '中华会计网校', 'http://www.accacc.org.cn/', 0, 0, 0, 3039, 0, 1, 0, NULL, 20, '', ''),
(2347, '1289541851', '中国会计人', 'http://www.ccppaa.com', 0, 0, 0, 3039, 0, 1, 0, NULL, 21, '', ''),
(2348, '1289541851', '中国会计网', 'http://www.canet.com.cn', 0, 0, 0, 3039, 0, 1, 0, NULL, 22, '', ''),
(2349, '1289541972', '注册会计师考试', 'http://www.cicpa.org.cn/', 0, 0, 0, 3039, 0, 1, 0, NULL, 23, '', ''),
(2350, '1289541972', '中华会计网校', 'http://www.chinaacc.com/', 0, 0, 0, 3039, 0, 1, 0, NULL, 24, '', ''),
(2351, '1289541972', '国家司法考试', 'http://www.moj.gov.cn/sfkss/node_226.htm', 0, 0, 0, 3039, 0, 1, 0, NULL, 25, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(2352, '1289541972', '新浪－司法考试', 'http://edu.sina.com.cn/exam/lawyer/', 0, 0, 0, 3039, 0, 1, 0, NULL, 26, '', ''),
(2353, '1289541972', '中国注册金融分析师', 'http://www.crfa.org.cn/', 0, 0, 0, 3039, 0, 1, 0, NULL, 27, '', ''),
(2354, '1289542039', '法律教育网', 'http://www.chinalawedu.com', 0, 0, 0, 3039, 0, 1, 0, NULL, 28, '', ''),
(2355, '1289542039', '万国司法考试', 'http://www.wanguoschool.net', 0, 0, 0, 3039, 0, 1, 0, NULL, 29, '', ''),
(2356, '1289542039', '中国司法考试在线', 'http://www.sifa2000.com', 0, 0, 0, 3039, 0, 1, 0, NULL, 30, '', ''),
(2357, '1289542039', '中国普法网(司法部)', 'http://www.legalinfo.gov.cn/', 0, 0, 0, 3039, 0, 1, 0, NULL, 31, '', ''),
(2358, '1289542039', '律政中国司法考试网', 'http://www.lzschool.org.cn/', 0, 0, 0, 3039, 0, 1, 0, NULL, 32, '', ''),
(2359, '1289542039', '腾讯司法考试', 'http://edu.qq.com/kszx/sf_index.shtml', 0, 0, 0, 3039, 0, 1, 0, NULL, 33, '', ''),
(2360, '1289542039', '新九州司法考试', 'http://law.jiuzhou001.com/', 0, 0, 0, 3039, 0, 1, 0, NULL, 34, '', ''),
(2361, '1289542039', '国家司法考试网', 'http://www.cnsikao.com/', 0, 0, 0, 3039, 0, 1, 0, NULL, 35, '', ''),
(2362, '1289542039', '司法考试-法法网', 'http://www.fafawang.com/', 0, 0, 0, 3039, 0, 1, 0, NULL, 36, '', ''),
(2363, '1289542039', '国家司法考试-满分网', 'http://www.sikao300.com/', 0, 0, 0, 3039, 0, 1, 0, NULL, 37, '', ''),
(2364, '1289542039', '中国司法考试网', 'http://www.sikao.com.cn/', 0, 0, 0, 3039, 0, 1, 0, NULL, 38, '', ''),
(2365, '1289542039', '搜狐-司法考试', 'http://learning.sohu.com/s2005/sifakaoshi.shtml', 0, 0, 0, 3039, 0, 1, 0, NULL, 39, '', ''),
(2366, '1289541972', '全国卫生专业技术资格', 'http://www.21wecan.com.cn/', 0, 0, 0, 3040, 0, 1, 0, NULL, 1, '', ''),
(2367, '1289541972', '翻译专业资格考试', 'http://www.catti.net.cn/', 0, 0, 0, 3040, 0, 1, 0, NULL, 2, '', ''),
(2368, '1289541972', '剑桥少儿英语', 'http://www.sbc-neea.com.cn/', 0, 0, 0, 3040, 0, 1, 0, NULL, 3, '', ''),
(2369, '1289541972', '中国营销专业资格', 'http://www.pemt.org/', 0, 0, 0, 3040, 0, 1, 0, NULL, 4, '', ''),
(2370, '1289541972', '全国计算机等级考试', 'http://www.ncre.cn/', 0, 0, 0, 3040, 0, 1, 0, NULL, 5, '', ''),
(2371, '1289541972', '全国电子信息应用教育中心', 'http://www.ceiaec.org/', 0, 0, 0, 3040, 0, 1, 0, NULL, 6, '', ''),
(2372, '1289541972', '新浪-计算机考试', 'http://edu.sina.com.cn/exam/pc/index.shtml', 0, 0, 0, 3040, 0, 1, 0, NULL, 7, '', ''),
(2373, '1289541972', '职称考评资讯', 'http://www.zckp.com/', 0, 0, 0, 3040, 0, 1, 0, NULL, 8, '', ''),
(2374, '1289541972', '中国会计视野', 'http://www.esnai.com/', 0, 0, 0, 3040, 0, 1, 0, NULL, 9, '', ''),
(2375, '1289541972', '国家医学考试网', 'http://www.nmec.org.cn/', 0, 0, 0, 3040, 0, 1, 0, NULL, 10, '', ''),
(2376, '1289541972', '金融专业英语证书考试', 'http://www.pbcedu.net/jryy/index.php', 0, 0, 0, 3040, 0, 1, 0, NULL, 11, '', ''),
(2377, '1289541972', '财考网', 'http://www.ck100.com/', 0, 0, 0, 3040, 0, 1, 0, NULL, 12, '', ''),
(2378, '1289541972', '医考通', 'http://2008.ikoton.com/', 0, 0, 0, 3040, 0, 1, 0, NULL, 13, '', ''),
(2379, '1289784530', '首都之窗', 'http://www.beijing.gov.cn/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 1, '', ''),
(2380, '1289784530', '新华网北京', 'http://www.bj.xinhuanet.com/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 2, '', ''),
(2381, '1289784530', '千龙网', 'http://www.qianlong.com/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 3, '', ''),
(2382, '1289784530', '京报网', 'http://www.bjnews.com.cn/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 4, '', ''),
(2383, '1289784530', '北京公交网', 'http://www.bjbus.com/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 5, '', ''),
(2384, '1289784530', '京华网', 'http://www.jinghua.cn/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 6, '', ''),
(2385, '1289784530', '北青网', 'http://www.ynet.com/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 7, '', ''),
(2386, '1289784530', '光明网', 'http://www.gmw.cn/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 8, '', ''),
(2387, '1289784530', 'BTV在线', 'http://www.btv.com.cn/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 9, '', ''),
(2388, '1289784530', '中国网络电视台', 'http://www.cntv.cn/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 10, '', ''),
(2389, '1289784530', '北京口碑网', 'http://beijing.koubei.com/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 11, '', ''),
(2390, '1289784530', '北京晨报', 'http://www.morningpost.com.cn/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 12, '', ''),
(2391, '1289784530', '北京网', 'http://www.beijing.cn/', 0, 0, 0, 4011, 0, 1, 1289799213, NULL, 13, '', ''),
(2392, '1289784530', '电信网上营业厅', 'http://bj.ct10000.com/', 0, 0, 0, 4013, 0, 1, 1289799213, NULL, 14, '', ''),
(2393, '1289784530', '联通网上营业厅', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=000100010001&amp;id=1001', 0, 0, 0, 4013, 0, 1, 1289799213, NULL, 15, '', ''),
(2394, '1289784530', '移动网上营业厅', 'http://www.bj.10086.cn/', 0, 0, 0, 4013, 0, 1, 1289799213, NULL, 16, '', ''),
(8223, '1290230924', '北京天气预报', 'http://www.weather.com.cn/html/weather/101010100.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 1, '', ''),
(2396, '1289784530', '915手机网', 'http://www.915.com/', 0, 0, 0, 4013, 0, 1, 1289799213, NULL, 18, '', ''),
(2397, '1289785272', '首都之窗', 'http://www.beijing.gov.cn/', 0, 0, 0, 4012, 0, 1, 0, NULL, 1, '', ''),
(2398, '1289785272', '千龙网', 'http://www.qianlong.com/', 0, 0, 0, 4012, 0, 1, 0, NULL, 2, '', ''),
(2399, '1289785272', '北京晨报', 'http://www.morningpost.com.cn/', 0, 0, 0, 4012, 0, 1, 0, NULL, 3, '', ''),
(2400, '1289785272', '新京报', 'http://www.bjnews.com.cn/', 0, 0, 0, 4012, 0, 1, 1292223130, NULL, 4, '', ''),
(2401, '1289785272', '北青网', 'http://www.ynet.com/', 0, 0, 0, 4012, 0, 1, 0, NULL, 5, '', ''),
(2402, '1289785272', '京华时报', 'http://www.jinghua.cn/', 0, 0, 0, 4012, 0, 1, 0, NULL, 6, '', ''),
(2403, '1289785272', '光明网', 'http://www.gmw.cn/', 0, 0, 0, 4012, 0, 1, 0, NULL, 7, '', ''),
(2404, '1289785363', '北京住房公积金网', 'http://www.bjgjj.gov.cn/', 0, 0, 0, 4013, 0, 1, 0, NULL, 1, '', ''),
(2405, '1289785363', '中国票务在线', 'http://www.piao.com.cn/', 0, 0, 0, 4013, 0, 1, 0, NULL, 2, '', ''),
(2406, '1289785363', '万达影城', 'http://www.wandafilm.com/', 0, 0, 0, 4013, 0, 1, 0, NULL, 3, '', ''),
(2407, '1289785363', '赶集网', 'http://bj.ganji.com/', 0, 0, 0, 4013, 0, 1, 0, NULL, 4, '', ''),
(2408, '1289785363', '55BBS社区', 'http://bbs.55bbs.com/', 0, 0, 0, 4013, 0, 1, 0, NULL, 5, '', ''),
(2409, '1289785363', '北京贴吧', 'http://tieba.baidu.com/f?kw=%B1%B1%BE%A9', 0, 0, 0, 4013, 0, 1, 0, NULL, 6, '', ''),
(2410, '1289785363', '北京宽带网', 'http://www.bbn.com.cn/', 0, 0, 0, 4013, 0, 1, 0, NULL, 7, '', ''),
(2411, '1289785363', '焦点房产－北京', 'http://house.focus.cn/', 0, 0, 0, 4013, 0, 1, 0, NULL, 8, '', ''),
(2412, '1289785363', '新浪房产北京', 'http://bj.house.sina.com.cn', 0, 0, 0, 4013, 0, 1, 0, NULL, 9, '', ''),
(2413, '1289785363', '首都之窗旅游', 'http://www.beijing.gov.cn/ggfw/lyz/default.htm', 0, 0, 0, 4013, 0, 1, 0, NULL, 10, '', ''),
(2414, '1289785363', '北京协和医院', 'http://www.pumch.ac.cn/', 0, 0, 0, 4013, 0, 1, 0, NULL, 11, '', ''),
(2415, '1289785363', '北京同仁医院', 'http://www.trhos.com/', 0, 0, 0, 4013, 0, 1, 0, NULL, 12, '', ''),
(2416, '1289785363', '武警总医院', 'http://www.wj-hospital.com/', 0, 0, 0, 4013, 0, 1, 0, NULL, 13, '', ''),
(2417, '1289785363', '北京大学', 'http://www.pku.edu.cn/', 0, 0, 0, 4013, 0, 1, 0, NULL, 14, '', ''),
(2418, '1289785363', '清华大学', 'http://www.tsinghua.edu.cn/', 0, 0, 0, 4013, 0, 1, 0, NULL, 15, '', ''),
(2419, '1289785363', '首都图书馆', 'http://www.clcn.net.cn/', 0, 0, 0, 4013, 0, 1, 0, NULL, 16, '', ''),
(2420, '1289785363', '新东方教育', 'http://www.neworiental.org/', 0, 0, 0, 4013, 0, 1, 0, NULL, 17, '', ''),
(2421, '1289785363', '北京市人事考试网', 'http://www.bjpta.gov.cn/', 0, 0, 0, 4013, 0, 1, 0, NULL, 18, '', ''),
(2422, '1289785363', '北京酒吧夜时尚', 'http://www.clubzone.cn/', 0, 0, 0, 4013, 0, 1, 0, NULL, 19, '', ''),
(2423, '1289785363', '北京人才网', 'http://www.bjrc.com/', 0, 0, 0, 4013, 0, 1, 0, NULL, 20, '', ''),
(2424, '1289785363', '北京便民号码', 'http://app.beijing.gov.cn/phone/', 0, 0, 0, 4013, 0, 1, 0, NULL, 21, '', ''),
(2425, '1289785422', '北京人事考试网', 'http://www.bjpta.gov.cn/', 0, 0, 0, 4014, 0, 1, 0, NULL, 1, '', ''),
(2426, '1289785422', '北京会计网', 'http://www.kuaiji.com.cn/', 0, 0, 0, 4014, 0, 1, 0, NULL, 2, '', ''),
(2427, '1289785422', '北京新东方', 'http://beijing.neworiental.org/', 0, 0, 0, 4014, 0, 1, 0, NULL, 3, '', ''),
(2428, '1289785422', '2010北京公务员考试成绩查询', 'http://www.bjpta.gov.cn/wscf/2010/bjgwy20102.asp', 0, 0, 0, 4014, 0, 1, 0, NULL, 4, '', ''),
(2429, '1289785499', '北京贴吧', 'http://tieba.baidu.com/f?kw=%B1%B1%BE%A9', 0, 0, 0, 4015, 0, 1, 0, NULL, 1, '', ''),
(2430, '1289785499', '京华论坛', 'http://bbs.qianlong.com/', 0, 0, 0, 4015, 0, 1, 0, NULL, 2, '', ''),
(2431, '1289785499', '望京网论坛', 'http://bbs.wangjing.cn/', 0, 0, 0, 4015, 0, 1, 0, NULL, 3, '', ''),
(2432, '1289785499', '望京社区', 'http://www.wjsq.com/', 0, 0, 0, 4015, 0, 1, 0, NULL, 4, '', ''),
(2433, '1289785499', '回龙观社区网', 'http://www.hlgnet.com/', 0, 0, 0, 4015, 0, 1, 0, NULL, 5, '', ''),
(2434, '1289785499', '八通网', 'http://www.bato.cn/', 0, 0, 0, 4015, 0, 1, 0, NULL, 6, '', ''),
(2435, '1289785499', '亦庄生活', 'http://www.yizlife.com/', 0, 0, 0, 4015, 0, 1, 0, NULL, 7, '', ''),
(2436, '1289785499', '爱我大兴社区', 'http://bbs.25dx.com/', 0, 0, 0, 4015, 0, 1, 0, NULL, 8, '', ''),
(2437, '1289785499', '天通苑社区网', 'http://www.tty520.com/', 0, 0, 0, 4015, 0, 1, 0, NULL, 9, '', ''),
(2438, '1289785499', '网聚房山', 'http://www.haofs.com/', 0, 0, 0, 4015, 0, 1, 0, NULL, 10, '', ''),
(2439, '1289785499', '北京热门论坛', 'http://tieba.baidu.com/f?kw=%B1%B1%BE%A9%C2%DB%CC%B3', 0, 0, 0, 4015, 0, 1, 0, NULL, 11, '', ''),
(2440, '1289785499', '京东热线', 'http://www.yanjiao.com.cn/', 0, 0, 0, 4015, 0, 1, 0, NULL, 12, '', ''),
(2441, '1289785499', '北京福彩论坛', 'http://bbs.bwlc.net/', 0, 0, 0, 4015, 0, 1, 0, NULL, 13, '', ''),
(2442, '1289785499', '燕郊网城', 'http://www.yanjiao.com/', 0, 0, 0, 4015, 0, 1, 0, NULL, 14, '', ''),
(2443, '1289785499', '绿野户外', 'http://www.lvye.info/', 0, 0, 0, 4015, 0, 1, 0, NULL, 15, '', ''),
(2444, '1289785624', '北京市政府', 'http://www.beijing.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 1, '', ''),
(2445, '1289785624', '北京市公安局', 'http://www.bjgaj.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 2, '', ''),
(2446, '1289785624', '北京市工商局', 'http://www.hd315.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 3, '', ''),
(2447, '1289785624', '北京市财政局', 'http://www.bjcz.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 4, '', ''),
(2448, '1289785624', '北京交通管理局', 'http://www.bjjtgl.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 5, '', ''),
(2449, '1289785624', '北京市发改委', 'http://www.bjpc.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 6, '', ''),
(2450, '1289785624', '北京法院网', 'http://bjgy.chinacourt.org/', 0, 0, 0, 4016, 0, 1, 0, NULL, 7, '', ''),
(2451, '1289785624', '北京市卫生局', 'http://www.bjhb.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 8, '', ''),
(2452, '1289785624', '北京市地方税务局', 'http://www.tax861.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 9, '', ''),
(2453, '1289785624', '北京国税', 'http://www.bjsat.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 10, '', ''),
(2454, '1289785624', '北京市建设委员会', 'http://www.bjjs.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 11, '', ''),
(2455, '1289785624', '北京市民政局', 'http://www.bjmzj.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 12, '', ''),
(2456, '1289785624', '北京市统计局', 'http://www.bjstats.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 13, '', ''),
(2457, '1289785624', '北京市教委会', 'http://www.bjedu.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 14, '', ''),
(2458, '1289785624', '北京人力资源', 'http://www.bjld.gov.cn/', 0, 0, 0, 4016, 0, 1, 0, NULL, 15, '', ''),
(2459, '1289785794', '天津热线', 'http://www.online.tj.cn', 0, 0, 0, 4021, 0, 1, 0, NULL, 1, '', ''),
(2460, '1289785794', '天津日报', 'http://www.tianjindaily.com.cn', 0, 0, 0, 4021, 0, 1, 0, NULL, 2, '', ''),
(2461, '1289785794', '天津之窗', 'http://www.tianjin.gov.cn', 0, 0, 0, 4021, 0, 1, 0, NULL, 3, '', ''),
(2462, '1289785794', '北方网', 'http://www.enorth.com.cn', 0, 0, 0, 4021, 0, 1, 0, NULL, 4, '', ''),
(2463, '1289785794', '今晚报', 'http://www.jwb.com.cn', 0, 0, 0, 4021, 0, 1, 0, NULL, 5, '', ''),
(2464, '1289785794', '天津电视台', 'http://www.tjtv.com.cn', 0, 0, 0, 4021, 0, 1, 0, NULL, 6, '', ''),
(2465, '1289785794', '天津天气预报', 'http://weather.tq121.com.cn/detail.php?city=%CC%EC%BD%F2', 0, 0, 0, 4021, 0, 1, 0, NULL, 7, '', ''),
(2466, '1289785794', '天津公交网', 'http://www.tjbus.com', 0, 0, 0, 4021, 0, 1, 0, NULL, 8, '', ''),
(2467, '1289785794', '天津福利彩票', 'http://www.fulicaipiao.cn/tianjin', 0, 0, 0, 4021, 0, 1, 0, NULL, 9, '', ''),
(2468, '1289785794', '天津体育彩票', 'http://tiyucaipiao.net/tianjin', 0, 0, 0, 4021, 0, 1, 0, NULL, 10, '', ''),
(8222, '1289887264', '广告联盟', 'http://www.ete.cn/', 0, 0, 0, 3015, 0, 1, 1289887264, NULL, 17, '', ''),
(2470, '1289785941', '北方网', 'http://www.enorth.com.cn/', 0, 0, 0, 4022, 0, 1, 0, NULL, 1, '', ''),
(2471, '1289785941', '天津网', 'http://www.tianjinwe.com/', 0, 0, 0, 4022, 0, 1, 0, NULL, 2, '', ''),
(2472, '1289785941', '天津热线', 'http://www.online.tj.cn/', 0, 0, 0, 4022, 0, 1, 0, NULL, 3, '', ''),
(2473, '1289785941', '天津视窗', 'http://www.022net.com/', 0, 0, 0, 4022, 0, 1, 0, NULL, 4, '', ''),
(2474, '1289785941', '天津电视台', 'http://www.tjtv.com.cn/', 0, 0, 0, 4022, 0, 1, 0, NULL, 5, '', ''),
(2475, '1289785941', '今晚报', 'http://www.jwb.com.cn/', 0, 0, 0, 4022, 0, 1, 0, NULL, 6, '', ''),
(2476, '1289785941', '天津广播网', 'http://www.radiotj.com/', 0, 0, 0, 4022, 0, 1, 0, NULL, 7, '', ''),
(2477, '1289785941', '塘沽在线', 'http://www.tanggu.net.cn/', 0, 0, 0, 4022, 0, 1, 0, NULL, 8, '', ''),
(2478, '1279617741', '教育部', 'http://www.moe.edu.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 1, '', ''),
(2479, '1279617741', '中国教育在线', 'http://www.eol.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 2, '', ''),
(2480, '1279617741', '人民教育出版社', 'http://www.pep.com.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 3, '', ''),
(2481, '1279617741', '中小学教师继续教育网', 'http://www.teacher.com.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 4, '', ''),
(2482, '1279617741', '中国教育报', 'http://www.jyb.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 5, '', ''),
(2483, '1279617741', '中国教师资格网', 'http://www.jszg.edu.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 6, '', ''),
(2484, '1279617741', '教师招聘网', 'http://www.jiaoshizhaopin.net/', 0, 0, 0, 3041, 0, 1, 0, NULL, 7, '', ''),
(2485, '1279617741', '中国教师报', 'http://www.chinateacher.com.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 8, '', ''),
(2486, '1279617741', '中国教育考试网', 'http://www.neea.edu.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 9, '', ''),
(2487, '1279617741', '高等教育学生信息网', 'http://www.chsi.com.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 10, '', ''),
(2488, '1279617741', '搜狐教育', 'http://learning.sohu.com/', 0, 0, 0, 3041, 0, 1, 0, NULL, 11, '', ''),
(2489, '1279617741', '腾讯教育频道', 'http://edu.qq.com/', 0, 0, 0, 3041, 0, 1, 0, NULL, 12, '', ''),
(2490, '1279617741', '中国留学网', 'http://www.cscse.edu.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 13, '', ''),
(2491, '1279617741', 'K12教育网', 'http://www.k12.com.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 14, '', ''),
(2492, '1279617741', '新浪教育', 'http://edu.sina.com.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 15, '', ''),
(2493, '1279617741', '中国教师研修网', 'http://www.teacherclub.com.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 16, '', ''),
(2494, '1279617741', '中国教师行动网', 'http://www.eact.com.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 17, '', ''),
(2495, '1279617741', '中国教育信息网', 'http://www.chinaedu.edu.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 18, '', ''),
(2496, '1279617741', '搜学网', 'http://www.sooxue.com/', 0, 0, 0, 3041, 0, 1, 0, NULL, 19, '', ''),
(2497, '1279617741', '人教论坛', 'http://bbs.pep.com.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 20, '', ''),
(2498, '1279617741', 'e度教育社区', 'http://bbs.eduu.com/', 0, 0, 0, 3041, 0, 1, 0, NULL, 21, '', ''),
(2499, '1279617741', '新思考网', 'http://www.cersp.com/', 0, 0, 0, 3041, 0, 1, 0, NULL, 22, '', ''),
(2500, '1279617741', '人教学习网', 'http://www.gopep.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 23, '', ''),
(2501, '1279617741', '中国教育统计网', 'http://www.stats.edu.cn/', 0, 0, 0, 3041, 0, 1, 0, NULL, 24, '', ''),
(2502, '1279617741', '校信通', 'http://www.ha.xxt.net.cn/index.html', 0, 0, 0, 3041, 0, 1, 0, NULL, 25, '', ''),
(2503, '1279617741', '中学学科网', 'http://www.zxxk.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 1, '', ''),
(2504, '1279617741', '初中数学网', 'http://www.czsx.com.cn/', 0, 0, 0, 3042, 0, 1, 0, NULL, 2, '', ''),
(2505, '1279617741', '数学中国', 'http://www.mathschina.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 3, '', ''),
(2506, '1279617741', '12999数学网', 'http://www.12999.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 4, '', ''),
(2507, '1279617741', '奥数网', 'http://aoshu.eduu.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 5, '', ''),
(2508, '1279617741', '凤凰语文网', 'http://www.xxyw.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 6, '', ''),
(2509, '1279617741', '老百晓语文', 'http://www.lbx777.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 7, '', ''),
(2510, '1279617741', '无忧无虑中学语文网', 'http://www.5156edu.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 8, '', ''),
(2511, '1279617741', '中学语文教学资源网', 'http://www.ruiwen.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 9, '', ''),
(2512, '1279617741', '中华语文网', 'http://www.zhyww.cn/', 0, 0, 0, 3042, 0, 1, 0, NULL, 10, '', ''),
(2513, '1279617741', '小学生优秀作文网', 'http://www.xiaoxue123.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 11, '', ''),
(2514, '1279617741', '中小学生作文网', 'http://zuowen.eduu.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 12, '', ''),
(2515, '1279617741', '小荷作文网', 'http://www.zww.cn/', 0, 0, 0, 3042, 0, 1, 0, NULL, 13, '', ''),
(2516, '1279617741', '中学历史教学园地', 'http://www.zxls.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 14, '', ''),
(2517, '1279617741', '初中物理在线', 'http://www.czwlzx.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 15, '', ''),
(2518, '1279617741', '新课标第一网', 'http://www.xkb1.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 16, '', ''),
(2519, '1279617741', '诺亚舟', 'http://www.noahedu.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 17, '', ''),
(2520, '1279617741', '文言文翻译', 'http://ewenyan.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 18, '', ''),
(2521, '1279617741', '中华教育资源网', 'http://www.cn910.net/', 0, 0, 0, 3042, 0, 1, 0, NULL, 19, '', ''),
(2522, '1279617741', '第二教育网', 'http://www.dearedu.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 20, '', ''),
(2523, '1279617741', '新华字典', 'http://xh.5156edu.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 21, '', ''),
(2524, '1279617741', '在线成语词典', 'http://cy.5156edu.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 22, '', ''),
(2525, '1279617741', '金山打字', 'http://typeeasy.kingsoft.com/', 0, 0, 0, 3042, 0, 1, 0, NULL, 23, '', ''),
(2526, '1279617741', 'Excel技术社区', 'http://club.excelhome.net/', 0, 0, 0, 3043, 0, 1, 0, NULL, 1, '', ''),
(2527, '1279617741', '好课件吧', 'http://www.goodkejian.com/', 0, 0, 0, 3043, 0, 1, 0, NULL, 2, '', ''),
(2528, '1279617741', '共享资料', 'http://ishare.iask.sina.com.cn/', 0, 0, 0, 3043, 0, 1, 0, NULL, 3, '', ''),
(2529, '1279617741', '文秘114', 'http://www.wenmi114.com/', 0, 0, 0, 3043, 0, 1, 0, NULL, 4, '', ''),
(2530, '1279617741', '第一范文网', 'http://www.diyifanwen.com/', 0, 0, 0, 3043, 0, 1, 0, NULL, 5, '', ''),
(2531, '1279617741', '第一课件网', 'http://www.1kejian.com/', 0, 0, 0, 3043, 0, 1, 0, NULL, 6, '', ''),
(2532, '1279617741', '中国课件站', 'http://www.cnkjz.com/', 0, 0, 0, 3043, 0, 1, 0, NULL, 7, '', ''),
(2533, '1279617741', '21世纪教育资源网', 'http://www.21cnjy.com/', 0, 0, 0, 3043, 0, 1, 0, NULL, 8, '', ''),
(2534, '1279617741', '3edu教育资源', 'http://www.3edu.net/', 0, 0, 0, 3043, 0, 1, 0, NULL, 9, '', ''),
(2535, '1279617741', 'google学术搜索', 'http://scholar.google.com.hk/', 0, 0, 0, 3043, 0, 1, 0, NULL, 10, '', ''),
(2536, '1279617741', 'google学术', 'http://scholar.google.com/', 0, 0, 0, 3043, 0, 1, 0, NULL, 11, '', ''),
(2537, '1279617741', '新东方学校', 'http://www.neworiental.org/', 0, 0, 0, 3044, 0, 1, 0, NULL, 1, '', ''),
(2538, '1279617741', '中华会计网校', 'http://www.chinaacc.com/', 0, 0, 0, 3044, 0, 1, 0, NULL, 2, '', ''),
(2539, '1279617741', '101远程教育网', 'http://www.chinaedu.com/', 0, 0, 0, 3044, 0, 1, 0, NULL, 3, '', ''),
(2540, '1279617741', '北京四中网校', 'http://www.etiantian.com/', 0, 0, 0, 3044, 0, 1, 0, NULL, 4, '', ''),
(2541, '1279617741', '新世界日语', 'http://www.neworldjp.com/', 0, 0, 0, 3044, 0, 1, 0, NULL, 5, '', ''),
(2542, '1279617741', '长江商学院', 'http://www.ckgsb.com/', 0, 0, 0, 3044, 0, 1, 0, NULL, 6, '', ''),
(2543, '1279617741', '海天考研', 'http://www.bjhaitian.com/', 0, 0, 0, 3044, 0, 1, 0, NULL, 7, '', ''),
(2544, '1279617741', '黄冈中学网校', 'http://www.huanggao.net/', 0, 0, 0, 3044, 0, 1, 0, NULL, 8, '', ''),
(2545, '1279617741', '环球职业教育在线', 'http://www.edu24ol.com/', 0, 0, 0, 3044, 0, 1, 0, NULL, 9, '', ''),
(2546, '1279617741', '新航道英语', 'http://www.newchannel.org/', 0, 0, 0, 3044, 0, 1, 0, NULL, 10, '', ''),
(2547, '1279617741', '北大网络教育', 'http://www.pkudl.cn/', 0, 0, 0, 3044, 0, 1, 0, NULL, 11, '', ''),
(2548, '1279617741', '网上人大', 'http://www.cmr.com.cn/', 0, 0, 0, 3044, 0, 1, 0, NULL, 12, '', ''),
(2549, '1279617741', '洪恩在线', 'http://home.hongen.com/', 0, 0, 0, 3044, 0, 1, 0, NULL, 13, '', ''),
(2550, '1279617741', '万国司考培训', 'http://www.wanguoschool.net/', 0, 0, 0, 3044, 0, 1, 0, NULL, 14, '', ''),
(2551, '1279617741', '华尔街英语', 'http://www.wselearning.com/', 0, 0, 0, 3044, 0, 1, 0, NULL, 15, '', ''),
(2552, '1289786076', '天津福彩', 'http://www.tjflcpw.com', 0, 0, 0, 4023, 0, 1, 0, NULL, 1, '', ''),
(2553, '1289786076', '天津体彩', 'http://www.tjlottery.gov.cn/', 0, 0, 0, 4023, 0, 1, 0, NULL, 2, '', ''),
(2554, '1289786076', '天津移动', 'http://www.tj.10086.cn/', 0, 0, 0, 4023, 0, 1, 0, NULL, 3, '', ''),
(2555, '1289786076', '天津联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=000100030001&amp;amp;id=1042', 0, 0, 0, 4023, 0, 1, 0, NULL, 4, '', ''),
(2556, '1289786076', '天津电信', 'http://tj.ct10000.com/', 0, 0, 0, 4023, 0, 1, 0, NULL, 5, '', ''),
(2557, '1289786076', '天津医院大全', 'http://tianjin.haodf.com/', 0, 0, 0, 4023, 0, 1, 0, NULL, 6, '', ''),
(2558, '1289786076', '天津二手网', 'http://www.tj2shou.com/', 0, 0, 0, 4023, 0, 1, 0, NULL, 7, '', ''),
(2559, '1289786148', '阳光高考', 'http://gaokao.chsi.com.cn/z/2010gxmd/', 0, 0, 0, 4024, 0, 1, 0, NULL, 1, '', ''),
(2560, '1289786148', '南开大学', 'http://www.nankai.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 2, '', ''),
(2561, '1289786148', '天津大学', 'http://www.tju.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 3, '', ''),
(2562, '1289786148', '中国民航大学', 'http://www.cauc.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 4, '', ''),
(2563, '1289786148', '天津工业大学', 'http://www.tjpu.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 5, '', ''),
(2564, '1289786148', '天津科技大学', 'http://www.tust.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 6, '', ''),
(2565, '1289786148', '天津理工大学', 'http://www.tjut.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 7, '', ''),
(2566, '1289786148', '天津医科大学', 'http://www.tijmu.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 8, '', ''),
(2567, '1289786148', '天津中医药大学', 'http://www.tjutcm.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 9, '', ''),
(2568, '1289786148', '天津师范大学', 'http://www.tjnu.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 10, '', ''),
(2569, '1289786148', '天津职业技术师范大学', 'http://www.tute.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 11, '', ''),
(2570, '1289786148', '天津外国语大学', 'http://www.tjfsu.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 12, '', ''),
(2571, '1289786148', '天津财经大学', 'http://www.tjufe.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 13, '', ''),
(2572, '1289786148', '天津商业大学', 'http://www.tjcu.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 14, '', ''),
(2573, '1289786148', '天津天狮学院', 'http://www.tianshi.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 15, '', ''),
(2574, '1289786148', '天津城市建设学院', 'http://www.tjuci.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 16, '', ''),
(2575, '1289786148', '天津农学院', 'http://www.tjac.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 17, '', ''),
(2576, '1289786148', '天津体育学院', 'http://www.tjipe.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 18, '', ''),
(2577, '1289786148', '天津音乐学院', 'http://www.tjcm.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 19, '', ''),
(2578, '1289786148', '天津美术学院', 'http://www.tjarts.edu.cn/', 0, 0, 0, 4024, 0, 1, 0, NULL, 20, '', ''),
(2579, '1289786185', '天津贴吧', 'http://tieba.baidu.com/f?kw=%CC%EC%BD%F2', 0, 0, 0, 4025, 0, 1, 0, NULL, 1, '', ''),
(2580, '1289786185', '天涯天津', 'http://www.tianya.cn/city/tj/index.shtml', 0, 0, 0, 4025, 0, 1, 0, NULL, 2, '', ''),
(2581, '1289786185', '天津论坛', 'http://bbs.kutj.com/', 0, 0, 0, 4025, 0, 1, 0, NULL, 3, '', ''),
(2582, '1289786185', '百丽吧时尚社区', 'http://www.belle8.com/', 0, 0, 0, 4025, 0, 1, 0, NULL, 4, '', ''),
(2583, '1289786185', '趣拜网', 'http://www.qvbuy.com/', 0, 0, 0, 4025, 0, 1, 0, NULL, 5, '', ''),
(2584, '1289786185', '渤海论坛', 'http://www.bohaibbs.org/', 0, 0, 0, 4025, 0, 1, 0, NULL, 6, '', ''),
(2585, '1289786185', '新宝坻论坛', 'http://bbs.xbaodi.com/', 0, 0, 0, 4025, 0, 1, 0, NULL, 7, '', ''),
(2586, '1289786272', '市教委', 'http://www.tjmec.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 1, '', ''),
(2587, '1289786272', '发改委', 'http://www.tjdpc.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 2, '', ''),
(2588, '1289786272', '规划局', 'http://www.cityplan.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 3, '', ''),
(2589, '1289786272', '旅游局', 'http://www.tjtour.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 4, '', ''),
(2590, '1289786272', '国税局', 'http://www.tjsat.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 5, '', ''),
(2591, '1289786272', '司法局', 'http://www.tjsf.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 6, '', ''),
(2592, '1289786272', '建设交通委', 'http://www.tjcac.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 7, '', ''),
(2593, '1289786272', '卫生局', 'http://www.tjwsj.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 8, '', ''),
(2594, '1289786272', '食品药品监管局', 'http://www.tda.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 9, '', ''),
(2595, '1289786272', '质监局', 'http://www.tjjj.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 10, '', ''),
(2596, '1289786272', '出版局', 'http://www.tjppb.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 11, '', ''),
(2597, '1289786272', '统计局', 'http://www.stats-tj.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 12, '', ''),
(2598, '1289786272', '市政公路局', 'http://www.tjsz.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 13, '', ''),
(2599, '1289786272', '交通港口局', 'http://www.tjjt.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 14, '', ''),
(2600, '1289786272', '天津公选网', 'http://www.tjgxw.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 15, '', ''),
(2601, '1289786272', '滨海新区', 'http://www.bh.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 16, '', ''),
(2602, '1289786272', '和平区', 'http://www.tjhp.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 17, '', ''),
(2603, '1289786272', '河北区', 'http://www.tjhbq.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 18, '', ''),
(2604, '1289786272', '河西区', 'http://www.tjhexi.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 19, '', ''),
(2605, '1289786272', '河东区', 'http://www.tjhd.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 20, '', ''),
(2606, '1289786272', '南开区', 'http://www.tjnk.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 21, '', ''),
(2607, '1289786272', '红桥区', 'http://www.tjhqqzf.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 22, '', ''),
(2608, '1289786272', '东丽区', 'http://www.dlnet.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 23, '', ''),
(2609, '1289786272', '西青区', 'http://www.xq.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 24, '', ''),
(2610, '1289786272', '津南区', 'http://www.tjjn.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 25, '', ''),
(2611, '1289786272', '北辰区', 'http://www.tjbc.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 26, '', ''),
(2612, '1289786272', '武清区', 'http://www.tjwq.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 27, '', ''),
(2613, '1289786272', '宝坻区', 'http://www.baodi.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 28, '', ''),
(2614, '1289786272', '蓟县', 'http://www.tjjx.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 29, '', ''),
(2615, '1289786272', '静海县', 'http://www.tjjh.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 30, '', ''),
(2616, '1289786272', '宁河县', 'http://www.ninghe.gov.cn/', 0, 0, 0, 4026, 0, 1, 0, NULL, 31, '', ''),
(2617, '1289786365', '上海热线', 'http://www.online.sh.cn/', 0, 0, 0, 4031, 0, 1, 0, NULL, 1, '', ''),
(2618, '1289786365', '新民网', 'http://www.xinmin.cn/', 0, 0, 0, 4031, 0, 1, 0, NULL, 2, '', ''),
(2619, '1289786365', '东方网', 'http://www.eastday.com/', 0, 0, 0, 4031, 0, 1, 0, NULL, 3, '', ''),
(2620, '1289786365', '篱笆网', 'http://www.liba.com/', 0, 0, 0, 4031, 0, 1, 0, NULL, 4, '', ''),
(2621, '1289786365', '文汇报', 'http://whb.news365.com.cn/', 0, 0, 0, 4031, 0, 1, 0, NULL, 5, '', ''),
(2622, '1289786365', '上海市政府', 'http://www.shanghai.gov.cn/', 0, 0, 0, 4031, 0, 1, 0, NULL, 6, '', ''),
(2623, '1289786365', '东方财富', 'http://www.eastmoney.com/', 0, 0, 0, 4031, 0, 1, 0, NULL, 7, '', ''),
(2624, '1289786365', '上海世博会', 'http://www.expo2010.cn/', 0, 0, 0, 4031, 0, 1, 0, NULL, 8, '', ''),
(2625, '1289786365', '上海东方电视台', 'http://www.dragontv.cn/', 0, 0, 0, 4031, 0, 1, 0, NULL, 9, '', ''),
(2626, '1289786365', '上海广播电视台', 'http://www.smg.cn/', 0, 0, 0, 4031, 0, 1, 0, NULL, 10, '', ''),
(2627, '1289786365', '上海口碑网', 'http://shanghai.koubei.com/', 0, 0, 0, 4031, 0, 1, 0, NULL, 11, '', ''),
(2628, '1289786365', '东方早报', 'http://www.dfdaily.com/', 0, 0, 0, 4031, 0, 1, 0, NULL, 12, '', ''),
(2629, '1289786365', '上海移动', 'http://www.sh.10086.cn/', 0, 0, 0, 4031, 0, 1, 0, NULL, 13, '', ''),
(2630, '1289786365', '上海电信', 'http://sh.ct10000.com/', 0, 0, 0, 4031, 0, 1, 0, NULL, 14, '', ''),
(2631, '1289786365', '上海联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=000100020001&amp;amp;id=1021', 0, 0, 0, 4031, 0, 1, 0, NULL, 15, '', ''),
(2633, '1289786365', '915手机网', 'http://www.915.com/', 0, 0, 0, 4031, 0, 1, 0, NULL, 17, '', ''),
(2634, '1289786399', '上海热线', 'http://www.online.sh.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 1, '', ''),
(2635, '1289786399', '中国上海', 'http://www.shanghai.gov.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 2, '', ''),
(2636, '1289786399', '东方网', 'http://www.eastday.com/', 0, 0, 0, 4032, 0, 1, 0, NULL, 3, '', ''),
(2637, '1289786399', '新浪上海频道', 'http://sh.sina.com.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 4, '', ''),
(2638, '1289786399', '搜狐上海频道', 'http://sh.sohu.com/', 0, 0, 0, 4032, 0, 1, 0, NULL, 5, '', ''),
(2639, '1289786399', '新华网上海频道', 'http://www.sh.xinhua.org/', 0, 0, 0, 4032, 0, 1, 0, NULL, 6, '', ''),
(2640, '1289786399', '东方早报', 'http://www.dfdaily.com/', 0, 0, 0, 4032, 0, 1, 0, NULL, 7, '', ''),
(2641, '1289786399', '新民晚报', 'http://xmwb.news365.com.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 8, '', ''),
(2642, '1289786399', '上海文广新闻传媒集团', 'http://www.smg.cn', 0, 0, 0, 4032, 0, 1, 0, NULL, 9, '', ''),
(2643, '1289786399', '新民周刊', 'http://xmzk.xinminweekly.com.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 10, '', ''),
(2644, '1289786399', '上海世博官方网站', 'http://www.expo2010china.com/', 0, 0, 0, 4032, 0, 1, 0, NULL, 11, '', ''),
(2645, '1289786399', '新民网', 'http://www.xinmin.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 12, '', ''),
(2646, '1289786399', '文新传媒(文汇报)', 'http://www.news365.com.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 13, '', ''),
(2647, '1289786399', '解放日报', 'http://epaper.jfdaily.com/', 0, 0, 0, 4032, 0, 1, 0, NULL, 14, '', ''),
(2648, '1289786399', '外滩画报', 'http://www.bundpic.com/', 0, 0, 0, 4032, 0, 1, 0, NULL, 15, '', ''),
(2649, '1289786399', '上海日报[英]', 'http://www.shanghaidaily.com/', 0, 0, 0, 4032, 0, 1, 0, NULL, 16, '', ''),
(2650, '1289786399', '上海英文星报', 'http://app1.chinadaily.com.cn/star/index.html', 0, 0, 0, 4032, 0, 1, 0, NULL, 17, '', ''),
(2651, '1289786399', '每日经济新闻', 'http://www.nbd.com.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 18, '', ''),
(2652, '1289786399', '上海证券报', 'http://www.cnstock.com/paper_new/html/node.htm', 0, 0, 0, 4032, 0, 1, 0, NULL, 19, '', ''),
(2653, '1289786399', '东方体育日报', 'http://www.dfsports.com.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 20, '', ''),
(2654, '1289786399', '上海青年报', 'http://www.why.com.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 21, '', ''),
(2655, '1289786399', '上海金融报', 'http://www.shfinancialnews.com/', 0, 0, 0, 4032, 0, 1, 0, NULL, 22, '', ''),
(2656, '1289786399', '上海环境报', 'http://www.envir.gov.cn/index.asp', 0, 0, 0, 4032, 0, 1, 0, NULL, 23, '', ''),
(2657, '1289786399', '上海商报', 'http://www.shbiz.com.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 24, '', ''),
(2658, '1289786399', '新民周刊', 'http://xmzk.xinminweekly.com.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 25, '', ''),
(2659, '1289786399', '东方卫视', 'http://www.dragontv.cn/', 0, 0, 0, 4032, 0, 1, 0, NULL, 26, '', ''),
(2660, '1289786466', '58同城', 'http://sh.58.com/', 0, 0, 0, 4033, 0, 1, 1289803727, NULL, 1, '', ''),
(2661, '1289786466', '搜狐上海频道', 'http://sh.sohu.com/', 0, 0, 0, 4033, 0, 1, 0, NULL, 2, '', ''),
(2662, '1289786466', '新华网上海频道', 'http://www.sh.xinhua.org/', 0, 0, 0, 4033, 0, 1, 0, NULL, 3, '', ''),
(2663, '1289786466', '新浪上海频道', 'http://sh.sina.com.cn/', 0, 0, 0, 4033, 0, 1, 0, NULL, 4, '', ''),
(2664, '1289786466', '新民周刊', 'http://xmzk.xinminweekly.com.cn/', 0, 0, 0, 4033, 0, 1, 0, NULL, 5, '', ''),
(2665, '1289786466', '上海人才热线', 'http://www.shanghairc.com/', 0, 0, 0, 4033, 0, 1, 0, NULL, 6, '', ''),
(2666, '1289786466', '上海人才市场', 'http://www.hr.net.cn/', 0, 0, 0, 4033, 0, 1, 0, NULL, 7, '', ''),
(2667, '1289786466', '上海外服', 'http://www.efesco.com/', 0, 0, 0, 4033, 0, 1, 0, NULL, 8, '', ''),
(2668, '1289786466', '上海职业能力考试院', 'http://www.spta.gov.cn/', 0, 0, 0, 4033, 0, 1, 0, NULL, 9, '', ''),
(2669, '1289786466', '上海房产网', 'http://www.shome.cn/', 0, 0, 0, 4033, 0, 1, 0, NULL, 10, '', ''),
(2670, '1289786466', '上海租房热线', 'http://www.okfang.com/', 0, 0, 0, 4033, 0, 1, 0, NULL, 11, '', ''),
(2671, '1289786466', '上海热线-旅游', 'http://tttrip.online.sh.cn/', 0, 0, 0, 4033, 0, 1, 0, NULL, 12, '', ''),
(2672, '1289786466', '上海旅游网', 'http://www.shanghaitour.net/', 0, 0, 0, 4033, 0, 1, 0, NULL, 13, '', ''),
(2673, '1289786466', '上海打折网', 'http://www.shanghaidz.com/', 0, 0, 0, 4033, 0, 1, 0, NULL, 14, '', ''),
(2674, '1289786466', '携程旅行网上海', 'http://destinations.ctrip.com/Destinations/DistrictIntroduction.asp?district=2', 0, 0, 0, 4033, 0, 1, 0, NULL, 15, '', ''),
(2675, '1289786466', '上海博物馆', 'http://www.shanghaimuseum.net/', 0, 0, 0, 4033, 0, 1, 0, NULL, 16, '', ''),
(2676, '1289786466', '上海热线-美食', 'http://eat.online.sh.cn/', 0, 0, 0, 4033, 0, 1, 0, NULL, 17, '', ''),
(2677, '1289786466', '太平洋百货', 'http://www.pacific-shanghai.com.cn/', 0, 0, 0, 4033, 0, 1, 0, NULL, 18, '', ''),
(2678, '1289786466', '上海市儿童医院', 'http://www.shchildren.com.cn/', 0, 0, 0, 4033, 0, 1, 0, NULL, 19, '', ''),
(2679, '1289786466', '焦点上海房地产网', 'http://sh.soufun.com/', 0, 0, 0, 4033, 0, 1, 0, NULL, 20, '', ''),
(2680, '1289786466', '丫丫亲子-上海站', 'http://sh.iyaya.com/s', 0, 0, 0, 4033, 0, 1, 0, NULL, 21, '', ''),
(2681, '1289786466', '网上世博会', 'http://www.expo.cn/', 0, 0, 0, 4033, 0, 1, 0, NULL, 22, '', ''),
(2682, '1289786466', '上海19楼', 'http://shanghai.19lou.com/', 0, 0, 0, 4033, 0, 1, 0, NULL, 23, '', ''),
(2683, '1289786466', '上海大剧院', 'http://www.shgtheatre.com/', 0, 0, 0, 4033, 0, 1, 0, NULL, 24, '', ''),
(2684, '1289786466', '宽带山KDS论坛', 'http://club.pchome.net/forum_1_15.html', 0, 0, 0, 4033, 0, 1, 0, NULL, 25, '', ''),
(2685, '1289786466', '上海热线互动社区', 'http://bbs.online.sh.cn/forum/index.php', 0, 0, 0, 4033, 0, 1, 0, NULL, 26, '', ''),
(2686, '1289786501', '上海市教委', 'http://www.shmec.gov.cn/', 0, 0, 0, 4034, 0, 1, 0, NULL, 1, '', ''),
(2687, '1289786501', '上海市中小学名单', 'http://www.shmec.gov.cn/web/glxx/map.php', 0, 0, 0, 4034, 0, 1, 0, NULL, 2, '', ''),
(2688, '1289786501', '华东理工大学', 'http://www.ecust.edu.cn/', 0, 0, 0, 4034, 0, 1, 0, NULL, 3, '', ''),
(2689, '1289786501', '上海图书馆', 'http://www.library.sh.cn', 0, 0, 0, 4034, 0, 1, 0, NULL, 4, '', ''),
(2690, '1289786501', '上海教育资源网', 'http://www.sherc.net', 0, 0, 0, 4034, 0, 1, 0, NULL, 5, '', ''),
(2691, '1289786501', '上海招考热线', 'http://www.shmeea.edu.cn', 0, 0, 0, 4034, 0, 1, 0, NULL, 6, '', ''),
(2692, '1289786501', '上海学前教育网', 'http://www.age06.com/', 0, 0, 0, 4034, 0, 1, 0, NULL, 7, '', ''),
(2693, '1289786526', '上海热线论坛', 'http://bbs.online.sh.cn/forum/index.php', 0, 0, 0, 4035, 0, 1, 0, NULL, 1, '', ''),
(2694, '1289786526', '天涯社区上海', 'http://www.tianya.cn/new/TianyaCity/ArticlesList_Culture.asp?idWriter=0&amp;amp;Key=0&amp;amp;idItem=41', 0, 0, 0, 4035, 0, 1, 0, NULL, 2, '', ''),
(2695, '1289786526', 'KDS宽带山', 'http://club.pchome.net/forum_1_15.html', 0, 0, 0, 4035, 0, 1, 0, NULL, 3, '', ''),
(2696, '1289786526', '上海人', 'http://rd.qihoo.com/qd.html?u=http%253A%252F%252Fwww.shanghaining.com%252F&amp;amp;t=1271937049&amp;amp;c=1&amp;amp;a=9&amp;amp;p=6625&amp;amp;s=d420de42f81c2f78e5af49eb46648207', 0, 0, 0, 4035, 0, 1, 0, NULL, 4, '', ''),
(2697, '1289786526', '东方社区', 'http://bbs.eastday.com/', 0, 0, 0, 4035, 0, 1, 0, NULL, 5, '', ''),
(2698, '1289786526', '酷爱上海论坛', 'http://bbs.kooaoo.com/', 0, 0, 0, 4035, 0, 1, 0, NULL, 6, '', ''),
(2699, '1289786526', '福联交友网', 'http://www.fj-sh.com', 0, 0, 0, 4035, 0, 1, 0, NULL, 7, '', ''),
(2700, '1289786545', '上海市公安局', 'http://www.police.sh.cn/', 0, 0, 0, 4036, 0, 1, 0, NULL, 1, '', ''),
(2701, '1289786545', '上海消费者委员会', 'http://www.315.sh.cn/', 0, 0, 0, 4036, 0, 1, 0, NULL, 2, '', ''),
(2702, '1289786545', '上海市工商局', 'http://www.sgs.gov.cn', 0, 0, 0, 4036, 0, 1, 0, NULL, 3, '', ''),
(2703, '1289786545', '上海食品药品监督管理局', 'http://www.shfda.gov.cn', 0, 0, 0, 4036, 0, 1, 0, NULL, 4, '', ''),
(2704, '1289786545', '上海海关', 'http://shanghai.customs.gov.cn/', 0, 0, 0, 4036, 0, 1, 0, NULL, 5, '', ''),
(2705, '1289786545', '上海海事局', 'http://www.shmsa.gov.cn', 0, 0, 0, 4036, 0, 1, 0, NULL, 6, '', ''),
(2706, '1289786545', '上海市财税网', 'http://www.csj.sh.gov.cn', 0, 0, 0, 4036, 0, 1, 0, NULL, 7, '', ''),
(2760, '1289786650', '法律出版社', 'http://www.lawpress.com.cn', 0, 0, 0, 4347, 0, 1, 0, NULL, 12, '', ''),
(2759, '1289786650', '高等教育出版社', 'http://www.hep.edu.cn', 0, 0, 0, 4347, 0, 1, 0, NULL, 11, '', ''),
(2758, '1289786650', '外语教学与研究出版社', 'http://www.fltrp.com/', 0, 0, 0, 4347, 0, 1, 0, NULL, 10, '', ''),
(2757, '1289786650', '外文出版社', 'http://www.flp.com.cn', 0, 0, 0, 4347, 0, 1, 0, NULL, 9, '', ''),
(2756, '1289786650', '复旦大学出版社', 'http://www.fudanpress.com', 0, 0, 0, 4347, 0, 1, 0, NULL, 8, '', ''),
(2755, '1289786650', '清华大学出版社', 'http://www.tup.tsinghua.edu.cn/', 0, 0, 0, 4347, 0, 1, 0, NULL, 7, '', ''),
(2749, '1289786650', '人民教育出版社', 'http://www.pep.com.cn/', 0, 0, 0, 4347, 0, 1, 0, NULL, 1, '', ''),
(2750, '1289786650', '商务印书馆', 'http://www.cp.com.cn/', 0, 0, 0, 4347, 0, 1, 0, NULL, 2, '', ''),
(2751, '1289786650', '译林出版社', 'http://www.yilin.com/', 0, 0, 0, 4347, 0, 1, 0, NULL, 3, '', ''),
(2752, '1289786650', '上海译文出版社', 'http://www.stph.com.cn', 0, 0, 0, 4347, 0, 1, 0, NULL, 4, '', ''),
(2753, '1289786650', '作家出版社', 'http://www.zuojiachubanshe.com', 0, 0, 0, 4347, 0, 1, 0, NULL, 5, '', ''),
(2754, '1289786650', '科学出版社', 'http://www.sciencep.com', 0, 0, 0, 4347, 0, 1, 0, NULL, 6, '', ''),
(2722, '1279617741', '听相声', 'http://www.tingxs.com/', 0, 0, 0, 3045, 0, 1, 0, NULL, 1, '', ''),
(2723, '1279617741', '中国京剧艺术网', 'http://www.jingjuok.com/', 0, 0, 0, 3045, 0, 1, 0, NULL, 2, '', ''),
(2724, '1279617741', '中国古曲网', 'http://www.guqu.net/', 0, 0, 0, 3045, 0, 1, 0, NULL, 3, '', ''),
(2725, '1279617741', '中华戏曲网', 'http://www.dongdongqiang.com', 0, 0, 0, 3045, 0, 1, 0, NULL, 4, '', ''),
(2726, '1279617741', 'CCTV九州大戏台', 'http://space.tv.cctv.com/podcast/jzdxt', 0, 0, 0, 3045, 0, 1, 0, NULL, 5, '', ''),
(2727, '1279617741', '中华演出网', 'http://www.show160.com/', 0, 0, 0, 3045, 0, 1, 0, NULL, 6, '', ''),
(2728, '1279617741', '曲苑杂坛', 'http://space.tv.cctv.com/podcast/quyuanzatan', 0, 0, 0, 3045, 0, 1, 0, NULL, 7, '', ''),
(2729, '1279617741', '德云社-相声公社', 'http://www.guodegang.org/bbs/index.php', 0, 0, 0, 3045, 0, 1, 0, NULL, 8, '', ''),
(2730, '1279617741', '有声小说吧', 'http://www.yousheng8.com/index.htm', 0, 0, 0, 3045, 0, 1, 0, NULL, 10, '', ''),
(2731, '1279617741', '本山在线', 'http://www.zbs.cn', 0, 0, 0, 3045, 0, 1, 0, NULL, 11, '', ''),
(2732, '1279617741', '我听评书网', 'http://www.5tps.com', 0, 0, 0, 3045, 0, 1, 0, NULL, 12, '', ''),
(2733, '1279617741', '吴桥杂技网', 'http://www.wqzjt.cn/', 0, 0, 0, 3046, 0, 1, 0, NULL, 1, '', ''),
(2734, '1279617741', '魔术吧', 'http://www.magic8.cn/', 0, 0, 0, 3046, 0, 1, 0, NULL, 2, '', ''),
(2735, '1279617741', '魔术屋', 'http://www.moshu5.com/', 1, 0, 0, 3046, 0, 1, 0, NULL, 3, '', ''),
(2736, '1279617741', '中国魔术论坛', 'http://www.52magic.net/', 0, 0, 0, 3046, 0, 1, 0, NULL, 4, '', ''),
(2737, '1279617741', '爱魔术', 'http://www.aimagic.cn/', 0, 0, 0, 3046, 0, 1, 0, NULL, 5, '', ''),
(2738, '1279617741', 'CCTV戏曲频道', 'http://space.tv.cctv.com/podcast/jzdxt', 0, 0, 0, 3047, 0, 1, 0, NULL, 1, '', ''),
(2739, '1279617741', '河南戏曲', 'http://www.hnxq.net/', 0, 0, 0, 3047, 0, 1, 0, NULL, 2, '', ''),
(2740, '1279617741', '京剧艺术网', 'http://www.jingjuok.com/', 0, 0, 0, 3047, 0, 1, 0, NULL, 3, '', ''),
(2741, '1279617741', '国家大剧院', 'http://www.chncpa.org/', 0, 0, 0, 3047, 0, 1, 0, NULL, 4, '', ''),
(2742, '1279617741', '中国川剧网', 'http://scopera.newssc.org/', 0, 0, 0, 3047, 0, 1, 0, NULL, 5, '', ''),
(2743, '1279617741', '中国秦腔网', 'http://www.qinqiang.com/', 0, 0, 0, 3047, 0, 1, 0, NULL, 6, '', ''),
(2744, '1279617741', '中国戏曲网', 'http://www.chinaopera.net/', 0, 0, 0, 3047, 0, 1, 0, NULL, 7, '', ''),
(2745, '1279617741', '秦腔乱弹网', 'http://www.qinqiang.org/', 0, 0, 0, 3047, 0, 1, 0, NULL, 8, '', ''),
(2746, '1279617741', '咚咚呛', 'http://www.dongdongqiang.com/', 0, 0, 0, 3047, 0, 1, 0, NULL, 9, '', ''),
(2747, '1279617741', '梨园春', 'http://www.liyuanchun.net/', 0, 0, 0, 3047, 0, 1, 0, NULL, 10, '', ''),
(2748, '1279617741', '中安在线黄梅戏', 'http://drama.anhuinews.com/', 0, 0, 0, 3047, 0, 1, 0, NULL, 11, '', ''),
(2761, '1289786650', '人民邮电出版社', 'http://www.ptpress.com.cn/', 0, 0, 0, 4347, 0, 1, 0, NULL, 13, '', ''),
(2762, '1289786650', '大象出版社', 'http://www.daxiang.cn', 0, 0, 0, 4347, 0, 1, 0, NULL, 14, '', ''),
(2763, '1289786650', '金盾出版社', 'http://www.jdcbs.com.cn', 0, 0, 0, 4347, 0, 1, 0, NULL, 15, '', ''),
(2764, '1289786674', '美国麦克米兰出版公司', 'http://www.mcp.com/', 0, 0, 0, 4348, 0, 1, 0, NULL, 1, '', ''),
(2765, '1289786674', '高乐尔出版公司', 'http://www.gowerpub.com', 0, 0, 0, 4348, 0, 1, 0, NULL, 2, '', ''),
(2766, '1289786674', '剑桥大学出版社', 'http://www.cup.cam.ac.uk/', 0, 0, 0, 4348, 0, 1, 0, NULL, 3, '', ''),
(2767, '1289786674', '牛津大学出版社', 'http://www.oup.co.uk', 0, 0, 0, 4348, 0, 1, 0, NULL, 4, '', ''),
(2768, '1289786674', '皮尔森集团', 'http://www.pearson.com', 0, 0, 0, 4348, 0, 1, 0, NULL, 5, '', ''),
(2769, '1289786674', '艾迪生韦斯利-朗文公司', 'http://www.awl.com/', 0, 0, 0, 4348, 0, 1, 0, NULL, 6, '', ''),
(2770, '1289786674', 'Adobe出版社', 'http://www.adobe.com/', 0, 0, 0, 4348, 0, 1, 0, NULL, 7, '', ''),
(2771, '1289786674', '美国教育考试中心', 'http://www.ets.org/', 0, 0, 0, 4348, 0, 1, 0, NULL, 8, '', ''),
(2772, '1289786674', '赫斯特公司', 'http://www.hearst.com', 0, 0, 0, 4348, 0, 1, 0, NULL, 9, '', ''),
(2773, '1289786674', '学术出版社', 'http://www.scholastic.com', 0, 0, 0, 4348, 0, 1, 0, NULL, 10, '', ''),
(2774, '1289786674', '兰登书屋', 'http://www.randomhouse.com', 0, 0, 0, 4348, 0, 1, 0, NULL, 11, '', ''),
(2775, '1289786674', '角川書店', 'http://www.kadokawa.co.jp', 0, 0, 0, 4348, 0, 1, 0, NULL, 12, '', ''),
(2776, '1289786674', 'IDG公司', 'http://www.idg.com/', 0, 0, 0, 4348, 0, 1, 0, NULL, 13, '', ''),
(2777, '1289786674', '汤姆森公司', 'http://www.thomson.com', 0, 0, 0, 4348, 0, 1, 0, NULL, 14, '', ''),
(2778, '1289786674', '威尔逊出版公司', 'http://www.hwwilson.com', 0, 0, 0, 4348, 0, 1, 0, NULL, 15, '', ''),
(2779, '1289786674', '企鹅出版集团', 'http://www.penguin.com', 0, 0, 0, 4348, 0, 1, 0, NULL, 16, '', ''),
(2780, '1289786674', '麦格劳-希尔公司', 'http://www.mcgraw-hill.com', 0, 0, 0, 4348, 0, 1, 0, NULL, 17, '', ''),
(2781, '1289786674', '霍顿·米夫林出版公司', 'http://www.hmco.com', 0, 0, 0, 4348, 0, 1, 0, NULL, 18, '', ''),
(2782, '1289786674', '哈珀·柯林斯出版集团', 'http://www.harpercollins.com/', 0, 0, 0, 4348, 0, 1, 0, NULL, 19, '', ''),
(2783, '1289786674', '约翰·威得父子公司', 'http://www.wiley.com', 0, 0, 0, 4348, 0, 1, 0, NULL, 20, '', ''),
(2784, '1289786674', '兰根夏特出版公司', 'http://www.langenscheidt.de/', 0, 0, 0, 4348, 0, 1, 0, NULL, 21, '', ''),
(2785, '1289786701', '重庆热线', 'http://www.online.cq.cn', 0, 0, 0, 4041, 0, 1, 0, NULL, 1, '', ''),
(2786, '1289786701', '华龙网', 'http://www.cqnews.net', 0, 0, 0, 4041, 0, 1, 0, NULL, 2, '', ''),
(2787, '1289786701', '重庆之窗', 'http://www.cqwin.com', 0, 0, 0, 4041, 0, 1, 0, NULL, 3, '', ''),
(2788, '1289786701', '重庆溜', 'http://cq6.com', 0, 0, 0, 4041, 0, 1, 0, NULL, 4, '', ''),
(2789, '1289786701', '重庆气象网', 'http://www.121.cq.cn', 0, 0, 0, 4041, 0, 1, 0, NULL, 5, '', ''),
(2790, '1289786701', '重庆公交', 'http://www.cqgj.net', 0, 0, 0, 4041, 0, 1, 0, NULL, 6, '', ''),
(2791, '1289786701', '重庆彩票网', 'http://www.cqcp.net', 0, 0, 0, 4041, 0, 1, 0, NULL, 7, '', ''),
(2792, '1289786701', '重庆体彩网', 'http://www.cqlottery.gov.cn', 0, 0, 0, 4041, 0, 1, 0, NULL, 8, '', ''),
(8221, '1289887065', '蹦蹦家园', 'http://www.bengbeng.com/', 0, 0, 0, 2048, 0, 1, 1289887065, NULL, 46, '', ''),
(2794, '1289786726', '国家环保总局', 'http://www.zhb.gov.cn/', 0, 0, 0, 4349, 0, 1, 0, NULL, 1, '', ''),
(2795, '1289786726', '中国环境生态网', 'http://www.eedu.org.cn', 0, 0, 0, 4349, 0, 1, 0, NULL, 2, '', ''),
(2796, '1289786726', '中华环保', 'http://www.chinaep.net/', 0, 0, 0, 4349, 0, 1, 0, NULL, 3, '', ''),
(2797, '1289786726', '中国环保网', 'http://www.epnet.cn/', 0, 0, 0, 4349, 0, 1, 0, NULL, 4, '', ''),
(2798, '1289786726', '中国环境科学学会', 'http://www.chinacses.org', 0, 0, 0, 4349, 0, 1, 0, NULL, 5, '', ''),
(2799, '1289786726', '中国环境资源网', 'http://www.ce65.com', 0, 0, 0, 4349, 0, 1, 0, NULL, 6, '', ''),
(2800, '1289786726', '中国环境影响评价网', 'http://www.china-eia.com', 0, 0, 0, 4349, 0, 1, 0, NULL, 7, '', ''),
(2801, '1289786726', '中国环境监测', 'http://www.cnemc.cn/', 0, 0, 0, 4349, 0, 1, 0, NULL, 8, '', ''),
(2802, '1289786726', '中华环境保护基金会', 'http://www.cepf.org.cn', 0, 0, 0, 4349, 0, 1, 0, NULL, 9, '', ''),
(2803, '1289786726', '中国环境报', 'http://www.cenews.com.cn', 0, 0, 0, 4349, 0, 1, 0, NULL, 10, '', ''),
(2804, '1289786726', '中国环保商务网', 'http://www.ep168.com', 0, 0, 0, 4349, 0, 1, 0, NULL, 11, '', ''),
(2805, '1289786726', '中国环保设备网', 'http://www.goepe.com', 0, 0, 0, 4349, 0, 1, 0, NULL, 12, '', ''),
(2806, '1289786726', '中科院生态研究中心', 'http://www.rcees.ac.cn', 0, 0, 0, 4349, 0, 1, 0, NULL, 13, '', ''),
(2807, '1289786726', '中国环保网', 'http://www.chinaenvironment.com', 0, 0, 0, 4349, 0, 1, 0, NULL, 14, '', ''),
(2808, '1289786726', '中国环保频道', 'http://www.zghbpd.com/', 0, 0, 0, 4349, 0, 1, 0, NULL, 15, '', ''),
(2809, '1289786726', '慧聪环保网', 'http://www.ep.hc360.com', 0, 0, 0, 4349, 0, 1, 0, NULL, 16, '', ''),
(2810, '1289786726', '中国环保设备网', 'http://www.epun.cn/', 0, 0, 0, 4349, 0, 1, 0, NULL, 17, '', ''),
(2811, '1289786726', '生态中国网', 'http://eco.gov.cn', 0, 0, 0, 4349, 0, 1, 0, NULL, 18, '', ''),
(2812, '1289786756', '中国绿化网', 'http://www.chinagreen.net.cn/', 0, 0, 0, 4350, 0, 1, 0, NULL, 1, '', ''),
(2813, '1289786756', '园林在线', 'http://www.lvhua.com/', 0, 0, 0, 4350, 0, 1, 0, NULL, 2, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(2814, '1289786756', '国家林业局', 'http://www.forestry.gov.cn/', 0, 0, 0, 4350, 0, 1, 0, NULL, 3, '', ''),
(2815, '1289786756', '中国绿化苗木网', 'http://www.hnmmw.com', 0, 0, 0, 4350, 0, 1, 0, NULL, 4, '', ''),
(2816, '1289786756', '中国园林网', 'http://www.yuanlin.com/', 0, 0, 0, 4350, 0, 1, 0, NULL, 5, '', ''),
(2817, '1289786756', '中华园林网', 'http://www.yuanlin365.com/', 0, 0, 0, 4350, 0, 1, 0, NULL, 6, '', ''),
(2818, '1289786756', '园林中国网', 'http://www.cnlai.com', 0, 0, 0, 4350, 0, 1, 0, NULL, 7, '', ''),
(2819, '1289786756', '中国园林商情', 'http://www.18yl.com/', 0, 0, 0, 4350, 0, 1, 0, NULL, 8, '', ''),
(2820, '1289786756', '园林学习网', 'http://www.ylstudy.com/', 0, 0, 0, 4350, 0, 1, 0, NULL, 9, '', ''),
(2821, '1289786772', '重庆热线', 'http://www.online.cq.cn/', 0, 0, 0, 4042, 0, 1, 0, NULL, 1, '', ''),
(2822, '1289786772', '华龙网', 'http://www.cqnews.net/', 0, 0, 0, 4042, 0, 1, 0, NULL, 2, '', ''),
(2823, '1289786772', '重庆晚报', 'http://www.cqwb.com.cn/', 0, 0, 0, 4042, 0, 1, 0, NULL, 3, '', ''),
(2824, '1289786772', '重庆晨报', 'http://www.cqcb.com/', 0, 0, 0, 4042, 0, 1, 0, NULL, 4, '', ''),
(2825, '1289786772', '重庆商报', 'http://cqsb.cqnews.net/', 0, 0, 0, 4042, 0, 1, 0, NULL, 5, '', ''),
(2826, '1289786772', '大渝网', 'http://cq.qq.com/', 0, 0, 0, 4042, 0, 1, 0, NULL, 6, '', ''),
(2827, '1289786772', '重庆时报', 'http://cqsb.chengw.com/', 0, 0, 0, 4042, 0, 1, 0, NULL, 7, '', ''),
(2828, '1289786772', '新华网重庆频道', 'http://www.cq.xinhuanet.com/', 0, 0, 0, 4042, 0, 1, 0, NULL, 8, '', ''),
(2829, '1289786786', '中国水网', 'http://www.h2o-china.com', 0, 0, 0, 4351, 0, 1, 0, NULL, 1, '', ''),
(2830, '1289786786', '中国水利网', 'http://www.chinawater.com.cn', 0, 0, 0, 4351, 0, 1, 0, NULL, 2, '', ''),
(2831, '1289786786', '中国水工业', 'http://www.c-water.com.cn', 0, 0, 0, 4351, 0, 1, 0, NULL, 3, '', ''),
(2832, '1289786786', '中国水势网', 'http://www.waterinfo.com.cn', 0, 0, 0, 4351, 0, 1, 0, NULL, 4, '', ''),
(2833, '1289786786', '中国水利学会', 'http://www.ches.org.cn', 0, 0, 0, 4351, 0, 1, 0, NULL, 5, '', ''),
(2834, '1289786786', '水信息网', 'http://www.hwcc.com.cn', 0, 0, 0, 4351, 0, 1, 0, NULL, 6, '', ''),
(2835, '1289786786', '慧聪水工业网', 'http://www.water.hc360.com/', 0, 0, 0, 4351, 0, 1, 0, NULL, 7, '', ''),
(2836, '1289786816', '新华网重庆频道', 'http://www.cq.xinhuanet.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 1, '', ''),
(2837, '1289786816', '人民网重庆视窗', 'http://cq.people.com.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 2, '', ''),
(2838, '1289786816', '重庆江北国际机场', 'http://www.cqa.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 3, '', ''),
(2839, '1289786816', '爱渝网', 'http://www.cqiee.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 4, '', ''),
(2840, '1289786816', '大渝网', 'http://cq.qq.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 5, '', ''),
(2841, '1289786816', '重庆轨道交通', 'http://www.cqmetro.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 6, '', ''),
(2842, '1289786816', '重庆移动', 'http://www.cq.chinamobile.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 7, '', ''),
(2843, '1289786816', '重庆联通', 'http://www.on165.com/index.aspx', 0, 0, 0, 4043, 0, 1, 0, NULL, 8, '', ''),
(2844, '1289786816', '重庆电信', 'http://www.cqtelecom.com.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 9, '', ''),
(2845, '1289786816', '重庆铁通', 'http://www.cttcq.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 10, '', ''),
(2846, '1289786816', '重庆人才网', 'http://www.cqjob.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 11, '', ''),
(2847, '1289786816', '联英人才网', 'http://www.hrm.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 12, '', ''),
(2848, '1289786816', '重庆人才市场', 'http://www.hrm.cq.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 13, '', ''),
(2849, '1289786816', '重庆市人事局', 'http://www.cqpa.gov.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 14, '', ''),
(2850, '1289786816', '重庆劳动保障网', 'http://jld.cq.gov.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 15, '', ''),
(2851, '1289786816', '重庆焦点房产网', 'http://cq.focus.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 16, '', ''),
(2852, '1289786816', '搜房网重庆站', 'http://cq.soufun.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 17, '', ''),
(2853, '1289786816', '重庆市房管局', 'http://www.cqgtfw.gov.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 18, '', ''),
(2854, '1289786816', '华龙网旅游', 'http://tour.cqnews.net', 0, 0, 0, 4043, 0, 1, 0, NULL, 19, '', ''),
(2855, '1289786816', '重庆美食在线', 'http://www.eating.cn/file/main', 0, 0, 0, 4043, 0, 1, 0, NULL, 20, '', ''),
(2856, '1289786816', '重庆美食', 'http://food.cqnews.net', 0, 0, 0, 4043, 0, 1, 0, NULL, 21, '', ''),
(2857, '1289786816', '重庆热线-美食', 'http://food.online.cq.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 22, '', ''),
(2858, '1289786816', '重庆卫生信息网', 'http://www.cqwsj.gov.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 23, '', ''),
(2859, '1289786816', '西南医院', 'http://www.swhospital.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 24, '', ''),
(2860, '1289786816', '重庆第三人民医院', 'http://www.3rmhospital.com.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 25, '', ''),
(2861, '1289786816', '搜狐社区-重庆', 'http://club.travel.sohu.com/list_art_sub.php?b=chongqing', 0, 0, 0, 4043, 0, 1, 0, NULL, 26, '', ''),
(2862, '1289786816', '天涯社区-重庆', 'http://www.tianya.cn/new/TianyaCity/ArticlesList_Culture.asp?idWriter=0&amp;amp;Key=0&amp;amp;idItem=45', 0, 0, 0, 4043, 0, 1, 0, NULL, 27, '', ''),
(2863, '1289786816', '重庆购物狂论坛', 'http://cqmmgo.com/bbs', 0, 0, 0, 4043, 0, 1, 0, NULL, 28, '', ''),
(2864, '1289786816', '华龙两江论坛', 'http://bbs.cqnews.net', 0, 0, 0, 4043, 0, 1, 0, NULL, 29, '', ''),
(2865, '1289786816', '重庆市政府公众信息网', 'http://www.cq.gov.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 30, '', ''),
(2866, '1289786816', '重庆市法院', 'http://www.cqcourt.gov.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 31, '', ''),
(2867, '1289786816', '重庆市检察院', 'http://www.cqjcy.gov.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 32, '', ''),
(2868, '1289786816', '重庆市发展改革委员会', 'http://wfg.cq.gov.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 33, '', ''),
(2869, '1289786816', '重庆市档案局', 'http://jda.cq.gov.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 34, '', ''),
(2870, '1289786816', '重庆市公安局', 'http://jga.cq.gov.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 35, '', ''),
(2871, '1289786816', '重庆自来水公司', 'http://www.cqzls.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 36, '', ''),
(2872, '1289786816', '重庆电力公司', 'http://www.cq95598.com.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 37, '', ''),
(2873, '1289786816', '重庆二手电脑网', 'http://www.ccqit.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 38, '', ''),
(2874, '1289786816', '云阳人家', 'http://www.yycqc.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 39, '', ''),
(2875, '1289786816', '重庆信息发布网', 'http://www.xc766.cn', 0, 0, 0, 4043, 0, 1, 0, NULL, 40, '', ''),
(2876, '1289786816', '重庆论坛', 'http://bbs.classic023.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 41, '', ''),
(2877, '1289786816', '重庆购物狂论坛', 'http://go.cqmmgo.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 42, '', ''),
(2878, '1289786816', '黔江热线', 'http://www.52qj.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 43, '', ''),
(2879, '1289786816', '石柱在线', 'http://www.shizhu.com', 0, 0, 0, 4043, 0, 1, 0, NULL, 44, '', ''),
(2880, '1289786816', '重庆建设科技', 'http://www.cqct.org', 0, 0, 0, 4043, 0, 1, 0, NULL, 45, '', ''),
(2881, '1289786840', '中国工业网站', 'http://www.ic1000.net/', 0, 0, 0, 4352, 0, 1, 0, NULL, 1, '', ''),
(2882, '1289786840', '中国轻工业网', 'http://www.clii.com.cn/', 0, 0, 0, 4352, 0, 1, 0, NULL, 2, '', ''),
(2883, '1289786840', '中兵器工业集团公司', 'http://www.cngc.com.cn/', 0, 0, 0, 4352, 0, 1, 0, NULL, 3, '', ''),
(2884, '1289786840', '中塑料加工工业协会', 'http://www.cppia.com.cn/', 0, 0, 0, 4352, 0, 1, 0, NULL, 4, '', ''),
(2885, '1289786840', '中国水工业网', 'http://www.c-water.com.cn/', 0, 0, 0, 4352, 0, 1, 0, NULL, 5, '', ''),
(2886, '1289786840', '中国煤炭工业网', 'http://www.chinacoal.gov.cn/', 0, 0, 0, 4352, 0, 1, 0, NULL, 6, '', ''),
(2887, '1289786840', '中国膜技术网', 'http://www.mem-china.com/', 0, 0, 0, 4352, 0, 1, 0, NULL, 7, '', ''),
(2888, '1289786840', '中国煤炭工业网', 'http://www.chinacoal.gov.cn/', 0, 0, 0, 4352, 0, 1, 0, NULL, 8, '', ''),
(2889, '1289786840', '中国玻璃工业网', 'http://www.chinaglassnet.com/', 0, 0, 0, 4352, 0, 1, 0, NULL, 9, '', ''),
(2890, '1289786859', '重庆大学', 'http://www.cqu.edu.cn/', 0, 0, 0, 4044, 0, 1, 0, NULL, 1, '', ''),
(2891, '1289786859', '重庆邮电大学', 'http://www.cqupt.edu.cn/', 0, 0, 0, 4044, 0, 1, 0, NULL, 2, '', ''),
(2892, '1289786859', '西南政法大学', 'http://www.swupl.edu.cn/', 0, 0, 0, 4044, 0, 1, 0, NULL, 3, '', ''),
(2893, '1289786859', '西南大学', 'http://www.swnu.edu.cn/', 0, 0, 0, 4044, 0, 1, 0, NULL, 4, '', ''),
(2894, '1289786859', '重庆师范大学', 'http://www.cqnu.edu.cn/', 0, 0, 0, 4044, 0, 1, 0, NULL, 5, '', ''),
(2895, '1289786859', '重庆交通大学', 'http://www.cquc.edu.cn/', 0, 0, 0, 4044, 0, 1, 0, NULL, 6, '', ''),
(2896, '1289786859', '四川外语学院', 'http://www.sisu.edu.cn/', 0, 0, 0, 4044, 0, 1, 0, NULL, 7, '', ''),
(2897, '1289786862', '全球五金网', 'http://www.wjw.cn', 0, 0, 0, 4353, 0, 1, 0, NULL, 1, '', ''),
(2898, '1289786862', '亚洲五金资源', 'http://www.asia-hardware.com', 0, 0, 0, 4353, 0, 1, 0, NULL, 2, '', ''),
(2899, '1289786862', '中国五金网', 'http://china.globalhardwares.com', 0, 0, 0, 4353, 0, 1, 0, NULL, 3, '', ''),
(2900, '1289786862', '慧聪五金网', 'http://www.wujin.hc360.com', 0, 0, 0, 4353, 0, 1, 0, NULL, 4, '', ''),
(2901, '1289786862', '华南五金交易网', 'http://www.hnwj.net', 0, 0, 0, 4353, 0, 1, 0, NULL, 5, '', ''),
(2902, '1289786862', '五金商贸网', 'http://www.hardwareinfo.cn/', 0, 0, 0, 4353, 0, 1, 0, NULL, 6, '', ''),
(2903, '1289786862', '保险箱批发网', 'http://www.pifa7.cn/', 0, 0, 0, 4353, 0, 1, 0, NULL, 7, '', ''),
(2904, '1289786862', '中国锯工业网', 'http://www.cnsaw.com', 0, 0, 0, 4353, 0, 1, 0, NULL, 8, '', ''),
(2905, '1289786862', '买卖人五金网', 'http://www.chinammr.com/', 0, 0, 0, 4353, 0, 1, 0, NULL, 9, '', ''),
(2906, '1289786881', '国际模具网', 'http://www.2mould.com/', 0, 0, 0, 4354, 0, 1, 0, NULL, 1, '', ''),
(2907, '1289786881', '中国模具网', 'http://www.mould.net.cn', 0, 0, 0, 4354, 0, 1, 0, NULL, 2, '', ''),
(2908, '1289786881', '中国机械模具网', 'http://www.mymould.net.cn/', 0, 0, 0, 4354, 0, 1, 0, NULL, 3, '', ''),
(2909, '1289786881', '中国模具人才网', 'http://www.mouldjob.com', 0, 0, 0, 4354, 0, 1, 0, NULL, 4, '', ''),
(2910, '1289786881', '模具网', 'http://www.molds.cn', 0, 0, 0, 4354, 0, 1, 0, NULL, 5, '', ''),
(2911, '1289786881', '中国塑料模具网', 'http://cn.plasticmould.net/', 0, 0, 0, 4354, 0, 1, 0, NULL, 6, '', ''),
(2912, '1289786881', '国际模具网', 'http://www.2mould.com', 0, 0, 0, 4354, 0, 1, 0, NULL, 7, '', ''),
(3763, '1289787970', '电信', 'http://jl.ct10000.com/', 0, 0, 0, 4083, 0, 1, 0, NULL, 4, '', ''),
(3762, '1289787970', '联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010012&amp;amp;id=3728', 0, 0, 0, 4083, 0, 1, 0, NULL, 3, '', ''),
(2918, '1289786924', '涪风论坛', 'http://bbs.fuling.com/', 0, 0, 0, 4045, 0, 1, 0, NULL, 1, '', ''),
(2919, '1289786924', '重庆购物狂论坛', 'http://go.cqmmgo.com/', 0, 0, 0, 4045, 0, 1, 0, NULL, 2, '', ''),
(2920, '1289786924', '天涯重庆', 'http://cq.tianya.cn/', 0, 0, 0, 4045, 0, 1, 0, NULL, 3, '', ''),
(2921, '1289786924', '重庆妈妈网', 'http://www.cqmama.net/', 0, 0, 0, 4045, 0, 1, 0, NULL, 4, '', ''),
(2922, '1289786924', '重庆贴吧', 'http://post.baidu.com/f?kw=%D6%D8%C7%EC', 0, 0, 0, 4045, 0, 1, 0, NULL, 5, '', ''),
(2923, '1289786924', '重庆钓鱼网', 'http://www.cqfishing.net/', 0, 0, 0, 4045, 0, 1, 0, NULL, 6, '', ''),
(2924, '1289786924', '两江论坛', 'http://bbs.cqnews.net/', 0, 0, 0, 4045, 0, 1, 0, NULL, 7, '', ''),
(2925, '1289786924', '重庆e宠网', 'http://www.cqepet.com/', 0, 0, 0, 4045, 0, 1, 0, NULL, 8, '', ''),
(2926, '1289786924', '方竹论坛', 'http://www.ncfz.com/', 0, 0, 0, 4045, 0, 1, 0, NULL, 9, '', ''),
(2927, '1289786924', '垫江论坛', 'http://www.cqdj520.cn/', 0, 0, 0, 4045, 0, 1, 0, NULL, 10, '', ''),
(2928, '1289786924', '重庆it论坛网', 'http://bbs.cqit.com/', 0, 0, 0, 4045, 0, 1, 0, NULL, 11, '', ''),
(2929, '1289786924', '重庆力帆足球俱乐部', 'http://www.lifanfc.com/', 0, 0, 0, 4045, 0, 1, 0, NULL, 12, '', ''),
(2930, '1289786943', '全国物流信息网', 'http://www.56888.net', 0, 0, 0, 4356, 0, 1, 0, NULL, 1, '', ''),
(2931, '1289786943', '中国物流与采购网', 'http://www.chinawuliu.com.cn', 0, 0, 0, 4356, 0, 1, 0, NULL, 2, '', ''),
(2932, '1289786943', '中国物流招标网', 'http://www.clb.org.cn/', 0, 0, 0, 4356, 0, 1, 0, NULL, 3, '', ''),
(2933, '1289786943', '中国物流联合网', 'http://www.un56.com', 0, 0, 0, 4356, 0, 1, 0, NULL, 4, '', ''),
(2934, '1289786943', '大中国物流', 'http://www.greatchina56.com/', 0, 0, 0, 4356, 0, 1, 0, NULL, 5, '', ''),
(2935, '1289786943', '锦程物流网', 'http://www.jctrans.com', 0, 0, 0, 4356, 0, 1, 0, NULL, 6, '', ''),
(2936, '1289786943', '中国物流产品网', 'http://www.56products.com', 0, 0, 0, 4356, 0, 1, 0, NULL, 7, '', ''),
(2937, '1289786943', '中国交通运输协会', 'http://www.cctanet.org.cn', 0, 0, 0, 4356, 0, 1, 0, NULL, 8, '', ''),
(2938, '1289786943', '物流110', 'http://www.56110.cn/', 0, 0, 0, 4356, 0, 1, 0, NULL, 9, '', ''),
(2939, '1289786943', '物流工程学会', 'http://www.lei.org.cn', 0, 0, 0, 4356, 0, 1, 0, NULL, 10, '', ''),
(2940, '1289786962', '重庆市政府', 'http://www.cq.gov.cn/', 0, 0, 0, 4046, 0, 1, 0, NULL, 1, '', ''),
(2941, '1289786962', '重庆市发改委', 'http://wfg.cq.gov.cn/', 0, 0, 0, 4046, 0, 1, 0, NULL, 2, '', ''),
(2942, '1289786962', '重庆市法院', 'http://www.cqcourt.gov.cn/', 0, 0, 0, 4046, 0, 1, 0, NULL, 3, '', ''),
(2943, '1289786962', '重庆市检察院', 'http://www.cqjcy.gov.cn/', 0, 0, 0, 4046, 0, 1, 0, NULL, 4, '', ''),
(2944, '1289786962', '重庆市公安局', 'http://jga.cq.gov.cn/', 0, 0, 0, 4046, 0, 1, 0, NULL, 5, '', ''),
(2945, '1289786962', '重庆市档案局', 'http://jda.cq.gov.cn/', 0, 0, 0, 4046, 0, 1, 0, NULL, 6, '', ''),
(2946, '1289786962', '重庆政府采购网', 'http://www.cqgp.gov.cn/', 0, 0, 0, 4046, 0, 1, 0, NULL, 7, '', ''),
(2947, '1289786963', '中国交通', 'http://www.iicc.ac.cn', 0, 0, 0, 4357, 0, 1, 0, NULL, 1, '', ''),
(2948, '1289786963', '中国公路网', 'http://www.chinahighway.com/', 0, 0, 0, 4357, 0, 1, 0, NULL, 2, '', ''),
(2949, '1289786963', '中国交通新闻网', 'http://www.zgjtb.com/', 0, 0, 0, 4357, 0, 1, 0, NULL, 3, '', ''),
(2950, '1289786963', '中国国际海运网', 'http://www.shippingchina.com', 0, 0, 0, 4357, 0, 1, 0, NULL, 4, '', ''),
(2951, '1289786963', '中华航运网', 'http://www.chineseshipping.com.cn', 0, 0, 0, 4357, 0, 1, 0, NULL, 5, '', ''),
(2952, '1289786963', '中华配货网', 'http://www.peihuo.com', 0, 0, 0, 4357, 0, 1, 0, NULL, 6, '', ''),
(2953, '1289786963', '中国航贸网', 'http://www.snet.com.cn', 0, 0, 0, 4357, 0, 1, 0, NULL, 7, '', ''),
(2954, '1289786963', '航运信息网', 'http://www.csi.com.cn', 0, 0, 0, 4357, 0, 1, 0, NULL, 8, '', ''),
(2955, '1289786963', '民航资源网', 'http://www.carnoc.com', 0, 0, 0, 4357, 0, 1, 0, NULL, 9, '', ''),
(2956, '1289786963', '航运在线', 'http://www.sol.com.cn', 0, 0, 0, 4357, 0, 1, 0, NULL, 10, '', ''),
(2957, '1289786987', '各类快递跟踪查询', 'http://tool.115.com/live/express', 0, 0, 0, 4358, 0, 1, 0, NULL, 1, '', ''),
(2958, '1289786987', 'EMS 全球邮政特快', 'http://www.ems.com.cn/', 0, 0, 0, 4358, 0, 1, 0, NULL, 2, '', ''),
(2959, '1289786987', '顺丰快递', 'http://www.sf-express.com/', 0, 0, 0, 4358, 0, 1, 0, NULL, 3, '', ''),
(2960, '1289786987', '圆通速递', 'http://www.yto.net.cn/', 0, 0, 0, 4358, 0, 1, 0, NULL, 4, '', ''),
(2961, '1289786987', '申通快递', 'http://www.sto.cn/', 0, 0, 0, 4358, 0, 1, 0, NULL, 5, '', ''),
(2962, '1289786987', '中通快递', 'http://www.zto.cn/', 0, 0, 0, 4358, 0, 1, 0, NULL, 6, '', ''),
(2963, '1289786987', '汇通速递', 'http://www.htky365.com/', 0, 0, 0, 4358, 0, 1, 0, NULL, 7, '', ''),
(2964, '1289786987', '天天快递', 'http://www.ttkdex.com/', 0, 0, 0, 4358, 0, 1, 0, NULL, 8, '', ''),
(2965, '1289786987', '韵达快递', 'http://www.yundaex.com/', 0, 0, 0, 4358, 0, 1, 0, NULL, 9, '', ''),
(2966, '1289786987', '小红马物流快递', 'http://ponyex.com.cn/', 0, 0, 0, 4358, 0, 1, 0, NULL, 10, '', ''),
(2967, '1289786987', '全一快递货件', 'http://www.apex100.com/', 0, 0, 0, 4358, 0, 1, 0, NULL, 11, '', ''),
(2968, '1289786987', 'DHL中外运敦豪快递', 'http://www.cn.dhl.com/', 0, 0, 0, 4358, 0, 1, 0, NULL, 12, '', ''),
(2969, '1289786987', 'FedEx(联邦快递)', 'http://www.fedex.com/Tracking?cntry_code=cn', 0, 0, 0, 4358, 0, 1, 0, NULL, 13, '', ''),
(2970, '1289786987', '中铁快运', 'http://www.cre.cn/', 0, 0, 0, 4358, 0, 1, 0, NULL, 14, '', ''),
(2971, '1289786987', '华宇物流', 'http://www.hoau.net/', 0, 0, 0, 4358, 0, 1, 0, NULL, 15, '', ''),
(2972, '1289787011', '公交线路查询', 'http://www.8684.cn/', 0, 0, 0, 4359, 0, 1, 0, NULL, 1, '', ''),
(2973, '1289787011', '58列车时刻表', 'http://lieche.58.com/', 0, 0, 0, 4359, 0, 1, 0, NULL, 2, '', ''),
(2974, '1289787011', '火车票网', 'http://huoche.com/', 0, 0, 0, 4359, 0, 1, 0, NULL, 3, '', ''),
(2975, '1289787011', '火车票价查询', 'http://www.piaojia.cn/', 0, 0, 0, 4359, 0, 1, 0, NULL, 4, '', ''),
(2976, '1289787011', '携程旅行网-机票预订', 'http://www.ctrip.com', 0, 0, 0, 4359, 0, 1, 1289791018, NULL, 5, '', ''),
(6359, '1279617741', '海峡钓鱼论坛', 'http://bbs.chinafishing.com/', 0, 0, 0, 3066, 0, 1, 0, NULL, 1, '', ''),
(2977, '1289787011', '交通标志查询', 'http://biaozhi.5w.com/', 0, 0, 0, 4359, 0, 1, 0, NULL, 6, '', ''),
(2978, '1289787011', '全国车辆交通违章查询', 'http://tool.115.com/live/car', 0, 0, 0, 4359, 0, 1, 0, NULL, 7, '', ''),
(2979, '1289787011', '航班实时查询', 'http://travel.elong.com/flights/Default.aspx', 0, 0, 0, 4359, 0, 1, 1289791051, NULL, 8, '', ''),
(2980, '1289787011', '各地车牌号码查询', 'http://chepai.5w.com/', 0, 0, 0, 4359, 0, 1, 1289801789, NULL, 9, '', ''),
(2981, '1289787129', '中华人民共和国卫生部', 'http://www.moh.gov.cn/', 0, 0, 0, 4360, 0, 1, 0, NULL, 1, '', ''),
(2982, '1289787129', '中国医药网', 'http://www.pharmnet.com.cn/', 0, 0, 0, 4360, 0, 1, 0, NULL, 2, '', ''),
(2983, '1289787129', '中国医疗器械行业协会', 'http://www.camdi.org/', 0, 0, 0, 4360, 0, 1, 0, NULL, 3, '', ''),
(2984, '1289787129', '国际医疗仪器设备展览会', 'http://www.chinamed.net.cn/', 0, 0, 0, 4360, 0, 1, 0, NULL, 4, '', ''),
(2985, '1289787129', '医疗器械信息网', 'http://www.mednet.cn/', 0, 0, 0, 4360, 0, 1, 0, NULL, 5, '', ''),
(2986, '1289787129', '中国医疗器械信息网', 'http://www.cmdi.gov.cn/', 0, 0, 0, 4360, 0, 1, 0, NULL, 6, '', ''),
(2987, '1289787129', '国家中西药管理局', 'http://www.satcm.gov.cn/', 0, 0, 0, 4360, 0, 1, 0, NULL, 7, '', ''),
(2988, '1289787129', '国家食品药品监督管理局', 'http://www.sda.gov.cn/', 0, 0, 0, 4360, 0, 1, 0, NULL, 8, '', ''),
(2989, '1289787129', '中国药业123', 'http://www.chinayaoye123.com/', 0, 0, 0, 4360, 0, 1, 0, NULL, 9, '', ''),
(2990, '1289787129', '国家中药品种保护评委会', 'http://www.zybh.gov.cn/', 0, 0, 0, 4360, 0, 1, 0, NULL, 10, '', ''),
(2991, '1289787129', '合理用药网', 'http://hlyyao.com.cn/', 0, 0, 0, 4360, 0, 1, 0, NULL, 11, '', ''),
(2992, '1289787129', '慧聪－制药工业', 'http://www.pharmacy.hc360.com/', 0, 0, 0, 4360, 0, 1, 0, NULL, 12, '', ''),
(2993, '1289787129', '医药在线', 'http://www.cnm21.com/', 0, 0, 0, 4360, 0, 1, 0, NULL, 13, '', ''),
(2994, '1289787146', '长城在线', 'http://www.hebei.com.cn/', 0, 0, 0, 4051, 0, 1, 0, NULL, 1, '', ''),
(2995, '1289787146', '邯郸在线', 'http://www.hdol.cn/', 0, 0, 0, 4051, 0, 1, 0, NULL, 2, '', ''),
(2996, '1289787146', '衡水热线', 'http://hs.inhe.net/', 0, 0, 0, 4051, 0, 1, 0, NULL, 3, '', ''),
(2997, '1289787146', '保定热线', 'http://www.bdinfo.net/', 0, 0, 0, 4051, 0, 1, 0, NULL, 4, '', ''),
(2998, '1289787146', '邢台123', 'http://www.xingtai123.com/', 0, 0, 0, 4051, 0, 1, 0, NULL, 5, '', ''),
(2999, '1289787146', '廊坊热线', 'http://www.langfang.net/', 0, 0, 0, 4051, 0, 1, 0, NULL, 6, '', ''),
(3000, '1289787146', '邢台信息港', 'http://xingtai.inhe.net/', 0, 0, 0, 4051, 0, 1, 0, NULL, 7, '', ''),
(3001, '1289787146', '承德信息港', 'http://www.zisai.com/', 0, 0, 0, 4051, 0, 1, 0, NULL, 8, '', ''),
(3002, '1289787146', '邯郸信息港', 'http://www.hdt.net.cn/', 0, 0, 0, 4051, 0, 1, 0, NULL, 9, '', ''),
(3003, '1289787146', '秦皇岛信息港', 'http://www.qhd.com.cn/', 0, 0, 0, 4051, 0, 1, 0, NULL, 10, '', ''),
(3004, '1289787146', '张家口热线', 'http://zj-www.he.cninfo.net/', 0, 0, 0, 4051, 0, 1, 0, NULL, 11, '', ''),
(3005, '1289787146', '邯郸之窗', 'http://www.hdzc.net/', 0, 0, 0, 4051, 0, 1, 0, NULL, 12, '', ''),
(3006, '1289787146', '环渤海新闻网', 'http://www.huanbohainews.com.cn/', 0, 0, 0, 4051, 0, 1, 0, NULL, 13, '', ''),
(3007, '1289787146', '沧州信息港', 'http://www.cangzhou.net.cn/', 0, 0, 0, 4051, 0, 1, 0, NULL, 14, '', ''),
(3008, '1289787146', '沧州百姓网', 'http://cangzhou.baixing.com/', 0, 0, 0, 4051, 0, 1, 0, NULL, 15, '', ''),
(3009, '1289787146', '廊坊百姓网', 'http://langfang.baixing.com/', 0, 0, 0, 4051, 0, 1, 0, NULL, 16, '', ''),
(3010, '1289787165', '中国纺织机械网', 'http://www.cttm.net/', 0, 0, 0, 4361, 0, 1, 0, NULL, 1, '', ''),
(3011, '1289787165', '中国纺织机械市场网', 'http://www.ctmm.net/', 0, 0, 0, 4361, 0, 1, 0, NULL, 2, '', ''),
(3012, '1289787165', '中国纺机网', 'http://www.chinatex.info/', 0, 0, 0, 4361, 0, 1, 0, NULL, 3, '', ''),
(3013, '1289787165', '中国纺机网', 'http://www.ttmn.com', 0, 0, 0, 4361, 0, 1, 0, NULL, 4, '', ''),
(3014, '1289787165', '中华纺机网', 'http://www.ctma.net/', 0, 0, 0, 4361, 0, 1, 0, NULL, 5, '', ''),
(3015, '1289787168', '河北经济网', 'http://www.hbjjrb.com/', 0, 0, 0, 4052, 0, 1, 0, NULL, 1, '', ''),
(3016, '1289787168', '河北青年报', 'http://www.hbqnb.com/', 0, 0, 0, 4052, 0, 1, 0, NULL, 2, '', ''),
(3017, '1289787168', '够牛网', 'http://www.gooniu.com/', 0, 0, 0, 4052, 0, 1, 0, NULL, 3, '', ''),
(3018, '1289787168', '保定热线', 'http://www.bdinfo.net/', 0, 0, 0, 4052, 0, 1, 0, NULL, 4, '', ''),
(3019, '1289787168', '环渤海新闻网', 'http://www.huanbohainews.com.cn/', 0, 0, 0, 4052, 0, 1, 0, NULL, 5, '', ''),
(3020, '1289787168', '邯郸信息港', 'http://www.hdt.net.cn/', 0, 0, 0, 4052, 0, 1, 0, NULL, 6, '', ''),
(3021, '1289787168', '张家口新闻网', 'http://www.zjknews.com/', 0, 0, 0, 4052, 0, 1, 0, NULL, 7, '', ''),
(3022, '1289787168', '太和网', 'http://www.taihe.net/', 0, 0, 0, 4052, 0, 1, 0, NULL, 8, '', ''),
(3023, '1289787168', '河北之窗', 'http://www.hebzc.com.cn/', 0, 0, 0, 4052, 0, 1, 0, NULL, 9, '', ''),
(3024, '1289787168', '邯郸之窗', 'http://www.hdzc.net/', 0, 0, 0, 4052, 0, 1, 0, NULL, 10, '', ''),
(3025, '1289787168', '秦皇岛信息港', 'http://www.qhd.com.cn/', 0, 0, 0, 4052, 0, 1, 0, NULL, 11, '', ''),
(3026, '1289787168', '城北网', 'http://www.cityheb.com/', 0, 0, 0, 4052, 0, 1, 0, NULL, 12, '', ''),
(3027, '1289787168', '唐山热线', 'http://www.tsee.net/', 0, 0, 0, 4052, 0, 1, 0, NULL, 13, '', ''),
(3028, '1289787168', '河北电视台', 'http://www.hebtv.com/', 0, 0, 0, 4052, 0, 1, 0, NULL, 14, '', ''),
(3029, '1289787168', '邯郸新闻网', 'http://www.handannews.com.cn/', 0, 0, 0, 4052, 0, 1, 0, NULL, 15, '', ''),
(3030, '1289787168', '河北广播网', 'http://www.hebradio.com/', 0, 0, 0, 4052, 0, 1, 0, NULL, 16, '', ''),
(3031, '1289787168', '酷酷石家庄', 'http://www.qqsjz.com/', 0, 0, 0, 4052, 0, 1, 0, NULL, 17, '', ''),
(3032, '1289787168', '人民网河北频道', 'http://he.people.com.cn/', 0, 0, 0, 4052, 0, 1, 0, NULL, 18, '', ''),
(3033, '1289787168', '新华网河北频道', 'http://www.he.xinhuanet.com/', 0, 0, 0, 4052, 0, 1, 0, NULL, 19, '', ''),
(3034, '1289787186', '中国印染网', 'http://www.china-dyeing.com', 0, 0, 0, 4362, 0, 1, 0, NULL, 1, '', ''),
(3035, '1289787186', '中国印染资讯', 'http://www.sinodf.com', 0, 0, 0, 4362, 0, 1, 0, NULL, 2, '', ''),
(3036, '1289787186', '中国印染行业协会', 'http://www.cdpa.org.cn', 0, 0, 0, 4362, 0, 1, 0, NULL, 3, '', ''),
(3037, '1289787186', '华夏印染网', 'http://www.cndye.net', 0, 0, 0, 4362, 0, 1, 0, NULL, 4, '', ''),
(3038, '1289787186', '中国印染网', 'http://www.chinayinran.com/', 0, 0, 0, 4362, 0, 1, 0, NULL, 5, '', ''),
(3039, '1289787186', '中国印染网', 'http://www.cnyrw.com/', 0, 0, 0, 4362, 0, 1, 0, NULL, 6, '', ''),
(3040, '1289787186', '中国印染化学品网', 'http://www.printingadd.com/', 0, 0, 0, 4362, 0, 1, 0, NULL, 7, '', ''),
(3041, '1289787186', '中华印染网', 'http://www.yrzx.net/', 0, 0, 0, 4362, 0, 1, 0, NULL, 8, '', ''),
(3042, '1289787206', '中国皮具网', 'http://www.piju.com.cn/', 0, 0, 0, 4363, 0, 1, 0, NULL, 1, '', ''),
(3043, '1289787206', '慧聪皮革网', 'http://www.leather.hc360.com/', 0, 0, 0, 4363, 0, 1, 0, NULL, 2, '', ''),
(3044, '1289787206', '中国皮革工业', 'http://leather.clii.com.cn/', 0, 0, 0, 4363, 0, 1, 0, NULL, 3, '', ''),
(3045, '1289787206', '世界皮革网', 'http://www.world-leather.net', 0, 0, 0, 4363, 0, 1, 0, NULL, 4, '', ''),
(3046, '1289787206', '中国皮革交易网', 'http://www.sinoleather.com', 0, 0, 0, 4363, 0, 1, 0, NULL, 5, '', ''),
(3047, '1289787206', '中国皮革资讯网', 'http://www.china-leather.com', 0, 0, 0, 4363, 0, 1, 0, NULL, 6, '', ''),
(3048, '1289787206', '中国合成皮革网', 'http://www.synthleather.com', 0, 0, 0, 4363, 0, 1, 0, NULL, 7, '', ''),
(3049, '1289787206', '中华服装网-皮革服装', 'http://www.51fashion.com.cn/51AreaLeather/', 0, 0, 0, 4363, 0, 1, 0, NULL, 8, '', ''),
(3050, '1289787210', '福彩', 'http://www.yzfcw.com/', 0, 0, 0, 4053, 0, 1, 0, NULL, 1, '', ''),
(3051, '1289787210', '体彩', 'http://www.hbtcw.com/', 0, 0, 0, 4053, 0, 1, 0, NULL, 2, '', ''),
(3052, '1289787210', '移动', 'http://www.he.10086.cn/', 0, 0, 0, 4053, 0, 1, 0, NULL, 3, '', ''),
(3053, '1289787210', '联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?id=&amp;amp;arno=00010025', 0, 0, 0, 4053, 0, 1, 0, NULL, 4, '', ''),
(3054, '1289787210', '电信', 'http://www.hbtele.com/', 0, 0, 0, 4053, 0, 1, 0, NULL, 5, '', ''),
(3055, '1289787210', '邮政', 'http://www.hepost.com/', 0, 0, 0, 4053, 0, 1, 0, NULL, 6, '', ''),
(3056, '1289787210', '河北银行', 'http://www.sccb.com.cn/', 0, 0, 0, 4053, 0, 1, 0, NULL, 7, '', ''),
(3057, '1289787210', '专家门诊', 'http://hebei.haodf.com/', 0, 0, 0, 4053, 0, 1, 0, NULL, 8, '', ''),
(3058, '1289787210', '石家庄都市网', 'http://www.sjzcity.com/', 0, 0, 0, 4053, 0, 1, 0, NULL, 9, '', ''),
(3059, '1289787229', '中国绣花网', 'http://www.emb163.com/', 0, 0, 0, 4364, 0, 1, 0, NULL, 1, '', ''),
(3060, '1289787229', '联科绣花网', 'http://www.linkgd.com/', 0, 0, 0, 4364, 0, 1, 0, NULL, 2, '', ''),
(3061, '1289787229', '联科刺绣网', 'http://www.linkemb.com', 0, 0, 0, 4364, 0, 1, 0, NULL, 3, '', ''),
(3062, '1289787269', '中国绸都网', 'http://www.silkcapital.com', 0, 0, 0, 4365, 0, 1, 0, NULL, 1, '', ''),
(3063, '1289787269', '中国茧丝绸交易市场', 'http://www.esilk.net', 0, 0, 0, 4365, 0, 1, 0, NULL, 2, '', ''),
(3064, '1289787269', '中国丝绸网', 'http://www.china-4.com/', 0, 0, 0, 4365, 0, 1, 0, NULL, 3, '', ''),
(3065, '1289787269', '中国丝绸信息网', 'http://www.cnsilk.cn/', 0, 0, 0, 4365, 0, 1, 0, NULL, 4, '', ''),
(3066, '1289787269', '中国纺织网', 'http://www.texnet.com.cn/', 0, 0, 0, 4365, 0, 1, 0, NULL, 5, '', ''),
(3067, '1289787269', '中国茧丝绸信息网', 'http://www.silk-e.org/', 0, 0, 0, 4365, 0, 1, 0, NULL, 6, '', ''),
(3068, '1289787269', '丝绸集团股份', 'http://www.shsilktech.com', 0, 0, 0, 4365, 0, 1, 0, NULL, 7, '', ''),
(3069, '1289787269', '慧聪丝印特印网', 'http://www.screen.hc360.com', 0, 0, 0, 4365, 0, 1, 0, NULL, 8, '', ''),
(3070, '1289787269', '中国丝绸进出口公司', 'http://www.chinasilk.com/', 0, 0, 0, 4365, 0, 1, 0, NULL, 9, '', ''),
(3071, '1289787269', '中国丝绸博物馆', 'http://www.chinasilkmuseum.com/', 0, 0, 0, 4365, 0, 1, 0, NULL, 10, '', ''),
(3072, '1289787286', '河北大学', 'http://www.hbu.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 1, '', ''),
(3073, '1289787286', '燕山大学', 'http://www.ysu.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 2, '', ''),
(3074, '1289787286', '河北工业大学', 'http://www.hebut.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 3, '', ''),
(3075, '1289787286', '防灾科技学院', 'http://www.fzxy.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 4, '', ''),
(3076, '1289787286', '河北师范大学', 'http://www.hebtu.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 5, '', ''),
(3077, '1289787286', '河北医科大学', 'http://www.hebmu.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 6, '', ''),
(3078, '1289787286', '河北农业大学', 'http://www.hebau.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 7, '', ''),
(3079, '1289787286', '河北科技大学', 'http://www.hebust.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 8, '', ''),
(3080, '1289787286', '河北理工大学', 'http://www.heut.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 9, '', ''),
(3081, '1289787286', '河北经贸大学', 'http://www.heuet.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 10, '', ''),
(3082, '1289787286', '石家庄经济学院', 'http://www.sjzue.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 11, '', ''),
(3083, '1289787286', '华北煤炭医学院', 'http://2010.ncmc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 12, '', ''),
(3084, '1289787286', '河北工业职业技术学院', 'http://www.hbcit.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 13, '', ''),
(3085, '1289787286', '河北工程技术高等专科学校', 'http://www.hbgz.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 14, '', ''),
(3086, '1289787286', '河北工程大学', 'http://www.hebeu.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 15, '', ''),
(3087, '1289787286', '河北民族师范学院', 'http://www.hbun.net/', 0, 0, 0, 4054, 0, 1, 0, NULL, 16, '', ''),
(3088, '1289787286', '河北传媒学院', 'http://www.hebic.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 17, '', ''),
(3089, '1289787286', '河北石油职业技术学院', 'http://www.pvtc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 18, '', ''),
(3090, '1289787286', '唐山工业职业技术学院', 'http://www.tsgzy.com.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 19, '', ''),
(3091, '1289787286', '中国人民武装警察部队学院', 'http://www.wjxy.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 20, '', ''),
(3092, '1289787286', '河北体育学院', 'http://www.hepec.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 21, '', ''),
(3093, '1289787286', '唐山师范学院', 'http://www.tstc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 22, '', ''),
(3094, '1289787286', '石家庄信息工程职业学院', 'http://www.sjziei.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 23, '', ''),
(3095, '1289787286', '邢台学院', 'http://www.xttc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 24, '', ''),
(3096, '1289787286', '石家庄职业技术学院', 'http://www.sjzpt.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 25, '', ''),
(3097, '1289787286', '河北金融学院', 'http://www.bdcf.net/', 0, 0, 0, 4054, 0, 1, 0, NULL, 26, '', ''),
(3098, '1289787286', '河北旅游职业学院', 'http://www.cdtvc.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 27, '', ''),
(3099, '1289787286', '华北科技学院', 'http://www.ncist.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 28, '', ''),
(3100, '1289787286', '保定学院', 'http://www.bdu.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 29, '', ''),
(3101, '1289787286', '河北建筑工程学院', 'http://www.hebiace.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 30, '', ''),
(3102, '1289787286', '石家庄铁道大学', 'http://www.sjzri.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 31, '', ''),
(3103, '1289787286', '保定职业技术学院', 'http://www.bvtc.com.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 32, '', ''),
(3104, '1289787286', '中央司法警官学院', 'http://www.cicp.edu.cn/200506/index.htm', 0, 0, 0, 4054, 0, 1, 0, NULL, 33, '', ''),
(3105, '1289787286', '衡水学院', 'http://www.hsnc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 34, '', ''),
(3106, '1289787286', '唐山学院', 'http://www.tsc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 35, '', ''),
(3107, '1289787286', '邢台职业技术学院', 'http://www.xpc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 36, '', ''),
(3108, '1289787286', '中国地质大学长城学院', 'http://www.cuggw.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 37, '', ''),
(3109, '1289787286', '石家庄学院', 'http://www.sjzc.edu.cn', 0, 0, 0, 4054, 0, 1, 0, NULL, 38, '', ''),
(3110, '1289787286', '北华航天工业学院', 'http://www.nciae.edu.cn', 0, 0, 0, 4054, 0, 1, 0, NULL, 39, '', ''),
(3111, '1289787286', '承德石油高等专科学校', 'http://www.cdpc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 40, '', ''),
(3112, '1289787286', '河北软件职业技术学院', 'http://www.hbsi.com.cn', 0, 0, 0, 4054, 0, 1, 0, NULL, 41, '', ''),
(3113, '1289787286', '石家庄法商职业学院', 'http://www.hbfsh.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 42, '', ''),
(3114, '1289787286', '邢台医学专科高等学校', 'http://www.xtmc.net', 0, 0, 0, 4054, 0, 1, 0, NULL, 43, '', ''),
(3115, '1289787286', '石家庄理工职业学院', 'http://i789.he.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 44, '', ''),
(3116, '1289787286', '廊坊师范学院', 'http://www.lfsfxy.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 45, '', ''),
(3117, '1289787286', '承德医学院', 'http://www.cdmc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 46, '', ''),
(3118, '1289787286', '河北科技师范学院', 'http://www.hevttc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 47, '', ''),
(3119, '1289787286', '沧州师范学院', 'http://www.caztc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 48, '', ''),
(3120, '1289787286', '河北北方学院', 'http://www.hebeinu.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 49, '', ''),
(3121, '1289787286', '河北化工医药职业技术学院', 'http://www.hebcpc.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 50, '', ''),
(3122, '1289787286', '邯郸学院', 'http://www.hdc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 51, '', ''),
(3123, '1289787286', '沧州医学高等专科学校', 'http://www.czmc.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 52, '', ''),
(3124, '1289787286', '石家庄医学高等专科学校', 'http://www.sjzmc.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 53, '', ''),
(3125, '1289787286', '石家庄人民医学高等专科学校', 'http://www.sjzrmyz.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 54, '', ''),
(3126, '1289787286', '沧州职业技术学院', 'http://www.czvtc.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 55, '', ''),
(3127, '1289787286', '石家庄铁路职业技术学院', 'http://www.sirt.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 56, '', ''),
(3128, '1289787286', '张家口职业技术学院', 'http://www.zhz.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 57, '', ''),
(3129, '1289787286', '河北能源职业技术学院', 'http://www.hbnyxy.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 58, '', ''),
(3130, '1289787286', '邯郸职业技术学院', 'http://www.hd-u.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 59, '', ''),
(3131, '1289787286', '石家庄计算机职业学院', 'http://www.sjzcvc.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 60, '', ''),
(3132, '1289787286', '河北建材职业技术学院', 'http://www.hbjcxy.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 61, '', ''),
(3133, '1289787286', '石家庄邮电职业技术学院', 'http://www.sjzpc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 62, '', ''),
(3134, '1289787286', '河北女子职业技术学院', 'http://www.hebnzxy.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 63, '', ''),
(3135, '1289787286', '泊头职业学院', 'http://222.223.57.197:8080/', 0, 0, 0, 4054, 0, 1, 0, NULL, 64, '', ''),
(3136, '1289787286', '渤海石油职业学院', 'http://www.bhsyxy.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 65, '', ''),
(3137, '1289787286', '唐山科技职业技术学院', 'http://www.tskjzy.cn/index.do?templet=index', 0, 0, 0, 4054, 0, 1, 0, NULL, 66, '', ''),
(3138, '1289787286', '河北机电职业技术学院', 'http://www.hbjd.com.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 67, '', ''),
(3139, '1289787286', '保定电力职业技术学院', 'http://www.bddy.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 68, '', ''),
(3140, '1289787286', '廊坊职业技术学院', 'http://www.lfzhjxy.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 69, '', ''),
(3141, '1289787286', '石家庄科技工程职业学院', 'http://www.zdsf.net/', 0, 0, 0, 4054, 0, 1, 0, NULL, 70, '', ''),
(3142, '1289787286', '冀中职业学院', 'http://www.jzhxy.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 71, '', ''),
(3143, '1289787286', '石家庄外事职业学院', 'http://www.wsxy.net/', 0, 0, 0, 4054, 0, 1, 0, NULL, 72, '', ''),
(3144, '1289787286', '河北政法职业学院', 'http://www.helc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 73, '', ''),
(3145, '1289787286', '河北公安警察职业学院', 'http://www.hebsjy.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 74, '', ''),
(3146, '1289787286', '廊坊东方职业技术学院', 'http://www.dfzyxy.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 75, '', ''),
(3147, '1289787286', '河北省艺术职业学院', 'http://www.hebart.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 76, '', ''),
(3148, '1289787286', '宣化科技职业学院', 'http://www.xhkjzyxy.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 77, '', ''),
(3149, '1289787286', '石家庄东方美术职业学院', 'http://www.oafa.com.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 78, '', ''),
(3150, '1289787286', '石家庄外经贸职业学院', 'http://www.sjzwjm.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 79, '', ''),
(3151, '1289787286', '河北交通职业技术学院', 'http://www.hejtxy.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 80, '', ''),
(3152, '1289787286', '河北外国语职业学院', 'http://www.hbvcfl.com.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 81, '', ''),
(3153, '1289787286', '石家庄科技职业学院', 'http://www.sjzkjxy.net/', 0, 0, 0, 4054, 0, 1, 0, NULL, 82, '', ''),
(3154, '1289787286', '河北司法警官职业学院', 'http://www.jjgxy.com.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 83, '', ''),
(3155, '1289787286', '河北劳动关系职业学院', 'http://www.hbgy.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 84, '', ''),
(3156, '1289787286', '秦皇岛职业技术学院', 'http://www.qhdvtc.com/hbzj/index.jsp', 0, 0, 0, 4054, 0, 1, 0, NULL, 85, '', ''),
(3157, '1289787286', '石家庄外国语职业学院', 'http://www.sjzwgyxy.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 86, '', ''),
(3158, '1289787286', '唐山职业技术学院', 'http://www.tsvtc.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 87, '', ''),
(3159, '1289787286', '保定科技职业学院', 'http://www.hbkjxy.cn/xsnews/kj_sy.asp', 0, 0, 0, 4054, 0, 1, 0, NULL, 88, '', ''),
(3160, '1289787286', '石家庄外语翻译职业学院', 'http://www.hbwy.com.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 89, '', ''),
(3161, '1289787286', '石家庄工商职业学院', 'http://www.sjzgsxy.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 90, '', ''),
(3162, '1289787286', '廊坊燕京职业技术学院', 'http://www.lfyjzjxy.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 91, '', ''),
(3163, '1289787286', '承德护理职业学院', 'http://www.cdwx.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 92, '', ''),
(3164, '1289787286', '河北理工大学轻工学院', 'http://qgxy.heut.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 93, '', ''),
(3165, '1289787286', '河北工程大学科信学院', 'http://kexin.hebeu.edu.cn/default.asp', 0, 0, 0, 4054, 0, 1, 0, NULL, 94, '', ''),
(3166, '1289787286', '华北电力大学科技学院', 'http://www.hdky.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 95, '', ''),
(3167, '1289787286', '河北科技大学理工学院', 'http://hbklg.hebust.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 96, '', ''),
(3168, '1289787286', '河北大学工商学院', 'http://www.hicc.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 97, '', ''),
(3169, '1289787286', '河北师范大学汇华学院', 'http://huihua.hebtu.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 98, '', ''),
(3170, '1289787286', '河北医科大学临床学院', 'http://202.206.48.102/', 0, 0, 0, 4054, 0, 1, 0, NULL, 99, '', ''),
(3171, '1289787286', '河北经贸大学经济管理学院', 'http://202.206.206.251/', 0, 0, 0, 4054, 0, 1, 0, NULL, 100, '', ''),
(3172, '1289787286', '河北工业大学城市学院', 'http://cc.hebut.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 101, '', ''),
(3173, '1289787286', '燕山大学里仁学院', 'http://stc.ysu.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 102, '', ''),
(3174, '1289787286', '石家庄铁道大学四方学院', 'http://sfxy.sjzri.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 103, '', ''),
(3175, '1289787286', '华北煤炭医学院冀唐学院', 'http://jitang.ncmc.edu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 104, '', ''),
(3176, '1289787286', '北京化工大学北方学院', 'http://www.buctedu.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 105, '', ''),
(3177, '1289787286', '北京中医药大学东方学院', 'http://www.df-college.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 106, '', ''),
(3178, '1289787286', '河北地质职工大学', 'http://www.dkyaolan.com/', 0, 0, 0, 4054, 0, 1, 0, NULL, 107, '', ''),
(3179, '1289787286', '张家口教育学院', 'http://www.zjkjyxy.cn/', 0, 0, 0, 4054, 0, 1, 0, NULL, 108, '', ''),
(3180, '1289787286', '河北青年管理干部学院', 'http://www.hbqgy.cn/index.php', 0, 0, 0, 4054, 0, 1, 0, NULL, 109, '', ''),
(3181, '1289787286', '中国环境管理干部学院', 'http://www.emcc.cn/web/', 0, 0, 0, 4054, 0, 1, 0, NULL, 110, '', ''),
(3182, '1289787296', '中国棉花网', 'http://www.cncotton.com', 0, 0, 0, 4366, 0, 1, 0, NULL, 1, '', ''),
(3183, '1289787296', '中国棉花信息网', 'http://www.cottonchina.org', 0, 0, 0, 4366, 0, 1, 0, NULL, 2, '', ''),
(3184, '1289787296', '中国棉花企业网', 'http://www.cncew.com/', 0, 0, 0, 4366, 0, 1, 0, NULL, 3, '', ''),
(3185, '1289787296', '中国棉纺织信息网', 'http://www.tteb.com', 0, 0, 0, 4366, 0, 1, 0, NULL, 4, '', ''),
(3186, '1289787296', '中国棉花交易网', 'http://www.socotton.com/', 0, 0, 0, 4366, 0, 1, 0, NULL, 5, '', ''),
(3187, '1289787296', '中国棉花协会', 'http://www.china-cotton.org', 0, 0, 0, 4366, 0, 1, 0, NULL, 6, '', ''),
(3188, '1289787312', '唐山论坛', 'http://bbs.xintang.cn/', 0, 0, 0, 4055, 0, 1, 1300673762, NULL, 1, '', ''),
(3189, '1289787312', '辛集社区', 'http://www.xinji.org/', 0, 0, 0, 4055, 0, 1, 0, NULL, 2, '', ''),
(3190, '1289787312', '河北贴吧', 'http://tieba.baidu.com/f?kw=%BA%D3%B1%B1', 0, 0, 0, 4055, 0, 1, 0, NULL, 3, '', ''),
(3191, '1289787312', '石家庄贴吧', 'http://tieba.baidu.com/f?kw=%CA%AF%BC%D2%D7%AF', 0, 0, 0, 4055, 0, 1, 0, NULL, 4, '', ''),
(3192, '1289787312', '沧州论坛', 'http://www.czqq.com/', 0, 0, 0, 4055, 0, 1, 0, NULL, 5, '', ''),
(3193, '1289787312', '玉田论坛', 'http://bbs.yutian.gov.cn/', 0, 0, 0, 4055, 0, 1, 0, NULL, 6, '', ''),
(3194, '1289787312', '遵化论坛', 'http://bbs.zunhua.org/', 0, 0, 0, 4055, 0, 1, 0, NULL, 7, '', ''),
(3195, '1289787312', '永年论坛', 'http://bbs.ynian.com/', 0, 0, 0, 4055, 0, 1, 0, NULL, 8, '', ''),
(3196, '1289787312', '廊坊大众论坛', 'http://www.lfluntan.com/', 0, 0, 0, 4055, 0, 1, 0, NULL, 9, '', ''),
(3197, '1289787312', '大众论坛', 'http://xinxi.renmin.cc/', 0, 0, 0, 4055, 0, 1, 0, NULL, 10, '', ''),
(3198, '1289787312', '石家庄论坛', 'http://www.sjzbbs.com/', 0, 0, 0, 4055, 0, 1, 0, NULL, 11, '', ''),
(3199, '1289787312', '秦皇岛论坛', 'http://www.qhdok.com/', 0, 0, 0, 4055, 0, 1, 0, NULL, 12, '', ''),
(3200, '1289787312', '巨鹿论坛', 'http://www.juluren.com/', 0, 0, 0, 4055, 0, 1, 0, NULL, 13, '', ''),
(3201, '1289787312', '二亩地', 'http://www.ermudi.com/', 0, 0, 0, 4055, 0, 1, 0, NULL, 14, '', ''),
(3202, '1289787320', '中华纺织网', 'http://www.cntexnet.com', 0, 0, 0, 4367, 0, 1, 0, NULL, 1, '', ''),
(3203, '1289787320', '中国纺织网', 'http://www.texnet.com.cn/', 0, 0, 0, 4367, 0, 1, 0, NULL, 2, '', ''),
(3204, '1289787320', '中纤咨询', 'http://www.ccf.com.cn', 0, 0, 0, 4367, 0, 1, 0, NULL, 3, '', ''),
(3205, '1289787320', '中国针织网', 'http://www.eck.com.cn/', 0, 0, 0, 4367, 0, 1, 0, NULL, 4, '', ''),
(3206, '1289787320', '中国化纤经济信息网', 'http://www.ccfei.com/', 0, 0, 0, 4367, 0, 1, 0, NULL, 5, '', ''),
(3207, '1289787320', '中国纺织经济信息网', 'http://cn.cntextile.com/', 0, 0, 0, 4367, 0, 1, 0, NULL, 6, '', ''),
(3208, '1289787320', '中纺织品进出口商会', 'http://www.ccct.org.cn/', 0, 0, 0, 4367, 0, 1, 0, NULL, 7, '', ''),
(3209, '1289787320', '中国家纺信息网', 'http://www.hometextiles.cn/', 0, 0, 0, 4367, 0, 1, 0, NULL, 8, '', ''),
(3210, '1289787320', '中国纺织科学研究院', 'http://www.cta.com.cn', 0, 0, 0, 4367, 0, 1, 0, NULL, 9, '', ''),
(3211, '1289787320', '中国纱线网', 'http://www.zgsxw.com', 0, 0, 0, 4367, 0, 1, 0, NULL, 10, '', ''),
(3212, '1289787320', '中华家纺网', 'http://www.hometex114.com', 0, 0, 0, 4367, 0, 1, 0, NULL, 11, '', ''),
(3213, '1289787320', '网上轻纺城', 'http://www.qfc.cn', 0, 0, 0, 4367, 0, 1, 0, NULL, 12, '', ''),
(3214, '1289787320', '中国家纺网', 'http://www.hometexnet.com', 0, 0, 0, 4367, 0, 1, 0, NULL, 13, '', ''),
(3215, '1289787320', '全球纺织网', 'http://www.tnc.com.cn/', 0, 0, 0, 4367, 0, 1, 0, NULL, 14, '', ''),
(3216, '1289787320', '纺织经理人', 'http://textile.icxo.com/', 0, 0, 0, 4367, 0, 1, 0, NULL, 15, '', ''),
(3217, '1289787320', '锦桥纺织网', 'http://www.sinotex.cn/', 0, 0, 0, 4367, 0, 1, 0, NULL, 16, '', ''),
(3218, '1289787320', '慧聪纺织网', 'http://www.textile.hc360.com/', 0, 0, 0, 4367, 0, 1, 0, NULL, 17, '', ''),
(3219, '1289787339', '发改委', 'http://www.hbdrc.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 1, '', ''),
(3220, '1289787339', '教育厅', 'http://www.hee.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 2, '', ''),
(3221, '1289787339', '旅游局', 'http://www.hebeitour.com.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 3, '', ''),
(3222, '1289787339', '司法厅', 'http://www.hbfz.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 4, '', ''),
(3223, '1289787339', '财政厅', 'http://www.hebcz.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 5, '', ''),
(3224, '1289787339', '交通运输厅', 'http://www.hbsjtt.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 6, '', ''),
(3225, '1289787339', '住房和城乡建设厅', 'http://www.hebjs.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 7, '', ''),
(3226, '1289787339', '农业厅', 'http://www.heagri.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 8, '', ''),
(3227, '1289787339', '卫生厅', 'http://www.hebwst.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 9, '', ''),
(3228, '1289787339', '体育局', 'http://www.hebsport.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 10, '', ''),
(3229, '1289787339', '知识产权局', 'http://www.hebipo.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 11, '', ''),
(3230, '1289787339', '地方税务局', 'http://www.hebds.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 12, '', ''),
(3231, '1289787339', '承德市', 'http://www.chengde.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 13, '', ''),
(3232, '1289787339', '秦皇岛市', 'http://www.qhd.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 14, '', ''),
(3233, '1289787339', '廊坊市', 'http://www.lf.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 15, '', ''),
(3234, '1289787339', '保定市', 'http://www.bd.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 16, '', ''),
(3235, '1289787339', '沧州市', 'http://www.cangzhou.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 17, '', ''),
(3236, '1289787339', '衡水市', 'http://www.hengshui.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 18, '', ''),
(3237, '1289787339', '邢台市', 'http://www.xingtai.gov.cn/', 0, 0, 0, 4056, 0, 1, 1298205204, NULL, 19, '', ''),
(3238, '1289787339', '邯郸市', 'http://www.hd.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 20, '', ''),
(3239, '1289787339', '张家口市', 'http://www.zjk.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 21, '', ''),
(3240, '1289787339', '唐山市', 'http://www.tangshan.gov.cn/', 0, 0, 0, 4056, 0, 1, 0, NULL, 22, '', ''),
(3241, '1289787358', '中国图书出版网', 'http://www.bkpcn.com/', 0, 0, 0, 4368, 0, 1, 0, NULL, 1, '', ''),
(3242, '1289787358', '中国印刷出版门户', 'http://www.bisenet.com/', 0, 0, 0, 4368, 0, 1, 0, NULL, 2, '', ''),
(3243, '1289787358', '中国出版网', 'http://www.chuban.cc/', 0, 0, 0, 4368, 0, 1, 0, NULL, 3, '', ''),
(3244, '1289787358', '中国新闻出版网', 'http://www.chinaxwcb.com/index/index.htm', 0, 0, 0, 4368, 0, 1, 0, NULL, 4, '', ''),
(3245, '1289787358', '中国互动出版社', 'http://www.china-pub.com/', 0, 0, 0, 4368, 0, 1, 0, NULL, 5, '', ''),
(3246, '1289787358', '慧聪印刷网', 'http://www.printing.hc360.com', 0, 0, 0, 4368, 0, 1, 0, NULL, 6, '', ''),
(3247, '1289787358', '新华书店', 'http://p.yiqifa.com/c?s=caeb6778&w=220184&c=299&i=188&l=0&e=c&t=http://www.xinhuabookstore.com', 0, 0, 0, 4368, 0, 1, 0, NULL, 7, '', ''),
(3248, '1289787358', '图书交易网', 'http://www.bookb2b.com', 0, 0, 0, 4368, 0, 1, 0, NULL, 8, '', ''),
(3249, '1289787358', '自费出书', 'http://www.chushu168.com/', 0, 0, 0, 4368, 0, 1, 0, NULL, 9, '', ''),
(3250, '1289787358', '集萃印花网', 'http://www.ccedpw.com', 0, 0, 0, 4368, 0, 1, 0, NULL, 10, '', ''),
(3251, '1289787382', '中国包装网', 'http://www.pack.net.cn', 0, 0, 0, 4369, 0, 1, 0, NULL, 1, '', ''),
(3252, '1289787382', '中华印刷包装网', 'http://www.cpp114.com', 0, 0, 0, 4369, 0, 1, 0, NULL, 2, '', ''),
(3253, '1289787382', '中国纸业网', 'http://www.chinapaper.net', 0, 0, 0, 4369, 0, 1, 0, NULL, 3, '', ''),
(3254, '1289787382', '中国纸网', 'http://www.paper.com.cn', 0, 0, 0, 4369, 0, 1, 0, NULL, 4, '', ''),
(3255, '1289787382', '慧聪纸业网', 'http://www.paper.hc360.com', 0, 0, 0, 4369, 0, 1, 0, NULL, 5, '', ''),
(3256, '1289787382', '中国包装设计网', 'http://www.chndesign.com', 0, 0, 0, 4369, 0, 1, 0, NULL, 6, '', ''),
(3257, '1289787382', '中国包装报', 'http://www.cpackage.com', 0, 0, 0, 4369, 0, 1, 0, NULL, 7, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(3258, '1289787382', '东北印刷包装网', 'http://www.adprint.com.cn', 0, 0, 0, 4369, 0, 1, 0, NULL, 8, '', ''),
(3259, '1289787382', '华印包装网', 'http://www.a1pak.com/', 0, 0, 0, 4369, 0, 1, 0, NULL, 9, '', ''),
(3761, '1289787970', '移动', 'http://www.jl.10086.cn/', 0, 0, 0, 4083, 0, 1, 0, NULL, 2, '', ''),
(3760, '1289787970', '福彩', 'http://www.jilintz.com/', 0, 0, 0, 4083, 0, 1, 0, NULL, 1, '', ''),
(3263, '1289787438', '晋城在线', 'http://www.jconline.cn/', 0, 0, 0, 4061, 0, 1, 0, NULL, 1, '', ''),
(3264, '1289787438', '阳泉信息港', 'http://www.yq.sx.cninfo.net/', 0, 0, 0, 4061, 0, 1, 0, NULL, 2, '', ''),
(3265, '1289787438', '大同热线', 'http://www.dtrx.cn/', 0, 0, 0, 4061, 0, 1, 0, NULL, 3, '', ''),
(3266, '1289787438', '龙城热线', 'http://www.ty.sx.cn/', 0, 0, 0, 4061, 0, 1, 0, NULL, 4, '', ''),
(3267, '1289787443', '中国工艺网', 'http://www.cgy.cn/', 0, 0, 0, 4371, 0, 1, 0, NULL, 1, '', ''),
(3268, '1289787443', '中华玉网', 'http://www.jades.cn/', 0, 0, 0, 4371, 0, 1, 0, NULL, 2, '', ''),
(3269, '1289787443', '中国工艺品信息网', 'http://www.craftschina.net', 0, 0, 0, 4371, 0, 1, 0, NULL, 3, '', ''),
(3270, '1289787443', '慧聪网-礼品工艺品', 'http://www.gift.hc360.com/', 0, 0, 0, 4371, 0, 1, 0, NULL, 4, '', ''),
(3271, '1289787443', '全球饰品网', 'http://www.52sp.com/', 0, 0, 0, 4371, 0, 1, 0, NULL, 5, '', ''),
(3272, '1289787443', '中国饰品加盟在线', 'http://www.sp.jmw.com.cn/', 0, 0, 0, 4371, 0, 1, 0, NULL, 6, '', ''),
(3273, '1289787443', '联科绣花网', 'http://www.linkgd.com/', 0, 0, 0, 4371, 0, 1, 0, NULL, 7, '', ''),
(3274, '1289787443', '21世纪珠宝网', 'http://www.21gem.net/', 0, 0, 0, 4371, 0, 1, 0, NULL, 8, '', ''),
(3275, '1289787443', '银饰品批发网', 'http://www.1925.cn/', 0, 0, 0, 4371, 0, 1, 0, NULL, 9, '', ''),
(3276, '1289787443', '紫艺网', 'http://www.zsgy.com/', 0, 0, 0, 4371, 0, 1, 0, NULL, 10, '', ''),
(3277, '1289787443', '中国钟表网', 'http://www.chinawatchnet.com/', 0, 0, 0, 4371, 0, 1, 0, NULL, 11, '', ''),
(3278, '1289787443', '中国眼镜网', 'http://www.glasses.com.cn', 0, 0, 0, 4371, 0, 1, 0, NULL, 12, '', ''),
(3279, '1289787443', '中国假发网', 'http://www.51wig.com', 0, 0, 0, 4371, 0, 1, 0, NULL, 13, '', ''),
(3280, '1289787443', '中国水晶网', 'http://www.chinashuijing.com', 0, 0, 0, 4371, 0, 1, 0, NULL, 14, '', ''),
(3281, '1289787443', '中国伞网', 'http://www.3to3.com/', 0, 0, 0, 4371, 0, 1, 0, NULL, 15, '', ''),
(3282, '1289787443', '纸艺网', 'http://www.zhidiy.com', 0, 0, 0, 4371, 0, 1, 0, NULL, 16, '', ''),
(3283, '1279617741', '中国乐器网', 'http://www.yueqi.com/', 0, 0, 0, 3048, 0, 1, 0, NULL, 1, '', ''),
(3284, '1279617741', '中华乐器网', 'http://www.cyueqi.com/', 0, 0, 0, 3048, 0, 1, 0, NULL, 2, '', ''),
(3285, '1279617741', '中国口琴音乐网', 'http://www.chinaharp.com/', 0, 0, 0, 3048, 0, 1, 0, NULL, 3, '', ''),
(3286, '1279617741', '中国提琴网', 'http://www.cnstrad.com/', 0, 0, 0, 3048, 0, 1, 0, NULL, 4, '', ''),
(3287, '1279617741', '中国古筝音乐网', 'http://www.51zheng.com/', 0, 0, 0, 3048, 0, 1, 0, NULL, 5, '', ''),
(3288, '1279617741', '中国二胡网', 'http://www.erhuchina.com/', 0, 0, 0, 3048, 0, 1, 0, NULL, 6, '', ''),
(3289, '1279617741', '民乐网', 'http://www.minyue123.com', 0, 0, 0, 3048, 0, 1, 0, NULL, 7, '', ''),
(3290, '1279617741', '中国二胡艺术网', 'http://www.erhuart.cn', 0, 0, 0, 3048, 0, 1, 0, NULL, 8, '', ''),
(3291, '1279617741', '虫虫吉他谱', 'http://www.ccjt.net/', 0, 0, 0, 3048, 0, 1, 0, NULL, 9, '', ''),
(3292, '1279617741', '搜谱网', 'http://www.sooopu.com/', 0, 0, 0, 3048, 0, 1, 0, NULL, 10, '', ''),
(3293, '1279617741', '吉它谱', 'http://www.jitapu.com/', 0, 0, 0, 3048, 0, 1, 0, NULL, 11, '', ''),
(3294, '1279617741', '流行钢琴网', 'http://www.popiano.org/', 0, 0, 0, 3048, 0, 1, 0, NULL, 12, '', ''),
(3295, '1279617741', '星夜钢琴网', 'http://www.cpiano.com/', 0, 0, 0, 3048, 0, 1, 0, NULL, 13, '', ''),
(3296, '1279617741', '吉他中国', 'http://www.guitarchina.com', 0, 0, 0, 3048, 0, 1, 0, NULL, 14, '', ''),
(3297, '1279617741', '吉他星空', 'http://www.gtsky.com', 0, 0, 0, 3048, 0, 1, 0, NULL, 15, '', ''),
(3298, '1279617741', '弈天棋缘', 'http://www.movesky.net/', 0, 0, 0, 3049, 0, 1, 0, NULL, 1, '', ''),
(3299, '1279617741', '中国象棋大师网', 'http://www.zgxqds.com/', 0, 0, 0, 3049, 0, 1, 0, NULL, 2, '', ''),
(3300, '1279617741', '搜狐棋牌', 'http://sports.sohu.com/qipai.shtml', 0, 0, 0, 3049, 0, 1, 0, NULL, 3, '', ''),
(3301, '1279617741', '东萍象棋网', 'http://www.dpxq.com/', 0, 0, 0, 3049, 0, 1, 0, NULL, 4, '', ''),
(3302, '1279617741', '新浪棋牌', 'http://sports.sina.com.cn/chess/', 0, 0, 0, 3049, 0, 1, 0, NULL, 5, '', ''),
(3303, '1279617741', '弈城围棋网', 'http://www.eweiqi.com/', 0, 0, 0, 3049, 0, 1, 0, NULL, 6, '', ''),
(3304, '1279617741', 'TOM棋圣道场', 'http://weiqi.sports.tom.com/', 0, 0, 0, 3049, 0, 1, 0, NULL, 7, '', ''),
(3305, '1279617741', '象棋巫师', 'http://www.xqbase.com/xqwizard/xqwizard.htm', 0, 0, 0, 3049, 0, 1, 0, NULL, 8, '', ''),
(3306, '1279617741', '百度书法图片', 'http://image.baidu.com/i?ct=201326592&cl=2&lm=-1&tn=baiduimage&pv=&z=0&word=%CA%E9%B7%A8&s=0', 0, 0, 0, 3050, 0, 1, 0, NULL, 1, '', ''),
(3307, '1279617741', '中国书画家网', 'http://www.shufa.org/', 0, 0, 0, 3050, 0, 1, 0, NULL, 2, '', ''),
(3308, '1279617741', '中国书法网', 'http://www.shufa.com/', 0, 0, 0, 3050, 0, 1, 0, NULL, 3, '', ''),
(3309, '1279617741', '中国篆刻论坛', 'http://bbs.zgzkw.com/', 0, 0, 0, 3050, 0, 1, 0, NULL, 4, '', ''),
(3310, '1279617741', '书法家论坛', 'http://bbs.china-shufajia.com/', 0, 0, 0, 3050, 0, 1, 0, NULL, 5, '', ''),
(3311, '1279617741', '中华诗词论坛', 'http://bbs.zhsc.net/', 0, 0, 0, 3050, 0, 1, 0, NULL, 6, '', ''),
(3312, '1279617741', '中国书画网', 'http://www.ltsf.com/', 0, 0, 0, 3050, 0, 1, 0, NULL, 7, '', ''),
(3313, '1279617741', '中国美术馆', 'http://www.namoc.org/', 0, 0, 0, 3050, 0, 1, 0, NULL, 8, '', ''),
(3314, '1279617741', '新华网书画频道', 'http://www.xinhuanet.com/shuhua/', 0, 0, 0, 3050, 0, 1, 0, NULL, 9, '', ''),
(3315, '1279617741', '书法网', 'http://www.freehead.com/', 0, 0, 0, 3050, 0, 1, 0, NULL, 10, '', ''),
(3316, '1279617741', '天涯金石书画', 'http://www.tianya.cn/new/TechForum/ArticlesList.asp?idWriter=0&Key=0&idItem=169', 0, 0, 0, 3050, 0, 1, 0, NULL, 11, '', ''),
(3317, '1279617741', '书法江湖', 'http://www.sf108.com/bbs/', 0, 0, 0, 3050, 0, 1, 0, NULL, 12, '', ''),
(3318, '1279617741', '新华网收藏', 'http://www.xinhuanet.com/collection/', 0, 0, 0, 3051, 0, 1, 0, NULL, 1, '', ''),
(3319, '1279617741', '集邮信息网', 'http://www.cpi.com.cn/', 0, 0, 0, 3051, 0, 1, 0, NULL, 2, '', ''),
(3320, '1279617741', 'CCTV寻宝', 'http://space.tv.cctv.com/podcast/jianbao', 0, 0, 0, 3051, 0, 1, 0, NULL, 3, '', ''),
(3321, '1279617741', '炒邮网', 'http://www.cjiyou.net/', 0, 0, 0, 3051, 0, 1, 0, NULL, 4, '', ''),
(3322, '1279617741', '龙之藏', 'http://www.lzc369.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 5, '', ''),
(3323, '1279617741', '上海文玩', 'http://www.feiqu.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 6, '', ''),
(3324, '1279617741', '盛世收藏', 'http://www.sssc.cn/', 0, 0, 0, 3051, 0, 1, 0, NULL, 7, '', ''),
(3325, '1279617741', '文玩天下', 'http://www.htchi.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 8, '', ''),
(3326, '1279617741', '中国收藏热线', 'http://www.997788.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 9, '', ''),
(3327, '1279617741', '中国奇石网论坛', 'http://bbs.qsw.cn/', 0, 0, 0, 3051, 0, 1, 0, NULL, 10, '', ''),
(3328, '1279617741', '中华古玩网', 'http://www.gucn.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 11, '', ''),
(3329, '1279617741', '泉友之家', 'http://www.coinabc.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 12, '', ''),
(3330, '1279617741', '雅昌艺术网', 'http://www.artron.net/', 0, 0, 0, 3051, 0, 1, 0, NULL, 13, '', ''),
(3331, '1279617741', '文玩八方', 'http://www.8fromchina.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 14, '', ''),
(3332, '1279617741', '兴趣与收藏目录', 'http://tieba.baidu.com/f?ct=536870912&sn=%CA%B1%C9%D0%D0%DD%CF%D0&bs=%D0%CB%C8%A4%D3%EB%CA%D5%B2%D8&rn=200&pn=0&cm=1101&tn=simpleCategory', 0, 0, 0, 3051, 0, 1, 0, NULL, 15, '', ''),
(3333, '1279617741', '藏龙网', 'http://bbs.a9188.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 16, '', ''),
(3334, '1279617741', '金币收藏网', 'http://www.51jb.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 17, '', ''),
(3335, '1279617741', '嘉德在线', 'http://www.artrade.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 18, '', ''),
(3336, '1279617741', '古泉园地', 'http://www.chcoin.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 19, '', ''),
(3337, '1279617741', '湘泉雅集', 'http://www.quancang.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 20, '', ''),
(3338, '1279617741', '奇石交易网', 'http://www.s1288.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 21, '', ''),
(3339, '1279617741', '中国古玩论坛', 'http://www.chineseantiques.com.cn/', 0, 0, 0, 3051, 0, 1, 0, NULL, 22, '', ''),
(3340, '1279617741', '雅昌艺术网论坛', 'http://bbs.artron.net/', 0, 0, 0, 3051, 0, 1, 0, NULL, 23, '', ''),
(3341, '1279617741', '中国收藏网', 'http://www.socang.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 24, '', ''),
(3342, '1279617741', '钱币天堂', 'http://www.coinsky.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 25, '', ''),
(3343, '1279617741', '华夏收藏网', 'http://www.mycollect.net/', 0, 0, 0, 3051, 0, 1, 0, NULL, 26, '', ''),
(3344, '1279617741', '博宝艺术网', 'http://www.artxun.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 27, '', ''),
(3345, '1279617741', '一尘网', 'http://www.xx007.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 28, '', ''),
(3346, '1279617741', '赵涌在线', 'http://www.zhaoonline.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 29, '', ''),
(3347, '1279617741', '天下收藏视频集锦', 'http://video.baidu.com/v?ct=301989888&rn=20&pn=0&db=0&s=8&word=%CC%EC%CF%C2%CA%D5%B2%D8&fr=ala0', 0, 0, 0, 3051, 0, 1, 0, NULL, 30, '', ''),
(3348, '1279617741', '烧酒网', 'http://www.shaojiu.com/', 0, 0, 0, 3051, 0, 1, 0, NULL, 31, '', ''),
(3349, '1289787460', '中新网山西新闻', 'http://www.sx.chinanews.com.cn/', 0, 0, 0, 4062, 0, 1, 0, NULL, 1, '', ''),
(3350, '1289787460', '人民网山西频道', 'http://sx.people.com.cn/', 0, 0, 0, 4062, 0, 1, 0, NULL, 2, '', ''),
(3351, '1289787460', '山西晚报', 'http://www.sxwbs.com/', 0, 0, 0, 4062, 0, 1, 0, NULL, 3, '', ''),
(3352, '1289787460', '晋中日报', 'http://www.sxjzwb.com/', 0, 0, 0, 4062, 0, 1, 0, NULL, 4, '', ''),
(3353, '1289787460', '三晋都市报', 'http://www.daynews.com.cn/sjdsb/', 0, 0, 0, 4062, 0, 1, 0, NULL, 5, '', ''),
(3354, '1289787460', '新阳泉网', 'http://www.xinyq.com/', 0, 0, 0, 4062, 0, 1, 0, NULL, 6, '', ''),
(3355, '1289787460', '阳泉信息港', 'http://www.yq.sx.cninfo.net/', 0, 0, 0, 4062, 0, 1, 0, NULL, 7, '', ''),
(3356, '1289787460', '青年在线', 'http://www.sxqnb.com.cn/', 0, 0, 0, 4062, 0, 1, 0, NULL, 8, '', ''),
(3357, '1289787460', '汾河信息港', 'http://www.yz.sx.cn/', 0, 0, 0, 4062, 0, 1, 0, NULL, 9, '', ''),
(3358, '1289787460', '大同热线', 'http://www.dtrx.cn/', 0, 0, 0, 4062, 0, 1, 0, NULL, 10, '', ''),
(3359, '1289787460', '运城信息港', 'http://www.yc.sx.cn/', 0, 0, 0, 4062, 0, 1, 0, NULL, 11, '', ''),
(3360, '1289787460', '太原在线', 'http://www.tytv.com.cn/', 0, 0, 0, 4062, 0, 1, 0, NULL, 12, '', ''),
(3361, '1289787460', '生活晨报', 'http://www.shcb.net/', 0, 0, 0, 4062, 0, 1, 0, NULL, 13, '', ''),
(3362, '1289787460', '忻州信息网', 'http://0350.cn/', 0, 0, 0, 4062, 0, 1, 0, NULL, 14, '', ''),
(3363, '1289787460', '吕梁信息港', 'http://www.llxxg.com.cn/', 0, 0, 0, 4062, 0, 1, 0, NULL, 15, '', ''),
(3364, '1289787464', '慧聪玩具网', 'http://www.toys.hc360.com/', 0, 0, 0, 4372, 0, 1, 0, NULL, 1, '', ''),
(3365, '1289787464', '中国玩具网', 'http://www.wanju.cn/', 0, 0, 0, 4372, 0, 1, 0, NULL, 2, '', ''),
(3366, '1289787464', '玩具巴巴', 'http://www.toybaba.com/', 0, 0, 0, 4372, 0, 1, 0, NULL, 3, '', ''),
(3367, '1289787464', '中华玩具网', 'http://www.chinatoynet.com', 0, 0, 0, 4372, 0, 1, 0, NULL, 4, '', ''),
(3368, '1289787464', '阿里巴巴玩具供销中心', 'http://search.china.alibaba.com/offer/%E7%8E%A9%E5%85%B7%E7%BD%91.html', 0, 0, 0, 4372, 0, 1, 0, NULL, 5, '', ''),
(3369, '1289787464', '中国玩具供求信息网', 'http://www.toys-gd.com/', 0, 0, 0, 4372, 0, 1, 0, NULL, 6, '', ''),
(3370, '1289787464', '世界玩具网', 'http://www.world-toy.com/', 0, 0, 0, 4372, 0, 1, 0, NULL, 7, '', ''),
(3371, '1289787489', '中国鲜花速递网', 'http://www.cnefs.com', 0, 0, 0, 4373, 0, 1, 0, NULL, 1, '', ''),
(3372, '1289787489', '中国鲜花礼品网', 'http://www.flowercn.com/', 0, 0, 0, 4373, 0, 1, 0, NULL, 2, '', ''),
(3373, '1289787489', '莎啦啦鲜花', 'http://www.salala.com.cn/', 0, 0, 0, 4373, 0, 1, 0, NULL, 3, '', ''),
(3374, '1289787489', '七彩鲜花网', 'http://www.7caihua.com/', 0, 0, 0, 4373, 0, 1, 0, NULL, 4, '', ''),
(3375, '1289787489', '百花在线鲜花网', 'http://www.baihua999.com/', 0, 0, 0, 4373, 0, 1, 0, NULL, 5, '', ''),
(3376, '1289787502', '新华网山西频道', 'http://www.sx.xinhuanet.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 1, '', ''),
(3377, '1289787502', '山西晚报', 'http://www.sxwbs.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 2, '', ''),
(3378, '1289787502', '山西地图', 'http://map.daynews.com.cn', 0, 0, 0, 4063, 0, 1, 0, NULL, 3, '', ''),
(3379, '1289787502', '百度地图-太原', 'http://map.baidu.com/#word=%CC%AB%D4%AD&amp;amp;ct=10', 0, 0, 0, 4063, 0, 1, 0, NULL, 4, '', ''),
(3380, '1289787502', '列车时刻', 'http://hcp.kooxoo.com/', 0, 0, 0, 4063, 0, 1, 0, NULL, 5, '', ''),
(3381, '1289787502', '山西移动', 'http://www.sx.chinamobile.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 6, '', ''),
(3382, '1289787502', '山西联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010018&amp;amp;id=2946', 0, 0, 0, 4063, 0, 1, 0, NULL, 7, '', ''),
(3383, '1289787502', '山西通信', 'http://www.sjrx.com/4', 0, 0, 0, 4063, 0, 1, 0, NULL, 8, '', ''),
(3384, '1289787502', '山西电信', 'http://www.shanxitele.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 9, '', ''),
(3385, '1289787502', '山西铁通', 'http://www.cttsx.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 10, '', ''),
(3386, '1289787502', '宽带三晋', 'http://kdsj2.sx.cn', 0, 0, 0, 4063, 0, 1, 0, NULL, 11, '', ''),
(3387, '1289787502', '互联星空山西', 'http://www.vnet.cn/sx', 0, 0, 0, 4063, 0, 1, 0, NULL, 12, '', ''),
(3388, '1289787502', '山西邮政', 'http://www.sxpost.com.cn', 0, 0, 0, 4063, 0, 1, 0, NULL, 13, '', ''),
(3389, '1289787502', '山西人才市场', 'http://www.sjrc.com.cn', 0, 0, 0, 4063, 0, 1, 0, NULL, 14, '', ''),
(3390, '1289787502', '太原人才网', 'http://www.tyrc.com.cn', 0, 0, 0, 4063, 0, 1, 0, NULL, 15, '', ''),
(3391, '1289787502', '搜房太原', 'http://taiyuan.soufun.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 16, '', ''),
(3392, '1289787502', '太原房产管理局', 'http://www.ty-realestate.com.cn', 0, 0, 0, 4063, 0, 1, 0, NULL, 17, '', ''),
(3393, '1289787502', '山西信息港旅游频道', 'http://sxly.sjrx.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 18, '', ''),
(3394, '1289787502', '太原道', 'http://www.tydao.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 19, '', ''),
(3395, '1289787502', '山西新闻网美食', 'http://www.daynews.com.cn/life/ms/list.html', 0, 0, 0, 4063, 0, 1, 0, NULL, 20, '', ''),
(3396, '1289787502', '太原美食网', 'http://www.tyeat.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 21, '', ''),
(3397, '1289787502', '中国面食网', 'http://www.cnwfn.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 22, '', ''),
(3398, '1289787502', '三晋健康网', 'http://www.sjjkw.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 23, '', ''),
(3399, '1289787502', '山西省红十字会', 'http://www.sxredcross.org.cn', 0, 0, 0, 4063, 0, 1, 0, NULL, 24, '', ''),
(3400, '1289787502', '山西省人民医院', 'http://sxsrmyy.hos.999120.net', 0, 0, 0, 4063, 0, 1, 0, NULL, 25, '', ''),
(3401, '1289787502', '山西医科大学第二医院', 'http://www.sedey.com', 0, 0, 0, 4063, 0, 1, 0, NULL, 26, '', ''),
(3402, '1289787510', '慧聪礼品工艺品网', 'http://www.gift.hc360.com/', 0, 0, 0, 4374, 0, 1, 0, NULL, 1, '', ''),
(3403, '1289787510', '新亚礼品网', 'http://www.xylp.com.cn/', 0, 0, 0, 4374, 0, 1, 0, NULL, 2, '', ''),
(3404, '1289787510', '在线网购礼品', 'http://www.wg365.com/lipin.htm', 0, 0, 0, 4374, 0, 1, 0, NULL, 3, '', ''),
(3405, '1289787510', '中国礼品商务网', 'http://www.18a8.com', 0, 0, 0, 4374, 0, 1, 0, NULL, 4, '', ''),
(3406, '1289787510', '工礼网', 'http://www.gift12345.com', 0, 0, 0, 4374, 0, 1, 0, NULL, 5, '', ''),
(3407, '1289787510', '中国礼品采购网', 'http://www.china-gift.cc/', 0, 0, 0, 4374, 0, 1, 0, NULL, 6, '', ''),
(3408, '1289787510', '中国礼品之都网', 'http://www.lpc8.com', 0, 0, 0, 4374, 0, 1, 0, NULL, 7, '', ''),
(3409, '1289787510', '八佰拜百货商城网', 'http://www.800buy.com.cn/', 0, 0, 0, 4374, 0, 1, 0, NULL, 8, '', ''),
(3410, '1289787510', '中国礼品网', 'http://www.enwise.net/', 0, 0, 0, 4374, 0, 1, 0, NULL, 9, '', ''),
(3411, '1289787510', '礼品网', 'http://www.sinogift.com.cn/', 0, 0, 0, 4374, 0, 1, 0, NULL, 10, '', ''),
(3412, '1289787540', '山西大学', 'http://www.sxu.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 1, '', ''),
(3413, '1289787540', '太原理工大学', 'http://www.tyut.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 2, '', ''),
(3414, '1289787540', '中北大学', 'http://www.nuc.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 3, '', ''),
(3415, '1289787540', '太原科技大学', 'http://www.tyust.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 4, '', ''),
(3416, '1289787540', '山西农业大学', 'http://www.sxau.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 5, '', ''),
(3417, '1289787540', '山西医科大学', 'http://www.sxmu.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 6, '', ''),
(3418, '1289787540', '山西师范大学', 'http://www.sxnu.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 7, '', ''),
(3419, '1289787540', '山西大同大学', 'http://www.sxdtdx.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 8, '', ''),
(3420, '1289787540', '山西财经大学', 'http://www.sxufe.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 9, '', ''),
(3421, '1289787540', '太原工业学院', 'http://www.tit.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 10, '', ''),
(3422, '1289787540', '长治医学院', 'http://www.czmc.com/', 0, 0, 0, 4064, 0, 1, 0, NULL, 11, '', ''),
(3423, '1289787540', '山西中医学院', 'http://www.sxtcm.com/', 0, 0, 0, 4064, 0, 1, 0, NULL, 12, '', ''),
(3424, '1289787540', '太原师范学院', 'http://www.tynu.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 13, '', ''),
(3425, '1289787540', '长治学院', 'http://czxy.sxbys.com.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 14, '', ''),
(3426, '1289787540', '吕梁学院', 'http://www.llhc.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 15, '', ''),
(3427, '1289787540', '晋中学院', 'http://www.sxjztc.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 16, '', ''),
(3428, '1289787540', '忻州师范学院', 'http://www.xztc.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 17, '', ''),
(3429, '1289787540', '运城学院', 'http://www.ycu.edu.cn/', 0, 0, 0, 4064, 0, 1, 0, NULL, 18, '', ''),
(3765, '1289787970', '长春美食', 'http://www.dianping.com/changchun/food', 0, 0, 0, 4083, 0, 1, 0, NULL, 6, '', ''),
(3764, '1289787970', '吉林银行', 'http://www.jlbank.com.cn/', 0, 0, 0, 4083, 0, 1, 0, NULL, 5, '', ''),
(3759, '1289787924', '吉林日报', 'http://www.chinajilin.com.cn/jlrb/', 0, 0, 0, 4082, 0, 1, 0, NULL, 7, '', ''),
(3758, '1289787924', '长春交通之声', 'http://www.fm968.net/', 0, 0, 0, 4082, 0, 1, 0, NULL, 6, '', ''),
(3757, '1289787924', '北方法制报', 'http://www.bffzb.com/', 0, 0, 0, 4082, 0, 1, 0, NULL, 5, '', ''),
(3756, '1289787924', '吉林新闻网', 'http://www.jl.chinanews.com.cn/', 0, 0, 0, 4082, 0, 1, 0, NULL, 4, '', ''),
(3755, '1289787924', '长春电视台', 'http://www.chinactv.com/', 0, 0, 0, 4082, 0, 1, 0, NULL, 3, '', ''),
(3754, '1289787924', '新华网吉林频道', 'http://www.jl.xinhuanet.com/', 0, 0, 0, 4082, 0, 1, 0, NULL, 2, '', ''),
(3753, '1289787924', '吉林广播网', 'http://www.jlradio.com.cn/', 0, 0, 0, 4082, 0, 1, 0, NULL, 1, '', ''),
(3752, '1289787902', '四平风采', 'http://www-sp.jl.cninfo.net/', 0, 0, 0, 4081, 0, 1, 0, NULL, 8, '', ''),
(3751, '1289787902', '城市晚报', 'http://cswbszb.chinajilin.com.cn/paperindex.htm', 0, 0, 0, 4081, 0, 1, 0, NULL, 7, '', ''),
(3750, '1289787902', '新文化报', 'http://www.xwhb.com/', 0, 0, 0, 4081, 0, 1, 0, NULL, 6, '', ''),
(3749, '1289787902', '吉林电视网', 'http://www.jilintv.cn/', 0, 0, 0, 4081, 0, 1, 0, NULL, 5, '', ''),
(3748, '1289787902', '长视网', 'http://www.chinactv.com/', 0, 0, 0, 4081, 0, 1, 0, NULL, 4, '', ''),
(3747, '1289787902', '吉林省政府', 'http://www.jl.gov.cn/', 0, 0, 0, 4081, 0, 1, 0, NULL, 3, '', ''),
(3746, '1289787902', '中国吉林', 'http://www.chinajilin.com.cn/', 0, 0, 0, 4081, 0, 1, 0, NULL, 2, '', ''),
(3745, '1289787902', '吉林信息港', 'http://www.jl.cninfo.net/', 0, 0, 0, 4081, 0, 1, 0, NULL, 1, '', ''),
(3463, '1289787557', '山西贴吧', 'http://tieba.baidu.com/f?kw=%C9%BD%CE%F7', 0, 0, 0, 4065, 0, 1, 0, NULL, 1, '', ''),
(3464, '1289787557', '太原贴吧', 'http://tieba.baidu.com/f?kw=%CC%AB%D4%AD', 0, 0, 0, 4065, 0, 1, 0, NULL, 2, '', ''),
(3465, '1289787557', '清泽论坛', 'http://www.tyutbbs.com/', 0, 0, 0, 4065, 0, 1, 0, NULL, 3, '', ''),
(3466, '1289787557', '太原论坛', 'http://bbs.longcity.net/', 0, 0, 0, 4065, 0, 1, 0, NULL, 4, '', ''),
(3467, '1289787557', '财大论坛', 'http://www.mycida.net/', 0, 0, 0, 4065, 0, 1, 0, NULL, 5, '', ''),
(3468, '1289787557', '壶口潮', 'http://www.hhhk.cn/bbs/', 0, 0, 0, 4065, 0, 1, 0, NULL, 6, '', ''),
(3469, '1289787557', '临汾都市论坛', 'http://bbs.linfen365.com/', 0, 0, 0, 4065, 0, 1, 0, NULL, 7, '', ''),
(3470, '1289787557', '阳泉窝窝', 'http://www.yqwowo.com/', 0, 0, 0, 4065, 0, 1, 0, NULL, 8, '', ''),
(3471, '1289787574', '装修图满多', 'http://www.tumanduo.com', 0, 0, 0, 4376, 0, 1, 0, NULL, 1, '', ''),
(3472, '1289787574', '搜房装修家居网', 'http://home.soufun.com/', 0, 0, 0, 4376, 0, 1, 0, NULL, 2, '', ''),
(3473, '1289787574', '焦点装修家居网', 'http://home.focus.cn', 0, 0, 0, 4376, 0, 1, 0, NULL, 3, '', ''),
(3474, '1289787574', '和家网', 'http://www.51hejia.com/', 0, 0, 0, 4376, 0, 1, 0, NULL, 4, '', ''),
(3475, '1289787574', '新浪装修家居网', 'http://jiaju.sina.com.cn/', 0, 0, 0, 4376, 0, 1, 1300674217, NULL, 5, '', ''),
(3476, '1289787574', '颐家家居网', 'http://www.e-jjj.com/', 0, 0, 0, 4376, 0, 1, 0, NULL, 6, '', ''),
(3477, '1289787574', '我爱我家', 'http://www.525j.com.cn/', 0, 0, 0, 4376, 0, 1, 0, NULL, 7, '', ''),
(3478, '1289787574', '中国智能家居网', 'http://www.smarthomecn.com/', 0, 0, 0, 4376, 0, 1, 0, NULL, 8, '', ''),
(3479, '1289787574', '中国室内设计网', 'http://www.ciid.com.cn', 0, 0, 0, 4376, 0, 1, 0, NULL, 9, '', ''),
(3480, '1289787574', '中国地板信息网', 'http://www.flooring.com.cn/', 0, 0, 0, 4376, 0, 1, 0, NULL, 10, '', ''),
(3481, '1289787574', '中国装修网', 'http://www.cool-de.com/', 0, 0, 0, 4376, 0, 1, 0, NULL, 11, '', ''),
(3482, '1289787574', '香巴拉家居网', 'http://sunbala.cn/ehome/', 0, 0, 0, 4376, 0, 1, 0, NULL, 12, '', ''),
(3483, '1289787574', '我饰我家网', 'http://www.5s5j.com/', 0, 0, 0, 4376, 0, 1, 0, NULL, 13, '', ''),
(3484, '1289787574', '中装网', 'http://www.roomage.com', 0, 0, 0, 4376, 0, 1, 0, NULL, 14, '', ''),
(3485, '1289787574', '装算网', 'http://www.zsuan.com/', 0, 0, 0, 4376, 0, 1, 0, NULL, 15, '', ''),
(3486, '1289787574', '喜悦家居网', 'http://www.joyju.com/', 0, 0, 0, 4376, 0, 1, 0, NULL, 16, '', ''),
(3487, '1289787574', '装修问答网', 'http://www.zxask.cn', 0, 0, 0, 4376, 0, 1, 0, NULL, 17, '', ''),
(3488, '1289787574', '百万征集方案—YLMF大厦', 'http://i.ylmf.com/', 0, 0, 0, 4376, 0, 1, 0, NULL, 18, '', ''),
(3489, '1289787578', '民政厅', 'http://www.sxmz.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 1, '', ''),
(3490, '1289787578', '教育厅', 'http://www.sxedu.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 2, '', ''),
(3491, '1289787578', '发改委', 'http://www.sxdrc.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 3, '', ''),
(3492, '1289787578', '交通运输厅', 'http://www.sxjt.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 4, '', ''),
(3493, '1289787578', '气象局', 'http://www.sxqx.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 5, '', ''),
(3494, '1289787578', '监察厅', 'http://www.sxlzw.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 6, '', ''),
(3495, '1289787578', '地震局', 'http://www.sxeq.com.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 7, '', ''),
(3496, '1289787578', '科技厅', 'http://www.sxinfo.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 8, '', ''),
(3497, '1289787578', '煤炭交易中心', 'http://www.ctctc.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 9, '', ''),
(3498, '1289787578', '物价局', 'http://www.sxprice.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 10, '', ''),
(3499, '1289787578', '安全生产监督', 'http://www.sxaj.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 11, '', ''),
(3500, '1289787578', '体育局', 'http://www.sxsport.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 12, '', ''),
(3501, '1289787578', '广播电影电视局', 'http://www.sxrt.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 13, '', ''),
(3502, '1289787578', '环保厅', 'http://www.sxhb.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 14, '', ''),
(3503, '1289787578', '食品药品监督管理', 'http://www.shxda.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 15, '', ''),
(3504, '1289787578', '大同市', 'http://www.sxdt.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 16, '', ''),
(3505, '1289787578', '阳泉市', 'http://www.yq.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 17, '', ''),
(3506, '1289787578', '长治市', 'http://www.changzhi.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 18, '', ''),
(3507, '1289787578', '晋城市', 'http://www.jconline.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 19, '', ''),
(3508, '1289787578', '朔州市', 'http://www.shuozhou.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 20, '', ''),
(3509, '1289787578', '晋中市', 'http://www.sxjz.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 21, '', ''),
(3510, '1289787578', '忻州市', 'http://www.sxxz.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 22, '', ''),
(3511, '1289787578', '吕梁市', 'http://www.lvliang.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 23, '', ''),
(3512, '1289787578', '临汾市', 'http://www.linfen.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 24, '', ''),
(3513, '1289787578', '运城市', 'http://www.yuncheng.gov.cn/', 0, 0, 0, 4066, 0, 1, 0, NULL, 25, '', ''),
(3514, '1289787601', '搜房网', 'http://www.soufun.com/', 0, 0, 0, 4377, 0, 1, 0, NULL, 1, '', ''),
(3515, '1289787601', '焦点房地产网', 'http://house.focus.cn/', 0, 0, 0, 4377, 0, 1, 0, NULL, 2, '', ''),
(3516, '1289787601', '新浪房产', 'http://house.sina.com.cn', 0, 0, 0, 4377, 0, 1, 0, NULL, 3, '', ''),
(3517, '1289787601', '搜狐房产', 'http://house.sohu.com', 0, 0, 0, 4377, 0, 1, 0, NULL, 4, '', ''),
(3518, '1289787601', '口碑网房产', 'http://fang.taobao.com/', 0, 0, 0, 4377, 0, 1, 1289787782, NULL, 5, '', ''),
(3519, '1289787601', '新华网房产频道', 'http://www.xinhuanet.com/house/', 0, 0, 0, 4377, 0, 1, 0, NULL, 6, '', ''),
(3520, '1289787601', '雅虎房地产', 'http://cn.realestate.yahoo.com', 0, 0, 0, 4377, 0, 1, 0, NULL, 7, '', ''),
(3521, '1289787601', '赶集网租房二手房', 'http://www.ganji.com/', 0, 0, 0, 4377, 0, 1, 1289787645, NULL, 8, '', ''),
(3563, '1289787672', '辽宁日报', 'http://epaper.lnd.com.cn/', 0, 0, 0, 4072, 0, 1, 0, NULL, 1, '', ''),
(3522, '1289787601', '和讯房产', 'http://house.hexun.com/', 0, 0, 0, 4377, 0, 1, 0, NULL, 9, '', ''),
(3523, '1289787601', '九九房', 'http://www.99fang.com/bj/', 0, 0, 0, 4377, 0, 1, 0, NULL, 10, '', ''),
(3524, '1289787601', '房老大', 'http://www.foloda.com/', 0, 0, 0, 4377, 0, 1, 0, NULL, 11, '', ''),
(3525, '1289787601', '全房网', 'http://tj.allfang.com/', 0, 0, 0, 4377, 0, 1, 1300674199, NULL, 12, '', ''),
(3526, '1289787601', '大中华地产', 'http://re.icxo.com', 0, 0, 0, 4377, 0, 1, 0, NULL, 13, '', ''),
(3527, '1289787601', '易居网', 'http://www.eeju.com/', 0, 0, 0, 4377, 0, 1, 0, NULL, 14, '', ''),
(3528, '1289787601', '人民网房产', 'http://house.people.com.cn/', 0, 0, 0, 4377, 0, 1, 0, NULL, 15, '', ''),
(3529, '1289787601', '21CN房产', 'http://house.21cn.com/', 0, 0, 0, 4377, 0, 1, 0, NULL, 16, '', ''),
(3530, '1289787601', '房王网', 'http://www.ihouseking.com', 0, 0, 0, 4377, 0, 1, 0, NULL, 17, '', ''),
(3531, '1289787601', '我来房产网', 'http://www.wolai.com/', 0, 0, 0, 4377, 0, 1, 0, NULL, 18, '', ''),
(3532, '1289787601', '房东网', 'http://www.fundon.cn', 0, 0, 0, 4377, 0, 1, 0, NULL, 19, '', ''),
(3533, '1289787601', '家和网视频看房', 'http://www.homhow.com/', 0, 0, 0, 4377, 0, 1, 0, NULL, 20, '', ''),
(3534, '1289787601', '易易网', 'http://www.yaoee.com', 0, 0, 0, 4377, 0, 1, 0, NULL, 21, '', ''),
(3535, '1289787601', '房产超市网', 'http://www.fccs.com', 0, 0, 0, 4377, 0, 1, 0, NULL, 22, '', ''),
(3536, '1289787601', '房途网', 'http://www.fangtoo.com', 0, 0, 0, 4377, 0, 1, 0, NULL, 23, '', ''),
(3537, '1289787601', '爱房网新房', 'http://www.aifang.com/', 0, 0, 0, 4377, 0, 1, 1289787634, NULL, 24, '', ''),
(3539, '1279617741', '中国人寿', 'http://www.e-chinalife.com/', 0, 0, 0, 3052, 0, 1, 0, NULL, 1, '', ''),
(3538, '1289787601', '安得房', 'http://www.andfang.com/', 0, 0, 0, 4377, 0, 1, 0, NULL, 25, '', ''),
(3540, '1279617741', '平安保险', 'http://www.pingan.com/', 0, 0, 0, 3052, 0, 1, 0, NULL, 2, '', ''),
(3541, '1279617741', '太平洋保险', 'http://www.cpic.com.cn/', 0, 0, 0, 3052, 0, 1, 0, NULL, 3, '', ''),
(3542, '1279617741', '泰康人寿', 'http://www.taikang.com/', 0, 0, 0, 3052, 0, 1, 0, NULL, 4, '', ''),
(3543, '1279617741', '中国人保', 'http://www.piccnet.com.cn/', 0, 0, 0, 3052, 0, 1, 0, NULL, 5, '', ''),
(3544, '1279617741', '新华人寿', 'http://www.newchinalife.com/', 0, 0, 0, 3052, 0, 1, 0, NULL, 6, '', ''),
(3545, '1279617741', '友邦保险', 'http://www.aia.com.cn/', 0, 0, 0, 3052, 0, 1, 0, NULL, 7, '', ''),
(3546, '1279617741', '中国保险网', 'http://www.china-insurance.com/', 0, 0, 0, 3052, 0, 1, 0, NULL, 8, '', ''),
(3547, '1279617741', '中国保监会', 'http://www.circ.gov.cn/web/site0/', 0, 0, 0, 3052, 0, 1, 0, NULL, 9, '', ''),
(3548, '1279617741', '中英人寿', 'http://www.aviva-cofco.com.cn/', 0, 0, 0, 3052, 0, 1, 0, NULL, 10, '', ''),
(3549, '1279617741', '人力资源和社会保障部', 'http://www.mohrss.gov.cn/Desktop.aspx?PATH=rsbww/sy', 0, 0, 0, 3052, 0, 1, 0, NULL, 11, '', ''),
(3550, '1279617741', '金融界-保险', 'http://insurance.jrj.com.cn/', 0, 0, 0, 3052, 0, 1, 0, NULL, 12, '', ''),
(3551, '1289787644', '北国网', 'http://www.lnd.com.cn/', 0, 0, 0, 4071, 0, 1, 0, NULL, 1, '', ''),
(3552, '1289787644', '辽阳信息港', 'http://www.lyip.com.cn/', 0, 0, 0, 4071, 0, 1, 0, NULL, 2, '', ''),
(3553, '1289787644', '海力网', 'http://www.hilizi.com/', 0, 0, 0, 4071, 0, 1, 0, NULL, 3, '', ''),
(3554, '1289787644', '铁岭信息港', 'http://www.tlptt.ln.cn/', 0, 0, 0, 4071, 0, 1, 0, NULL, 4, '', ''),
(3555, '1289787644', '沈阳网', 'http://www.syd.com.cn/', 0, 0, 0, 4071, 0, 1, 0, NULL, 5, '', ''),
(3556, '1289787644', '鞍山信息港', 'http://www.asptt.ln.cn/', 0, 0, 0, 4071, 0, 1, 0, NULL, 6, '', ''),
(3557, '1289787644', '朝阳之窗', 'http://cy.northtimes.com/', 0, 0, 0, 4071, 0, 1, 0, NULL, 7, '', ''),
(3558, '1289787644', '沈阳热线', 'http://www.sy.ln.cn/', 0, 0, 0, 4071, 0, 1, 0, NULL, 8, '', ''),
(3559, '1289787644', '世纪星', 'http://www.n169.com/', 0, 0, 0, 4071, 0, 1, 0, NULL, 9, '', ''),
(3560, '1289787644', '本溪时空', 'http://bx.northtimes.com/', 0, 0, 0, 4071, 0, 1, 0, NULL, 10, '', ''),
(3561, '1289787644', '锦州在线', 'http://www.jzptt.ln.cn/', 0, 0, 0, 4071, 0, 1, 0, NULL, 11, '', ''),
(3562, '1289787644', '丹东新闻网', 'http://dd.nen.com.cn/', 0, 0, 0, 4071, 0, 1, 0, NULL, 12, '', ''),
(3564, '1289787672', '民心网', 'http://www.mxwz.com/', 0, 0, 0, 4072, 0, 1, 0, NULL, 2, '', ''),
(3565, '1289787672', '辽宁电视台', 'http://www.lntv.cn/', 0, 0, 0, 4072, 0, 1, 0, NULL, 3, '', ''),
(3566, '1289787672', '沈阳广播电视台', 'http://www.csytv.com/', 0, 0, 0, 4072, 0, 1, 0, NULL, 4, '', ''),
(3567, '1289787672', '沈阳广播网', 'http://www.syradio.cn/', 0, 0, 0, 4072, 0, 1, 0, NULL, 5, '', ''),
(3568, '1289787672', '千华网', 'http://www.qianhuaweb.com/', 0, 0, 0, 4072, 0, 1, 0, NULL, 6, '', ''),
(3569, '1289787672', '振兴东北', 'http://www.chinaneast.gov.cn/', 0, 0, 0, 4072, 0, 1, 0, NULL, 7, '', ''),
(3570, '1289787672', '沈阳日报', 'http://epaper.syd.com.cn/syrb/paperindex.htm', 0, 0, 0, 4072, 0, 1, 0, NULL, 8, '', ''),
(3571, '1289787672', '沈阳晚报', 'http://epaper.syd.com.cn/sywb/paperindex.htm', 0, 0, 0, 4072, 0, 1, 0, NULL, 9, '', ''),
(3572, '1289787672', '锦州新闻网', 'http://www.1m3d.com/', 0, 0, 0, 4072, 0, 1, 0, NULL, 10, '', ''),
(3573, '1289787672', '大连晚报', 'http://www.dlwb.com.cn/', 0, 0, 0, 4072, 0, 1, 0, NULL, 11, '', ''),
(3574, '1289787672', '网上三好街', 'http://www.sanhaostreet.com/', 0, 0, 0, 4072, 0, 1, 0, NULL, 12, '', ''),
(3575, '1289787672', '沈阳热线', 'http://sy.northtimes.com/', 0, 0, 0, 4072, 0, 1, 0, NULL, 13, '', ''),
(3576, '1289787672', '鞍山信息港', 'http://www.asptt.ln.cn/', 0, 0, 0, 4072, 0, 1, 0, NULL, 14, '', ''),
(3577, '1289787672', '世纪星', 'http://www.n169.com/', 0, 0, 0, 4072, 0, 1, 0, NULL, 15, '', ''),
(3578, '1289787672', '本溪时空', 'http://www.bxptt.ln.cn/', 0, 0, 0, 4072, 0, 1, 0, NULL, 16, '', ''),
(3579, '1289787672', '鹤乡热线', 'http://www.panjin.net/', 0, 0, 0, 4072, 0, 1, 0, NULL, 17, '', ''),
(3580, '1289787672', '北方时空', 'http://www.northtimes.com/', 0, 0, 0, 4072, 0, 1, 0, NULL, 18, '', ''),
(3581, '1289787696', '辽宁电视台', 'http://www.lntv.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 1, '', ''),
(3582, '1289787696', '大连新闻网', 'http://www.daliandaily.com.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 2, '', ''),
(3583, '1289787696', '新华网辽宁频道', 'http://www.ln.xinhuanet.com/', 0, 0, 0, 4073, 0, 1, 0, NULL, 3, '', ''),
(3584, '1289787696', '辽宁邮政', 'http://www.ln183.com/', 0, 0, 0, 4073, 0, 1, 0, NULL, 4, '', ''),
(3585, '1289787696', '辽宁人事人才公共服务网', 'http://www.lnrc.com.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 5, '', ''),
(3586, '1289787696', '东北房产网', 'http://www.dbfc.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 6, '', ''),
(3587, '1289787696', '大连房产市场', 'http://www.dl-fangdi.com.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 7, '', ''),
(3588, '1289787696', '大连住房公积金网', 'http://www.gjj.dl.gov.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 8, '', ''),
(3589, '1289787696', '辽宁旅游信息网', 'http://www.lntour.gov.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 9, '', ''),
(3590, '1289787696', '辽宁省人民医院', 'http://www.lnph.com/', 0, 0, 0, 4073, 0, 1, 0, NULL, 10, '', ''),
(3591, '1289787696', '辽宁省中医院', 'http://www.lntcm.com.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 11, '', ''),
(3592, '1289787696', '辽宁省红十字会', 'http://www.lnredcross.org.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 12, '', ''),
(3593, '1289787696', '辽宁教育网', 'http://www.lnen.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 13, '', ''),
(3594, '1289787696', '东北新闻网教育', 'http://tech.nen.com.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 14, '', ''),
(3595, '1289787696', '辽宁招生考试之窗', 'http://www.lnzsks.com/', 0, 0, 0, 4073, 0, 1, 0, NULL, 15, '', ''),
(3596, '1289787696', '沈阳招生考试网', 'http://www.syzsks.com/', 0, 0, 0, 4073, 0, 1, 0, NULL, 16, '', ''),
(3597, '1289787696', '辽宁人事考试网', 'http://www.lnrsks.com/', 0, 0, 0, 4073, 0, 1, 0, NULL, 17, '', ''),
(3598, '1289787696', '北国论坛', 'http://bbs.lnd.com.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 18, '', ''),
(3599, '1289787696', '金虎论坛', 'http://bbs.nen.com.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 19, '', ''),
(3600, '1289787696', '营口论坛', 'http://www.chinayk.com/', 0, 0, 0, 4073, 0, 1, 0, NULL, 20, '', ''),
(3601, '1289787696', '大连论坛', 'http://bbs.runsky.com/bbs/main.html', 0, 0, 0, 4073, 0, 1, 0, NULL, 21, '', ''),
(3602, '1289787696', '沈阳诚浩证券', 'http://www.chstock.com/', 0, 0, 0, 4073, 0, 1, 0, NULL, 22, '', ''),
(3603, '1289787696', '沈阳养老保险', 'http://www.ylbxglzx.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 23, '', ''),
(3604, '1289787696', '沈阳医疗保险', 'http://www.syyb.gov.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 24, '', ''),
(3605, '1289787696', '劳动社会保障厅', 'http://www.ln.lss.gov.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 25, '', ''),
(3606, '1289787696', '沈阳交通违章查询', 'http://www.sygajj.gov.cn/', 0, 0, 0, 4073, 0, 1, 0, NULL, 26, '', ''),
(3607, '1289787696', '辽宁二手车', 'http://www.ln2car.com/', 0, 0, 0, 4073, 0, 1, 0, NULL, 27, '', ''),
(3608, '1289787696', '邮编区号查询', 'http://tool.115.com/youbian/', 0, 0, 0, 4073, 0, 1, 0, NULL, 28, '', ''),
(3609, '1289787696', '彩票查询', 'http://tool.115.com/live/caipiao/', 0, 0, 0, 4073, 0, 1, 0, NULL, 29, '', ''),
(3610, '1289787696', '常用电话号码', 'http://tool.115.com/live/phone/', 0, 0, 0, 4073, 0, 1, 0, NULL, 30, '', ''),
(3611, '1289787748', '大连理工大学', 'http://www.dlut.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 1, '', ''),
(3612, '1289787748', '东北大学', 'http://www.neu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 2, '', ''),
(3613, '1289787748', '中国医科大学', 'http://www.cmu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 3, '', ''),
(3614, '1289787748', '东北财经大学', 'http://www.dufe.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 4, '', ''),
(3615, '1289787748', '沈阳药科大学', 'http://www.syphu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 5, '', ''),
(3616, '1289787748', '辽宁大学', 'http://www.lnu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 6, '', ''),
(3617, '1289787748', '沈阳农业大学', 'http://www.syau.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 7, '', ''),
(3618, '1289787748', '沈阳工业大学', 'http://www.sut.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 8, '', ''),
(3619, '1289787748', '沈阳理工大学', 'http://www.sylu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 9, '', ''),
(3620, '1289787748', '大连海事大学', 'http://www.dlmu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 10, '', ''),
(3621, '1289787748', '辽宁工程技术大学', 'http://www.lntu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 11, '', ''),
(3622, '1289787748', '沈阳师范大学', 'http://www.synu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 12, '', ''),
(3623, '1289787748', '辽宁师范大学', 'http://www.lnnu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 13, '', ''),
(3624, '1289787748', '沈阳医学院', 'http://www.symc.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 14, '', ''),
(3625, '1289787748', '大连大学', 'http://www.dlu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 15, '', ''),
(3626, '1289787748', '渤海船舶职业学院', 'http://www.bhcy.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 16, '', ''),
(3627, '1289787748', '锦州师范高等专科', 'http://www.jzsz.com.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 17, '', ''),
(3628, '1289787748', '辽宁工业大学', 'http://www.lnit.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 18, '', ''),
(3629, '1289787748', '大连理工大学城市学院', 'http://city.dlut.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 19, '', ''),
(3630, '1289787748', '鲁迅美术学院', 'http://www.lumei.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 20, '', ''),
(3631, '1289787748', '沈阳体育学院', 'http://www.syty.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 21, '', ''),
(3632, '1289787748', '大连外国语学院', 'http://www.dlufl.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 22, '', ''),
(3633, '1289787748', '沈阳航空航天大学', 'http://www.syiae.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 23, '', ''),
(3634, '1289787748', '辽宁中医药大学', 'http://www.lnutcm.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 24, '', ''),
(3635, '1289787748', '大连海洋大学', 'http://www.dlfu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 25, '', ''),
(3636, '1289787748', '沈阳职业技术学院', 'http://www.vtcsy.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 26, '', ''),
(3637, '1289787748', '渤海大学', 'http://www.jznu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 27, '', ''),
(3638, '1289787748', '大连医科大学', 'http://www.dlmedu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 28, '', ''),
(3639, '1289787748', '大连工业大学', 'http://www.dlpu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 29, '', ''),
(3640, '1289787748', '沈阳化工大学', 'http://www.syuct.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 30, '', ''),
(3641, '1289787748', '大连交通大学', 'http://www.djtu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 31, '', ''),
(3642, '1289787748', '辽宁医学院', 'http://www.jzmu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 32, '', ''),
(3643, '1289787748', '辽宁科技大学', 'http://www.asust.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 33, '', ''),
(3644, '1289787748', '大连民族学院', 'http://www.dlnu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 34, '', ''),
(3645, '1289787748', '辽宁对外经贸学院', 'http://www.luibe.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 35, '', ''),
(3646, '1289787748', '沈阳建筑大学', 'http://www.sjzu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 36, '', ''),
(3647, '1289787748', '辽宁林业职业技术学院', 'http://www.lnlzy.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 37, '', ''),
(3648, '1289787748', '辽宁石油化工大学', 'http://www.lnpu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 38, '', ''),
(3649, '1289787748', '辽宁科技学院', 'http://www.lnist.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 39, '', ''),
(3650, '1289787748', '大连职业技术学院', 'http://www.dlvtc.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 40, '', ''),
(3651, '1289787748', '鞍山师范学院', 'http://www.asnc.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 41, '', ''),
(3652, '1289787748', '辽宁金融职业学院', 'http://www.lnfvc.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 42, '', ''),
(3653, '1289787748', '朝阳师范高等专科学校', 'http://www.cysz.com.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 43, '', ''),
(3654, '1289787748', '沈阳工程学院', 'http://www.syce.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 44, '', ''),
(3655, '1289787748', '大连东软信息学院', 'http://www.neusoft.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 45, '', ''),
(3656, '1289787748', '辽东学院', 'http://www.ldxy.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 46, '', ''),
(3657, '1289787748', '沈阳大学', 'http://www.syu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 47, '', ''),
(3658, '1289787748', '沈阳音乐学院', 'http://www.sycm.com.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 48, '', ''),
(3659, '1289787748', '辽宁广告职业学院', 'http://www.ggxy.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 49, '', ''),
(3660, '1289787748', '辽宁财贸学院', 'http://www.lncmxy.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 50, '', ''),
(3661, '1289787748', '辽宁交通高等专科学校', 'http://www.lncc.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 51, '', ''),
(3662, '1289787748', '铁岭师范高等专科学校', 'http://www.tlsz.com.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 52, '', ''),
(3663, '1289787748', '抚顺师范高等专科学校', 'http://www.fstc.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 53, '', ''),
(3664, '1289787748', '辽宁警官高等专科学校', 'http://www.lnpc.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 54, '', ''),
(3665, '1289787748', '阜新高等专科学校', 'http://www.fxgz.com.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 55, '', ''),
(3666, '1289787748', '辽宁农业职业技术学院', 'http://lnnzy.ln.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 56, '', ''),
(3667, '1289787748', '辽阳职业技术学院', 'http://www.419.com.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 57, '', ''),
(3668, '1289787748', '辽宁公安司法管理干部学院', 'http://www.lacpj.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 58, '', ''),
(3669, '1289787748', '盘锦职业技术学院', 'http://www.pjzy.net.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 59, '', ''),
(3670, '1289787748', '抚顺职业技术学院', 'http://www.fvti.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 60, '', ''),
(3671, '1289787748', '营口职业技术学院', 'http://www.ykdx.net/asptest/index.asp', 0, 0, 0, 4074, 0, 1, 0, NULL, 61, '', ''),
(3672, '1289787748', '大连艺术职业学院', 'http://www.dlac.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 62, '', ''),
(3673, '1289787748', '大连东软信息技术职业学院', 'http://dalian.neusoft.edu.cn/index.html', 0, 0, 0, 4074, 0, 1, 0, NULL, 63, '', ''),
(3674, '1289787748', '辽宁石化职业技术学院', 'http://www.lnpc.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 64, '', ''),
(3675, '1289787748', '辽宁经济职业技术学院', 'http://www.lnemci.com/main1.aspx', 0, 0, 0, 4074, 0, 1, 0, NULL, 65, '', ''),
(3676, '1289787748', '辽宁信息职业技术学院', 'http://www.lnxxxy.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 66, '', ''),
(3677, '1289787748', '辽宁现代服务职业技术学院', 'http://www.lnxdfwxy.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 67, '', ''),
(3678, '1289787748', '辽宁装备制造职业技术学院', 'http://www.ltcem.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 68, '', ''),
(3679, '1289787748', '辽宁理工职业学院', 'http://www.lndhdx.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 69, '', ''),
(3680, '1289787748', '辽宁机电职业技术学院', 'http://www.lnmec.net.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 70, '', ''),
(3681, '1289787748', '大连翻译职业学院', 'http://www.dltcedu.org/', 0, 0, 0, 4074, 0, 1, 0, NULL, 71, '', ''),
(3682, '1289787748', '辽宁商贸职业学院', 'http://www.lnsmzy.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 72, '', ''),
(3683, '1289787748', '大连汽车职业技术学院', 'http://www.dlqcxy.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 73, '', ''),
(3684, '1289787748', '大连装备制造职业技术学院', 'http://dl.xaiu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 74, '', ''),
(3685, '1289787748', '大连枫叶职业技术学院', 'http://dmlit.cn/zhaoshengxinxi/zsgg2009.asp', 0, 0, 0, 4074, 0, 1, 0, NULL, 75, '', ''),
(3686, '1289787748', '辽宁职业学院', 'http://www.lnvc.cn/info/data/publish/100.jsp', 0, 0, 0, 4074, 0, 1, 0, NULL, 76, '', ''),
(3687, '1289787748', '辽宁美术职业学院', 'http://www.fzcollege.org/', 0, 0, 0, 4074, 0, 1, 0, NULL, 77, '', ''),
(3688, '1289787748', '沈阳航空职业技术学院', 'http://www.syhzy.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 78, '', ''),
(3689, '1289787748', '大连航运职业技术学院', 'http://www.dlsc.net.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 79, '', ''),
(3690, '1289787748', '辽宁地质工程职业学院', 'http://www.lndzxy.com/ws2004/', 0, 0, 0, 4074, 0, 1, 0, NULL, 80, '', ''),
(3691, '1289787748', '辽宁体育运动职业技术学院', 'http://www.lnen.cn/mb/view.html?actionType=home&amp;amp;domainid=96', 0, 0, 0, 4074, 0, 1, 0, NULL, 81, '', ''),
(3692, '1289787748', '辽宁冶金职业技术学院', 'http://www.lnyj.net/', 0, 0, 0, 4074, 0, 1, 0, NULL, 82, '', ''),
(3693, '1289787748', '辽宁工程职业学院', 'http://lngczyxy.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 83, '', ''),
(3694, '1289787748', '辽宁卫生职业技术学院', 'http://www.lzygzy-edu.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 84, '', ''),
(3695, '1289787748', '沈阳工业大学工程学院', 'http://gcxy.sut.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 85, '', ''),
(3696, '1289787748', '沈阳大学科技工程学院', 'http://www.syu.edu.cn/xueyuan/kjxy/', 0, 0, 0, 4074, 0, 1, 0, NULL, 86, '', ''),
(3697, '1289787748', '大连交通大学信息工程学院', 'http://www.ieidjtu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 87, '', ''),
(3698, '1289787748', '沈阳化工大学科亚学院', 'http://keyaxueyuan.syuct.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 88, '', ''),
(3699, '1289787748', '东北财经大学津桥商学院', 'http://www.kingbridge.net/', 0, 0, 0, 4074, 0, 1, 0, NULL, 89, '', ''),
(3700, '1289787748', '大连工业大学艺术与信息学院', 'http://www.caie.org/', 0, 0, 0, 4074, 0, 1, 0, NULL, 90, '', ''),
(3701, '1289787748', '辽宁科技大学信息技术学院', 'http://zsjy.ustl.edu.cn/xxxy/', 0, 0, 0, 4074, 0, 1, 0, NULL, 91, '', ''),
(3702, '1289787748', '中国医科大学临床医药学院', 'http://www.cmu.edu.cn/cmc/', 0, 0, 0, 4074, 0, 1, 0, NULL, 92, '', ''),
(3703, '1289787748', '辽宁石油化工大学顺华学院', 'http://www.lnshny.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 93, '', ''),
(3704, '1289787748', '辽宁师范大学海华学院', 'http://haihua.lnnu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 94, '', ''),
(3705, '1289787748', '沈阳建筑大学城市建设学院', 'http://www.sjcy.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 95, '', ''),
(3706, '1289787748', '辽宁中医药大学杏林学院', 'http://www.lnutcm.edu.cn/xinglin/', 0, 0, 0, 4074, 0, 1, 0, NULL, 96, '', ''),
(3707, '1289787748', '沈阳理工大学应用技术学院', 'http://www.syyyy.com.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 97, '', ''),
(3708, '1289787748', '沈阳医学院何氏视觉科学学院', 'http://www.he-edu.com/', 0, 0, 0, 4074, 0, 1, 0, NULL, 98, '', ''),
(3709, '1289787748', '辽宁医学院医疗学院', 'http://ylxy.lnmu.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 99, '', ''),
(3710, '1289787748', '大连医科大学中山学院', 'http://www.dmuzs.edu.cn/', 0, 0, 0, 4074, 0, 1, 0, NULL, 100, '', ''),
(3711, '1289787772', '辽宁贴吧', 'http://tieba.baidu.com/f?kw=%C1%C9%C4%FE', 0, 0, 0, 4075, 0, 1, 0, NULL, 1, '', ''),
(3712, '1289787772', '沈阳贴吧', 'http://tieba.baidu.com/f?kw=%C9%F2%D1%F4', 0, 0, 0, 4075, 0, 1, 0, NULL, 2, '', ''),
(3713, '1289787772', '大连贴吧', 'http://tieba.baidu.com/f?kw=%B4%F3%C1%AC', 0, 0, 0, 4075, 0, 1, 0, NULL, 3, '', ''),
(3714, '1289787772', '小城东港', 'http://www.dg.ln.cn/', 0, 0, 0, 4075, 0, 1, 0, NULL, 4, '', ''),
(3715, '1289787772', '时代丹东', 'http://www.dd365t.com/', 0, 0, 0, 4075, 0, 1, 0, NULL, 5, '', ''),
(3716, '1289787772', '大连野人户外', 'http://www.dlyeren.com/ucbbs/index.php', 0, 0, 0, 4075, 0, 1, 0, NULL, 6, '', ''),
(3717, '1289787772', '摩托车论坛', 'http://www.lnmoto.cn/bbs/', 0, 0, 0, 4075, 0, 1, 0, NULL, 7, '', ''),
(3718, '1289787772', '同行网', 'http://bbs.090.com.cn/', 0, 0, 0, 4075, 0, 1, 0, NULL, 8, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(3719, '1289787772', '大连理工碧海青天', 'http://bbs.dlut.edu.cn/', 0, 0, 0, 4075, 0, 1, 0, NULL, 9, '', ''),
(3720, '1289787772', '葫芦岛论坛', 'http://bbs.hld.gov.cn/', 0, 0, 0, 4075, 0, 1, 0, NULL, 10, '', ''),
(3721, '1289787800', '发改委', 'http://www.lndp.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 1, '', ''),
(3722, '1289787800', '工商局', 'http://www.lngs.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 2, '', ''),
(3723, '1289787800', '税务局', 'http://www.ln-n-tax.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 3, '', ''),
(3724, '1289787800', '监察厅', 'http://www.lnsjjjc.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 4, '', ''),
(3725, '1289787800', '气象局', 'http://www.lnmb.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 5, '', ''),
(3726, '1289787800', '教育厅', 'http://www.lnen.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 6, '', ''),
(3727, '1289787800', '科学技术厅', 'http://www.lninfo.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 7, '', ''),
(3728, '1289787800', '海事局', 'http://www.lnmsa.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 8, '', ''),
(3729, '1289787800', '大连海关', 'http://dalian.customs.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 9, '', ''),
(3730, '1289787800', '沈阳海关', 'http://shenyang.customs.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 10, '', ''),
(3731, '1289787800', '交通厅', 'http://www.lncom.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 11, '', ''),
(3732, '1289787800', '建设厅', 'http://www.cc.ln.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 12, '', ''),
(3733, '1289787800', '抚顺市', 'http://www.fushun.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 13, '', ''),
(3734, '1289787800', '鞍山市', 'http://www.anshan.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 14, '', ''),
(3735, '1289787800', '丹东市', 'http://www.dandong.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 15, '', ''),
(3736, '1289787800', '本溪市', 'http://www.benxi.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 16, '', ''),
(3737, '1289787800', '锦州市', 'http://www.jz.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 17, '', ''),
(3738, '1289787800', '营口市', 'http://www.yingkou.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 18, '', ''),
(3739, '1289787800', '阜新市', 'http://www.fuxin.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 19, '', ''),
(3740, '1289787800', '辽阳市', 'http://www.liaoyang.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 20, '', ''),
(3741, '1289787800', '盘锦市', 'http://www.panjin.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 21, '', ''),
(3742, '1289787800', '朝阳市', 'http://www.zgcy.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 22, '', ''),
(3743, '1289787800', '铁岭市', 'http://www.tieling.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 23, '', ''),
(3744, '1289787800', '葫芦岛市', 'http://www.hld.gov.cn/', 0, 0, 0, 4076, 0, 1, 0, NULL, 24, '', ''),
(3766, '1289787970', '专家门诊', 'http://jilin.haodf.com/', 0, 0, 0, 4083, 0, 1, 0, NULL, 7, '', ''),
(3767, '1289787970', '长春58同城', 'http://cc.58.com/', 0, 0, 0, 4083, 0, 1, 0, NULL, 8, '', ''),
(3768, '1289787970', '天气预报', 'http://www.weather.com.cn/html/weather/101060201.shtml', 0, 0, 0, 4083, 0, 1, 0, NULL, 9, '', ''),
(3769, '1289787970', '地图查询', 'http://map.baidu.com/?newmap=1&amp;amp;ie=utf-8&amp;amp;s=s%26wd%3D%E5%90%89%E6%9E%97', 0, 0, 0, 4083, 0, 1, 0, NULL, 10, '', ''),
(3770, '1289787970', '火车票预定', 'http://www.huoche.com/dingpiao/sheng/jilin', 0, 0, 0, 4083, 0, 1, 0, NULL, 11, '', ''),
(3771, '1289787970', '长春交通违章查询', 'http://www.ccjg.gov.cn/', 0, 0, 0, 4083, 0, 1, 0, NULL, 12, '', ''),
(3772, '1289787970', '吉林市旅游信息', 'http://www.gojl.com.cn/', 0, 0, 0, 4083, 0, 1, 0, NULL, 13, '', ''),
(3773, '1289787990', '吉林大学', 'http://www.jlu.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 1, '', ''),
(3774, '1289787990', '东北师范大学', 'http://www.nenu.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 2, '', ''),
(3775, '1289787990', '吉林农业大学', 'http://www.jlau.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 3, '', ''),
(3776, '1289787990', '长春大学', 'http://www.ccu-edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 4, '', ''),
(3777, '1289787990', '北华大学', 'http://www.beihua.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 5, '', ''),
(3778, '1289787990', '吉林师范大学', 'http://www.jlnu.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 6, '', ''),
(3779, '1289787990', '延边大学', 'http://www.ybu.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 7, '', ''),
(3780, '1289787990', '吉林动画学院', 'http://www.jldh.com.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 8, '', ''),
(3781, '1289787990', '东北电力大学', 'http://www.nedu.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 9, '', ''),
(3782, '1289787990', '长春工程学院', 'http://www.ccit.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 10, '', ''),
(3783, '1289787990', '吉林化工学院', 'http://www.jlict.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 11, '', ''),
(3784, '1289787990', '长春师范学院', 'http://www.cncnc.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 12, '', ''),
(3785, '1289787990', '吉林工程技术师范学院', 'http://www.jltiet.net/', 0, 0, 0, 4084, 0, 1, 0, NULL, 13, '', ''),
(3786, '1289787990', '吉林建筑工程学院', 'http://www.jliae.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 14, '', ''),
(3787, '1289787990', '长春工业大学', 'http://www.ccut.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 15, '', ''),
(3788, '1289787990', '长春汽车工业高等专科学校', 'http://www.caii.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 16, '', ''),
(3789, '1289787990', '长春中医药大学', 'http://www.ccucm.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 17, '', ''),
(3790, '1289787990', '通化师范学院', 'http://www.thnu.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 18, '', ''),
(3791, '1289787990', '长春职业技术学院', 'http://www.cvit.com.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 19, '', ''),
(3792, '1289787990', '吉林华桥外国语学院', 'http://www.hqwy.com/', 0, 0, 0, 4084, 0, 1, 0, NULL, 20, '', ''),
(3793, '1289787990', '吉林体育学院', 'http://www.jlty.com.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 21, '', ''),
(3794, '1289787990', '白城师范学院', 'http://www.bcsfxy.com/', 0, 0, 0, 4084, 0, 1, 0, NULL, 22, '', ''),
(3795, '1289787990', '吉林艺术学院', 'http://www.jlart.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 23, '', ''),
(3796, '1289787990', '吉林农业科技学院', 'http://www.jlnku.com/', 0, 0, 0, 4084, 0, 1, 0, NULL, 24, '', ''),
(3797, '1289787990', '吉林工商学院', 'http://www.jlbtc.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 25, '', ''),
(3798, '1289787990', '长春理工大学', 'http://www.cust.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 26, '', ''),
(3799, '1289787990', '吉林医药学院', 'http://www.jlmpc.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 27, '', ''),
(3800, '1289787990', '吉林警察学院', 'http://www.jlgazk.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 28, '', ''),
(3801, '1289787990', '白城医学高等专科学校', 'http://www.bcyz.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 29, '', ''),
(3802, '1289787990', '长春医学高等专科学校', 'http://www.cmcedu.com/', 0, 0, 0, 4084, 0, 1, 0, NULL, 30, '', ''),
(3803, '1289787990', '长春金融高等专科学校', 'http://www.cjgz.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 31, '', ''),
(3804, '1289787990', '吉林交通职业技术学院', 'http://www.jjtc.com.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 32, '', ''),
(3805, '1289787990', '辽源职业技术学院', 'http://www.lyvtc.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 33, '', ''),
(3806, '1289787990', '四平职业大学', 'http://www.jlsppc.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 34, '', ''),
(3807, '1289787990', '松原职业技术学院', 'http://www.sypt.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 35, '', ''),
(3808, '1289787990', '吉林农业工程职业技术学院', 'http://www.jlnyxy.com.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 36, '', ''),
(3809, '1289787990', '白城职业技术学院', 'http://www.bcvit.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 37, '', ''),
(3810, '1289787990', '吉林司法警官职业学院', 'http://www.jlsfjx.com/', 0, 0, 0, 4084, 0, 1, 0, NULL, 38, '', ''),
(3811, '1289787990', '长春信息技术职业学院', 'http://www.citpc.net/', 0, 0, 0, 4084, 0, 1, 0, NULL, 39, '', ''),
(3812, '1289787990', '吉林电子信息职业技术学院', 'http://www.jltc.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 40, '', ''),
(3813, '1289787990', '吉林工业职业技术学院', 'http://www.jvcit.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 41, '', ''),
(3814, '1289787990', '长白山职业技术学院', 'http://www.cbsvtc.com.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 42, '', ''),
(3815, '1289787990', '吉林铁道职业技术学院', 'http://www.jtpt.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 43, '', ''),
(3816, '1289787990', '吉林科技职业技术学院', 'http://www.jilinkj.com/', 0, 0, 0, 4084, 0, 1, 0, NULL, 44, '', ''),
(3817, '1289787990', '吉林建筑工程装饰学院', 'http://www.jladi.com/', 0, 0, 0, 4084, 0, 1, 0, NULL, 45, '', ''),
(3818, '1289787990', '吉林省经济管理干部学院', 'http://www.jemcc.net/', 0, 0, 0, 4084, 0, 1, 0, NULL, 46, '', ''),
(3819, '1289787990', '长春大学光华学院', 'http://www.ccughc.net/', 0, 0, 0, 4084, 0, 1, 0, NULL, 47, '', ''),
(3820, '1289787990', '长春工业大学人文信息学院', 'http://www.ccutchi.com/', 0, 0, 0, 4084, 0, 1, 0, NULL, 48, '', ''),
(3821, '1289787990', '长春理工大学光电信息学院', 'http://www.csoei.com/', 0, 0, 0, 4084, 0, 1, 0, NULL, 49, '', ''),
(3822, '1289787990', '吉林财经大学信息经济学院', 'http://www.iecctc.com/', 0, 0, 0, 4084, 0, 1, 0, NULL, 50, '', ''),
(3823, '1289787990', '吉林农业大学发展学院', 'http://www.jlaudev.com.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 51, '', ''),
(3824, '1289787990', '东北师范大学人文学院', 'http://www.chsnenu.edu.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 52, '', ''),
(3825, '1289787990', '吉林师范大学博达学院', 'http://www.bdxy.com.cn/', 0, 0, 0, 4084, 0, 1, 0, NULL, 53, '', ''),
(3826, '1289787990', '长春大学旅游学院', 'http://www.cctourcollege.com/', 0, 0, 0, 4084, 0, 1, 0, NULL, 54, '', ''),
(3827, '1289787990', '吉林省教育学院', 'http://www.jledu.net/', 0, 0, 0, 4084, 0, 1, 0, NULL, 55, '', ''),
(3828, '1289788012', '新文化网论坛', 'http://bbs.xwhb.com/forum.php', 0, 0, 0, 4085, 0, 1, 0, NULL, 1, '', ''),
(3829, '1289788012', '长白论坛', 'http://bbs.chinajilin.com.cn/', 0, 0, 0, 4085, 0, 1, 0, NULL, 2, '', ''),
(3830, '1289788012', '搜狐社区-吉林', 'http://club.city.travel.sohu.com/l-jilin-0-0-0-0.html', 0, 0, 0, 4085, 0, 1, 0, NULL, 3, '', ''),
(3831, '1289788012', '吉林市论坛', 'http://www.jlbbs.cn/', 0, 0, 0, 4085, 0, 1, 0, NULL, 4, '', ''),
(3832, '1289788012', '吉林师大论坛', 'http://www.showus4u.com.cn/', 0, 0, 0, 4085, 0, 1, 0, NULL, 5, '', ''),
(3833, '1289788037', '气象局', 'http://www.jlqx.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 1, '', ''),
(3834, '1289788037', '商务厅', 'http://www.jldofcom.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 2, '', ''),
(3835, '1289788037', '工商局', 'http://www.jlgs.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 3, '', ''),
(3836, '1289788037', '消防总队', 'http://www.jl119.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 4, '', ''),
(3837, '1289788037', '邮政管理局', 'http://jl.chinapost.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 5, '', ''),
(3838, '1289788037', '妇联', 'http://women.jl.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 6, '', ''),
(3839, '1289788037', '工会', 'http://gh.jl.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 7, '', ''),
(3840, '1289788037', '残联', 'http://cl.jl.org.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 8, '', ''),
(3841, '1289788037', '发改委', 'http://www.jilin.cei.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 9, '', ''),
(3842, '1289788037', '教育厅', 'http://www.jledu.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 10, '', ''),
(3843, '1289788037', '交通运输厅', 'http://www.jljt.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 11, '', ''),
(3844, '1289788037', '监察厅', 'http://jct.jl.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 12, '', ''),
(3845, '1289788037', '食品药品监督管理局', 'http://www.jlda.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 13, '', ''),
(3846, '1289788037', '安全生产监督管理局', 'http://www.jlsafety.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 14, '', ''),
(3847, '1289788037', '质量技术监督局', 'http://www.jlqi.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 15, '', ''),
(3848, '1289788037', '民政厅', 'http://mzt.jl.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 16, '', ''),
(3849, '1289788037', '吉林市', 'http://www.jlcity.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 17, '', ''),
(3850, '1289788037', '通化市', 'http://www.tonghua.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 18, '', ''),
(3851, '1289788037', '松原市', 'http://www.jlsy.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 19, '', ''),
(3852, '1289788037', '白城市', 'http://www.bc.jl.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 20, '', ''),
(3853, '1289788037', '延边朝鲜自治州', 'http://www.yanbian.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 21, '', ''),
(3854, '1289788037', '辽源市', 'http://0437.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 22, '', ''),
(3855, '1289788037', '白山市', 'http://www.cbs.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 23, '', ''),
(3856, '1289788037', '四平市', 'http://www.siping.gov.cn/', 0, 0, 0, 4086, 0, 1, 0, NULL, 24, '', ''),
(3857, '1289788133', '生活知道网', 'http://www.shzhidao.cn/', 0, 0, 0, 4091, 0, 1, 0, NULL, 1, '', ''),
(3858, '1289788133', '哈尔滨信息港', 'http://www.96963.com/', 0, 0, 0, 4091, 0, 1, 0, NULL, 2, '', ''),
(3859, '1289788133', '绥化信息港', 'http://sh.hlj.net/', 0, 0, 0, 4091, 0, 1, 0, NULL, 3, '', ''),
(3860, '1289788133', '冰城网', 'http://www.bingchengwang.com/', 0, 0, 0, 4091, 0, 1, 0, NULL, 4, '', ''),
(3861, '1289788133', '大庆信息港', 'http://www.daqing.net/', 0, 0, 0, 4091, 0, 1, 0, NULL, 5, '', ''),
(3862, '1289788133', '大庆油田信息港', 'http://www.dqt.com.cn', 0, 0, 0, 4091, 0, 1, 0, NULL, 6, '', ''),
(3863, '1289788133', '伊春信息港', 'http://yc.hlj.net/', 0, 0, 0, 4091, 0, 1, 0, NULL, 7, '', ''),
(3864, '1289788133', '鹤岗信息港', 'http://hg.hlj.net/', 0, 0, 0, 4091, 0, 1, 0, NULL, 8, '', ''),
(3865, '1289788152', '新华网黑龙江频道', 'http://www.hlj.xinhua.org/', 0, 0, 0, 4092, 0, 1, 0, NULL, 1, '', ''),
(3866, '1289788152', '哈尔滨电视台', 'http://www.hrbtv.net/', 0, 0, 0, 4092, 0, 1, 0, NULL, 2, '', ''),
(3867, '1289788152', '哈尔滨新闻网', 'http://www.harbinnews.com/', 0, 0, 0, 4092, 0, 1, 0, NULL, 3, '', ''),
(3868, '1289788152', '哈尔滨日报', 'http://www.harbindaily.com/', 0, 0, 0, 4092, 0, 1, 0, NULL, 4, '', ''),
(3869, '1289788152', '大庆网', 'http://www.dqdaily.com/', 0, 0, 0, 4092, 0, 1, 0, NULL, 5, '', ''),
(3870, '1289788152', '黑龙江生活广播', 'http://www.1045.net/', 0, 0, 0, 4092, 0, 1, 0, NULL, 6, '', ''),
(3871, '1289788152', '牡丹江网', 'http://www.mdj.cn/', 0, 0, 0, 4092, 0, 1, 0, NULL, 7, '', ''),
(3872, '1289788152', '七台河新闻网', 'http://www.qthdaily.com/', 0, 0, 0, 4092, 0, 1, 0, NULL, 8, '', ''),
(3873, '1289788152', '哈尔滨IT网', 'http://www.hrbit.com/', 0, 0, 0, 4092, 0, 1, 0, NULL, 9, '', ''),
(3874, '1289788152', '东北网', 'http://www.dbw.cn/', 0, 0, 0, 4092, 0, 1, 0, NULL, 10, '', ''),
(3875, '1289788152', '黑龙江朝鲜民族', 'http://www.873k.com/', 0, 0, 0, 4092, 0, 1, 0, NULL, 11, '', ''),
(3876, '1289788171', '福彩', 'http://www.lottost.cn/', 0, 0, 0, 4093, 0, 1, 0, NULL, 1, '', ''),
(3877, '1289788171', '体彩', 'http://www.hljtcp.com/', 0, 0, 0, 4093, 0, 1, 0, NULL, 2, '', ''),
(3878, '1289788171', '移动', 'http://www.hl.10086.cn/', 0, 0, 0, 4093, 0, 1, 0, NULL, 3, '', ''),
(3879, '1289788171', '联通', 'http://www.hlj165.com/', 0, 0, 0, 4093, 0, 1, 0, NULL, 4, '', ''),
(3880, '1289788171', '电信', 'http://www.hljtele.com/', 0, 0, 0, 4093, 0, 1, 0, NULL, 5, '', ''),
(3881, '1289788171', '邮政', 'http://www.hljpost.com/', 0, 0, 0, 4093, 0, 1, 0, NULL, 6, '', ''),
(3882, '1289788171', '专家门诊', 'http://heilongjiang.haodf.com/', 0, 0, 0, 4093, 0, 1, 0, NULL, 7, '', ''),
(3883, '1289788171', '列车时刻', 'http://lieche.5w.com/', 0, 0, 0, 4093, 0, 1, 0, NULL, 8, '', ''),
(3884, '1289788171', '龙江二手车', 'http://www.2sche.cn/', 0, 0, 0, 4093, 0, 1, 0, NULL, 9, '', ''),
(3885, '1289788171', '天气预报', 'http://www.weather.com.cn/heilongjiang/index.shtml', 0, 0, 0, 4093, 0, 1, 0, NULL, 10, '', ''),
(3886, '1289788171', '黑龙江地图网', 'http://hlj.uemap.com/', 0, 0, 0, 4093, 0, 1, 0, NULL, 11, '', ''),
(3887, '1289788171', '公交查询', 'http://haerbin.8684.cn/', 0, 0, 0, 4093, 0, 1, 0, NULL, 12, '', ''),
(3888, '1289788171', '火车票预订', 'http://www.huoche.com/dingpiao/sheng/heilongjiang', 0, 0, 0, 4093, 0, 1, 0, NULL, 13, '', ''),
(3889, '1289788171', '哈尔滨旅游网', 'http://www.hljtour.com/', 0, 0, 0, 4093, 0, 1, 0, NULL, 14, '', ''),
(3890, '1289788171', '机票预订', 'http://www.17u.com/jipiao/jp-170/', 0, 0, 0, 4093, 0, 1, 0, NULL, 15, '', ''),
(3891, '1289788171', '酒店预订', 'http://hotels.ctrip.com/hotel/haerbin5/', 0, 0, 0, 4093, 0, 1, 0, NULL, 16, '', ''),
(3892, '1289788195', '哈尔滨工业大学', 'http://www.hit.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 1, '', ''),
(3893, '1289788195', '哈尔滨工程大学', 'http://www.hrbeu.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 2, '', ''),
(3894, '1289788195', '东北林业大学', 'http://www.nefu.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 3, '', ''),
(3895, '1289788195', '黑龙江大学', 'http://www.hlju.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 4, '', ''),
(3896, '1289788195', '哈尔滨师范大学', 'http://www.hrbnu.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 5, '', ''),
(3897, '1289788195', '哈尔滨医科大学', 'http://www.hrbmu.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 6, '', ''),
(3898, '1289788195', '哈尔滨理工大学', 'http://www.hrbust.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 7, '', ''),
(3899, '1289788195', '东北农业大学', 'http://www.neau.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 8, '', ''),
(3900, '1289788195', '佳木斯大学', 'http://www.jmsu.org/', 0, 0, 0, 4094, 0, 1, 0, NULL, 9, '', ''),
(3901, '1289788195', '哈尔滨商业大学', 'http://www.hljcu.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 10, '', ''),
(3902, '1289788195', '黑龙江中医药大学', 'http://www.hljucm.net/', 0, 0, 0, 4094, 0, 1, 0, NULL, 11, '', ''),
(3903, '1289788195', '黑龙江省教育学院', 'http://www.hljy.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 12, '', ''),
(3904, '1289788195', '黑龙江八一农垦大学', 'http://www.hlau.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 13, '', ''),
(3905, '1289788195', '黑龙江信息技术职业学院', 'http://www.hljitpc.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 14, '', ''),
(3906, '1289788195', '黑龙江旅游职业技术学院', 'http://www.ljly.net/', 0, 0, 0, 4094, 0, 1, 0, NULL, 15, '', ''),
(3907, '1289788195', '哈尔滨德强商务学院', 'http://www.hrbtc.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 16, '', ''),
(3908, '1289788195', '鸡西大学', 'http://www.jxdx.net', 0, 0, 0, 4094, 0, 1, 0, NULL, 17, '', ''),
(3909, '1289788195', '哈尔滨学院', 'http://www.hrbu.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 18, '', ''),
(3910, '1289788195', '绥化学院', 'http://www.shxy.net/', 0, 0, 0, 4094, 0, 1, 0, NULL, 19, '', ''),
(3911, '1289788195', '齐齐哈尔医学院', 'http://www.qqhrmc.net.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 20, '', ''),
(3912, '1289788195', '大庆师范学院', 'http://www.dqsy.net/', 0, 0, 0, 4094, 0, 1, 0, NULL, 21, '', ''),
(3913, '1289788195', '牡丹江师范学院', 'http://www.mdjnu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 22, '', ''),
(3914, '1289788195', '黑龙江农业工程职业学院', 'http://www.hngzy.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 23, '', ''),
(3915, '1289788195', '黑龙江东方学院', 'http://www.dfxy.net/', 0, 0, 0, 4094, 0, 1, 0, NULL, 24, '', ''),
(3916, '1289788195', '黑龙江司法警官职业学院', 'http://www.hlsfjx.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 25, '', ''),
(3917, '1289788195', '大庆职业学院', 'http://www.dqzyxy.net/', 0, 0, 0, 4094, 0, 1, 0, NULL, 26, '', ''),
(3918, '1289788195', '黑龙江工程学院', 'http://www.hljit.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 27, '', ''),
(3919, '1289788195', '齐齐哈尔大学', 'http://www.qqhru.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 28, '', ''),
(3920, '1289788195', '黑龙江科技学院', 'http://www.usth.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 29, '', ''),
(3921, '1289788195', '黑龙江省政法管理干部学院', 'http://www.hljzfxy.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 30, '', ''),
(3922, '1289788195', '牡丹江医学院', 'http://www.mdjmu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 31, '', ''),
(3923, '1289788195', '牡丹江大学', 'http://www.mdjdx.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 32, '', ''),
(3924, '1289788195', '哈尔滨体育学院', 'http://www.hrbipe.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 33, '', ''),
(3925, '1289788195', '黑龙江建筑职业技术学院', 'http://www.hcc.net.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 34, '', ''),
(3926, '1289788195', '哈尔滨金融学院', 'http://www.hrbjz.edu.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 35, '', ''),
(3927, '1289788195', '黑龙江省农垦管理干部学院', 'http://www.nkgy.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 36, '', ''),
(3928, '1289788195', '大庆医学高等专科学校', 'http://dqyz.petrodaqing.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 37, '', ''),
(3929, '1289788195', '齐齐哈尔高等师范专科学校', 'http://www.qqhrtc.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 38, '', ''),
(3930, '1289788195', '黑龙江幼儿师范高等专科学校', 'http://www.hljys.cn/main/', 0, 0, 0, 4094, 0, 1, 0, NULL, 39, '', ''),
(3931, '1289788195', '鹤岗师范高等专科学校', 'http://www.hgtc.org.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 40, '', ''),
(3932, '1289788195', '黑龙江畜牧兽医职业学院', 'http://www.hmy.com.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 41, '', ''),
(3933, '1289788195', '黑龙江农业工程职业学院', 'http://www.hngzy.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 42, '', ''),
(3934, '1289788195', '伊春职业学院', 'http://www.ycvc.com.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 43, '', ''),
(3935, '1289788195', '黑龙江农垦职业学院', 'http://www.nkzy.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 44, '', ''),
(3936, '1289788195', '齐齐哈尔职业学院', 'http://www.hdyu.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 45, '', ''),
(3937, '1289788195', '哈尔滨市职工医学院', 'http://www.hrbszgyxy.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 46, '', ''),
(3938, '1289788195', '哈尔滨现代公共关系职业学院', 'http://www.hljpr0451.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 47, '', ''),
(3939, '1289788195', '七台河职业学院', 'http://www.qthzyxy.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 48, '', ''),
(3940, '1289788195', '哈尔滨应用职业技术学院', 'http://www.hyyzy.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 49, '', ''),
(3941, '1289788195', '黑龙江交通职业技术学院', 'http://www.hlcp.com.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 50, '', ''),
(3942, '1289788195', '黑龙江工商职业技术学院', 'http://www.hcic.gov.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 51, '', ''),
(3943, '1289788195', '黑龙江工程学院昆仑旅游学院', 'http://www.kllyxy.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 52, '', ''),
(3944, '1289788195', '哈尔滨电力职业技术学院', 'http://hepotc.hl.sgcc.com.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 53, '', ''),
(3945, '1289788195', '哈尔滨铁道职业技术学院', 'http://www.htxy.net/', 0, 0, 0, 4094, 0, 1, 0, NULL, 54, '', ''),
(3946, '1289788195', '大兴安岭职业学院', 'http://www.dxalu.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 55, '', ''),
(3947, '1289788195', '黑龙江农业经济职业学院', 'http://www.nyjj.net.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 56, '', ''),
(3948, '1289788195', '哈尔滨江南职业技术学院', 'http://www.13451.cn/Index.html', 0, 0, 0, 4094, 0, 1, 0, NULL, 57, '', ''),
(3949, '1289788195', '黑龙江商业职业学院', 'http://www.hljszy.net/', 0, 0, 0, 4094, 0, 1, 0, NULL, 58, '', ''),
(3950, '1289788195', '黑龙江农垦科技职业学院', 'http://www.nknzy.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 59, '', ''),
(3951, '1289788195', '黑龙江公安警官职业学院', 'http://www.hlpolice.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 60, '', ''),
(3952, '1289788195', '黑龙江生物科技职业学院', 'http://www.swkj.net/', 0, 0, 0, 4094, 0, 1, 0, NULL, 61, '', ''),
(3953, '1289788195', '黑龙江粮食职业学院', 'http://www.hljgvc.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 62, '', ''),
(3954, '1289788195', '哈尔滨科学技术职业学院', 'http://www.hrbkjzy.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 63, '', ''),
(3955, '1289788195', '佳木斯职业学院', 'http://www.jmsjs.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 64, '', ''),
(3956, '1289788195', '黑龙江生态工程职业学院', 'http://www.hfmc.net/', 0, 0, 0, 4094, 0, 1, 0, NULL, 65, '', ''),
(3957, '1289788195', '黑龙江煤炭职业技术学院', 'http://www.hmzy.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 66, '', ''),
(3958, '1289788195', '黑龙江三江美术职业学院', 'http://www.sjmsxy.net.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 67, '', ''),
(3959, '1289788195', '黑龙江民族职业学院', 'http://www.mvcollege.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 68, '', ''),
(3960, '1289788195', '黑龙江艺术职业学院', 'http://www.hljyzy.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 69, '', ''),
(3961, '1289788195', '哈尔滨理工大学远东学院', 'http://www.fe-edu.com.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 70, '', ''),
(3962, '1289788195', '哈尔滨师范大学恒星学院', 'http://www.starcollege.com.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 71, '', ''),
(3963, '1289788195', '哈尔滨工业大学华德学院', 'http://www.hithd.net/', 0, 0, 0, 4094, 0, 1, 0, NULL, 72, '', ''),
(3964, '1289788195', '黑龙江工程学院昆仑旅游学院', 'http://www.kllyxy.com/', 0, 0, 0, 4094, 0, 1, 0, NULL, 73, '', ''),
(3965, '1289788195', '黑龙江大学剑桥学院', 'http://www.jqu.net.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 74, '', ''),
(3966, '1289788195', '哈尔滨商业大学广厦学院', 'http://www.gsxy.cn/', 0, 0, 0, 4094, 0, 1, 0, NULL, 75, '', ''),
(3967, '1289788213', '黑龙江贴吧', 'http://tieba.baidu.com/f?kw=%BA%DA%C1%FA%BD%AD', 0, 0, 0, 4095, 0, 1, 0, NULL, 1, '', ''),
(3968, '1289788213', '龙广在线论坛', 'http://bbs.hljradio.com/', 0, 0, 0, 4095, 0, 1, 0, NULL, 2, '', ''),
(3969, '1289788213', '哈尔滨贴吧', 'http://tieba.baidu.com/f?kw=%B9%FE%B6%FB%B1%F5', 0, 0, 0, 4095, 0, 1, 0, NULL, 3, '', ''),
(3970, '1289788213', '佳人网', 'http://jmser.com/', 0, 0, 0, 4095, 0, 1, 0, NULL, 4, '', ''),
(3971, '1289788213', '双鸭山热线', 'http://www.0469.cn/', 0, 0, 0, 4095, 0, 1, 0, NULL, 5, '', ''),
(3972, '1289788213', '黑河体育在线', 'http://www.xrlq.com.cn/', 0, 0, 0, 4095, 0, 1, 0, NULL, 6, '', ''),
(3973, '1289788213', '绥化家园', 'http://shjy.5d6d.com/', 0, 0, 0, 4095, 0, 1, 0, NULL, 7, '', ''),
(3974, '1289788213', '大兴安岭部落', 'http://www.dxal.org/', 0, 0, 0, 4095, 0, 1, 0, NULL, 8, '', ''),
(3975, '1289788213', '江北论坛', 'http://www.jiangbei8.cn/', 0, 0, 0, 4095, 0, 1, 0, NULL, 9, '', ''),
(3976, '1289788213', '黑龙江都市生活', 'http://www.16789.com.cn/', 0, 0, 0, 4095, 0, 1, 0, NULL, 10, '', ''),
(3977, '1289788213', '黑龙江信息港论坛', 'http://bbs.hlj.net/', 0, 0, 0, 4095, 0, 1, 0, NULL, 11, '', ''),
(3978, '1289788233', '气象局', 'http://www.hljmb.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 1, '', ''),
(3979, '1289788233', '旅游局', 'http://www.hljtour.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 2, '', ''),
(3980, '1289788233', '招生考试委员会', 'http://www.lzk.hl.cn', 0, 0, 0, 4096, 0, 1, 0, NULL, 3, '', ''),
(3981, '1289788233', '人事局', 'http://www.hrbrsj.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 4, '', ''),
(3982, '1289788233', '旅游局', 'http://www.hljtour.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 5, '', ''),
(3983, '1289788233', '通信管理局', 'http://www.hlca.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 6, '', ''),
(3984, '1289788233', '统计局', 'http://www.hlj.stats.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 7, '', ''),
(3985, '1289788233', '科学技术厅', 'http://www.hljkjt.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 8, '', ''),
(3986, '1289788233', '国有资产监督管理', 'http://www.hljgzw.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 9, '', ''),
(3987, '1289788233', '发改委', 'http://www.hljdpc.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 10, '', ''),
(3988, '1289788233', '齐齐哈尔市', 'http://www.qqhr.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 11, '', ''),
(3989, '1289788233', '牡丹江市', 'http://www.mdj.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 12, '', ''),
(3990, '1289788233', '佳木斯市', 'http://www.jms.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 13, '', ''),
(3991, '1289788233', '大庆市', 'http://www.daqing.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 14, '', ''),
(3992, '1289788233', '鸡西市', 'http://www.jixi.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 15, '', ''),
(3993, '1289788233', '双鸭山市', 'http://www.shuangyashan.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 16, '', ''),
(3994, '1289788233', '伊春市', 'http://www.yc.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 17, '', ''),
(3995, '1289788233', '七台河市', 'http://www.qth.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 18, '', ''),
(3996, '1289788233', '黑河市', 'http://www.heihe.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 19, '', ''),
(3997, '1289788233', '绥化市', 'http://www.suihua.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 20, '', ''),
(3998, '1289788233', '大兴安岭地区', 'http://www.dxal.gov.cn/', 0, 0, 0, 4096, 0, 1, 0, NULL, 21, '', ''),
(3999, '1279617741', '联合国中文站', 'http://www.un.org/chinese/', 0, 0, 0, 3053, 0, 1, 0, NULL, 1, '', ''),
(4000, '1279617741', '联合早报', 'http://www.zaobao.com/', 0, 0, 0, 3053, 0, 1, 0, NULL, 2, '', ''),
(4001, '1279617741', '朝鲜日报中文版', 'http://chn.chosun.com/', 0, 0, 0, 3053, 0, 1, 0, NULL, 3, '', ''),
(4002, '1279617741', '美国中文网', 'http://www.sinovision.net/', 0, 0, 0, 3053, 0, 1, 0, NULL, 4, '', ''),
(4003, '1279617741', '星岛环球网', 'http://www.stnn.cc/', 0, 0, 0, 3053, 0, 1, 0, NULL, 5, '', ''),
(4004, '1279617741', '加拿大华人网', 'http://www.sinonet.net/', 0, 0, 0, 3053, 0, 1, 0, NULL, 6, '', ''),
(4005, '1279617741', '维基百科', 'http://zh.wikipedia.org/zh-cn/', 0, 0, 0, 3053, 0, 1, 0, NULL, 7, '', ''),
(4006, '1279617741', '俄罗斯之声中文台', 'http://www.ruvr.ru/index.php?lng=pek', 0, 0, 0, 3053, 0, 1, 0, NULL, 8, '', ''),
(4007, '1279617741', 'KBS韩国国际电台', 'http://world.kbs.co.kr/chinese/', 0, 0, 0, 3053, 0, 1, 0, NULL, 9, '', ''),
(4008, '1279617741', '瑞士中文网', 'http://www.swissinfo.ch/chi/index.html', 0, 0, 0, 3053, 0, 1, 0, NULL, 10, '', ''),
(4009, '1279617741', '乐在韩国', 'http://bbs.enjoykorea.net/', 0, 0, 0, 3053, 0, 1, 0, NULL, 11, '', ''),
(4010, '1279617741', '加拿大家园', 'http://www.canadameet.com/', 0, 0, 0, 3053, 0, 1, 0, NULL, 12, '', ''),
(4011, '1279617741', '奋斗在韩国', 'http://bbs.icnkr.com/', 0, 0, 0, 3053, 0, 1, 0, NULL, 13, '', ''),
(4012, '1279617741', '星岛日报', 'http://www.singtao.com/', 0, 0, 0, 3053, 0, 1, 0, NULL, 14, '', ''),
(4013, '1279617741', '韩国联合通讯社', 'http://chinese.yonhapnews.co.kr/', 0, 0, 0, 3053, 0, 1, 0, NULL, 15, '', ''),
(4014, '1279617741', '新欧洲', 'http://bbs.revefrance.com/', 0, 0, 0, 3053, 0, 1, 0, NULL, 16, '', ''),
(4015, '1279617741', '俄罗斯新闻网', 'http://rusnews.cn/', 0, 0, 0, 3053, 0, 1, 0, NULL, 17, '', ''),
(4016, '1279617741', '美国驻华使馆', 'http://chinese.usembassy-china.org.cn/', 0, 0, 0, 3053, 0, 1, 0, NULL, 18, '', ''),
(4017, '1279617741', 'Yahoo', 'http://www.yahoo.com/', 0, 0, 0, 3054, 0, 1, 0, NULL, 1, '', ''),
(4018, '1279617741', 'Google', 'http://www.google.com/', 0, 0, 0, 3054, 0, 1, 0, NULL, 2, '', ''),
(4019, '1279617741', 'MSN', 'http://www.msn.com/', 0, 0, 0, 3054, 0, 1, 0, NULL, 3, '', ''),
(4020, '1279617741', 'EBay', 'http://www.ebay.com/', 0, 0, 0, 3054, 0, 1, 0, NULL, 4, '', ''),
(4021, '1279617741', 'CNN', 'http://www.cnn.com/', 0, 0, 0, 3054, 0, 1, 0, NULL, 5, '', ''),
(4022, '1279617741', 'Myspace', 'http://www.myspace.com/', 0, 0, 0, 3054, 0, 1, 0, NULL, 6, '', ''),
(4023, '1279617741', 'Amazon', 'http://www.amazon.com/', 0, 0, 0, 3054, 0, 1, 0, NULL, 7, '', ''),
(4024, '1279617741', 'naver', 'http://www.naver.com/', 0, 0, 0, 3054, 0, 1, 0, NULL, 8, '', ''),
(4025, '1279617741', 'AOL', 'http://www.aol.com/', 0, 0, 0, 3054, 0, 1, 0, NULL, 9, '', ''),
(4026, '1279617741', 'BBC', 'http://www.bbc.co.uk/', 0, 0, 0, 3054, 0, 1, 0, NULL, 10, '', ''),
(4027, '1279617741', '法新社', 'http://www.afp.com/', 0, 0, 0, 3055, 0, 1, 0, NULL, 1, '', ''),
(4028, '1279617741', '华盛顿邮报', 'http://www.washingtonpost.com/', 0, 0, 0, 3055, 0, 1, 0, NULL, 2, '', ''),
(4029, '1279617741', '纽约时报', 'http://www.nytimes.com/', 0, 0, 0, 3055, 0, 1, 0, NULL, 3, '', ''),
(4030, '1279617741', '卫报(英)', 'http://www.guardian.co.uk/', 0, 0, 0, 3055, 0, 1, 0, NULL, 4, '', ''),
(4031, '1279617741', '美联社', 'http://www.ap.org/', 0, 0, 0, 3055, 0, 1, 0, NULL, 5, '', ''),
(4032, '1279617741', '读卖新闻(日)', 'http://www.yomiuri.co.jp/', 0, 0, 0, 3055, 0, 1, 0, NULL, 6, '', ''),
(4033, '1279617741', '美国国家地理杂志', 'http://www.nationalgeographic.com/', 0, 0, 0, 3055, 0, 1, 0, NULL, 7, '', ''),
(4034, '1279617741', '美国科学杂志', 'http://www.sciencemag.org/', 0, 0, 0, 3055, 0, 1, 0, NULL, 8, '', ''),
(4035, '1279617741', '福布斯(美)', 'http://www.forbes.com/', 0, 0, 0, 3055, 0, 1, 0, NULL, 9, '', ''),
(4036, '1279617741', '路透社(英)', 'http://www.reuters.com/', 0, 0, 0, 3055, 0, 1, 0, NULL, 10, '', ''),
(4037, '1279617741', '简氏防务周刊(英)', 'http://www.janes.com/', 0, 0, 0, 3055, 0, 1, 0, NULL, 11, '', ''),
(4038, '1279617741', '时代周刊', 'http://www.time.com/', 0, 0, 0, 3055, 0, 1, 0, NULL, 12, '', ''),
(4039, '1279617741', '联合国官方站', 'http://www.un.org/', 0, 0, 0, 3055, 0, 1, 0, NULL, 13, '', ''),
(4040, '1279617741', '世贸组织WTO', 'http://www.wto.org/', 0, 0, 0, 3055, 0, 1, 0, NULL, 14, '', ''),
(4041, '1279617741', '奥斯卡电影节', 'http://www.oscar.com/', 0, 0, 0, 3055, 0, 1, 0, NULL, 15, '', ''),
(4042, '1279617741', '世界卫生组织(WHO)', 'http://www.who.int/', 0, 0, 0, 3055, 0, 1, 0, NULL, 16, '', ''),
(4043, '1279617741', '诺贝尔奖委员会', 'http://nobelprize.org/', 0, 0, 0, 3055, 0, 1, 0, NULL, 17, '', ''),
(4044, '1279617741', '国际奥委会', 'http://www.olympic.org/', 0, 0, 0, 3055, 0, 1, 0, NULL, 18, '', ''),
(4045, '1279617741', '国际足联', 'http://www.fifa.com/', 0, 0, 0, 3055, 0, 1, 0, NULL, 19, '', ''),
(4046, '1279617741', 'NBA官方站', 'http://www.nba.com/', 0, 0, 0, 3055, 0, 1, 0, NULL, 20, '', ''),
(4047, '1289788349', '南京金陵热线', 'http://www.jlonline.com/', 0, 0, 0, 4101, 0, 1, 0, NULL, 1, '', ''),
(4048, '1289788349', '江苏都市网', 'http://www.dsqq.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 2, '', ''),
(4049, '1289788349', '无锡太湖明珠', 'http://www.thmz.com/', 0, 0, 0, 4101, 0, 1, 0, NULL, 3, '', ''),
(4050, '1289788349', '名城苏州', 'http://www.2500sz.com/', 0, 0, 0, 4101, 0, 1, 0, NULL, 4, '', ''),
(4051, '1289788349', '梦溪论坛', 'http://bbs.my0511.com/', 0, 0, 0, 4101, 0, 1, 0, NULL, 5, '', ''),
(4052, '1289788349', '扬州网', 'http://www.yznews.com.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 6, '', ''),
(4053, '1289788349', '启吾东疆', 'http://bbs.qidong.gov.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 7, '', ''),
(4054, '1289788349', '吴江信息港', 'http://www.wj.js.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 8, '', ''),
(4055, '1289788349', '苏州热线', 'http://www.sz.js.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 9, '', ''),
(4056, '1289788349', '无锡阿福台', 'http://www.wuxi.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 10, '', ''),
(4057, '1289788349', '扬州热线', 'http://jsyz.vnet.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 11, '', ''),
(4058, '1289788349', '张家港金港热线', 'http://www.zjg.js.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 12, '', ''),
(4059, '1289788349', '常州信息港', 'http://www.czinfo.net/', 0, 0, 0, 4101, 0, 1, 0, NULL, 13, '', ''),
(4060, '1289788349', '无锡新传媒', 'http://www.wxrb.com/', 0, 0, 0, 4101, 0, 1, 0, NULL, 14, '', ''),
(4061, '1289788349', '徐州彭城视窗', 'http://jsxz.vnet.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 15, '', ''),
(4062, '1289788349', '太仓视窗', 'http://www.tc.jsinfo.net/', 0, 0, 0, 4101, 0, 1, 0, NULL, 16, '', ''),
(4063, '1289788349', '南通热线', 'http://jsnt.vnet.cn/2010/', 0, 0, 0, 4101, 0, 1, 0, NULL, 17, '', ''),
(4064, '1289788349', '淮安网', 'http://www.huaian.com/%20', 0, 0, 0, 4101, 0, 1, 0, NULL, 18, '', ''),
(4065, '1289788349', '陶都热线', 'http://www.yx.js.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 19, '', ''),
(4066, '1289788349', '常州网', 'http://www.cz001.com.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 20, '', ''),
(4067, '1289788349', '常熟虞城热线', 'http://www.cs.js.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 21, '', ''),
(4068, '1289788349', '昆山视窗', 'http://www.ks.js.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 22, '', ''),
(4069, '1289788349', '溧阳信息港', 'http://www.ly.js.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 23, '', ''),
(4070, '1289788349', '无锡二泉网', 'http://www.wst.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 24, '', ''),
(4071, '1289788349', '盐城热线', 'http://jsyc.vnet.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 25, '', ''),
(4072, '1289788349', '中国徐州网', 'http://www.cnxz.com.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 26, '', ''),
(4073, '1289788349', '连云港信息港', 'http://jslyg.vnet.cn/', 0, 0, 0, 4101, 0, 1, 0, NULL, 27, '', ''),
(4074, '1289788369', '新华报业', 'http://www.xhby.net/', 0, 0, 0, 4102, 0, 1, 0, NULL, 1, '', ''),
(4075, '1289788369', '南京报业', 'http://www.njnews.cn/', 0, 0, 0, 4102, 0, 1, 0, NULL, 2, '', ''),
(4076, '1289788369', '江苏法制报', 'http://www.jslegal.com/', 0, 0, 0, 4102, 0, 1, 0, NULL, 3, '', ''),
(4077, '1289788369', '镇江网友之家', 'http://www.my0511.com/', 0, 0, 0, 4102, 0, 1, 0, NULL, 4, '', ''),
(4078, '1289788369', '淮安网', 'http://www.huaian.com/', 0, 0, 0, 4102, 0, 1, 0, NULL, 5, '', ''),
(4079, '1289788369', '新华网江苏频道', 'http://www.js.xinhuanet.com/', 0, 0, 0, 4102, 0, 1, 0, NULL, 6, '', ''),
(4080, '1289788369', '二泉网', 'http://www.wst.cn/', 0, 0, 0, 4102, 0, 1, 0, NULL, 7, '', ''),
(4081, '1289788369', '太仓视察', 'http://www.tc.cn/', 0, 0, 0, 4102, 0, 1, 0, NULL, 8, '', ''),
(4082, '1289788369', '太湖明珠', 'http://www.thmz.com/', 0, 0, 0, 4102, 0, 1, 0, NULL, 9, '', ''),
(4083, '1289788369', '名城苏州', 'http://www.2500sz.com/', 0, 0, 0, 4102, 0, 1, 0, NULL, 10, '', ''),
(4084, '1289788369', '江苏省广播电视总台', 'http://www.jsbc.com/', 0, 0, 0, 4102, 0, 1, 0, NULL, 11, '', ''),
(4085, '1289788369', '苏州新闻网', 'http://www.subaonet.com/', 0, 0, 0, 4102, 0, 1, 0, NULL, 12, '', ''),
(4086, '1289788369', '吴江信息港', 'http://www.wj.js.cn/', 0, 0, 0, 4102, 0, 1, 0, NULL, 13, '', ''),
(4087, '1289788369', '淮安新闻网', 'http://www.hynews.net/', 0, 0, 0, 4102, 0, 1, 0, NULL, 14, '', ''),
(4088, '1289788369', '扬州日报', 'http://www.yznews.com.cn/yzrb/', 0, 0, 0, 4102, 0, 1, 0, NULL, 15, '', ''),
(4089, '1289788369', '无锡新传媒', 'http://www.wxrb.com/', 0, 0, 0, 4102, 0, 1, 0, NULL, 16, '', ''),
(4090, '1289788369', '新华日报', 'http://xh.xhby.net/newxh/', 0, 0, 0, 4102, 0, 1, 0, NULL, 17, '', ''),
(4091, '1289788369', '连云港传媒网', 'http://www.lygmedia.com/', 0, 0, 0, 4102, 0, 1, 0, NULL, 18, '', ''),
(4092, '1289788369', '天天泰州', 'http://www.t56.net/', 0, 0, 0, 4102, 0, 1, 0, NULL, 19, '', ''),
(4093, '1289788369', '无锡阿福台', 'http://www.wst.net.cn/', 0, 0, 0, 4102, 0, 1, 0, NULL, 20, '', ''),
(4094, '1289788369', '虞城热线', 'http://www.cs.js.cn/', 0, 0, 0, 4102, 0, 1, 0, NULL, 21, '', ''),
(4095, '1289788369', '金港热线', 'http://www.zjg.js.cn/', 0, 0, 0, 4102, 0, 1, 0, NULL, 22, '', ''),
(4096, '1289788369', '江阴信息港', 'http://www.jy.js.cn/', 0, 0, 0, 4102, 0, 1, 0, NULL, 23, '', ''),
(4097, '1289788369', '昆仑山日报', 'http://www.ksrb.cn/', 0, 0, 0, 4102, 0, 1, 0, NULL, 24, '', ''),
(4098, '1289788369', '宿迁新闻网', 'http://www.sqdaily.com/', 0, 0, 0, 4102, 0, 1, 0, NULL, 25, '', ''),
(4099, '1289788391', '福彩', 'http://www.jslottery.com/', 0, 0, 0, 4103, 0, 1, 0, NULL, 1, '', ''),
(4100, '1289788391', '体彩', 'http://www.js-lottery.com/', 0, 0, 0, 4103, 0, 1, 0, NULL, 2, '', ''),
(4101, '1289788391', '移动', 'http://www.js.10086.cn/', 0, 0, 0, 4103, 0, 1, 0, NULL, 3, '', ''),
(4102, '1289788391', '联通', 'http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?id=&amp;amp;arno=00010008', 0, 0, 0, 4103, 0, 1, 0, NULL, 4, '', ''),
(4103, '1289788391', '电信', 'http://js.ct10000.com/', 0, 0, 0, 4103, 0, 1, 0, NULL, 5, '', ''),
(4104, '1289788391', '专家门诊', 'http://jiangsu.haodf.com/', 0, 0, 0, 4103, 0, 1, 0, NULL, 6, '', ''),
(4105, '1289788391', '南京家政', 'http://nanjing.jzcn.net/City/5/', 0, 0, 0, 4103, 0, 1, 0, NULL, 7, '', ''),
(4106, '1289788391', '百姓广场', 'http://www.88bx.com/', 0, 0, 0, 4103, 0, 1, 0, NULL, 8, '', ''),
(4107, '1289788391', '南京车管所', 'http://www.njcgs.com/', 0, 0, 0, 4103, 0, 1, 0, NULL, 9, '', ''),
(4108, '1289788391', '天气预报', 'http://www.weather.com.cn/jiangsu/index.shtml', 0, 0, 0, 4103, 0, 1, 0, NULL, 10, '', ''),
(4109, '1289788391', '公交查询', 'http://nanjing.8684.cn/', 0, 0, 0, 4103, 0, 1, 0, NULL, 11, '', ''),
(4110, '1289788391', '南京地铁', 'http://www.nj-dt.com/', 0, 0, 0, 4103, 0, 1, 0, NULL, 12, '', ''),
(4111, '1289788391', '火车票预订', 'http://www.huoche.com/dingpiao/sheng/jiangsu', 0, 0, 0, 4103, 0, 1, 0, NULL, 13, '', ''),
(4112, '1289788391', '禄口国际机场', 'http://www.njiairport.com/', 0, 0, 0, 4103, 0, 1, 0, NULL, 14, '', ''),
(4113, '1289788391', '南京火车站', 'http://www.njstation.com/', 0, 0, 0, 4103, 0, 1, 0, NULL, 15, '', ''),
(4114, '1289788391', '无锡3D地图', 'http://www.3dwuxi.com/', 0, 0, 0, 4103, 0, 1, 0, NULL, 16, '', ''),
(4115, '1289788427', '南京大学', 'http://www.nju.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 1, '', ''),
(4116, '1289788427', '东南大学', 'http://www.seu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 2, '', ''),
(4117, '1289788427', '江南大学', 'http://www.sytu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 3, '', ''),
(4118, '1289788427', '河海大学', 'http://www.hhu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 4, '', ''),
(4119, '1289788427', '南京航空航天大学', 'http://www.nuaa.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 5, '', ''),
(4120, '1289788427', '中国矿业大学', 'http://www.cumt.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 6, '', ''),
(4121, '1289788427', '南京信息工程大学', 'http://www.nuist.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 7, '', ''),
(4122, '1289788427', '江苏科技大学', 'http://www.ecsi.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 8, '', ''),
(4123, '1289788427', '南京林业大学', 'http://www.njfu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 9, '', ''),
(4124, '1289788427', '南京邮电大学', 'http://www.njupt.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 10, '', ''),
(4125, '1289788427', '南京农业大学', 'http://www.njau.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 11, '', ''),
(4126, '1289788427', '南京医科大学', 'http://www.njmu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 12, '', ''),
(4127, '1289788427', '南京中医药大学', 'http://www.njutcm.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 13, '', ''),
(4128, '1289788427', '南京工业大学', 'http://www.njut.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 14, '', ''),
(4129, '1289788427', '南京理工大学', 'http://www.njust.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 15, '', ''),
(4130, '1289788427', '中国药科大学', 'http://www.cpu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 16, '', ''),
(4131, '1289788427', '南京师范大学', 'http://www.njnu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 17, '', ''),
(4132, '1289788427', '南京财经大学', 'http://www.njue.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 18, '', ''),
(4133, '1289788427', '江苏大学', 'http://www.ujs.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 19, '', ''),
(4134, '1289788427', '苏州大学', 'http://www.suda.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 20, '', ''),
(4135, '1289788427', '南通大学', 'http://www.ntu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 21, '', ''),
(4136, '1289788427', '扬州大学', 'http://www.yzu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 22, '', ''),
(4137, '1289788427', '南京工程学院', 'http://www.njit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 23, '', ''),
(4138, '1289788427', '常州工学院', 'http://www.czu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 24, '', ''),
(4139, '1289788427', '江苏警官学院', 'http://www.jspi.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 25, '', ''),
(4140, '1289788427', '南京审计学院', 'http://www.nau.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 26, '', ''),
(4141, '1289788427', '江苏技术师范学院', 'http://www.jstu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 27, '', ''),
(4142, '1289788427', '苏州科技学院', 'http://web.usts.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 28, '', ''),
(4143, '1289788427', '常熟理工学院', 'http://www.cslg.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 29, '', ''),
(4144, '1289788427', '南京体育学院', 'http://www.nipes.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 30, '', ''),
(4145, '1289788427', '淮阴师范学院', 'http://www.hytc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 31, '', ''),
(4146, '1289788427', '南京晓庄学院', 'http://www.njxzc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 32, '', ''),
(4147, '1289788427', '盐城师范学院', 'http://www.yctc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 33, '', ''),
(4148, '1289788427', '三江学院', 'http://www.sju.js.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 34, '', ''),
(4149, '1289788427', '徐州建筑职业技术学院', 'http://www.xzcat.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 35, '', ''),
(4150, '1289788427', '盐城工学院', 'http://www.ycit.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 36, '', ''),
(4151, '1289788427', '常州大学', 'http://www.cczu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 37, '', ''),
(4152, '1289788427', '徐州师范大学', 'http://www.xznu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 38, '', ''),
(4153, '1289788427', '常州机电职业技术学院', 'http://www.czmec.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 39, '', ''),
(4154, '1289788427', '徐州医学院', 'http://www.xzmc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 40, '', ''),
(4155, '1289788427', '徐州工程学院', 'http://www.xzit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 41, '', ''),
(4156, '1289788427', '南京艺术学院', 'http://www.njarti.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 42, '', ''),
(4157, '1289788427', '金陵科技学院', 'http://www.jit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 43, '', ''),
(4158, '1289788427', '南京信息职业技术学院', 'http://www.njcit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 44, '', ''),
(4159, '1289788427', '淮阴工学院', 'http://www.hyit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 45, '', ''),
(4160, '1289788427', '苏州职业大学', 'http://www.jssvc.edu.cn//', 0, 0, 0, 4104, 0, 1, 0, NULL, 46, '', ''),
(4161, '1289788427', '江苏海事职业技术学院', 'http://www.jmi.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 47, '', ''),
(4162, '1289788427', '南京化工职业技术学院', 'http://www.njcc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 48, '', ''),
(4163, '1289788427', '南京森林警察学院', 'http://www.forestpolice.net/', 0, 0, 0, 4104, 0, 1, 0, NULL, 49, '', ''),
(4164, '1289788427', '南通职业大学', 'http://www.ntvc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 50, '', ''),
(4165, '1289788427', '南京财经大学红山学院', 'http://hs.njue.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 51, '', ''),
(4166, '1289788427', '中国传媒大学南广学院', 'http://www.cucn.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 52, '', ''),
(4167, '1289788427', '无锡职业技术学院', 'http://www.wxit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 53, '', ''),
(4168, '1289788427', '南通农业职业技术学院', 'http://www.ntac.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 54, '', ''),
(4169, '1289788427', '连云港师范高等专科学校', 'http://new.lygsf.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 55, '', ''),
(4170, '1289788427', '南京人口管理干部学院', 'http://www.ncppm.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 56, '', ''),
(4171, '1289788427', '南京信息工程大学滨江学院', 'http://www.bjxy.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 57, '', ''),
(4172, '1289788427', '淮安信息职业技术学院', 'http://www.hcit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 58, '', ''),
(4173, '1289788427', '苏州卫生职业技术学院', 'http://www.szmtc.com/', 0, 0, 0, 4104, 0, 1, 0, NULL, 59, '', ''),
(4174, '1289788427', '江苏食品职业技术学院', 'http://www.jsfsc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 60, '', ''),
(4175, '1289788427', '南京交通职业技术学院', 'http://www.njci.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 61, '', ''),
(4176, '1289788427', '镇江市高等专科学校', 'http://www.zjc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 62, '', ''),
(4177, '1289788427', '苏州工业园区职业技术学院', 'http://www.sipivt.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 63, '', ''),
(4178, '1289788427', '常州工程职业技术学院', 'http://www.czie.net/', 0, 0, 0, 4104, 0, 1, 0, NULL, 64, '', ''),
(4179, '1289788427', '无锡商业职业技术学院', 'http://www.jscpu.com/', 0, 0, 0, 4104, 0, 1, 0, NULL, 65, '', ''),
(4180, '1289788427', '江苏建康职业学院', 'http://www.jssmu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 66, '', ''),
(4181, '1289788427', '淮海工学院', 'http://www.hhit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 67, '', ''),
(4182, '1289788427', '南京工业职业技术学院', 'http://www.niit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 68, '', ''),
(4183, '1289788427', '泰州师范高等专科学校', 'http://www.tzsz.net/', 0, 0, 0, 4104, 0, 1, 0, NULL, 69, '', ''),
(4184, '1289788427', '江苏畜牧兽医职业技术学院', 'http://www.jsahvc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 70, '', ''),
(4185, '1289788427', '南通纺织职业技术学院', 'http://www.nttec.edu.cn/cps/site/nttec2006/', 0, 0, 0, 4104, 0, 1, 0, NULL, 71, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(4186, '1289788427', '沙洲职业工学院', 'http://www.szit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 72, '', ''),
(4187, '1289788427', '南通航运职业技术学院', 'http://www.ntsc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 73, '', ''),
(4188, '1289788427', '连云港职业技术学院', 'http://www.lygtc.net.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 74, '', ''),
(4189, '1289788427', '扬州市职业大学', 'http://www.yzpc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 75, '', ''),
(4190, '1289788427', '苏州工艺美术职业技术学院', 'http://www.sgmart.com/', 0, 0, 0, 4104, 0, 1, 0, NULL, 76, '', ''),
(4191, '1289788427', '民办明达职业技术学院', 'http://www.mdu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 77, '', ''),
(4192, '1289788427', '江苏城市职业学院', 'http://www.jscvc.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 78, '', ''),
(4193, '1289788427', '泰州职业技术学院', 'http://www.tzpc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 79, '', ''),
(4194, '1289788427', '江海职业技术学院', 'http://www.jhu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 80, '', ''),
(4195, '1289788427', '江苏省省级机关管理干部学院', 'http://www.jsggy.net/', 0, 0, 0, 4104, 0, 1, 0, NULL, 81, '', ''),
(4196, '1289788427', '盐城纺织职业技术学院', 'http://www.yctei.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 82, '', ''),
(4197, '1289788427', '徐州工业职业技术学院', 'http://www.xzcit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 83, '', ''),
(4198, '1289788427', '无锡南洋职业技术学院', 'http://www.wsoc.com.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 84, '', ''),
(4199, '1289788427', '苏州港大思培科技职业学院', 'http://www.hkuspace.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 85, '', ''),
(4200, '1289788427', '江阴职业技术学院', 'http://www.jypc.org/', 0, 0, 0, 4104, 0, 1, 0, NULL, 86, '', ''),
(4201, '1289788427', '宿迁职业技术学院', 'http://www.cjsiu.com/', 0, 0, 0, 4104, 0, 1, 0, NULL, 87, '', ''),
(4202, '1289788427', '常州纺织服装职业技术学院', 'http://www.cztgi.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 88, '', ''),
(4203, '1289788427', '正德职业技术学院', 'http://www.zdxy.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 89, '', ''),
(4204, '1289788427', '江苏农林职业技术学院', 'http://www.jsafc.net/', 0, 0, 0, 4104, 0, 1, 0, NULL, 90, '', ''),
(4205, '1289788427', '江苏信息职业技术学院', 'http://www.jsit.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 91, '', ''),
(4206, '1289788427', '昆山登云科技职业学院', 'http://www.dyc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 92, '', ''),
(4207, '1289788427', '南京视觉艺术职业学院', 'http://www.niva.cn/index.asp', 0, 0, 0, 4104, 0, 1, 0, NULL, 93, '', ''),
(4208, '1289788427', '苏州信息职业技术学院', 'http://www.szitu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 94, '', ''),
(4209, '1289788427', '江苏经贸职业技术学院', 'http://www.jseti.edu.cn/581194/index.htm', 0, 0, 0, 4104, 0, 1, 0, NULL, 95, '', ''),
(4210, '1289788427', '苏州农业职业技术学院', 'http://www.szai.com/', 0, 0, 0, 4104, 0, 1, 0, NULL, 96, '', ''),
(4211, '1289788427', '钟山职业技术学院', 'http://www.zscollege.com/', 0, 0, 0, 4104, 0, 1, 0, NULL, 97, '', ''),
(4212, '1289788427', '常州轻工职业技术学院', 'http://www.czili.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 98, '', ''),
(4213, '1289788427', '太湖创意职业技术学院', 'http://www.thcyzy.org/', 0, 0, 0, 4104, 0, 1, 0, NULL, 99, '', ''),
(4214, '1289788427', '无锡工艺职业技术学院', 'http://www.wxgyxy.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 100, '', ''),
(4215, '1289788427', '紫琅职业技术学院', 'http://www.zlvc.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 101, '', ''),
(4216, '1289788427', '南京机电职业技术学院', 'http://www.njcmee.net/myProject/webpage/index.jsp', 0, 0, 0, 4104, 0, 1, 0, NULL, 102, '', ''),
(4217, '1289788427', '金肯职业技术学院', 'http://www.jku.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 103, '', ''),
(4218, '1289788427', '南京旅游职业学院', 'http://www.jltu.net/', 0, 0, 0, 4104, 0, 1, 0, NULL, 104, '', ''),
(4219, '1289788427', '苏州高博软件技术职业学院', 'http://www.gist.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 105, '', ''),
(4220, '1289788427', '江苏联合职业技术学院', 'http://www.juti.cn/article/index.asp', 0, 0, 0, 4104, 0, 1, 0, NULL, 106, '', ''),
(4221, '1289788427', '九州职业技术学院', 'http://www.jznu.com.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 107, '', ''),
(4222, '1289788427', '无锡城市职业技术学院', 'http://58.214.36.232:8000/', 0, 0, 0, 4104, 0, 1, 0, NULL, 108, '', ''),
(4223, '1289788427', '南京铁道职业技术学院', 'http://www.njrts.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 109, '', ''),
(4224, '1289788427', '常州信息职业技术学院', 'http://www.ccit.js.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 110, '', ''),
(4225, '1289788427', '健雄职业技术学院', 'http://www.wjxvtc.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 111, '', ''),
(4226, '1289788427', '江苏财经职业技术学院', 'http://www.jscjxy.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 112, '', ''),
(4227, '1289788427', '硅湖职业技术学院', 'http://www.usl.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 113, '', ''),
(4228, '1289788427', '盐城卫生职业技术学院', 'http://www.jsycmc.com/', 0, 0, 0, 4104, 0, 1, 0, NULL, 114, '', ''),
(4229, '1289788427', '苏州经贸职业技术学院', 'http://www.szjm.edu.cn/site/szjm/', 0, 0, 0, 4104, 0, 1, 0, NULL, 115, '', ''),
(4230, '1289788427', '南京特殊教育职业技术学院', 'http://www.njty.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 116, '', ''),
(4231, '1289788427', '金山职业技术学院', 'http://www.jinshan-cn.com/', 0, 0, 0, 4104, 0, 1, 0, NULL, 117, '', ''),
(4232, '1289788427', '江南影视艺术职业学院', 'http://www.jseea.cn/schoolinformation/detail_jiangnanyingshi.html', 0, 0, 0, 4104, 0, 1, 0, NULL, 118, '', ''),
(4233, '1289788427', '苏州工业职业技术学院', 'http://www.siit.cn/main/home/index.htm', 0, 0, 0, 4104, 0, 1, 0, NULL, 119, '', ''),
(4234, '1289788427', '扬州环境资源职业技术学院', 'http://www.yzerc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 120, '', ''),
(4235, '1289788427', '无锡科技职业学院', 'http://www.wxstc.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 121, '', ''),
(4236, '1289788427', '应天职业技术学院', 'http://www.ytc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 122, '', ''),
(4237, '1289788427', '苏州托普信息职业技术学院', 'http://www.szetop.com/', 0, 0, 0, 4104, 0, 1, 0, NULL, 123, '', ''),
(4238, '1289788427', '建东职业技术学院', 'http://www.czjdu.com/', 0, 0, 0, 4104, 0, 1, 0, NULL, 124, '', ''),
(4239, '1289788427', '宿迁泽达职业技术学院', 'http://www.jseea.cn/schoolinformation/suqianzedazhiyejishu.html', 0, 0, 0, 4104, 0, 1, 0, NULL, 125, '', ''),
(4240, '1289788427', '苏州工业园区服务外包学院', 'http://www.siso.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 126, '', ''),
(4241, '1289788427', '江南大学太湖学院', 'http://www.thxy.org/', 0, 0, 0, 4104, 0, 1, 0, NULL, 127, '', ''),
(4242, '1289788427', '东南大学成贤学院', 'http://cxxy.seu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 128, '', ''),
(4243, '1289788427', '中国矿业大学徐海学院', 'http://xhc.cumt.edu.cn/web2/09index.asp', 0, 0, 0, 4104, 0, 1, 0, NULL, 129, '', ''),
(4244, '1289788427', '南京大学金陵学院', 'http://jlxy.nju.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 130, '', ''),
(4245, '1289788427', '南京理工大学紫金学院', 'http://zj.njust.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 131, '', ''),
(4246, '1289788427', '南京航空航天大学金城学院', 'http://jc.nuaa.edu.cn/new/jincheng/index2.htm', 0, 0, 0, 4104, 0, 1, 0, NULL, 132, '', ''),
(4247, '1289788427', '南京理工大学泰州科技学院', 'http://www.njusttz.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 133, '', ''),
(4248, '1289788427', '南京师范大学泰州学院', 'http://www.nnutc.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 134, '', ''),
(4249, '1289788427', '南京工业大学浦江学院', 'http://pjxy.njut.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 135, '', ''),
(4250, '1289788427', '南京师范大学中北学院', 'http://zbzs.njnu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 136, '', ''),
(4251, '1289788427', '南京医科大学康达学院', 'http://kdc.njmu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 137, '', ''),
(4252, '1289788427', '南京中医药大学翰林学院', 'http://hlxy.njutcm.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 138, '', ''),
(4253, '1289788427', '苏州大学文正学院', 'http://58.210.239.206/', 0, 0, 0, 4104, 0, 1, 0, NULL, 139, '', ''),
(4254, '1289788427', '苏州大学应用技术学院', 'http://tec.suda.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 140, '', ''),
(4255, '1289788427', '苏州科技学院天平学院', 'http://tpxy.usts.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 141, '', ''),
(4256, '1289788427', '江苏大学京江学院', 'http://www.ujs.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 142, '', ''),
(4257, '1289788427', '扬州大学广陵学院', 'http://glxy.yzu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 143, '', ''),
(4258, '1289788427', '徐州师范大学科文学院', 'http://kwxy.xznu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 144, '', ''),
(4259, '1289788427', '南京邮电大学通达学院', 'http://tdxy.njupt.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 145, '', ''),
(4260, '1289788427', '江苏科技大学南徐学院', 'http://nanxu.just.edu.cn/home/index.do', 0, 0, 0, 4104, 0, 1, 0, NULL, 146, '', ''),
(4261, '1289788427', '常州大学怀德学院', 'http://hdc.jpu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 147, '', ''),
(4262, '1289788427', '南通大学杏林学院', 'http://xlxy.ntu.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 148, '', ''),
(4263, '1289788427', '南京审计学院金审学院', 'http://jsxy.nau.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 149, '', ''),
(4264, '1289788427', '江苏教育学院', 'http://www.jsie.edu.cn/', 0, 0, 0, 4104, 0, 1, 0, NULL, 150, '', ''),
(4265, '1289788427', '江苏省青年管理干部学院', 'http://qgy.sdx.js.cn/index.asp', 0, 0, 0, 4104, 0, 1, 0, NULL, 151, '', ''),
(4266, '1289788431', '北京唐人礼品网', 'http://www.teagift.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 1, '', ''),
(4267, '1289788431', '北京商务礼品网', 'http://www.bxhr.com.cn', 0, 0, 0, 4370, 0, 1, 0, NULL, 2, '', ''),
(4268, '1289788431', '北京俏视礼品网', 'http://www.qslp.com.cn', 0, 0, 0, 4370, 0, 1, 0, NULL, 3, '', ''),
(4269, '1289788431', '北京亿用贵族', 'http://www.yiyong.com.cn', 0, 0, 0, 4370, 0, 1, 0, NULL, 4, '', ''),
(4270, '1289788431', '上海礼品网', 'http://www.shgifts.cn', 0, 0, 0, 4370, 0, 1, 0, NULL, 5, '', ''),
(4271, '1289788431', '上海企力礼品网', 'http://www.qiligift.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 6, '', ''),
(4272, '1289788431', '温州礼品城', 'http://www.lpc8.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 7, '', ''),
(4273, '1289788431', '杭州鲜花网', 'http://www.hzxiangcao.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 8, '', ''),
(4274, '1289788431', '杭州千惠礼品', 'http://www.qianhuigift.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 9, '', ''),
(4275, '1289788431', '广东礼品网', 'http://www.gdgifts.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 10, '', ''),
(4276, '1289788431', '广州市银帆礼品', 'http://www.yinfan.com.cn', 0, 0, 0, 4370, 0, 1, 0, NULL, 11, '', ''),
(4277, '1289788431', '深圳礼品城', 'http://www.szlpc.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 12, '', ''),
(4278, '1289788431', '义乌礼品城', 'http://www.15gift.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 13, '', ''),
(4279, '1289788431', '贵州民族工艺品网', 'http://www.gzlpw.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 14, '', ''),
(4280, '1289788431', '东莞市杰雅礼品', 'http://www.jy588.cn/index.asp', 0, 0, 0, 4370, 0, 1, 0, NULL, 15, '', ''),
(4281, '1289788431', '大连天元礼品', 'http://www.dlmall.cn', 0, 0, 0, 4370, 0, 1, 0, NULL, 16, '', ''),
(4282, '1289788431', '庆成礼品网', 'http://www.ccgift.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 17, '', ''),
(4283, '1289788431', '万顺礼品', 'http://www.ws888.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 18, '', ''),
(4284, '1289788431', '能创礼品', 'http://www.gznc.net', 0, 0, 0, 4370, 0, 1, 0, NULL, 19, '', ''),
(4285, '1289788431', '北京国际玩具展', 'http://www.beijingite.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 20, '', ''),
(4286, '1289788431', '厦门玩具网', 'http://www.xmtoy.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 21, '', ''),
(4287, '1289788431', '义乌蓝燕玩具网', 'http://www.ywwanju.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 22, '', ''),
(4288, '1289788431', '义乌玩具市场网', 'http://www.ywtoys.org', 0, 0, 0, 4370, 0, 1, 0, NULL, 23, '', ''),
(4289, '1289788431', '凡茜玩具', 'http://www.fancytoys.net', 0, 0, 0, 4370, 0, 1, 0, NULL, 24, '', ''),
(4290, '1289788431', '澄海玩具协会', 'http://www.chtoy.cn', 0, 0, 0, 4370, 0, 1, 0, NULL, 25, '', ''),
(4291, '1289788431', '广通工艺', 'http://www.gttoys.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 26, '', ''),
(4292, '1289788431', '义乌雅领饰品', 'http://www.yaling.com.cn', 0, 0, 0, 4370, 0, 1, 0, NULL, 27, '', ''),
(4293, '1289788431', '云贝饰品批发网', 'http://www.yunbei.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 28, '', ''),
(4294, '1289788431', '深圳珠宝网', 'http://www.0755zb.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 29, '', ''),
(4295, '1289788431', '温州眼镜网', 'http://www.wenzhouglasses.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 30, '', ''),
(4296, '1289788431', '苗族工艺品网', 'http://www.miaoling.net', 0, 0, 0, 4370, 0, 1, 0, NULL, 31, '', ''),
(4297, '1289788431', '云南民族饰品网', 'http://www.ynimpress.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 32, '', ''),
(4298, '1289788431', '西府民间工艺品网', 'http://www.19art.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 33, '', ''),
(4299, '1289788431', '新西兰工艺品网', 'http://www.cierracandles.com', 0, 0, 0, 4370, 0, 1, 0, NULL, 34, '', ''),
(4300, '1289788453', '泰无聊', 'http://bbs.t56.net/', 0, 0, 0, 4105, 0, 1, 0, NULL, 1, '', ''),
(4301, '1289788453', '丹阳翼网', 'http://www.212300.com/', 0, 0, 0, 4105, 0, 1, 0, NULL, 2, '', ''),
(4302, '1289788453', '在海一方', 'http://bbs.lyg.jsinfo.net/discuzx/', 0, 0, 0, 4105, 0, 1, 0, NULL, 3, '', ''),
(4303, '1289788453', '新沂城市论坛', 'http://bbs.0516k.com/', 0, 0, 0, 4105, 0, 1, 0, NULL, 4, '', ''),
(4304, '1289788453', '邳州论坛', 'http://www.pzzc.net/', 0, 0, 0, 4105, 0, 1, 0, NULL, 5, '', ''),
(4305, '1289788453', '仪征政府论坛', 'http://bbs.yizheng.gov.cn/', 0, 0, 0, 4105, 0, 1, 0, NULL, 6, '', ''),
(4306, '1289788453', '金湖论坛', 'http://bbs.211600.com/', 0, 0, 0, 4105, 0, 1, 0, NULL, 7, '', ''),
(4307, '1289788453', '新区家园', 'http://www.newuxi.com/', 0, 0, 0, 4105, 0, 1, 0, NULL, 8, '', ''),
(4308, '1289788453', '昆山论坛', 'http://www.kbcool.com/', 0, 0, 0, 4105, 0, 1, 0, NULL, 9, '', ''),
(4309, '1289788453', '东台人论坛', 'http://bbs.dt123.net/', 0, 0, 0, 4105, 0, 1, 0, NULL, 10, '', ''),
(4310, '1289788453', '观前街', 'http://www.guanqianjie.com/', 0, 0, 0, 4105, 0, 1, 0, NULL, 11, '', ''),
(4311, '1289788453', '宿迁论坛', 'http://bbs.sqee.cn/', 0, 0, 0, 4105, 0, 1, 0, NULL, 12, '', ''),
(4312, '1289788453', '江苏龙', 'http://bbs.jsngl.com/', 0, 0, 0, 4105, 0, 1, 0, NULL, 13, '', ''),
(4313, '1289788453', '苏友论坛', 'http://www.suyoubbs.cn/', 0, 0, 0, 4105, 0, 1, 0, NULL, 14, '', ''),
(4314, '1289788480', '气象局', 'http://www.jsmb.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 1, '', ''),
(4315, '1289788480', '交通运输厅', 'http://www.jscd.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 2, '', ''),
(4316, '1289788480', '发改委', 'http://www.jsdpc.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 3, '', ''),
(4317, '1289788480', '教育厅', 'http://www.jsjyt.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 4, '', ''),
(4318, '1289788480', '监察厅', 'http://www.jssjw.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 5, '', ''),
(4319, '1289788480', '科技厅', 'http://www.jstd.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 6, '', ''),
(4320, '1289788480', '宗教事务局', 'http://www.jsmzzj.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 7, '', ''),
(4321, '1289788480', '司法厅', 'http://www.jssf.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 8, '', ''),
(4322, '1289788480', '国土资源', 'http://www.jsmlr.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 9, '', ''),
(4323, '1289788480', '农业委员会', 'http://www.jsagri.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 10, '', ''),
(4324, '1289788480', '财政厅', 'http://www.jscz.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 11, '', ''),
(4325, '1289788480', '水利厅', 'http://www.jswater.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 12, '', ''),
(4326, '1289788480', '无锡市', 'http://www.wuxi.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 13, '', ''),
(4327, '1289788480', '徐州市', 'http://www.xz.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 14, '', ''),
(4328, '1289788480', '常州市', 'http://www.changzhou.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 15, '', ''),
(4329, '1289788480', '苏州市', 'http://www.suzhou.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 16, '', ''),
(4330, '1289788480', '南通市', 'http://www.nantong.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 17, '', ''),
(4331, '1289788480', '连去港市', 'http://www.lyg.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 18, '', ''),
(4332, '1289788480', '淮安市', 'http://www.huaian.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 19, '', ''),
(4333, '1289788480', '扬州市', 'http://www.yangzhou.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 20, '', ''),
(4334, '1289788480', '泰州市', 'http://www.taizhou.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 21, '', ''),
(4335, '1289788480', '宿迁市', 'http://www.suqian.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 22, '', ''),
(4336, '1289788480', '盐城市', 'http://www.yancheng.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 23, '', ''),
(4337, '1289788480', '镇江市', 'http://www.zhenjiang.gov.cn/', 0, 0, 0, 4106, 0, 1, 0, NULL, 24, '', ''),
(4338, '1289788499', '北京房地产网', 'http://www.bjhouse.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 1, '', ''),
(4339, '1289788499', '北京房产网', 'http://www.bjfcw.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 2, '', ''),
(4340, '1289788499', '天郎房网', 'http://www.bjfang.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 3, '', ''),
(4341, '1289788499', '易龙房产网', 'http://www.yilongnet.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 4, '', ''),
(4342, '1289788499', '赶集房产北京租售', 'http://bj.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 5, '', ''),
(4343, '1289788499', '北京市房地产网', 'http://www.bjfdc.gov.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 6, '', ''),
(4344, '1289788499', '北京挑房者网站', 'http://www.tiaofun.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 7, '', ''),
(4345, '1289788499', '赶集房产天津租售', 'http://tj.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 8, '', ''),
(4346, '1289788499', '合意地产网', 'http://www.hoomee.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 9, '', ''),
(4347, '1289788499', '天津龙腾房地产信息网', 'http://www.lthouse.com.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 10, '', ''),
(4348, '1289788499', '上海热线房产', 'http://house.online.sh.cn/gb/node/house_default.htm', 0, 0, 0, 4439, 0, 1, 0, NULL, 11, '', ''),
(4349, '1289788499', '上海租售情报网', 'http://www.myliving.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 12, '', ''),
(4350, '1289788499', '上海搜搜看看网', 'http://www.sskk.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 13, '', ''),
(4351, '1289788499', '安家网', 'http://www.anjia.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 14, '', ''),
(4352, '1289788499', '安居网', 'http://www.anju.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 15, '', ''),
(4353, '1289788499', '房产之门', 'http://www.fczm.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 16, '', ''),
(4354, '1289788499', '上海二手房', 'http://www.house.sh.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 17, '', ''),
(4355, '1289788499', '科房网', 'http://www.kefan.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 18, '', ''),
(4356, '1289788499', '上海楼市在线', 'http://www.loushi.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 19, '', ''),
(4357, '1289788499', '上海租房热线', 'http://www.okfang.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 20, '', ''),
(4358, '1289788499', '上海房产365', 'http://www.shfc365.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 21, '', ''),
(4359, '1289788499', '搜屋网-上海二手房', 'http://www.souwoo.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 22, '', ''),
(4360, '1289788499', '赶集房产武汉租售', 'http://wh.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 23, '', ''),
(4361, '1289788499', '武汉家装网', 'http://www.whjzw.net', 0, 0, 0, 4439, 0, 1, 0, NULL, 24, '', ''),
(4362, '1289788499', '襄樊房产网', 'http://www.fczx.net', 0, 0, 0, 4439, 0, 1, 0, NULL, 25, '', ''),
(4363, '1289788499', '亿房网', 'http://www.fdc.com.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 26, '', ''),
(4364, '1289788499', '南昌房产财富网', 'http://www.ncfccf.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 27, '', ''),
(4365, '1289788499', '赶集房产南昌租售', 'http://nc.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 28, '', ''),
(4366, '1289788499', '湛江房产网', 'http://www.0759h.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 29, '', ''),
(4367, '1289788499', '青岛房产在线', 'http://www.house.sd.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 30, '', ''),
(4368, '1289788499', '齐鲁置业网', 'http://www.qlzyw.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 31, '', ''),
(4369, '1289788499', '青岛无忧房网', 'http://www.51fdc.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 32, '', ''),
(4370, '1289788499', '青岛住宅与房地产网', 'http://www.515home.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 33, '', ''),
(4371, '1289788499', '齐鲁热线房产', 'http://sdfdc.sdinfo.net', 0, 0, 0, 4439, 0, 1, 0, NULL, 34, '', ''),
(4372, '1289788499', '赶集房产济南租售', 'http://jn.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 35, '', ''),
(4373, '1289788499', '赶集房产青岛租售', 'http://qd.ganji.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 36, '', ''),
(4374, '1289788499', '赶集房产威海租售', 'http://wei.ganji.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 37, '', ''),
(4375, '1289788499', '莱芜房地产网', 'http://www.lwhouse.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 38, '', ''),
(4376, '1289788499', '商都房产网', 'http://house.shangdu.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 39, '', ''),
(4377, '1289788499', '凯业房园', 'http://kaye.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 40, '', ''),
(4378, '1289788499', '赶集房产郑州租售', 'http://zz.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 41, '', ''),
(4379, '1289788499', '郑州-周口楼市网', 'http://www.zkloushi.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 42, '', ''),
(4380, '1289788499', '赶集房产长沙租售', 'http://cs.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 43, '', ''),
(4381, '1289788499', '中联地产网', 'http://www.zlhome.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 44, '', ''),
(4382, '1289788499', '惠州房地产网', 'http://www.hzew.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 45, '', ''),
(4383, '1289788499', '汕头房产网', 'http://www.sthouse.net', 0, 0, 0, 4439, 0, 1, 0, NULL, 46, '', ''),
(4384, '1289788499', '赶集房产广州租售', 'http://gz.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 47, '', ''),
(4385, '1289788499', '赶集房产深圳租售', 'http://sz.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 48, '', ''),
(4386, '1289788499', '赶集房产东莞租售', 'http://dg.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 49, '', ''),
(4387, '1289788499', '靓屋网·汕头', 'http://www.houseabc.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 50, '', ''),
(4388, '1289788499', '汕头房地产信息网', 'http://www.stre.net', 0, 0, 0, 4439, 0, 1, 0, NULL, 51, '', ''),
(4389, '1289788499', '深圳房地产交易网', 'http://www1.szhouse.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 52, '', ''),
(4390, '1289788499', '广西房地产信息网', 'http://www.gxfdc.com.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 53, '', ''),
(4391, '1289788499', '桂林房产网', 'http://www.guilinhouse.net', 0, 0, 0, 4439, 0, 1, 0, NULL, 54, '', ''),
(4392, '1289788499', '广西房产街', 'http://www.gxhouse.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 55, '', ''),
(4393, '1289788499', '广西房地产信息网', 'http://www.gxfdc.com.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 56, '', ''),
(4394, '1289788499', '赶集房产南宁租售', 'http://nn.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 57, '', ''),
(4395, '1289788499', '西安房地产信息网', 'http://www.800j.com.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 58, '', ''),
(4396, '1289788499', '赶集房产西安租售', 'http://xa.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 59, '', ''),
(4397, '1289788499', '西安房地产超市', 'http://www.xianhouse.gov.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 60, '', ''),
(4398, '1289788499', '厦门房产网', 'http://www.xmfc.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 61, '', ''),
(4399, '1289788499', '泉州房产在线', 'http://www.qzfangchan.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 62, '', ''),
(4400, '1289788499', '八闽房网', 'http://www.fjhousenet.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 63, '', ''),
(4401, '1289788499', '厦门房地产联合网', 'http://www.xmhouse.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 64, '', ''),
(4402, '1289788499', '厦门.房屋网', 'http://xm.houseweb.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 65, '', ''),
(4403, '1289788499', '厦门租房网', 'http://www.xmzf.net', 0, 0, 0, 4439, 0, 1, 0, NULL, 66, '', ''),
(4404, '1289788499', '福房网', 'http://www.ffw.com.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 67, '', ''),
(4405, '1289788499', '莆田房产网', 'http://www.ptfdc.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 68, '', ''),
(4406, '1289788499', '赶集房产厦门租售', 'http://xm.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 69, '', ''),
(4407, '1289788499', '赶集房产福州租售', 'http://fz.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 70, '', ''),
(4408, '1289788499', '百惠网', 'http://www.befree.com.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 71, '', ''),
(4409, '1289788499', '石家庄房地产网', 'http://www.sjzhouse.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 72, '', ''),
(4410, '1289788499', '赶集房产石家庄租售', 'http://sjz.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 73, '', ''),
(4411, '1289788499', '嘉兴无忧房产网', 'http://www.51fcw.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 74, '', ''),
(4412, '1289788499', '赶集房产杭州租售', 'http://hz.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 75, '', ''),
(4413, '1289788499', '赶集房产宁波租售', 'http://nb.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 76, '', ''),
(4414, '1289788499', '房易网-浙江房产', 'http://www.fecom.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 77, '', ''),
(4415, '1289788499', '中国公众房网', 'http://www.pehousing.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 78, '', ''),
(4416, '1289788499', '衢州房地产信息网', 'http://www.qzfdc.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 79, '', ''),
(4417, '1289788499', '赶集房产南京租售', 'http://nj.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 80, '', ''),
(4418, '1289788499', '赶集房产苏州租售', 'http://su.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 81, '', ''),
(4419, '1289788499', '赶集房产无锡租售', 'http://wx.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 82, '', ''),
(4420, '1289788499', '扬州房产网', 'http://www.yzfdc.net', 0, 0, 0, 4439, 0, 1, 0, NULL, 83, '', ''),
(4421, '1289788499', '吴江房产网', 'http://www.wjhouse.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 84, '', ''),
(4422, '1289788499', '南京房地产网', 'http://www.e-njhouse.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 85, '', ''),
(4423, '1289788499', '常州房产网', 'http://www.czfcw.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 86, '', ''),
(4424, '1289788499', '人居苏州网', 'http://www.rjsuzhou.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 87, '', ''),
(4425, '1289788499', '搜楼', 'http://www.soulou.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 88, '', ''),
(4426, '1289788499', '沈阳房信网', 'http://www.syfx.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 89, '', ''),
(4427, '1289788499', '大连看房网', 'http://www.housevo.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 90, '', ''),
(4428, '1289788499', '赶集房产沈阳租售', 'http://sy.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 91, '', ''),
(4429, '1289788499', '赶集房产大连租售', 'http://dl.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 92, '', ''),
(4430, '1289788499', '赶集房产贵阳租售', 'http://gy.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 93, '', ''),
(4431, '1289788499', '赶集房产昆明租售', 'http://km.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 94, '', ''),
(4432, '1289788499', '赶集房产拉萨租售', 'http://xz.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 95, '', ''),
(4433, '1289788499', '赶集房产合肥租售', 'http://hf.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 96, '', ''),
(4434, '1289788499', '无锡房产家居互动门户', 'http://www.wxren.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 97, '', ''),
(4435, '1289788499', '合肥新安房产网', 'http://xafdc.net', 0, 0, 0, 4439, 0, 1, 0, NULL, 98, '', ''),
(4436, '1289788499', '赶集房产兰州租售', 'http://lz.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 99, '', ''),
(4437, '1289788499', '甘肃房地产资讯网', 'http://www.gshouse.com.cn', 0, 0, 0, 4439, 0, 1, 0, NULL, 100, '', ''),
(4438, '1289788499', '赶集房产银川租售', 'http://yc.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 101, '', ''),
(4439, '1289788499', '成都买房网', 'http://www.cdmfw.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 102, '', ''),
(4440, '1289788499', '天府房产网', 'http://www.tffcw.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 103, '', ''),
(4441, '1289788499', '成都房产信息网', 'http://www.173fc.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 104, '', ''),
(4442, '1289788499', '赶集房产成都租售', 'http://cd.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 105, '', ''),
(4443, '1289788499', '赶集房产重庆租售', 'http://cq.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 106, '', ''),
(4444, '1289788499', '重庆房产网', 'http://www.023fcw.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 107, '', ''),
(4445, '1289788499', '海南在线房产频道', 'http://house.hainan.net', 0, 0, 0, 4439, 0, 1, 0, NULL, 108, '', ''),
(4446, '1289788499', '赶集房产海口租售', 'http://hn.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 109, '', ''),
(4447, '1289788499', '琼海房产网', 'http://www.qionghaifc.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 110, '', ''),
(4448, '1289788499', '赶集房产太原租售', 'http://ty.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 111, '', ''),
(4449, '1289788499', '赶集房产长春租售', 'http://cc.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 112, '', ''),
(4450, '1289788499', '赶集房产哈尔滨租售', 'http://hrb.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 113, '', ''),
(4451, '1289788499', '赶集房产西宁租售', 'http://xn.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 114, '', ''),
(4452, '1289788499', '夏都网房产', 'http://house.xiadu.com', 0, 0, 0, 4439, 0, 1, 0, NULL, 115, '', ''),
(4453, '1289788499', '赶集房产乌鲁木齐租售', 'http://xj.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 116, '', ''),
(4454, '1289788499', '赶集房产呼和浩特租售', 'http://nmg.ganji.com/fang', 0, 0, 0, 4439, 0, 1, 0, NULL, 117, '', ''),
(4455, '1289788535', '嵊州信息港', 'http://www.sz.zj.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 1, '', ''),
(4456, '1289788535', '上虞信息港', 'http://www.sy.net.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 2, '', ''),
(4457, '1289788535', '宁海热线', 'http://www.nhzj.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 3, '', ''),
(4458, '1289788535', '新昌信息港', 'http://www.xc.zj.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 4, '', ''),
(4459, '1289788535', '温州热线', 'http://www.wz.zj.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 5, '', ''),
(4460, '1289788535', '台州信息港', 'http://www.tzinfo.net/', 0, 0, 0, 4111, 0, 1, 0, NULL, 6, '', ''),
(4461, '1289788535', '浙北信息港', 'http://www.hz0572.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 7, '', ''),
(4462, '1289788535', '嘉善在线', 'http://www.js0573.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 8, '', ''),
(4463, '1289788535', '诸暨在线', 'http://www.zhuji.net/', 0, 0, 0, 4111, 0, 1, 0, NULL, 9, '', ''),
(4464, '1289788535', '金华热线', 'http://www.0579.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 10, '', ''),
(4465, '1289788535', '丽水信息港', 'http://www.inlishui.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 11, '', ''),
(4466, '1289788535', '绍兴E网', 'http://www.e0575.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 12, '', ''),
(4467, '1289788535', '宁波东方热线', 'http://www.cnool.net/', 0, 0, 0, 4111, 0, 1, 0, NULL, 13, '', ''),
(4468, '1289788535', '慈溪热线', 'http://www.zxip.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 14, '', ''),
(4469, '1289788535', '绍兴信息港', 'http://www.sx.zj.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 15, '', ''),
(4470, '1289788535', '华数在线', 'http://www.hzcnc.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 16, '', ''),
(4471, '1289788535', '义乌新闻网', 'http://www.ywnews.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 17, '', ''),
(4472, '1289788535', '金华新闻网', 'http://www.jhnews.com.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 18, '', ''),
(4473, '1289788535', '宁波网', 'http://www.cnnb.com.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 19, '', ''),
(4474, '1289788535', '温州网', 'http://www.66wz.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 20, '', ''),
(4475, '1289788535', '湖州在线', 'http://www.hz66.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 21, '', ''),
(4476, '1289788535', '嘉兴在线', 'http://www.cnjxol.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 22, '', ''),
(4477, '1289788535', '北仑之窗', 'http://www.bl.gov.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 23, '', ''),
(4478, '1289788535', '萧山网', 'http://www.xsnet.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 24, '', ''),
(4479, '1289788535', '绍兴网', 'http://www.shaoxing.com.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 25, '', ''),
(4480, '1289788535', '杭州下沙网', 'http://www.xiashanet.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 26, '', ''),
(4481, '1289788535', '舟山网', 'http://www.zhoushan.cn/', 0, 0, 0, 4111, 0, 1, 0, NULL, 27, '', ''),
(4482, '1289788535', '余姚生活网', 'http://www.eyuyao.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 28, '', ''),
(4483, '1289788535', '义乌热线', 'http://www.cnyw.net/', 0, 0, 0, 4111, 0, 1, 0, NULL, 29, '', ''),
(4484, '1289788535', '虹桥门户网', 'http://www.hqdoor.com/', 0, 0, 0, 4111, 0, 1, 0, NULL, 30, '', ''),
(4485, '1289788560', '浙江在线', 'http://www.zjol.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 1, '', ''),
(4486, '1289788560', '杭州网', 'http://www.hangzhou.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 2, '', ''),
(4487, '1289788560', '浙江卫视', 'http://www.zjstv.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 3, '', ''),
(4488, '1289788560', '浙江都市网', 'http://www.zj.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 4, '', ''),
(4489, '1289788560', '中国浙江', 'http://www.zj.gov.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 5, '', ''),
(4490, '1289788560', '新华网浙江频道', 'http://www.zj.xinhuanet.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 6, '', ''),
(4491, '1289788560', '浙江日报', 'http://www.zjdaily.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 7, '', ''),
(4492, '1289788560', '杭州日报', 'http://hzrb.hangzhou.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 8, '', ''),
(4493, '1289788560', '嵊州信息港', 'http://www.sz.zj.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 9, '', ''),
(4494, '1289788560', '温州晚报', 'http://www.wzwb.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 10, '', ''),
(4495, '1289788560', '义乌新闻网', 'http://www.ywnews.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 11, '', ''),
(4496, '1289788560', '金华新闻网', 'http://www.jhnews.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 12, '', ''),
(4497, '1289788560', '宁波网', 'http://www.cnnb.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 13, '', ''),
(4498, '1289788560', '温州网', 'http://www.66wz.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 14, '', ''),
(4499, '1289788560', '湖州在线', 'http://www.hz66.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 15, '', ''),
(4500, '1289788560', '嘉兴在线', 'http://www.cnjxol.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 16, '', ''),
(4501, '1289788560', '宁海热线', 'http://www.nhzj.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 17, '', ''),
(4502, '1289788560', '大杭州', 'http://www.dahangzhou.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 18, '', ''),
(4503, '1289788560', '萧山网', 'http://www.xsnet.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 19, '', ''),
(4504, '1289788560', '绍兴网', 'http://www.shaoxing.com.cn', 0, 0, 0, 4112, 0, 1, 0, NULL, 20, '', ''),
(4505, '1289788560', '温州热线', 'http://www.wz.zj.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 21, '', ''),
(4506, '1289788560', '台州信息港', 'http://www.tzinfo.net/', 0, 0, 0, 4112, 0, 1, 0, NULL, 22, '', ''),
(4507, '1289788560', '杭州下沙网', 'http://www.xiashanet.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 23, '', ''),
(4508, '1289788560', '浙北信息港', 'http://www.huzhou.zj.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 24, '', ''),
(4509, '1289788560', '嘉善在线', 'http://www.js0573.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 25, '', ''),
(4510, '1289788560', '舟山网', 'http://www.zhoushan.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 26, '', ''),
(4511, '1289788560', '诸暨在线', 'http://www.zhuji.net', 0, 0, 0, 4112, 0, 1, 0, NULL, 27, '', ''),
(4512, '1289788560', '金华热线', 'http://www.0579.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 28, '', ''),
(4513, '1289788560', '丽水信息港', 'http://www.inlishui.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 29, '', ''),
(4514, '1289788560', '余姚生活网', 'http://www.eyuyao.com', 0, 0, 0, 4112, 0, 1, 0, NULL, 30, '', ''),
(4515, '1289788560', '义乌信息港', 'http://www.yw169.net/', 0, 0, 0, 4112, 0, 1, 0, NULL, 31, '', ''),
(4516, '1289788560', '宁波东方热线', 'http://www.cnool.net/', 0, 0, 0, 4112, 0, 1, 0, NULL, 32, '', ''),
(4517, '1289788560', '慈溪热线', 'http://www.zxip.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 33, '', ''),
(4518, '1289788560', '绍兴信息港', 'http://www.sx.zj.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 34, '', ''),
(4519, '1289788560', '绍兴E网', 'http://www.e0575.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 35, '', ''),
(4520, '1289788560', '华数在线', 'http://www.hzcnc.com', 0, 0, 0, 4112, 0, 1, 0, NULL, 36, '', ''),
(4521, '1289788560', '上虞信息港', 'http://www.sy.net.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 37, '', ''),
(4522, '1289788560', '新昌信息港', 'http://www.xc.zj.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 38, '', ''),
(4523, '1289788560', '中国宁波网', 'http://www.cnnb.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 39, '', ''),
(4524, '1289788560', '千岛湖新闻网', 'http://www.qdhnews.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 40, '', ''),
(4525, '1289788560', '衢州新闻网', 'http://www.qz828.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 41, '', ''),
(4526, '1289788560', '宁波日报', 'http://www.cnnb.com.cn/gb/node2/node115/index.html', 0, 0, 0, 4112, 0, 1, 0, NULL, 42, '', ''),
(4527, '1289788560', '萧山日报', 'http://xsrb.xsnet.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 43, '', ''),
(4528, '1289788560', '瑞安日报', 'http://rarb.zjol.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 44, '', ''),
(4529, '1289788560', '钱江晚报', 'http://zjdaily.zjol.com.cn/qjwb/', 0, 0, 0, 4112, 0, 1, 0, NULL, 45, '', ''),
(4530, '1289788560', '今日早报', 'http://jrzb.zjol.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 46, '', ''),
(4531, '1289788560', '温州日报', 'http://www.wzrb.com.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 47, '', ''),
(4532, '1289788560', '南湖晚报', 'http://nhwb.cnjxol.com/', 0, 0, 0, 4112, 0, 1, 0, NULL, 48, '', ''),
(4533, '1289788560', '义乌商报', 'http://pdf.ywnews.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 49, '', ''),
(4534, '1289788560', '都市快报', 'http://hzdaily.hangzhou.com.cn/dskb/', 0, 0, 0, 4112, 0, 1, 0, NULL, 50, '', ''),
(4535, '1289788560', '杭州文广网', 'http://www.hcrt.cn/', 0, 0, 0, 4112, 0, 1, 0, NULL, 51, '', ''),
(4536, '1289788564', '山西交通网', 'http://www.sxjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 1, '', ''),
(4537, '1289788564', '吉林省交通公众信息网', 'http://www.jljt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 2, '', ''),
(4538, '1289788564', '黑龙江交通网', 'http://www.hljjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 3, '', ''),
(4539, '1289788564', '上海交通网上服务中心', 'http://www.shjt.net/index.htm', 0, 0, 0, 4355, 0, 1, 0, NULL, 4, '', ''),
(4540, '1289788564', '江苏交通科学研究院', 'http://www.ti.js.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 5, '', ''),
(4541, '1289788564', '浙江交通', 'http://www.zjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 6, '', ''),
(4542, '1289788564', '安徽交通政务网', 'http://www.ahjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 7, '', ''),
(4543, '1289788564', '中国铁路时刻网', 'http://www.shike.org.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 8, '', ''),
(4544, '1289788564', '江西省交通信息网', 'http://www.jxjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 9, '', ''),
(4545, '1289788564', '交通之星-河南交通科技信息', 'http://www.jtstar.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 10, '', ''),
(4546, '1289788564', '杭州市交通信息网', 'http://www.hzcb.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 11, '', ''),
(4547, '1289788564', '长沙运输信息管理', 'http://www.csyg.net', 0, 0, 0, 4355, 0, 1, 0, NULL, 12, '', ''),
(4548, '1289788564', '无锡交通信息网', 'http://www.traffic.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 13, '', ''),
(4549, '1289788564', '厦门火车站资讯网', 'http://www.xmhcz.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 14, '', ''),
(4550, '1289788564', '郑州交通信息网', 'http://www.zzjtj.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 15, '', ''),
(4551, '1289788564', '佛山交通网', 'http://www.fsjtw.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 16, '', ''),
(4552, '1289788564', '宁夏交通信息网', 'http://www.nxcd.gov.cn/xinwen/default.asp', 0, 0, 0, 4355, 0, 1, 0, NULL, 17, '', ''),
(4553, '1289788564', '西部交通信息网', 'http://www.xbjtxx.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 18, '', ''),
(4554, '1289788564', '城市公交车信息查询', 'http://www.21page.net/traffic/traffic.asp', 0, 0, 0, 4355, 0, 1, 0, NULL, 19, '', ''),
(4555, '1289788564', '公交线路查询', 'http://www.soku.net/Bus_Default.Asp', 0, 0, 0, 4355, 0, 1, 0, NULL, 20, '', ''),
(4556, '1289788564', '8684公交查询', 'http://www.8684.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 21, '', ''),
(4557, '1289788564', '北京公交查询', 'http://beijing.8684.cn/sitemap', 0, 0, 0, 4355, 0, 1, 0, NULL, 22, '', ''),
(4558, '1289788564', '上海公交线路查询', 'http://www.ddmap.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 23, '', ''),
(4559, '1289788564', '天津公交线路查询', 'http://www.kutj.com/bus', 0, 0, 0, 4355, 0, 1, 0, NULL, 24, '', ''),
(4560, '1289788564', '重庆市公交线路查询', 'http://chongqing.bus84.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 25, '', ''),
(4561, '1289788564', '西安公交线路', 'http://www1.xbus.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 26, '', ''),
(4562, '1289788564', '成都公交线路', 'http://www.cityboat.com.cn/files/ggcx-xlcx.asp', 0, 0, 0, 4355, 0, 1, 0, NULL, 27, '', ''),
(4563, '1289788564', '石家庄公交线路查询', 'http://he.people.com.cn/GB/channel11/59/200408/05/265.html', 0, 0, 0, 4355, 0, 1, 0, NULL, 28, '', ''),
(4564, '1289788564', '广州市公交线路查询', 'http://guangzhou.8684.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 29, '', ''),
(4565, '1289788564', '深圳市公交线路查询', 'http://jt.sz.bendibao.com/bus', 0, 0, 0, 4355, 0, 1, 0, NULL, 30, '', ''),
(4566, '1289788564', '珠海公交线路', 'http://www.okzhuhai.com/transport/zhuhaitrasport/busline.htm', 0, 0, 0, 4355, 0, 1, 0, NULL, 31, '', ''),
(4567, '1289788564', '东莞公交线路', 'http://www.job999.com/dongguan.htm', 0, 0, 0, 4355, 0, 1, 0, NULL, 32, '', ''),
(4568, '1289788564', '中山市公交线路', 'http://www.zhongshan.gd.cn/shenghuofuwu/bus.htm', 0, 0, 0, 4355, 0, 1, 0, NULL, 33, '', ''),
(4569, '1289788564', '桂林公交线路', 'http://www.guilinlife.com/service/busline.asp', 0, 0, 0, 4355, 0, 1, 0, NULL, 34, '', ''),
(4570, '1289788564', '苏州市公交线路', 'http://www.szkg.net.cn/fwrx/fwrx.asp', 0, 0, 0, 4355, 0, 1, 0, NULL, 35, '', ''),
(4571, '1289788564', '青岛公交线路查询', 'http://www.qdtravel.com/traffic/gongjiao.asp', 0, 0, 0, 4355, 0, 1, 0, NULL, 36, '', ''),
(4572, '1289788564', '汕头公交查询', 'http://citylife.st.gd.cn/gongche.asp', 0, 0, 0, 4355, 0, 1, 0, NULL, 37, '', ''),
(4573, '1289788564', '福州市区公交线路', 'http://travel.fjii.com/gj', 0, 0, 0, 4355, 0, 1, 0, NULL, 38, '', ''),
(4574, '1289788564', '昆山市公交线路表', 'http://www.9tour.cn/info/226/33737.shtml', 0, 0, 0, 4355, 0, 1, 0, NULL, 39, '', ''),
(4575, '1289788564', '丽水公交线路', 'http://www.inlishui.com/service/gongjiao.html', 0, 0, 0, 4355, 0, 1, 0, NULL, 40, '', ''),
(4576, '1289788564', '杭州市公交线路', 'http://hot.dahangzhou.com/index002_3.htm', 0, 0, 0, 4355, 0, 1, 0, NULL, 41, '', ''),
(4577, '1289788564', '合肥公交线路', 'http://hefei.8684.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 42, '', ''),
(4578, '1289788564', '龙岩市区公交线路', 'http://www.lybuluo.com/Gongjiao', 0, 0, 0, 4355, 0, 1, 0, NULL, 43, '', ''),
(4579, '1289788564', '唐山公交线路查询', 'http://tangshan.8684.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 44, '', ''),
(4580, '1289788564', '山西运城公交线路', 'http://www.tourunion.com/info/htm/7747.htm', 0, 0, 0, 4355, 0, 1, 0, NULL, 45, '', ''),
(4581, '1289788564', '岳阳市公交线路', 'http://www.yueyang.gov.cn/ReadNews.asp?NewsID=3073&amp;amp;BigClassName=', 0, 0, 0, 4355, 0, 1, 0, NULL, 46, '', ''),
(4582, '1289788564', '无锡公交查询', 'http://www.thmz.com/html/col28/cchb/gj1.htm', 0, 0, 0, 4355, 0, 1, 0, NULL, 47, '', ''),
(4583, '1289788564', '襄樊市公交线路', 'http://www.dalu.com/china/hubei/index5.html', 0, 0, 0, 4355, 0, 1, 0, NULL, 48, '', ''),
(4584, '1289788564', '临沂市公交线路', 'http://www.lywww.com/bianmin/gongjiaoxianlu.htm', 0, 0, 0, 4355, 0, 1, 0, NULL, 49, '', ''),
(4585, '1289788564', '威海市公交线路', 'http://www.51766.com/www/detailhtml/1100023385.html', 0, 0, 0, 4355, 0, 1, 0, NULL, 50, '', ''),
(4586, '1289788564', '盐城公交线路', 'http://www.yctelecom.com.cn/bmfw/bmfw_bus1.asp', 0, 0, 0, 4355, 0, 1, 0, NULL, 51, '', ''),
(4587, '1289788564', '玉溪公共汽车线路', 'http://www.yuxi.gov.cn/gjxtxx', 0, 0, 0, 4355, 0, 1, 0, NULL, 52, '', ''),
(4588, '1289788564', '中华人民共和国交通部', 'http://www.moc.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 53, '', ''),
(4589, '1289788564', '北京市公安交通管理局', 'http://www.bjjtgl.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 54, '', ''),
(4590, '1289788564', '天津交通委员会', 'http://www.tjjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 55, '', ''),
(4591, '1289788564', '河北省交通厅', 'http://www.hbsjtt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 56, '', ''),
(4592, '1289788564', '山西省交通厅', 'http://www.sxjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 57, '', ''),
(4593, '1289788564', '辽宁省交通厅', 'http://www.lncom.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 58, '', ''),
(4594, '1289788564', '吉林省交通厅', 'http://www.jljt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 59, '', ''),
(4595, '1289788564', '黑龙江省交通厅', 'http://2006.moc.gov.cn/06heilongjiang', 0, 0, 0, 4355, 0, 1, 0, NULL, 60, '', ''),
(4596, '1289788564', '上海交通', 'http://www.jt.sh.cn/jtn/cms/shjt/index.html', 0, 0, 0, 4355, 0, 1, 0, NULL, 61, '', ''),
(4597, '1289788564', '甘肃省交通厅', 'http://www.gsjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 62, '', ''),
(4598, '1289788564', '浙江交通', 'http://www.zjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 63, '', ''),
(4599, '1289788564', '安徽交通', 'http://www.ahjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 64, '', ''),
(4600, '1289788564', '福建省交通厅', 'http://www.fjjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 65, '', ''),
(4601, '1289788564', '江西交通信息网', 'http://www.jxjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 66, '', ''),
(4602, '1289788564', '山东省交通厅', 'http://www.sdjt.gov.cn/index.jsp', 0, 0, 0, 4355, 0, 1, 0, NULL, 67, '', ''),
(4603, '1289788564', '河南省交通厅', 'http://www.hncd.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 68, '', ''),
(4604, '1289788564', '湖北省交通厅', 'http://www.hbjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 69, '', ''),
(4605, '1289788564', '湖南省交通厅', 'http://www.hnjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 70, '', ''),
(4606, '1289788564', '广东省交通厅', 'http://2006.moc.gov.cn/06guangdong', 0, 0, 0, 4355, 0, 1, 0, NULL, 71, '', ''),
(4607, '1289788564', '广西交通', 'http://www.gxjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 72, '', ''),
(4608, '1289788564', '海南省交通厅', 'http://2006.moc.gov.cn/06hainan', 0, 0, 0, 4355, 0, 1, 0, NULL, 73, '', ''),
(4609, '1289788564', '四川省交通厅', 'http://www.scjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 74, '', ''),
(4610, '1289788564', '贵州省交通厅', 'http://www.qjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 75, '', ''),
(4611, '1289788564', '西藏自治区交通厅', 'http://2006.moc.gov.cn/06xizang', 0, 0, 0, 4355, 0, 1, 0, NULL, 76, '', ''),
(4612, '1289788564', '陕西省交通厅', 'http://www.sxsjtt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 77, '', ''),
(4613, '1289788564', '青海省交通厅', 'http://www.qhjtt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 78, '', ''),
(4614, '1289788564', '宁夏交通厅', 'http://www.nxcd.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 79, '', ''),
(4615, '1289788564', '新疆交通厅', 'http://www.xjjt.gov.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 80, '', ''),
(4616, '1289788564', '中国国际航空公司', 'http://www.airchina.com.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 81, '', ''),
(4617, '1289788564', '南方航空', 'http://www.csair.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 82, '', ''),
(4618, '1289788564', '民航资源网', 'http://www.carnoc.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 83, '', ''),
(4619, '1289788564', '上海航空公司', 'http://www.shanghai-air.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 84, '', ''),
(4620, '1289788564', '东方航空', 'http://www.ce-air.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 85, '', ''),
(4621, '1289788564', '深圳航空', 'http://www.shenzhenair.com/index.jsp', 0, 0, 0, 4355, 0, 1, 0, NULL, 86, '', ''),
(4622, '1289788564', '厦门航空', 'http://www.xiamenair.com.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 87, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(4623, '1289788564', '海南航空', 'http://www.hnair.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 88, '', ''),
(4624, '1289788564', '國泰航空', 'http://www.cathaypacific.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 89, '', ''),
(4625, '1289788564', '中华航空公司', 'http://www.china-airlines.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 90, '', ''),
(4626, '1289788564', '《中国交通报》', 'http://paper.zgjtb.com/jtb', 0, 0, 0, 4355, 0, 1, 0, NULL, 91, '', ''),
(4627, '1289788564', '《中国物流与采购》', 'http://www.clpma.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 92, '', ''),
(4628, '1289788564', '《航运交易公报》', 'http://www.sse.net.cn/bulletin/bu.asp', 0, 0, 0, 4355, 0, 1, 0, NULL, 93, '', ''),
(4629, '1289788564', '《运输经理世界》', 'http://www.transport.net.cn', 0, 0, 0, 4355, 0, 1, 0, NULL, 94, '', ''),
(4630, '1289788564', '《物流》', 'http://www.gd-logistics.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 95, '', ''),
(4631, '1289788564', '《物流技术》', 'http://www.logisticstech.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 96, '', ''),
(4632, '1289788564', '《现代物流报》', 'http://www.xd56b.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 97, '', ''),
(4633, '1289788564', '《中国储运》', 'http://www.chinachuyun.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 98, '', ''),
(4634, '1289788564', '《深圳船务》', 'http://www.szshipping.net', 0, 0, 0, 4355, 0, 1, 0, NULL, 99, '', ''),
(4635, '1289788564', '《湖北交通报》', 'http://www.hbjt.gov.cn/WEBSITE/jtb/index.htm', 0, 0, 0, 4355, 0, 1, 0, NULL, 100, '', ''),
(4636, '1289788564', '《江苏交通报》', 'http://www.jsjtb.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 101, '', ''),
(4637, '1289788564', '物流技术与应用杂志', 'http://www.edit56.com', 0, 0, 0, 4355, 0, 1, 0, NULL, 102, '', ''),
(4638, '1289788606', '浙江气象', 'http://www.zjmb.gov.cn/', 0, 0, 0, 4113, 0, 1, 0, NULL, 1, '', ''),
(4639, '1289788606', '杭州公交', 'http://www.hzbus.com.cn/', 0, 0, 0, 4113, 0, 1, 0, NULL, 2, '', ''),
(4640, '1289788606', '百度地图杭州', 'http://map.baidu.com/m?word=%BA%BC%D6%DD&amp;amp;ct=10', 0, 0, 0, 4113, 0, 1, 0, NULL, 3, '', ''),
(4641, '1289788606', '宁波交警网', 'http://www.nbjj.gov.cn/', 0, 0, 0, 4113, 0, 1, 0, NULL, 4, '', ''),
(4642, '1289788606', '杭州市民卡', 'http://www.96225.com/', 0, 0, 0, 4113, 0, 1, 0, NULL, 5, '', ''),
(4643, '1289788606', '杭州丁丁地图', 'http://hz.ddmap.com/', 0, 0, 0, 4113, 0, 1, 0, NULL, 6, '', ''),
(4644, '1289788606', '浙江旅游网', 'http://www.tourzj.com/', 0, 0, 0, 4113, 0, 1, 0, NULL, 7, '', ''),
(4645, '1289788606', '宁波旅游网', 'http://www.zjningbo.com/', 0, 0, 0, 4113, 0, 1, 0, NULL, 8, '', ''),
(4646, '1289788606', '横店影视城', 'http://www.hengdianworld.com/', 0, 0, 0, 4113, 0, 1, 0, NULL, 9, '', ''),
(4647, '1289788606', '大众点评网杭州', 'http://www.dianping.com/hangzhou/food', 0, 0, 0, 4113, 0, 1, 0, NULL, 10, '', ''),
(4648, '1289788606', '吃在杭州', 'http://food.zjol.com.cn/', 0, 0, 0, 4113, 0, 1, 0, NULL, 11, '', ''),
(4649, '1289788606', '四季青服装网', 'http://www.sjq.cn/', 0, 0, 0, 4113, 0, 1, 0, NULL, 12, '', ''),
(4650, '1289788606', '好易购', 'http://www.best1.com/', 0, 0, 0, 4113, 0, 1, 0, NULL, 13, '', ''),
(4651, '1289788606', '搜房网-杭州频道', 'http://hz.soufun.com/', 0, 0, 0, 4113, 0, 1, 0, NULL, 14, '', ''),
(4652, '1289788606', '住在杭州', 'http://www.livinghangzhou.com/', 0, 0, 0, 4113, 0, 1, 0, NULL, 15, '', ''),
(4653, '1289788606', '浙大医学院第二附院', 'http://www.z2hospital.com', 0, 0, 0, 4113, 0, 1, 0, NULL, 16, '', ''),
(4654, '1289788606', '浙江省中医院', 'http://www.zjhtcm.com/', 0, 0, 0, 4113, 0, 1, 0, NULL, 17, '', ''),
(4655, '1289788606', '浙江省人民医院', 'http://www.hospitalstar.com/', 0, 0, 0, 4113, 0, 1, 0, NULL, 18, '', ''),
(4656, '1289788606', '浙江省妇保医院', 'http://www.womanhospital.cn/', 0, 0, 0, 4113, 0, 1, 0, NULL, 19, '', ''),
(4657, '1289788606', '浙江医院', 'http://www.zjhospital.com.cn/', 0, 0, 0, 4113, 0, 1, 0, NULL, 20, '', ''),
(4658, '1289788606', '浙大附属儿童医院', 'http://www.zjuch.cn/', 0, 0, 0, 4113, 0, 1, 0, NULL, 21, '', ''),
(4659, '1289788606', '浙江省卫生厅', 'http://www.zjwst.gov.cn/', 0, 0, 0, 4113, 0, 1, 0, NULL, 22, '', ''),
(4660, '1289788644', '酒店特价预订', 'http://www.ctrip.com/', 0, 0, 0, 4378, 0, 1, 1289788684, NULL, 1, '', ''),
(4699, '1289788699', '豆豆网', 'http://www.doudou.com/', 0, 0, 0, 4115, 0, 1, 1290668481, NULL, 1, '', ''),
(4661, '1289788644', '7天连锁酒店', 'http://www.7daysinn.cn/', 0, 0, 0, 4378, 0, 1, 1289788710, NULL, 2, '', ''),
(4728, '1289788719', '浙江省政府', 'http://www.zhejiang.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 1, '', ''),
(4662, '1289788644', '迈点网', 'http://www.meadin.com', 0, 0, 0, 4378, 0, 1, 0, NULL, 3, '', ''),
(4663, '1289788644', 'e龙-酒店预订', 'http://hotel.elong.com/', 0, 0, 0, 4378, 0, 1, 0, NULL, 4, '', ''),
(4664, '1289788644', '如家酒店连锁', 'http://www.homeinns.com/', 0, 0, 0, 4378, 0, 1, 0, NULL, 5, '', ''),
(4665, '1289788644', 'Qunar折扣酒店', 'http://cdn.deals.qunar.com/ad/activity/Qunar_DM/flights_dj_mkt31.html?flightDM=mkt31Fday1&amp;amp;hotelDM=mkt31Hday1&amp;amp;ticketDM=mkt31Day1', 0, 0, 0, 4378, 0, 1, 0, NULL, 6, '', ''),
(4666, '1289788644', '慧聪网-酒店行业', 'http://www.hotel.hc360.com/', 0, 0, 0, 4378, 0, 1, 0, NULL, 7, '', ''),
(4667, '1289788676', '浙江大学', 'http://www.zju.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 1, '', ''),
(4668, '1289788676', '公安海警学院', 'http://www.hjgz.net/', 0, 0, 0, 4114, 0, 1, 0, NULL, 2, '', ''),
(4669, '1289788676', '宁波大学', 'http://www.nbu.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 3, '', ''),
(4670, '1289788676', '浙江工业大学', 'http://www.zjut.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 4, '', ''),
(4671, '1289788676', '杭州电子科技大学', 'http://www.hdu.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 5, '', ''),
(4672, '1289788676', '浙江理工大学', 'http://www.zist.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 6, '', ''),
(4673, '1289788676', '浙江农林大学', 'http://www.zjfc.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 7, '', ''),
(4674, '1289788676', '浙江中医药大学', 'http://www.zjtcm.net/', 0, 0, 0, 4114, 0, 1, 0, NULL, 8, '', ''),
(4675, '1289788676', '浙江师范大学', 'http://www.zjnu.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 9, '', ''),
(4676, '1289788676', '杭州师范大学', 'http://www.hznu.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 10, '', ''),
(4677, '1289788676', '浙江工商大学', 'http://www.hzic.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 11, '', ''),
(4678, '1289788676', '宁波诺丁汉大学', 'http://www.nottingham.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 12, '', ''),
(4679, '1289788676', '温州大学', 'http://www.wzu.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 13, '', ''),
(4680, '1289788676', '宁波大红鹰学院', 'http://www.dhyedu.com/', 0, 0, 0, 4114, 0, 1, 0, NULL, 14, '', ''),
(4681, '1289788676', '浙江越秀外国语学院', 'http://www.yxc.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 15, '', ''),
(4682, '1289788676', '中国计量学院', 'http://www.cjlu.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 16, '', ''),
(4683, '1289788676', '宁波工程学院', 'http://www.nbut.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 17, '', ''),
(4684, '1289788676', '嘉兴学院', 'http://www.zjxu.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 18, '', ''),
(4685, '1289788676', '浙江科技学院', 'http://www.zust.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 19, '', ''),
(4686, '1289788676', '浙江海洋学院', 'http://www.zjou.net.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 20, '', ''),
(4687, '1289788676', '温州医学院', 'http://www.wzmc.net/', 0, 0, 0, 4114, 0, 1, 0, NULL, 21, '', ''),
(4688, '1289788676', '湖州师范学院', 'http://www.hutc.zj.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 22, '', ''),
(4689, '1289788676', '台州学院', 'http://www.tzc.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 23, '', ''),
(4690, '1289788676', '绍兴文理学院', 'http://www.usx.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 24, '', ''),
(4691, '1289788676', '浙江传媒学院', 'http://www.zjicm.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 25, '', ''),
(4692, '1289788676', '浙江外国语学院', 'http://www.zjei.net/', 0, 0, 0, 4114, 0, 1, 0, NULL, 26, '', ''),
(4693, '1289788676', '浙江财经学院', 'http://www.zufe.edu.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 27, '', ''),
(4694, '1289788676', '浙江警察学院', 'http://www.zjjcxy.cn/default.html', 0, 0, 0, 4114, 0, 1, 0, NULL, 28, '', ''),
(4695, '1289788676', '中国美术学院', 'http://www.chinaacademyofart.com/', 0, 0, 0, 4114, 0, 1, 0, NULL, 29, '', ''),
(4696, '1289788676', '浙江树人学院', 'http://www.zjsru.cn/', 0, 0, 0, 4114, 0, 1, 0, NULL, 30, '', ''),
(4697, '1289788676', '浙江万里学院', 'http://www.zjwu.net/', 0, 0, 0, 4114, 0, 1, 0, NULL, 31, '', ''),
(4698, '1289788676', '丽水学院', 'http://www.lsxy.com/', 0, 0, 0, 4114, 0, 1, 0, NULL, 32, '', ''),
(4700, '1289788699', '19楼论坛', 'http://www.19lou.com/', 0, 0, 0, 4115, 0, 1, 0, NULL, 2, '', ''),
(4701, '1289788699', '新金华论坛', 'http://bbs.jhnews.com.cn/', 0, 0, 0, 4115, 0, 1, 0, NULL, 3, '', ''),
(4702, '1289788699', '百度知道浙江', 'http://zhidao.baidu.com/browse/249', 0, 0, 0, 4115, 0, 1, 0, NULL, 4, '', ''),
(4703, '1289788699', '蹦蹦家园', 'http://www.bengbeng.com/', 0, 0, 0, 4115, 0, 1, 1290668590, NULL, 5, '', ''),
(4704, '1289788699', '温州贴吧', 'http://tieba.baidu.com/f?kw=%CE%C2%D6%DD', 0, 0, 0, 4115, 0, 1, 0, NULL, 6, '', ''),
(4705, '1289788699', '宁波天一社区', 'http://bbs.cnnb.com.cn/', 0, 0, 0, 4115, 0, 1, 0, NULL, 7, '', ''),
(4706, '1289788699', '浙江都市网论坛', 'http://club.zj.com/', 0, 0, 0, 4115, 0, 1, 0, NULL, 8, '', ''),
(4707, '1289788699', '百度杭州贴吧', 'http://tieba.baidu.com/f?ct=&amp;amp;tn=&amp;amp;rn=&amp;amp;pn=&amp;amp;lm=&amp;amp;sc=&amp;amp;kw=%BA%BC%D6%DD&amp;amp;rs2=0&amp;amp;myselectvalue=1&amp;amp;word=%BA%BC%D6%DD&amp;amp;tb=on', 0, 0, 0, 4115, 0, 1, 0, NULL, 9, '', ''),
(4708, '1289788699', '东方热线论坛', 'http://forum.cnool.net/', 0, 0, 0, 4115, 0, 1, 0, NULL, 10, '', ''),
(4709, '1289788699', '宁波贴吧', 'http://tieba.baidu.com/f?kw=%C4%FE%B2%A8', 0, 0, 0, 4115, 0, 1, 0, NULL, 11, '', ''),
(4710, '1289788699', '百度浙江贴吧', 'http://tieba.baidu.com/f?kw=%D5%E3%BD%AD', 0, 0, 0, 4115, 0, 1, 0, NULL, 12, '', ''),
(4711, '1289788699', '温州bbs', 'http://bbs.66wz.com/', 0, 0, 0, 4115, 0, 1, 0, NULL, 13, '', ''),
(4712, '1289788699', '北干听风', 'http://bbs.xs163.net/', 0, 0, 0, 4115, 0, 1, 0, NULL, 14, '', ''),
(4713, '1289788699', '绍兴E网论坛', 'http://www.e0575.cn/', 0, 0, 0, 4115, 0, 1, 0, NULL, 15, '', ''),
(4714, '1289788699', '海宁论坛', 'http://www.haining.com.cn/', 0, 0, 0, 4115, 0, 1, 0, NULL, 16, '', ''),
(4715, '1289788699', '703温州论坛', 'http://bbs.703804.com/', 0, 0, 0, 4115, 0, 1, 0, NULL, 17, '', ''),
(4716, '1289788699', '义乌稠州论坛', 'http://bbs.cnyw.net/', 0, 0, 0, 4115, 0, 1, 0, NULL, 18, '', ''),
(4717, '1289788699', '新北仑', 'http://bbs.cnnb.com/', 0, 0, 0, 4115, 0, 1, 0, NULL, 19, '', ''),
(4718, '1289788699', '上虞论坛', 'http://www.0575bbs.com', 0, 0, 0, 4115, 0, 1, 0, NULL, 20, '', ''),
(4719, '1289788699', '宁波论坛', 'http://bbs.nbw.cn', 0, 0, 0, 4115, 0, 1, 0, NULL, 21, '', ''),
(4720, '1289788699', '瑞安论坛', 'http://bbs.ruian.com/', 0, 0, 0, 4115, 0, 1, 0, NULL, 22, '', ''),
(4721, '1289788699', '慈溪论坛', 'http://bbs.zxip.com/', 0, 0, 0, 4115, 0, 1, 0, NULL, 23, '', ''),
(4722, '1289788699', '千岛论坛', 'http://bbs.qiandao.net/', 0, 0, 0, 4115, 0, 1, 0, NULL, 24, '', ''),
(4723, '1289788699', '舟山论坛', 'http://bbs.zhoushan.cn/', 0, 0, 0, 4115, 0, 1, 0, NULL, 25, '', ''),
(4724, '1289788699', '乐清上班族', 'http://bbs.5iyq.com/', 0, 0, 0, 4115, 0, 1, 0, NULL, 26, '', ''),
(4725, '1289788699', '海盐论坛', 'http://www.hybbs.com/', 0, 0, 0, 4115, 0, 1, 0, NULL, 27, '', ''),
(4726, '1289788699', '余姚论坛', 'http://www.0574bbs.com/', 0, 0, 0, 4115, 0, 1, 0, NULL, 28, '', ''),
(4727, '1289788699', '平湖在线', 'http://www.ph66.com/', 0, 0, 0, 4115, 0, 1, 0, NULL, 29, '', ''),
(4729, '1289788719', '省发改委', 'http://www.zjdpc.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 2, '', ''),
(4730, '1289788719', '省民政厅', 'http://www.zjmz.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 3, '', ''),
(4731, '1289788719', '省劳动保障厅', 'http://www.zj.molss.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 4, '', ''),
(4732, '1289788719', '省工商局', 'http://www.zjaic.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 5, '', ''),
(4733, '1289788719', '省国土资源厅', 'http://www.zjdlr.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 6, '', ''),
(4734, '1289788719', '省法制办', 'http://www.zjfzb.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 7, '', ''),
(4735, '1289788719', '浙江省法院', 'http://www.zjcourt.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 8, '', ''),
(4736, '1289788719', '杭州市', 'http://www.hangzhou.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 9, '', ''),
(4737, '1289788719', '宁波市', 'http://www.ningbo.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 10, '', ''),
(4738, '1289788719', '温州市', 'http://www.wenzhou.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 11, '', ''),
(4739, '1289788719', '湖州市', 'http://www.huzhou.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 12, '', ''),
(4740, '1289788719', '嘉兴市', 'http://www.jiaxing.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 13, '', ''),
(4741, '1289788719', '绍兴市', 'http://www.sx.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 14, '', ''),
(4742, '1289788719', '金华市', 'http://www.jinhua.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 15, '', ''),
(4743, '1289788719', '舟山市', 'http://www.zhoushan.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 16, '', ''),
(4744, '1289788719', '台州市', 'http://www.zjtz.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 17, '', ''),
(4745, '1289788719', '衢州市', 'http://www.quzhou.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 18, '', ''),
(4746, '1289788719', '丽水市', 'http://www.lishui.gov.cn/', 0, 0, 0, 4116, 0, 1, 0, NULL, 19, '', ''),
(4747, '1289788751', '合肥热线', 'http://www.hefei.cc/', 0, 0, 0, 4121, 0, 1, 0, NULL, 1, '', ''),
(4748, '1289788751', '江淮热线', 'http://www.hf.ah163.net/', 0, 0, 0, 4121, 0, 1, 0, NULL, 2, '', ''),
(4749, '1289788751', '阜阳信息港', 'http://www.fy.ah163.net/', 0, 0, 0, 4121, 0, 1, 0, NULL, 3, '', ''),
(4750, '1289788751', '池州人网', 'http://www.chizhouren.com/', 0, 0, 0, 4121, 0, 1, 0, NULL, 4, '', ''),
(4751, '1289788751', '小城天长', 'http://www.tcren.cn/', 0, 0, 0, 4121, 0, 1, 0, NULL, 5, '', ''),
(4752, '1289788751', '蚌埠人', 'http://www.bbr.cn/', 0, 0, 0, 4121, 0, 1, 0, NULL, 6, '', ''),
(4753, '1289788751', 'e滁州', 'http://www.echuzhou.cn/', 0, 0, 0, 4121, 0, 1, 0, NULL, 7, '', ''),
(4754, '1289788751', '安庆信息港', 'http://www.aq.ah163.net/', 0, 0, 0, 4121, 0, 1, 0, NULL, 8, '', ''),
(4755, '1289788751', '铜陵铜都时空', 'http://www.tl.ah163.net/', 0, 0, 0, 4121, 0, 1, 0, NULL, 9, '', ''),
(4756, '1289788751', '巢湖在线', 'http://www.ch365.com.cn/', 0, 0, 0, 4121, 0, 1, 0, NULL, 10, '', ''),
(4757, '1289788751', '芜湖信息港', 'http://www.wh.ah163.net/', 0, 0, 0, 4121, 0, 1, 0, NULL, 11, '', ''),
(4758, '1289788751', '亳州信息港', 'http://www.bz.ah163.net/', 0, 0, 0, 4121, 0, 1, 0, NULL, 12, '', ''),
(4759, '1289788751', '芜湖新闻网', 'http://www.wuhunews.cn/', 0, 0, 0, 4121, 0, 1, 0, NULL, 13, '', ''),
(4760, '1289788751', '淮南信息港', 'http://www.hn.ah163.net/', 0, 0, 0, 4121, 0, 1, 0, NULL, 14, '', ''),
(4761, '1289788751', '安徽热线', 'http://www.ah163.net/', 0, 0, 0, 4121, 0, 1, 0, NULL, 15, '', ''),
(4762, '1289788771', '中安在线', 'http://www.anhuinews.com/', 0, 0, 0, 4122, 0, 1, 0, NULL, 1, '', ''),
(4763, '1289788771', '炎黄在线', 'http://www.yh365.com/', 0, 0, 0, 4122, 0, 1, 0, NULL, 2, '', ''),
(4764, '1289788771', '安徽热线', 'http://www.ah163.net/', 0, 0, 0, 4122, 0, 1, 0, NULL, 3, '', ''),
(4765, '1289788771', '合肥热线', 'http://www.hefei.cc/', 0, 0, 0, 4122, 0, 1, 0, NULL, 4, '', ''),
(4766, '1289788771', '江淮热线', 'http://hf.ah163.net/', 0, 0, 0, 4122, 0, 1, 0, NULL, 5, '', ''),
(4767, '1289788771', '合肥报业网', 'http://www.hf365.com/', 0, 0, 0, 4122, 0, 1, 0, NULL, 6, '', ''),
(4768, '1289788771', '安徽农网', 'http://www.ahnw.gov.cn/', 0, 0, 0, 4122, 0, 1, 0, NULL, 7, '', ''),
(4769, '1289788771', '阜阳信息港', 'http://www.fy.ah163.net/', 0, 0, 0, 4122, 0, 1, 0, NULL, 8, '', ''),
(4770, '1289788771', '安徽法制报', 'http://epaper.anhuinews.com/ahfzb/', 0, 0, 0, 4122, 0, 1, 0, NULL, 9, '', ''),
(4771, '1289788771', '巢湖在线', 'http://www.ch365.com.cn/', 0, 0, 0, 4122, 0, 1, 0, NULL, 10, '', ''),
(4772, '1289788771', '蚌埠人', 'http://www.bbr.cn/', 0, 0, 0, 4122, 0, 1, 0, NULL, 11, '', ''),
(4773, '1289788771', 'e滁州', 'http://www.echuzhou.cn/', 0, 0, 0, 4122, 0, 1, 0, NULL, 12, '', ''),
(4774, '1289788771', '安庆信息港', 'http://www.aq.ah163.net/', 0, 0, 0, 4122, 0, 1, 0, NULL, 13, '', ''),
(4775, '1289788771', '马鞍山信息港', 'http://www.mas.ah163.net/', 0, 0, 0, 4122, 0, 1, 0, NULL, 14, '', ''),
(4776, '1289788771', '宣城信息港', 'http://www.xc.ah163.net/', 0, 0, 0, 4122, 0, 1, 0, NULL, 15, '', ''),
(4777, '1289788771', '芜湖信息港', 'http://www.wh.ah163.net/', 0, 0, 0, 4122, 0, 1, 0, NULL, 16, '', ''),
(4778, '1289788771', '亳州信息港', 'http://www.bz.ah163.net/', 0, 0, 0, 4122, 0, 1, 0, NULL, 17, '', ''),
(4779, '1289788771', '六安信息港', 'http://www.la.ah163.net/', 0, 0, 0, 4122, 0, 1, 0, NULL, 18, '', ''),
(4780, '1289788771', '铜陵铜都时空', 'http://www.tl.ah163.net/', 0, 0, 0, 4122, 0, 1, 0, NULL, 19, '', ''),
(4781, '1289788771', '巢湖信息港', 'http://www.ch.ah163.net/', 0, 0, 0, 4122, 0, 1, 0, NULL, 20, '', ''),
(4782, '1289788771', '阜阳168', 'http://www.fy168.cc/', 0, 0, 0, 4122, 0, 1, 0, NULL, 21, '', ''),
(4783, '1289788771', '安徽日报', 'http://epaper.anhuinews.com/ahrb.aspx', 0, 0, 0, 4122, 0, 1, 0, NULL, 22, '', ''),
(4784, '1289788771', '合肥在线', 'http://www.hf365.com/', 0, 0, 0, 4122, 0, 1, 0, NULL, 23, '', ''),
(4785, '1289788771', '安庆新闻网', 'http://www.aqnews.com.cn/', 0, 0, 0, 4122, 0, 1, 0, NULL, 24, '', ''),
(4786, '1289788771', '枞阳在线', 'http://www.aqzyzx.com/', 0, 0, 0, 4122, 0, 1, 0, NULL, 25, '', ''),
(4787, '1289788771', '新安晚报', 'http://epaper.anhuinews.com/xawb', 0, 0, 0, 4122, 0, 1, 0, NULL, 26, '', ''),
(4788, '1289788771', '江淮晨报', 'http://pdf.hf365.com/jhcbpdf/', 0, 0, 0, 4122, 0, 1, 0, NULL, 27, '', ''),
(4789, '1289788771', '江淮时报', 'http://epaper.anhuinews.com/jhsb', 0, 0, 0, 4122, 0, 1, 0, NULL, 28, '', ''),
(4790, '1289788771', '安徽商报', 'http://epaper.anhuinews.com/ahsb', 0, 0, 0, 4122, 0, 1, 0, NULL, 29, '', ''),
(4791, '1289788771', '安徽法制报', 'http://epaper.anhuinews.com/ahfzb', 0, 0, 0, 4122, 0, 1, 0, NULL, 30, '', ''),
(4792, '1289788771', '安徽电视台', 'http://www.ahtv.cn/', 0, 0, 0, 4122, 0, 1, 0, NULL, 31, '', ''),
(4793, '1289788771', '芜狐网', 'http://www.wuhubtv.com/', 0, 0, 0, 4122, 0, 1, 0, NULL, 32, '', ''),
(4794, '1289788782', '北京铁通', 'http://www.cttbj.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 1, '', ''),
(4795, '1289788782', '天津铁通', 'http://www.ctttj.com/', 0, 0, 0, 4379, 0, 1, 0, NULL, 2, '', ''),
(4796, '1289788782', '上海铁通', 'http://www.cttsh.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 3, '', ''),
(4797, '1289788782', '黑龙江分铁通', 'http://www.ctthlj.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 4, '', ''),
(4798, '1289788782', '吉林铁通', 'http://www.cttjl.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 5, '', ''),
(4799, '1289788782', '河北铁通', 'http://www.ctthe.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 6, '', ''),
(4800, '1289788782', '陕西铁通', 'http://www.cttsn.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 7, '', ''),
(4801, '1289788782', '山西铁通', 'http://www.cttsx.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 8, '', ''),
(4802, '1289788782', '湖北铁通', 'http://www.ctthb.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 9, '', ''),
(4803, '1289788782', '河南铁通', 'http://www.cttha.com/', 0, 0, 0, 4379, 0, 1, 0, NULL, 10, '', ''),
(4804, '1289788782', '山东铁通', 'http://www.cttsd.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 11, '', ''),
(4805, '1289788782', '浙江铁通', 'http://www.cttzj.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 12, '', ''),
(4806, '1289788782', '安徽铁通', 'http://www.cttah.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 13, '', ''),
(4807, '1289788782', '江苏铁通', 'http://www.cttjs.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 14, '', ''),
(4808, '1289788782', '重庆铁通', 'http://www.cttcq.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 15, '', ''),
(4809, '1289788782', '四川铁通', 'http://www.cttsc.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 16, '', ''),
(4810, '1289788782', '云南铁通', 'http://www.cttyn.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 17, '', ''),
(4811, '1289788782', '福建铁通', 'http://www.cttfz.com/index.asp', 0, 0, 0, 4379, 0, 1, 0, NULL, 18, '', ''),
(4812, '1289788782', '江西铁通', 'http://www.cttjx.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 19, '', ''),
(4813, '1289788782', '广东铁通', 'http://www.cttgd.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 20, '', ''),
(4814, '1289788782', '湖南铁通', 'http://www.ctthn.com/', 0, 0, 0, 4379, 0, 1, 0, NULL, 21, '', ''),
(4815, '1289788782', '广西铁通', 'http://kf.cttgx.com/index.asp', 0, 0, 0, 4379, 0, 1, 0, NULL, 22, '', ''),
(4816, '1289788782', '海南铁通', 'http://www.ctthi.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 23, '', ''),
(4817, '1289788782', '青海铁通', 'http://www.cttqh.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 24, '', ''),
(4818, '1289788782', '内蒙古铁通', 'http://www.cttnm.com', 0, 0, 0, 4379, 0, 1, 0, NULL, 25, '', ''),
(4819, '1289788798', '安徽气象', 'http://www.ahqx.gov.cn/', 0, 0, 0, 4123, 0, 1, 0, NULL, 1, '', ''),
(4820, '1289788798', '安徽地图网', 'http://map.baidu.com/#word=%B0%B2%BB%D5&amp;amp;ct=10', 0, 0, 0, 4123, 0, 1, 0, NULL, 2, '', ''),
(4821, '1289788798', '百度地图合肥市', 'http://map.baidu.com/#word=%E5%90%88%E8%82%A5&amp;amp;ct=10', 0, 0, 0, 4123, 0, 1, 0, NULL, 3, '', ''),
(4822, '1289788798', '合肥公交', 'http://www.hfbus.cn/', 0, 0, 0, 4123, 0, 1, 0, NULL, 4, '', ''),
(4823, '1289788798', '合肥火车站', 'http://www.hfstation.com/', 0, 0, 0, 4123, 0, 1, 0, NULL, 5, '', ''),
(4824, '1289788798', '合肥交通违章查询', 'http://www.hfjjzd.gov.cn/', 0, 0, 0, 4123, 0, 1, 0, NULL, 6, '', ''),
(4825, '1289788798', '列车时刻', 'http://lieche.5w.com/', 0, 0, 0, 4123, 0, 1, 0, NULL, 7, '', ''),
(4826, '1289788798', '安徽旅游资讯网', 'http://www.ahta.com.cn/', 0, 0, 0, 4123, 0, 1, 0, NULL, 8, '', ''),
(4827, '1289788798', '安徽旅游信息港', 'http://www.anhuiok.net/', 0, 0, 0, 4123, 0, 1, 0, NULL, 9, '', ''),
(4828, '1289788798', '九华山', 'http://www.jiuhuashan.cc/', 0, 0, 0, 4123, 0, 1, 0, NULL, 10, '', ''),
(4829, '1289788798', '桃花溪自然旅游风景区', 'http://www.ahthx.com/', 0, 0, 0, 4123, 0, 1, 0, NULL, 11, '', ''),
(4830, '1289788798', '绩溪旅游网', 'http://www.jixitour.com/', 0, 0, 0, 4123, 0, 1, 0, NULL, 12, '', ''),
(4831, '1289788798', '合肥吃吧', 'http://www.eatba.com/', 0, 0, 0, 4123, 0, 1, 0, NULL, 13, '', ''),
(4832, '1289788798', '合肥生活消费网', 'http://www.0551life.com/', 0, 0, 0, 4123, 0, 1, 0, NULL, 14, '', ''),
(4833, '1289788798', '安徽团购网', 'http://www.0551.com/', 0, 0, 0, 4123, 0, 1, 0, NULL, 15, '', ''),
(4834, '1289788805', '北京联通', 'http://www.bj.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 0, NULL, 1, '', ''),
(4835, '1289788805', '上海联通', 'http://www.sh.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 0, NULL, 2, '', ''),
(4836, '1289788805', '河北联通', 'http://www.he.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 0, NULL, 3, '', ''),
(4837, '1289788805', '吉林联通', 'http://www.jl165.com/', 0, 0, 0, 4380, 0, 1, 0, NULL, 4, '', ''),
(4838, '1289788805', '福建联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010006&id=1820', 0, 0, 0, 4380, 0, 1, 1289801518, NULL, 5, '', ''),
(4839, '1289788805', '湖北联通', 'http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010024&id=1349', 0, 0, 0, 4380, 0, 1, 1289801518, NULL, 6, '', ''),
(4840, '1289788805', '海南联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010005&id=1645', 0, 0, 0, 4380, 0, 1, 1289801518, NULL, 7, '', ''),
(4841, '1289788805', '云南联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010026&id=4154', 0, 0, 0, 4380, 0, 1, 1289801518, NULL, 8, '', ''),
(4842, '1289788805', '山西联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010018&id=2946', 0, 0, 0, 4380, 0, 1, 1289801518, NULL, 9, '', ''),
(4843, '1289788805', '黑龙江联通', 'http://www.hl.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 0, NULL, 10, '', ''),
(4844, '1289788805', '江苏联通', 'http://www.js.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 0, NULL, 11, '', ''),
(4845, '1289788805', '江西联通', 'http://www.jx.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 0, NULL, 12, '', ''),
(4846, '1289788805', '湖南联通', 'http://www.hn.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 0, NULL, 13, '', ''),
(4847, '1289788805', '江苏联通', 'http://www.js.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 0, NULL, 14, '', ''),
(4848, '1289788805', '浙江联通', 'http://www.zj.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 0, NULL, 15, '', ''),
(4849, '1289788805', '山东联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010016&id=2651', 0, 0, 0, 4380, 0, 1, 1289801518, NULL, 16, '', ''),
(4850, '1289788805', '广东联通', 'http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010004&id=1677', 0, 0, 0, 4380, 0, 1, 1289801518, NULL, 17, '', ''),
(4851, '1289788805', '四川联通', 'http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010009&id=3368', 0, 0, 0, 4380, 0, 1, 1289801518, NULL, 18, '', ''),
(4852, '1289788805', '陕西联通', 'http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010015&id=2533', 0, 0, 0, 4380, 0, 1, 1289801518, NULL, 19, '', ''),
(4853, '1289788805', '重庆联通', 'http://www.on165.com/index.aspx', 0, 0, 0, 4380, 0, 1, 0, NULL, 20, '', ''),
(4854, '1289788805', '辽宁联通', 'http://www.ln.cnc.cn/', 0, 0, 0, 4380, 0, 1, 0, NULL, 21, '', ''),
(4855, '1289788805', '安徽联通', 'http://www.ah.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 0, NULL, 22, '', ''),
(4856, '1289788805', '河南联通', 'http://www.ha.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 1289801162, NULL, 23, '', ''),
(4857, '1289788805', '广西联通', 'http://www.gx.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 1289801463, NULL, 24, '', ''),
(7852, '1289802154', '智联招聘-北京', 'http://www.zhaopin.com/jobseeker/index_bj.html', 0, 0, 0, 1085, 0, 1, 0, NULL, 2, '', ''),
(4858, '1289788805', '贵州联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010027&id=3944', 0, 0, 0, 4380, 0, 1, 1289801447, NULL, 25, '', ''),
(4859, '1289788805', '青海联通', 'http://www.qh.chinaunicom.com/', 0, 0, 0, 4380, 0, 1, 1289801442, NULL, 26, '', ''),
(4860, '1289788805', '新疆联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010021&id=3255', 0, 0, 0, 4380, 0, 1, 1289801412, NULL, 27, '', ''),
(4861, '1289788805', '内蒙古联通', 'http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010029&id=4042', 0, 0, 0, 4380, 0, 1, 1289801405, NULL, 28, '', ''),
(4862, '1289788830', '中国科学技术大学', 'http://www.ustc.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 1, '', ''),
(4863, '1289788830', '合肥工业大学', 'http://www.hfut.edu.cn/ch/', 0, 0, 0, 4124, 0, 1, 0, NULL, 2, '', ''),
(4864, '1289788830', '安徽大学', 'http://www.ahu.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 3, '', ''),
(4865, '1289788830', '安徽理工大学', 'http://www.aust.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 4, '', ''),
(4866, '1289788830', '安徽工业大学', 'http://www.ahut.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 5, '', ''),
(4867, '1289788830', '安徽工程大学', 'http://www.auts.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 6, '', ''),
(4868, '1289788830', '安徽农业大学', 'http://www.ahau.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 7, '', ''),
(4869, '1289788830', '安徽医科大学', 'http://www.ahmu.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 8, '', ''),
(4870, '1289788830', '安徽师范大学', 'http://www.ahnu.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 9, '', ''),
(4871, '1289788830', '淮北师范大学', 'http://www.hbcnc.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 10, '', ''),
(4872, '1289788830', '安徽财经大学', 'http://www.aufe.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 11, '', ''),
(4873, '1289788830', '安徽三联学院', 'http://www.sanlian.net.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 12, '', ''),
(4874, '1289788830', '安徽建筑工业学院', 'http://www.aiai.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 13, '', ''),
(4875, '1289788830', '安徽中医学院', 'http://www.ahtcm.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 14, '', ''),
(4876, '1289788830', '皖南医学院', 'http://www.wnmc.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 15, '', ''),
(4877, '1289788830', '蚌埠医学院', 'http://www.bbmc.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 16, '', ''),
(4878, '1289788830', '阜阳师范学院', 'http://www.fync.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 17, '', ''),
(4879, '1289788830', '淮南师范学院', 'http://www.hnnu.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 18, '', ''),
(4880, '1289788830', '安庆师范学院', 'http://www.aqtc.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 19, '', ''),
(4881, '1289788830', '安徽科技学院', 'http://www.ahstu.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 20, '', ''),
(4882, '1289788830', '合肥师范学院', 'http://www.hftc.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 21, '', ''),
(4883, '1289788830', '黄山学院', 'http://www.hsc.org.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 22, '', ''),
(4884, '1289788830', '安徽新华学院', 'http://www.axhu.cn/axhu1/', 0, 0, 0, 4124, 0, 1, 0, NULL, 23, '', ''),
(4885, '1289788830', '宿州学院', 'http://www.ahsztc.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 24, '', ''),
(4886, '1289788830', '铜陵学院', 'http://www.tlc.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 25, '', ''),
(4887, '1289788830', '皖西学院', 'http://www.wxc.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 26, '', ''),
(4888, '1289788830', '巢湖学院', 'http://www.chtc.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 27, '', ''),
(4889, '1289788830', '合肥学院', 'http://www.hfuu.edu.cn/', 0, 0, 0, 4124, 0, 1, 0, NULL, 28, '', ''),
(4890, '1289788832', '北京移动', 'http://www.bj.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 1, '', ''),
(4891, '1289788832', '天津移动', 'http://www.tj.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 2, '', ''),
(4892, '1289788832', '上海移动', 'http://www.sh.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 3, '', ''),
(4893, '1289788832', '西藏移动', 'http://www.xz.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 4, '', ''),
(4894, '1289788832', '黑龙江移动', 'http://www.hl.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 5, '', ''),
(4895, '1289788832', '辽宁移动', 'http://www.ln.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 6, '', ''),
(4896, '1289788832', '河北移动', 'http://www.he.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 7, '', ''),
(4897, '1289788832', '山东移动', 'http://www.sd.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 8, '', ''),
(4898, '1289788832', '山西移动', 'http://www.sx.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 9, '', ''),
(4899, '1289788832', '江苏移动', 'http://www.js.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 10, '', ''),
(4900, '1289788832', '河南移动', 'http://www.ha.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 11, '', ''),
(4901, '1289788832', '安徽移动', 'http://www.ah.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 12, '', ''),
(4902, '1289788832', '浙江移动', 'http://www.zj.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 13, '', ''),
(4903, '1289788832', '河南移动', 'http://www.ha.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 14, '', ''),
(4904, '1289788832', '宁夏移动', 'http://www.nx.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 15, '', ''),
(4905, '1289788832', '陕西移动', 'http://www.sn.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 16, '', ''),
(4906, '1289788832', '湖北移动', 'http://www.hb.10086.cn/', 0, 0, 0, 4381, 0, 1, 1289801013, NULL, 17, '', ''),
(4907, '1289788832', '江西移动', 'http://www.jx.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 18, '', ''),
(4908, '1289788832', '福建移动', 'http://www.fj.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 19, '', ''),
(4909, '1289788832', '宁夏移动', 'http://www.nx.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 20, '', ''),
(4910, '1289788832', '甘肃移动', 'http://www.gs.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 21, '', ''),
(4911, '1289788832', '四川移动', 'http://www.sc.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 22, '', ''),
(4912, '1289788832', '重庆移动', 'http://www.cq.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 23, '', ''),
(4913, '1289788832', '湖南移动', 'http://www.hn.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 24, '', ''),
(4914, '1289788832', '广东移动', 'http://www.gd.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 25, '', ''),
(4915, '1289788832', '香港移动', 'http://www.chinamobileltd.com/', 0, 0, 0, 4381, 0, 1, 0, NULL, 26, '', ''),
(4916, '1289788832', '重庆移动', 'http://www.cq.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 27, '', ''),
(4917, '1289788832', '贵州移动', 'http://www.gz.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 28, '', ''),
(4918, '1289788832', '广西移动', 'http://www.gx.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 29, '', ''),
(4919, '1289788832', '云南移动', 'http://www.yn.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 30, '', ''),
(4920, '1289788832', '海南移动', 'http://www.hi.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 31, '', ''),
(4921, '1289788832', '内蒙古移动', 'http://www.nm.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 32, '', ''),
(4922, '1289788832', '青海移动', 'http://www.qh.10086.cn/', 0, 0, 0, 4381, 0, 1, 0, NULL, 33, '', ''),
(4923, '1289788832', '新疆移动', 'http://www.xj.10086.cn/', 0, 0, 0, 4381, 0, 1, 1289801050, NULL, 34, '', ''),
(4924, '1289788857', '中安论坛', 'http://bbs.anhuinews.com/', 0, 0, 0, 4125, 0, 1, 0, NULL, 1, '', ''),
(4925, '1289788857', '合肥论坛', 'http://bbs.hefei.cc/', 0, 0, 0, 4125, 0, 1, 0, NULL, 2, '', ''),
(4926, '1289788857', '宿州论坛', 'http://bbs.my0557.cn/', 0, 0, 0, 4125, 0, 1, 0, NULL, 3, '', ''),
(4927, '1289788857', '颍上论坛', 'http://bbs.ahys.gov.cn/', 0, 0, 0, 4125, 0, 1, 0, NULL, 4, '', ''),
(4928, '1289788857', '明光论坛', 'http://www.mgbbs.cn/', 0, 0, 0, 4125, 0, 1, 0, NULL, 5, '', ''),
(4929, '1289788857', '马鞍山OK论坛', 'http://www.masok.cn/', 0, 0, 0, 4125, 0, 1, 0, NULL, 6, '', ''),
(4930, '1289788857', '蚌埠论坛', 'http://www.ahbb.cc/', 0, 0, 0, 4125, 0, 1, 0, NULL, 7, '', ''),
(4931, '1289788857', '阜阳论坛', 'http://www.fy22.com/', 0, 0, 0, 4125, 0, 1, 0, NULL, 8, '', ''),
(4932, '1289788857', '广德论坛', 'http://bbs.gd163.cn/', 0, 0, 0, 4125, 0, 1, 0, NULL, 9, '', ''),
(4933, '1289788857', '淮北人论坛', 'http://bbs.hb163.cn/', 0, 0, 0, 4125, 0, 1, 0, NULL, 10, '', ''),
(4934, '1289788857', '芜湖论坛', 'http://bbs.0553114.com', 0, 0, 0, 4125, 0, 1, 0, NULL, 11, '', ''),
(4935, '1289788857', '北京电信', 'http://www.bjtelecom.net/', 0, 0, 0, 4382, 0, 1, 0, NULL, 1, '', ''),
(4936, '1289788857', '天津电信', 'http://tj.ct10000.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 2, '', ''),
(4937, '1289788857', '上海电信', 'http://sh.ct10000.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 3, '', ''),
(4938, '1289788857', '河北电信', 'http://www.hbtele.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 4, '', ''),
(4939, '1289788857', '福建电信', 'http://www.fjtelecom.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 5, '', ''),
(4940, '1289788857', '湖北电信', 'http://www.hbtelecom.com.cn/', 0, 0, 0, 4382, 0, 1, 0, NULL, 6, '', ''),
(4941, '1289788857', '海南电信', 'http://hi.ct10000.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 7, '', ''),
(4942, '1289788857', '云南电信', 'http://yn.ct10000.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 8, '', ''),
(4943, '1289788857', '山西电信', 'http://www.shanxitele.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 9, '', ''),
(4944, '1289788857', '黑龙江电信', 'http://www.hljtele.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 10, '', ''),
(4945, '1289788857', '江苏电信', 'http://www.telecomjs.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 11, '', ''),
(4946, '1289788857', '江西电信', 'http://jx.ct10000.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 12, '', ''),
(4947, '1289788857', '湖南电信', 'http://hn.ct10000.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 13, '', ''),
(4948, '1289788857', '浙江电信', 'http://zj.ct10000.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 14, '', ''),
(4949, '1289788857', '山东电信', 'http://www.sdtele.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 15, '', ''),
(4950, '1289788857', '广东电信', 'http://gd.ct10000.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 16, '', ''),
(4951, '1289788857', '四川电信', 'http://www.sctel.com.cn/', 0, 0, 0, 4382, 0, 1, 0, NULL, 17, '', ''),
(4952, '1289788857', '陕西电信', 'http://www.xaonline.com', 0, 0, 0, 4382, 0, 1, 0, NULL, 18, '', ''),
(4953, '1289788857', '重庆电信', 'http://www.cqtelecom.com.cn/', 0, 0, 0, 4382, 0, 1, 0, NULL, 19, '', ''),
(4954, '1289788857', '安徽电信', 'http://www.ahtelecom.com.cn/', 0, 0, 0, 4382, 0, 1, 0, NULL, 20, '', ''),
(4955, '1289788857', '河南电信', 'http://ha.ct10000.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 21, '', ''),
(4956, '1289788857', '广西电信', 'http://gx.ct10000.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 22, '', ''),
(4957, '1289788857', '贵州电信', 'http://www.gzdx.com.cn/', 0, 0, 0, 4382, 0, 1, 0, NULL, 23, '', ''),
(4958, '1289788857', '青海电信', 'http://www.qhtelecom.com.cn/', 0, 0, 0, 4382, 0, 1, 0, NULL, 24, '', ''),
(4959, '1289788857', '新疆电信', 'http://www.xjtelecom.com.cn/', 0, 0, 0, 4382, 0, 1, 0, NULL, 25, '', ''),
(4960, '1289788857', '内蒙古电信', 'http://nm.ct10000.com/', 0, 0, 0, 4382, 0, 1, 0, NULL, 26, '', ''),
(4961, '1289788882', '赛迪网通信', 'http://comm.ccidnet.com', 0, 0, 0, 4383, 0, 1, 0, NULL, 1, '', ''),
(4962, '1289788882', '通信产业网', 'http://www.ccidcom.com/', 0, 0, 0, 4383, 0, 1, 0, NULL, 2, '', ''),
(4963, '1289788882', '比特网-通信', 'http://telecom.chinabyte.com/', 0, 0, 0, 4383, 0, 1, 0, NULL, 3, '', ''),
(4964, '1289788882', '中国通信网', 'http://www.c114.net/', 0, 0, 0, 4383, 0, 1, 0, NULL, 4, '', ''),
(4965, '1289788882', '中国通信新闻网', 'http://www.cnii.com.cn/', 0, 0, 0, 4383, 0, 1, 0, NULL, 5, '', ''),
(4966, '1289788882', '中国信息产业网', 'http://www.cnii.com.cn/', 0, 0, 0, 4383, 0, 1, 0, NULL, 6, '', ''),
(4967, '1289788882', '新浪网电信与通讯', 'http://tech.sina.com.cn/tech', 0, 0, 0, 4383, 0, 1, 0, NULL, 7, '', ''),
(4968, '1289788882', '移动通信网', 'http://www.mscbsc.com', 0, 0, 0, 4383, 0, 1, 0, NULL, 8, '', ''),
(4969, '1289788882', 'CCTIME飞象网', 'http://www.cctime.com/', 0, 0, 0, 4383, 0, 1, 0, NULL, 9, '', ''),
(4970, '1289788882', '泰尔网-通信行业', 'http://www.catr.cn/', 0, 0, 0, 4383, 0, 1, 0, NULL, 10, '', ''),
(4971, '1289788887', '安徽省人民政府', 'http://www.ah.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 1, '', ''),
(4972, '1289788887', '安徽发改委', 'http://www.ahpc.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 2, '', ''),
(4973, '1289788887', '安徽省工商局', 'http://www.ahaic.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 3, '', ''),
(4974, '1289788887', '安徽省公安厅', 'http://www.ahga.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 4, '', ''),
(4975, '1289788887', '安徽省卫生厅', 'http://www.ahwst.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 5, '', ''),
(4976, '1289788887', '合肥市', 'http://www.hefei.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 6, '', ''),
(4977, '1289788887', '六安市', 'http://www.luan.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 7, '', ''),
(4978, '1289788887', '蚌埠市', 'http://www.bengbu.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 8, '', ''),
(4979, '1289788887', '芜湖市', 'http://www.wuhu.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 9, '', ''),
(4980, '1289788887', '马鞍山', 'http://www.mas.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 10, '', ''),
(4981, '1289788887', '铜陵市', 'http://www.tl.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 11, '', ''),
(4982, '1289788887', '黄山市', 'http://www.huangshan.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 12, '', ''),
(4983, '1289788887', '滁州市', 'http://www.chuzhou.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 13, '', ''),
(4984, '1289788887', '安庆市', 'http://www.anqing.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 14, '', ''),
(4985, '1289788887', '宣城市', 'http://www.xuancheng.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 15, '', ''),
(4986, '1289788887', '淮南市', 'http://www.huainan.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 16, '', ''),
(4987, '1289788887', '巢湖市', 'http://www.chaohu.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 17, '', ''),
(4988, '1289788887', '阜阳市', 'http://www.fy.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 18, '', ''),
(4989, '1289788887', '池州市', 'http://www.chizhou.gov.cn/', 0, 0, 0, 4126, 0, 1, 0, NULL, 19, '', ''),
(4990, '1289788903', '中国电信', 'http://www.chinatelecom.com.cn/', 0, 0, 0, 4384, 0, 1, 0, NULL, 1, '', ''),
(4991, '1289788903', '中国移动', 'http://www.chinamobile.com/', 0, 0, 0, 4384, 0, 1, 0, NULL, 2, '', ''),
(4992, '1289788903', '中国联通', 'http://www.chinaunicom.com', 0, 0, 0, 4384, 0, 1, 0, NULL, 3, '', ''),
(4993, '1289788903', '中国铁通', 'http://www.chinatietong.com/', 0, 0, 0, 4384, 0, 1, 0, NULL, 4, '', ''),
(4994, '1279617741', '百度法律搜索', 'http://law.baidu.com/', 0, 0, 0, 3056, 0, 1, 0, NULL, 1, '', ''),
(4995, '1279617741', '法律之星-法规查询', 'http://www.law-star.com/html/lawsearch.htm', 0, 0, 0, 3056, 0, 1, 0, NULL, 2, '', ''),
(4996, '1279617741', '劳动合同法', 'http://www.xinhuanet.com/legal/ldhtf/', 0, 0, 0, 3056, 0, 1, 0, NULL, 3, '', ''),
(4997, '1279617741', '中国政府网法律法规', 'http://www.gov.cn/flfg/index.htm', 0, 0, 0, 3056, 0, 1, 0, NULL, 4, '', ''),
(4998, '1279617741', '中国普法网', 'http://www.legalinfo.gov.cn/', 0, 0, 0, 3057, 0, 1, 0, NULL, 1, '', ''),
(4999, '1279617741', '法制网', 'http://www.legaldaily.com.cn/', 0, 0, 0, 3057, 0, 1, 0, NULL, 2, '', ''),
(5000, '1279617741', '正义网', 'http://www.jcrb.com/', 0, 0, 0, 3057, 0, 1, 0, NULL, 3, '', ''),
(5001, '1279617741', '中国法院网', 'http://www.chinacourt.org/', 0, 0, 0, 3057, 0, 1, 0, NULL, 4, '', ''),
(5002, '1279617741', '找法网', 'http://china.findlaw.cn/', 0, 0, 0, 3057, 0, 1, 0, NULL, 5, '', ''),
(5003, '1279617741', '劳动合同法网', 'http://www.ldht.org/', 0, 0, 0, 3057, 0, 1, 0, NULL, 6, '', ''),
(5004, '1279617741', '法律博客', 'http://www.fyfz.cn/', 0, 0, 0, 3057, 0, 1, 0, NULL, 7, '', ''),
(5005, '1279617741', '法律图书馆', 'http://www.law-lib.com/', 0, 0, 0, 3057, 0, 1, 0, NULL, 8, '', ''),
(5006, '1279617741', '中国法律信息网', 'http://www.law-star.com/', 0, 0, 0, 3057, 0, 1, 0, NULL, 9, '', ''),
(5007, '1279617741', '中顾网', 'http://www.9ask.cn/', 0, 0, 0, 3057, 0, 1, 0, NULL, 10, '', ''),
(5008, '1279617741', '东方法眼', 'http://www.dffy.com/', 0, 0, 0, 3057, 0, 1, 0, NULL, 11, '', ''),
(5009, '1279617741', '新华网-法治频道', 'http://www.xinhuanet.com/legal/', 0, 0, 0, 3057, 0, 1, 0, NULL, 12, '', ''),
(5010, '1279617741', '新浪-法治新闻', 'http://news.sina.com.cn/law/', 0, 0, 0, 3057, 0, 1, 0, NULL, 13, '', ''),
(5011, '1279617741', '国务院法制办公室', 'http://www.chinalaw.gov.cn/', 0, 0, 0, 3057, 0, 1, 0, NULL, 14, '', ''),
(5012, '1279617741', 'CNTV-法治频道', 'http://law.cctv.com/01/index.shtml', 0, 0, 0, 3057, 0, 1, 0, NULL, 15, '', ''),
(5013, '1279617741', '中国法律大全', 'http://www.jincao.com/t1.htm', 0, 0, 0, 3057, 0, 1, 0, NULL, 16, '', ''),
(5014, '1279617741', '法治论坛', 'http://bbs.chinacourt.org/', 0, 0, 0, 3057, 0, 1, 0, NULL, 17, '', ''),
(5015, '1279617741', '天涯法律论坛', 'http://cache.tianya.cn/publicforum/ArticlesList/0/law.shtml', 0, 0, 0, 3057, 0, 1, 0, NULL, 18, '', ''),
(5016, '1279617741', '律师365', 'http://www.64365.com/', 0, 0, 0, 3057, 0, 1, 0, NULL, 19, '', ''),
(5017, '1279617741', '北大法律信息网', 'http://www.chinalawinfo.com/', 0, 0, 0, 3057, 0, 1, 0, NULL, 20, '', ''),
(5018, '1279617741', '最高人民法院', 'http://www.court.gov.cn/', 0, 0, 0, 3057, 0, 1, 0, NULL, 21, '', ''),
(5019, '1279617741', '最高人民检察院', 'http://www.spp.gov.cn/', 0, 0, 0, 3057, 0, 1, 0, NULL, 22, '', ''),
(5020, '1279617741', '中国民商法律网', 'http://www.civillaw.com.cn/', 0, 0, 0, 3057, 0, 1, 0, NULL, 23, '', ''),
(5021, '1279617741', '北大法宝', 'http://vip.chinalawinfo.com/', 0, 0, 0, 3057, 0, 1, 0, NULL, 24, '', ''),
(5022, '1279617741', '葵花法律论坛', 'http://www.mykh.net/bbs/', 0, 0, 0, 3057, 0, 1, 0, NULL, 25, '', ''),
(5023, '1279617741', '学法网论坛', 'http://bbs.xuefa.com/', 0, 0, 0, 3057, 0, 1, 0, NULL, 26, '', ''),
(5024, '1279617741', '法律在线服务网', 'http://www.on118.com/', 0, 0, 0, 3058, 0, 1, 0, NULL, 1, '', ''),
(5025, '1279617741', '中国法律援助网', 'http://www.falvyuanzhu.cn/', 0, 0, 0, 3058, 0, 1, 0, NULL, 2, '', ''),
(5026, '1279617741', '中国青少年维权中心', 'http://www.chinachild.org/', 0, 0, 0, 3058, 0, 1, 0, NULL, 3, '', ''),
(5027, '1279617741', '中国律师网', 'http://www.chineselawyer.com.cn/', 0, 0, 0, 3058, 0, 1, 0, NULL, 4, '', ''),
(5028, '1279617741', '中国法律顾问网', 'http://www.goodlawyer.com.cn/', 0, 0, 0, 3058, 0, 1, 0, NULL, 5, '', ''),
(5029, '1279617741', '中国法网', 'http://www.cnlaw.net/', 0, 0, 0, 3058, 0, 1, 0, NULL, 6, '', ''),
(5030, '1279617741', '中国离婚网', 'http://www.lhabc.com/', 0, 0, 0, 3058, 0, 1, 0, NULL, 7, '', ''),
(5031, '1279617741', '维权365', 'http://www.weiquan365.com/', 0, 0, 0, 3058, 0, 1, 0, NULL, 8, '', ''),
(5032, '1279617741', '中国农民工维权网', 'http://www.zgnmg.org/', 0, 0, 0, 3058, 0, 1, 0, NULL, 9, '', ''),
(5033, '1279617741', '中国刑事辩护网', 'http://www.chnlawyer.net/', 0, 0, 0, 3058, 0, 1, 0, NULL, 10, '', ''),
(5034, '1279617741', '律师在线', 'http://www.lawyers.net.cn/', 0, 0, 0, 3058, 0, 1, 0, NULL, 11, '', ''),
(5035, '1279617741', '法律快车', 'http://www.lawtime.cn/', 0, 0, 0, 3058, 0, 1, 0, NULL, 12, '', ''),
(5036, '1279617741', '148在线律师', 'http://www.148-law.com/', 0, 0, 0, 3058, 0, 1, 0, NULL, 13, '', ''),
(5037, '1279617741', '中法网', 'http://www.edu1488.com/', 0, 0, 0, 3059, 0, 1, 0, NULL, 1, '', ''),
(5038, '1279617741', '中国普法网-司法考试', 'http://www.legalinfo.gov.cn/sfks/node_101.htm', 0, 0, 0, 3059, 0, 1, 0, NULL, 2, '', ''),
(5039, '1279617741', '搜狐-司法考试', 'http://learning.sohu.com/s2005/sifakaoshi.shtml', 0, 0, 0, 3059, 0, 1, 0, NULL, 3, '', ''),
(5040, '1279617741', '国家司法考试资料库', 'http://www.law-lib.com/sk/', 0, 0, 0, 3059, 0, 1, 0, NULL, 4, '', ''),
(5041, '1279617741', '学法网', 'http://bbs.xuefa.com/', 0, 0, 0, 3059, 0, 1, 0, NULL, 5, '', ''),
(5042, '1279617741', '法律教育网', 'http://www.chinalawedu.com/', 0, 0, 0, 3059, 0, 1, 0, NULL, 6, '', ''),
(5043, '1279617741', '国家司法考试培训网', 'http://www.cnsikao.com/', 0, 0, 0, 3059, 0, 1, 0, NULL, 7, '', ''),
(5044, '1279617741', '新浪-国家司法考试', 'http://edu.sina.com.cn/lawyer/', 0, 0, 0, 3059, 0, 1, 0, NULL, 8, '', ''),
(5045, '1279617741', '法法网', 'http://www.fafawang.com/', 0, 0, 0, 3059, 0, 1, 0, NULL, 9, '', ''),
(5046, '1279617741', '万国司法考试', 'http://www.wanguoschool.net/', 0, 0, 0, 3059, 0, 1, 0, NULL, 10, '', ''),
(5047, '1289788987', '钱龙股票软件', 'http://www.qianlong.com.cn/soft/', 0, 0, 0, 4385, 0, 1, 0, NULL, 1, '', ''),
(5048, '1289788987', '大智慧股票软件', 'http://www.gw.com.cn/download/level2/index.html', 0, 0, 0, 4385, 0, 1, 0, NULL, 2, '', ''),
(5049, '1289788987', '同花顺股票软件', 'http://www.10jqka.com.cn/download/', 0, 0, 0, 4385, 0, 1, 0, NULL, 3, '', ''),
(5050, '1289788987', '天空－股票软件下载', 'http://www.skycn.com/sort/sort2070100_indate_DESC_1.html', 0, 0, 0, 4385, 0, 1, 0, NULL, 4, '', ''),
(5051, '1289788987', '中国证券报', 'http://www.cs.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 5, '', ''),
(5052, '1289788987', '上海证券报', 'http://www.cnstock.com/paper_new', 0, 0, 0, 4385, 0, 1, 0, NULL, 6, '', ''),
(5053, '1289788987', '证券时报', 'http://www.secutimes.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 7, '', ''),
(5054, '1289788987', '华尔街日报', 'http://chinese.wsj.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 8, '', ''),
(5055, '1289788987', '中国财经报', 'http://www.cfen.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 9, '', ''),
(5056, '1289788987', '《财经网》', 'http://www.caijing.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 10, '', ''),
(5057, '1289788987', '每日经济新闻', 'http://www.nbd.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 11, '', ''),
(5058, '1289788987', '21世纪经济报道', 'http://www.21cbh.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 12, '', ''),
(5059, '1289788987', '中国经营报', 'http://www.cb.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 13, '', ''),
(5060, '1289788987', '上海金融报', 'http://www.shfinancialnews.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 14, '', ''),
(5061, '1289788987', '证券导报', 'http://zqdb.hinews.cn/php', 0, 0, 0, 4385, 0, 1, 0, NULL, 15, '', ''),
(5062, '1289788987', '福布斯', 'http://www.forbeschina.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 16, '', ''),
(5063, '1289788987', '证券市场周刊', 'http://www.zhoukan.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 17, '', ''),
(5064, '1289788987', '期货日报', 'http://www.qhdb.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 18, '', ''),
(5065, '1289788987', '经济观察报', 'http://www.eeo.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 19, '', ''),
(5066, '1289788987', '香港商报', 'http://www.hkcd.com.hk', 0, 0, 0, 4385, 0, 1, 0, NULL, 20, '', ''),
(5067, '1289788987', '新财富', 'http://www.newfortune.net.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 21, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(5068, '1289788987', '国际财经时报', 'http://china.ibtimes.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 22, '', ''),
(5069, '1289788987', '国泰君安', 'http://www.gtja.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 23, '', ''),
(5070, '1289788987', '安信证券', 'http://www.essences.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 24, '', ''),
(5071, '1289788987', '广东证券网', 'http://www.99b2b.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 25, '', ''),
(5072, '1289788987', '广发证券', 'http://www.gf.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 26, '', ''),
(5073, '1289788987', '西部证券', 'http://www.westsecu.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 27, '', ''),
(5074, '1289788987', '招商证券', 'http://www.newone.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 28, '', ''),
(5075, '1289788987', '银河证券', 'http://www.chinastock.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 29, '', ''),
(5076, '1289788987', '华泰证券', 'http://www.htsc.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 30, '', ''),
(5077, '1289788987', '申银万国', 'http://www.sw2000.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 31, '', ''),
(5078, '1289788987', '海通证券', 'http://www.htsec.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 32, '', ''),
(5079, '1289788987', '中信证券', 'http://www.cs.ecitic.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 33, '', ''),
(5080, '1289788987', '国信证券', 'http://www.guosen.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 34, '', ''),
(5081, '1289788987', '光大证券', 'http://www.ebscn.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 35, '', ''),
(5082, '1289788987', '华安证券', 'http://www.huaans.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 36, '', ''),
(5083, '1289788987', '国海证券', 'http://www.ghzq.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 37, '', ''),
(5084, '1289788987', '长江证券', 'http://www.95579.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 38, '', ''),
(5085, '1289788987', '中银国际', 'http://www.bocichina.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 39, '', ''),
(5086, '1289788987', '国都证券', 'http://www.guodu.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 40, '', ''),
(5087, '1289788987', '山西证券', 'http://www.i618.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 41, '', ''),
(5088, '1289788987', '华西证券', 'http://www.hx168.com.cn/hxzq/index.jsp', 0, 0, 0, 4385, 0, 1, 0, NULL, 42, '', ''),
(5089, '1289788987', '中投证券', 'http://www.cjis.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 43, '', ''),
(5090, '1289788987', '兴业证券', 'http://www.xyzq.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 44, '', ''),
(5091, '1289788987', '东北证券', 'http://www.nesc.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 45, '', ''),
(5092, '1289788987', '东兴证券', 'http://www.dxzq.net', 0, 0, 0, 4385, 0, 1, 0, NULL, 46, '', ''),
(5093, '1289788987', '国元证券', 'http://www.gyzq.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 47, '', ''),
(5094, '1289788987', '联合证券', 'http://www.lhzq.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 48, '', ''),
(5095, '1289788987', '宏源证券', 'http://www.ehongyuan.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 49, '', ''),
(5096, '1289788987', '东吴证券', 'http://www.dwjq.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 50, '', ''),
(5097, '1289788987', '浙商证券', 'http://www.stocke.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 51, '', ''),
(5098, '1289788987', '南京证券', 'http://www.njzq.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 52, '', ''),
(5099, '1289788987', '上海证券', 'http://www.962518.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 53, '', ''),
(5100, '1289788987', '方正证券', 'http://www.foundersc.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 54, '', ''),
(5101, '1289788987', '国盛证券', 'http://www.gsstock.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 55, '', ''),
(5102, '1289788987', '东海证券', 'http://www.longone.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 56, '', ''),
(5103, '1289788987', '东莞证券', 'http://www.dgzq.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 57, '', ''),
(5104, '1289788987', '长财证券', 'http://cczq.net/cczq', 0, 0, 0, 4385, 0, 1, 0, NULL, 58, '', ''),
(5105, '1289788987', '国联证券', 'http://www.glsc.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 59, '', ''),
(5106, '1289788987', '财富证券', 'http://www.cfzq.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 60, '', ''),
(5107, '1289788987', '西南证券', 'http://www.swsc.com.cn/portal/homepage.jsp', 0, 0, 0, 4385, 0, 1, 0, NULL, 61, '', ''),
(5108, '1289788987', '财达证券', 'http://www.s10000.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 62, '', ''),
(5109, '1289788987', '齐鲁证券', 'http://www.qlzq.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 63, '', ''),
(5110, '1289788987', '万联证券', 'http://www.wlzq.com.cn/wlzq/index.html', 0, 0, 0, 4385, 0, 1, 0, NULL, 64, '', ''),
(5111, '1289788987', '江南证券', 'http://www.scstock.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 65, '', ''),
(5112, '1289788987', '中信建投', 'http://www.csc108.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 66, '', ''),
(5113, '1289788987', '华夏基金', 'http://www.chinaamc.com/portal/cn/index.html', 0, 0, 0, 4385, 0, 1, 0, NULL, 67, '', ''),
(5114, '1289788987', '南方基金', 'http://www.southernfund.com/nanfang', 0, 0, 0, 4385, 0, 1, 0, NULL, 68, '', ''),
(5115, '1289788987', '嘉实基金', 'http://www.jsfund.cn/jswz/index.html', 0, 0, 0, 4385, 0, 1, 0, NULL, 69, '', ''),
(5116, '1289788987', '广发基金', 'http://www.gffunds.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 70, '', ''),
(5117, '1289788987', '大成基金', 'http://www.dcfund.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 71, '', ''),
(5118, '1289788987', '易方达基金', 'http://www.efunds.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 72, '', ''),
(5119, '1289788987', '博时基金', 'http://www.bosera.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 73, '', ''),
(5120, '1289788987', '海富通基金', 'http://www.hftfund.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 74, '', ''),
(5121, '1289788987', '银华基金', 'http://www.yhfund.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 75, '', ''),
(5122, '1289788987', '富国基金', 'http://www.fullgoal.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 76, '', ''),
(5123, '1289788987', '长盛基金', 'http://www.csfunds.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 77, '', ''),
(5124, '1289788987', '交银施罗德', 'http://www.jysld.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 78, '', ''),
(5125, '1289788987', '中邮基金', 'http://www.postfund.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 79, '', ''),
(5126, '1289788987', '宝盈基金', 'http://www.byfunds.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 80, '', ''),
(5127, '1289788987', '上投摩根基金', 'http://www.51fund.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 81, '', ''),
(5128, '1289788987', '融通基金', 'http://www.rtfund.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 82, '', ''),
(5129, '1289788987', '华安基金', 'http://www.huaan.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 83, '', ''),
(5130, '1289788987', '长城基金', 'http://www.ccfund.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 84, '', ''),
(5131, '1289788987', '中欧基金', 'http://www.lcfunds.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 85, '', ''),
(5132, '1289788987', '华宝兴业', 'http://www.fsfund.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 86, '', ''),
(5133, '1289788987', '汇添富基金', 'http://www.htffund.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 87, '', ''),
(5134, '1289788987', '建信基金', 'http://www.ccbfund.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 88, '', ''),
(5135, '1289788987', '信诚基金', 'http://www.citicprufunds.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 89, '', ''),
(5136, '1289788987', '工银瑞信基金', 'http://www.icbccs.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 90, '', ''),
(5137, '1289788987', '国泰基金', 'http://www.gtfund.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 91, '', ''),
(5138, '1289788987', '华商基金', 'http://www.hsfund.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 92, '', ''),
(5139, '1289788987', '诺德基金', 'http://www.lordabbettchina.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 93, '', ''),
(5140, '1289788987', '诺安基金', 'http://www.lionfund.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 94, '', ''),
(5141, '1289788987', '中银国际基金', 'http://www.bociim.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 95, '', ''),
(5142, '1289788987', '景顺基金', 'http://www.invescogreatwall.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 96, '', ''),
(5143, '1289788987', '光大宝德基金', 'http://www.epf.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 97, '', ''),
(5144, '1289788987', '泰信基金', 'http://www.ftfund.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 98, '', ''),
(5145, '1289788987', '兴业基金', 'http://www.xyfunds.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 99, '', ''),
(5146, '1289788987', '中信基金', 'http://www.citicfunds.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 100, '', ''),
(5147, '1289788987', '长信基金', 'http://www.cxfund.com.cn', 0, 0, 0, 4385, 0, 1, 0, NULL, 101, '', ''),
(5148, '1289788987', '招商基金', 'http://www.cmfchina.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 102, '', ''),
(5149, '1289788987', '泰达荷银基金', 'http://www.aateda.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 103, '', ''),
(5150, '1289788987', '友邦华泰', 'http://www.aig-huatai.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 104, '', ''),
(5151, '1289788987', '中海基金', 'http://www.zhfund.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 105, '', ''),
(5152, '1289788987', '华富基金', 'http://www.hffund.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 106, '', ''),
(5153, '1289788987', '益民基金', 'http://www.ymfund.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 107, '', ''),
(5154, '1289788987', '万家基金', 'http://www.wjasset.com', 0, 0, 0, 4385, 0, 1, 0, NULL, 108, '', ''),
(5155, '1289788987', '中国农业银行代销基金', 'http://www.95599.cn/jijin/Fund/Fund_Index.aspx', 0, 0, 0, 4385, 0, 1, 0, NULL, 109, '', ''),
(5156, '1289788987', '邮政储蓄代销基金', 'http://www.psbc.com/portal/zh_CN/Fund/index.html', 0, 0, 0, 4385, 0, 1, 0, NULL, 110, '', ''),
(5157, '1289788987', '招商银行代销基金', 'http://info.cmbchina.com/fund', 0, 0, 0, 4385, 0, 1, 0, NULL, 111, '', ''),
(5158, '1289788987', '中国工商银行代销基金', 'http://www.icbc.com.cn/icbc/%E7%BD%91%E4%B8%8A%E5%9F%BA%E9%87%91/', 0, 0, 0, 4385, 0, 1, 0, NULL, 112, '', ''),
(5161, '1289788993', '福建热线', 'http://www.fjii.com/', 0, 0, 0, 4131, 0, 1, 0, NULL, 1, '', ''),
(5162, '1289788993', '海都资讯网', 'http://www.hdzxw.com/', 0, 0, 0, 4131, 0, 1, 0, NULL, 2, '', ''),
(5163, '1289788993', '东南网', 'http://www.fjsen.com/', 0, 0, 0, 4131, 0, 1, 0, NULL, 3, '', ''),
(5164, '1289788993', '福建电视台', 'http://www.fjtv.net/', 0, 0, 0, 4131, 0, 1, 0, NULL, 4, '', ''),
(5165, '1289788993', '福建省政府', 'http://www.fujian.gov.cn/', 0, 0, 0, 4131, 0, 1, 0, NULL, 5, '', ''),
(5166, '1289788993', '台海网', 'http://www.taihainet.com/', 0, 0, 0, 4131, 0, 1, 0, NULL, 6, '', ''),
(5167, '1289788993', '闽东信息港', 'http://www.nd168.com/', 0, 0, 0, 4131, 0, 1, 0, NULL, 7, '', ''),
(5168, '1289788993', '福州新闻网', 'http://www.fznews.com.cn/', 0, 0, 0, 4131, 0, 1, 0, NULL, 8, '', ''),
(5169, '1289788993', '龙岩热线', 'http://www.ly.fj.cn/main.asp', 0, 0, 0, 4131, 0, 1, 0, NULL, 9, '', ''),
(5170, '1289788993', '厦门网', 'http://www.xmnn.cn/', 0, 0, 0, 4131, 0, 1, 0, NULL, 10, '', ''),
(5171, '1289788993', '福建新闻网', 'http://www.fjcns.com/', 0, 0, 0, 4131, 0, 1, 0, NULL, 11, '', ''),
(5172, '1289788993', '福建之窗', 'http://www.66163.com/', 0, 0, 0, 4131, 0, 1, 0, NULL, 12, '', ''),
(5173, '1289788993', '泉州网', 'http://www.qzwb.com/', 0, 0, 0, 4131, 0, 1, 0, NULL, 13, '', ''),
(5174, '1289788993', '八达信息港', 'http://chinabada.fj.vnet.cn/', 0, 0, 0, 4131, 0, 1, 0, NULL, 14, '', ''),
(5175, '1289788993', '福建电台都市生活频道', 'http://www.fm987.com.cn/', 0, 0, 0, 4131, 0, 1, 0, NULL, 15, '', ''),
(5176, '1289788993', '福州便民网', 'http://www.fzbm.com', 0, 0, 0, 4131, 0, 1, 0, NULL, 16, '', ''),
(5177, '1289788993', '东南快报', 'http://www.dnkb.com.cn/', 0, 0, 0, 4131, 0, 1, 0, NULL, 17, '', ''),
(5178, '1289788993', '泉州晚报', 'http://www.qzwb.com/', 0, 0, 0, 4131, 0, 1, 0, NULL, 18, '', ''),
(5179, '1289788993', '海峡都市报', 'http://www.hdzxw.com/', 0, 0, 0, 4131, 0, 1, 0, NULL, 19, '', ''),
(5180, '1289789017', '股吧', 'http://guba.eastmoney.com/', 0, 0, 0, 4386, 0, 1, 0, NULL, 1, '', ''),
(5181, '1289789017', '金融界股吧', 'http://istock.jrj.com.cn/', 0, 0, 0, 4386, 0, 1, 0, NULL, 2, '', ''),
(5182, '1289789017', '金融界股票论坛', 'http://bbs.jrj.com.cn/', 0, 0, 0, 4386, 0, 1, 0, NULL, 3, '', ''),
(5183, '1289789017', '老钱庄股票论坛', 'http://www.laoqianzhuang.com/', 0, 0, 0, 4386, 0, 1, 0, NULL, 4, '', ''),
(5184, '1289789017', '搜狐股市论坛', 'http://business.sohu.com/upload/clubnew.htm', 0, 0, 0, 4386, 0, 1, 0, NULL, 5, '', ''),
(5185, '1289789017', 'MACD股市技术论坛', 'http://bbs.macd.cn', 0, 0, 0, 4386, 0, 1, 0, NULL, 6, '', ''),
(5186, '1289789017', '新浪财经论坛', 'http://finance.sina.com.cn/bbs/index.shtml', 0, 0, 0, 4386, 0, 1, 0, NULL, 7, '', ''),
(5187, '1289789017', '中金博客', 'http://blog.cnfol.com/', 0, 0, 0, 4386, 0, 1, 0, NULL, 8, '', ''),
(5188, '1289789017', '和讯股票博客', 'http://blog.hexun.com/class20.htm', 0, 0, 0, 4386, 0, 1, 0, NULL, 9, '', ''),
(5189, '1289789017', '中国证券网博客', 'http://blog.cnstock.com/', 0, 0, 0, 4386, 0, 1, 0, NULL, 10, '', ''),
(5190, '1289789017', '新浪财经博客', 'http://club.finance.sina.com.cn/', 0, 0, 0, 4386, 0, 1, 0, NULL, 11, '', ''),
(5191, '1289789017', '东方财富财经博客', 'http://blog.eastmoney.com/', 0, 0, 0, 4386, 0, 1, 0, NULL, 12, '', ''),
(5192, '1289789017', '搜狐财经博客', 'http://blog.sohu.com/business/', 0, 0, 0, 4386, 0, 1, 0, NULL, 13, '', ''),
(5193, '1289789017', '股票吧论坛', 'http://bbs.gupiao8.com/', 0, 0, 0, 4386, 0, 1, 0, NULL, 14, '', ''),
(5194, '1289789017', '理想论坛', 'http://www.55188.com/', 0, 0, 0, 4386, 0, 1, 0, NULL, 15, '', ''),
(5195, '1289789026', '东南新闻网', 'http://www.fjsen.com/', 0, 0, 0, 4132, 0, 1, 0, NULL, 1, '', ''),
(5196, '1289789026', '福建新闻网', 'http://www.fjcns.com/', 0, 0, 0, 4132, 0, 1, 0, NULL, 2, '', ''),
(5197, '1289789026', '福建电视台', 'http://www.fjtv.net/', 0, 0, 0, 4132, 0, 1, 0, NULL, 3, '', ''),
(5198, '1289789026', '福州新闻网', 'http://www.fznews.com.cn/', 0, 0, 0, 4132, 0, 1, 0, NULL, 4, '', ''),
(5199, '1289789026', '厦门网', 'http://www.xmnn.cn/', 0, 0, 0, 4132, 0, 1, 0, NULL, 5, '', ''),
(5200, '1289789026', '东南快报', 'http://www.dnkb.com.cn/', 0, 0, 0, 4132, 0, 1, 0, NULL, 6, '', ''),
(5201, '1289789026', '泉州晚报', 'http://www.qzwb.com/', 0, 0, 0, 4132, 0, 1, 0, NULL, 7, '', ''),
(5202, '1289789026', '海峡都市报', 'http://www.nhaidu.com/', 0, 0, 0, 4132, 0, 1, 0, NULL, 8, '', ''),
(5203, '1289789026', '海峡导报', 'http://epaper.taihainet.com/', 0, 0, 0, 4132, 0, 1, 0, NULL, 9, '', ''),
(5204, '1289789040', '新浪财经微博', 'http://finance.t.sina.com.cn/', 0, 0, 0, 4387, 0, 1, 0, NULL, 1, '', ''),
(5205, '1289789040', '东方财富微博', 'http://t.eastmoney.com/', 0, 0, 0, 4387, 0, 1, 0, NULL, 2, '', ''),
(5206, '1289789040', '中金在线微博', 'http://t.cnfol.com/', 0, 0, 0, 4387, 0, 1, 0, NULL, 3, '', ''),
(5207, '1289789040', '和讯财经微博', 'http://t.hexun.com/', 0, 0, 0, 4387, 0, 1, 0, NULL, 4, '', ''),
(5208, '1289789040', '赶牛财经微博', 'http://www.ganniu.com/', 0, 0, 0, 4387, 0, 1, 0, NULL, 5, '', ''),
(5209, '1289789045', '福建电台都市生活频道', 'http://www.fm987.com.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 1, '', ''),
(5210, '1289789045', '新浪福建', 'http://fj.sina.com.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 2, '', ''),
(5211, '1289789045', '福建医疗保险管理中心', 'http://www.fjyb.com.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 3, '', ''),
(5212, '1289789045', '福建卫生信息网', 'http://www.fjphb.gov.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 4, '', ''),
(5213, '1289789045', '福建省立医院', 'http://www.fjsl.com.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 5, '', ''),
(5214, '1289789045', '福建第二人民医院', 'http://www.fjhospital.com/', 0, 0, 0, 4133, 0, 1, 0, NULL, 6, '', ''),
(5215, '1289789045', '福建教育厅', 'http://www.fjedu.gov.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 7, '', ''),
(5216, '1289789045', '福建公务员考试网', 'http://www.fjkl.gov.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 8, '', ''),
(5217, '1289789045', '福建自考网', 'http://www.fjzk.com.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 9, '', ''),
(5218, '1289789045', '福建省人事考试网', 'http://www.fjpta.com/', 0, 0, 0, 4133, 0, 1, 0, NULL, 10, '', ''),
(5219, '1289789045', '福建农林大学', 'http://www.fjau.edu.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 11, '', ''),
(5220, '1289789045', '福建师范大学', 'http://www.fjtu.edu.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 12, '', ''),
(5221, '1289789045', '福州便民网', 'http://www.fzbm.com/', 0, 0, 0, 4133, 0, 1, 0, NULL, 13, '', ''),
(5222, '1289789045', '看福清', 'http://www.fqlook.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 14, '', ''),
(5223, '1289789045', '德化网', 'http://www.dehua.net/', 0, 0, 0, 4133, 0, 1, 0, NULL, 15, '', ''),
(5224, '1289789045', '长汀网', 'http://www.ctw.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 16, '', ''),
(5225, '1289789045', '莆田生活网', 'http://www.0594sh.com/', 0, 0, 0, 4133, 0, 1, 0, NULL, 17, '', ''),
(5226, '1289789045', '闽南人在线音乐网', 'http://www.510173.com/', 0, 0, 0, 4133, 0, 1, 0, NULL, 18, '', ''),
(5227, '1289789045', '晋江信息综合网', 'http://www.jjj8.cn/index.asp', 0, 0, 0, 4133, 0, 1, 0, NULL, 19, '', ''),
(5228, '1289789045', '福清网', 'http://www.cnfq.com/', 0, 0, 0, 4133, 0, 1, 0, NULL, 20, '', ''),
(5229, '1289789045', '福州市便民呼叫中心', 'http://12345.fuzhou.gov.cn/', 0, 0, 0, 4133, 0, 1, 0, NULL, 21, '', ''),
(5230, '1289789045', '厦门小鱼社区', 'http://www.xmfish.com/', 0, 0, 0, 4133, 0, 1, 0, NULL, 22, '', ''),
(5231, '1289789045', '福州家园网', 'http://www.ihome99.com/', 0, 0, 0, 4133, 0, 1, 0, NULL, 23, '', ''),
(5232, '1289789045', '福州美食网', 'http://www.78fz.com/', 0, 0, 0, 4133, 0, 1, 0, NULL, 24, '', ''),
(5233, '1289789060', '金融界-股评天地', 'http://invest.jrj.com.cn/invest/', 0, 0, 0, 4388, 0, 1, 0, NULL, 1, '', ''),
(5234, '1289789060', '东方财富网-行情', 'http://quote.eastmoney.com/', 0, 0, 0, 4388, 0, 1, 0, NULL, 2, '', ''),
(5235, '1289789060', '腾讯-财经天下评', 'http://finance.qq.com/tianxiaping/index.htm', 0, 0, 0, 4388, 0, 1, 0, NULL, 3, '', ''),
(5236, '1289789060', '新浪-股市行情', 'http://biz.finance.sina.com.cn/hq/', 0, 0, 0, 4388, 0, 1, 0, NULL, 4, '', ''),
(5237, '1289789060', '和讯评论', 'http://opinion.hexun.com/', 0, 0, 0, 4388, 0, 1, 0, NULL, 5, '', ''),
(5238, '1289789060', '全景网-股评', 'http://www.p5w.net/stock/hydx/', 0, 0, 0, 4388, 0, 1, 0, NULL, 6, '', ''),
(5239, '1289789060', '证券之星-行情', 'http://quote.stockstar.com/stock/', 0, 0, 0, 4388, 0, 1, 0, NULL, 7, '', ''),
(5240, '1289789088', '东方财富网', 'http://www.eastmoney.com/', 0, 0, 0, 4389, 0, 1, 0, NULL, 1, '', ''),
(5241, '1289789088', '新浪财经', 'http://finance.sina.com.cn', 0, 0, 0, 4389, 0, 1, 0, NULL, 2, '', ''),
(5242, '1289789088', '搜狐财经', 'http://business.sohu.com/', 0, 0, 0, 4389, 0, 1, 0, NULL, 3, '', ''),
(5243, '1289789088', '中国经济网', 'http://www.ce.cn/', 0, 0, 0, 4389, 0, 1, 0, NULL, 4, '', ''),
(5244, '1289789088', '证券之星', 'http://www.stockstar.com/', 0, 0, 0, 4389, 0, 1, 0, NULL, 5, '', ''),
(5245, '1289789088', '中金在线', 'http://www.cnfol.com', 0, 0, 0, 4389, 0, 1, 0, NULL, 6, '', ''),
(5246, '1289789088', '中国财经信息网', 'http://www.cfi.cn', 0, 0, 0, 4389, 0, 1, 0, NULL, 7, '', ''),
(5247, '1289789088', '百度财经', 'http://finance.baidu.com/', 0, 0, 0, 4389, 0, 1, 0, NULL, 8, '', ''),
(5248, '1289789088', '网易财经', 'http://money.163.com/', 0, 0, 0, 4389, 0, 1, 0, NULL, 9, '', ''),
(5249, '1289789088', '凤凰财经', 'http://finance.ifeng.com/', 0, 0, 0, 4389, 0, 1, 0, NULL, 10, '', ''),
(5250, '1289789088', '新华网财经', 'http://www.xinhuanet.com/fortune/index.htm', 0, 0, 0, 4389, 0, 1, 0, NULL, 11, '', ''),
(5251, '1289789088', '金融界', 'http://www.jrj.com.cn/default.htm', 0, 0, 0, 4389, 0, 1, 0, NULL, 12, '', ''),
(5252, '1289789088', '腾讯财经', 'http://finance.qq.com', 0, 0, 0, 4389, 0, 1, 0, NULL, 13, '', ''),
(5253, '1289789088', '21CN财经', 'http://finance.21cn.com/', 0, 0, 0, 4389, 0, 1, 0, NULL, 14, '', ''),
(5254, '1289789088', '财经网', 'http://www.caijing.com.cn', 0, 0, 0, 4389, 0, 1, 0, NULL, 15, '', ''),
(5255, '1289789088', '和讯财经', 'http://www.hexun.com/', 0, 0, 0, 4389, 0, 1, 0, NULL, 16, '', ''),
(5256, '1289789088', '中国财经网', 'http://www.fec.com.cn', 0, 0, 0, 4389, 0, 1, 0, NULL, 17, '', ''),
(5257, '1289789088', '股天下', 'http://www.gutx.com/', 0, 0, 0, 4389, 0, 1, 0, NULL, 18, '', ''),
(5258, '1289789088', '股城网', 'http://www.stockcity.cn/', 0, 0, 0, 4389, 0, 1, 0, NULL, 19, '', ''),
(5259, '1289789088', 'FT中文网', 'http://www.ftchinese.com/', 0, 0, 0, 4389, 0, 1, 0, NULL, 20, '', ''),
(5260, '1289789088', '福建教育厅', 'http://www.fjedu.gov.cn/', 0, 0, 0, 4134, 0, 1, 0, NULL, 1, '', ''),
(5261, '1289789088', '福建公务员考试网', 'http://www.fjkl.gov.cn/', 0, 0, 0, 4134, 0, 1, 0, NULL, 2, '', ''),
(5262, '1289789088', '福建自考网', 'http://www.fjzk.com.cn/', 0, 0, 0, 4134, 0, 1, 0, NULL, 3, '', ''),
(5263, '1289789088', '福建省人事考试网', 'http://www.fjpta.com/', 0, 0, 0, 4134, 0, 1, 0, NULL, 4, '', ''),
(5264, '1289789088', '厦门大学', 'http://www.xmu.edu.cn/', 0, 0, 0, 4134, 0, 1, 0, NULL, 5, '', ''),
(5265, '1289789088', '福建农林大学', 'http://www.fjau.edu.cn/', 0, 0, 0, 4134, 0, 1, 0, NULL, 6, '', ''),
(5266, '1289789088', '福州大学', 'http://www.fzu.edu.cn/', 0, 0, 0, 4134, 0, 1, 0, NULL, 7, '', ''),
(5267, '1289789088', '福建师范大学', 'http://www.fjtu.edu.cn/', 0, 0, 0, 4134, 0, 1, 0, NULL, 8, '', ''),
(5268, '1289789088', '福建医科大学', 'http://www.fjmu.edu.cn/', 0, 0, 0, 4134, 0, 1, 0, NULL, 9, '', ''),
(5269, '1289789088', '集美大学', 'http://www.jmu.edu.cn/', 0, 0, 0, 4134, 0, 1, 0, NULL, 10, '', ''),
(5270, '1289789110', '厦门小鱼社区', 'http://www.xmfish.com/', 0, 0, 0, 4135, 0, 1, 0, NULL, 1, '', ''),
(5271, '1289789110', '福州家园网', 'http://www.ihome99.com/', 0, 0, 0, 4135, 0, 1, 0, NULL, 2, '', ''),
(5272, '1289789110', '福建论坛', 'http://bbs.66163.com/', 0, 0, 0, 4135, 0, 1, 0, NULL, 3, '', ''),
(5273, '1289789110', '闽北互动论坛', 'http://bbs.np163.net/', 0, 0, 0, 4135, 0, 1, 0, NULL, 4, '', ''),
(5274, '1289789110', '福州便民论坛', 'http://bbs.fzbm.com/', 0, 0, 0, 4135, 0, 1, 0, NULL, 5, '', ''),
(5275, '1289789110', '厦门贴吧', 'http://tieba.baidu.com/f?kw=厦门贴吧', 0, 0, 0, 4135, 0, 1, 1300674020, NULL, 6, '', ''),
(5276, '1289789110', '福州贴吧', 'http://tieba.baidu.com/f?kw=福州贴吧', 0, 0, 0, 4135, 0, 1, 1300674040, NULL, 7, '', ''),
(5277, '1289789110', '龙岩论坛', 'http://www.0597kk.com/', 0, 0, 0, 4135, 0, 1, 0, NULL, 8, '', ''),
(5278, '1289789110', '百度知道-福建', 'http://zhidao.baidu.com/browse/253', 0, 0, 0, 4135, 0, 1, 0, NULL, 9, '', ''),
(5279, '1289789110', '长乐论坛', 'http://www.changle.com.cn/', 0, 0, 0, 4135, 0, 1, 0, NULL, 10, '', ''),
(5280, '1289789110', '厦门小猪社区', 'http://www.xmpig.com', 0, 0, 0, 4135, 0, 1, 0, NULL, 11, '', ''),
(5281, '1289789110', '厦门e部落', 'http://www.ecl.com.cn/', 0, 0, 0, 4135, 0, 1, 0, NULL, 12, '', ''),
(5282, '1289789110', '泉州论坛', 'http://bbs.0595bbs.cn/', 0, 0, 0, 4135, 0, 1, 0, NULL, 13, '', ''),
(5283, '1289789110', '泉州缘如水论坛', 'http://www.qzbbs.com/', 0, 0, 0, 4135, 0, 1, 0, NULL, 14, '', ''),
(5284, '1289789110', '永安论坛', 'http://bbs.yawin.cn/', 0, 0, 0, 4135, 0, 1, 0, NULL, 15, '', ''),
(5285, '1289789110', '莆田小鱼社区', 'http://ptfish.com/', 0, 0, 0, 4135, 0, 1, 0, NULL, 16, '', ''),
(5286, '1289789135', '福建省政府', 'http://www.fujian.gov.cn/', 0, 0, 0, 4136, 0, 1, 0, NULL, 1, '', ''),
(5287, '1289789135', '发改委', 'http://www.fjdpc.gov.cn/', 0, 0, 0, 4136, 0, 1, 0, NULL, 2, '', ''),
(5288, '1289789135', '工商局', 'http://www.fjaic.gov.cn/', 0, 0, 0, 4136, 0, 1, 0, NULL, 3, '', ''),
(5289, '1289789135', '厦门', 'http://www.xm.gov.cn/', 0, 0, 0, 4136, 0, 1, 0, NULL, 4, '', ''),
(5290, '1289789135', '龙岩', 'http://www.longyan.gov.cn/', 0, 0, 0, 4136, 0, 1, 0, NULL, 5, '', ''),
(5291, '1289789135', '莆田', 'http://www.putian.gov.cn/', 0, 0, 0, 4136, 0, 1, 0, NULL, 6, '', ''),
(5292, '1289789135', '厦门市国家税务局', 'http://www.xm-n-tax.gov.cn/', 0, 0, 0, 4136, 0, 1, 0, NULL, 7, '', ''),
(5293, '1289789135', '福建省台办', 'http://www.fjstb.gov.cn/', 0, 0, 0, 4136, 0, 1, 0, NULL, 8, '', ''),
(5294, '1289789135', '物价局', 'http://www.fjjg.gov.cn/', 0, 0, 0, 4136, 0, 1, 0, NULL, 9, '', ''),
(5295, '1289789135', '海洋渔业局', 'http://www.fjof.gov.cn/', 0, 0, 0, 4136, 0, 1, 0, NULL, 10, '', ''),
(5296, '1289789135', '地税局', 'http://www.fj-l-tax.gov.cn/', 0, 0, 0, 4136, 0, 1, 0, NULL, 11, '', ''),
(5297, '1289789140', '第一营销网', 'http://www.cmmo.com.cn/', 0, 0, 0, 4390, 0, 1, 0, NULL, 1, '', ''),
(5298, '1289789140', '中国营销传播网', 'http://www.emkt.com.cn/', 0, 0, 0, 4390, 0, 1, 0, NULL, 2, '', ''),
(5299, '1289789140', '网络营销手册', 'http://www.tomx.com/', 0, 0, 0, 4390, 0, 1, 0, NULL, 3, '', ''),
(5300, '1289789140', '新竞争力', 'http://www.jingzhengli.cn/', 0, 0, 0, 4390, 0, 1, 0, NULL, 4, '', ''),
(5301, '1289789140', '网上营销新观察', 'http://www.marketingman.net/', 0, 0, 0, 4390, 0, 1, 0, NULL, 5, '', ''),
(5302, '1289789140', '阿里巴巴商业资讯', 'http://info.china.alibaba.com/news/community/c14.html', 0, 0, 0, 4390, 0, 1, 0, NULL, 6, '', ''),
(5303, '1289789140', '致信网', 'http://www.mie168.com/', 0, 0, 0, 4390, 0, 1, 0, NULL, 7, '', ''),
(5304, '1289789140', '市场部网', 'http://www.shichangbu.com/', 0, 0, 0, 4390, 0, 1, 0, NULL, 8, '', ''),
(5305, '1289789159', '中国广告人网站', 'http://www.chinaadren.com', 0, 0, 0, 4391, 0, 1, 0, NULL, 1, '', ''),
(5306, '1289789159', '中国广告媒体网', 'http://www.ad163.com', 0, 0, 0, 4391, 0, 1, 0, NULL, 2, '', ''),
(5307, '1289789159', '中华传媒网', 'http://www.mediachina.net', 0, 0, 0, 4391, 0, 1, 0, NULL, 3, '', ''),
(5308, '1289789159', '中国广告网', 'http://www.cnad.com/', 0, 0, 0, 4391, 0, 1, 0, NULL, 4, '', ''),
(5309, '1289789159', '中华广告网', 'http://www.a.com.cn/', 0, 0, 0, 4391, 0, 1, 0, NULL, 5, '', ''),
(5310, '1289789159', '沃华传媒网', 'http://www.wowa.cn', 0, 0, 0, 4391, 0, 1, 0, NULL, 6, '', ''),
(5311, '1289789159', '创业投资网', 'http://www.28.com', 0, 0, 0, 4391, 0, 1, 0, NULL, 7, '', ''),
(5312, '1289789159', '中国广告门户网', 'http://www.yxad.com/', 0, 0, 0, 4391, 0, 1, 0, NULL, 8, '', ''),
(5313, '1289789159', '人民网传媒频道', 'http://media.people.com.cn/GB/index.html', 0, 0, 0, 4391, 0, 1, 0, NULL, 9, '', ''),
(5314, '1289789159', '广告设计印刷商贸网', 'http://www.adp365.com/', 0, 0, 0, 4391, 0, 1, 0, NULL, 10, '', ''),
(5315, '1289789159', '媒体资源网', 'http://www.allchina.cn', 0, 0, 0, 4391, 0, 1, 0, NULL, 11, '', ''),
(5316, '1289789187', '中国首钢集团', 'http://www.shougang.com.cn', 0, 0, 0, 4392, 0, 1, 0, NULL, 1, '', ''),
(5317, '1289789187', '宝钢集团', 'http://www.baosteel.com', 0, 0, 0, 4392, 0, 1, 0, NULL, 2, '', ''),
(5318, '1289789187', '马鞍山钢铁', 'http://www.magang.com.cn', 0, 0, 0, 4392, 0, 1, 0, NULL, 3, '', ''),
(5319, '1289789187', '鞍山钢铁', 'http://www.ansteel.com.cn', 0, 0, 0, 4392, 0, 1, 0, NULL, 4, '', ''),
(5320, '1289789187', '攀钢集团', 'http://www.pzhsteel.com.cn/', 0, 0, 0, 4392, 0, 1, 0, NULL, 5, '', ''),
(5321, '1289789209', '中国铸造网', 'http://www.foundry.com.cn', 0, 0, 0, 4393, 0, 1, 0, NULL, 1, '', ''),
(5322, '1289789209', '中国制造网', 'http://cn.made-in-china.com/', 0, 0, 0, 4393, 0, 1, 0, NULL, 2, '', ''),
(5323, '1289789209', '中铸网', 'http://www.3mb.cn/', 0, 0, 0, 4393, 0, 1, 0, NULL, 3, '', ''),
(5324, '1289789209', '全球铸造网', 'http://www.zhuzaowang.org.cn/', 0, 0, 0, 4393, 0, 1, 0, NULL, 4, '', ''),
(5325, '1289789209', '中国铸造', 'http://www.btzzw.com/', 0, 0, 0, 4393, 0, 1, 0, NULL, 5, '', ''),
(5326, '1289789209', '中华铸造网', 'http://www.zz17.com/', 0, 0, 0, 4393, 0, 1, 0, NULL, 6, '', ''),
(5327, '1289789209', '中国精密铸造网', 'http://www.cnpcnet.cn/', 0, 0, 0, 4393, 0, 1, 0, NULL, 7, '', ''),
(5328, '1289789209', '机械工程学会铸造会', 'http://www.foundrynations.com/', 0, 0, 0, 4393, 0, 1, 0, NULL, 8, '', ''),
(5329, '1289789209', '铸造杂志社', 'http://www.foundryworld.com', 0, 0, 0, 4393, 0, 1, 0, NULL, 9, '', ''),
(5330, '1289789229', '东方金属网', 'http://www.dfjinshu.com', 0, 0, 0, 4394, 0, 1, 0, NULL, 1, '', ''),
(5331, '1289789229', '全球金属网', 'http://www.ometal.com', 0, 0, 0, 4394, 0, 1, 0, NULL, 2, '', ''),
(5332, '1289789229', '中国金属商务网', 'http://www.ldmetals.com', 0, 0, 0, 4394, 0, 1, 0, NULL, 3, '', ''),
(5333, '1289789229', '冶金价格信息网', 'http://www.metalprice.net', 0, 0, 0, 4394, 0, 1, 0, NULL, 4, '', ''),
(5334, '1289789229', '中国焦铁网', 'http://www.coke-iron.com', 0, 0, 0, 4394, 0, 1, 0, NULL, 5, '', ''),
(5335, '1289789229', '环球金属信息网', 'http://www.world-metal.com', 0, 0, 0, 4394, 0, 1, 0, NULL, 6, '', ''),
(5336, '1289789229', '我要不锈钢', 'http://www.51bxg.com', 0, 0, 0, 4394, 0, 1, 0, NULL, 7, '', ''),
(5337, '1289789229', '不锈钢.中国', 'http://www.bxg.cn', 0, 0, 0, 4394, 0, 1, 0, NULL, 8, '', ''),
(5338, '1289789229', '中国铁合金网', 'http://www.cn-fe.com', 0, 0, 0, 4394, 0, 1, 0, NULL, 9, '', ''),
(5339, '1289789229', '中国冶金经济信息网', 'http://www.chinaesteel.com.cn/', 0, 0, 0, 4394, 0, 1, 0, NULL, 10, '', ''),
(5340, '1289789229', '中国有色网', 'http://www.cnmn.com.cn/', 0, 0, 0, 4394, 0, 1, 0, NULL, 11, '', ''),
(5341, '1289789229', '中国有色金属加工网', 'http://www.ysjg.cn', 0, 0, 0, 4394, 0, 1, 0, NULL, 12, '', ''),
(5342, '1289789229', '西北有色金属研究院', 'http://www.c-nin.com', 0, 0, 0, 4394, 0, 1, 0, NULL, 13, '', ''),
(5343, '1289789229', '中国锰业网', 'http://www.mn-cn.com/', 0, 0, 0, 4394, 0, 1, 0, NULL, 14, '', ''),
(5344, '1289789229', '中国镁业网', 'http://www.chinamagnesium.org/index.php', 0, 0, 0, 4394, 0, 1, 0, NULL, 15, '', ''),
(5345, '1289789229', '中国铁合金网', 'http://www.cn-fe.com', 0, 0, 0, 4394, 0, 1, 0, NULL, 16, '', ''),
(5346, '1289789229', '中国金属废料网', 'http://www.chinascrap.com', 0, 0, 0, 4394, 0, 1, 0, NULL, 17, '', ''),
(5347, '1289789229', '中国铝型材网', 'http://www.capm.net', 0, 0, 0, 4394, 0, 1, 0, NULL, 18, '', ''),
(5348, '1289789229', '中铝信息网', 'http://www.alum-info.com', 0, 0, 0, 4394, 0, 1, 0, NULL, 19, '', ''),
(5349, '1289789250', '中国冶金信息网', 'http://www.metalinfo.com.cn', 0, 0, 0, 4395, 0, 1, 0, NULL, 1, '', ''),
(5350, '1289789250', '中国冶金经济信息网', 'http://www.chinaesteel.com.cn', 0, 0, 0, 4395, 0, 1, 0, NULL, 2, '', ''),
(5351, '1289789250', '冶金价格信息网', 'http://www.metalprice.net', 0, 0, 0, 4395, 0, 1, 0, NULL, 3, '', ''),
(5352, '1289789250', '有色金属矿产资源', 'http://www.cnncmrc.com', 0, 0, 0, 4395, 0, 1, 0, NULL, 4, '', ''),
(5353, '1289789250', '冶金贸促网', 'http://www.mc-ccpit.com', 0, 0, 0, 4395, 0, 1, 0, NULL, 5, '', ''),
(5354, '1289789250', '中国国际矿业大会', 'http://www.china-mining.org', 0, 0, 0, 4395, 0, 1, 0, NULL, 6, '', ''),
(5355, '1289789250', '冶金矿产市场', 'http://china.alibaba.com/buy/trade/9.html', 0, 0, 0, 4395, 0, 1, 0, NULL, 7, '', ''),
(5356, '1289789250', '中国非金属矿信息网', 'http://www.chinanmm.com', 0, 0, 0, 4395, 0, 1, 0, NULL, 8, '', ''),
(5357, '1289789250', '中华粉末冶金网', 'http://www.fenmoyejin.com', 0, 0, 0, 4395, 0, 1, 0, NULL, 9, '', ''),
(5358, '1289789250', '冶金促进中心', 'http://www.mippc.net.cn', 0, 0, 0, 4395, 0, 1, 0, NULL, 10, '', ''),
(5359, '1289789271', '我的钢铁', 'http://www.mysteel.com', 0, 0, 0, 4396, 0, 1, 0, NULL, 1, '', ''),
(5360, '1289789271', '中国联合钢铁网', 'http://www.custeel.com', 0, 0, 0, 4396, 0, 1, 0, NULL, 2, '', ''),
(5361, '1289789271', '中国钢铁交易网', 'http://www.chinasteel.com.cn', 0, 0, 0, 4396, 0, 1, 0, NULL, 3, '', ''),
(5362, '1289789271', '中国不锈钢商务网', 'http://www.bxg86.com/', 0, 0, 0, 4396, 0, 1, 0, NULL, 4, '', ''),
(5363, '1289789271', '钢之家', 'http://www.steelhome.cn/', 0, 0, 0, 4396, 0, 1, 0, NULL, 5, '', ''),
(5364, '1289789271', '中国钢铁网', 'http://www.yesteel.com', 0, 0, 0, 4396, 0, 1, 0, NULL, 6, '', ''),
(5365, '1289789271', '中国钢材炉料信息网', 'http://www.gangtie114.com/', 0, 0, 0, 4396, 0, 1, 0, NULL, 7, '', ''),
(5366, '1289789271', '中国钢材贸易网', 'http://www.gcmyw.com/', 0, 0, 0, 4396, 0, 1, 0, NULL, 8, '', ''),
(5367, '1289789271', '钢材大超市', 'http://www.gcdcs.com', 0, 0, 0, 4396, 0, 1, 0, NULL, 9, '', ''),
(5368, '1289789283', '江西热线', 'http://www.jx163.com/', 0, 0, 0, 4141, 0, 1, 0, NULL, 1, '', ''),
(5369, '1289789283', '大江网', 'http://www.jxnews.com.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 2, '', ''),
(5370, '1289789283', '中国江西', 'http://www.jxcn.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 3, '', ''),
(5371, '1289789283', '今视网', 'http://www.jxgdw.com/', 0, 0, 0, 4141, 0, 1, 0, NULL, 4, '', ''),
(5372, '1289789283', '江南都市报', 'http://www.jxnews.com.cn/jndsb/', 0, 0, 0, 4141, 0, 1, 0, NULL, 5, '', ''),
(5373, '1289789283', '新余信息港', 'http://jxxy.vnet.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 6, '', ''),
(5374, '1289789283', '南昌新闻网', 'http://www.ncnews.com.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 7, '', ''),
(5375, '1289789283', '圈圈网', 'http://www.0791quanquan.com/', 0, 0, 0, 4141, 0, 1, 0, NULL, 8, '', ''),
(5376, '1289789283', '江西省政府', 'http://www.jiangxi.gov.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 9, '', ''),
(5377, '1289789283', '鹰潭信息港', 'http://jxyt.vnet.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 10, '', ''),
(5378, '1289789283', '吉安信息港', 'http://www.ja.jx.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 11, '', ''),
(5379, '1289789283', '上饶之窗', 'http://www.srzc.com/', 0, 0, 0, 4141, 0, 1, 0, NULL, 12, '', ''),
(5380, '1289789283', '九江新闻网', 'http://www.jjxw.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 13, '', ''),
(5381, '1289789283', '九江信息港', 'http://jxjj.vnet.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 14, '', ''),
(5382, '1289789283', '上饶热线', 'http://www.sr.jx.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 15, '', ''),
(5383, '1289789283', '抚州热线', 'http://www.fzline.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 16, '', ''),
(5384, '1289789283', '宜春信息港', 'http://www.yc.jx.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 17, '', ''),
(5385, '1289789283', '南昌地宝网', 'http://www.tiboo.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 18, '', ''),
(5386, '1289789283', '瓷都信息港', 'http://www.jdz.jx.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 19, '', ''),
(5387, '1289789283', '赣州信息港', 'http://www.gz.jx.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 20, '', ''),
(5388, '1289789283', '景德镇在线', 'http://jdz.jxcn.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 21, '', ''),
(5389, '1289789283', '南昌之窗', 'http://www.nc0791.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 22, '', ''),
(5390, '1289789283', '上犹网', 'http://www.shangyou.cn/', 0, 0, 0, 4141, 0, 1, 0, NULL, 23, '', ''),
(5391, '1289789305', '中国橡胶网', 'http://www.cria.org.cn', 0, 0, 0, 4397, 0, 1, 0, NULL, 1, '', ''),
(5392, '1289789305', '中国橡胶资源网', 'http://www.rubber.com.cn', 0, 0, 0, 4397, 0, 1, 0, NULL, 2, '', ''),
(5393, '1289789305', '中国橡胶市场信息网', 'http://www.crminet.net.cn', 0, 0, 0, 4397, 0, 1, 0, NULL, 3, '', ''),
(5394, '1289789305', '中国橡胶商务网', 'http://www.ldrubber.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 4, '', ''),
(5395, '1289789305', '中华橡胶商务网', 'http://www.chinaccm.com/36', 0, 0, 0, 4397, 0, 1, 0, NULL, 5, '', ''),
(5396, '1289789305', '卓创资讯-橡胶网', 'http://rubb.chem99.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 6, '', ''),
(5397, '1289789305', '塑料制品网', 'http://www.slzp.net.cn', 0, 0, 0, 4397, 0, 1, 0, NULL, 7, '', ''),
(5398, '1289789305', '中国玻璃工业网', 'http://www.chinaglassnet.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 8, '', ''),
(5399, '1289789305', '中国日用玻璃信息网', 'http://www.cnagi.org.cn', 0, 0, 0, 4397, 0, 1, 0, NULL, 9, '', ''),
(5400, '1289789305', '中国玻璃艺术网', 'http://www.artglassnet.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 10, '', ''),
(5401, '1289789305', '中国玻璃信息网', 'http://www.glassinfo.com.cn', 0, 0, 0, 4397, 0, 1, 0, NULL, 11, '', ''),
(5402, '1289789305', 'GlassAsia', 'http://www.asiaglass.com.sg', 0, 0, 0, 4397, 0, 1, 0, NULL, 12, '', ''),
(5403, '1289789305', 'GlassGlobal', 'http://www.glassglobal.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 13, '', ''),
(5404, '1289789305', '中国塑料网', 'http://www.chinaplastic.net', 0, 0, 0, 4397, 0, 1, 0, NULL, 14, '', ''),
(5405, '1289789305', '中塑在线', 'http://www.21cp.net', 0, 0, 0, 4397, 0, 1, 0, NULL, 15, '', ''),
(5406, '1289789305', '慧聪塑料网', 'http://www.plas.hc360.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 16, '', ''),
(5407, '1289789305', '中华塑料网', 'http://www.plastic.com.cn', 0, 0, 0, 4397, 0, 1, 0, NULL, 17, '', ''),
(5408, '1289789305', '中国塑料行业网', 'http://www.su-liao.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 18, '', ''),
(5409, '1289789305', '中国塑料商务网', 'http://www.plasway.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 19, '', ''),
(5410, '1289789305', '中国塑料制品交易网', 'http://www.chinappmarket.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 20, '', ''),
(5411, '1289789305', '中国再生塑料网', 'http://www.zssl.net', 0, 0, 0, 4397, 0, 1, 0, NULL, 21, '', ''),
(5412, '1289789305', '工程塑料网', 'http://www.engplastics.net', 0, 0, 0, 4397, 0, 1, 0, NULL, 22, '', ''),
(5413, '1289789305', '中国工程塑料网', 'http://www.engplast.com.cn', 0, 0, 0, 4397, 0, 1, 0, NULL, 23, '', ''),
(5414, '1289789305', '中国乐从塑料网', 'http://www.plasb2b.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 24, '', ''),
(5415, '1289789305', '中国注塑网', 'http://www.yxx.com.cn', 0, 0, 0, 4397, 0, 1, 0, NULL, 25, '', ''),
(5416, '1289789305', '中国开门化工网', 'http://www.chemn.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 26, '', ''),
(5417, '1289789305', '中国塑料机械工业协会', 'http://www.cppmia.org.cn', 0, 0, 0, 4397, 0, 1, 0, NULL, 27, '', ''),
(5418, '1289789305', '中国塑料产业链网', 'http://www.21-plastic.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 28, '', ''),
(5419, '1289789305', '中国涂料网', 'http://www.tuliao365.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 29, '', ''),
(5420, '1289789305', '慧聪涂料网', 'http://www.coatings.hc360.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 30, '', ''),
(5421, '1289789305', '中国涂料商务网', 'http://www.ldcoating.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 31, '', ''),
(5422, '1289789305', '我要看看漆', 'http://www.51kk7.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 32, '', ''),
(5423, '1289789305', '中国涂料在线', 'http://www.coatingol.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 33, '', ''),
(5424, '1289789305', '中国涂装网', 'http://www.china-painting.net', 0, 0, 0, 4397, 0, 1, 0, NULL, 34, '', ''),
(5425, '1289789305', '慧聪涂装与表面处理网', 'http://www.pf.hc360.com', 0, 0, 0, 4397, 0, 1, 0, NULL, 35, '', ''),
(5426, '1289789305', '中国油墨网', 'http://www.china-ink.net', 0, 0, 0, 4397, 0, 1, 0, NULL, 36, '', ''),
(5427, '1289789305', '环球表面处理网', 'http://www.surface-treatment.net', 0, 0, 0, 4397, 0, 1, 0, NULL, 37, '', ''),
(5428, '1289789305', '中国涂料信息网', 'http://www.tuliao.net.cn', 0, 0, 0, 4397, 0, 1, 0, NULL, 38, '', ''),
(5429, '1289789311', '江西热线', 'http://www.online.jx.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 1, '', ''),
(5430, '1289789311', '大江网', 'http://www.jxnews.com.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 2, '', ''),
(5431, '1289789311', '中国江西', 'http://www.jxcn.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 3, '', ''),
(5432, '1289789311', '江西省政府', 'http://www.jiangxi.gov.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 4, '', ''),
(5433, '1289789311', '今视网（江西电视台）', 'http://www.jxgdw.com/', 0, 0, 0, 4142, 0, 1, 0, NULL, 5, '', ''),
(5434, '1289789311', '江南都市报', 'http://www.jxnews.com.cn/jndsb/', 0, 0, 0, 4142, 0, 1, 0, NULL, 6, '', ''),
(5435, '1289789311', '南昌热线', 'http://jxnc.vnet.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 7, '', ''),
(5436, '1289789311', '南昌新闻网', 'http://www.ncnews.com.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 8, '', ''),
(5437, '1289789311', '江西人民广播电台', 'http://www.jxgdw.com/jxgd/jxgbdt/', 0, 0, 0, 4142, 0, 1, 0, NULL, 9, '', ''),
(5438, '1289789311', '鹰潭信息港', 'http://jxyt.vnet.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 10, '', ''),
(5439, '1289789311', '新华网江西频道', 'http://www.jx.xinhuanet.com/', 0, 0, 0, 4142, 0, 1, 0, NULL, 11, '', ''),
(5440, '1289789311', '南昌人民广播电台', 'http://www.ncpbs.com/', 0, 0, 0, 4142, 0, 1, 0, NULL, 12, '', ''),
(5441, '1289789311', '九江新闻网', 'http://www.jjxw.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 13, '', ''),
(5442, '1289789311', '南昌信息网', 'http://www.nc886.com.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 14, '', ''),
(5443, '1289789311', '上饶之窗', 'http://www.srzc.com/', 0, 0, 0, 4142, 0, 1, 0, NULL, 15, '', ''),
(5444, '1289789311', '抚州热线', 'http://www.fzline.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 16, '', ''),
(5445, '1289789311', '吉安信息港', 'http://www.ja.jx.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 17, '', ''),
(5446, '1289789311', '九江信息港', 'http://jxjj.vnet.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 18, '', ''),
(5447, '1289789311', '上饶热线', 'http://www.sr.jx.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 19, '', ''),
(5448, '1289789311', '宜春信息港', 'http://www.yc.jx.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 20, '', ''),
(5449, '1289789311', '南昌地宝网', 'http://www.tiboo.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 21, '', ''),
(5450, '1289789311', '瓷都信息港', 'http://www.jdz.jx.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 22, '', ''),
(5451, '1289789311', '赣州信息港', 'http://www.gz.jx.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 23, '', ''),
(5452, '1289789311', '萍乡信息港', 'http://jxpx.vnet.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 24, '', ''),
(5453, '1289789311', '新余信息港', 'http://jxxy.vnet.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 25, '', ''),
(5454, '1289789311', '江西信息港', 'http://hijiangxi.com/', 0, 0, 0, 4142, 0, 1, 0, NULL, 26, '', ''),
(5455, '1289789311', '宜春新闻网', 'http://www.newsyc.com/', 0, 0, 0, 4142, 0, 1, 0, NULL, 27, '', ''),
(5456, '1289789311', '江西日报', 'http://www.jxnews.com.cn/jxrb/', 0, 0, 0, 4142, 0, 1, 0, NULL, 28, '', ''),
(5457, '1289789311', '南昌日报', 'http://www.ncrbw.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 29, '', ''),
(5458, '1289789311', '南昌晚报', 'http://www.ncwbw.cn/', 0, 0, 0, 4142, 0, 1, 0, NULL, 30, '', ''),
(5459, '1289789311', '信息日报', 'http://www.jxnews.com.cn/xxrb/', 0, 0, 0, 4142, 0, 1, 0, NULL, 31, '', ''),
(5460, '1289789333', '中国化机网', 'http://www.chemmach.com/', 0, 0, 0, 4398, 0, 1, 0, NULL, 1, '', ''),
(5461, '1289789333', '中国化工仪器网', 'http://www.chem17.com/', 0, 0, 0, 4398, 0, 1, 0, NULL, 2, '', ''),
(5462, '1289789333', '中国化工设备网', 'http://www.ccen.net', 0, 0, 0, 4398, 0, 1, 0, NULL, 3, '', ''),
(5463, '1289789333', '中国化工机械网', 'http://www.chemm.cn/', 0, 0, 0, 4398, 0, 1, 0, NULL, 4, '', ''),
(5464, '1289789333', '中国化机网', 'http://www.huajx.com/', 0, 0, 0, 4398, 0, 1, 0, NULL, 5, '', ''),
(5465, '1289789333', '化工设备网', 'http://www.cheme.cn/', 0, 0, 0, 4398, 0, 1, 0, NULL, 6, '', ''),
(5466, '1289789333', '中国化工仪器网', 'http://www.chem17.com', 0, 0, 0, 4398, 0, 1, 0, NULL, 7, '', ''),
(5467, '1289789333', '化工机械网上贸易市场', 'http://www.chemjx.cn/', 0, 0, 0, 4398, 0, 1, 0, NULL, 8, '', ''),
(5468, '1289789354', '中国化工信息网', 'http://www.cheminfo.gov.cn', 0, 0, 0, 4399, 0, 1, 0, NULL, 1, '', ''),
(5469, '1289789354', '中国化工网', 'http://www.chemnet.com.cn', 0, 0, 0, 4399, 0, 1, 0, NULL, 2, '', ''),
(5470, '1289789354', '中国化工资讯网', 'http://www.chchin.com/', 0, 0, 0, 4399, 0, 1, 0, NULL, 3, '', ''),
(5471, '1289789354', '中国石油化工网', 'http://www.chemall.com.cn/', 0, 0, 0, 4399, 0, 1, 0, NULL, 4, '', ''),
(5472, '1289789354', '中国化工企业信息网', 'http://www.souchem.com/', 0, 0, 0, 4399, 0, 1, 0, NULL, 5, '', ''),
(5473, '1289789354', '中国化工企业互联网', 'http://www.cpcp.com.cn', 0, 0, 0, 4399, 0, 1, 0, NULL, 6, '', ''),
(5474, '1289789354', '中国化工信息', 'http://www.chemnews.com.cn', 0, 0, 0, 4399, 0, 1, 0, NULL, 7, '', ''),
(5475, '1289789354', '中国开门化工商务网', 'http://www.chemn.com', 0, 0, 0, 4399, 0, 1, 0, NULL, 8, '', ''),
(5476, '1289789354', '中国化工电子商务网', 'http://www.ccecn.com', 0, 0, 0, 4399, 0, 1, 0, NULL, 9, '', ''),
(5477, '1289789354', '中化新网', 'http://www.ccin.com.cn/', 0, 0, 0, 4399, 0, 1, 0, NULL, 10, '', ''),
(5478, '1289789354', '中国万维化工城', 'http://www.chem.com.cn', 0, 0, 0, 4399, 0, 1, 0, NULL, 11, '', ''),
(5479, '1289789354', '华夏化工网', 'http://www.hxchem.net/', 0, 0, 0, 4399, 0, 1, 0, NULL, 12, '', ''),
(5480, '1289789354', '中国化工招聘网', 'http://www.hgjob.com', 0, 0, 0, 4399, 0, 1, 0, NULL, 13, '', ''),
(5481, '1289789354', '中国化工市场七日讯', 'http://www.qrx.cn', 0, 0, 0, 4399, 0, 1, 0, NULL, 14, '', ''),
(5482, '1289789354', '林产化工网', 'http://www.308308.com/', 0, 0, 0, 4399, 0, 1, 0, NULL, 15, '', ''),
(5483, '1289789354', '慧聪化工网', 'http://www.chem.hc360.com', 0, 0, 0, 4399, 0, 1, 0, NULL, 16, '', ''),
(5484, '1289789354', '卓创资讯-化工网', 'http://chem.chem99.com/', 0, 0, 0, 4399, 0, 1, 0, NULL, 17, '', ''),
(5485, '1289789354', '勤加缘化工在线', 'http://chem.qjy168.com/', 0, 0, 0, 4399, 0, 1, 0, NULL, 18, '', ''),
(5486, '1289789354', '中国化工产品网', 'http://www.chemcp.com', 0, 0, 0, 4399, 0, 1, 0, NULL, 19, '', ''),
(5487, '1289789354', '世易化工网', 'http://china.echinachem.com/', 0, 0, 0, 4399, 0, 1, 0, NULL, 20, '', ''),
(5488, '1289789354', '卡维资讯', 'http://www.kawise.com/', 0, 0, 0, 4399, 0, 1, 0, NULL, 21, '', ''),
(5489, '1289789354', '化工英才网', 'http://www.chenhr.com/', 0, 0, 0, 4399, 0, 1, 0, NULL, 22, '', ''),
(5490, '1289789354', '化工世界网', 'http://www.chemworld.com.cn', 0, 0, 0, 4399, 0, 1, 0, NULL, 23, '', ''),
(5491, '1289789354', '化工易贸网', 'http://www.chemease.com', 0, 0, 0, 4399, 0, 1, 0, NULL, 24, '', ''),
(5492, '1289789354', '西部化工网', 'http://www.cnwestchem.com', 0, 0, 0, 4399, 0, 1, 0, NULL, 25, '', ''),
(5493, '1289789354', '华东化工网', 'http://www.cechem.net/', 0, 0, 0, 4399, 0, 1, 0, NULL, 26, '', ''),
(5494, '1289789354', '中纤咨询', 'http://www.ccfei.com/', 0, 0, 0, 4399, 0, 1, 0, NULL, 27, '', ''),
(5495, '1289789354', '化工热线', 'http://www.chemol.com.cn', 0, 0, 0, 4399, 0, 1, 0, NULL, 28, '', ''),
(5496, '1289789369', '江西气象', 'http://www.weather.org.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 1, '', ''),
(5497, '1289789369', '江西机场', 'http://www.jxairport.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 2, '', ''),
(5498, '1289789369', '南昌公交线路', 'http://nanchang.8684.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 3, '', ''),
(5499, '1289789369', '江西交通信息网', 'http://www.jxjt.gov.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 4, '', ''),
(5500, '1289789369', '南昌驾驶员记分查询', 'http://ncjj.nc.gov.cn/infos.asp', 0, 0, 0, 4143, 0, 1, 0, NULL, 5, '', ''),
(5501, '1289789369', '百度地图－南昌', 'http://map.baidu.com/#word=%E5%8D%97%E6%98%8C%E5%B8%82&amp;amp;ct=10', 0, 0, 0, 4143, 0, 1, 0, NULL, 6, '', ''),
(5502, '1289789369', '江西交警网', 'http://www.jxhld.gov.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 7, '', ''),
(5503, '1289789369', '列车时刻', 'http://lieche.5w.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 8, '', ''),
(5504, '1289789369', '大江旅游', 'http://tour.jxnews.com.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 9, '', ''),
(5505, '1289789369', '江西旅游网', 'http://www.jxta.gov.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 10, '', ''),
(5506, '1289789369', '婺源旅游局', 'http://www.wylyw.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 11, '', ''),
(5507, '1289789369', '庐山', 'http://www.china-lushan.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 12, '', ''),
(5508, '1289789369', '井冈山', 'http://www.jgstour.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 13, '', ''),
(5509, '1289789369', '三清山', 'http://www.sanqingshan.net.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 14, '', ''),
(5510, '1289789369', '鄱阳湖', 'http://www.poyanglake.net/index1.asp', 0, 0, 0, 4143, 0, 1, 0, NULL, 15, '', ''),
(5511, '1289789369', '南昌餐饮网', 'http://www.nccyw.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 16, '', ''),
(5512, '1289789369', '大众点评网南昌', 'http://www.dianping.com/nanchang/food', 0, 0, 0, 4143, 0, 1, 0, NULL, 17, '', ''),
(5513, '1289789369', '小刀在线', 'http://www.ncdiy.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 18, '', ''),
(5514, '1289789369', '圈圈网', 'http://www.0791quanquan.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 19, '', ''),
(5515, '1289789369', '江西搜房', 'http://www.jxsoufun.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 20, '', ''),
(5516, '1289789369', '搜房网江西站', 'http://soufun.online.jx.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 21, '', ''),
(5517, '1289789369', '九江房产管理局', 'http://www.jjhome.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 22, '', ''),
(5518, '1289789369', '南昌房产管理局', 'http://www.ncfdc.com.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 23, '', ''),
(5519, '1289789369', '景德镇住房公积金网', 'http://www.jdzgjj.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 24, '', ''),
(5520, '1289789369', '南昌住房公积金网', 'http://www.ncgjj.com.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 25, '', ''),
(5521, '1289789369', '南昌搜房网', 'http://nc.soufun.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 26, '', ''),
(5522, '1289789369', '江西房产交易网', 'http://www.jtzhiye.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 27, '', ''),
(5523, '1289789369', '江西住宅与房地产', 'http://www.jxzzfdc.gov.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 28, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(5524, '1289789369', '南昌大学第一附院', 'http://www.cdyfy.com/index-moban1225.asp', 0, 0, 0, 4143, 0, 1, 0, NULL, 29, '', ''),
(5525, '1289789369', '大江网健康频道', 'http://health.jxnews.com.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 30, '', ''),
(5526, '1289789369', '江西省人民医院', 'http://www.jxph.com/', 0, 0, 0, 4143, 0, 1, 0, NULL, 31, '', ''),
(5527, '1289789369', '江西省中医院', 'http://www.jxszyy.nc.jx.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 32, '', ''),
(5528, '1289789369', '江西省儿童医院', 'http://www.jxsetyy.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 33, '', ''),
(5529, '1289789369', '南昌大学第二附院', 'http://www.jxmu.edu.cn/hospital/hospital2/', 0, 0, 0, 4143, 0, 1, 0, NULL, 34, '', ''),
(5530, '1289789369', '江西省肿瘤医院', 'http://www.jxcancer.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 35, '', ''),
(5531, '1289789369', '江西省胸科医院', 'http://www.xkyy.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 36, '', ''),
(5532, '1289789369', '江西省红十字会', 'http://www.jxredcross.org.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 37, '', ''),
(5533, '1289789369', '江西省卫生厅', 'http://www.jxwst.gov.cn/', 0, 0, 0, 4143, 0, 1, 0, NULL, 38, '', ''),
(5534, '1289789388', '江西省教育厅', 'http://www.jxedu.gov.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 1, '', ''),
(5535, '1289789388', '江西高等教育网', 'http://www.jxgj.edu.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 2, '', ''),
(5536, '1289789388', '江西省自学考试网', 'http://www.jxzk.com.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 3, '', ''),
(5537, '1289789388', '江西自考网', 'http://www.jxzk.com.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 4, '', ''),
(5538, '1289789388', '南昌大学', 'http://www.ncu.edu.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 5, '', ''),
(5539, '1289789388', '江西师范大学', 'http://www.jxnu.edu.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 6, '', ''),
(5540, '1289789388', '江西财经大学', 'http://www.jxufe.edu.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 7, '', ''),
(5541, '1289789388', '江西农业大学', 'http://www.jxau.edu.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 8, '', ''),
(5542, '1289789388', '华东交通大学', 'http://www.ecjtu.jx.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 9, '', ''),
(5543, '1289789388', '南昌理工学院', 'http://www.nclg.com.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 10, '', ''),
(5544, '1289789388', '东华理工大学', 'http://www.ecit.edu.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 11, '', ''),
(5545, '1289789388', '江西理工大学', 'http://www.jxust.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 12, '', ''),
(5546, '1289789388', '赣南医学院', 'http://www.gnmc.net.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 13, '', ''),
(5547, '1289789388', '南昌航空大学', 'http://www.niat.jx.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 14, '', ''),
(5548, '1289789388', '江西会计网', 'http://acc.jxf.gov.cn/', 0, 0, 0, 4144, 0, 1, 0, NULL, 15, '', ''),
(5549, '1289789394', '中国仪器仪表学会', 'http://www.cis.org.cn', 0, 0, 0, 4402, 0, 1, 0, NULL, 1, '', ''),
(5550, '1289789394', '仪器信息网', 'http://www.instrument.com.cn/', 0, 0, 0, 4402, 0, 1, 0, NULL, 2, '', ''),
(5551, '1289789394', '中国仪器仪表信息网', 'http://www.instrnet.com', 0, 0, 0, 4402, 0, 1, 0, NULL, 3, '', ''),
(5552, '1289789394', '中仪器仪表行业协会', 'http://www.cima.org.cn/', 0, 0, 0, 4402, 0, 1, 0, NULL, 4, '', ''),
(5553, '1289789394', '中国机经网-仪器仪表', 'http://www.mei.gov.cn/industry/instrument/', 0, 0, 0, 4402, 0, 1, 0, NULL, 5, '', ''),
(5554, '1289789394', '仪器仪表交易网', 'http://www.testmart.cn', 0, 0, 0, 4402, 0, 1, 0, NULL, 6, '', ''),
(5555, '1289789394', '中国工控168网', 'http://www.gk168.com', 0, 0, 0, 4402, 0, 1, 0, NULL, 7, '', ''),
(5556, '1289789394', '仪表网', 'http://www.yibiao.com', 0, 0, 0, 4402, 0, 1, 0, NULL, 8, '', ''),
(5557, '1289789394', '中国分析仪器网', 'http://www.54pc.com/', 0, 0, 0, 4402, 0, 1, 0, NULL, 9, '', ''),
(5558, '1289789394', '易展仪表展览网', 'http://www.18show.cn', 0, 0, 0, 4402, 0, 1, 0, NULL, 10, '', ''),
(5559, '1289789408', '今视论坛', 'http://bbs.jxgdw.com/', 0, 0, 0, 4145, 0, 1, 0, NULL, 1, '', ''),
(5560, '1289789408', '江西论坛', 'http://bbs.jxcn.cn/', 0, 0, 0, 4145, 0, 1, 0, NULL, 2, '', ''),
(5561, '1289789408', '江西贴吧', 'http://tieba.baidu.com/f?kw=%BD%AD%CE%F7', 0, 0, 0, 4145, 0, 1, 0, NULL, 3, '', ''),
(5562, '1289789408', '大江论坛', 'http://bbs.jxnews.com.cn/', 0, 0, 0, 4145, 0, 1, 0, NULL, 4, '', ''),
(5563, '1289789408', '景德镇贴吧', 'http://tieba.baidu.com/f?kw=%BE%B0%B5%C2%D5%F2', 0, 0, 0, 4145, 0, 1, 0, NULL, 5, '', ''),
(5564, '1289789408', '小刀论坛', 'http://bbs.ncdiy.com/', 0, 0, 0, 4145, 0, 1, 0, NULL, 6, '', ''),
(5565, '1289789414', '中华机械网', 'http://china.machine365.com/', 0, 0, 0, 4403, 0, 1, 0, NULL, 1, '', ''),
(5566, '1289789414', '中国制造网', 'http://cn.made-in-china.com/', 0, 0, 0, 4403, 0, 1, 0, NULL, 2, '', ''),
(5567, '1289789414', '中国工程机械网', 'http://www.cpzl.com/', 0, 0, 0, 4403, 0, 1, 0, NULL, 3, '', ''),
(5568, '1289789414', '中国机械网', 'http://www.jx.cn', 0, 0, 0, 4403, 0, 1, 0, NULL, 4, '', ''),
(5569, '1289789414', '全球机械网', 'http://www.qqma.com/', 0, 0, 0, 4403, 0, 1, 0, NULL, 5, '', ''),
(5570, '1289789414', '中国机械工程学会', 'http://www.cmes.org', 0, 0, 0, 4403, 0, 1, 0, NULL, 6, '', ''),
(5571, '1289789414', '中国机械与配件网', 'http://www.lc800.com/', 0, 0, 0, 4403, 0, 1, 0, NULL, 7, '', ''),
(5572, '1289789414', '慧聪热泵网', 'http://www.hp.hc360.com', 0, 0, 0, 4403, 0, 1, 0, NULL, 8, '', ''),
(5573, '1289789414', '中国路面机械网', 'http://www.lmjx.net', 0, 0, 0, 4403, 0, 1, 0, NULL, 9, '', ''),
(5574, '1289789414', '全球阀门网', 'http://www.famens.com/', 0, 0, 0, 4403, 0, 1, 0, NULL, 10, '', ''),
(5575, '1289789414', '慧聪网工程机械网', 'http://www.cm.hc360.com', 0, 0, 0, 4403, 0, 1, 0, NULL, 11, '', ''),
(5576, '1289789414', '中国起重机械网', 'http://www.chinacrane.net/', 0, 0, 0, 4403, 0, 1, 0, NULL, 12, '', ''),
(5577, '1289789414', '中国锯工业网', 'http://www.cnsaw.com/', 0, 0, 0, 4403, 0, 1, 0, NULL, 13, '', ''),
(5578, '1289789414', '中国教育装备采购网', 'http://www.caigou.com.cn/', 0, 0, 0, 4403, 0, 1, 0, NULL, 14, '', ''),
(5579, '1289789414', '中国机床网', 'http://china.machine35.com', 0, 0, 0, 4403, 0, 1, 0, NULL, 15, '', ''),
(5580, '1289789414', '亚洲泵网', 'http://www.asiapump.cn/', 0, 0, 0, 4403, 0, 1, 0, NULL, 16, '', ''),
(5581, '1289789425', '江西省政府', 'http://www.jiangxi.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 1, '', ''),
(5582, '1289789425', '发改委', 'http://www.jxdpc.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 2, '', ''),
(5583, '1289789425', '安全生产监督管理局', 'http://www.jxsafety.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 3, '', ''),
(5584, '1289789425', '农业厅', 'http://www.jxagri.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 4, '', ''),
(5585, '1289789425', '食品药品监督管理局', 'http://www.jxfda.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 5, '', ''),
(5586, '1289789425', '江西省经贸委', 'http://www.jxetc.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 6, '', ''),
(5587, '1289789425', '江西省公安厅', 'http://www.jxga.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 7, '', ''),
(5588, '1289789425', '江西省地税局', 'http://www.jxds.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 8, '', ''),
(5589, '1289789425', '南昌', 'http://www.nc.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 9, '', ''),
(5590, '1289789425', '景德镇', 'http://www.jdz.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 10, '', ''),
(5591, '1289789425', '宜春', 'http://www.yichun.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 11, '', ''),
(5592, '1289789425', '九江', 'http://www.jiujiang.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 12, '', ''),
(5593, '1289789425', '江西妇联', 'http://www.jxwomen.org.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 13, '', ''),
(5594, '1289789425', '江西省计生委', 'http://www.jxjsw.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 14, '', ''),
(5595, '1289789425', '江西省扶贫开发办', 'http://www.pado-jx.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 15, '', ''),
(5596, '1289789425', '江西省工商局', 'http://www.jxaic.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 16, '', ''),
(5597, '1289789425', '江西省人事厅网', 'http://www.jxrsxx.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 17, '', ''),
(5598, '1289789425', '江西省财政厅', 'http://www.jxf.gov.cn/', 0, 0, 0, 4146, 0, 1, 0, NULL, 18, '', ''),
(5599, '1289789430', '中国音响设计网', 'http://www.xycad.com', 0, 0, 0, 4404, 0, 1, 0, NULL, 1, '', ''),
(5600, '1289789430', '非常发烧网', 'http://www.hifi168.com', 0, 0, 0, 4404, 0, 1, 0, NULL, 2, '', ''),
(5601, '1289789430', '中国专业音响网', 'http://www.av220.com/', 0, 0, 0, 4404, 0, 1, 0, NULL, 3, '', ''),
(5602, '1289789430', '慧聪音响灯光网', 'http://www.audio.hc360.com', 0, 0, 0, 4404, 0, 1, 0, NULL, 4, '', ''),
(5603, '1289789430', '神州音响网', 'http://www.szaudio.com', 0, 0, 0, 4404, 0, 1, 0, NULL, 5, '', ''),
(5604, '1289789430', '中国音频网', 'http://www.cmmbox.com/', 0, 0, 0, 4404, 0, 1, 0, NULL, 6, '', ''),
(5605, '1289789449', '中国家电在线', 'http://www.eaonline.com.cn', 0, 0, 0, 4405, 0, 1, 0, NULL, 1, '', ''),
(5606, '1289789449', '中国家电网', 'http://www.cheaa.com/', 0, 0, 0, 4405, 0, 1, 0, NULL, 2, '', ''),
(5607, '1289789449', '家电大视野', 'http://www.jddsy.com', 0, 0, 0, 4405, 0, 1, 0, NULL, 3, '', ''),
(5608, '1289789449', '慧聪家电网', 'http://www.homea.hc360.com', 0, 0, 0, 4405, 0, 1, 0, NULL, 4, '', ''),
(5609, '1289789449', '数字家电', 'http://elec.it168.com', 0, 0, 0, 4405, 0, 1, 0, NULL, 5, '', ''),
(5610, '1289789449', '中国家电多赢网', 'http://www.gdeha.com', 0, 0, 0, 4405, 0, 1, 0, NULL, 6, '', ''),
(5611, '1289789449', '百汇家电网', 'http://www.bhjoy.com/', 0, 0, 0, 4405, 0, 1, 0, NULL, 7, '', ''),
(5612, '1289789484', '中国电力企业联合会', 'http://www.cec.org.cn', 0, 0, 0, 4406, 0, 1, 0, NULL, 1, '', ''),
(5613, '1289789484', '中国电力在线', 'http://www.chinapoweronline.com', 0, 0, 0, 4406, 0, 1, 0, NULL, 2, '', ''),
(5614, '1289789484', '中国电力网', 'http://www.chinapower.com.cn', 0, 0, 0, 4406, 0, 1, 0, NULL, 3, '', ''),
(5615, '1289789484', '中国电力新闻网', 'http://www.cpnn.com.cn/', 0, 0, 0, 4406, 0, 1, 0, NULL, 4, '', ''),
(5616, '1289789484', '慧聪网电气网', 'http://www.electric.hc360.com/', 0, 0, 0, 4406, 0, 1, 0, NULL, 5, '', ''),
(5617, '1289789484', '国家电力监管委员会', 'http://www.serc.gov.cn', 0, 0, 0, 4406, 0, 1, 0, NULL, 6, '', ''),
(5618, '1289789484', '中国电力装备网', 'http://www.99dq.com', 0, 0, 0, 4406, 0, 1, 0, NULL, 7, '', ''),
(5619, '1289789484', '电力设备网', 'http://www.cepee.com/', 0, 0, 0, 4406, 0, 1, 0, NULL, 8, '', ''),
(5620, '1289789484', '中国电力设备信息网', 'http://www.cpeinet.com.cn/', 0, 0, 0, 4406, 0, 1, 0, NULL, 9, '', ''),
(5621, '1289789484', '新能量电力商务网', 'http://www.freshpower.cn', 0, 0, 0, 4406, 0, 1, 0, NULL, 10, '', ''),
(5622, '1289789484', '中国电力企业联合会', 'http://www.dls.org.cn', 0, 0, 0, 4406, 0, 1, 0, NULL, 11, '', ''),
(5623, '1289789484', '农村电气化信息网', 'http://www.chinarein.com', 0, 0, 0, 4406, 0, 1, 0, NULL, 12, '', ''),
(5624, '1289789484', '《电力系统自动化》', 'http://www.aeps-info.com', 0, 0, 0, 4406, 0, 1, 0, NULL, 13, '', ''),
(5625, '1289789484', '电力产品网', 'http://www.powerproduct.com/', 0, 0, 0, 4406, 0, 1, 0, NULL, 14, '', ''),
(5626, '1289789484', '北极星电力技术网', 'http://www.bjx.com.cn/', 0, 0, 0, 4406, 0, 1, 0, NULL, 15, '', ''),
(5627, '1289789484', '中国电力科学研究院', 'http://www.epri.ac.cn/', 0, 0, 0, 4406, 0, 1, 0, NULL, 16, '', ''),
(5628, '1289789484', '中国电力招标采购网', 'http://www.dlztb.com/', 0, 0, 0, 4406, 0, 1, 0, NULL, 17, '', ''),
(5629, '1289789502', '中煤网', 'http://www.3jjj.com', 0, 0, 0, 4407, 0, 1, 0, NULL, 1, '', ''),
(5630, '1289789502', '中国煤炭新闻网', 'http://www.cwestc.com', 0, 0, 0, 4407, 0, 1, 0, NULL, 2, '', ''),
(5631, '1289789502', '煤炭网', 'http://www.coal.com.cn', 0, 0, 0, 4407, 0, 1, 0, NULL, 3, '', ''),
(5632, '1289789502', '中国煤炭资源网', 'http://www.sxcoal.com', 0, 0, 0, 4407, 0, 1, 0, NULL, 4, '', ''),
(5633, '1289789502', '中国煤炭博物馆', 'http://www.coalmus.org.cn', 0, 0, 0, 4407, 0, 1, 0, NULL, 5, '', ''),
(5634, '1289789502', '中国煤炭机械工业网', 'http://www.coalmachine.net/', 0, 0, 0, 4407, 0, 1, 0, NULL, 6, '', ''),
(5635, '1289789502', '中国煤焦数字交易市场', 'http://www.ccce.com.cn', 0, 0, 0, 4407, 0, 1, 0, NULL, 7, '', ''),
(5636, '1289789502', '中国煤炭律师网', 'http://www.zgmtls.com/', 0, 0, 0, 4407, 0, 1, 0, NULL, 8, '', ''),
(5637, '1289789525', '中国石油新闻中心', 'http://www.oilnews.com.cn', 0, 0, 0, 4408, 0, 1, 0, NULL, 1, '', ''),
(5638, '1289789525', '中国石油商务网', 'http://www.oilchina.com', 0, 0, 0, 4408, 0, 1, 0, NULL, 2, '', ''),
(5639, '1289789525', '世界石油网', 'http://www.worldoilweb.com', 0, 0, 0, 4408, 0, 1, 0, NULL, 3, '', ''),
(5640, '1289789525', '中国石化新闻网', 'http://www.sinopecnews.com.cn', 0, 0, 0, 4408, 0, 1, 0, NULL, 4, '', ''),
(5641, '1289789525', '中国石油在线', 'http://www.chinaoilonline.com', 0, 0, 0, 4408, 0, 1, 0, NULL, 5, '', ''),
(5642, '1289789525', '中国油品资讯网', 'http://www.oilinfor.com', 0, 0, 0, 4408, 0, 1, 0, NULL, 6, '', ''),
(5643, '1289789525', '慧聪石油网', 'http://www.oil.hc360.com/', 0, 0, 0, 4408, 0, 1, 0, NULL, 7, '', ''),
(5644, '1289789525', '中国石油和化工网', 'http://www.chemall.com.cn/', 0, 0, 0, 4408, 0, 1, 0, NULL, 8, '', ''),
(5645, '1289789525', '东方油气网', 'http://www.oilgas.com.cn', 0, 0, 0, 4408, 0, 1, 0, NULL, 9, '', ''),
(5646, '1289789525', '中国加油站网', 'http://www.oilboss.cn/', 0, 0, 0, 4408, 0, 1, 0, NULL, 10, '', ''),
(5647, '1289789525', '中国石油天然气', 'http://www.petrochina.com.cn', 0, 0, 0, 4408, 0, 1, 0, NULL, 11, '', ''),
(5648, '1289789525', '中国石化', 'http://www.sinopec.com', 0, 0, 0, 4408, 0, 1, 0, NULL, 12, '', ''),
(5649, '1289789525', '中国石油天然气集团', 'http://www.cnpc.com.cn/', 0, 0, 0, 4408, 0, 1, 0, NULL, 13, '', ''),
(5650, '1289789525', '中华商务网-石油产业', 'http://www.chinaccm.com/shiyou.asp', 0, 0, 0, 4408, 0, 1, 0, NULL, 14, '', ''),
(5651, '1289789525', '中原油田信息港', 'http://www.zytx.com.cn/', 0, 0, 0, 4408, 0, 1, 0, NULL, 15, '', ''),
(5652, '1289789525', '隆众石化商务网', 'http://www.oilchem.net', 0, 0, 0, 4408, 0, 1, 0, NULL, 16, '', ''),
(5653, '1289789525', '石化英才网', 'http://www.chenhr.com/', 0, 0, 0, 4408, 0, 1, 0, NULL, 17, '', ''),
(5654, '1289789546', '中国新能源网', 'http://www.newenergy.org.cn', 0, 0, 0, 4409, 0, 1, 0, NULL, 1, '', ''),
(5655, '1289789546', '中国新能源与可再生能源网', 'http://www.crein.org.cn', 0, 0, 0, 4409, 0, 1, 0, NULL, 2, '', ''),
(5656, '1289789546', '中国能源网', 'http://www.china5e.com/', 0, 0, 0, 4409, 0, 1, 0, NULL, 3, '', ''),
(5657, '1289789546', '中国电池网', 'http://www.battery.com.cn/', 0, 0, 0, 4409, 0, 1, 0, NULL, 4, '', ''),
(5658, '1289789546', '阿里巴巴-能源行业', 'http://china.alibaba.com/buy/trade/10.html', 0, 0, 0, 4409, 0, 1, 0, NULL, 5, '', ''),
(5659, '1289789546', '中国能源信息网', 'http://www.nengyuan.net/', 0, 0, 0, 4409, 0, 1, 0, NULL, 6, '', ''),
(5660, '1289789546', '全球矿权网', 'http://www.qqkqw.com', 0, 0, 0, 4409, 0, 1, 0, NULL, 7, '', ''),
(5661, '1289789574', '中国水果网', 'http://www.cnfruit.com', 0, 0, 0, 4410, 0, 1, 0, NULL, 1, '', ''),
(5662, '1289789574', '中国果品网', 'http://www.china-fruit.com.cn', 0, 0, 0, 4410, 0, 1, 0, NULL, 2, '', ''),
(5663, '1289789574', '中华果都网', 'http://www.chinadsh.com', 0, 0, 0, 4410, 0, 1, 0, NULL, 3, '', ''),
(5664, '1289789574', '中国水果供应商', 'http://www.cn-fruits.cn/', 0, 0, 0, 4410, 0, 1, 0, NULL, 4, '', ''),
(5665, '1289789574', '中华水果网', 'http://www.onfruit.com/', 0, 0, 0, 4410, 0, 1, 0, NULL, 5, '', ''),
(5666, '1289789574', '水果帮', 'http://www.fruit8.com/', 0, 0, 0, 4410, 0, 1, 0, NULL, 6, '', ''),
(5667, '1289789593', '中国饮料工业', 'http://cbi.clii.com.cn/', 0, 0, 0, 4411, 0, 1, 0, NULL, 1, '', ''),
(5668, '1289789593', '中国饮料工业协会', 'http://www.chinabeverage.org/', 0, 0, 0, 4411, 0, 1, 0, NULL, 2, '', ''),
(5669, '1289789593', '中国乳业信息网', 'http://www.chinadairy.net', 0, 0, 0, 4411, 0, 1, 0, NULL, 3, '', ''),
(5670, '1289789593', '饮料研究报告', 'http://www.chinabgao.com/09/report/drink.asp', 0, 0, 0, 4411, 0, 1, 0, NULL, 4, '', ''),
(5671, '1289789593', '中国奶业在线', 'http://www.chinadairyindustry.org.cn', 0, 0, 0, 4411, 0, 1, 0, NULL, 5, '', ''),
(5672, '1289789612', '中国茶网', 'http://tea.zjol.com.cn', 0, 0, 0, 4412, 0, 1, 0, NULL, 1, '', ''),
(5673, '1289789612', '中茶文化网', 'http://www.teaw.com', 0, 0, 0, 4412, 0, 1, 0, NULL, 2, '', ''),
(5674, '1289789612', '茶网·中国', 'http://www.alltea.cn/', 0, 0, 0, 4412, 0, 1, 0, NULL, 3, '', ''),
(5675, '1289789612', '中茶网', 'http://www.teanet.com.cn', 0, 0, 0, 4412, 0, 1, 0, NULL, 4, '', ''),
(5676, '1289789612', '爱茶网', 'http://www.fjteaw.cn', 0, 0, 0, 4412, 0, 1, 0, NULL, 5, '', ''),
(5677, '1289789612', '中国追新茶叶网', 'http://www.aa59.com/', 0, 0, 0, 4412, 0, 1, 0, NULL, 6, '', ''),
(5678, '1289789630', '中国烟草在线', 'http://www.tobaccochina.com', 0, 0, 0, 4413, 0, 1, 0, NULL, 1, '', ''),
(5679, '1289789630', '烟草中国网', 'http://www.16888.com.cn', 0, 0, 0, 4413, 0, 1, 0, NULL, 2, '', ''),
(5680, '1289789630', '东方烟草网', 'http://www.eastobacco.com', 0, 0, 0, 4413, 0, 1, 0, NULL, 3, '', ''),
(5681, '1289789630', '中国烟草资讯网', 'http://www.echinatobacco.com', 0, 0, 0, 4413, 0, 1, 0, NULL, 4, '', ''),
(5682, '1289789630', '中国烟草科教网', 'http://www.tobaccoinfo.com.cn', 0, 0, 0, 4413, 0, 1, 0, NULL, 5, '', ''),
(5683, '1289789630', '中国烟草交易中心', 'http://www.tobt.com.cn/', 0, 0, 0, 4413, 0, 1, 0, NULL, 6, '', ''),
(5684, '1289789630', '国家烟草专卖局', 'http://www.tobacco.gov.cn/', 0, 0, 0, 4413, 0, 1, 0, NULL, 7, '', ''),
(5685, '1289789630', '糖酒快讯', 'http://www.tjkx.com/', 0, 0, 0, 4413, 0, 1, 0, NULL, 8, '', ''),
(5686, '1289789630', '中国食糖网', 'http://www.gsec.com.cn', 0, 0, 0, 4413, 0, 1, 0, NULL, 9, '', ''),
(5687, '1289789630', '中国酒', 'http://www.chinadrinks.net', 0, 0, 0, 4413, 0, 1, 0, NULL, 10, '', ''),
(5688, '1289789655', '中华粮网', 'http://www.cngrain.com', 0, 0, 0, 4414, 0, 1, 0, NULL, 1, '', ''),
(5689, '1289789655', '中国粮食信息网', 'http://www.grain.gov.cn', 0, 0, 0, 4414, 0, 1, 0, NULL, 2, '', ''),
(5690, '1289789655', '中国粮油商务网', 'http://www.fao.com.cn', 0, 0, 0, 4414, 0, 1, 0, NULL, 3, '', ''),
(5691, '1289789655', '中国粮油食品信息网', 'http://www.cof.net.cn', 0, 0, 0, 4414, 0, 1, 0, NULL, 4, '', ''),
(5692, '1289789655', '中国粮食网', 'http://www.cereal.com.cn', 0, 0, 0, 4414, 0, 1, 0, NULL, 5, '', ''),
(5693, '1289789655', '中华粮油商务网', 'http://www.chinaccm.com/02/', 0, 0, 0, 4414, 0, 1, 0, NULL, 6, '', ''),
(5694, '1289789655', '中国粮油信息网', 'http://www.chinagrain.cn/', 0, 0, 0, 4414, 0, 1, 0, NULL, 7, '', ''),
(5695, '1289789655', '国家粮食局', 'http://www.chinagrain.gov.cn', 0, 0, 0, 4414, 0, 1, 0, NULL, 8, '', ''),
(5696, '1289789655', '中国玉米市场网', 'http://www.ex-starch.com', 0, 0, 0, 4414, 0, 1, 0, NULL, 9, '', ''),
(5697, '1289789655', '中国大豆网', 'http://www.dadou.cn', 0, 0, 0, 4414, 0, 1, 0, NULL, 10, '', ''),
(5698, '1289789655', '中国玉米网', 'http://www.maize.com.cn', 0, 0, 0, 4414, 0, 1, 0, NULL, 11, '', ''),
(5699, '1289789655', '中国食用油信息网', 'http://www.oilcn.com/', 0, 0, 0, 4414, 0, 1, 0, NULL, 12, '', ''),
(5700, '1289789655', '华商资讯网', 'http://www.oil-114.com', 0, 0, 0, 4414, 0, 1, 0, NULL, 13, '', ''),
(5701, '1289789655', '粮油市场报', 'http://www.grainnews.com.cn', 0, 0, 0, 4414, 0, 1, 0, NULL, 14, '', ''),
(5702, '1289789655', '榕粮网', 'http://www.fzgrain.com', 0, 0, 0, 4414, 0, 1, 0, NULL, 15, '', ''),
(5703, '1289789655', '北方粮网', 'http://www.cndnce.com/', 0, 0, 0, 4414, 0, 1, 0, NULL, 16, '', ''),
(5704, '1289789677', '中国食品商务网', 'http://www.21food.cn', 0, 0, 0, 4415, 0, 1, 0, NULL, 1, '', ''),
(5705, '1289789677', '慧聪网-食品工业', 'http://www.pack.hc360.com/', 0, 0, 0, 4415, 0, 1, 0, NULL, 2, '', ''),
(5706, '1289789677', '中国食品科技网', 'http://www.tech-food.com', 0, 0, 0, 4415, 0, 1, 0, NULL, 3, '', ''),
(5707, '1289789677', '中国食品工业网', 'http://www.cfiin.com', 0, 0, 0, 4415, 0, 1, 0, NULL, 4, '', ''),
(5708, '1289789677', '中国食品质量报', 'http://www.cfqn.com.cn', 0, 0, 0, 4415, 0, 1, 0, NULL, 5, '', ''),
(5709, '1289789677', '中国食品展会网', 'http://www.foodexpo.cn', 0, 0, 0, 4415, 0, 1, 0, NULL, 6, '', ''),
(5710, '1289789677', '中国食品网', 'http://www.cn-food.net', 0, 0, 0, 4415, 0, 1, 0, NULL, 7, '', ''),
(5711, '1289789677', '中国绿色食品网', 'http://www.greenfood.org.cn/', 0, 0, 0, 4415, 0, 1, 0, NULL, 8, '', ''),
(5712, '1289789677', '第一食品贸易网', 'http://www.foods1.com/', 0, 0, 0, 4415, 0, 1, 0, NULL, 9, '', ''),
(5713, '1289789677', '中国食品科技会', 'http://www.cifst.org.cn', 0, 0, 0, 4415, 0, 1, 0, NULL, 10, '', ''),
(5714, '1289789677', '中国食品信息网', 'http://www.chinafoods.cn/', 0, 0, 0, 4415, 0, 1, 0, NULL, 11, '', ''),
(5715, '1289789677', '食品伙伴网', 'http://www.foodmate.net', 0, 0, 0, 4415, 0, 1, 0, NULL, 12, '', ''),
(5716, '1289789677', '国家食品药品监管局', 'http://www.sda.gov.cn/', 0, 0, 0, 4415, 0, 1, 0, NULL, 13, '', ''),
(5717, '1289789677', '中国食品财富网', 'http://www.food36.com', 0, 0, 0, 4415, 0, 1, 0, NULL, 14, '', ''),
(5718, '1289789677', '中国食品招商网', 'http://www.foodszs.com/', 0, 0, 0, 4415, 0, 1, 0, NULL, 15, '', ''),
(5719, '1289789677', '食品在线', 'http://www.foodol.org', 0, 0, 0, 4415, 0, 1, 0, NULL, 16, '', ''),
(5720, '1289789677', '中国食品展览网', 'http://www.foodce.com', 0, 0, 0, 4415, 0, 1, 0, NULL, 17, '', ''),
(5721, '1289789711', '中国工程项目网', 'http://www.gcxm.com.cn', 0, 0, 0, 4416, 0, 1, 0, NULL, 1, '', ''),
(5722, '1289789711', '中国工程预算网', 'http://www.yusuan.com/', 0, 0, 0, 4416, 0, 1, 0, NULL, 2, '', ''),
(5723, '1289789711', '工程建设网', 'http://www.hnecc.net', 0, 0, 0, 4416, 0, 1, 0, NULL, 3, '', ''),
(5724, '1289789711', '中国城市规划设计研究院', 'http://www.caupd.com.cn', 0, 0, 0, 4416, 0, 1, 0, NULL, 4, '', ''),
(5725, '1289789711', '水利工程网', 'http://www.shuigong.com', 0, 0, 0, 4416, 0, 1, 0, NULL, 5, '', ''),
(5726, '1289789711', '中国城市建设信息网', 'http://www.csjs.gov.cn', 0, 0, 0, 4416, 0, 1, 0, NULL, 6, '', ''),
(5727, '1289789731', '中国陶瓷网', 'http://www.taoci365.com/', 0, 0, 0, 4417, 0, 1, 0, NULL, 1, '', ''),
(5728, '1289789731', '中国陶瓷信息资源网', 'http://www.ccisn.com.cn', 0, 0, 0, 4417, 0, 1, 0, NULL, 2, '', ''),
(5729, '1289789731', '慧聪建筑陶瓷网', 'http://www.ceramic.hc360.com', 0, 0, 0, 4417, 0, 1, 0, NULL, 3, '', ''),
(5730, '1289789731', '中国陶瓷采购网', 'http://www.cerambuy.com/', 0, 0, 0, 4417, 0, 1, 0, NULL, 4, '', ''),
(5731, '1289789731', '德化陶瓷网-瓷贸网', 'http://www.porcelain-trade.com', 0, 0, 0, 4417, 0, 1, 0, NULL, 5, '', ''),
(5732, '1289789731', '华厦陶瓷网', 'http://www.chinachina.net', 0, 0, 0, 4417, 0, 1, 0, NULL, 6, '', ''),
(5733, '1289789731', '陶城报', 'http://www.fstcb.com', 0, 0, 0, 4417, 0, 1, 0, NULL, 7, '', ''),
(5734, '1289789731', '中国钧瓷网', 'http://www.junci2008.com', 0, 0, 0, 4417, 0, 1, 0, NULL, 8, '', ''),
(5735, '1289789752', '中国建材网', 'http://www.bmlink.com/', 0, 0, 0, 4418, 0, 1, 0, NULL, 1, '', ''),
(5736, '1289789752', '中国建材价格网', 'http://www.jc.net.cn', 0, 0, 0, 4418, 0, 1, 0, NULL, 2, '', ''),
(5737, '1289789752', '慧聪建材网', 'http://bm.hc360.com/', 0, 0, 0, 4418, 0, 1, 0, NULL, 3, '', ''),
(5738, '1289789752', '中国建材第一网', 'http://www.jc001.cn', 0, 0, 0, 4418, 0, 1, 0, NULL, 4, '', ''),
(5739, '1289789752', '国家建材网', 'http://www.chinabmnet.com/china/', 0, 0, 0, 4418, 0, 1, 0, NULL, 5, '', ''),
(5740, '1289789752', '中国建材商务网', 'http://www.c-bm.com/', 0, 0, 0, 4418, 0, 1, 0, NULL, 6, '', ''),
(5741, '1289789752', '世界建材网', 'http://www.wbmbw.com', 0, 0, 0, 4418, 0, 1, 0, NULL, 7, '', ''),
(5742, '1289789752', '世界建筑建材总网', 'http://www.cnworld.net/', 0, 0, 0, 4418, 0, 1, 0, NULL, 8, '', ''),
(5743, '1289789752', '西部建材网', 'http://www.xnjcw.com', 0, 0, 0, 4418, 0, 1, 0, NULL, 9, '', ''),
(5744, '1289789752', '绿色建材网', 'http://www.greenjc.com', 0, 0, 0, 4418, 0, 1, 0, NULL, 10, '', ''),
(5745, '1289789752', '中国建材信息总网', 'http://www.bm.cei.gov.cn/', 0, 0, 0, 4418, 0, 1, 0, NULL, 11, '', ''),
(5746, '1289789752', '诚信建材网', 'http://www.jian-cai.com', 0, 0, 0, 4418, 0, 1, 0, NULL, 12, '', ''),
(5747, '1289789752', '中国建材交易总网', 'http://www.8c8c.com.cn/', 0, 0, 0, 4418, 0, 1, 0, NULL, 13, '', ''),
(5748, '1289789752', '建材机械设备网', 'http://www.it68.net/', 0, 0, 0, 4418, 0, 1, 0, NULL, 14, '', ''),
(5749, '1289789752', '中国木材网', 'http://www.chinatimber.org', 0, 0, 0, 4418, 0, 1, 0, NULL, 15, '', ''),
(5750, '1289789752', '中国木业国际网', 'http://www.chinawood.org', 0, 0, 0, 4418, 0, 1, 0, NULL, 16, '', ''),
(5751, '1289789752', '中国木业资源网', 'http://www.ewood.cn/', 0, 0, 0, 4418, 0, 1, 0, NULL, 17, '', ''),
(5752, '1289789752', '中国木业网', 'http://www.wood365.cn/', 0, 0, 0, 4418, 0, 1, 0, NULL, 18, '', ''),
(5753, '1289789752', '鱼珠木材网', 'http://www.yuzhuwood.com/', 0, 0, 0, 4418, 0, 1, 0, NULL, 19, '', ''),
(5754, '1289789752', '中国石材第一网', 'http://www.1stone.com.cn/', 0, 0, 0, 4418, 0, 1, 0, NULL, 20, '', ''),
(5755, '1289789752', '中国水泥网', 'http://www.chinacements.com', 0, 0, 0, 4418, 0, 1, 0, NULL, 21, '', ''),
(5756, '1289789752', '中国石材频道', 'http://www.shicai.com/', 0, 0, 0, 4418, 0, 1, 0, NULL, 22, '', ''),
(5757, '1289789752', '中国石材应用网', 'http://www.stoneyy.com/', 0, 0, 0, 4418, 0, 1, 0, NULL, 23, '', ''),
(5758, '1289789752', '水泥商情网', 'http://www.snsqw.com', 0, 0, 0, 4418, 0, 1, 0, NULL, 24, '', ''),
(5759, '1289789752', '慧聪灯饰网', 'http://www.lamp.hc360.com/', 0, 0, 0, 4418, 0, 1, 0, NULL, 25, '', ''),
(5760, '1289789773', '中华人民共和国建设部', 'http://www.cin.gov.cn/', 0, 0, 0, 4419, 0, 1, 0, NULL, 1, '', ''),
(5761, '1289789773', '中国建设招标网', 'http://www.zhaobiao.gov.cn', 0, 0, 0, 4419, 0, 1, 0, NULL, 2, '', ''),
(5762, '1289789773', '阿里巴巴-建筑建材', 'http://china.alibaba.com/buy/trade/13.html', 0, 0, 0, 4419, 0, 1, 0, NULL, 3, '', ''),
(5763, '1289789773', '工成网', 'http://www.buildbook.com.cn/index.asp', 0, 0, 0, 4419, 0, 1, 0, NULL, 4, '', ''),
(5764, '1289789773', '景观中国', 'http://www.landscapecn.com', 0, 0, 0, 4419, 0, 1, 0, NULL, 5, '', ''),
(5765, '1289789773', '天工网', 'http://www.tgnet.cn/', 0, 0, 0, 4419, 0, 1, 0, NULL, 6, '', ''),
(5766, '1289789773', '中国建筑装饰网', 'http://www.ccd.com.cn', 0, 0, 0, 4419, 0, 1, 0, NULL, 7, '', ''),
(5767, '1289789773', '筑龙网', 'http://www.zhulong.com', 0, 0, 0, 4419, 0, 1, 0, NULL, 8, '', ''),
(5768, '1289789773', '中国建筑电气资讯网', 'http://www.chinabei.com', 0, 0, 0, 4419, 0, 1, 0, NULL, 9, '', ''),
(5769, '1289789773', '中国建筑与室内设计师网', 'http://www.china-designer.com', 0, 0, 0, 4419, 0, 1, 0, NULL, 10, '', ''),
(5770, '1289789773', '建筑英才网', 'http://www.buildhr.com/', 0, 0, 0, 4419, 0, 1, 0, NULL, 11, '', ''),
(5771, '1289789773', '中国建筑培训网', 'http://www.atrain.cn/', 0, 0, 0, 4419, 0, 1, 0, NULL, 12, '', ''),
(5772, '1289789773', '中国建筑劳务交易网', 'http://www.jzlw.net.cn', 0, 0, 0, 4419, 0, 1, 0, NULL, 13, '', ''),
(5773, '1289789773', '天辰建设网', 'http://www.buildnet.cn', 0, 0, 0, 4419, 0, 1, 0, NULL, 14, '', ''),
(5774, '1289789795', '国际安防网', 'http://www.isecu.cn/', 0, 0, 0, 4420, 0, 1, 0, NULL, 1, '', ''),
(5775, '1289789795', '中国安全网', 'http://www.safety.com.cn/', 0, 0, 0, 4420, 0, 1, 0, NULL, 2, '', ''),
(5776, '1289789795', '中国安防网', 'http://www.c-ps.net/', 0, 0, 0, 4420, 0, 1, 0, NULL, 3, '', ''),
(5777, '1289789795', '中安网', 'http://www.cps.com.cn/', 0, 0, 0, 4420, 0, 1, 0, NULL, 4, '', ''),
(5778, '1289789795', '安全天地网', 'http://www.szsafety.com/', 0, 0, 0, 4420, 0, 1, 0, NULL, 5, '', ''),
(5779, '1289789795', '国家安全生产监督局', 'http://www.chinasafety.gov.cn/', 0, 0, 0, 4420, 0, 1, 0, NULL, 6, '', ''),
(5780, '1289789795', '中国安全防范行业网', 'http://www.21csp.com.cn/', 0, 0, 0, 4420, 0, 1, 0, NULL, 7, '', ''),
(5781, '1289789795', '安全文化网', 'http://www.anquan.com.cn/', 0, 0, 0, 4420, 0, 1, 0, NULL, 8, '', ''),
(5782, '1289789795', '防雷技术网', 'http://www.lightning.com.cn/', 0, 0, 0, 4420, 0, 1, 0, NULL, 9, '', ''),
(5783, '1289789795', '慧聪消防网', 'http://www.fire.hc360.com', 0, 0, 0, 4420, 0, 1, 0, NULL, 10, '', ''),
(5784, '1289789795', '慧聪安防网', 'http://www.secu.hc360.com', 0, 0, 0, 4420, 0, 1, 0, NULL, 11, '', ''),
(5785, '1289789813', '中国电子技术标准化', 'http://www.cesi.ac.cn/', 0, 0, 0, 4421, 0, 1, 0, NULL, 1, '', ''),
(5786, '1289789813', '中国电子工业网', 'http://www.dianzinet.com/', 0, 0, 0, 4421, 0, 1, 0, NULL, 2, '', ''),
(5787, '1289789813', '中电网', 'http://www.chinaecnet.com/', 0, 0, 0, 4421, 0, 1, 0, NULL, 3, '', ''),
(5788, '1289789813', '电源网', 'http://www.dianyuan.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 4, '', ''),
(5789, '1289789813', '华强电子网', 'http://www.hqew.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 5, '', ''),
(5790, '1289789813', '中国维修网', 'http://www.weixiuwang.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 6, '', ''),
(5791, '1289789813', '中国电气设计师', 'http://www.dq.shejis.com/', 0, 0, 0, 4421, 0, 1, 0, NULL, 7, '', ''),
(5792, '1289789813', '中国工业电器网', 'http://www.cnelc.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 8, '', ''),
(5793, '1289789813', '中华液晶网', 'http://cn.fpdisplay.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 9, '', ''),
(5794, '1289789813', '中国工控网', 'http://www.gongkong.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 10, '', ''),
(5795, '1289789813', '阿拉丁照明网', 'http://www.alighting.cn', 0, 0, 0, 4421, 0, 1, 0, NULL, 11, '', ''),
(5796, '1289789813', '消费电子商网', 'http://www.twicechina.com/', 0, 0, 0, 4421, 0, 1, 0, NULL, 12, '', ''),
(5797, '1289789813', '中华电工电器商务网', 'http://www.chinaccm.com/38/', 0, 0, 0, 4421, 0, 1, 0, NULL, 13, '', ''),
(5798, '1289789813', '中国机电网', 'http://www.chinanics.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 14, '', ''),
(5799, '1289789813', '制造资源网', 'http://www.oemresource.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 15, '', ''),
(5800, '1289789813', '国际电子商情', 'http://www.ebnchina.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 16, '', ''),
(5801, '1289789813', '电子发烧友', 'http://www.elecfans.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 17, '', ''),
(5802, '1289789813', '中国二手设备网', 'http://www.fengj.com/', 0, 0, 0, 4421, 0, 1, 0, NULL, 18, '', ''),
(5803, '1289789813', '21IC中国电子网', 'http://www.21ic.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 19, '', ''),
(5804, '1289789813', '中国减速机信息网', 'http://www.jiansuji001.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 20, '', ''),
(5805, '1289789813', '电子查询网', 'http://www.b2bic.com', 0, 0, 0, 4421, 0, 1, 0, NULL, 21, '', ''),
(5806, '1289789813', 'LED环球在线', 'http://www.ledgb.com/', 0, 0, 0, 4421, 0, 1, 0, NULL, 22, '', ''),
(5807, '1289789813', '电子生产设备网', 'http://www.shebei114.cn', 0, 0, 0, 4421, 0, 1, 0, NULL, 23, '', ''),
(5808, '1289789813', '视频之家', 'http://www.52video.net', 0, 0, 0, 4421, 0, 1, 0, NULL, 24, '', ''),
(5809, '1289789843', '中国箱包网', 'http://china.bagsnet.com/', 0, 0, 0, 4422, 0, 1, 0, NULL, 1, '', ''),
(5810, '1289789843', '中华箱包网', 'http://www.chinabag.com.cn', 0, 0, 0, 4422, 0, 1, 0, NULL, 2, '', ''),
(5811, '1289789843', 'eBags', 'http://www.ebags.com', 0, 0, 0, 4422, 0, 1, 0, NULL, 3, '', ''),
(5812, '1289789843', '全球箱包网', 'http://www.wtobag.com/', 0, 0, 0, 4422, 0, 1, 0, NULL, 4, '', ''),
(5813, '1289789843', '包包网', 'http://www.bags163.com/', 0, 0, 0, 4422, 0, 1, 0, NULL, 5, '', ''),
(5814, '1289789863', '中华内衣网', 'http://www.ne365.com', 0, 0, 0, 4423, 0, 1, 0, NULL, 1, '', ''),
(5815, '1289789863', '中国品牌内衣网', 'http://www.ne360.net', 0, 0, 0, 4423, 0, 1, 0, NULL, 2, '', ''),
(5816, '1289789863', '哇咔内衣', 'http://www.vaakav.com/', 0, 0, 0, 4423, 0, 1, 1289790514, NULL, 3, '', ''),
(5817, '1289789881', '中国服装鞋帽网', 'http://www.fzxm.com/', 0, 0, 0, 4424, 0, 1, 0, NULL, 1, '', ''),
(5818, '1289789881', '世界服装鞋帽网', 'http://www.sjfzxm.com/', 0, 0, 0, 4424, 0, 1, 0, NULL, 2, '', ''),
(5819, '1289789881', '中国鞋业网', 'http://www.cn-shoes.net/', 0, 0, 0, 4424, 0, 1, 0, NULL, 3, '', ''),
(5820, '1289789881', '中国鞋业互联网', 'http://www.chinashoes.com', 0, 0, 0, 4424, 0, 1, 0, NULL, 4, '', ''),
(5821, '1289789881', '中国鞋网', 'http://www.cnshoes.com', 0, 0, 0, 4424, 0, 1, 0, NULL, 5, '', ''),
(5822, '1289789881', '中国鞋网cnxz.cn', 'http://www.cnxz.cn', 0, 0, 0, 4424, 0, 1, 0, NULL, 6, '', ''),
(5823, '1289789881', '搜巡鞋网', 'http://www.soxu.cn', 0, 0, 0, 4424, 0, 1, 0, NULL, 7, '', ''),
(5824, '1289789881', '国际袜都网', 'http://www.worldsocks.com', 0, 0, 0, 4424, 0, 1, 0, NULL, 8, '', ''),
(5825, '1289789881', '中国鞋业在线', 'http://www.shoeol.com/', 0, 0, 0, 4424, 0, 1, 0, NULL, 9, '', ''),
(5826, '1289789881', '慧聪制鞋网', 'http://www.shoes.hc360.com/', 0, 0, 0, 4424, 0, 1, 0, NULL, 10, '', ''),
(5853, '1279617741', '耐克', 'http://www.nike.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 1, '', ''),
(5828, '1289789920', '中国服装趋势网', 'http://www.t100.cn', 0, 0, 0, 4426, 0, 1, 0, NULL, 1, '', ''),
(5829, '1289789920', '中国服装协会', 'http://www.cnga.org.cn', 0, 0, 0, 4426, 0, 1, 0, NULL, 2, '', ''),
(5830, '1289789920', '中华服装网', 'http://www.51fashion.com.cn', 0, 0, 0, 4426, 0, 1, 0, NULL, 3, '', ''),
(5831, '1289789920', '中国品牌服装网', 'http://www.china-ef.com', 0, 0, 0, 4426, 0, 1, 0, NULL, 4, '', ''),
(5832, '1289789920', '中国女装网', 'http://www.nz86.com/', 0, 0, 0, 4426, 0, 1, 0, NULL, 5, '', ''),
(5833, '1289789920', '中国牛仔服装网', 'http://www.511340.com', 0, 0, 0, 4426, 0, 1, 0, NULL, 6, '', ''),
(5834, '1289789920', '慧聪服装网', 'http://www.cloth.hc360.com', 0, 0, 0, 4426, 0, 1, 0, NULL, 7, '', ''),
(5835, '1289789920', '衣服网', 'http://www.yifu.com', 0, 0, 0, 4426, 0, 1, 0, NULL, 8, '', ''),
(5836, '1289789920', '中国服装招商网', 'http://www.f168z.com', 0, 0, 0, 4426, 0, 1, 0, NULL, 9, '', ''),
(5837, '1289789920', '中国纺织服饰网', 'http://www.wears.com.cn', 0, 0, 0, 4426, 0, 1, 0, NULL, 10, '', ''),
(5838, '1289789920', '中国纺织服装网', 'http://www.bcnq.com', 0, 0, 0, 4426, 0, 1, 0, NULL, 11, '', ''),
(5839, '1289789920', '中国纺织网', 'http://www.texnet.com.cn/', 0, 0, 0, 4426, 0, 1, 0, NULL, 12, '', ''),
(5840, '1289789920', '世界时装网', 'http://fashion.icxo.com', 0, 0, 0, 4426, 0, 1, 0, NULL, 13, '', ''),
(5841, '1289789920', '时尚服装网', 'http://www.cnwear.com/', 0, 0, 0, 4426, 0, 1, 0, NULL, 14, '', ''),
(5842, '1289789920', '中国缝制设备网', 'http://www.sewworld.com', 0, 0, 0, 4426, 0, 1, 0, NULL, 15, '', ''),
(5843, '1289789920', '瑞丽女性-服饰频道', 'http://www.rayli.com.cn/fashion', 0, 0, 0, 4426, 0, 1, 0, NULL, 16, '', ''),
(5844, '1289789920', 'ELLE时尚潮流', 'http://www.ellechina.com', 0, 0, 0, 4426, 0, 1, 0, NULL, 17, '', ''),
(5845, '1289789920', '全球服装报价网', 'http://www.qqfzbj.com', 0, 0, 0, 4426, 0, 1, 0, NULL, 18, '', ''),
(5846, '1289789920', '中华童装网', 'http://www.e-ccdc.com', 0, 0, 0, 4426, 0, 1, 0, NULL, 19, '', ''),
(5847, '1289789920', '中国童装网', 'http://www.51kids.com/', 0, 0, 0, 4426, 0, 1, 0, NULL, 20, '', ''),
(5848, '1289789920', '倾城旗袍网', 'http://www.hercity.com/', 0, 0, 0, 4426, 0, 1, 0, NULL, 21, '', ''),
(5849, '1289789920', '中国裤子网', 'http://www.zgkz.cn/', 0, 0, 0, 4426, 0, 1, 0, NULL, 22, '', ''),
(7853, '1289802154', '北京人事人才信息网', 'http://www.bjp.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 3, '', ''),
(5851, '1289789920', '中国童装品牌网', 'http://www.61kids.com.cn', 0, 0, 0, 4426, 0, 1, 0, NULL, 24, '', ''),
(5852, '1289789920', '中国服装款式网', 'http://www.yfu.cn/', 0, 0, 0, 4426, 0, 1, 0, NULL, 25, '', ''),
(5854, '1279617741', '李宁', 'http://www.li-ning.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 2, '', ''),
(5855, '1279617741', '波司登', 'http://www.bosideng.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 3, '', ''),
(5856, '1279617741', '海盗船', 'http://www.pirateship.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 4, '', ''),
(5857, '1279617741', '歌莉娅', 'http://www.goelia.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 5, '', ''),
(5858, '1279617741', '谢瑞麟', 'http://www.tsljewellery.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 6, '', ''),
(5859, '1279617741', '阿迪达斯', 'http://www.adidas.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 7, '', ''),
(5860, '1279617741', '匡威', 'http://www.converse.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 8, '', ''),
(5861, '1279617741', '真维斯', 'http://www.jeanswest.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 9, '', ''),
(5862, '1279617741', '优衣库', 'http://www.uniqlo.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 10, '', ''),
(5863, '1279617741', '艾格', 'http://www.etam.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 11, '', ''),
(5864, '1279617741', '班尼路', 'http://www.baleno.com.hk/', 0, 0, 0, 3060, 0, 1, 0, NULL, 12, '', ''),
(5865, '1279617741', '海澜之家', 'http://www.heilanhome.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 13, '', ''),
(5866, '1279617741', '美津浓', 'http://www.mizuno.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 14, '', ''),
(5867, '1279617741', '金利来', 'http://www.goldlion-china.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 15, '', ''),
(5868, '1279617741', '丽婴房', 'http://www.phland.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 16, '', ''),
(5869, '1279617741', 'Levis', 'http://www.levi.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 17, '', ''),
(5870, '1279617741', 'The North Face', 'http://www.thenorthface.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 18, '', ''),
(5871, '1279617741', '彪马-Puma', 'http://www.puma.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 19, '', ''),
(5872, '1279617741', '安踏', 'http://www.anta.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 20, '', ''),
(5873, '1279617741', '百丽', 'http://www.belle.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 21, '', ''),
(5874, '1279617741', '西铁城', 'http://www.citizen.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 22, '', ''),
(5875, '1279617741', '美特斯邦威', 'http://www.metersbonwe.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 23, '', ''),
(5876, '1279617741', 'coach', 'http://www.coach.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 24, '', ''),
(5877, '1279617741', '佐丹奴', 'http://www.e-giordano.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 25, '', ''),
(5878, '1279617741', '361度', 'http://www.361sport.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 26, '', ''),
(5879, '1279617741', 'h&m', 'http://www.hm.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 27, '', ''),
(5880, '1279617741', '爱马仕', 'http://www.hermes.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 28, '', ''),
(5881, '1279617741', '七匹狼', 'http://www.septwolves.com/', 0, 0, 0, 3060, 0, 1, 0, NULL, 29, '', ''),
(5882, '1279617741', '马克华菲', 'http://www.fairwhale.com.cn/', 0, 0, 0, 3060, 0, 1, 0, NULL, 30, '', ''),
(5883, '1279617741', '肯德基', 'http://www.kfc.com.cn/', 0, 0, 0, 3061, 0, 1, 0, NULL, 1, '', ''),
(5884, '1279617741', '呷哺呷哺', 'http://www.xiabu.com/', 0, 0, 0, 3061, 0, 1, 0, NULL, 2, '', ''),
(5885, '1279617741', '星巴克', 'http://www.starbucks.cn/', 0, 0, 0, 3061, 0, 1, 0, NULL, 3, '', ''),
(5886, '1279617741', '可口可乐', 'http://www.icoke.cn/', 0, 0, 0, 3061, 0, 1, 0, NULL, 4, '', ''),
(5887, '1279617741', '蒙牛', 'http://www.mengniu.com.cn/', 0, 0, 0, 3061, 0, 1, 0, NULL, 5, '', ''),
(5888, '1279617741', '真功夫', 'http://www.zkungfu.com/', 0, 0, 0, 3061, 0, 1, 0, NULL, 6, '', ''),
(5889, '1279617741', '麦当劳', 'http://www.mcdonalds.com.cn/', 0, 0, 0, 3061, 0, 1, 0, NULL, 7, '', ''),
(5890, '1279617741', '永和大王', 'http://www.yonghe.com.cn/', 0, 0, 0, 3061, 0, 1, 0, NULL, 8, '', ''),
(5891, '1279617741', '棒约翰', 'http://www.papajohnschina.com/', 0, 0, 0, 3061, 0, 1, 0, NULL, 9, '', ''),
(5892, '1279617741', '德克士', 'http://www.dicos.com.cn/', 0, 0, 0, 3061, 0, 1, 0, NULL, 10, '', ''),
(5893, '1279617741', '伊利', 'http://www.yili.com/', 0, 0, 0, 3061, 0, 1, 0, NULL, 11, '', ''),
(5894, '1279617741', '金钱豹', 'http://www.goldenjaguar.com/chs/default.aspx', 0, 0, 0, 3061, 0, 1, 0, NULL, 12, '', ''),
(5895, '1279617741', '美宝莲', 'http://www.maybellinechina.com/', 0, 0, 0, 3062, 0, 1, 0, NULL, 1, '', ''),
(5896, '1279617741', '丝芙兰', 'http://www.sephora.cn/', 0, 0, 0, 3062, 0, 1, 0, NULL, 2, '', ''),
(5897, '1279617741', '欧莱雅', 'http://www.lorealchina.com/', 0, 0, 0, 3062, 0, 1, 0, NULL, 3, '', ''),
(5898, '1279617741', '资生堂-Shiseido', 'http://www.shiseidochina.com/', 0, 0, 0, 3062, 0, 1, 0, NULL, 4, '', ''),
(5899, '1279617741', '雅诗兰黛', 'http://www.esteelauder.com.cn/', 0, 0, 0, 3062, 0, 1, 0, NULL, 5, '', ''),
(5900, '1279617741', '佰草集', 'http://www.herborist.com.cn/', 0, 0, 0, 3062, 0, 1, 0, NULL, 6, '', ''),
(5901, '1279617741', '海飞丝', 'http://www.head-shoulders.com.cn/', 0, 0, 0, 3063, 0, 1, 0, NULL, 1, '', ''),
(5902, '1279617741', '屈臣氏', 'http://www.watsons.com.cn/', 0, 0, 0, 3063, 0, 1, 0, NULL, 2, '', ''),
(5903, '1279617741', '沙宣', 'http://www.vs.com.cn/', 0, 0, 0, 3063, 0, 1, 0, NULL, 3, '', ''),
(5904, '1279617741', '宝洁', 'http://www.pg.com.cn/', 0, 0, 0, 3063, 0, 1, 0, NULL, 4, '', ''),
(5905, '1279617741', '丝宝集团', 'http://www.c-bons.com.cn/', 0, 0, 0, 3063, 0, 1, 0, NULL, 5, '', ''),
(5906, '1279617741', '同仁堂', 'http://www.tongrentang.com/', 0, 0, 0, 3063, 0, 1, 0, NULL, 6, '', ''),
(5907, '1279617741', '创维', 'http://www.skyworth.com/cn/', 0, 0, 0, 3064, 0, 1, 0, NULL, 1, '', ''),
(5908, '1279617741', '索尼', 'http://www.sony.com.cn/', 0, 0, 0, 3064, 0, 1, 0, NULL, 2, '', ''),
(5909, '1279617741', '西门子', 'http://www.siemens.com.cn/', 0, 0, 0, 3064, 0, 1, 0, NULL, 3, '', ''),
(5910, '1279617741', '海信', 'http://www.hisense.com/', 0, 0, 0, 3064, 0, 1, 0, NULL, 4, '', ''),
(5911, '1279617741', '九阳', 'http://www.joyoung.com.cn/', 0, 0, 0, 3064, 0, 1, 0, NULL, 5, '', ''),
(5912, '1279617741', '新飞', 'http://www.xinfei.com/', 0, 0, 0, 3064, 0, 1, 0, NULL, 6, '', ''),
(5913, '1279617741', '美的', 'http://www.midea.com.cn/', 0, 0, 0, 3064, 0, 1, 0, NULL, 7, '', ''),
(5914, '1279617741', '三星', 'http://www.samsung.com.cn/', 0, 0, 0, 3064, 0, 1, 0, NULL, 8, '', ''),
(5915, '1279617741', '康佳', 'http://www.konka.com/', 0, 0, 0, 3064, 0, 1, 0, NULL, 9, '', ''),
(5916, '1279617741', '伊莱克斯', 'http://www.electrolux.com.cn/', 0, 0, 0, 3064, 0, 1, 0, NULL, 10, '', ''),
(5917, '1279617741', '东芝', 'http://www.toshiba.com.cn/', 0, 0, 0, 3064, 0, 1, 0, NULL, 11, '', ''),
(5918, '1279617741', '格兰仕', 'http://www.galanz.com.cn/', 0, 0, 0, 3064, 0, 1, 0, NULL, 12, '', ''),
(5919, '1289790161', '中国农业机械网', 'http://www.nyjx.cn/', 0, 0, 0, 4427, 0, 1, 0, NULL, 1, '', ''),
(5920, '1289790161', '中国农机总网', 'http://www.nongjiwang.com/', 0, 0, 0, 4427, 0, 1, 0, NULL, 2, '', ''),
(5921, '1289790161', '中国农业机械学会', 'http://www.agro-csam.org/', 0, 0, 0, 4427, 0, 1, 0, NULL, 3, '', ''),
(5922, '1289790161', '中国农业机械化信息网', 'http://www.amic.agri.gov.cn/', 0, 0, 0, 4427, 0, 1, 0, NULL, 4, '', ''),
(5923, '1289790179', '中国饲料行业信息网', 'http://www.feedtrade.com.cn/', 0, 0, 0, 4428, 0, 1, 0, NULL, 1, '', ''),
(5924, '1289790179', '中国饲料在线', 'http://www.chinafeedonline.com/china/index.jsp', 0, 0, 0, 4428, 0, 1, 0, NULL, 2, '', ''),
(5925, '1289790179', '中国饲料技术网', 'http://www.feedtech.com.cn/', 0, 0, 0, 4428, 0, 1, 0, NULL, 3, '', ''),
(5926, '1289790179', '中国饲料工业信息网', 'http://www.chinafeed.org.cn/', 0, 0, 0, 4428, 0, 1, 0, NULL, 4, '', ''),
(5927, '1289790179', '中国汇易饲料咨询网', 'http://www.chinajci.com/default.asp', 0, 0, 0, 4428, 0, 1, 0, NULL, 5, '', ''),
(5928, '1289790179', '益农网', 'http://www.efeedlink.com.cn/', 0, 0, 0, 4428, 0, 1, 0, NULL, 6, '', ''),
(5929, '1289790179', '饲料添加剂信息网', 'http://www.chinafeedadditive.com/', 0, 0, 0, 4428, 0, 1, 0, NULL, 7, '', ''),
(5930, '1289790179', '南方饲料信息网', 'http://www.sfe.net.cn/', 0, 0, 0, 4428, 0, 1, 0, NULL, 8, '', ''),
(5931, '1289790196', '中国农资网', 'http://www.ampcn.com/', 0, 0, 0, 4429, 0, 1, 0, NULL, 1, '', ''),
(5932, '1289790196', '种子中国', 'http://www.zhongzi.net/', 0, 0, 0, 4429, 0, 1, 0, NULL, 2, '', ''),
(5933, '1289790196', '慧聪农化网', 'http://www.nong-zi.com/', 0, 0, 0, 4429, 0, 1, 0, NULL, 3, '', ''),
(5934, '1289790196', '中国化肥信息网', 'http://www.china-fertinfo.com.cn/', 0, 0, 0, 4429, 0, 1, 0, NULL, 4, '', ''),
(5935, '1289790196', '中国化肥网', 'http://www.ferinfo.com/', 0, 0, 0, 4429, 0, 1, 0, NULL, 5, '', ''),
(5936, '1289790196', '中国农药信息网', 'http://www.chinapesticide.gov.cn/', 0, 0, 0, 4429, 0, 1, 0, NULL, 6, '', ''),
(5937, '1289790196', '中国农药网', 'http://www.agrichem.cn/', 0, 0, 0, 4429, 0, 1, 0, NULL, 7, '', ''),
(5938, '1289790196', '农博种业', 'http://seed.aweb.com.cn/', 0, 0, 0, 4429, 0, 1, 0, NULL, 8, '', ''),
(5939, '1289790215', '中华名优土特产网', 'http://www.myttc.cn/', 0, 0, 0, 4430, 0, 1, 0, NULL, 1, '', ''),
(5940, '1289790215', '中华粮网', 'http://www.cngrain.com/', 0, 0, 0, 4430, 0, 1, 0, NULL, 2, '', ''),
(5941, '1289790215', '中国棉花信息网', 'http://www.cottonchina.org/', 0, 0, 0, 4430, 0, 1, 0, NULL, 3, '', ''),
(5942, '1289790215', '中国花生网', 'http://www.cnpeanut.com/', 0, 0, 0, 4430, 0, 1, 0, NULL, 4, '', ''),
(5943, '1289790215', '中国枣网', 'http://www.zao.com.cn/', 0, 0, 0, 4430, 0, 1, 0, NULL, 5, '', ''),
(5944, '1289790215', '中国大豆网', 'http://www.dadou.cn/', 0, 0, 0, 4430, 0, 1, 0, NULL, 6, '', ''),
(5945, '1289790215', '中国水稻信息网', 'http://www.chinariceinfo.com/', 0, 0, 0, 4430, 0, 1, 0, NULL, 7, '', ''),
(5946, '1289790215', '中国玉米市场网', 'http://www.ex-starch.com/', 0, 0, 0, 4430, 0, 1, 0, NULL, 8, '', ''),
(5947, '1289790215', '中国棉花网', 'http://www.cncotton.com/', 0, 0, 0, 4430, 0, 1, 0, NULL, 9, '', ''),
(5948, '1289790215', '中国花生商务网', 'http://www.114665.cn/', 0, 0, 0, 4430, 0, 1, 0, NULL, 10, '', ''),
(5949, '1289790234', '农博水产', 'http://fishery.aweb.com.cn/', 0, 0, 0, 4431, 0, 1, 0, NULL, 1, '', ''),
(5950, '1289790234', '中国渔业网', 'http://www.yyew.com/', 0, 0, 0, 4431, 0, 1, 0, NULL, 2, '', ''),
(5951, '1289790234', '中国水产门户网', 'http://www.bbwfish.com', 0, 0, 0, 4431, 0, 1, 0, NULL, 3, '', ''),
(5952, '1289790234', '中国水产养殖网', 'http://www.shuichan.cc', 0, 0, 0, 4431, 0, 1, 0, NULL, 4, '', ''),
(5953, '1289790255', '中国花木网', 'http://www.cnhm.net/', 0, 0, 0, 4432, 0, 1, 0, NULL, 1, '', ''),
(5954, '1289790255', '国家林业局', 'http://www.forestry.gov.cn/', 0, 0, 0, 4432, 0, 1, 0, NULL, 2, '', ''),
(5955, '1289790255', '中国林业信息网', 'http://www.lknet.ac.cn/', 0, 0, 0, 4432, 0, 1, 0, NULL, 3, '', ''),
(5956, '1289790255', '中国苗木绿化网', 'http://www.yxmm.com', 0, 0, 0, 4432, 0, 1, 0, NULL, 4, '', ''),
(5957, '1289790255', '中国苗木价格网', 'http://www.cqtree.net/', 0, 0, 0, 4432, 0, 1, 0, NULL, 5, '', ''),
(5958, '1289790275', '中国养殖网', 'http://www.chinabreed.com', 0, 0, 0, 4433, 0, 1, 0, NULL, 1, '', ''),
(5959, '1289790275', '中国畜牧业信息网', 'http://www.caaa.cn/', 0, 0, 0, 4433, 0, 1, 0, NULL, 2, '', ''),
(5960, '1289790275', '中国养殖商务网', 'http://www.yangzhi.com/', 0, 0, 0, 4433, 0, 1, 0, NULL, 3, '', ''),
(5961, '1289790275', '中华畜牧业信息网', 'http://www.cnxmy.com', 0, 0, 0, 4433, 0, 1, 0, NULL, 4, '', ''),
(5962, '1289790275', '博亚和讯', 'http://www.boyar.cn/', 0, 0, 0, 4433, 0, 1, 0, NULL, 5, '', ''),
(5963, '1289790275', '中国牧业网', 'http://www.china-ah.com', 0, 0, 0, 4433, 0, 1, 0, NULL, 6, '', ''),
(5964, '1289790275', '养殖网', 'http://www.yangzhi.net', 0, 0, 0, 4433, 0, 1, 0, NULL, 7, '', ''),
(5965, '1289790275', '中国畜牧兽医在线', 'http://www.cnaho.com', 0, 0, 0, 4433, 0, 1, 0, NULL, 8, '', ''),
(5966, '1289790275', '西部畜牧网', 'http://www.xbxmw.com/', 0, 0, 0, 4433, 0, 1, 0, NULL, 9, '', ''),
(5967, '1289790275', '中华猪网', 'http://www.zhuw365.com', 0, 0, 0, 4433, 0, 1, 0, NULL, 10, '', ''),
(5968, '1289790275', '中国禽病网', 'http://www.qinbing.cn', 0, 0, 0, 4433, 0, 1, 0, NULL, 11, '', ''),
(5969, '1289790275', '中国牛羊网', 'http://www.niuyang.cc', 0, 0, 0, 4433, 0, 1, 0, NULL, 12, '', ''),
(5970, '1289790275', '猪病新干线', 'http://www.zbxgx.com', 0, 0, 0, 4433, 0, 1, 0, NULL, 13, '', ''),
(5971, '1289790275', '特色养殖', 'http://www.70ee.com', 0, 0, 0, 4433, 0, 1, 0, NULL, 14, '', ''),
(5972, '1289790275', '中原畜牧网', 'http://www.hnfeed.com/', 0, 0, 0, 4433, 0, 1, 0, NULL, 15, '', ''),
(5973, '1289790295', '中国农业信息网', 'http://www.agri.gov.cn', 0, 0, 0, 4434, 0, 1, 0, NULL, 1, '', ''),
(5974, '1289790295', '新农网', 'http://www.xinnong.com/', 0, 0, 0, 4434, 0, 1, 0, NULL, 2, '', ''),
(5975, '1289790295', '阿里巴巴-农业', 'http://china.alibaba.com/buy/trade/1.html', 0, 0, 0, 4434, 0, 1, 0, NULL, 3, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(5976, '1289790295', '农博网', 'http://www.aweb.com.cn/', 0, 0, 0, 4434, 0, 1, 0, NULL, 4, '', ''),
(5977, '1289790295', '农村信息网', 'http://www.12582.com/', 0, 0, 0, 4434, 0, 1, 0, NULL, 5, '', ''),
(5978, '1289790295', '农村网', 'http://www.nocn.com.cn/', 0, 0, 0, 4434, 0, 1, 0, NULL, 6, '', ''),
(5979, '1289790295', '中国农业网', 'http://www.zgny.com.cn', 0, 0, 0, 4434, 0, 1, 0, NULL, 7, '', ''),
(5980, '1289790295', '金农网', 'http://www.jinnong.cn/', 0, 0, 0, 4434, 0, 1, 0, NULL, 8, '', ''),
(5981, '1289790295', '中国粮食信息网', 'http://www.grain.gov.cn/', 0, 0, 0, 4434, 0, 1, 0, NULL, 9, '', ''),
(5982, '1289790295', '松际农网', 'http://www.99sj.com/', 0, 0, 0, 4434, 0, 1, 0, NULL, 10, '', ''),
(5983, '1289790295', '中农网', 'http://www.ap88.com/', 0, 0, 0, 4434, 0, 1, 0, NULL, 11, '', ''),
(5984, '1289790295', '旭农网', 'http://www.nong365.com', 0, 0, 0, 4434, 0, 1, 0, NULL, 12, '', ''),
(5985, '1289790295', '中国兴农网', 'http://www.cnan.gov.cn', 0, 0, 0, 4434, 0, 1, 0, NULL, 13, '', ''),
(5986, '1289790295', '中国新农村建设网', 'http://www.xyjj.org.cn', 0, 0, 0, 4434, 0, 1, 0, NULL, 14, '', ''),
(5987, '1289790295', '三农科技服务网', 'http://3n.gxsti.net/', 0, 0, 0, 4434, 0, 1, 0, NULL, 15, '', ''),
(5988, '1289790295', '北国农网', 'http://www.db-nw.com', 0, 0, 0, 4434, 0, 1, 0, NULL, 16, '', ''),
(5989, '1289790295', '中国价格信息网', 'http://www.chinaprice.gov.cn/', 0, 0, 0, 4434, 0, 1, 0, NULL, 17, '', ''),
(5990, '1289790295', '中国食用油网', 'http://www.oil86.com', 0, 0, 0, 4434, 0, 1, 0, NULL, 18, '', ''),
(5991, '1289790295', '中越农资网', 'http://www.cv-nz.com/index.html?currently=home', 0, 0, 0, 4434, 0, 1, 0, NULL, 19, '', ''),
(5992, '1289790295', '中国农牧网', 'http://www.nm18.com', 0, 0, 0, 4434, 0, 1, 0, NULL, 20, '', ''),
(5993, '1289790320', '中国会展网', 'http://www.expo-china.com', 0, 0, 0, 4435, 0, 1, 0, NULL, 1, '', ''),
(5994, '1289790320', '中国商务会展网', 'http://www.51wzst.com', 0, 0, 0, 4435, 0, 1, 0, NULL, 2, '', ''),
(5995, '1289790320', '中国会展在线', 'http://www.cce.net.cn/', 0, 0, 0, 4435, 0, 1, 0, NULL, 3, '', ''),
(5996, '1289790320', '环球商展网', 'http://fair.mofcom.gov.cn/', 0, 0, 0, 4435, 0, 1, 0, NULL, 4, '', ''),
(5997, '1289790320', '阿里巴巴-展会网', 'http://expo.china.alibaba.com/', 0, 0, 0, 4435, 0, 1, 0, NULL, 5, '', ''),
(5998, '1289790320', '世博网', 'http://www.expo2010china.com/', 0, 0, 0, 4435, 0, 1, 0, NULL, 6, '', ''),
(5999, '1289790320', '国展网', 'http://www.ciec.com.cn/', 0, 0, 0, 4435, 0, 1, 0, NULL, 7, '', ''),
(6000, '1289790320', '华采会展', 'http://fair.cbiq.com/', 0, 0, 0, 4435, 0, 1, 0, NULL, 8, '', ''),
(6001, '1289790335', '济南信息港', 'http://www.online.jn.sd.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 1, '', ''),
(6002, '1289790335', '鲁中网', 'http://www.lznews.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 2, '', ''),
(6003, '1289790335', '烟台水母网', 'http://www.shm.com.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 3, '', ''),
(6004, '1289790335', '半岛网', 'http://www.bandao.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 4, '', ''),
(6005, '1289790335', '青岛信息港', 'http://www.qd.sd.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 5, '', ''),
(6006, '1289790335', '烟台热线', 'http://www.ytcnc.net/', 0, 0, 0, 4151, 0, 1, 0, NULL, 6, '', ''),
(6007, '1289790335', '威海信息港', 'http://www.whinfo.net.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 7, '', ''),
(6008, '1289790335', '日照信息港', 'http://www.rizhao.net/', 0, 0, 0, 4151, 0, 1, 0, NULL, 8, '', ''),
(6009, '1289790335', '潍坊信息港', 'http://www.wfinfo.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 9, '', ''),
(6010, '1289790335', '中华泰山网', 'http://www.my0538.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 10, '', ''),
(6011, '1289790335', '淄博信息港', 'http://www.zbinfo.net/', 0, 0, 0, 4151, 0, 1, 0, NULL, 11, '', ''),
(6012, '1289790335', '临沂信息港', 'http://www.ly169.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 12, '', ''),
(6013, '1289790335', '诸城信息港', 'http://www.zcinfo.net/', 0, 0, 0, 4151, 0, 1, 0, NULL, 13, '', ''),
(6014, '1289790335', '鲁北热线', 'http://www.dzcnc.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 14, '', ''),
(6015, '1289790335', '泰安信息港', 'http://www.tainfo.net/', 0, 0, 0, 4151, 0, 1, 0, NULL, 15, '', ''),
(6016, '1289790335', '菏泽信息港', 'http://www.heze.cc/', 0, 0, 0, 4151, 0, 1, 0, NULL, 16, '', ''),
(6017, '1289790335', '莱芜信息港', 'http://www.lwinfo.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 17, '', ''),
(6018, '1289790335', '莱西信息港', 'http://www.laixi.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 18, '', ''),
(6019, '1289790335', '东营信息港', 'http://www.dongying.com.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 19, '', ''),
(6020, '1289790335', '文登之窗', 'http://www.whwd.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 20, '', ''),
(6021, '1289790335', '新视听', 'http://www.jnnc.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 21, '', ''),
(6022, '1289790335', '日照百事通', 'http://www.rz168.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 22, '', ''),
(6023, '1289790335', '枣庄信息港', 'http://www.zaozhuang.com.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 23, '', ''),
(6024, '1289790335', '临沂在线', 'http://www.lywww.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 24, '', ''),
(6025, '1289790335', '胶南信息港', 'http://www.jiaonan.net/', 0, 0, 0, 4151, 0, 1, 0, NULL, 25, '', ''),
(6026, '1289790335', '黄岛信息港', 'http://www.hdxxg.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 26, '', ''),
(6027, '1289790335', '临朐信息港', 'http://www.lqinfo.net.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 27, '', ''),
(6028, '1289790335', '蓬莱信息港', 'http://www.penglai.com.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 28, '', ''),
(6029, '1289790335', '济宁信息港', 'http://ji-www.sd.cninfo.net/', 0, 0, 0, 4151, 0, 1, 0, NULL, 29, '', ''),
(6030, '1289790335', '胶南信息网', 'http://www.jiaonan.tv/', 0, 0, 0, 4151, 0, 1, 0, NULL, 30, '', ''),
(6031, '1289790335', '莱芜都市网', 'http://www.0634.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 31, '', ''),
(6032, '1289790335', '莱芜在线', 'http://www.laiwu.net/', 0, 0, 0, 4151, 0, 1, 0, NULL, 32, '', ''),
(6033, '1289790335', '滨州信息港', 'http://www.bz169.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 33, '', ''),
(6034, '1289790335', '即墨信息港', 'http://www.qdjimo.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 34, '', ''),
(6035, '1289790335', '潍坊新闻网', 'http://www.wfnews.com.cn/', 0, 0, 0, 4151, 0, 1, 0, NULL, 35, '', ''),
(6036, '1289790335', '青岛开发区信息港', 'http://www.qingkai.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 36, '', ''),
(6037, '1289790335', '曲阜123', 'http://www.qufu123.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 37, '', ''),
(6038, '1289790335', '德州之窗', 'http://www.dzwindows.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 38, '', ''),
(6039, '1289790335', '黄河口信息港', 'http://www.hhk365.com/', 0, 0, 0, 4151, 0, 1, 0, NULL, 39, '', ''),
(6040, '1289790342', '经理世界网', 'http://www.ceocio.com.cn/', 0, 0, 0, 4436, 0, 1, 0, NULL, 1, '', ''),
(6041, '1289790342', '财富-FORTUNE', 'http://www.fortunechina.com/', 0, 0, 0, 4436, 0, 1, 0, NULL, 2, '', ''),
(6042, '1289790342', '财经网', 'http://www.caijing.com.cn/', 0, 0, 0, 4436, 0, 1, 0, NULL, 3, '', ''),
(6043, '1289790342', '商业时代', 'http://www.ectime.com.cn/', 0, 0, 0, 4436, 0, 1, 0, NULL, 4, '', ''),
(6044, '1289790342', '商业周刊', 'http://www.businessweekchina.com/', 0, 0, 0, 4436, 0, 1, 0, NULL, 5, '', ''),
(6045, '1289790342', '华尔街日报', 'http://chinese.wsj.com/', 0, 0, 0, 4436, 0, 1, 0, NULL, 6, '', ''),
(6046, '1289790342', '中国经营报', 'http://www.cb.com.cn/', 0, 0, 0, 4436, 0, 1, 0, NULL, 7, '', ''),
(6047, '1289790356', '齐鲁热线', 'http://www.sdinfo.net/', 0, 0, 0, 4152, 0, 1, 0, NULL, 1, '', ''),
(6048, '1289790356', '大众网', 'http://www.dzwww.com/', 0, 0, 0, 4152, 0, 1, 0, NULL, 2, '', ''),
(6049, '1289790356', '齐鲁晚报', 'http://www.qlwb.com.cn/', 0, 0, 0, 4152, 0, 1, 0, NULL, 3, '', ''),
(6050, '1289790356', '青岛新闻网', 'http://www.qingdaonews.com/', 0, 0, 0, 4152, 0, 1, 0, NULL, 4, '', ''),
(6051, '1289790356', '百灵网', 'http://www.beelink.com/', 0, 0, 0, 4152, 0, 1, 0, NULL, 5, '', ''),
(6052, '1289790356', '山东新闻网', 'http://www.sdnews.com.cn/', 0, 0, 0, 4152, 0, 1, 0, NULL, 6, '', ''),
(6053, '1289790356', '胶东在线', 'http://www.jiaodong.net/', 0, 0, 0, 4152, 0, 1, 0, NULL, 7, '', ''),
(6054, '1289790356', '日照新闻网', 'http://www.rznews.cn/', 0, 0, 0, 4152, 0, 1, 0, NULL, 8, '', ''),
(6055, '1289790356', '舜网', 'http://www.e23.cn/', 0, 0, 0, 4152, 0, 1, 0, NULL, 9, '', ''),
(6056, '1289790356', '威海新闻网', 'http://www.whnews.cn/', 0, 0, 0, 4152, 0, 1, 0, NULL, 10, '', ''),
(6057, '1289790356', '济宁新闻网', 'http://www.jn001.com/', 0, 0, 0, 4152, 0, 1, 0, NULL, 11, '', ''),
(6058, '1289790356', '齐鲁网', 'http://www.iqilu.com/', 0, 0, 0, 4152, 0, 1, 0, NULL, 12, '', ''),
(6059, '1289790356', '青岛传媒网', 'http://www.qingdaomedia.com/', 0, 0, 0, 4152, 0, 1, 0, NULL, 13, '', ''),
(6060, '1289790360', '中国商情报告网', 'http://www.chinasqbg.com/', 0, 0, 0, 4437, 0, 1, 0, NULL, 1, '', ''),
(6061, '1289790360', '中华报告网', 'http://www.ccmnet.com/', 0, 0, 0, 4437, 0, 1, 0, NULL, 2, '', ''),
(6062, '1289790360', '中国行业研究报告网', 'http://www.chinahyyj.com/', 0, 0, 0, 4437, 0, 1, 0, NULL, 3, '', ''),
(6063, '1289790360', '百度数据研究中心', 'http://data.baidu.com/', 0, 0, 0, 4437, 0, 1, 0, NULL, 4, '', ''),
(6064, '1289790360', '国讯报告网', 'http://www.gxbaogao.com/', 0, 0, 0, 4437, 0, 1, 0, NULL, 5, '', ''),
(6065, '1289790360', '中国报告大厅', 'http://www.chinabgao.com/', 0, 0, 0, 4437, 0, 1, 0, NULL, 6, '', ''),
(6066, '1289790360', '博讯报告网', 'http://www.365report.com/', 0, 0, 0, 4437, 0, 1, 0, NULL, 7, '', ''),
(6067, '1289790360', '报告直通车', 'http://www.reportbus.com', 0, 0, 0, 4437, 0, 1, 0, NULL, 8, '', ''),
(6068, '1289790360', '中国商业报告网', 'http://www.china3608.com/index.html', 0, 0, 0, 4437, 0, 1, 0, NULL, 9, '', ''),
(6069, '1289790360', '51行业报告网', 'http://www.51baogao.cn/', 0, 0, 0, 4437, 0, 1, 0, NULL, 10, '', ''),
(6070, '1289790380', '中国商务部', 'http://www.mofcom.gov.cn/', 0, 0, 0, 4438, 0, 1, 0, NULL, 1, '', ''),
(6071, '1289790380', '联商网', 'http://www.linkshop.com.cn', 0, 0, 0, 4438, 0, 1, 0, NULL, 2, '', ''),
(6072, '1289790380', '慧聪网', 'http://www.hc360.com', 0, 0, 0, 4438, 0, 1, 0, NULL, 3, '', ''),
(6073, '1289790380', '阿里巴巴', 'http://china.alibaba.com/', 0, 0, 0, 4438, 0, 1, 1289790426, NULL, 4, '', ''),
(6074, '1289790380', '沱沱网中文站', 'http://china.tootoo.com/', 0, 0, 0, 4438, 0, 1, 0, NULL, 5, '', ''),
(6075, '1289790380', '大商圈网', 'http://www.bbspace.cn/', 0, 0, 0, 4438, 0, 1, 0, NULL, 6, '', ''),
(6076, '1289790380', '搜易网', 'http://www.sooe.cn', 0, 0, 0, 4438, 0, 1, 0, NULL, 7, '', ''),
(6077, '1289790380', '中国招标网', 'http://www.bidchance.com/', 0, 0, 0, 4438, 0, 1, 0, NULL, 8, '', ''),
(6078, '1289790380', '买麦网', 'http://www.mymai.com', 0, 0, 0, 4438, 0, 1, 0, NULL, 9, '', ''),
(6079, '1289790380', '万国商业网', 'http://china.busytrade.com', 0, 0, 0, 4438, 0, 1, 0, NULL, 10, '', ''),
(6080, '1289790380', '中国投资指南', 'http://www.fdi.gov.cn', 0, 0, 0, 4438, 0, 1, 0, NULL, 11, '', ''),
(6081, '1289790380', '中国招标信息网', 'http://www.cnbidding.com/', 0, 0, 0, 4438, 0, 1, 0, NULL, 12, '', ''),
(6082, '1289790380', '中国出口贸易网', 'http://www.cnexpnet.com/', 0, 0, 0, 4438, 0, 1, 0, NULL, 13, '', ''),
(6083, '1289790380', '世界买家网', 'http://win.mofcom.gov.cn/', 0, 0, 0, 4438, 0, 1, 0, NULL, 14, '', ''),
(6084, '1289790380', '环球贸易网', 'http://www.herostart.com.cn', 0, 0, 0, 4438, 0, 1, 0, NULL, 15, '', ''),
(6085, '1289790380', '慧聪网-商务指南', 'http://www.biz.hc360.com/', 0, 0, 0, 4438, 0, 1, 0, NULL, 16, '', ''),
(6086, '1289790380', '中国品牌网', 'http://www.chinapp.com', 0, 0, 0, 4438, 0, 1, 0, NULL, 17, '', ''),
(6087, '1289790380', '新品快播网', 'http://www.npicp.com/', 0, 0, 0, 4438, 0, 1, 0, NULL, 18, '', ''),
(6088, '1289790380', '国际进出口贸易网', 'http://www.vooec.com/', 0, 0, 0, 4438, 0, 1, 0, NULL, 19, '', ''),
(6089, '1289790380', '掌商网', 'http://www.zs91.com/', 0, 0, 0, 4438, 0, 1, 0, NULL, 20, '', ''),
(6090, '1289790380', '中国厂商网', 'http://www.changshang.com/', 0, 0, 0, 4438, 0, 1, 0, NULL, 21, '', ''),
(6091, '1289790380', '中华零售网', 'http://www.i18.cn', 0, 0, 0, 4438, 0, 1, 0, NULL, 22, '', ''),
(6092, '1289790380', '中国直销专业网', 'http://www.cdsp.com.cn', 0, 0, 0, 4438, 0, 1, 0, NULL, 23, '', ''),
(6093, '1289790380', '批发指南网', 'http://www.pfzn.com/', 0, 0, 0, 4438, 0, 1, 0, NULL, 24, '', ''),
(6094, '1289790380', '中国贸易金融网', 'http://www.sinotf.com', 0, 0, 0, 4438, 0, 1, 0, NULL, 25, '', ''),
(6095, '1289790380', 'FTA自由贸易区', 'http://www.ecfta.com', 0, 0, 0, 4438, 0, 1, 0, NULL, 26, '', ''),
(6096, '1289790380', '全球贸易中心', 'http://www.global-trade-center.com', 0, 0, 0, 4438, 0, 1, 0, NULL, 27, '', ''),
(6097, '1289790399', '百度地图-济南', 'http://map.baidu.com/#word=%BC%C3%C4%CF%CA%D0&amp;amp;ct=10', 0, 0, 0, 4153, 0, 1, 0, NULL, 1, '', ''),
(6098, '1289790399', '济南公交', 'http://www.jnbus.com.cn/', 0, 0, 0, 4153, 0, 1, 0, NULL, 2, '', ''),
(6099, '1289790399', '济南国际机场', 'http://www.jnairport.com/', 0, 0, 0, 4153, 0, 1, 0, NULL, 3, '', ''),
(6100, '1289790399', '青岛机场', 'http://www.qdairport.com/', 0, 0, 0, 4153, 0, 1, 0, NULL, 4, '', ''),
(6101, '1289790399', '百度地图-青岛', 'http://map.baidu.com/#word=%C7%E0%B5%BA&amp;amp;ct=10', 0, 0, 0, 4153, 0, 1, 0, NULL, 5, '', ''),
(6102, '1289790399', '山东航空集团', 'http://www.shandongair.com.cn/', 0, 0, 0, 4153, 0, 1, 0, NULL, 6, '', ''),
(6103, '1289790399', '济南交警网', 'http://www.jnjj.com/', 0, 0, 0, 4153, 0, 1, 0, NULL, 7, '', ''),
(6104, '1289790399', '济南铁路局', 'http://www.jtkyw.com/', 0, 0, 0, 4153, 0, 1, 0, NULL, 8, '', ''),
(6105, '1289790399', '济南长途汽车站', 'http://www.jnqczz.com.cn/', 0, 0, 0, 4153, 0, 1, 0, NULL, 9, '', ''),
(6106, '1289790399', '三维济南', 'http://map.qlcity.com/', 0, 0, 0, 4153, 0, 1, 0, NULL, 10, '', ''),
(6107, '1289790399', '大众旅游网', 'http://www.dzwww.com/ly/', 0, 0, 0, 4153, 0, 1, 0, NULL, 11, '', ''),
(6108, '1289790399', '青岛新闻网旅游频道', 'http://travel.qingdaonews.com/', 0, 0, 0, 4153, 0, 1, 0, NULL, 12, '', ''),
(6109, '1289790399', '泰山信息网', 'http://www.taian.gov.cn/', 0, 0, 0, 4153, 0, 1, 0, NULL, 13, '', ''),
(6110, '1289790399', '大众点评网济南美食', 'http://www.dianping.com/jinan/food', 0, 0, 0, 4153, 0, 1, 0, NULL, 14, '', ''),
(6111, '1289790399', '青岛美食', 'http://food.qingdaonews.com/', 0, 0, 0, 4153, 0, 1, 0, NULL, 15, '', ''),
(6112, '1289790399', '搜房网济南', 'http://jn.soufun.com/', 0, 0, 0, 4153, 0, 1, 0, NULL, 16, '', ''),
(6113, '1289790399', '济南房产网', 'http://www.jnhouse.com/', 0, 0, 0, 4153, 0, 1, 0, NULL, 17, '', ''),
(6114, '1289790399', '齐鲁热线房产', 'http://sdfdc.sdinfo.net/', 0, 0, 0, 4153, 0, 1, 0, NULL, 18, '', ''),
(6115, '1289790399', '青岛房产在线', 'http://www.house.sd.cn/', 0, 0, 0, 4153, 0, 1, 0, NULL, 19, '', ''),
(6116, '1289790399', '搜房网青岛', 'http://qd.soufun.com/', 0, 0, 0, 4153, 0, 1, 0, NULL, 20, '', ''),
(6117, '1289790399', '济南住房公积金网', 'http://www.gjj.gov.cn/', 0, 0, 0, 4153, 0, 1, 0, NULL, 21, '', ''),
(6118, '1289790399', '山东省立医院', 'http://www.sph.com.cn/', 0, 0, 0, 4153, 0, 1, 0, NULL, 22, '', ''),
(6119, '1289790399', '山东大学齐鲁医院', 'http://www.qiluhospital.com/', 0, 0, 0, 4153, 0, 1, 0, NULL, 23, '', ''),
(6120, '1289790399', '山东医药价格网', 'http://www.sdyyjg.gov.cn/', 0, 0, 0, 4153, 0, 1, 0, NULL, 24, '', ''),
(6121, '1289790420', '山东大学', 'http://www.sdu.edu.cn/', 0, 0, 0, 4154, 0, 1, 0, NULL, 1, '', ''),
(6122, '1289790420', '山东理工大学', 'http://www.sdut.edu.cn/', 0, 0, 0, 4154, 0, 1, 0, NULL, 2, '', ''),
(6123, '1289790420', '中国海洋大学', 'http://www.ouc.edu.cn/', 0, 0, 0, 4154, 0, 1, 0, NULL, 3, '', ''),
(6124, '1289790420', '中国石油大学（华东）', 'http://www.upc.edu.cn/', 0, 0, 0, 4154, 0, 1, 0, NULL, 4, '', ''),
(6125, '1289790420', '山东省教育厅', 'http://www.sdedu.gov.cn/', 0, 0, 0, 4154, 0, 1, 0, NULL, 5, '', ''),
(6126, '1289790420', '青岛大学', 'http://www.qdu.edu.cn/', 0, 0, 0, 4154, 0, 1, 0, NULL, 6, '', ''),
(6127, '1289790420', '济南自考网', 'http://www.jnzk.net', 0, 0, 0, 4154, 0, 1, 0, NULL, 7, '', ''),
(6128, '1289790420', '济宁教育网', 'http://www.jnjyw.edu.cn/', 0, 0, 0, 4154, 0, 1, 0, NULL, 8, '', ''),
(6129, '1289790420', '山东教师教育网', 'http://www.sdteacher.gov.cn/', 0, 0, 0, 4154, 0, 1, 0, NULL, 9, '', ''),
(6130, '1289790420', '泰安教育网', 'http://www.taian.edu.cn/', 0, 0, 0, 4154, 0, 1, 0, NULL, 10, '', ''),
(6131, '1289790420', '山东招生信息网', 'http://www.sdzs.gov.cn/', 0, 0, 0, 4154, 0, 1, 0, NULL, 11, '', ''),
(6132, '1289790446', '搜狐山东社区', 'http://club.travel.sohu.com/list_art_sub.php?b=shandong', 0, 0, 0, 4155, 0, 1, 0, NULL, 1, '', ''),
(6133, '1289790446', '沂蒙社区', 'http://club.ly169.cn', 0, 0, 0, 4155, 0, 1, 0, NULL, 2, '', ''),
(6134, '1289790446', '青岛社区', 'http://club.qingdaonews.com/', 0, 0, 0, 4155, 0, 1, 0, NULL, 3, '', ''),
(6135, '1289790446', '大众论坛', 'http://bbs.dzwww.com/', 0, 0, 0, 4155, 0, 1, 0, NULL, 4, '', ''),
(6136, '1289790446', '半岛社区', 'http://club.bandao.cn/', 0, 0, 0, 4155, 0, 1, 0, NULL, 5, '', ''),
(6137, '1289790446', '山东贴吧', 'http://post.baidu.com/f?kw=%C9%BD%B6%AB', 0, 0, 0, 4155, 0, 1, 0, NULL, 6, '', ''),
(6138, '1289790446', '济南贴吧', 'http://post.baidu.com/f?kw=%BC%C3%C4%CF', 0, 0, 0, 4155, 0, 1, 0, NULL, 7, '', ''),
(6139, '1289790446', '青岛贴吧', 'http://post.baidu.com/f?kw=%C7%E0%B5%BA', 0, 0, 0, 4155, 0, 1, 0, NULL, 8, '', ''),
(6140, '1289790446', '胶东社区', 'http://bbs.jiaodong.net/', 0, 0, 0, 4155, 0, 1, 0, NULL, 9, '', ''),
(6141, '1289790446', '巨野论坛', 'http://www.juyebbs.com/bbs/', 0, 0, 0, 4155, 0, 1, 0, NULL, 10, '', ''),
(6142, '1289790446', '百灵社区', 'http://club.beelink.com/', 0, 0, 0, 4155, 0, 1, 0, NULL, 11, '', ''),
(6143, '1289790446', '舜网论坛', 'http://bbs.e23.cn/', 0, 0, 0, 4155, 0, 1, 0, NULL, 12, '', ''),
(6144, '1289790446', '烟台论坛', 'http://www.ytbbs.com/', 0, 0, 0, 4155, 0, 1, 0, NULL, 13, '', ''),
(6145, '1289790446', '爱威海社区', 'http://www.iweihai.cn/club/', 0, 0, 0, 4155, 0, 1, 0, NULL, 14, '', ''),
(6146, '1289790446', '济南论坛', 'http://bbs.jn8.net', 0, 0, 0, 4155, 0, 1, 0, NULL, 15, '', ''),
(6147, '1289790446', '青岛IT社区', 'http://bbs.qdit.com', 0, 0, 0, 4155, 0, 1, 0, NULL, 16, '', ''),
(6148, '1289790446', '无为论坛', 'http://www.actcn.net/', 0, 0, 0, 4155, 0, 1, 0, NULL, 17, '', ''),
(6149, '1289790446', '淄博旮旯社区', 'http://bbs.zbgl.net/', 0, 0, 0, 4155, 0, 1, 0, NULL, 18, '', ''),
(6150, '1289790446', '滨州论坛', 'http://www.bbsbz.net/', 0, 0, 0, 4155, 0, 1, 0, NULL, 19, '', ''),
(6151, '1289790446', '淄博论坛', 'http://www.zibocc.com/', 0, 0, 0, 4155, 0, 1, 0, NULL, 20, '', ''),
(6152, '1289790446', '邹平论坛', 'http://www.zpbbs.cn/', 0, 0, 0, 4155, 0, 1, 0, NULL, 21, '', ''),
(6153, '1289790446', '泰安论坛', 'http://bbs.0538.com.cn/', 0, 0, 0, 4155, 0, 1, 0, NULL, 22, '', ''),
(6154, '1289790482', '山东省政府', 'http://www.sd.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 1, '', ''),
(6155, '1289790482', '济南建设网', 'http://www.jncc.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 2, '', ''),
(6156, '1289790482', '胶南政务网', 'http://www.jiaonan.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 3, '', ''),
(6157, '1289790482', '山东食品药品管理局', 'http://www.sdfda.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 4, '', ''),
(6158, '1289790482', '济南', 'http://www.jinan.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 5, '', ''),
(6159, '1289790482', '青岛', 'http://www.qingdao.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 6, '', ''),
(6160, '1289790482', '枣庄', 'http://www.zaozhuang.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 7, '', ''),
(6161, '1289790482', '东营', 'http://www.dongying.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 8, '', ''),
(6162, '1289790482', '烟台', 'http://www.yantai.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 9, '', ''),
(6163, '1289790482', '潍坊', 'http://www.weifang.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 10, '', ''),
(6164, '1289790482', '济宁', 'http://www.jining.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 11, '', ''),
(6165, '1289790482', '泰安', 'http://www.taian.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 12, '', ''),
(6166, '1289790482', '威海', 'http://www.weihai.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 13, '', ''),
(6167, '1289790482', '日照', 'http://www.rizhao.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 14, '', ''),
(6168, '1289790482', '莱芜', 'http://www.laiwu.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 15, '', ''),
(6169, '1289790482', '临沂', 'http://www.linyi.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 16, '', ''),
(6170, '1289790482', '德州', 'http://www.dezhou.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 17, '', ''),
(6171, '1289790482', '聊城', 'http://www.liaocheng.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 18, '', ''),
(6172, '1289790482', '滨州', 'http://www.binzhou.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 19, '', ''),
(6173, '1289790482', '菏泽', 'http://www.heze.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 20, '', ''),
(6174, '1289790482', '山东省卫生厅', 'http://www.sdws.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 21, '', ''),
(6175, '1289790482', '滕州', 'http://www.tengzhou.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 22, '', ''),
(6176, '1289790482', '山东省交通厅', 'http://www.sdjt.gov.cn/index.jsp', 0, 0, 0, 4156, 0, 1, 0, NULL, 23, '', ''),
(6177, '1289790482', '山东省地方税务局', 'http://www.sdds.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 24, '', ''),
(6178, '1289790482', '曲阜', 'http://www.qufu.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 25, '', ''),
(6179, '1289790482', '济南公安服务在线', 'http://www.jnga.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 26, '', ''),
(6180, '1289790482', '山东省国家税务局', 'http://www.sd-n-tax.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 27, '', ''),
(6181, '1289790482', '山东农业信息网', 'http://www.sdny.gov.cn/', 0, 0, 0, 4156, 0, 1, 0, NULL, 28, '', ''),
(6182, '1289790482', '青岛地税电子申报系统', 'http://dec.qdds.net/', 0, 0, 0, 4156, 0, 1, 0, NULL, 29, '', ''),
(6183, '1289790482', '青岛政务网', 'http://www.qingdao.gov.cn/n172/', 0, 0, 0, 4156, 0, 1, 0, NULL, 30, '', ''),
(6239, '1279617741', '色影无忌', 'http://www.xitek.com/', 0, 0, 0, 3065, 0, 1, 0, NULL, 1, '', ''),
(6235, '1289790796', '濮阳信息港', 'http://py.shangdu.com/', 0, 0, 0, 4161, 0, 1, 0, NULL, 12, '', ''),
(6234, '1289790796', '平顶山信息港', 'http://www.pdsinfo.ha.cn/', 0, 0, 0, 4161, 0, 1, 0, NULL, 11, '', ''),
(6233, '1289790796', '新乡信息港', 'http://www.373.cn/', 0, 0, 0, 4161, 0, 1, 0, NULL, 10, '', ''),
(6232, '1289790796', '鹤壁信息港', 'http://hb.shangdu.com/', 0, 0, 0, 4161, 0, 1, 0, NULL, 9, '', ''),
(6231, '1289790796', '中原油田信息港', 'http://www.zytx.com.cn/', 0, 0, 0, 4161, 0, 1, 0, NULL, 8, '', ''),
(6230, '1289790796', '信阳信息港', 'http://xy.shangdu.com/', 0, 0, 0, 4161, 0, 1, 0, NULL, 7, '', ''),
(6229, '1289790796', '漯河信息港', 'http://www.lhinfo.ha.cn/', 0, 0, 0, 4161, 0, 1, 0, NULL, 6, '', ''),
(6228, '1289790796', '南阳信息港', 'http://www.nyinfo.ha.cn/', 0, 0, 0, 4161, 0, 1, 0, NULL, 5, '', ''),
(6227, '1289790796', '中华龙都网', 'http://www.zhld.com/', 0, 0, 0, 4161, 0, 1, 0, NULL, 4, '', ''),
(6226, '1289790796', '三门峡信息港', 'http://smx.shangdu.com/', 0, 0, 0, 4161, 0, 1, 0, NULL, 3, '', ''),
(6225, '1289790796', '洛阳信息港', 'http://ly.shangdu.com/', 0, 0, 0, 4161, 0, 1, 0, NULL, 2, '', ''),
(6224, '1289790796', '驻马店信息港', 'http://zmd.shangdu.com/', 0, 0, 0, 4161, 0, 1, 0, NULL, 1, '', ''),
(6202, '1289790651', '河南电视台', 'http://www.hntv.ha.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 1, '', ''),
(6203, '1289790651', '新浪河南', 'http://henan.sina.com.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 2, '', ''),
(6204, '1289790651', '河南文化网', 'http://www.hawh.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 3, '', ''),
(6205, '1289790651', '河南广播网', 'http://www.radiohenan.com/', 0, 0, 0, 4162, 0, 1, 0, NULL, 4, '', ''),
(6206, '1289790651', '人民网河南频道', 'http://www.hnsc.com.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 5, '', ''),
(6207, '1289790651', '新华网河南频道', 'http://www.ha.xinhuanet.com/', 0, 0, 0, 4162, 0, 1, 0, NULL, 6, '', ''),
(6208, '1289790651', '郑州日报', 'http://zzrb.zynews.com/', 0, 0, 0, 4162, 0, 1, 0, NULL, 7, '', ''),
(6209, '1289790651', '郑州晚报', 'http://zzwb.zynews.com/', 0, 0, 0, 4162, 0, 1, 0, NULL, 8, '', ''),
(6210, '1289790651', '洛阳信息港', 'http://ly.shangdu.com/', 0, 0, 0, 4162, 0, 1, 0, NULL, 9, '', ''),
(6211, '1289790651', '洛阳日报', 'http://lyrb.lyd.com.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 10, '', ''),
(6212, '1289790651', '洛阳晚报', 'http://lywb.lyd.com.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 11, '', ''),
(6213, '1289790651', '商丘网', 'http://www.sqrb.com.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 12, '', ''),
(6214, '1289790651', '三门峡日报', 'http://www.smxdaily.com.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 13, '', ''),
(6215, '1289790651', '漯河网', 'http://www.luohe.com.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 14, '', ''),
(6216, '1289790651', '周口龙都网', 'http://www.zhld.com/', 0, 0, 0, 4162, 0, 1, 0, NULL, 15, '', ''),
(6217, '1289790651', '驻马店新闻网', 'http://www.zmdnews.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 16, '', ''),
(6218, '1289790651', '信阳信息港', 'http://xy.shangdu.com/', 0, 0, 0, 4162, 0, 1, 0, NULL, 17, '', ''),
(6219, '1289790651', '中原油田信息港', 'http://www.zytx.com.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 18, '', ''),
(6220, '1289790651', '安阳信息港', 'http://www.ayinfo.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 19, '', ''),
(6221, '1289790651', '新乡信息港', 'http://www.373.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 20, '', ''),
(6222, '1289790651', '许昌信息港', 'http://www.xcinfo.ha.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 21, '', ''),
(6223, '1289790651', '焦作信息港', 'http://www.jzinfo.ha.cn/', 0, 0, 0, 4162, 0, 1, 0, NULL, 22, '', ''),
(6236, '1289790796', '许昌信息港', 'http://www.xcinfo.ha.cn/', 0, 0, 0, 4161, 0, 1, 0, NULL, 13, '', ''),
(6237, '1289790796', '鹤壁便民网', 'http://www.bm0392.com/', 0, 0, 0, 4161, 0, 1, 0, NULL, 14, '', ''),
(6238, '1289790796', '巩义搜生活网', 'http://www.gysou.com/', 0, 0, 0, 4161, 0, 1, 0, NULL, 15, '', ''),
(6240, '1279617741', '名表论坛', 'http://www.watchstore.com.cn/', 0, 0, 0, 3065, 0, 1, 0, NULL, 2, '', ''),
(6241, '1279617741', '烟悦网', 'http://www.yanyue.cn/', 0, 0, 0, 3065, 0, 1, 0, NULL, 3, '', ''),
(6242, '1279617741', '家庭影院音响论坛', 'http://www.av199.com/', 0, 0, 0, 3065, 0, 1, 0, NULL, 4, '', ''),
(6243, '1279617741', '刀友论坛', 'http://www.knifriend.com/', 0, 0, 0, 3065, 0, 1, 0, NULL, 5, '', ''),
(6244, '1279617741', '耳机大家坛', 'http://www.erji.net/', 0, 0, 0, 3065, 0, 1, 0, NULL, 6, '', ''),
(6245, '1279617741', '蜂鸟网', 'http://www.fengniao.com/', 0, 0, 0, 3065, 0, 1, 0, NULL, 7, '', ''),
(6246, '1289790996', '河南福彩', 'http://www.henanfucai.com/', 0, 0, 0, 4163, 0, 1, 0, NULL, 1, '', ''),
(6247, '1289790996', '河南体彩', 'http://www.hnlottery.com.cn/', 0, 0, 0, 4163, 0, 1, 0, NULL, 2, '', ''),
(6248, '1289790996', '河南移动', 'http://www.ha.10086.cn/', 0, 0, 0, 4163, 0, 1, 0, NULL, 3, '', ''),
(6249, '1289790996', '河南联通', 'http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010023&amp;amp;id=1173', 0, 0, 0, 4163, 0, 1, 0, NULL, 4, '', ''),
(6250, '1289790996', '河南电信', 'http://ha.ct10000.com/', 0, 0, 0, 4163, 0, 1, 0, NULL, 5, '', ''),
(6251, '1289790996', '郑州百姓网', 'http://zhengzhou.baixing.com/', 0, 0, 0, 4163, 0, 1, 0, NULL, 6, '', ''),
(6252, '1289790996', '河南医院', 'http://henan.haodf.com/', 0, 0, 0, 4163, 0, 1, 0, NULL, 7, '', ''),
(6253, '1289790996', '河南天气预报', 'http://www.weather.com.cn/html/province/henan.shtml', 0, 0, 0, 4163, 0, 1, 0, NULL, 8, '', ''),
(6254, '1289790996', '河南旅游', 'http://www.hnta.cn/', 0, 0, 0, 4163, 0, 1, 0, NULL, 9, '', ''),
(6255, '1289790996', '郑州火车站', 'http://www.zzhcz.com/', 0, 0, 0, 4163, 0, 1, 0, NULL, 10, '', ''),
(6256, '1289790996', '郑州公交查询', 'http://www.zhengzhoubus.com/', 0, 0, 0, 4163, 0, 1, 0, NULL, 11, '', ''),
(6257, '1289790996', '河南高速交警网', 'http://www.hngsjj.gov.cn/', 0, 0, 0, 4163, 0, 1, 0, NULL, 12, '', ''),
(6258, '1289790996', '交通厅', 'http://www.hncd.gov.cn/', 0, 0, 0, 4163, 0, 1, 0, NULL, 13, '', ''),
(6259, '1289791017', '郑州大学', 'http://www.zzu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 1, '', ''),
(6260, '1289791017', '河南大学', 'http://www.henu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 2, '', ''),
(6261, '1289791017', '河南财经政法大学', 'http://www.hnufe.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 3, '', ''),
(6262, '1289791017', '河南农业大学', 'http://www.henau.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 4, '', ''),
(6263, '1289791017', '河南科技大学', 'http://www.haust.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 5, '', ''),
(6264, '1289791017', '河南师范大学', 'http://www.henannu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 6, '', ''),
(6265, '1289791017', '华北水利水电学院', 'http://www.ncwu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 7, '', ''),
(6266, '1289791017', '河南理工大学', 'http://www.hpu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 8, '', ''),
(6267, '1289791017', '平顶山教育学院', 'http://www.pdsjyxy.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 9, '', ''),
(6268, '1289791017', '洛阳师范学院', 'http://www.lync.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 10, '', ''),
(6269, '1289791017', '河南科技学院', 'http://www.hist.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 11, '', ''),
(6270, '1289791017', '洛阳理工学院', 'http://www.lit.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 12, '', ''),
(6271, '1289791017', '南阳理工学院', 'http://www.nyist.net/', 0, 0, 0, 4164, 0, 1, 0, NULL, 13, '', ''),
(6272, '1289791017', '郑州轻工业学院', 'http://www.zzili.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 14, '', ''),
(6273, '1289791017', '河南机电高等专科学校', 'http://www.hneeu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 15, '', ''),
(6274, '1289791017', '河南城建学院', 'http://www.hncj.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 16, '', ''),
(6275, '1289791017', '郑州航空工业管理学院', 'http://www.zzia.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 17, '', ''),
(6276, '1289791017', '中原工学院', 'http://www.zzti.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 18, '', ''),
(6277, '1289791017', '黄河科技学院', 'http://www.hhstu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 19, '', ''),
(6278, '1289791017', '中州大学', 'http://www.zhzhu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 20, '', ''),
(6279, '1289791017', '河南中医学院', 'http://www.hactcm.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 21, '', ''),
(6280, '1289791017', '新乡医学院', 'http://www.xxmu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 22, '', ''),
(6281, '1289791017', '信阳师范学院', 'http://www.xytc.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 23, '', ''),
(6282, '1289791017', '河南卫生职工学院', 'http://www.hamc.com.cn/main/index.htm', 0, 0, 0, 4164, 0, 1, 0, NULL, 24, '', ''),
(6283, '1289791017', '安阳师范学院', 'http://www.aynu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 25, '', ''),
(6284, '1289791017', '周口师范学院', 'http://www.zknu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 26, '', ''),
(6285, '1289791017', '河南工程学院', 'http://www.zzei.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 27, '', ''),
(6286, '1289791017', '安阳工学院', 'http://www.ayit.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 28, '', ''),
(6287, '1289791017', '平顶山学院', 'http://www.pdsu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 29, '', ''),
(6288, '1289791017', '许昌学院', 'http://www.xcu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 30, '', ''),
(6289, '1289791017', '河南警察学院', 'http://www.hngazk.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 31, '', ''),
(6290, '1289791017', '新乡学院', 'http://www.xxu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 32, '', ''),
(6291, '1289791017', '黄淮学院', 'http://www.huanghuai.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 33, '', ''),
(6292, '1289791017', '郑州师范学院', 'http://www.zztc.com.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 34, '', ''),
(6293, '1289791017', '焦作师范高等专科学校', 'http://www.jzsz.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 35, '', ''),
(6294, '1289791017', '河南商业高等专科学校', 'http://www.habc.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 36, '', ''),
(6295, '1289791017', '郑州牧业工程高等专科学校', 'http://www.zzcah.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 37, '', ''),
(6296, '1289791017', '平顶山工业职业技术学院', 'http://www.pzxy.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 38, '', ''),
(6297, '1289791017', '三门峡职业技术学院', 'http://www.smxpt.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 39, '', ''),
(6298, '1289791017', '郑州科技学院', 'http://www.zzist.net/', 0, 0, 0, 4164, 0, 1, 0, NULL, 40, '', ''),
(6299, '1289791017', '郑州华信学院', 'http://www.zzhxxy.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 41, '', ''),
(6300, '1289791017', '开封大学', 'http://www.kfu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 42, '', ''),
(6301, '1289791017', '铁道警官高等专科学校', 'http://www.tdjg.com.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 43, '', ''),
(6302, '1289791017', '郑州铁路职业技术学院', 'http://www.zzrvtc.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 44, '', ''),
(6303, '1289791017', '漯河医学高等专科学校', 'http://www.lhmc.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 45, '', ''),
(6304, '1289791017', '黄河水利职业技术学院', 'http://www.yrcti.edu.cn', 0, 0, 0, 4164, 0, 1, 0, NULL, 46, '', ''),
(6305, '1289791017', '商丘职业技术学院', 'http://www.sqzy.com.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 47, '', ''),
(6306, '1289791017', '河南教育学院', 'http://www.haie.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 48, '', ''),
(6307, '1289791017', '河南职业技术学院', 'http://www.hnzj.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 49, '', ''),
(6308, '1289791017', '河南农业职业学院', 'http://www.hnac.com.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 50, '', ''),
(6309, '1289791017', '周口职业技术学院', 'http://www.zkvtc.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 51, '', ''),
(6310, '1289791017', '河南财政税务高等专科学校', 'http://www.hacz.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 52, '', ''),
(6311, '1289791017', '郑州电力高等专科学校', 'http://www.zepc.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 53, '', ''),
(6312, '1289791017', '信阳农业高等专科学校', 'http://www.xyac.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 54, '', ''),
(6313, '1289791017', '郑州澍青医学高等专科学校', 'http://www.shuqing.org/', 0, 0, 0, 4164, 0, 1, 0, NULL, 55, '', ''),
(6314, '1289791017', '南阳医学高等专科学校', 'http://www.nymc.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 56, '', ''),
(6315, '1289791017', '商丘医学高等专科学校', 'http://www.sqyx.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 57, '', ''),
(6316, '1289791017', '开封教育学院', 'http://www.kfie.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 58, '', ''),
(6317, '1289791017', '漯河职业技术学院', 'http://www.lhvtc.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 59, '', ''),
(6318, '1289791017', '鹤壁职业技术学院', 'http://www.hbzy.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 60, '', ''),
(6319, '1289791017', '郑州职业技术学院', 'http://www.zzyedu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 61, '', ''),
(6320, '1289791017', '嵩山少林武术职业学院', 'http://www.shaolinkungfu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 62, '', ''),
(6321, '1289791017', '郑州工业安全职业学院', 'http://www.zazy.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 63, '', ''),
(6322, '1289791017', '郑州交通职业学院', 'http://www.zjtu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 64, '', ''),
(6323, '1289791017', '商丘科技职业学院', 'http://www.sstvc.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 65, '', ''),
(6324, '1289791017', '郑州信息科技职业学院', 'http://tech.open.ha.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 66, '', ''),
(6325, '1289791017', '新乡职业技术学院', 'http://www.xxvtc.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 67, '', ''),
(6326, '1289791017', '漯河食品职业学院', 'http://www.lsgx.com.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 68, '', ''),
(6327, '1289791017', '郑州布瑞达理工职业学院', 'http://www.brenda.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 69, '', ''),
(6328, '1289791017', '河南经贸职业学院', 'http://www.hnjmxy.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 70, '', ''),
(6329, '1289791017', '济源职业技术学院', 'http://www.jyvtc.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 71, '', ''),
(6330, '1289791017', '河南建筑职业技术学院', 'http://www.hnjs.com.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 72, '', ''),
(6331, '1289791017', '周口科技职业学院', 'http://www.zkkjxy.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 73, '', ''),
(6332, '1289791017', '河南质量工程职业学院', 'http://www.zlxy.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 74, '', ''),
(6333, '1289791017', '驻马店职业技术学院', 'http://www.zmdvtc.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 75, '', ''),
(6334, '1289791017', '河南财经政法大学成功学院', 'http://www.chenggong.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 76, '', ''),
(6335, '1289791017', '信阳职业技术学院', 'http://www.xyvtc.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 77, '', ''),
(6336, '1289791017', '郑州经贸职业学院', 'http://www.zzjm.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 78, '', ''),
(6337, '1289791017', '河南工业职业技术学院', 'http://www.hnpi.cn:8084/', 0, 0, 0, 4164, 0, 1, 0, NULL, 79, '', ''),
(6338, '1289791017', '安阳职业技术学院', 'http://jsxy.anyangedu.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 80, '', ''),
(6339, '1289791017', '郑州电力职业技术学院', 'http://www.zzdl.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 81, '', ''),
(6340, '1289791017', '郑州旅游职业学院', 'http://www.zztrc.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 82, '', ''),
(6341, '1289791017', '河南工业贸易职业学院', 'http://www.hngm.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 83, '', ''),
(6342, '1289791017', '河南交通职业技术学院', 'http://www.hncc.net/', 0, 0, 0, 4164, 0, 1, 0, NULL, 84, '', ''),
(6343, '1289791017', '许昌职业技术学院', 'http://www.xcitc.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 85, '', ''),
(6344, '1289791017', '濮阳职业技术学院', 'http://218.28.84.54/web/', 0, 0, 0, 4164, 0, 1, 0, NULL, 86, '', ''),
(6345, '1289791017', '郑州电子信息职业技术学院', 'http://www.zyfb.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 87, '', ''),
(6346, '1289791017', '永城职业学院', 'http://www.yczyxy.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 88, '', ''),
(6347, '1289791017', '焦作工贸职业学院', 'http://www.jzgmxy.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 89, '', ''),
(6348, '1289791017', '河南农业大学华豫学院', 'http://www.hnhyedu.net/', 0, 0, 0, 4164, 0, 1, 0, NULL, 90, '', ''),
(6349, '1289791017', '河南化工职业学院', 'http://www.haict.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 91, '', ''),
(6350, '1289791017', '河南艺术职业学院', 'http://www.hnarti.com/', 0, 0, 0, 4164, 0, 1, 0, NULL, 92, '', ''),
(6351, '1289791017', '河南理工大学万方科技学院', 'http://202.196.225.55/', 0, 0, 0, 4164, 0, 1, 0, NULL, 93, '', ''),
(6352, '1289791017', '河南大学民生学院', 'http://minsheng.henu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 94, '', ''),
(6353, '1289791017', '中原工学院信息商务学院', 'http://www.zcib.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 95, '', ''),
(6354, '1289791017', '安阳师范学院人文管理学院', 'http://shm.aynu.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 96, '', ''),
(6355, '1289791017', '河南师范大学新联学院', 'http://www.xlxy.net/1index.asp', 0, 0, 0, 4164, 0, 1, 0, NULL, 97, '', ''),
(6356, '1289791017', '新乡医学院三全学院', 'http://www.sqmc.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 98, '', ''),
(6357, '1289791017', '河南科技学院新科学院', 'http://xink1.hist.edu.cn/', 0, 0, 0, 4164, 0, 1, 0, NULL, 99, '', ''),
(6358, '1289791017', '信阳师范学院华锐学院', 'http://www.hrxy.edu.cn/home/', 0, 0, 0, 4164, 0, 1, 0, NULL, 100, '', ''),
(6360, '1279617741', '老鬼钓鱼论坛', 'http://www.lg918.cn/bbs/', 0, 0, 0, 3066, 0, 1, 0, NULL, 2, '', ''),
(6361, '1279617741', '中钓论坛', 'http://bbs.fishcn.com/', 0, 0, 0, 3066, 0, 1, 0, NULL, 3, '', ''),
(6362, '1279617741', '中羽论坛', 'http://bbs.badmintoncn.com/', 0, 0, 0, 3066, 0, 1, 0, NULL, 4, '', ''),
(6363, '1279617741', '自行车旅行网', 'http://www.biketo.com/bbs/', 0, 0, 0, 3066, 0, 1, 0, NULL, 5, '', ''),
(6364, '1279617741', '自行车论坛', 'http://www.chinabike.net/newbbs/', 0, 0, 0, 3066, 0, 1, 0, NULL, 6, '', ''),
(6365, '1289791043', '河南贴吧', 'http://tieba.baidu.com/f?kw=%BA%D3%C4%CF', 0, 0, 0, 4165, 0, 1, 0, NULL, 1, '', ''),
(6366, '1289791043', '新浪河南论坛', 'http://bbs.henan.sina.com.cn/', 0, 0, 0, 4165, 0, 1, 0, NULL, 2, '', ''),
(6367, '1289791043', '郑州贴吧', 'http://tieba.baidu.com/f?kw=%D6%A3%D6%DD', 0, 0, 0, 4165, 0, 1, 0, NULL, 3, '', ''),
(6368, '1289791043', '焦作山阳社区', 'http://bbs.jzinfo.ha.cn/', 0, 0, 0, 4165, 0, 1, 0, NULL, 4, '', ''),
(6369, '1289791043', '周口龙都社区', 'http://bbs.zhld.com/', 0, 0, 0, 4165, 0, 1, 0, NULL, 5, '', ''),
(6370, '1289791043', '许昌春秋论坛', 'http://bbs.0374.net.cn/', 0, 0, 0, 4165, 0, 1, 0, NULL, 6, '', ''),
(6371, '1289791043', '娱乐新鹤壁', 'http://www.hbnew.com/', 0, 0, 0, 4165, 0, 1, 0, NULL, 7, '', ''),
(6372, '1289791043', '河南户外联盟', 'http://bbs.hnhw.com/', 0, 0, 0, 4165, 0, 1, 0, NULL, 8, '', ''),
(6373, '1289791043', '河南大学论坛', 'http://www.hedabbs.cn/', 0, 0, 0, 4165, 0, 1, 0, NULL, 9, '', ''),
(6374, '1279617741', '编织人生', 'http://bbs.bianzhirensheng.com/', 0, 0, 0, 3067, 0, 1, 0, NULL, 1, '', ''),
(6375, '1279617741', '书法家论坛', 'http://bbs.china-shufajia.com/', 0, 0, 0, 3067, 0, 1, 0, NULL, 2, '', ''),
(6376, '1279617741', '中国篆刻论坛', 'http://bbs.zgzkw.com/', 0, 0, 0, 3067, 0, 1, 0, NULL, 3, '', ''),
(6377, '1279617741', '魔方小站', 'http://www.rubik.com.cn/', 0, 0, 0, 3067, 0, 1, 0, NULL, 4, '', ''),
(6378, '1279617741', '盆景艺术论坛', 'http://bbs.cnpenjing.com/', 0, 0, 0, 3067, 0, 1, 0, NULL, 5, '', ''),
(6379, '1279617741', '木工爱好者', 'http://www.zuojiaju.com/', 0, 0, 0, 3067, 0, 1, 0, NULL, 6, '', ''),
(6380, '1279617741', '肉丁网', 'http://www.rouding.com/', 0, 0, 0, 3067, 0, 1, 0, NULL, 7, '', ''),
(6381, '1289791067', '工商局', 'http://www.haaic.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 1, '', ''),
(6382, '1289791067', '财政厅', 'http://www.hncz.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 2, '', ''),
(6383, '1289791067', '卫生厅', 'http://www.hnwst.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 3, '', ''),
(6384, '1289791067', '住房和城乡建设厅', 'http://www.hnjs.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 4, '', ''),
(6385, '1289791067', '河南统计网', 'http://www.ha.stats.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 5, '', ''),
(6386, '1289791067', '省招生办公室', 'http://www.heao.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 6, '', ''),
(6387, '1289791067', '河南教师资格网', 'http://jszg.haedu.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 7, '', ''),
(6388, '1289791067', '河南政府采购网', 'http://www.hngp.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 8, '', ''),
(6389, '1289791067', '河南职称网', 'http://www.hnzc.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 9, '', ''),
(6390, '1289791067', '食品药品监督管理局', 'http://www.hda.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 10, '', ''),
(6391, '1289791067', '河南农业信息网', 'http://www.haagri.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 11, '', ''),
(6392, '1289791067', '河南法院网', 'http://hnfy.chinacourt.org/', 0, 0, 0, 4166, 0, 1, 0, NULL, 12, '', ''),
(6393, '1289791067', '郑州地税局', 'http://www.hazz-l-tax.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 13, '', ''),
(6394, '1289791067', '洛阳市', 'http://www.ly.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 14, '', ''),
(6395, '1289791067', '开封市', 'http://www.kaifeng.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 15, '', ''),
(6396, '1289791067', '安阳市', 'http://www.anyang.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 16, '', ''),
(6397, '1289791067', '鹤壁市', 'http://www.hebi.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 17, '', ''),
(6398, '1289791067', '濮阳市', 'http://www.puyang.gov.cn//', 0, 0, 0, 4166, 0, 1, 0, NULL, 18, '', ''),
(6399, '1289791067', '济源市', 'http://www.jiyuan.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 19, '', ''),
(6400, '1289791067', '许昌市', 'http://www.xuchang.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 20, '', ''),
(6401, '1289791067', '焦作市', 'http://www.jiaozuo.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 21, '', ''),
(6402, '1289791067', '三门峡市', 'http://www.smx.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 22, '', ''),
(6403, '1289791067', '新乡市', 'http://www.xinxiang.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 23, '', ''),
(6404, '1289791067', '平顶山市', 'http://www.pds.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 24, '', ''),
(6405, '1289791067', '漯河市', 'http://www.luohe.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 25, '', ''),
(6406, '1289791067', '商丘市', 'http://www.shangqiu.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 26, '', ''),
(6407, '1289791067', '南阳市', 'http://www.nanyang.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 27, '', ''),
(6408, '1289791067', '周口市', 'http://www.zhoukou.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 28, '', ''),
(6409, '1289791067', '信阳市', 'http://www.xinyang.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 29, '', ''),
(6410, '1289791067', '驻马店市', 'http://www.zhumadian.gov.cn/', 0, 0, 0, 4166, 0, 1, 0, NULL, 30, '', ''),
(6411, '1289791111', '赤壁热线', 'http://www.cbrx.com/', 0, 0, 0, 4171, 0, 1, 0, NULL, 1, '', ''),
(6412, '1289791111', '荆州热线', 'http://www.jzinfo.com/', 0, 0, 0, 4171, 0, 1, 0, NULL, 2, '', ''),
(6413, '1289791111', '孝感热线', 'http://www.xginfo.com/', 0, 0, 0, 4171, 0, 1, 0, NULL, 3, '', ''),
(6414, '1289791111', '仙桃热线', 'http://xt.hb.vnet.cn/', 0, 0, 0, 4171, 0, 1, 0, NULL, 4, '', ''),
(6415, '1289791111', '东风热线', 'http://www.dongfeng.net/', 0, 0, 0, 4171, 0, 1, 0, NULL, 5, '', ''),
(6416, '1289791111', '车城热线', 'http://www.checheng.net/', 0, 0, 0, 4171, 0, 1, 0, NULL, 6, '', ''),
(6417, '1289791111', '襄樊热线', 'http://xf.hb.vnet.cn/', 0, 0, 0, 4171, 0, 1, 0, NULL, 7, '', ''),
(6418, '1289791111', '荆门信息港', 'http://www.jminfo.net/', 0, 0, 0, 4171, 0, 1, 0, NULL, 8, '', ''),
(6419, '1289791111', '三峡热线', 'http://www.sanxia.net.cn/', 0, 0, 0, 4171, 0, 1, 0, NULL, 9, '', ''),
(6420, '1289791111', '江汉热线', 'http://www.jhrx.cn/', 0, 0, 0, 4171, 0, 1, 0, NULL, 10, '', ''),
(6421, '1289791111', '黄石信息港', 'http://www.435000.com/', 0, 0, 0, 4171, 0, 1, 0, NULL, 11, '', ''),
(6422, '1289791111', '荆州在线', 'http://www.jzcool.com/', 0, 0, 0, 4171, 0, 1, 0, NULL, 12, '', ''),
(6423, '1289791111', '黄冈热线', 'http://www.hg.net.cn/', 0, 0, 0, 4171, 0, 1, 0, NULL, 13, '', ''),
(6424, '1289791156', '武汉热线', 'http://www.wuhan.net.cn/', 0, 0, 0, 4172, 0, 1, 0, NULL, 1, '', ''),
(6425, '1289791156', '荆楚网', 'http://www.cnhubei.com/', 0, 0, 0, 4172, 0, 1, 0, NULL, 2, '', ''),
(6426, '1289791156', '汉网(长江日报)', 'http://www.cnhan.com/', 0, 0, 0, 4172, 0, 1, 0, NULL, 3, '', ''),
(6427, '1289791156', '腾讯大楚网', 'http://hb.qq.com/', 0, 0, 0, 4172, 0, 1, 0, NULL, 4, '', ''),
(6428, '1289791156', '十堰秦楚网', 'http://www.10yan.com/', 0, 0, 0, 4172, 0, 1, 0, NULL, 5, '', ''),
(6429, '1289791156', '楚天都市报', 'http://ctdsb.cnhubei.com/cache/paper_ctdsb.aspx', 0, 0, 0, 4172, 0, 1, 0, NULL, 6, '', ''),
(6430, '1289791156', '湖北日报', 'http://hbrb.cnhubei.com/', 0, 0, 0, 4172, 0, 1, 0, NULL, 7, '', ''),
(6431, '1289791156', '黄石声屏网', 'http://www.hsgd.net.cn/', 0, 0, 0, 4172, 0, 1, 0, NULL, 8, '', ''),
(6432, '1289791156', '孝感网', 'http://www.xgrb.cn/', 0, 0, 0, 4172, 0, 1, 0, NULL, 9, '', ''),
(6433, '1289791156', '武汉晚报', 'http://www.cnhan.com/gb/special/node_928.htm', 0, 0, 0, 4172, 0, 1, 0, NULL, 10, '', ''),
(6434, '1289791156', '湖北新闻网', 'http://www.hb.chinanews.com.cn/', 0, 0, 0, 4172, 0, 1, 0, NULL, 11, '', ''),
(6435, '1289791156', '中国三峡传媒网', 'http://www.cn3x.com.cn/', 0, 0, 0, 4172, 0, 1, 0, NULL, 12, '', ''),
(6436, '1289791156', '火凤网', 'http://www.hbtv.com.cn/', 0, 0, 0, 4172, 0, 1, 0, NULL, 13, '', ''),
(6437, '1289791156', '长江网', 'http://www.cjn.cn/', 0, 0, 0, 4172, 0, 1, 0, NULL, 14, '', ''),
(6438, '1289791156', '恩施新闻网', 'http://www.enshi.cn/', 0, 0, 0, 4172, 0, 1, 0, NULL, 15, '', ''),
(6439, '1289791156', '应城网', 'http://www.yingchengnet.com/', 0, 0, 0, 4172, 0, 1, 0, NULL, 16, '', ''),
(6440, '1289791156', '东风热线', 'http://www.dongfeng.net/', 0, 0, 0, 4172, 0, 1, 0, NULL, 17, '', ''),
(6441, '1289791156', '楚天金报', 'http://ctjb.cnhubei.com/cache/paper_ctjb.aspx', 0, 0, 0, 4172, 0, 1, 0, NULL, 18, '', ''),
(6442, '1279617741', '牧夫天文论坛', 'http://www.astronomy.com.cn/bbs/', 0, 0, 0, 3068, 0, 1, 0, NULL, 1, '', ''),
(6443, '1279617741', '专利之家', 'http://www.patent-cn.com/', 0, 0, 0, 3068, 0, 1, 0, NULL, 2, '', ''),
(6444, '1279617741', '环球科学', 'http://www.sciam.com.cn/', 0, 0, 0, 3068, 0, 1, 0, NULL, 3, '', ''),
(6445, '1279617741', '科学松鼠会', 'http://songshuhui.net/', 0, 0, 0, 3068, 0, 1, 0, NULL, 4, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(6446, '1289791197', '武汉公交', 'http://www.wuhanbus.com/fuwu.asp', 0, 0, 0, 4173, 0, 1, 0, NULL, 1, '', ''),
(6447, '1289791197', '武汉天河国际机场', 'http://www.whairport.com/', 0, 0, 0, 4173, 0, 1, 0, NULL, 2, '', ''),
(6448, '1289791197', '列车时刻', 'http://www.whrailway.cn/service.asp', 0, 0, 0, 4173, 0, 1, 0, NULL, 3, '', ''),
(6449, '1289791197', '百度地图-武汉', 'http://map.baidu.com/#word=%E6%AD%A6%E6%B1%89&amp;amp;ct=10', 0, 0, 0, 4173, 0, 1, 0, NULL, 4, '', ''),
(6450, '1289791197', '武汉数字地图', 'http://map.wuhan.net.cn/', 0, 0, 0, 4173, 0, 1, 0, NULL, 5, '', ''),
(6451, '1289791197', '长途汽车客运', 'http://www.hbglky.com/bccx.php', 0, 0, 0, 4173, 0, 1, 0, NULL, 6, '', ''),
(6452, '1289791197', '武汉便民信息查询', 'http://www.wuhan.net.cn/chaxun/', 0, 0, 0, 4173, 0, 1, 0, NULL, 7, '', ''),
(6453, '1289791197', '携程旅游-湖北', 'http://destguides.ctrip.com/china/hubei/region67/', 0, 0, 0, 4173, 0, 1, 0, NULL, 8, '', ''),
(6454, '1289791197', '湖北旅游网', 'http://www.hubeitour.gov.cn/', 0, 0, 0, 4173, 0, 1, 0, NULL, 9, '', ''),
(6455, '1289791197', '荆楚网旅游频道', 'http://travel.cnhubei.com/', 0, 0, 0, 4173, 0, 1, 0, NULL, 10, '', ''),
(6456, '1289791197', '汉网旅游频道', 'http://www.cnhan.com/gb/node/node_1185.htm', 0, 0, 0, 4173, 0, 1, 0, NULL, 11, '', ''),
(6457, '1289791197', '湖北中青旅', 'http://www.hubcyts.com/', 0, 0, 0, 4173, 0, 1, 0, NULL, 12, '', ''),
(6458, '1289791197', '湖北旅游网', 'http://www.hbtour.com/', 0, 0, 0, 4173, 0, 1, 0, NULL, 13, '', ''),
(6459, '1289791197', '湖北美食网', 'http://www.1797.com.cn/', 0, 0, 0, 4173, 0, 1, 0, NULL, 14, '', ''),
(6460, '1289791197', '大众点评网武汉美食', 'http://www.dianping.com/wuhan', 0, 0, 0, 4173, 0, 1, 0, NULL, 15, '', ''),
(6461, '1289791197', '武汉市儿童医院', 'http://www.zgwhfe.com/', 0, 0, 0, 4173, 0, 1, 0, NULL, 16, '', ''),
(6462, '1289791197', '武汉大学中南医院', 'http://www.znhospital.cn/', 0, 0, 0, 4173, 0, 1, 0, NULL, 17, '', ''),
(6463, '1289791197', '汉网健康频道', 'http://www.cnhan.com/gb/special/node_5.htm', 0, 0, 0, 4173, 0, 1, 0, NULL, 18, '', ''),
(6464, '1289791197', '湖北省新华医院', 'http://www.xinhuahospital.com/', 0, 0, 0, 4173, 0, 1, 0, NULL, 19, '', ''),
(6465, '1289791197', '荆楚网健康', 'http://health.cnhubei.com/', 0, 0, 0, 4173, 0, 1, 0, NULL, 20, '', ''),
(6466, '1279617741', '财帮子', 'http://www.caibangzi.com/', 0, 0, 0, 3069, 0, 1, 0, NULL, 1, '', ''),
(6467, '1279617741', '钱包', 'http://www.qian8ao.com/', 0, 0, 0, 3069, 0, 1, 0, NULL, 2, '', ''),
(6468, '1279617741', '账客网', 'http://www.jizhangla.com/', 0, 0, 0, 3069, 0, 1, 0, NULL, 3, '', ''),
(6469, '1279617741', '财客在线', 'http://www.caakee.com/', 0, 0, 0, 3069, 0, 1, 0, NULL, 4, '', ''),
(6470, '1289791226', '湖北教育信息网', 'http://www.e21.edu.cn/', 0, 0, 0, 4174, 0, 1, 0, NULL, 1, '', ''),
(6471, '1289791226', '湖北省教育考试院', 'http://www.hbea.edu.cn/', 0, 0, 0, 4174, 0, 1, 0, NULL, 2, '', ''),
(6472, '1289791226', '湖北省教育厅', 'http://www.hbe.gov.cn/', 0, 0, 0, 4174, 0, 1, 0, NULL, 3, '', ''),
(6473, '1289791226', '武汉大学', 'http://www.whu.edu.cn/', 0, 0, 0, 4174, 0, 1, 0, NULL, 4, '', ''),
(6474, '1289791226', '中南财经政法大学', 'http://www.znufe.edu.cn/', 0, 0, 0, 4174, 0, 1, 0, NULL, 5, '', ''),
(6475, '1289791226', '华中师范大学', 'http://www.ccnu.edu.cn/', 0, 0, 0, 4174, 0, 1, 0, NULL, 6, '', ''),
(6476, '1289791226', '武汉理工大学', 'http://www.whut.edu.cn/', 0, 0, 0, 4174, 0, 1, 0, NULL, 7, '', ''),
(6477, '1289791226', '湖北自考网', 'http://www.hbzkw.com', 0, 0, 0, 4174, 0, 1, 0, NULL, 8, '', ''),
(6478, '1289791226', '华中科技大学', 'http://www.hust.edu.cn/', 0, 0, 0, 4174, 0, 1, 0, NULL, 9, '', ''),
(6479, '1279617741', '猪八戒', 'http://www.zhubajie.com/', 0, 0, 0, 3070, 0, 1, 0, NULL, 1, '', ''),
(6480, '1279617741', '威客中国', 'http://www.vikecn.com/', 0, 0, 0, 3070, 0, 1, 0, NULL, 2, '', ''),
(6481, '1279617741', '征集网', 'http://www.zhengjicn.com/', 0, 0, 0, 3070, 0, 1, 0, NULL, 3, '', ''),
(6482, '1279617741', '任务中国', 'http://www.taskcn.com/', 0, 0, 0, 3070, 0, 1, 0, NULL, 4, '', ''),
(6483, '1279617741', '佛教导航', 'http://www.fjdh.com/', 0, 0, 0, 3071, 0, 1, 0, NULL, 1, '', ''),
(6484, '1279617741', '金刚经', 'http://www.jingangjing.com/', 0, 0, 0, 3071, 0, 1, 0, NULL, 2, '', ''),
(6485, '1279617741', '中国佛教网', 'http://www.zgfj.cn/', 0, 0, 0, 3071, 0, 1, 0, NULL, 3, '', ''),
(6486, '1279617741', '地藏论坛', 'http://www.bskk.com/', 0, 0, 0, 3071, 0, 1, 0, NULL, 4, '', ''),
(6487, '1279617741', '佛学在线', 'http://www.foxue.org/', 0, 0, 0, 3071, 0, 1, 0, NULL, 5, '', ''),
(6488, '1279617741', '地藏缘论坛', 'http://www.folou.com/', 0, 0, 0, 3071, 0, 1, 0, NULL, 6, '', ''),
(6489, '1279617741', '佛教在线', 'http://www.fjnet.com/', 0, 0, 0, 3071, 0, 1, 0, NULL, 7, '', ''),
(6490, '1279617741', '周易天地', 'http://bbs.64gua.com/', 0, 0, 0, 3072, 0, 1, 0, NULL, 1, '', ''),
(6491, '1279617741', '赞美诗', 'http://www.zanmeishi.com/', 0, 0, 0, 3072, 0, 1, 0, NULL, 2, '', ''),
(6492, '1279617741', '中国调查网', 'http://www.zdiao.com/', 0, 0, 0, 3072, 0, 1, 0, NULL, 3, '', ''),
(6493, '1279617741', 'MVBOX', 'http://www.mvbox.cn/', 0, 0, 0, 3072, 0, 1, 0, NULL, 4, '', ''),
(6494, '1279617741', '舍得网', 'http://www.shede.com/', 0, 0, 0, 3072, 0, 1, 0, NULL, 5, '', ''),
(6495, '1279617741', 'MBA智库百科', 'http://wiki.mbalib.com/', 0, 0, 0, 3072, 0, 1, 0, NULL, 6, '', ''),
(6496, '1279617741', '我学网', 'http://www.5xue.com/', 0, 0, 0, 3072, 0, 1, 0, NULL, 7, '', ''),
(6497, '1279617741', '劝学网', 'http://www.quanxue.cn/', 0, 0, 0, 3072, 0, 1, 0, NULL, 8, '', ''),
(6498, '1279617741', '维棠', 'http://www.vidown.cn/', 0, 0, 0, 3072, 0, 1, 0, NULL, 9, '', ''),
(6499, '1289791246', '湖北贴吧', 'http://tieba.baidu.com/f?kw=%BA%FE%B1%B1', 0, 0, 0, 4175, 0, 1, 0, NULL, 1, '', ''),
(6500, '1289791246', '天涯社区湖北', 'http://cache.tianya.cn/new/TianyaCity/ArticlesList_Culture.asp?idWriter=0&amp;amp;Key=0&amp;amp;iditem=46', 0, 0, 0, 4175, 0, 1, 0, NULL, 2, '', ''),
(6501, '1289791246', '百度知道湖北', 'http://zhidao.baidu.com/browse/256', 0, 0, 0, 4175, 0, 1, 0, NULL, 3, '', ''),
(6502, '1289791246', '潜江人论坛', 'http://www.qjren.com/', 0, 0, 0, 4175, 0, 1, 0, NULL, 4, '', ''),
(6503, '1289791246', '大武汉论坛', 'http://www.dawuhan.com/', 0, 0, 0, 4175, 0, 1, 0, NULL, 5, '', ''),
(6504, '1289791246', '荆门社区', 'http://www.jmbbs.com', 0, 0, 0, 4175, 0, 1, 0, NULL, 6, '', ''),
(6505, '1289791246', '日光海岸', 'http://www.sunpp.com/bbs/', 0, 0, 0, 4175, 0, 1, 0, NULL, 7, '', ''),
(6506, '1289791246', '三峡论坛', 'http://bbs.sanxia.net.cn', 0, 0, 0, 4175, 0, 1, 0, NULL, 8, '', ''),
(6507, '1289791246', '谷城社区', 'http://bbs.gucheng.org', 0, 0, 0, 4175, 0, 1, 0, NULL, 9, '', ''),
(6508, '1289791246', '钟祥论坛', 'http://bbs.zxwindow.com/', 0, 0, 0, 4175, 0, 1, 0, NULL, 10, '', ''),
(6509, '1289791246', '随州论坛', 'http://www.szbbs.org/', 0, 0, 0, 4175, 0, 1, 0, NULL, 11, '', ''),
(6510, '1289791246', '恩施论坛', 'http://bbs.enshi.cn/', 0, 0, 0, 4175, 0, 1, 0, NULL, 12, '', ''),
(6511, '1289791246', '水都论坛', 'http://bbs.hbdjk.com/', 0, 0, 0, 4175, 0, 1, 0, NULL, 13, '', ''),
(6512, '1289791264', '湖北省政府', 'http://www.hubei.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 1, '', ''),
(6513, '1289791264', '湖北省发改委', 'http://www.hbjw.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 2, '', ''),
(6514, '1289791264', '湖北物价局', 'http://www.hbpic.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 3, '', ''),
(6515, '1289791264', '湖北省国税局', 'http://www.hb-n-tax.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 4, '', ''),
(6516, '1289791264', '湖北省建设厅', 'http://www.hbsjst.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 5, '', ''),
(6517, '1289791264', '湖北政府采购网', 'http://www.ccgp-hubei.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 6, '', ''),
(6518, '1289791264', '湖北交通厅', 'http://www.hbjt.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 7, '', ''),
(6519, '1289791264', '武汉', 'http://www.wuhan.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 8, '', ''),
(6520, '1289791264', '湖北人事网', 'http://www.hbrs.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 9, '', ''),
(6521, '1289791264', '荆州', 'http://www.jingzhou.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 10, '', ''),
(6522, '1289791264', '孝感', 'http://www.xiaogan.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 11, '', ''),
(6523, '1289791264', '黄冈', 'http://www.hg.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 12, '', ''),
(6524, '1289791264', '宜昌', 'http://www.yichang.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 13, '', ''),
(6525, '1289791264', '襄阳', 'http://www.hbxy.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 14, '', ''),
(6526, '1289791264', '仙桃', 'http://www.xiantao.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 15, '', ''),
(6527, '1289791264', '襄樊', 'http://www.xf.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 16, '', ''),
(6528, '1289791264', '当阳', 'http://www.hbdangyang.com/', 0, 0, 0, 4176, 0, 1, 0, NULL, 17, '', ''),
(6529, '1289791264', '恩施', 'http://www.enshi.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 18, '', ''),
(6530, '1289791264', '老河口', 'http://www.laohekou.com.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 19, '', ''),
(6531, '1289791264', '宜都', 'http://www.hbyidu.com/', 0, 0, 0, 4176, 0, 1, 0, NULL, 20, '', ''),
(6532, '1289791264', '武穴', 'http://www.hbwuxue.com/', 0, 0, 0, 4176, 0, 1, 0, NULL, 21, '', ''),
(6533, '1289791264', '鄂州', 'http://www.ezhou.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 22, '', ''),
(6534, '1289791264', '广水', 'http://www.zggs.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 23, '', ''),
(6535, '1289791264', '赤壁', 'http://www.chibi.com.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 24, '', ''),
(6536, '1289791264', '荆门', 'http://www.jingmen.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 25, '', ''),
(6537, '1289791264', '巴东', 'http://www.cjbd.com.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 26, '', ''),
(6538, '1289791264', '黄石', 'http://www.huangshi.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 27, '', ''),
(6539, '1289791264', '随州', 'http://www.suizhou.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 28, '', ''),
(6540, '1289791264', '天门', 'http://www.tianmen.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 29, '', ''),
(6541, '1289791264', '湖北省公安厅', 'http://www.hbgat.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 30, '', ''),
(6542, '1289791264', '武汉市公安局', 'http://www.whga.gov.cn/', 0, 0, 0, 4176, 0, 1, 0, NULL, 31, '', ''),
(6543, '1289791318', '红网郴州站', 'http://www.chenzhou.gov.cn/', 0, 0, 0, 4181, 0, 1, 0, NULL, 1, '', ''),
(6544, '1289791318', '湘潭在线', 'http://www.xtol.cn/', 0, 0, 0, 4181, 0, 1, 0, NULL, 2, '', ''),
(6545, '1289791318', '星辰在线', 'http://www.changsha.cn/', 0, 0, 0, 4181, 0, 1, 0, NULL, 3, '', ''),
(6546, '1289791318', '永州信息港', 'http://yz.2118.com.cn/', 0, 0, 0, 4181, 0, 1, 0, NULL, 4, '', ''),
(6547, '1289791318', '红网永州站', 'http://www.yongzhou.gov.cn/', 0, 0, 0, 4181, 0, 1, 0, NULL, 5, '', ''),
(6548, '1289791318', '株洲在线', 'http://www.zzz4.com/', 0, 0, 0, 4181, 0, 1, 0, NULL, 6, '', ''),
(6549, '1289791318', '郴州信息港', 'http://www.0735.com.cn/', 0, 0, 0, 4181, 0, 1, 0, NULL, 7, '', ''),
(6550, '1289791318', '湘西生活网', 'http://www.07430743.com/', 0, 0, 0, 4181, 0, 1, 0, NULL, 8, '', ''),
(6551, '1289791318', '郴州新网', 'http://www.0735.com/', 0, 0, 0, 4181, 0, 1, 0, NULL, 9, '', ''),
(6552, '1289791344', '湖南在线', 'http://hunan.voc.com.cn/', 0, 0, 0, 4182, 0, 1, 0, NULL, 1, '', ''),
(6553, '1289791344', '三湘都市报', 'http://sxdsb.rednet.cn/', 0, 0, 0, 4182, 0, 1, 0, NULL, 2, '', ''),
(6554, '1289791344', '华声在线', 'http://www.voc.com.cn/', 0, 0, 0, 4182, 0, 1, 0, NULL, 3, '', ''),
(6555, '1289791344', '新华网湖南频道', 'http://www.hn.xinhuanet.com/', 0, 0, 0, 4182, 0, 1, 0, NULL, 4, '', ''),
(6556, '1289791344', '湖南红网', 'http://www.rednet.cn/', 0, 0, 0, 4182, 0, 1, 0, NULL, 5, '', ''),
(6557, '1289791344', '星辰在线', 'http://www.changsha.cn/', 0, 0, 0, 4182, 0, 1, 0, NULL, 6, '', ''),
(6558, '1289791344', '金鹰网', 'http://www.hunantv.com/', 0, 0, 0, 4182, 0, 1, 0, NULL, 7, '', ''),
(6559, '1289791344', '湖南信息港', 'http://2118.hn.vnet.cn/', 0, 0, 0, 4182, 0, 1, 0, NULL, 8, '', ''),
(6560, '1289791344', '经视网', 'http://www.hnetv.com/', 0, 0, 0, 4182, 0, 1, 0, NULL, 9, '', ''),
(6561, '1289791344', '湖南广播在线', 'http://www.hnradio.com/', 0, 0, 0, 4182, 0, 1, 0, NULL, 10, '', ''),
(6562, '1289791344', '长沙晚报', 'http://cswb.csonline.com.cn/CSWB/', 0, 0, 0, 4182, 0, 1, 0, NULL, 11, '', ''),
(6563, '1289791344', '湖南日报', 'http://epaper.voc.com.cn/hnrb/', 0, 0, 0, 4182, 0, 1, 0, NULL, 12, '', ''),
(6564, '1289791344', '中新湖南网', 'http://www.hnxw.cn/', 0, 0, 0, 4182, 0, 1, 0, NULL, 13, '', ''),
(6565, '1289791344', '潇湘晨报', 'http://www.xxcb.cn/', 0, 0, 0, 4182, 0, 1, 1292223353, NULL, 14, '', ''),
(6566, '1289791369', '百度地图-长沙', 'http://map.baidu.com/#word=%B3%A4%C9%B3&amp;amp;ct=10', 0, 0, 0, 4183, 0, 1, 0, NULL, 1, '', ''),
(6567, '1289791369', '长沙公交查询', 'http://changsha.8684.cn/', 0, 0, 0, 4183, 0, 1, 0, NULL, 2, '', ''),
(6568, '1289791369', '湖南机场', 'http://www.hncaac.com/', 0, 0, 0, 4183, 0, 1, 0, NULL, 3, '', ''),
(6569, '1289791369', '列车时刻', 'http://lieche.5w.com/', 0, 0, 0, 4183, 0, 1, 0, NULL, 4, '', ''),
(6570, '1289791369', '携程旅行-湖南', 'http://destguides.ctrip.com/china/hunan/region53/', 0, 0, 0, 4183, 0, 1, 0, NULL, 5, '', ''),
(6571, '1289791369', '湖南旅游网', 'http://www.gotohn.com/', 0, 0, 0, 4183, 0, 1, 0, NULL, 6, '', ''),
(6572, '1289791369', '湖南旅游网(旅游局)', 'http://www.hnt.gov.cn/', 0, 0, 0, 4183, 0, 1, 0, NULL, 7, '', ''),
(6573, '1289791369', '张家界旅游网', 'http://www.zhangjiajie.me', 0, 0, 0, 4183, 0, 1, 0, NULL, 8, '', ''),
(6574, '1289791369', '长沙美食网', 'http://eat.csonline.com.cn', 0, 0, 0, 4183, 0, 1, 0, NULL, 9, '', ''),
(6575, '1289791369', '搜房-长沙', 'http://changsha.soufun.com/', 0, 0, 0, 4183, 0, 1, 0, NULL, 10, '', ''),
(6576, '1289791369', '湖南房地产交易网', 'http://www.365fz.com/', 0, 0, 0, 4183, 0, 1, 0, NULL, 11, '', ''),
(6577, '1289791369', '好房子', 'http://www.haofz.com/', 0, 0, 0, 4183, 0, 1, 0, NULL, 12, '', ''),
(6578, '1289791369', '三湘健康', 'http://www.sxjk.com/', 0, 0, 0, 4183, 0, 1, 0, NULL, 13, '', ''),
(6579, '1289791369', '湖南好大夫', 'http://hunan.haodf.com/', 0, 0, 0, 4183, 0, 1, 0, NULL, 14, '', ''),
(6580, '1289791369', '湘雅医院', 'http://www.xiangya.com.cn/', 0, 0, 0, 4183, 0, 1, 0, NULL, 15, '', ''),
(6581, '1289791369', '湖南省儿童医院', 'http://www.et-hospital.com.cn/', 0, 0, 0, 4183, 0, 1, 0, NULL, 16, '', ''),
(6582, '1289791369', '湖南省人民医院', 'http://www.hnsrmyy.com/', 0, 0, 0, 4183, 0, 1, 0, NULL, 17, '', ''),
(6583, '1289791369', '大众卫生报', 'http://dzwsb.hnol.net/', 0, 0, 0, 4183, 0, 1, 0, NULL, 18, '', ''),
(6584, '1289791369', '凤网', 'http://www.fengone.com/', 0, 0, 0, 4183, 0, 1, 0, NULL, 19, '', ''),
(6585, '1289791438', '湖南教育网', 'http://www.hnedu.cn/', 0, 0, 0, 4184, 0, 1, 0, NULL, 1, '', ''),
(6586, '1289791438', '长沙考试网', 'http://www.csks.gov.cn/', 0, 0, 0, 4184, 0, 1, 0, NULL, 2, '', ''),
(6587, '1289791438', '湖南大学', 'http://www.hnu.cn/', 0, 0, 0, 4184, 0, 1, 0, NULL, 3, '', ''),
(6588, '1289791438', '湖南师范大学', 'http://www.hunnu.edu.cn/', 0, 0, 0, 4184, 0, 1, 0, NULL, 4, '', ''),
(6589, '1289791438', '湖南省教育考试院', 'http://www.hneao.edu.cn/', 0, 0, 0, 4184, 0, 1, 0, NULL, 5, '', ''),
(6590, '1289791438', '湖南科技大学', 'http://www.hnust.edu.cn/', 0, 0, 0, 4184, 0, 1, 0, NULL, 6, '', ''),
(6591, '1289791438', '湘潭大学', 'http://www.xtu.edu.cn/', 0, 0, 0, 4184, 0, 1, 0, NULL, 7, '', ''),
(6592, '1289791438', '长沙教育信息网', 'http://www.csedu.gov.cn/', 0, 0, 0, 4184, 0, 1, 0, NULL, 8, '', ''),
(6593, '1289791438', '中南大学', 'http://www.csu.edu.cn/', 0, 0, 0, 4184, 0, 1, 0, NULL, 9, '', ''),
(6594, '1289791457', '湖南红网论坛', 'http://bbs.rednet.cn/', 0, 0, 0, 4185, 0, 1, 0, NULL, 1, '', ''),
(6595, '1289791457', '张家界公众论坛', 'http://www.bbszjj.com/', 0, 0, 0, 4185, 0, 1, 0, NULL, 2, '', ''),
(6596, '1289791457', '天涯社区-湖南', 'http://www.tianya.cn/new/TianyaCity/ArticlesList_Culture.asp?idWriter=0&amp;amp;Key=0&amp;amp;idItem=56', 0, 0, 0, 4185, 0, 1, 0, NULL, 3, '', ''),
(6597, '1289791457', '百度知道-湖南', 'http://zhidao.baidu.com/browse/257', 0, 0, 0, 4185, 0, 1, 0, NULL, 4, '', ''),
(6598, '1289791457', '华声在线论坛', 'http://bbs.voc.com.cn/', 0, 0, 0, 4185, 0, 1, 0, NULL, 5, '', ''),
(6599, '1289791457', '湖南贴吧', 'http://tieba.baidu.com/f?kw=%BA%FE%C4%CF', 0, 0, 0, 4185, 0, 1, 0, NULL, 6, '', ''),
(6600, '1289791457', '长沙贴吧', 'http://tieba.baidu.com/f?kw=%B3%A4%C9%B3', 0, 0, 0, 4185, 0, 1, 0, NULL, 7, '', ''),
(6601, '1289791457', '湖南体彩论坛', 'http://bbs.hnticai.com/', 0, 0, 0, 4185, 0, 1, 0, NULL, 8, '', ''),
(6602, '1289791482', '湖南省政府', 'http://www.hunan.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 1, '', ''),
(6603, '1289791482', '湖南法院网', 'http://hunanfy.chinacourt.org/', 0, 0, 0, 4186, 0, 1, 0, NULL, 2, '', ''),
(6604, '1289791482', '湖南省教育厅', 'http://gov.hnedu.cn/cn/gov/index.jsp', 0, 0, 0, 4186, 0, 1, 0, NULL, 3, '', ''),
(6605, '1289791482', '中国长沙', 'http://www.changsha.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 4, '', ''),
(6606, '1289791482', '湘潭市政府信息网', 'http://www.xiangtan.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 5, '', ''),
(6607, '1289791482', '株洲农业信息网', 'http://www.zzsagri.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 6, '', ''),
(6608, '1289791482', '衡阳市人民政府', 'http://www.hengyang.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 7, '', ''),
(6609, '1289791482', '湘西州公众信息网', 'http://www.xxz.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 8, '', ''),
(6610, '1289791482', '邵阳市公众信息网', 'http://www.shaoyang.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 9, '', ''),
(6611, '1289791482', '益阳市公众信息网', 'http://www.yiyangcity.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 10, '', ''),
(6612, '1289791482', '娄底政府公众信息网', 'http://www.hnloudi.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 11, '', ''),
(6613, '1289791482', '常德市公众信息网', 'http://www.changde.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 12, '', ''),
(6614, '1289791482', '张家界公众信息网', 'http://www.zjj.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 13, '', ''),
(6615, '1289791482', '永州公众信息网', 'http://www.yzcity.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 14, '', ''),
(6616, '1289791482', '怀化公众信息网', 'http://www.huaihua.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 15, '', ''),
(6617, '1289791482', '湖南政府采购网', 'http://www.ccgp-hunan.gov.cn/', 0, 0, 0, 4186, 0, 1, 0, NULL, 16, '', ''),
(6618, '1289791482', '湖南省卫生厅', 'http://www.21hospital.com/', 0, 0, 0, 4186, 0, 1, 0, NULL, 17, '', ''),
(6619, '1289791589', '佛山信息港', 'http://www.fsecity.com/', 0, 0, 0, 4191, 0, 1, 0, NULL, 1, '', ''),
(6620, '1289791589', '中山网', 'http://www.zsnews.cn/', 0, 0, 0, 4191, 0, 1, 0, NULL, 2, '', ''),
(6621, '1289791589', '今日惠州网', 'http://www.huizhou.cn/', 0, 0, 0, 4191, 0, 1, 0, NULL, 3, '', ''),
(6622, '1289791589', '阳江视窗', 'http://www.yangjiang.com/', 0, 0, 0, 4191, 0, 1, 0, NULL, 4, '', ''),
(6623, '1289791589', '顺德信息网', 'http://www.shunde.net.cn/', 0, 0, 0, 4191, 0, 1, 0, NULL, 5, '', ''),
(6624, '1289791589', '雷州壹网', 'http://www.lzeweb.com/', 0, 0, 0, 4191, 0, 1, 0, NULL, 6, '', ''),
(6625, '1289791589', '惠州信息港', 'http://www.hzinfo.com/', 0, 0, 0, 4191, 0, 1, 0, NULL, 7, '', ''),
(6626, '1289791589', '中山国际网', 'http://www.zsnet.com/', 0, 0, 0, 4191, 0, 1, 0, NULL, 8, '', ''),
(6627, '1289791589', '汕头信息港', 'http://www.shantou.gd.cn/', 0, 0, 0, 4191, 0, 1, 0, NULL, 9, '', ''),
(6628, '1289791589', '珠海视窗', 'http://www.zhuhai.gd.cn/', 0, 0, 0, 4191, 0, 1, 0, NULL, 10, '', ''),
(6629, '1289791589', '江门国际网', 'http://jm.gd.vnet.cn/', 0, 0, 0, 4191, 0, 1, 0, NULL, 11, '', ''),
(6630, '1289791589', '韶关家园', 'http://www.sg169.com/', 0, 0, 0, 4191, 0, 1, 0, NULL, 12, '', ''),
(6631, '1289791589', '茂名在线', 'http://www.gdmm.com/', 0, 0, 0, 4191, 0, 1, 0, NULL, 13, '', ''),
(6632, '1289791589', '茂名信息港', 'http://www.maoming.gd.cn/', 0, 0, 0, 4191, 0, 1, 0, NULL, 14, '', ''),
(6633, '1289791589', '梅州视窗', 'http://www.meizhou.net/', 0, 0, 0, 4191, 0, 1, 0, NULL, 15, '', ''),
(6634, '1289791769', '南方周末', 'http://www.infzm.com/', 0, 0, 0, 4192, 0, 1, 0, NULL, 1, '', ''),
(6635, '1289791769', '南方日报', 'http://www.nfdaily.cn/', 0, 0, 0, 4192, 0, 1, 0, NULL, 2, '', ''),
(6636, '1289791769', '南方都市报', 'http://nd.oeeee.com/', 0, 0, 0, 4192, 0, 1, 0, NULL, 3, '', ''),
(6637, '1289791769', '广东电视台', 'http://www.gdtv.com.cn/', 0, 0, 0, 4192, 0, 1, 0, NULL, 4, '', ''),
(6638, '1289791769', '广州电视台', 'http://www.gztv.com/', 0, 0, 0, 4192, 0, 1, 0, NULL, 5, '', ''),
(6639, '1289791769', '东莞阳光网', 'http://www.sun0769.com/', 0, 0, 0, 4192, 0, 1, 0, NULL, 6, '', ''),
(6640, '1289791769', '碧海银沙', 'http://www.yinsha.com/', 0, 0, 0, 4192, 0, 1, 0, NULL, 7, '', ''),
(6641, '1289791769', '广佛都市网', 'http://www.citygf.com/', 0, 0, 0, 4192, 0, 1, 0, NULL, 8, '', ''),
(6642, '1289791769', '广州日报', 'http://gzdaily.dayoo.com/', 0, 0, 0, 4192, 0, 1, 0, NULL, 9, '', ''),
(6643, '1289791769', '奥一网', 'http://www.oeeee.com/', 0, 0, 0, 4192, 0, 1, 0, NULL, 10, '', ''),
(6644, '1289791769', '珠海视窗', 'http://www.zhuhai.gd.cn/', 0, 0, 0, 4192, 0, 1, 0, NULL, 11, '', ''),
(6645, '1289791769', '今日惠州网', 'http://www.huizhou.cn/', 0, 0, 0, 4192, 0, 1, 0, NULL, 12, '', ''),
(6646, '1289791769', '中山国际网', 'http://www.zsnet.com/', 0, 0, 0, 4192, 0, 1, 0, NULL, 13, '', ''),
(6647, '1289791769', '江门国际网', 'http://jm.gd.vnet.cn/', 0, 0, 0, 4192, 0, 1, 0, NULL, 14, '', ''),
(6648, '1289791769', '梅州视窗', 'http://www.meizhou.net/', 0, 0, 0, 4192, 0, 1, 0, NULL, 15, '', ''),
(6649, '1289791769', '茂名在线', 'http://www.gdmm.com/', 0, 0, 0, 4192, 0, 1, 0, NULL, 16, '', ''),
(6650, '1289791769', '韶关家园', 'http://www.sg169.com/', 0, 0, 0, 4192, 0, 1, 0, NULL, 17, '', ''),
(6651, '1279617741', '中国红十字基金会', 'http://www.crcf.org.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 1, '', ''),
(6652, '1279617741', '壹基金', 'http://www.onefoundation.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 2, '', ''),
(6653, '1279617741', '中国青少年发展基金会', 'http://www.cydf.org.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 3, '', ''),
(6654, '1279617741', '中国残疾人福利基金会', 'http://www.cwfh.org.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 4, '', ''),
(6655, '1279617741', '中华慈善总会', 'http://www.chinacharity.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 5, '', ''),
(6656, '1279617741', '中国宋庆龄基金会', 'http://www.sclf.org/', 0, 0, 0, 3082, 0, 1, 0, NULL, 6, '', ''),
(6657, '1279617741', '中国扶贫基金会', 'http://www.fupin.org.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 7, '', ''),
(6658, '1279617741', '中国教育发展基金会', 'http://www.cedf.org.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 8, '', ''),
(6659, '1279617741', '中国妇女发展基金会', 'http://www.cwdf.org.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 9, '', ''),
(6660, '1279617741', '感恩中国', 'http://www.owecn.com/', 0, 0, 0, 3082, 0, 1, 0, NULL, 10, '', ''),
(6661, '1279617741', '中华环保基金会', 'http://www.cepf.org.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 11, '', ''),
(6662, '1279617741', '国际红十字会', 'http://www.icrc.org/chi', 0, 0, 0, 3082, 0, 1, 0, NULL, 12, '', ''),
(6663, '1279617741', '联合国儿童基金会', 'http://www.unicef.org/chinese/', 0, 0, 0, 3082, 0, 1, 0, NULL, 13, '', ''),
(6664, '1279617741', '世界自然基金会', 'http://www.wwfchina.org/', 0, 0, 0, 3082, 0, 1, 0, NULL, 14, '', ''),
(6665, '1279617741', '公益互助目录', 'http://tieba.baidu.com/f?ct=536870912&sn=%BF%C6%BD%CC%C8%CB%CE%C4&bs=%B9%AB%D2%E6%BB%A5%D6%FA&rn=200&pn=0&cm=1101&tn=simpleCategory', 0, 0, 0, 3082, 0, 1, 0, NULL, 15, '', ''),
(6666, '1279617741', '中国儿童少年基金会', 'http://www.cctf.org.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 16, '', ''),
(6667, '1279617741', '李嘉诚基金会', 'http://www.lksf.org/gb/', 0, 0, 0, 3082, 0, 1, 0, NULL, 17, '', ''),
(6668, '1279617741', '中国红十字会', 'http://www.redcross.org.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 18, '', ''),
(6669, '1279617741', '中国志愿者网', 'http://www.zgzyz.org.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 19, '', ''),
(6670, '1279617741', '小桔灯助学捐书', 'http://light.baidu.com/join.html', 0, 0, 0, 3082, 0, 1, 0, NULL, 20, '', ''),
(6671, '1279617741', '搜狐公益', 'http://gongyi.sohu.com/', 0, 0, 0, 3082, 0, 1, 0, NULL, 21, '', ''),
(6672, '1279617741', '凤凰网公益', 'http://gongyi.ifeng.com/', 0, 0, 0, 3082, 0, 1, 0, NULL, 22, '', ''),
(6673, '1279617741', '网易公益', 'http://gongyi.163.com/', 0, 0, 0, 3082, 0, 1, 0, NULL, 23, '', ''),
(6674, '1279617741', '百度公益', 'http://gongyi.baidu.com/', 0, 0, 0, 3082, 0, 1, 0, NULL, 24, '', ''),
(6675, '1279617741', '新浪公益', 'http://gongyi.sina.com.cn/', 0, 0, 0, 3082, 0, 1, 0, NULL, 25, '', ''),
(6676, '1279617741', '腾讯公益', 'http://gongyi.qq.com/', 0, 0, 0, 3082, 0, 1, 0, NULL, 26, '', ''),
(6677, '1289791802', '广州地图', 'http://map.baidu.com/?newmap=1&amp;amp;l=12&amp;amp;t=B_NORMAL_MAP&amp;amp;c=12613487.11,2629614.08&amp;amp;s=cur%26curtp%3D2%26wd%3D%25E5%25B9%25BF%25E5%25B7%259E', 0, 0, 0, 4193, 0, 1, 0, NULL, 1, '', ''),
(6678, '1289791802', '坐车网', 'http://www.zuoche.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 2, '', ''),
(6679, '1289791802', '广州三维地图', 'http://gz.o.cn/', 0, 0, 0, 4193, 0, 1, 0, NULL, 3, '', ''),
(6680, '1289791802', '广州地铁', 'http://www.gzmtr.com/ckfw/dtxlt/', 0, 0, 0, 4193, 0, 1, 0, NULL, 4, '', ''),
(6681, '1289791802', '深圳公交、地图查询', 'http://map.sz.bendibao.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 5, '', ''),
(6682, '1289791802', '深圳地铁', 'http://www.szmc.net/index.jsp', 0, 0, 0, 4193, 0, 1, 0, NULL, 6, '', ''),
(6683, '1289791802', '深圳宝安国际机场', 'http://www.szairport.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 7, '', ''),
(6684, '1289791802', '查查吧', 'http://www.chachaba.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 8, '', ''),
(6685, '1289791802', '深圳通', 'http://www.shenzhentong.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 9, '', ''),
(6686, '1289791802', '都市圈', 'http://www.o.cn/', 0, 0, 0, 4193, 0, 1, 0, NULL, 10, '', ''),
(6687, '1289791802', '至尊租车', 'http://www.toponecn.cn/', 0, 0, 0, 4193, 0, 1, 0, NULL, 11, '', ''),
(6688, '1289791802', '天河客运站', 'http://www.tianhebus.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 12, '', ''),
(6689, '1289791802', '华铁在线', 'http://www.ht1881.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 13, '', ''),
(6690, '1289791802', '广东移动', 'http://gd.10086.cn/', 0, 0, 0, 4193, 0, 1, 0, NULL, 14, '', ''),
(6691, '1289791802', '广东联通', 'http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010004&amp;amp;id=1677', 0, 0, 0, 4193, 0, 1, 0, NULL, 15, '', ''),
(6692, '1289791802', '深圳移动', 'http://gd.10086.cn/shenzhen/', 0, 0, 0, 4193, 0, 1, 0, NULL, 16, '', ''),
(6693, '1289791802', '广东电信', 'http://gd.ct10000.com/gz/', 0, 0, 0, 4193, 0, 1, 0, NULL, 17, '', ''),
(6694, '1289791802', '广州市房产管理局', 'http://www.laho.gov.cn/', 0, 0, 0, 4193, 0, 1, 0, NULL, 18, '', ''),
(6695, '1289791802', '焦点房产-广州', 'http://gz.focus.cn/', 0, 0, 0, 4193, 0, 1, 0, NULL, 19, '', ''),
(6696, '1289791802', '深圳房地产信息网', 'http://www.szhome.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 20, '', ''),
(6697, '1289791802', '搜房网-广州', 'http://gz.soufun.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 21, '', ''),
(6698, '1289791802', '搜房网-深圳', 'http://sz.soufun.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 22, '', ''),
(6699, '1289791802', '珠海房产之窗', 'http://www.zh51home.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 23, '', ''),
(8224, '1290230924', '上海天气预报', 'http://www.weather.com.cn/html/weather/101020100.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 2, '', ''),
(6701, '1289791802', '大众点评', 'http://www.dianping.com/guangzhou', 0, 0, 0, 4193, 0, 1, 0, NULL, 25, '', ''),
(6702, '1289791802', '星海音乐厅', 'http://www.concerthall.com.cn/', 0, 0, 0, 4193, 0, 1, 0, NULL, 26, '', ''),
(6703, '1289791802', 'qq团购网', 'http://tuan.qq.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 27, '', ''),
(6704, '1289791802', '深圳东部华侨城', 'http://www.octeast.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 28, '', ''),
(6705, '1289791802', '深圳欢乐谷', 'http://sz.happyvalley.cn/', 0, 0, 0, 4193, 0, 1, 0, NULL, 29, '', ''),
(6706, '1289791802', '珍惜网团购', 'http://www.zhenxi.com/', 0, 0, 0, 4193, 0, 1, 0, NULL, 30, '', ''),
(6708, '1289791828', '华南理工大学', 'http://www.scut.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 2, '', ''),
(6709, '1289791828', '暨南大学', 'http://www.jnu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 3, '', ''),
(6710, '1289791828', '华南农业大学', 'http://www.scau.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 4, '', ''),
(6711, '1289791828', '广东海洋大学', 'http://www.gdou.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 5, '', ''),
(6712, '1289791828', '广东工业大学', 'http://www.gdut.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 6, '', ''),
(6713, '1289791828', '广州大学', 'http://www.gzhu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 7, '', ''),
(6714, '1289791828', '华南师范大学', 'http://www.scnu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 8, '', ''),
(6715, '1289791828', '广东外语外贸大学', 'http://www.gdufs.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 9, '', ''),
(6716, '1289791828', '北京师范大学珠海分校', 'http://www.bnuep.com/', 0, 0, 0, 4194, 0, 1, 0, NULL, 10, '', ''),
(6717, '1289791828', '南方医科大学', 'http://www.smu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 11, '', ''),
(6718, '1289791828', '广东商学院', 'http://www.gdcc.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 12, '', ''),
(6719, '1289791828', '深圳大学', 'http://www.szu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 13, '', ''),
(6720, '1289791828', '汕头大学', 'http://www.stu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 14, '', ''),
(6721, '1289791828', '五邑大学', 'http://www.wyu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 15, '', ''),
(6722, '1289791828', '深圳职业技术学院', 'http://www.szpt.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 16, '', ''),
(6723, '1289791828', '广东医学院', 'http://www.gdmc.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 17, '', ''),
(6724, '1289791828', '广东金融学院', 'http://www.gduf.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 18, '', ''),
(6725, '1289791828', '惠州学院', 'http://www.hzu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 19, '', ''),
(6726, '1289791828', '广东石油化工学院', 'http://www.gdpa.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 20, '', ''),
(6727, '1289791828', '嘉应学院', 'http://www.jyu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 21, '', ''),
(6728, '1289791828', '联合国际学院', 'http://www.uic.edu.hk/admission', 0, 0, 0, 4194, 0, 1, 0, NULL, 22, '', ''),
(6729, '1289791828', '广东白云学院', 'http://www.bvtc.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 23, '', ''),
(6730, '1289791828', '星海音乐学院', 'http://www.xhcom.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 24, '', ''),
(6731, '1289791828', '吉林大学珠海学院', 'http://www.jluzh.com/', 0, 0, 0, 4194, 0, 1, 0, NULL, 25, '', ''),
(6732, '1289791828', '广州美术学院', 'http://www.gzarts.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 26, '', ''),
(6733, '1289791828', '广州中医药大学', 'http://www.gzhtcm.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 27, '', ''),
(6734, '1289791828', '广州医学院', 'http://www.gzhmc.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 28, '', ''),
(6735, '1289791828', '韶关学院', 'http://www.sgu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 29, '', ''),
(6736, '1289791828', '肇庆学院', 'http://www.zqu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 30, '', ''),
(6737, '1289791828', '北京理工大学珠海学院', 'http://www.zhbit.com/', 0, 0, 0, 4194, 0, 1, 0, NULL, 31, '', ''),
(6738, '1289791828', '湛江师范学院', 'http://www.zhjnc.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 32, '', ''),
(6739, '1289791828', '佛山科学技术学院', 'http://www.fosu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 33, '', ''),
(6740, '1289791828', '南华工商学院', 'http://www.nhic.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 34, '', ''),
(6741, '1289791828', '电子科技大学中山学院', 'http://www.zsc.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 35, '', ''),
(6742, '1289791828', '韩山师范学院', 'http://www.hstc.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 36, '', ''),
(6743, '1289791828', '广东第二师范学院', 'http://www.gdei.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 37, '', ''),
(6744, '1289791828', '广州民航职业技术学院', 'http://www.caac.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 38, '', ''),
(6745, '1289791828', '广州航海高等专科学校', 'http://www.gzhmt.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 39, '', ''),
(6746, '1289791828', '仲恺农业工程学院', 'http://www.zhku.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 40, '', ''),
(6747, '1289791828', '广东邮电职业技术学院', 'http://www.gupt.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 41, '', ''),
(6748, '1289791828', '广东警官学院', 'http://www.gdppla.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 42, '', ''),
(6749, '1289791828', '东莞理工学院', 'http://www.dgut.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 43, '', ''),
(6750, '1289791828', '广州体育学院', 'http://www.gipe.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 44, '', ''),
(6751, '1289791828', '佛山职业技术学院', 'http://www.fspt.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 45, '', ''),
(6752, '1289791828', '广东水利电力职业技术学院', 'http://www.gdsdxy.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 46, '', ''),
(6753, '1289791828', '广东轻工职业技术学院', 'http://www.gdqy.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 47, '', ''),
(6754, '1289791828', '广东松山职业技术学院', 'http://www.gdsspt.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 48, '', ''),
(6755, '1289791828', '广东药学院', 'http://www.gdpu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 49, '', ''),
(6756, '1289791828', '揭阳职业技术学院', 'http://www.jyc.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 50, '', ''),
(6757, '1289791828', '广东理工职业学院', 'http://www.gdpi.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 51, '', ''),
(6758, '1289791828', '广东技术师范学院', 'http://www.gdin.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 52, '', ''),
(6759, '1289791828', '广东机电职业技术学院', 'http://www.gdmec.com/', 0, 0, 0, 4194, 0, 1, 0, NULL, 53, '', ''),
(6760, '1289791828', '广东岭南职业技术学院', 'http://www.lingnancollege.com.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 54, '', ''),
(6761, '1289791828', '广州番禺职业技术学院', 'http://www.pyp.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 55, '', ''),
(6762, '1289791828', '河源职业技术学院', 'http://www.hycollege.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 56, '', ''),
(6763, '1289791828', '肇庆工商职业技术学院', 'http://www.zqtbu.com/', 0, 0, 0, 4194, 0, 1, 0, NULL, 57, '', ''),
(6764, '1289791828', '广东女子职业技术学院', 'http://www.gdfs.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 58, '', ''),
(6765, '1289791828', '广州城市职业学院', 'http://www.gcp.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 59, '', ''),
(6766, '1289791828', '广东工贸职业技术学院', 'http://www.gdgm.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 60, '', ''),
(6767, '1289791828', '广东交通职业技术学院', 'http://www.gdcp.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 61, '', ''),
(6768, '1289791828', '广东建设职业技术学院', 'http://www.gdcvi.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 62, '', ''),
(6769, '1289791828', '清远职业技术学院', 'http://www.qypt.com.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 63, '', ''),
(6770, '1289791828', '中山职业技术学院', 'http://www.zspt.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 64, '', ''),
(6771, '1289791828', '广东科学技术职业学院', 'http://www.gdit.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 65, '', ''),
(6772, '1289791828', '广州华南商贸职业学院', 'http://www.hnsmxy.com/', 0, 0, 0, 4194, 0, 1, 0, NULL, 66, '', ''),
(6773, '1289791828', '广州铁路职业技术学院', 'http://www.gtxy.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 67, '', ''),
(6774, '1289791828', '广东技术师范学院', 'http://www.gdin.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 68, '', ''),
(6775, '1289791828', '广东培正学院', 'http://www.peizheng.com.cn/Index.html', 0, 0, 0, 4194, 0, 1, 0, NULL, 69, '', ''),
(6776, '1289791828', '肇庆医学高等专科学校', 'http://www.zqyz.gd.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 70, '', ''),
(6777, '1289791828', '私立华联学院', 'http://www.hlu.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 71, '', ''),
(6778, '1289791828', '广东食品药品职业学院', 'http://www.gdyzy.edu.cn/Pages/default.aspx', 0, 0, 0, 4194, 0, 1, 0, NULL, 72, '', ''),
(6779, '1289791828', '广东外语外贸大学南国商学院', 'http://nanguo.gdufs.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 73, '', ''),
(6780, '1289791828', '广东新安职业技术学院', 'http://www.gdxa.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 74, '', ''),
(6781, '1289791828', '顺德职业技术学院', 'http://www.sdpt.com.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 75, '', ''),
(6782, '1289791828', '潮汕职业技术学院', 'http://www.chaoshan.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 76, '', ''),
(6783, '1289791828', '阳江职业技术学院', 'http://www.yjcollege.net/index/yjcollege_index2010.asp', 0, 0, 0, 4194, 0, 1, 0, NULL, 77, '', ''),
(6784, '1289791828', '广州珠江职业技术学院', 'http://www.gzzjedu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 78, '', ''),
(6785, '1289791828', '广州科技职业技术学院', 'http://www.gzkjxy.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 79, '', ''),
(6786, '1289791828', '广州城建职业学院', 'http://www.gzccc.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 80, '', ''),
(6787, '1289791828', '广州信息工程职业技术学院', 'http://www.gzmodern.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 81, '', ''),
(6788, '1289791828', '广州体育职业技术学院', 'http://121.8.99.245/school/ccAction%21showNews.action', 0, 0, 0, 4194, 0, 1, 0, NULL, 82, '', ''),
(6789, '1289791828', '湛江现代科技职业学院', 'http://www.zmstu.org.cn/Index.html', 0, 0, 0, 4194, 0, 1, 0, NULL, 83, '', ''),
(6790, '1289791828', '广东体育职业技术学院', 'http://www.gdvcp.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 84, '', ''),
(6791, '1289791828', '广东行政职业学院', 'http://www.gdxzzy.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 85, '', ''),
(6792, '1289791828', '珠海城市职业技术学院', 'http://www.zhcpt.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 86, '', ''),
(6793, '1289791828', '惠州经济职业技术学院', 'http://www.hzcollege.com/', 0, 0, 0, 4194, 0, 1, 0, NULL, 87, '', ''),
(6794, '1289791828', '茂名职业技术学院', 'http://www.mmvtc.cn/templet/default/', 0, 0, 0, 4194, 0, 1, 0, NULL, 88, '', ''),
(6795, '1289791828', '广州工程技术职业学院', 'http://www.gzvtc.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 89, '', ''),
(6796, '1289791828', '东莞南博职业技术学院', 'http://www.gdnanbo.com/index.html', 0, 0, 0, 4194, 0, 1, 0, NULL, 90, '', ''),
(6797, '1289791828', '广州工商职业技术学院', 'http://www.gzgs.org.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 91, '', ''),
(6798, '1289791828', '广州华立科技职业学院', 'http://www.hlxy.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 92, '', ''),
(6799, '1289791828', '广东工程职业技术学院', 'http://www.gpc.net.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 93, '', ''),
(6800, '1289791828', '汕尾职业技术学院', 'http://www.swvtc.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 94, '', ''),
(6801, '1289791828', '广州科技贸易职业学院', 'http://www.gzkmu.cn/cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 95, '', ''),
(6802, '1289791828', '广州涉外经济职业技术学院', 'http://www.gziec.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 96, '', ''),
(6803, '1289791828', '广东司法警官职业学院', 'http://www.gdsfjy.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 97, '', ''),
(6804, '1289791828', '深圳信息职业技术学院', 'http://www.sziit.com.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 98, '', ''),
(6805, '1289791828', '广东亚视演艺职业学院', 'http://www.atvcn.com/', 0, 0, 0, 4194, 0, 1, 0, NULL, 99, '', ''),
(6806, '1289791828', '汕头职业技术学院', 'http://stzy.stedu.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 100, '', ''),
(6807, '1289791828', '中山火炬职业技术学院', 'http://www.zstp.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 101, '', ''),
(6808, '1289791828', '江门职业技术学院', 'http://www.jmpt.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 102, '', ''),
(6809, '1289791828', '广东省外语艺术职业学院', 'http://www.gtcfla.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 103, '', ''),
(6810, '1289791828', '广东纺织职业技术学院', 'http://www.gditt.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 104, '', ''),
(6811, '1289791828', '罗定职业技术学院', 'http://www.ldpoly.com/', 0, 0, 0, 4194, 0, 1, 0, NULL, 105, '', ''),
(6812, '1289791828', '广东科贸职业学院', 'http://www.gdkm.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 106, '', ''),
(6813, '1289791828', '广东海洋大学寸金学院', 'http://www.gdcjxy.com/', 0, 0, 0, 4194, 0, 1, 0, NULL, 107, '', ''),
(6814, '1289791828', '广东文艺职业学院', 'http://www.gdla.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 108, '', ''),
(6815, '1289791828', '珠海艺术职业学院', 'http://www.zhac.net/', 0, 0, 0, 4194, 0, 1, 0, NULL, 109, '', ''),
(6816, '1289791828', '南海东软信息技术职业学院', 'http://nanhai.neusoft.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 110, '', ''),
(6817, '1289791828', '广州康大职业技术学院', 'http://www.kdvtc-edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 111, '', ''),
(6818, '1289791828', '广州华商职业学院', 'http://www.gzhsvc.com/', 0, 0, 0, 4194, 0, 1, 0, NULL, 112, '', ''),
(6819, '1289791828', '广州华夏职业学院', 'http://www.gzhxtc.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 113, '', ''),
(6820, '1289791828', '华南师范大学增城学院', 'http://www.scnuzc.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 114, '', ''),
(6821, '1289791828', '广州大学松田学院', 'http://www2.sontan.net/index.do', 0, 0, 0, 4194, 0, 1, 0, NULL, 115, '', ''),
(6822, '1289791828', '东莞理工学院城市学院', 'http://csxy.dgut.edu.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 116, '', ''),
(6823, '1289791828', '中山大学新华学院', 'http://xh.sysu.edu.cn/web2009/', 0, 0, 0, 4194, 0, 1, 0, NULL, 117, '', ''),
(6824, '1289791828', '华南理工大学广州汽车学院', 'http://www.gzauto.org/', 0, 0, 0, 4194, 0, 1, 0, NULL, 118, '', ''),
(6825, '1289791828', '广州大学华软软件学院', 'http://www.sise.com.cn/', 0, 0, 0, 4194, 0, 1, 0, NULL, 119, '', ''),
(6826, '1289791828', '中山大学南方学院', 'http://www.nfsysu.cn/2010/', 0, 0, 0, 4194, 0, 1, 0, NULL, 120, '', ''),
(6827, '1289791828', '华南理工大学广州汽车学院', 'http://www.gzauto.org/', 0, 0, 0, 4194, 0, 1, 0, NULL, 121, '', ''),
(6828, '1289791872', '广东贴吧', 'http://tieba.baidu.com/f?kw=%B9%E3%B6%AB', 0, 0, 0, 4195, 0, 1, 0, NULL, 1, '', ''),
(6829, '1289791872', '广东发展论坛', 'http://bbs.gd.gov.cn/', 0, 0, 0, 4195, 0, 1, 0, NULL, 2, '', ''),
(6830, '1289791872', '广州妈妈网', 'http://www.gzmama.com/', 0, 0, 0, 4195, 0, 1, 0, NULL, 3, '', ''),
(6831, '1289791872', '广州社区', 'http://club.gznet.com/', 0, 0, 0, 4195, 0, 1, 0, NULL, 4, '', ''),
(6832, '1289791872', '深圳社区', 'http://club.sz.net.cn/', 0, 0, 0, 4195, 0, 1, 0, NULL, 5, '', ''),
(6833, '1289791872', '河源论坛', 'http://bbs.076299.com/', 0, 0, 0, 4195, 0, 1, 0, NULL, 6, '', ''),
(6834, '1289791872', '佛山魔盒社区', 'http://bbs.fsbox.net/', 0, 0, 0, 4195, 0, 1, 0, NULL, 7, '', ''),
(6835, '1289791872', '广州学生网', 'http://bbs.gz4u.net/', 0, 0, 0, 4195, 0, 1, 0, NULL, 8, '', ''),
(6836, '1289791872', '高明论坛', 'http://www.528500.com/default3.php', 0, 0, 0, 4195, 0, 1, 0, NULL, 9, '', ''),
(6837, '1289791872', '惠州乐乐论坛', 'http://bbs.hzyes.com/', 0, 0, 0, 4195, 0, 1, 0, NULL, 10, '', ''),
(6838, '1289791872', '罗定E天空', 'http://www.ld0766.com/', 0, 0, 0, 4195, 0, 1, 0, NULL, 11, '', ''),
(6839, '1289791872', '汕头e京网', 'http://www.ezeem.com/', 0, 0, 0, 4195, 0, 1, 0, NULL, 12, '', ''),
(6840, '1289791872', '揭阳星空论坛', 'http://bbs.0663.net/', 0, 0, 0, 4195, 0, 1, 0, NULL, 13, '', ''),
(6841, '1289791872', '大埔论坛', 'http://bbs.514200.com/', 0, 0, 0, 4195, 0, 1, 0, NULL, 14, '', ''),
(6842, '1289791872', '潮州小桥流水', 'http://www.521000.com/bbs/', 0, 0, 0, 4195, 0, 1, 0, NULL, 15, '', ''),
(6843, '1289791872', '英德小虫网', 'http://bbs.e763.com/', 0, 0, 0, 4195, 0, 1, 0, NULL, 16, '', ''),
(6844, '1289791890', '工商局', 'http://www.gdgs.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 1, '', ''),
(6845, '1289791890', '公安厅', 'http://www.gdga.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 2, '', ''),
(6846, '1289791890', '教育厅', 'http://www.gdhed.edu.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 3, '', ''),
(6847, '1289791890', '财政厅', 'http://www.gdczt.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 4, '', ''),
(6848, '1289791890', '交通厅', 'http://www.gdcd.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 5, '', ''),
(6849, '1289791890', '农业厅', 'http://www.gd.agri.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 6, '', ''),
(6850, '1289791890', '出入境管理处', 'http://crj.gdga.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 7, '', ''),
(6851, '1289791890', '发展和改革委员会', 'http://www.gddpc.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 8, '', ''),
(6852, '1289791890', '珠海市', 'http://www.zhuhai.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 9, '', ''),
(6853, '1289791890', '汕头市', 'http://www.shantou.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 10, '', ''),
(6854, '1289791890', '佛山市', 'http://www.foshan.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 11, '', ''),
(6855, '1289791890', '梅州市', 'http://www.meizhou.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 12, '', ''),
(6856, '1289791890', '惠州市', 'http://www.huizhou.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 13, '', ''),
(6857, '1289791890', '茂名市', 'http://www.maoming.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 14, '', ''),
(6858, '1289791890', '河源市', 'http://www.heyuan.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 15, '', ''),
(6859, '1289791890', '肇庆市', 'http://www.zhaoqing.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 16, '', ''),
(6860, '1289791890', '东莞市', 'http://www.dongguan.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 17, '', ''),
(6861, '1289791890', '中山市', 'http://www.zs.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 18, '', ''),
(6862, '1289791890', '江门市', 'http://www.jiangmen.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 19, '', ''),
(6863, '1289791890', '阳江市', 'http://www.yangjiang.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 20, '', ''),
(6864, '1289791890', '湛江市', 'http://www.zhanjiang.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 21, '', ''),
(6865, '1289791890', '汕尾市', 'http://www.shanwei.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 22, '', ''),
(6866, '1289791890', '潮州市', 'http://www.chaozhou.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 23, '', ''),
(6867, '1289791890', '揭阳市', 'http://www.jieyang.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 24, '', ''),
(6868, '1289791890', '云浮市', 'http://www.yunfu.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 25, '', ''),
(6869, '1289791890', '韶关市', 'http://www.shaoguan.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 26, '', ''),
(6870, '1289791890', '清远市', 'http://www.gdqy.gov.cn/', 0, 0, 0, 4196, 0, 1, 0, NULL, 27, '', ''),
(6873, '1289792118', '文昌市', 'http://www.wenchang.gov.cn/', 0, 0, 0, 4201, 0, 1, 0, NULL, 3, '', ''),
(6874, '1289792118', '万宁市', 'http://wanning.hainan.gov.cn/', 0, 0, 0, 4201, 0, 1, 0, NULL, 4, '', ''),
(6875, '1289792118', '琼海市', 'http://www.qionghai.gov.cn/', 0, 0, 0, 4201, 0, 1, 0, NULL, 5, '', ''),
(6876, '1289792118', '东方市', 'http://dongfang.hainan.gov.cn/', 0, 0, 0, 4201, 0, 1, 0, NULL, 6, '', ''),
(6877, '1289792118', '五指山市', 'http://www.wzs.gov.cn/', 0, 0, 0, 4201, 0, 1, 0, NULL, 7, '', ''),
(6878, '1289792118', '海口网', 'http://www.hkwb.net/', 0, 0, 0, 4201, 0, 1, 0, NULL, 8, '', ''),
(6879, '1289792139', '蓝网', 'http://www.bluehn.com/', 0, 0, 0, 4202, 0, 1, 0, NULL, 1, '', ''),
(6880, '1289792139', '新华网海南频道', 'http://www.hq.xinhuanet.com/', 0, 0, 0, 4202, 0, 1, 0, NULL, 2, '', ''),
(6881, '1289792139', '人民网海南视窗', 'http://hi.people.com.cn/', 0, 0, 0, 4202, 0, 1, 0, NULL, 3, '', ''),
(6882, '1289792139', '海口广播电视台', 'http://www.haikoutv.com/', 0, 0, 0, 4202, 0, 1, 0, NULL, 4, '', ''),
(6883, '1289792139', '海南经济报', 'http://www.hnjjb.com/', 0, 0, 0, 4202, 0, 1, 0, NULL, 5, '', ''),
(6884, '1289792139', '琼海在线', 'http://www.qionghi.com/', 0, 0, 0, 4202, 0, 1, 0, NULL, 6, '', ''),
(6885, '1289792139', '南国都市报', 'http://ngdsb.hinews.cn/', 0, 0, 0, 4202, 0, 1, 0, NULL, 7, '', ''),
(6886, '1289792139', '海口晚报', 'http://press.idoican.com.cn/detail/newspapers/812/', 0, 0, 0, 4202, 0, 1, 0, NULL, 8, '', ''),
(6887, '1289792139', '中新海南网', 'http://www.hi.chinanews.com.cn/', 0, 0, 0, 4202, 0, 1, 0, NULL, 9, '', ''),
(6888, '1289792139', '证券导报', 'http://zqdb.hinews.cn/', 0, 0, 0, 4202, 0, 1, 0, NULL, 10, '', ''),
(6889, '1289792139', '法制时报', 'http://fzsb.hinews.cn/', 0, 0, 0, 4202, 0, 1, 0, NULL, 11, '', ''),
(6890, '1289792139', '国际旅游岛商报', 'http://www.hndnews.com/', 0, 0, 0, 4202, 0, 1, 0, NULL, 12, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(6891, '1289792139', '海南农垦报', 'http://www.hnnkb.cn/', 0, 0, 0, 4202, 0, 1, 0, NULL, 13, '', ''),
(6892, '1289792189', '海南气象', 'http://mb.hainan.gov.cn/', 0, 0, 0, 4203, 0, 1, 0, NULL, 1, '', ''),
(6893, '1289792189', '海南航空公司', 'http://www.hnair.com/', 0, 0, 0, 4203, 0, 1, 0, NULL, 2, '', ''),
(6894, '1289792189', '百度地图－三亚', 'http://map.baidu.com/#word=%E4%B8%89%E4%BA%9A&amp;amp;ct=10', 0, 0, 0, 4203, 0, 1, 0, NULL, 3, '', ''),
(6895, '1289792189', '海口公交', 'http://www.hainan.gov.cn/V3/bus/', 0, 0, 0, 4203, 0, 1, 0, NULL, 4, '', ''),
(6896, '1289792189', '百度地图－海口', 'http://map.baidu.com/#word=%E6%B5%B7%E5%8F%A3%E5%B8%82&amp;amp;ct=10', 0, 0, 0, 4203, 0, 1, 0, NULL, 5, '', ''),
(6897, '1289792189', '海南移动', 'http://www.hi.10086.cn/', 0, 0, 0, 4203, 0, 1, 0, NULL, 6, '', ''),
(6898, '1289792189', '海南联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010005&amp;amp;id=1645', 0, 0, 0, 4203, 0, 1, 0, NULL, 7, '', ''),
(6899, '1289792189', '海南电信', 'http://hi.ct10000.com/', 0, 0, 0, 4203, 0, 1, 0, NULL, 8, '', ''),
(6900, '1289792189', '海南英才网', 'http://www.hainanhr.com/', 0, 0, 0, 4203, 0, 1, 0, NULL, 9, '', ''),
(6901, '1289792189', '海南人才在线', 'http://job.hainan.net/', 0, 0, 0, 4203, 0, 1, 0, NULL, 10, '', ''),
(6902, '1289792189', '海口人才网', 'http://www.haijob.com/', 0, 0, 0, 4203, 0, 1, 0, NULL, 11, '', ''),
(6903, '1289792189', '三亚人才网', 'http://www.sanyajob.com/', 0, 0, 0, 4203, 0, 1, 0, NULL, 12, '', ''),
(6904, '1289792189', '海南在线房产频道', 'http://house.hainan.net/', 0, 0, 0, 4203, 0, 1, 0, NULL, 13, '', ''),
(6905, '1289792189', '海口住宅与房产信息网', 'http://www.hkrealestate.gov.cn/', 0, 0, 0, 4203, 0, 1, 0, NULL, 14, '', ''),
(6906, '1289792189', '海南住房公积金网', 'http://www.hngjj.net/', 0, 0, 0, 4203, 0, 1, 0, NULL, 15, '', ''),
(6907, '1289792211', '海口经济学院', 'http://www.hkc.edu.cn/', 0, 0, 0, 4204, 0, 1, 0, NULL, 1, '', ''),
(6908, '1289792211', '海南职业技术学院', 'http://www.hcvt.cn', 0, 0, 0, 4204, 0, 1, 0, NULL, 2, '', ''),
(6909, '1289792211', '海南医学院', 'http://www.hainmc.edu.cn/', 0, 0, 0, 4204, 0, 1, 0, NULL, 3, '', ''),
(6910, '1289792211', '海南师范大\r\n\r\n学', 'http://www.hainnu.edu.cn/', 0, 0, 0, 4204, 0, 1, 0, NULL, 4, '', ''),
(6911, '1289792211', '海南大学', 'http://www.hainu.edu.cn/', 0, 0, 0, 4204, 0, 1, 0, NULL, 5, '', ''),
(6912, '1289792211', '三亚航空旅游职业学院', 'http://www.hnasatc.com/', 0, 0, 0, 4204, 0, 1, 0, NULL, 6, '', ''),
(6913, '1289792211', '海南大学三亚学院', 'http://www.syxyhn.com/', 0, 0, 0, 4204, 0, 1, 0, NULL, 7, '', ''),
(6914, '1289792211', '海南外国语职业学院', 'http://www.hnflvc.com/', 0, 0, 0, 4204, 0, 1, 0, NULL, 8, '', ''),
(6915, '1289792211', '海南政法职业学院', 'http://www.hnplc.com/', 0, 0, 0, 4204, 0, 1, 0, NULL, 9, '', ''),
(6916, '1289792211', '海南经贸职业技术学院', 'http://www.hnjmc.com/', 0, 0, 0, 4204, 0, 1, 0, NULL, 10, '', ''),
(6917, '1289792211', '琼州学院', 'http://www.qzu.edu.cn/', 0, 0, 0, 4204, 0, 1, 0, NULL, 11, '', ''),
(6918, '1289792211', '琼台师范高等专科学校', 'http://www.qttc.edu.cn/', 0, 0, 0, 4204, 0, 1, 0, NULL, 12, '', ''),
(6919, '1289792211', '海南工商职业学院', 'http://www.hntbc.com/', 0, 0, 0, 4204, 0, 1, 0, NULL, 13, '', ''),
(6920, '1289792211', '三亚理工职业学院', 'http://www.nm.zsks.cn/yxjs/sylgxy.htm', 0, 0, 0, 4204, 0, 1, 0, NULL, 14, '', ''),
(6921, '1289792211', '海南软件职业技术学院', 'http://www.hnspi.net/', 0, 0, 0, 4204, 0, 1, 0, NULL, 15, '', ''),
(6922, '1289792233', '大三亚', 'http://www.dasanya.com/', 0, 0, 0, 4205, 0, 1, 0, NULL, 1, '', ''),
(6923, '1289792233', '知己网', 'http://www.zhiji.com/', 0, 0, 0, 4205, 0, 1, 0, NULL, 2, '', ''),
(6924, '1289792233', '椰子树下', 'http://chat.hk.hi.cn/', 0, 0, 0, 4205, 0, 1, 0, NULL, 3, '', ''),
(6925, '1289792233', '琼岛社区', 'http://www.qiongdao.cn/', 0, 0, 0, 4205, 0, 1, 0, NULL, 4, '', ''),
(6926, '1289792233', '海南大学起点论坛', 'http://www.ihain.cn/', 0, 0, 0, 4205, 0, 1, 0, NULL, 5, '', ''),
(6927, '1289792233', '搜狐社区海南', 'http://club.gd.sohu.com/l-hainan-0-0-0-0.html', 0, 0, 0, 4205, 0, 1, 0, NULL, 6, '', ''),
(6928, '1289792233', '海南旅游论坛', 'http://bbs.898.travel/', 0, 0, 0, 4205, 0, 1, 0, NULL, 7, '', ''),
(6929, '1279617741', '百度文库', 'http://wenku.baidu.com/', 0, 0, 0, 3083, 0, 1, 0, NULL, 1, '', ''),
(6930, '1279617741', '豆丁网', 'http://www.docin.com/', 0, 0, 0, 3083, 0, 1, 0, NULL, 2, '', ''),
(6931, '1279617741', '360doc', 'http://www.360doc.com/', 0, 0, 0, 3083, 0, 1, 0, NULL, 3, '', ''),
(6932, '1279617741', '新浪共享', 'http://ishare.iask.sina.com.cn/', 0, 0, 0, 3083, 0, 1, 0, NULL, 4, '', ''),
(6933, '1279617741', '中国知网', 'http://www.cnki.net/', 0, 0, 0, 3083, 0, 1, 0, NULL, 5, '', ''),
(6934, '1279617741', '无忧ppt', 'http://www.51ppt.com.cn/', 0, 0, 0, 3083, 0, 1, 0, NULL, 6, '', ''),
(6935, '1279617741', '道客巴巴', 'http://www.doc88.com/', 0, 0, 0, 3083, 0, 1, 0, NULL, 7, '', ''),
(6936, '1279617741', '万方数据库', 'http://www.wanfangdata.com.cn/', 0, 0, 0, 3083, 0, 1, 0, NULL, 8, '', ''),
(6937, '1279617741', '个人简历', 'http://wenku.baidu.com/view/d89ef605cc17552707220864.html', 0, 0, 0, 3084, 0, 1, 0, NULL, 1, '', ''),
(6938, '1279617741', '通知', 'http://wenku.baidu.com/search?word=%CD%A8%D6%AA&lm=0&od=0', 0, 0, 0, 3084, 0, 1, 0, NULL, 1, '', ''),
(6939, '1279617741', '申请书', 'http://wenku.baidu.com/search?word=%C9%EA%C7%EB%CA%E9&lm=0&od=0', 0, 0, 0, 3084, 0, 1, 0, NULL, 1, '', ''),
(6940, '1279617741', '演讲致辞', 'http://wenku.baidu.com/search?word=%D1%DD%BD%B2%D6%C2%B4%C7&lm=0&od=0', 0, 0, 0, 3084, 0, 1, 0, NULL, 1, '', ''),
(6941, '1279617741', '合同协议', 'http://wenku.baidu.com/search?word=%BA%CF%CD%AC%D0%AD%D2%E9+&lm=0&od=0', 0, 0, 0, 3084, 0, 1, 0, NULL, 1, '', ''),
(6942, '1279617741', '工作计划', 'http://wenku.baidu.com/search?word=%B9%A4%D7%F7%BC%C6%BB%AE&lm=0&od=0', 0, 0, 0, 3084, 0, 1, 0, NULL, 1, '', ''),
(6943, '1279617741', '工作总结', 'http://wenku.baidu.com/search?word=%B9%A4%D7%F7%D7%DC%BD%E1&lm=0&od=0', 0, 0, 0, 3084, 0, 1, 0, NULL, 1, '', ''),
(6944, '1279617741', '调研报告', 'http://wenku.baidu.com/search?word=%B5%F7%D1%D0%B1%A8%B8%E6&lm=0&od=0', 0, 0, 0, 3084, 0, 1, 0, NULL, 1, '', ''),
(6945, '1279617741', 'PPT模板', 'http://wenku.baidu.com/search?word=PPT%C4%A3%B0%E5&lm=0&od=0', 0, 0, 0, 3084, 0, 1, 0, NULL, 1, '', ''),
(6946, '1279617741', '个人先进事迹材料', 'http://wenku.baidu.com/search?word=%B8%F6%C8%CB%CF%C8%BD%F8%CA%C2%BC%A3%B2%C4%C1%CF&lm=0&od=0', 0, 0, 0, 3085, 0, 1, 0, NULL, 1, '', ''),
(6947, '1279617741', '入党申请书', 'http://wenku.baidu.com/search?word=%C8%EB%B5%B3%C9%EA%C7%EB%CA%E9&lm=0&od=0', 0, 0, 0, 3085, 0, 1, 0, NULL, 2, '', ''),
(6948, '1279617741', '思想汇报', 'http://wenku.baidu.com/search?word=%CB%BC%CF%EB%BB%E3%B1%A8&lm=0&od=0', 0, 0, 0, 3085, 0, 1, 0, NULL, 3, '', ''),
(6949, '1279617741', '自我介绍', 'http://wenku.baidu.com/search?word=%D7%D4%CE%D2%BD%E9%C9%DC&lm=0&od=0', 0, 0, 0, 3085, 0, 1, 0, NULL, 4, '', ''),
(6950, '1279617741', '奖学金申请书', 'http://wenku.baidu.com/search?word=%BD%B1%D1%A7%BD%F0%C9%EA%C7%EB%CA%E9&lm=0&od=0', 0, 0, 0, 3085, 0, 1, 0, NULL, 5, '', ''),
(6951, '1279617741', '自我鉴定', 'http://wenku.baidu.com/search?word=%D7%D4%CE%D2%BC%F8%B6%A8&lm=0&od=0', 0, 0, 0, 3085, 0, 1, 0, NULL, 6, '', ''),
(6952, '1279617741', '谚语大全', 'http://wenku.baidu.com/search?word=%D1%E8%D3%EF%B4%F3%C8%AB&lm=0&od=0', 0, 0, 0, 3085, 0, 1, 0, NULL, 7, '', ''),
(6953, '1289792252', '气象局', 'http://mb.hainan.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 1, '', ''),
(6954, '1289792252', '旅游发展委员会', 'http://tourism.hainan.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 2, '', ''),
(6955, '1289792252', '血液中心', 'http://www.blood.org.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 3, '', ''),
(6956, '1289792252', '海洋与渔业厅', 'http://dof.hainan.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 4, '', ''),
(6957, '1289792252', '农业厅', 'http://www.hiagri.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 5, '', ''),
(6958, '1289792252', '地方税务局', 'http://tax.hainan.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 6, '', ''),
(6959, '1289792252', '发改委', 'http://plan.hainan.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 7, '', ''),
(6960, '1289792252', '检察院', 'http://www.hi.jcy.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 8, '', ''),
(6961, '1289792252', '天涯法律网', 'http://www.hicourt.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 9, '', ''),
(6962, '1289792252', '财政厅', 'http://mof.hainan.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 10, '', ''),
(6963, '1289792252', '教育厅', 'http://edu.hainan.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 11, '', ''),
(6964, '1289792252', '考试局', 'http://ea.hainan.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 12, '', ''),
(6965, '1289792252', '人力资源和社会保障厅', 'http://hi.lss.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 13, '', ''),
(6966, '1289792252', '海南民政', 'http://minzheng.hainan.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 14, '', ''),
(6967, '1289792252', '公安厅', 'http://ga.hainan.gov.cn/', 0, 0, 0, 4206, 0, 1, 0, NULL, 15, '', ''),
(6968, '1289792315', '天府热线', 'http://www.tfol.com/', 0, 0, 0, 4211, 0, 1, 0, NULL, 1, '', ''),
(6969, '1289792315', '宜宾新闻网', 'http://www.ybxww.com/', 0, 0, 0, 4211, 0, 1, 0, NULL, 2, '', ''),
(6970, '1289792315', '广元热线', 'http://www.gy169.net/', 0, 0, 0, 4211, 0, 1, 0, NULL, 3, '', ''),
(6971, '1289792315', '宜宾泡菜坛', 'http://www.ybbbs.com/', 0, 0, 0, 4211, 0, 1, 0, NULL, 4, '', ''),
(6972, '1289792315', '自贡在线', 'http://www.zg163.net/', 0, 0, 0, 4211, 0, 1, 0, NULL, 5, '', ''),
(6973, '1289792315', '资阳大众网', 'http://www.my0832.com/', 0, 0, 0, 4211, 0, 1, 0, NULL, 6, '', ''),
(6974, '1289792315', '乐山新闻网', 'http://www.leshan.cn/', 0, 0, 0, 4211, 0, 1, 0, NULL, 7, '', ''),
(6975, '1289792315', '宜宾零距离', 'http://www.ybvv.com/', 0, 0, 0, 4211, 0, 1, 0, NULL, 8, '', ''),
(6976, '1289792333', '四川在线', 'http://www.scol.com.cn/', 0, 0, 0, 4212, 0, 1, 0, NULL, 1, '', ''),
(6977, '1289792333', '天府热线', 'http://www.tfol.com/', 0, 0, 0, 4212, 0, 1, 0, NULL, 2, '', ''),
(6978, '1289792333', '四川电视台', 'http://www.sctv.com/', 0, 0, 0, 4212, 0, 1, 0, NULL, 3, '', ''),
(6979, '1289792333', '四川新闻网', 'http://www.newssc.org/', 0, 0, 0, 4212, 0, 1, 0, NULL, 4, '', ''),
(6980, '1289792333', '四川省政府', 'http://www.sc.gov.cn/', 0, 0, 0, 4212, 0, 1, 0, NULL, 5, '', ''),
(6981, '1289792333', '新华网四川频道', 'http://www.sc.xinhuanet.com/', 0, 0, 0, 4212, 0, 1, 0, NULL, 6, '', ''),
(6982, '1289792333', '成都电视台', 'http://www.chengdutv.com/', 0, 0, 0, 4212, 0, 1, 0, NULL, 7, '', ''),
(6983, '1289792333', '大成网', 'http://cd.qq.com/', 0, 0, 0, 4212, 0, 1, 0, NULL, 8, '', ''),
(6984, '1289792333', '成都商报', 'http://e.cdqss.com/', 0, 0, 0, 4212, 0, 1, 0, NULL, 9, '', ''),
(6985, '1289792333', '天虎网', 'http://www.tyfo.com/', 0, 0, 0, 4212, 0, 1, 0, NULL, 10, '', ''),
(6986, '1289792333', '中新网四川频道', 'http://www.sc.chinanews.com.cn/', 0, 0, 0, 4212, 0, 1, 0, NULL, 11, '', ''),
(6987, '1289792333', '西部在线', 'http://www.xbol.net/', 0, 0, 0, 4212, 0, 1, 0, NULL, 12, '', ''),
(6988, '1289792333', '四川警察网', 'http://www.scga.gov.cn/', 0, 0, 0, 4212, 0, 1, 0, NULL, 13, '', ''),
(6989, '1289792333', '成都晚报', 'http://www.cdwb.com.cn/', 0, 0, 0, 4212, 0, 1, 0, NULL, 14, '', ''),
(6990, '1289792333', '四川热线', 'http://sichuanx.cn/', 0, 0, 0, 4212, 0, 1, 0, NULL, 15, '', ''),
(6991, '1289792333', '达州新闻网', 'http://www.dzxw.net/', 0, 0, 0, 4212, 0, 1, 0, NULL, 16, '', ''),
(6992, '1289792333', '四川日报', 'http://www.sichuandaily.com.cn/', 0, 0, 0, 4212, 0, 1, 0, NULL, 17, '', ''),
(6993, '1289792333', '成都日报', 'http://www.cdrb.com.cn/', 0, 0, 0, 4212, 0, 1, 0, NULL, 18, '', ''),
(6994, '1289792333', '泸州日报', 'http://lzrb.newssc.org/', 0, 0, 0, 4212, 0, 1, 0, NULL, 19, '', ''),
(6995, '1289792333', '华西都市报', 'http://www.wccdaily.com.cn/', 0, 0, 0, 4212, 0, 1, 0, NULL, 20, '', ''),
(6996, '1289792333', '天府早报', 'http://www.morning.sc.cn/', 0, 0, 0, 4212, 0, 1, 0, NULL, 21, '', ''),
(6997, '1289792333', '四川农村日报', 'http://www.country.sc.cn/', 0, 0, 0, 4212, 0, 1, 0, NULL, 22, '', ''),
(6998, '1289792333', '宜宾新闻网', 'http://www.ybxww.com/', 0, 0, 0, 4212, 0, 1, 0, NULL, 23, '', ''),
(6999, '1289792352', '四川在线论坛', 'http://bbs.scol.com.cn/', 0, 0, 0, 4213, 0, 1, 0, NULL, 1, '', ''),
(7000, '1289792352', '四川贴吧', 'http://tieba.baidu.com/f?kw=%E5%9B%9B%E5%B7%9D', 0, 0, 0, 4213, 0, 1, 0, NULL, 2, '', ''),
(7001, '1289792352', '乐山港', 'http://www.leshangang.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 3, '', ''),
(7002, '1289792352', '西秦会馆', 'http://bbs.zg163.net/', 0, 0, 0, 4213, 0, 1, 0, NULL, 4, '', ''),
(7003, '1289792352', '麻辣社区', 'http://club.newssc.org/', 0, 0, 0, 4213, 0, 1, 0, NULL, 5, '', ''),
(7004, '1289792352', '凤凰山下', 'http://bbs.dz169.net/', 0, 0, 0, 4213, 0, 1, 0, NULL, 6, '', ''),
(7005, '1289792352', '雨城论坛', 'http://bbs.yaanren.net', 0, 0, 0, 4213, 0, 1, 0, NULL, 7, '', ''),
(7006, '1289792352', '成都贴吧', 'http://tieba.baidu.com/f?kw=%B3%C9%B6%BC', 0, 0, 0, 4213, 0, 1, 0, NULL, 8, '', ''),
(7007, '1289792352', '百度知道-四川', 'http://zhidao.baidu.com/browse/258', 0, 0, 0, 4213, 0, 1, 0, NULL, 9, '', ''),
(7008, '1289792352', '第四城', 'http://www.028town.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 10, '', ''),
(7009, '1289792352', '最成都', 'http://rd.qihoo.com/qd.html?u=http%253A%252F%252Fforum.chengtu.com%252F&amp;amp;t=1271937337&amp;amp;c=1&amp;amp;a=9&amp;amp;p=6630&amp;amp;s=828a51b19e6256291fc7240b92f513c2', 0, 0, 0, 4213, 0, 1, 0, NULL, 11, '', ''),
(7010, '1289792352', '成都气象', 'http://www.cdmb.gov.cn/', 0, 0, 0, 4213, 0, 1, 0, NULL, 12, '', ''),
(7011, '1289792352', '百度地图-四川', 'http://map.baidu.com/#word=%E5%9B%9B%E5%B7%9D&amp;amp;ct=10', 0, 0, 0, 4213, 0, 1, 0, NULL, 13, '', ''),
(7012, '1289792352', '成都公交', 'http://chengdu.8684.cn/', 0, 0, 0, 4213, 0, 1, 0, NULL, 14, '', ''),
(7013, '1289792352', '列车时刻', 'http://lieche.5w.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 15, '', ''),
(7014, '1289792352', '成都双流国际机场', 'http://www.cdairport.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 16, '', ''),
(7015, '1289792352', '成都火车站', 'http://www.cdcz.net/', 0, 0, 0, 4213, 0, 1, 0, NULL, 17, '', ''),
(7016, '1289792352', '携程旅行-四川', 'http://destguides.ctrip.com/china/sichuan/region9/', 0, 0, 0, 4213, 0, 1, 0, NULL, 18, '', ''),
(7017, '1289792352', '四川旅游信息网', 'http://rd.qihoo.com/qd.html?u=http%253A%252F%252Fwww.scta.gov.cn%252F&amp;amp;t=1271937373&amp;amp;c=1&amp;amp;a=9&amp;amp;p=6631&amp;amp;s=9b6b64bbd997599e025327adb129d7ab', 0, 0, 0, 4213, 0, 1, 0, NULL, 19, '', ''),
(7018, '1289792352', '成都欢乐谷', 'http://www.cdhlg.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 20, '', ''),
(7019, '1289792352', '九寨沟', 'http://www.jiuzhai.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 21, '', ''),
(7020, '1289792352', '四姑娘山', 'http://www.sgns.gov.cn/', 0, 0, 0, 4213, 0, 1, 0, NULL, 22, '', ''),
(7021, '1289792352', '峨眉山', 'http://www.ems517.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 23, '', ''),
(7022, '1289792352', '大众点评网成都', 'http://www.dianping.com/chengdu/food', 0, 0, 0, 4213, 0, 1, 0, NULL, 24, '', ''),
(7023, '1289792352', '成都吃喝玩乐网', 'http://www.52ch.net/', 0, 0, 0, 4213, 0, 1, 0, NULL, 25, '', ''),
(7024, '1289792352', '新华网四川美食', 'http://www.sc.xinhuanet.com/service/food/', 0, 0, 0, 4213, 0, 1, 0, NULL, 26, '', ''),
(7025, '1289792352', '四川饮食网', 'http://www.scysw.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 27, '', ''),
(7026, '1289792352', '成都全搜索', 'http://www.cdqss.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 28, '', ''),
(7027, '1289792352', '成都口碑网', 'http://chengdu.koubei.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 29, '', ''),
(7028, '1289792352', '四川在线房产', 'http://house.scol.com.cn/', 0, 0, 0, 4213, 0, 1, 0, NULL, 30, '', ''),
(7029, '1289792352', '搜房网成都站', 'http://cd.soufun.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 31, '', ''),
(7030, '1289792352', '四川房地产', 'http://www.scfdc.cn/', 0, 0, 0, 4213, 0, 1, 0, NULL, 32, '', ''),
(7031, '1289792352', '成都住房公积金', 'http://www.cdzfgjj.gov.cn/', 0, 0, 0, 4213, 0, 1, 0, NULL, 33, '', ''),
(7032, '1289792352', '成都房管局', 'http://www.cdfgj.gov.cn/', 0, 0, 0, 4213, 0, 1, 0, NULL, 34, '', ''),
(7033, '1289792352', '四川建设网', 'http://www.sccin.com.cn/', 0, 0, 0, 4213, 0, 1, 0, NULL, 35, '', ''),
(7034, '1289792352', '四川在线健康频道', 'http://jk.scol.com.cn/', 0, 0, 0, 4213, 0, 1, 0, NULL, 36, '', ''),
(7035, '1289792352', '四川大学华西医院', 'http://www.cd120.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 37, '', ''),
(7036, '1289792352', '四川省人民医院', 'http://www.samsph.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 38, '', ''),
(7037, '1289792352', '四川大学华西二院', 'http://www.motherchildren.com/', 0, 0, 0, 4213, 0, 1, 0, NULL, 39, '', ''),
(7038, '1289792378', '四川大学', 'http://www.scu.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 1, '', ''),
(7039, '1289792378', '西南交通大学', 'http://www.swjtu.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 2, '', ''),
(7040, '1289792378', '电子科技大学', 'http://www.uestc.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 3, '', ''),
(7041, '1289792378', '西南财经大学', 'http://www.swufe.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 4, '', ''),
(7042, '1289792378', '西南民族大学', 'http://www.swun.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 5, '', ''),
(7043, '1289792378', '中国民用航空飞行学院', 'http://www.cafuc.edu.cn/structure/NewWeb/index', 0, 0, 0, 4214, 0, 1, 0, NULL, 6, '', ''),
(7044, '1289792378', '成都理工大学', 'http://www.cdut.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 7, '', ''),
(7045, '1289792378', '西华大学', 'http://www.xhu.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 8, '', ''),
(7046, '1289792378', '西南科技大学', 'http://www.swust.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 9, '', ''),
(7047, '1289792378', '四川农业大学', 'http://www.sicau.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 10, '', ''),
(7048, '1289792378', '成都中医药大学', 'http://www.cdutcm.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 11, '', ''),
(7049, '1289792378', '四川师范大学', 'http://www.sicnu.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 12, '', ''),
(7050, '1289792378', '西华师范大学', 'http://www.cwnu.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 13, '', ''),
(7051, '1289792378', '西南石油大学', 'http://www.swpu.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 14, '', ''),
(7052, '1289792378', '成都信息工程学院', 'http://www.cuit.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 15, '', ''),
(7053, '1289792378', '四川理工学院', 'http://www.suse.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 16, '', ''),
(7054, '1289792378', '泸州医学院', 'http://www.lzmc.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 17, '', ''),
(7055, '1289792378', '川北医学院', 'http://www.nsmc.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 18, '', ''),
(7056, '1289792378', '成都医学院', 'http://www.cmc.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 19, '', ''),
(7057, '1289792378', '乐山师范学院', 'http://www.lstc.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 20, '', ''),
(7058, '1289792378', '内江师范学院', 'http://www.njtc.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 21, '', ''),
(7059, '1289792378', '四川文理学院', 'http://www.sasu.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 22, '', ''),
(7060, '1289792378', '四川警察学院', 'http://www.scpolicec.com/', 0, 0, 0, 4214, 0, 1, 0, NULL, 23, '', ''),
(7061, '1289792378', '成都体育学院', 'http://www.cdsu.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 24, '', ''),
(7062, '1289792378', '四川音乐学院', 'http://www.sccm.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 25, '', ''),
(7063, '1289792378', '四川民族学院', 'http://www.scun.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 26, '', ''),
(7064, '1289792378', '成都学院', 'http://www.cdu.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 27, '', ''),
(7065, '1289792378', '西昌学院', 'http://www.xcc.sc.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 28, '', ''),
(7066, '1289792378', '攀枝花学院', 'http://www.pzhu.edu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 29, '', ''),
(7067, '1289792378', '宜宾学院', 'http://www.yibinu.cn/web/index.aspx', 0, 0, 0, 4214, 0, 1, 0, NULL, 30, '', ''),
(7068, '1289792378', '绵阳师范学院', 'http://www.mnu.cn/', 0, 0, 0, 4214, 0, 1, 0, NULL, 31, '', ''),
(7069, '1289792404', '天府论坛', 'http://bbs.scol.com.cn/', 0, 0, 0, 4215, 0, 1, 0, NULL, 1, '', ''),
(7070, '1289792404', '四川贴吧', 'http://tieba.baidu.com/f?kw=%CB%C4%B4%A8', 0, 0, 0, 4215, 0, 1, 0, NULL, 2, '', ''),
(7071, '1289792404', '西秦会馆', 'http://bbs.zg163.net/', 0, 0, 0, 4215, 0, 1, 0, NULL, 3, '', ''),
(7072, '1289792404', '凤凰山下', 'http://bbs.dz169.net/', 0, 0, 0, 4215, 0, 1, 0, NULL, 4, '', ''),
(7073, '1289792404', '麻辣社区', 'http://club.newssc.org/', 0, 0, 0, 4215, 0, 1, 0, NULL, 5, '', ''),
(7074, '1289792404', '第四城', 'http://www.028town.com/', 0, 0, 0, 4215, 0, 1, 0, NULL, 6, '', ''),
(7075, '1289792404', '成都贴吧', 'http://tieba.baidu.com/f?kw=%B3%C9%B6%BC', 0, 0, 0, 4215, 0, 1, 0, NULL, 7, '', ''),
(7076, '1289792404', '宜宾零距离', 'http://bbs.ybvv.com/', 0, 0, 0, 4215, 0, 1, 0, NULL, 8, '', ''),
(7077, '1289792404', '泸州论坛', 'http://www.0830bbs.com/', 0, 0, 0, 4215, 0, 1, 0, NULL, 9, '', ''),
(7078, '1289792404', '海棠社区', 'http://bbs.leshan.cn/', 0, 0, 0, 4215, 0, 1, 0, NULL, 10, '', ''),
(7079, '1289792404', 'gogo攀枝花', 'http://www.gogopzh.com/', 0, 0, 0, 4215, 0, 1, 0, NULL, 11, '', ''),
(7080, '1289792404', '眉山人论坛', 'http://bbs.meishanren.com/', 0, 0, 0, 4215, 0, 1, 0, NULL, 12, '', ''),
(7081, '1289792404', '成都向上', 'http://bbs.upcd.org/', 0, 0, 0, 4215, 0, 1, 0, NULL, 13, '', ''),
(7082, '1289792404', '大话利州', 'http://bbs.dzsm.com/', 0, 0, 0, 4215, 0, 1, 0, NULL, 14, '', ''),
(7083, '1289792404', '江油论坛', 'http://www.sc518.com/bbs/', 0, 0, 0, 4215, 0, 1, 0, NULL, 15, '', ''),
(7084, '1289794563', '四川省政府', 'http://www.sc.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 1, '', ''),
(7085, '1289794563', '四川工商局', 'http://www.scaic.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 2, '', ''),
(7086, '1289794563', '成都市社保局', 'http://www.cdldbz.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 3, '', ''),
(7087, '1289794563', '四川劳动社会保障厅', 'http://www.sc.lss.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 4, '', ''),
(7088, '1289794563', '成都市政府', 'http://www.chengdu.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 5, '', ''),
(7089, '1289794563', '绵阳', 'http://www.mianyang.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 6, '', ''),
(7090, '1289794563', '南充', 'http://www.nanchong.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 7, '', ''),
(7091, '1289794563', '雅安', 'http://www.yaan.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 8, '', ''),
(7092, '1289794563', '四川警察网', 'http://www.scga.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 9, '', ''),
(7093, '1289794563', '资阳', 'http://www.ziyang.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 10, '', ''),
(7094, '1289794563', '四川省建设厅', 'http://www.scjst.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 11, '', ''),
(7095, '1289794563', '达州', 'http://www.dazhou.gov.cn/', 0, 0, 0, 4216, 0, 1, 0, NULL, 12, '', ''),
(7096, '1289795998', '贵州信息港', 'http://www.gz163.cn/', 0, 0, 0, 4221, 0, 1, 0, NULL, 1, '', ''),
(7097, '1289795998', '贵州电视台', 'http://www.gzstv.com/', 0, 0, 0, 4221, 0, 1, 0, NULL, 2, '', ''),
(7098, '1289795998', '遵义在线', 'http://www.zynews.net/', 0, 0, 0, 4221, 0, 1, 0, NULL, 3, '', ''),
(7099, '1289795998', '安顺', 'http://www.anshun.gov.cn/', 0, 0, 0, 4221, 0, 1, 0, NULL, 4, '', ''),
(7100, '1289795998', '贵州省政府', 'http://www.gzgov.gov.cn/', 0, 0, 0, 4221, 0, 1, 0, NULL, 5, '', ''),
(7101, '1289795998', '铜仁', 'http://www.tongren.gov.cn/', 0, 0, 0, 4221, 0, 1, 0, NULL, 6, '', ''),
(7102, '1289795998', '163贵州网', 'http://www.163gz.com/', 0, 0, 0, 4221, 0, 1, 0, NULL, 7, '', ''),
(7103, '1289795998', '兴义之窗', 'http://www.xyzc.cn/', 0, 0, 0, 4221, 0, 1, 0, NULL, 8, '', ''),
(7104, '1289796016', '贵州信息港', 'http://www.gz163.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 1, '', ''),
(7105, '1289796016', '贵州电视台', 'http://www.gzstv.com/', 0, 0, 0, 4222, 0, 1, 0, NULL, 2, '', ''),
(7106, '1289796016', '百度新闻—贵州', 'http://news.baidu.com/n?cmd=6&amp;amp;loc=7230&amp;amp;name=%E8%B4%B5%E5%B7%9E&amp;amp;pn=1', 0, 0, 0, 4222, 0, 1, 0, NULL, 3, '', ''),
(7107, '1289796016', '贵州中国', 'http://www.chinaguizhou.gov.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 4, '', ''),
(7108, '1289796016', '贵州省政府', 'http://www.gzgov.gov.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 5, '', ''),
(7109, '1289796016', '铜仁', 'http://www.tongren.gov.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 6, '', ''),
(7110, '1289796016', '遵义在线', 'http://www.zyol.gz.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 7, '', ''),
(7111, '1289796016', '铜仁信息港', 'http://tr.gz163.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 8, '', ''),
(7112, '1289796016', '毕节视窗', 'http://bj.gz163.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 9, '', ''),
(7113, '1289796016', '兴义之窗', 'http://www.xy.gz.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 10, '', ''),
(7114, '1289796016', '安顺', 'http://www.anshun.gov.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 11, '', ''),
(7115, '1289796016', '凯里信息港', 'http://qdn.gz163.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 12, '', ''),
(7116, '1289796016', '都匀黔南信息港', 'http://qn.gz163.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 13, '', ''),
(7117, '1289796016', '三苗网(苗族联合网)', 'http://www.3miao.net/', 0, 0, 0, 4222, 0, 1, 0, NULL, 14, '', ''),
(7118, '1289796016', '金黔在线', 'http://www.gog.com.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 15, '', ''),
(7119, '1289796016', '贵州日报', 'http://www.gog.com.cn/gzrb/', 0, 0, 0, 4222, 0, 1, 0, NULL, 16, '', ''),
(7120, '1289796016', '贵州商报', 'http://gzsb.gog.com.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 17, '', ''),
(7121, '1289796016', '贵州都市报', 'http://www.gog.com.cn/gzdsb/', 0, 0, 0, 4222, 0, 1, 0, NULL, 18, '', ''),
(7122, '1289796016', '西部开发报', 'http://xbkfb.com/', 0, 0, 0, 4222, 0, 1, 0, NULL, 19, '', ''),
(7123, '1289796016', '贵阳日报', 'http://www.gywb.cn/', 0, 0, 0, 4222, 0, 1, 0, NULL, 20, '', ''),
(7124, '1289796049', '贵州教育网', 'http://www.gzsedu.cn/', 0, 0, 0, 4223, 0, 1, 0, NULL, 1, '', ''),
(7125, '1289796049', '贵州旅游在线', 'http://www.gz-travel.net/', 0, 0, 0, 4223, 0, 1, 0, NULL, 2, '', ''),
(7126, '1289796049', '搜房贵阳站', 'http://gy.soufun.com/', 0, 0, 0, 4223, 0, 1, 0, NULL, 3, '', ''),
(7127, '1289796049', '贵州移动', 'http://www.gz.10086.cn/', 0, 0, 0, 4223, 0, 1, 0, NULL, 4, '', ''),
(7128, '1289796049', '贵州电信', 'http://gz.ct10000.com/', 0, 0, 0, 4223, 0, 1, 0, NULL, 5, '', ''),
(7129, '1289796049', '贵州省建设厅', 'http://www.gzjs.gov.cn/', 0, 0, 0, 4223, 0, 1, 0, NULL, 6, '', ''),
(7130, '1289796049', '贵州招生考试中心', 'http://www.gzszk.com/', 0, 0, 0, 4223, 0, 1, 0, NULL, 7, '', ''),
(7131, '1289796049', '贵州交警总队', 'http://www.gzjjzd.gov.cn/', 0, 0, 0, 4223, 0, 1, 0, NULL, 8, '', ''),
(7132, '1289796049', '贵阳人才网', 'http://www.gyrc.com.cn/', 0, 0, 0, 4223, 0, 1, 0, NULL, 9, '', ''),
(7133, '1289796049', '贵阳地图', 'http://map.baidu.com/?newmap=1&amp;amp;s=s%26wd%3D%E8%B4%B5%E9%98%B3%E5%B8%82%26c%3D146&amp;amp;fr=alab0', 0, 0, 0, 4223, 0, 1, 0, NULL, 10, '', ''),
(7134, '1289796109', '贵州教育网', 'http://www.gzsedu.cn/', 0, 0, 0, 4224, 0, 1, 1289799463, NULL, 1, '', ''),
(7135, '1289796135', '贵阳论坛', 'http://www.cn0851.com/club/', 0, 0, 0, 4225, 0, 1, 0, NULL, 1, '', ''),
(7136, '1289796135', '贵州贴吧', 'http://post.baidu.com/f?kw=%B9%F3%D6%DD', 0, 0, 0, 4225, 0, 1, 0, NULL, 2, '', ''),
(7137, '1289796135', '贵阳贴吧', 'http://post.baidu.com/f?kw=%B9%F3%D1%F4', 0, 0, 0, 4225, 0, 1, 0, NULL, 3, '', ''),
(7138, '1289796135', '百度知道-贵州', 'http://zhidao.baidu.com/browse/260', 0, 0, 0, 4225, 0, 1, 0, NULL, 4, '', ''),
(7139, '1289796135', '夜郎社区', 'http://bbs.gz163.cn/', 0, 0, 0, 4225, 0, 1, 0, NULL, 5, '', ''),
(7140, '1289796172', '六盘水', 'http://www.gzlps.gov.cn/', 0, 0, 0, 4226, 0, 1, 0, NULL, 1, '', ''),
(7141, '1289796172', '贵州省建设厅', 'http://www.gzjs.gov.cn/', 0, 0, 0, 4226, 0, 1, 0, NULL, 2, '', ''),
(7142, '1289796208', '西双版纳信息港', 'http://www.bn163.net/', 0, 0, 0, 4231, 0, 1, 0, NULL, 1, '', ''),
(7143, '1289796208', '大理信息港', 'http://www.dali163.com/', 0, 0, 0, 4231, 0, 1, 0, NULL, 2, '', ''),
(7144, '1289796208', '临沧', 'http://www.lincang.cn/', 0, 0, 0, 4231, 0, 1, 0, NULL, 3, '', ''),
(7145, '1289796208', '曲靖信息港', 'http://www.eqj.cn/', 0, 0, 0, 4231, 0, 1, 0, NULL, 4, '', ''),
(7146, '1289796208', '文山信息港', 'http://ws.yninfo.com/', 0, 0, 0, 4231, 0, 1, 0, NULL, 5, '', ''),
(7147, '1289796208', '昆明信息港', 'http://www.kunming.cn/', 0, 0, 0, 4231, 0, 1, 0, NULL, 6, '', ''),
(7148, '1289796258', '云南信息港', 'http://www.yninfo.com/', 0, 0, 0, 4232, 0, 1, 0, NULL, 1, '', ''),
(7149, '1289796258', '云南网', 'http://www.yunnan.cn/', 0, 0, 0, 4232, 0, 1, 0, NULL, 2, '', ''),
(7150, '1289796258', '云南电视网', 'http://www.yntv.cn/', 0, 0, 0, 4232, 0, 1, 0, NULL, 3, '', ''),
(7151, '1289796258', '云南日报网', 'http://www.yndaily.com/', 0, 0, 0, 4232, 0, 1, 0, NULL, 4, '', ''),
(7152, '1289796258', '昆明电视台', 'http://www.kmtv.com.cn/', 0, 0, 0, 4232, 0, 1, 0, NULL, 5, '', ''),
(7153, '1289796258', '云南新闻网', 'http://www.yn.chinanews.com.cn/', 0, 0, 0, 4232, 0, 1, 0, NULL, 6, '', ''),
(7154, '1289796258', '云南网', 'http://www.yunnan.cn/', 0, 0, 0, 4232, 0, 1, 0, NULL, 7, '', ''),
(7155, '1289796258', '中新网云南', 'http://www.yn.chinanews.com.cn/', 0, 0, 0, 4232, 0, 1, 0, NULL, 8, '', ''),
(7156, '1289796258', '云南电视台', 'http://www.yntv.cn/', 0, 0, 0, 4232, 0, 1, 0, NULL, 9, '', ''),
(7157, '1289796299', '云南气象', 'http://www.ynmb.cn/', 0, 0, 0, 4233, 0, 1, 0, NULL, 1, '', ''),
(7158, '1289796299', '云南省地图', 'http://www.51ditu.com/maps/maps_search.html?c=%E4%BA%91%E5%8D%97', 0, 0, 0, 4233, 0, 1, 0, NULL, 2, '', ''),
(7159, '1289796299', '百度地图昆明', 'http://map.baidu.com/#word=%E6%98%86%E6%98%8E%E5%B8%82&amp;amp;ct=10', 0, 0, 0, 4233, 0, 1, 0, NULL, 3, '', ''),
(7160, '1289796299', '昆明公交', 'http://www.kmbus.com.cn/', 0, 0, 0, 4233, 0, 1, 0, NULL, 4, '', ''),
(7161, '1289796299', '列车时刻查询', 'http://lieche.5w.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 5, '', ''),
(7162, '1289796299', '云南丽江机场', 'http://www.lijiang-airport.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 6, '', ''),
(7163, '1289796299', '云南机场', 'http://www.ynairport.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 7, '', ''),
(7164, '1289796299', '云游网', 'http://www.traveloyunnan.com.cn/', 0, 0, 0, 4233, 0, 1, 0, NULL, 8, '', ''),
(7165, '1289796299', '云南民族文化网', 'http://www.ynmw.org/', 0, 0, 0, 4233, 0, 1, 0, NULL, 9, '', ''),
(7166, '1289796299', '西双版纳旅游网', 'http://www.xsbnly.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 10, '', ''),
(7167, '1289796299', '昆明市旅游局', 'http://www.kmta.gov.cn/', 0, 0, 0, 4233, 0, 1, 0, NULL, 11, '', ''),
(7168, '1289796299', '云南日报旅游频道', 'http://www.yndaily.com/ihtml/yndaily/TXTP_LY.html', 0, 0, 0, 4233, 0, 1, 0, NULL, 12, '', ''),
(7169, '1289796299', '丽江旅游网', 'http://www.ljtour.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 13, '', ''),
(7170, '1289796299', '大众点评网昆明', 'http://www.dianping.com/kunming/food', 0, 0, 0, 4233, 0, 1, 0, NULL, 14, '', ''),
(7171, '1289796299', '云南美食网', 'http://www.yncate.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 15, '', ''),
(7172, '1289796299', '普洱网', 'http://www.peinfo.net/', 0, 0, 0, 4233, 0, 1, 0, NULL, 16, '', ''),
(7173, '1289796299', '昆明房产网', 'http://www.kunmf.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 17, '', ''),
(7174, '1289796299', '云南信息港房网', 'http://house.yninfo.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 18, '', ''),
(7175, '1289796299', '搜房昆明', 'http://km.soufun.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 19, '', ''),
(7176, '1289796299', '文山住房公积金网', 'http://www.wsgjj.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 20, '', ''),
(7177, '1289796299', '丽江住房公积金网', 'http://www.ljgjj.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 21, '', ''),
(7178, '1289796299', '昆明住房公积金网', 'http://www.kmgjj.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 22, '', ''),
(7179, '1289796299', '云南信息港健康', 'http://health.yninfo.com/', 0, 0, 0, 4233, 0, 1, 0, NULL, 23, '', ''),
(7180, '1289796299', '云南医疗保险网', 'http://www.ynyb.org.cn/', 0, 0, 0, 4233, 0, 1, 0, NULL, 24, '', ''),
(7181, '1289796299', '云大医院', 'http://www.ydyy.cn/', 0, 0, 0, 4233, 0, 1, 0, NULL, 25, '', ''),
(7182, '1289796320', '云南省教育厅', 'http://www.ynjy.cn/', 0, 0, 0, 4234, 0, 1, 0, NULL, 1, '', ''),
(7183, '1289796320', '云南省招考频道', 'http://www.ynzs.cn/', 0, 0, 0, 4234, 0, 1, 0, NULL, 2, '', ''),
(7184, '1289796320', '云南自考网', 'http://www.ynzk.com/', 0, 0, 0, 4234, 0, 1, 0, NULL, 3, '', ''),
(7185, '1289796320', '云南师范大学', 'http://www.ynnu.edu.cn/', 0, 0, 0, 4234, 0, 1, 0, NULL, 4, '', ''),
(7186, '1289796320', '云南大学', 'http://www.ynu.edu.cn/', 0, 0, 0, 4234, 0, 1, 0, NULL, 5, '', ''),
(7187, '1289796320', '昆明理工大学', 'http://www.kmust.edu.cn/', 0, 0, 0, 4234, 0, 1, 0, NULL, 6, '', ''),
(7188, '1289796320', '云南民族大学', 'http://www.ynni.edu.cn/', 0, 0, 0, 4234, 0, 1, 0, NULL, 7, '', ''),
(7189, '1289796354', '云之南社区', 'http://club.yninfo.com/', 0, 0, 0, 4235, 0, 1, 0, NULL, 1, '', ''),
(7190, '1289796354', '云网论坛', 'http://forum.jinbifun.com/xbar.shtml', 0, 0, 0, 4235, 0, 1, 0, NULL, 2, '', ''),
(7191, '1289796354', '百度贴吧云南', 'http://tieba.baidu.com/f?kw=%E4%BA%91%E5%8D%97', 0, 0, 0, 4235, 0, 1, 0, NULL, 3, '', ''),
(7192, '1289796354', '百度贴吧昆明', 'http://tieba.baidu.com/f?kw=%E6%98%86%E6%98%8E', 0, 0, 0, 4235, 0, 1, 0, NULL, 4, '', ''),
(7193, '1289796354', '云南信息港交友', 'http://love.yninfo.com/', 0, 0, 0, 4235, 0, 1, 0, NULL, 5, '', ''),
(7194, '1289796354', '百度贴吧大理', 'http://tieba.baidu.com/f?kw=%E5%A4%A7%E7%90%86', 0, 0, 0, 4235, 0, 1, 0, NULL, 6, '', ''),
(7195, '1289796354', '百度贴吧西双版纳', 'http://tieba.baidu.com/f?kw=%E8%A5%BF%E5%8F%8C%E7%89%88%E7%BA%B3', 0, 0, 0, 4235, 0, 1, 0, NULL, 7, '', ''),
(7196, '1289796386', '云南省政府', 'http://www.yn.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 1, '', ''),
(7197, '1289796386', '云南发改委', 'http://www.yndpc.yn.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 2, '', ''),
(7198, '1289796386', '云南省法院', 'http://www.gy.yn.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 3, '', ''),
(7199, '1289796386', '保山市', 'http://www.baoshan.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 4, '', ''),
(7200, '1289796386', '昆明市', 'http://www.km.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 5, '', ''),
(7201, '1289796386', '曲靖市', 'http://www.qj.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 6, '', ''),
(7202, '1289796386', '玉溪市', 'http://www.yuxi.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 7, '', ''),
(7203, '1289796386', '昭通市', 'http://www.zhaotong.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 8, '', ''),
(7204, '1289796386', '楚雄州', 'http://www.cxz.gov.cn', 0, 0, 0, 4236, 0, 1, 0, NULL, 9, '', ''),
(7205, '1289796386', '红河州', 'http://www.hh.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 10, '', ''),
(7206, '1289796386', '丽江市', 'http://www.lijiang.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 11, '', ''),
(7207, '1289796386', '迪庆州', 'http://www.yndq.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 12, '', ''),
(7208, '1289796386', '文山州', 'http://www.ynws.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 13, '', ''),
(7209, '1289796386', '西双版纳州', 'http://www.xsbn.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 14, '', ''),
(7210, '1289796386', '普洱市', 'http://www.puer.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 15, '', ''),
(7211, '1289796386', '大理州', 'http://www.dali.gov.cn/', 0, 0, 0, 4236, 0, 1, 0, NULL, 16, '', ''),
(7212, '1289796441', '榆林信息港', 'http://v.sn.vnet.cn/yl/index/index.jsp', 0, 0, 0, 4241, 0, 1, 0, NULL, 1, '', ''),
(7213, '1289796441', '西部网', 'http://www.cnwest.com/', 0, 0, 0, 4241, 0, 1, 0, NULL, 2, '', ''),
(7214, '1289796441', '宝鸡日报', 'http://www.baojidaily.com/', 0, 0, 0, 4241, 0, 1, 0, NULL, 3, '', ''),
(7215, '1289796441', '宝鸡新闻网', 'http://www.baojinews.com/', 0, 0, 0, 4241, 0, 1, 0, NULL, 4, '', ''),
(7216, '1289796441', '咸阳信息港', 'http://www.xy9981.com/', 0, 0, 0, 4241, 0, 1, 0, NULL, 5, '', ''),
(7217, '1289796478', '古城热线', 'http://www.269.net/', 0, 0, 0, 4242, 0, 1, 0, NULL, 1, '', ''),
(7218, '1289796478', '三秦都市报', 'http://www.sanqindaily.com/', 0, 0, 0, 4242, 0, 1, 0, NULL, 2, '', ''),
(7219, '1289796478', '西安新闻网', 'http://www.xiancn.com/', 0, 0, 0, 4242, 0, 1, 0, NULL, 3, '', ''),
(7220, '1289796478', '陕西电视台', 'http://www.sxtvs.com/', 0, 0, 0, 4242, 0, 1, 0, NULL, 4, '', ''),
(7221, '1289796478', '华商网', 'http://www.hsw.cn/', 0, 0, 0, 4242, 0, 1, 0, NULL, 5, '', ''),
(7222, '1289796478', '陕西日报', 'http://www.sxdaily.com.cn/', 0, 0, 0, 4242, 0, 1, 0, NULL, 6, '', ''),
(7223, '1289796478', '金号网', 'http://www.sxradio.com.cn/', 0, 0, 0, 4242, 0, 1, 0, NULL, 7, '', ''),
(7224, '1289796478', '大秦网', 'http://xian.qq.com/', 0, 0, 0, 4242, 0, 1, 0, NULL, 8, '', ''),
(7225, '1289796478', '陕西省政府', 'http://www.shaanxi.gov.cn/', 0, 0, 0, 4242, 0, 1, 0, NULL, 9, '', ''),
(7226, '1289796478', '陕西日报', 'http://www.sxdaily.com.cn/', 0, 0, 0, 4242, 0, 1, 0, NULL, 10, '', ''),
(7227, '1289796478', '三秦都市报', 'http://www.sanqindaily.com/', 0, 0, 0, 4242, 0, 1, 0, NULL, 11, '', ''),
(7228, '1289796478', '西安新闻网', 'http://www.xiancn.com/', 0, 0, 0, 4242, 0, 1, 0, NULL, 12, '', ''),
(7229, '1289796478', '陕西电视台', 'http://www.sxtvs.com/', 0, 0, 0, 4242, 0, 1, 0, NULL, 13, '', ''),
(7230, '1289796478', '咸阳日报', 'http://xianyang.cnwest.com/', 0, 0, 0, 4242, 0, 1, 0, NULL, 14, '', ''),
(7231, '1289796478', '华商报', 'http://ehsb.hsw.cn/', 0, 0, 0, 4242, 0, 1, 0, NULL, 15, '', ''),
(7232, '1289796478', '榆林日报', 'http://szb.ylrb.com/', 0, 0, 0, 4242, 0, 1, 0, NULL, 16, '', ''),
(7233, '1289796507', '陕西气象信息网', 'http://www.sxmb.gov.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 1, '', ''),
(7234, '1289796507', '西安公交查询', 'http://www1.xbus.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 2, '', ''),
(7235, '1289796507', '陕西地图', 'http://www.shaanxi.cn/sx_into/sxmap/index.htm', 0, 0, 0, 4243, 0, 1, 0, NULL, 3, '', ''),
(7236, '1289796507', '西安咸阳机场', 'http://www.xxia.com/', 0, 0, 0, 4243, 0, 1, 0, NULL, 4, '', ''),
(7237, '1289796507', '百度地图-西安', 'http://map.baidu.com/#word=%E8%A5%BF%E5%AE%89%E5%B8%82&amp;amp;ct=10', 0, 0, 0, 4243, 0, 1, 0, NULL, 5, '', ''),
(7238, '1289796507', '列车时刻查询', 'http://lieche.5w.com/', 0, 0, 0, 4243, 0, 1, 0, NULL, 6, '', ''),
(7239, '1289796507', '陕西旅游网', 'http://www.sxtour.com/', 0, 0, 0, 4243, 0, 1, 0, NULL, 7, '', ''),
(7240, '1289796507', '陕西历史博物馆', 'http://www.sxhm.com/', 0, 0, 0, 4243, 0, 1, 0, NULL, 8, '', ''),
(7241, '1289796507', '秦始皇兵马俑博物馆', 'http://www.bmy.com.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 9, '', ''),
(7242, '1289796507', '华清池', 'http://www.hqc.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 10, '', ''),
(7243, '1289796507', '西安市旅游局', 'http://rd.qihoo.com/qd.html?u=http%253A%252F%252Fwww.xian-tourism.com%252F&amp;amp;t=1271937827&amp;amp;c=1&amp;amp;a=9&amp;amp;p=6637&amp;amp;s=8a2b547bc1daf4ba40f6ee424b1a4633', 0, 0, 0, 4243, 0, 1, 0, NULL, 11, '', ''),
(7244, '1289796507', '大众点评网西安美食', 'http://www.dianping.com/xian/food', 0, 0, 0, 4243, 0, 1, 0, NULL, 12, '', ''),
(7245, '1289796507', '陕西价格信息网', 'http://www.spic.gov.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 13, '', ''),
(7246, '1289796507', '西安餐饮网', 'http://www.xauc.com/', 0, 0, 0, 4243, 0, 1, 0, NULL, 14, '', ''),
(7247, '1289796507', '三秦房产网', 'http://www.3qhouse.com/', 0, 0, 0, 4243, 0, 1, 0, NULL, 15, '', ''),
(7248, '1289796507', '西安房地产信息网', 'http://www.800j.com.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 16, '', ''),
(7249, '1289796507', '西安房产管理局', 'http://www.xafgj.gov.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 17, '', ''),
(7250, '1289796507', '古城热线房产频道', 'http://house.xaonline.com/', 0, 0, 0, 4243, 0, 1, 0, NULL, 18, '', ''),
(7251, '1289796507', '搜房网西安', 'http://xian.soufun.com/', 0, 0, 0, 4243, 0, 1, 0, NULL, 19, '', ''),
(7252, '1289796507', '陕西西京医院', 'http://xjwww.fmmu.edu.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 20, '', ''),
(7253, '1289796507', '西安交大第一医院', 'http://www.dyyy.xjtu.edu.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 21, '', ''),
(7254, '1289796507', '西安唐都医院', 'http://tdwww.fmmu.edu.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 22, '', ''),
(7255, '1289796507', '陕西省妇幼保健院', 'http://www.mchsn.com/', 0, 0, 0, 4243, 0, 1, 0, NULL, 23, '', ''),
(7256, '1289796507', '西安第四医院', 'http://www.mchsn.com/', 0, 0, 0, 4243, 0, 1, 0, NULL, 24, '', ''),
(7257, '1289796507', '陕西第二人民医院', 'http://www.sspph.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 25, '', ''),
(7258, '1289796507', '陕西卫生网', 'http://www.sxhealth.gov.cn/', 0, 0, 0, 4243, 0, 1, 0, NULL, 26, '', ''),
(7259, '1289796531', '陕西教育网', 'http://rd.qihoo.com/qd.html?u=http%253A%252F%252Fwww.snedu.com.cn%252F&amp;amp;t=1271937797&amp;amp;c=1&amp;amp;a=9&amp;amp;p=6636&amp;amp;s=ea262166c0637bb9a26232d6fae2ddc9', 0, 0, 0, 4244, 0, 1, 0, NULL, 1, '', ''),
(7260, '1289796531', '陕西人事考试网', 'http://www.sxrsks.cn/', 0, 0, 0, 4244, 0, 1, 0, NULL, 2, '', ''),
(7261, '1289796531', '西安交通大学', 'http://www.xjtu.edu.cn/', 0, 0, 0, 4244, 0, 1, 0, NULL, 3, '', ''),
(7262, '1289796531', '西北工业大学', 'http://www.nwpu.edu.cn/', 0, 0, 0, 4244, 0, 1, 0, NULL, 4, '', ''),
(7263, '1289796531', '西安电子科技大学', 'http://www.xidian.edu.cn/', 0, 0, 0, 4244, 0, 1, 0, NULL, 5, '', ''),
(7264, '1289796531', '陕西师范大学', 'http://www.snnu.edu.cn/', 0, 0, 0, 4244, 0, 1, 0, NULL, 6, '', ''),
(7265, '1289796557', '古城茶秀', 'http://rd.qihoo.com/qd.html?u=http%253A%252F%252Fforum.xaonline.com%252F&amp;amp;t=1271937528&amp;amp;c=1&amp;amp;a=9&amp;amp;p=6633&amp;amp;s=069f098cb506ba660d169fd1b820619a', 0, 0, 0, 4245, 0, 1, 0, NULL, 1, '', ''),
(7266, '1289796557', '腾讯论坛西安', 'http://xian.qq.com/bbs/', 0, 0, 0, 4245, 0, 1, 0, NULL, 2, '', ''),
(7267, '1289796557', '百度贴吧陕西', 'http://tieba.baidu.com/f?kw=%E9%99%95%E8%A5%BF', 0, 0, 0, 4245, 0, 1, 0, NULL, 3, '', ''),
(7268, '1289796557', '百度贴吧西安', 'http://tieba.baidu.com/f?kw=%E8%A5%BF%E5%AE%89', 0, 0, 0, 4245, 0, 1, 0, NULL, 4, '', ''),
(7269, '1289796557', '百度知道陕西', 'http://zhidao.baidu.com/browse/261', 0, 0, 0, 4245, 0, 1, 0, NULL, 5, '', ''),
(7270, '1289796557', '搜狐论坛陕西', 'http://club.city.travel.sohu.com/lshan_xi0000.html', 0, 0, 0, 4245, 0, 1, 0, NULL, 6, '', ''),
(7271, '1289796557', '天涯社区陕西', 'http://bbs.city.tianya.cn/new/TianyaCity/ArticlesList_Culture.asp?idWriter=0&amp;amp;Key=0&amp;amp;idItem=60', 0, 0, 0, 4245, 0, 1, 0, NULL, 7, '', ''),
(7272, '1289796592', '陕西省政府', 'http://www.shaanxi.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 1, '', ''),
(7273, '1289796592', '陕西农业信息网', 'http://www.sxny.gov.cn/sites/MainSite/', 0, 0, 0, 4246, 0, 1, 0, NULL, 2, '', ''),
(7274, '1289796592', '铜川市政府', 'http://www.tongchuan.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 3, '', ''),
(7275, '1289796592', '中国咸阳', 'http://www.xianyang.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 4, '', ''),
(7276, '1289796592', '西安市政府', 'http://www.xa.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 5, '', ''),
(7277, '1289796592', '汉中市政府', 'http://www.hanzhong.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 6, '', ''),
(7278, '1289796592', '陕西省教育厅', 'http://www.snedu.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 7, '', ''),
(7279, '1289796592', '商洛市政府', 'http://www.shangluo.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 8, '', ''),
(7280, '1289796592', '安康市政府', 'http://www.ak.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 9, '', ''),
(7281, '1289796592', '宝鸡市政府', 'http://www.baoji.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 10, '', ''),
(7282, '1289796592', '延安市政府', 'http://www.yanan.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 11, '', ''),
(7283, '1289796592', '陕西省交通厅', 'http://www.sxsjtt.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 12, '', ''),
(7284, '1289796592', '陕西省财政厅', 'http://www.sf.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 13, '', ''),
(7285, '1289796592', '陕西建设网', 'http://www.shaanxijs.gov.cn/', 0, 0, 0, 4246, 0, 1, 0, NULL, 14, '', ''),
(7286, '1289796644', '兰州晨报', 'http://www.lzcbnews.com/', 0, 0, 0, 4251, 0, 1, 0, NULL, 1, '', ''),
(7287, '1289796644', '兰州电视台', 'http://www.lztv.tv/', 0, 0, 0, 4251, 0, 1, 0, NULL, 2, '', ''),
(7288, '1289796644', '兰州新闻网', 'http://www.lzbs.com.cn/', 0, 0, 0, 4251, 0, 1, 0, NULL, 3, '', ''),
(7289, '1289796644', '天水在线', 'http://www.tianshui.com.cn/', 0, 0, 0, 4251, 0, 1, 0, NULL, 4, '', ''),
(7290, '1289796699', '兰川晨报', 'http://lzcb.gansudaily.com.cn/', 0, 0, 0, 4252, 0, 1, 0, NULL, 1, '', ''),
(7291, '1289796699', '甘肃日报', 'http://gsrb.gansudaily.com.cn/', 0, 0, 0, 4252, 0, 1, 0, NULL, 2, '', ''),
(7292, '1289796699', '西部商报', 'http://xbsb.gansudaily.com.cn/', 0, 0, 0, 4252, 0, 1, 0, NULL, 3, '', ''),
(7293, '1289796699', '甘肃法制报', 'http://gsfzb.gansudaily.com.cn/', 0, 0, 0, 4252, 0, 1, 0, NULL, 4, '', ''),
(7294, '1289796699', '新华网甘肃频道', 'http://www.gs.xinhua.org/', 0, 0, 0, 4252, 0, 1, 0, NULL, 5, '', ''),
(7295, '1289796699', '读者', 'http://www.duzhe.com/', 0, 0, 0, 4252, 0, 1, 0, NULL, 6, '', ''),
(7296, '1289796699', '中国陇南网', 'http://www.cnlongnan.cn/', 0, 0, 0, 4252, 0, 1, 0, NULL, 7, '', ''),
(7297, '1289796699', '白银新闻网', 'http://www.bynews.com.cn/', 0, 0, 0, 4252, 0, 1, 0, NULL, 8, '', ''),
(7298, '1289796699', '陇东数字报', 'http://epaper.chinaqy.info/', 0, 0, 0, 4252, 0, 1, 0, NULL, 9, '', ''),
(7299, '1289796699', '定西日报', 'http://www.dingxidaily.com/', 0, 0, 0, 4252, 0, 1, 0, NULL, 10, '', ''),
(7300, '1289796740', '甘肃移动', 'http://www.gs.10086.cn/', 0, 0, 0, 4253, 0, 1, 0, NULL, 1, '', ''),
(7301, '1289796740', '甘肃联通', 'http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=00010030&amp;amp;id=2290%20', 0, 0, 0, 4253, 0, 1, 0, NULL, 2, '', ''),
(7302, '1289796740', '西北人才网', 'http://www.xbrc.gov.cn/', 0, 0, 0, 4253, 0, 1, 0, NULL, 3, '', ''),
(7303, '1289796740', '甘肃人事网', 'http://www.rst.gansu.gov.cn/', 0, 0, 0, 4253, 0, 1, 0, NULL, 4, '', ''),
(7304, '1289796740', '酒泉人事人才网', 'http://www.jqrc.net/', 0, 0, 0, 4253, 0, 1, 0, NULL, 5, '', ''),
(7305, '1289796740', '百度地图兰州', 'http://map.baidu.com/?newmap=1&amp;amp;l=12&amp;amp;t=B_NORMAL_MAP&amp;amp;c=11557683.25,4284074.36&amp;amp;s=cur%26curtp%3D2%26wd%3D%25E5%2585%25B0%25E5%25B7%259E', 0, 0, 0, 4253, 0, 1, 0, NULL, 6, '', ''),
(7306, '1289796740', '甘房网', 'http://www.gshouse.com.cn/', 0, 0, 0, 4253, 0, 1, 0, NULL, 7, '', ''),
(7307, '1289796740', '敦煌旅游网', 'http://www.dunhuangtour.com/', 0, 0, 0, 4253, 0, 1, 0, NULL, 8, '', ''),
(7308, '1289796740', '甘肃省卫生厅', 'http://www.gsws.gov.cn/', 0, 0, 0, 4253, 0, 1, 0, NULL, 9, '', ''),
(7309, '1289796766', '兰州大学', 'http://www.lzu.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 1, '', ''),
(7310, '1289796766', '西北师范大学', 'http://www.nwnu.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 2, '', ''),
(7311, '1289796766', '兰州理工大学', 'http://www.gsut.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 3, '', ''),
(7312, '1289796766', '兰州交通大学', 'http://www.lzjtu.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 4, '', ''),
(7313, '1289796766', '甘肃农业大学', 'http://www.gsau.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 5, '', ''),
(7314, '1289796766', '甘肃民族师范学院', 'http://www.gnun.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 6, '', ''),
(7315, '1289796766', '甘肃中医学院', 'http://www.gszy.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 7, '', ''),
(7316, '1289796766', '天水师范学院', 'http://www.tsnc.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 8, '', ''),
(7317, '1289796766', '兰州职业技术学院', 'http://www.lvu.edu.cn', 0, 0, 0, 4254, 0, 1, 0, NULL, 9, '', ''),
(7318, '1289796766', '兰州商学院', 'http://www.lzcc.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 10, '', ''),
(7319, '1289796766', '甘肃政法学院', 'http://www.gsli.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 11, '', ''),
(7320, '1289796766', '河西学院', 'http://www.hxu.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 12, '', ''),
(7321, '1289796766', '兰州石化职业技术学院', 'http://www.lzpcc.com.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 13, '', ''),
(7322, '1289796766', '兰州城市学院', 'http://www.lztc.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 14, '', ''),
(7323, '1289796766', '甘肃联合大学', 'http://www.gsu.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 15, '', ''),
(7324, '1289796766', '甘肃林业职业技术学院', 'http://www.gsfc.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 16, '', ''),
(7325, '1289796766', '陇东学院', 'http://www.ldxy.edu.cn/%20', 0, 0, 0, 4254, 0, 1, 0, NULL, 17, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(7326, '1289796766', '兰州工业高等专科学校', 'http://www.lzptc.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 18, '', ''),
(7327, '1289796766', '平凉医学高等专科学校', 'http://www.plmc.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 19, '', ''),
(7328, '1289796766', '兰州交通大学博文学院', 'http://www.bowenedu.cn/www/', 0, 0, 0, 4254, 0, 1, 0, NULL, 20, '', ''),
(7329, '1289796766', '定西师范高等专科学校', 'http://www.dxatc.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 21, '', ''),
(7330, '1289796766', '甘肃农业职业技术学院', 'http://www.gnzy.gssedu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 22, '', ''),
(7331, '1289796766', '兰州商学院长青学院', 'http://222.23.176.254/', 0, 0, 0, 4254, 0, 1, 0, NULL, 23, '', ''),
(7332, '1289796766', '甘肃交通职业技术学院', 'http://www.gsjtxy.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 24, '', ''),
(7333, '1289796766', '酒泉职业技术学院', 'http://www.jqzy.com/', 0, 0, 0, 4254, 0, 1, 0, NULL, 25, '', ''),
(7334, '1289796766', '兰州航空工业职工大学', 'http://www.lzavu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 26, '', ''),
(7335, '1289796766', '兰州理工大学技术工程学院', 'http://www.ljsgcxy.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 27, '', ''),
(7336, '1289796766', '甘肃畜牧工程职业技术学院', 'http://www.xmgcxy.gsedu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 28, '', ''),
(7337, '1289796766', '武威职业学院', 'http://www.wwoc.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 29, '', ''),
(7338, '1289796766', '兰州资源环境职业技术学院', 'http://www.lzre.gs.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 30, '', ''),
(7339, '1289796766', '甘肃钢铁职业技术学院', 'http://www.ggzy.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 31, '', ''),
(7340, '1289796766', '甘肃机电职业技术学院', 'http://www.gsjdxy.com/', 0, 0, 0, 4254, 0, 1, 0, NULL, 32, '', ''),
(7341, '1289796766', '西北师范大学知行学院', 'http://zxxy.nwnu.edu.cn/', 0, 0, 0, 4254, 0, 1, 0, NULL, 33, '', ''),
(7342, '1289796766', '兰州商学院陇桥学院', 'http://www.lzlqc.com/', 0, 0, 0, 4254, 0, 1, 0, NULL, 34, '', ''),
(7343, '1289796793', '兰州贴吧', 'http://tieba.baidu.com/f?kw=%C0%BC%D6%DD', 0, 0, 0, 4255, 0, 1, 0, NULL, 1, '', ''),
(7344, '1289796793', '天涯甘肃', 'http://bbs.city.tianya.cn/new/tianyacity/articleslist_culture_v3.asp?idWriter=0&amp;amp;Key=0&amp;amp;idItem=183', 0, 0, 0, 4255, 0, 1, 0, NULL, 2, '', ''),
(7345, '1289796793', '兰州生活圈', 'http://www.lzooo.com/', 0, 0, 0, 4255, 0, 1, 0, NULL, 3, '', ''),
(7346, '1289796793', '大十字', 'http://www.wuweionline.com/', 0, 0, 0, 4255, 0, 1, 0, NULL, 4, '', ''),
(7347, '1289796793', '兰州圈圈', 'http://www.0931qq.com/', 0, 0, 0, 4255, 0, 1, 0, NULL, 5, '', ''),
(7348, '1289796793', '天水生活', 'http://www.0938.cn/', 0, 0, 0, 4255, 0, 1, 0, NULL, 6, '', ''),
(7349, '1289796793', '酒泉在线', 'http://www.jqcn.com/', 0, 0, 0, 4255, 0, 1, 0, NULL, 7, '', ''),
(7350, '1289796815', '甘肃省政府', 'http://www.gansu.gov.cn/', 0, 0, 0, 4256, 0, 1, 0, NULL, 1, '', ''),
(7351, '1289796815', '甘肃农业信息网', 'http://www.gsny.gov.cn/', 0, 0, 0, 4256, 0, 1, 0, NULL, 2, '', ''),
(7352, '1289796815', '甘肃人事编制信息网', 'http://www.rst.gansu.gov.cn/', 0, 0, 0, 4256, 0, 1, 0, NULL, 3, '', ''),
(7353, '1289796815', '酒泉市人民政府', 'http://www.jiuquan.gov.cn/', 0, 0, 0, 4256, 0, 1, 0, NULL, 4, '', ''),
(7354, '1289796815', '甘肃农业信息网', 'http://www.gsny.gov.cn/', 0, 0, 0, 4256, 0, 1, 0, NULL, 5, '', ''),
(7355, '1289796957', '创业商机杂志', 'http://cnrdn.com/rd.htm?id=1022100&r=http://www.lhad.com.cn/zs_19.html', 0, 0, 0, 3073, 0, 1, 1302146370, NULL, 1, '#FF0000', ''),
(7856, '1289802154', '前程无忧-北京站', 'http://cn.51job.com/default-area.php?area=0100', 0, 0, 0, 1085, 0, 1, 0, NULL, 6, '', ''),
(7356, '1289796957', '7808口碑创业网', 'http://www.7808.cn/cy.shtml?site=dh?5w', 0, 0, 0, 3073, 0, 1, 1302146270, NULL, 2, '', ''),
(7357, '1289796957', '3158致富网', 'http://www.3158.cn/?site=dh5w', 0, 0, 0, 3073, 0, 1, 1302146149, NULL, 3, '', ''),
(7358, '1289796957', '1年能赚100万', 'http://cnrdn.com/rd.htm?id=1022101&r=http://www.lhad.com.cn/zs_20.html', 0, 0, 0, 3073, 0, 1, 1302146403, NULL, 4, '', ''),
(7359, '1289796957', '小本创业网', 'http://gb.36578.com/gbook_admin/getgo.php?id=3662', 0, 0, 0, 3073, 0, 1, 1302146471, NULL, 5, '#FF0000', ''),
(7855, '1289802154', '北京科技人才网', 'http://www.bjkjrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 5, '', ''),
(7360, '1289796957', '2011年赚钱生意', 'http://www.7808.cn/cy.shtml?site=dh?5w', 0, 0, 0, 3073, 0, 1, 1302146346, NULL, 6, '', ''),
(7361, '1289796957', '投1000赚10万', 'http://cnrdn.com/rd.htm?id=1022101&r=http://www.lhad.com.cn/zs_20.html', 0, 0, 0, 3073, 0, 1, 1302146258, NULL, 7, '', ''),
(7362, '1289796957', '1000元开店', 'http://www.7808.cn/cy.shtml?site=dh?5w', 0, 0, 0, 3073, 0, 1, 1302146458, NULL, 8, '#FF0000', ''),
(7363, '1289796960', '西宁市', 'http://www.xining.gov.cn/', 0, 0, 0, 4261, 0, 1, 0, NULL, 1, '', ''),
(7364, '1289796960', '海东', 'http://www.haidong.gov.cn/', 0, 0, 0, 4261, 0, 1, 0, NULL, 2, '', ''),
(7365, '1289796960', '黄南州', 'http://www.huangnan.gov.cn/', 0, 0, 0, 4261, 0, 1, 0, NULL, 3, '', ''),
(7366, '1289796960', '海西州', 'http://www.haixi.gov.cn/', 0, 0, 0, 4261, 0, 1, 0, NULL, 4, '', ''),
(7367, '1289796985', '青海新闻网', 'http://www.qhnews.com/', 0, 0, 0, 4262, 0, 1, 0, NULL, 1, '', ''),
(7368, '1289796985', '青海民族文化网', 'http://www.qhwh.gov.cn/', 0, 0, 0, 4262, 0, 1, 0, NULL, 2, '', ''),
(7369, '1289796985', '新华网青海频道', 'http://www.qh.xinhua.org', 0, 0, 0, 4262, 0, 1, 0, NULL, 3, '', ''),
(7370, '1289796985', '青海省政府', 'http://www.qh.gov.cn/', 0, 0, 0, 4262, 0, 1, 0, NULL, 4, '', ''),
(7371, '1289796985', '青海电视台', 'http://www.qhstv.com/', 0, 0, 0, 4262, 0, 1, 0, NULL, 5, '', ''),
(7372, '1289796985', '青海人民广播电台', 'http://www.qhradio.com/', 0, 0, 0, 4262, 0, 1, 0, NULL, 6, '', ''),
(7373, '1289796985', '青海藏语广播网', 'http://www.qhtb.cn/', 0, 0, 0, 4262, 0, 1, 0, NULL, 7, '', ''),
(7374, '1289796985', '中国藏族网通', 'http://www.tibet3.com/', 0, 0, 0, 4262, 0, 1, 0, NULL, 8, '', ''),
(7375, '1289796985', '青海日报', 'http://epaper.tibet3.com/', 0, 0, 0, 4262, 0, 1, 0, NULL, 9, '', ''),
(7376, '1289796992', '全球黄页', 'http://www.21page.net', 0, 0, 0, 3074, 0, 1, 0, NULL, 1, '', ''),
(7377, '1289796992', '中国黄页大全', 'http://www.ypall.com/', 0, 0, 0, 3074, 0, 1, 0, NULL, 2, '', ''),
(7378, '1289796992', '中国网库', 'http://www.99114.com/', 0, 0, 0, 3074, 0, 1, 0, NULL, 3, '', ''),
(7379, '1289796992', '中国企业网络黄页', 'http://www.page.net.cn', 0, 0, 0, 3074, 0, 1, 0, NULL, 4, '', ''),
(7380, '1289796992', '阿里巴巴公司库', 'http://page.china.alibaba.com/cp/cp1.html', 0, 0, 0, 3074, 0, 1, 0, NULL, 5, '', ''),
(7381, '1289796992', '百度黄页搜索', 'http://yp.baidu.com/', 0, 0, 0, 3074, 0, 1, 0, NULL, 6, '', ''),
(7382, '1289796992', '中国电信黄页', 'http://www.locoso.com/', 0, 0, 0, 3074, 0, 1, 0, NULL, 7, '', ''),
(7383, '1289796992', '全国企业网', 'http://www.qychina.com/', 0, 0, 0, 3074, 0, 1, 0, NULL, 8, '', ''),
(7384, '1289796992', '58同城', 'http://www.58.com/', 0, 0, 0, 3074, 0, 1, 0, NULL, 9, '', ''),
(7385, '1289796992', '行业大黄页', 'http://www.3653h.com/', 0, 0, 0, 3074, 0, 1, 0, NULL, 10, '', ''),
(7386, '1289796992', '新浪企业黄页', 'http://yp.sina.net', 0, 0, 0, 3074, 0, 1, 0, NULL, 11, '', ''),
(7387, '1289796992', '公众企业网', 'http://www.public.net.cn/', 0, 0, 0, 3074, 0, 1, 0, NULL, 12, '', ''),
(7388, '1289797011', '青海气象', 'http://www.qhqxj.gov.cn/', 0, 0, 0, 4263, 0, 1, 0, NULL, 1, '', ''),
(7389, '1289797011', '百度地图西宁', 'http://map.baidu.com/#word=%E8%A5%BF%E5%AE%81%E5%B8%82&amp;amp;ct=10', 0, 0, 0, 4263, 0, 1, 0, NULL, 2, '', ''),
(7390, '1289797011', '列车时刻', 'http://lieche.5w.com/', 0, 0, 0, 4263, 0, 1, 0, NULL, 3, '', ''),
(7391, '1289797011', '青海旅游网', 'http://www.qhly.gov.cn/', 0, 0, 0, 4263, 0, 1, 0, NULL, 4, '', ''),
(7392, '1289797011', '青海青', 'http://www.qhqphoto.com/', 0, 0, 0, 4263, 0, 1, 0, NULL, 5, '', ''),
(7393, '1289797011', '青海新闻网旅游频道', 'http://www.qhnews.com/qhly/index.shtml', 0, 0, 0, 4263, 0, 1, 0, NULL, 6, '', ''),
(7394, '1289797011', '可可西里藏羚羊保护', 'http://www.kekexili.com/', 0, 0, 0, 4263, 0, 1, 0, NULL, 7, '', ''),
(7395, '1289797011', '青海美食网', 'http://www.qhms.cn/', 0, 0, 0, 4263, 0, 1, 0, NULL, 8, '', ''),
(7396, '1289797011', '青海街坊网', 'http://www.qhhouse.com.cn/', 0, 0, 0, 4263, 0, 1, 0, NULL, 9, '', ''),
(7397, '1289797011', '青海房地产市场网', 'http://qh.tld.cn/', 0, 0, 0, 4263, 0, 1, 0, NULL, 10, '', ''),
(7398, '1289797011', '西宁房产管理局', 'http://xnfcj.xining.gov.cn/', 0, 0, 0, 4263, 0, 1, 0, NULL, 11, '', ''),
(7399, '1289797011', '青海红十字医院', 'http://www.qhrch.com/', 0, 0, 0, 4263, 0, 1, 0, NULL, 12, '', ''),
(7400, '1289797011', '青海省藏医院', 'http://www.arurahp.com/', 0, 0, 0, 4263, 0, 1, 0, NULL, 13, '', ''),
(7401, '1289797022', '中央人民政府', 'http://www.gov.cn/', 0, 0, 0, 3075, 0, 1, 0, NULL, 1, '', ''),
(7402, '1289797022', '全国人民代表大会', 'http://www.npc.gov.cn/', 0, 0, 0, 3075, 0, 1, 0, NULL, 2, '', ''),
(7403, '1289797022', '最高人民法院', 'http://www.court.gov.cn/', 0, 0, 0, 3075, 0, 1, 0, NULL, 3, '', ''),
(7404, '1289797022', '最高人民检察院', 'http://www.spp.gov.cn/site2006/index.html', 0, 0, 0, 3075, 0, 1, 0, NULL, 4, '', ''),
(7405, '1289797034', '青海人事考试信息网', 'http://www.qhpta.com/', 0, 0, 0, 4264, 0, 1, 0, NULL, 1, '', ''),
(7406, '1289797034', '青海民族学院', 'http://www.qhmu.edu.cn/', 0, 0, 0, 4264, 0, 1, 0, NULL, 2, '', ''),
(7407, '1289797034', '青海大学', 'http://www.qhu.edu.cn/', 0, 0, 0, 4264, 0, 1, 0, NULL, 3, '', ''),
(7408, '1289797034', '青海师范大学', 'http://www.qhnu.edu.cn/', 0, 0, 0, 4264, 0, 1, 0, NULL, 4, '', ''),
(7409, '1289797044', '外交部', 'http://www.fmprc.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 1, '', ''),
(7410, '1289797044', '发展改革委员会', 'http://www.sdpc.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 2, '', ''),
(7411, '1289797044', '教育部', 'http://www.moe.edu.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 3, '', ''),
(7412, '1289797044', '科学技术部', 'http://www.most.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 4, '', ''),
(7413, '1289797044', '公安部', 'http://www.mps.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 5, '', ''),
(7414, '1289797044', '监察部', 'http://www.mos.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 6, '', ''),
(7415, '1289797044', '民政部', 'http://www.mca.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 7, '', ''),
(7416, '1289797044', '司法部', 'http://www.legalinfo.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 8, '', ''),
(7417, '1289797044', '财政部', 'http://www.mof.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 9, '', ''),
(7418, '1289797044', '劳动和社会保障部', 'http://www.mohrss.gov.cn', 0, 0, 0, 3076, 0, 1, 0, NULL, 10, '', ''),
(7419, '1289797044', '建设部', 'http://www.cin.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 11, '', ''),
(7420, '1289797044', '邮政局', 'http://www.chinapost.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 12, '', ''),
(7421, '1289797044', '交通部', 'http://www.moc.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 13, '', ''),
(7422, '1289797044', '信息产业部', 'http://www.miit.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 14, '', ''),
(7423, '1289797044', '水利部', 'http://www.mwr.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 15, '', ''),
(7424, '1289797044', '农业部', 'http://www.agri.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 16, '', ''),
(7425, '1289797044', '商务部', 'http://www.mofcom.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 17, '', ''),
(7426, '1289797044', '文化部', 'http://www.ccnt.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 18, '', ''),
(7427, '1289797044', '卫生部', 'http://www.moh.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 19, '', ''),
(7428, '1289797044', '人口计生委员会', 'http://www.chinapop.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 20, '', ''),
(7429, '1289797044', '人民银行', 'http://www.pbc.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 21, '', ''),
(7430, '1289797044', '审计署', 'http://www.audit.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 22, '', ''),
(7431, '1289797044', '国土资源部', 'http://www.mlr.gov.cn/', 0, 0, 0, 3076, 0, 1, 0, NULL, 23, '', ''),
(7432, '1289797075', '青新论坛', 'http://www.qhnews.com/bbs/index1.shtml', 0, 0, 0, 4265, 0, 1, 0, NULL, 1, '', ''),
(7433, '1289797075', '西宁贴吧', 'http://tieba.baidu.com/f?ct=&amp;amp;tn=&amp;amp;rn=&amp;amp;pn=&amp;amp;lm=&amp;amp;sc=&amp;amp;kw=%E8%A5%BF%E5%AE%81&amp;amp;rs2=0&amp;amp;myselectvalue=1&amp;amp;word=%E8%A5%BF%E5%AE%81&amp;amp;tb=on', 0, 0, 0, 4265, 0, 1, 0, NULL, 2, '', ''),
(7434, '1289797135', '青海省人事厅', 'http://www.qhrs.gov.cn/', 0, 0, 0, 4266, 0, 1, 0, NULL, 1, '', ''),
(7435, '1289797135', '青海省政府', 'http://www.qh.gov.cn/', 0, 0, 0, 4266, 0, 1, 0, NULL, 2, '', ''),
(7436, '1289797199', '南宁市', 'http://www.nanning.gov.cn/', 0, 0, 0, 4271, 0, 1, 0, NULL, 1, '', ''),
(7437, '1289797199', '柳州市', 'http://www.liuzhou.gov.cn/', 0, 0, 0, 4271, 0, 1, 0, NULL, 2, '', ''),
(7438, '1289797199', '河池市', 'http://www.gxhc.gov.cn/', 0, 0, 0, 4271, 0, 1, 0, NULL, 3, '', ''),
(7439, '1289797199', '梧州市', 'http://www.wuzhou.gov.cn/', 0, 0, 0, 4271, 0, 1, 0, NULL, 4, '', ''),
(7440, '1289797199', '北海市', 'http://www.beihai.gov.cn/', 0, 0, 0, 4271, 0, 1, 0, NULL, 5, '', ''),
(7441, '1289797199', '防城港市', 'http://www.fcg.gx.cei.gov.cn/', 0, 0, 0, 4271, 0, 1, 0, NULL, 6, '', ''),
(7442, '1289797199', '钦州市', 'http://www.gx.xinhuanet.com/', 0, 0, 0, 4271, 0, 1, 0, NULL, 7, '', ''),
(7443, '1289797199', '贵港市', 'http://www.gx.xinhuanet.com/dtzx/ggs/', 0, 0, 0, 4271, 0, 1, 0, NULL, 8, '', ''),
(7444, '1289797199', '玉林市', 'http://www.yulin.gov.cn/', 0, 0, 0, 4271, 0, 1, 0, NULL, 9, '', ''),
(7445, '1289797199', '来宾市', 'http://www.laibin.gov.cn/', 0, 0, 0, 4271, 0, 1, 0, NULL, 10, '', ''),
(7446, '1289797199', '贺州市', 'http://www.gxhz.gov.cn/', 0, 0, 0, 4271, 0, 1, 0, NULL, 11, '', ''),
(7447, '1289797222', '广西新闻网', 'http://www.gxnews.com.cn/', 0, 0, 0, 4272, 0, 1, 0, NULL, 1, '', ''),
(7448, '1289797222', '南宁新闻网', 'http://www.nnnews.net/', 0, 0, 0, 4272, 0, 1, 0, NULL, 2, '', ''),
(7449, '1289797222', '广西电视台', 'http://www.gxtv.cn/', 0, 0, 0, 4272, 0, 1, 0, NULL, 3, '', ''),
(7450, '1289797222', '南国早报', 'http://www.ngzb.com.cn/', 0, 0, 0, 4272, 0, 1, 0, NULL, 4, '', ''),
(7451, '1289797222', '河池网', 'http://www.hcwang.cn/', 0, 0, 0, 4272, 0, 1, 0, NULL, 5, '', ''),
(7452, '1289797222', '时空网', 'http://www.gxsky.com/', 0, 0, 0, 4272, 0, 1, 0, NULL, 6, '', ''),
(7453, '1289797222', '百色视窗', 'http://www.bsptt.gx.cn/', 0, 0, 0, 4272, 0, 1, 0, NULL, 7, '', ''),
(7454, '1289797222', '南宁电视台', 'http://www.nntv.com.cn/', 0, 0, 0, 4272, 0, 1, 0, NULL, 8, '', ''),
(7455, '1289797222', '玉林天天网', 'http://www.yulindayday.com/', 0, 0, 0, 4272, 0, 1, 0, NULL, 9, '', ''),
(7456, '1289797222', '广西日报', 'http://www.gxrb.com.cn/', 0, 0, 0, 4272, 0, 1, 0, NULL, 10, '', ''),
(7457, '1289797222', '红豆今网', 'http://www.hdjwww.com/', 0, 0, 0, 4272, 0, 1, 0, NULL, 11, '', ''),
(7458, '1289797222', '桂林生活网', 'http://www.guilinlife.com/', 0, 0, 0, 4272, 0, 1, 0, NULL, 12, '', ''),
(7459, '1289797222', '柳州新闻网', 'http://www.lznews.gov.cn/', 0, 0, 0, 4272, 0, 1, 0, NULL, 13, '', ''),
(7460, '1289797222', '贵港视窗', 'http://www.gg163.net/', 0, 0, 0, 4272, 0, 1, 0, NULL, 14, '', ''),
(7461, '1289797222', '贵港快乐网', 'http://www.gghappy.com/', 0, 0, 0, 4272, 0, 1, 0, NULL, 15, '', ''),
(7462, '1289797255', '广西气象', 'http://www.gx121.com/', 0, 0, 0, 4273, 0, 1, 0, NULL, 1, '', ''),
(7463, '1289797255', '广西公交线路', 'http://www.gx-info.gov.cn/info/bus.asp', 0, 0, 0, 4273, 0, 1, 0, NULL, 2, '', ''),
(7464, '1289797255', '列车时刻', 'http://www.huochepiao.com/lieche/', 0, 0, 0, 4273, 0, 1, 0, NULL, 3, '', ''),
(7465, '1289797255', '百度地图南宁', 'http://map.baidu.com/#word=%C4%CF%C4%FE%CA%D0&amp;amp;ct=10', 0, 0, 0, 4273, 0, 1, 0, NULL, 4, '', ''),
(7466, '1289797255', '南宁吴圩国际机场', 'http://www.nnairport.com/', 0, 0, 0, 4273, 0, 1, 0, NULL, 5, '', ''),
(7467, '1289797255', '南宁卫星地图', 'http://maps.google.com/maps?f=q&amp;amp;hl=zh-CN&amp;amp;q=%E5%8D%97%E5%AE%81&amp;amp;ie=UTF8&amp;amp;ll=22.815349,108.31378&amp;amp;spn=0.057279,0.107803&amp;amp;t=k&amp;amp;om=1', 0, 0, 0, 4273, 0, 1, 0, NULL, 6, '', ''),
(7468, '1289797255', '桂林卫星地图', 'http://maps.google.com/maps?f=q&amp;amp;hl=zh-CN&amp;amp;q=%E6%A1%82%E6%9E%97&amp;amp;ie=UTF8&amp;amp;ll=25.279684,110.265741&amp;amp;spn=0.007024,0.013475&amp;amp;t=k&amp;amp;om=1', 0, 0, 0, 4273, 0, 1, 0, NULL, 7, '', ''),
(7469, '1289797255', '百度地图广西', 'http://map.baidu.com/#word=%B9%E3%CE%F7&amp;amp;ct=10', 0, 0, 0, 4273, 0, 1, 0, NULL, 8, '', ''),
(7470, '1289797255', '携程旅游-广西', 'http://destguides.ctrip.com/china/guangxi/region52/', 0, 0, 0, 4273, 0, 1, 0, NULL, 9, '', ''),
(7471, '1289797255', '广西旅游在线', 'http://www.gxta.gov.cn/', 0, 0, 0, 4273, 0, 1, 0, NULL, 10, '', ''),
(7472, '1289797255', '桂林景点介绍', 'http://destguides.ctrip.com/china/guilin/district28/sight.html', 0, 0, 0, 4273, 0, 1, 0, NULL, 11, '', ''),
(7473, '1289797255', '众品网', 'http://www.pcate.com/', 0, 0, 0, 4273, 0, 1, 0, NULL, 12, '', ''),
(7474, '1289797255', 'POCO美食桂林站', 'http://gl.food.poco.cn/', 0, 0, 0, 4273, 0, 1, 0, NULL, 13, '', ''),
(7475, '1289797255', '南宁美食网', 'http://www.nnmsw.com/', 0, 0, 0, 4273, 0, 1, 0, NULL, 14, '', ''),
(7476, '1289797255', '广西房产街', 'http://www.gxhouse.com/', 0, 0, 0, 4273, 0, 1, 0, NULL, 15, '', ''),
(7477, '1289797255', '南宁房产管理局', 'http://fc.nanning.gov.cn/', 0, 0, 0, 4273, 0, 1, 0, NULL, 16, '', ''),
(7478, '1289797255', '搜房南宁', 'http://nn.soufun.com/', 0, 0, 0, 4273, 0, 1, 0, NULL, 17, '', ''),
(7479, '1289797255', '桂林中医院', 'http://www.glzyy.com/', 0, 0, 0, 4273, 0, 1, 0, NULL, 18, '', ''),
(7480, '1289797285', '广西大学', 'http://www.gxu.edu.cn/', 0, 0, 0, 4274, 0, 1, 0, NULL, 1, '', ''),
(7481, '1289797285', '广西民族大学', 'http://www.gxun.edu.cn/', 0, 0, 0, 4274, 0, 1, 0, NULL, 2, '', ''),
(7482, '1289797285', '广西教育网', 'http://www.gxem.cn/', 0, 0, 0, 4274, 0, 1, 0, NULL, 3, '', ''),
(7483, '1289797285', '广西教育厅', 'http://www.gxedu.gov.cn/', 0, 0, 0, 4274, 0, 1, 0, NULL, 4, '', ''),
(7484, '1289797285', '广西招生考试院', 'http://www.gxeea.cn/', 0, 0, 0, 4274, 0, 1, 0, NULL, 5, '', ''),
(7485, '1289797285', '南宁人事考试网', 'http://www.nnrkz.com/', 0, 0, 0, 4274, 0, 1, 0, NULL, 6, '', ''),
(7486, '1289797285', '广西公务员考试网', 'http://gx.gongkao.net/Official/Guangxi/', 0, 0, 0, 4274, 0, 1, 0, NULL, 7, '', ''),
(7487, '1289797310', '红豆社区', 'http://hongdou.gxnews.com.cn/', 0, 0, 0, 4275, 0, 1, 0, NULL, 1, '', ''),
(7488, '1289797310', '时空论坛', 'http://bbs.gxsky.com/', 0, 0, 0, 4275, 0, 1, 0, NULL, 2, '', ''),
(7489, '1289797310', '桂林人论坛', 'http://bbs.guilinlife.com/', 0, 0, 0, 4275, 0, 1, 0, NULL, 3, '', ''),
(7490, '1289797310', '贵港论坛', 'http://bbs.gg163.net/', 0, 0, 0, 4275, 0, 1, 0, NULL, 4, '', ''),
(7491, '1289797310', '广西贴吧', 'http://tieba.baidu.com/f?kw=%B9%E3%CE%F7', 0, 0, 0, 4275, 0, 1, 0, NULL, 5, '', ''),
(7492, '1289797310', '南宁贴吧', 'http://tieba.baidu.com/f?kw=%C4%CF%C4%FE', 0, 0, 0, 4275, 0, 1, 0, NULL, 6, '', ''),
(7493, '1289797310', '桂林贴吧', 'http://tieba.baidu.com/f?kw=%B9%F0%C1%D6', 0, 0, 0, 4275, 0, 1, 0, NULL, 7, '', ''),
(7494, '1289797310', '新平果论坛', 'http://bbs.xinpg.com/bbs_index.html', 0, 0, 0, 4275, 0, 1, 0, NULL, 8, '', ''),
(7495, '1289797310', '桂平论坛', 'http://www.gpbbs.cn/', 0, 0, 0, 4275, 0, 1, 0, NULL, 9, '', ''),
(7496, '1289797310', '灵水论坛', 'http://www.gxwmbbs.com/', 0, 0, 0, 4275, 0, 1, 0, NULL, 10, '', ''),
(7497, '1289797310', '桂江社区', 'http://bbs.zpol.cn/', 0, 0, 0, 4275, 0, 1, 0, NULL, 11, '', ''),
(7498, '1289797310', '右江论坛', 'http://bbs.gxbs.net/', 0, 0, 0, 4275, 0, 1, 0, NULL, 12, '', ''),
(7499, '1289797329', '广西壮族自治区政府', 'http://www.gxzf.gov.cn/', 0, 0, 0, 4276, 0, 1, 0, NULL, 1, '', ''),
(7500, '1289797329', '广西金质网', 'http://www.gxqts.gov.cn/', 0, 0, 0, 4276, 0, 1, 0, NULL, 2, '', ''),
(7501, '1289797329', '广西财政厅', 'http://www.gxcz.gov.cn/', 0, 0, 0, 4276, 0, 1, 0, NULL, 3, '', ''),
(7502, '1289797329', '广西国税局', 'http://www.gxgs.gov.cn/', 0, 0, 0, 4276, 0, 1, 0, NULL, 4, '', ''),
(7503, '1289797374', '通辽信息网', 'http://www.tlxxw.com/', 0, 0, 0, 4281, 0, 1, 0, NULL, 1, '', ''),
(7504, '1289797374', '呼伦贝尔日报', 'http://www.hlbrdaily.com.cn/', 0, 0, 0, 4281, 0, 1, 0, NULL, 2, '', ''),
(7505, '1289797374', '包头信息港', 'http://www.bt163.net/', 0, 0, 0, 4281, 0, 1, 0, NULL, 3, '', ''),
(7506, '1289797374', '河套信息港', 'http://www.htcnc.net/', 0, 0, 0, 4281, 0, 1, 0, NULL, 4, '', ''),
(7507, '1289797374', '通辽信息港', 'http://www.nmtl.cn/', 0, 0, 0, 4281, 0, 1, 0, NULL, 5, '', ''),
(7508, '1289797374', '准格尔之窗', 'http://www.zge.gov.cn/', 0, 0, 0, 4281, 0, 1, 0, NULL, 6, '', ''),
(7509, '1289797374', '呼伦贝尔火网', 'http://www.0470a.com/', 0, 0, 0, 4281, 0, 1, 0, NULL, 7, '', ''),
(7510, '1289797402', '赤峰广播电视网', 'http://www.cfradio.cn/', 0, 0, 0, 4282, 0, 1, 0, NULL, 1, '', ''),
(7511, '1289797402', '呼伦贝尔日报', 'http://www.hlbrdaily.com.cn/', 0, 0, 0, 4282, 0, 1, 0, NULL, 2, '', ''),
(7512, '1289797402', '内蒙古金融网', 'http://www.nmgjrw.com/', 0, 0, 0, 4282, 0, 1, 0, NULL, 3, '', ''),
(7513, '1289797402', '北方IT网', 'http://www.nmzol.com/', 0, 0, 0, 4282, 0, 1, 0, NULL, 4, '', ''),
(7514, '1289797402', '通辽之窗', 'http://www.0475.org/', 0, 0, 0, 4282, 0, 1, 0, NULL, 5, '', ''),
(7515, '1289797402', '中国西部网', 'http://www.chinawestnews.net/', 0, 0, 0, 4282, 0, 1, 0, NULL, 6, '', ''),
(7516, '1289797402', '赤峰信息港', 'http://www.024000.org/', 0, 0, 0, 4282, 0, 1, 0, NULL, 7, '', ''),
(7517, '1289797402', '新焦点网', 'http://www.xjdcm.cn/', 0, 0, 0, 4282, 0, 1, 0, NULL, 8, '', ''),
(7518, '1289797454', '福彩', 'http://www.nmlottery.com.cn/', 0, 0, 0, 4283, 0, 1, 0, NULL, 1, '', ''),
(7519, '1289797454', '体彩', 'http://www.nmtc.com.cn/', 0, 0, 0, 4283, 0, 1, 0, NULL, 2, '', ''),
(7520, '1289797454', '包商银行', 'http://www.bcb.com.cn/', 0, 0, 0, 4283, 0, 1, 0, NULL, 3, '', ''),
(7521, '1289797454', '电信', 'http://nm.ct10000.com/', 0, 0, 0, 4283, 0, 1, 0, NULL, 4, '', ''),
(7522, '1289797454', '移动', 'http://www.nm.10086.cn/', 0, 0, 0, 4283, 0, 1, 0, NULL, 5, '', ''),
(7523, '1289797454', '联通', 'http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?id=&amp;amp;arno=00010029', 0, 0, 0, 4283, 0, 1, 0, NULL, 6, '', ''),
(7524, '1289797454', '天气预报', 'http://nmg.weather.com.cn/index.shtml', 0, 0, 0, 4283, 0, 1, 0, NULL, 7, '', ''),
(7525, '1289797454', '内蒙古火车票', 'http://www.huoche.com/dingpiao/sheng/neimenggu', 0, 0, 0, 4283, 0, 1, 0, NULL, 8, '', ''),
(7526, '1289797454', '呼和浩特公交查询', 'http://huhehaote.8684.cn/', 0, 0, 0, 4283, 0, 1, 0, NULL, 9, '', ''),
(7527, '1289797454', '内蒙古旅游', 'http://www.nmgtour.gov.cn/', 0, 0, 0, 4283, 0, 1, 0, NULL, 10, '', ''),
(7528, '1289797454', '赤峰旅游网', 'http://www.cfly.net/', 0, 0, 0, 4283, 0, 1, 0, NULL, 11, '', ''),
(7529, '1289797454', '内蒙旅游在线', 'http://www.nmlyzx.com/', 0, 0, 0, 4283, 0, 1, 0, NULL, 12, '', ''),
(7530, '1289797454', '内蒙古房地产网', 'http://www.nmgfdc.com/', 0, 0, 0, 4283, 0, 1, 0, NULL, 13, '', ''),
(7531, '1289797454', '内蒙古房产网', 'http://www.nmgfc.cn/', 0, 0, 0, 4283, 0, 1, 0, NULL, 14, '', ''),
(7532, '1289797454', '呼和浩特房地产网', 'http://www.365hf.com/', 0, 0, 0, 4283, 0, 1, 0, NULL, 15, '', ''),
(7533, '1289797454', '鄂尔多斯房产网', 'http://www.eedsf.cn/', 0, 0, 0, 4283, 0, 1, 0, NULL, 16, '', ''),
(7534, '1289797454', '包头房地产网', 'http://www.365baotou.com/', 0, 0, 0, 4283, 0, 1, 0, NULL, 17, '', ''),
(8219, '1289886973', '消费反利', 'http://www.doudou.com/adCps.php', 0, 0, 0, 1007, 0, 1, 1291971543, NULL, 18, '', ''),
(7536, '1289797454', '互联星空·内蒙古', 'http://nm.vnet.cn/', 0, 0, 0, 4283, 0, 1, 0, NULL, 19, '', ''),
(7537, '1289797454', '天堂草原音乐网', 'http://www.ttcy.tv/', 0, 0, 0, 4283, 0, 1, 0, NULL, 20, '', ''),
(7538, '1289797454', '金方舟赛鸽', 'http://www.jfzsgclub.com/', 0, 0, 0, 4283, 0, 1, 0, NULL, 21, '', ''),
(7539, '1289797484', '内蒙古大学', 'http://www.imu.edu.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 1, '', ''),
(7540, '1289797484', '内蒙古民族大学', 'http://www.imun.edu.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 2, '', ''),
(7541, '1289797484', '内蒙古科技大学', 'http://www.imust.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 3, '', ''),
(7542, '1289797484', '内蒙古师范大学', 'http://www.imnu.edu.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 4, '', ''),
(7543, '1289797484', '内蒙古财经学院', 'http://www.imfec.edu.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 5, '', ''),
(7544, '1289797484', '内蒙古工业大学', 'http://www.imut.edu.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 6, '', ''),
(7545, '1289797484', '内蒙古师范大学鸿德学院', 'http://www.honder.com/new/', 0, 0, 0, 4284, 0, 1, 0, NULL, 7, '', ''),
(7546, '1289797484', '内蒙古医学院', 'http://www.immc.edu.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 8, '', ''),
(7547, '1289797484', '内蒙古大学创业学院', 'http://www.imuchuangye.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 9, '', ''),
(7548, '1289797484', '呼和浩特职业学院', 'http://www.hhvc.net.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 10, '', ''),
(7549, '1289797484', '内蒙古轩元职业学院', 'http://www.nmshangfa.cn/Index.html', 0, 0, 0, 4284, 0, 1, 0, NULL, 11, '', ''),
(7550, '1289797484', '兴安职业技术学院', 'http://www.nmxzy.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 12, '', ''),
(7551, '1289797484', '内蒙古农业大学', 'http://www.imau.edu.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 13, '', ''),
(7552, '1289797484', '乌兰察布职业学院', 'http://www.wlcbzyxy.com.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 14, '', ''),
(7553, '1289797484', '呼伦贝尔学院', 'http://www.hlbrc.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 15, '', ''),
(7554, '1289797484', '赤峰学院', 'http://www.cfxy.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 16, '', ''),
(7555, '1289797484', '集宁师范学院', 'http://www.jntc.nm.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 17, '', ''),
(7556, '1289797484', '乌兰察布医学高等专科学校', 'http://www.wlcbswx.com/', 0, 0, 0, 4284, 0, 1, 0, NULL, 18, '', ''),
(7557, '1289797484', '河套大学', 'http://www.hetaodaxue.com/', 0, 0, 0, 4284, 0, 1, 0, NULL, 19, '', ''),
(7558, '1289797484', '内蒙古建筑职业技术学院', 'http://www.imaa.edu.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 20, '', ''),
(7559, '1289797484', '内蒙古丰州职业学院', 'http://www.qcdx.net/', 0, 0, 0, 4284, 0, 1, 0, NULL, 21, '', ''),
(7560, '1289797484', '赤峰职业技术学院', 'http://www.cfzyjsxy.com/', 0, 0, 0, 4284, 0, 1, 0, NULL, 22, '', ''),
(7561, '1289797484', '内蒙古北方职业技术学院', 'http://www.nmbfxy.com/index.asp', 0, 0, 0, 4284, 0, 1, 0, NULL, 23, '', ''),
(7562, '1289797484', '内蒙古交通职业技术学院', 'http://www.nmjtzy.com/', 0, 0, 0, 4284, 0, 1, 0, NULL, 24, '', ''),
(7563, '1289797484', '内蒙古科技职业学院', 'http://www.imstu.org.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 25, '', ''),
(7564, '1289797484', '内蒙古商贸职业学院', 'http://www.imvcc.com/', 0, 0, 0, 4284, 0, 1, 0, NULL, 26, '', ''),
(7565, '1289797484', '内蒙古化工职业学院', 'http://www.hgzyxy.com/', 0, 0, 0, 4284, 0, 1, 0, NULL, 27, '', ''),
(7566, '1289797484', '乌海职业技术学院', 'http://www.whvtc.net/', 0, 0, 0, 4284, 0, 1, 0, NULL, 28, '', ''),
(7567, '1289797484', '内蒙古经贸外语职业学院', 'http://www.nmgjwy.com/', 0, 0, 0, 4284, 0, 1, 0, NULL, 29, '', ''),
(7568, '1289797484', '内蒙古电子信息职业技术学院', 'http://www.imeic.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 30, '', ''),
(7569, '1289797484', '包头铁道职业技术学院', 'http://www.bttzy.com/', 0, 0, 0, 4284, 0, 1, 0, NULL, 31, '', ''),
(7570, '1289797484', '锡林郭勒职业学院', 'http://www.xlglvc.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 32, '', ''),
(7571, '1289797484', '包头钢铁职业技术学院', 'http://www.btsvc.net/', 0, 0, 0, 4284, 0, 1, 0, NULL, 33, '', ''),
(7572, '1289797484', '包头轻工职业技术学院', 'http://www.btqy.com.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 34, '', ''),
(7573, '1289797484', '鄂尔多斯职业学院', 'http://www.ordosvc.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 35, '', ''),
(7574, '1289797484', '内蒙古警察职业学院', 'http://www.imppc.cn/', 0, 0, 0, 4284, 0, 1, 0, NULL, 36, '', ''),
(7575, '1289797484', '内蒙古体育职业学院', 'http://www.nmtyxy.com/jxjyc_tz.php', 0, 0, 0, 4284, 0, 1, 0, NULL, 37, '', ''),
(7576, '1289797506', '内蒙古贴吧', 'http://tieba.baidu.com/f?kw=%C4%DA%C3%C9%B9%C5', 0, 0, 0, 4285, 0, 1, 0, NULL, 1, '', ''),
(7577, '1289797506', '呼和浩特吧', 'http://tieba.baidu.com/f?kw=%BA%F4%BA%CD%BA%C6%CC%D8', 0, 0, 0, 4285, 0, 1, 0, NULL, 2, '', ''),
(7578, '1289797506', '搜狐社区-内蒙古', 'http://club.travel.sohu.com/list_art_sub.new.php?b=neimenggu', 0, 0, 0, 4285, 0, 1, 0, NULL, 3, '', ''),
(7579, '1289797506', '牙克石雅情社区', 'http://www.yakeshi.com.cn/', 0, 0, 0, 4285, 0, 1, 0, NULL, 4, '', ''),
(7580, '1289797506', '小丽花', 'http://www.bfxb.cn/', 0, 0, 0, 4285, 0, 1, 0, NULL, 5, '', ''),
(7581, '1289797528', '教育厅', 'http://www.nmgov.edu.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 1, '', ''),
(7582, '1289797528', '人事厅', 'http://www.nmgrst.com/', 0, 0, 0, 4286, 0, 1, 0, NULL, 2, '', ''),
(7583, '1289797528', '民政厅', 'http://www.nmmzt.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 3, '', ''),
(7584, '1289797528', '监察厅', 'http://www.nmjjw.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 4, '', ''),
(7585, '1289797528', '质量技术监督', 'http://www.nmgzjj.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 5, '', ''),
(7586, '1289797528', '财政厅', 'http://www.nmgcz.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 6, '', ''),
(7587, '1289797528', '环境保护厅', 'http://www.nmgepb.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 7, '', ''),
(7588, '1289797528', '食品药品监督管理局', 'http://www.nmfda.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 8, '', ''),
(7589, '1289797528', '民族事务委员会', 'http://www.nmgmzw.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 9, '', ''),
(7590, '1289797528', '水利厅', 'http://www.nmgslw.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 10, '', ''),
(7591, '1289797528', '人口和计划生育委员会', 'http://www.nmgpop.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 11, '', ''),
(7592, '1289797528', '交通厅', 'http://www.nmjt.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 12, '', ''),
(7593, '1289797528', '住房和城乡建设厅', 'http://www.nmgjsw.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 13, '', ''),
(7594, '1289797528', '知识产权局', 'http://www.nmipo.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 14, '', ''),
(7595, '1289797528', '卫生厅', 'http://www.nmwst.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 15, '', ''),
(7596, '1289797528', '通信管理局', 'http://www.nmca.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 16, '', ''),
(7597, '1289797528', '包头', 'http://www.baotou.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 17, '', ''),
(7598, '1289797528', '赤峰', 'http://www.chifeng.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 18, '', ''),
(7599, '1289797528', '通辽', 'http://www.tongliao.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 19, '', ''),
(7600, '1289797528', '呼伦贝尔', 'http://www.hulunbeier.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 20, '', ''),
(7601, '1289797528', '乌海', 'http://www.wuhai.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 21, '', ''),
(7602, '1289797528', '鄂尔多斯', 'http://www.ordos.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 22, '', ''),
(7603, '1289797528', '乌兰察布', 'http://www.wulanchabu.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 23, '', ''),
(7604, '1289797528', '锡林郭勒', 'http://www.xlgl.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 24, '', ''),
(7605, '1289797528', '巴彦淖尔', 'http://www.bynr.gov.cn/', 0, 0, 0, 4286, 0, 1, 0, NULL, 25, '', ''),
(7606, '1289797784', '中国拉萨', 'http://www.lasa.gov.cn/', 0, 0, 0, 4291, 0, 1, 0, NULL, 1, '', ''),
(7607, '1289797820', '中国藏族民俗网', 'http://www.tibetanct.com/', 0, 0, 0, 4292, 0, 1, 0, NULL, 1, '', ''),
(7608, '1289797820', '藏人文化网', 'http://www.tibetcul.com/', 0, 0, 0, 4292, 0, 1, 0, NULL, 2, '', ''),
(7609, '1289797820', '中国西藏新闻网', 'http://www.chinatibetnews.com/', 0, 0, 0, 4292, 0, 1, 0, NULL, 3, '', ''),
(7610, '1289797820', '新疆生产建设兵团', 'http://www.xjbt.gov.cn/', 0, 0, 0, 4292, 0, 1, 0, NULL, 4, '', ''),
(7611, '1289797820', '中国西藏信息中心', 'http://www.tibet.cn/', 0, 0, 0, 4292, 0, 1, 0, NULL, 5, '', ''),
(7612, '1289797820', '拉萨晚报', 'http://www.lasa-eveningnews.com.cn/', 0, 0, 0, 4292, 0, 1, 0, NULL, 6, '', ''),
(7613, '1289797869', '拉萨气象', 'http://www.cma.gov.cn/tqyb/weatherframe/55591/1.html', 0, 0, 0, 4293, 0, 1, 0, NULL, 1, '', ''),
(7614, '1289797869', '西藏交通厅', 'http://2006.moc.gov.cn/06xizang/', 0, 0, 0, 4293, 0, 1, 0, NULL, 2, '', ''),
(7615, '1289797869', '西藏旅游', 'http://www.oktibet.com/', 0, 0, 0, 4293, 0, 1, 0, NULL, 3, '', ''),
(7616, '1289797869', '西藏烹饪餐饮饭店业协会', 'http://www.tibetcook.com/', 0, 0, 0, 4293, 0, 1, 0, NULL, 4, '', ''),
(7617, '1289797869', '房产装修', 'http://www.xzcs.gov.cn/realestate.aspx', 0, 0, 0, 4293, 0, 1, 0, NULL, 5, '', ''),
(7618, '1289797869', '食品药品监督管理局', 'http://www.xizangda.gov.cn/', 0, 0, 0, 4293, 0, 1, 0, NULL, 6, '', ''),
(7619, '1289797894', '西藏大学', 'http://www.utibet.edu.cn/', 0, 0, 0, 4294, 0, 1, 0, NULL, 1, '', ''),
(7620, '1289797894', '西藏民族学院', 'http://www.xzmy.edu.cn/', 0, 0, 0, 4294, 0, 1, 0, NULL, 2, '', ''),
(7621, '1289797894', '西藏教育考试院', 'http://www.xzzsks.com.cn/', 0, 0, 0, 4294, 0, 1, 0, NULL, 3, '', ''),
(7622, '1289797915', '百度知道-西藏', 'http://zhidao.baidu.com/browse/267', 0, 0, 0, 4295, 0, 1, 0, NULL, 1, '', ''),
(7623, '1289797915', '西藏搜吧', 'http://post.soso.com/sobar.q?op=enterbar&amp;amp;ch=&amp;amp;kw=&amp;amp;bn=%CE%F7%B2%D8&amp;amp;proto=4', 0, 0, 0, 4295, 0, 1, 0, NULL, 2, '', ''),
(7624, '1289797915', '拉萨搜吧', 'http://post.soso.com/sobar.q?op=enterbar&amp;amp;ch=&amp;amp;kw=&amp;amp;bn=%C0%AD%C8%F8&amp;amp;proto=4', 0, 0, 0, 4295, 0, 1, 0, NULL, 3, '', ''),
(7625, '1289797949', '中国西藏信息中心', 'http://www.tibetinfor.com/', 0, 0, 0, 4296, 0, 1, 0, NULL, 1, '', ''),
(7626, '1289798036', '国务院国有资产监督管理委员会', 'http://www.sasac.gov.cn/index.html', 0, 0, 0, 3077, 0, 1, 1289798036, NULL, 1, '', ''),
(7627, '1289798077', '宁夏信息港', 'http://www.nx.cninfo.net/', 0, 0, 0, 4301, 0, 1, 0, NULL, 1, '', ''),
(7628, '1289798077', '银川新闻网', 'http://www.ycen.com.cn/', 0, 0, 0, 4301, 0, 1, 0, NULL, 2, '', ''),
(7629, '1289798077', '石嘴山新闻网', 'http://www.szsnews.com/', 0, 0, 0, 4301, 0, 1, 0, NULL, 3, '', ''),
(7630, '1289798077', '吴忠新闻网', 'http://wz.nxnews.cn/', 0, 0, 0, 4301, 0, 1, 0, NULL, 4, '', ''),
(7631, '1289798077', '南国都市网', 'http://www.scity.cn/', 0, 0, 0, 4301, 0, 1, 0, NULL, 5, '', ''),
(7632, '1289798077', '宁夏网', 'http://www.nxnet.cn/', 0, 0, 0, 4301, 0, 1, 0, NULL, 6, '', ''),
(7633, '1289798099', '宁夏网虫', 'http://www.nx.cn/', 0, 0, 0, 4302, 0, 1, 0, NULL, 1, '', ''),
(7634, '1289798099', '宁夏新闻网', 'http://www.nxnews.net/', 0, 0, 0, 4302, 0, 1, 0, NULL, 2, '', ''),
(7635, '1289798099', '宁夏信息港', 'http://www.nx.cninfo.net/', 0, 0, 0, 4302, 0, 1, 0, NULL, 3, '', ''),
(7636, '1289798099', '宁夏电视台', 'http://www.nxtv.com.cn/', 0, 0, 0, 4302, 0, 1, 0, NULL, 4, '', ''),
(7637, '1289798099', '银川新闻网', 'http://www.ycen.com.cn/', 0, 0, 0, 4302, 0, 1, 0, NULL, 5, '', ''),
(7638, '1289798099', '新消息报', 'http://szb.nxnet.cn/index2.aspx', 0, 0, 0, 4302, 0, 1, 0, NULL, 6, '', ''),
(7639, '1289798099', '宁夏日报', 'http://www.nxnet.net/', 0, 0, 0, 4302, 0, 1, 0, NULL, 7, '', ''),
(7640, '1289798127', '宁夏新闻网旅游频道', 'http://www.nxnews.net/travel/', 0, 0, 0, 4303, 0, 1, 0, NULL, 1, '', ''),
(7641, '1289798127', '宁夏风韵', 'http://tour.yc.nx.cn/', 0, 0, 0, 4303, 0, 1, 0, NULL, 2, '', ''),
(7642, '1289798127', '宁夏旅游网', 'http://www.nxtour.com.cn/', 0, 0, 0, 4303, 0, 1, 0, NULL, 3, '', ''),
(7643, '1289798127', '宁夏旅游政务网', 'http://www.nxta.gov.cn/', 0, 0, 0, 4303, 0, 1, 0, NULL, 4, '', ''),
(7644, '1289798127', '携程旅游-宁夏', 'http://destguides.ctrip.com/china/ningxia/region63/', 0, 0, 0, 4303, 0, 1, 0, NULL, 5, '', ''),
(7645, '1289798127', '宁夏信息港美食', 'http://soofan.yc.nx.cn/', 0, 0, 0, 4303, 0, 1, 0, NULL, 6, '', ''),
(7646, '1289798127', '宁夏美食在线', 'http://www.0951cate.com/', 0, 0, 0, 4303, 0, 1, 0, NULL, 7, '', ''),
(7647, '1289798127', '宁夏房产资讯网', 'http://www.nxf.cn/', 0, 0, 0, 4303, 0, 1, 0, NULL, 8, '', ''),
(7648, '1289798127', '银川房产网', 'http://www.ychfc.com/', 0, 0, 0, 4303, 0, 1, 0, NULL, 9, '', ''),
(7649, '1289798127', '银川市房产管理局', 'http://www.ycre.gov.cn/', 0, 0, 0, 4303, 0, 1, 0, NULL, 10, '', ''),
(7650, '1289798127', '银川住房公积金网', 'http://www.ycgjj.com.cn/', 0, 0, 0, 4303, 0, 1, 0, NULL, 11, '', ''),
(7651, '1289798127', '宁夏新闻网健康频道', 'http://www.nxnews.net/health/', 0, 0, 0, 4303, 0, 1, 0, NULL, 12, '', ''),
(7652, '1289798127', '宁夏卫生网', 'http://www.nxws.gov.cn/', 0, 0, 0, 4303, 0, 1, 0, NULL, 13, '', ''),
(7653, '1289798127', '宁夏医学院附属医院', 'http://nyfy.com.cn/', 0, 0, 0, 4303, 0, 1, 0, NULL, 14, '', ''),
(7654, '1289798162', '宁夏教育网', 'http://www.nxycedu.com/', 0, 0, 0, 4304, 0, 1, 0, NULL, 1, '', ''),
(7655, '1289798162', '宁夏人事考试中心', 'http://www.nxpta.gov.cn/', 0, 0, 0, 4304, 0, 1, 0, NULL, 2, '', ''),
(7656, '1289798162', '宁夏理工学院', 'http://www.nxist.com/', 0, 0, 0, 4304, 0, 1, 0, NULL, 3, '', ''),
(7657, '1289798162', '宁夏大学', 'http://www.nxu.edu.cn/', 0, 0, 0, 4304, 0, 1, 0, NULL, 4, '', ''),
(7658, '1289798162', '宁夏师范学院', 'http://www.nxtu.cn/', 0, 0, 0, 4304, 0, 1, 0, NULL, 5, '', ''),
(7659, '1289798162', '银川大学', 'http://www.ycu.com.cn/', 0, 0, 0, 4304, 0, 1, 0, NULL, 6, '', ''),
(7660, '1289798184', '宁夏贴吧', 'http://tieba.baidu.com/f?kw=%E5%AE%81%E5%A4%8F', 0, 0, 0, 4305, 0, 1, 0, NULL, 1, '', ''),
(7661, '1289798184', '银川贴吧', 'http://tieba.baidu.com/f?kw=%E9%93%B6%E5%B7%9D', 0, 0, 0, 4305, 0, 1, 0, NULL, 2, '', ''),
(7662, '1289798184', '吴忠贴吧', 'http://tieba.baidu.com/f?kw=%E5%90%B4%E5%BF%A0', 0, 0, 0, 4305, 0, 1, 0, NULL, 3, '', ''),
(7663, '1289798184', '宁报论坛', 'http://bbs.nxnet.cn/', 0, 0, 0, 4305, 0, 1, 0, NULL, 4, '', ''),
(7664, '1289798184', '蔓草社区', 'http://bbs.nxnews.net/forum/', 0, 0, 0, 4305, 0, 1, 0, NULL, 5, '', ''),
(7665, '1289798184', '石嘴山贴吧', 'http://tieba.baidu.com/f?kw=%E7%9F%B3%E5%98%B4%E5%B1%B1', 0, 0, 0, 4305, 0, 1, 0, NULL, 6, '', ''),
(7666, '1289798184', '宁夏网虫', 'http://www.nx.cn/', 0, 0, 0, 4305, 0, 1, 0, NULL, 7, '', ''),
(7667, '1289798209', '宁夏回族自治区政府', 'http://www.nx.gov.cn/', 0, 0, 0, 4306, 0, 1, 0, NULL, 1, '', ''),
(7668, '1289798209', '宁夏工商', 'http://www.ngsh.gov.cn/', 0, 0, 0, 4306, 0, 1, 0, NULL, 2, '', ''),
(7669, '1289798209', '银川市政府', 'http://www.yinchuan.gov.cn/', 0, 0, 0, 4306, 0, 1, 0, NULL, 3, '', ''),
(7670, '1289798264', '博尔塔拉蒙古自治州', 'http://www.xjboz.gov.cn/', 0, 0, 0, 4311, 0, 1, 0, NULL, 1, '', ''),
(7671, '1289798264', '巴音郭楞蒙古自治州', 'http://www.xjbz.gov.cn/', 0, 0, 0, 4311, 0, 1, 0, NULL, 2, '', ''),
(7672, '1289798264', '哈密地区', 'http://www.hami.gov.cn/', 0, 0, 0, 4311, 0, 1, 0, NULL, 3, '', ''),
(7673, '1289798264', '喀什地区', 'http://www.kashi.gov.cn/', 0, 0, 0, 4311, 0, 1, 0, NULL, 4, '', ''),
(7674, '1289798264', '克拉玛依市', 'http://www.klmy.gov.cn/', 0, 0, 0, 4311, 0, 1, 0, NULL, 5, '', ''),
(7675, '1289798291', '新疆生产建设兵团', 'http://www.xjbt.gov.cn/', 0, 0, 0, 4312, 0, 1, 0, NULL, 1, '', ''),
(7676, '1289798291', '新疆新闻在线', 'http://www.xjbs.com.cn/', 0, 0, 0, 4312, 0, 1, 0, NULL, 2, '', ''),
(7677, '1289798291', '伊犁新闻网', 'http://www.ylxw.com.cn/', 0, 0, 0, 4312, 0, 1, 0, NULL, 3, '', ''),
(7678, '1289798291', '阿勒泰新闻网', 'http://altxw.com/', 0, 0, 0, 4312, 0, 1, 0, NULL, 4, '', ''),
(7679, '1289798291', '克拉玛依网', 'http://www.kelamayi.com.cn/', 0, 0, 0, 4312, 0, 1, 0, NULL, 5, '', ''),
(7680, '1289798291', '绿河谷', 'http://www.ylnet.com.cn/', 0, 0, 0, 4312, 0, 1, 0, NULL, 6, '', ''),
(7681, '1289798291', '天山网', 'http://www.tianshannet.com.cn/', 0, 0, 0, 4312, 0, 1, 0, NULL, 7, '', ''),
(7682, '1289798291', '新疆日报', 'http://www.xjdaily.com/', 0, 0, 0, 4312, 0, 1, 0, NULL, 8, '', ''),
(7683, '1289798291', '新疆都市报', 'http://epaper.xjts.cn/', 0, 0, 0, 4312, 0, 1, 0, NULL, 9, '', ''),
(7684, '1289798291', '新疆法制报', 'http://www.xjfzb.com/', 0, 0, 0, 4312, 0, 1, 0, NULL, 10, '', ''),
(7685, '1289798291', '新疆经济报', 'http://epaper.xjjjb.com/', 0, 0, 0, 4312, 0, 1, 0, NULL, 11, '', ''),
(7686, '1289798291', '乌鲁木齐晚报', 'http://www.wlmqwb.com/', 0, 0, 0, 4312, 0, 1, 0, NULL, 12, '', ''),
(7687, '1289798291', '新疆电视台', 'http://www.xjtvs.com.cn/', 0, 0, 0, 4312, 0, 1, 0, NULL, 13, '', ''),
(7688, '1289798314', '新疆机场', 'http://www.xjairport.com/', 0, 0, 0, 4313, 0, 1, 0, NULL, 1, '', ''),
(7689, '1289798314', '乌鲁木齐公交', 'http://wulumuqi.8684.cn/', 0, 0, 0, 4313, 0, 1, 0, NULL, 2, '', ''),
(7690, '1289798314', '新疆旅游网', 'http://www.xinjiangtour.gov.cn/', 0, 0, 0, 4313, 0, 1, 0, NULL, 3, '', ''),
(7691, '1289798314', '新丝路旅游', 'http://tour.xj163.cn/', 0, 0, 0, 4313, 0, 1, 0, NULL, 4, '', ''),
(7692, '1289798314', '新疆美食网', 'http://www.xjcate.cn/website/index.html', 0, 0, 0, 4313, 0, 1, 0, NULL, 5, '', ''),
(7693, '1289798314', '叮当市场', 'http://dd.xj163.cn/', 0, 0, 0, 4313, 0, 1, 0, NULL, 6, '', ''),
(7694, '1289798314', '万丰房产信息网', 'http://www.xjwf.com/', 0, 0, 0, 4313, 0, 1, 0, NULL, 7, '', ''),
(7695, '1289798314', '新疆建设网', 'http://www.xjjs.gov.cn/Defaault.aspx', 0, 0, 0, 4313, 0, 1, 0, NULL, 8, '', ''),
(7696, '1289798314', '新疆房产管理局', 'http://www.8256.com/url/010697.htm', 0, 0, 0, 4313, 0, 1, 0, NULL, 9, '', ''),
(7697, '1289798314', '自治区中医院', 'http://www.xjtcm.com/', 0, 0, 0, 4313, 0, 1, 0, NULL, 10, '', ''),
(7698, '1289798338', '新疆大学', 'http://www.xju.edu.cn/', 0, 0, 0, 4314, 0, 1, 0, NULL, 1, '', ''),
(7699, '1289798338', '石河子大学', 'http://www.shzu.edu.cn/', 0, 0, 0, 4314, 0, 1, 0, NULL, 2, '', ''),
(7700, '1289798338', '新疆农业大学', 'http://www.xjau.edu.cn/', 0, 0, 0, 4314, 0, 1, 0, NULL, 3, '', ''),
(7701, '1289798338', '塔里木大学', 'http://www.taru.edu.cn/', 0, 0, 0, 4314, 0, 1, 0, NULL, 4, '', ''),
(7702, '1289798338', '新疆师范大学', 'http://www.xjnu.edu.cn/', 0, 0, 0, 4314, 0, 1, 0, NULL, 5, '', ''),
(7703, '1289798338', '新疆财经学院', 'http://www.xjufe.edu.cn/', 0, 0, 0, 4314, 0, 1, 0, NULL, 6, '', ''),
(7704, '1289798364', '新疆吧', 'http://tieba.baidu.com/f?kw=%D0%C2%BD%AE&amp;amp;fr=ala0', 0, 0, 0, 4315, 0, 1, 0, NULL, 1, '', ''),
(7705, '1289798364', '克拉玛依强市论坛', 'http://www.klmybbs.com/', 0, 0, 0, 4315, 0, 1, 0, NULL, 2, '', ''),
(7706, '1289798364', '小羊军团', 'http://www.xyjt.org/', 0, 0, 0, 4315, 0, 1, 0, NULL, 3, '', ''),
(7707, '1289798380', '海关总署', 'http://www.customs.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798380, NULL, 1, '', ''),
(7708, '1289798380', '国家税务总局', 'http://www.chinatax.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798380, NULL, 2, '', ''),
(7709, '1289798380', '国家工商行政管理总局', 'http://www.saic.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798380, NULL, 3, '', ''),
(7710, '1289798380', '国家质量监督检验检疫总局', 'http://www.aqsiq.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798380, NULL, 4, '', ''),
(7711, '1289798380', '国家广播电影电视总局', 'http://www.chinasarft.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798380, NULL, 5, '', ''),
(7712, '1289798380', '国家新闻出版总署', 'http://www.gapp.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798380, NULL, 6, '', ''),
(7713, '1289798380', '国家体育总局', 'http://www.sport.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798380, NULL, 7, '', ''),
(7714, '1289798380', '国家安全生产监督管理总局', 'http://www.chinasafety.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798380, NULL, 8, '', ''),
(7715, '1289798380', '国家统计局', 'http://www.stats.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798380, NULL, 9, '', ''),
(7716, '1289798380', '国家林业局', 'http://www.forestry.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289802823, NULL, 10, '', ''),
(8225, '1290230924', '广州天气预报', 'http://www.weather.com.cn/html/weather/101280101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 3, '', ''),
(7717, '1289798380', '国家知识产权局', 'http://www.sipo.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798380, NULL, 11, '', ''),
(7718, '1289798403', '新疆政府网', 'http://www.xinjiang.gov.cn/', 0, 0, 0, 4316, 0, 1, 0, NULL, 1, '', ''),
(7719, '1289798403', '卫生厅', 'http://www.xjwst.gov.cn/', 0, 0, 0, 4316, 0, 1, 0, NULL, 2, '', ''),
(7720, '1289798403', '博尔塔拉蒙古自治州', 'http://www.xjboz.gov.cn/', 0, 0, 0, 4316, 0, 1, 0, NULL, 3, '', ''),
(7721, '1289798403', '巴音郭楞蒙古自治州', 'http://www.xjbz.gov.cn/', 0, 0, 0, 4316, 0, 1, 0, NULL, 4, '', ''),
(7722, '1289798467', '国家旅游局', 'http://www.cnta.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798467, NULL, 12, '', ''),
(7723, '1289798467', '国家宗教事务局', 'http://www.sara.gov.cn/GB/', 0, 0, 0, 3078, 0, 1, 1289798467, NULL, 13, '', ''),
(7724, '1289798467', '国务院参事室', 'http://www.counsellor.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798467, NULL, 14, '', ''),
(7725, '1289798467', '国务院机关事务管理局', 'http://www.ggj.gov.cn/', 0, 0, 0, 3078, 0, 1, 1289798467, NULL, 15, '', ''),
(7726, '1289798467', '国家预防腐败局', 'http://yfj.mos.gov.cn/yfj/', 0, 0, 0, 3078, 0, 1, 1289798467, NULL, 16, '', ''),
(7727, '1289798645', '国务院侨务办公室', 'http://www.gqb.gov.cn/index.shtml', 0, 0, 0, 3079, 0, 1, 1289798645, NULL, 1, '', ''),
(7728, '1289798645', '国务院港澳事务办公室', 'http://www.hmo.gov.cn/public/index.htm', 0, 0, 0, 3079, 0, 1, 1289798645, NULL, 2, '', ''),
(7729, '1289798645', '国务院法制办公室', 'http://www.chinalaw.gov.cn/', 0, 0, 0, 3079, 0, 1, 1289798645, NULL, 3, '', ''),
(7730, '1289798645', '国务院研究室', 'http://www.gov.cn/gjjg/2005-12/26/content_137261.htm', 0, 0, 0, 3079, 0, 1, 1289798645, NULL, 4, '', ''),
(7731, '1289798645', '国务院台湾事务办公室', 'http://www.gwytb.gov.cn/', 0, 0, 0, 3079, 0, 1, 1289798645, NULL, 5, '', ''),
(7732, '1289798645', '国务院新闻办公室', 'http://www.scio.gov.cn/', 0, 0, 0, 3079, 0, 1, 1289798645, NULL, 6, '', ''),
(7733, '1289798646', '香港政府一站通', 'http://www.gov.hk/', 0, 0, 0, 4321, 0, 1, 0, NULL, 1, '', ''),
(7734, '1289798667', 'MSN香港', 'http://hk.msn.com/', 0, 0, 0, 4322, 0, 1, 0, NULL, 1, '', ''),
(7735, '1289798667', '新城广播电台', 'http://www.metroradio.com.hk/', 0, 0, 0, 4322, 0, 1, 0, NULL, 2, '', ''),
(7736, '1289798667', '雅虎香港', 'http://hk.yahoo.com/', 0, 0, 0, 4322, 0, 1, 0, NULL, 3, '', ''),
(7737, '1289798667', '凤凰网', 'http://www.ifeng.com/', 0, 0, 0, 4322, 0, 1, 0, NULL, 4, '', ''),
(7738, '1289798667', '香港文汇报', 'http://www.wenweipo.com/', 0, 0, 0, 4322, 0, 1, 0, NULL, 5, '', ''),
(7739, '1289798667', '大公报', 'http://www.takungpao.com/', 0, 0, 0, 4322, 0, 1, 0, NULL, 6, '', ''),
(7740, '1289798667', '香港商报', 'http://www.hkcd.com.hk/', 0, 0, 0, 4322, 0, 1, 0, NULL, 7, '', ''),
(7741, '1289798688', '香港天文台', 'http://gb.weather.gov.hk/', 0, 0, 0, 4323, 0, 1, 0, NULL, 1, '', ''),
(7742, '1289798688', '香港酒店', 'http://www.elong.com/hotel/HongKong_1.html', 0, 0, 0, 4323, 0, 1, 0, NULL, 2, '', ''),
(7743, '1289798688', '香港旅游网', 'http://www.hkjn.com.hk/', 0, 0, 0, 4323, 0, 1, 0, NULL, 3, '', ''),
(7744, '1289798688', '香港迪斯尼乐园', 'http://www.hongkongdisneyland.com/', 0, 0, 0, 4323, 0, 1, 0, NULL, 4, '', ''),
(7745, '1289798688', '香港餐厅', 'http://www.openrice.com/', 0, 0, 0, 4323, 0, 1, 0, NULL, 5, '', ''),
(7746, '1289798688', '亲子王国', 'http://www.baby-kingdom.com/', 0, 0, 0, 4323, 0, 1, 0, NULL, 6, '', ''),
(7747, '1289798688', '搜房香港网', 'http://www.hkproperty.com/', 0, 0, 0, 4323, 0, 1, 0, NULL, 7, '', ''),
(7748, '1289798688', '香港医疗网', 'http://www.hk-doctor.com/', 0, 0, 0, 4323, 0, 1, 0, NULL, 8, '', ''),
(7749, '1289798716', '香港城市大学', 'http://www.cityu.edu.hk/', 0, 0, 0, 4324, 0, 1, 0, NULL, 1, '', ''),
(7750, '1289798716', '香港大学', 'http://www.hku.hk/', 0, 0, 0, 4324, 0, 1, 0, NULL, 2, '', ''),
(7751, '1289798716', '香港中文大学', 'http://www.cuhk.edu.hk/', 0, 0, 0, 4324, 0, 1, 0, NULL, 3, '', ''),
(7752, '1289798716', '香港浸會大學', 'http://www.hkbu.edu.hk/', 0, 0, 0, 4324, 0, 1, 0, NULL, 4, '', ''),
(7753, '1289798716', '香港理工大学', 'http://www.polyu.edu.hk/', 0, 0, 0, 4324, 0, 1, 0, NULL, 5, '', ''),
(7754, '1289798716', '香港科技大学', 'http://www.ust.hk/', 0, 0, 0, 4324, 0, 1, 0, NULL, 6, '', ''),
(7755, '1289798785', '香港特别行政区政府', 'http://www.gov.hk/', 0, 0, 0, 4326, 0, 1, 0, NULL, 1, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(7756, '1289798785', '香港廉政公署', 'http://www.icac.org.hk/', 0, 0, 0, 4326, 0, 1, 0, NULL, 2, '', ''),
(7757, '1289798785', '香港劳工处', 'http://www.jobs.gov.hk/', 0, 0, 0, 4326, 0, 1, 0, NULL, 3, '', ''),
(7758, '1289798785', '香港旅游发展局', 'http://www.discoverhongkong.com/', 0, 0, 0, 4326, 0, 1, 0, NULL, 4, '', ''),
(7759, '1289798836', '澳门特别行政区政府', 'http://www.gov.mo/', 0, 0, 0, 4331, 0, 1, 0, NULL, 1, '', ''),
(7760, '1289798859', '澳门航空', 'http://www.airmacau.com.mo/', 0, 0, 0, 4333, 0, 1, 0, NULL, 1, '', ''),
(7761, '1289798859', '澳门卫星地图', 'http://maps.google.com/maps?f=q&amp;amp;hl=zh-CN&amp;amp;q=macau&amp;amp;ie=UTF8&amp;amp;ll=22.198849,113.544044&amp;amp;spn=0.215519,0.42057&amp;amp;t=h&amp;amp;om=1', 0, 0, 0, 4333, 0, 1, 0, NULL, 2, '', ''),
(7762, '1289798859', '澳门旅游指南网站', 'http://www.youaomen.com/', 0, 0, 0, 4333, 0, 1, 0, NULL, 3, '', ''),
(7763, '1289798859', '澳门美食网', 'http://www.macaucuisine.com/', 0, 0, 0, 4333, 0, 1, 0, NULL, 4, '', ''),
(7764, '1289798859', '澳门房地产联合商会', 'http://www.macaurealty.com/', 0, 0, 0, 4333, 0, 1, 0, NULL, 5, '', ''),
(7765, '1289798859', '皇城医疗', 'http://www.kingtontowngroup.com/', 0, 0, 0, 4333, 0, 1, 0, NULL, 6, '', ''),
(7766, '1289798888', '新华通讯社', 'http://www.xinhuanet.com/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7767, '1289798888', '中国科学院', 'http://www.cas.cn/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7768, '1289798888', '中国社会科学院', 'http://www.cass.net.cn/y_03/y_03.htm/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7769, '1289798888', '中国工程院', 'http://www.cae.cn/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7770, '1289798888', '国务院发展研究中心', 'http://www.drc.gov.cn/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7771, '1289798888', '国家行政学院', 'http://www.nsa.gov.cn/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7772, '1289798888', '中国地震局', 'http://www.cea.gov.cn/cea/jgsz/jgjj/index.asp', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7773, '1289798888', '中国气象局', 'http://www.cma.gov.cn/bmgk/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7774, '1289798888', '中国银行业监督管理委员会', 'http://www.cbrc.gov.cn/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7775, '1289798888', '中国证券监督管理委员会', 'http://www.csrc.gov.cn/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7776, '1289798888', '中国保险监督管理委员会', 'http://www.circ.gov.cn/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7777, '1289798888', '国家电力监管委员会', 'http://www.serc.gov.cn/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7778, '1289798888', '全国社会保障基金理事会', 'http://www.ssf.gov.cn/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7779, '1289798888', '国家自然科学基金委员会', 'http://www.nsfc.gov.cn/', 0, 0, 0, 3080, 0, 1, 1289798888, NULL, 1, '', ''),
(7780, '1289798889', '澳门大学', 'http://www.umac.mo/', 0, 0, 0, 4334, 0, 1, 0, NULL, 1, '', ''),
(7781, '1289798889', '澳门理工学院', 'http://www.ipm.edu.mo/', 0, 0, 0, 4334, 0, 1, 0, NULL, 2, '', ''),
(7782, '1289798889', '澳门科技大学', 'http://www.must.edu.mo/', 0, 0, 0, 4334, 0, 1, 0, NULL, 3, '', ''),
(7783, '1289798889', '亚洲国际公开大学', 'http://www.aiou.edu/', 0, 0, 0, 4334, 0, 1, 0, NULL, 4, '', ''),
(7784, '1289798927', '澳门交友', 'http://www.91yuan.com/HTML/A82B0.htm', 0, 0, 0, 4335, 0, 1, 0, NULL, 1, '', ''),
(7785, '1289798949', '澳门特别行政区政府', 'http://www.gov.mo/', 0, 0, 0, 4336, 0, 1, 0, NULL, 1, '', ''),
(7786, '1289798949', '澳门保安部队', 'http://www.fsm.gov.mo/', 0, 0, 0, 4336, 0, 1, 0, NULL, 2, '', ''),
(7787, '1289798949', '澳门海关', 'http://www.customs.gov.mo/', 0, 0, 0, 4336, 0, 1, 0, NULL, 3, '', ''),
(7788, '1289798949', '澳门艺术博物馆', 'http://www.artmuseum.gov.mo/', 0, 0, 0, 4336, 0, 1, 0, NULL, 4, '', ''),
(7789, '1289799033', '中国台湾网', 'http://www.chinataiwan.org/', 0, 0, 0, 4341, 0, 1, 0, NULL, 1, '', ''),
(7790, '1289799076', 'PChome-Online', 'http://www.pchome.com.tw/', 0, 0, 0, 4342, 0, 1, 0, NULL, 1, '', ''),
(7791, '1289799076', '番薯藤', 'http://www.yam.com/', 0, 0, 0, 4342, 0, 1, 0, NULL, 2, '', ''),
(7792, '1289799076', 'HiNet', 'http://www.hinet.net/', 0, 0, 0, 4342, 0, 1, 0, NULL, 3, '', ''),
(7793, '1289799076', 'TTV台视资讯网', 'http://www.ttv.com.tw/', 0, 0, 0, 4342, 0, 1, 0, NULL, 4, '', ''),
(7794, '1289799076', '新浪台湾站', 'http://www.sina.com.tw/', 0, 0, 0, 4342, 0, 1, 0, NULL, 5, '', ''),
(7795, '1289799076', 'CCTV台湾频道', 'http://www.cctv.com/taiwan/', 0, 0, 0, 4342, 0, 1, 0, NULL, 6, '', ''),
(7796, '1289799076', '中国电视公司', 'http://www.chinatv.com.tw/', 0, 0, 0, 4342, 0, 1, 0, NULL, 7, '', ''),
(7797, '1289799076', '你好台湾', 'http://www.nihaotw.com/', 0, 0, 0, 4342, 0, 1, 0, NULL, 8, '', ''),
(7798, '1289799076', '联合新闻网', 'http://www.udn.com/', 0, 0, 0, 4342, 0, 1, 0, NULL, 9, '', ''),
(7799, '1289799076', 'TVBS', 'http://www.tvbs.com.tw', 0, 0, 0, 4342, 0, 1, 0, NULL, 10, '', ''),
(7800, '1289799076', '中国时报', 'http://www.chinatimes.com.tw/', 0, 0, 0, 4342, 0, 1, 0, NULL, 11, '', ''),
(7801, '1289799076', '东森新闻', 'http://www.nownews.com/', 0, 0, 0, 4342, 0, 1, 0, NULL, 12, '', ''),
(7802, '1289799076', '中央日报', 'http://www.cdnews.com.tw/', 0, 0, 0, 4342, 0, 1, 0, NULL, 13, '', ''),
(7803, '1289799097', '台湾电子地图', 'http://www.map.com.tw/', 0, 0, 0, 4343, 0, 1, 0, NULL, 1, '', ''),
(7804, '1289799097', '台湾气象', 'http://www.cwb.gov.tw', 0, 0, 0, 4343, 0, 1, 0, NULL, 2, '', ''),
(7805, '1289799097', 'google台湾卫星地图', 'http://maps.google.com/?ie=UTF8&amp;amp;ll=23.699865,120.910034&amp;amp;spn=3.409859,4.938354&amp;amp;t=k&amp;amp;om=1', 0, 0, 0, 4343, 0, 1, 0, NULL, 3, '', ''),
(7806, '1289799097', '雄狮旅游网', 'http://www.liontravel.com/', 0, 0, 0, 4343, 0, 1, 0, NULL, 4, '', ''),
(7807, '1289799097', '台湾旅游网', 'http://www.travel-web.com.tw/', 0, 0, 0, 4343, 0, 1, 0, NULL, 5, '', ''),
(7808, '1289799097', '灿星旅游网', 'http://www.startravel.com.tw/', 0, 0, 0, 4343, 0, 1, 0, NULL, 6, '', ''),
(7809, '1289799097', '中华航空公司', 'http://www.china-airlines.com/', 0, 0, 0, 4343, 0, 1, 0, NULL, 7, '', ''),
(7810, '1289799097', '雅虎旅游', 'http://tw.travel.yahoo.com/', 0, 0, 0, 4343, 0, 1, 0, NULL, 8, '', ''),
(7811, '1289799097', '雅虎美食', 'http://tw.lifestyle.yahoo.com/', 0, 0, 0, 4343, 0, 1, 0, NULL, 9, '', ''),
(7812, '1289799097', '雅虎生活', 'http://tw.lifestyle.yahoo.com/', 0, 0, 0, 4343, 0, 1, 0, NULL, 10, '', ''),
(7813, '1289799097', '宝贝家庭亲子网', 'http://www.babyhome.com.tw/', 0, 0, 0, 4343, 0, 1, 0, NULL, 11, '', ''),
(7814, '1289799116', '台北市教育入口网', 'http://www.tp.edu.tw/', 0, 0, 0, 4344, 0, 1, 0, NULL, 1, '', ''),
(7815, '1289799116', '交通大学', 'http://www.nctu.edu.tw/', 0, 0, 0, 4344, 0, 1, 0, NULL, 2, '', ''),
(7816, '1289799116', '台湾大学', 'http://www.ntu.edu.tw/', 0, 0, 0, 4344, 0, 1, 0, NULL, 3, '', ''),
(7817, '1289799116', '中山大学', 'http://www.nsysu.edu.tw/', 0, 0, 0, 4344, 0, 1, 0, NULL, 4, '', ''),
(7818, '1289799116', '清华大学', 'http://www.nthu.edu.tw/', 0, 0, 0, 4344, 0, 1, 0, NULL, 5, '', ''),
(7819, '1289799116', '台湾科技大学', 'http://www.ntust.edu.tw/', 0, 0, 0, 4344, 0, 1, 0, NULL, 6, '', ''),
(7820, '1289799116', '东吴大学', 'http://www.scu.edu.tw/', 0, 0, 0, 4344, 0, 1, 0, NULL, 7, '', ''),
(7821, '1289799116', '中央大学', 'http://www.ncu.edu.tw/', 0, 0, 0, 4344, 0, 1, 0, NULL, 8, '', ''),
(7822, '1289799133', '寻梦圆（聊天）', 'http://ek21.com/', 0, 0, 0, 4345, 0, 1, 0, NULL, 1, '', ''),
(7823, '1289799133', 'PChome-像薄', 'http://photo.pchome.com.tw/', 0, 0, 0, 4345, 0, 1, 0, NULL, 2, '', ''),
(7824, '1289799133', 'xuite', 'http://www.xuite.net/', 0, 0, 0, 4345, 0, 1, 0, NULL, 3, '', ''),
(7825, '1289799133', '摩利网', 'http://www.molibee.com/', 0, 0, 0, 4345, 0, 1, 0, NULL, 4, '', ''),
(7826, '1289799171', '中国台湾网', 'http://www.chinataiwan.org/', 0, 0, 0, 4346, 0, 1, 0, NULL, 1, '', ''),
(7827, '1289799460', '贵州大学', 'http://www.gzu.edu.cn/', 0, 0, 0, 4224, 0, 1, 1289799463, NULL, 1, '', ''),
(7828, '1289799522', '国家信访局', 'http://www.gjxfj.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 1, '', ''),
(7829, '1289799522', '国家粮食局', 'http://www.chinagrain.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 2, '', ''),
(7830, '1289799522', '国家能源局', 'http://nyj.ndrc.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 3, '', ''),
(7831, '1289799522', '国家国防科技工业局', 'http://www.gov.cn/gjjg/2005-05/31/content_2399.htm', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 4, '', ''),
(7832, '1289799522', '国家烟草专卖局', 'http://www.tobacco.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 5, '', ''),
(7833, '1289799522', '国家外国专家局', 'http://www.safea.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 6, '', ''),
(7834, '1289799522', '国家公务员局', 'http://www.scs.gov.cn', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 7, '', ''),
(7835, '1289799522', '国家海洋局', 'http://www.soa.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 8, '', ''),
(7836, '1289799522', '中国民用航空局', 'http://www.caac.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 9, '', ''),
(7837, '1289799522', '国家测绘局', 'http://www.sbsm.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 10, '', ''),
(7838, '1289799522', '国家邮政局', 'http://www.chinapost.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 11, '', ''),
(7839, '1289799522', '国家文物局', 'http://www.sach.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 12, '', ''),
(7840, '1289799522', '国家食品药品监督管理局', 'http://www.sda.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 13, '', ''),
(7841, '1289799522', '国家中医药管理局', 'http://www.satcm.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 14, '', ''),
(7842, '1289799522', '国家外汇管理局', 'http://www.safe.gov.cn/model_safe/whjjs/whjjs_detail.jsp?id=1&ID=160200000000000000', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 15, '', ''),
(7843, '1289799522', '国家煤矿安全监察局', 'http://www.chinasafety.gov.cn/zhuantipindao/meikuanganquan.htm', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 16, '', ''),
(7844, '1289799522', '国家档案局', 'http://www.saac.gov.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 17, '', ''),
(7845, '1289799522', '国家保密局', 'http://www.isstec.org.cn/', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 18, '', ''),
(7846, '1289799522', '密码局', 'http://www.gov.cn/gjjg/2005-05/31/content_2399.htm', 0, 0, 0, 3081, 0, 1, 1289799522, NULL, 19, '', ''),
(7847, '1289799593', '澳门日报', 'http://www.macaodaily.com/', 0, 0, 0, 4332, 0, 1, 0, NULL, 1, '', ''),
(7848, '1289799593', '澳门广播电视公司', 'http://www.tdm.com.mo/', 0, 0, 0, 4332, 0, 1, 0, NULL, 2, '', ''),
(7849, '1289799593', '澳门城市指南', 'http://gb.cityguide.gov.mo/', 0, 0, 0, 4332, 0, 1, 0, NULL, 3, '', ''),
(7850, '1289799593', '澳门华侨报', 'http://www.vakiodaily.com/', 0, 0, 0, 4332, 0, 1, 0, NULL, 4, '', ''),
(7857, '1289802154', '北京劳动保障网', 'http://www.bjld.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 7, '', ''),
(7858, '1289802154', '首都人才热线', 'http://www.sodurc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 8, '', ''),
(7859, '1289802154', '北京朝阳人才网', 'http://www.sunjob.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 9, '', ''),
(7860, '1289802154', '求职 招聘 北京公招网', 'http://www.ggcp.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 10, '', ''),
(7861, '1289802154', '我的工作网', 'http://www.myjob.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 11, '', ''),
(7862, '1289802154', '北京招聘会信息', 'http://www.bjzph.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 12, '', ''),
(7863, '1289802154', '北京毕业生就业信息网', 'http://www.bjbys.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 13, '', ''),
(7864, '1289802154', '北京人才热线', 'http://www.beijingrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 14, '', ''),
(7865, '1289802154', '北京教育人才网', 'http://www.jyrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 15, '', ''),
(7866, '1289802154', '北京西城人才网', 'http://www.xchrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 16, '', ''),
(7867, '1289802154', '北京柏卓人力资源', 'http://www.bchr.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 17, '', ''),
(7868, '1289802154', '北京外企人才在线', 'http://www.fesco.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 18, '', ''),
(7869, '1289802154', '北京毕业生就业中心', 'http://www.bjbys.net.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 19, '', ''),
(7870, '1289802154', '赶集网招聘（北京）', 'http://bj.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 20, '', ''),
(7871, '1289802154', '海淀区人事局', 'http://www.hdrshj.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 21, '', ''),
(7872, '1289802154', '高校毕业就业信息网', 'http://www.bjbys.net.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 22, '', ''),
(7873, '1289802154', '中华英才网上海站', 'http://shanghai.chinahr.com/Default.aspx?jtr=277445543&amp;amp;jtrr=', 0, 0, 0, 1085, 0, 1, 0, NULL, 23, '', ''),
(7874, '1289802154', '上海人才网', 'http://www.001hr.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 24, '', ''),
(7875, '1289802154', '上海人才热线', 'http://www.shanghairc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 25, '', ''),
(7876, '1289802154', '上海招聘热线', 'http://www.shzp.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 26, '', ''),
(7877, '1289802154', '大上海人才热线', 'http://www.dshrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 27, '', ''),
(7878, '1289802154', '赶集网招聘（上海）', 'http://sh.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 28, '', ''),
(7879, '1289802154', '前程无忧-上海站', 'http://www.51job.com/default-area.php?area=0200', 0, 0, 0, 1085, 0, 1, 0, NULL, 29, '', ''),
(7880, '1289802154', '上海招聘会信息', 'http://www.sh-zhaopinhui.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 30, '', ''),
(7881, '1289802154', '上海申才网', 'http://www.sc.sh.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 31, '', ''),
(7882, '1289802154', '上海招聘网', 'http://www.shjob.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 32, '', ''),
(7883, '1289802154', '上海才探人才网', 'http://www.021so.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 33, '', ''),
(7884, '1289802154', '上海人才中介行业协会', 'http://www.shrca.org', 0, 0, 0, 1085, 0, 1, 0, NULL, 34, '', ''),
(7885, '1289802154', '崇明县人才网', 'http://cm.21cnhr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 35, '', ''),
(7886, '1289802154', '高校毕业生就业网', 'http://www.firstjob.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 36, '', ''),
(7887, '1289802154', '普陀人才网', 'http://pt.21cnhr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 37, '', ''),
(7888, '1289802154', '21世纪人才网', 'http://www.21cnhr.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 38, '', ''),
(7889, '1289802154', '上海高校毕业生就业信息', 'http://www.firstjob.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 39, '', ''),
(7890, '1289802154', '中华英才网天津站', 'http://tianjin.chinahr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 40, '', ''),
(7891, '1289802154', '天津人才网', 'http://www.tjzhaopin.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 41, '', ''),
(7892, '1289802154', '北方网北方职场', 'http://job.enorth.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 42, '', ''),
(7893, '1289802154', '中国天津人事信息网', 'http://www.tjpnet.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 43, '', ''),
(7894, '1289802154', '天津劳动保障网', 'http://www.tj.lss.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 44, '', ''),
(7895, '1289802154', '天津人才招聘网', 'http://www.tjrcw.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 45, '', ''),
(7896, '1289802154', '前程无忧-天津', 'http://www.51job.com/default-area.php?area=0500', 0, 0, 0, 1085, 0, 1, 0, NULL, 46, '', ''),
(7897, '1289802154', '津门人才热线', 'http://www.jinrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 47, '', ''),
(7898, '1289802154', '津轻人才网', 'http://www.jqrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 48, '', ''),
(7899, '1289802154', 'TCJOB天津人才网', 'http://www.tcjob.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 49, '', ''),
(7900, '1289802154', '赶集网招聘（天津）', 'http://tj.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 50, '', ''),
(7901, '1289802154', '中华英才网重庆站', 'http://chongqing.chinahr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 51, '', ''),
(7902, '1289802154', '重庆人才网', 'http://www.cqjob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 52, '', ''),
(7903, '1289802154', '联英人才网', 'http://www.hrm.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 53, '', ''),
(7904, '1289802154', '重庆人才大市场', 'http://www.hrm.cq.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 54, '', ''),
(7905, '1289802154', '重庆劳动保障网', 'http://jld.cq.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 55, '', ''),
(7906, '1289802154', '山城人才热线', 'http://www.shanrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 56, '', ''),
(7907, '1289802154', '重庆市人事局', 'http://www.cqpa.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 57, '', ''),
(7908, '1289802154', '赶集网招聘（重庆）', 'http://cq.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 58, '', ''),
(7909, '1289802154', '广东省人事厅', 'http://www.gdrst.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 59, '', ''),
(7910, '1289802154', '广东人才网', 'http://www.gdrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 60, '', ''),
(7911, '1289802154', '广东人才热线', 'http://www.guangdongrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 61, '', ''),
(7912, '1289802154', '汕头招聘网', 'http://www.stzp.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 62, '', ''),
(7913, '1289802154', '中华英才网广州站', 'http://guangzhou.chinahr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 63, '', ''),
(7914, '1289802154', '广州人才网', 'http://www.020job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 64, '', ''),
(7915, '1289802154', '广州人事网', 'http://www.gzpi.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 65, '', ''),
(7916, '1289802154', '前程无忧-深圳', 'http://www.51job.com/default-area.php?area=0400', 0, 0, 0, 1085, 0, 1, 0, NULL, 66, '', ''),
(7917, '1289802154', '前程无忧-广州', 'http://www.51job.com/default-area.php?area=0302', 0, 0, 0, 1085, 0, 1, 0, NULL, 67, '', ''),
(7918, '1289802154', '中华英才-深圳', 'http://shenzhen.chinahr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 68, '', ''),
(7919, '1289802154', '珠三角人才网', 'http://www.dgchr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 69, '', ''),
(7920, '1289802154', '中国广州人事信息网', 'http://www.gzpi.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 70, '', ''),
(7921, '1289802154', '珠三角联合人才网', 'http://www.ujob.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 71, '', ''),
(7922, '1289802154', '赶集网招聘（深圳）', 'http://sz.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 72, '', ''),
(7923, '1289802154', '大洋网求职广场', 'http://jobs.dayoo.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 73, '', ''),
(7924, '1289802154', '八方人才网深圳', 'http://www.job88.com/shenzhen', 0, 0, 0, 1085, 0, 1, 0, NULL, 74, '', ''),
(7925, '1289802154', '赶集网招聘（广州）', 'http://gz.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 75, '', ''),
(7926, '1289802154', '广州招聘网', 'http://www.guangzhoujob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 76, '', ''),
(7927, '1289802154', '汕头招聘网', 'http://www.stzp.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 77, '', ''),
(7928, '1289802154', '江苏人事人才网', 'http://www.jsrsrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 78, '', ''),
(7929, '1289802154', '中华英才网-南京', 'http://nanjing.chinahr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 79, '', ''),
(7930, '1289802154', '南京人才网', 'http://www.njrsrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 80, '', ''),
(7931, '1289802154', '赶集网招聘（南京）', 'http://nj.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 81, '', ''),
(7932, '1289802154', '苏州人才市场', 'http://www.szrc.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 82, '', ''),
(7933, '1289802154', '扬州人才网', 'http://www.yzjob.net.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 83, '', ''),
(7934, '1289802154', '扬子人才网', 'http://www.yzjob.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 84, '', ''),
(7935, '1289802154', '徐州人才网', 'http://www.xzrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 85, '', ''),
(7936, '1289802154', '常熟劳动和社会保障', 'http://www.cslss.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 86, '', ''),
(7937, '1289802154', '张家港人才网', 'http://www.zjgrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 87, '', ''),
(7938, '1289802154', '连云港人才网', 'http://www.lygrc.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 88, '', ''),
(7939, '1289802154', '无锡人才网', 'http://www.wxhrm.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 89, '', ''),
(7940, '1289802154', '无锡新区人才网', 'http://www.nchr.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 90, '', ''),
(7941, '1289802154', '常州人才网', 'http://www.czrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 91, '', ''),
(7942, '1289802154', '南通人才', 'http://www.ntrc.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 92, '', ''),
(7943, '1289802154', '泰州人才网', 'http://www.tzjob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 93, '', ''),
(7944, '1289802154', '盐城人才网', 'http://www.ychr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 94, '', ''),
(7945, '1289802154', '吴江人力资源网', 'http://www.wjhr.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 95, '', ''),
(7946, '1289802154', '吴江市劳动就业管理', 'http://www.lets91.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 96, '', ''),
(7947, '1289802154', '新世纪人才网', 'http://www.nchr.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 97, '', ''),
(7948, '1289802154', '昆山开发区人才网　', 'http://www.ksren.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 98, '', ''),
(7949, '1289802154', '镇江市人才服务中心', 'http://zjrc.hrol.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 99, '', ''),
(7950, '1289802154', '徐州招聘网', 'http://www.xzjob.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 100, '', ''),
(7951, '1289802154', '徐州英才网', 'http://www.xuzhoujob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 101, '', ''),
(7952, '1289802154', '南通人才基地', 'http://www.ntrc.net.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 102, '', ''),
(7953, '1289802154', '赶集网招聘（苏州）', 'http://su.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 103, '', ''),
(7954, '1289802154', '赶集网招聘（无锡）', 'http://wx.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 104, '', ''),
(7955, '1289802154', '山东人才网', 'http://www.sdrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 105, '', ''),
(7956, '1289802154', '山东人才市场', 'http://www.sdrc315.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 106, '', ''),
(7957, '1289802154', '山东人事信息网', 'http://www.sdrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 107, '', ''),
(7958, '1289802154', '51job济南', 'http://www.51job.com/default-area.php?area=1202', 0, 0, 0, 1085, 0, 1, 0, NULL, 108, '', ''),
(7959, '1289802154', '济南人才网', 'http://www.0531job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 109, '', ''),
(7960, '1289802154', '青岛人才网', 'http://www.zgqdrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 110, '', ''),
(7961, '1289802154', '青岛人事政务网', 'http://www.qdpb.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 111, '', ''),
(7962, '1289802154', '齐鲁人才网', 'http://www.qlrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 112, '', ''),
(7963, '1289802154', '德州人才网', 'http://www.dzjob.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 113, '', ''),
(7964, '1289802154', '淄川人才信息网', 'http://www.zbrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 114, '', ''),
(7965, '1289802154', '赶集网招聘（济南）', 'http://jn.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 115, '', ''),
(7966, '1289802154', '山东有才网', 'http://www.51youcai.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 116, '', ''),
(7967, '1289802154', '浙江人才网', 'http://www.zjrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 117, '', ''),
(7968, '1289802154', '中华英才网浙江站', 'http://hangzhou.chinahr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 118, '', ''),
(7969, '1289802154', '浙江人才热线', 'http://www.zhejiangrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 119, '', ''),
(7970, '1289802154', '浙江人事编制网', 'http://www.zjrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 120, '', ''),
(7971, '1289802154', '赶集网招聘（杭州）', 'http://hz.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 121, '', ''),
(7972, '1289802154', '杭州余杭人才网', 'http://www.hzyhrc.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 122, '', ''),
(7973, '1289802154', '杭州人才热线', 'http://www.571job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 123, '', ''),
(7974, '1289802154', '杭州人事局', 'http://www.hzsrsj.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 124, '', ''),
(7975, '1289802154', '前程无忧-杭州', 'http://www.51job.com/default-area.php?area=0802', 0, 0, 0, 1085, 0, 1, 0, NULL, 125, '', ''),
(7976, '1289802154', '温州高新人才网', 'http://www.dmrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 126, '', ''),
(7977, '1289802154', '温州人力资源网', 'http://www.0577hr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 127, '', ''),
(7978, '1289802154', '台州银河人才网', 'http://www.tzyhrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 128, '', ''),
(7979, '1289802154', '台州人力网', 'http://www.tzrl.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 129, '', ''),
(7980, '1289802154', '宁波人才网', 'http://www.nbrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 130, '', ''),
(7981, '1289802154', '赶集网招聘（宁波）', 'http://nb.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 131, '', ''),
(7982, '1289802154', '奉化市劳动力市场', 'http://www.fhclm.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 132, '', ''),
(7983, '1289802154', '萧山人才网', 'http://xshr.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 133, '', ''),
(7984, '1289802154', '余姚人才市场', 'http://www.yyrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 134, '', ''),
(7985, '1289802154', '温州人才市场网', 'http://www.0577rc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 135, '', ''),
(7986, '1289802154', '杭州人才网', 'http://www.571job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 136, '', ''),
(7987, '1289802154', '河南人事厅', 'http://www.hnrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 137, '', ''),
(7988, '1289802154', '河南天基人才网', 'http://www.tjinfo.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 138, '', ''),
(7989, '1289802154', '赶集网招聘（郑州）', 'http://zz.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 139, '', ''),
(7990, '1289802154', '大河人才网', 'http://www.daherc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 140, '', ''),
(7991, '1289802154', '新乡人才网', 'http://www.xxjob.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 141, '', ''),
(7992, '1289802154', '河北人才网', 'http://www.hbrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 142, '', ''),
(7993, '1289802154', '石家庄人才网', 'http://www.sjzrc.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 143, '', ''),
(7994, '1289802154', '赶集网招聘（石家庄）', 'http://sjz.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 144, '', ''),
(7995, '1289802154', '燕赵人才热线', 'http://www.hebeirc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 145, '', ''),
(7996, '1289802154', '唐山人才网', 'http://www.tsrcw.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 146, '', ''),
(7997, '1289802154', '保定市人才市场', 'http://www.bdrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 147, '', ''),
(7998, '1289802154', '邯郸人才网', 'http://job.hdzc.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 148, '', ''),
(7999, '1289802154', '银河人才网', 'http://www.jobinhe.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 149, '', ''),
(8000, '1289802154', '河北搜才网', 'http://www.hbsc.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 150, '', ''),
(8001, '1289802154', '大连人才网', 'http://www.dl-rc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 151, '', ''),
(8002, '1289802154', '大连在线人才网', 'http://www.daliancity.com.cn/job', 0, 0, 0, 1085, 0, 1, 0, NULL, 152, '', ''),
(8003, '1289802154', '大连人才招聘网', 'http://www.dlxp.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 153, '', ''),
(8004, '1289802154', '赶集网招聘（大连）', 'http://dl.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 154, '', ''),
(8005, '1289802154', '前程无忧-大连', 'http://www.51job.com/default-area.php?area=2303', 0, 0, 0, 1085, 0, 1, 0, NULL, 155, '', ''),
(8006, '1289802154', '前程无忧-沈阳', 'http://www.51job.com/default-area.php?area=2302', 0, 0, 0, 1085, 0, 1, 0, NULL, 156, '', ''),
(8007, '1289802154', '赶集网招聘（沈阳）', 'http://sy.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 157, '', ''),
(8008, '1289802154', '沈阳人才网', 'http://www.syrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 158, '', ''),
(8009, '1289802154', '鞍山人才港', 'http://www.23job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 159, '', ''),
(8010, '1289802154', '营口市人才网', 'http://www.ykrc.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 160, '', ''),
(8011, '1289802154', '葫芦岛人才网', 'http://www.hldjob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 161, '', ''),
(8012, '1289802154', '四川人事信息网', 'http://www.scrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 162, '', ''),
(8013, '1289802154', '四川成都人才网', 'http://www.028zhaopin.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 163, '', ''),
(8014, '1289802154', '中华英才网四川站', 'http://chinahrafaad.allyes.com/main/adfclick?db=chinahrafaad&amp;amp;bid=42532,21440,140&amp;amp;cid=17237,92,1&amp;amp;sid=43018&amp;amp;show=ignore&amp;amp;url=http://chengdu.chinahr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 164, '', ''),
(8015, '1289802154', '中国成都人才市场', 'http://www.rc114.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 165, '', ''),
(8016, '1289802154', '前程无忧-成都', 'http://www.51job.com/default-area.php?area=0902', 0, 0, 0, 1085, 0, 1, 0, NULL, 166, '', ''),
(8017, '1289802154', '赶集网招聘（成都）', 'http://cd.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 167, '', ''),
(8018, '1289802154', '四川省人才市场', 'http://www.scrc168.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 168, '', ''),
(8019, '1289802154', '南充人才网', 'http://www.ncrc.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 169, '', ''),
(8020, '1289802154', '天府人才网', 'http://www.job20.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 170, '', ''),
(8021, '1289802154', '眉州人才市场', 'http://www.msdprc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 171, '', ''),
(8022, '1289802154', '诚信人才网', 'http://www.cxrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 172, '', ''),
(8023, '1289802154', '达州人才网', 'http://www.dzwork.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 173, '', ''),
(8024, '1289802154', '湖北人才热线', 'http://www.hbjob.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 174, '', ''),
(8025, '1289802154', '湖北人事信息网', 'http://www.hbrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 175, '', ''),
(8026, '1289802154', '湖北人才网', 'http://www.jobhb.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 176, '', ''),
(8027, '1289802154', '中国武汉人才市场', 'http://www.job98.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 177, '', ''),
(8028, '1289802154', '中华英才-武汉站', 'http://wuhan.chinahr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 178, '', ''),
(8029, '1289802154', '前程无忧-武汉站', 'http://www.51job.com/default-area.php?area=1802', 0, 0, 0, 1085, 0, 1, 0, NULL, 179, '', ''),
(8030, '1289802154', '赶集网招聘（武汉）', 'http://wh.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 180, '', ''),
(8031, '1289802154', '武汉人才网', 'http://www.3job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 181, '', ''),
(8032, '1289802154', '中国海峡人才网', 'http://www.hxrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 182, '', ''),
(8033, '1289802154', '中华英才网福建站', 'http://fujian.chinahr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 183, '', ''),
(8034, '1289802154', '福建人事人才网', 'http://www.fjrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 184, '', ''),
(8035, '1289802154', '漳州人事人才网', 'http://www.zzhr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 185, '', ''),
(8036, '1289802154', '厦门人才网', 'http://www.xmrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 186, '', ''),
(8037, '1289802154', '福州人才网', 'http://www.0591job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 187, '', ''),
(8038, '1289802154', '大泉州人才网', 'http://www.qzrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 188, '', ''),
(8039, '1289802154', '龙岩好工作人才网', 'http://www.lyrc.cc', 0, 0, 0, 1085, 0, 1, 0, NULL, 189, '', ''),
(8040, '1289802154', '补天大学生兼职', 'http://www.fillsky.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 190, '', ''),
(8041, '1289802154', '漳州人才网', 'http://www.rzzz.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 191, '', ''),
(8042, '1289802154', '漳州招聘网', 'http://www.2238202.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 192, '', ''),
(8043, '1289802154', '赶集网招聘（福州）', 'http://fz.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 193, '', ''),
(8044, '1289802154', '赶集网招聘（厦门）', 'http://xm.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 194, '', ''),
(8045, '1289802154', '福建精才网', 'http://www.059rc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 195, '', ''),
(8046, '1289802154', '中国湖南人才网', 'http://www.hnrcsc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 196, '', ''),
(8047, '1289802154', '湖南毕业生就业信息', 'http://www.hunbys.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 197, '', ''),
(8048, '1289802154', '湖南领导人才网', 'http://www.hnleader.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 198, '', ''),
(8049, '1289802154', '长沙人才网', 'http://www.cshr.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 199, '', ''),
(8050, '1289802154', '前程无忧-长沙', 'http://www.51job.com/default-area.php?area=1902', 0, 0, 0, 1085, 0, 1, 0, NULL, 200, '', ''),
(8051, '1289802154', '长沙高新人才网', 'http://www.15job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 201, '', ''),
(8052, '1289802154', '赶集网招聘（长沙）', 'http://cs.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 202, '', ''),
(8053, '1289802154', '长沙人才热线', 'http://www.0731job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 203, '', ''),
(8054, '1289802154', '芙蓉人才网', 'http://www.frrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 204, '', ''),
(8055, '1289802154', '湖南招聘网', 'http://www.hnz.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 205, '', ''),
(8056, '1289802154', '湖南人才', 'http://www.hnrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 206, '', ''),
(8057, '1289802154', '黑龙江就业网', 'http://www.hljjob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 207, '', ''),
(8058, '1289802154', '黑人事编制信息网', 'http://www.hljrstbb.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 208, '', ''),
(8059, '1289802154', '黑龙江人才网', 'http://www.rc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 209, '', ''),
(8060, '1289802154', '前程无忧-哈尔滨', 'http://www.51job.com/default-area.php?area=2202', 0, 0, 0, 1085, 0, 1, 0, NULL, 210, '', ''),
(8061, '1289802154', '哈尔滨人才网', 'http://www.hrbrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 211, '', ''),
(8062, '1289802154', '哈尔滨人事编制信息网', 'http://www.hrbrsj.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 212, '', ''),
(8063, '1289802154', '赶集网招聘（哈尔滨）', 'http://hrb.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 213, '', ''),
(8064, '1289802154', '齐齐哈尔人才网', 'http://www.qqhr-rc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 214, '', ''),
(8065, '1289802154', '黑龙江英才网', 'http://www.joblj.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 215, '', ''),
(8066, '1289802154', '哈尔滨启航人才信息港', 'http://www.913hr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 216, '', ''),
(8067, '1289802154', '安徽人才网', 'http://www.ahhr.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 217, '', ''),
(8068, '1289802154', '安徽招聘网', 'http://www.ahzp.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 218, '', ''),
(8069, '1289802154', '前程无忧-合肥', 'http://www.51job.com/default-area.php?area=1502', 0, 0, 0, 1085, 0, 1, 0, NULL, 219, '', ''),
(8070, '1289802154', '芜湖人事人才网', 'http://www.whrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 220, '', ''),
(8071, '1289802154', '马鞍山人才网', 'http://www.masrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 221, '', ''),
(8072, '1289802154', '安庆轻松招聘网', 'http://www.qszpw.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 222, '', ''),
(8073, '1289802154', '新安人才网', 'http://www.goodjobs.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 223, '', ''),
(8074, '1289802154', '六安人才网', 'http://www.larc.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 224, '', ''),
(8075, '1289802154', '赶集网招聘（合肥）', 'http://hf.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 225, '', ''),
(8076, '1289802154', '江西人才在线', 'http://www.jiangxirc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 226, '', ''),
(8077, '1289802154', '江西人才人事网', 'http://www.jxrencai.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 227, '', ''),
(8078, '1289802154', '江西人事厅', 'http://www.jxrenshi.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 228, '', ''),
(8079, '1289802154', '赣州人才网', 'http://www.gz91.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 229, '', ''),
(8080, '1289802154', '赶集网招聘（南昌）', 'http://nc.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 230, '', ''),
(8081, '1289802154', '赣州人才热线', 'http://www.gzrcrx.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 231, '', ''),
(8082, '1289802154', '一起工作网', 'http://www.17job.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 232, '', ''),
(8083, '1289802154', '广西人才网', 'http://www.gxrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 233, '', ''),
(8084, '1289802154', '广西招聘求职网', 'http://www.job114.net.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 234, '', ''),
(8085, '1289802154', '广西人才信息网', 'http://www.gxrc.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 235, '', ''),
(8086, '1289802154', '中华英才', 'http://searchjob.chinahr.com/SearchResult.aspx?occParentIDList=255&amp;amp;indIDList=255&amp;amp;myLocIDList=17000&amp;amp;prj=bdkeyword&amp;amp;jtr=40041453&amp;amp;jtrr=', 0, 0, 0, 1085, 0, 1, 0, NULL, 236, '', ''),
(8087, '1289802154', '广西求职招聘网站大全', 'http://www.job22.com/url/guangxijob.htm', 0, 0, 0, 1085, 0, 1, 0, NULL, 237, '', ''),
(8088, '1289802154', '壮族自治区人事厅', 'http://www.gxrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 238, '', ''),
(8089, '1289802154', '桂林人才网', 'http://www.vvjob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 239, '', ''),
(8090, '1289802154', '桂冠人才网', 'http://www.guiguanrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 240, '', ''),
(8091, '1289802154', '北海人才网', 'http://www.bhrc.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 241, '', ''),
(8092, '1289802154', '钦州人才网', 'http://www.gxqzrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 242, '', ''),
(8093, '1289802154', '株洲人才网', 'http://www.hnzzrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 243, '', ''),
(8094, '1289802154', '南宁人才网', 'http://www.nnrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 244, '', ''),
(8095, '1289802154', '柳州人才网', 'http://www.lzrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 245, '', ''),
(8096, '1289802154', '赶集网招聘（南宁）', 'http://nn.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 246, '', ''),
(8097, '1289802154', '中华英才网', 'http://searchjob.chinahr.com/SearchResult.aspx?occParentIDList=255&amp;amp;indIDList=255&amp;amp;myLocIDList=5000&amp;amp;prj=bdkeyword&amp;amp;jtr=823464246&amp;amp;jtrr=', 0, 0, 0, 1085, 0, 1, 0, NULL, 247, '', ''),
(8098, '1289802154', '吉林市人才市场', 'http://www.jlsrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 248, '', ''),
(8099, '1289802154', '吉林省艺术人才网', 'http://www.jlysrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 249, '', ''),
(8100, '1289802154', '吉林人才信息网', 'http://www.jlline.com/rc', 0, 0, 0, 1085, 0, 1, 0, NULL, 250, '', ''),
(8101, '1289802154', '中国长春人才网', 'http://www.changchunjob.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 251, '', ''),
(8102, '1289802154', '赶集网招聘（长春）', 'http://cc.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 252, '', ''),
(8103, '1289802154', '长春人才网', 'http://www.ccrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 253, '', ''),
(8104, '1289802154', '人才在线', 'http://www.ljob.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 254, '', ''),
(8105, '1289802154', '长春经开人才网', 'http://www.cctalent.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 255, '', ''),
(8106, '1289802154', '长春人才市场', 'http://www.ccrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 256, '', ''),
(8107, '1289802154', '通化人才市场', 'http://thrc.th163.jl.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 257, '', ''),
(8108, '1289802154', '云南人事人才信息网', 'http://www.ynrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 258, '', ''),
(8109, '1289802154', '云南招聘网', 'http://job.km169.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 259, '', ''),
(8110, '1289802154', '云南人才网', 'http://www.ynhr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 260, '', ''),
(8111, '1289802154', '云南优聘网', 'http://www.jobyn.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 261, '', ''),
(8112, '1289802154', '云南信息港招聘', 'http://work.yninfo.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 262, '', ''),
(8113, '1289802154', '云南企业人才市场', 'http://www.360ynjob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 263, '', ''),
(8114, '1289802154', '玉溪市人事人才网', 'http://www.yxrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 264, '', ''),
(8115, '1289802154', '玉溪人才招聘网', 'http://www.yxzp.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 265, '', ''),
(8116, '1289802154', '昆明人才网', 'http://www.100job.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 266, '', ''),
(8117, '1289802154', '昆明热线－求职', 'http://job.km169.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 267, '', ''),
(8118, '1289802154', '云南楚雄良木人才网', 'http://www.cxlm.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 268, '', ''),
(8119, '1289802154', '赶集网招聘（昆明）', 'http://km.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 269, '', ''),
(8120, '1289802154', '西部工作网', 'http://work.yninfo.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 270, '', ''),
(8121, '1289802154', '陕西人才网', 'http://www.sxrcw.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 271, '', ''),
(8122, '1289802154', '陕西培训就业信息网', 'http://www.001lt.com/ty/html/238228.htm', 0, 0, 0, 1085, 0, 1, 0, NULL, 272, '', ''),
(8123, '1289802154', '中国西安人才网', 'http://www.xajob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 273, '', ''),
(8124, '1289802154', '前程无忧-西安站', 'http://www.51job.com/default-area.php?area=2002', 0, 0, 0, 1085, 0, 1, 0, NULL, 274, '', ''),
(8125, '1289802154', '赶集网招聘（西安）', 'http://xa.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 275, '', ''),
(8126, '1289802154', '西宁人才网', 'http://www.xnrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 276, '', ''),
(8127, '1289802154', '关中人才网', 'http://www.guanzhongrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 277, '', ''),
(8128, '1289802154', '陕西汉中人才网|', 'http://www.0916rc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 278, '', ''),
(8129, '1289802154', '山西人才市场', 'http://www.sxjobs.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 279, '', ''),
(8130, '1289802154', '太原招聘会信息', 'http://www.tyzhaopin.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 280, '', ''),
(8131, '1289802154', '太原职业介绍服务中心', 'http://www.tylm.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 281, '', ''),
(8132, '1289802154', '赶集网招聘（太原）', 'http://ty.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 282, '', ''),
(8133, '1289802154', '太原高新人才网', 'http://www.ctpjob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 283, '', ''),
(8134, '1289802154', '阳泉人事人才网', 'http://www.yqrsj.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 284, '', ''),
(8135, '1289802154', '大同人才网', 'http://www.dtrcsc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 285, '', ''),
(8136, '1289802154', '太原人才网', 'http://www.tywork.cc', 0, 0, 0, 1085, 0, 1, 0, NULL, 286, '', ''),
(8137, '1289802154', '内蒙古人才网', 'http://www.nmrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 287, '', ''),
(8138, '1289802154', '内蒙古人事人才网', 'http://www.nmgrst.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 288, '', ''),
(8139, '1289802154', '内蒙古人才交流中心', 'http://nm.rc365.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 289, '', ''),
(8140, '1289802154', '中华英才网', 'http://searchjob.chinahr.com/SearchResult.aspx?occParentIDList=255&amp;amp;indIDList=255&amp;amp;myLocIDList=3000&amp;amp;prj=bdkeyword&amp;amp;jtr=956657646&amp;amp;jtrr=', 0, 0, 0, 1085, 0, 1, 0, NULL, 290, '', ''),
(8141, '1289802154', '鄂尔多斯人事人才网', 'http://www.erdsrsrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 291, '', ''),
(8142, '1289802154', '赶集网招聘（内蒙古）', 'http://nmg.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 292, '', ''),
(8143, '1289802154', '呼和浩特人才', 'http://www.hhhtrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 293, '', ''),
(8144, '1289802154', '内蒙古人才热线', 'http://www.nmgrc.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 294, '', ''),
(8145, '1289802154', '内蒙古人百纳才网', 'http://www.job0471.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 295, '', ''),
(8146, '1289802154', '内蒙古立人招聘', 'http://www.nmlr.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 296, '', ''),
(8147, '1289802154', '高校毕业生就业信息', 'http://www.nmbys.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 297, '', ''),
(8148, '1289802154', '内蒙古包头人才网', 'http://www.0472rc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 298, '', ''),
(8149, '1289802154', '赶集网招聘（呼和浩特）', 'http://nmg.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 299, '', ''),
(8150, '1289802154', '新疆人才网', 'http://www.xjrcw.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 300, '', ''),
(8151, '1289802154', '新疆人才热线', 'http://www.78hr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 301, '', ''),
(8152, '1289802154', '中华英才网', 'http://searchjob.chinahr.com/SearchResult.aspx?occParentIDList=255&amp;amp;indIDList=255&amp;amp;myLocIDList=27000&amp;amp;prj=bdkeyword&amp;amp;jtr=334721114&amp;amp;jtrr=', 0, 0, 0, 1085, 0, 1, 0, NULL, 302, '', ''),
(8153, '1289802154', '新疆国际人才交流协会', 'http://xinjiang.caiep.org', 0, 0, 0, 1085, 0, 1, 0, NULL, 303, '', ''),
(8154, '1289802154', '新疆人才在线', 'http://xj.185job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 304, '', ''),
(8155, '1289802154', '新疆自治区人才网', 'http://www.xj-rc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 305, '', ''),
(8156, '1289802154', '赶集网招聘（新疆）', 'http://xj.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 306, '', ''),
(8157, '1289802154', '新疆人才在线', 'http://www.xjrce.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 307, '', ''),
(8158, '1289802154', '赶集网招聘（乌鲁木齐）', 'http://xj.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 308, '', ''),
(8159, '1289802154', '贵州人事人才网', 'http://www.gzrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 309, '', ''),
(8160, '1289802154', '贵州人才信息网', 'http://www.gzrc.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 310, '', ''),
(8161, '1289802154', '贵州省人才网', 'http://www.gz-rcw.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 311, '', ''),
(8162, '1289802154', '贵阳市人事局', 'http://www.gyhr.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 312, '', ''),
(8163, '1289802154', '贵黔人才网', 'http://www.guiqianrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 313, '', ''),
(8164, '1289802154', '中国贵阳人才网', 'http://www.gyrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 314, '', ''),
(8165, '1289802154', '赶集网招聘（贵阳）', 'http://gy.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 315, '', ''),
(8166, '1289802154', '贵州每日人才网', 'http://gz.rc365.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 316, '', ''),
(8167, '1289802154', '遵义人事人才网', 'http://www.zyrc.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 317, '', ''),
(8168, '1289802154', '贵州人才网门户', 'http://ylrc.gz163.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 318, '', ''),
(8169, '1289802154', '贵州人才猎头网', 'http://www.gzrc.gov.cn/upload/gz/news/html/Manager_2008-10-16429025.html', 0, 0, 0, 1085, 0, 1, 0, NULL, 319, '', ''),
(8170, '1289802154', '甘肃人才在线', 'http://www.gsjob.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 320, '', ''),
(8171, '1289802154', '甘肃人事编制信息网', 'http://www.rst.gansu.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 321, '', ''),
(8172, '1289802154', '酒泉人事人才网', 'http://www.jqrc.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 322, '', ''),
(8173, '1289802154', '赶集网招聘（兰州）', 'http://lz.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 323, '', ''),
(8174, '1289802154', '西北人才网', 'http://www.xbrc.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 324, '', ''),
(8175, '1289802154', '兰州易聘网', 'http://www.ezjob.cc', 0, 0, 0, 1085, 0, 1, 0, NULL, 325, '', ''),
(8176, '1289802154', '海南人才在线', 'http://job.hainan.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 326, '', ''),
(8177, '1289802154', '海南人才热线', 'http://www.0898job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 327, '', ''),
(8178, '1289802154', '海南人力资源网', 'http://www.hnjy.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 328, '', ''),
(8179, '1289802154', '海南人才网', 'http://www.hnhrd.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 329, '', ''),
(8180, '1289802154', '海口人才网', 'http://www.haijob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 330, '', ''),
(8181, '1289802154', '赶集网招聘（海口）', 'http://hn.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 331, '', ''),
(8182, '1289802154', '三亚人才网', 'http://www.sanyajob.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 332, '', ''),
(8183, '1289802154', '海南英才网', 'http://www.hainanhr.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 333, '', ''),
(8184, '1289802154', '南海人才频道', 'http://job.hinews.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 334, '', ''),
(8185, '1289802154', '青海人才市场', 'http://www.qhrcsc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 335, '', ''),
(8186, '1289802154', '青海省人事厅', 'http://www.qhrs.gov.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 336, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(8187, '1289802154', '西宁人才网', 'http://www.xnrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 337, '', ''),
(8188, '1289802154', '赶集网招聘（西宁）', 'http://xn.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 338, '', ''),
(8189, '1289802154', '青海省人才网', 'http://www.qh-rc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 339, '', ''),
(8190, '1289802154', '青海猎头网', 'http://lietouhaidongdi.rc365.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 340, '', ''),
(8191, '1289802154', '青海人才网', 'http://www.qhrc.com.cn/qh', 0, 0, 0, 1085, 0, 1, 0, NULL, 341, '', ''),
(8192, '1289802154', '青海前程大吉网', 'http://qh.jobdj.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 342, '', ''),
(8193, '1289802154', '青海人才热线', 'http://www.qhrcrx.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 343, '', ''),
(8194, '1289802154', '宁夏人才', 'http://www.nxrc.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 344, '', ''),
(8195, '1289802154', '宁夏人才在线', 'http://nx.185job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 345, '', ''),
(8196, '1289802154', '宁夏英才网', 'http://www.0951job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 346, '', ''),
(8197, '1289802154', '宁夏人力网', 'http://www.nxrl.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 347, '', ''),
(8198, '1289802154', '宁夏前程大吉招聘网', 'http://nx.jobdj.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 348, '', ''),
(8199, '1289802154', '银川人事信息网', 'http://www.zgycrs.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 349, '', ''),
(8200, '1289802154', '赶集网招聘（银川）', 'http://yc.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 350, '', ''),
(8201, '1289802154', '石嘴山人事人才网', 'http://www.szsrsrc.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 351, '', ''),
(8202, '1289802154', '石嘴山劳动就业服务局', 'http://www.nxsjy.com.cn', 0, 0, 0, 1085, 0, 1, 0, NULL, 352, '', ''),
(8203, '1289802154', '西藏人才在线', 'http://xz.185job.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 353, '', ''),
(8204, '1289802154', '赶集网招聘（拉萨）', 'http://xz.ganji.com/zhaopin', 0, 0, 0, 1085, 0, 1, 0, NULL, 354, '', ''),
(8205, '1289802154', '香港人才网', 'http://www.hkjob.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 355, '', ''),
(8206, '1289802154', '香港劳工处', 'http://www.jobs.gov.hk', 0, 0, 0, 1085, 0, 1, 0, NULL, 356, '', ''),
(8207, '1289802154', '招职', 'http://www.jiujik.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 357, '', ''),
(8208, '1289802154', '1111人力银行', 'http://www.1111.com.tw', 0, 0, 0, 1085, 0, 1, 0, NULL, 358, '', ''),
(8209, '1289802154', '104人力银行', 'http://www.104.com.tw', 0, 0, 0, 1085, 0, 1, 0, NULL, 359, '', ''),
(8210, '1289802154', 'CareerDB.Com', 'http://www.careerdb.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 360, '', ''),
(8211, '1289802154', '泛亚人力銀行', 'http://www.9999.com.tw', 0, 0, 0, 1085, 0, 1, 0, NULL, 361, '', ''),
(8212, '1289802154', '招职 (SCMP)', 'http://www.jiujik.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 362, '', ''),
(8213, '1289802154', '青云路', 'http://ecjobs.com.hk', 0, 0, 0, 1085, 0, 1, 0, NULL, 363, '', ''),
(8214, '1289802154', 'Career Times', 'http://www.careertimes.com.hk', 0, 0, 0, 1085, 0, 1, 0, NULL, 364, '', ''),
(8215, '1289802154', 'Monster', 'http://www.monster.com.hk', 0, 0, 0, 1085, 0, 1, 0, NULL, 365, '', ''),
(8216, '1289802154', '城市網絡招聘站', 'http://www.hkwm.com/job.htm', 0, 0, 0, 1085, 0, 1, 0, NULL, 366, '', ''),
(8217, '1289802154', '求职动力', 'http://www.jobspower.com', 0, 0, 0, 1085, 0, 1, 0, NULL, 367, '', ''),
(8218, '1289802154', 'Job8.net', 'http://www.job8.net', 0, 0, 0, 1085, 0, 1, 0, NULL, 368, '', ''),
(8226, '1290230924', '杭州天气预报', 'http://www.weather.com.cn/html/weather/101210101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 4, '', ''),
(8227, '1290230924', '福州天气预报', 'http://www.weather.com.cn/html/weather/101230101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 5, '', ''),
(8228, '1290230924', '南宁天气预报', 'http://www.weather.com.cn/html/weather/101300101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 6, '', ''),
(8229, '1290230924', '昆明天气预报', 'http://www.weather.com.cn/html/weather/101290101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 7, '', ''),
(8230, '1290230924', '海口天气预报', 'http://www.weather.com.cn/html/weather/101310101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 8, '', ''),
(8231, '1290230924', '澳门天气预报', 'http://www.weather.com.cn/html/weather/101330101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 9, '', ''),
(8232, '1290230924', '香港天气预报', 'http://www.weather.com.cn/html/weather/101320101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 10, '', ''),
(8233, '1290230924', '台北天气预报', 'http://www.weather.com.cn/html/weather/101340101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 11, '', ''),
(8234, '1290230924', '西宁天气预报', 'http://www.weather.com.cn/html/weather/101150101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 12, '', ''),
(8235, '1290230924', '兰州天气预报', 'http://www.weather.com.cn/html/weather/101160101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 13, '', ''),
(8236, '1290230924', '西安天气预报', 'http://www.weather.com.cn/html/weather/101110101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 14, '', ''),
(8237, '1290230924', '武汉天气预报', 'http://www.weather.com.cn/html/weather/101200101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 15, '', ''),
(8238, '1290230924', '郑州天气预报', 'http://www.weather.com.cn/html/weather/101180101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 16, '', ''),
(8239, '1290230924', '济南天气预报', 'http://www.weather.com.cn/html/weather/101120101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 17, '', ''),
(8240, '1290230924', '南京天气预报', 'http://www.weather.com.cn/html/weather/101190101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 18, '', ''),
(8241, '1290230924', '合肥天气预报', 'http://www.weather.com.cn/html/weather/101220101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 19, '', ''),
(8242, '1290230924', '重庆天气预报', 'http://www.weather.com.cn/html/weather/101040100.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 20, '', ''),
(8243, '1290230924', '成都天气预报', 'http://www.weather.com.cn/html/weather/101270101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 21, '', ''),
(8244, '1290230924', '拉萨天气预报', 'http://www.weather.com.cn/html/weather/101140101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 22, '', ''),
(8245, '1290230924', '贵阳天气预报', 'http://www.weather.com.cn/html/weather/101260101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 23, '', ''),
(8246, '1290230924', '长沙天气预报', 'http://www.weather.com.cn/html/weather/101250101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 24, '', ''),
(8247, '1290230924', '南昌天气预报', 'http://www.weather.com.cn/html/weather/101240101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 25, '', ''),
(8248, '1290230924', '天津天气预报', 'http://www.weather.com.cn/html/weather/101030100.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 26, '', ''),
(8249, '1290230924', '石家庄天气预报', 'http://www.weather.com.cn/html/weather/101090101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 27, '', ''),
(8250, '1290230924', '呼和浩特天气预报', 'http://www.weather.com.cn/html/weather/101080101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 28, '', ''),
(8251, '1290230924', '太原天气预报', 'http://www.weather.com.cn/html/weather/101100101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 29, '', ''),
(8252, '1290230924', '银川天气预报', 'http://www.weather.com.cn/html/weather/101170101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 30, '', ''),
(8253, '1290230924', '乌鲁木齐天气预报', 'http://www.weather.com.cn/html/weather/101130101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 31, '', ''),
(8254, '1290230924', '哈尔滨天气预报', 'http://www.weather.com.cn/html/weather/101050101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 32, '', ''),
(8255, '1290230924', '长春天气预报', 'http://www.weather.com.cn/html/weather/101060101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 33, '', ''),
(8256, '1290230924', '沈阳天气预报', 'http://www.weather.com.cn/html/weather/101070101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 34, '', ''),
(8257, '1290230924', '哈尔滨天气预报', 'http://www.weather.com.cn/html/weather/101050101.shtml', 0, 0, 0, 4440, 0, 1, 0, NULL, 35, '', ''),
(8258, '1290230943', '亚洲各主要城市', 'http://www.weather.com.cn/html/continent/asia.shtml', 0, 0, 0, 4441, 0, 1, 0, NULL, 1, '', ''),
(8259, '1290230943', '欧洲各主要城市', 'http://www.weather.com.cn/html/continent/europe.shtml', 0, 0, 0, 4441, 0, 1, 0, NULL, 2, '', ''),
(8260, '1290230943', '北美洲各主要城市', 'http://www.weather.com.cn/html/continent/northamerica.shtml', 0, 0, 0, 4441, 0, 1, 0, NULL, 3, '', ''),
(8261, '1290230943', '南美洲各主要城市', 'http://www.weather.com.cn/html/continent/southamerica.shtml', 0, 0, 0, 4441, 0, 1, 0, NULL, 4, '', ''),
(8262, '1290230943', '大洋洲各主要城市', 'http://www.weather.com.cn/html/continent/oceania.shtml', 0, 0, 0, 4441, 0, 1, 0, NULL, 5, '', ''),
(8263, '1290230943', '非洲各主要城市', 'http://www.weather.com.cn/html/continent/africa.shtml', 0, 0, 0, 4441, 0, 1, 0, NULL, 6, '', ''),
(8264, '1290231194', '山东彩票', 'http://www.sdcp.com.cn', 0, 0, 0, 4442, 0, 1, 0, NULL, 1, '', ''),
(8265, '1290231194', '北京福彩网', 'http://www.bwlc.net', 0, 0, 0, 4442, 0, 1, 0, NULL, 2, '', ''),
(8266, '1290231194', '广东福彩', 'http://www.gdfc.org.cn', 0, 0, 0, 4442, 0, 1, 0, NULL, 3, '', ''),
(8267, '1290231194', '陕西风采网', 'http://www.sxfc.gov.cn', 0, 0, 0, 4442, 0, 1, 0, NULL, 4, '', ''),
(8268, '1290231194', '福建风采', 'http://www.cwl-fj.com', 0, 0, 0, 4442, 0, 1, 0, NULL, 5, '', ''),
(8269, '1290231194', '黑龙江福彩网', 'http://www.lottost.cn/', 0, 0, 0, 4442, 0, 1, 0, NULL, 6, '', ''),
(8270, '1290231194', '吉林福利彩票', 'http://www.fulicaipiao.cn/jilin/index.html', 0, 0, 0, 4442, 0, 1, 0, NULL, 7, '', ''),
(8271, '1290231194', '内蒙古福彩网', 'http://www.nmlottery.com.cn/', 0, 0, 0, 4442, 0, 1, 0, NULL, 8, '', ''),
(8272, '1290231194', '山西福彩网', 'http://www.sxfc.org.cn/', 0, 0, 0, 4442, 0, 1, 0, NULL, 9, '', ''),
(8273, '1290231194', '宁夏福彩网', 'http://www.nxflcp.com/', 0, 0, 0, 4442, 0, 1, 0, NULL, 10, '', ''),
(8274, '1290231194', '陕西风采网', 'http://www.sxfc.gov.cn/', 0, 0, 0, 4442, 0, 1, 0, NULL, 11, '', ''),
(8275, '1290231194', '河南福彩网', 'http://www.henanfucai.com/', 0, 0, 0, 4442, 0, 1, 0, NULL, 12, '', ''),
(8276, '1290231194', '江苏福彩网', 'http://www.jslottery.com/', 0, 0, 0, 4442, 0, 1, 0, NULL, 13, '', ''),
(8277, '1290231194', '安徽福彩网', 'http://www.ahfc.gov.cn/', 0, 0, 0, 4442, 0, 1, 0, NULL, 14, '', ''),
(8278, '1290231194', '上海福彩网', 'http://www.swlc.sh.cn/', 0, 0, 0, 4442, 0, 1, 0, NULL, 15, '', ''),
(8279, '1290231194', '浙江福彩网', 'http://fc.zjol.com.cn/', 0, 0, 0, 4442, 0, 1, 0, NULL, 16, '', ''),
(8280, '1290231194', '江西福彩网', 'http://jxfc.online.jx.cn/', 0, 0, 0, 4442, 0, 1, 0, NULL, 17, '', ''),
(8281, '1290231194', '湖北福彩网', 'http://hbfc.cnhubei.com/', 0, 0, 0, 4442, 0, 1, 0, NULL, 18, '', ''),
(8282, '1290231194', '湖南福彩网', 'http://www.hnflcp.com/', 0, 0, 0, 4442, 0, 1, 0, NULL, 19, '', ''),
(8283, '1290231194', '重庆彩票网', 'http://www.cqcp.net/', 0, 0, 0, 4442, 0, 1, 0, NULL, 20, '', ''),
(8284, '1290231194', '四川福彩网', 'http://www.scflcp.com/', 0, 0, 0, 4442, 0, 1, 0, NULL, 21, '', ''),
(8285, '1290231194', '青海福彩网', 'http://www.qhfcw.com/', 0, 0, 0, 4442, 0, 1, 0, NULL, 22, '', ''),
(8286, '1290231194', '甘肃福彩网', 'http://www.gsflcp.com/', 0, 0, 0, 4442, 0, 1, 0, NULL, 23, '', ''),
(8287, '1290231194', '辽宁福彩网', 'http://www.lnlotto.com/', 0, 0, 0, 4442, 0, 1, 0, NULL, 24, '', ''),
(8288, '1290231194', '贵州福彩网', 'http://www.gzfucai.com/', 0, 0, 0, 4442, 0, 1, 0, NULL, 25, '', ''),
(8289, '1290231194', '海南福彩网', 'http://www.hnfc.net/', 0, 0, 0, 4442, 0, 1, 0, NULL, 26, '', ''),
(8290, '1290231215', '河北体彩网', 'http://www.hbtcw.com', 0, 0, 0, 4443, 0, 1, 0, NULL, 1, '', ''),
(8291, '1290231215', '黑龙江体彩网', 'http://www.hljtcp.com', 0, 0, 0, 4443, 0, 1, 0, NULL, 2, '', ''),
(8292, '1290231215', '上海体彩网', 'http://www.shlottery.gov.cn/', 0, 0, 0, 4443, 0, 1, 0, NULL, 3, '', ''),
(8293, '1290231215', '辽宁体彩网', 'http://www.lntycp.com/', 0, 0, 0, 4443, 0, 1, 0, NULL, 4, '', ''),
(8294, '1290231215', '吉林体彩网', 'http://jltcw.net:8000/jitcw/', 0, 0, 0, 4443, 0, 1, 0, NULL, 5, '', ''),
(8295, '1290231215', '江西体彩网', 'http://www.jxlottery.com', 0, 0, 0, 4443, 0, 1, 0, NULL, 6, '', ''),
(8296, '1290231215', '河南体彩网', 'http://www.hnlottery.com.cn/', 0, 0, 0, 4443, 0, 1, 0, NULL, 7, '', ''),
(8297, '1290231215', '重庆体彩网', 'http://www.cqlottery.gov.cn', 0, 0, 0, 4443, 0, 1, 0, NULL, 8, '', ''),
(8298, '1290231215', '广东体彩网', 'http://www.gdlottery.cn/', 0, 0, 0, 4443, 0, 1, 0, NULL, 9, '', ''),
(8299, '1290231215', '四川体彩网', 'http://www.sclottery.gov.cn/', 0, 0, 0, 4443, 0, 1, 0, NULL, 10, '', ''),
(8300, '1290231215', '北京体彩网', 'http://tiyucaipiao.net/beijing/', 0, 0, 0, 4443, 0, 1, 0, NULL, 11, '', ''),
(8301, '1290231215', '山东体彩网', 'http://www.sdticai.com/', 0, 0, 0, 4443, 0, 1, 0, NULL, 12, '', ''),
(8302, '1290231215', '江苏体彩网', 'http://www.js-lottery.com/', 0, 0, 0, 4443, 0, 1, 0, NULL, 13, '', ''),
(8303, '1290231215', '浙江省体彩网', 'http://www.zjlottery.com/', 0, 0, 0, 4443, 0, 1, 0, NULL, 14, '', ''),
(8304, '1290231215', '安徽体彩网', 'http://www.ahlottery.com/', 0, 0, 0, 4443, 0, 1, 0, NULL, 15, '', ''),
(8305, '1290231215', '山西体彩网', 'http://www.sxlottery.net/', 0, 0, 0, 4443, 0, 1, 0, NULL, 16, '', ''),
(8306, '1290231215', '宁夏体育彩票', 'http://lottery.yc.nx.cn/', 0, 0, 0, 4443, 0, 1, 0, NULL, 17, '', ''),
(8307, '1290231215', '陕西体彩网', 'http://www.sxtc.com.cn/', 0, 0, 0, 4443, 0, 1, 0, NULL, 18, '', ''),
(8308, '1290231215', '湖北体彩网', 'http://www.hbtycp.com/', 0, 0, 0, 4443, 0, 1, 0, NULL, 19, '', ''),
(8309, '1290231215', '海南体彩网', 'http://www.tc.hainan.net/', 0, 0, 0, 4443, 0, 1, 0, NULL, 20, '', ''),
(8310, '1290231215', '广西体彩网', 'http://tiyucaipiao.net/guangxi/', 0, 0, 0, 4443, 0, 1, 0, NULL, 21, '', ''),
(8311, '1290231215', '云南体彩网', 'http://www.ynticai.cn/', 0, 0, 0, 4443, 0, 1, 0, NULL, 22, '', ''),
(8312, '1290231215', '青海体彩网', 'http://tiyucaipiao.net/qinghai/', 0, 0, 0, 4443, 0, 1, 0, NULL, 23, '', ''),
(8313, '1290231215', '西藏体彩网', 'http://tiyucaipiao.net/xizang/', 0, 0, 0, 4443, 0, 1, 0, NULL, 24, '', ''),
(8314, '1290231215', '甘肃体彩网', 'http://www.gstc.gov.cn/', 0, 0, 0, 4443, 0, 1, 0, NULL, 25, '', ''),
(8315, '1290231215', '新疆体彩网', 'http://tiyucaipiao.net/xinjiang/', 0, 0, 0, 4443, 0, 1, 0, NULL, 26, '', ''),
(8316, '1290231215', '贵州体彩网', 'http://www.gztcw.com.cn/', 0, 0, 0, 4443, 0, 1, 0, NULL, 27, '', ''),
(8317, '1290231215', '内蒙古体彩网', 'http://www.nmtc.com.cn/', 0, 0, 0, 4443, 0, 1, 0, NULL, 28, '', ''),
(8318, '1290231215', '浙江体彩网', 'http://www.zjlottery.com/', 0, 0, 0, 4443, 0, 1, 0, NULL, 29, '', ''),
(8319, '1290231215', '湖南体彩网', 'http://www.hnticai.com/', 0, 0, 0, 4443, 0, 1, 0, NULL, 30, '', ''),
(8320, '1290231215', '宁夏体彩网', 'http://www.nxtcw.com.cn/', 0, 0, 0, 4443, 0, 1, 0, NULL, 31, '', ''),
(8321, '1290231215', '牡丹江体彩网', 'http://www.mdjtcp.com/', 0, 0, 0, 4443, 0, 1, 0, NULL, 32, '', ''),
(8322, '1290231722', '搜房网', 'http://www.soufun.com/', 0, 0, 0, 4472, 0, 1, 0, NULL, 1, '', ''),
(8323, '1290231722', '焦点房产北京', 'http://house.focus.cn/', 0, 0, 0, 4472, 0, 1, 0, NULL, 2, '', ''),
(8324, '1290231722', '新浪房产北京', 'http://bj.house.sina.com.cn/', 0, 0, 0, 4472, 0, 1, 0, NULL, 3, '', ''),
(8325, '1290231722', '北京房产交易管理网', 'http://www.bjfdc.gov.cn/', 0, 0, 0, 4472, 0, 1, 0, NULL, 4, '', ''),
(8326, '1290231722', '21世纪不动产', 'http://www.century21cn.com', 0, 0, 0, 4472, 0, 1, 0, NULL, 5, '', ''),
(8328, '1290231722', '北京住房公积金管理中心', 'http://www.bjgjj.gov.cn/', 0, 0, 0, 4472, 0, 1, 0, NULL, 7, '', ''),
(8329, '1290231722', '我爱我家', 'http://bj.5i5j.com/', 0, 0, 0, 4472, 0, 1, 0, NULL, 8, '', ''),
(8330, '1290231722', '链家在线', 'http://www.homelink.com.cn/', 0, 0, 0, 4472, 0, 1, 0, NULL, 9, '', ''),
(8331, '1290231722', '集美家居', 'http://www.jimei.com.cn/', 0, 0, 0, 4472, 0, 1, 0, NULL, 10, '', ''),
(8332, '1290231722', '狙房网', 'http://www.snifast.com/', 0, 0, 0, 4472, 0, 1, 0, NULL, 11, '', ''),
(8333, '1290231722', '图房网', 'http://www.tofun.cn/', 0, 0, 0, 4472, 0, 1, 0, NULL, 12, '', ''),
(8334, '1290231722', '九九房产', 'http://www.99fang.com/', 0, 0, 0, 4472, 0, 1, 0, NULL, 13, '', ''),
(8335, '1290231722', 'ie房', 'http://www.iefang.com/', 0, 0, 0, 4472, 0, 1, 0, NULL, 14, '', ''),
(8336, '1290231722', '视频看房网', 'http://www.homev.cn/', 0, 0, 0, 4472, 0, 1, 0, NULL, 15, '', ''),
(8337, '1290231748', '搜房上海', 'http://sh.soufun.com/', 0, 0, 0, 4471, 0, 1, 0, NULL, 1, '', ''),
(8338, '1290231748', '房之窗', 'http://www.ehomeday.com/', 0, 0, 0, 4471, 0, 1, 0, NULL, 2, '', ''),
(8339, '1290231748', '上海房产之窗网', 'http://www.ehomeday.com/', 0, 0, 0, 4471, 0, 1, 0, NULL, 3, '', ''),
(8340, '1290231748', '和家网', 'http://www.51hejia.com/', 0, 0, 0, 4471, 0, 1, 0, NULL, 4, '', ''),
(8341, '1290231748', '上海房产管理局', 'http://www.shfg.gov.cn/', 0, 0, 0, 4471, 0, 1, 0, NULL, 5, '', ''),
(8342, '1290231748', '上海住房公积金网', 'http://www.shgjj.com/', 0, 0, 0, 4471, 0, 1, 0, NULL, 6, '', ''),
(8343, '1290231748', '搜屋', 'http://shanghai.souwoo.com/', 0, 0, 0, 4471, 0, 1, 0, NULL, 7, '', ''),
(8344, '1290231748', '安家网', 'http://www.anjia.com/', 0, 0, 0, 4471, 0, 1, 0, NULL, 8, '', ''),
(8345, '1290231748', '搜屋网', 'http://www.souwoo.com/', 0, 0, 0, 4471, 0, 1, 0, NULL, 9, '', ''),
(8346, '1290231748', '上海二手房网-安居客', 'http://shanghai.anjuke.com/', 0, 0, 0, 4471, 0, 1, 0, NULL, 10, '', ''),
(8347, '1290231748', '租售情报网', 'http://www.myliving.cn/', 0, 0, 0, 4471, 0, 1, 0, NULL, 11, '', ''),
(8348, '1290231770', '全房网', 'http://tj.allfang.com/', 0, 0, 0, 4470, 0, 1, 0, NULL, 1, '', ''),
(8349, '1290231770', '搜房天津', 'http://tj.soufun.com/', 0, 0, 0, 4470, 0, 1, 0, NULL, 2, '', ''),
(8350, '1290231770', '焦点房产天津', 'http://tj.focus.cn/', 0, 0, 0, 4470, 0, 1, 0, NULL, 3, '', ''),
(8351, '1290231770', '天津房产管理局', 'http://www.tjfdc.com.cn/', 0, 0, 0, 4470, 0, 1, 0, NULL, 4, '', ''),
(8352, '1290231770', '天津住房公积金管理中心', 'http://www.zfgjj.cn/', 0, 0, 0, 4470, 0, 1, 0, NULL, 5, '', ''),
(8353, '1290231770', '天津国土资源和房屋管理局', 'http://www.tjfdc.gov.cn/', 0, 0, 0, 4470, 0, 1, 0, NULL, 6, '', ''),
(8354, '1290231795', '河北建设网', 'http://www.hebjs.gov.cn/', 0, 0, 0, 4469, 0, 1, 0, NULL, 1, '', ''),
(8355, '1290231795', '银河房产', 'http://house.inhe.net/', 0, 0, 0, 4469, 0, 1, 0, NULL, 2, '', ''),
(8356, '1290231795', '搜房石家庄', 'http://sjz.soufun.com/', 0, 0, 0, 4469, 0, 1, 0, NULL, 3, '', ''),
(8357, '1290231795', '唐山房产', 'http://www.tsfczx.com', 0, 0, 0, 4469, 0, 1, 0, NULL, 4, '', ''),
(8358, '1290231795', '邢台住房公积金管理中心', 'http://www.xtsgjj.org.cn/', 0, 0, 0, 4469, 0, 1, 0, NULL, 5, '', ''),
(8359, '1290231825', 'housoo房产资讯', 'http://www.housoo.com/', 0, 0, 0, 4468, 0, 1, 0, NULL, 1, '', ''),
(8360, '1290231825', '住在龙城', 'http://fdc.longcity.net', 0, 0, 0, 4468, 0, 1, 0, NULL, 2, '', ''),
(8361, '1290231825', '搜房太原', 'http://taiyuan.soufun.com/', 0, 0, 0, 4468, 0, 1, 0, NULL, 3, '', ''),
(8362, '1290231825', '太原住房公积金网', 'http://www.tygjj.com/', 0, 0, 0, 4468, 0, 1, 0, NULL, 4, '', ''),
(8363, '1290231825', '太原房产管理局', 'http://www.ty-realestate.com.cn/', 0, 0, 0, 4468, 0, 1, 0, NULL, 5, '', ''),
(8364, '1290231844', '烟台房产网', 'http://www.ythouse.com', 0, 0, 0, 4467, 0, 1, 0, NULL, 1, '', ''),
(8365, '1290231844', '济南房地产网', 'http://www.jnhouse.com/', 0, 0, 0, 4467, 0, 1, 0, NULL, 2, '', ''),
(8366, '1290231844', '搜房济南', 'http://jn.soufun.com/', 0, 0, 0, 4467, 0, 1, 0, NULL, 3, '', ''),
(8367, '1290231844', '搜房青岛', 'http://qd.soufun.com/', 0, 0, 0, 4467, 0, 1, 0, NULL, 4, '', ''),
(8368, '1290231844', '青岛房产在线', 'http://www.house.sd.cn/', 0, 0, 0, 4467, 0, 1, 0, NULL, 5, '', ''),
(8369, '1290231844', '济南住房公积金网', 'http://www.gjj.gov.cn/', 0, 0, 0, 4467, 0, 1, 0, NULL, 6, '', ''),
(8370, '1290231844', '青岛房产信息网', 'http://www.qdfdc.com/', 0, 0, 0, 4467, 0, 1, 0, NULL, 7, '', ''),
(8371, '1290231869', '长春住房公积金网', 'http://www.cczfgjj.gov.cn/', 0, 0, 0, 4466, 0, 1, 0, NULL, 1, '', ''),
(8372, '1290231869', '搜房长春', 'http://changchun.soufun.com/', 0, 0, 0, 4466, 0, 1, 0, NULL, 2, '', ''),
(8373, '1290231869', '长春房地产信息网', 'http://www.ccfdw.com/', 0, 0, 0, 4466, 0, 1, 0, NULL, 3, '', ''),
(8374, '1290231890', '亿房', 'http://www.fdc.com.cn/', 0, 0, 0, 4465, 0, 1, 0, NULL, 1, '', ''),
(8375, '1290231890', '武汉住房公积金网', 'http://www.whgjj.cn/', 0, 0, 0, 4465, 0, 1, 0, NULL, 2, '', ''),
(8376, '1290231890', '荆州住房公积金网', 'http://www.jzgjj.com/', 0, 0, 0, 4465, 0, 1, 0, NULL, 3, '', ''),
(8377, '1290231890', '湖北住宅与房产信息网', 'http://www.hbfdcw.com/', 0, 0, 0, 4465, 0, 1, 0, NULL, 4, '', ''),
(8378, '1290231890', '搜房武汉', 'http://wuhan.soufun.com/', 0, 0, 0, 4465, 0, 1, 0, NULL, 5, '', ''),
(8379, '1290231890', '十堰住房公积金网', 'http://www.sygjj.gov.cn/', 0, 0, 0, 4465, 0, 1, 0, NULL, 6, '', ''),
(8380, '1290231890', '襄樊住房公积金网', 'http://www.xfgjj.com/', 0, 0, 0, 4465, 0, 1, 0, NULL, 7, '', ''),
(8381, '1290231890', '黄石住房公积金网', 'http://www.hsgjj.com/', 0, 0, 0, 4465, 0, 1, 0, NULL, 8, '', ''),
(8382, '1290231890', '宜昌住房公积金网', 'http://www.ycgjj.net/', 0, 0, 0, 4465, 0, 1, 0, NULL, 9, '', ''),
(8383, '1290231890', '襄樊房产热线', 'http://www.xffcol.com/', 0, 0, 0, 4465, 0, 1, 0, NULL, 10, '', ''),
(8384, '1290231911', '哈尔滨住房公积金网', 'http://www.hrbgjj.gov.cn/', 0, 0, 0, 4464, 0, 1, 0, NULL, 1, '', ''),
(8385, '1290231911', '黑龙江信息港房产', 'http://house.hlj.net/', 0, 0, 0, 4464, 0, 1, 0, NULL, 2, '', ''),
(8386, '1290231911', '大庆住房公积金', 'http://www.dqgjj.gov.cn/', 0, 0, 0, 4464, 0, 1, 0, NULL, 3, '', ''),
(8387, '1290231911', '搜房哈尔滨站', 'http://hrb.soufun.com/', 0, 0, 0, 4464, 0, 1, 0, NULL, 4, '', ''),
(8388, '1290231935', '商都房产', 'http://house.shangdu.com/', 0, 0, 0, 4463, 0, 1, 0, NULL, 1, '', ''),
(8389, '1290231935', '搜房郑州', 'http://zz.soufun.com/', 0, 0, 0, 4463, 0, 1, 0, NULL, 2, '', ''),
(8390, '1290231935', '郑州住房公积金网', 'http://www.zzgjj.com/', 0, 0, 0, 4463, 0, 1, 0, NULL, 3, '', ''),
(8391, '1290231935', '郑州房产管理局', 'http://www.zzfdc.gov.cn/', 0, 0, 0, 4463, 0, 1, 0, NULL, 4, '', ''),
(8392, '1290231935', '三门峡住房公积金网', 'http://www.smxgjj.com/', 0, 0, 0, 4463, 0, 1, 0, NULL, 5, '', ''),
(8393, '1290231935', '平顶山房产管理局', 'http://www.pdsfdc.gov.cn/', 0, 0, 0, 4463, 0, 1, 0, NULL, 6, '', ''),
(8394, '1290231935', '装装网', 'http://www.zhuangw.com/', 0, 0, 0, 4463, 0, 1, 0, NULL, 7, '', ''),
(8395, '1290231935', '濮阳房产网', 'http://www.pyfc.cn/', 0, 0, 0, 4463, 0, 1, 0, NULL, 8, '', ''),
(8396, '1290231935', '开封房产网', 'http://www.kaifc.cn/', 0, 0, 0, 4463, 0, 1, 0, NULL, 9, '', ''),
(8397, '1290231935', '织家网', 'http://www.51zhijia.com/', 0, 0, 0, 4463, 0, 1, 0, NULL, 10, '', ''),
(8398, '1290231954', '搜房苏州', 'http://suzhou.soufun.com/', 0, 0, 0, 4462, 0, 1, 0, NULL, 1, '', ''),
(8399, '1290231954', '扬州住房公积金', 'http://www.yzgjj.gov.cn/', 0, 0, 0, 4462, 0, 1, 0, NULL, 2, '', ''),
(8400, '1290231954', '南京网上房产', 'http://www.njhouse.com.cn/', 0, 0, 0, 4462, 0, 1, 0, NULL, 3, '', ''),
(8401, '1290231954', '搜房南京', 'http://nanjing.soufun.com/', 0, 0, 0, 4462, 0, 1, 0, NULL, 4, '', ''),
(8402, '1290231954', '常州住房公积金', 'http://www.czgjj.com/', 0, 0, 0, 4462, 0, 1, 0, NULL, 5, '', ''),
(8403, '1290231954', '江阴房产信息网', 'http://www.jy510.com/', 0, 0, 0, 4462, 0, 1, 0, NULL, 6, '', ''),
(8404, '1290231954', '南京住房公积金', 'http://www.njgjj.com/', 0, 0, 0, 4462, 0, 1, 0, NULL, 7, '', ''),
(8405, '1290231954', '苏州住房公积金', 'http://www.szgjj.gov.cn/', 0, 0, 0, 4462, 0, 1, 0, NULL, 8, '', ''),
(8406, '1290231954', '昆山房产网', 'http://house.ks.js.cn/', 0, 0, 0, 4462, 0, 1, 0, NULL, 9, '', ''),
(8407, '1290231954', '365地产家居网', 'http://www.house365.com/', 0, 0, 0, 4462, 0, 1, 0, NULL, 10, '', ''),
(8408, '1290231954', '常州房产', 'http://www.czfcw.com/', 0, 0, 0, 4462, 0, 1, 0, NULL, 11, '', ''),
(8409, '1290231954', '爱上网', 'http://www.loveshang.com/', 0, 0, 0, 4462, 0, 1, 0, NULL, 12, '', ''),
(8410, '1290231954', '淮安网上楼市', 'http://www.hahouse.gov.cn/', 0, 0, 0, 4462, 0, 1, 0, NULL, 13, '', ''),
(8411, '1290231954', '百姓广场', 'http://baixing.sz.js.cn/', 0, 0, 0, 4462, 0, 1, 0, NULL, 14, '', ''),
(8412, '1290231954', '无锡房地产市场网', 'http://www.wxhouse.com/', 0, 0, 0, 4462, 0, 1, 0, NULL, 15, '', ''),
(8413, '1290231954', '苏州房产信息网', 'http://www.szfc.gov.cn/', 0, 0, 0, 4462, 0, 1, 0, NULL, 16, '', ''),
(8414, '1290231954', '华侨路茶坊', 'http://bbs.house365.com/', 0, 0, 0, 4462, 0, 1, 0, NULL, 17, '', ''),
(8415, '1290231978', '搜房广州', 'http://gz.soufun.com/', 0, 0, 0, 4458, 0, 1, 0, NULL, 1, '', ''),
(8416, '1290231978', '深圳房地产信息网', 'http://www.szhome.com/', 0, 0, 0, 4458, 0, 1, 0, NULL, 2, '', ''),
(8417, '1290231978', '搜房深圳', 'http://sz.soufun.com/', 0, 0, 0, 4458, 0, 1, 0, NULL, 3, '', ''),
(8418, '1290231978', '广州房产管理局', 'http://www.laho.gov.cn/', 0, 0, 0, 4458, 0, 1, 0, NULL, 4, '', ''),
(8419, '1290231978', '东莞住房公积金管理中心', 'http://www.dggjj.cn/', 0, 0, 0, 4458, 0, 1, 0, NULL, 5, '', ''),
(8420, '1290231978', '满堂红地产网', 'http://www.mytophome.com/', 0, 0, 0, 4458, 0, 1, 0, NULL, 6, '', ''),
(8421, '1290231978', '广州住房公积金网', 'http://www.gzgjj.gov.cn/', 0, 0, 0, 4458, 0, 1, 0, NULL, 7, '', ''),
(8422, '1290231978', '东莞住房公积金网', 'http://www.dggjj.cn/', 0, 0, 0, 4458, 0, 1, 0, NULL, 8, '', ''),
(8423, '1290231978', '阳光家缘', 'http://g4c.laho.gov.cn/', 0, 0, 0, 4458, 0, 1, 0, NULL, 9, '', ''),
(8424, '1290232317', '厦门房地产联合网', 'http://www.xmhouse.com/', 0, 0, 0, 4459, 0, 1, 0, NULL, 1, '', ''),
(8425, '1290232317', '搜房福州', 'http://fz.soufun.com/', 0, 0, 0, 4459, 0, 1, 0, NULL, 2, '', ''),
(8426, '1290232317', '福房网', 'http://www.ffw.com.cn/', 0, 0, 0, 4459, 0, 1, 0, NULL, 3, '', ''),
(8427, '1290232317', '胜利家园', 'http://fz.v17go.com/', 0, 0, 0, 4459, 0, 1, 0, NULL, 4, '', ''),
(8428, '1290232317', '福州城市猎房', 'http://www.letfind.com.cn/', 0, 0, 0, 4459, 0, 1, 0, NULL, 5, '', ''),
(8429, '1290232317', '龙岩房产网', 'http://www.0597house.com/', 0, 0, 0, 4459, 0, 1, 0, NULL, 6, '', ''),
(8430, '1290232317', '国房网', 'http://fz.china-house.com/', 0, 0, 0, 4459, 0, 1, 0, NULL, 7, '', ''),
(8431, '1290232340', '南昌房产管理局', 'http://www.ncfdc.com.cn/', 0, 0, 0, 4460, 0, 1, 0, NULL, 1, '', ''),
(8432, '1290232340', '南昌住房公积金网', 'http://www.ncgjj.com.cn/', 0, 0, 0, 4460, 0, 1, 0, NULL, 2, '', ''),
(8433, '1290232340', '搜房南昌', 'http://nc.soufun.com/', 0, 0, 0, 4460, 0, 1, 0, NULL, 3, '', ''),
(8434, '1290232340', '家秀', 'http://www.ihomeshow.com/', 0, 0, 0, 4460, 0, 1, 0, NULL, 4, '', ''),
(8435, '1290232340', '赣州房产网', 'http://www.9ihome.com/', 0, 0, 0, 4460, 0, 1, 0, NULL, 5, '', ''),
(8436, '1290232366', '沈阳住房公积金', 'http://www.sygjj.com/', 0, 0, 0, 4444, 0, 1, 0, NULL, 1, '', ''),
(8437, '1290232366', '大连住房公积金网', 'http://www.gjj.dl.gov.cn/', 0, 0, 0, 4444, 0, 1, 0, NULL, 2, '', ''),
(8438, '1290232366', '锦州房产网', 'http://www.jzhome.cn', 0, 0, 0, 4444, 0, 1, 0, NULL, 3, '', ''),
(8439, '1290232366', '搜房沈阳', 'http://sy.soufun.com/', 0, 0, 0, 4444, 0, 1, 0, NULL, 4, '', ''),
(8441, '1290232388', '房途网', 'http://hangzhou.fangtoo.com/', 0, 0, 0, 4445, 0, 1, 0, NULL, 1, '', ''),
(8442, '1290232388', '住在杭州网', 'http://zzhz.zjol.com.cn/', 0, 0, 0, 4445, 0, 1, 0, NULL, 2, '', ''),
(8443, '1290232388', '杭州市房产信息网', 'http://www.hzfc.gov.cn/', 0, 0, 0, 4445, 0, 1, 0, NULL, 3, '', ''),
(8444, '1290232388', '搜房杭州', 'http://hz.soufun.com/', 0, 0, 0, 4445, 0, 1, 0, NULL, 4, '', ''),
(8445, '1290232388', '宁波住宅与房地产网', 'http://www.cnnbfdc.com/', 0, 0, 0, 4445, 0, 1, 0, NULL, 5, '', ''),
(8446, '1290232388', '杭州住房公积金网', 'http://www.hzgjj.gov.cn/', 0, 0, 0, 4445, 0, 1, 0, NULL, 6, '', ''),
(8447, '1290232388', '金华住房公积金网', 'http://www.jhgjj.gov.cn/', 0, 0, 0, 4445, 0, 1, 0, NULL, 7, '', ''),
(8448, '1290232388', '温州房产网', 'http://www.0577home.net/', 0, 0, 0, 4445, 0, 1, 0, NULL, 8, '', ''),
(8449, '1290232388', '东方热线房产', 'http://house.cnool.net/', 0, 0, 0, 4445, 0, 1, 0, NULL, 9, '', ''),
(8450, '1290232451', '海南住房公积金管理中心', 'http://www.hngjj.net/', 0, 0, 0, 4446, 0, 1, 0, NULL, 1, '', ''),
(8451, '1290232451', '海南房产', 'http://house.hainan.net/', 0, 0, 0, 4446, 0, 1, 0, NULL, 2, '', ''),
(8452, '1290232470', '甘房网', 'http://www.gshouse.com.cn/', 0, 0, 0, 4447, 0, 1, 0, NULL, 1, '', ''),
(8453, '1290232470', '兰州住房公积金管理中心', 'http://www.lzgjj.com/', 0, 0, 0, 4447, 0, 1, 0, NULL, 2, '', ''),
(8454, '1290232489', '内蒙古房产网', 'http://www.nmgfc.cn/', 0, 0, 0, 4448, 0, 1, 0, NULL, 1, '', ''),
(8455, '1290232489', '找查发', 'http://www.zhaochafa.com/', 0, 0, 0, 4448, 0, 1, 0, NULL, 2, '', ''),
(8456, '1290232489', '呼和浩特公积金网', 'http://www.hhhtgjj.com.cn/', 0, 0, 0, 4448, 0, 1, 0, NULL, 3, '', ''),
(8457, '1290232511', '西宁租房网', 'http://www.xnzufang.cn/', 0, 0, 0, 4449, 0, 1, 0, NULL, 1, '', ''),
(8458, '1290232534', '银川住房公积金网', 'http://www.ycgjj.com.cn/', 0, 0, 0, 4450, 0, 1, 0, NULL, 1, '', ''),
(8459, '1290232534', '银川房产网', 'http://www.ychfc.com/', 0, 0, 0, 4450, 0, 1, 0, NULL, 2, '', ''),
(8460, '1290232534', '银川市房产管理局', 'http://www.ycre.gov.cn/', 0, 0, 0, 4450, 0, 1, 0, NULL, 3, '', ''),
(8461, '1290232581', '西安房产管理局', 'http://www.xafgj.gov.cn/', 0, 0, 0, 4451, 0, 1, 0, NULL, 1, '', ''),
(8462, '1290232581', '陕西房产', 'http://sx.house.sina.com.cn/', 0, 0, 0, 4451, 0, 1, 0, NULL, 2, '', ''),
(8463, '1290232601', '岳阳房地产网', 'http://www.yyfdcw.com/', 0, 0, 0, 4452, 0, 1, 0, NULL, 1, '', ''),
(8464, '1290232601', '常德房地产网', 'http://www.cdfdc.gov.cn/', 0, 0, 0, 4452, 0, 1, 0, NULL, 2, '', ''),
(8465, '1290232601', '好房子', 'http://www.haofz.com/', 0, 0, 0, 4452, 0, 1, 0, NULL, 3, '', ''),
(8466, '1290232601', '长沙住房公积金网', 'http://www.csgjj.com.cn/', 0, 0, 0, 4452, 0, 1, 0, NULL, 4, '', ''),
(8467, '1290232601', '株洲住房公积金网', 'http://www.zzsgjj.com/', 0, 0, 0, 4452, 0, 1, 0, NULL, 5, '', ''),
(8468, '1290232601', '搜房长沙', 'http://changsha.soufun.com/', 0, 0, 0, 4452, 0, 1, 0, NULL, 6, '', ''),
(8469, '1290232601', '长沙市房产管理局', 'http://www.csfdc.gov.cn/', 0, 0, 0, 4452, 0, 1, 0, NULL, 7, '', ''),
(8470, '1290232601', '衡阳房产信息网', 'http://www.0734fdc.cn/', 0, 0, 0, 4452, 0, 1, 0, NULL, 8, '', ''),
(8471, '1290232601', '郴房网', 'http://www.07358.com/', 0, 0, 0, 4452, 0, 1, 0, NULL, 9, '', ''),
(8472, '1290232601', '怀化房产网', 'http://www.hhfcw.com/', 0, 0, 0, 4452, 0, 1, 0, NULL, 10, '', ''),
(8473, '1290232620', '贵阳房产管理局', 'http://www.gyfg.gov.cn/', 0, 0, 0, 4453, 0, 1, 0, NULL, 1, '', ''),
(8474, '1290232620', '搜房贵阳', 'http://gy.soufun.com/', 0, 0, 0, 4453, 0, 1, 0, NULL, 2, '', ''),
(8475, '1290232620', '筑房网', 'http://www.gyfc.net.cn/', 0, 0, 0, 4453, 0, 1, 0, NULL, 3, '', ''),
(8476, '1290232638', '搜房重庆', 'http://cq.soufun.com/', 0, 0, 0, 4454, 0, 1, 0, NULL, 1, '', ''),
(8477, '1290232638', '焦点房产重庆', 'http://cq.focus.cn/', 0, 0, 0, 4454, 0, 1, 0, NULL, 2, '', ''),
(8478, '1290232638', '重庆房产管理局', 'http://www.cqgtfw.gov.cn/', 0, 0, 0, 4454, 0, 1, 0, NULL, 3, '', ''),
(8479, '1290232659', '四川房产在线', 'http://house.scol.com.cn/', 0, 0, 0, 4455, 0, 1, 0, NULL, 1, '', ''),
(8480, '1290232659', '搜房成都', 'http://cd.soufun.com/', 0, 0, 0, 4455, 0, 1, 0, NULL, 2, '', ''),
(8481, '1290232659', '四川房地产', 'http://www.scfdc.cn/', 0, 0, 0, 4455, 0, 1, 0, NULL, 3, '', ''),
(8482, '1290232659', '成都房产管理局', 'http://www.cdfgj.gov.cn/', 0, 0, 0, 4455, 0, 1, 0, NULL, 4, '', ''),
(8483, '1290232659', '成都住房公积金管理中心', 'http://www.cdzfgjj.gov.cn/', 0, 0, 0, 4455, 0, 1, 0, NULL, 5, '', ''),
(8484, '1290232659', '乐山住房公积金网', 'http://www.lszfgjj.gov.cn/', 0, 0, 0, 4455, 0, 1, 0, NULL, 6, '', ''),
(8485, '1290232659', '宜宾住房公积金管理中心', 'http://www.ybgjj.com/', 0, 0, 0, 4455, 0, 1, 0, NULL, 7, '', ''),
(8486, '1290232659', '绵阳住房公积金管理中心', 'http://gjj.my.gov.cn/', 0, 0, 0, 4455, 0, 1, 0, NULL, 8, '', ''),
(8487, '1290232659', '房产114', 'http://www.fc114.com/', 0, 0, 0, 4455, 0, 1, 0, NULL, 9, '', ''),
(8488, '1290232678', '云南房网', 'http://www.ynhouse.com/', 0, 0, 0, 4456, 0, 1, 0, NULL, 1, '', ''),
(8489, '1290232678', '搜房昆明', 'http://km.soufun.com/', 0, 0, 0, 4456, 0, 1, 0, NULL, 2, '', ''),
(8490, '1290232678', '云南信息港房产', 'http://house.yninfo.com/', 0, 0, 0, 4456, 0, 1, 0, NULL, 3, '', ''),
(8491, '1290232697', '柳州房产街', 'http://lz.gxhouse.com/', 0, 0, 0, 4457, 0, 1, 0, NULL, 1, '', ''),
(8492, '1290232697', '南宁住房公积金网', 'http://www.nngjj.com/', 0, 0, 0, 4457, 0, 1, 0, NULL, 2, '', ''),
(8493, '1290232697', '广西房地产信息网', 'http://www.gxfdc.cn/', 0, 0, 0, 4457, 0, 1, 0, NULL, 3, '', ''),
(8494, '1290232715', '合肥家园网', 'http://www.hfhome.cn/', 0, 0, 0, 4461, 0, 1, 0, NULL, 1, '', ''),
(8495, '1290232715', '搜房合肥', 'http://hf.soufun.com/', 0, 0, 0, 4461, 0, 1, 0, NULL, 2, '', ''),
(8496, '1290232715', '安庆房产网', 'http://www.aqhouse.com/', 0, 0, 0, 4461, 0, 1, 0, NULL, 3, '', ''),
(8497, '1290232715', '合肥房地产交易网', 'http://www.hfhouse.com/', 0, 0, 0, 4461, 0, 1, 0, NULL, 4, '', ''),
(8498, '1290232715', '合肥住房公积金中心', 'http://www.hfgjj.com/', 0, 0, 0, 4461, 0, 1, 0, NULL, 5, '', ''),
(8499, '1290232715', '马鞍山住房公积金', 'http://www.masgjj.gov.cn/', 0, 0, 0, 4461, 0, 1, 0, NULL, 6, '', ''),
(8500, '1290232715', '阜阳住房公积金', 'http://www.fygjj.com/', 0, 0, 0, 4461, 0, 1, 0, NULL, 7, '', ''),
(8501, '1290232715', '黄山住房公积金', 'http://www.hsgjjw.com/', 0, 0, 0, 4461, 0, 1, 0, NULL, 8, '', ''),
(8502, '1290232715', '蚌埠住房公积金', 'http://zfgjj.bb.ah.cn/', 0, 0, 0, 4461, 0, 1, 0, NULL, 9, '', ''),
(8503, '1290232715', '合肥房产网', 'http://www.hffangchan.com/', 0, 0, 0, 4461, 0, 1, 0, NULL, 10, '', ''),
(8504, '1290232715', '马鞍山房房网', 'http://www.masff.com/', 0, 0, 0, 4461, 0, 1, 0, NULL, 11, '', ''),
(8505, '1290232873', '红旗网', 'http://car.faw.com.cn/car/index.jsp', 0, 0, 0, 4473, 0, 1, 0, NULL, 1, '', ''),
(8506, '1290232873', 'Acura讴歌汽车', 'http://www.acura.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 2, '', ''),
(8507, '1290232873', '北京现代汽车有限公司', 'http://www.beijing-hyundai.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 3, '', ''),
(8508, '1290232873', '华晨汽车', 'http://www.brilliance-auto.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 4, '', ''),
(8509, '1290232873', '比亚迪汽车', 'http://www.bydauto.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 5, '', ''),
(8510, '1290232873', '凯迪拉克', 'http://www.cadillac.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 6, '', ''),
(8511, '1290232873', '长安铃木', 'http://www.changansuzuki.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 7, '', ''),
(8512, '1290232873', '上海大众汽车', 'http://www.csvw.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 8, '', ''),
(8513, '1290232873', '东风悦达.起亚', 'http://www.dyk.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 9, '', ''),
(8514, '1290232873', '一汽-大众', 'http://www.faw-volkswagen.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 10, '', ''),
(8515, '1290232873', '南京菲亚特', 'http://www.fiat.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 11, '', ''),
(8516, '1290232873', '福特汽车', 'http://www.ford.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 12, '', ''),
(8517, '1290232873', '北汽福田汽车', 'http://www.futian.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 13, '', ''),
(8518, '1290232873', '吉利轿车', 'http://www.geely.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 14, '', ''),
(8519, '1290232873', '通用汽车中国', 'http://www.gmchina.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 15, '', ''),
(8520, '1290232873', '广州本田', 'http://www.guangzhouhonda.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 16, '', ''),
(8521, '1290232873', '长城汽车', 'http://www.gwm.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 17, '', ''),
(8522, '1290232873', '哈飞汽车', 'http://www.hafeiauto.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 18, '', ''),
(8523, '1290232873', '海马汽车', 'http://www.haima.com/2006/index.asp', 0, 0, 0, 4473, 0, 1, 0, NULL, 19, '', ''),
(8524, '1290232873', '黑豹汽车', 'http://www.heibao.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 20, '', ''),
(8525, '1290232873', '华普汽车', 'http://www.huapucar.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 21, '', ''),
(8526, '1290232873', '现代汽车', 'http://www.hyundai-motor.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 22, '', ''),
(8527, '1290232873', '江淮汽车', 'http://www.jac.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 23, '', ''),
(8528, '1290232873', '江铃汽车', 'http://www.jmc.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 24, '', ''),
(8529, '1290232873', '一汽马自达', 'http://www.mazda3.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 25, '', ''),
(8530, '1290232873', 'NISSAN中国', 'http://www.nissan.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 26, '', ''),
(8531, '1290232873', '标致汽车', 'http://www.peugeot.com/fr/default.htm', 0, 0, 0, 4473, 0, 1, 0, NULL, 27, '', ''),
(8532, '1290232873', '上海汽车工业总公司', 'http://www.saicgroup.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 28, '', ''),
(8533, '1290232873', '上汽通用五菱', 'http://www.sgmw.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 29, '', ''),
(8534, '1290232873', '上海汇众汽车', 'http://www.sachs.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 30, '', ''),
(8535, '1290232873', '上海通用', 'http://www.shanghaigm.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 31, '', ''),
(8536, '1290232873', '东南汽车', 'http://www.soueast-motor.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 32, '', ''),
(8537, '1290232873', '双龙汽车', 'http://www.ssangyongmotor.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 33, '', ''),
(8538, '1290232873', '天津一汽夏利汽车', 'http://www.tjfaw.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 34, '', ''),
(8539, '1290232873', '丰田汽车', 'http://www.toyota.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 35, '', ''),
(8540, '1290232873', '长安福特', 'http://www.volvocars.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 36, '', ''),
(8541, '1290232873', '郑州日产汽车', 'http://www.zhengzhounissan.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 37, '', ''),
(8542, '1290232873', '中华轿车', 'http://www.zhonghuacar.com/', 0, 0, 0, 4473, 0, 1, 0, NULL, 38, '', ''),
(8543, '1290232873', '中兴汽车', 'http://www.zxauto.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 39, '', ''),
(8544, '1290232873', '大众中国', 'http://www.vw.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 40, '', ''),
(8545, '1290232873', '东风-雪铁龙', 'http://www.dcad.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 41, '', ''),
(8546, '1290232873', '日产-雷诺', 'http://www.renault.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 42, '', ''),
(8547, '1290232873', 'NULL', 'http://www.daimlerchrysler.com.cn/%E6%88%B4%E5%A7%86%E5%8B%92-%E5%85%8B%E8%8E%B1%E6%96%AF%E5%8B%92', 0, 0, 0, 4473, 0, 1, 0, NULL, 43, '', ''),
(8548, '1290232873', '现代-起亚', 'http://www.kia-motor.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 44, '', ''),
(8549, '1290232873', '宝马', 'http://www.bmw.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 45, '', ''),
(8550, '1290232873', '本田中国', 'http://www.honda.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 46, '', ''),
(8551, '1290232873', '奔驰', 'http://www.mercedes-benz.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 47, '', ''),
(8552, '1290232873', '奥迪', 'http://www.audi.cn/audi/cn/zh2.html', 0, 0, 0, 4473, 0, 1, 0, NULL, 48, '', ''),
(8553, '1290232873', '神龙汽车', 'http://www.dpca.com.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 49, '', ''),
(8554, '1290232873', '奇瑞汽车', 'http://www.chery.cn/', 0, 0, 0, 4473, 0, 1, 0, NULL, 50, '', ''),
(8555, '1290232901', '中国汽车交易网', 'http://www.auto18.com/', 0, 0, 0, 4474, 0, 1, 0, NULL, 1, '', ''),
(8556, '1290232901', '中国汽车消费网', 'http://www.315che.com', 0, 0, 0, 4474, 0, 1, 0, NULL, 2, '', ''),
(8557, '1290232901', '太平洋汽车报价', 'http://price.pcauto.com.cn/', 0, 0, 0, 4474, 0, 1, 0, NULL, 3, '', ''),
(8558, '1290232901', '汽车之家报价', 'http://car.autohome.com.cn/', 0, 0, 0, 4474, 0, 1, 0, NULL, 4, '', ''),
(8559, '1290232901', '搜狐汽车报价', 'http://price.auto.sohu.com/', 0, 0, 0, 4474, 0, 1, 0, NULL, 5, '', ''),
(8560, '1290232901', '易车网汽车报价', 'http://price.bitauto.com/', 0, 0, 0, 4474, 0, 1, 0, NULL, 6, '', ''),
(8561, '1290232923', '驾校一点通', 'http://www.jxedt.com/', 0, 0, 0, 4475, 0, 1, 0, NULL, 1, '', ''),
(8562, '1290232923', '全国驾校网', 'http://www.51xueche.com/', 0, 0, 0, 4475, 0, 1, 0, NULL, 2, '', ''),
(8563, '1290232923', '学车网', 'http://www.xueche.net/', 0, 0, 0, 4475, 0, 1, 0, NULL, 3, '', ''),
(8564, '1290232923', '驾驶员试题网', 'http://www.jsyst.cn', 0, 0, 0, 4475, 0, 1, 0, NULL, 4, '', ''),
(8565, '1290233335', '浙江电视台', 'http://www.cztv.com/', 0, 0, 0, 4476, 0, 1, 0, NULL, 1, '', ''),
(8566, '1290233335', '温州广电网', 'http://www.wztv.cn/', 0, 0, 0, 4476, 0, 1, 0, NULL, 2, '', ''),
(8567, '1290233353', '兰州电视台', 'http://www.lztv.tv/', 0, 0, 0, 4477, 0, 1, 0, NULL, 1, '', ''),
(8568, '1290233382', '内蒙古电视台', 'http://www.nmtv.cn/', 0, 0, 0, 4478, 0, 1, 0, NULL, 1, '', ''),
(8569, '1290233382', '内蒙古广播网', 'http://www.nmrb.cn/', 0, 0, 0, 4478, 0, 1, 0, NULL, 2, '', ''),
(8570, '1290233402', '青海电视台', 'http://www.qhstv.com/', 0, 0, 0, 4479, 0, 1, 0, NULL, 1, '', ''),
(8571, '1290233417', '宁夏电视台', 'http://www.nxtv.com.cn/', 0, 0, 0, 4480, 0, 1, 0, NULL, 1, '', ''),
(8572, '1290233417', '宁夏人民广播电台', 'http://www.nxnews.net/radio/', 0, 0, 0, 4480, 0, 1, 0, NULL, 2, '', ''),
(8573, '1290233435', '陕西电视台', 'http://www.sxtvs.com/', 0, 0, 0, 4481, 0, 1, 0, NULL, 1, '', ''),
(8574, '1290233435', '西安电视台', 'http://www.xatvs.com/', 0, 0, 0, 4481, 0, 1, 0, NULL, 2, '', ''),
(8575, '1290233455', '中国湖南卫视', 'http://www.hunantv.com/', 0, 0, 0, 4482, 0, 1, 0, NULL, 1, '', ''),
(8576, '1290233455', '湖南广播在线', 'http://www.hnradio.com/', 0, 0, 0, 4482, 0, 1, 0, NULL, 2, '', ''),
(8577, '1290233455', '湖南电台交通频道', 'http://www.fm918.cn/', 0, 0, 0, 4482, 0, 1, 0, NULL, 3, '', ''),
(8578, '1290233455', '湖南经济电视台', 'http://www.hnetv.com/', 0, 0, 0, 4482, 0, 1, 0, NULL, 4, '', ''),
(8579, '1290233473', '贵州电视台', 'http://www.gzstv.com/', 0, 0, 0, 4483, 0, 1, 0, NULL, 1, '', ''),
(8580, '1290233473', '贵州人民广播电台', 'http://www.gzbs.cn/', 0, 0, 0, 4483, 0, 1, 0, NULL, 2, '', ''),
(8581, '1290233499', '重庆电视台', 'http://www.cbg.cn/', 0, 0, 0, 4484, 0, 1, 0, NULL, 1, '', ''),
(8582, '1290233499', '华龙宽频', 'http://v.cbg.cn/', 0, 0, 0, 4484, 0, 1, 0, NULL, 2, '', ''),
(8583, '1290233519', '四川电视台', 'http://www.sctv.com/', 0, 0, 0, 4485, 0, 1, 0, NULL, 1, '', ''),
(8584, '1290233519', '成都电视台', 'http://www.chengdutv.com/', 0, 0, 0, 4485, 0, 1, 0, NULL, 2, '', ''),
(8585, '1290233519', '宜宾电视台', 'http://www.ybtv.cc/', 0, 0, 0, 4485, 0, 1, 0, NULL, 3, '', ''),
(8586, '1290233536', '云南电视台', 'http://www.yntv.cn/', 0, 0, 0, 4486, 0, 1, 0, NULL, 1, '', ''),
(8587, '1290233536', '昆明电视台', 'http://www.kmtv.com.cn/', 0, 0, 0, 4486, 0, 1, 0, NULL, 2, '', ''),
(8588, '1290233553', '广西电视台', 'http://www.gxtv.com.cn/', 0, 0, 0, 4487, 0, 1, 0, NULL, 1, '', ''),
(8589, '1290233553', '南宁电视台', 'http://www.nntv.com.cn/', 0, 0, 0, 4487, 0, 1, 0, NULL, 2, '', ''),
(8590, '1290233553', '广西广播网', 'http://www.gxradio.com/', 0, 0, 0, 4487, 0, 1, 0, NULL, 3, '', ''),
(8591, '1290233553', '玉林电视台', 'http://www.yltvb.com/', 0, 0, 0, 4487, 0, 1, 0, NULL, 4, '', ''),
(8592, '1290233570', '广东电视台', 'http://www.gdtv.com.cn/', 0, 0, 0, 4488, 0, 1, 0, NULL, 1, '', ''),
(8593, '1290233570', '南方电视台', 'http://www.tvscn.com/', 0, 0, 0, 4488, 0, 1, 0, NULL, 2, '', ''),
(8594, '1290233570', '广东电台城市之声', 'http://www.fm1036.com/', 0, 0, 0, 4488, 0, 1, 0, NULL, 3, '', ''),
(8595, '1290233570', '深圳电视台', 'http://www.sztv.com.cn/', 0, 0, 0, 4488, 0, 1, 0, NULL, 4, '', ''),
(8596, '1290233570', '潮州广播电视', 'http://www.czbtv.com/', 0, 0, 0, 4488, 0, 1, 0, NULL, 5, '', ''),
(8597, '1290233570', '广州电台', 'http://www.goofm.com/', 0, 0, 0, 4488, 0, 1, 0, NULL, 6, '', ''),
(8598, '1290233570', '佛山电视台', 'http://www.fstv.com.cn/', 0, 0, 0, 4488, 0, 1, 0, NULL, 7, '', ''),
(8599, '1290233570', '佛山电台', 'http://www.946.com.cn/', 0, 0, 0, 4488, 0, 1, 0, NULL, 8, '', ''),
(8600, '1290233570', '广东电台音乐之声', 'http://www.fm993.com.cn/', 0, 0, 0, 4488, 0, 1, 0, NULL, 9, '', ''),
(8601, '1290233570', '珠海电视台', 'http://www.zhtv.com/', 0, 0, 0, 4488, 0, 1, 0, NULL, 10, '', ''),
(8602, '1290233570', '汕头电台', 'http://www.strtv.cn/', 0, 0, 0, 4488, 0, 1, 0, NULL, 11, '', ''),
(8603, '1290233570', '羊城交通广播', 'http://www.fm1052.com.cn/', 0, 0, 0, 4488, 0, 1, 0, NULL, 12, '', ''),
(8604, '1290233570', '广州电视台', 'http://www.gztv.com/', 0, 0, 0, 4488, 0, 1, 0, NULL, 13, '', ''),
(8605, '1290233590', '东南卫视', 'http://www.setv.com.cn/', 0, 0, 0, 4489, 0, 1, 0, NULL, 1, '', ''),
(8606, '1290233590', '福建电视台', 'http://www.fjtv.net/', 0, 0, 0, 4489, 0, 1, 0, NULL, 2, '', ''),
(8607, '1290233590', '晋江电视台', 'http://www.jinjiang.tv/', 0, 0, 0, 4489, 0, 1, 0, NULL, 3, '', ''),
(8608, '1290233590', '漳州电视台', 'http://www.zztv.fj.cn/', 0, 0, 0, 4489, 0, 1, 0, NULL, 4, '', ''),
(8609, '1290233590', '福建电台都市生活频道', 'http://www.fm987.com.cn/', 0, 0, 0, 4489, 0, 1, 0, NULL, 5, '', ''),
(8610, '1290233590', '福建经济电台', 'http://www.fj961.com/', 0, 0, 0, 4489, 0, 1, 0, NULL, 6, '', ''),
(8611, '1290233590', '泉州电视台', 'http://www.qztv.cn/', 0, 0, 0, 4489, 0, 1, 0, NULL, 7, '', ''),
(8612, '1290233612', '江西电视台', 'http://www.cjxtv.com/', 0, 0, 0, 4490, 0, 1, 0, NULL, 1, '', ''),
(8613, '1290233612', '江西人民广播电台', 'http://www.jxgdw.com/jxgd/jxgbdt/', 0, 0, 0, 4490, 0, 1, 0, NULL, 2, '', ''),
(8614, '1290233612', '南昌人民广播电台', 'http://www.ncpbs.com/', 0, 0, 0, 4490, 0, 1, 0, NULL, 3, '', ''),
(8615, '1290233612', '九江电视台', 'http://www.jj-tv.com/', 0, 0, 0, 4490, 0, 1, 0, NULL, 4, '', ''),
(8616, '1290233612', '赣州电视台', 'http://www.jxgztv.com/', 0, 0, 0, 4490, 0, 1, 0, NULL, 5, '', ''),
(8617, '1290233632', '安徽电视台', 'http://www.ahtv.cn/', 0, 0, 0, 4491, 0, 1, 0, NULL, 1, '', ''),
(8618, '1290233632', '合肥电视台', 'http://www.hefeitv.com/', 0, 0, 0, 4491, 0, 1, 0, NULL, 2, '', ''),
(8619, '1290233632', '安徽人民广播电台', 'http://www.ahradio.com.cn/', 0, 0, 0, 4491, 0, 1, 0, NULL, 3, '', ''),
(8620, '1290233649', '江苏电视台', 'http://www.jsbc.com/', 0, 0, 0, 4492, 0, 1, 0, NULL, 1, '', ''),
(8621, '1290233649', '太湖明珠－广播电视', 'http://www.thmz.com/col34/', 0, 0, 0, 4492, 0, 1, 0, NULL, 2, '', ''),
(8622, '1290233649', '江苏交通广播网', 'http://www.js1011.com/', 0, 0, 0, 4492, 0, 1, 0, NULL, 3, '', ''),
(8623, '1290233671', '河南电视台', 'http://www.hntv.ha.cn/', 0, 0, 0, 4493, 0, 1, 0, NULL, 1, '', ''),
(8624, '1290233671', '河南广播网', 'http://www.radiohenan.com/', 0, 0, 0, 4493, 0, 1, 0, NULL, 2, '', ''),
(8625, '1290233671', '郑州广播在线', 'http://www.zzradio.cn/', 0, 0, 0, 4493, 0, 1, 0, NULL, 3, '', ''),
(8626, '1290233671', '新乡电视台', 'http://www.tv373.com/', 0, 0, 0, 4493, 0, 1, 0, NULL, 4, '', ''),
(8627, '1290233671', '南阳电视台', 'http://www.nytv.com.cn/', 0, 0, 0, 4493, 0, 1, 0, NULL, 5, '', ''),
(8628, '1290233689', '黑龙江电视台', 'http://www.hljtv.com/', 0, 0, 0, 4494, 0, 1, 0, NULL, 1, '', ''),
(8629, '1290233689', '哈尔滨电视台', 'http://www.hrbtv.net/', 0, 0, 0, 4494, 0, 1, 0, NULL, 2, '', ''),
(8630, '1290233689', '黑龙江广播电台', 'http://www.hljradio.com/', 0, 0, 0, 4494, 0, 1, 0, NULL, 3, '', ''),
(8631, '1290233689', '黑龙江交通广播', 'http://www.fm998.com.cn/', 0, 0, 0, 4494, 0, 1, 0, NULL, 4, '', ''),
(8632, '1290233708', '直播威海', 'http://www.weihai.tv/', 0, 0, 0, 4495, 0, 1, 0, NULL, 1, '', ''),
(8633, '1290233708', '山东广播网', 'http://www.sdgb.cn/', 0, 0, 0, 4495, 0, 1, 0, NULL, 2, '', ''),
(8634, '1290233708', '青岛传媒网', 'http://www.qingdaomedia.com/', 0, 0, 0, 4495, 0, 1, 0, NULL, 3, '', ''),
(8635, '1290233708', '济南电视台', 'http://www.jntv.com.cn/', 0, 0, 0, 4495, 0, 1, 0, NULL, 4, '', ''),
(8636, '1290233731', '山西广播电视总台', 'http://www.sxrtv.com/', 0, 0, 0, 4496, 0, 1, 0, NULL, 1, '', ''),
(8637, '1290233731', '山西电视台', 'http://www.shanxitv.com/', 0, 0, 0, 4496, 0, 1, 0, NULL, 2, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(8638, '1290233731', '山西音乐广播', 'http://www.sxrtv.com/Radio/music_radio/yygb_index.htm', 0, 0, 0, 4496, 0, 1, 0, NULL, 3, '', ''),
(8639, '1290233731', '山西长城经济广播', 'http://www.sxrtv.com/Radio/ChangchengEconomy_Radio/ChangchengEconomy_Radio_index.htm', 0, 0, 0, 4496, 0, 1, 0, NULL, 4, '', ''),
(8640, '1290233747', '河北电视台', 'http://www.hebtv.com/', 0, 0, 0, 4497, 0, 1, 0, NULL, 1, '', ''),
(8641, '1290233747', '保定电视台', 'http://www.bdtv.com.cn/', 0, 0, 0, 4497, 0, 1, 0, NULL, 2, '', ''),
(8642, '1290233747', '石家庄广电网', 'http://www.sjztv.com.cn/', 0, 0, 0, 4497, 0, 1, 0, NULL, 3, '', ''),
(8643, '1290233765', '吉林电视台', 'http://www.jilintv.cn/', 0, 0, 0, 4498, 0, 1, 0, NULL, 1, '', ''),
(8644, '1290233765', '吉林人民广播电台', 'http://www.jlradio.com.cn/', 0, 0, 0, 4498, 0, 1, 0, NULL, 2, '', ''),
(8645, '1290233765', '长春电视台', 'http://www.chinactv.com/', 0, 0, 0, 4498, 0, 1, 0, NULL, 3, '', ''),
(8646, '1290233765', '延边电视台', 'http://cn.iybtv.com/', 0, 0, 0, 4498, 0, 1, 0, NULL, 4, '', ''),
(8647, '1290233781', '天津电视台', 'http://www.tjtv.com.cn/', 0, 0, 0, 4499, 0, 1, 0, NULL, 1, '', ''),
(8648, '1290233781', '天津卫视', 'http://www.tjtv.com.cn/weishi/', 0, 0, 0, 4499, 0, 1, 0, NULL, 2, '', ''),
(8649, '1290233798', '湖北电视台', 'http://www.hbtv.com.cn/', 0, 0, 0, 4500, 0, 1, 0, NULL, 1, '', ''),
(8650, '1290233798', '武汉广电网', 'http://www.whbc.com.cn/', 0, 0, 0, 4500, 0, 1, 0, NULL, 2, '', ''),
(8651, '1290233798', '荆门电视台', 'http://www.jmtv.com.cn/', 0, 0, 0, 4500, 0, 1, 0, NULL, 3, '', ''),
(8652, '1290233816', '上海电视台', 'http://www.smg.cn/', 0, 0, 0, 4501, 0, 1, 0, NULL, 1, '', ''),
(8653, '1290233816', '上海东方卫视', 'http://www.smg.cn/', 0, 0, 0, 4501, 0, 1, 0, NULL, 2, '', ''),
(8654, '1290233816', '广播戏曲频率', 'http://www.smg.cn/Index_Columns/Index_Channels.aspx?id=36', 0, 0, 0, 4501, 0, 1, 0, NULL, 3, '', ''),
(8655, '1290233832', '辽宁电视台', 'http://www.lntv.com.cn/', 0, 0, 0, 4502, 0, 1, 0, NULL, 1, '', ''),
(8656, '1290233832', '沈阳电视台', 'http://www.csytv.com/', 0, 0, 0, 4502, 0, 1, 0, NULL, 2, '', ''),
(8657, '1290233832', '沈阳广播网', 'http://www.syradio.cn/', 0, 0, 0, 4502, 0, 1, 0, NULL, 3, '', ''),
(8658, '1290233832', '大连电视台', 'http://www.dltv.cn/', 0, 0, 0, 4502, 0, 1, 0, NULL, 4, '', ''),
(8659, '1290233853', '北京电视台', 'http://www.btv.org/', 0, 0, 0, 4503, 0, 1, 0, NULL, 1, '', ''),
(8660, '1290233853', '北京广播网', 'http://www.rbc.cn/', 0, 0, 0, 4503, 0, 1, 0, NULL, 2, '', ''),
(8661, '1290233853', '中国教育电视台', 'http://www.cetv.edu.cn/', 0, 0, 0, 4503, 0, 1, 0, NULL, 3, '', ''),
(8662, '1290233853', '国际在线', 'http://gb.cri.cn/', 0, 0, 0, 4503, 0, 1, 0, NULL, 4, '', ''),
(8663, '1290234430', '北京大学', 'http://www.pku.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 1, '', ''),
(8664, '1290234430', '中国人民大学', 'http://www.ruc.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 2, '', ''),
(8665, '1290234430', '清华大学', 'http://www.tsinghua.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 3, '', ''),
(8666, '1290234430', '北京交通大学', 'http://www.njtu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 4, '', ''),
(8667, '1290234430', '北京航空航天大学', 'http://www.buaa.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 5, '', ''),
(8668, '1290234430', '北京理工大学', 'http://www.bit.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 6, '', ''),
(8669, '1290234430', '北京科技大学', 'http://www.ustb.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 7, '', ''),
(8670, '1290234430', '北京化工大学', 'http://www.buct.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 8, '', ''),
(8671, '1290234430', '北京邮电大学', 'http://www.bupt.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 9, '', ''),
(8672, '1290234430', '华北电力大学', 'http://www.ncepu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 10, '', ''),
(8673, '1290234430', '中国石油大学(北京)', 'http://www.cup.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 11, '', ''),
(8674, '1290234430', '中国地质大学（北京）', 'http://www.cugb.edu.cn/%20', 0, 0, 0, 4535, 0, 1, 0, NULL, 12, '', ''),
(8675, '1290234430', '中国农业大学', 'http://www.cau.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 13, '', ''),
(8676, '1290234430', '北京林业大学', 'http://www.bjfu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 14, '', ''),
(8677, '1290234430', '北京中医药大学', 'http://www.bucm.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 15, '', ''),
(8678, '1290234430', '北京师范大学', 'http://www.bnu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 16, '', ''),
(8679, '1290234430', '北京外国语大学', 'http://www.bfsu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 17, '', ''),
(8680, '1290234430', '北京语言大学', 'http://www.blcu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 18, '', ''),
(8681, '1290234430', '中国传媒大学', 'http://www.cuc.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 19, '', ''),
(8682, '1290234430', '中央财经大学', 'http://www.cufe.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 20, '', ''),
(8683, '1290234430', '对外经贸大学', 'http://www.uibe.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 21, '', ''),
(8684, '1290234430', '中国人民公安大学', 'http://www.cppsu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 22, '', ''),
(8685, '1290234430', '中国政法大学', 'http://www.cupl.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 23, '', ''),
(8686, '1290234430', '北京体育大学', 'http://www.bsu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 24, '', ''),
(8687, '1290234430', '中央民族大学', 'http://www.cun.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 25, '', ''),
(8688, '1290234430', '北京电子科技学院', 'http://www.besti.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 26, '', ''),
(8689, '1290234430', '北京协和医学院', 'http://www.pumc.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 27, '', ''),
(8690, '1290234430', '外交学院', 'http://www.fac.edu.cn/mainweb/index.php', 0, 0, 0, 4535, 0, 1, 0, NULL, 28, '', ''),
(8691, '1290234430', '中华女子学院', 'http://www.cwu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 29, '', ''),
(8692, '1290234430', '国际关系学院', 'http://www.uir.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 30, '', ''),
(8693, '1290234430', '中国青年政治学院', 'http://www.cyu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 31, '', ''),
(8694, '1290234430', '中国劳动关系学院', 'http://www.ciir.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 32, '', ''),
(8695, '1290234430', '中央音乐学院', 'http://www.ccom.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 33, '', ''),
(8696, '1290234430', '中央美术学院', 'http://www.cafa.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 34, '', ''),
(8697, '1290234430', '中央戏剧学院', 'http://www.chntheatre.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 35, '', ''),
(8698, '1290234430', '北京联合大学', 'http://www.buu.edu.cn/home/', 0, 0, 0, 4535, 0, 1, 0, NULL, 36, '', ''),
(8699, '1290234430', '北京工业大学', 'http://www.bjut.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 37, '', ''),
(8700, '1290234430', '北方工业大学', 'http://www.ncut.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 38, '', ''),
(8701, '1290234430', '北京信息科技大学', 'http://www.bistu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 39, '', ''),
(8702, '1290234430', '首都医科大学', 'http://www.ccmu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 40, '', ''),
(8703, '1290234430', '首都师范大学', 'http://www.cnu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 41, '', ''),
(8704, '1290234430', '北京工商大学', 'http://www.btbu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 42, '', ''),
(8705, '1290234430', '首都经济贸易大学', 'http://www.cueb.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 43, '', ''),
(8706, '1290234430', '北京城市学院', 'http://www.bcu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 44, '', ''),
(8707, '1290234430', '北京服装学院', 'http://www.bift.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 45, '', ''),
(8708, '1290234430', '北京印刷学院', 'http://www.bigc.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 46, '', ''),
(8709, '1290234430', '北京建筑工程学院', 'http://www.bucea.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 47, '', ''),
(8710, '1290234430', '北京石油化工学院', 'http://www.bipt.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 48, '', ''),
(8711, '1290234430', '首钢工学院', 'http://www.sgit.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 49, '', ''),
(8712, '1290234430', '北京农学院', 'http://www.bac.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 50, '', ''),
(8713, '1290234430', '北京第二外国语学院', 'http://www.bisu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 51, '', ''),
(8714, '1290234430', '北京物资学院', 'http://www.bwu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 52, '', ''),
(8715, '1290234430', '首都体育学院', 'http://www.cipe.net.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 53, '', ''),
(8716, '1290234430', '中国音乐学院', 'http://www.ccmusic.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 54, '', ''),
(8717, '1290234430', '中国戏曲学院', 'http://www.nacta.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 55, '', ''),
(8718, '1290234430', '北京电影学院', 'http://www.bfa.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 56, '', ''),
(8719, '1290234430', '北京舞蹈学院', 'http://www.bda.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 57, '', ''),
(8720, '1290234489', '北京青年政治学院', 'http://www.bjypc.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 1, '', ''),
(8721, '1290234489', '北京科技经营管理学院', 'http://www.bjjsy1985.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 2, '', ''),
(8722, '1290234489', '北京电子科技职业学院', 'http://www.dky.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 3, '', ''),
(8723, '1290234489', '北京信息职业技术学院', 'http://www.bitc.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 4, '', ''),
(8724, '1290234489', '北京工业职业技术学院', 'http://www.bgy.org.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 5, '', ''),
(8725, '1290234489', '北京吉利大学', 'http://www.bgu.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 6, '', ''),
(8726, '1290234489', '北京培黎职业学院', 'http://www.bjpldx.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 7, '', ''),
(8727, '1290234489', '北京经济管理职业学院', 'http://www.bj.xinhuanet.com/wq/gq/jg/', 0, 0, 0, 4535, 0, 1, 0, NULL, 8, '', ''),
(8728, '1290234489', '北京劳动保障职业学院', 'http://www.bvclss.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 9, '', ''),
(8729, '1290234489', '北京戏曲艺术职业学院', 'http://www.bjxx.com.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 10, '', ''),
(8730, '1290234489', '北京体育职业学院', 'http://www.bjtzhy.org/', 0, 0, 0, 4535, 0, 1, 0, NULL, 11, '', ''),
(8731, '1290234489', '北京农业职业学院', 'http://www.bvca.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 12, '', ''),
(8732, '1290234489', '北京汇佳职业学院', 'http://www.hju.net.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 13, '', ''),
(8733, '1290234489', '北京政法职业学院', 'http://www.bcpl.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 14, '', ''),
(8734, '1290234489', '北京财贸职业学院', 'http://www.bjczy.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 15, '', ''),
(8735, '1290234489', '北京经济技术职业学院', 'http://www.tangedu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 16, '', ''),
(8736, '1290234489', '北京科技职业学院', 'http://www.5aaa.com/', 0, 0, 0, 4535, 0, 1, 0, NULL, 17, '', ''),
(8737, '1290234489', '北京北大方正软件职业技术学院', 'http://www.pfc.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 18, '', ''),
(8738, '1290234489', '北京现代职业技术学院', 'http://www.moderncollege.com.cn/DefaultPages/MyPage4.asp?Template=4', 0, 0, 0, 4535, 0, 1, 0, NULL, 19, '', ''),
(8739, '1290234489', '北京社会管理职业学院', 'http://sgy.mca.gov.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 20, '', ''),
(8740, '1290234489', '北京新圆明职业学院', 'http://www.ymyu.com/', 0, 0, 0, 4535, 0, 1, 0, NULL, 21, '', ''),
(8741, '1290234489', '北京交通职业技术学院', 'http://www.jtxy.com.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 22, '', ''),
(8742, '1290234489', '北京经贸职业学院', 'http://www.jmxyedu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 23, '', ''),
(8743, '1290234489', '北京京北职业技术学院', 'http://www.jbzy.com.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 24, '', ''),
(8744, '1290234489', '北京交通运输职业学院', 'http://www.bjjtxx.com/', 0, 0, 0, 4535, 0, 1, 0, NULL, 25, '', ''),
(8745, '1290234489', '首都师范大学科德学院', 'http://www.kdcnu.com/', 0, 0, 0, 4535, 0, 1, 0, NULL, 26, '', ''),
(8746, '1290234489', '北京工商大学嘉华学院', 'http://www.canvard.com.cn/index.php', 0, 0, 0, 4535, 0, 1, 0, NULL, 27, '', ''),
(8747, '1290234489', '北京邮电大学世纪学院', 'http://www.ccbupt.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 28, '', ''),
(8748, '1290234489', '北京工业大学耿丹学院', 'http://www.gengdan.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 29, '', ''),
(8749, '1290234489', '北京第二外国语学院中瑞酒店管理学院', 'http://www.bhi.edu.cn/', 0, 0, 0, 4535, 0, 1, 0, NULL, 30, '', ''),
(8750, '1290234489', '北京科技大学延庆分校', 'http://www.ustbyq.com/', 0, 0, 0, 4535, 0, 1, 0, NULL, 31, '', ''),
(8751, '1290234571', '南开大学', 'http://www.nankai.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 1, '', ''),
(8752, '1290234571', '天津大学', 'http://www.tju.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 2, '', ''),
(8753, '1290234571', '中国民航大学', 'http://www.cauc.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 3, '', ''),
(8754, '1290234571', '天津工业大学', 'http://www.tjpu.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 4, '', ''),
(8755, '1290234571', '天津科技大学', 'http://www.tust.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 5, '', ''),
(8756, '1290234571', '天津理工大学', 'http://www.tjut.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 6, '', ''),
(8757, '1290234571', '天津医科大学', 'http://www.tijmu.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 7, '', ''),
(8758, '1290234571', '天津中医药大学', 'http://www.tjutcm.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 8, '', ''),
(8759, '1290234571', '天津师范大学', 'http://www.tjnu.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 9, '', ''),
(8760, '1290234571', '天津职业技术师范大学', 'http://www.tute.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 10, '', ''),
(8761, '1290234571', '天津外国语大学', 'http://www.tjfsu.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 11, '', ''),
(8762, '1290234571', '天津财经大学', 'http://www.tjufe.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 12, '', ''),
(8763, '1290234571', '天津商业大学', 'http://www.tjcu.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 13, '', ''),
(8764, '1290234571', '天津天狮学院', 'http://www.tianshi.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 14, '', ''),
(8765, '1290234571', '天津城市建设学院', 'http://www.tjuci.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 15, '', ''),
(8766, '1290234571', '天津农学院', 'http://www.tjac.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 16, '', ''),
(8767, '1290234571', '天津体育学院', 'http://www.tjipe.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 17, '', ''),
(8768, '1290234571', '天津音乐学院', 'http://www.tjcm.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 18, '', ''),
(8769, '1290234571', '天津美术学院', 'http://www.tjarts.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 19, '', ''),
(8770, '1290234571', '天津医学高等专科学校', 'http://www.tjyzh.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 20, '', ''),
(8771, '1290234571', '天津职业大学', 'http://www.tjtc.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 21, '', ''),
(8772, '1290234571', '天津电子信息职业技术学院', 'http://www.tjdz.net/', 0, 0, 0, 4534, 0, 1, 0, NULL, 22, '', ''),
(8773, '1290234571', '天津滨海职业学院', 'http://www.tjbpi.com/', 0, 0, 0, 4534, 0, 1, 0, NULL, 23, '', ''),
(8774, '1290234571', '天津轻工职业技术学院', 'http://www.tjlivtc.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 24, '', ''),
(8775, '1290234571', '天津公安警官职业学院', 'http://www.tjjingyuan.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 25, '', ''),
(8776, '1290234571', '天津现代职业技术学院', 'http://www.xdxy.com.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 26, '', ''),
(8777, '1290234571', '天津机电职业技术学院', 'http://www.suoyuan.com.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 27, '', ''),
(8778, '1290234571', '天津工程职业技术学院', 'http://www.tjeti.com/', 0, 0, 0, 4534, 0, 1, 0, NULL, 28, '', ''),
(8779, '1290234571', '天津渤海职业技术学院', 'http://www.tjbhzy.net.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 29, '', ''),
(8780, '1290234571', '天津海运职业学院', 'http://www.tjhyzyxy.com/hyxy/', 0, 0, 0, 4534, 0, 1, 0, NULL, 30, '', ''),
(8781, '1290234571', '天津城市职业学院', 'http://www.tjcsxy.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 31, '', ''),
(8782, '1290234571', '天津石油职业技术学院', 'http://www.tjsyxy.com/main/', 0, 0, 0, 4534, 0, 1, 0, NULL, 32, '', ''),
(8783, '1290234571', '天津冶金职业技术学院', 'http://www.tjmvti.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 33, '', ''),
(8784, '1290234571', '天津交通职业学院', 'http://www.tjtvc.com/', 0, 0, 0, 4534, 0, 1, 0, NULL, 34, '', ''),
(8785, '1290234571', '天津铁道职业技术学院', 'http://www.tjtdxy.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 35, '', ''),
(8786, '1290234571', '天津生物工程职业技术学院', 'http://www.tjbio.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 36, '', ''),
(8787, '1290234571', '天津工艺美术职业学院', 'http://www.gmtj.com/zhaosheng/xyjj.htm', 0, 0, 0, 4534, 0, 1, 0, NULL, 37, '', ''),
(8788, '1290234571', '天津广播影视职业学院', 'http://www.tjgbys.com/', 0, 0, 0, 4534, 0, 1, 0, NULL, 38, '', ''),
(8789, '1290234571', '天津开发区职业技术学院', 'http://www.tedazj.com/', 0, 0, 0, 4534, 0, 1, 0, NULL, 39, '', ''),
(8790, '1290234571', '天津艺术职业学院', 'http://www.tjysxy.com/', 0, 0, 0, 4534, 0, 1, 0, NULL, 40, '', ''),
(8791, '1290234571', '天津国土资源和房屋职业学院', 'http://www.tjgsxy.com.cn/tjgfxy/', 0, 0, 0, 4534, 0, 1, 0, NULL, 41, '', ''),
(8792, '1290234571', '天津城市建设管理职业技术学院', 'http://www.tjchengjian.com/', 0, 0, 0, 4534, 0, 1, 0, NULL, 42, '', ''),
(8793, '1290234571', '天津中德职业技术学院', 'http://59.67.48.243/code/index3.asp', 0, 0, 0, 4534, 0, 1, 0, NULL, 43, '', ''),
(8794, '1290234571', '天津青年职业学院', 'http://www.tjqnzyxy.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 44, '', ''),
(8795, '1290234571', '天津对外经济贸易职业学院', 'http://www.tifert.edu.cn/portal/index.htm', 0, 0, 0, 4534, 0, 1, 0, NULL, 45, '', ''),
(8796, '1290234571', '南开大学滨海学院', 'http://binhai.nankai.edu.cn/script/binhai/', 0, 0, 0, 4534, 0, 1, 0, NULL, 46, '', ''),
(8797, '1290234571', '天津外国语大学滨海外事学院', 'http://bhws.tjfsu.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 47, '', ''),
(8798, '1290234571', '天津体育学院运动与文化艺术学院', 'http://www.tjtwy.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 48, '', ''),
(8799, '1290234571', '天津商业大学宝德学院', 'http://www.boustead.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 49, '', ''),
(8801, '1290234571', '北京科技大学天津学院', 'http://tj.ustb.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 51, '', ''),
(8802, '1290234571', '天津师范大学津沽学院', 'http://59.67.75.245/jingu', 0, 0, 0, 4534, 0, 1, 0, NULL, 52, '', ''),
(8803, '1290234571', '天津理工大学中环信息学院', 'http://www.tjzhic.com/', 0, 0, 0, 4534, 0, 1, 0, NULL, 53, '', ''),
(8804, '1290234571', '天津大学仁爱学院', 'http://www.tjrac.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 54, '', ''),
(8805, '1290234571', '天津财经大学珠江学院', 'http://zhujiang.tjufe.edu.cn/', 0, 0, 0, 4534, 0, 1, 0, NULL, 55, '', ''),
(8806, '1290234772', '华北科技学院', 'http://www.ncist.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 1, '', ''),
(8807, '1290234772', '防灾科技学院', 'http://www.fzxy.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 2, '', ''),
(8808, '1290234772', '中国人民武装警察部队学院', 'http://www.wjxy.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 3, '', ''),
(8809, '1290234772', '中央司法警官学院', 'http://www.cicp.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 4, '', ''),
(8810, '1290234772', '河北大学', 'http://www.hbu.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 5, '', ''),
(8811, '1290234772', '河北工业大学', 'http://www.hebut.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 6, '', ''),
(8812, '1290234772', '燕山大学', 'http://www.ysu.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 7, '', ''),
(8813, '1290234772', '河北联合大学（原河北理工大学）', 'http://www.heut.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 8, '', ''),
(8814, '1290234772', '河北科技大学', 'http://www.hebust.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 9, '', ''),
(8815, '1290234772', '河北工程大学', 'http://www.hebeu.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 10, '', ''),
(8816, '1290234772', '石家庄铁道大学', 'http://www.sjzri.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 11, '', ''),
(8817, '1290234772', '河北农业大学', 'http://www.hebau.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 12, '', ''),
(8818, '1290234772', '河北医科大学', 'http://www.hebmu.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 13, '', ''),
(8819, '1290234772', '河北师范大学', 'http://www.hebtu.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 14, '', ''),
(8820, '1290234772', '河北经贸大学', 'http://www.heuet.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 15, '', ''),
(8821, '1290234772', '石家庄经济学院', 'http://www.sjzue.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 16, '', ''),
(8822, '1290234772', '北华航天工业学院', 'http://www.nciae.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 17, '', ''),
(8823, '1290234772', '承德医学院', 'http://www.cdmc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 18, '', ''),
(8824, '1290234772', '廊坊师范学院', 'http://www.lfsfxy.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 19, '', ''),
(8825, '1290234772', '河北民族师范学院', 'http://www.hbun.net/', 0, 0, 0, 4533, 0, 1, 0, NULL, 20, '', ''),
(8826, '1290234772', '唐山师范学院', 'http://www2.tstc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 21, '', ''),
(8827, '1290234772', '河北科技师范学院', 'http://www.hevttc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 22, '', ''),
(8828, '1290234772', '邢台学院', 'http://www.xttc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 23, '', ''),
(8829, '1290234772', '河北金融学院', 'http://www.bdcf.net/', 0, 0, 0, 4533, 0, 1, 0, NULL, 24, '', ''),
(8830, '1290234772', '河北体育学院', 'http://www.hepec.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 25, '', ''),
(8831, '1290234772', '河北传媒学院', 'http://www.hebic.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 26, '', ''),
(8832, '1290234772', '保定学院', 'http://www.bdu.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 27, '', ''),
(8833, '1290234772', '河北北方学院', 'http://www.hebeinu.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 28, '', ''),
(8834, '1290234772', '邯郸学院', 'http://www.hdc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 29, '', ''),
(8835, '1290234772', '唐山学院', 'http://www.tsc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 30, '', ''),
(8836, '1290234772', '石家庄学院', 'http://www.sjzc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 31, '', ''),
(8837, '1290234772', '沧州医学高等专科学校', 'http://www.czmc.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 32, '', ''),
(8838, '1290234772', '河北工程技术高等专科学校', 'http://www.hbgz.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 33, '', ''),
(8839, '1290234772', '承德石油高等专科学校', 'http://www.cdpc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 34, '', ''),
(8840, '1290234772', '石家庄医学高等专科学校', 'http://www.sjzmc.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 35, '', ''),
(8841, '1290234772', '邢台医学高等专科学校', 'http://www.xtmc.net/', 0, 0, 0, 4533, 0, 1, 0, NULL, 36, '', ''),
(8842, '1290234772', '石家庄人民医学高等专科学校', 'http://www.sjzrmyz.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 37, '', ''),
(8843, '1290234772', '河北化工医药职业技术学院', 'http://www.hebcpc.cn/template/mainpage01.asp', 0, 0, 0, 4533, 0, 1, 0, NULL, 38, '', ''),
(8844, '1290234772', '沧州职业技术学院', 'http://www.czvtc.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 39, '', ''),
(8845, '1290234772', '石家庄铁路职业技术学院', 'http://www.sirt.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 40, '', ''),
(8846, '1290234772', '张家口职业技术学院', 'http://www.zhz.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 41, '', ''),
(8847, '1290234772', '河北工业职业技术学院', 'http://www.hbcit.edu.cn/new/', 0, 0, 0, 4533, 0, 1, 0, NULL, 42, '', ''),
(8848, '1290234772', '河北能源职业技术学院', 'http://www.hbnyxy.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 43, '', ''),
(8849, '1290234772', '保定职业技术学院', 'http://www.bvtc.com.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 44, '', ''),
(8850, '1290234772', '石家庄职业技术学院', 'http://www.sjzpt.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 45, '', ''),
(8851, '1290234772', '邢台职业技术学院', 'http://www.xpc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 46, '', ''),
(8852, '1290234772', '邯郸职业技术学院', 'http://www.hd-u.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 47, '', ''),
(8853, '1290234772', '石家庄计算机职业学院', 'http://www.sjzcvc.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 48, '', ''),
(8854, '1290234772', '河北建材职业技术学院', 'http://www.hbjcxy.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 49, '', ''),
(8855, '1290234772', '石家庄邮电职业技术学院', 'http://www.sjzpc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 50, '', ''),
(8856, '1290234772', '河北女子职业技术学院', 'http://www.hebnzxy.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 51, '', ''),
(8857, '1290234772', '泊头职业学院', 'http://222.223.57.197:8080/', 0, 0, 0, 4533, 0, 1, 0, NULL, 52, '', ''),
(8858, '1290234772', '渤海石油职业学院', 'http://www.bhsyxy.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 53, '', ''),
(8859, '1290234772', '唐山科技职业技术学院', 'http://www.tskjzy.cn/index.do?templet=index', 0, 0, 0, 4533, 0, 1, 0, NULL, 54, '', ''),
(8860, '1290234772', '河北机电职业技术学院', 'http://www.hbjd.com.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 55, '', ''),
(8861, '1290234772', '保定电力职业技术学院', 'http://www.bddy.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 56, '', ''),
(8862, '1290234772', '廊坊职业技术学院', 'http://www.lfzhjxy.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 57, '', ''),
(8863, '1290234772', '石家庄科技工程职业学院', 'http://www.zdsf.net/', 0, 0, 0, 4533, 0, 1, 0, NULL, 58, '', ''),
(8864, '1290234772', '冀中职业学院', 'http://www.jzhxy.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 59, '', ''),
(8865, '1290234772', '石家庄外事职业学院', 'http://www.wsxy.net/', 0, 0, 0, 4533, 0, 1, 0, NULL, 60, '', ''),
(8866, '1290234772', '河北政法职业学院', 'http://www.helc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 61, '', ''),
(8867, '1290234772', '河北旅游职业学院', 'http://www.cdtvc.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 62, '', ''),
(8868, '1290234772', '河北公安警察职业学院', 'http://www.hebsjy.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 63, '', ''),
(8869, '1290234772', '廊坊东方职业技术学院', 'http://www.dfzyxy.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 64, '', ''),
(8870, '1290234772', '河北省艺术职业学院', 'http://www.hebart.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 65, '', ''),
(8871, '1290234772', '宣化科技职业学院', 'http://www.xhkjzyxy.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 66, '', ''),
(8872, '1290234772', '石家庄东方美术职业学院', 'http://www.oafa.com.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 67, '', ''),
(8873, '1290234772', '石家庄外经贸职业学院', 'http://www.sjzwjm.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 68, '', ''),
(8874, '1290234772', '石家庄信息工程职业学院', 'http://www.sjziei.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 69, '', ''),
(8875, '1290234772', '河北交通职业技术学院', 'http://www.hejtxy.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 70, '', ''),
(8876, '1290234772', '石家庄理工职业学院', 'http://61.182.226.208/', 0, 0, 0, 4533, 0, 1, 0, NULL, 71, '', ''),
(8877, '1290234772', '河北外国语职业学院', 'http://www.hbvcfl.com.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 72, '', ''),
(8878, '1290234772', '石家庄科技职业学院', 'http://www.sjzkjxy.net/', 0, 0, 0, 4533, 0, 1, 0, NULL, 73, '', ''),
(8879, '1290234772', '河北司法警官职业学院', 'http://www.jjgxy.com.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 74, '', ''),
(8880, '1290234772', '河北劳动关系职业学院', 'http://www.hbgy.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 75, '', ''),
(8881, '1290234772', '河北石油职业技术学院', 'http://www.pvtc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 76, '', ''),
(8882, '1290234772', '秦皇岛职业技术学院', 'http://www.qhdvtc.com/hbzj/index.jsp', 0, 0, 0, 4533, 0, 1, 0, NULL, 77, '', ''),
(8883, '1290234772', '河北软件职业技术学院', 'http://www.hbsi.com.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 78, '', ''),
(8884, '1290234772', '石家庄外国语职业学院', 'http://www.sjzwgyxy.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 79, '', ''),
(8885, '1290234772', '唐山职业技术学院', 'http://www.tsvtc.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 80, '', ''),
(8886, '1290234772', '保定科技职业学院', 'http://www.hbkjxy.cn/xsnews/kj_sy.asp', 0, 0, 0, 4533, 0, 1, 0, NULL, 81, '', ''),
(8887, '1290234772', '唐山工业职业技术学院', 'http://www.tsgzy.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 82, '', ''),
(8888, '1290234772', '石家庄外语翻译职业学院', 'http://www.hbwy.com.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 83, '', ''),
(8889, '1290234772', '石家庄工商职业学院', 'http://www.sjzgsxy.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 84, '', ''),
(8890, '1290234772', '石家庄法商职业学院', 'http://www.hbfsh.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 85, '', ''),
(8891, '1290234772', '廊坊燕京职业技术学院', 'http://www.lfyjzjxy.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 86, '', ''),
(8892, '1290234772', '承德护理职业学院', 'http://www.cdwx.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 87, '', ''),
(8893, '1290234772', '河北理工大学轻工学院', 'http://qgxy.heut.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 88, '', ''),
(8894, '1290234772', '河北工程大学科信学院', 'http://kexin.hebeu.edu.cn/default.asp', 0, 0, 0, 4533, 0, 1, 0, NULL, 89, '', ''),
(8895, '1290234772', '华北电力大学科技学院', 'http://www.hdky.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 90, '', ''),
(8896, '1290234772', '河北科技大学理工学院', 'http://hbklg.hebust.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 91, '', ''),
(8897, '1290234772', '河北大学工商学院', 'http://www.hicc.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 92, '', ''),
(8898, '1290234772', '河北师范大学汇华学院', 'http://huihua.hebtu.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 93, '', ''),
(8899, '1290234772', '河北医科大学临床学院', 'http://202.206.48.102/', 0, 0, 0, 4533, 0, 1, 0, NULL, 94, '', ''),
(8900, '1290234772', '河北经贸大学经济管理学院', 'http://202.206.206.251/', 0, 0, 0, 4533, 0, 1, 0, NULL, 95, '', ''),
(8901, '1290234772', '河北工业大学城市学院', 'http://cc.hebut.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 96, '', ''),
(8902, '1290234772', '燕山大学里仁学院', 'http://stc.ysu.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 97, '', ''),
(8903, '1290234772', '华北煤炭医学院冀唐学院', 'http://jitang.ncmc.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 98, '', ''),
(8904, '1290234772', '北京化工大学北方学院', 'http://www.buctedu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 99, '', ''),
(8905, '1290234772', '北京中医药大学东方学院', 'http://www.df-college.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 100, '', ''),
(8906, '1290234772', '北京交通大学海滨学院', 'http://www.bjtuhbxy.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 101, '', ''),
(8907, '1290234772', '张家口教育学院', 'http://www.zjkjyxy.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 102, '', ''),
(8908, '1290234772', '石家庄职工大学', 'http://sjzzgdx.he.edu.cn/', 0, 0, 0, 4533, 0, 1, 0, NULL, 103, '', ''),
(8909, '1290234772', '中国环境管理干部学院', 'http://www.emcc.cn/web/', 0, 0, 0, 4533, 0, 1, 0, NULL, 104, '', ''),
(8910, '1290234772', '河北青年管理干部学院', 'http://www.hbqgy.cn/index.php', 0, 0, 0, 4533, 0, 1, 0, NULL, 105, '', ''),
(8911, '1290234772', '河北地质职工大学', 'http://www.dkyaolan.com/', 0, 0, 0, 4533, 0, 1, 0, NULL, 106, '', ''),
(8912, '1290234863', '吉林大学', 'http://www.jlu.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 1, '', ''),
(8913, '1290234863', '东北师范大学', 'http://www.nenu.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 2, '', ''),
(8914, '1290234863', '北华大学', 'http://www.beihua.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 3, '', ''),
(8915, '1290234863', '吉林师范大学', 'http://www.jlnu.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 4, '', ''),
(8916, '1290234863', '延边大学', 'http://www.ybu.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 5, '', ''),
(8917, '1290234863', '吉林财经大学', 'http://www.ctu.cc.jl.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 6, '', ''),
(8918, '1290234863', '东北电力大学', 'http://www.nedu.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 7, '', ''),
(8919, '1290234863', '长春工程学院', 'http://www.ccit.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 8, '', ''),
(8920, '1290234863', '吉林化工学院', 'http://www.jlict.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 9, '', ''),
(8921, '1290234863', '长春师范学院', 'http://www.cncnc.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 10, '', ''),
(8922, '1290234863', '吉林工程技术师范学院', 'http://www.jltiet.net/', 0, 0, 0, 4532, 0, 1, 0, NULL, 11, '', ''),
(8923, '1290234863', '吉林建筑工程学院', 'http://www.jliae.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 12, '', ''),
(8924, '1290234863', '长春工业大学', 'http://www.ccut.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 13, '', ''),
(8925, '1290234863', '长春中医药大学', 'http://www.ccucm.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 14, '', ''),
(8926, '1290234863', '通化师范学院', 'http://www.thnu.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 15, '', ''),
(8927, '1290234863', '吉林华桥外国语学院', 'http://www.hqwy.com/', 0, 0, 0, 4532, 0, 1, 0, NULL, 16, '', ''),
(8928, '1290234863', '吉林医药学院', 'http://www.jlmpc.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 17, '', ''),
(8929, '1290234863', '白城师范学院', 'http://www.bcsfxy.com/', 0, 0, 0, 4532, 0, 1, 0, NULL, 18, '', ''),
(8930, '1290234863', '吉林艺术学院', 'http://www.jlart.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 19, '', ''),
(8931, '1290234863', '吉林农业科技学院', 'http://www.jlnku.com/', 0, 0, 0, 4532, 0, 1, 0, NULL, 20, '', ''),
(8932, '1290234863', '吉林工商学院', 'http://www.jlbtc.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 21, '', ''),
(8933, '1290234863', '长春理工大学', 'http://www.cust.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 22, '', ''),
(8934, '1290234863', '吉林动画学院', 'http://www.jldh.com.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 23, '', ''),
(8935, '1290234863', '长春大学', 'http://www.ccu-edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 24, '', ''),
(8936, '1290234863', '吉林警察学院', 'http://www.jlgazk.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 25, '', ''),
(8937, '1290234863', '吉林体育学院', 'http://www.jlty.com.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 26, '', ''),
(8938, '1290234863', '白城医学高等专科学校', 'http://www.bcyz.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 27, '', ''),
(8939, '1290234863', '长春汽车工业高等专科学校', 'http://www.caii.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 28, '', ''),
(8940, '1290234863', '长春医学高等专科学校', 'http://www.cmcedu.com/', 0, 0, 0, 4532, 0, 1, 0, NULL, 29, '', ''),
(8941, '1290234863', '长春金融高等专科学校', 'http://www.cjgz.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 30, '', ''),
(8942, '1290234863', '吉林交通职业技术学院', 'http://www.jjtc.com.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 31, '', ''),
(8943, '1290234863', '辽源职业技术学院', 'http://www.lyvtc.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 32, '', ''),
(8944, '1290234863', '四平职业大学', 'http://www.jlsppc.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 33, '', ''),
(8945, '1290234863', '松原职业技术学院', 'http://www.sypt.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 34, '', ''),
(8946, '1290234863', '吉林农业工程职业技术学院', 'http://www.jlnyxy.com.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 35, '', ''),
(8947, '1290234863', '白城职业技术学院', 'http://www.bcvit.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 36, '', ''),
(8948, '1290234863', '吉林司法警官职业学院', 'http://www.jlsfjx.com/', 0, 0, 0, 4532, 0, 1, 0, NULL, 37, '', ''),
(8949, '1290234863', '长春信息技术职业学院', 'http://www.citpc.net/', 0, 0, 0, 4532, 0, 1, 0, NULL, 38, '', ''),
(8950, '1290234863', '吉林电子信息职业技术学院', 'http://www.jltc.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 39, '', ''),
(8951, '1290234863', '吉林工业职业技术学院', 'http://www.jvcit.edu.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 40, '', ''),
(8952, '1290234863', '长白山职业技术学院', 'http://www.cbsvtc.com.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 41, '', ''),
(8953, '1290234863', '长春职业技术学院', 'http://www.cvit.com.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 42, '', ''),
(8954, '1290234863', '吉林铁道职业技术学院', 'http://www.jtpt.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 43, '', ''),
(8955, '1290234863', '吉林科技职业技术学院', 'http://www.jilinkj.com/', 0, 0, 0, 4532, 0, 1, 0, NULL, 44, '', ''),
(8956, '1290234863', '吉林建筑工程学院建筑装饰学院', 'http://www.jladi.com/', 0, 0, 0, 4532, 0, 1, 0, NULL, 45, '', ''),
(8957, '1290234863', '吉林建筑工程学院城建学院', 'http://www.jlucc.net:8080/opencms/', 0, 0, 0, 4532, 0, 1, 0, NULL, 46, '', ''),
(8958, '1290234863', '长春大学光华学院', 'http://www.ccughc.net/', 0, 0, 0, 4532, 0, 1, 0, NULL, 47, '', ''),
(8959, '1290234863', '长春工业大学人文信息学院', 'http://www.ccutchi.com/', 0, 0, 0, 4532, 0, 1, 0, NULL, 48, '', ''),
(8960, '1290234863', '长春理工大学光电信息学院', 'http://www.csoei.com/', 0, 0, 0, 4532, 0, 1, 0, NULL, 49, '', ''),
(8961, '1290234863', '吉林财经大学信息经济学院', 'http://www.iecctc.com/', 0, 0, 0, 4532, 0, 1, 0, NULL, 50, '', ''),
(8962, '1290234863', '吉林农业大学发展学院', 'http://www.jlaudev.com.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 51, '', ''),
(8963, '1290234863', '吉林师范大学博达学院', 'http://www.bdxy.com.cn/', 0, 0, 0, 4532, 0, 1, 0, NULL, 52, '', ''),
(8964, '1290234863', '长春大学旅游学院', 'http://www.cctourcollege.com/', 0, 0, 0, 4532, 0, 1, 0, NULL, 53, '', ''),
(8965, '1290234863', '吉林省教育学院', 'http://www.jledu.net/', 0, 0, 0, 4532, 0, 1, 0, NULL, 54, '', ''),
(8966, '1290234863', '吉林省经济管理干部学院', 'http://www.jemcc.net/', 0, 0, 0, 4532, 0, 1, 0, NULL, 55, '', ''),
(8967, '1290234942', '内蒙古大学', 'http://www.imu.edu.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 1, '', ''),
(8968, '1290234942', '内蒙古科技大学', 'http://www.imust.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 2, '', ''),
(8969, '1290234942', '内蒙古民族大学', 'http://www.imun.edu.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 3, '', ''),
(8970, '1290234942', '内蒙古工业大学', 'http://www.imut.edu.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 4, '', ''),
(8971, '1290234942', '内蒙古农业大学', 'http://www.imau.edu.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 5, '', ''),
(8972, '1290234942', '内蒙古师范大学', 'http://www.imnu.edu.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 6, '', ''),
(8973, '1290234942', '内蒙古医学院', 'http://www.immc.edu.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 7, '', ''),
(8974, '1290234942', '赤峰学院', 'http://www.cfxy.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 8, '', ''),
(8975, '1290234942', '呼和浩特民族学院', 'http://www.imnc.edu.cn/web/', 0, 0, 0, 4531, 0, 1, 0, NULL, 9, '', ''),
(8976, '1290234942', '集宁师范学院', 'http://www.jntc.nm.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 10, '', ''),
(8977, '1290234942', '呼伦贝尔学院', 'http://www.hlbrc.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 11, '', ''),
(8978, '1290234942', '内蒙古财经学院', 'http://www.imfec.edu.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 12, '', ''),
(8979, '1290234942', '乌兰察布医学高等专科学校', 'http://www.wlcbswx.com/', 0, 0, 0, 4531, 0, 1, 0, NULL, 13, '', ''),
(8980, '1290234942', '河套大学', 'http://www.hetaodaxue.com/', 0, 0, 0, 4531, 0, 1, 0, NULL, 14, '', ''),
(8981, '1290234942', '包头职业技术学院', 'http://www.imun.edu.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 15, '', ''),
(8982, '1290234942', '内蒙古建筑职业技术学院', 'http://www.imaa.edu.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 16, '', ''),
(8983, '1290234942', '内蒙古机电职业技术学院', 'http://www.nmgjdxy.com/', 0, 0, 0, 4531, 0, 1, 0, NULL, 17, '', ''),
(8984, '1290234942', '赤峰职业技术学院', 'http://www.cfzyjsxy.com/', 0, 0, 0, 4531, 0, 1, 0, NULL, 18, '', ''),
(8985, '1290234942', '内蒙古北方职业技术学院', 'http://www.nmbfxy.com/index.asp', 0, 0, 0, 4531, 0, 1, 0, NULL, 19, '', ''),
(8986, '1290234942', '内蒙古交通职业技术学院', 'http://www.nmjtzy.com/', 0, 0, 0, 4531, 0, 1, 0, NULL, 20, '', ''),
(8987, '1290234942', '内蒙古科技职业学院', 'http://www.imstu.org.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 21, '', ''),
(8988, '1290234942', '内蒙古商贸职业学院', 'http://www.imvcc.com/', 0, 0, 0, 4531, 0, 1, 0, NULL, 22, '', ''),
(8989, '1290234942', '内蒙古化工职业学院', 'http://www.hgzyxy.com/', 0, 0, 0, 4531, 0, 1, 0, NULL, 23, '', ''),
(8990, '1290234942', '乌海职业技术学院', 'http://www.whvtc.net/', 0, 0, 0, 4531, 0, 1, 0, NULL, 24, '', ''),
(8991, '1290234942', '呼和浩特职业学院', 'http://www.hhvc.net.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 25, '', ''),
(8992, '1290234942', '内蒙古经贸外语职业学院', 'http://www.nmgjwy.com/', 0, 0, 0, 4531, 0, 1, 0, NULL, 26, '', ''),
(8993, '1290234942', '内蒙古电子信息职业技术学院', 'http://www.imeic.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 27, '', ''),
(11019, '1290239043', '北京招聘会信息', 'http://zhidao.baidu.com/q?word=%B1%B1%BE%A9++%D5%D0%C6%B8%BB%E1&amp;amp;ct=17&amp;amp;pn=0&amp;amp;tn=ikaslist&amp;amp;rn=10', 0, 0, 0, 4565, 0, 1, 0, NULL, 8, '', ''),
(8995, '1290234942', '包头铁道职业技术学院', 'http://www.bttzy.com/', 0, 0, 0, 4531, 0, 1, 0, NULL, 29, '', ''),
(8996, '1290234942', '锡林郭勒职业学院', 'http://www.xlglvc.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 30, '', ''),
(8997, '1290234942', '包头钢铁职业技术学院', 'http://www.btsvc.net/', 0, 0, 0, 4531, 0, 1, 0, NULL, 31, '', ''),
(8998, '1290234942', '乌兰察布职业学院', 'http://www.wlcbzyxy.com.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 32, '', ''),
(8999, '1290234942', '通辽职业学院', 'http://www.tlzyxy.com/', 0, 0, 0, 4531, 0, 1, 0, NULL, 33, '', ''),
(9000, '1290234942', '包头轻工职业技术学院', 'http://www.btqy.com.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 34, '', ''),
(9001, '1290234942', '兴安职业技术学院', 'http://www.nmxzy.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 35, '', ''),
(9002, '1290234942', '鄂尔多斯职业学院', 'http://www.ordosvc.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 36, '', ''),
(9003, '1290234942', '内蒙古警察职业学院', 'http://www.imppc.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 37, '', ''),
(9004, '1290234942', '内蒙古体育职业学院', 'http://www.nmtyxy.com/jxjyc_tz.php', 0, 0, 0, 4531, 0, 1, 0, NULL, 38, '', ''),
(9005, '1290234942', '内蒙古丰州职业学院', 'http://www.qcdx.net/', 0, 0, 0, 4531, 0, 1, 0, NULL, 39, '', ''),
(9006, '1290234942', '内蒙古轩元职业学院', 'http://www.nmshangfa.cn/Index.html', 0, 0, 0, 4531, 0, 1, 0, NULL, 40, '', ''),
(9007, '1290234942', '内蒙古大学创业学院', 'http://www.imuchuangye.cn/', 0, 0, 0, 4531, 0, 1, 0, NULL, 41, '', ''),
(9008, '1290234942', '内蒙古师范大学鸿德学院', 'http://www.honder.com/new/', 0, 0, 0, 4531, 0, 1, 0, NULL, 42, '', ''),
(9009, '1290235094', '山西大学', 'http://www.sxu.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 1, '', ''),
(9010, '1290235094', '太原理工大学', 'http://www.tyut.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 2, '', ''),
(9011, '1290235094', '中北大学', 'http://www.nuc.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 3, '', ''),
(9012, '1290235094', '太原科技大学', 'http://www.tyust.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 4, '', ''),
(9013, '1290235094', '山西农业大学', 'http://www.sxau.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 5, '', ''),
(9014, '1290235094', '山西医科大学', 'http://www.sxmu.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 6, '', ''),
(9015, '1290235094', '山西师范大学', 'http://www.sxnu.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 7, '', ''),
(9016, '1290235094', '山西大同大学', 'http://www.sxdtdx.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 8, '', ''),
(9017, '1290235094', '山西财经大学', 'http://www.sxufe.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 9, '', ''),
(9018, '1290235094', '太原工业学院', 'http://www.tit.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 10, '', ''),
(9019, '1290235094', '长治医学院', 'http://www.czmc.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 11, '', ''),
(9020, '1290235094', '山西中医学院', 'http://www.sxtcm.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 12, '', ''),
(9021, '1290235094', '太原师范学院', 'http://www.tynu.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 13, '', ''),
(9022, '1290235094', '长治学院', 'http://czxy.sxbys.com.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 14, '', ''),
(9023, '1290235094', '吕梁学院', 'http://www.llhc.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 15, '', ''),
(9024, '1290235094', '晋中学院', 'http://www.sxjztc.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 16, '', ''),
(9025, '1290235094', '忻州师范学院', 'http://www.xztc.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 17, '', ''),
(9026, '1290235094', '运城学院', 'http://www.ycu.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 18, '', ''),
(9027, '1290235094', '太原电力高等专科学校', 'http://www.sxuec.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 19, '', ''),
(9028, '1290235094', '晋中师范高等专科学校', 'http://www.sxjzsf.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 20, '', ''),
(9029, '1290235094', '阳泉师范高等专科学校', 'http://www.sxyqsz.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 21, '', ''),
(9030, '1290235094', '运城幼儿师范高等专科学校', 'http://www.sxycys.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 22, '', ''),
(9031, '1290235094', '山西省财政税务专科学校', 'http://www.sxftc.edu.cn/newpage/home.php', 0, 0, 0, 4530, 0, 1, 0, NULL, 23, '', ''),
(9032, '1290235094', '山西警官高等专科学校', 'http://www.sxpu.com.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 24, '', ''),
(9033, '1290235094', '太原大学', 'http://www.sxtyu.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 25, '', ''),
(9034, '1290235094', '山西警官职业学院', 'http://www.sxpolice.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 26, '', ''),
(9035, '1290235094', '山西运城农业职业技术学院', 'http://www.sycnxy.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 27, '', ''),
(9036, '1290235094', '晋中职业技术学院', 'http://www.jzzy.sx.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 28, '', ''),
(9037, '1290235094', '山西国际商务职业学院', 'http://www.sxibs.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 29, '', ''),
(9038, '1290235094', '山西体育职业学院', 'http://www.sxptc.com/index.asp', 0, 0, 0, 4530, 0, 1, 0, NULL, 30, '', ''),
(9039, '1290235094', '山西旅游职业学院', 'http://www.sxtvi.com.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 31, '', ''),
(9040, '1290235094', '山西华澳商贸职业学院', 'http://www.huaao.sx.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 32, '', ''),
(9041, '1290235094', '山西管理职业学院', 'http://www.sxglzyxy.com.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 33, '', ''),
(9042, '1290235094', '运城职业技术学院', 'http://115.24.28.1/', 0, 0, 0, 4530, 0, 1, 0, NULL, 34, '', ''),
(9043, '1290235094', '山西戏剧职业学院', 'http://www.shanxixjxy.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 35, '', ''),
(9044, '1290235094', '山西财贸职业技术学院', 'http://www.sxcmvc.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 36, '', ''),
(9045, '1290235094', '山西林业职业技术学院', 'http://www.sxly.com.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 37, '', ''),
(9046, '1290235094', '山西水利职业技术学院', 'http://www.sxsy.com.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 38, '', ''),
(9047, '1290235094', '阳泉职业技术学院', 'http://www.tyutyqc.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 39, '', ''),
(9048, '1290235094', '山西轻工职业技术学院', 'http://www.sxqgzy.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 40, '', ''),
(9049, '1290235094', '山西信息职业技术学院', 'http://www.vcit.cn/Index.html', 0, 0, 0, 4530, 0, 1, 0, NULL, 41, '', ''),
(9050, '1290235094', '晋城职业技术学院', 'http://jczy.sxbys.com.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 42, '', ''),
(9051, '1290235094', '山西机电职业技术学院', 'http://www.sxjdxy.org/', 0, 0, 0, 4530, 0, 1, 0, NULL, 43, '', ''),
(9052, '1290235094', '大同煤炭职业技术学院', 'http://www.zgxzw.com/school/school.asp?id=169', 0, 0, 0, 4530, 0, 1, 0, NULL, 44, '', ''),
(9053, '1290235094', '太原旅游职业学院', 'http://www.tylyzyxy.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 45, '', ''),
(9054, '1290235094', '山西工商职业学院', 'http://www.sxtbu.net/', 0, 0, 0, 4530, 0, 1, 0, NULL, 46, '', ''),
(9055, '1290235094', '山西老区职业技术学院', 'http://www.sxlqzy.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 47, '', ''),
(9056, '1290235094', '临汾职业技术学院', 'http://www.lfvtc.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 48, '', ''),
(9057, '1290235094', '山西煤炭职业技术学院', 'http://www.sxmtxy.com.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 49, '', ''),
(9058, '1290235094', '太原城市职业技术学院', 'http://www.cntcvc.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 50, '', ''),
(9059, '1290235094', '山西金融职业学院', 'http://www.sxjrzyxy.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 51, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(9060, '1290235094', '山西职业技术学院', 'http://www.sxzzy.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 52, '', ''),
(9061, '1290235094', '山西电力职业技术学院', 'http://www.vtep.edu.cn/homepage/dlxyww/', 0, 0, 0, 4530, 0, 1, 0, NULL, 53, '', ''),
(9062, '1290235094', '长治职业技术学院', 'http://www.czzy.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 54, '', ''),
(9063, '1290235094', '山西交通职业技术学院', 'http://www.sxjt.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 55, '', ''),
(9064, '1290235094', '山西建筑职业技术学院', 'http://www.sxatc.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 56, '', ''),
(9065, '1290235094', '山西生物应用职业技术学院', 'http://www.sxbac.net.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 57, '', ''),
(9066, '1290235094', '山西工程职业技术学院', 'http://www.sxgy.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 58, '', ''),
(9067, '1290235094', '山西兴华职业学院', 'http://www.xzzsks.com.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 59, '', ''),
(9068, '1290235094', '山西经贸职业学院', 'http://www.sxemc.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 60, '', ''),
(9069, '1290235094', '朔州职业技术学院', 'http://www.szvtc.sx.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 61, '', ''),
(9070, '1290235094', '山西同文外语职业学院', 'http://www.sxtwedu.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 62, '', ''),
(9071, '1290235094', '山西大学商务学院', 'http://www.sdsy.sxu.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 63, '', ''),
(9072, '1290235094', '太原理工大学现代科技学院', 'http://www.xdkj.tyut.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 64, '', ''),
(9073, '1290235094', '山西农业大学信息学院', 'http://www1.sxau.edu.cn/xxxy/', 0, 0, 0, 4530, 0, 1, 0, NULL, 65, '', ''),
(9074, '1290235094', '山西师范大学现代文理学院', 'http://itblog.sxnu.edu.cn/change/xyxs/xdwlxy/index.htm', 0, 0, 0, 4530, 0, 1, 0, NULL, 66, '', ''),
(9075, '1290235094', '中北大学信息商务学院', 'http://xxsw.nuc.edu.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 67, '', ''),
(11018, '1290239043', '顺义人才网', 'http://www.shyrc.com/', 0, 0, 0, 4565, 0, 1, 0, NULL, 7, '', ''),
(9077, '1290235094', '山西医科大学晋祠学院', 'http://www.sxmu-jcc.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 69, '', ''),
(9078, '1290235094', '山西财经大学华商学院', 'http://www.schsxy.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 70, '', ''),
(9079, '1290235094', '广播电影电视管理干部学院', 'http://www.arft.net/', 0, 0, 0, 4530, 0, 1, 0, NULL, 71, '', ''),
(9080, '1290235094', '山西职工医学院', 'http://www.sxzgyxy.com/', 0, 0, 0, 4530, 0, 1, 0, NULL, 72, '', ''),
(9081, '1290235094', '山西煤炭管理干部学院', 'http://www.sxmtxy.net/', 0, 0, 0, 4530, 0, 1, 0, NULL, 73, '', ''),
(9082, '1290235094', '山西青年管理干部学院', 'http://www.sxqgy.cn/web/', 0, 0, 0, 4530, 0, 1, 0, NULL, 74, '', ''),
(9083, '1290235094', '山西政法管理干部学院', 'http://zfgl.sxbys.com.cn/', 0, 0, 0, 4530, 0, 1, 0, NULL, 75, '', ''),
(9084, '1290235161', '大连理工大学', 'http://www.dlut.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 1, '', ''),
(9085, '1290235161', '东北大学', 'http://www.neu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 2, '', ''),
(9086, '1290235161', '大连海事大学', 'http://www.dlmu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 3, '', ''),
(9087, '1290235161', '中国刑事警察学院', 'http://www.ccpc.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 4, '', ''),
(9088, '1290235161', '大连民族学院', 'http://www.dlnu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 5, '', ''),
(9089, '1290235161', '辽宁大学', 'http://www.lnu.edu.cn/lndx/index.jsp', 0, 0, 0, 4529, 0, 1, 0, NULL, 6, '', ''),
(9090, '1290235161', '沈阳大学', 'http://www.syu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 7, '', ''),
(9091, '1290235161', '大连大学', 'http://www.dlu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 8, '', ''),
(9092, '1290235161', '沈阳理工大学', 'http://www.sylu.edu.cn/sylgdx_new/default.php', 0, 0, 0, 4529, 0, 1, 0, NULL, 9, '', ''),
(9093, '1290235161', '辽宁工程技术大学', 'http://www.lntu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 10, '', ''),
(9094, '1290235161', '沈阳工业大学', 'http://www.sut.edu.cn/index.html', 0, 0, 0, 4529, 0, 1, 0, NULL, 11, '', ''),
(9095, '1290235161', '沈阳建筑大学', 'http://www.sjzu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 12, '', ''),
(9096, '1290235161', '辽宁石油化工大学', 'http://www.lnpu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 13, '', ''),
(9097, '1290235161', '大连交通大学', 'http://www.djtu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 14, '', ''),
(9098, '1290235161', '沈阳化工大学', 'http://www.syuct.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 15, '', ''),
(9099, '1290235161', '辽宁科技大学', 'http://www.asust.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 16, '', ''),
(9100, '1290235161', '大连工业大学', 'http://www.dlpu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 17, '', ''),
(9101, '1290235161', '辽宁工业大学', 'http://www.lnit.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 18, '', ''),
(9102, '1290235161', '沈阳航空航天大学', 'http://www.syiae.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 19, '', ''),
(9103, '1290235161', '沈阳农业大学', 'http://www.syau.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 20, '', ''),
(9104, '1290235161', '大连海洋大学', 'http://www.dlfu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 21, '', ''),
(9105, '1290235161', '中国医科大学', 'http://www.cmu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 22, '', ''),
(9106, '1290235161', '大连医科大学', 'http://www.dlmedu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 23, '', ''),
(9107, '1290235161', '辽宁中医药大学', 'http://www.lnutcm.edu.cn/cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 24, '', ''),
(9108, '1290235161', '沈阳药科大学', 'http://www.syphu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 25, '', ''),
(9109, '1290235161', '辽宁师范大学', 'http://www.lnnu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 26, '', ''),
(9110, '1290235161', '沈阳师范大学', 'http://www.synu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 27, '', ''),
(9111, '1290235161', '渤海大学', 'http://www.jznu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 28, '', ''),
(9112, '1290235161', '东北财经大学', 'http://www.dufe.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 29, '', ''),
(9113, '1290235161', '沈阳工程学院', 'http://www.sie.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 30, '', ''),
(9114, '1290235161', '辽宁科技学院', 'http://www.lnist.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 31, '', ''),
(9115, '1290235161', '大连东软信息学院', 'http://www.neusoft.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 32, '', ''),
(9116, '1290235161', '辽宁医学院', 'http://www.jzmu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 33, '', ''),
(9117, '1290235161', '沈阳医学院', 'http://www.symc.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 34, '', ''),
(9118, '1290235161', '鞍山师范学院', 'http://www.asnc.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 35, '', ''),
(9119, '1290235161', '大连外国语学院', 'http://www.dlufl.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 36, '', ''),
(9120, '1290235161', '辽宁财贸学院', 'http://www.lncmxy.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 37, '', ''),
(9121, '1290235161', '沈阳体育学院', 'http://www.syty.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 38, '', ''),
(9122, '1290235161', '鲁迅美术学院', 'http://www.lumei.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 39, '', ''),
(9123, '1290235161', '沈阳音乐学院', 'http://www.sycm.com.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 40, '', ''),
(9125, '1290235161', '辽东学院', 'http://www.ldxy.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 42, '', ''),
(9126, '1290235161', '辽宁对外经贸学院', 'http://www.luibe.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 43, '', ''),
(9127, '1290235161', '辽宁交通高等专科学校', 'http://www.lncc.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 44, '', ''),
(9128, '1290235161', '铁岭师范高等专科学校', 'http://www.tlsz.com.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 45, '', ''),
(9129, '1290235161', '抚顺师范高等专科学校', 'http://www.fstc.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 46, '', ''),
(9130, '1290235161', '朝阳师范高等专科学校', 'http://www.cysz.com.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 47, '', ''),
(9131, '1290235161', '锦州师范高等专科学校', 'http://www.jzsz.com.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 48, '', ''),
(9132, '1290235161', '辽宁警官高等专科学校', 'http://www.lnpc.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 49, '', ''),
(9133, '1290235161', '阜新高等专科学校', 'http://www.fxgz.com.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 50, '', ''),
(9134, '1290235161', '大连职业技术学院', 'http://www.dlvtc.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 51, '', ''),
(9135, '1290235161', '辽宁农业职业技术学院', 'http://lnnzy.ln.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 52, '', ''),
(9136, '1290235161', '辽阳职业技术学院', 'http://www.419.com.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 53, '', ''),
(9137, '1290235161', '盘锦职业技术学院', 'http://www.pjzy.net.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 54, '', ''),
(9138, '1290235161', '渤海船舶职业学院', 'http://www.bhcy.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 55, '', ''),
(9139, '1290235161', '抚顺职业技术学院', 'http://www.fvti.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 56, '', ''),
(9140, '1290235161', '营口职业技术学院', 'http://www.ykdx.net/asptest/index.asp', 0, 0, 0, 4529, 0, 1, 0, NULL, 57, '', ''),
(9141, '1290235161', '大连艺术职业学院', 'http://www.dlac.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 58, '', ''),
(9142, '1290235161', '大连东软信息技术职业学院', 'http://dalian.neusoft.edu.cn/index.html', 0, 0, 0, 4529, 0, 1, 0, NULL, 59, '', ''),
(9143, '1290235161', '辽宁金融职业学院', 'http://www.lnfvc.cn/newweb/index.asp', 0, 0, 0, 4529, 0, 1, 0, NULL, 60, '', ''),
(9144, '1290235161', '辽宁石化职业技术学院', 'http://www.lnpc.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 61, '', ''),
(9145, '1290235161', '辽宁经济职业技术学院', 'http://www.lnemci.com/main1.aspx', 0, 0, 0, 4529, 0, 1, 0, NULL, 62, '', ''),
(9146, '1290235161', '辽宁信息职业技术学院', 'http://www.lnxxxy.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 63, '', ''),
(9147, '1290235161', '辽宁现代服务职业技术学院', 'http://www.lnxdfwxy.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 64, '', ''),
(9148, '1290235161', '辽宁广告职业学院', 'http://www.ggxy.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 65, '', ''),
(9149, '1290235161', '辽宁装备制造职业技术学院', 'http://www.ltcem.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 66, '', ''),
(9150, '1290235161', '辽宁理工职业学院', 'http://www.lndhdx.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 67, '', ''),
(9151, '1290235161', '辽宁机电职业技术学院', 'http://www.lnmec.net.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 68, '', ''),
(9152, '1290235161', '辽宁林业职业技术学院', 'http://www.lnlzy.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 69, '', ''),
(9153, '1290235161', '大连翻译职业学院', 'http://www.dltcedu.org/', 0, 0, 0, 4529, 0, 1, 0, NULL, 70, '', ''),
(9154, '1290235161', '辽宁商贸职业学院', 'http://www.lnsmzy.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 71, '', ''),
(9155, '1290235161', '大连汽车职业技术学院', 'http://www.dlqcxy.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 72, '', ''),
(9156, '1290235161', '大连装备制造职业技术学院', 'http://dl.xaiu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 73, '', ''),
(9157, '1290235161', '大连枫叶职业技术学院', 'http://dmlit.cn/zhaoshengxinxi/zsgg2009.asp', 0, 0, 0, 4529, 0, 1, 0, NULL, 74, '', ''),
(9158, '1290235161', '辽宁职业学院', 'http://www.lnvc.cn/info/data/publish/100.jsp', 0, 0, 0, 4529, 0, 1, 0, NULL, 75, '', ''),
(9159, '1290235161', '辽宁美术职业学院', 'http://www.fzcollege.org/', 0, 0, 0, 4529, 0, 1, 0, NULL, 76, '', ''),
(9160, '1290235161', '沈阳航空职业技术学院', 'http://www.syhzy.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 77, '', ''),
(9161, '1290235161', '大连航运职业技术学院', 'http://www.dlsc.net.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 78, '', ''),
(9162, '1290235161', '沈阳职业技术学院', 'http://www.vtcsy.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 79, '', ''),
(9163, '1290235161', '辽宁地质工程职业学院', 'http://www.lndzxy.com/ws2004/', 0, 0, 0, 4529, 0, 1, 0, NULL, 80, '', ''),
(9164, '1290235161', '辽宁体育运动职业技术学院', 'http://www.lnen.cn/mb/view.html?actionType=home&amp;amp;domainid=96', 0, 0, 0, 4529, 0, 1, 0, NULL, 81, '', ''),
(9165, '1290235161', '辽宁冶金职业技术学院', 'http://www.lnyj.net/', 0, 0, 0, 4529, 0, 1, 0, NULL, 82, '', ''),
(9166, '1290235161', '辽宁工程职业学院', 'http://lngczyxy.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 83, '', ''),
(9167, '1290235161', '辽宁卫生职业技术学院', 'http://www.lzygzy-edu.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 84, '', ''),
(9168, '1290235161', '大连理工大学城市学院', 'http://www.dl-city.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 85, '', ''),
(9169, '1290235161', '沈阳航空航天大学北方科技学院', 'http://nstc.syiae.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 86, '', ''),
(9170, '1290235161', '沈阳大学科技工程学院', 'http://www.syu.edu.cn/xueyuan/kjxy/', 0, 0, 0, 4529, 0, 1, 0, NULL, 87, '', ''),
(9171, '1290235161', '大连交通大学信息工程学院', 'http://www.ieidjtu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 88, '', ''),
(9172, '1290235161', '东北财经大学津桥商学院', 'http://www.kingbridge.net/', 0, 0, 0, 4529, 0, 1, 0, NULL, 89, '', ''),
(9173, '1290235161', '大连工业大学艺术与信息工程学院', 'http://www.caie.org/', 0, 0, 0, 4529, 0, 1, 0, NULL, 90, '', ''),
(9174, '1290235161', '辽宁科技大学信息技术学院', 'http://zsjy.ustl.edu.cn/xxxy/', 0, 0, 0, 4529, 0, 1, 0, NULL, 91, '', ''),
(9175, '1290235161', '中国医科大学临床医药学院', 'http://www.cmu.edu.cn/cmc/', 0, 0, 0, 4529, 0, 1, 0, NULL, 92, '', ''),
(9176, '1290235161', '辽宁石油化工大学顺华能源学院', 'http://www.lnshny.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 93, '', ''),
(9177, '1290235161', '辽宁师范大学海华学院', 'http://haihua.lnnu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 94, '', ''),
(9178, '1290235161', '沈阳建筑大学城市建设学院', 'http://www.sjcy.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 95, '', ''),
(9179, '1290235161', '辽宁中医药大学杏林学院', 'http://www.lnutcm.edu.cn/xinglin/', 0, 0, 0, 4529, 0, 1, 0, NULL, 96, '', ''),
(9180, '1290235161', '沈阳理工大学应用技术学院', 'http://www.syyyy.com.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 97, '', ''),
(9181, '1290235161', '沈阳医学院何氏视觉科学学院', 'http://www.he-edu.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 98, '', ''),
(9182, '1290235161', '辽宁医学院医疗学院', 'http://ylxy.lnmu.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 99, '', ''),
(9183, '1290235161', '大连医科大学中山学院', 'http://www.dmuzs.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 100, '', ''),
(9184, '1290235161', '沈阳工业大学工程学院', 'http://gcxy.sut.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 101, '', ''),
(9185, '1290235161', '沈阳化工大学科亚学院', 'http://keyaxueyuan.syuct.edu.cn/', 0, 0, 0, 4529, 0, 1, 0, NULL, 102, '', ''),
(9186, '1290235161', '辽宁公安司法管理干部学院', 'http://www.lacpj.com/', 0, 0, 0, 4529, 0, 1, 0, NULL, 103, '', ''),
(9187, '1290235223', '兰州大学', 'http://www.lzu.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 1, '', ''),
(9188, '1290235223', '西北民族大学', 'http://www.xbmu.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 2, '', ''),
(9189, '1290235223', '兰州理工大学', 'http://www.gsut.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 3, '', ''),
(9190, '1290235223', '兰州交通大学', 'http://www.lzjtu.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 4, '', ''),
(9191, '1290235223', '甘肃农业大学', 'http://www.gsau.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 5, '', ''),
(9192, '1290235223', '西北师范大学', 'http://www.nwnu.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 6, '', ''),
(9193, '1290235223', '甘肃中医学院', 'http://www.gszy.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 7, '', ''),
(9194, '1290235223', '陇东学院', 'http://www.ldxy.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 8, '', ''),
(9195, '1290235223', '甘肃民族师范学院', 'http://www.gnun.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 9, '', ''),
(9196, '1290235223', '天水师范学院', 'http://www.tsnc.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 10, '', ''),
(9197, '1290235223', '兰州商学院', 'http://www.lzcc.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 11, '', ''),
(9198, '1290235223', '甘肃政法学院', 'http://www.gsli.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 12, '', ''),
(9199, '1290235223', '河西学院', 'http://www.hxu.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 13, '', ''),
(9200, '1290235223', '兰州城市学院', 'http://www.lztc.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 14, '', ''),
(9201, '1290235223', '兰州工业高等专科学校', 'http://www.lzptc.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 15, '', ''),
(9202, '1290235223', '平凉医学高等专科学校', 'http://www.plmc.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 16, '', ''),
(9203, '1290235223', '定西师范高等专科学校', 'http://www.dxatc.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 17, '', ''),
(9204, '1290235223', '甘肃联合大学', 'http://www.gsu.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 18, '', ''),
(9205, '1290235223', '兰州石化职业技术学院', 'http://www.lzpcc.com.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 19, '', ''),
(9206, '1290235223', '甘肃农业职业技术学院', 'http://www.gnzy.gssedu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 20, '', ''),
(9207, '1290235223', '甘肃林业职业技术学院', 'http://www.gsfc.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 21, '', ''),
(9208, '1290235223', '甘肃交通职业技术学院', 'http://www.gsjtxy.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 22, '', ''),
(9209, '1290235223', '酒泉职业技术学院', 'http://www.jqzy.com/', 0, 0, 0, 4528, 0, 1, 0, NULL, 23, '', ''),
(9210, '1290235223', '兰州外语职业学院', 'http://www.lzwyedu.com/', 0, 0, 0, 4528, 0, 1, 0, NULL, 24, '', ''),
(9211, '1290235223', '兰州职业技术学院', 'http://www.lvu.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 25, '', ''),
(9212, '1290235223', '甘肃工业职业技术学院', 'http://edu.tianshui.com.cn/html/hgyxx/', 0, 0, 0, 4528, 0, 1, 0, NULL, 26, '', ''),
(9213, '1290235223', '甘肃畜牧工程职业技术学院', 'http://www.xmgcxy.gsedu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 27, '', ''),
(9214, '1290235223', '武威职业学院', 'http://www.wwoc.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 28, '', ''),
(9215, '1290235223', '兰州资源环境职业技术学院', 'http://www.lzre.gs.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 29, '', ''),
(9216, '1290235223', '甘肃钢铁职业技术学院', 'http://www.ggzy.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 30, '', ''),
(9217, '1290235223', '甘肃机电职业技术学院', 'http://www.gsjdxy.com/', 0, 0, 0, 4528, 0, 1, 0, NULL, 31, '', ''),
(9218, '1290235223', '西北师范大学知行学院', 'http://zxxy.nwnu.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 32, '', ''),
(9219, '1290235223', '兰州商学院陇桥学院', 'http://www.lzlqc.com/', 0, 0, 0, 4528, 0, 1, 0, NULL, 33, '', ''),
(9220, '1290235223', '兰州交通大学博文学院', 'http://www.bowenedu.cn/www/', 0, 0, 0, 4528, 0, 1, 0, NULL, 34, '', ''),
(9221, '1290235223', '兰州商学院长青学院', 'http://222.23.176.254/', 0, 0, 0, 4528, 0, 1, 0, NULL, 35, '', ''),
(9222, '1290235223', '兰州理工大学技术工程学院', 'http://www.ljsgcxy.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 36, '', ''),
(9223, '1290235223', '西北师范大学知行学院', 'http://zxxy.nwnu.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 37, '', ''),
(9224, '1290235223', '兰州商学院陇桥学院', 'http://www.lzlqc.com/', 0, 0, 0, 4528, 0, 1, 0, NULL, 38, '', ''),
(9225, '1290235223', '兰州交通大学博文学院', 'http://www.bowenedu.cn/www/', 0, 0, 0, 4528, 0, 1, 0, NULL, 39, '', ''),
(9226, '1290235223', '兰州商学院长青学院', 'http://222.23.176.254/', 0, 0, 0, 4528, 0, 1, 0, NULL, 40, '', ''),
(9227, '1290235223', '兰州理工大学技术工程学院', 'http://www.ljsgcxy.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 41, '', ''),
(9228, '1290235223', '西北师范大学知行学院', 'http://zxxy.nwnu.edu.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 42, '', ''),
(9229, '1290235223', '兰州商学院陇桥学院', 'http://www.lzlqc.com/', 0, 0, 0, 4528, 0, 1, 0, NULL, 43, '', ''),
(9230, '1290235223', '兰州交通大学博文学院', 'http://www.bowenedu.cn/www/', 0, 0, 0, 4528, 0, 1, 0, NULL, 44, '', ''),
(9231, '1290235223', '兰州商学院长青学院', 'http://222.23.176.254/', 0, 0, 0, 4528, 0, 1, 0, NULL, 45, '', ''),
(9232, '1290235223', '兰州理工大学技术工程学院', 'http://www.ljsgcxy.cn/', 0, 0, 0, 4528, 0, 1, 0, NULL, 46, '', ''),
(9233, '1290235270', '复旦大学', 'http://www.fudan.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 1, '', ''),
(9234, '1290235270', '上海交通大学', 'http://www.sjtu.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 2, '', ''),
(9235, '1290235270', '同济大学', 'http://www.tongji.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 3, '', ''),
(9236, '1290235270', '华东理工大学', 'http://www.ecust.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 4, '', ''),
(9237, '1290235270', '东华大学', 'http://www.dhu.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 5, '', ''),
(9238, '1290235270', '华东师范大学', 'http://www.ecnu.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 6, '', ''),
(9239, '1290235270', '上海外国语大学', 'http://www.shisu.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 7, '', ''),
(9240, '1290235270', '上海财经大学', 'http://www.shufe.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 8, '', ''),
(9241, '1290235270', '上海海关学院', 'http://shanghai_edu.customs.gov.cn/publish/portal135/', 0, 0, 0, 4527, 0, 1, 0, NULL, 9, '', ''),
(9242, '1290235270', '上海大学', 'http://www.shu.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 10, '', ''),
(9243, '1290235270', '上海理工大学', 'http://www.usst.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 11, '', ''),
(9244, '1290235270', '上海海事大学', 'http://www.shmtu.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 12, '', ''),
(9245, '1290235270', '上海工程技术大学', 'http://www.sues.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 13, '', ''),
(9246, '1290235270', '上海海洋大学', 'http://www.shfu.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 14, '', ''),
(9247, '1290235270', '上海中医药大学', 'http://www.shutcm.com/', 0, 0, 0, 4527, 0, 1, 0, NULL, 15, '', ''),
(9248, '1290235270', '上海师范大学', 'http://www.shnu.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 16, '', ''),
(9249, '1290235270', '华东政法大学', 'http://www.ecupl.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 17, '', ''),
(9250, '1290235270', '上海政法学院', 'http://www.shupl.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 18, '', ''),
(9251, '1290235270', '上海建桥学院', 'http://www.gench.com.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 19, '', ''),
(9252, '1290235270', '上海第二工业大学', 'http://www.shspu.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 20, '', ''),
(9253, '1290235270', '上海应用技术学院', 'http://www.sit.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 21, '', ''),
(9254, '1290235270', '上海电力学院', 'http://www.shiep.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 22, '', ''),
(9255, '1290235270', '上海电机学院', 'http://www.sdju.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 23, '', ''),
(9256, '1290235270', '上海对外贸易学院', 'http://www.shift.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 24, '', ''),
(9257, '1290235270', '上海金融学院', 'http://www.shfc.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 25, '', ''),
(9258, '1290235270', '上海立信会计学院', 'http://www.lixin.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 26, '', ''),
(9259, '1290235270', '上海体育学院', 'http://www.sus.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 27, '', ''),
(9260, '1290235270', '上海音乐学院', 'http://www.shcmusic.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 28, '', ''),
(9261, '1290235270', '上海戏剧学院', 'http://www.sta.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 29, '', ''),
(9262, '1290235270', '上海商学院', 'http://www.sbs.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 30, '', ''),
(9263, '1290235270', '上海杉达学院', 'http://www.sandau.edu.cn/cweb/index/', 0, 0, 0, 4527, 0, 1, 0, NULL, 31, '', ''),
(9264, '1290235270', '上海医疗器械高等专科学校', 'http://www.smic.edu.cn/web/infportal/index', 0, 0, 0, 4527, 0, 1, 0, NULL, 32, '', ''),
(9265, '1290235270', '上海出版印刷高等专科学校', 'http://www.sppc.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 33, '', ''),
(9266, '1290235270', '上海医药高等专科学校', 'http://www.sihs.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 34, '', ''),
(9267, '1290235270', '上海旅游高等专科学校', 'http://www.sitsh.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 35, '', ''),
(9268, '1290235270', '上海公安高等专科学校', 'http://www.shpc.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 36, '', ''),
(9269, '1290235270', '上海电影艺术职业学院', 'http://www.shfilmart.com/indes.php', 0, 0, 0, 4527, 0, 1, 0, NULL, 37, '', ''),
(9270, '1290235270', '上海东海职业技术学院', 'http://www.esu.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 38, '', ''),
(9271, '1290235270', '上海新侨职业技术学院', 'http://www.xqpi.net/', 0, 0, 0, 4527, 0, 1, 0, NULL, 39, '', ''),
(9272, '1290235270', '上海城市管理职业技术学院', 'http://www.umcollege.com/', 0, 0, 0, 4527, 0, 1, 0, NULL, 40, '', ''),
(9273, '1290235270', '上海思博职业技术学院', 'http://www.shsipo.com/', 0, 0, 0, 4527, 0, 1, 0, NULL, 41, '', ''),
(9274, '1290235270', '上海中侨职业技术学院', 'http://www.shzq.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 42, '', ''),
(9275, '1290235270', '上海托普信息技术职业学院', 'http://www.etop.com.cn/portal/', 0, 0, 0, 4527, 0, 1, 0, NULL, 43, '', ''),
(9276, '1290235270', '上海科学技术职业学院', 'http://www.scst.edu.cn/structure/sy/index', 0, 0, 0, 4527, 0, 1, 0, NULL, 44, '', ''),
(9277, '1290235270', '上海邦德职业技术学院', 'http://www.shbangde.com/', 0, 0, 0, 4527, 0, 1, 0, NULL, 45, '', ''),
(9278, '1290235270', '上海立达职业技术学院', 'http://www.lidapoly.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 46, '', ''),
(9279, '1290235270', '上海建峰职业技术学院', 'http://www.shjf.com/', 0, 0, 0, 4527, 0, 1, 0, NULL, 47, '', ''),
(9280, '1290235270', '上海工艺美术职业学院', 'http://www.gymy.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 48, '', ''),
(9281, '1290235270', '上海农林职业技术学院', 'http://www.shafc.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 49, '', ''),
(9282, '1290235270', '上海体育职业学院', 'http://www.ssi.edu.cn/mainAction.do', 0, 0, 0, 4527, 0, 1, 0, NULL, 50, '', ''),
(9283, '1290235270', '上海震旦职业学院', 'http://www.aurora-college.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 51, '', ''),
(9284, '1290235270', '上海海事职业技术学院', 'http://www.cnshmaritime.com/', 0, 0, 0, 4527, 0, 1, 0, NULL, 52, '', ''),
(9285, '1290235270', '上海民远职业技术学院', 'http://www.min-yuan.com/', 0, 0, 0, 4527, 0, 1, 0, NULL, 53, '', ''),
(9286, '1290235270', '上海中华职业技术学院', 'http://www.zhonghuacollege.com/', 0, 0, 0, 4527, 0, 1, 0, NULL, 54, '', ''),
(9287, '1290235270', '上海工会管理职业学院', 'http://college.shghxyedu.net/', 0, 0, 0, 4527, 0, 1, 0, NULL, 55, '', ''),
(9288, '1290235270', '上海工商外国语职业学院', 'http://www.sicfl.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 56, '', ''),
(9289, '1290235270', '上海交通职业技术学院', 'http://www.scp.edu.cn/page/index.asp', 0, 0, 0, 4527, 0, 1, 0, NULL, 57, '', ''),
(9290, '1290235270', '上海济光职业技术学院', 'http://www.shjgxy.com/', 0, 0, 0, 4527, 0, 1, 0, NULL, 58, '', ''),
(9291, '1290235270', '上海行健职业学院', 'http://www.shxj.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 59, '', ''),
(9292, '1290235270', '上海电子信息职业技术学院', 'http://www.stiei.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 60, '', ''),
(9293, '1290235270', '上海欧华职业技术学院', 'http://www.shouhua.net.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 61, '', ''),
(9294, '1290235270', '上海健康职业技术学院', 'http://www.shzgyxy.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 62, '', ''),
(9295, '1290235270', '上海外国语大学贤达经济人文学院', 'http://www.xdsisu.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 63, '', ''),
(9296, '1290235270', '上海师范大学天华学院', 'http://www.sthu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 64, '', ''),
(9297, '1290235270', '复旦大学上海视觉艺术学院', 'http://www.siva.edu.cn/', 0, 0, 0, 4527, 0, 1, 0, NULL, 65, '', ''),
(9298, '1290235328', '广西大学', 'http://www.gxu.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 1, '', ''),
(9299, '1290235328', '桂林电子科技大学', 'http://www.gliet.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 2, '', ''),
(9300, '1290235328', '桂林理工大学', 'http://www.glite.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 3, '', ''),
(9301, '1290235328', '广西医科大学', 'http://www.gxmu.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 4, '', ''),
(9302, '1290235328', '广西师范大学', 'http://www.gxnu.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 5, '', ''),
(9303, '1290235328', '广西民族大学', 'http://www.gxun.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 6, '', ''),
(9304, '1290235328', '广西工学院', 'http://www.gxut.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 7, '', ''),
(9305, '1290235328', '广西中医学院', 'http://www.gxtcmu.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 8, '', ''),
(9306, '1290235328', '右江民族医学院', 'http://www.ymcn.gx.cn/Index.html', 0, 0, 0, 4526, 0, 1, 0, NULL, 9, '', ''),
(9307, '1290235328', '桂林医学院', 'http://www.glmc.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 10, '', ''),
(9308, '1290235328', '广西师范学院', 'http://www.gxtc.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 11, '', ''),
(9309, '1290235328', '广西民族师范学院', 'http://www.gxnun.net/', 0, 0, 0, 4526, 0, 1, 0, NULL, 12, '', ''),
(9310, '1290235328', '河池学院', 'http://www.hcnu.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 13, '', ''),
(11017, '1290239043', 'fesco', 'http://www.fesco.com.cn/', 0, 0, 0, 4565, 0, 1, 0, NULL, 6, '', ''),
(9312, '1290235328', '广西财经学院', 'http://www.gxufe.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 15, '', ''),
(9313, '1290235328', '广西艺术学院', 'http://www.gxai.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 16, '', ''),
(9314, '1290235328', '贺州学院', 'http://www.hzu.gx.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 17, '', ''),
(9315, '1290235328', '钦州学院', 'http://www.qzu.net.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 18, '', ''),
(9316, '1290235328', '百色学院', 'http://www.bsuc.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 19, '', ''),
(9317, '1290235328', '梧州学院', 'http://www.gxuwz.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 20, '', ''),
(9318, '1290235328', '桂林航天工业高等专科学校', 'http://www.glcat.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 21, '', ''),
(9319, '1290235328', '柳州医学高等专科学校', 'http://www.lzyz.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 22, '', ''),
(9320, '1290235328', '桂林师范高等专科学校', 'http://ww.glnc.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 23, '', ''),
(9321, '1290235328', '柳州师范高等专科学校', 'http://www.gxlztc.net/', 0, 0, 0, 4526, 0, 1, 0, NULL, 24, '', ''),
(9322, '1290235328', '广西幼儿师范高等专科学校', 'http://www.gxyesf.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 25, '', ''),
(9323, '1290235328', '桂林旅游高等专科学校', 'http://www.glit.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 26, '', ''),
(9324, '1290235328', '广西体育高等专科学校', 'http://www.gxtznn.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 27, '', ''),
(9325, '1290235328', '柳州职业技术学院', 'http://www.lzzy.net/', 0, 0, 0, 4526, 0, 1, 0, NULL, 28, '', ''),
(9326, '1290235328', '广西职业技术学院', 'http://www.gxzjy.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 29, '', ''),
(9327, '1290235328', '南宁职业技术学院', 'http://www.ncvt.net/', 0, 0, 0, 4526, 0, 1, 0, NULL, 30, '', ''),
(9328, '1290235328', '广西机电职业技术学院', 'http://www.gxcme.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 31, '', ''),
(9329, '1290235328', '贵港职业学院', 'http://www.ggzy.net/', 0, 0, 0, 4526, 0, 1, 0, NULL, 32, '', ''),
(9330, '1290235328', '广西农业职业技术学院', 'http://www.gxnyxy.com.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 33, '', ''),
(9331, '1290235328', '广西工程职业学院', 'http://www.gxgcedu.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 34, '', ''),
(9332, '1290235328', '广西建设职业技术学院', 'http://www.gxjsxy.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 35, '', ''),
(9333, '1290235328', '广西理工职业技术学院', 'http://www.gxlgxy.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 36, '', ''),
(9334, '1290235328', '广西经贸职业技术学院', 'http://www.gxjmzy.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 37, '', ''),
(9335, '1290235328', '广西工商职业技术学院', 'http://www.gxgsxy.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 38, '', ''),
(9336, '1290235328', '广西工业职业技术学院', 'http://www.gxic.net/', 0, 0, 0, 4526, 0, 1, 0, NULL, 39, '', ''),
(9337, '1290235328', '百色职业学院', 'http://www.bszyxy.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 40, '', ''),
(9338, '1290235328', '广西水利电力职业技术学院', 'http://www.gxsdxy.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 41, '', ''),
(9339, '1290235328', '广西城市职业学院', 'http://www.gxccedu.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 42, '', ''),
(9340, '1290235328', '广西东方外语职业学院', 'http://www.cndffc.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 43, '', ''),
(9341, '1290235328', '广西国际商务职业技术学院', 'http://www.gxibvc.net/', 0, 0, 0, 4526, 0, 1, 0, NULL, 44, '', ''),
(9342, '1290235328', '梧州职业学院', 'http://www.wzzyedu.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 45, '', ''),
(9343, '1290235328', '桂林山水职业学院', 'http://www.guolianweb.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 46, '', ''),
(9344, '1290235328', '广西电力职业技术学院', 'http://www.gxdlxy.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 47, '', ''),
(9345, '1290235328', '广西英华国际职业学院', 'http://www.tic-gx.com.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 48, '', ''),
(9346, '1290235328', '柳州城市职业学院', 'http://www.lcvc.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 49, '', ''),
(9347, '1290235328', '广西生态工程职业技术学院', 'http://www.gxstzy.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 50, '', ''),
(9348, '1290235328', '广西演艺职业学院', 'http://www.gxart.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 51, '', ''),
(9349, '1290235328', '广西交通职业技术学院', 'http://www.gxjzy.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 52, '', ''),
(9350, '1290235328', '北海艺术设计职业学院', 'http://www.sszss.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 53, '', ''),
(9351, '1290235328', '北海职业学院', 'http://www.bhzyxy.net/', 0, 0, 0, 4526, 0, 1, 0, NULL, 54, '', ''),
(9352, '1290235328', '广西现代职业技术学院', 'http://www.gxxd.net.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 55, '', ''),
(9353, '1290235328', '广西经济职业学院', 'http://www.gxevc.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 56, '', ''),
(9354, '1290235328', '柳州铁道职业技术学院', 'http://www.lztdzy.com/v8/', 0, 0, 0, 4526, 0, 1, 0, NULL, 57, '', ''),
(9355, '1290235328', '邕江大学', 'http://www.yjdx.net/', 0, 0, 0, 4526, 0, 1, 0, NULL, 58, '', ''),
(9356, '1290235328', '广西科技职业学院', 'http://www.gxkjzy.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 59, '', ''),
(9357, '1290235328', '广西卫生职业技术学院', 'http://www.gxwgy.com.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 60, '', ''),
(9358, '1290235328', '广西师范大学漓江学院', 'http://www.gxljcollege.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 61, '', ''),
(9359, '1290235328', '桂林电子科技大学信息科技学院', 'http://iit.guet.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 62, '', ''),
(9360, '1290235328', '广西工学院鹿山学院', 'http://www.lzls.gxut.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 63, '', ''),
(9361, '1290235328', '广西师范学院师园学院', 'http://www2.gxtc.edu.cn/shiyuan/', 0, 0, 0, 4526, 0, 1, 0, NULL, 64, '', ''),
(9362, '1290235328', '广西民族大学相思湖学院', 'http://xshxy.gxun.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 65, '', ''),
(9363, '1290235328', '广西大学行健文理学院', 'http://xingjian.gxu.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 66, '', ''),
(9364, '1290235328', '广西中医学院赛恩斯新医药学院', 'http://www.gxzyxysy.com/', 0, 0, 0, 4526, 0, 1, 0, NULL, 67, '', ''),
(9365, '1290235328', '北京航空航天大学北海学院', 'http://www.bh.buaa.edu.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 68, '', ''),
(9366, '1290235328', '广西壮族自治区经济管理干部学院', 'http://www.jgy.gx.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 69, '', ''),
(9367, '1290235328', '广西政法管理干部学院', 'http://www.gxzfxy.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 70, '', ''),
(9368, '1290235328', '广西教育学院', 'http://www.gxec.net.cn/', 0, 0, 0, 4526, 0, 1, 0, NULL, 71, '', ''),
(9369, '1290235328', '南宁地区教育学院', 'http://www.nnjy.net/', 0, 0, 0, 4526, 0, 1, 0, NULL, 72, '', ''),
(9370, '1290235430', '浙江大学', 'http://www.zju.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 1, '', ''),
(9371, '1290235430', '公安海警学院', 'http://www.hjgz.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 2, '', ''),
(9372, '1290235430', '宁波大学', 'http://www.nbu.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 3, '', ''),
(9373, '1290235430', '浙江工业大学', 'http://www.zjut.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 4, '', ''),
(9374, '1290235430', '杭州电子科技大学', 'http://www.hdu.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 5, '', ''),
(9375, '1290235430', '浙江理工大学', 'http://www.zist.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 6, '', ''),
(9376, '1290235430', '浙江农林大学', 'http://www.zjfc.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 7, '', ''),
(9377, '1290235430', '浙江中医药大学', 'http://www.zjtcm.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 8, '', ''),
(9378, '1290235430', '浙江师范大学', 'http://www.zjnu.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 9, '', ''),
(9379, '1290235430', '杭州师范大学', 'http://www.hznu.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 10, '', ''),
(9380, '1290235430', '浙江工商大学', 'http://www.hzic.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 11, '', ''),
(9381, '1290235430', '宁波诺丁汉大学', 'http://www.nottingham.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 12, '', ''),
(9382, '1290235430', '温州大学', 'http://www.wzu.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 13, '', ''),
(9383, '1290235430', '宁波大红鹰学院', 'http://www.dhyedu.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 14, '', ''),
(9384, '1290235430', '浙江越秀外国语学院', 'http://www.yxc.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 15, '', ''),
(9385, '1290235430', '中国计量学院', 'http://www.cjlu.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 16, '', ''),
(9386, '1290235430', '宁波工程学院', 'http://www.nbut.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 17, '', ''),
(9387, '1290235430', '嘉兴学院', 'http://www.zjxu.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 18, '', ''),
(9388, '1290235430', '浙江科技学院', 'http://www.zust.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 19, '', ''),
(9389, '1290235430', '浙江海洋学院', 'http://www.zjou.net.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 20, '', ''),
(9390, '1290235430', '温州医学院', 'http://www.wzmc.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 21, '', ''),
(9391, '1290235430', '湖州师范学院', 'http://www.hutc.zj.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 22, '', ''),
(9392, '1290235430', '台州学院', 'http://www.tzc.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 23, '', ''),
(9393, '1290235430', '绍兴文理学院', 'http://www.usx.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 24, '', ''),
(9394, '1290235430', '浙江传媒学院', 'http://www.zjicm.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 25, '', ''),
(9395, '1290235430', '浙江外国语学院', 'http://www.zjei.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 26, '', ''),
(9396, '1290235430', '浙江财经学院', 'http://www.zufe.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 27, '', ''),
(9397, '1290235430', '浙江警察学院', 'http://www.zjjcxy.cn/default.html', 0, 0, 0, 4525, 0, 1, 0, NULL, 28, '', ''),
(9398, '1290235430', '中国美术学院', 'http://www.chinaacademyofart.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 29, '', ''),
(9399, '1290235430', '浙江树人学院', 'http://www.zjsru.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 30, '', ''),
(9400, '1290235430', '浙江万里学院', 'http://www.zjwu.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 31, '', ''),
(9401, '1290235430', '丽水学院', 'http://www.lsxy.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 32, '', ''),
(9402, '1290235430', '浙江水利水电专科学校', 'http://www.zjwchc.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 33, '', ''),
(9403, '1290235430', '浙江医学高等专科学校', 'http://www.zjmc.net.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 34, '', ''),
(9404, '1290235430', '浙江医药高等专科学校', 'http://www.zjpc.net.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 35, '', ''),
(9405, '1290235430', '金华职业技术学院', 'http://www.jhc.cn/index.asp', 0, 0, 0, 4525, 0, 1, 0, NULL, 36, '', ''),
(9406, '1290235430', '宁波职业技术学院', 'http://www.nbptweb.net/index.action', 0, 0, 0, 4525, 0, 1, 0, NULL, 37, '', ''),
(9407, '1290235430', '浙江交通职业技术学院', 'http://www.zjvtit.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 38, '', ''),
(9408, '1290235430', '温州职业技术学院', 'http://www.wzvtc.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 39, '', ''),
(9409, '1290235430', '台州职业技术学院', 'http://www.tzvtc.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 40, '', ''),
(9410, '1290235430', '嘉兴南洋职业技术学院', 'http://www.jxnyc.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 41, '', ''),
(9411, '1290235430', '嘉兴职业技术学院', 'http://www.jxvtc.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 42, '', ''),
(9412, '1290235430', '浙江纺织服装职业技术学院', 'http://www.zjff.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 43, '', ''),
(9413, '1290235430', '绍兴职业技术学院', 'http://www.sxvtc.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 44, '', ''),
(9414, '1290235430', '浙江育英职业技术学院', 'http://www.zjyyc.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 45, '', ''),
(9415, '1290235430', '浙江经贸职业技术学院', 'http://www.zjiet.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 46, '', ''),
(9416, '1290235430', '浙江建设职业技术学院', 'http://www.zjjy.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 47, '', ''),
(9417, '1290235430', '衢州职业技术学院', 'http://www.qzct.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 48, '', ''),
(9418, '1290235430', '浙江金融职业学院', 'http://www.zjfc.com.cn/default.html', 0, 0, 0, 4525, 0, 1, 0, NULL, 49, '', ''),
(9419, '1290235430', '丽水职业技术学院', 'http://www.lszjy.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 50, '', ''),
(9421, '1290235430', '浙江艺术职业学院', 'http://www.zj-art.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 52, '', ''),
(9422, '1290235430', '浙江机电职业技术学院', 'http://www.zime.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 53, '', ''),
(9423, '1290235430', '浙江商业职业技术学院', 'http://www.zjvcc.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 54, '', ''),
(9424, '1290235430', '浙江警官职业学院', 'http://www.zjjy.com.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 55, '', ''),
(9425, '1290235430', '浙江工业职业技术学院', 'http://www.zjipc.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 56, '', ''),
(9426, '1290235430', '浙江旅游职业学院', 'http://www.tczj.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 57, '', ''),
(9427, '1290235430', '浙江经济职业技术学院', 'http://www.zjtie.edu.cn/web/index.asp', 0, 0, 0, 4525, 0, 1, 0, NULL, 58, '', ''),
(9428, '1290235430', '浙江横店影视职业学院', 'http://www.zjhyxy.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 59, '', ''),
(9429, '1290235430', '浙江同济科技职业学院', 'http://www.zjtongji.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 60, '', ''),
(9430, '1290235430', '宁波天一职业技术学院', 'http://www.nbchs.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 61, '', ''),
(9431, '1290235430', '浙江邮电职业技术学院', 'http://www.zptc.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 62, '', ''),
(9432, '1290235430', '台州科技职业学院', 'http://www.tzvcst.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 63, '', ''),
(9433, '1290235430', '浙江电力职业技术学院', 'http://www.zjevtc.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 64, '', ''),
(9434, '1290235430', '湖州职业技术学院', 'http://202.107.243.69/', 0, 0, 0, 4525, 0, 1, 0, NULL, 65, '', ''),
(9435, '1290235430', '杭州科技职业技术学院', 'http://www.hzaspt.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 66, '', ''),
(9436, '1290235430', '杭州职业技术学院', 'http://www.hzvtc.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 67, '', ''),
(9437, '1290235430', '宁波城市职业技术学院', 'http://www.nbcc.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 68, '', ''),
(9438, '1290235430', '浙江工贸职业技术学院', 'http://www.zjitc.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 69, '', ''),
(11016, '1290239043', '北京人事人才信息网', 'http://www.bjp.gov.cn/', 0, 0, 0, 4565, 0, 1, 0, NULL, 5, '', ''),
(9440, '1290235430', '杭州万向职业技术学院', 'http://www.wxpoly.cn/web/index.asp', 0, 0, 0, 4525, 0, 1, 0, NULL, 71, '', ''),
(9441, '1290235430', '义乌工商职业技术学院', 'http://www.ywu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 72, '', ''),
(9442, '1290235430', '浙江国际海运职业技术学院', 'http://www.zimc.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 73, '', ''),
(9443, '1290235430', '温州科技职业学院', 'http://www.wzvcst.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 74, '', ''),
(9444, '1290235430', '浙江体育职业技术学院', 'http://www.zjcs.net.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 75, '', ''),
(9445, '1290235430', '浙江广厦建设职业技术学院', 'http://www.guangshaxy.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 76, '', ''),
(9446, '1290235430', '浙江东方职业技术学院', 'http://www.zjdfc.com/Index.asp', 0, 0, 0, 4525, 0, 1, 0, NULL, 77, '', ''),
(9447, '1290235430', '浙江长征职业技术学院', 'http://www.zjczxy.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 78, '', ''),
(9448, '1290235430', '浙江大学城市学院', 'http://www.zucc.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 79, '', ''),
(9449, '1290235430', '浙江大学宁波理工学院', 'http://www.nit.zju.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 80, '', ''),
(9450, '1290235430', '浙江工业大学之江学院', 'http://www.zjc.zjut.edu.cn/web/site/index.jsp', 0, 0, 0, 4525, 0, 1, 0, NULL, 81, '', ''),
(9451, '1290235430', '浙江师范大学行知学院', 'http://xz.zjnu.net.cn/xzcollege/', 0, 0, 0, 4525, 0, 1, 0, NULL, 82, '', ''),
(9452, '1290235430', '宁波大学科学技术学院', 'http://www.ndkjxy.net.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 83, '', ''),
(9453, '1290235430', '杭州电子科技大学信息工程学院', 'http://www.hziee.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 84, '', ''),
(9454, '1290235430', '浙江理工大学科技与艺术学院', 'http://www.ky.zstu.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 85, '', ''),
(9455, '1290235430', '浙江海洋学院东海科学技术学院', 'http://dk.zjou.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 86, '', ''),
(9456, '1290235430', '浙江农林大学天目学院', 'http://tmxy.zjfc.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 87, '', ''),
(9457, '1290235430', '温州医学院仁济学院', 'http://www.wzmc.net/renji/', 0, 0, 0, 4525, 0, 1, 0, NULL, 88, '', ''),
(9458, '1290235430', '杭州师范大学钱江学院', 'http://qjxy.hznu.edu.cn:90/cms/index.jsf', 0, 0, 0, 4525, 0, 1, 0, NULL, 89, '', ''),
(9459, '1290235430', '湖州师范学院求真学院', 'http://qzxy.hutc.zj.cn/2009/', 0, 0, 0, 4525, 0, 1, 0, NULL, 90, '', ''),
(9460, '1290235430', '绍兴文理学院元培学院', 'http://www.ypcol.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 91, '', ''),
(9461, '1290235430', '温州大学瓯江学院', 'http://www.ojc.zj.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 92, '', ''),
(9462, '1290235430', '浙江工商大学杭州商学院', 'http://hsy.zjgsu.edu.cn/cms/index.jsf', 0, 0, 0, 4525, 0, 1, 0, NULL, 93, '', ''),
(9463, '1290235430', '中国计量学院现代科技学院', 'http://xdkj.cjlu.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 94, '', ''),
(9464, '1290235430', '嘉兴学院南湖学院', 'http://nhxy.zjxu.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 95, '', ''),
(9465, '1290235430', '温州大学城市学院', 'http://www.wucc.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 96, '', ''),
(9466, '1290235430', '同济大学浙江学院', 'http://www.tjzj.edu.cn/', 0, 0, 0, 4525, 0, 1, 0, NULL, 97, '', ''),
(9467, '1290235430', '上海财经大学浙江学院', 'http://www.shufe-zj.com/', 0, 0, 0, 4525, 0, 1, 0, NULL, 98, '', ''),
(9468, '1290235430', '宁波教育学院', 'http://www.nbei.net/', 0, 0, 0, 4525, 0, 1, 0, NULL, 99, '', ''),
(9469, '1290235510', '中国科学技术大学', 'http://www.ustc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 1, '', ''),
(9470, '1290235510', '合肥工业大学', 'http://www.hfut.edu.cn/ch/', 0, 0, 0, 4524, 0, 1, 0, NULL, 2, '', ''),
(9471, '1290235510', '安徽大学', 'http://www.ahu.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 3, '', ''),
(9472, '1290235510', '安徽理工大学', 'http://www.aust.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 4, '', ''),
(9473, '1290235510', '安徽工业大学', 'http://www.ahut.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 5, '', ''),
(9474, '1290235510', '安徽工程大学', 'http://www.auts.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 6, '', ''),
(9475, '1290235510', '安徽农业大学', 'http://www.ahau.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 7, '', ''),
(9476, '1290235510', '安徽医科大学', 'http://www.ahmu.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 8, '', ''),
(9477, '1290235510', '安徽师范大学', 'http://www.ahnu.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 9, '', ''),
(9478, '1290235510', '淮北师范大学', 'http://www.hbcnc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 10, '', '');
INSERT INTO `site` (`siteID`, `siteCreateDate`, `siteName`, `siteUrl`, `siteProvince`, `siteCity`, `siteTown`, `stpID`, `siteFamous`, `siteStatus`, `cDate`, `siteDefine`, `siteSort`, `siteColor`, `dsiteColor`) VALUES
(9479, '1290235510', '安徽财经大学', 'http://www.aufe.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 11, '', ''),
(9480, '1290235510', '安徽三联学院', 'http://www.sanlian.net.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 12, '', ''),
(9481, '1290235510', '安徽建筑工业学院', 'http://www.aiai.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 13, '', ''),
(9482, '1290235510', '安徽中医学院', 'http://www.ahtcm.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 14, '', ''),
(9483, '1290235510', '皖南医学院', 'http://www.wnmc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 15, '', ''),
(9484, '1290235510', '蚌埠医学院', 'http://www.bbmc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 16, '', ''),
(9485, '1290235510', '阜阳师范学院', 'http://www.fync.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 17, '', ''),
(9486, '1290235510', '淮南师范学院', 'http://www.hnnu.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 18, '', ''),
(9487, '1290235510', '安庆师范学院', 'http://www.aqtc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 19, '', ''),
(9488, '1290235510', '安徽科技学院', 'http://www.ahstu.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 20, '', ''),
(9489, '1290235510', '合肥师范学院', 'http://www.hftc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 21, '', ''),
(9490, '1290235510', '黄山学院', 'http://www.hsc.org.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 22, '', ''),
(9491, '1290235510', '安徽新华学院', 'http://www.axhu.cn/axhu1/', 0, 0, 0, 4524, 0, 1, 0, NULL, 23, '', ''),
(9492, '1290235510', '宿州学院', 'http://www.ahsztc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 24, '', ''),
(9493, '1290235510', '铜陵学院', 'http://www.tlc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 25, '', ''),
(9494, '1290235510', '皖西学院', 'http://www.wxc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 26, '', ''),
(9495, '1290235510', '巢湖学院', 'http://www.chtc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 27, '', ''),
(9496, '1290235510', '合肥学院', 'http://www.hfuu.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 28, '', ''),
(9498, '1290235510', '滁州学院', 'http://www.chzu.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 30, '', ''),
(9499, '1290235510', '池州学院', 'http://www.cntc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 31, '', ''),
(9500, '1290235510', '马鞍山师范高等专科学校', 'http://www.massz.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 32, '', ''),
(9501, '1290235510', '安徽中医药高等专科学校', 'http://www.ahzyygz.com/', 0, 0, 0, 4524, 0, 1, 0, NULL, 33, '', ''),
(9502, '1290235510', '安庆医药高等专科学校', 'http://www.aqyyz.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 34, '', ''),
(9503, '1290235510', '安徽医学高等专科学校', 'http://www.ahyz.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 35, '', ''),
(9504, '1290235510', '桐城师范高等专科学校', 'http://www.tcsf.org.cn/welcome/index.php', 0, 0, 0, 4524, 0, 1, 0, NULL, 36, '', ''),
(11015, '1290239043', '首都人才网', 'http://www.shoudurc.com/', 0, 0, 0, 4565, 0, 1, 0, NULL, 4, '', ''),
(9506, '1290235510', '安徽警官职业学院', 'http://www.ahjgxy.com/', 0, 0, 0, 4524, 0, 1, 0, NULL, 38, '', ''),
(9507, '1290235510', '淮北职业技术学院', 'http://www.hbvtc.net/', 0, 0, 0, 4524, 0, 1, 0, NULL, 39, '', ''),
(9508, '1290235510', '芜湖职业技术学院', 'http://www.whptu.ah.cn/site/default/', 0, 0, 0, 4524, 0, 1, 0, NULL, 40, '', ''),
(9509, '1290235510', '安徽商贸职业技术学院', 'http://www.ahszy.com/', 0, 0, 0, 4524, 0, 1, 0, NULL, 41, '', ''),
(9510, '1290235510', '民办万博科技职业学院', 'http://www.ahwbedu.net/', 0, 0, 0, 4524, 0, 1, 0, NULL, 42, '', ''),
(9511, '1290235510', '铜陵职业技术学院', 'http://www.tlpt.net.cn/main/index.asp', 0, 0, 0, 4524, 0, 1, 0, NULL, 43, '', ''),
(9512, '1290235510', '淮南职业技术学院', 'http://www.hnvtc.ah.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 44, '', ''),
(9513, '1290235510', '安徽水利水电职业技术学院', 'http://www.ahsdxy.ah.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 45, '', ''),
(9514, '1290235510', '淮南联合大学', 'http://www.hnuu.edu.cn/index.jsp', 0, 0, 0, 4524, 0, 1, 0, NULL, 46, '', ''),
(9515, '1290235510', '安徽职业技术学院', 'http://www.ahtu.ah.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 47, '', ''),
(9516, '1290235510', '安徽艺术职业学院', 'http://www.artah.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 48, '', ''),
(9517, '1290235510', '安徽电气工程职业技术学院', 'http://www.aepu.com.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 49, '', ''),
(9518, '1290235510', '安徽冶金科技职业学院', 'http://www.ahyky.com/', 0, 0, 0, 4524, 0, 1, 0, NULL, 50, '', ''),
(9519, '1290235510', '安徽矿业职业技术学院', 'http://www.anhky.com/', 0, 0, 0, 4524, 0, 1, 0, NULL, 51, '', ''),
(9520, '1290235510', '安徽工商职业学院', 'http://www.ahbvc.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 52, '', ''),
(9521, '1290235510', '安庆职业技术学院', 'http://www.aqvtc.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 53, '', ''),
(9522, '1290235510', '安徽绿海商务职业学院', 'http://www.lhub.cn/default.jsp', 0, 0, 0, 4524, 0, 1, 0, NULL, 54, '', ''),
(9523, '1290235510', '合肥共达职业技术学院', 'http://gdxy.hfut.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 55, '', ''),
(9524, '1290235510', '安徽电子信息职业技术学院', 'http://www.avceit.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 56, '', ''),
(9525, '1290235510', '安徽涉外经济职业学院', 'http://www.ahaec-edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 57, '', ''),
(9526, '1290235510', '安徽国际商务职业学院', 'http://www.ahiib.com/', 0, 0, 0, 4524, 0, 1, 0, NULL, 58, '', ''),
(9527, '1290235510', '安徽财贸职业学院', 'http://www.aftvc.com/', 0, 0, 0, 4524, 0, 1, 0, NULL, 59, '', ''),
(9528, '1290235510', '安徽林业职业技术学院', 'http://www.ahlyxy.cn/chinese/index.htm', 0, 0, 0, 4524, 0, 1, 0, NULL, 60, '', ''),
(9529, '1290235510', '阜阳科技职业学院', 'http://www.fky.net.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 61, '', ''),
(9530, '1290235510', '安徽审计职业学院', 'http://www.ahsjxy.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 62, '', ''),
(9531, '1290235510', '安徽新闻出版职业技术学院', 'http://www.ahcbxy.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 63, '', ''),
(9532, '1290235510', '安徽工业职业技术学院', 'http://www.ahip.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 64, '', ''),
(9533, '1290235510', '安徽邮电职业技术学院', 'http://www.ahptc.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 65, '', ''),
(9534, '1290235510', '蚌埠经济技术职业学院', 'http://www.bjy.ah.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 66, '', ''),
(9535, '1290235510', '安徽交通职业技术学院', 'http://www.ahctc.com/', 0, 0, 0, 4524, 0, 1, 0, NULL, 67, '', ''),
(9536, '1290235510', '安徽工业经济职业技术学院', 'http://www.ahiec.net/', 0, 0, 0, 4524, 0, 1, 0, NULL, 68, '', ''),
(9537, '1290235510', '马鞍山职业技术学院', 'http://www.mastc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 69, '', ''),
(9538, '1290235510', '徽商职业学院', 'http://www.huishangedu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 70, '', ''),
(9539, '1290235510', '民办安徽旅游职业学院', 'http://www.ahlyedu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 71, '', ''),
(9540, '1290235510', '合肥通用职业技术学院', 'http://www.hftyxy.com/', 0, 0, 0, 4524, 0, 1, 0, NULL, 72, '', ''),
(9541, '1290235510', '安徽工贸职业技术学院', 'http://www.ahgmedu.cn/index.asp', 0, 0, 0, 4524, 0, 1, 0, NULL, 73, '', ''),
(9542, '1290235510', '阜阳职业技术学院', 'http://www.fyzy.net/', 0, 0, 0, 4524, 0, 1, 0, NULL, 74, '', ''),
(9543, '1290235510', '安徽现代信息工程职业学院', 'http://www.ahmodern.net/', 0, 0, 0, 4524, 0, 1, 0, NULL, 75, '', ''),
(9544, '1290235510', '民办安徽外国语职业技术学院', 'http://www.aflc.com.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 76, '', ''),
(9545, '1290235510', '宣城职业技术学院', 'http://xcvtc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 77, '', ''),
(9546, '1290235510', '安徽城市管理职业学院', 'http://www.cmoc.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 78, '', ''),
(9547, '1290235510', '民办安徽外国语职业技术学院', 'http://www.aflc.com.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 79, '', ''),
(9548, '1290235510', '宣城职业技术学院', 'http://xcvtc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 80, '', ''),
(9549, '1290235510', '安徽城市管理职业学院', 'http://www.cmoc.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 81, '', ''),
(9550, '1290235510', '六安职业技术学院', 'http://www.lvtc.edu.cn/', 0, 0, 0, 4524, 0, 1, 0, NULL, 82, '', ''),
(9551, '1290235510', '安徽体育运动职业技术学院', 'http://www.ahty.net/', 0, 0, 0, 4524, 0, 1, 0, NULL, 83, '', ''),
(9552, 