<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" omit-xml-declaration="yes" method="html"/>
<xsl:template match="/">
<table class="tblList">
	<colgroup>
	<col width="120" />
	<col />
	<col width="60" />
	<col width="60" />
	<col width="60" />
	<col width="60" />
	<col width="60" />
	<col width="80" />
	<col width="80" />
	</colgroup>
  <tr>
    <th>网站名称</th>
    <th>网站链接</th>
    <th>网站分类</th>
    <th>网站地区</th>
    <th>入站流量</th>
    <th>出站流量</th>
    <th>浏览次数</th>
    <th>收录日期</th>
    <th>操作</th>
  </tr>
<xsl:apply-templates />
<tr>
	<td colspan="9">
		{%spbar%}
	</td>
</tr>
</table>
</xsl:template>

<xsl:template match="row">
  <tr>
  <td>
	<xsl:if test="@isTop=1">
		<span class="redb">(顶)</span>
	</xsl:if>
	<xsl:value-of select="@siteName"/></td>
	<td><a href="http://{@url}" target="_blank"><xsl:value-of select="@url"/></a></td>
	<td><xsl:value-of select="@siteCname"/></td>
	<td><xsl:value-of select="@cityCname"/></td>
	<td><xsl:value-of select="@inNum"/></td>
	<td><xsl:value-of select="@outNum"/></td>
	<td><xsl:value-of select="@viewNum"/></td>
	<td><xsl:value-of select="@editTime"/></td>
  <td>
		<a href="?act=edit&amp;id={@id}">编辑</a>&#160;
		<a href="javascript:void(0);"  onclick="chkLink('?act=saveDel&amp;id={@id}',this,'确定要删除吗?')">删除</a>
	</td>
  </tr>
</xsl:template>

</xsl:stylesheet>