<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" omit-xml-declaration="no" method="html" encoding="utf-8"/>
<xsl:param name="orderType"/>
<xsl:param name="cityId"/>
<xsl:template match="/">
	<div class="blankBar">&#160;</div>
	<div class="areaList">
		<div class="ti">
			<div class="label">排序方式: &#160;&#160;&#160;</div>
			<a href="?cityId={$cityId}&amp;orderType=inNum">
			<xsl:if test="$orderType='inNum'">
				<xsl:attribute name="class">cura</xsl:attribute>
			</xsl:if>
			入站流量</a>
			<a href="?cityId={$cityId}&amp;orderType=outNum">
			<xsl:if test="$orderType='outNum'">
				<xsl:attribute name="class">cura</xsl:attribute>
			</xsl:if>
			出站流量</a>
			<a href="?cityId={$cityId}&amp;orderType=viewNum">
			<xsl:if test="$orderType='viewNum'">
				<xsl:attribute name="class">cura</xsl:attribute>
			</xsl:if>
			人气指数</a>
		</div>
		<ul>
			<xsl:apply-templates/>
			<li class="clear"></li>
		</ul>
		<div class="spBar">{%spBar%}</div>
	</div>
</xsl:template>

<xsl:template match="row">
	<li class="hli">
		<div class="c1">
			<img src="http://open.thumbshots.org/image.pxf?url={@url}"/>
		</div>
		<div class="c2">
			<div class="sti">
				<a href="site.php?id={@id}"><xsl:value-of select="@siteName"/></a>
				<xsl:if test="@isTop=1">
					&#160;<img src="/images/tg.gif" align="absmiddle"/>
				</xsl:if>
			</div>
			<div class="cont"><xsl:value-of select="@content"/></div>
			<div class="url">
				<span class="cc1"><xsl:value-of select="@url"/></span>
				-
				<a href="siteList.php?cid={@cid}">类似网站</a>
				-
				<span class="cc2"><xsl:value-of select="substring-before(@editTime,' ')"/></span>
			</div>
		</div>
		<div class="c3">
			<div class="rank"><xsl:value-of select="format-number(@markNum,'0.0')"/>&#160;<a href="site.php?id={@id}">查看点评</a></div>
			<div class="star">
				<div style="width:{@markNum div 5*100}%">&#160;</div>
			</div>
			<div class="comment"><xsl:value-of select="@commentNum"/>人点评</div>
		</div>
		<div class="clear"></div>
	</li>
</xsl:template>

</xsl:stylesheet>