<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" omit-xml-declaration="no" method="html" encoding="utf-8"/>
<xsl:param name="curCityId"/>
<xsl:template match="/">
	<div class="childCitysDiv">
		<div class="ti">
		“<xsl:value-of select="/root/city/item/@cName"/>网站目录”二级地区
		</div>
		<ul>
			<xsl:apply-templates select="/root/city/item[position() &gt; 1]"/>
			<li class="clear"></li>
		</ul>
	</div>
</xsl:template>

<xsl:template match="/root/city/item">
	<li class="hli">
		<xsl:if test="$curCityId=@id">
			<xsl:attribute name="class">hli curli</xsl:attribute>
		</xsl:if>
		<a href="?cityId={@id}"><xsl:value-of select="@cName"/></a>
		<sup><xsl:value-of select="/root/data/row[@cityId=current()/@id]/@rsNum"/></sup>
	</li>
</xsl:template>

</xsl:stylesheet>