<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" omit-xml-declaration="no" method="html" encoding="utf-8"/>
<xsl:param name="curCId"/>
<xsl:template match="/">
	<div class="childSitesDiv">
		<div class="ti">
		<xsl:choose>
			<xsl:when test="$curCId=''">网站目录分类</xsl:when>
			<xsl:otherwise>“<xsl:value-of select="/root/site/item/@cName"/>网站目录”二级分类</xsl:otherwise>
		</xsl:choose>
		</div>
		<ul>
		<xsl:choose>
			<xsl:when test="$curCId=''"><xsl:apply-templates select="/root/site/item"/></xsl:when>
			<xsl:otherwise><xsl:apply-templates select="/root/site/item[position() &gt; 1]"/></xsl:otherwise>
		</xsl:choose>
			<li class="clear"></li>
		</ul>
	</div>
</xsl:template>

<xsl:template match="/root/site/item">
	<li class="hli">
		<xsl:if test="$curCId=@id">
			<xsl:attribute name="class">hli curli</xsl:attribute>
		</xsl:if>
		<a href="?cid={@id}"><xsl:value-of select="@cName"/></a>
		<sup><xsl:value-of select="/root/data/row[@cid=current()/@id]/@rsNum"/></sup>
	</li>
</xsl:template>

</xsl:stylesheet>