<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" omit-xml-declaration="no" method="html" encoding="utf-8"/>

<xsl:template match="/">
	<xsl:apply-templates select="/root/list/item"/>
	<div class="clear"></div>
</xsl:template>

<xsl:template match="/root/list/item">
<dl>
	<dt>
	<a href="/area.php?cityId={@id}"><xsl:value-of select="@cName"/></a>
	<span>(<xsl:value-of select="/root/data/row[@cityId1=current()/@id]/@cityId1Num"/>)</span>
	</dt>
	<dd>
		<ul>
			<xsl:apply-templates select="item[@isTj=1]"/>
			<li class="clear"></li>
		</ul>
	</dd>
</dl>
</xsl:template>

<xsl:template match="item">
		<li class="hli"><a href="area.php?cityId={@id}">
		<xsl:if test="@islight=1">
			<xsl:attribute name="class"> light</xsl:attribute>
		</xsl:if>
		<xsl:value-of select="@cName"/>
		</a></li>
</xsl:template>

</xsl:stylesheet>