<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:variable name="catalogDoc" select="document('../data/news.xml')"></xsl:variable>
<xsl:output indent="no" omit-xml-declaration="no" method="html" encoding="utf-8"/>
<xsl:template match="/">
	<xsl:variable name="cid"><xsl:value-of select="/data/row/@cid"/></xsl:variable>
	<div class="blankBar">&#160;</div>
	<div class="newsList">
		<div class="ti">
			<div class="label">资讯类别: &#160;&#160;&#160;</div>
			<a href="/news.php">
			资讯首页</a>
			<xsl:for-each select="$catalogDoc/list/item">
				<a href="?cid={@id}">
				<xsl:if test="@id=$cid">
					<xsl:attribute name="class">cura</xsl:attribute>
				</xsl:if>
				<xsl:value-of select="@cName"/></a>
			</xsl:for-each>
		</div>
		<div class="newsCont">
			<xsl:apply-templates/>
		</div>
	</div>
</xsl:template>

<xsl:template match="row">
	<div class="newsTi"><xsl:value-of select="@title"/></div>
	<div class="cont"><xsl:value-of select="@content" disable-output-escaping="yes"/></div>
</xsl:template>

</xsl:stylesheet>