<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:variable name="catalogDoc" select="document('../data/news.xml')"></xsl:variable>
<xsl:output indent="no" omit-xml-declaration="no" method="html" encoding="utf-8"/>
<xsl:param name="cid"/>
<xsl:template match="/">
	<div class="blankBar">&#160;</div>
	<div class="newsList">
		<div class="ti">
			<div class="label">资讯类别: &#160;&#160;&#160;</div>
			<a href="/news.php">
			<xsl:if test="$cid=''">
				<xsl:attribute name="class">cura</xsl:attribute>
			</xsl:if>
			资讯首页</a>
			<xsl:for-each select="$catalogDoc/list/item">
				<a href="?cid={@id}">
				<xsl:if test="@id=$cid">
					<xsl:attribute name="class">cura</xsl:attribute>
				</xsl:if>
				<xsl:value-of select="@cName"/></a>
			</xsl:for-each>
		</div>
		<ul class="newsul">
			<xsl:apply-templates/>
			<li class="clear"></li>
		</ul>
		<div class="spBar">{%spBar%}</div>
	</div>
</xsl:template>

<xsl:template match="row">
	<li class="hli">
		<div class="c1">
			<div class="viewNum"><xsl:value-of select="@viewNum"/></div>
			<div class="txt">views</div>
			<div class="dt"><xsl:value-of select="substring-before(@editTime,' ')"/></div>
		</div>
		<div class="c2">
			<div class="sti">
				<a href="/news.php?id={@id}"><xsl:value-of select="@title"/></a>
			</div>
			<div class="cont"><xsl:value-of select="@summary"/></div>
		</div>
		<div class="clear"></div>
	</li>
</xsl:template>

</xsl:stylesheet>