<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" omit-xml-declaration="no" method="html" encoding="utf-8"/>
<xsl:template match="/">
	<div class="blankBar">&#160;</div>
	<div class="siteDiv">
		<xsl:apply-templates/>
	</div>
</xsl:template>

<xsl:template match="row">
	<div class="ti">
		<xsl:value-of select="@siteName"/>
	</div>
	<div class="cont">

		<div class="r1 clearfix">
			<div class="c1">
				<a href="http://{@url}" target="_blank" onclick="addOutNum({@id})"><img src="http://open.thumbshots.org/image.pxf?url={@url}"/></a>
			</div>
			<div class="c2">
				<div class="url"><xsl:value-of select="@url"/></div>
				<div class="siteName"><a href="http://{@url}" target="_blank" onclick="addOutNum({@id})"><xsl:value-of select="@siteName"/></a></div>
			</div>
			<div class="c3 clearfix">
				<div class="cc1">
					<div class="r11">
						<xsl:value-of select="@joinedNum"/>人评分，总得分 <xsl:value-of select="@totalScore"/>
					</div>
					<div class="r22">
						(满分5分)
					</div>
				</div>
				<div class="cc2">
					<xsl:value-of select="format-number(@markNum,'0.0')"/>
				</div>
			</div>
		</div>

		<div class="r2">
			<img src="/images/ggad.gif"/>
		</div>

		<div class="r3 clearfix">
			<div class="label">网站描述：</div>
			<div class="str"><xsl:value-of select="@content" disable-output-escaping="yes"/></div>
		</div>

		<div class="r4 clearfix">
			<div class="label">所属行业：</div>
			<div class="str"><xsl:value-of select="@siteCatalogNav" disable-output-escaping="yes"/></div>
			<div class="label">所属地区：</div>
			<div class="str"><xsl:value-of select="@cityCatalogNav" disable-output-escaping="yes"/></div>
		</div>

		<div class="r5 clearfix">
			<div class="label">网站评分：</div>
			<div class="str clearfix">
				<div class="starDiv">
					<xsl:call-template name="starTpl">
						<xsl:with-param name="curpos">1</xsl:with-param>
						<xsl:with-param name="end">5</xsl:with-param>
						<xsl:with-param name="elVal"><xsl:value-of select="floor(@markNum)"/></xsl:with-param>
					</xsl:call-template>
				</div>
				<div class="starInfo" id="markInfoDiv">
					评分人数:<span><xsl:value-of select="@joinedNum"/></span>
					总分: <span><xsl:value-of select="@totalScore"/></span> 
				</div>
			</div>
		</div>

		<div class="r6 clearfix">
			<div class="hdiv">
				<div class="txt"><xsl:value-of select="substring-before(@editTime,' ')"/></div>
				<div class="label">收录日期: </div>
			</div>
			<div class="hdiv">
				<div class="txt"><xsl:value-of select="@outNum"/></div>
				<div class="label">出站流量: </div>
			</div>
			<div class="hdiv">
				<div class="txt"><xsl:value-of select="@inNum"/></div>
				<div class="label">入站流量: </div>
			</div>
			<div class="hdiv">
				<div class="txt"><xsl:value-of select="@viewNum"/></div>
				<div class="label">浏览次数: </div>
			</div>
			<div class="hdiv">
				<div class="txt"><xsl:value-of select="@commentNum"/></div>
				<div class="label">点评数量: </div>
			</div>
		</div>

		<div class="r7">
			<a href="#comment"><img src="/images/comment.gif"/></a>
		</div>

		<script type="text/javascript">
		$('.starDiv input').rating({
			callback: function(value){
				$.getJSON('/site.php?act=saveStar&amp;id=<xsl:value-of select="@id"/>&amp;val='+value,function(data){
					opAjaxJson(data);
				});
			}
		});
		</script>
	</div>

</xsl:template>

<xsl:template name="starTpl">
	<xsl:param name="curpos"/>
	<xsl:param name="end"/>
	<xsl:param name="elVal"/>
	<xsl:if test="$curpos &lt;= $end">
		<input type="radio" name="star" value="{$curpos}">
			<xsl:if test="$curpos=$elVal">
				<xsl:attribute name="checked">1</xsl:attribute>
			</xsl:if>
		</input>
		<xsl:call-template name="starTpl">
			<xsl:with-param name="curpos"><xsl:value-of select="$curpos+1"/></xsl:with-param>
			<xsl:with-param name="end">5</xsl:with-param>
			<xsl:with-param name="elVal"><xsl:value-of select="$elVal"/></xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>
</xsl:stylesheet>