<?php


class util
{

	function readfile( $file )
	{
		$fp = fopen( $file, "r" );
		flock( $fp, 1 );
		$content = fread( $fp, filesize( $file ) );
		fclose( $fp );
		return $content;
	}

	function writefile( $file, $content, $mode = "w+" )
	{
		if ( !file_exists( $file ) )
		{
			util::makefile( $file );
		}
		$fp = fopen( $file, $mode );
		flock( $fp, 2 );
		$result = fwrite( $fp, $content );
		fclose( $fp );
		return $result;
	}

	function makefile( $fileName, $content = "" )
	{
		$path = substr( $fileName, 0, strrpos( $fileName, "/" ) );
		util::makedir( $path );
		$fp = fopen( $fileName, "w+" );
		fwrite( $fp, $content );
		fclose( $fp );
		return true;
	}

	function makedir( $path )
	{
		if ( FALSE !== strpos( $path, "./" ) )
		{
			$path = util::getrealpath( $path );
		}
		$path = str_replace( "\\", "/", $path );
		if ( file_exists( $path ) )
		{
			return true;
		}
		$dirs = explode( "/", $path );
		$dir_tmp = "";
		$i = 0;
		for ( ;	$i < count( $dirs );	++$i	)
		{
			$dir_tmp .= $dirs[$i]."/";
			if ( !file_exists( $dir_tmp ) )
			{
				mkdir( $dir_tmp );
			}
		}
		return true;
	}

	function getrealpath( $path )
	{
		$path = str_replace( "\\", "/", $path );
		$parts = array_filter( explode( "/", $path ), "strlen" );
		$relativePath = "";
		foreach ( $parts as $part )
		{
			if ( "." == $part || !( ".." == $part ) )
			{
				$relativePath .= $part."/";
				array_shift( $parts );
			}
		}
		return realpath( $relativePath ).implode( DIRECTORY_SEPARATOR, $parts );
	}

	function gpc( $gpcType = "" )
	{
		$gpcFlag = ini_get( "magic_quotes_gpc" );
		if ( $gpcFlag )
		{
			return;
		}
		if ( is_array( $_GET ) )
		{
			foreach ( $GLOBALS['_GET'] as $key => $value )
			{
				$GLOBALS['_GET'][$key] = addslashes( $value );
			}
		}
		if ( is_array( $_POST ) )
		{
			foreach ( $GLOBALS['_POST'] as $key => $value )
			{
				if ( !is_array( $_POST[$key] ) )
				{
					$GLOBALS['_POST'][$key] = addslashes( $value );
				}
				else
				{
					foreach ( $GLOBALS['_POST'][$key] as $key => $value )
					{
						$GLOBALS['_POST'][$key][$key] = addslashes( $value );
					}
				}
			}
		}
	}

	function printarray( $arr )
	{
		echo "<xmp>";
		print_r( $arr );
		echo "</xmp>";
	}

	function auth( )
	{
		$currentDomain = $_SERVER['SERVER_NAME'];
		$key = @file_get_contents( "../inc/mysites.php" );
		if ( empty( $key ) )
		{
			$msg = "[4001] 授权文件不存在或已损坏。<br/>请联系<a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">MySITES</a>官方网站(<a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">http://mysites.honghesoft.com/</a>)获取授权。";
			util::quit( $msg );
		}
		$key = base64_decode( trim( $key ) );
		list( $licMd5, $licDomain, $licExpireTime, $licVersion ) = explode( "|", $key );
		if ( empty( $licMd5 ) || empty( $licDomain ) || empty( $licExpireTime ) )
		{
			$msg = "[4002] 授权文件不正确或已损坏。<br/>请联系<a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">MySITES</a>官方网站(<a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">http://mysites.honghesoft.com/</a>)获取授权。";
			util::quit( $msg );
		}
		$validMd5 = md5( "red-honghesoft-mysites-".$licVersion."-{$licDomain}-{$licExpireTime}" );
		if ( $licMd5 != $validMd5 )
		{
			$msg = "[4003] 授权文件不正确或已损坏。<br/>请联系<a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">MySITES</a>官方网站(<a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">http://mysites.honghesoft.com/</a>)获取授权。";
			util::quit( $msg );
		}
		if ( "*" != $licDomain && !eregi( $licDomain."\$", $currentDomain ) )
		{
			$msg = "[4004] 您现在所使用的域名 ".$currentDomain." 未获授权，您将不能使用数据添加、修改和删除功能。<br/>请联系<a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">MySITES</a>官方网站(<a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">http://mysites.honghesoft.com/</a>)购买授权。<br/>获得授权后，您将可以无限制使用本系统的全部功能。<br/><br/>>> <a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">购买授权</a>";
			util::quit( $msg );
		}
		if ( $licExpireTime < time( ) )
		{
			$msg = "[4005] 您现在所使用的授权已过期，您将不能使用数据数据添加、修改和删除功能。。<br/>请联系<a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">MySITES</a>官方网站(<a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">http://mysites.honghesoft.com/</a>)购买新的授权。<br/>获得授权后，您将可以无限制使用本系统的全部功能。<br/><br/>>> <a href=\"http://mysites.honghesoft.com/\" target=\"_blank\">购买授权</a>";
			util::quit( $msg );
		}
	}

	function quit( $msg )
	{
		exit( "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><title>管理中心</title><link href=\"common/main.css\" rel=\"stylesheet\" type=\"text/css\" /></head><body><strong>操作被限制，未能完成……</strong><p class=\"info\">".$msg."</p></body></html>" );
	}

}

?>
