﻿# Host: 192.168.0.159  (Version: 5.7.17)
# Date: 2019-05-14 10:40:06
# Generator: MySQL-Front 5.3  (Build 4.234)

/*!40101 SET NAMES utf8 */;

#
# Structure for table "access_apps"
#

DROP TABLE IF EXISTS `access_apps`;
CREATE TABLE `access_apps` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `platform` enum('android','ios') COLLATE utf8mb4_unicode_ci NOT NULL,
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pv` int(11) NOT NULL DEFAULT '0' COMMENT 'pv',
  `uv` int(11) NOT NULL DEFAULT '0' COMMENT 'uv',
  `ip` int(11) NOT NULL DEFAULT '0' COMMENT 'ip',
  `today` date NOT NULL COMMENT '日期',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "access_apps"
#


#
# Structure for table "access_channels"
#

DROP TABLE IF EXISTS `access_channels`;
CREATE TABLE `access_channels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `platform` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL,
  `template_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `pv` int(11) NOT NULL DEFAULT '0',
  `uv` int(11) NOT NULL DEFAULT '0',
  `ip` int(11) NOT NULL DEFAULT '0',
  `today` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "access_channels"
#


#
# Structure for table "access_products"
#

DROP TABLE IF EXISTS `access_products`;
CREATE TABLE `access_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `platform` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `product_id` int(11) NOT NULL DEFAULT '0',
  `pv` int(11) NOT NULL DEFAULT '0',
  `uv` int(11) NOT NULL DEFAULT '0',
  `ip` int(11) NOT NULL DEFAULT '0',
  `today` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "access_products"
#


#
# Structure for table "access_records"
#

DROP TABLE IF EXISTS `access_records`;
CREATE TABLE `access_records` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `today` date NOT NULL COMMENT '日期',
  `platform` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL,
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `refer` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `device_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `system_version` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `app_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `app_version` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "access_records"
#


#
# Structure for table "app_menus"
#

DROP TABLE IF EXISTS `app_menus`;
CREATE TABLE `app_menus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` int(11) NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "app_menus"
#


#
# Structure for table "app_startups"
#

DROP TABLE IF EXISTS `app_startups`;
CREATE TABLE `app_startups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` int(11) NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "app_startups"
#


#
# Structure for table "applications"
#

DROP TABLE IF EXISTS `applications`;
CREATE TABLE `applications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `display_name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `package_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `jpush_config` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "applications"
#


#
# Structure for table "applies"
#

DROP TABLE IF EXISTS `applies`;
CREATE TABLE `applies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0',
  `order_no` varchar(255) CHARACTER SET utf8mb4 DEFAULT NULL,
  `platform` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '平台',
  `type` enum('product','credit') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '类型',
  `product_id` int(11) NOT NULL DEFAULT '0',
  `credit_id` int(11) NOT NULL DEFAULT '0',
  `channel_id` int(11) NOT NULL DEFAULT '0',
  `channel_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '渠道码',
  `register_page_id` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `pay_id` int(11) DEFAULT '0',
  `pay_time` timestamp NULL DEFAULT NULL,
  `pay_way` varchar(255) CHARACTER SET utf8mb4 DEFAULT NULL,
  `expire_time` timestamp NULL DEFAULT NULL,
  `money` decimal(10,2) DEFAULT '0.00',
  `file_id` int(11) DEFAULT '0',
  `result_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `result_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mark` varchar(1100) CHARACTER SET utf8mb4 DEFAULT NULL,
  `product_type` int(11) DEFAULT '0',
  `start_time` timestamp NULL DEFAULT NULL,
  `complete_time` timestamp NULL DEFAULT NULL,
  `refuse_time` timestamp NULL DEFAULT NULL,
  `refuse_content` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "applies"
#


#
# Structure for table "apply_logs"
#

DROP TABLE IF EXISTS `apply_logs`;
CREATE TABLE `apply_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `apply_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL COMMENT '订单状态：',
  `mid` int(11) DEFAULT NULL COMMENT '用户id',
  `uid` int(11) DEFAULT NULL COMMENT '后台操作员id',
  `mark` varchar(255) DEFAULT NULL COMMENT '操作备注',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "apply_logs"
#


#
# Structure for table "apps"
#

DROP TABLE IF EXISTS `apps`;
CREATE TABLE `apps` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `application_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用id,',
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `download_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `qrcode_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` enum('android','ios') COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `update_log` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '更新日志',
  `channel_id` int(11) NOT NULL,
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态:',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "apps"
#


#
# Structure for table "article_categories"
#

DROP TABLE IF EXISTS `article_categories`;
CREATE TABLE `article_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sort` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "article_categories"
#


#
# Structure for table "article_collections"
#

DROP TABLE IF EXISTS `article_collections`;
CREATE TABLE `article_collections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `article_id` int(11) NOT NULL DEFAULT '0' COMMENT '文章id',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "article_collections"
#


#
# Structure for table "article_members"
#

DROP TABLE IF EXISTS `article_members`;
CREATE TABLE `article_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `article_id` int(11) NOT NULL DEFAULT '0' COMMENT '文章id',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "article_members"
#


#
# Structure for table "article_praises"
#

DROP TABLE IF EXISTS `article_praises`;
CREATE TABLE `article_praises` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `article_id` int(11) NOT NULL DEFAULT '0' COMMENT '文章id',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "article_praises"
#


#
# Structure for table "article_shares"
#

DROP TABLE IF EXISTS `article_shares`;
CREATE TABLE `article_shares` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `article_id` int(11) NOT NULL DEFAULT '0' COMMENT '文章id',
  `link` text COLLATE utf8mb4_unicode_ci COMMENT '分享链接',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "article_shares"
#


#
# Structure for table "articles"
#

DROP TABLE IF EXISTS `articles`;
CREATE TABLE `articles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cover` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '封面图',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '标题',
  `corner_id` int(11) NOT NULL DEFAULT '0' COMMENT '角标id',
  `category_id` int(11) NOT NULL DEFAULT '0' COMMENT '资讯分类id',
  `base_views` int(11) NOT NULL DEFAULT '0' COMMENT '阅读基数',
  `real_views` int(11) NOT NULL DEFAULT '0' COMMENT '真实阅读数',
  `intro` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '摘要',
  `praise` int(11) NOT NULL DEFAULT '0' COMMENT '点赞数',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '内容',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态:0=>下架,1=>上架',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "articles"
#


#
# Structure for table "behavior_logs"
#

DROP TABLE IF EXISTS `behavior_logs`;
CREATE TABLE `behavior_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `register_channel_id` int(11) NOT NULL,
  `register_channel_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `register_page_id` int(11) NOT NULL DEFAULT '0',
  `register_page_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operate_type` tinyint(4) NOT NULL,
  `operate_channel_id` int(11) NOT NULL DEFAULT '0',
  `operate_channel_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `operate_platform` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL,
  `operate_page_id` int(11) NOT NULL DEFAULT '0',
  `operate_page_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operate_params` json DEFAULT NULL COMMENT '请求参数',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "behavior_logs"
#


#
# Structure for table "carts"
#

DROP TABLE IF EXISTS `carts`;
CREATE TABLE `carts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL,
  `product_id` int(11) unsigned NOT NULL COMMENT '产品ID',
  `number` int(5) NOT NULL DEFAULT '1' COMMENT '数量',
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '弃用！',
  `type` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "carts"
#


#
# Structure for table "cash_out_lists"
#

DROP TABLE IF EXISTS `cash_out_lists`;
CREATE TABLE `cash_out_lists` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL COMMENT '后台审核人员',
  `money` decimal(10,2) DEFAULT NULL,
  `rate_money` decimal(10,2) DEFAULT NULL,
  `rate` decimal(4,2) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1' COMMENT '提现状态：',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `mark` varchar(255) DEFAULT NULL COMMENT '备注',
  `image` varchar(255) DEFAULT NULL COMMENT '打款凭证',
  `account` varchar(255) DEFAULT NULL COMMENT '打款账号',
  `deal_at` timestamp NULL DEFAULT NULL COMMENT '打款时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "cash_out_lists"
#


#
# Structure for table "cash_rate_logs"
#

DROP TABLE IF EXISTS `cash_rate_logs`;
CREATE TABLE `cash_rate_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `before_rate` float(4,2) DEFAULT NULL,
  `after_rate` float(4,2) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "cash_rate_logs"
#


#
# Structure for table "cash_rate_settings"
#

DROP TABLE IF EXISTS `cash_rate_settings`;
CREATE TABLE `cash_rate_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` float(6,2) DEFAULT NULL COMMENT '比例',
  `uid` int(11) DEFAULT NULL COMMENT '管理员',
  `limit` decimal(10,2) DEFAULT NULL COMMENT '金额限制',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1提现2退款',
  `status` tinyint(3) DEFAULT NULL COMMENT '1已配置0未配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "cash_rate_settings"
#


#
# Structure for table "cash_refund_lists"
#

DROP TABLE IF EXISTS `cash_refund_lists`;
CREATE TABLE `cash_refund_lists` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `apply_money` decimal(10,2) DEFAULT NULL,
  `check_money` decimal(10,2) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL COMMENT '状态：',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `mark` varchar(255) DEFAULT NULL COMMENT '备注',
  `account` varchar(255) DEFAULT NULL COMMENT '打款账号',
  `image` varchar(255) DEFAULT NULL COMMENT '打款凭证',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "cash_refund_lists"
#


#
# Structure for table "channel_ceilings"
#

DROP TABLE IF EXISTS `channel_ceilings`;
CREATE TABLE `channel_ceilings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ceiling_num` int(11) DEFAULT NULL,
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "channel_ceilings"
#


#
# Structure for table "channel_reduces"
#

DROP TABLE IF EXISTS `channel_reduces`;
CREATE TABLE `channel_reduces` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channel_id` int(11) NOT NULL,
  `channel_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `channel_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL,
  `distribute_template_id` int(11) NOT NULL,
  `distribute_template_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `distribute_page_id` int(11) NOT NULL,
  `distribute_page_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reduce_type` enum('register','apply_register') COLLATE utf8mb4_unicode_ci NOT NULL,
  `reduce_rate` int(11) NOT NULL DEFAULT '100',
  `modifier_id` int(11) NOT NULL DEFAULT '0',
  `modifier_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态:',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "channel_reduces"
#


#
# Structure for table "channels"
#

DROP TABLE IF EXISTS `channels`;
CREATE TABLE `channels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `role_id` int(11) NOT NULL DEFAULT '0' COMMENT '角色id',
  `channel_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '渠道名称',
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '渠道码',
  `department_id` int(11) NOT NULL DEFAULT '0' COMMENT '部门id',
  `manager` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '渠道负责人',
  `reduce_type` enum('register','apply_register') COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect_status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '跳转状态:',
  `ceiling_num` int(11) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态:',
  `deal_at` datetime DEFAULT NULL COMMENT '结算日期',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "channels"
#

INSERT INTO `channels` VALUES (1,1,1,'官方','100001',1,'官方负责人','register',1,NULL,1,NULL,NULL,NULL);

#
# Structure for table "circles"
#

DROP TABLE IF EXISTS `circles`;
CREATE TABLE `circles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `copy_content` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '描述',
  `slug` enum('wechat_public','wechat_person','qq') COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '标识',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "circles"
#


#
# Structure for table "cloud_apply_infos"
#

DROP TABLE IF EXISTS `cloud_apply_infos`;
CREATE TABLE `cloud_apply_infos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `apply_id` int(11) DEFAULT NULL COMMENT '订单ID',
  `order_no` varchar(50) DEFAULT NULL COMMENT '订单号',
  `out_trade_no` varchar(50) DEFAULT NULL COMMENT '交易号',
  `total_amount` varchar(255) DEFAULT NULL COMMENT '交易金额',
  `status` tinyint(2) DEFAULT NULL COMMENT '云订单状态',
  `resource_price_type` varchar(255) DEFAULT NULL COMMENT '订单类型',
  `created_at` datetime(6) DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(6),
  `updated_at` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

#
# Data for table "cloud_apply_infos"
#


#
# Structure for table "comment_replies"
#

DROP TABLE IF EXISTS `comment_replies`;
CREATE TABLE `comment_replies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` int(11) NOT NULL DEFAULT '0' COMMENT '评论id',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '回复内容',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '回复人id',
  `user_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '回复人姓名',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "comment_replies"
#


#
# Structure for table "comments"
#

DROP TABLE IF EXISTS `comments`;
CREATE TABLE `comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_type` enum('product','credit') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '产品类型',
  `comment_type` enum('real','fake') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '评论类型',
  `mid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id,虚拟用户为0',
  `phone` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '手机号',
  `product_id` int(11) NOT NULL DEFAULT '0',
  `credit_id` int(11) NOT NULL DEFAULT '0',
  `model_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '产品名称',
  `apply_id` int(11) NOT NULL DEFAULT '0' COMMENT '申请记录id',
  `star` double(3,1) NOT NULL DEFAULT '5.0' COMMENT '评分',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态:',
  `is_wonderful` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否是精彩评论:',
  `content` text COLLATE utf8mb4_unicode_ci COMMENT '评论内容',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "comments"
#


#
# Structure for table "corners"
#

DROP TABLE IF EXISTS `corners`;
CREATE TABLE `corners` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '角标名称',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '角标图片地址',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `type` enum('product','credit','article') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '类型',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "corners"
#

INSERT INTO `corners` VALUES (1,'最新','/images/new_icon.png',0,'product','2019-03-27 18:10:19','2019-03-27 18:10:19');

#
# Structure for table "credit_banks"
#

DROP TABLE IF EXISTS `credit_banks`;
CREATE TABLE `credit_banks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '银行名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "credit_banks"
#


#
# Structure for table "credit_collections"
#

DROP TABLE IF EXISTS `credit_collections`;
CREATE TABLE `credit_collections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0',
  `credit_id` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "credit_collections"
#


#
# Structure for table "credit_levels"
#

DROP TABLE IF EXISTS `credit_levels`;
CREATE TABLE `credit_levels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '等级名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "credit_levels"
#


#
# Structure for table "credit_organizations"
#

DROP TABLE IF EXISTS `credit_organizations`;
CREATE TABLE `credit_organizations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "credit_organizations"
#


#
# Structure for table "credit_shares"
#

DROP TABLE IF EXISTS `credit_shares`;
CREATE TABLE `credit_shares` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `credit_id` int(11) NOT NULL DEFAULT '0',
  `link` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "credit_shares"
#


#
# Structure for table "credits"
#

DROP TABLE IF EXISTS `credits`;
CREATE TABLE `credits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `credit_bank_id` int(11) NOT NULL DEFAULT '0',
  `corner_id` int(11) NOT NULL DEFAULT '0',
  `credit_level_id` int(11) NOT NULL DEFAULT '0',
  `credit_organization_id` int(11) NOT NULL DEFAULT '0',
  `year_fee` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '年费',
  `redirect_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `free_period` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cash_amount` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '状态',
  `base_apply_num` int(11) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `guess_like` tinyint(4) NOT NULL DEFAULT '0' COMMENT '猜你喜欢:0=>否,1=>是',
  `introduce` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '特权',
  `apply_numbers` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "credits"
#


#
# Structure for table "deal_records"
#

DROP TABLE IF EXISTS `deal_records`;
CREATE TABLE `deal_records` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `deal_at` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "deal_records"
#


#
# Structure for table "deduction_applies"
#

DROP TABLE IF EXISTS `deduction_applies`;
CREATE TABLE `deduction_applies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0',
  `phone` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `platform` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '平台',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `reduce_rate` int(11) NOT NULL DEFAULT '100',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "deduction_applies"
#


#
# Structure for table "deduction_registers"
#

DROP TABLE IF EXISTS `deduction_registers`;
CREATE TABLE `deduction_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `phone` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `reduce_rate` int(11) NOT NULL DEFAULT '100',
  `rate_sum` int(11) NOT NULL DEFAULT '0',
  `natural` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `platform` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "deduction_registers"
#


#
# Structure for table "deductions"
#

DROP TABLE IF EXISTS `deductions`;
CREATE TABLE `deductions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `platform` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `phone` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mid` int(11) NOT NULL DEFAULT '0',
  `reduce_type` enum('register','apply_register') COLLATE utf8mb4_unicode_ci NOT NULL,
  `deduction_register_id` int(11) NOT NULL DEFAULT '0',
  `deduction_apply_id` int(11) NOT NULL DEFAULT '0',
  `reduce_rate` int(11) NOT NULL DEFAULT '100',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `is_deal` tinyint(4) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "deductions"
#


#
# Structure for table "departments"
#

DROP TABLE IF EXISTS `departments`;
CREATE TABLE `departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "departments"
#

INSERT INTO `departments` VALUES (1,'运营',NULL,NULL),(2,'流量',NULL,NULL);

#
# Structure for table "devices"
#

DROP TABLE IF EXISTS `devices`;
CREATE TABLE `devices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` int(11) NOT NULL,
  `push_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` enum('android','ios') COLLATE utf8mb4_unicode_ci NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '设备码',
  `device_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_version` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `app_name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `app_version` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci COMMENT 'UA',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "devices"
#


#
# Structure for table "dictionaries"
#

DROP TABLE IF EXISTS `dictionaries`;
CREATE TABLE `dictionaries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `function_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '功能名称',
  `field_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '字段名称',
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '功能标识',
  `content` text COLLATE utf8mb4_unicode_ci,
  `model_ids` json DEFAULT NULL COMMENT '各模型ids',
  `per_length` int(11) NOT NULL DEFAULT '10',
  `max_num` int(11) NOT NULL DEFAULT '20' COMMENT '最大值',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "dictionaries"
#


#
# Structure for table "distribute_page_contents"
#

DROP TABLE IF EXISTS `distribute_page_contents`;
CREATE TABLE `distribute_page_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(11) NOT NULL DEFAULT '0' COMMENT '分发页id',
  `custom_range` json NOT NULL,
  `register_img_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `banners` json NOT NULL,
  `product_ids` json NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "distribute_page_contents"
#


#
# Structure for table "distribute_pages"
#

DROP TABLE IF EXISTS `distribute_pages`;
CREATE TABLE `distribute_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '渠道码',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '分发页名称',
  `template_id` int(11) NOT NULL DEFAULT '0' COMMENT '模板id',
  `reduce_type` enum('register','apply_register') COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态:0=>停用,1=>正常',
  `support_custom` tinyint(4) NOT NULL DEFAULT '0',
  `custom_status` tinyint(4) NOT NULL DEFAULT '0',
  `custom_range` json NOT NULL COMMENT '可定制范围:banner,register,product',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '分发页地址',
  `qrcode_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '二维码地址',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "distribute_pages"
#


#
# Structure for table "distribute_templates"
#

DROP TABLE IF EXISTS `distribute_templates`;
CREATE TABLE `distribute_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '模板名称',
  `support_custom` tinyint(4) NOT NULL DEFAULT '0',
  `custom_status` tinyint(4) NOT NULL DEFAULT '0',
  `custom_range` json NOT NULL COMMENT '可',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "distribute_templates"
#


#
# Structure for table "districts"
#

DROP TABLE IF EXISTS `districts`;
CREATE TABLE `districts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adcode` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '行政编码',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名字',
  `center` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '经纬度',
  `level` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '级别',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `initials` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '首字母',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `pinyin` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `web_status` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3727 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "districts"
#

INSERT INTO `districts` VALUES (1,'110000','北京市','116.405285,39.904989','province',0,9999,'B','2018-12-14 00:19:53','2019-02-23 07:28:28','beijing','北京',NULL),(2,'110100','北京市','116.405285,39.904989','city',1,0,'B','2018-12-14 00:19:53','2019-02-23 07:28:28','beijing','北京',1),(3,'110101','东城区','116.418757,39.917544','district',2,0,'D','2018-12-14 00:19:53','2019-02-23 07:28:28','dongchengqu','东城区',NULL),(4,'110102','西城区','116.366794,39.915309','district',2,0,'X','2018-12-14 00:19:53','2019-02-23 07:28:28','xichengqu','西城区',NULL),(5,'110105','朝阳区','116.486409,39.921489','district',2,0,'Z','2018-12-14 00:19:53','2019-02-23 07:28:28','zhaoyangqu','朝阳区',NULL),(6,'110106','丰台区','116.286968,39.863642','district',2,0,'F','2018-12-14 00:19:53','2019-02-23 07:28:28','fengtaiqu','丰台区',NULL),(7,'110107','石景山区','116.195445,39.914601','district',2,0,'S','2018-12-14 00:19:53','2019-02-23 07:28:29','shijingshanqu','石景山区',NULL),(8,'110108','海淀区','116.310316,39.956074','district',2,0,'H','2018-12-14 00:19:53','2019-02-23 07:28:29','haidianqu','海淀区',NULL),(9,'110109','门头沟区','116.105381,39.937183','district',2,0,'M','2018-12-14 00:19:53','2019-02-23 07:28:29','mentougouqu','门头沟区',NULL),(10,'110111','房山区','116.139157,39.735535','district',2,0,'F','2018-12-14 00:19:53','2019-02-23 07:28:29','fangshanqu','房山区',NULL),(11,'110112','通州区','116.658603,39.902486','district',2,0,'T','2018-12-14 00:19:53','2019-02-23 07:28:29','tongzhouqu','通州区',NULL),(12,'110113','顺义区','116.653525,40.128936','district',2,0,'S','2018-12-14 00:19:53','2019-02-23 07:28:29','shunyiqu','顺义区',NULL),(13,'110114','昌平区','116.235906,40.218085','district',2,0,'C','2018-12-14 00:19:53','2019-02-23 07:28:29','changpingqu','昌平区',NULL),(14,'110115','大兴区','116.338033,39.728908','district',2,0,'D','2018-12-14 00:19:53','2019-02-23 07:28:29','daxingqu','大兴区',NULL),(15,'110116','怀柔区','116.637122,40.324272','district',2,0,'H','2018-12-14 00:19:53','2019-02-23 07:28:29','huairouqu','怀柔区',NULL),(16,'110117','平谷区','117.112335,40.144783','district',2,0,'P','2018-12-14 00:19:53','2019-02-23 07:28:29','pingguqu','平谷区',NULL),(17,'110118','密云区','116.843352,40.377362','district',2,0,'M','2018-12-14 00:19:53','2019-02-23 07:28:29','miyunqu','密云区',NULL),(18,'110119','延庆区','115.985006,40.465325','district',2,0,'Y','2018-12-14 00:19:53','2019-02-23 07:28:29','yanqingqu','延庆区',NULL),(19,'120000','天津市','117.190182,39.125596','province',0,9002,'T','2018-12-14 00:19:53','2019-02-23 07:28:29','tianjin','天津',NULL),(20,'120100','天津市','117.190182,39.125596','city',19,0,'T','2018-12-14 00:19:54','2019-02-23 07:28:29','tianjin','天津',1),(21,'120101','和平区','117.195907,39.118327','district',20,0,'H','2018-12-14 00:19:54','2019-02-23 07:28:29','hepingqu','和平区',NULL),(22,'120102','河东区','117.226568,39.122125','district',20,0,'H','2018-12-14 00:19:54','2019-02-23 07:28:29','hedongqu','河东区',NULL),(23,'120103','河西区','117.217536,39.101897','district',20,0,'H','2018-12-14 00:19:54','2019-02-23 07:28:29','hexiqu','河西区',NULL),(24,'120104','南开区','117.164143,39.120474','district',20,0,'N','2018-12-14 00:19:54','2019-02-23 07:28:29','nankaiqu','南开区',NULL),(25,'120105','河北区','117.201569,39.156632','district',20,0,'H','2018-12-14 00:19:54','2019-02-23 07:28:29','hebeiqu','河北区',NULL),(26,'120106','红桥区','117.163301,39.175066','district',20,0,'H','2018-12-14 00:19:54','2019-02-23 07:28:29','hongqiaoqu','红桥区',NULL),(27,'120110','东丽区','117.313967,39.087764','district',20,0,'D','2018-12-14 00:19:54','2019-02-23 07:28:29','dongliqu','东丽区',NULL),(28,'120111','西青区','117.012247,39.139446','district',20,0,'X','2018-12-14 00:19:54','2019-02-23 07:28:29','xiqingqu','西青区',NULL),(29,'120112','津南区','117.382549,38.989577','district',20,0,'J','2018-12-14 00:19:54','2019-02-23 07:28:29','jinnanqu','津南区',NULL),(30,'120113','北辰区','117.13482,39.225555','district',20,0,'B','2018-12-14 00:19:54','2019-02-23 07:28:29','beichenqu','北辰区',NULL),(31,'120114','武清区','117.057959,39.376925','district',20,0,'W','2018-12-14 00:19:54','2019-02-23 07:28:29','wuqingqu','武清区',NULL),(32,'120115','宝坻区','117.308094,39.716965','district',20,0,'B','2018-12-14 00:19:54','2019-02-23 07:28:29','baodiqu','宝坻区',NULL),(33,'120116','滨海新区','117.654173,39.032846','district',20,0,'B','2018-12-14 00:19:54','2019-02-23 07:28:29','binhaixinqu','滨海新区',NULL),(34,'120117','宁河区','117.82828,39.328886','district',20,0,'N','2018-12-14 00:19:54','2019-02-23 07:28:29','ninghequ','宁河区',NULL),(35,'120118','静海区','116.925304,38.935671','district',20,0,'J','2018-12-14 00:19:54','2019-02-23 07:28:29','jinghaiqu','静海区',NULL),(36,'120119','蓟州区','117.407449,40.045342','district',20,0,'J','2018-12-14 00:19:54','2019-02-23 07:28:29','jizhouqu','蓟州区',NULL),(37,'130000','河北省','114.502461,38.045474','province',0,8000,'H','2018-12-14 00:19:54','2019-02-23 07:28:29','hebeisheng','河北省',NULL),(38,'130100','石家庄市','114.502461,38.045474','city',37,0,'S','2018-12-14 00:19:54','2019-02-23 07:28:29','shijiazhuang','石家庄',NULL),(39,'130102','长安区','114.548151,38.047501','district',38,0,'C','2018-12-14 00:19:55','2019-02-23 07:28:29','changanqu','长安区',NULL),(40,'130104','桥西区','114.462931,38.028383','district',38,0,'Q','2018-12-14 00:19:55','2019-02-23 07:28:29','qiaoxiqu','桥西区',NULL),(41,'130105','新华区','114.465974,38.067142','district',38,0,'X','2018-12-14 00:19:55','2019-02-23 07:28:29','xinhuaqu','新华区',NULL),(42,'130107','井陉矿区','114.058178,38.069748','district',38,0,'J','2018-12-14 00:19:55','2019-02-23 07:28:29','jingxingkuangqu','井陉矿区',NULL),(43,'130108','裕华区','114.533257,38.027696','district',38,0,'Y','2018-12-14 00:19:55','2019-02-23 07:28:29','yuhuaqu','裕华区',NULL),(44,'130109','藁城区','114.849647,38.033767','district',38,0,'G','2018-12-14 00:19:55','2019-02-23 07:28:29','gaochengqu','藁城区',NULL),(45,'130110','鹿泉区','114.321023,38.093994','district',38,0,'L','2018-12-14 00:19:55','2019-02-23 07:28:30','luquanqu','鹿泉区',NULL),(46,'130111','栾城区','114.654281,37.886911','district',38,0,'L','2018-12-14 00:19:55','2019-02-23 07:28:30','luanchengqu','栾城区',NULL),(47,'130121','井陉县','114.144488,38.033614','district',38,0,'J','2018-12-14 00:19:55','2019-02-23 07:28:30','jingxingxian','井陉县',NULL),(48,'130123','正定县','114.569887,38.147835','district',38,0,'Z','2018-12-14 00:19:55','2019-02-23 07:28:30','zhengdingxian','正定县',NULL),(49,'130125','行唐县','114.552734,38.437422','district',38,0,'X','2018-12-14 00:19:55','2019-02-23 07:28:30','xingtangxian','行唐县',NULL),(50,'130126','灵寿县','114.37946,38.306546','district',38,0,'L','2018-12-14 00:19:55','2019-02-23 07:28:30','lingshouxian','灵寿县',NULL),(51,'130127','高邑县','114.610699,37.605714','district',38,0,'G','2018-12-14 00:19:55','2019-02-23 07:28:30','gaoyixian','高邑县',NULL),(52,'130128','深泽县','115.200207,38.18454','district',38,0,'S','2018-12-14 00:19:55','2019-02-23 07:28:30','shenzexian','深泽县',NULL),(53,'130129','赞皇县','114.387756,37.660199','district',38,0,'Z','2018-12-14 00:19:55','2019-02-23 07:28:30','zanhuangxian','赞皇县',NULL),(54,'130130','无极县','114.977845,38.176376','district',38,0,'W','2018-12-14 00:19:55','2019-02-23 07:28:30','wujixian','无极县',NULL),(55,'130131','平山县','114.184144,38.259311','district',38,0,'P','2018-12-14 00:19:55','2019-02-23 07:28:30','pingshanxian','平山县',NULL),(56,'130132','元氏县','114.52618,37.762514','district',38,0,'Y','2018-12-14 00:19:55','2019-02-23 07:28:30','yuanshixian','元氏县',NULL),(57,'130133','赵县','114.775362,37.754341','district',38,0,'Z','2018-12-14 00:19:55','2019-02-23 07:28:30','zhaoxian','赵县',NULL),(58,'130181','辛集市','115.217451,37.92904','district',38,0,'X','2018-12-14 00:19:55','2019-02-23 07:28:30','xinji','辛集',NULL),(59,'130183','晋州市','115.044886,38.027478','district',38,0,'J','2018-12-14 00:19:55','2019-02-23 07:28:30','jinzhou','晋州',NULL),(60,'130184','新乐市','114.68578,38.344768','district',38,0,'X','2018-12-14 00:19:56','2019-02-23 07:28:30','xinle','新乐',NULL),(61,'130200','唐山市','118.175393,39.635113','city',37,0,'T','2018-12-14 00:19:56','2019-02-23 07:28:30','tangshan','唐山',NULL),(62,'130202','路南区','118.210821,39.615162','district',61,0,'L','2018-12-14 00:19:56','2019-02-23 07:28:30','lunanqu','路南区',NULL),(63,'130203','路北区','118.174736,39.628538','district',61,0,'L','2018-12-14 00:19:56','2019-02-23 07:28:30','lubeiqu','路北区',NULL),(64,'130204','古冶区','118.45429,39.715736','district',61,0,'G','2018-12-14 00:19:56','2019-02-23 07:28:30','guyequ','古冶区',NULL),(65,'130205','开平区','118.264425,39.676171','district',61,0,'K','2018-12-14 00:19:56','2019-02-23 07:28:30','kaipingqu','开平区',NULL),(66,'130207','丰南区','118.110793,39.56303','district',61,0,'F','2018-12-14 00:19:56','2019-02-23 07:28:30','fengnanqu','丰南区',NULL),(67,'130208','丰润区','118.155779,39.831363','district',61,0,'F','2018-12-14 00:19:56','2019-02-23 07:28:30','fengrunqu','丰润区',NULL),(68,'130209','曹妃甸区','118.446585,39.278277','district',61,0,'C','2018-12-14 00:19:56','2019-02-23 07:28:30','caofeidianqu','曹妃甸区',NULL),(69,'130223','滦县','118.699547,39.744851','district',61,0,'L','2018-12-14 00:19:56','2019-02-23 07:28:30','luanxian','滦县',NULL),(70,'130224','滦南县','118.681552,39.506201','district',61,0,'L','2018-12-14 00:19:56','2019-02-23 07:28:30','luannanxian','滦南县',NULL),(71,'130225','乐亭县','118.905341,39.42813','district',61,0,'L','2018-12-14 00:19:56','2019-02-23 07:28:30','letingxian','乐亭县',NULL),(72,'130227','迁西县','118.305139,40.146238','district',61,0,'Q','2018-12-14 00:19:56','2019-02-23 07:28:30','qianxixian','迁西县',NULL),(73,'130229','玉田县','117.753665,39.887323','district',61,0,'Y','2018-12-14 00:19:56','2019-02-23 07:28:30','yutianxian','玉田县',NULL),(74,'130281','遵化市','117.965875,40.188616','district',61,0,'Z','2018-12-14 00:19:56','2019-02-23 07:28:30','zunhua','遵化',NULL),(75,'130283','迁安市','118.701933,40.012108','district',61,0,'Q','2018-12-14 00:19:56','2019-02-23 07:28:30','qianan','迁安',NULL),(76,'130300','秦皇岛市','119.586579,39.942531','city',37,0,'Q','2018-12-14 00:19:56','2019-02-23 07:28:30','qinhuangdao','秦皇岛',NULL),(77,'130302','海港区','119.596224,39.943458','district',76,0,'H','2018-12-14 00:19:56','2019-02-23 07:28:30','haigangqu','海港区',NULL),(78,'130303','山海关区','119.753591,39.998023','district',76,0,'S','2018-12-14 00:19:56','2019-02-23 07:28:30','shanhaiguanqu','山海关区',NULL),(79,'130304','北戴河区','119.486286,39.825121','district',76,0,'B','2018-12-14 00:19:56','2019-02-23 07:28:30','beidaihequ','北戴河区',NULL),(80,'130306','抚宁区','119.240651,39.887053','district',76,0,'F','2018-12-14 00:19:56','2019-02-23 07:28:30','funingqu','抚宁区',NULL),(81,'130321','青龙满族自治县','118.954555,40.406023','district',76,0,'Q','2018-12-14 00:19:57','2019-02-23 07:28:30','qinglongmanzuzizhixian','青龙满族自治县',NULL),(82,'130322','昌黎县','119.164541,39.709729','district',76,0,'C','2018-12-14 00:19:57','2019-02-23 07:28:30','changlixian','昌黎县',NULL),(83,'130324','卢龙县','118.881809,39.891639','district',76,0,'L','2018-12-14 00:19:57','2019-02-23 07:28:31','lulongxian','卢龙县',NULL),(84,'130400','邯郸市','114.490686,36.612273','city',37,0,'H','2018-12-14 00:19:57','2019-02-23 07:28:31','handan','邯郸',NULL),(85,'130402','邯山区','114.484989,36.603196','district',84,0,'H','2018-12-14 00:19:57','2019-02-23 07:28:31','hanshanqu','邯山区',NULL),(86,'130403','丛台区','114.494703,36.611082','district',84,0,'C','2018-12-14 00:19:57','2019-02-23 07:28:31','congtaiqu','丛台区',NULL),(87,'130404','复兴区','114.458242,36.615484','district',84,0,'F','2018-12-14 00:19:57','2019-02-23 07:28:31','fuxingqu','复兴区',NULL),(88,'130406','峰峰矿区','114.209936,36.420487','district',84,0,'F','2018-12-14 00:19:57','2019-02-23 07:28:31','fengfengkuangqu','峰峰矿区',NULL),(89,'130407','肥乡区','114.805154,36.555778','district',84,0,'F','2018-12-14 00:19:57','2019-02-23 07:28:31','feixiangqu','肥乡区',NULL),(90,'130408','永年区','114.496162,36.776413','district',84,0,'Y','2018-12-14 00:19:57','2019-02-23 07:28:31','yongnianqu','永年区',NULL),(91,'130423','临漳县','114.610703,36.337604','district',84,0,'L','2018-12-14 00:19:57','2019-02-23 07:28:31','linzhangxian','临漳县',NULL),(92,'130424','成安县','114.680356,36.443832','district',84,0,'C','2018-12-14 00:19:57','2019-02-23 07:28:31','chenganxian','成安县',NULL),(93,'130425','大名县','115.152586,36.283316','district',84,0,'D','2018-12-14 00:19:57','2019-02-23 07:28:31','damingxian','大名县',NULL),(94,'130426','涉县','113.673297,36.563143','district',84,0,'S','2018-12-14 00:19:57','2019-02-23 07:28:31','shexian','涉县',NULL),(95,'130427','磁县','114.38208,36.367673','district',84,0,'C','2018-12-14 00:19:57','2019-02-23 07:28:31','cixian','磁县',NULL),(96,'130430','邱县','115.168584,36.81325','district',84,0,'Q','2018-12-14 00:19:57','2019-02-23 07:28:31','qiuxian','邱县',NULL),(97,'130431','鸡泽县','114.878517,36.914908','district',84,0,'J','2018-12-14 00:19:57','2019-02-23 07:28:31','jizexian','鸡泽县',NULL),(98,'130432','广平县','114.950859,36.483603','district',84,0,'G','2018-12-14 00:19:57','2019-02-23 07:28:31','guangpingxian','广平县',NULL),(99,'130433','馆陶县','115.289057,36.539461','district',84,0,'G','2018-12-14 00:19:57','2019-02-23 07:28:31','guantaoxian','馆陶县',NULL),(100,'130434','魏县','114.93411,36.354248','district',84,0,'W','2018-12-14 00:19:57','2019-02-23 07:28:31','weixian','魏县',NULL),(101,'130435','曲周县','114.957588,36.773398','district',84,0,'Q','2018-12-14 00:19:57','2019-02-23 07:28:31','quzhouxian','曲周县',NULL),(102,'130481','武安市','114.194581,36.696115','district',84,0,'W','2018-12-14 00:19:58','2019-02-23 07:28:31','wuan','武安',NULL),(103,'130500','邢台市','114.508851,37.0682','city',37,0,'X','2018-12-14 00:19:58','2019-02-23 07:28:31','xingtai','邢台',NULL),(104,'130502','桥东区','114.507131,37.064125','district',103,0,'Q','2018-12-14 00:19:58','2019-02-23 07:28:31','qiaodongqu','桥东区',NULL),(105,'130503','桥西区','114.473687,37.068009','district',103,0,'Q','2018-12-14 00:19:58','2019-02-23 07:28:31','qiaoxiqu','桥西区',NULL),(106,'130521','邢台县','114.561132,37.05073','district',103,0,'X','2018-12-14 00:19:58','2019-02-23 07:28:31','xingtaixian','邢台县',NULL),(107,'130522','临城县','114.506873,37.444009','district',103,0,'L','2018-12-14 00:19:58','2019-02-23 07:28:31','linchengxian','临城县',NULL),(108,'130523','内丘县','114.511523,37.287663','district',103,0,'N','2018-12-14 00:19:58','2019-02-23 07:28:31','neiqiuxian','内丘县',NULL),(109,'130524','柏乡县','114.693382,37.483596','district',103,0,'B','2018-12-14 00:19:58','2019-02-23 07:28:31','baixiangxian','柏乡县',NULL),(110,'130525','隆尧县','114.776348,37.350925','district',103,0,'L','2018-12-14 00:19:58','2019-02-23 07:28:31','longyaoxian','隆尧县',NULL),(111,'130526','任县','114.684469,37.129952','district',103,0,'R','2018-12-14 00:19:58','2019-02-23 07:28:31','renxian','任县',NULL),(112,'130527','南和县','114.691377,37.003812','district',103,0,'N','2018-12-14 00:19:58','2019-02-23 07:28:31','nanhexian','南和县',NULL),(113,'130528','宁晋县','114.921027,37.618956','district',103,0,'N','2018-12-14 00:19:58','2019-02-23 07:28:31','ningjinxian','宁晋县',NULL),(114,'130529','巨鹿县','115.038782,37.21768','district',103,0,'J','2018-12-14 00:19:58','2019-02-23 07:28:31','juluxian','巨鹿县',NULL),(115,'130530','新河县','115.247537,37.526216','district',103,0,'X','2018-12-14 00:19:58','2019-02-23 07:28:31','xinhexian','新河县',NULL),(116,'130531','广宗县','115.142797,37.075548','district',103,0,'G','2018-12-14 00:19:58','2019-02-23 07:28:31','guangzongxian','广宗县',NULL),(117,'130532','平乡县','115.029218,37.069404','district',103,0,'P','2018-12-14 00:19:58','2019-02-23 07:28:31','pingxiangxian','平乡县',NULL),(118,'130533','威县','115.272749,36.983272','district',103,0,'W','2018-12-14 00:19:58','2019-02-23 07:28:31','weixian','威县',NULL),(119,'130534','清河县','115.668999,37.059991','district',103,0,'Q','2018-12-14 00:19:58','2019-02-23 07:28:32','qinghexian','清河县',NULL),(120,'130535','临西县','115.498684,36.8642','district',103,0,'L','2018-12-14 00:19:58','2019-02-23 07:28:32','linxixian','临西县',NULL),(121,'130581','南宫市','115.398102,37.359668','district',103,0,'N','2018-12-14 00:19:59','2019-02-23 07:28:32','nangong','南宫',NULL),(122,'130582','沙河市','114.504902,36.861903','district',103,0,'S','2018-12-14 00:19:59','2019-02-23 07:28:32','shahe','沙河',NULL),(123,'130600','保定市','115.482331,38.867657','city',37,0,'B','2018-12-14 00:19:59','2019-02-23 07:28:32','baoding','保定',NULL),(124,'130602','竞秀区','115.470659,38.88662','district',123,0,'J','2018-12-14 00:19:59','2019-02-23 07:28:32','jingxiuqu','竞秀区',NULL),(125,'130606','莲池区','115.500934,38.865005','district',123,0,'L','2018-12-14 00:19:59','2019-02-23 07:28:32','lianchiqu','莲池区',NULL),(126,'130607','满城区','115.32442,38.95138','district',123,0,'M','2018-12-14 00:19:59','2019-02-23 07:28:32','manchengqu','满城区',NULL),(127,'130608','清苑区','115.492221,38.771012','district',123,0,'Q','2018-12-14 00:19:59','2019-02-23 07:28:32','qingyuanqu','清苑区',NULL),(128,'130609','徐水区','115.64941,39.020395','district',123,0,'X','2018-12-14 00:19:59','2019-02-23 07:28:32','xushuiqu','徐水区',NULL),(129,'130623','涞水县','115.711985,39.393148','district',123,0,'L','2018-12-14 00:19:59','2019-02-23 07:28:32','laishuixian','涞水县',NULL),(130,'130624','阜平县','114.198801,38.847276','district',123,0,'F','2018-12-14 00:19:59','2019-02-23 07:28:32','fupingxian','阜平县',NULL),(131,'130626','定兴县','115.796895,39.266195','district',123,0,'D','2018-12-14 00:19:59','2019-02-23 07:28:32','dingxingxian','定兴县',NULL),(132,'130627','唐县','114.981241,38.748542','district',123,0,'T','2018-12-14 00:19:59','2019-02-23 07:28:32','tangxian','唐县',NULL),(133,'130628','高阳县','115.778878,38.690092','district',123,0,'G','2018-12-14 00:19:59','2019-02-23 07:28:32','gaoyangxian','高阳县',NULL),(134,'130629','容城县','115.866247,39.05282','district',123,0,'R','2018-12-14 00:19:59','2019-02-23 07:28:32','rongchengxian','容城县',NULL),(135,'130630','涞源县','114.692567,39.35755','district',123,0,'L','2018-12-14 00:19:59','2019-02-23 07:28:32','laiyuanxian','涞源县',NULL),(136,'130631','望都县','115.154009,38.707448','district',123,0,'W','2018-12-14 00:19:59','2019-02-23 07:28:32','wangduxian','望都县',NULL),(137,'130632','安新县','115.931979,38.929912','district',123,0,'A','2018-12-14 00:19:59','2019-02-23 07:28:32','anxinxian','安新县',NULL),(138,'130633','易县','115.501146,39.35297','district',123,0,'Y','2018-12-14 00:19:59','2019-02-23 07:28:32','yixian','易县',NULL),(139,'130634','曲阳县','114.704055,38.619992','district',123,0,'Q','2018-12-14 00:19:59','2019-02-23 07:28:32','quyangxian','曲阳县',NULL),(140,'130635','蠡县','115.583631,38.496429','district',123,0,'L','2018-12-14 00:19:59','2019-02-23 07:28:32','lixian','蠡县',NULL),(141,'130636','顺平县','115.132749,38.845127','district',123,0,'S','2018-12-14 00:20:00','2019-02-23 07:28:32','shunpingxian','顺平县',NULL),(142,'130637','博野县','115.461798,38.458271','district',123,0,'B','2018-12-14 00:20:00','2019-02-23 07:28:32','boyexian','博野县',NULL),(143,'130638','雄县','116.107474,38.990819','district',123,0,'X','2018-12-14 00:20:00','2019-02-23 07:28:32','xiongxian','雄县',NULL),(144,'130681','涿州市','115.973409,39.485765','district',123,0,'Z','2018-12-14 00:20:00','2019-02-23 07:28:32','zhuozhou','涿州',NULL),(145,'130682','定州市','114.991389,38.517602','district',123,0,'D','2018-12-14 00:20:00','2019-02-23 07:28:32','dingzhou','定州',NULL),(146,'130683','安国市','115.33141,38.421367','district',123,0,'A','2018-12-14 00:20:00','2019-02-23 07:28:32','anguo','安国',NULL),(147,'130684','高碑店市','115.882704,39.327689','district',123,0,'G','2018-12-14 00:20:00','2019-02-23 07:28:32','gaobeidian','高碑店',NULL),(148,'130700','张家口市','114.884091,40.811901','city',37,0,'Z','2018-12-14 00:20:00','2019-02-23 07:28:32','zhangjiakou','张家口',NULL),(149,'130702','桥东区','114.885658,40.813875','district',148,0,'Q','2018-12-14 00:20:00','2019-02-23 07:28:32','qiaodongqu','桥东区',NULL),(150,'130703','桥西区','114.882127,40.824385','district',148,0,'Q','2018-12-14 00:20:00','2019-02-23 07:28:32','qiaoxiqu','桥西区',NULL),(151,'130705','宣化区','115.0632,40.609368','district',148,0,'X','2018-12-14 00:20:00','2019-02-23 07:28:32','xuanhuaqu','宣化区',NULL),(152,'130706','下花园区','115.281002,40.488645','district',148,0,'X','2018-12-14 00:20:00','2019-02-23 07:28:32','xiahuayuanqu','下花园区',NULL),(153,'130708','万全区','114.736131,40.765136','district',148,0,'W','2018-12-14 00:20:00','2019-02-23 07:28:32','wanquanqu','万全区',NULL),(154,'130709','崇礼区','115.281652,40.971302','district',148,0,'C','2018-12-14 00:20:00','2019-02-23 07:28:32','chongliqu','崇礼区',NULL),(155,'130722','张北县','114.715951,41.151713','district',148,0,'Z','2018-12-14 00:20:00','2019-02-23 07:28:32','zhangbeixian','张北县',NULL),(156,'130723','康保县','114.615809,41.850046','district',148,0,'K','2018-12-14 00:20:00','2019-02-23 07:28:32','kangbaoxian','康保县',NULL),(157,'130724','沽源县','115.684836,41.667419','district',148,0,'G','2018-12-14 00:20:00','2019-02-23 07:28:32','guyuanxian','沽源县',NULL),(158,'130725','尚义县','113.977713,41.080091','district',148,0,'S','2018-12-14 00:20:00','2019-02-23 07:28:33','shangyixian','尚义县',NULL),(159,'130726','蔚县','114.582695,39.837181','district',148,0,'Y','2018-12-14 00:20:00','2019-02-23 07:28:33','yuxian','蔚县',NULL),(160,'130727','阳原县','114.167343,40.113419','district',148,0,'Y','2018-12-14 00:20:00','2019-02-23 07:28:33','yangyuanxian','阳原县',NULL),(161,'130728','怀安县','114.422364,40.671274','district',148,0,'H','2018-12-14 00:20:00','2019-02-23 07:28:33','huaianxian','怀安县',NULL),(162,'130730','怀来县','115.520846,40.405405','district',148,0,'H','2018-12-14 00:20:00','2019-02-23 07:28:33','huailaixian','怀来县',NULL),(163,'130731','涿鹿县','115.219246,40.378701','district',148,0,'Z','2018-12-14 00:20:01','2019-02-23 07:28:33','zhuoluxian','涿鹿县',NULL),(164,'130732','赤城县','115.832708,40.912081','district',148,0,'C','2018-12-14 00:20:01','2019-02-23 07:28:33','chichengxian','赤城县',NULL),(165,'130800','承德市','117.939152,40.976204','city',37,0,'C','2018-12-14 00:20:01','2019-02-23 07:28:33','chengde','承德',NULL),(166,'130802','双桥区','117.939152,40.976204','district',165,0,'S','2018-12-14 00:20:01','2019-02-23 07:28:33','shuangqiaoqu','双桥区',NULL),(167,'130803','双滦区','117.797485,40.959756','district',165,0,'S','2018-12-14 00:20:01','2019-02-23 07:28:33','shuangluanqu','双滦区',NULL),(168,'130804','鹰手营子矿区','117.661154,40.546956','district',165,0,'Y','2018-12-14 00:20:01','2019-02-23 07:28:33','yingshouyingzikuangqu','鹰手营子矿区',NULL),(169,'130821','承德县','118.172496,40.768637','district',165,0,'C','2018-12-14 00:20:01','2019-02-23 07:28:33','chengdexian','承德县',NULL),(170,'130822','兴隆县','117.507098,40.418525','district',165,0,'X','2018-12-14 00:20:01','2019-02-23 07:28:33','xinglongxian','兴隆县',NULL),(171,'130824','滦平县','117.337124,40.936644','district',165,0,'L','2018-12-14 00:20:01','2019-02-23 07:28:33','luanpingxian','滦平县',NULL),(172,'130825','隆化县','117.736343,41.316667','district',165,0,'L','2018-12-14 00:20:01','2019-02-23 07:28:33','longhuaxian','隆化县',NULL),(173,'130826','丰宁满族自治县','116.65121,41.209903','district',165,0,'F','2018-12-14 00:20:01','2019-02-23 07:28:33','fengningmanzuzizhixian','丰宁满族自治县',NULL),(174,'130827','宽城满族自治县','118.488642,40.607981','district',165,0,'K','2018-12-14 00:20:01','2019-02-23 07:28:33','kuanchengmanzuzizhixian','宽城满族自治县',NULL),(175,'130828','围场满族蒙古族自治县','117.764086,41.949404','district',165,0,'W','2018-12-14 00:20:01','2019-02-23 07:28:33','weichangmanzumengguzuzizhixian','围场满族蒙古族自治县',NULL),(176,'130881','平泉市','118.690238,41.00561','district',165,0,'P','2018-12-14 00:20:01','2019-02-23 07:28:33','pingquan','平泉',NULL),(177,'130900','沧州市','116.857461,38.310582','city',37,0,'C','2018-12-14 00:20:01','2019-02-23 07:28:33','cangzhou','沧州',NULL),(178,'130902','新华区','116.873049,38.308273','district',177,0,'X','2018-12-14 00:20:01','2019-02-23 07:28:33','xinhuaqu','新华区',NULL),(179,'130903','运河区','116.840063,38.307405','district',177,0,'Y','2018-12-14 00:20:01','2019-02-23 07:28:33','yunhequ','运河区',NULL),(180,'130921','沧县','117.007478,38.219856','district',177,0,'C','2018-12-14 00:20:01','2019-02-23 07:28:33','cangxian','沧县',NULL),(181,'130922','青县','116.838384,38.569646','district',177,0,'Q','2018-12-14 00:20:01','2019-02-23 07:28:33','qingxian','青县',NULL),(182,'130923','东光县','116.542062,37.88655','district',177,0,'D','2018-12-14 00:20:01','2019-02-23 07:28:33','dongguangxian','东光县',NULL),(183,'130924','海兴县','117.496606,38.141582','district',177,0,'H','2018-12-14 00:20:01','2019-02-23 07:28:33','haixingxian','海兴县',NULL),(184,'130925','盐山县','117.229814,38.056141','district',177,0,'Y','2018-12-14 00:20:02','2019-02-23 07:28:33','yanshanxian','盐山县',NULL),(185,'130926','肃宁县','115.835856,38.427102','district',177,0,'S','2018-12-14 00:20:02','2019-02-23 07:28:33','suningxian','肃宁县',NULL),(186,'130927','南皮县','116.709171,38.042439','district',177,0,'N','2018-12-14 00:20:02','2019-02-23 07:28:33','nanpixian','南皮县',NULL),(187,'130928','吴桥县','116.391512,37.628182','district',177,0,'W','2018-12-14 00:20:02','2019-02-23 07:28:33','wuqiaoxian','吴桥县',NULL),(188,'130929','献县','116.123844,38.189661','district',177,0,'X','2018-12-14 00:20:02','2019-02-23 07:28:33','xianxian','献县',NULL),(189,'130930','孟村回族自治县','117.105104,38.057953','district',177,0,'M','2018-12-14 00:20:02','2019-02-23 07:28:33','mengcunhuizuzizhixian','孟村回族自治县',NULL),(190,'130981','泊头市','116.570163,38.073479','district',177,0,'B','2018-12-14 00:20:02','2019-02-23 07:28:33','potou','泊头',NULL),(191,'130982','任丘市','116.106764,38.706513','district',177,0,'R','2018-12-14 00:20:02','2019-02-23 07:28:33','renqiu','任丘',NULL),(192,'130983','黄骅市','117.343803,38.369238','district',177,0,'H','2018-12-14 00:20:02','2019-02-23 07:28:33','huanghua','黄骅',NULL),(193,'130984','河间市','116.089452,38.44149','district',177,0,'H','2018-12-14 00:20:02','2019-02-23 07:28:33','hejian','河间',NULL),(194,'131000','廊坊市','116.704441,39.523927','city',37,0,'L','2018-12-14 00:20:02','2019-02-23 07:28:33','langfang','廊坊',NULL),(195,'131002','安次区','116.694544,39.502569','district',194,0,'A','2018-12-14 00:20:02','2019-02-23 07:28:34','anciqu','安次区',NULL),(196,'131003','广阳区','116.713708,39.521931','district',194,0,'G','2018-12-14 00:20:02','2019-02-23 07:28:34','guangyangqu','广阳区',NULL),(197,'131022','固安县','116.299894,39.436468','district',194,0,'G','2018-12-14 00:20:02','2019-02-23 07:28:34','guanxian','固安县',NULL),(198,'131023','永清县','116.498089,39.319717','district',194,0,'Y','2018-12-14 00:20:02','2019-02-23 07:28:34','yongqingxian','永清县',NULL),(199,'131024','香河县','117.007161,39.757212','district',194,0,'X','2018-12-14 00:20:02','2019-02-23 07:28:34','xianghexian','香河县',NULL),(200,'131025','大城县','116.640735,38.699215','district',194,0,'D','2018-12-14 00:20:02','2019-02-23 07:28:34','daichengxian','大城县',NULL),(201,'131026','文安县','116.460107,38.866801','district',194,0,'W','2018-12-14 00:20:02','2019-02-23 07:28:34','wenanxian','文安县',NULL),(202,'131028','大厂回族自治县','116.986501,39.889266','district',194,0,'D','2018-12-14 00:20:02','2019-02-23 07:28:34','dachanghuizuzizhixian','大厂回族自治县',NULL),(203,'131081','霸州市','116.392021,39.117331','district',194,0,'B','2018-12-14 00:20:02','2019-02-23 07:28:34','bazhou','霸州',NULL),(204,'131082','三河市','117.077018,39.982778','district',194,0,'S','2018-12-14 00:20:02','2019-02-23 07:28:34','sanhe','三河',NULL),(205,'131100','衡水市','115.665993,37.735097','city',37,0,'H','2018-12-14 00:20:03','2019-02-23 07:28:34','hengshui','衡水',NULL),(206,'131102','桃城区','115.694945,37.732237','district',205,0,'T','2018-12-14 00:20:03','2019-02-23 07:28:34','taochengqu','桃城区',NULL),(207,'131103','冀州区','115.579173,37.542788','district',205,0,'J','2018-12-14 00:20:03','2019-02-23 07:28:34','jizhouqu','冀州区',NULL),(208,'131121','枣强县','115.726499,37.511512','district',205,0,'Z','2018-12-14 00:20:03','2019-02-23 07:28:34','zaoqiangxian','枣强县',NULL),(209,'131122','武邑县','115.892415,37.803774','district',205,0,'W','2018-12-14 00:20:03','2019-02-23 07:28:34','wuyixian','武邑县',NULL),(210,'131123','武强县','115.970236,38.03698','district',205,0,'W','2018-12-14 00:20:03','2019-02-23 07:28:34','wuqiangxian','武强县',NULL),(211,'131124','饶阳县','115.726577,38.232671','district',205,0,'R','2018-12-14 00:20:03','2019-02-23 07:28:34','raoyangxian','饶阳县',NULL),(212,'131125','安平县','115.519627,38.233511','district',205,0,'A','2018-12-14 00:20:03','2019-02-23 07:28:34','anpingxian','安平县',NULL),(213,'131126','故城县','115.966747,37.350981','district',205,0,'G','2018-12-14 00:20:03','2019-02-23 07:28:34','guchengxian','故城县',NULL),(214,'131127','景县','116.258446,37.686622','district',205,0,'J','2018-12-14 00:20:03','2019-02-23 07:28:34','jingxian','景县',NULL),(215,'131128','阜城县','116.164727,37.869945','district',205,0,'F','2018-12-14 00:20:03','2019-02-23 07:28:34','fuchengxian','阜城县',NULL),(216,'131182','深州市','115.554596,38.00347','district',205,0,'S','2018-12-14 00:20:03','2019-02-23 07:28:34','shenzhou','深州',NULL),(217,'140000','山西省','112.549248,37.857014','province',0,4500,'S','2018-12-14 00:20:03','2019-02-23 07:28:34','shanxisheng','山西省',NULL),(218,'140100','太原市','112.549248,37.857014','city',217,0,'T','2018-12-14 00:20:03','2019-02-23 07:28:34','taiyuan','太原',NULL),(219,'140105','小店区','112.564273,37.817974','district',218,0,'X','2018-12-14 00:20:03','2019-02-23 07:28:34','xiaodianqu','小店区',NULL),(220,'140106','迎泽区','112.558851,37.855804','district',218,0,'Y','2018-12-14 00:20:03','2019-02-23 07:28:34','yingzequ','迎泽区',NULL),(221,'140107','杏花岭区','112.560743,37.879291','district',218,0,'X','2018-12-14 00:20:03','2019-02-23 07:28:34','xinghualingqu','杏花岭区',NULL),(222,'140108','尖草坪区','112.487122,37.939893','district',218,0,'J','2018-12-14 00:20:03','2019-02-23 07:28:34','jiancaopingqu','尖草坪区',NULL),(223,'140109','万柏林区','112.522258,37.862653','district',218,0,'W','2018-12-14 00:20:03','2019-02-23 07:28:34','wanbolinqu','万柏林区',NULL),(224,'140110','晋源区','112.477849,37.715619','district',218,0,'J','2018-12-14 00:20:03','2019-02-23 07:28:34','jinyuanqu','晋源区',NULL),(225,'140121','清徐县','112.357961,37.60729','district',218,0,'Q','2018-12-14 00:20:03','2019-02-23 07:28:34','qingxuxian','清徐县',NULL),(226,'140122','阳曲县','112.673818,38.058797','district',218,0,'Y','2018-12-14 00:20:03','2019-02-23 07:28:34','yangquxian','阳曲县',NULL),(227,'140123','娄烦县','111.793798,38.066035','district',218,0,'L','2018-12-14 00:20:04','2019-02-23 07:28:34','loufanxian','娄烦县',NULL),(228,'140181','古交市','112.174353,37.908534','district',218,0,'G','2018-12-14 00:20:04','2019-02-23 07:28:34','gujiao','古交',NULL),(229,'140200','大同市','113.295259,40.09031','city',217,0,'D','2018-12-14 00:20:04','2019-02-23 07:28:34','datong','大同',NULL),(230,'140202','城区','113.301438,40.090511','district',229,0,'C','2018-12-14 00:20:04','2019-02-23 07:28:34','chengqu','城区',NULL),(231,'140203','矿区','113.168656,40.03626','district',229,0,'K','2018-12-14 00:20:04','2019-02-23 07:28:34','kuangqu','矿区',NULL),(232,'140211','南郊区','113.16892,40.01802','district',229,0,'N','2018-12-14 00:20:04','2019-02-23 07:28:34','nanjiaoqu','南郊区',NULL),(233,'140212','新荣区','113.141044,40.258269','district',229,0,'X','2018-12-14 00:20:04','2019-02-23 07:28:35','xinrongqu','新荣区',NULL),(234,'140221','阳高县','113.749871,40.364927','district',229,0,'Y','2018-12-14 00:20:04','2019-02-23 07:28:35','yanggaoxian','阳高县',NULL),(235,'140222','天镇县','114.09112,40.421336','district',229,0,'T','2018-12-14 00:20:04','2019-02-23 07:28:35','tianzhenxian','天镇县',NULL),(236,'140223','广灵县','114.279252,39.763051','district',229,0,'G','2018-12-14 00:20:04','2019-02-23 07:28:35','guanglingxian','广灵县',NULL),(237,'140224','灵丘县','114.23576,39.438867','district',229,0,'L','2018-12-14 00:20:04','2019-02-23 07:28:35','lingqiuxian','灵丘县',NULL),(238,'140225','浑源县','113.698091,39.699099','district',229,0,'H','2018-12-14 00:20:04','2019-02-23 07:28:35','hunyuanxian','浑源县',NULL),(239,'140226','左云县','112.70641,40.012873','district',229,0,'Z','2018-12-14 00:20:04','2019-02-23 07:28:35','zuoyunxian','左云县',NULL),(240,'140227','大同县','113.611306,40.039345','district',229,0,'D','2018-12-14 00:20:04','2019-02-23 07:28:35','datongxian','大同县',NULL),(241,'140300','阳泉市','113.583285,37.861188','city',217,0,'Y','2018-12-14 00:20:04','2019-02-23 07:28:35','yangquan','阳泉',NULL),(242,'140302','城区','113.586513,37.860938','district',241,0,'C','2018-12-14 00:20:04','2019-02-23 07:28:35','chengqu','城区',NULL),(243,'140303','矿区','113.559066,37.870085','district',241,0,'K','2018-12-14 00:20:04','2019-02-23 07:28:35','kuangqu','矿区',NULL),(244,'140311','郊区','113.58664,37.94096','district',241,0,'J','2018-12-14 00:20:04','2019-02-23 07:28:35','jiaoqu','郊区',NULL),(245,'140321','平定县','113.631049,37.800289','district',241,0,'P','2018-12-14 00:20:04','2019-02-23 07:28:35','pingdingxian','平定县',NULL),(246,'140322','盂县','113.41223,38.086131','district',241,0,'Y','2018-12-14 00:20:04','2019-02-23 07:28:35','yuxian','盂县',NULL),(247,'140400','长治市','113.113556,36.191112','city',217,0,'C','2018-12-14 00:20:04','2019-02-23 07:28:35','changzhi','长治',NULL),(248,'140402','城区','113.114107,36.187896','district',247,0,'C','2018-12-14 00:20:05','2019-02-23 07:28:35','chengqu','城区',NULL),(249,'140411','郊区','113.101211,36.218388','district',247,0,'J','2018-12-14 00:20:05','2019-02-23 07:28:35','jiaoqu','郊区',NULL),(250,'140421','长治县','113.056679,36.052438','district',247,0,'C','2018-12-14 00:20:05','2019-02-23 07:28:35','changzhixian','长治县',NULL),(251,'140423','襄垣县','113.050094,36.532854','district',247,0,'X','2018-12-14 00:20:05','2019-02-23 07:28:35','xiangyuanxian','襄垣县',NULL),(252,'140424','屯留县','112.892741,36.314072','district',247,0,'T','2018-12-14 00:20:05','2019-02-23 07:28:35','tunliuxian','屯留县',NULL),(253,'140425','平顺县','113.438791,36.200202','district',247,0,'P','2018-12-14 00:20:05','2019-02-23 07:28:35','pingshunxian','平顺县',NULL),(254,'140426','黎城县','113.387366,36.502971','district',247,0,'L','2018-12-14 00:20:05','2019-02-23 07:28:35','lichengxian','黎城县',NULL),(255,'140427','壶关县','113.206138,36.110938','district',247,0,'H','2018-12-14 00:20:05','2019-02-23 07:28:35','huguanxian','壶关县',NULL),(256,'140428','长子县','112.884656,36.119484','district',247,0,'C','2018-12-14 00:20:05','2019-02-23 07:28:35','changzixian','长子县',NULL),(257,'140429','武乡县','112.8653,36.834315','district',247,0,'W','2018-12-14 00:20:05','2019-02-23 07:28:35','wuxiangxian','武乡县',NULL),(258,'140430','沁县','112.70138,36.757123','district',247,0,'Q','2018-12-14 00:20:05','2019-02-23 07:28:35','qinxian','沁县',NULL),(259,'140431','沁源县','112.340878,36.500777','district',247,0,'Q','2018-12-14 00:20:05','2019-02-23 07:28:35','qinyuanxian','沁源县',NULL),(260,'140481','潞城市','113.223245,36.332233','district',247,0,'L','2018-12-14 00:20:05','2019-02-23 07:28:35','lucheng','潞城',NULL),(261,'140500','晋城市','112.851274,35.497553','city',217,0,'J','2018-12-14 00:20:05','2019-02-23 07:28:35','jincheng','晋城',NULL),(262,'140502','城区','112.853106,35.496641','district',261,0,'C','2018-12-14 00:20:05','2019-02-23 07:28:35','chengqu','城区',NULL),(263,'140521','沁水县','112.187213,35.689472','district',261,0,'Q','2018-12-14 00:20:05','2019-02-23 07:28:35','qinshuixian','沁水县',NULL),(264,'140522','阳城县','112.422014,35.482177','district',261,0,'Y','2018-12-14 00:20:05','2019-02-23 07:28:35','yangchengxian','阳城县',NULL),(265,'140524','陵川县','113.278877,35.775614','district',261,0,'L','2018-12-14 00:20:05','2019-02-23 07:28:35','lingchuanxian','陵川县',NULL),(266,'140525','泽州县','112.899137,35.617221','district',261,0,'Z','2018-12-14 00:20:05','2019-02-23 07:28:35','zezhouxian','泽州县',NULL),(267,'140581','高平市','112.930691,35.791355','district',261,0,'G','2018-12-14 00:20:05','2019-02-23 07:28:35','gaoping','高平',NULL),(268,'140600','朔州市','112.433387,39.331261','city',217,0,'S','2018-12-14 00:20:05','2019-02-23 07:28:35','shuozhou','朔州',NULL),(269,'140602','朔城区','112.428676,39.324525','district',268,0,'S','2018-12-14 00:20:05','2019-02-23 07:28:35','shuochengqu','朔城区',NULL),(270,'140603','平鲁区','112.295227,39.515603','district',268,0,'P','2018-12-14 00:20:06','2019-02-23 07:28:36','pingluqu','平鲁区',NULL),(271,'140621','山阴县','112.816396,39.52677','district',268,0,'S','2018-12-14 00:20:06','2019-02-23 07:28:36','shanyinxian','山阴县',NULL),(272,'140622','应县','113.187505,39.559187','district',268,0,'Y','2018-12-14 00:20:06','2019-02-23 07:28:36','yingxian','应县',NULL),(273,'140623','右玉县','112.465588,39.988812','district',268,0,'Y','2018-12-14 00:20:06','2019-02-23 07:28:36','youyuxian','右玉县',NULL),(274,'140624','怀仁县','113.100512,39.82079','district',268,0,'H','2018-12-14 00:20:06','2019-02-23 07:28:36','huairenxian','怀仁县',NULL),(275,'140700','晋中市','112.736465,37.696495','city',217,0,'J','2018-12-14 00:20:06','2019-02-23 07:28:36','jinzhong','晋中',NULL),(276,'140702','榆次区','112.740056,37.6976','district',275,0,'Y','2018-12-14 00:20:06','2019-02-23 07:28:36','yuciqu','榆次区',NULL),(277,'140721','榆社县','112.973521,37.069019','district',275,0,'Y','2018-12-14 00:20:06','2019-02-23 07:28:36','yushexian','榆社县',NULL),(278,'140722','左权县','113.377834,37.079672','district',275,0,'Z','2018-12-14 00:20:06','2019-02-23 07:28:36','zuoquanxian','左权县',NULL),(279,'140723','和顺县','113.572919,37.327027','district',275,0,'H','2018-12-14 00:20:06','2019-02-23 07:28:36','heshunxian','和顺县',NULL),(280,'140724','昔阳县','113.706166,37.60437','district',275,0,'X','2018-12-14 00:20:06','2019-02-23 07:28:36','xiyangxian','昔阳县',NULL),(281,'140725','寿阳县','113.177708,37.891136','district',275,0,'S','2018-12-14 00:20:06','2019-02-23 07:28:36','shouyangxian','寿阳县',NULL),(282,'140726','太谷县','112.554103,37.424595','district',275,0,'T','2018-12-14 00:20:06','2019-02-23 07:28:36','taiguxian','太谷县',NULL),(283,'140727','祁县','112.330532,37.358739','district',275,0,'Q','2018-12-14 00:20:06','2019-02-23 07:28:36','qixian','祁县',NULL),(284,'140728','平遥县','112.174059,37.195474','district',275,0,'P','2018-12-14 00:20:06','2019-02-23 07:28:36','pingyaoxian','平遥县',NULL),(285,'140729','灵石县','111.772759,36.847469','district',275,0,'L','2018-12-14 00:20:06','2019-02-23 07:28:36','lingshixian','灵石县',NULL),(286,'140781','介休市','111.913857,37.027616','district',275,0,'J','2018-12-14 00:20:06','2019-02-23 07:28:36','jiexiu','介休',NULL),(287,'140800','运城市','111.003957,35.022778','city',217,0,'Y','2018-12-14 00:20:06','2019-02-23 07:28:36','yuncheng','运城',NULL),(288,'140802','盐湖区','111.000627,35.025643','district',287,0,'Y','2018-12-14 00:20:06','2019-02-23 07:28:36','yanhuqu','盐湖区',NULL),(289,'140821','临猗县','110.77493,35.141883','district',287,0,'L','2018-12-14 00:20:06','2019-02-23 07:28:36','linyixian','临猗县',NULL),(290,'140822','万荣县','110.843561,35.417042','district',287,0,'W','2018-12-14 00:20:06','2019-02-23 07:28:36','wanrongxian','万荣县',NULL),(291,'140823','闻喜县','111.220306,35.353839','district',287,0,'W','2018-12-14 00:20:06','2019-02-23 07:28:36','wenxixian','闻喜县',NULL),(292,'140824','稷山县','110.978996,35.600412','district',287,0,'J','2018-12-14 00:20:07','2019-02-23 07:28:36','jishanxian','稷山县',NULL),(293,'140825','新绛县','111.225205,35.613697','district',287,0,'X','2018-12-14 00:20:07','2019-02-23 07:28:36','xinjiangxian','新绛县',NULL),(294,'140826','绛县','111.576182,35.49045','district',287,0,'J','2018-12-14 00:20:07','2019-02-23 07:28:36','jiangxian','绛县',NULL),(295,'140827','垣曲县','111.67099,35.298293','district',287,0,'Y','2018-12-14 00:20:07','2019-02-23 07:28:36','yuanquxian','垣曲县',NULL),(296,'140828','夏县','111.223174,35.140441','district',287,0,'X','2018-12-14 00:20:07','2019-02-23 07:28:36','xiaxian','夏县',NULL),(297,'140829','平陆县','111.212377,34.837256','district',287,0,'P','2018-12-14 00:20:07','2019-02-23 07:28:36','pingluxian','平陆县',NULL),(298,'140830','芮城县','110.69114,34.694769','district',287,0,'R','2018-12-14 00:20:07','2019-02-23 07:28:36','ruichengxian','芮城县',NULL),(299,'140881','永济市','110.447984,34.865125','district',287,0,'Y','2018-12-14 00:20:07','2019-02-23 07:28:36','yongji','永济',NULL),(300,'140882','河津市','110.710268,35.59715','district',287,0,'H','2018-12-14 00:20:07','2019-02-23 07:28:36','hejin','河津',NULL),(301,'140900','忻州市','112.733538,38.41769','city',217,0,'X','2018-12-14 00:20:07','2019-02-23 07:28:36','xinzhou','忻州',NULL),(302,'140902','忻府区','112.734112,38.417743','district',301,0,'X','2018-12-14 00:20:07','2019-02-23 07:28:36','xinfuqu','忻府区',NULL),(303,'140921','定襄县','112.963231,38.484948','district',301,0,'D','2018-12-14 00:20:07','2019-02-23 07:28:36','dingxiangxian','定襄县',NULL),(304,'140922','五台县','113.259012,38.725711','district',301,0,'W','2018-12-14 00:20:07','2019-02-23 07:28:36','wutaixian','五台县',NULL),(305,'140923','代县','112.962519,39.065138','district',301,0,'D','2018-12-14 00:20:07','2019-02-23 07:28:36','daixian','代县',NULL),(306,'140924','繁峙县','113.267707,39.188104','district',301,0,'F','2018-12-14 00:20:07','2019-02-23 07:28:37','fanshixian','繁峙县',NULL),(307,'140925','宁武县','112.307936,39.001718','district',301,0,'N','2018-12-14 00:20:07','2019-02-23 07:28:37','ningwuxian','宁武县',NULL),(308,'140926','静乐县','111.940231,38.355947','district',301,0,'J','2018-12-14 00:20:07','2019-02-23 07:28:37','jinglexian','静乐县',NULL),(309,'140927','神池县','112.200438,39.088467','district',301,0,'S','2018-12-14 00:20:07','2019-02-23 07:28:37','shenchixian','神池县',NULL),(310,'140928','五寨县','111.841015,38.912761','district',301,0,'W','2018-12-14 00:20:07','2019-02-23 07:28:37','wuzhaixian','五寨县',NULL),(311,'140929','岢岚县','111.56981,38.705625','district',301,0,'K','2018-12-14 00:20:07','2019-02-23 07:28:37','kelanxian','岢岚县',NULL),(312,'140930','河曲县','111.146609,39.381895','district',301,0,'H','2018-12-14 00:20:08','2019-02-23 07:28:37','hequxian','河曲县',NULL),(313,'140931','保德县','111.085688,39.022576','district',301,0,'B','2018-12-14 00:20:08','2019-02-23 07:28:37','baodexian','保德县',NULL),(314,'140932','偏关县','111.500477,39.442153','district',301,0,'P','2018-12-14 00:20:08','2019-02-23 07:28:37','pianguanxian','偏关县',NULL),(315,'140981','原平市','112.713132,38.729186','district',301,0,'Y','2018-12-14 00:20:08','2019-02-23 07:28:37','yuanping','原平',NULL),(316,'141000','临汾市','111.517973,36.08415','city',217,0,'L','2018-12-14 00:20:08','2019-02-23 07:28:37','linfen','临汾',NULL),(317,'141002','尧都区','111.522945,36.080366','district',316,0,'Y','2018-12-14 00:20:08','2019-02-23 07:28:37','yaoduqu','尧都区',NULL),(318,'141021','曲沃县','111.475529,35.641387','district',316,0,'Q','2018-12-14 00:20:08','2019-02-23 07:28:37','quwoxian','曲沃县',NULL),(319,'141022','翼城县','111.713508,35.738621','district',316,0,'Y','2018-12-14 00:20:08','2019-02-23 07:28:37','yichengxian','翼城县',NULL),(320,'141023','襄汾县','111.442932,35.876139','district',316,0,'X','2018-12-14 00:20:08','2019-02-23 07:28:37','xiangfenxian','襄汾县',NULL),(321,'141024','洪洞县','111.673692,36.255742','district',316,0,'H','2018-12-14 00:20:08','2019-02-23 07:28:37','hongtongxian','洪洞县',NULL),(322,'141025','古县','111.920207,36.26855','district',316,0,'G','2018-12-14 00:20:08','2019-02-23 07:28:37','guxian','古县',NULL),(323,'141026','安泽县','112.251372,36.146032','district',316,0,'A','2018-12-14 00:20:08','2019-02-23 07:28:37','anzexian','安泽县',NULL),(324,'141027','浮山县','111.850039,35.971359','district',316,0,'F','2018-12-14 00:20:08','2019-02-23 07:28:37','fushanxian','浮山县',NULL),(325,'141028','吉县','110.682853,36.099355','district',316,0,'J','2018-12-14 00:20:08','2019-02-23 07:28:37','jixian','吉县',NULL),(326,'141029','乡宁县','110.857365,35.975402','district',316,0,'X','2018-12-14 00:20:08','2019-02-23 07:28:37','xiangningxian','乡宁县',NULL),(327,'141030','大宁县','110.751283,36.46383','district',316,0,'D','2018-12-14 00:20:08','2019-02-23 07:28:37','daningxian','大宁县',NULL),(328,'141031','隰县','110.935809,36.692675','district',316,0,'X','2018-12-14 00:20:08','2019-02-23 07:28:37','xixian','隰县',NULL),(329,'141032','永和县','110.631276,36.760614','district',316,0,'Y','2018-12-14 00:20:08','2019-02-23 07:28:37','yonghexian','永和县',NULL),(330,'141033','蒲县','111.09733,36.411682','district',316,0,'P','2018-12-14 00:20:08','2019-02-23 07:28:37','puxian','蒲县',NULL),(331,'141034','汾西县','111.563021,36.653368','district',316,0,'F','2018-12-14 00:20:08','2019-02-23 07:28:37','fenxixian','汾西县',NULL),(332,'141081','侯马市','111.371272,35.620302','district',316,0,'H','2018-12-14 00:20:08','2019-02-23 07:28:37','houma','侯马',NULL),(333,'141082','霍州市','111.723103,36.57202','district',316,0,'H','2018-12-14 00:20:09','2019-02-23 07:28:37','huozhou','霍州',NULL),(334,'141100','吕梁市','111.134335,37.524366','city',217,0,'L','2018-12-14 00:20:09','2019-02-23 07:28:37','lvliang','吕梁',NULL),(335,'141102','离石区','111.134462,37.524037','district',334,0,'L','2018-12-14 00:20:09','2019-02-23 07:28:37','lishiqu','离石区',NULL),(336,'141121','文水县','112.032595,37.436314','district',334,0,'W','2018-12-14 00:20:09','2019-02-23 07:28:37','wenshuixian','文水县',NULL),(337,'141122','交城县','112.159154,37.555155','district',334,0,'J','2018-12-14 00:20:09','2019-02-23 07:28:37','jiaochengxian','交城县',NULL),(338,'141123','兴县','111.124816,38.464136','district',334,0,'X','2018-12-14 00:20:09','2019-02-23 07:28:37','xingxian','兴县',NULL),(339,'141124','临县','110.995963,37.960806','district',334,0,'L','2018-12-14 00:20:09','2019-02-23 07:28:37','linxian','临县',NULL),(340,'141125','柳林县','110.89613,37.431664','district',334,0,'L','2018-12-14 00:20:09','2019-02-23 07:28:37','liulinxian','柳林县',NULL),(341,'141126','石楼县','110.837119,36.999426','district',334,0,'S','2018-12-14 00:20:09','2019-02-23 07:28:37','shilouxian','石楼县',NULL),(342,'141127','岚县','111.671555,38.278654','district',334,0,'L','2018-12-14 00:20:09','2019-02-23 07:28:38','lanxian','岚县',NULL),(343,'141128','方山县','111.238885,37.892632','district',334,0,'F','2018-12-14 00:20:09','2019-02-23 07:28:38','fangshanxian','方山县',NULL),(344,'141129','中阳县','111.193319,37.342054','district',334,0,'Z','2018-12-14 00:20:09','2019-02-23 07:28:38','zhongyangxian','中阳县',NULL),(345,'141130','交口县','111.183188,36.983068','district',334,0,'J','2018-12-14 00:20:09','2019-02-23 07:28:38','jiaokouxian','交口县',NULL),(346,'141181','孝义市','111.781568,37.144474','district',334,0,'X','2018-12-14 00:20:09','2019-02-23 07:28:38','xiaoyi','孝义',NULL),(347,'141182','汾阳市','111.785273,37.267742','district',334,0,'F','2018-12-14 00:20:09','2019-02-23 07:28:38','fenyang','汾阳',NULL),(348,'150000','内蒙古自治区','111.670801,40.818311','province',0,3001,'N','2018-12-14 00:20:09','2019-02-23 07:28:38','neimengguzizhiqu','内蒙古自治区',NULL),(349,'150100','呼和浩特市','111.670801,40.818311','city',348,0,'H','2018-12-14 00:20:09','2019-02-23 07:28:38','huhehaote','呼和浩特',NULL),(350,'150102','新城区','111.685964,40.826225','district',349,0,'X','2018-12-14 00:20:09','2019-02-23 07:28:38','xinchengqu','新城区',NULL),(351,'150103','回民区','111.662162,40.815149','district',349,0,'H','2018-12-14 00:20:09','2019-02-23 07:28:38','huiminqu','回民区',NULL),(352,'150104','玉泉区','111.66543,40.799421','district',349,0,'Y','2018-12-14 00:20:09','2019-02-23 07:28:38','yuquanqu','玉泉区',NULL),(353,'150105','赛罕区','111.698463,40.807834','district',349,0,'S','2018-12-14 00:20:10','2019-02-23 07:28:38','saihanqu','赛罕区',NULL),(354,'150121','土默特左旗','111.133615,40.720416','district',349,0,'T','2018-12-14 00:20:10','2019-02-23 07:28:38','tumotezuoqi','土默特左旗',NULL),(355,'150122','托克托县','111.197317,40.276729','district',349,0,'T','2018-12-14 00:20:10','2019-02-23 07:28:38','tuoketuoxian','托克托县',NULL),(356,'150123','和林格尔县','111.824143,40.380288','district',349,0,'H','2018-12-14 00:20:10','2019-02-23 07:28:38','helingeerxian','和林格尔县',NULL),(357,'150124','清水河县','111.67222,39.912479','district',349,0,'Q','2018-12-14 00:20:10','2019-02-23 07:28:38','qingshuihexian','清水河县',NULL),(358,'150125','武川县','111.456563,41.094483','district',349,0,'W','2018-12-14 00:20:10','2019-02-23 07:28:38','wuchuanxian','武川县',NULL),(359,'150200','包头市','109.840405,40.658168','city',348,0,'B','2018-12-14 00:20:10','2019-02-23 07:28:38','baotou','包头',NULL),(360,'150202','东河区','110.026895,40.587056','district',359,0,'D','2018-12-14 00:20:10','2019-02-23 07:28:38','donghequ','东河区',NULL),(361,'150203','昆都仑区','109.822932,40.661345','district',359,0,'K','2018-12-14 00:20:10','2019-02-23 07:28:38','kundulunqu','昆都仑区',NULL),(362,'150204','青山区','109.880049,40.668558','district',359,0,'Q','2018-12-14 00:20:10','2019-02-23 07:28:38','qingshanqu','青山区',NULL),(363,'150205','石拐区','110.272565,40.672094','district',359,0,'S','2018-12-14 00:20:10','2019-02-23 07:28:38','shiguaiqu','石拐区',NULL),(364,'150206','白云鄂博矿区','109.97016,41.769246','district',359,0,'B','2018-12-14 00:20:10','2019-02-23 07:28:38','baiyunebokuangqu','白云鄂博矿区',NULL),(365,'150207','九原区','109.968122,40.600581','district',359,0,'J','2018-12-14 00:20:10','2019-02-23 07:28:38','jiuyuanqu','九原区',NULL),(366,'150221','土默特右旗','110.526766,40.566434','district',359,0,'T','2018-12-14 00:20:10','2019-02-23 07:28:38','tumoteyouqi','土默特右旗',NULL),(367,'150222','固阳县','110.063421,41.030004','district',359,0,'G','2018-12-14 00:20:10','2019-02-23 07:28:38','guyangxian','固阳县',NULL),(368,'150223','达尔罕茂明安联合旗','110.438452,41.702836','district',359,0,'D','2018-12-14 00:20:10','2019-02-23 07:28:38','daerhanmaominganlianheqi','达尔罕茂明安联合旗',NULL),(369,'150300','乌海市','106.825563,39.673734','city',348,0,'W','2018-12-14 00:20:10','2019-02-23 07:28:38','wuhai','乌海',NULL),(370,'150302','海勃湾区','106.817762,39.673527','district',369,0,'H','2018-12-14 00:20:10','2019-02-23 07:28:38','haibowanqu','海勃湾区',NULL),(371,'150303','海南区','106.884789,39.44153','district',369,0,'H','2018-12-14 00:20:10','2019-02-23 07:28:38','hainanqu','海南区',NULL),(372,'150304','乌达区','106.722711,39.502288','district',369,0,'W','2018-12-14 00:20:10','2019-02-23 07:28:38','wudaqu','乌达区',NULL),(373,'150400','赤峰市','118.956806,42.275317','city',348,0,'C','2018-12-14 00:20:11','2019-02-23 07:28:38','chifeng','赤峰',NULL),(374,'150402','红山区','118.961087,42.269732','district',373,0,'H','2018-12-14 00:20:11','2019-02-23 07:28:38','hongshanqu','红山区',NULL),(375,'150403','元宝山区','119.289877,42.041168','district',373,0,'Y','2018-12-14 00:20:11','2019-02-23 07:28:38','yuanbaoshanqu','元宝山区',NULL),(376,'150404','松山区','118.938958,42.281046','district',373,0,'S','2018-12-14 00:20:11','2019-02-23 07:28:39','songshanqu','松山区',NULL),(377,'150421','阿鲁科尔沁旗','120.094969,43.87877','district',373,0,'A','2018-12-14 00:20:11','2019-02-23 07:28:39','alukeerqinqi','阿鲁科尔沁旗',NULL),(378,'150422','巴林左旗','119.391737,43.980715','district',373,0,'B','2018-12-14 00:20:11','2019-02-23 07:28:39','balinzuoqi','巴林左旗',NULL),(379,'150423','巴林右旗','118.678347,43.528963','district',373,0,'B','2018-12-14 00:20:11','2019-02-23 07:28:39','balinyouqi','巴林右旗',NULL),(380,'150424','林西县','118.05775,43.605326','district',373,0,'L','2018-12-14 00:20:11','2019-02-23 07:28:39','linxixian','林西县',NULL),(381,'150425','克什克腾旗','117.542465,43.256233','district',373,0,'K','2018-12-14 00:20:11','2019-02-23 07:28:39','keshiketengqi','克什克腾旗',NULL),(382,'150426','翁牛特旗','119.022619,42.937128','district',373,0,'W','2018-12-14 00:20:11','2019-02-23 07:28:39','wengniuteqi','翁牛特旗',NULL),(383,'150428','喀喇沁旗','118.708572,41.92778','district',373,0,'K','2018-12-14 00:20:11','2019-02-23 07:28:39','kalaqinqi','喀喇沁旗',NULL),(384,'150429','宁城县','119.339242,41.598692','district',373,0,'N','2018-12-14 00:20:11','2019-02-23 07:28:39','ningchengxian','宁城县',NULL),(385,'150430','敖汉旗','119.906486,42.287012','district',373,0,'A','2018-12-14 00:20:11','2019-02-23 07:28:39','aohanqi','敖汉旗',NULL),(386,'150500','通辽市','122.263119,43.617429','city',348,0,'T','2018-12-14 00:20:11','2019-02-23 07:28:39','tongliao','通辽',NULL),(387,'150502','科尔沁区','122.264042,43.617422','district',386,0,'K','2018-12-14 00:20:11','2019-02-23 07:28:39','keerqinqu','科尔沁区',NULL),(388,'150521','科尔沁左翼中旗','123.313873,44.127166','district',386,0,'K','2018-12-14 00:20:11','2019-02-23 07:28:39','keerqinzuoyizhongqi','科尔沁左翼中旗',NULL),(389,'150522','科尔沁左翼后旗','122.355155,42.954564','district',386,0,'K','2018-12-14 00:20:11','2019-02-23 07:28:39','keerqinzuoyihouqi','科尔沁左翼后旗',NULL),(390,'150523','开鲁县','121.308797,43.602432','district',386,0,'K','2018-12-14 00:20:11','2019-02-23 07:28:39','kailuxian','开鲁县',NULL),(391,'150524','库伦旗','121.774886,42.734692','district',386,0,'K','2018-12-14 00:20:11','2019-02-23 07:28:39','kulunqi','库伦旗',NULL),(392,'150525','奈曼旗','120.662543,42.84685','district',386,0,'N','2018-12-14 00:20:11','2019-02-23 07:28:39','naimanqi','奈曼旗',NULL),(393,'150526','扎鲁特旗','120.905275,44.555294','district',386,0,'Z','2018-12-14 00:20:12','2019-02-23 07:28:39','zaluteqi','扎鲁特旗',NULL),(394,'150581','霍林郭勒市','119.657862,45.532361','district',386,0,'H','2018-12-14 00:20:12','2019-02-23 07:28:39','huolinguole','霍林郭勒',NULL),(395,'150600','鄂尔多斯市','109.99029,39.817179','city',348,0,'E','2018-12-14 00:20:12','2019-02-23 07:28:39','eerduosi','鄂尔多斯',NULL),(396,'150602','东胜区','109.98945,39.81788','district',395,0,'D','2018-12-14 00:20:12','2019-02-23 07:28:39','dongshengqu','东胜区',NULL),(397,'150603','康巴什区','109.790076,39.607472','district',395,0,'K','2018-12-14 00:20:12','2019-02-23 07:28:39','kangbashenqu','康巴什区',NULL),(398,'150621','达拉特旗','110.040281,40.404076','district',395,0,'D','2018-12-14 00:20:12','2019-02-23 07:28:39','dalateqi','达拉特旗',NULL),(399,'150622','准格尔旗','111.238332,39.865221','district',395,0,'Z','2018-12-14 00:20:12','2019-02-23 07:28:39','zhungeerqi','准格尔旗',NULL),(400,'150623','鄂托克前旗','107.48172,38.183257','district',395,0,'E','2018-12-14 00:20:12','2019-02-23 07:28:39','etuokeqianqi','鄂托克前旗',NULL),(401,'150624','鄂托克旗','107.982604,39.095752','district',395,0,'E','2018-12-14 00:20:12','2019-02-23 07:28:39','etuokeqi','鄂托克旗',NULL),(402,'150625','杭锦旗','108.736324,39.831789','district',395,0,'H','2018-12-14 00:20:12','2019-02-23 07:28:39','hangjinqi','杭锦旗',NULL),(403,'150626','乌审旗','108.842454,38.596611','district',395,0,'W','2018-12-14 00:20:12','2019-02-23 07:28:39','wushenqi','乌审旗',NULL),(404,'150627','伊金霍洛旗','109.787402,39.604312','district',395,0,'Y','2018-12-14 00:20:12','2019-02-23 07:28:39','yijinhuoluoqi','伊金霍洛旗',NULL),(405,'150700','呼伦贝尔市','119.758168,49.215333','city',348,0,'H','2018-12-14 00:20:12','2019-02-23 07:28:39','hulunbeier','呼伦贝尔',NULL),(406,'150702','海拉尔区','119.764923,49.213889','district',405,0,'H','2018-12-14 00:20:12','2019-02-23 07:28:39','hailaerqu','海拉尔区',NULL),(407,'150703','扎赉诺尔区','117.716373,49.456567','district',405,0,'Z','2018-12-14 00:20:12','2019-02-23 07:28:39','zhalainuoerqu','扎赉诺尔区',NULL),(408,'150721','阿荣旗','123.464615,48.130503','district',405,0,'A','2018-12-14 00:20:12','2019-02-23 07:28:39','arongqi','阿荣旗',NULL),(409,'150722','莫力达瓦达斡尔族自治旗','124.507401,48.478385','district',405,0,'M','2018-12-14 00:20:12','2019-02-23 07:28:39','molidawadawoerzuzizhiqi','莫力达瓦达斡尔族自治旗',NULL),(410,'150723','鄂伦春自治旗','123.725684,50.590177','district',405,0,'E','2018-12-14 00:20:12','2019-02-23 07:28:39','elunchunzizhiqi','鄂伦春自治旗',NULL),(411,'150724','鄂温克族自治旗','119.754041,49.143293','district',405,0,'E','2018-12-14 00:20:12','2019-02-23 07:28:39','ewenkezuzizhiqi','鄂温克族自治旗',NULL),(412,'150725','陈巴尔虎旗','119.437609,49.328422','district',405,0,'C','2018-12-14 00:20:12','2019-02-23 07:28:39','chenbaerhuqi','陈巴尔虎旗',NULL),(413,'150726','新巴尔虎左旗','118.267454,48.216571','district',405,0,'X','2018-12-14 00:20:13','2019-02-23 07:28:40','xinbaerhuzuoqi','新巴尔虎左旗',NULL),(414,'150727','新巴尔虎右旗','116.825991,48.669134','district',405,0,'X','2018-12-14 00:20:13','2019-02-23 07:28:40','xinbaerhuyouqi','新巴尔虎右旗',NULL),(415,'150781','满洲里市','117.455561,49.590788','district',405,0,'M','2018-12-14 00:20:13','2019-02-23 07:28:40','manzhouli','满洲里',NULL),(416,'150782','牙克石市','120.729005,49.287024','district',405,0,'Y','2018-12-14 00:20:13','2019-02-23 07:28:40','yakeshi','牙克石',NULL),(417,'150783','扎兰屯市','122.744401,48.007412','district',405,0,'Z','2018-12-14 00:20:13','2019-02-23 07:28:40','zhalantun','扎兰屯',NULL),(418,'150784','额尔古纳市','120.178636,50.2439','district',405,0,'E','2018-12-14 00:20:13','2019-02-23 07:28:40','eerguna','额尔古纳',NULL),(419,'150785','根河市','121.532724,50.780454','district',405,0,'G','2018-12-14 00:20:13','2019-02-23 07:28:40','genhe','根河',NULL),(420,'150800','巴彦淖尔市','107.416959,40.757402','city',348,0,'B','2018-12-14 00:20:13','2019-02-23 07:28:40','bayannaoer','巴彦淖尔',NULL),(421,'150802','临河区','107.417018,40.757092','district',420,0,'L','2018-12-14 00:20:13','2019-02-23 07:28:40','linhequ','临河区',NULL),(422,'150821','五原县','108.270658,41.097639','district',420,0,'W','2018-12-14 00:20:13','2019-02-23 07:28:40','wuyuanxian','五原县',NULL),(423,'150822','磴口县','107.006056,40.330479','district',420,0,'D','2018-12-14 00:20:13','2019-02-23 07:28:40','dengkouxian','磴口县',NULL),(424,'150823','乌拉特前旗','108.656816,40.725209','district',420,0,'W','2018-12-14 00:20:13','2019-02-23 07:28:40','wulteqianqi','乌拉特前旗',NULL),(425,'150824','乌拉特中旗','108.515255,41.57254','district',420,0,'W','2018-12-14 00:20:13','2019-02-23 07:28:40','wultezhongqi','乌拉特中旗',NULL),(426,'150825','乌拉特后旗','107.074941,41.084307','district',420,0,'W','2018-12-14 00:20:13','2019-02-23 07:28:40','wultehouqi','乌拉特后旗',NULL),(427,'150826','杭锦后旗','107.147682,40.888797','district',420,0,'H','2018-12-14 00:20:13','2019-02-23 07:28:40','hangjinhouqi','杭锦后旗',NULL),(428,'150900','乌兰察布市','113.114543,41.034126','city',348,0,'W','2018-12-14 00:20:13','2019-02-23 07:28:40','wulanchabu','乌兰察布',NULL),(429,'150902','集宁区','113.116453,41.034134','district',428,0,'J','2018-12-14 00:20:13','2019-02-23 07:28:40','jiningqu','集宁区',NULL),(430,'150921','卓资县','112.577702,40.89576','district',428,0,'Z','2018-12-14 00:20:13','2019-02-23 07:28:40','zhuozixian','卓资县',NULL),(431,'150922','化德县','114.01008,41.899335','district',428,0,'H','2018-12-14 00:20:13','2019-02-23 07:28:40','huadexian','化德县',NULL),(432,'150923','商都县','113.560643,41.560163','district',428,0,'S','2018-12-14 00:20:13','2019-02-23 07:28:40','shangduxian','商都县',NULL),(433,'150924','兴和县','113.834009,40.872437','district',428,0,'X','2018-12-14 00:20:13','2019-02-23 07:28:40','xinghexian','兴和县',NULL),(434,'150925','凉城县','112.500911,40.531627','district',428,0,'L','2018-12-14 00:20:14','2019-02-23 07:28:40','liangchengxian','凉城县',NULL),(435,'150926','察哈尔右翼前旗','113.211958,40.786859','district',428,0,'C','2018-12-14 00:20:14','2019-02-23 07:28:40','chahaeryouyiqianqi','察哈尔右翼前旗',NULL),(436,'150927','察哈尔右翼中旗','112.633563,41.274212','district',428,0,'C','2018-12-14 00:20:14','2019-02-23 07:28:40','chahaeryouyizhongqi','察哈尔右翼中旗',NULL),(437,'150928','察哈尔右翼后旗','113.1906,41.447213','district',428,0,'C','2018-12-14 00:20:14','2019-02-23 07:28:40','chahaeryouyihouqi','察哈尔右翼后旗',NULL),(438,'150929','四子王旗','111.70123,41.528114','district',428,0,'S','2018-12-14 00:20:14','2019-02-23 07:28:40','siziwangqi','四子王旗',NULL),(439,'150981','丰镇市','113.163462,40.437534','district',428,0,'F','2018-12-14 00:20:14','2019-02-23 07:28:40','fengzhen','丰镇',NULL),(440,'152200','兴安盟','122.070317,46.076268','city',348,0,'X','2018-12-14 00:20:14','2019-02-23 07:28:40','xinganmeng','兴安盟',NULL),(441,'152201','乌兰浩特市','122.068975,46.077238','district',440,0,'W','2018-12-14 00:20:14','2019-02-23 07:28:40','wulanhaote','乌兰浩特',NULL),(442,'152202','阿尔山市','119.943656,47.177','district',440,0,'A','2018-12-14 00:20:14','2019-02-23 07:28:41','aershan','阿尔山',NULL),(443,'152221','科尔沁右翼前旗','121.957544,46.076497','district',440,0,'K','2018-12-14 00:20:14','2019-02-23 07:28:41','keerqinyouyiqianqi','科尔沁右翼前旗',NULL),(444,'152222','科尔沁右翼中旗','121.472818,45.059645','district',440,0,'K','2018-12-14 00:20:14','2019-02-23 07:28:41','keerqinyouyizhongqi','科尔沁右翼中旗',NULL),(445,'152223','扎赉特旗','122.909332,46.725136','district',440,0,'Z','2018-12-14 00:20:14','2019-02-23 07:28:41','zhalaiteqi','扎赉特旗',NULL),(446,'152224','突泉县','121.564856,45.380986','district',440,0,'T','2018-12-14 00:20:14','2019-02-23 07:28:41','tuquanxian','突泉县',NULL),(447,'152500','锡林郭勒盟','116.090996,43.944018','city',348,0,'X','2018-12-14 00:20:14','2019-02-23 07:28:41','xilinguolemeng','锡林郭勒盟',NULL),(448,'152501','二连浩特市','111.97981,43.652895','district',447,0,'E','2018-12-14 00:20:14','2019-02-23 07:28:41','erlianhaote','二连浩特',NULL),(449,'152502','锡林浩特市','116.091903,43.944301','district',447,0,'X','2018-12-14 00:20:14','2019-02-23 07:28:41','xilinhaote','锡林浩特',NULL),(450,'152522','阿巴嘎旗','114.970618,44.022728','district',447,0,'A','2018-12-14 00:20:14','2019-02-23 07:28:41','abagaqi','阿巴嘎旗',NULL),(451,'152523','苏尼特左旗','113.653412,43.854108','district',447,0,'S','2018-12-14 00:20:14','2019-02-23 07:28:41','sunitezuoqi','苏尼特左旗',NULL),(452,'152524','苏尼特右旗','112.65539,42.746662','district',447,0,'S','2018-12-14 00:20:14','2019-02-23 07:28:41','suniteyouqi','苏尼特右旗',NULL),(453,'152525','东乌珠穆沁旗','116.980022,45.510307','district',447,0,'D','2018-12-14 00:20:14','2019-02-23 07:28:41','dongwuzhumuqinqi','东乌珠穆沁旗',NULL),(454,'152526','西乌珠穆沁旗','117.615249,44.586147','district',447,0,'X','2018-12-14 00:20:15','2019-02-23 07:28:42','xiwuzhumuqinqi','西乌珠穆沁旗',NULL),(455,'152527','太仆寺旗','115.28728,41.895199','district',447,0,'T','2018-12-14 00:20:15','2019-02-23 07:28:42','taipusiqi','太仆寺旗',NULL),(456,'152528','镶黄旗','113.843869,42.239229','district',447,0,'X','2018-12-14 00:20:15','2019-02-23 07:28:42','xianghuangqi','镶黄旗',NULL),(457,'152529','正镶白旗','115.031423,42.286807','district',447,0,'Z','2018-12-14 00:20:15','2019-02-23 07:28:42','zhengxiangbaiqi','正镶白旗',NULL),(458,'152530','正蓝旗','116.003311,42.245895','district',447,0,'Z','2018-12-14 00:20:15','2019-02-23 07:28:42','zhenglanqi','正蓝旗',NULL),(459,'152531','多伦县','116.477288,42.197962','district',447,0,'D','2018-12-14 00:20:15','2019-02-23 07:28:42','duolunxian','多伦县',NULL),(460,'152900','阿拉善盟','105.706422,38.844814','city',348,0,'A','2018-12-14 00:20:15','2019-02-23 07:28:42','alashanmeng','阿拉善盟',NULL),(461,'152921','阿拉善左旗','105.70192,38.847241','district',460,0,'A','2018-12-14 00:20:15','2019-02-23 07:28:42','alashanzuoqi','阿拉善左旗',NULL),(462,'152922','阿拉善右旗','101.671984,39.21159','district',460,0,'A','2018-12-14 00:20:15','2019-02-23 07:28:42','alashanyouqi','阿拉善右旗',NULL),(463,'152923','额济纳旗','101.06944,41.958813','district',460,0,'E','2018-12-14 00:20:15','2019-02-23 07:28:42','ejinaqi','额济纳旗',NULL),(464,'210000','辽宁省','123.429096,41.796767','province',0,3600,'L','2018-12-14 00:20:15','2019-02-23 07:28:42','liaoningsheng','辽宁省',NULL),(465,'210100','沈阳市','123.429096,41.796767','city',464,0,'S','2018-12-14 00:20:15','2019-02-23 07:28:42','shenyang','沈阳',NULL),(466,'210102','和平区','123.406664,41.788074','district',465,0,'H','2018-12-14 00:20:15','2019-02-23 07:28:42','hepingqu','和平区',NULL),(467,'210103','沈河区','123.445696,41.795591','district',465,0,'S','2018-12-14 00:20:15','2019-02-23 07:28:42','shenhequ','沈河区',NULL),(468,'210104','大东区','123.469956,41.808503','district',465,0,'D','2018-12-14 00:20:15','2019-02-23 07:28:42','dadongqu','大东区',NULL),(469,'210105','皇姑区','123.405677,41.822336','district',465,0,'H','2018-12-14 00:20:15','2019-02-23 07:28:42','huangguqu','皇姑区',NULL),(470,'210106','铁西区','123.350664,41.787808','district',465,0,'T','2018-12-14 00:20:15','2019-02-23 07:28:42','tiexiqu','铁西区',NULL),(471,'210111','苏家屯区','123.341604,41.665904','district',465,0,'S','2018-12-14 00:20:15','2019-02-23 07:28:42','sujiatunqu','苏家屯区',NULL),(472,'210112','浑南区','123.458981,41.741946','district',465,0,'H','2018-12-14 00:20:15','2019-02-23 07:28:42','hunnanqu','浑南区',NULL),(473,'210113','沈北新区','123.521471,42.052312','district',465,0,'S','2018-12-14 00:20:15','2019-02-23 07:28:42','shenbeixinqu','沈北新区',NULL),(474,'210114','于洪区','123.310829,41.795833','district',465,0,'Y','2018-12-14 00:20:15','2019-02-23 07:28:42','yuhongqu','于洪区',NULL),(475,'210115','辽中区','122.731269,41.512725','district',465,0,'L','2018-12-14 00:20:16','2019-02-23 07:28:42','liaozhongqu','辽中区',NULL),(476,'210123','康平县','123.352703,42.741533','district',465,0,'K','2018-12-14 00:20:16','2019-02-23 07:28:42','kangpingxian','康平县',NULL),(477,'210124','法库县','123.416722,42.507045','district',465,0,'F','2018-12-14 00:20:16','2019-02-23 07:28:42','fakuxian','法库县',NULL),(478,'210181','新民市','122.828868,41.996508','district',465,0,'X','2018-12-14 00:20:16','2019-02-23 07:28:42','xinmin','新民',NULL),(479,'210200','大连市','121.618622,38.91459','city',464,0,'D','2018-12-14 00:20:16','2019-02-23 07:28:42','dalian','大连',1),(480,'210202','中山区','121.64376,38.921553','district',479,0,'Z','2018-12-14 00:20:16','2019-02-23 07:28:43','zhongshanqu','中山区',NULL),(481,'210203','西岗区','121.616112,38.914266','district',479,0,'X','2018-12-14 00:20:16','2019-02-23 07:28:43','xigangqu','西岗区',NULL),(482,'210204','沙河口区','121.593702,38.912859','district',479,0,'S','2018-12-14 00:20:16','2019-02-23 07:28:43','shahekouqu','沙河口区',NULL),(483,'210211','甘井子区','121.582614,38.975148','district',479,0,'G','2018-12-14 00:20:16','2019-02-23 07:28:43','ganjingziqu','甘井子区',NULL),(484,'210212','旅顺口区','121.26713,38.812043','district',479,0,'L','2018-12-14 00:20:16','2019-02-23 07:28:43','lvshunkouqu','旅顺口区',NULL),(485,'210213','金州区','121.789413,39.052745','district',479,0,'J','2018-12-14 00:20:16','2019-02-23 07:28:43','jinzhouqu','金州区',NULL),(486,'210214','普兰店区','121.9705,39.401555','district',479,0,'P','2018-12-14 00:20:16','2019-02-23 07:28:43','pulandianqu','普兰店区',NULL),(487,'210224','长海县','122.587824,39.272399','district',479,0,'C','2018-12-14 00:20:16','2019-02-23 07:28:43','changhaixian','长海县',NULL),(488,'210281','瓦房店市','122.002656,39.63065','district',479,0,'W','2018-12-14 00:20:16','2019-02-23 07:28:43','wafangdian','瓦房店',NULL),(489,'210283','庄河市','122.970612,39.69829','district',479,0,'Z','2018-12-14 00:20:16','2019-02-23 07:28:43','zhuanghe','庄河',NULL),(490,'210300','鞍山市','122.995632,41.110626','city',464,0,'A','2018-12-14 00:20:16','2019-02-23 07:28:43','anshan','鞍山',NULL),(491,'210302','铁东区','122.994475,41.110344','district',490,0,'T','2018-12-14 00:20:16','2019-02-23 07:28:43','tiedongqu','铁东区',NULL),(492,'210303','铁西区','122.971834,41.11069','district',490,0,'T','2018-12-14 00:20:16','2019-02-23 07:28:43','tiexiqu','铁西区',NULL),(493,'210304','立山区','123.024806,41.150622','district',490,0,'L','2018-12-14 00:20:16','2019-02-23 07:28:43','lishanqu','立山区',NULL),(494,'210311','千山区','122.949298,41.068909','district',490,0,'Q','2018-12-14 00:20:17','2019-02-23 07:28:43','qianshanqu','千山区',NULL),(495,'210321','台安县','122.429736,41.38686','district',490,0,'T','2018-12-14 00:20:17','2019-02-23 07:28:43','taianxian','台安县',NULL),(496,'210323','岫岩满族自治县','123.28833,40.281509','district',490,0,'X','2018-12-14 00:20:17','2019-02-23 07:28:43','xiuyanmanzuzizhixian','岫岩满族自治县',NULL),(497,'210381','海城市','122.752199,40.852533','district',490,0,'H','2018-12-14 00:20:17','2019-02-23 07:28:43','haicheng','海城',NULL),(498,'210400','抚顺市','123.921109,41.875956','city',464,0,'F','2018-12-14 00:20:17','2019-02-23 07:28:43','fushun','抚顺',NULL),(499,'210402','新抚区','123.902858,41.86082','district',498,0,'X','2018-12-14 00:20:17','2019-02-23 07:28:43','xinfuqu','新抚区',NULL),(500,'210403','东洲区','124.047219,41.866829','district',498,0,'D','2018-12-14 00:20:17','2019-02-23 07:28:43','dongzhouqu','东洲区',NULL),(501,'210404','望花区','123.801509,41.851803','district',498,0,'W','2018-12-14 00:20:17','2019-02-23 07:28:43','wanghuaqu','望花区',NULL),(502,'210411','顺城区','123.917165,41.881132','district',498,0,'S','2018-12-14 00:20:17','2019-02-23 07:28:43','shunchengqu','顺城区',NULL),(503,'210421','抚顺县','124.097979,41.922644','district',498,0,'F','2018-12-14 00:20:17','2019-02-23 07:28:43','fushunxian','抚顺县',NULL),(504,'210422','新宾满族自治县','125.037547,41.732456','district',498,0,'X','2018-12-14 00:20:17','2019-02-23 07:28:43','xinbinmanzuzizhixian','新宾满族自治县',NULL),(505,'210423','清原满族自治县','124.927192,42.10135','district',498,0,'Q','2018-12-14 00:20:17','2019-02-23 07:28:43','qingyuanmanzuzizhixian','清原满族自治县',NULL),(506,'210500','本溪市','123.770519,41.297909','city',464,0,'B','2018-12-14 00:20:17','2019-02-23 07:28:43','benxi','本溪',NULL),(507,'210502','平山区','123.761231,41.291581','district',506,0,'P','2018-12-14 00:20:17','2019-02-23 07:28:43','pingshanqu','平山区',NULL),(508,'210503','溪湖区','123.765226,41.330056','district',506,0,'X','2018-12-14 00:20:17','2019-02-23 07:28:43','xihuqu','溪湖区',NULL),(509,'210504','明山区','123.763288,41.302429','district',506,0,'M','2018-12-14 00:20:17','2019-02-23 07:28:43','mingshanqu','明山区',NULL),(510,'210505','南芬区','123.748381,41.104093','district',506,0,'N','2018-12-14 00:20:17','2019-02-23 07:28:43','nanfenqu','南芬区',NULL),(511,'210521','本溪满族自治县','124.126156,41.300344','district',506,0,'B','2018-12-14 00:20:17','2019-02-23 07:28:43','benximanzuzizhixian','本溪满族自治县',NULL),(512,'210522','桓仁满族自治县','125.359195,41.268997','district',506,0,'H','2018-12-14 00:20:17','2019-02-23 07:28:43','huanrenmanzuzizhixian','桓仁满族自治县',NULL),(513,'210600','丹东市','124.383044,40.124296','city',464,0,'D','2018-12-14 00:20:17','2019-02-23 07:28:43','dandong','丹东',NULL),(514,'210602','元宝区','124.397814,40.136483','district',513,0,'Y','2018-12-14 00:20:17','2019-02-23 07:28:43','yuanbaoqu','元宝区',NULL),(515,'210603','振兴区','124.361153,40.102801','district',513,0,'Z','2018-12-14 00:20:18','2019-02-23 07:28:43','zhenxingqu','振兴区',NULL),(516,'210604','振安区','124.427709,40.158557','district',513,0,'Z','2018-12-14 00:20:18','2019-02-23 07:28:43','zhenanqu','振安区',NULL),(517,'210624','宽甸满族自治县','124.784867,40.730412','district',513,0,'K','2018-12-14 00:20:18','2019-02-23 07:28:43','kuandianmanzuzizhixian','宽甸满族自治县',NULL),(518,'210681','东港市','124.149437,39.883467','district',513,0,'D','2018-12-14 00:20:18','2019-02-23 07:28:44','donggang','东港',NULL),(519,'210682','凤城市','124.071067,40.457567','district',513,0,'F','2018-12-14 00:20:18','2019-02-23 07:28:44','fengcheng','凤城',NULL),(520,'210700','锦州市','121.135742,41.119269','city',464,0,'J','2018-12-14 00:20:18','2019-02-23 07:28:44','jinzhou','锦州',NULL),(521,'210702','古塔区','121.130085,41.115719','district',520,0,'G','2018-12-14 00:20:18','2019-02-23 07:28:44','gutaqu','古塔区',NULL),(522,'210703','凌河区','121.151304,41.114662','district',520,0,'L','2018-12-14 00:20:18','2019-02-23 07:28:44','linghequ','凌河区',NULL),(523,'210711','太和区','121.107297,41.105378','district',520,0,'T','2018-12-14 00:20:18','2019-02-23 07:28:44','taihequ','太和区',NULL),(524,'210726','黑山县','122.117915,41.691804','district',520,0,'H','2018-12-14 00:20:18','2019-02-23 07:28:44','heishanxian','黑山县',NULL),(525,'210727','义县','121.242831,41.537224','district',520,0,'Y','2018-12-14 00:20:18','2019-02-23 07:28:44','yixian','义县',NULL),(526,'210781','凌海市','121.364236,41.171738','district',520,0,'L','2018-12-14 00:20:18','2019-02-23 07:28:44','linghai','凌海',NULL),(527,'210782','北镇市','121.795962,41.598764','district',520,0,'B','2018-12-14 00:20:18','2019-02-23 07:28:44','beizhen','北镇',NULL),(528,'210800','营口市','122.235151,40.667432','city',464,0,'Y','2018-12-14 00:20:18','2019-02-23 07:28:44','yingkou','营口',NULL),(529,'210802','站前区','122.253235,40.669949','district',528,0,'Z','2018-12-14 00:20:18','2019-02-23 07:28:44','zhanqianqu','站前区',NULL),(530,'210803','西市区','122.210067,40.663086','district',528,0,'X','2018-12-14 00:20:18','2019-02-23 07:28:44','xiqu','西区',NULL),(531,'210804','鲅鱼圈区','122.127242,40.263646','district',528,0,'B','2018-12-14 00:20:18','2019-02-23 07:28:44','bayuquanqu','鲅鱼圈区',NULL),(532,'210811','老边区','122.382584,40.682723','district',528,0,'L','2018-12-14 00:20:18','2019-02-23 07:28:44','laobianqu','老边区',NULL),(533,'210881','盖州市','122.355534,40.405234','district',528,0,'G','2018-12-14 00:20:18','2019-02-23 07:28:44','gaizhou','盖州',NULL),(534,'210882','大石桥市','122.505894,40.633973','district',528,0,'D','2018-12-14 00:20:18','2019-02-23 07:28:44','dashiqiao','大石桥',NULL),(535,'210900','阜新市','121.648962,42.011796','city',464,0,'F','2018-12-14 00:20:19','2019-02-23 07:28:44','fuxin','阜新',NULL),(536,'210902','海州区','121.657639,42.011162','district',535,0,'H','2018-12-14 00:20:19','2019-02-23 07:28:44','haizhouqu','海州区',NULL),(537,'210903','新邱区','121.790541,42.086603','district',535,0,'X','2018-12-14 00:20:19','2019-02-23 07:28:44','xinqiuqu','新邱区',NULL),(538,'210904','太平区','121.677575,42.011145','district',535,0,'T','2018-12-14 00:20:19','2019-02-23 07:28:44','taipingqu','太平区',NULL),(539,'210905','清河门区','121.42018,41.780477','district',535,0,'Q','2018-12-14 00:20:19','2019-02-23 07:28:44','qinghemenqu','清河门区',NULL),(540,'210911','细河区','121.654791,42.019218','district',535,0,'X','2018-12-14 00:20:19','2019-02-23 07:28:44','xihequ','细河区',NULL),(541,'210921','阜新蒙古族自治县','121.743125,42.058607','district',535,0,'F','2018-12-14 00:20:19','2019-02-23 07:28:44','fuxinmengguzuzizhixian','阜新蒙古族自治县',NULL),(542,'210922','彰武县','122.537444,42.384823','district',535,0,'Z','2018-12-14 00:20:19','2019-02-23 07:28:44','zhangwuxian','彰武县',NULL),(543,'211000','辽阳市','123.18152,41.269402','city',464,0,'L','2018-12-14 00:20:19','2019-02-23 07:28:44','liaoyang','辽阳',NULL),(544,'211002','白塔区','123.172611,41.26745','district',543,0,'B','2018-12-14 00:20:19','2019-02-23 07:28:44','baitaqu','白塔区',NULL),(545,'211003','文圣区','123.188227,41.266765','district',543,0,'W','2018-12-14 00:20:19','2019-02-23 07:28:44','wenshengqu','文圣区',NULL),(546,'211004','宏伟区','123.200461,41.205747','district',543,0,'H','2018-12-14 00:20:19','2019-02-23 07:28:44','hongweiqu','宏伟区',NULL),(547,'211005','弓长岭区','123.431633,41.157831','district',543,0,'G','2018-12-14 00:20:19','2019-02-23 07:28:44','gongchanglingqu','弓长岭区',NULL),(548,'211011','太子河区','123.185336,41.251682','district',543,0,'T','2018-12-14 00:20:19','2019-02-23 07:28:44','taizihequ','太子河区',NULL),(549,'211021','辽阳县','123.079674,41.216479','district',543,0,'L','2018-12-14 00:20:19','2019-02-23 07:28:44','liaoyangxian','辽阳县',NULL),(550,'211081','灯塔市','123.325864,41.427836','district',543,0,'D','2018-12-14 00:20:19','2019-02-23 07:28:44','dengta','灯塔',NULL),(551,'211100','盘锦市','122.06957,41.124484','city',464,0,'P','2018-12-14 00:20:19','2019-02-23 07:28:44','panjin','盘锦',NULL),(552,'211102','双台子区','122.055733,41.190365','district',551,0,'S','2018-12-14 00:20:19','2019-02-23 07:28:44','shuangtaiziqu','双台子区',NULL),(553,'211103','兴隆台区','122.071624,41.122423','district',551,0,'X','2018-12-14 00:20:19','2019-02-23 07:28:44','xinglongtaiqu','兴隆台区',NULL),(554,'211104','大洼区','122.071708,40.994428','district',551,0,'D','2018-12-14 00:20:19','2019-02-23 07:28:45','dawaqu','大洼区',NULL),(555,'211122','盘山县','121.98528,41.240701','district',551,0,'P','2018-12-14 00:20:19','2019-02-23 07:28:45','panshanxian','盘山县',NULL),(556,'211200','铁岭市','123.844279,42.290585','city',464,0,'T','2018-12-14 00:20:20','2019-02-23 07:28:45','tieling','铁岭',NULL),(557,'211202','银州区','123.844877,42.292278','district',556,0,'Y','2018-12-14 00:20:20','2019-02-23 07:28:45','yinzhouqu','银州区',NULL),(558,'211204','清河区','124.14896,42.542978','district',556,0,'Q','2018-12-14 00:20:20','2019-02-23 07:28:45','qinghequ','清河区',NULL),(559,'211221','铁岭县','123.725669,42.223316','district',556,0,'T','2018-12-14 00:20:20','2019-02-23 07:28:45','tielingxian','铁岭县',NULL),(560,'211223','西丰县','124.72332,42.738091','district',556,0,'X','2018-12-14 00:20:20','2019-02-23 07:28:45','xifengxian','西丰县',NULL),(561,'211224','昌图县','124.11017,42.784441','district',556,0,'C','2018-12-14 00:20:20','2019-02-23 07:28:45','changtuxian','昌图县',NULL),(562,'211281','调兵山市','123.545366,42.450734','district',556,0,'D','2018-12-14 00:20:20','2019-02-23 07:28:45','diaobingshan','调兵山',NULL),(563,'211282','开原市','124.045551,42.542141','district',556,0,'K','2018-12-14 00:20:20','2019-02-23 07:28:45','kaiyuan','开原',NULL),(564,'211300','朝阳市','120.451176,41.576758','city',464,0,'Z','2018-12-14 00:20:20','2019-02-23 07:28:45','zhaoyang','朝阳',NULL),(565,'211302','双塔区','120.44877,41.579389','district',564,0,'S','2018-12-14 00:20:20','2019-02-23 07:28:45','shuangtaqu','双塔区',NULL),(566,'211303','龙城区','120.413376,41.576749','district',564,0,'L','2018-12-14 00:20:20','2019-02-23 07:28:45','longchengqu','龙城区',NULL),(567,'211321','朝阳县','120.404217,41.526342','district',564,0,'Z','2018-12-14 00:20:20','2019-02-23 07:28:45','zhaoyangxian','朝阳县',NULL),(568,'211322','建平县','119.642363,41.402576','district',564,0,'J','2018-12-14 00:20:20','2019-02-23 07:28:45','jianpingxian','建平县',NULL),(569,'211324','喀喇沁左翼蒙古族自治县','119.744883,41.125428','district',564,0,'K','2018-12-14 00:20:20','2019-02-23 07:28:45','kalaqinzuoyimengguzuzizhixian','喀喇沁左翼蒙古族自治县',NULL),(570,'211381','北票市','120.766951,41.803286','district',564,0,'B','2018-12-14 00:20:20','2019-02-23 07:28:45','beipiao','北票',NULL),(571,'211382','凌源市','119.404789,41.243086','district',564,0,'L','2018-12-14 00:20:20','2019-02-23 07:28:45','lingyuan','凌源',NULL),(572,'211400','葫芦岛市','120.856394,40.755572','city',464,0,'H','2018-12-14 00:20:20','2019-02-23 07:28:45','huludao','葫芦岛',NULL),(573,'211402','连山区','120.85937,40.755143','district',572,0,'L','2018-12-14 00:20:20','2019-02-23 07:28:45','lianshanqu','连山区',NULL),(574,'211403','龙港区','120.838569,40.709991','district',572,0,'L','2018-12-14 00:20:20','2019-02-23 07:28:45','longgangqu','龙港区',NULL),(575,'211404','南票区','120.752314,41.098813','district',572,0,'N','2018-12-14 00:20:20','2019-02-23 07:28:45','nanpiaoqu','南票区',NULL),(576,'211421','绥中县','120.342112,40.328407','district',572,0,'S','2018-12-14 00:20:20','2019-02-23 07:28:45','suizhongxian','绥中县',NULL),(577,'211422','建昌县','119.807776,40.812871','district',572,0,'J','2018-12-14 00:20:21','2019-02-23 07:28:45','jianchangxian','建昌县',NULL),(578,'211481','兴城市','120.729365,40.619413','district',572,0,'X','2018-12-14 00:20:21','2019-02-23 07:28:45','xingcheng','兴城',NULL),(579,'220000','吉林省','125.3245,43.886841','province',0,4500,'J','2018-12-14 00:20:21','2019-02-23 07:28:45','jilinsheng','吉林省',NULL),(580,'220100','长春市','125.3245,43.886841','city',579,0,'C','2018-12-14 00:20:21','2019-02-23 07:28:45','changchun','长春',NULL),(581,'220102','南关区','125.337237,43.890235','district',580,0,'N','2018-12-14 00:20:21','2019-02-23 07:28:45','nanguanqu','南关区',NULL),(582,'220103','宽城区','125.342828,43.903823','district',580,0,'K','2018-12-14 00:20:21','2019-02-23 07:28:45','kuanchengqu','宽城区',NULL),(583,'220104','朝阳区','125.318042,43.86491','district',580,0,'Z','2018-12-14 00:20:21','2019-02-23 07:28:45','zhaoyangqu','朝阳区',NULL),(584,'220105','二道区','125.384727,43.870824','district',580,0,'E','2018-12-14 00:20:21','2019-02-23 07:28:45','erdaoqu','二道区',NULL),(585,'220106','绿园区','125.272467,43.892177','district',580,0,'L','2018-12-14 00:20:21','2019-02-23 07:28:45','lvyuanqu','绿园区',NULL),(586,'220112','双阳区','125.659018,43.525168','district',580,0,'S','2018-12-14 00:20:21','2019-02-23 07:28:45','shuangyangqu','双阳区',NULL),(587,'220113','九台区','125.844682,44.157155','district',580,0,'J','2018-12-14 00:20:21','2019-02-23 07:28:45','jiutaiqu','九台区',NULL),(588,'220122','农安县','125.175287,44.431258','district',580,0,'N','2018-12-14 00:20:21','2019-02-23 07:28:45','nonganxian','农安县',NULL),(589,'220182','榆树市','126.550107,44.827642','district',580,0,'Y','2018-12-14 00:20:21','2019-02-23 07:28:46','yushu','榆树',NULL),(590,'220183','德惠市','125.703327,44.533909','district',580,0,'D','2018-12-14 00:20:21','2019-02-23 07:28:46','dehui','德惠',NULL),(591,'220200','吉林市','126.55302,43.843577','city',579,0,'J','2018-12-14 00:20:21','2019-02-23 07:28:46','jilin','吉林',NULL),(592,'220202','昌邑区','126.570766,43.851118','district',591,0,'C','2018-12-14 00:20:21','2019-02-23 07:28:46','changyiqu','昌邑区',NULL),(593,'220203','龙潭区','126.561429,43.909755','district',591,0,'L','2018-12-14 00:20:21','2019-02-23 07:28:46','longtanqu','龙潭区',NULL),(594,'220204','船营区','126.55239,43.843804','district',591,0,'C','2018-12-14 00:20:21','2019-02-23 07:28:46','chuanyingqu','船营区',NULL),(595,'220211','丰满区','126.560759,43.816594','district',591,0,'F','2018-12-14 00:20:21','2019-02-23 07:28:46','fengmanqu','丰满区',NULL),(596,'220221','永吉县','126.501622,43.667416','district',591,0,'Y','2018-12-14 00:20:21','2019-02-23 07:28:46','yongjixian','永吉县',NULL),(597,'220281','蛟河市','127.342739,43.720579','district',591,0,'J','2018-12-14 00:20:21','2019-02-23 07:28:46','jiaohe','蛟河',NULL),(598,'220282','桦甸市','126.745445,42.972093','district',591,0,'H','2018-12-14 00:20:21','2019-02-23 07:28:46','huadian','桦甸',NULL),(599,'220283','舒兰市','126.947813,44.410906','district',591,0,'S','2018-12-14 00:20:22','2019-02-23 07:28:46','shulan','舒兰',NULL),(600,'220284','磐石市','126.059929,42.942476','district',591,0,'P','2018-12-14 00:20:22','2019-02-23 07:28:46','panshi','磐石',NULL),(601,'220300','四平市','124.370785,43.170344','city',579,0,'S','2018-12-14 00:20:22','2019-02-23 07:28:46','siping','四平',NULL),(602,'220302','铁西区','124.360894,43.176263','district',601,0,'T','2018-12-14 00:20:22','2019-02-23 07:28:46','tiexiqu','铁西区',NULL),(603,'220303','铁东区','124.388464,43.16726','district',601,0,'T','2018-12-14 00:20:22','2019-02-23 07:28:46','tiedongqu','铁东区',NULL),(604,'220322','梨树县','124.335802,43.30831','district',601,0,'L','2018-12-14 00:20:22','2019-02-23 07:28:46','lishuxian','梨树县',NULL),(605,'220323','伊通满族自治县','125.303124,43.345464','district',601,0,'Y','2018-12-14 00:20:22','2019-02-23 07:28:46','yitongmanzuzizhixian','伊通满族自治县',NULL),(606,'220381','公主岭市','124.817588,43.509474','district',601,0,'G','2018-12-14 00:20:22','2019-02-23 07:28:46','gongzhuling','公主岭',NULL),(607,'220382','双辽市','123.505283,43.518275','district',601,0,'S','2018-12-14 00:20:22','2019-02-23 07:28:46','shuangliao','双辽',NULL),(608,'220400','辽源市','125.145349,42.902692','city',579,0,'L','2018-12-14 00:20:22','2019-02-23 07:28:46','liaoyuan','辽源',NULL),(609,'220402','龙山区','125.145164,42.902702','district',608,0,'L','2018-12-14 00:20:22','2019-02-23 07:28:46','longshanqu','龙山区',NULL),(610,'220403','西安区','125.151424,42.920415','district',608,0,'X','2018-12-14 00:20:22','2019-02-23 07:28:46','xianqu','西安区',NULL),(611,'220421','东丰县','125.529623,42.675228','district',608,0,'D','2018-12-14 00:20:22','2019-02-23 07:28:46','dongfengxian','东丰县',NULL),(612,'220422','东辽县','124.991995,42.927724','district',608,0,'D','2018-12-14 00:20:22','2019-02-23 07:28:46','dongliaoxian','东辽县',NULL),(613,'220500','通化市','125.936501,41.721177','city',579,0,'T','2018-12-14 00:20:22','2019-02-23 07:28:46','tonghua','通化',NULL),(614,'220502','东昌区','125.936716,41.721233','district',613,0,'D','2018-12-14 00:20:22','2019-02-23 07:28:46','dongchangqu','东昌区',NULL),(615,'220503','二道江区','126.045987,41.777564','district',613,0,'E','2018-12-14 00:20:22','2019-02-23 07:28:46','erdaojiangqu','二道江区',NULL),(616,'220521','通化县','125.753121,41.677918','district',613,0,'T','2018-12-14 00:20:22','2019-02-23 07:28:46','tonghuaxian','通化县',NULL),(617,'220523','辉南县','126.042821,42.683459','district',613,0,'H','2018-12-14 00:20:22','2019-02-23 07:28:46','huinanxian','辉南县',NULL),(618,'220524','柳河县','125.740536,42.281484','district',613,0,'L','2018-12-14 00:20:22','2019-02-23 07:28:46','liuhexian','柳河县',NULL),(619,'220581','梅河口市','125.687336,42.530002','district',613,0,'M','2018-12-14 00:20:23','2019-02-23 07:28:46','meihekou','梅河口',NULL),(620,'220582','集安市','126.186204,41.126276','district',613,0,'J','2018-12-14 00:20:23','2019-02-23 07:28:46','jian','集安',NULL),(621,'220600','白山市','126.427839,41.942505','city',579,0,'B','2018-12-14 00:20:23','2019-02-23 07:28:46','baishan','白山',NULL),(622,'220602','浑江区','126.428035,41.943065','district',621,0,'H','2018-12-14 00:20:23','2019-02-23 07:28:46','hunjiangqu','浑江区',NULL),(623,'220605','江源区','126.584229,42.048109','district',621,0,'J','2018-12-14 00:20:23','2019-02-23 07:28:46','jiangyuanqu','江源区',NULL),(624,'220621','抚松县','127.273796,42.332643','district',621,0,'F','2018-12-14 00:20:23','2019-02-23 07:28:46','fusongxian','抚松县',NULL),(625,'220622','靖宇县','126.808386,42.389689','district',621,0,'J','2018-12-14 00:20:23','2019-02-23 07:28:46','jingyuxian','靖宇县',NULL),(626,'220623','长白朝鲜族自治县','128.203384,41.419361','district',621,0,'C','2018-12-14 00:20:23','2019-02-23 07:28:47','changbaichaoxianzuzizhixian','长白朝鲜族自治县',NULL),(627,'220681','临江市','126.919296,41.810689','district',621,0,'L','2018-12-14 00:20:23','2019-02-23 07:28:47','linjiang','临江',NULL),(628,'220700','松原市','124.823608,45.118243','city',579,0,'S','2018-12-14 00:20:23','2019-02-23 07:28:47','songyuan','松原',NULL),(629,'220702','宁江区','124.827851,45.176498','district',628,0,'N','2018-12-14 00:20:23','2019-02-23 07:28:47','ningjiangqu','宁江区',NULL),(630,'220721','前郭尔罗斯蒙古族自治县','124.826808,45.116288','district',628,0,'Q','2018-12-14 00:20:23','2019-02-23 07:28:47','qianguoerluosimengguzuzizhixian','前郭尔罗斯蒙古族自治县',NULL),(631,'220722','长岭县','123.985184,44.276579','district',628,0,'C','2018-12-14 00:20:23','2019-02-23 07:28:47','changlingxian','长岭县',NULL),(632,'220723','乾安县','124.024361,45.006846','district',628,0,'Q','2018-12-14 00:20:23','2019-02-23 07:28:47','qiananxian','乾安县',NULL),(633,'220781','扶余市','126.042758,44.986199','district',628,0,'F','2018-12-14 00:20:23','2019-02-23 07:28:47','fuyu','扶余',NULL),(634,'220800','白城市','122.841114,45.619026','city',579,0,'B','2018-12-14 00:20:23','2019-02-23 07:28:47','baicheng','白城',NULL),(635,'220802','洮北区','122.842499,45.619253','district',634,0,'T','2018-12-14 00:20:23','2019-02-23 07:28:47','taobeiqu','洮北区',NULL),(636,'220821','镇赉县','123.202246,45.846089','district',634,0,'Z','2018-12-14 00:20:23','2019-02-23 07:28:47','zhenlaixian','镇赉县',NULL),(637,'220822','通榆县','123.088543,44.80915','district',634,0,'T','2018-12-14 00:20:23','2019-02-23 07:28:47','tongyuxian','通榆县',NULL),(638,'220881','洮南市','122.783779,45.339113','district',634,0,'T','2018-12-14 00:20:23','2019-02-23 07:28:47','taonan','洮南',NULL),(639,'220882','大安市','124.291512,45.507648','district',634,0,'D','2018-12-14 00:20:23','2019-02-23 07:28:47','daan','大安',NULL),(640,'222400','延边朝鲜族自治州','129.513228,42.904823','city',579,0,'Y','2018-12-14 00:20:24','2019-02-23 07:28:47','yanbianchaoxianzuzizhizhou','延边朝鲜族自治州',NULL),(641,'222401','延吉市','129.51579,42.906964','district',640,0,'Y','2018-12-14 00:20:24','2019-02-23 07:28:47','yanji','延吉',NULL),(642,'222402','图们市','129.846701,42.966621','district',640,0,'T','2018-12-14 00:20:24','2019-02-23 07:28:47','tumen','图们',NULL),(643,'222403','敦化市','128.22986,43.366921','district',640,0,'D','2018-12-14 00:20:24','2019-02-23 07:28:47','dunhua','敦化',NULL),(644,'222404','珲春市','130.365787,42.871057','district',640,0,'H','2018-12-14 00:20:24','2019-02-23 07:28:47','huichun','珲春',NULL),(645,'222405','龙井市','129.425747,42.771029','district',640,0,'L','2018-12-14 00:20:24','2019-02-23 07:28:47','longjing','龙井',NULL),(646,'222406','和龙市','129.008748,42.547004','district',640,0,'H','2018-12-14 00:20:24','2019-02-23 07:28:47','helong','和龙',NULL),(647,'222424','汪清县','129.766161,43.315426','district',640,0,'W','2018-12-14 00:20:24','2019-02-23 07:28:47','wangqingxian','汪清县',NULL),(648,'222426','安图县','128.901865,43.110994','district',640,0,'A','2018-12-14 00:20:24','2019-02-23 07:28:47','antuxian','安图县',NULL),(649,'230000','黑龙江省','126.642464,45.756967','province',0,3700,'H','2018-12-14 00:20:24','2019-02-23 07:28:47','heilongjiangsheng','黑龙江省',NULL),(650,'230100','哈尔滨市','126.642464,45.756967','city',649,0,'H','2018-12-14 00:20:24','2019-02-23 07:28:47','haerbin','哈尔滨',NULL),(651,'230102','道里区','126.612532,45.762035','district',650,0,'D','2018-12-14 00:20:24','2019-02-23 07:28:47','daoliqu','道里区',NULL),(652,'230103','南岗区','126.652098,45.755971','district',650,0,'N','2018-12-14 00:20:24','2019-02-23 07:28:47','nangangqu','南岗区',NULL),(653,'230104','道外区','126.648838,45.78454','district',650,0,'D','2018-12-14 00:20:24','2019-02-23 07:28:47','daowaiqu','道外区',NULL),(654,'230108','平房区','126.629257,45.605567','district',650,0,'P','2018-12-14 00:20:24','2019-02-23 07:28:47','pingfangqu','平房区',NULL),(655,'230109','松北区','126.563066,45.814656','district',650,0,'S','2018-12-14 00:20:24','2019-02-23 07:28:47','songbeiqu','松北区',NULL),(656,'230110','香坊区','126.667049,45.713067','district',650,0,'X','2018-12-14 00:20:24','2019-02-23 07:28:47','xiangfangqu','香坊区',NULL),(657,'230111','呼兰区','126.603302,45.98423','district',650,0,'H','2018-12-14 00:20:24','2019-02-23 07:28:47','hulanqu','呼兰区',NULL),(658,'230112','阿城区','126.972726,45.538372','district',650,0,'A','2018-12-14 00:20:24','2019-02-23 07:28:47','achengqu','阿城区',NULL),(659,'230113','双城区','126.308784,45.377942','district',650,0,'S','2018-12-14 00:20:24','2019-02-23 07:28:47','shuangchengqu','双城区',NULL),(660,'230123','依兰县','129.565594,46.315105','district',650,0,'Y','2018-12-14 00:20:24','2019-02-23 07:28:47','yilanxian','依兰县',NULL),(661,'230124','方正县','128.836131,45.839536','district',650,0,'F','2018-12-14 00:20:25','2019-02-23 07:28:47','fangzhengxian','方正县',NULL),(662,'230125','宾县','127.48594,45.759369','district',650,0,'B','2018-12-14 00:20:25','2019-02-23 07:28:47','binxian','宾县',NULL),(663,'230126','巴彦县','127.403602,46.081889','district',650,0,'B','2018-12-14 00:20:25','2019-02-23 07:28:48','bayanxian','巴彦县',NULL),(664,'230127','木兰县','128.042675,45.949826','district',650,0,'M','2018-12-14 00:20:25','2019-02-23 07:28:48','mulanxian','木兰县',NULL),(665,'230128','通河县','128.747786,45.977618','district',650,0,'T','2018-12-14 00:20:25','2019-02-23 07:28:48','tonghexian','通河县',NULL),(666,'230129','延寿县','128.331886,45.455648','district',650,0,'Y','2018-12-14 00:20:25','2019-02-23 07:28:48','yanshouxian','延寿县',NULL),(667,'230183','尚志市','127.968539,45.214953','district',650,0,'S','2018-12-14 00:20:25','2019-02-23 07:28:48','shangzhi','尚志',NULL),(668,'230184','五常市','127.15759,44.919418','district',650,0,'W','2018-12-14 00:20:25','2019-02-23 07:28:48','wuchang','五常',NULL),(669,'230200','齐齐哈尔市','123.95792,47.342081','city',649,0,'Q','2018-12-14 00:20:25','2019-02-23 07:28:48','qiqihaer','齐齐哈尔',NULL),(670,'230202','龙沙区','123.957338,47.341736','district',669,0,'L','2018-12-14 00:20:25','2019-02-23 07:28:48','longshaqu','龙沙区',NULL),(671,'230203','建华区','123.955888,47.354494','district',669,0,'J','2018-12-14 00:20:25','2019-02-23 07:28:48','jianhuaqu','建华区',NULL),(672,'230204','铁锋区','123.973555,47.339499','district',669,0,'T','2018-12-14 00:20:25','2019-02-23 07:28:48','tiefengqu','铁锋区',NULL),(673,'230205','昂昂溪区','123.813181,47.156867','district',669,0,'A','2018-12-14 00:20:25','2019-02-23 07:28:48','angangxiqu','昂昂溪区',NULL),(674,'230206','富拉尔基区','123.638873,47.20697','district',669,0,'F','2018-12-14 00:20:25','2019-02-23 07:28:48','fulaerjiqu','富拉尔基区',NULL),(675,'230207','碾子山区','122.887972,47.51401','district',669,0,'N','2018-12-14 00:20:25','2019-02-23 07:28:48','nianzishanqu','碾子山区',NULL),(676,'230208','梅里斯达斡尔族区','123.754599,47.311113','district',669,0,'M','2018-12-14 00:20:25','2019-02-23 07:28:48','meilisidawoerzuqu','梅里斯达斡尔族区',NULL),(677,'230221','龙江县','123.187225,47.336388','district',669,0,'L','2018-12-14 00:20:25','2019-02-23 07:28:48','longjiangxian','龙江县',NULL),(678,'230223','依安县','125.307561,47.890098','district',669,0,'Y','2018-12-14 00:20:25','2019-02-23 07:28:48','yianxian','依安县',NULL),(679,'230224','泰来县','123.41953,46.39233','district',669,0,'T','2018-12-14 00:20:25','2019-02-23 07:28:48','tailaixian','泰来县',NULL),(680,'230225','甘南县','123.506034,47.917838','district',669,0,'G','2018-12-14 00:20:25','2019-02-23 07:28:48','gannanxian','甘南县',NULL),(681,'230227','富裕县','124.469106,47.797172','district',669,0,'F','2018-12-14 00:20:25','2019-02-23 07:28:48','fuyuxian','富裕县',NULL),(682,'230229','克山县','125.874355,48.034342','district',669,0,'K','2018-12-14 00:20:26','2019-02-23 07:28:48','keshanxian','克山县',NULL),(683,'230230','克东县','126.249094,48.03732','district',669,0,'K','2018-12-14 00:20:26','2019-02-23 07:28:48','kedongxian','克东县',NULL),(684,'230231','拜泉县','126.091911,47.607363','district',669,0,'B','2018-12-14 00:20:26','2019-02-23 07:28:48','baiquanxian','拜泉县',NULL),(685,'230281','讷河市','124.882172,48.481133','district',669,0,'N','2018-12-14 00:20:26','2019-02-23 07:28:48','nehe','讷河',NULL),(686,'230300','鸡西市','130.975966,45.300046','city',649,0,'J','2018-12-14 00:20:26','2019-02-23 07:28:48','jixi','鸡西',NULL),(687,'230302','鸡冠区','130.974374,45.30034','district',686,0,'J','2018-12-14 00:20:26','2019-02-23 07:28:48','jiguanqu','鸡冠区',NULL),(688,'230303','恒山区','130.910636,45.213242','district',686,0,'H','2018-12-14 00:20:26','2019-02-23 07:28:48','hengshanqu','恒山区',NULL),(689,'230304','滴道区','130.846823,45.348812','district',686,0,'D','2018-12-14 00:20:26','2019-02-23 07:28:48','didaoqu','滴道区',NULL),(690,'230305','梨树区','130.697781,45.092195','district',686,0,'L','2018-12-14 00:20:26','2019-02-23 07:28:48','lishuqu','梨树区',NULL),(691,'230306','城子河区','131.010501,45.338248','district',686,0,'C','2018-12-14 00:20:26','2019-02-23 07:28:48','chengzihequ','城子河区',NULL),(692,'230307','麻山区','130.481126,45.209607','district',686,0,'M','2018-12-14 00:20:26','2019-02-23 07:28:48','mashanqu','麻山区',NULL),(693,'230321','鸡东县','131.148907,45.250892','district',686,0,'J','2018-12-14 00:20:26','2019-02-23 07:28:48','jidongxian','鸡东县',NULL),(694,'230381','虎林市','132.973881,45.767985','district',686,0,'H','2018-12-14 00:20:26','2019-02-23 07:28:48','hulin','虎林',NULL),(695,'230382','密山市','131.874137,45.54725','district',686,0,'M','2018-12-14 00:20:26','2019-02-23 07:28:48','mishan','密山',NULL),(696,'230400','鹤岗市','130.277487,47.332085','city',649,0,'H','2018-12-14 00:20:26','2019-02-23 07:28:48','hegang','鹤岗',NULL),(697,'230402','向阳区','130.292478,47.345372','district',696,0,'X','2018-12-14 00:20:26','2019-02-23 07:28:48','xiangyangqu','向阳区',NULL),(698,'230403','工农区','130.276652,47.331678','district',696,0,'G','2018-12-14 00:20:26','2019-02-23 07:28:48','gongnongqu','工农区',NULL),(699,'230404','南山区','130.275533,47.31324','district',696,0,'N','2018-12-14 00:20:26','2019-02-23 07:28:48','nanshanqu','南山区',NULL),(700,'230405','兴安区','130.236169,47.252911','district',696,0,'X','2018-12-14 00:20:26','2019-02-23 07:28:48','xinganqu','兴安区',NULL),(701,'230406','东山区','130.31714,47.337385','district',696,0,'D','2018-12-14 00:20:26','2019-02-23 07:28:49','dongshanqu','东山区',NULL),(702,'230407','兴山区','130.30534,47.35997','district',696,0,'X','2018-12-14 00:20:26','2019-02-23 07:28:49','xingshanqu','兴山区',NULL),(703,'230421','萝北县','130.829087,47.577577','district',696,0,'L','2018-12-14 00:20:26','2019-02-23 07:28:49','luobeixian','萝北县',NULL),(704,'230422','绥滨县','131.860526,47.289892','district',696,0,'S','2018-12-14 00:20:27','2019-02-23 07:28:49','suibinxian','绥滨县',NULL),(705,'230500','双鸭山市','131.157304,46.643442','city',649,0,'S','2018-12-14 00:20:27','2019-02-23 07:28:49','shuangyashan','双鸭山',NULL),(706,'230502','尖山区','131.15896,46.642961','district',705,0,'J','2018-12-14 00:20:27','2019-02-23 07:28:49','jianshanqu','尖山区',NULL),(707,'230503','岭东区','131.163675,46.591076','district',705,0,'L','2018-12-14 00:20:27','2019-02-23 07:28:49','lingdongqu','岭东区',NULL),(708,'230505','四方台区','131.333181,46.594347','district',705,0,'S','2018-12-14 00:20:27','2019-02-23 07:28:49','sifangtaiqu','四方台区',NULL),(709,'230506','宝山区','131.404294,46.573366','district',705,0,'B','2018-12-14 00:20:27','2019-02-23 07:28:49','baoshanqu','宝山区',NULL),(710,'230521','集贤县','131.13933,46.72898','district',705,0,'J','2018-12-14 00:20:27','2019-02-23 07:28:49','jixianxian','集贤县',NULL),(711,'230522','友谊县','131.810622,46.775159','district',705,0,'Y','2018-12-14 00:20:27','2019-02-23 07:28:49','youyixian','友谊县',NULL),(712,'230523','宝清县','132.206415,46.328781','district',705,0,'B','2018-12-14 00:20:27','2019-02-23 07:28:49','baoqingxian','宝清县',NULL),(713,'230524','饶河县','134.021162,46.801288','district',705,0,'R','2018-12-14 00:20:27','2019-02-23 07:28:49','raohexian','饶河县',NULL),(714,'230600','大庆市','125.11272,46.590734','city',649,0,'D','2018-12-14 00:20:27','2019-02-23 07:28:49','daqing','大庆',NULL),(715,'230602','萨尔图区','125.114643,46.596356','district',714,0,'S','2018-12-14 00:20:27','2019-02-23 07:28:49','saertuqu','萨尔图区',NULL),(716,'230603','龙凤区','125.145794,46.573948','district',714,0,'L','2018-12-14 00:20:27','2019-02-23 07:28:49','longfengqu','龙凤区',NULL),(717,'230604','让胡路区','124.868341,46.653254','district',714,0,'R','2018-12-14 00:20:27','2019-02-23 07:28:49','ranghuluqu','让胡路区',NULL),(718,'230605','红岗区','124.889528,46.403049','district',714,0,'H','2018-12-14 00:20:27','2019-02-23 07:28:49','honggangqu','红岗区',NULL),(719,'230606','大同区','124.818509,46.034304','district',714,0,'D','2018-12-14 00:20:27','2019-02-23 07:28:49','datongqu','大同区',NULL),(720,'230621','肇州县','125.273254,45.708685','district',714,0,'Z','2018-12-14 00:20:27','2019-02-23 07:28:49','zhaozhouxian','肇州县',NULL),(721,'230622','肇源县','125.081974,45.518832','district',714,0,'Z','2018-12-14 00:20:27','2019-02-23 07:28:49','zhaoyuanxian','肇源县',NULL),(722,'230623','林甸县','124.877742,47.186411','district',714,0,'L','2018-12-14 00:20:27','2019-02-23 07:28:49','lindianxian','林甸县',NULL),(723,'230624','杜尔伯特蒙古族自治县','124.446259,46.865973','district',714,0,'D','2018-12-14 00:20:27','2019-02-23 07:28:49','duerbotemengguzuzizhixian','杜尔伯特蒙古族自治县',NULL),(724,'230700','伊春市','128.899396,47.724775','city',649,0,'Y','2018-12-14 00:20:27','2019-02-23 07:28:49','yichun','伊春',NULL),(725,'230702','伊春区','128.899284,47.726851','district',724,0,'Y','2018-12-14 00:20:27','2019-02-23 07:28:49','yichunqu','伊春区',NULL),(726,'230703','南岔区','129.28246,47.137314','district',724,0,'N','2018-12-14 00:20:28','2019-02-23 07:28:49','nanchaqu','南岔区',NULL),(727,'230704','友好区','128.838961,47.854303','district',724,0,'Y','2018-12-14 00:20:28','2019-02-23 07:28:49','youhaoqu','友好区',NULL),(728,'230705','西林区','129.311441,47.479437','district',724,0,'X','2018-12-14 00:20:28','2019-02-23 07:28:49','xilinqu','西林区',NULL),(729,'230706','翠峦区','128.671746,47.726228','district',724,0,'C','2018-12-14 00:20:28','2019-02-23 07:28:49','cuiluanqu','翠峦区',NULL),(730,'230707','新青区','129.52995,48.288292','district',724,0,'X','2018-12-14 00:20:28','2019-02-23 07:28:49','xinqingqu','新青区',NULL),(731,'230708','美溪区','129.133411,47.636102','district',724,0,'M','2018-12-14 00:20:28','2019-02-23 07:28:49','meixiqu','美溪区',NULL),(732,'230709','金山屯区','129.435944,47.41295','district',724,0,'J','2018-12-14 00:20:28','2019-02-23 07:28:49','jinshanzhunqu','金山屯区',NULL),(733,'230710','五营区','129.245028,48.108204','district',724,0,'W','2018-12-14 00:20:28','2019-02-23 07:28:49','wuyingqu','五营区',NULL),(734,'230711','乌马河区','128.802941,47.726961','district',724,0,'W','2018-12-14 00:20:28','2019-02-23 07:28:49','wumahequ','乌马河区',NULL),(735,'230712','汤旺河区','129.57224,48.453651','district',724,0,'T','2018-12-14 00:20:28','2019-02-23 07:28:49','tangwanghequ','汤旺河区',NULL),(736,'230713','带岭区','129.021151,47.027532','district',724,0,'D','2018-12-14 00:20:28','2019-02-23 07:28:49','dailingqu','带岭区',NULL),(737,'230714','乌伊岭区','129.437847,48.59112','district',724,0,'W','2018-12-14 00:20:28','2019-02-23 07:28:49','wuyilingqu','乌伊岭区',NULL),(738,'230715','红星区','129.388796,48.238368','district',724,0,'H','2018-12-14 00:20:28','2019-02-23 07:28:49','hongxingqu','红星区',NULL),(739,'230716','上甘岭区','129.02508,47.974859','district',724,0,'S','2018-12-14 00:20:28','2019-02-23 07:28:50','shangganlingqu','上甘岭区',NULL),(740,'230722','嘉荫县','130.397684,48.891378','district',724,0,'J','2018-12-14 00:20:28','2019-02-23 07:28:50','jiayinxian','嘉荫县',NULL),(741,'230781','铁力市','128.030561,46.985772','district',724,0,'T','2018-12-14 00:20:28','2019-02-23 07:28:50','tieli','铁力',NULL),(742,'230800','佳木斯市','130.361634,46.809606','city',649,0,'J','2018-12-14 00:20:28','2019-02-23 07:28:50','jiamusi','佳木斯',NULL),(743,'230803','向阳区','130.361786,46.809645','district',742,0,'X','2018-12-14 00:20:28','2019-02-23 07:28:50','xiangyangqu','向阳区',NULL),(744,'230804','前进区','130.377684,46.812345','district',742,0,'Q','2018-12-14 00:20:28','2019-02-23 07:28:50','qianjinqu','前进区',NULL),(745,'230805','东风区','130.403297,46.822476','district',742,0,'D','2018-12-14 00:20:28','2019-02-23 07:28:50','dongfengqu','东风区',NULL),(746,'230811','郊区','130.351588,46.80712','district',742,0,'J','2018-12-14 00:20:29','2019-02-23 07:28:50','jiaoqu','郊区',NULL),(747,'230822','桦南县','130.570112,46.240118','district',742,0,'H','2018-12-14 00:20:29','2019-02-23 07:28:50','huananxian','桦南县',NULL),(748,'230826','桦川县','130.723713,47.023039','district',742,0,'H','2018-12-14 00:20:29','2019-02-23 07:28:50','huachuanxian','桦川县',NULL),(749,'230828','汤原县','129.904463,46.730048','district',742,0,'T','2018-12-14 00:20:29','2019-02-23 07:28:50','tangyuanxian','汤原县',NULL),(750,'230881','同江市','132.510119,47.651131','district',742,0,'T','2018-12-14 00:20:29','2019-02-23 07:28:50','tongjiang','同江',NULL),(751,'230882','富锦市','132.037951,47.250747','district',742,0,'F','2018-12-14 00:20:29','2019-02-23 07:28:50','fujin','富锦',NULL),(752,'230883','抚远市','134.294501,48.364707','district',742,0,'F','2018-12-14 00:20:29','2019-02-23 07:28:50','fuyuan','抚远',NULL),(753,'230900','七台河市','131.015584,45.771266','city',649,0,'Q','2018-12-14 00:20:29','2019-02-23 07:28:50','qitaihe','七台河',NULL),(754,'230902','新兴区','130.889482,45.794258','district',753,0,'X','2018-12-14 00:20:29','2019-02-23 07:28:50','xinxingqu','新兴区',NULL),(755,'230903','桃山区','131.015848,45.771217','district',753,0,'T','2018-12-14 00:20:29','2019-02-23 07:28:50','taoshanqu','桃山区',NULL),(756,'230904','茄子河区','131.071561,45.776587','district',753,0,'Q','2018-12-14 00:20:29','2019-02-23 07:28:50','qiezihequ','茄子河区',NULL),(757,'230921','勃利县','130.575025,45.751573','district',753,0,'B','2018-12-14 00:20:29','2019-02-23 07:28:50','bolixian','勃利县',NULL),(758,'231000','牡丹江市','129.618602,44.582962','city',649,0,'M','2018-12-14 00:20:30','2019-02-23 07:28:50','mudanjiang','牡丹江',NULL),(759,'231002','东安区','129.623292,44.582399','district',758,0,'D','2018-12-14 00:20:30','2019-02-23 07:28:50','donganqu','东安区',NULL),(760,'231003','阳明区','129.634645,44.596328','district',758,0,'Y','2018-12-14 00:20:30','2019-02-23 07:28:50','yangmingqu','阳明区',NULL),(761,'231004','爱民区','129.601232,44.595443','district',758,0,'A','2018-12-14 00:20:30','2019-02-23 07:28:50','aiminqu','爱民区',NULL),(762,'231005','西安区','129.61311,44.581032','district',758,0,'X','2018-12-14 00:20:30','2019-02-23 07:28:50','xianqu','西安区',NULL),(763,'231025','林口县','130.268402,45.286645','district',758,0,'L','2018-12-14 00:20:30','2019-02-23 07:28:50','linkouxian','林口县',NULL),(764,'231081','绥芬河市','131.164856,44.396864','district',758,0,'S','2018-12-14 00:20:30','2019-02-23 07:28:50','suifenhe','绥芬河',NULL),(765,'231083','海林市','129.387902,44.574149','district',758,0,'H','2018-12-14 00:20:30','2019-02-23 07:28:50','hailin','海林',NULL),(766,'231084','宁安市','129.470019,44.346836','district',758,0,'N','2018-12-14 00:20:30','2019-02-23 07:28:50','ningan','宁安',NULL),(767,'231085','穆棱市','130.527085,44.91967','district',758,0,'M','2018-12-14 00:20:30','2019-02-23 07:28:50','muleng','穆棱',NULL),(768,'231086','东宁市','131.125296,44.063578','district',758,0,'D','2018-12-14 00:20:30','2019-02-23 07:28:50','dongning','东宁',NULL),(769,'231100','黑河市','127.499023,50.249585','city',649,0,'H','2018-12-14 00:20:30','2019-02-23 07:28:50','heihe','黑河',NULL),(770,'231102','爱辉区','127.497639,50.249027','district',769,0,'A','2018-12-14 00:20:30','2019-02-23 07:28:50','aihuiqu','爱辉区',NULL),(771,'231121','嫩江县','125.229904,49.177461','district',769,0,'N','2018-12-14 00:20:30','2019-02-23 07:28:50','nenjiangxian','嫩江县',NULL),(772,'231123','逊克县','128.476152,49.582974','district',769,0,'X','2018-12-14 00:20:30','2019-02-23 07:28:50','xunkexian','逊克县',NULL),(773,'231124','孙吴县','127.327315,49.423941','district',769,0,'S','2018-12-14 00:20:30','2019-02-23 07:28:50','sunwuxian','孙吴县',NULL);
INSERT INTO `districts` VALUES (774,'231181','北安市','126.508737,48.245437','district',769,0,'B','2018-12-14 00:20:30','2019-02-23 07:28:50','beian','北安',NULL),(775,'231182','五大连池市','126.197694,48.512688','district',769,0,'W','2018-12-14 00:20:30','2019-02-23 07:28:51','wudalianchi','五大连池',NULL),(776,'231200','绥化市','126.99293,46.637393','city',649,0,'S','2018-12-14 00:20:30','2019-02-23 07:28:51','suihua','绥化',NULL),(777,'231202','北林区','126.990665,46.634912','district',776,0,'B','2018-12-14 00:20:30','2019-02-23 07:28:51','beilinqu','北林区',NULL),(778,'231221','望奎县','126.484191,46.83352','district',776,0,'W','2018-12-14 00:20:30','2019-02-23 07:28:51','wangkuixian','望奎县',NULL),(779,'231222','兰西县','126.289315,46.259037','district',776,0,'L','2018-12-14 00:20:31','2019-02-23 07:28:51','lanxixian','兰西县',NULL),(780,'231223','青冈县','126.112268,46.686596','district',776,0,'Q','2018-12-14 00:20:31','2019-02-23 07:28:51','qinggangxian','青冈县',NULL),(781,'231224','庆安县','127.510024,46.879203','district',776,0,'Q','2018-12-14 00:20:31','2019-02-23 07:28:51','qinganxian','庆安县',NULL),(782,'231225','明水县','125.907544,47.183527','district',776,0,'M','2018-12-14 00:20:31','2019-02-23 07:28:51','mingshuixian','明水县',NULL),(783,'231226','绥棱县','127.111121,47.247195','district',776,0,'S','2018-12-14 00:20:31','2019-02-23 07:28:51','suilengxian','绥棱县',NULL),(784,'231281','安达市','125.329926,46.410614','district',776,0,'A','2018-12-14 00:20:31','2019-02-23 07:28:51','anda','安达',NULL),(785,'231282','肇东市','125.991402,46.069471','district',776,0,'Z','2018-12-14 00:20:31','2019-02-23 07:28:51','zhaodong','肇东',NULL),(786,'231283','海伦市','126.969383,47.460428','district',776,0,'H','2018-12-14 00:20:31','2019-02-23 07:28:51','hailun','海伦',NULL),(787,'232700','大兴安岭地区','124.711526,52.335262','city',649,0,'D','2018-12-14 00:20:31','2019-02-23 07:28:51','daxinganlingdiqu','大兴安岭地区',NULL),(788,'232701','加格达奇区','124.126716,50.424654','district',787,0,'J','2018-12-14 00:20:31','2019-02-23 07:28:51','jiagedaqiqu','加格达奇区',NULL),(789,'232721','呼玛县','126.662105,51.726998','district',787,0,'H','2018-12-14 00:20:31','2019-02-23 07:28:51','humaxian','呼玛县',NULL),(790,'232722','塔河县','124.710516,52.335229','district',787,0,'T','2018-12-14 00:20:31','2019-02-23 07:28:51','tahexian','塔河县',NULL),(791,'232723','漠河县','122.536256,52.972074','district',787,0,'M','2018-12-14 00:20:31','2019-02-23 07:28:51','mohexian','漠河县',NULL),(792,'310000','上海市','121.472644,31.231706','province',0,9998,'S','2018-12-14 00:20:31','2019-02-23 07:28:51','shanghai','上海',NULL),(793,'310100','上海市','121.472644,31.231706','city',792,0,'S','2018-12-14 00:20:31','2019-02-23 07:28:51','shanghai','上海',1),(794,'310101','黄浦区','121.490317,31.222771','district',793,0,'H','2018-12-14 00:20:31','2019-02-23 07:28:51','huangpuqu','黄浦区',NULL),(795,'310104','徐汇区','121.43752,31.179973','district',793,0,'X','2018-12-14 00:20:31','2019-02-23 07:28:51','xuhuiqu','徐汇区',NULL),(796,'310105','长宁区','121.4222,31.218123','district',793,0,'C','2018-12-14 00:20:31','2019-02-23 07:28:51','changningqu','长宁区',NULL),(797,'310106','静安区','121.448224,31.229003','district',793,0,'J','2018-12-14 00:20:31','2019-02-23 07:28:51','jinganqu','静安区',NULL),(798,'310107','普陀区','121.392499,31.241701','district',793,0,'P','2018-12-14 00:20:31','2019-02-23 07:28:51','putuoqu','普陀区',NULL),(799,'310109','虹口区','121.491832,31.26097','district',793,0,'H','2018-12-14 00:20:32','2019-02-23 07:28:51','hongkouqu','虹口区',NULL),(800,'310110','杨浦区','121.522797,31.270755','district',793,0,'Y','2018-12-14 00:20:32','2019-02-23 07:28:51','yangpuqu','杨浦区',NULL),(801,'310112','闵行区','121.375972,31.111658','district',793,0,'M','2018-12-14 00:20:32','2019-02-23 07:28:51','minhangqu','闵行区',NULL),(802,'310113','宝山区','121.489934,31.398896','district',793,0,'B','2018-12-14 00:20:32','2019-02-23 07:28:51','baoshanqu','宝山区',NULL),(803,'310114','嘉定区','121.250333,31.383524','district',793,0,'J','2018-12-14 00:20:32','2019-02-23 07:28:51','jiadingqu','嘉定区',NULL),(804,'310115','浦东新区','121.567706,31.245944','district',793,0,'P','2018-12-14 00:20:32','2019-02-23 07:28:51','pudongxinqu','浦东新区',NULL),(805,'310116','金山区','121.330736,30.724697','district',793,0,'J','2018-12-14 00:20:32','2019-02-23 07:28:51','jinshanqu','金山区',NULL),(806,'310117','松江区','121.223543,31.03047','district',793,0,'S','2018-12-14 00:20:32','2019-02-23 07:28:51','songjiangqu','松江区',NULL),(807,'310118','青浦区','121.113021,31.151209','district',793,0,'Q','2018-12-14 00:20:32','2019-02-23 07:28:51','qingpuqu','青浦区',NULL),(808,'310120','奉贤区','121.458472,30.912345','district',793,0,'F','2018-12-14 00:20:32','2019-02-23 07:28:51','fengxianqu','奉贤区',NULL),(809,'310151','崇明区','121.397516,31.626946','district',793,0,'C','2018-12-14 00:20:32','2019-02-23 07:28:51','chongmingqu','崇明区',NULL),(810,'320000','江苏省','118.767413,32.041544','province',0,9001,'J','2018-12-14 00:20:32','2019-02-23 07:28:51','jiangsusheng','江苏省',NULL),(811,'320100','南京市','118.767413,32.041544','city',810,0,'N','2018-12-14 00:20:32','2019-02-23 07:28:51','nanjing','南京',1),(812,'320102','玄武区','118.792199,32.050678','district',811,0,'X','2018-12-14 00:20:32','2019-02-23 07:28:52','xuanwuqu','玄武区',NULL),(813,'320104','秦淮区','118.786088,32.033818','district',811,0,'Q','2018-12-14 00:20:32','2019-02-23 07:28:52','qinhuaiqu','秦淮区',NULL),(814,'320105','建邺区','118.732688,32.004538','district',811,0,'J','2018-12-14 00:20:32','2019-02-23 07:28:52','jianyequ','建邺区',NULL),(815,'320106','鼓楼区','118.769739,32.066966','district',811,0,'G','2018-12-14 00:20:32','2019-02-23 07:28:52','gulouqu','鼓楼区',NULL),(816,'320111','浦口区','118.625307,32.05839','district',811,0,'P','2018-12-14 00:20:32','2019-02-23 07:28:52','pukouqu','浦口区',NULL),(817,'320113','栖霞区','118.808702,32.102147','district',811,0,'Q','2018-12-14 00:20:32','2019-02-23 07:28:52','qixiaqu','栖霞区',NULL),(818,'320114','雨花台区','118.77207,31.995946','district',811,0,'Y','2018-12-14 00:20:32','2019-02-23 07:28:52','yuhuataiqu','雨花台区',NULL),(819,'320115','江宁区','118.850621,31.953418','district',811,0,'J','2018-12-14 00:20:33','2019-02-23 07:28:52','jiangningqu','江宁区',NULL),(820,'320116','六合区','118.85065,32.340655','district',811,0,'L','2018-12-14 00:20:33','2019-02-23 07:28:52','luhequ','六合区',NULL),(821,'320117','溧水区','119.028732,31.653061','district',811,0,'L','2018-12-14 00:20:33','2019-02-23 07:28:52','lishuiqu','溧水区',NULL),(822,'320118','高淳区','118.87589,31.327132','district',811,0,'G','2018-12-14 00:20:33','2019-02-23 07:28:52','gaochunqu','高淳区',NULL),(823,'320200','无锡市','120.301663,31.574729','city',810,0,'W','2018-12-14 00:20:33','2019-02-23 07:28:52','wuxi','无锡',NULL),(824,'320205','锡山区','120.357298,31.585559','district',823,0,'X','2018-12-14 00:20:33','2019-02-23 07:28:52','xishanqu','锡山区',NULL),(825,'320206','惠山区','120.303543,31.681019','district',823,0,'H','2018-12-14 00:20:33','2019-02-23 07:28:52','huishanqu','惠山区',NULL),(826,'320211','滨湖区','120.266053,31.550228','district',823,0,'B','2018-12-14 00:20:33','2019-02-23 07:28:52','binhuqu','滨湖区',NULL),(827,'320213','梁溪区','120.296595,31.575706','district',823,0,'L','2018-12-14 00:20:33','2019-02-23 07:28:52','liangxiqu','梁溪区',NULL),(828,'320214','新吴区','120.352782,31.550966','district',823,0,'X','2018-12-14 00:20:33','2019-02-23 07:28:52','xinwuqu','新吴区',NULL),(829,'320281','江阴市','120.275891,31.910984','district',823,0,'J','2018-12-14 00:20:33','2019-02-23 07:28:52','jiangyin','江阴',NULL),(830,'320282','宜兴市','119.820538,31.364384','district',823,0,'Y','2018-12-14 00:20:33','2019-02-23 07:28:52','yixing','宜兴',NULL),(831,'320300','徐州市','117.184811,34.261792','city',810,0,'X','2018-12-14 00:20:33','2019-02-23 07:28:52','xuzhou','徐州',NULL),(832,'320302','鼓楼区','117.192941,34.269397','district',831,0,'G','2018-12-14 00:20:33','2019-02-23 07:28:52','gulouqu','鼓楼区',NULL),(833,'320303','云龙区','117.194589,34.254805','district',831,0,'Y','2018-12-14 00:20:33','2019-02-23 07:28:52','yunlongqu','云龙区',NULL),(834,'320305','贾汪区','117.450212,34.441642','district',831,0,'J','2018-12-14 00:20:33','2019-02-23 07:28:52','jiawangqu','贾汪区',NULL),(835,'320311','泉山区','117.182225,34.262249','district',831,0,'Q','2018-12-14 00:20:33','2019-02-23 07:28:52','quanshanqu','泉山区',NULL),(836,'320312','铜山区','117.183894,34.19288','district',831,0,'T','2018-12-14 00:20:33','2019-02-23 07:28:52','tongshanqu','铜山区',NULL),(837,'320321','丰县','116.592888,34.696946','district',831,0,'F','2018-12-14 00:20:33','2019-02-23 07:28:52','fengxian','丰县',NULL),(838,'320322','沛县','116.937182,34.729044','district',831,0,'P','2018-12-14 00:20:34','2019-02-23 07:28:52','peixian','沛县',NULL),(839,'320324','睢宁县','117.95066,33.899222','district',831,0,'S','2018-12-14 00:20:34','2019-02-23 07:28:52','suiningxian','睢宁县',NULL),(840,'320381','新沂市','118.345828,34.368779','district',831,0,'X','2018-12-14 00:20:34','2019-02-23 07:28:52','xinyi','新沂',NULL),(841,'320382','邳州市','117.963923,34.314708','district',831,0,'P','2018-12-14 00:20:34','2019-02-23 07:28:52','pizhou','邳州',NULL),(842,'320400','常州市','119.946973,31.772752','city',810,0,'C','2018-12-14 00:20:34','2019-02-23 07:28:52','changzhou','常州',NULL),(843,'320402','天宁区','119.963783,31.779632','district',842,0,'T','2018-12-14 00:20:34','2019-02-23 07:28:52','tianningqu','天宁区',NULL),(844,'320404','钟楼区','119.948388,31.78096','district',842,0,'Z','2018-12-14 00:20:34','2019-02-23 07:28:52','zhonglouqu','钟楼区',NULL),(845,'320411','新北区','119.974654,31.824664','district',842,0,'X','2018-12-14 00:20:34','2019-02-23 07:28:52','xinbeiqu','新北区',NULL),(846,'320412','武进区','119.958773,31.718566','district',842,0,'W','2018-12-14 00:20:34','2019-02-23 07:28:52','wujinqu','武进区',NULL),(847,'320413','金坛区','119.573395,31.744399','district',842,0,'J','2018-12-14 00:20:34','2019-02-23 07:28:52','jintanqu','金坛区',NULL),(848,'320481','溧阳市','119.487816,31.427081','district',842,0,'L','2018-12-14 00:20:34','2019-02-23 07:28:52','liyang','溧阳',NULL),(849,'320500','苏州市','120.619585,31.299379','city',810,0,'S','2018-12-14 00:20:34','2019-02-23 07:28:53','suzhou','苏州',1),(850,'320505','虎丘区','120.566833,31.294845','district',849,0,'H','2018-12-14 00:20:34','2019-02-23 07:28:53','huqiuqu','虎丘区',NULL),(851,'320506','吴中区','120.624621,31.270839','district',849,0,'W','2018-12-14 00:20:34','2019-02-23 07:28:53','wuzhongqu','吴中区',NULL),(852,'320507','相城区','120.618956,31.396684','district',849,0,'X','2018-12-14 00:20:34','2019-02-23 07:28:53','xiangchengqu','相城区',NULL),(853,'320508','姑苏区','120.622249,31.311414','district',849,0,'G','2018-12-14 00:20:34','2019-02-23 07:28:53','gusuqu','姑苏区',NULL),(854,'320509','吴江区','120.641601,31.160404','district',849,0,'W','2018-12-14 00:20:34','2019-02-23 07:28:53','wujiangqu','吴江区',NULL),(855,'320581','常熟市','120.74852,31.658156','district',849,0,'C','2018-12-14 00:20:34','2019-02-23 07:28:53','changshu','常熟',NULL),(856,'320582','张家港市','120.543441,31.865553','district',849,0,'Z','2018-12-14 00:20:34','2019-02-23 07:28:53','zhangjiagang','张家港',NULL),(857,'320583','昆山市','120.958137,31.381925','district',849,0,'K','2018-12-14 00:20:35','2019-02-23 07:28:53','kunshan','昆山',NULL),(858,'320585','太仓市','121.112275,31.452568','district',849,0,'T','2018-12-14 00:20:35','2019-02-23 07:28:53','taicang','太仓',NULL),(859,'320600','南通市','120.864608,32.016212','city',810,0,'N','2018-12-14 00:20:35','2019-02-23 07:28:53','nantong','南通',NULL),(860,'320602','崇川区','120.86635,32.015278','district',859,0,'C','2018-12-14 00:20:35','2019-02-23 07:28:53','chongchuanqu','崇川区',NULL),(861,'320611','港闸区','120.8339,32.040299','district',859,0,'G','2018-12-14 00:20:35','2019-02-23 07:28:53','gangzhaqu','港闸区',NULL),(862,'320612','通州区','121.073171,32.084287','district',859,0,'T','2018-12-14 00:20:35','2019-02-23 07:28:53','tongzhouqu','通州区',NULL),(863,'320621','海安县','120.465995,32.540289','district',859,0,'H','2018-12-14 00:20:35','2019-02-23 07:28:53','haianxian','海安县',NULL),(864,'320623','如东县','121.186088,32.311832','district',859,0,'R','2018-12-14 00:20:35','2019-02-23 07:28:53','rudongxian','如东县',NULL),(865,'320681','启东市','121.659724,31.810158','district',859,0,'Q','2018-12-14 00:20:35','2019-02-23 07:28:53','qidong','启东',NULL),(866,'320682','如皋市','120.566324,32.391591','district',859,0,'R','2018-12-14 00:20:35','2019-02-23 07:28:53','rugao','如皋',NULL),(867,'320684','海门市','121.176609,31.893528','district',859,0,'H','2018-12-14 00:20:35','2019-02-23 07:28:53','haimen','海门',NULL),(868,'320700','连云港市','119.178821,34.600018','city',810,0,'L','2018-12-14 00:20:35','2019-02-23 07:28:53','lianyungang','连云港',NULL),(869,'320703','连云区','119.366487,34.739529','district',868,0,'L','2018-12-14 00:20:35','2019-02-23 07:28:53','lianyunqu','连云区',NULL),(870,'320706','海州区','119.179793,34.601584','district',868,0,'H','2018-12-14 00:20:35','2019-02-23 07:28:53','haizhouqu','海州区',NULL),(871,'320707','赣榆区','119.128774,34.839154','district',868,0,'G','2018-12-14 00:20:35','2019-02-23 07:28:53','ganyuqu','赣榆区',NULL),(872,'320722','东海县','118.766489,34.522859','district',868,0,'D','2018-12-14 00:20:35','2019-02-23 07:28:53','donghaixian','东海县',NULL),(873,'320723','灌云县','119.255741,34.298436','district',868,0,'G','2018-12-14 00:20:35','2019-02-23 07:28:53','guanyunxian','灌云县',NULL),(874,'320724','灌南县','119.352331,34.092553','district',868,0,'G','2018-12-14 00:20:35','2019-02-23 07:28:53','guannanxian','灌南县',NULL),(875,'320800','淮安市','119.021265,33.597506','city',810,0,'H','2018-12-14 00:20:36','2019-02-23 07:28:53','huaian','淮安',NULL),(876,'320803','淮安区','119.14634,33.507499','district',875,0,'H','2018-12-14 00:20:36','2019-02-23 07:28:53','huaianqu','淮安区',NULL),(877,'320804','淮阴区','119.020817,33.622452','district',875,0,'H','2018-12-14 00:20:36','2019-02-23 07:28:53','huaiyinqu','淮阴区',NULL),(878,'320812','清江浦区','119.019454,33.603234','district',875,0,'Q','2018-12-14 00:20:36','2019-02-23 07:28:53','qingjiangpuqu','清江浦区',NULL),(879,'320813','洪泽区','118.867875,33.294975','district',875,0,'H','2018-12-14 00:20:36','2019-02-23 07:28:53','hongzequ','洪泽区',NULL),(880,'320826','涟水县','119.266078,33.771308','district',875,0,'L','2018-12-14 00:20:36','2019-02-23 07:28:53','lianshuixian','涟水县',NULL),(881,'320830','盱眙县','118.493823,33.00439','district',875,0,'X','2018-12-14 00:20:36','2019-02-23 07:28:53','xuyixian','盱眙县',NULL),(882,'320831','金湖县','119.016936,33.018162','district',875,0,'J','2018-12-14 00:20:36','2019-02-23 07:28:53','jinhuxian','金湖县',NULL),(883,'320900','盐城市','120.139998,33.377631','city',810,0,'Y','2018-12-14 00:20:36','2019-02-23 07:28:53','yancheng','盐城',NULL),(884,'320902','亭湖区','120.136078,33.383912','district',883,0,'T','2018-12-14 00:20:36','2019-02-23 07:28:53','tinghuqu','亭湖区',NULL),(885,'320903','盐都区','120.139753,33.341288','district',883,0,'Y','2018-12-14 00:20:36','2019-02-23 07:28:54','yanduqu','盐都区',NULL),(886,'320904','大丰区','120.470324,33.199531','district',883,0,'D','2018-12-14 00:20:36','2019-02-23 07:28:54','dafengqu','大丰区',NULL),(887,'320921','响水县','119.579573,34.19996','district',883,0,'X','2018-12-14 00:20:36','2019-02-23 07:28:54','xiangshuixian','响水县',NULL),(888,'320922','滨海县','119.828434,33.989888','district',883,0,'B','2018-12-14 00:20:36','2019-02-23 07:28:54','binhaixian','滨海县',NULL),(889,'320923','阜宁县','119.805338,33.78573','district',883,0,'F','2018-12-14 00:20:36','2019-02-23 07:28:54','funingxian','阜宁县',NULL),(890,'320924','射阳县','120.257444,33.773779','district',883,0,'S','2018-12-14 00:20:36','2019-02-23 07:28:54','sheyangxian','射阳县',NULL),(891,'320925','建湖县','119.793105,33.472621','district',883,0,'J','2018-12-14 00:20:36','2019-02-23 07:28:54','jianhuxian','建湖县',NULL),(892,'320981','东台市','120.314101,32.853174','district',883,0,'D','2018-12-14 00:20:36','2019-02-23 07:28:54','dongtai','东台',NULL),(893,'321000','扬州市','119.421003,32.393159','city',810,0,'Y','2018-12-14 00:20:36','2019-02-23 07:28:54','yangzhou','扬州',NULL),(894,'321002','广陵区','119.442267,32.392154','district',893,0,'G','2018-12-14 00:20:36','2019-02-23 07:28:54','guanglingqu','广陵区',NULL),(895,'321003','邗江区','119.397777,32.377899','district',893,0,'H','2018-12-14 00:20:37','2019-02-23 07:28:54','hanjiangqu','邗江区',NULL),(896,'321012','江都区','119.567481,32.426564','district',893,0,'J','2018-12-14 00:20:37','2019-02-23 07:28:54','jiangduqu','江都区',NULL),(897,'321023','宝应县','119.321284,33.23694','district',893,0,'B','2018-12-14 00:20:37','2019-02-23 07:28:54','baoyingxian','宝应县',NULL),(898,'321081','仪征市','119.182443,32.271965','district',893,0,'Y','2018-12-14 00:20:37','2019-02-23 07:28:54','yizheng','仪征',NULL),(899,'321084','高邮市','119.443842,32.785164','district',893,0,'G','2018-12-14 00:20:37','2019-02-23 07:28:54','gaoyou','高邮',NULL),(900,'321100','镇江市','119.452753,32.204402','city',810,0,'Z','2018-12-14 00:20:37','2019-02-23 07:28:54','zhenjiang','镇江',NULL),(901,'321102','京口区','119.454571,32.206191','district',900,0,'J','2018-12-14 00:20:37','2019-02-23 07:28:54','jingkouqu','京口区',NULL),(902,'321111','润州区','119.414877,32.213501','district',900,0,'R','2018-12-14 00:20:37','2019-02-23 07:28:54','runzhouqu','润州区',NULL),(903,'321112','丹徒区','119.433883,32.128972','district',900,0,'D','2018-12-14 00:20:37','2019-02-23 07:28:54','dantuqu','丹徒区',NULL),(904,'321181','丹阳市','119.581911,31.991459','district',900,0,'D','2018-12-14 00:20:37','2019-02-23 07:28:54','danyang','丹阳',NULL),(905,'321182','扬中市','119.828054,32.237266','district',900,0,'Y','2018-12-14 00:20:37','2019-02-23 07:28:54','yangzhong','扬中',NULL),(906,'321183','句容市','119.167135,31.947355','district',900,0,'J','2018-12-14 00:20:37','2019-02-23 07:28:54','jurong','句容',NULL),(907,'321200','泰州市','119.915176,32.484882','city',810,0,'T','2018-12-14 00:20:37','2019-02-23 07:28:54','taizhou','泰州',NULL),(908,'321202','海陵区','119.920187,32.488406','district',907,0,'H','2018-12-14 00:20:37','2019-02-23 07:28:54','hailingqu','海陵区',NULL),(909,'321203','高港区','119.88166,32.315701','district',907,0,'G','2018-12-14 00:20:37','2019-02-23 07:28:54','gaogangqu','高港区',NULL),(910,'321204','姜堰区','120.148208,32.508483','district',907,0,'J','2018-12-14 00:20:37','2019-02-23 07:28:55','jiangyanqu','姜堰区',NULL),(911,'321281','兴化市','119.840162,32.938065','district',907,0,'X','2018-12-14 00:20:37','2019-02-23 07:28:55','xinghua','兴化',NULL),(912,'321282','靖江市','120.26825,32.018168','district',907,0,'J','2018-12-14 00:20:37','2019-02-23 07:28:55','jingjiang','靖江',NULL),(913,'321283','泰兴市','120.020228,32.168784','district',907,0,'T','2018-12-14 00:20:37','2019-02-23 07:28:55','taixing','泰兴',NULL),(914,'321300','宿迁市','118.275162,33.963008','city',810,0,'S','2018-12-14 00:20:37','2019-02-23 07:28:55','suqian','宿迁',NULL),(915,'321302','宿城区','118.278984,33.937726','district',914,0,'S','2018-12-14 00:20:38','2019-02-23 07:28:55','suchengqu','宿城区',NULL),(916,'321311','宿豫区','118.330012,33.941071','district',914,0,'S','2018-12-14 00:20:38','2019-02-23 07:28:55','suyuqu','宿豫区',NULL),(917,'321322','沭阳县','118.775889,34.129097','district',914,0,'S','2018-12-14 00:20:38','2019-02-23 07:28:55','shuyangxian','沭阳县',NULL),(918,'321323','泗阳县','118.681284,33.711433','district',914,0,'S','2018-12-14 00:20:38','2019-02-23 07:28:55','siyangxian','泗阳县',NULL),(919,'321324','泗洪县','118.211824,33.456538','district',914,0,'S','2018-12-14 00:20:38','2019-02-23 07:28:55','sihongxian','泗洪县',NULL),(920,'330000','浙江省','120.153576,30.287459','province',0,8999,'Z','2018-12-14 00:20:38','2019-02-23 07:28:55','zhejiangsheng','浙江省',NULL),(921,'330100','杭州市','120.153576,30.287459','city',920,0,'H','2018-12-14 00:20:38','2019-02-23 07:28:55','hangzhou','杭州',1),(922,'330102','上城区','120.171465,30.250236','district',921,0,'S','2018-12-14 00:20:38','2019-02-23 07:28:55','shangchengqu','上城区',NULL),(923,'330103','下城区','120.172763,30.276271','district',921,0,'X','2018-12-14 00:20:38','2019-02-23 07:28:55','xiachengqu','下城区',NULL),(924,'330104','江干区','120.202633,30.266603','district',921,0,'J','2018-12-14 00:20:38','2019-02-23 07:28:55','jiangganqu','江干区',NULL),(925,'330105','拱墅区','120.150053,30.314697','district',921,0,'G','2018-12-14 00:20:38','2019-02-23 07:28:55','gongshuqu','拱墅区',NULL),(926,'330106','西湖区','120.147376,30.272934','district',921,0,'X','2018-12-14 00:20:38','2019-02-23 07:28:55','xihuqu','西湖区',NULL),(927,'330108','滨江区','120.21062,30.206615','district',921,0,'B','2018-12-14 00:20:38','2019-02-23 07:28:55','binjiangqu','滨江区',NULL),(928,'330109','萧山区','120.27069,30.162932','district',921,0,'X','2018-12-14 00:20:38','2019-02-23 07:28:55','xiaoshanqu','萧山区',NULL),(929,'330110','余杭区','120.301737,30.421187','district',921,0,'Y','2018-12-14 00:20:38','2019-02-23 07:28:55','yuhangqu','余杭区',NULL),(930,'330111','富阳区','119.949869,30.049871','district',921,0,'F','2018-12-14 00:20:38','2019-02-23 07:28:55','fuyangqu','富阳区',NULL),(931,'330112','临安区','119.715101,30.231153','district',921,0,'L','2018-12-14 00:20:38','2019-02-23 07:28:55','linanqu','临安区',NULL),(932,'330122','桐庐县','119.685045,29.797437','district',921,0,'T','2018-12-14 00:20:38','2019-02-23 07:28:55','tongluxian','桐庐县',NULL),(933,'330127','淳安县','119.044276,29.604177','district',921,0,'C','2018-12-14 00:20:38','2019-02-23 07:28:55','chunanxian','淳安县',NULL),(934,'330182','建德市','119.279089,29.472284','district',921,0,'J','2018-12-14 00:20:39','2019-02-23 07:28:55','jiande','建德',NULL),(935,'330200','宁波市','121.549792,29.868388','city',920,0,'N','2018-12-14 00:20:39','2019-02-23 07:28:55','ningbo','宁波',NULL),(936,'330203','海曙区','121.539698,29.874452','district',935,0,'H','2018-12-14 00:20:39','2019-02-23 07:28:55','haishuqu','海曙区',NULL),(937,'330205','江北区','121.559282,29.888361','district',935,0,'J','2018-12-14 00:20:39','2019-02-23 07:28:55','jiangbeiqu','江北区',NULL),(938,'330206','北仑区','121.831303,29.90944','district',935,0,'B','2018-12-14 00:20:39','2019-02-23 07:28:55','beilunqu','北仑区',NULL),(939,'330211','镇海区','121.713162,29.952107','district',935,0,'Z','2018-12-14 00:20:39','2019-02-23 07:28:55','zhenhaiqu','镇海区',NULL),(940,'330212','鄞州区','121.558436,29.831662','district',935,0,'Y','2018-12-14 00:20:39','2019-02-23 07:28:55','yinzhouqu','鄞州区',NULL),(941,'330213','奉化区','121.41089,29.662348','district',935,0,'F','2018-12-14 00:20:39','2019-02-23 07:28:55','fenghuaqu','奉化区',NULL),(942,'330225','象山县','121.877091,29.470206','district',935,0,'X','2018-12-14 00:20:39','2019-02-23 07:28:56','xiangshanxian','象山县',NULL),(943,'330226','宁海县','121.432606,29.299836','district',935,0,'N','2018-12-14 00:20:39','2019-02-23 07:28:56','ninghaixian','宁海县',NULL),(944,'330281','余姚市','121.156294,30.045404','district',935,0,'Y','2018-12-14 00:20:39','2019-02-23 07:28:56','yuyao','余姚',NULL),(945,'330282','慈溪市','121.248052,30.177142','district',935,0,'C','2018-12-14 00:20:39','2019-02-23 07:28:56','cixi','慈溪',NULL),(946,'330300','温州市','120.672111,28.000575','city',920,0,'W','2018-12-14 00:20:39','2019-02-23 07:28:56','wenzhou','温州',NULL),(947,'330302','鹿城区','120.674231,28.003352','district',946,0,'L','2018-12-14 00:20:39','2019-02-23 07:28:56','luchengqu','鹿城区',NULL),(948,'330303','龙湾区','120.763469,27.970254','district',946,0,'L','2018-12-14 00:20:39','2019-02-23 07:28:56','longwanqu','龙湾区',NULL),(949,'330304','瓯海区','120.637145,28.006444','district',946,0,'O','2018-12-14 00:20:39','2019-02-23 07:28:56','ouhaiqu','瓯海区',NULL),(950,'330305','洞头区','121.156181,27.836057','district',946,0,'D','2018-12-14 00:20:39','2019-02-23 07:28:56','dongtouqu','洞头区',NULL),(951,'330324','永嘉县','120.690968,28.153886','district',946,0,'Y','2018-12-14 00:20:40','2019-02-23 07:28:56','yongjiaxian','永嘉县',NULL),(952,'330326','平阳县','120.564387,27.6693','district',946,0,'P','2018-12-14 00:20:40','2019-02-23 07:28:56','pingyangxian','平阳县',NULL),(953,'330327','苍南县','120.406256,27.507743','district',946,0,'C','2018-12-14 00:20:40','2019-02-23 07:28:56','cangnanxian','苍南县',NULL),(954,'330328','文成县','120.09245,27.789133','district',946,0,'W','2018-12-14 00:20:40','2019-02-23 07:28:56','wenchengxian','文成县',NULL),(955,'330329','泰顺县','119.71624,27.557309','district',946,0,'T','2018-12-14 00:20:40','2019-02-23 07:28:56','taishunxian','泰顺县',NULL),(956,'330381','瑞安市','120.646171,27.779321','district',946,0,'R','2018-12-14 00:20:40','2019-02-23 07:28:56','ruian','瑞安',NULL),(957,'330382','乐清市','120.967147,28.116083','district',946,0,'Y','2018-12-14 00:20:40','2019-02-23 07:28:56','yueqing','乐清',NULL),(958,'330400','嘉兴市','120.750865,30.762653','city',920,0,'J','2018-12-14 00:20:40','2019-02-23 07:28:56','jiaxing','嘉兴',NULL),(959,'330402','南湖区','120.749953,30.764652','district',958,0,'N','2018-12-14 00:20:40','2019-02-23 07:28:56','nanhuqu','南湖区',NULL),(960,'330411','秀洲区','120.720431,30.763323','district',958,0,'X','2018-12-14 00:20:40','2019-02-23 07:28:56','xiuzhouqu','秀洲区',NULL),(961,'330421','嘉善县','120.921871,30.841352','district',958,0,'J','2018-12-14 00:20:40','2019-02-23 07:28:56','jiashanxian','嘉善县',NULL),(962,'330424','海盐县','120.942017,30.522223','district',958,0,'H','2018-12-14 00:20:40','2019-02-23 07:28:56','haiyanxian','海盐县',NULL),(963,'330481','海宁市','120.688821,30.525544','district',958,0,'H','2018-12-14 00:20:40','2019-02-23 07:28:56','haining','海宁',NULL),(964,'330482','平湖市','121.014666,30.698921','district',958,0,'P','2018-12-14 00:20:40','2019-02-23 07:28:56','pinghu','平湖',NULL),(965,'330483','桐乡市','120.551085,30.629065','district',958,0,'T','2018-12-14 00:20:40','2019-02-23 07:28:56','tongxiang','桐乡',NULL),(966,'330500','湖州市','120.102398,30.867198','city',920,0,'H','2018-12-14 00:20:40','2019-02-23 07:28:56','huzhou','湖州',NULL),(967,'330502','吴兴区','120.101416,30.867252','district',966,0,'W','2018-12-14 00:20:40','2019-02-23 07:28:56','wuxingqu','吴兴区',NULL),(968,'330503','南浔区','120.417195,30.872742','district',966,0,'N','2018-12-14 00:20:40','2019-02-23 07:28:56','nanxunqu','南浔区',NULL),(969,'330521','德清县','119.967662,30.534927','district',966,0,'D','2018-12-14 00:20:40','2019-02-23 07:28:56','deqingxian','德清县',NULL),(970,'330522','长兴县','119.910122,31.00475','district',966,0,'C','2018-12-14 00:20:41','2019-02-23 07:28:56','changxingxian','长兴县',NULL),(971,'330523','安吉县','119.687891,30.631974','district',966,0,'A','2018-12-14 00:20:41','2019-02-23 07:28:56','anjixian','安吉县',NULL),(972,'330600','绍兴市','120.582112,29.997117','city',920,0,'S','2018-12-14 00:20:41','2019-02-23 07:28:56','shaoxing','绍兴',NULL),(973,'330602','越城区','120.585315,29.996993','district',972,0,'Y','2018-12-14 00:20:41','2019-02-23 07:28:56','yuechengqu','越城区',NULL),(974,'330603','柯桥区','120.476075,30.078038','district',972,0,'K','2018-12-14 00:20:41','2019-02-23 07:28:56','keqiaoqu','柯桥区',NULL),(975,'330604','上虞区','120.874185,30.016769','district',972,0,'S','2018-12-14 00:20:41','2019-02-23 07:28:56','shangyuqu','上虞区',NULL),(976,'330624','新昌县','120.905665,29.501205','district',972,0,'X','2018-12-14 00:20:41','2019-02-23 07:28:56','xinchangxian','新昌县',NULL),(977,'330681','诸暨市','120.244326,29.713662','district',972,0,'Z','2018-12-14 00:20:41','2019-02-23 07:28:56','zhuji','诸暨',NULL),(978,'330683','嵊州市','120.82888,29.586606','district',972,0,'S','2018-12-14 00:20:41','2019-02-23 07:28:56','shengzhou','嵊州',NULL),(979,'330700','金华市','119.649506,29.089524','city',920,0,'J','2018-12-14 00:20:41','2019-02-23 07:28:57','jinhua','金华',NULL),(980,'330702','婺城区','119.652579,29.082607','district',979,0,'W','2018-12-14 00:20:41','2019-02-23 07:28:57','wuchengqu','婺城区',NULL),(981,'330703','金东区','119.681264,29.095835','district',979,0,'J','2018-12-14 00:20:41','2019-02-23 07:28:57','jindongqu','金东区',NULL),(982,'330723','武义县','119.819159,28.896563','district',979,0,'W','2018-12-14 00:20:41','2019-02-23 07:28:57','wuyixian','武义县',NULL),(983,'330726','浦江县','119.893363,29.451254','district',979,0,'P','2018-12-14 00:20:41','2019-02-23 07:28:57','pujiangxian','浦江县',NULL),(984,'330727','磐安县','120.44513,29.052627','district',979,0,'P','2018-12-14 00:20:41','2019-02-23 07:28:57','pananxian','磐安县',NULL),(985,'330781','兰溪市','119.460521,29.210065','district',979,0,'L','2018-12-14 00:20:41','2019-02-23 07:28:57','lanxi','兰溪',NULL),(986,'330782','义乌市','120.074911,29.306863','district',979,0,'Y','2018-12-14 00:20:41','2019-02-23 07:28:57','yiwu','义乌',NULL),(987,'330783','东阳市','120.23334,29.262546','district',979,0,'D','2018-12-14 00:20:41','2019-02-23 07:28:57','dongyang','东阳',NULL),(988,'330784','永康市','120.036328,28.895293','district',979,0,'Y','2018-12-14 00:20:41','2019-02-23 07:28:57','yongkang','永康',NULL),(989,'330800','衢州市','118.87263,28.941708','city',920,0,'Q','2018-12-14 00:20:41','2019-02-23 07:28:57','quzhou','衢州',NULL),(990,'330802','柯城区','118.873041,28.944539','district',989,0,'K','2018-12-14 00:20:41','2019-02-23 07:28:57','kechengqu','柯城区',NULL),(991,'330803','衢江区','118.957683,28.973195','district',989,0,'Q','2018-12-14 00:20:42','2019-02-23 07:28:57','qujiangqu','衢江区',NULL),(992,'330822','常山县','118.521654,28.900039','district',989,0,'C','2018-12-14 00:20:42','2019-02-23 07:28:57','changshanxian','常山县',NULL),(993,'330824','开化县','118.414435,29.136503','district',989,0,'K','2018-12-14 00:20:42','2019-02-23 07:28:57','kaihuaxian','开化县',NULL),(994,'330825','龙游县','119.172525,29.031364','district',989,0,'L','2018-12-14 00:20:42','2019-02-23 07:28:57','longyouxian','龙游县',NULL),(995,'330881','江山市','118.627879,28.734674','district',989,0,'J','2018-12-14 00:20:42','2019-02-23 07:28:57','jiangshan','江山',NULL),(996,'330900','舟山市','122.106863,30.016028','city',920,0,'Z','2018-12-14 00:20:42','2019-02-23 07:28:57','zhoushan','舟山',NULL),(997,'330902','定海区','122.108496,30.016423','district',996,0,'D','2018-12-14 00:20:42','2019-02-23 07:28:57','dinghaiqu','定海区',NULL),(998,'330903','普陀区','122.301953,29.945614','district',996,0,'P','2018-12-14 00:20:42','2019-02-23 07:28:57','putuoqu','普陀区',NULL),(999,'330921','岱山县','122.201132,30.242865','district',996,0,'D','2018-12-14 00:20:42','2019-02-23 07:28:57','daishanxian','岱山县',NULL),(1000,'330922','嵊泗县','122.457809,30.727166','district',996,0,'S','2018-12-14 00:20:42','2019-02-23 07:28:57','shengsixian','嵊泗县',NULL),(1001,'331000','台州市','121.428599,28.661378','city',920,0,'T','2018-12-14 00:20:42','2019-02-23 07:28:57','taizhou','台州',NULL),(1002,'331002','椒江区','121.431049,28.67615','district',1001,0,'J','2018-12-14 00:20:42','2019-02-23 07:28:57','jiaojiangqu','椒江区',NULL),(1003,'331003','黄岩区','121.262138,28.64488','district',1001,0,'H','2018-12-14 00:20:42','2019-02-23 07:28:57','huangyanqu','黄岩区',NULL),(1004,'331004','路桥区','121.37292,28.581799','district',1001,0,'L','2018-12-14 00:20:42','2019-02-23 07:28:57','luqiaoqu','路桥区',NULL),(1005,'331022','三门县','121.376429,29.118955','district',1001,0,'S','2018-12-14 00:20:42','2019-02-23 07:28:57','sanmenxian','三门县',NULL),(1006,'331023','天台县','121.031227,29.141126','district',1001,0,'T','2018-12-14 00:20:42','2019-02-23 07:28:57','tiantaixian','天台县',NULL),(1007,'331024','仙居县','120.735074,28.849213','district',1001,0,'X','2018-12-14 00:20:42','2019-02-23 07:28:57','xianjuxian','仙居县',NULL),(1008,'331081','温岭市','121.373611,28.368781','district',1001,0,'W','2018-12-14 00:20:42','2019-02-23 07:28:57','wenling','温岭',NULL),(1009,'331082','临海市','121.131229,28.845441','district',1001,0,'L','2018-12-14 00:20:42','2019-02-23 07:28:57','linhai','临海',NULL),(1010,'331083','玉环市','121.232337,28.12842','district',1001,0,'Y','2018-12-14 00:20:42','2019-02-23 07:28:57','yuhuan','玉环',NULL),(1011,'331100','丽水市','119.921786,28.451993','city',920,0,'L','2018-12-14 00:20:43','2019-02-23 07:28:57','lishui','丽水',NULL),(1012,'331102','莲都区','119.922293,28.451103','district',1011,0,'L','2018-12-14 00:20:43','2019-02-23 07:28:57','lianduqu','莲都区',NULL),(1013,'331121','青田县','120.291939,28.135247','district',1011,0,'Q','2018-12-14 00:20:43','2019-02-23 07:28:58','qingtianxian','青田县',NULL),(1014,'331122','缙云县','120.078965,28.654208','district',1011,0,'J','2018-12-14 00:20:43','2019-02-23 07:28:58','jinyunxian','缙云县',NULL),(1015,'331123','遂昌县','119.27589,28.5924','district',1011,0,'S','2018-12-14 00:20:43','2019-02-23 07:28:58','suichangxian','遂昌县',NULL),(1016,'331124','松阳县','119.485292,28.449937','district',1011,0,'S','2018-12-14 00:20:43','2019-02-23 07:28:58','songyangxian','松阳县',NULL),(1017,'331125','云和县','119.569458,28.111077','district',1011,0,'Y','2018-12-14 00:20:43','2019-02-23 07:28:58','yunhexian','云和县',NULL),(1018,'331126','庆元县','119.067233,27.618231','district',1011,0,'Q','2018-12-14 00:20:43','2019-02-23 07:28:58','qingyuanxian','庆元县',NULL),(1019,'331127','景宁畲族自治县','119.634669,27.977247','district',1011,0,'J','2018-12-14 00:20:43','2019-02-23 07:28:58','jingningshezuzizhixian','景宁畲族自治县',NULL),(1020,'331181','龙泉市','119.132319,28.069177','district',1011,0,'L','2018-12-14 00:20:43','2019-02-23 07:28:58','longquan','龙泉',NULL),(1021,'340000','安徽省','117.283042,31.86119','province',0,6200,'A','2018-12-14 00:20:43','2019-02-23 07:28:58','anhuisheng','安徽省',NULL),(1022,'340100','合肥市','117.283042,31.86119','city',1021,0,'H','2018-12-14 00:20:43','2019-02-23 07:28:58','hefei','合肥',NULL),(1023,'340102','瑶海区','117.315358,31.86961','district',1022,0,'Y','2018-12-14 00:20:43','2019-02-23 07:28:58','yaohaiqu','瑶海区',NULL),(1024,'340103','庐阳区','117.283776,31.869011','district',1022,0,'L','2018-12-14 00:20:43','2019-02-23 07:28:58','luyangqu','庐阳区',NULL),(1025,'340104','蜀山区','117.262072,31.855868','district',1022,0,'S','2018-12-14 00:20:43','2019-02-23 07:28:58','shushanqu','蜀山区',NULL),(1026,'340111','包河区','117.285751,31.82956','district',1022,0,'B','2018-12-14 00:20:43','2019-02-23 07:28:58','baohequ','包河区',NULL),(1027,'340121','长丰县','117.164699,32.478548','district',1022,0,'C','2018-12-14 00:20:43','2019-02-23 07:28:58','changfengxian','长丰县',NULL),(1028,'340122','肥东县','117.463222,31.883992','district',1022,0,'F','2018-12-14 00:20:43','2019-02-23 07:28:58','feidongxian','肥东县',NULL),(1029,'340123','肥西县','117.166118,31.719646','district',1022,0,'F','2018-12-14 00:20:43','2019-02-23 07:28:58','feixixian','肥西县',NULL),(1030,'340124','庐江县','117.289844,31.251488','district',1022,0,'L','2018-12-14 00:20:44','2019-02-23 07:28:58','lujiangxian','庐江县',NULL),(1031,'340181','巢湖市','117.874155,31.600518','district',1022,0,'C','2018-12-14 00:20:44','2019-02-23 07:28:58','chaohu','巢湖',NULL),(1032,'340200','芜湖市','118.376451,31.326319','city',1021,0,'W','2018-12-14 00:20:44','2019-02-23 07:28:58','wuhu','芜湖',NULL),(1033,'340202','镜湖区','118.376343,31.32559','district',1032,0,'J','2018-12-14 00:20:44','2019-02-23 07:28:58','jinghuqu','镜湖区',NULL),(1034,'340203','弋江区','118.377476,31.313394','district',1032,0,'Y','2018-12-14 00:20:44','2019-02-23 07:28:58','yijiangqu','弋江区',NULL),(1035,'340207','鸠江区','118.400174,31.362716','district',1032,0,'J','2018-12-14 00:20:44','2019-02-23 07:28:58','jiujiangqu','鸠江区',NULL),(1036,'340208','三山区','118.233987,31.225423','district',1032,0,'S','2018-12-14 00:20:44','2019-02-23 07:28:58','sanshanqu','三山区',NULL),(1037,'340221','芜湖县','118.572301,31.145262','district',1032,0,'W','2018-12-14 00:20:44','2019-02-23 07:28:58','wuhuxian','芜湖县',NULL),(1038,'340222','繁昌县','118.201349,31.080896','district',1032,0,'F','2018-12-14 00:20:44','2019-02-23 07:28:58','fanchangxian','繁昌县',NULL),(1039,'340223','南陵县','118.337104,30.919638','district',1032,0,'N','2018-12-14 00:20:44','2019-02-23 07:28:58','nanlingxian','南陵县',NULL),(1040,'340225','无为县','117.911432,31.303075','district',1032,0,'W','2018-12-14 00:20:44','2019-02-23 07:28:58','wuweixian','无为县',NULL),(1041,'340300','蚌埠市','117.363228,32.939667','city',1021,0,'B','2018-12-14 00:20:44','2019-02-23 07:28:58','bengbu','蚌埠',NULL),(1042,'340302','龙子湖区','117.382312,32.950452','district',1041,0,'L','2018-12-14 00:20:44','2019-02-23 07:28:58','longzihuqu','龙子湖区',NULL),(1043,'340303','蚌山区','117.355789,32.938066','district',1041,0,'B','2018-12-14 00:20:44','2019-02-23 07:28:58','bengshanqu','蚌山区',NULL),(1044,'340304','禹会区','117.35259,32.931933','district',1041,0,'Y','2018-12-14 00:20:44','2019-02-23 07:28:58','yuhuiqu','禹会区',NULL),(1045,'340311','淮上区','117.34709,32.963147','district',1041,0,'H','2018-12-14 00:20:44','2019-02-23 07:28:58','huaishangqu','淮上区',NULL),(1046,'340321','怀远县','117.200171,32.956934','district',1041,0,'H','2018-12-14 00:20:44','2019-02-23 07:28:58','huaiyuanxian','怀远县',NULL),(1047,'340322','五河县','117.888809,33.146202','district',1041,0,'W','2018-12-14 00:20:45','2019-02-23 07:28:58','wuhexian','五河县',NULL),(1048,'340323','固镇县','117.315962,33.318679','district',1041,0,'G','2018-12-14 00:20:45','2019-02-23 07:28:59','guzhenxian','固镇县',NULL),(1049,'340400','淮南市','117.018329,32.647574','city',1021,0,'H','2018-12-14 00:20:45','2019-02-23 07:28:59','huainan','淮南',NULL),(1050,'340402','大通区','117.052927,32.632066','district',1049,0,'D','2018-12-14 00:20:45','2019-02-23 07:28:59','datongqu','大通区',NULL),(1051,'340403','田家庵区','117.018318,32.644342','district',1049,0,'T','2018-12-14 00:20:45','2019-02-23 07:28:59','tianjiaanqu','田家庵区',NULL),(1052,'340404','谢家集区','116.865354,32.598289','district',1049,0,'X','2018-12-14 00:20:45','2019-02-23 07:28:59','xiejiajiqu','谢家集区',NULL),(1053,'340405','八公山区','116.841111,32.628229','district',1049,0,'B','2018-12-14 00:20:45','2019-02-23 07:28:59','bagongshanqu','八公山区',NULL),(1054,'340406','潘集区','116.816879,32.782117','district',1049,0,'P','2018-12-14 00:20:45','2019-02-23 07:28:59','panjiqu','潘集区',NULL),(1055,'340421','凤台县','116.722769,32.705382','district',1049,0,'F','2018-12-14 00:20:45','2019-02-23 07:28:59','fengtaixian','凤台县',NULL),(1056,'340422','寿县','116.785349,32.577304','district',1049,0,'S','2018-12-14 00:20:45','2019-02-23 07:28:59','shouxian','寿县',NULL),(1057,'340500','马鞍山市','118.507906,31.689362','city',1021,0,'M','2018-12-14 00:20:45','2019-02-23 07:28:59','maanshan','马鞍山',NULL),(1058,'340503','花山区','118.511308,31.69902','district',1057,0,'H','2018-12-14 00:20:45','2019-02-23 07:28:59','huashanqu','花山区',NULL),(1059,'340504','雨山区','118.493104,31.685912','district',1057,0,'Y','2018-12-14 00:20:45','2019-02-23 07:28:59','yushanqu','雨山区',NULL),(1060,'340506','博望区','118.843742,31.562321','district',1057,0,'B','2018-12-14 00:20:45','2019-02-23 07:28:59','bowangqu','博望区',NULL),(1061,'340521','当涂县','118.489873,31.556167','district',1057,0,'D','2018-12-14 00:20:45','2019-02-23 07:28:59','dangtuxian','当涂县',NULL),(1062,'340522','含山县','118.105545,31.727758','district',1057,0,'H','2018-12-14 00:20:45','2019-02-23 07:28:59','hanshanxian','含山县',NULL),(1063,'340523','和县','118.362998,31.716634','district',1057,0,'H','2018-12-14 00:20:45','2019-02-23 07:28:59','hexian','和县',NULL),(1064,'340600','淮北市','116.794664,33.971707','city',1021,0,'H','2018-12-14 00:20:45','2019-02-23 07:28:59','huaibei','淮北',NULL),(1065,'340602','杜集区','116.833925,33.991218','district',1064,0,'D','2018-12-14 00:20:45','2019-02-23 07:28:59','dujiqu','杜集区',NULL),(1066,'340603','相山区','116.790775,33.970916','district',1064,0,'X','2018-12-14 00:20:45','2019-02-23 07:28:59','xiangshanqu','相山区',NULL),(1067,'340604','烈山区','116.809465,33.889529','district',1064,0,'L','2018-12-14 00:20:46','2019-02-23 07:28:59','lieshanqu','烈山区',NULL),(1068,'340621','濉溪县','116.767435,33.916407','district',1064,0,'S','2018-12-14 00:20:46','2019-02-23 07:28:59','suixixian','濉溪县',NULL),(1069,'340700','铜陵市','117.816576,30.929935','city',1021,0,'T','2018-12-14 00:20:46','2019-02-23 07:28:59','tongling','铜陵',NULL),(1070,'340705','铜官区','117.818427,30.93182','district',1069,0,'T','2018-12-14 00:20:46','2019-02-23 07:28:59','tongguanqu','铜官区',NULL),(1071,'340706','义安区','117.792288,30.952338','district',1069,0,'Y','2018-12-14 00:20:46','2019-02-23 07:28:59','yianqu','义安区',NULL),(1072,'340711','郊区','117.80707,30.908927','district',1069,0,'J','2018-12-14 00:20:46','2019-02-23 07:28:59','jiaoqu','郊区',NULL),(1073,'340722','枞阳县','117.222027,30.700615','district',1069,0,'Z','2018-12-14 00:20:46','2019-02-23 07:28:59','zongyangxian','枞阳县',NULL),(1074,'340800','安庆市','117.043551,30.50883','city',1021,0,'A','2018-12-14 00:20:46','2019-02-23 07:28:59','anqing','安庆',NULL),(1075,'340802','迎江区','117.044965,30.506375','district',1074,0,'Y','2018-12-14 00:20:46','2019-02-23 07:28:59','yingjiangqu','迎江区',NULL),(1076,'340803','大观区','117.034512,30.505632','district',1074,0,'D','2018-12-14 00:20:46','2019-02-23 07:28:59','daguanqu','大观区',NULL),(1077,'340811','宜秀区','117.070003,30.541323','district',1074,0,'Y','2018-12-14 00:20:46','2019-02-23 07:28:59','yixiuqu','宜秀区',NULL),(1078,'340822','怀宁县','116.828664,30.734994','district',1074,0,'H','2018-12-14 00:20:46','2019-02-23 07:28:59','huainingxian','怀宁县',NULL),(1079,'340824','潜山县','116.573666,30.638222','district',1074,0,'Q','2018-12-14 00:20:46','2019-02-23 07:28:59','qianshanxian','潜山县',NULL),(1080,'340825','太湖县','116.305225,30.451869','district',1074,0,'T','2018-12-14 00:20:46','2019-02-23 07:28:59','taihuxian','太湖县',NULL),(1081,'340826','宿松县','116.120204,30.158327','district',1074,0,'S','2018-12-14 00:20:46','2019-02-23 07:28:59','susongxian','宿松县',NULL),(1082,'340827','望江县','116.690927,30.12491','district',1074,0,'W','2018-12-14 00:20:46','2019-02-23 07:28:59','wangjiangxian','望江县',NULL),(1083,'340828','岳西县','116.360482,30.848502','district',1074,0,'Y','2018-12-14 00:20:46','2019-02-23 07:29:00','yuexixian','岳西县',NULL),(1084,'340881','桐城市','116.959656,31.050576','district',1074,0,'T','2018-12-14 00:20:46','2019-02-23 07:29:00','tongcheng','桐城',NULL),(1085,'341000','黄山市','118.317325,29.709239','city',1021,0,'H','2018-12-14 00:20:46','2019-02-23 07:29:00','huangshan','黄山',NULL),(1086,'341002','屯溪区','118.317354,29.709186','district',1085,0,'T','2018-12-14 00:20:46','2019-02-23 07:29:00','tunxiqu','屯溪区',NULL),(1087,'341003','黄山区','118.136639,30.294517','district',1085,0,'H','2018-12-14 00:20:46','2019-02-23 07:29:00','huangshanqu','黄山区',NULL),(1088,'341004','徽州区','118.339743,29.825201','district',1085,0,'H','2018-12-14 00:20:46','2019-02-23 07:29:00','huizhouqu','徽州区',NULL),(1089,'341021','歙县','118.428025,29.867748','district',1085,0,'S','2018-12-14 00:20:47','2019-02-23 07:29:00','shexian','歙县',NULL),(1090,'341022','休宁县','118.188531,29.788878','district',1085,0,'X','2018-12-14 00:20:47','2019-02-23 07:29:00','xiuningxian','休宁县',NULL),(1091,'341023','黟县','117.942911,29.923812','district',1085,0,'Y','2018-12-14 00:20:47','2019-02-23 07:29:00','yixian','黟县',NULL),(1092,'341024','祁门县','117.717237,29.853472','district',1085,0,'Q','2018-12-14 00:20:47','2019-02-23 07:29:00','qimenxian','祁门县',NULL),(1093,'341100','滁州市','118.316264,32.303627','city',1021,0,'C','2018-12-14 00:20:47','2019-02-23 07:29:00','chuzhou','滁州',NULL),(1094,'341102','琅琊区','118.316475,32.303797','district',1093,0,'L','2018-12-14 00:20:47','2019-02-23 07:29:00','langyaqu','琅琊区',NULL),(1095,'341103','南谯区','118.296955,32.329841','district',1093,0,'N','2018-12-14 00:20:47','2019-02-23 07:29:00','nanqiaoqu','南谯区',NULL),(1096,'341122','来安县','118.433293,32.450231','district',1093,0,'L','2018-12-14 00:20:47','2019-02-23 07:29:00','laianxian','来安县',NULL),(1097,'341124','全椒县','118.268576,32.09385','district',1093,0,'Q','2018-12-14 00:20:47','2019-02-23 07:29:00','quanjiaoxian','全椒县',NULL),(1098,'341125','定远县','117.683713,32.527105','district',1093,0,'D','2018-12-14 00:20:47','2019-02-23 07:29:00','dingyuanxian','定远县',NULL),(1099,'341126','凤阳县','117.562461,32.867146','district',1093,0,'F','2018-12-14 00:20:47','2019-02-23 07:29:00','fengyangxian','凤阳县',NULL),(1100,'341181','天长市','119.011212,32.6815','district',1093,0,'T','2018-12-14 00:20:47','2019-02-23 07:29:00','tianchang','天长',NULL),(1101,'341182','明光市','117.998048,32.781206','district',1093,0,'M','2018-12-14 00:20:47','2019-02-23 07:29:00','mingguang','明光',NULL),(1102,'341200','阜阳市','115.819729,32.896969','city',1021,0,'F','2018-12-14 00:20:47','2019-02-23 07:29:00','fuyang','阜阳',NULL),(1103,'341202','颍州区','115.813914,32.891238','district',1102,0,'Y','2018-12-14 00:20:47','2019-02-23 07:29:00','yingzhouqu','颍州区',NULL),(1104,'341203','颍东区','115.858747,32.908861','district',1102,0,'Y','2018-12-14 00:20:47','2019-02-23 07:29:00','yingdongqu','颍东区',NULL),(1105,'341204','颍泉区','115.804525,32.924797','district',1102,0,'Y','2018-12-14 00:20:47','2019-02-23 07:29:00','yingquanqu','颍泉区',NULL),(1106,'341221','临泉县','115.261688,33.062698','district',1102,0,'L','2018-12-14 00:20:47','2019-02-23 07:29:00','linquanxian','临泉县',NULL),(1107,'341222','太和县','115.627243,33.16229','district',1102,0,'T','2018-12-14 00:20:47','2019-02-23 07:29:00','taihexian','太和县',NULL),(1108,'341225','阜南县','115.590534,32.638102','district',1102,0,'F','2018-12-14 00:20:47','2019-02-23 07:29:00','funanxian','阜南县',NULL),(1109,'341226','颍上县','116.259122,32.637065','district',1102,0,'Y','2018-12-14 00:20:47','2019-02-23 07:29:00','yingshangxian','颍上县',NULL),(1110,'341282','界首市','115.362117,33.26153','district',1102,0,'J','2018-12-14 00:20:48','2019-02-23 07:29:00','jieshou','界首',NULL),(1111,'341300','宿州市','116.984084,33.633891','city',1021,0,'S','2018-12-14 00:20:48','2019-02-23 07:29:00','suzhou','宿州',NULL),(1112,'341302','埇桥区','116.983309,33.633853','district',1111,0,'Y','2018-12-14 00:20:48','2019-02-23 07:29:00','yongqiaoqu','埇桥区',NULL),(1113,'341321','砀山县','116.351113,34.426247','district',1111,0,'D','2018-12-14 00:20:48','2019-02-23 07:29:00','dangshanxian','砀山县',NULL),(1114,'341322','萧县','116.945399,34.183266','district',1111,0,'X','2018-12-14 00:20:48','2019-02-23 07:29:00','xiaoxian','萧县',NULL),(1115,'341323','灵璧县','117.551493,33.540629','district',1111,0,'L','2018-12-14 00:20:48','2019-02-23 07:29:00','lingbixian','灵璧县',NULL),(1116,'341324','泗县','117.885443,33.47758','district',1111,0,'S','2018-12-14 00:20:48','2019-02-23 07:29:00','sixian','泗县',NULL),(1117,'341500','六安市','116.507676,31.752889','city',1021,0,'L','2018-12-14 00:20:48','2019-02-23 07:29:00','luan','六安',NULL),(1118,'341502','金安区','116.503288,31.754491','district',1117,0,'J','2018-12-14 00:20:48','2019-02-23 07:29:00','jinanqu','金安区',NULL),(1119,'341503','裕安区','116.494543,31.750692','district',1117,0,'Y','2018-12-14 00:20:48','2019-02-23 07:29:01','yuanqu','裕安区',NULL),(1120,'341504','叶集区','115.913594,31.84768','district',1117,0,'Y','2018-12-14 00:20:48','2019-02-23 07:29:01','yejiqu','叶集区',NULL),(1121,'341522','霍邱县','116.278875,32.341305','district',1117,0,'H','2018-12-14 00:20:48','2019-02-23 07:29:01','huoqiuxian','霍邱县',NULL),(1122,'341523','舒城县','116.944088,31.462848','district',1117,0,'S','2018-12-14 00:20:48','2019-02-23 07:29:01','shuchengxian','舒城县',NULL),(1123,'341524','金寨县','115.878514,31.681624','district',1117,0,'J','2018-12-14 00:20:48','2019-02-23 07:29:01','jinzhaixian','金寨县',NULL),(1124,'341525','霍山县','116.333078,31.402456','district',1117,0,'H','2018-12-14 00:20:48','2019-02-23 07:29:01','huoshanxian','霍山县',NULL),(1125,'341600','亳州市','115.782939,33.869338','city',1021,0,'B','2018-12-14 00:20:48','2019-02-23 07:29:01','bozhou','亳州',NULL),(1126,'341602','谯城区','115.781214,33.869284','district',1125,0,'Q','2018-12-14 00:20:48','2019-02-23 07:29:01','qiaochengqu','谯城区',NULL),(1127,'341621','涡阳县','116.211551,33.502831','district',1125,0,'G','2018-12-14 00:20:48','2019-02-23 07:29:01','guoyangxian','涡阳县',NULL),(1128,'341622','蒙城县','116.560337,33.260814','district',1125,0,'M','2018-12-14 00:20:48','2019-02-23 07:29:01','mengchengxian','蒙城县',NULL),(1129,'341623','利辛县','116.207782,33.143503','district',1125,0,'L','2018-12-14 00:20:49','2019-02-23 07:29:01','lixinxian','利辛县',NULL),(1130,'341700','池州市','117.489157,30.656037','city',1021,0,'C','2018-12-14 00:20:49','2019-02-23 07:29:01','chizhou','池州',NULL),(1131,'341702','贵池区','117.488342,30.657378','district',1130,0,'G','2018-12-14 00:20:49','2019-02-23 07:29:01','guichiqu','贵池区',NULL),(1132,'341721','东至县','117.021476,30.096568','district',1130,0,'D','2018-12-14 00:20:49','2019-02-23 07:29:01','dongzhixian','东至县',NULL),(1133,'341722','石台县','117.482907,30.210324','district',1130,0,'S','2018-12-14 00:20:49','2019-02-23 07:29:01','shitaixian','石台县',NULL),(1134,'341723','青阳县','117.857395,30.63818','district',1130,0,'Q','2018-12-14 00:20:49','2019-02-23 07:29:01','qingyangxian','青阳县',NULL),(1135,'341800','宣城市','118.757995,30.945667','city',1021,0,'X','2018-12-14 00:20:49','2019-02-23 07:29:01','xuancheng','宣城',NULL),(1136,'341802','宣州区','118.758412,30.946003','district',1135,0,'X','2018-12-14 00:20:49','2019-02-23 07:29:01','xuanzhouqu','宣州区',NULL),(1137,'341821','郎溪县','119.185024,31.127834','district',1135,0,'L','2018-12-14 00:20:49','2019-02-23 07:29:01','langxixian','郎溪县',NULL),(1138,'341822','广德县','119.417521,30.893116','district',1135,0,'G','2018-12-14 00:20:49','2019-02-23 07:29:01','guangdexian','广德县',NULL),(1139,'341823','泾县','118.412397,30.685975','district',1135,0,'J','2018-12-14 00:20:49','2019-02-23 07:29:01','jingxian','泾县',NULL),(1140,'341824','绩溪县','118.594705,30.065267','district',1135,0,'J','2018-12-14 00:20:49','2019-02-23 07:29:01','jixixian','绩溪县',NULL),(1141,'341825','旌德县','118.543081,30.288057','district',1135,0,'J','2018-12-14 00:20:49','2019-02-23 07:29:01','jingdexian','旌德县',NULL),(1142,'341881','宁国市','118.983407,30.626529','district',1135,0,'N','2018-12-14 00:20:49','2019-02-23 07:29:01','ningguo','宁国',NULL),(1143,'350000','福建省','119.306239,26.075302','province',0,6000,'F','2018-12-14 00:20:49','2019-02-23 07:29:01','fujiansheng','福建省',NULL),(1144,'350100','福州市','119.306239,26.075302','city',1143,0,'F','2018-12-14 00:20:49','2019-02-23 07:29:01','fuzhou','福州',NULL),(1145,'350102','鼓楼区','119.29929,26.082284','district',1144,0,'G','2018-12-14 00:20:49','2019-02-23 07:29:01','gulouqu','鼓楼区',NULL),(1146,'350103','台江区','119.310156,26.058616','district',1144,0,'T','2018-12-14 00:20:49','2019-02-23 07:29:01','taijiangqu','台江区',NULL),(1147,'350104','仓山区','119.320988,26.038912','district',1144,0,'C','2018-12-14 00:20:49','2019-02-23 07:29:01','cangshanqu','仓山区',NULL),(1148,'350105','马尾区','119.458725,25.991975','district',1144,0,'M','2018-12-14 00:20:49','2019-02-23 07:29:01','mayiqu','马尾区',NULL),(1149,'350111','晋安区','119.328597,26.078837','district',1144,0,'J','2018-12-14 00:20:50','2019-02-23 07:29:01','jinanqu','晋安区',NULL),(1150,'350112','长乐区','119.510849,25.960583','district',1144,0,'C','2018-12-14 00:20:50','2019-02-23 07:29:01','changlequ','长乐区',NULL),(1151,'350121','闽侯县','119.145117,26.148567','district',1144,0,'M','2018-12-14 00:20:50','2019-02-23 07:29:01','minhouxian','闽侯县',NULL),(1152,'350122','连江县','119.538365,26.202109','district',1144,0,'L','2018-12-14 00:20:50','2019-02-23 07:29:01','lianjiangxian','连江县',NULL),(1153,'350123','罗源县','119.552645,26.487234','district',1144,0,'L','2018-12-14 00:20:50','2019-02-23 07:29:01','luoyuanxian','罗源县',NULL),(1154,'350124','闽清县','118.868416,26.223793','district',1144,0,'M','2018-12-14 00:20:50','2019-02-23 07:29:01','minqingxian','闽清县',NULL),(1155,'350125','永泰县','118.939089,25.864825','district',1144,0,'Y','2018-12-14 00:20:50','2019-02-23 07:29:01','yongtaixian','永泰县',NULL),(1156,'350128','平潭县','119.791197,25.503672','district',1144,0,'P','2018-12-14 00:20:50','2019-02-23 07:29:02','pingtanxian','平潭县',NULL),(1157,'350181','福清市','119.376992,25.720402','district',1144,0,'F','2018-12-14 00:20:50','2019-02-23 07:29:02','fuqing','福清',NULL),(1158,'350200','厦门市','118.11022,24.490474','city',1143,0,'X','2018-12-14 00:20:50','2019-02-23 07:29:02','xiamen','厦门',NULL),(1159,'350203','思明区','118.087828,24.462059','district',1158,0,'S','2018-12-14 00:20:50','2019-02-23 07:29:02','simingqu','思明区',NULL),(1160,'350205','海沧区','118.036364,24.492512','district',1158,0,'H','2018-12-14 00:20:50','2019-02-23 07:29:02','haicangqu','海沧区',NULL),(1161,'350206','湖里区','118.10943,24.512764','district',1158,0,'H','2018-12-14 00:20:50','2019-02-23 07:29:02','huliqu','湖里区',NULL),(1162,'350211','集美区','118.100869,24.572874','district',1158,0,'J','2018-12-14 00:20:50','2019-02-23 07:29:02','jimeiqu','集美区',NULL),(1163,'350212','同安区','118.150455,24.729333','district',1158,0,'T','2018-12-14 00:20:50','2019-02-23 07:29:02','tonganqu','同安区',NULL),(1164,'350213','翔安区','118.242811,24.637479','district',1158,0,'X','2018-12-14 00:20:50','2019-02-23 07:29:02','xianganqu','翔安区',NULL),(1165,'350300','莆田市','119.007558,25.431011','city',1143,0,'P','2018-12-14 00:20:50','2019-02-23 07:29:02','putian','莆田',NULL),(1166,'350302','城厢区','119.001028,25.433737','district',1165,0,'C','2018-12-14 00:20:50','2019-02-23 07:29:02','chengxiangqu','城厢区',NULL),(1167,'350303','涵江区','119.119102,25.459273','district',1165,0,'H','2018-12-14 00:20:50','2019-02-23 07:29:02','hanjiangqu','涵江区',NULL),(1168,'350304','荔城区','119.020047,25.430047','district',1165,0,'L','2018-12-14 00:20:50','2019-02-23 07:29:03','lichengqu','荔城区',NULL),(1169,'350305','秀屿区','119.092607,25.316141','district',1165,0,'X','2018-12-14 00:20:50','2019-02-23 07:29:03','xiuyuqu','秀屿区',NULL),(1170,'350322','仙游县','118.694331,25.356529','district',1165,0,'X','2018-12-14 00:20:50','2019-02-23 07:29:03','xianyouxian','仙游县',NULL),(1171,'350400','三明市','117.635001,26.265444','city',1143,0,'S','2018-12-14 00:20:51','2019-02-23 07:29:03','sanming','三明',NULL),(1172,'350402','梅列区','117.63687,26.269208','district',1171,0,'M','2018-12-14 00:20:51','2019-02-23 07:29:03','meiliequ','梅列区',NULL),(1173,'350403','三元区','117.607418,26.234191','district',1171,0,'S','2018-12-14 00:20:51','2019-02-23 07:29:03','sanyuanqu','三元区',NULL),(1174,'350421','明溪县','117.201845,26.357375','district',1171,0,'M','2018-12-14 00:20:51','2019-02-23 07:29:03','mingxixian','明溪县',NULL),(1175,'350423','清流县','116.815821,26.17761','district',1171,0,'Q','2018-12-14 00:20:51','2019-02-23 07:29:03','qingliuxian','清流县',NULL),(1176,'350424','宁化县','116.659725,26.259932','district',1171,0,'N','2018-12-14 00:20:51','2019-02-23 07:29:03','ninghuaxian','宁化县',NULL),(1177,'350425','大田县','117.849355,25.690803','district',1171,0,'D','2018-12-14 00:20:51','2019-02-23 07:29:03','datianxian','大田县',NULL),(1178,'350426','尤溪县','118.188577,26.169261','district',1171,0,'Y','2018-12-14 00:20:51','2019-02-23 07:29:03','youxixian','尤溪县',NULL),(1179,'350427','沙县','117.789095,26.397361','district',1171,0,'S','2018-12-14 00:20:51','2019-02-23 07:29:03','shaxian','沙县',NULL),(1180,'350428','将乐县','117.473558,26.728667','district',1171,0,'J','2018-12-14 00:20:51','2019-02-23 07:29:03','jianglexian','将乐县',NULL),(1181,'350429','泰宁县','117.177522,26.897995','district',1171,0,'T','2018-12-14 00:20:51','2019-02-23 07:29:03','tainingxian','泰宁县',NULL),(1182,'350430','建宁县','116.845832,26.831398','district',1171,0,'J','2018-12-14 00:20:51','2019-02-23 07:29:03','jianningxian','建宁县',NULL),(1183,'350481','永安市','117.364447,25.974075','district',1171,0,'Y','2018-12-14 00:20:51','2019-02-23 07:29:03','yongan','永安',NULL),(1184,'350500','泉州市','118.589421,24.908853','city',1143,0,'Q','2018-12-14 00:20:51','2019-02-23 07:29:03','quanzhou','泉州',NULL),(1185,'350502','鲤城区','118.588929,24.907645','district',1184,0,'L','2018-12-14 00:20:51','2019-02-23 07:29:03','lichengqu','鲤城区',NULL),(1186,'350503','丰泽区','118.605147,24.896041','district',1184,0,'F','2018-12-14 00:20:51','2019-02-23 07:29:03','fengzequ','丰泽区',NULL),(1187,'350504','洛江区','118.670312,24.941153','district',1184,0,'L','2018-12-14 00:20:51','2019-02-23 07:29:03','luojiangqu','洛江区',NULL),(1188,'350505','泉港区','118.912285,25.126859','district',1184,0,'Q','2018-12-14 00:20:51','2019-02-23 07:29:03','quangangqu','泉港区',NULL),(1189,'350521','惠安县','118.798954,25.028718','district',1184,0,'H','2018-12-14 00:20:51','2019-02-23 07:29:03','huianxian','惠安县',NULL),(1190,'350524','安溪县','118.186014,25.056824','district',1184,0,'A','2018-12-14 00:20:51','2019-02-23 07:29:03','anxixian','安溪县',NULL),(1191,'350525','永春县','118.29503,25.320721','district',1184,0,'Y','2018-12-14 00:20:51','2019-02-23 07:29:03','yongchunxian','永春县',NULL),(1192,'350526','德化县','118.242986,25.489004','district',1184,0,'D','2018-12-14 00:20:52','2019-02-23 07:29:03','dehuaxian','德化县',NULL),(1193,'350527','金门县','118.323221,24.436417','district',1184,0,'J','2018-12-14 00:20:52','2019-02-23 07:29:03','jinmenxian','金门县',NULL),(1194,'350581','石狮市','118.628402,24.731978','district',1184,0,'S','2018-12-14 00:20:52','2019-02-23 07:29:03','shishi','石狮',NULL),(1195,'350582','晋江市','118.577338,24.807322','district',1184,0,'J','2018-12-14 00:20:52','2019-02-23 07:29:03','jinjiang','晋江',NULL),(1196,'350583','南安市','118.387031,24.959494','district',1184,0,'N','2018-12-14 00:20:52','2019-02-23 07:29:03','nanan','南安',NULL),(1197,'350600','漳州市','117.661801,24.510897','city',1143,0,'Z','2018-12-14 00:20:52','2019-02-23 07:29:03','zhangzhou','漳州',NULL),(1198,'350602','芗城区','117.656461,24.509955','district',1197,0,'X','2018-12-14 00:20:52','2019-02-23 07:29:03','xiangchengqu','芗城区',NULL),(1199,'350603','龙文区','117.671387,24.515656','district',1197,0,'L','2018-12-14 00:20:52','2019-02-23 07:29:03','longwenqu','龙文区',NULL),(1200,'350622','云霄县','117.340946,23.950486','district',1197,0,'Y','2018-12-14 00:20:52','2019-02-23 07:29:04','yunxiaoxian','云霄县',NULL),(1201,'350623','漳浦县','117.614023,24.117907','district',1197,0,'Z','2018-12-14 00:20:52','2019-02-23 07:29:04','zhangpuxian','漳浦县',NULL),(1202,'350624','诏安县','117.176083,23.710834','district',1197,0,'Z','2018-12-14 00:20:52','2019-02-23 07:29:04','zhaoanxian','诏安县',NULL),(1203,'350625','长泰县','117.755913,24.621475','district',1197,0,'C','2018-12-14 00:20:52','2019-02-23 07:29:04','changtaixian','长泰县',NULL),(1204,'350626','东山县','117.427679,23.702845','district',1197,0,'D','2018-12-14 00:20:52','2019-02-23 07:29:04','dongshanxian','东山县',NULL),(1205,'350627','南靖县','117.365462,24.516425','district',1197,0,'N','2018-12-14 00:20:52','2019-02-23 07:29:04','nanjingxian','南靖县',NULL),(1206,'350628','平和县','117.313549,24.366158','district',1197,0,'P','2018-12-14 00:20:52','2019-02-23 07:29:04','pinghexian','平和县',NULL),(1207,'350629','华安县','117.53631,25.001416','district',1197,0,'H','2018-12-14 00:20:52','2019-02-23 07:29:04','huaanxian','华安县',NULL),(1208,'350681','龙海市','117.817292,24.445341','district',1197,0,'L','2018-12-14 00:20:52','2019-02-23 07:29:04','longhai','龙海',NULL),(1209,'350700','南平市','118.178459,26.635627','city',1143,0,'N','2018-12-14 00:20:52','2019-02-23 07:29:04','nanping','南平',NULL),(1210,'350702','延平区','118.178918,26.636079','district',1209,0,'Y','2018-12-14 00:20:52','2019-02-23 07:29:04','yanpingqu','延平区',NULL),(1211,'350703','建阳区','118.12267,27.332067','district',1209,0,'J','2018-12-14 00:20:52','2019-02-23 07:29:04','jianyangqu','建阳区',NULL),(1212,'350721','顺昌县','117.80771,26.792851','district',1209,0,'S','2018-12-14 00:20:52','2019-02-23 07:29:04','shunchangxian','顺昌县',NULL),(1213,'350722','浦城县','118.536822,27.920412','district',1209,0,'P','2018-12-14 00:20:53','2019-02-23 07:29:04','puchengxian','浦城县',NULL),(1214,'350723','光泽县','117.337897,27.542803','district',1209,0,'G','2018-12-14 00:20:53','2019-02-23 07:29:04','guangzexian','光泽县',NULL),(1215,'350724','松溪县','118.783491,27.525785','district',1209,0,'S','2018-12-14 00:20:53','2019-02-23 07:29:04','songxixian','松溪县',NULL),(1216,'350725','政和县','118.858661,27.365398','district',1209,0,'Z','2018-12-14 00:20:53','2019-02-23 07:29:04','zhenghexian','政和县',NULL),(1217,'350781','邵武市','117.491544,27.337952','district',1209,0,'S','2018-12-14 00:20:53','2019-02-23 07:29:04','shaowu','邵武',NULL),(1218,'350782','武夷山市','118.032796,27.751733','district',1209,0,'W','2018-12-14 00:20:53','2019-02-23 07:29:04','wuyishan','武夷山',NULL),(1219,'350783','建瓯市','118.321765,27.03502','district',1209,0,'J','2018-12-14 00:20:53','2019-02-23 07:29:04','jianou','建瓯',NULL),(1220,'350800','龙岩市','117.02978,25.091603','city',1143,0,'L','2018-12-14 00:20:53','2019-02-23 07:29:04','longyan','龙岩',NULL),(1221,'350802','新罗区','117.030721,25.0918','district',1220,0,'X','2018-12-14 00:20:53','2019-02-23 07:29:04','xinluoqu','新罗区',NULL),(1222,'350803','永定区','116.732691,24.720442','district',1220,0,'Y','2018-12-14 00:20:53','2019-02-23 07:29:04','yongdingqu','永定区',NULL),(1223,'350821','长汀县','116.361007,25.842278','district',1220,0,'C','2018-12-14 00:20:53','2019-02-23 07:29:04','changtingxian','长汀县',NULL),(1224,'350823','上杭县','116.424774,25.050019','district',1220,0,'S','2018-12-14 00:20:53','2019-02-23 07:29:04','shanghangxian','上杭县',NULL),(1225,'350824','武平县','116.100928,25.08865','district',1220,0,'W','2018-12-14 00:20:53','2019-02-23 07:29:04','wupingxian','武平县',NULL),(1226,'350825','连城县','116.756687,25.708506','district',1220,0,'L','2018-12-14 00:20:53','2019-02-23 07:29:04','lianchengxian','连城县',NULL),(1227,'350881','漳平市','117.42073,25.291597','district',1220,0,'Z','2018-12-14 00:20:53','2019-02-23 07:29:04','zhangping','漳平',NULL),(1228,'350900','宁德市','119.527082,26.65924','city',1143,0,'N','2018-12-14 00:20:53','2019-02-23 07:29:04','ningde','宁德',NULL),(1229,'350902','蕉城区','119.527225,26.659253','district',1228,0,'J','2018-12-14 00:20:53','2019-02-23 07:29:04','jiaochengqu','蕉城区',NULL),(1230,'350921','霞浦县','120.005214,26.882068','district',1228,0,'X','2018-12-14 00:20:53','2019-02-23 07:29:04','xiapuxian','霞浦县',NULL),(1231,'350922','古田县','118.743156,26.577491','district',1228,0,'G','2018-12-14 00:20:53','2019-02-23 07:29:04','gutianxian','古田县',NULL),(1232,'350923','屏南县','118.987544,26.910826','district',1228,0,'P','2018-12-14 00:20:53','2019-02-23 07:29:04','pingnanxian','屏南县',NULL),(1233,'350924','寿宁县','119.506733,27.457798','district',1228,0,'S','2018-12-14 00:20:53','2019-02-23 07:29:05','shouningxian','寿宁县',NULL),(1234,'350925','周宁县','119.338239,27.103106','district',1228,0,'Z','2018-12-14 00:20:53','2019-02-23 07:29:05','zhouningxian','周宁县',NULL),(1235,'350926','柘荣县','119.898226,27.236163','district',1228,0,'Z','2018-12-14 00:20:54','2019-02-23 07:29:05','zherongxian','柘荣县',NULL),(1236,'350981','福安市','119.650798,27.084246','district',1228,0,'F','2018-12-14 00:20:54','2019-02-23 07:29:05','fuan','福安',NULL),(1237,'350982','福鼎市','120.219761,27.318884','district',1228,0,'F','2018-12-14 00:20:54','2019-02-23 07:29:05','fuding','福鼎',NULL),(1238,'360000','江西省','115.892151,28.676493','province',0,4100,'J','2018-12-14 00:20:54','2019-02-23 07:29:05','jiangxisheng','江西省',NULL),(1239,'360100','南昌市','115.892151,28.676493','city',1238,0,'N','2018-12-14 00:20:54','2019-02-23 07:29:05','nanchang','南昌',NULL),(1240,'360102','东湖区','115.889675,28.682988','district',1239,0,'D','2018-12-14 00:20:54','2019-02-23 07:29:05','donghuqu','东湖区',NULL),(1241,'360103','西湖区','115.91065,28.662901','district',1239,0,'X','2018-12-14 00:20:54','2019-02-23 07:29:05','xihuqu','西湖区',NULL),(1242,'360104','青云谱区','115.907292,28.635724','district',1239,0,'Q','2018-12-14 00:20:54','2019-02-23 07:29:05','qingyunpuqu','青云谱区',NULL),(1243,'360105','湾里区','115.731324,28.714803','district',1239,0,'W','2018-12-14 00:20:54','2019-02-23 07:29:05','wanliqu','湾里区',NULL),(1244,'360111','青山湖区','115.949044,28.689292','district',1239,0,'Q','2018-12-14 00:20:54','2019-02-23 07:29:05','qingshanhuqu','青山湖区',NULL),(1245,'360112','新建区','115.820806,28.690788','district',1239,0,'X','2018-12-14 00:20:54','2019-02-23 07:29:05','xinjianqu','新建区',NULL),(1246,'360121','南昌县','115.942465,28.543781','district',1239,0,'N','2018-12-14 00:20:54','2019-02-23 07:29:05','nanchangxian','南昌县',NULL),(1247,'360123','安义县','115.553109,28.841334','district',1239,0,'A','2018-12-14 00:20:54','2019-02-23 07:29:05','anyixian','安义县',NULL),(1248,'360124','进贤县','116.267671,28.365681','district',1239,0,'J','2018-12-14 00:20:54','2019-02-23 07:29:05','jinxianxian','进贤县',NULL),(1249,'360200','景德镇市','117.214664,29.29256','city',1238,0,'J','2018-12-14 00:20:54','2019-02-23 07:29:05','jingdezhen','景德镇',NULL),(1250,'360202','昌江区','117.195023,29.288465','district',1249,0,'C','2018-12-14 00:20:54','2019-02-23 07:29:05','changjiangqu','昌江区',NULL),(1251,'360203','珠山区','117.214814,29.292812','district',1249,0,'Z','2018-12-14 00:20:54','2019-02-23 07:29:05','zhushanqu','珠山区',NULL),(1252,'360222','浮梁县','117.217611,29.352251','district',1249,0,'F','2018-12-14 00:20:54','2019-02-23 07:29:05','fuliangxian','浮梁县',NULL),(1253,'360281','乐平市','117.129376,28.967361','district',1249,0,'L','2018-12-14 00:20:54','2019-02-23 07:29:05','leping','乐平',NULL),(1254,'360300','萍乡市','113.852186,27.622946','city',1238,0,'P','2018-12-14 00:20:55','2019-02-23 07:29:05','pingxiang','萍乡',NULL),(1255,'360302','安源区','113.855044,27.625826','district',1254,0,'A','2018-12-14 00:20:55','2019-02-23 07:29:05','anyuanqu','安源区',NULL),(1256,'360313','湘东区','113.7456,27.639319','district',1254,0,'X','2018-12-14 00:20:55','2019-02-23 07:29:05','xiangdongqu','湘东区',NULL),(1257,'360321','莲花县','113.955582,27.127807','district',1254,0,'L','2018-12-14 00:20:55','2019-02-23 07:29:05','lianhuaxian','莲花县',NULL),(1258,'360322','上栗县','113.800525,27.877041','district',1254,0,'S','2018-12-14 00:20:55','2019-02-23 07:29:05','shanglixian','上栗县',NULL),(1259,'360323','芦溪县','114.041206,27.633633','district',1254,0,'L','2018-12-14 00:20:55','2019-02-23 07:29:05','luxixian','芦溪县',NULL),(1260,'360400','九江市','115.992811,29.712034','city',1238,0,'J','2018-12-14 00:20:55','2019-02-23 07:29:05','jiujiang','九江',NULL),(1261,'360402','濂溪区','115.99012,29.676175','district',1260,0,'L','2018-12-14 00:20:55','2019-02-23 07:29:05','lianxiqu','濂溪区',NULL),(1262,'360403','浔阳区','115.995947,29.72465','district',1260,0,'X','2018-12-14 00:20:55','2019-02-23 07:29:06','xunyangqu','浔阳区',NULL),(1263,'360404','柴桑区','115.892977,29.610264','district',1260,0,'C','2018-12-14 00:20:55','2019-02-23 07:29:06','chaisangqu','柴桑区',NULL),(1264,'360423','武宁县','115.105646,29.260182','district',1260,0,'W','2018-12-14 00:20:55','2019-02-23 07:29:06','wuningxian','武宁县',NULL),(1265,'360424','修水县','114.573428,29.032729','district',1260,0,'X','2018-12-14 00:20:55','2019-02-23 07:29:06','xiushuixian','修水县',NULL),(1266,'360425','永修县','115.809055,29.018212','district',1260,0,'Y','2018-12-14 00:20:55','2019-02-23 07:29:06','yongxiuxian','永修县',NULL),(1267,'360426','德安县','115.762611,29.327474','district',1260,0,'D','2018-12-14 00:20:55','2019-02-23 07:29:06','deanxian','德安县',NULL),(1268,'360428','都昌县','116.205114,29.275105','district',1260,0,'D','2018-12-14 00:20:55','2019-02-23 07:29:06','duchangxian','都昌县',NULL),(1269,'360429','湖口县','116.244313,29.7263','district',1260,0,'H','2018-12-14 00:20:55','2019-02-23 07:29:06','hukouxian','湖口县',NULL),(1270,'360430','彭泽县','116.55584,29.898865','district',1260,0,'P','2018-12-14 00:20:55','2019-02-23 07:29:06','pengzexian','彭泽县',NULL),(1271,'360481','瑞昌市','115.669081,29.676599','district',1260,0,'R','2018-12-14 00:20:55','2019-02-23 07:29:06','ruichang','瑞昌',NULL),(1272,'360482','共青城市','115.805712,29.247884','district',1260,0,'G','2018-12-14 00:20:55','2019-02-23 07:29:06','gongqingcheng','共青城',NULL),(1273,'360483','庐山市','116.043743,29.456169','district',1260,0,'L','2018-12-14 00:20:56','2019-02-23 07:29:06','lushan','庐山',NULL),(1274,'360500','新余市','114.930835,27.810834','city',1238,0,'X','2018-12-14 00:20:56','2019-02-23 07:29:06','xinyu','新余',NULL),(1275,'360502','渝水区','114.923923,27.819171','district',1274,0,'Y','2018-12-14 00:20:56','2019-02-23 07:29:06','yushuiqu','渝水区',NULL),(1276,'360521','分宜县','114.675262,27.811301','district',1274,0,'F','2018-12-14 00:20:56','2019-02-23 07:29:06','fenyixian','分宜县',NULL),(1277,'360600','鹰潭市','117.033838,28.238638','city',1238,0,'Y','2018-12-14 00:20:56','2019-02-23 07:29:06','yingtan','鹰潭',NULL),(1278,'360602','月湖区','117.034112,28.239076','district',1277,0,'Y','2018-12-14 00:20:56','2019-02-23 07:29:06','yuehuqu','月湖区',NULL),(1279,'360622','余江县','116.822763,28.206177','district',1277,0,'Y','2018-12-14 00:20:56','2019-02-23 07:29:06','yujiangxian','余江县',NULL),(1280,'360681','贵溪市','117.212103,28.283693','district',1277,0,'G','2018-12-14 00:20:56','2019-02-23 07:29:06','guixi','贵溪',NULL),(1281,'360700','赣州市','114.940278,25.85097','city',1238,0,'G','2018-12-14 00:20:56','2019-02-23 07:29:06','ganzhou','赣州',NULL),(1282,'360702','章贡区','114.93872,25.851367','district',1281,0,'Z','2018-12-14 00:20:56','2019-02-23 07:29:06','zhanggongqu','章贡区',NULL),(1283,'360703','南康区','114.756933,25.661721','district',1281,0,'N','2018-12-14 00:20:56','2019-02-23 07:29:06','nankangqu','南康区',NULL),(1284,'360704','赣县区','115.018461,25.865432','district',1281,0,'G','2018-12-14 00:20:56','2019-02-23 07:29:06','ganxianqu','赣县区',NULL),(1285,'360722','信丰县','114.930893,25.38023','district',1281,0,'X','2018-12-14 00:20:56','2019-02-23 07:29:06','xinfengxian','信丰县',NULL),(1286,'360723','大余县','114.362243,25.395937','district',1281,0,'D','2018-12-14 00:20:56','2019-02-23 07:29:06','dayuxian','大余县',NULL),(1287,'360724','上犹县','114.540537,25.794284','district',1281,0,'S','2018-12-14 00:20:56','2019-02-23 07:29:06','shangyouxian','上犹县',NULL),(1288,'360725','崇义县','114.307348,25.687911','district',1281,0,'C','2018-12-14 00:20:56','2019-02-23 07:29:06','chongyixian','崇义县',NULL),(1289,'360726','安远县','115.392328,25.134591','district',1281,0,'A','2018-12-14 00:20:56','2019-02-23 07:29:06','anyuanxian','安远县',NULL),(1290,'360727','龙南县','114.792657,24.90476','district',1281,0,'L','2018-12-14 00:20:56','2019-02-23 07:29:06','longnanxian','龙南县',NULL),(1291,'360728','定南县','115.03267,24.774277','district',1281,0,'D','2018-12-14 00:20:56','2019-02-23 07:29:06','dingnanxian','定南县',NULL),(1292,'360729','全南县','114.531589,24.742651','district',1281,0,'Q','2018-12-14 00:20:56','2019-02-23 07:29:06','quannanxian','全南县',NULL),(1293,'360730','宁都县','116.018782,26.472054','district',1281,0,'N','2018-12-14 00:20:56','2019-02-23 07:29:06','ningduxian','宁都县',NULL),(1294,'360731','于都县','115.411198,25.955033','district',1281,0,'Y','2018-12-14 00:20:57','2019-02-23 07:29:06','yuduxian','于都县',NULL),(1295,'360732','兴国县','115.351896,26.330489','district',1281,0,'X','2018-12-14 00:20:57','2019-02-23 07:29:06','xingguoxian','兴国县',NULL),(1296,'360733','会昌县','115.791158,25.599125','district',1281,0,'H','2018-12-14 00:20:57','2019-02-23 07:29:07','huichangxian','会昌县',NULL),(1297,'360734','寻乌县','115.651399,24.954136','district',1281,0,'X','2018-12-14 00:20:57','2019-02-23 07:29:07','xunwuxian','寻乌县',NULL),(1298,'360735','石城县','116.342249,26.326582','district',1281,0,'S','2018-12-14 00:20:57','2019-02-23 07:29:07','shichengxian','石城县',NULL),(1299,'360781','瑞金市','116.034854,25.875278','district',1281,0,'R','2018-12-14 00:20:57','2019-02-23 07:29:07','ruijin','瑞金',NULL),(1300,'360800','吉安市','114.986373,27.111699','city',1238,0,'J','2018-12-14 00:20:57','2019-02-23 07:29:07','jian','吉安',NULL),(1301,'360802','吉州区','114.987331,27.112367','district',1300,0,'J','2018-12-14 00:20:57','2019-02-23 07:29:07','jizhouqu','吉州区',NULL),(1302,'360803','青原区','115.016306,27.105879','district',1300,0,'Q','2018-12-14 00:20:57','2019-02-23 07:29:07','qingyuanqu','青原区',NULL),(1303,'360821','吉安县','114.905117,27.040042','district',1300,0,'J','2018-12-14 00:20:57','2019-02-23 07:29:07','jianxian','吉安县',NULL),(1304,'360822','吉水县','115.134569,27.213445','district',1300,0,'J','2018-12-14 00:20:57','2019-02-23 07:29:07','jishuixian','吉水县',NULL),(1305,'360823','峡江县','115.319331,27.580862','district',1300,0,'X','2018-12-14 00:20:57','2019-02-23 07:29:07','xiajiangxian','峡江县',NULL),(1306,'360824','新干县','115.399294,27.755758','district',1300,0,'X','2018-12-14 00:20:57','2019-02-23 07:29:07','xinganxian','新干县',NULL),(1307,'360825','永丰县','115.435559,27.321087','district',1300,0,'Y','2018-12-14 00:20:57','2019-02-23 07:29:07','yongfengxian','永丰县',NULL),(1308,'360826','泰和县','114.901393,26.790164','district',1300,0,'T','2018-12-14 00:20:57','2019-02-23 07:29:07','taihexian','泰和县',NULL),(1309,'360827','遂川县','114.51689,26.323705','district',1300,0,'S','2018-12-14 00:20:57','2019-02-23 07:29:07','suichuanxian','遂川县',NULL),(1310,'360828','万安县','114.784694,26.462085','district',1300,0,'W','2018-12-14 00:20:57','2019-02-23 07:29:07','wananxian','万安县',NULL),(1311,'360829','安福县','114.61384,27.382746','district',1300,0,'A','2018-12-14 00:20:57','2019-02-23 07:29:07','anfuxian','安福县',NULL),(1312,'360830','永新县','114.242534,26.944721','district',1300,0,'Y','2018-12-14 00:20:57','2019-02-23 07:29:07','yongxinxian','永新县',NULL),(1313,'360881','井冈山市','114.284421,26.745919','district',1300,0,'J','2018-12-14 00:20:57','2019-02-23 07:29:07','jinggangshan','井冈山',NULL),(1314,'360900','宜春市','114.391136,27.8043','city',1238,0,'Y','2018-12-14 00:20:58','2019-02-23 07:29:07','yichun','宜春',NULL),(1315,'360902','袁州区','114.387379,27.800117','district',1314,0,'Y','2018-12-14 00:20:58','2019-02-23 07:29:07','yuanzhouqu','袁州区',NULL),(1316,'360921','奉新县','115.389899,28.700672','district',1314,0,'F','2018-12-14 00:20:58','2019-02-23 07:29:07','fengxinxian','奉新县',NULL),(1317,'360922','万载县','114.449012,28.104528','district',1314,0,'W','2018-12-14 00:20:58','2019-02-23 07:29:07','wanzaixian','万载县',NULL),(1318,'360923','上高县','114.932653,28.234789','district',1314,0,'S','2018-12-14 00:20:58','2019-02-23 07:29:07','shanggaoxian','上高县',NULL),(1319,'360924','宜丰县','114.787381,28.388289','district',1314,0,'Y','2018-12-14 00:20:58','2019-02-23 07:29:07','yifengxian','宜丰县',NULL),(1320,'360925','靖安县','115.361744,28.86054','district',1314,0,'J','2018-12-14 00:20:58','2019-02-23 07:29:07','jinganxian','靖安县',NULL),(1321,'360926','铜鼓县','114.37014,28.520956','district',1314,0,'T','2018-12-14 00:20:58','2019-02-23 07:29:07','tongguxian','铜鼓县',NULL),(1322,'360981','丰城市','115.786005,28.191584','district',1314,0,'F','2018-12-14 00:20:58','2019-02-23 07:29:07','fengcheng','丰城',NULL),(1323,'360982','樟树市','115.543388,28.055898','district',1314,0,'Z','2018-12-14 00:20:58','2019-02-23 07:29:07','zhangshu','樟树',NULL),(1324,'360983','高安市','115.381527,28.420951','district',1314,0,'G','2018-12-14 00:20:58','2019-02-23 07:29:07','gaoan','高安',NULL),(1325,'361000','抚州市','116.358351,27.98385','city',1238,0,'F','2018-12-14 00:20:58','2019-02-23 07:29:07','fuzhou','抚州',NULL),(1326,'361002','临川区','116.361404,27.981919','district',1325,0,'L','2018-12-14 00:20:58','2019-02-23 07:29:07','linchuanqu','临川区',NULL),(1327,'361003','东乡区','116.605341,28.2325','district',1325,0,'D','2018-12-14 00:20:58','2019-02-23 07:29:07','dongxiangqu','东乡区',NULL),(1328,'361021','南城县','116.63945,27.55531','district',1325,0,'N','2018-12-14 00:20:58','2019-02-23 07:29:07','nanchengxian','南城县',NULL),(1329,'361022','黎川县','116.91457,27.292561','district',1325,0,'L','2018-12-14 00:20:58','2019-02-23 07:29:07','lichuanxian','黎川县',NULL),(1330,'361023','南丰县','116.532994,27.210132','district',1325,0,'N','2018-12-14 00:20:58','2019-02-23 07:29:07','nanfengxian','南丰县',NULL),(1331,'361024','崇仁县','116.059109,27.760907','district',1325,0,'C','2018-12-14 00:20:58','2019-02-23 07:29:08','chongrenxian','崇仁县',NULL),(1332,'361025','乐安县','115.838432,27.420101','district',1325,0,'L','2018-12-14 00:20:58','2019-02-23 07:29:08','leanxian','乐安县',NULL),(1333,'361026','宜黄县','116.223023,27.546512','district',1325,0,'Y','2018-12-14 00:20:58','2019-02-23 07:29:08','yihuangxian','宜黄县',NULL),(1334,'361027','金溪县','116.778751,27.907387','district',1325,0,'J','2018-12-14 00:20:58','2019-02-23 07:29:08','jinxixian','金溪县',NULL),(1335,'361028','资溪县','117.066095,27.70653','district',1325,0,'Z','2018-12-14 00:20:58','2019-02-23 07:29:08','zixixian','资溪县',NULL),(1336,'361030','广昌县','116.327291,26.838426','district',1325,0,'G','2018-12-14 00:20:59','2019-02-23 07:29:08','guangchangxian','广昌县',NULL),(1337,'361100','上饶市','117.971185,28.44442','city',1238,0,'S','2018-12-14 00:20:59','2019-02-23 07:29:08','shangrao','上饶',NULL),(1338,'361102','信州区','117.970522,28.445378','district',1337,0,'X','2018-12-14 00:20:59','2019-02-23 07:29:08','xinzhouqu','信州区',NULL),(1339,'361103','广丰区','118.189852,28.440285','district',1337,0,'G','2018-12-14 00:20:59','2019-02-23 07:29:08','guangfengqu','广丰区',NULL),(1340,'361121','广信区','117.90612,28.453897','district',1337,0,'G','2018-12-14 00:20:59','2019-02-23 07:29:08','guangxinqu','广信区',NULL),(1341,'361123','玉山县','118.244408,28.673479','district',1337,0,'Y','2018-12-14 00:20:59','2019-02-23 07:29:08','yushanxian','玉山县',NULL),(1342,'361124','铅山县','117.711906,28.310892','district',1337,0,'Y','2018-12-14 00:20:59','2019-02-23 07:29:08','yanshanxian','铅山县',NULL),(1343,'361125','横峰县','117.608247,28.415103','district',1337,0,'H','2018-12-14 00:20:59','2019-02-23 07:29:08','hengfengxian','横峰县',NULL),(1344,'361126','弋阳县','117.435002,28.402391','district',1337,0,'Y','2018-12-14 00:20:59','2019-02-23 07:29:08','yiyangxian','弋阳县',NULL),(1345,'361127','余干县','116.691072,28.69173','district',1337,0,'Y','2018-12-14 00:20:59','2019-02-23 07:29:08','yuganxian','余干县',NULL),(1346,'361128','鄱阳县','116.673748,28.993374','district',1337,0,'P','2018-12-14 00:20:59','2019-02-23 07:29:08','poyangxian','鄱阳县',NULL),(1347,'361129','万年县','117.07015,28.692589','district',1337,0,'W','2018-12-14 00:20:59','2019-02-23 07:29:08','wannianxian','万年县',NULL),(1348,'361130','婺源县','117.86219,29.254015','district',1337,0,'W','2018-12-14 00:20:59','2019-02-23 07:29:08','wuyuanxian','婺源县',NULL),(1349,'361181','德兴市','117.578732,28.945034','district',1337,0,'D','2018-12-14 00:20:59','2019-02-23 07:29:08','dexing','德兴',NULL),(1350,'370000','山东省','117.000923,36.675807','province',0,7001,'S','2018-12-14 00:20:59','2019-02-23 07:29:08','shandongsheng','山东省',NULL),(1351,'370100','济南市','117.000923,36.675807','city',1350,0,'J','2018-12-14 00:20:59','2019-02-23 07:29:08','jinan','济南',NULL),(1352,'370102','历下区','117.03862,36.664169','district',1351,0,'L','2018-12-14 00:20:59','2019-02-23 07:29:08','lixiaqu','历下区',NULL),(1353,'370103','市中区','116.99898,36.657354','district',1351,0,'S','2018-12-14 00:20:59','2019-02-23 07:29:08','zhongqu','中区',NULL),(1354,'370104','槐荫区','116.947921,36.668205','district',1351,0,'H','2018-12-14 00:20:59','2019-02-23 07:29:08','huaiyinqu','槐荫区',NULL),(1355,'370105','天桥区','116.996086,36.693374','district',1351,0,'T','2018-12-14 00:20:59','2019-02-23 07:29:08','tianqiaoqu','天桥区',NULL),(1356,'370112','历城区','117.063744,36.681744','district',1351,0,'L','2018-12-14 00:20:59','2019-02-23 07:29:08','lichengqu','历城区',NULL),(1357,'370113','长清区','116.74588,36.561049','district',1351,0,'C','2018-12-14 00:21:00','2019-02-23 07:29:08','changqingqu','长清区',NULL),(1358,'370114','章丘区','117.54069,36.71209','district',1351,0,'Z','2018-12-14 00:21:00','2019-02-23 07:29:08','zhangqiuqu','章丘区',NULL),(1359,'370124','平阴县','116.455054,36.286923','district',1351,0,'P','2018-12-14 00:21:00','2019-02-23 07:29:08','pingyinxian','平阴县',NULL),(1360,'370125','济阳县','117.176035,36.976772','district',1351,0,'J','2018-12-14 00:21:00','2019-02-23 07:29:08','jiyangxian','济阳县',NULL),(1361,'370126','商河县','117.156369,37.310544','district',1351,0,'S','2018-12-14 00:21:00','2019-02-23 07:29:08','shanghexian','商河县',NULL),(1362,'370200','青岛市','120.355173,36.082982','city',1350,0,'Q','2018-12-14 00:21:00','2019-02-23 07:29:08','qingdao','青岛',NULL),(1363,'370202','市南区','120.395966,36.070892','district',1362,0,'S','2018-12-14 00:21:00','2019-02-23 07:29:08','nanqu','南区',NULL),(1364,'370203','市北区','120.355026,36.083819','district',1362,0,'S','2018-12-14 00:21:00','2019-02-23 07:29:08','beiqu','北区',NULL),(1365,'370211','黄岛区','119.995518,35.875138','district',1362,0,'H','2018-12-14 00:21:00','2019-02-23 07:29:08','huangdaoqu','黄岛区',NULL),(1366,'370212','崂山区','120.467393,36.102569','district',1362,0,'L','2018-12-14 00:21:00','2019-02-23 07:29:09','laoshanqu','崂山区',NULL),(1367,'370213','李沧区','120.421236,36.160023','district',1362,0,'L','2018-12-14 00:21:00','2019-02-23 07:29:09','licangqu','李沧区',NULL),(1368,'370214','城阳区','120.389135,36.306833','district',1362,0,'C','2018-12-14 00:21:00','2019-02-23 07:29:09','chengyangqu','城阳区',NULL),(1369,'370215','即墨区','120.447352,36.390847','district',1362,0,'J','2018-12-14 00:21:00','2019-02-23 07:29:09','jimoqu','即墨区',NULL),(1370,'370281','胶州市','120.006202,36.285878','district',1362,0,'J','2018-12-14 00:21:00','2019-02-23 07:29:09','jiaozhou','胶州',NULL),(1371,'370283','平度市','119.959012,36.788828','district',1362,0,'P','2018-12-14 00:21:00','2019-02-23 07:29:09','pingdu','平度',NULL),(1372,'370285','莱西市','120.526226,36.86509','district',1362,0,'L','2018-12-14 00:21:00','2019-02-23 07:29:09','laixi','莱西',NULL),(1373,'370300','淄博市','118.047648,36.814939','city',1350,0,'Z','2018-12-14 00:21:00','2019-02-23 07:29:09','zibo','淄博',NULL),(1374,'370302','淄川区','117.967696,36.647272','district',1373,0,'Z','2018-12-14 00:21:00','2019-02-23 07:29:09','zichuanqu','淄川区',NULL),(1375,'370303','张店区','118.053521,36.807049','district',1373,0,'Z','2018-12-14 00:21:00','2019-02-23 07:29:09','zhangdianqu','张店区',NULL),(1376,'370304','博山区','117.85823,36.497567','district',1373,0,'B','2018-12-14 00:21:00','2019-02-23 07:29:09','boshanqu','博山区',NULL),(1377,'370305','临淄区','118.306018,36.816657','district',1373,0,'L','2018-12-14 00:21:00','2019-02-23 07:29:09','linziqu','临淄区',NULL),(1378,'370306','周村区','117.851036,36.803699','district',1373,0,'Z','2018-12-14 00:21:00','2019-02-23 07:29:09','zhoucunqu','周村区',NULL),(1379,'370321','桓台县','118.101556,36.959773','district',1373,0,'H','2018-12-14 00:21:01','2019-02-23 07:29:09','huantaixian','桓台县',NULL),(1380,'370322','高青县','117.829839,37.169581','district',1373,0,'G','2018-12-14 00:21:01','2019-02-23 07:29:09','gaoqingxian','高青县',NULL),(1381,'370323','沂源县','118.166161,36.186282','district',1373,0,'Y','2018-12-14 00:21:01','2019-02-23 07:29:09','yiyuanxian','沂源县',NULL),(1382,'370400','枣庄市','117.557964,34.856424','city',1350,0,'Z','2018-12-14 00:21:01','2019-02-23 07:29:09','zaozhuang','枣庄',NULL),(1383,'370402','市中区','117.557281,34.856651','district',1382,0,'S','2018-12-14 00:21:01','2019-02-23 07:29:09','zhongqu','中区',NULL),(1384,'370403','薛城区','117.265293,34.79789','district',1382,0,'X','2018-12-14 00:21:01','2019-02-23 07:29:09','xuechengqu','薛城区',NULL),(1385,'370404','峄城区','117.586316,34.767713','district',1382,0,'Y','2018-12-14 00:21:01','2019-02-23 07:29:09','yichengqu','峄城区',NULL),(1386,'370405','台儿庄区','117.734747,34.564815','district',1382,0,'T','2018-12-14 00:21:01','2019-02-23 07:29:09','taierzhuangqu','台儿庄区',NULL),(1387,'370406','山亭区','117.458968,35.096077','district',1382,0,'S','2018-12-14 00:21:01','2019-02-23 07:29:09','shantingqu','山亭区',NULL),(1388,'370481','滕州市','117.162098,35.088498','district',1382,0,'T','2018-12-14 00:21:01','2019-02-23 07:29:09','tengzhou','滕州',NULL),(1389,'370500','东营市','118.66471,37.434564','city',1350,0,'D','2018-12-14 00:21:01','2019-02-23 07:29:09','dongying','东营',NULL),(1390,'370502','东营区','118.507543,37.461567','district',1389,0,'D','2018-12-14 00:21:01','2019-02-23 07:29:09','dongyingqu','东营区',NULL),(1391,'370503','河口区','118.529613,37.886015','district',1389,0,'H','2018-12-14 00:21:01','2019-02-23 07:29:09','hekouqu','河口区',NULL),(1392,'370505','垦利区','118.551314,37.588679','district',1389,0,'K','2018-12-14 00:21:01','2019-02-23 07:29:09','kenliqu','垦利区',NULL),(1393,'370522','利津县','118.248854,37.493365','district',1389,0,'L','2018-12-14 00:21:01','2019-02-23 07:29:09','lijinxian','利津县',NULL),(1394,'370523','广饶县','118.407522,37.05161','district',1389,0,'G','2018-12-14 00:21:01','2019-02-23 07:29:09','guangraoxian','广饶县',NULL),(1395,'370600','烟台市','121.391382,37.539297','city',1350,0,'Y','2018-12-14 00:21:01','2019-02-23 07:29:09','yantai','烟台',NULL),(1396,'370602','芝罘区','121.385877,37.540925','district',1395,0,'Z','2018-12-14 00:21:01','2019-02-23 07:29:09','zhifuqu','芝罘区',NULL),(1397,'370611','福山区','121.264741,37.496875','district',1395,0,'F','2018-12-14 00:21:01','2019-02-23 07:29:09','fushanqu','福山区',NULL),(1398,'370612','牟平区','121.60151,37.388356','district',1395,0,'M','2018-12-14 00:21:02','2019-02-23 07:29:09','mupingqu','牟平区',NULL),(1399,'370613','莱山区','121.448866,37.473549','district',1395,0,'L','2018-12-14 00:21:02','2019-02-23 07:29:09','laishanqu','莱山区',NULL),(1400,'370634','长岛县','120.738345,37.916194','district',1395,0,'C','2018-12-14 00:21:02','2019-02-23 07:29:09','changdaoxian','长岛县',NULL),(1401,'370681','龙口市','120.528328,37.648446','district',1395,0,'L','2018-12-14 00:21:02','2019-02-23 07:29:09','longkou','龙口',NULL),(1402,'370682','莱阳市','120.711151,36.977037','district',1395,0,'L','2018-12-14 00:21:02','2019-02-23 07:29:09','laiyang','莱阳',NULL),(1403,'370683','莱州市','119.942135,37.182725','district',1395,0,'L','2018-12-14 00:21:02','2019-02-23 07:29:10','laizhou','莱州',NULL),(1404,'370684','蓬莱市','120.762689,37.811168','district',1395,0,'P','2018-12-14 00:21:02','2019-02-23 07:29:10','penglai','蓬莱',NULL),(1405,'370685','招远市','120.403142,37.364919','district',1395,0,'Z','2018-12-14 00:21:02','2019-02-23 07:29:10','zhaoyuan','招远',NULL),(1406,'370686','栖霞市','120.834097,37.305854','district',1395,0,'X','2018-12-14 00:21:02','2019-02-23 07:29:10','qixia','栖霞',NULL),(1407,'370687','海阳市','121.168392,36.780657','district',1395,0,'H','2018-12-14 00:21:02','2019-02-23 07:29:10','haiyang','海阳',NULL),(1408,'370700','潍坊市','119.107078,36.70925','city',1350,0,'W','2018-12-14 00:21:02','2019-02-23 07:29:10','weifang','潍坊',NULL),(1409,'370702','潍城区','119.103784,36.710062','district',1408,0,'W','2018-12-14 00:21:02','2019-02-23 07:29:10','weichengqu','潍城区',NULL),(1410,'370703','寒亭区','119.207866,36.772103','district',1408,0,'H','2018-12-14 00:21:02','2019-02-23 07:29:10','hantingqu','寒亭区',NULL),(1411,'370704','坊子区','119.166326,36.654616','district',1408,0,'F','2018-12-14 00:21:02','2019-02-23 07:29:10','fangziqu','坊子区',NULL),(1412,'370705','奎文区','119.137357,36.709494','district',1408,0,'K','2018-12-14 00:21:02','2019-02-23 07:29:10','kuiwenqu','奎文区',NULL),(1413,'370724','临朐县','118.539876,36.516371','district',1408,0,'L','2018-12-14 00:21:02','2019-02-23 07:29:10','linquxian','临朐县',NULL),(1414,'370725','昌乐县','118.839995,36.703253','district',1408,0,'C','2018-12-14 00:21:02','2019-02-23 07:29:10','changlexian','昌乐县',NULL),(1415,'370781','青州市','118.484693,36.697855','district',1408,0,'Q','2018-12-14 00:21:02','2019-02-23 07:29:10','qingzhou','青州',NULL),(1416,'370782','诸城市','119.403182,35.997093','district',1408,0,'Z','2018-12-14 00:21:03','2019-02-23 07:29:10','zhucheng','诸城',NULL),(1417,'370783','寿光市','118.736451,36.874411','district',1408,0,'S','2018-12-14 00:21:03','2019-02-23 07:29:10','shouguang','寿光',NULL),(1418,'370784','安丘市','119.206886,36.427417','district',1408,0,'A','2018-12-14 00:21:03','2019-02-23 07:29:10','anqiu','安丘',NULL),(1419,'370785','高密市','119.757033,36.37754','district',1408,0,'G','2018-12-14 00:21:03','2019-02-23 07:29:10','gaomi','高密',NULL),(1420,'370786','昌邑市','119.394502,36.854937','district',1408,0,'C','2018-12-14 00:21:03','2019-02-23 07:29:10','changyi','昌邑',NULL),(1421,'370800','济宁市','116.587245,35.415393','city',1350,0,'J','2018-12-14 00:21:03','2019-02-23 07:29:10','jining','济宁',NULL),(1422,'370811','任城区','116.595261,35.414828','district',1421,0,'R','2018-12-14 00:21:03','2019-02-23 07:29:10','renchengqu','任城区',NULL),(1423,'370812','兖州区','116.828996,35.556445','district',1421,0,'Y','2018-12-14 00:21:03','2019-02-23 07:29:10','yanzhouqu','兖州区',NULL),(1424,'370826','微山县','117.12861,34.809525','district',1421,0,'W','2018-12-14 00:21:03','2019-02-23 07:29:10','weishanxian','微山县',NULL),(1425,'370827','鱼台县','116.650023,34.997706','district',1421,0,'Y','2018-12-14 00:21:03','2019-02-23 07:29:10','yutaixian','鱼台县',NULL),(1426,'370828','金乡县','116.310364,35.06977','district',1421,0,'J','2018-12-14 00:21:03','2019-02-23 07:29:10','jinxiangxian','金乡县',NULL),(1427,'370829','嘉祥县','116.342885,35.398098','district',1421,0,'J','2018-12-14 00:21:03','2019-02-23 07:29:10','jiaxiangxian','嘉祥县',NULL),(1428,'370830','汶上县','116.487146,35.721746','district',1421,0,'W','2018-12-14 00:21:03','2019-02-23 07:29:10','wenshangxian','汶上县',NULL),(1429,'370831','泗水县','117.273605,35.653216','district',1421,0,'S','2018-12-14 00:21:03','2019-02-23 07:29:10','sishuixian','泗水县',NULL),(1430,'370832','梁山县','116.08963,35.801843','district',1421,0,'L','2018-12-14 00:21:03','2019-02-23 07:29:10','liangshanxian','梁山县',NULL),(1431,'370881','曲阜市','116.991885,35.592788','district',1421,0,'Q','2018-12-14 00:21:03','2019-02-23 07:29:10','qufu','曲阜',NULL),(1432,'370883','邹城市','116.96673,35.405259','district',1421,0,'Z','2018-12-14 00:21:03','2019-02-23 07:29:10','zoucheng','邹城',NULL),(1433,'370900','泰安市','117.129063,36.194968','city',1350,0,'T','2018-12-14 00:21:04','2019-02-23 07:29:10','taian','泰安',NULL),(1434,'370902','泰山区','117.129984,36.189313','district',1433,0,'T','2018-12-14 00:21:04','2019-02-23 07:29:10','taishanqu','泰山区',NULL),(1435,'370911','岱岳区','117.04353,36.1841','district',1433,0,'D','2018-12-14 00:21:04','2019-02-23 07:29:10','daiyuequ','岱岳区',NULL),(1436,'370921','宁阳县','116.799297,35.76754','district',1433,0,'N','2018-12-14 00:21:04','2019-02-23 07:29:10','ningyangxian','宁阳县',NULL),(1437,'370923','东平县','116.461052,35.930467','district',1433,0,'D','2018-12-14 00:21:04','2019-02-23 07:29:10','dongpingxian','东平县',NULL),(1438,'370982','新泰市','117.766092,35.910387','district',1433,0,'X','2018-12-14 00:21:04','2019-02-23 07:29:11','xintai','新泰',NULL),(1439,'370983','肥城市','116.763703,36.1856','district',1433,0,'F','2018-12-14 00:21:04','2019-02-23 07:29:11','feicheng','肥城',NULL),(1440,'371000','威海市','122.116394,37.509691','city',1350,0,'W','2018-12-14 00:21:04','2019-02-23 07:29:11','weihai','威海',NULL),(1441,'371002','环翠区','122.116189,37.510754','district',1440,0,'H','2018-12-14 00:21:04','2019-02-23 07:29:11','huancuiqu','环翠区',NULL),(1442,'371003','文登区','122.057139,37.196211','district',1440,0,'W','2018-12-14 00:21:04','2019-02-23 07:29:11','wendengqu','文登区',NULL),(1443,'371082','荣成市','122.422896,37.160134','district',1440,0,'R','2018-12-14 00:21:05','2019-02-23 07:29:11','rongcheng','荣成',NULL),(1444,'371083','乳山市','121.536346,36.919622','district',1440,0,'R','2018-12-14 00:21:05','2019-02-23 07:29:11','rushan','乳山',NULL),(1445,'371100','日照市','119.461208,35.428588','city',1350,0,'R','2018-12-14 00:21:05','2019-02-23 07:29:11','rizhao','日照',NULL),(1446,'371102','东港区','119.457703,35.426152','district',1445,0,'D','2018-12-14 00:21:05','2019-02-23 07:29:11','donggangqu','东港区',NULL),(1447,'371103','岚山区','119.315844,35.119794','district',1445,0,'L','2018-12-14 00:21:05','2019-02-23 07:29:11','lanshanqu','岚山区',NULL),(1448,'371121','五莲县','119.206745,35.751936','district',1445,0,'W','2018-12-14 00:21:05','2019-02-23 07:29:11','wulianxian','五莲县',NULL),(1449,'371122','莒县','118.832859,35.588115','district',1445,0,'J','2018-12-14 00:21:05','2019-02-23 07:29:11','juxian','莒县',NULL),(1450,'371200','莱芜市','117.677736,36.214397','city',1350,0,'L','2018-12-14 00:21:05','2019-02-23 07:29:11','laiwu','莱芜',NULL),(1451,'371202','莱城区','117.678351,36.213662','district',1450,0,'L','2018-12-14 00:21:05','2019-02-23 07:29:11','laichengqu','莱城区',NULL),(1452,'371203','钢城区','117.82033,36.058038','district',1450,0,'G','2018-12-14 00:21:05','2019-02-23 07:29:11','gangchengqu','钢城区',NULL),(1453,'371300','临沂市','118.326443,35.065282','city',1350,0,'L','2018-12-14 00:21:05','2019-02-23 07:29:11','linyi','临沂',NULL),(1454,'371302','兰山区','118.327667,35.061631','district',1453,0,'L','2018-12-14 00:21:05','2019-02-23 07:29:11','lanshanqu','兰山区',NULL),(1455,'371311','罗庄区','118.284795,34.997204','district',1453,0,'L','2018-12-14 00:21:05','2019-02-23 07:29:11','luozhuangqu','罗庄区',NULL),(1456,'371312','河东区','118.398296,35.085004','district',1453,0,'H','2018-12-14 00:21:05','2019-02-23 07:29:11','hedongqu','河东区',NULL),(1457,'371321','沂南县','118.455395,35.547002','district',1453,0,'Y','2018-12-14 00:21:05','2019-02-23 07:29:11','yinanxian','沂南县',NULL),(1458,'371322','郯城县','118.342963,34.614741','district',1453,0,'T','2018-12-14 00:21:05','2019-02-23 07:29:11','tanchengxian','郯城县',NULL),(1459,'371323','沂水县','118.634543,35.787029','district',1453,0,'Y','2018-12-14 00:21:05','2019-02-23 07:29:11','yishuixian','沂水县',NULL),(1460,'371324','兰陵县','118.049968,34.855573','district',1453,0,'L','2018-12-14 00:21:05','2019-02-23 07:29:11','lanlingxian','兰陵县',NULL),(1461,'371325','费县','117.968869,35.269174','district',1453,0,'F','2018-12-14 00:21:05','2019-02-23 07:29:11','feixian','费县',NULL),(1462,'371326','平邑县','117.631884,35.511519','district',1453,0,'P','2018-12-14 00:21:06','2019-02-23 07:29:11','pingyixian','平邑县',NULL),(1463,'371327','莒南县','118.838322,35.175911','district',1453,0,'J','2018-12-14 00:21:06','2019-02-23 07:29:11','junanxian','莒南县',NULL),(1464,'371328','蒙阴县','117.943271,35.712435','district',1453,0,'M','2018-12-14 00:21:06','2019-02-23 07:29:11','mengyinxian','蒙阴县',NULL),(1465,'371329','临沭县','118.648379,34.917062','district',1453,0,'L','2018-12-14 00:21:06','2019-02-23 07:29:11','linshuxian','临沭县',NULL),(1466,'371400','德州市','116.307428,37.453968','city',1350,0,'D','2018-12-14 00:21:06','2019-02-23 07:29:11','dezhou','德州',NULL),(1467,'371402','德城区','116.307076,37.453923','district',1466,0,'D','2018-12-14 00:21:06','2019-02-23 07:29:11','dechengqu','德城区',NULL),(1468,'371403','陵城区','116.574929,37.332848','district',1466,0,'L','2018-12-14 00:21:06','2019-02-23 07:29:11','lingchengqu','陵城区',NULL),(1469,'371422','宁津县','116.79372,37.649619','district',1466,0,'N','2018-12-14 00:21:06','2019-02-23 07:29:11','ningjinxian','宁津县',NULL),(1470,'371423','庆云县','117.390507,37.777724','district',1466,0,'Q','2018-12-14 00:21:06','2019-02-23 07:29:11','qingyunxian','庆云县',NULL),(1471,'371424','临邑县','116.867028,37.192044','district',1466,0,'L','2018-12-14 00:21:06','2019-02-23 07:29:11','linyixian','临邑县',NULL),(1472,'371425','齐河县','116.758394,36.795497','district',1466,0,'Q','2018-12-14 00:21:06','2019-02-23 07:29:11','qihexian','齐河县',NULL),(1473,'371426','平原县','116.433904,37.164465','district',1466,0,'P','2018-12-14 00:21:06','2019-02-23 07:29:11','pingyuanxian','平原县',NULL),(1474,'371427','夏津县','116.003816,36.950501','district',1466,0,'X','2018-12-14 00:21:06','2019-02-23 07:29:12','xiajinxian','夏津县',NULL),(1475,'371428','武城县','116.078627,37.209527','district',1466,0,'W','2018-12-14 00:21:06','2019-02-23 07:29:12','wuchengxian','武城县',NULL),(1476,'371481','乐陵市','117.216657,37.729115','district',1466,0,'L','2018-12-14 00:21:06','2019-02-23 07:29:12','leling','乐陵',NULL),(1477,'371482','禹城市','116.642554,36.934485','district',1466,0,'Y','2018-12-14 00:21:06','2019-02-23 07:29:12','yucheng','禹城',NULL),(1478,'371500','聊城市','115.980367,36.456013','city',1350,0,'L','2018-12-14 00:21:06','2019-02-23 07:29:12','liaocheng','聊城',NULL),(1479,'371502','东昌府区','115.980023,36.45606','district',1478,0,'D','2018-12-14 00:21:06','2019-02-23 07:29:12','dongchangfuqu','东昌府区',NULL),(1480,'371521','阳谷县','115.784287,36.113708','district',1478,0,'Y','2018-12-14 00:21:06','2019-02-23 07:29:12','yangguxian','阳谷县',NULL),(1481,'371522','莘县','115.667291,36.237597','district',1478,0,'S','2018-12-14 00:21:07','2019-02-23 07:29:12','shenxian','莘县',NULL),(1482,'371523','茌平县','116.25335,36.591934','district',1478,0,'C','2018-12-14 00:21:07','2019-02-23 07:29:12','chipingxian','茌平县',NULL),(1483,'371524','东阿县','116.248855,36.336004','district',1478,0,'D','2018-12-14 00:21:07','2019-02-23 07:29:12','dongexian','东阿县',NULL),(1484,'371525','冠县','115.444808,36.483753','district',1478,0,'G','2018-12-14 00:21:07','2019-02-23 07:29:12','guanxian','冠县',NULL),(1485,'371526','高唐县','116.229662,36.859755','district',1478,0,'G','2018-12-14 00:21:07','2019-02-23 07:29:12','gaotangxian','高唐县',NULL),(1486,'371581','临清市','115.713462,36.842598','district',1478,0,'L','2018-12-14 00:21:07','2019-02-23 07:29:12','linqing','临清',NULL),(1487,'371600','滨州市','118.016974,37.383542','city',1350,0,'B','2018-12-14 00:21:07','2019-02-23 07:29:12','binzhou','滨州',NULL),(1488,'371602','滨城区','118.020149,37.384842','district',1487,0,'B','2018-12-14 00:21:07','2019-02-23 07:29:12','binchengqu','滨城区',NULL),(1489,'371603','沾化区','118.129902,37.698456','district',1487,0,'Z','2018-12-14 00:21:07','2019-02-23 07:29:12','zhanhuaqu','沾化区',NULL),(1490,'371621','惠民县','117.508941,37.483876','district',1487,0,'H','2018-12-14 00:21:07','2019-02-23 07:29:12','huiminxian','惠民县',NULL),(1491,'371622','阳信县','117.581326,37.640492','district',1487,0,'Y','2018-12-14 00:21:07','2019-02-23 07:29:12','yangxinxian','阳信县',NULL),(1492,'371623','无棣县','117.616325,37.740848','district',1487,0,'W','2018-12-14 00:21:07','2019-02-23 07:29:12','wudixian','无棣县',NULL),(1493,'371625','博兴县','118.123096,37.147002','district',1487,0,'B','2018-12-14 00:21:07','2019-02-23 07:29:12','boxingxian','博兴县',NULL),(1494,'371626','邹平县','117.736807,36.87803','district',1487,0,'Z','2018-12-14 00:21:07','2019-02-23 07:29:12','zoupingxian','邹平县',NULL),(1495,'371700','菏泽市','115.469381,35.246531','city',1350,0,'H','2018-12-14 00:21:07','2019-02-23 07:29:12','heze','菏泽',NULL),(1496,'371702','牡丹区','115.470946,35.24311','district',1495,0,'M','2018-12-14 00:21:07','2019-02-23 07:29:12','mudanqu','牡丹区',NULL),(1497,'371703','定陶区','115.569601,35.072701','district',1495,0,'D','2018-12-14 00:21:07','2019-02-23 07:29:12','dingtaoqu','定陶区',NULL),(1498,'371721','曹县','115.549482,34.823253','district',1495,0,'C','2018-12-14 00:21:07','2019-02-23 07:29:12','caoxian','曹县',NULL),(1499,'371722','单县','116.08262,34.790851','district',1495,0,'S','2018-12-14 00:21:07','2019-02-23 07:29:12','shanxian','单县',NULL),(1500,'371723','成武县','115.897349,34.947366','district',1495,0,'C','2018-12-14 00:21:07','2019-02-23 07:29:12','chengwuxian','成武县',NULL),(1501,'371724','巨野县','116.089341,35.390999','district',1495,0,'J','2018-12-14 00:21:08','2019-02-23 07:29:12','juyexian','巨野县',NULL),(1502,'371725','郓城县','115.93885,35.594773','district',1495,0,'Y','2018-12-14 00:21:08','2019-02-23 07:29:12','yunchengxian','郓城县',NULL),(1503,'371726','鄄城县','115.51434,35.560257','district',1495,0,'J','2018-12-14 00:21:08','2019-02-23 07:29:12','juanchengxian','鄄城县',NULL),(1504,'371728','东明县','115.098412,35.289637','district',1495,0,'D','2018-12-14 00:21:08','2019-02-23 07:29:12','dongmingxian','东明县',NULL),(1505,'410000','河南省','113.665412,34.757975','province',0,6699,'H','2018-12-14 00:21:08','2019-02-23 07:29:12','henansheng','河南省',NULL),(1506,'410100','郑州市','113.665412,34.757975','city',1505,0,'Z','2018-12-14 00:21:08','2019-02-23 07:29:12','zhengzhou','郑州',NULL),(1507,'410102','中原区','113.611576,34.748286','district',1506,0,'Z','2018-12-14 00:21:08','2019-02-23 07:29:12','zhongyuanqu','中原区',NULL),(1508,'410103','二七区','113.645422,34.730936','district',1506,0,'E','2018-12-14 00:21:08','2019-02-23 07:29:12','erqiqu','二七区',NULL),(1509,'410104','管城回族区','113.685313,34.746453','district',1506,0,'G','2018-12-14 00:21:08','2019-02-23 07:29:13','guanchenghuizuqu','管城回族区',NULL),(1510,'410105','金水区','113.686037,34.775838','district',1506,0,'J','2018-12-14 00:21:08','2019-02-23 07:29:13','jinshuiqu','金水区',NULL),(1511,'410106','上街区','113.298282,34.808689','district',1506,0,'S','2018-12-14 00:21:08','2019-02-23 07:29:13','shangjiequ','上街区',NULL),(1512,'410108','惠济区','113.61836,34.828591','district',1506,0,'H','2018-12-14 00:21:08','2019-02-23 07:29:13','huijiqu','惠济区',NULL),(1513,'410122','中牟县','114.022521,34.721976','district',1506,0,'Z','2018-12-14 00:21:08','2019-02-23 07:29:13','zhongmuxian','中牟县',NULL),(1514,'410181','巩义市','112.98283,34.75218','district',1506,0,'G','2018-12-14 00:21:08','2019-02-23 07:29:13','gongyi','巩义',NULL),(1515,'410182','荥阳市','113.391523,34.789077','district',1506,0,'X','2018-12-14 00:21:08','2019-02-23 07:29:13','xingyang','荥阳',NULL),(1516,'410183','新密市','113.380616,34.537846','district',1506,0,'X','2018-12-14 00:21:08','2019-02-23 07:29:13','xinmi','新密',NULL),(1517,'410184','新郑市','113.73967,34.394219','district',1506,0,'X','2018-12-14 00:21:08','2019-02-23 07:29:13','xinzheng','新郑',NULL),(1518,'410185','登封市','113.037768,34.459939','district',1506,0,'D','2018-12-14 00:21:09','2019-02-23 07:29:13','dengfeng','登封',NULL),(1519,'410200','开封市','114.341447,34.797049','city',1505,0,'K','2018-12-14 00:21:09','2019-02-23 07:29:13','kaifeng','开封',NULL),(1520,'410202','龙亭区','114.353348,34.799833','district',1519,0,'L','2018-12-14 00:21:09','2019-02-23 07:29:13','longtingqu','龙亭区',NULL),(1521,'410203','顺河回族区','114.364875,34.800459','district',1519,0,'S','2018-12-14 00:21:09','2019-02-23 07:29:13','shunhehuizuqu','顺河回族区',NULL),(1522,'410204','鼓楼区','114.3485,34.792383','district',1519,0,'G','2018-12-14 00:21:09','2019-02-23 07:29:13','gulouqu','鼓楼区',NULL),(1523,'410205','禹王台区','114.350246,34.779727','district',1519,0,'Y','2018-12-14 00:21:09','2019-02-23 07:29:13','yuwangtaiqu','禹王台区',NULL),(1524,'410212','祥符区','114.437622,34.756476','district',1519,0,'X','2018-12-14 00:21:09','2019-02-23 07:29:13','xiangfuqu','祥符区',NULL),(1525,'410221','杞县','114.770472,34.554585','district',1519,0,'Q','2018-12-14 00:21:09','2019-02-23 07:29:13','qixian','杞县',NULL),(1526,'410222','通许县','114.467734,34.477302','district',1519,0,'T','2018-12-14 00:21:09','2019-02-23 07:29:13','tongxuxian','通许县',NULL),(1527,'410223','尉氏县','114.193927,34.412256','district',1519,0,'W','2018-12-14 00:21:09','2019-02-23 07:29:13','weishixian','尉氏县',NULL),(1528,'410225','兰考县','114.820572,34.829899','district',1519,0,'L','2018-12-14 00:21:09','2019-02-23 07:29:13','lankaoxian','兰考县',NULL),(1529,'410300','洛阳市','112.434468,34.663041','city',1505,0,'L','2018-12-14 00:21:09','2019-02-23 07:29:13','luoyang','洛阳',NULL),(1530,'410302','老城区','112.477298,34.682945','district',1529,0,'L','2018-12-14 00:21:09','2019-02-23 07:29:13','laochengqu','老城区',NULL),(1531,'410303','西工区','112.443232,34.667847','district',1529,0,'X','2018-12-14 00:21:09','2019-02-23 07:29:13','xigongqu','西工区',NULL),(1532,'410304','瀍河回族区','112.491625,34.684738','district',1529,0,'C','2018-12-14 00:21:09','2019-02-23 07:29:13','chanhehuizuqu','瀍河回族区',NULL),(1533,'410305','涧西区','112.399243,34.654251','district',1529,0,'J','2018-12-14 00:21:10','2019-02-23 07:29:13','jianxiqu','涧西区',NULL),(1534,'410306','吉利区','112.584796,34.899093','district',1529,0,'J','2018-12-14 00:21:10','2019-02-23 07:29:13','jiliqu','吉利区',NULL),(1535,'410311','洛龙区','112.456634,34.618557','district',1529,0,'L','2018-12-14 00:21:10','2019-02-23 07:29:13','luolongqu','洛龙区',NULL),(1536,'410322','孟津县','112.443892,34.826485','district',1529,0,'M','2018-12-14 00:21:10','2019-02-23 07:29:13','mengjinxian','孟津县',NULL),(1537,'410323','新安县','112.141403,34.728679','district',1529,0,'X','2018-12-14 00:21:10','2019-02-23 07:29:13','xinanxian','新安县',NULL),(1538,'410324','栾川县','111.618386,33.783195','district',1529,0,'L','2018-12-14 00:21:10','2019-02-23 07:29:13','luanchuanxian','栾川县',NULL),(1539,'410325','嵩县','112.087765,34.131563','district',1529,0,'S','2018-12-14 00:21:10','2019-02-23 07:29:13','songxian','嵩县',NULL),(1540,'410326','汝阳县','112.473789,34.15323','district',1529,0,'R','2018-12-14 00:21:10','2019-02-23 07:29:13','ruyangxian','汝阳县',NULL),(1541,'410327','宜阳县','112.179989,34.516478','district',1529,0,'Y','2018-12-14 00:21:10','2019-02-23 07:29:13','yiyangxian','宜阳县',NULL),(1542,'410328','洛宁县','111.655399,34.387179','district',1529,0,'L','2018-12-14 00:21:10','2019-02-23 07:29:13','luoningxian','洛宁县',NULL),(1543,'410329','伊川县','112.429384,34.423416','district',1529,0,'Y','2018-12-14 00:21:10','2019-02-23 07:29:13','yichuanxian','伊川县',NULL),(1544,'410381','偃师市','112.787739,34.723042','district',1529,0,'Y','2018-12-14 00:21:10','2019-02-23 07:29:13','yanshi','偃师',NULL);
INSERT INTO `districts` VALUES (1545,'410400','平顶山市','113.307718,33.735241','city',1505,0,'P','2018-12-14 00:21:10','2019-02-23 07:29:14','pingdingshan','平顶山',NULL),(1546,'410402','新华区','113.299061,33.737579','district',1545,0,'X','2018-12-14 00:21:10','2019-02-23 07:29:14','xinhuaqu','新华区',NULL),(1547,'410403','卫东区','113.310327,33.739285','district',1545,0,'W','2018-12-14 00:21:11','2019-02-23 07:29:14','weidongqu','卫东区',NULL),(1548,'410404','石龙区','112.889885,33.901538','district',1545,0,'S','2018-12-14 00:21:11','2019-02-23 07:29:14','shilongqu','石龙区',NULL),(1549,'410411','湛河区','113.320873,33.725681','district',1545,0,'Z','2018-12-14 00:21:11','2019-02-23 07:29:14','zhanhequ','湛河区',NULL),(1550,'410421','宝丰县','113.066812,33.866359','district',1545,0,'B','2018-12-14 00:21:11','2019-02-23 07:29:14','baofengxian','宝丰县',NULL),(1551,'410422','叶县','113.358298,33.621252','district',1545,0,'Y','2018-12-14 00:21:11','2019-02-23 07:29:14','yexian','叶县',NULL),(1552,'410423','鲁山县','112.906703,33.740325','district',1545,0,'L','2018-12-14 00:21:11','2019-02-23 07:29:14','lushanxian','鲁山县',NULL),(1553,'410425','郏县','113.220451,33.971993','district',1545,0,'J','2018-12-14 00:21:11','2019-02-23 07:29:14','jiaxian','郏县',NULL),(1554,'410481','舞钢市','113.52625,33.302082','district',1545,0,'W','2018-12-14 00:21:11','2019-02-23 07:29:14','wugang','舞钢',NULL),(1555,'410482','汝州市','112.845336,34.167408','district',1545,0,'R','2018-12-14 00:21:11','2019-02-23 07:29:14','ruzhou','汝州',NULL),(1556,'410500','安阳市','114.352482,36.103442','city',1505,0,'A','2018-12-14 00:21:11','2019-02-23 07:29:14','anyang','安阳',NULL),(1557,'410502','文峰区','114.352562,36.098101','district',1556,0,'W','2018-12-14 00:21:11','2019-02-23 07:29:14','wenfengqu','文峰区',NULL),(1558,'410503','北关区','114.352646,36.10978','district',1556,0,'B','2018-12-14 00:21:11','2019-02-23 07:29:14','beiguanqu','北关区',NULL),(1559,'410505','殷都区','114.300098,36.108974','district',1556,0,'Y','2018-12-14 00:21:11','2019-02-23 07:29:14','yinduqu','殷都区',NULL),(1560,'410506','龙安区','114.323522,36.095568','district',1556,0,'L','2018-12-14 00:21:11','2019-02-23 07:29:14','longanqu','龙安区',NULL),(1561,'410522','安阳县','114.130207,36.130585','district',1556,0,'A','2018-12-14 00:21:11','2019-02-23 07:29:14','anyangxian','安阳县',NULL),(1562,'410523','汤阴县','114.362357,35.922349','district',1556,0,'T','2018-12-14 00:21:11','2019-02-23 07:29:14','tangyinxian','汤阴县',NULL),(1563,'410526','滑县','114.524,35.574628','district',1556,0,'H','2018-12-14 00:21:12','2019-02-23 07:29:14','huaxian','滑县',NULL),(1564,'410527','内黄县','114.904582,35.953702','district',1556,0,'N','2018-12-14 00:21:12','2019-02-23 07:29:14','neihuangxian','内黄县',NULL),(1565,'410581','林州市','113.823767,36.063403','district',1556,0,'L','2018-12-14 00:21:12','2019-02-23 07:29:14','linzhou','林州',NULL),(1566,'410600','鹤壁市','114.295444,35.748236','city',1505,0,'H','2018-12-14 00:21:12','2019-02-23 07:29:14','hebi','鹤壁',NULL),(1567,'410602','鹤山区','114.166551,35.936128','district',1566,0,'H','2018-12-14 00:21:12','2019-02-23 07:29:14','heshanqu','鹤山区',NULL),(1568,'410603','山城区','114.184202,35.896058','district',1566,0,'S','2018-12-14 00:21:12','2019-02-23 07:29:14','shanchengqu','山城区',NULL),(1569,'410611','淇滨区','114.293917,35.748382','district',1566,0,'Q','2018-12-14 00:21:12','2019-02-23 07:29:14','qibinqu','淇滨区',NULL),(1570,'410621','浚县','114.550162,35.671282','district',1566,0,'J','2018-12-14 00:21:12','2019-02-23 07:29:14','junxian','浚县',NULL),(1571,'410622','淇县','114.200379,35.609478','district',1566,0,'Q','2018-12-14 00:21:12','2019-02-23 07:29:14','qixian','淇县',NULL),(1572,'410700','新乡市','113.883991,35.302616','city',1505,0,'X','2018-12-14 00:21:12','2019-02-23 07:29:14','xinxiang','新乡',NULL),(1573,'410702','红旗区','113.878158,35.302684','district',1572,0,'H','2018-12-14 00:21:12','2019-02-23 07:29:14','hongqiqu','红旗区',NULL),(1574,'410703','卫滨区','113.866065,35.304905','district',1572,0,'W','2018-12-14 00:21:12','2019-02-23 07:29:14','weibinqu','卫滨区',NULL),(1575,'410704','凤泉区','113.906712,35.379855','district',1572,0,'F','2018-12-14 00:21:12','2019-02-23 07:29:14','fengquanqu','凤泉区',NULL),(1576,'410711','牧野区','113.89716,35.312974','district',1572,0,'M','2018-12-14 00:21:12','2019-02-23 07:29:14','muyequ','牧野区',NULL),(1577,'410721','新乡县','113.806186,35.190021','district',1572,0,'X','2018-12-14 00:21:12','2019-02-23 07:29:14','xinxiangxian','新乡县',NULL),(1578,'410724','获嘉县','113.657249,35.261685','district',1572,0,'H','2018-12-14 00:21:12','2019-02-23 07:29:14','huojiaxian','获嘉县',NULL),(1579,'410725','原阳县','113.965966,35.054001','district',1572,0,'Y','2018-12-14 00:21:13','2019-02-23 07:29:14','yuanyangxian','原阳县',NULL),(1580,'410726','延津县','114.200982,35.149515','district',1572,0,'Y','2018-12-14 00:21:13','2019-02-23 07:29:14','yanjinxian','延津县',NULL),(1581,'410727','封丘县','114.423405,35.04057','district',1572,0,'F','2018-12-14 00:21:13','2019-02-23 07:29:14','fengqiuxian','封丘县',NULL),(1582,'410728','长垣县','114.673807,35.19615','district',1572,0,'C','2018-12-14 00:21:13','2019-02-23 07:29:15','changyuanxian','长垣县',NULL),(1583,'410781','卫辉市','114.065855,35.404295','district',1572,0,'W','2018-12-14 00:21:13','2019-02-23 07:29:15','weihui','卫辉',NULL),(1584,'410782','辉县市','113.802518,35.461318','district',1572,0,'H','2018-12-14 00:21:13','2019-02-23 07:29:15','huixian','辉县',NULL),(1585,'410800','焦作市','113.238266,35.23904','city',1505,0,'J','2018-12-14 00:21:13','2019-02-23 07:29:15','jiaozuo','焦作',NULL),(1586,'410802','解放区','113.226126,35.241353','district',1585,0,'J','2018-12-14 00:21:13','2019-02-23 07:29:15','jiefangqu','解放区',NULL),(1587,'410803','中站区','113.175485,35.236145','district',1585,0,'Z','2018-12-14 00:21:13','2019-02-23 07:29:15','zhongzhanqu','中站区',NULL),(1588,'410804','马村区','113.321703,35.265453','district',1585,0,'M','2018-12-14 00:21:13','2019-02-23 07:29:15','macunqu','马村区',NULL),(1589,'410811','山阳区','113.26766,35.21476','district',1585,0,'S','2018-12-14 00:21:13','2019-02-23 07:29:15','shanyangqu','山阳区',NULL),(1590,'410821','修武县','113.447465,35.229923','district',1585,0,'X','2018-12-14 00:21:13','2019-02-23 07:29:15','xiuwuxian','修武县',NULL),(1591,'410822','博爱县','113.069313,35.170351','district',1585,0,'B','2018-12-14 00:21:13','2019-02-23 07:29:15','boaixian','博爱县',NULL),(1592,'410823','武陟县','113.408334,35.09885','district',1585,0,'W','2018-12-14 00:21:13','2019-02-23 07:29:15','wuzhixian','武陟县',NULL),(1593,'410825','温县','113.079118,34.941233','district',1585,0,'W','2018-12-14 00:21:13','2019-02-23 07:29:15','wenxian','温县',NULL),(1594,'410882','沁阳市','112.934538,35.08901','district',1585,0,'Q','2018-12-14 00:21:13','2019-02-23 07:29:15','qinyang','沁阳',NULL),(1595,'410883','孟州市','112.78708,34.90963','district',1585,0,'M','2018-12-14 00:21:13','2019-02-23 07:29:15','mengzhou','孟州',NULL),(1596,'410900','濮阳市','115.041299,35.768234','city',1505,0,'P','2018-12-14 00:21:13','2019-02-23 07:29:15','puyang','濮阳',NULL),(1597,'410902','华龙区','115.03184,35.760473','district',1596,0,'H','2018-12-14 00:21:13','2019-02-23 07:29:15','hualongqu','华龙区',NULL),(1598,'410922','清丰县','115.107287,35.902413','district',1596,0,'Q','2018-12-14 00:21:14','2019-02-23 07:29:15','qingfengxian','清丰县',NULL),(1599,'410923','南乐县','115.204336,36.075204','district',1596,0,'N','2018-12-14 00:21:14','2019-02-23 07:29:15','nanlexian','南乐县',NULL),(1600,'410926','范县','115.504212,35.851977','district',1596,0,'F','2018-12-14 00:21:14','2019-02-23 07:29:15','fanxian','范县',NULL),(1601,'410927','台前县','115.855681,35.996474','district',1596,0,'T','2018-12-14 00:21:14','2019-02-23 07:29:15','taiqianxian','台前县',NULL),(1602,'410928','濮阳县','115.023844,35.710349','district',1596,0,'P','2018-12-14 00:21:14','2019-02-23 07:29:15','puyangxian','濮阳县',NULL),(1603,'411000','许昌市','113.826063,34.022956','city',1505,0,'X','2018-12-14 00:21:14','2019-02-23 07:29:15','xuchang','许昌',NULL),(1604,'411002','魏都区','113.828307,34.02711','district',1603,0,'W','2018-12-14 00:21:14','2019-02-23 07:29:15','weiduqu','魏都区',NULL),(1605,'411003','建安区','113.842898,34.005018','district',1603,0,'J','2018-12-14 00:21:14','2019-02-23 07:29:15','jiananqu','建安区',NULL),(1606,'411024','鄢陵县','114.188507,34.100502','district',1603,0,'Y','2018-12-14 00:21:14','2019-02-23 07:29:15','yanlingxian','鄢陵县',NULL),(1607,'411025','襄城县','113.493166,33.855943','district',1603,0,'X','2018-12-14 00:21:14','2019-02-23 07:29:15','xiangchengxian','襄城县',NULL),(1608,'411081','禹州市','113.471316,34.154403','district',1603,0,'Y','2018-12-14 00:21:14','2019-02-23 07:29:15','yuzhou','禹州',NULL),(1609,'411082','长葛市','113.768912,34.219257','district',1603,0,'C','2018-12-14 00:21:14','2019-02-23 07:29:15','changge','长葛',NULL),(1610,'411100','漯河市','114.026405,33.575855','city',1505,0,'T','2018-12-14 00:21:14','2019-02-23 07:29:15','tahe','漯河',NULL),(1611,'411102','源汇区','114.017948,33.565441','district',1610,0,'Y','2018-12-14 00:21:14','2019-02-23 07:29:15','yuanhuiqu','源汇区',NULL),(1612,'411103','郾城区','114.016813,33.588897','district',1610,0,'Y','2018-12-14 00:21:14','2019-02-23 07:29:15','yanchengqu','郾城区',NULL),(1613,'411104','召陵区','114.051686,33.567555','district',1610,0,'S','2018-12-14 00:21:14','2019-02-23 07:29:15','shaolingqu','召陵区',NULL),(1614,'411121','舞阳县','113.610565,33.436278','district',1610,0,'W','2018-12-14 00:21:14','2019-02-23 07:29:15','wuyangxian','舞阳县',NULL),(1615,'411122','临颍县','113.938891,33.80609','district',1610,0,'L','2018-12-14 00:21:14','2019-02-23 07:29:15','linyingxian','临颍县',NULL),(1616,'411200','三门峡市','111.194099,34.777338','city',1505,0,'S','2018-12-14 00:21:15','2019-02-23 07:29:15','sanmenxia','三门峡',NULL),(1617,'411202','湖滨区','111.19487,34.77812','district',1616,0,'H','2018-12-14 00:21:15','2019-02-23 07:29:15','hubinqu','湖滨区',NULL),(1618,'411203','陕州区','111.103851,34.720244','district',1616,0,'S','2018-12-14 00:21:15','2019-02-23 07:29:16','shanzhouqu','陕州区',NULL),(1619,'411221','渑池县','111.762992,34.763487','district',1616,0,'M','2018-12-14 00:21:15','2019-02-23 07:29:16','mianchixian','渑池县',NULL),(1620,'411224','卢氏县','111.052649,34.053995','district',1616,0,'L','2018-12-14 00:21:15','2019-02-23 07:29:16','lushixian','卢氏县',NULL),(1621,'411281','义马市','111.869417,34.746868','district',1616,0,'Y','2018-12-14 00:21:15','2019-02-23 07:29:16','yima','义马',NULL),(1622,'411282','灵宝市','110.88577,34.521264','district',1616,0,'L','2018-12-14 00:21:15','2019-02-23 07:29:16','lingbao','灵宝',NULL),(1623,'411300','南阳市','112.540918,32.999082','city',1505,0,'N','2018-12-14 00:21:15','2019-02-23 07:29:16','nanyang','南阳',NULL),(1624,'411302','宛城区','112.544591,32.994857','district',1623,0,'W','2018-12-14 00:21:15','2019-02-23 07:29:16','wanchengqu','宛城区',NULL),(1625,'411303','卧龙区','112.528789,32.989877','district',1623,0,'W','2018-12-14 00:21:15','2019-02-23 07:29:16','wolongqu','卧龙区',NULL),(1626,'411321','南召县','112.435583,33.488617','district',1623,0,'N','2018-12-14 00:21:15','2019-02-23 07:29:16','nanzhaoxian','南召县',NULL),(1627,'411322','方城县','113.010933,33.255138','district',1623,0,'F','2018-12-14 00:21:15','2019-02-23 07:29:16','fangchengxian','方城县',NULL),(1628,'411323','西峡县','111.485772,33.302981','district',1623,0,'X','2018-12-14 00:21:15','2019-02-23 07:29:16','xixiaxian','西峡县',NULL),(1629,'411324','镇平县','112.232722,33.036651','district',1623,0,'Z','2018-12-14 00:21:15','2019-02-23 07:29:16','zhenpingxian','镇平县',NULL),(1630,'411325','内乡县','111.843801,33.046358','district',1623,0,'N','2018-12-14 00:21:15','2019-02-23 07:29:16','neixiangxian','内乡县',NULL),(1631,'411326','淅川县','111.489026,33.136106','district',1623,0,'X','2018-12-14 00:21:15','2019-02-23 07:29:16','xichuanxian','淅川县',NULL),(1632,'411327','社旗县','112.938279,33.056126','district',1623,0,'S','2018-12-14 00:21:16','2019-02-23 07:29:16','sheqixian','社旗县',NULL),(1633,'411328','唐河县','112.838492,32.687892','district',1623,0,'T','2018-12-14 00:21:16','2019-02-23 07:29:16','tanghexian','唐河县',NULL),(1634,'411329','新野县','112.365624,32.524006','district',1623,0,'X','2018-12-14 00:21:16','2019-02-23 07:29:16','xinyexian','新野县',NULL),(1635,'411330','桐柏县','113.406059,32.367153','district',1623,0,'T','2018-12-14 00:21:16','2019-02-23 07:29:16','tongbaixian','桐柏县',NULL),(1636,'411381','邓州市','112.092716,32.681642','district',1623,0,'D','2018-12-14 00:21:16','2019-02-23 07:29:16','dengzhou','邓州',NULL),(1637,'411400','商丘市','115.650497,34.437054','city',1505,0,'S','2018-12-14 00:21:16','2019-02-23 07:29:16','shangqiu','商丘',NULL),(1638,'411402','梁园区','115.65459,34.436553','district',1637,0,'L','2018-12-14 00:21:16','2019-02-23 07:29:16','liangyuanqu','梁园区',NULL),(1639,'411403','睢阳区','115.653813,34.390536','district',1637,0,'S','2018-12-14 00:21:16','2019-02-23 07:29:16','suiyangqu','睢阳区',NULL),(1640,'411421','民权县','115.148146,34.648455','district',1637,0,'M','2018-12-14 00:21:16','2019-02-23 07:29:16','minquanxian','民权县',NULL),(1641,'411422','睢县','115.070109,34.428433','district',1637,0,'S','2018-12-14 00:21:16','2019-02-23 07:29:16','suixian','睢县',NULL),(1642,'411423','宁陵县','115.320055,34.449299','district',1637,0,'N','2018-12-14 00:21:16','2019-02-23 07:29:16','ninglingxian','宁陵县',NULL),(1643,'411424','柘城县','115.307433,34.075277','district',1637,0,'Z','2018-12-14 00:21:16','2019-02-23 07:29:16','zhechengxian','柘城县',NULL),(1644,'411425','虞城县','115.863811,34.399634','district',1637,0,'Y','2018-12-14 00:21:16','2019-02-23 07:29:16','yuchengxian','虞城县',NULL),(1645,'411426','夏邑县','116.13989,34.240894','district',1637,0,'X','2018-12-14 00:21:16','2019-02-23 07:29:16','xiayixian','夏邑县',NULL),(1646,'411481','永城市','116.449672,33.931318','district',1637,0,'Y','2018-12-14 00:21:16','2019-02-23 07:29:16','yongcheng','永城',NULL),(1647,'411500','信阳市','114.075031,32.123274','city',1505,0,'X','2018-12-14 00:21:16','2019-02-23 07:29:16','xinyang','信阳',NULL),(1648,'411502','浉河区','114.075031,32.123274','district',1647,0,'S','2018-12-14 00:21:16','2019-02-23 07:29:16','shihequ','浉河区',NULL),(1649,'411503','平桥区','114.126027,32.098395','district',1647,0,'P','2018-12-14 00:21:17','2019-02-23 07:29:16','pingqiaoqu','平桥区',NULL),(1650,'411521','罗山县','114.533414,32.203206','district',1647,0,'L','2018-12-14 00:21:17','2019-02-23 07:29:16','luoshanxian','罗山县',NULL),(1651,'411522','光山县','114.903577,32.010398','district',1647,0,'G','2018-12-14 00:21:17','2019-02-23 07:29:16','guangshanxian','光山县',NULL),(1652,'411523','新县','114.87705,31.63515','district',1647,0,'X','2018-12-14 00:21:17','2019-02-23 07:29:17','xinxian','新县',NULL),(1653,'411524','商城县','115.406297,31.799982','district',1647,0,'S','2018-12-14 00:21:17','2019-02-23 07:29:17','shangchengxian','商城县',NULL),(1654,'411525','固始县','115.667328,32.183074','district',1647,0,'G','2018-12-14 00:21:17','2019-02-23 07:29:17','gushixian','固始县',NULL),(1655,'411526','潢川县','115.050123,32.134024','district',1647,0,'H','2018-12-14 00:21:17','2019-02-23 07:29:17','huangchuanxian','潢川县',NULL),(1656,'411527','淮滨县','115.415451,32.452639','district',1647,0,'H','2018-12-14 00:21:17','2019-02-23 07:29:17','huaibinxian','淮滨县',NULL),(1657,'411528','息县','114.740713,32.344744','district',1647,0,'X','2018-12-14 00:21:17','2019-02-23 07:29:17','xixian','息县',NULL),(1658,'411600','周口市','114.649653,33.620357','city',1505,0,'Z','2018-12-14 00:21:17','2019-02-23 07:29:17','zhoukou','周口',NULL),(1659,'411602','川汇区','114.652136,33.614836','district',1658,0,'C','2018-12-14 00:21:17','2019-02-23 07:29:17','chuanhuiqu','川汇区',NULL),(1660,'411621','扶沟县','114.392008,34.054061','district',1658,0,'F','2018-12-14 00:21:17','2019-02-23 07:29:17','fugouxian','扶沟县',NULL),(1661,'411622','西华县','114.530067,33.784378','district',1658,0,'X','2018-12-14 00:21:17','2019-02-23 07:29:17','xihuaxian','西华县',NULL),(1662,'411623','商水县','114.60927,33.543845','district',1658,0,'S','2018-12-14 00:21:17','2019-02-23 07:29:17','shangshuixian','商水县',NULL),(1663,'411624','沈丘县','115.078375,33.395514','district',1658,0,'S','2018-12-14 00:21:17','2019-02-23 07:29:17','shenqiuxian','沈丘县',NULL),(1664,'411625','郸城县','115.189,33.643852','district',1658,0,'D','2018-12-14 00:21:18','2019-02-23 07:29:17','danchengxian','郸城县',NULL),(1665,'411626','淮阳县','114.870166,33.732547','district',1658,0,'H','2018-12-14 00:21:18','2019-02-23 07:29:17','huaiyangxian','淮阳县',NULL),(1666,'411627','太康县','114.853834,34.065312','district',1658,0,'T','2018-12-14 00:21:18','2019-02-23 07:29:17','taikangxian','太康县',NULL),(1667,'411628','鹿邑县','115.486386,33.861067','district',1658,0,'L','2018-12-14 00:21:18','2019-02-23 07:29:17','luyixian','鹿邑县',NULL),(1668,'411681','项城市','114.899521,33.443085','district',1658,0,'X','2018-12-14 00:21:18','2019-02-23 07:29:17','xiangcheng','项城',NULL),(1669,'411700','驻马店市','114.024736,32.980169','city',1505,0,'Z','2018-12-14 00:21:18','2019-02-23 07:29:17','zhumadian','驻马店',NULL),(1670,'411702','驿城区','114.029149,32.977559','district',1669,0,'Y','2018-12-14 00:21:18','2019-02-23 07:29:17','yichengqu','驿城区',NULL),(1671,'411721','西平县','114.026864,33.382315','district',1669,0,'X','2018-12-14 00:21:18','2019-02-23 07:29:17','xipingxian','西平县',NULL),(1672,'411722','上蔡县','114.266892,33.264719','district',1669,0,'S','2018-12-14 00:21:18','2019-02-23 07:29:17','shangcaixian','上蔡县',NULL),(1673,'411723','平舆县','114.637105,32.955626','district',1669,0,'P','2018-12-14 00:21:18','2019-02-23 07:29:17','pingyuxian','平舆县',NULL),(1674,'411724','正阳县','114.38948,32.601826','district',1669,0,'Z','2018-12-14 00:21:18','2019-02-23 07:29:17','zhengyangxian','正阳县',NULL),(1675,'411725','确山县','114.026679,32.801538','district',1669,0,'Q','2018-12-14 00:21:18','2019-02-23 07:29:17','queshanxian','确山县',NULL),(1676,'411726','泌阳县','113.32605,32.725129','district',1669,0,'B','2018-12-14 00:21:18','2019-02-23 07:29:17','biyangxian','泌阳县',NULL),(1677,'411727','汝南县','114.359495,33.004535','district',1669,0,'R','2018-12-14 00:21:18','2019-02-23 07:29:17','runanxian','汝南县',NULL),(1678,'411728','遂平县','114.00371,33.14698','district',1669,0,'S','2018-12-14 00:21:18','2019-02-23 07:29:17','suipingxian','遂平县',NULL),(1679,'411729','新蔡县','114.975246,32.749948','district',1669,0,'X','2018-12-14 00:21:18','2019-02-23 07:29:17','xincaixian','新蔡县',NULL),(1680,'419001','济源市','112.590047,35.090378','city',1505,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:17','jiyuan','济源',NULL),(1681,'419001','济源市下冶镇','112.212,35.1131','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:17','jiyuanxiayezhen','济源下冶镇',NULL),(1682,'419001','济源市五龙口镇','112.761,35.1956','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuanwulongkouzhen','济源五龙口镇',NULL),(1683,'419001','济源市克井镇','112.635,35.255','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuankejingzhen','济源克井镇',NULL),(1684,'419001','济源市北海街道','112.569,35.1116','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuanbeihaijiedao','济源北海街道',NULL),(1685,'419001','济源市坡头镇','112.538,34.9308','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuanpotouzhen','济源坡头镇',NULL),(1686,'419001','济源市大峪镇','112.338,34.9398','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuandayuzhen','济源大峪镇',NULL),(1687,'419001','济源市天坛街道','112.567,35.1229','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuantiantanjiedao','济源天坛街道',NULL),(1688,'419001','济源市思礼镇','112.388,35.2103','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuansilizhen','济源思礼镇',NULL),(1689,'419001','济源市承留镇','112.509,35.0243','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuanchengliuzhen','济源承留镇',NULL),(1690,'419001','济源市梨林镇','112.753,35.0882','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuanlilinzhen','济源梨林镇',NULL),(1691,'419001','济源市沁园街道','112.593,35.0822','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuanqinyuanjiedao','济源沁园街道',NULL),(1692,'419001','济源市济水街道','112.595,35.0944','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuanjishuijiedao','济源济水街道',NULL),(1693,'419001','济源市玉泉街道','112.624,35.1189','street',1680,0,'J','2018-12-14 00:21:19','2019-02-23 07:29:18','jiyuanyuquanjiedao','济源玉泉街道',NULL),(1694,'419001','济源市王屋镇','112.169,35.1244','street',1680,0,'J','2018-12-14 00:21:20','2019-02-23 07:29:18','jiyuanwangwuzhen','济源王屋镇',NULL),(1695,'419001','济源市轵城镇','112.622,35.0625','street',1680,0,'J','2018-12-14 00:21:20','2019-02-23 07:29:18','jiyuanzhichengzhen','济源轵城镇',NULL),(1696,'419001','济源市邵原镇','112.113,35.2704','street',1680,0,'J','2018-12-14 00:21:20','2019-02-23 07:29:18','jiyuanshaoyuanzhen','济源邵原镇',NULL),(1697,'420000','湖北省','114.298572,30.584355','province',0,7700,'H','2018-12-14 00:21:20','2019-02-23 07:29:18','hubeisheng','湖北省',NULL),(1698,'420100','武汉市','114.298572,30.584355','city',1697,0,'W','2018-12-14 00:21:20','2019-02-23 07:29:18','wuhan','武汉',1),(1699,'420102','江岸区','114.30304,30.594911','district',1698,0,'J','2018-12-14 00:21:20','2019-02-23 07:29:18','jianganqu','江岸区',NULL),(1700,'420103','江汉区','114.283109,30.578771','district',1698,0,'J','2018-12-14 00:21:20','2019-02-23 07:29:18','jianghanqu','江汉区',NULL),(1701,'420104','硚口区','114.264568,30.57061','district',1698,0,'Q','2018-12-14 00:21:20','2019-02-23 07:29:18','qiaokouqu','硚口区',NULL),(1702,'420105','汉阳区','114.265807,30.549326','district',1698,0,'H','2018-12-14 00:21:20','2019-02-23 07:29:18','hanyangqu','汉阳区',NULL),(1703,'420106','武昌区','114.307344,30.546536','district',1698,0,'W','2018-12-14 00:21:20','2019-02-23 07:29:18','wuchangqu','武昌区',NULL),(1704,'420107','青山区','114.39707,30.634215','district',1698,0,'Q','2018-12-14 00:21:20','2019-02-23 07:29:18','qingshanqu','青山区',NULL),(1705,'420111','洪山区','114.400718,30.504259','district',1698,0,'H','2018-12-14 00:21:20','2019-02-23 07:29:18','hongshanqu','洪山区',NULL),(1706,'420112','东西湖区','114.142483,30.622467','district',1698,0,'D','2018-12-14 00:21:20','2019-02-23 07:29:18','dongxihuqu','东西湖区',NULL),(1707,'420113','汉南区','114.08124,30.309637','district',1698,0,'H','2018-12-14 00:21:20','2019-02-23 07:29:18','hannanqu','汉南区',NULL),(1708,'420114','蔡甸区','114.029341,30.582186','district',1698,0,'C','2018-12-14 00:21:20','2019-02-23 07:29:18','caidianqu','蔡甸区',NULL),(1709,'420115','江夏区','114.313961,30.349045','district',1698,0,'J','2018-12-14 00:21:21','2019-02-23 07:29:18','jiangxiaqu','江夏区',NULL),(1710,'420116','黄陂区','114.374025,30.874155','district',1698,0,'H','2018-12-14 00:21:21','2019-02-23 07:29:18','huangpiqu','黄陂区',NULL),(1711,'420117','新洲区','114.802108,30.842149','district',1698,0,'X','2018-12-14 00:21:21','2019-02-23 07:29:18','xinzhouqu','新洲区',NULL),(1712,'420200','黄石市','115.077048,30.220074','city',1697,0,'H','2018-12-14 00:21:21','2019-02-23 07:29:18','huangshi','黄石',NULL),(1713,'420202','黄石港区','115.090164,30.212086','district',1712,0,'H','2018-12-14 00:21:21','2019-02-23 07:29:18','huangshigangqu','黄石港区',NULL),(1714,'420203','西塞山区','115.093354,30.205365','district',1712,0,'X','2018-12-14 00:21:21','2019-02-23 07:29:18','xisaishanqu','西塞山区',NULL),(1715,'420204','下陆区','114.975755,30.177845','district',1712,0,'X','2018-12-14 00:21:21','2019-02-23 07:29:18','xialuqu','下陆区',NULL),(1716,'420205','铁山区','114.901366,30.20601','district',1712,0,'T','2018-12-14 00:21:21','2019-02-23 07:29:18','tieshanqu','铁山区',NULL),(1717,'420222','阳新县','115.212883,29.841572','district',1712,0,'Y','2018-12-14 00:21:21','2019-02-23 07:29:19','yangxinxian','阳新县',NULL),(1718,'420281','大冶市','114.974842,30.098804','district',1712,0,'D','2018-12-14 00:21:21','2019-02-23 07:29:19','daye','大冶',NULL),(1719,'420300','十堰市','110.787916,32.646907','city',1697,0,'S','2018-12-14 00:21:21','2019-02-23 07:29:19','shiyan','十堰',NULL),(1720,'420302','茅箭区','110.78621,32.644463','district',1719,0,'M','2018-12-14 00:21:21','2019-02-23 07:29:19','maojianqu','茅箭区',NULL),(1721,'420303','张湾区','110.772365,32.652516','district',1719,0,'Z','2018-12-14 00:21:21','2019-02-23 07:29:19','zhangwanqu','张湾区',NULL),(1722,'420304','郧阳区','110.812099,32.838267','district',1719,0,'Y','2018-12-14 00:21:21','2019-02-23 07:29:19','yunyangqu','郧阳区',NULL),(1723,'420322','郧西县','110.426472,32.991457','district',1719,0,'Y','2018-12-14 00:21:21','2019-02-23 07:29:19','yunxixian','郧西县',NULL),(1724,'420323','竹山县','110.2296,32.22586','district',1719,0,'Z','2018-12-14 00:21:22','2019-02-23 07:29:19','zhushanxian','竹山县',NULL),(1725,'420324','竹溪县','109.717196,32.315342','district',1719,0,'Z','2018-12-14 00:21:22','2019-02-23 07:29:19','zhuxixian','竹溪县',NULL),(1726,'420325','房县','110.741966,32.055002','district',1719,0,'F','2018-12-14 00:21:22','2019-02-23 07:29:19','fangxian','房县',NULL),(1727,'420381','丹江口市','111.513793,32.538839','district',1719,0,'D','2018-12-14 00:21:22','2019-02-23 07:29:19','danjiangkou','丹江口',NULL),(1728,'420500','宜昌市','111.290843,30.702636','city',1697,0,'Y','2018-12-14 00:21:22','2019-02-23 07:29:19','yichang','宜昌',NULL),(1729,'420502','西陵区','111.295468,30.702476','district',1728,0,'X','2018-12-14 00:21:22','2019-02-23 07:29:19','xilingqu','西陵区',NULL),(1730,'420503','伍家岗区','111.307215,30.679053','district',1728,0,'W','2018-12-14 00:21:22','2019-02-23 07:29:19','wujiagangqu','伍家岗区',NULL),(1731,'420504','点军区','111.268163,30.692322','district',1728,0,'D','2018-12-14 00:21:22','2019-02-23 07:29:19','dianjunqu','点军区',NULL),(1732,'420505','猇亭区','111.427642,30.530744','district',1728,0,'X','2018-12-14 00:21:22','2019-02-23 07:29:19','xiaotingqu','猇亭区',NULL),(1733,'420506','夷陵区','111.326747,30.770199','district',1728,0,'Y','2018-12-14 00:21:22','2019-02-23 07:29:19','yilingqu','夷陵区',NULL),(1734,'420525','远安县','111.64331,31.059626','district',1728,0,'Y','2018-12-14 00:21:22','2019-02-23 07:29:19','yuananxian','远安县',NULL),(1735,'420526','兴山县','110.754499,31.34795','district',1728,0,'X','2018-12-14 00:21:22','2019-02-23 07:29:19','xingshanxian','兴山县',NULL),(1736,'420527','秭归县','110.976785,30.823908','district',1728,0,'Z','2018-12-14 00:21:22','2019-02-23 07:29:19','ziguixian','秭归县',NULL),(1737,'420528','长阳土家族自治县','111.198475,30.466534','district',1728,0,'Z','2018-12-14 00:21:22','2019-02-23 07:29:19','zhangyangtujiazuzizhixian','长阳土家族自治县',NULL),(1738,'420529','五峰土家族自治县','110.674938,30.199252','district',1728,0,'W','2018-12-14 00:21:22','2019-02-23 07:29:19','wufengtujiazuzizhixian','五峰土家族自治县',NULL),(1739,'420581','宜都市','111.454367,30.387234','district',1728,0,'Y','2018-12-14 00:21:23','2019-02-23 07:29:19','yidu','宜都',NULL),(1740,'420582','当阳市','111.793419,30.824492','district',1728,0,'D','2018-12-14 00:21:23','2019-02-23 07:29:19','dangyang','当阳',NULL),(1741,'420583','枝江市','111.751799,30.425364','district',1728,0,'Z','2018-12-14 00:21:23','2019-02-23 07:29:19','zhijiang','枝江',NULL),(1742,'420600','襄阳市','112.144146,32.042426','city',1697,0,'X','2018-12-14 00:21:23','2019-02-23 07:29:19','xiangyang','襄阳',NULL),(1743,'420602','襄城区','112.150327,32.015088','district',1742,0,'X','2018-12-14 00:21:23','2019-02-23 07:29:19','xiangchengqu','襄城区',NULL),(1744,'420606','樊城区','112.13957,32.058589','district',1742,0,'F','2018-12-14 00:21:23','2019-02-23 07:29:19','fanchengqu','樊城区',NULL),(1745,'420607','襄州区','112.197378,32.085517','district',1742,0,'X','2018-12-14 00:21:23','2019-02-23 07:29:19','xiangzhouqu','襄州区',NULL),(1746,'420624','南漳县','111.844424,31.77692','district',1742,0,'N','2018-12-14 00:21:23','2019-02-23 07:29:19','nanzhangxian','南漳县',NULL),(1747,'420625','谷城县','111.640147,32.262676','district',1742,0,'G','2018-12-14 00:21:23','2019-02-23 07:29:19','guchengxian','谷城县',NULL),(1748,'420626','保康县','111.262235,31.873507','district',1742,0,'B','2018-12-14 00:21:23','2019-02-23 07:29:19','baokangxian','保康县',NULL),(1749,'420682','老河口市','111.675732,32.385438','district',1742,0,'L','2018-12-14 00:21:23','2019-02-23 07:29:19','laohekou','老河口',NULL),(1750,'420683','枣阳市','112.765268,32.123083','district',1742,0,'Z','2018-12-14 00:21:23','2019-02-23 07:29:19','zaoyang','枣阳',NULL),(1751,'420684','宜城市','112.261441,31.709203','district',1742,0,'Y','2018-12-14 00:21:23','2019-02-23 07:29:19','yicheng','宜城',NULL),(1752,'420700','鄂州市','114.890593,30.396536','city',1697,0,'E','2018-12-14 00:21:23','2019-02-23 07:29:19','ezhou','鄂州',NULL),(1753,'420702','梁子湖区','114.681967,30.098191','district',1752,0,'L','2018-12-14 00:21:23','2019-02-23 07:29:20','liangzihuqu','梁子湖区',NULL),(1754,'420703','华容区','114.74148,30.534468','district',1752,0,'H','2018-12-14 00:21:23','2019-02-23 07:29:20','huarongqu','华容区',NULL),(1755,'420704','鄂城区','114.890012,30.39669','district',1752,0,'E','2018-12-14 00:21:23','2019-02-23 07:29:20','echengqu','鄂城区',NULL),(1756,'420800','荆门市','112.204251,31.03542','city',1697,0,'J','2018-12-14 00:21:23','2019-02-23 07:29:20','jingmen','荆门',NULL),(1757,'420802','东宝区','112.204804,31.033461','district',1756,0,'D','2018-12-14 00:21:23','2019-02-23 07:29:20','dongbaoqu','东宝区',NULL),(1758,'420804','掇刀区','112.198413,30.980798','district',1756,0,'D','2018-12-14 00:21:24','2019-02-23 07:29:20','duodaoqu','掇刀区',NULL),(1759,'420821','京山县','113.114595,31.022458','district',1756,0,'J','2018-12-14 00:21:24','2019-02-23 07:29:20','jingshanxian','京山县',NULL),(1760,'420822','沙洋县','112.595218,30.70359','district',1756,0,'S','2018-12-14 00:21:24','2019-02-23 07:29:20','shayangxian','沙洋县',NULL),(1761,'420881','钟祥市','112.587267,31.165573','district',1756,0,'Z','2018-12-14 00:21:24','2019-02-23 07:29:20','zhongxiang','钟祥',NULL),(1762,'420900','孝感市','113.926655,30.926423','city',1697,0,'X','2018-12-14 00:21:24','2019-02-23 07:29:20','xiaogan','孝感',NULL),(1763,'420902','孝南区','113.925849,30.925966','district',1762,0,'X','2018-12-14 00:21:24','2019-02-23 07:29:20','xiaonanqu','孝南区',NULL),(1764,'420921','孝昌县','113.988964,31.251618','district',1762,0,'X','2018-12-14 00:21:24','2019-02-23 07:29:20','xiaochangxian','孝昌县',NULL),(1765,'420922','大悟县','114.126249,31.565483','district',1762,0,'D','2018-12-14 00:21:24','2019-02-23 07:29:20','dawuxian','大悟县',NULL),(1766,'420923','云梦县','113.750616,31.021691','district',1762,0,'Y','2018-12-14 00:21:24','2019-02-23 07:29:20','yunmengxian','云梦县',NULL),(1767,'420981','应城市','113.573842,30.939038','district',1762,0,'Y','2018-12-14 00:21:24','2019-02-23 07:29:20','yingcheng','应城',NULL),(1768,'420982','安陆市','113.690401,31.26174','district',1762,0,'A','2018-12-14 00:21:24','2019-02-23 07:29:20','anlu','安陆',NULL),(1769,'420984','汉川市','113.835301,30.652165','district',1762,0,'H','2018-12-14 00:21:24','2019-02-23 07:29:20','hanchuan','汉川',NULL),(1770,'421000','荆州市','112.23813,30.326857','city',1697,0,'J','2018-12-14 00:21:24','2019-02-23 07:29:20','jingzhou','荆州',NULL),(1771,'421002','沙市区','112.257433,30.315895','district',1770,0,'S','2018-12-14 00:21:24','2019-02-23 07:29:20','shaqu','沙区',NULL),(1772,'421003','荆州区','112.195354,30.350674','district',1770,0,'J','2018-12-14 00:21:24','2019-02-23 07:29:20','jingzhouqu','荆州区',NULL),(1773,'421022','公安县','112.230179,30.059065','district',1770,0,'G','2018-12-14 00:21:24','2019-02-23 07:29:20','gonganxian','公安县',NULL),(1774,'421023','监利县','112.904344,29.820079','district',1770,0,'J','2018-12-14 00:21:24','2019-02-23 07:29:20','jianlixian','监利县',NULL),(1775,'421024','江陵县','112.41735,30.033919','district',1770,0,'J','2018-12-14 00:21:24','2019-02-23 07:29:20','jianglingxian','江陵县',NULL),(1776,'421081','石首市','112.40887,29.716437','district',1770,0,'S','2018-12-14 00:21:24','2019-02-23 07:29:20','shishou','石首',NULL),(1777,'421083','洪湖市','113.470304,29.81297','district',1770,0,'H','2018-12-14 00:21:25','2019-02-23 07:29:20','honghu','洪湖',NULL),(1778,'421087','松滋市','111.77818,30.176037','district',1770,0,'S','2018-12-14 00:21:25','2019-02-23 07:29:20','songzi','松滋',NULL),(1779,'421100','黄冈市','114.879365,30.447711','city',1697,0,'H','2018-12-14 00:21:25','2019-02-23 07:29:20','huanggang','黄冈',NULL),(1780,'421102','黄州区','114.878934,30.447435','district',1779,0,'H','2018-12-14 00:21:25','2019-02-23 07:29:20','huangzhouqu','黄州区',NULL),(1781,'421121','团风县','114.872029,30.63569','district',1779,0,'T','2018-12-14 00:21:25','2019-02-23 07:29:20','tuanfengxian','团风县',NULL),(1782,'421122','红安县','114.615095,31.284777','district',1779,0,'H','2018-12-14 00:21:25','2019-02-23 07:29:20','honganxian','红安县',NULL),(1783,'421123','罗田县','115.398984,30.781679','district',1779,0,'L','2018-12-14 00:21:25','2019-02-23 07:29:20','luotianxian','罗田县',NULL),(1784,'421124','英山县','115.67753,30.735794','district',1779,0,'Y','2018-12-14 00:21:25','2019-02-23 07:29:20','yingshanxian','英山县',NULL),(1785,'421125','浠水县','115.26344,30.454837','district',1779,0,'X','2018-12-14 00:21:25','2019-02-23 07:29:20','xishuixian','浠水县',NULL),(1786,'421126','蕲春县','115.433964,30.234927','district',1779,0,'Q','2018-12-14 00:21:25','2019-02-23 07:29:20','qichunxian','蕲春县',NULL),(1787,'421127','黄梅县','115.942548,30.075113','district',1779,0,'H','2018-12-14 00:21:25','2019-02-23 07:29:20','huangmeixian','黄梅县',NULL),(1788,'421181','麻城市','115.02541,31.177906','district',1779,0,'M','2018-12-14 00:21:25','2019-02-23 07:29:20','macheng','麻城',NULL),(1789,'421182','武穴市','115.56242,29.849342','district',1779,0,'W','2018-12-14 00:21:25','2019-02-23 07:29:21','wuxue','武穴',NULL),(1790,'421200','咸宁市','114.328963,29.832798','city',1697,0,'X','2018-12-14 00:21:25','2019-02-23 07:29:21','xianning','咸宁',NULL),(1791,'421202','咸安区','114.333894,29.824716','district',1790,0,'X','2018-12-14 00:21:25','2019-02-23 07:29:21','xiananqu','咸安区',NULL),(1792,'421221','嘉鱼县','113.921547,29.973363','district',1790,0,'J','2018-12-14 00:21:25','2019-02-23 07:29:21','jiayuxian','嘉鱼县',NULL),(1793,'421222','通城县','113.814131,29.246076','district',1790,0,'T','2018-12-14 00:21:25','2019-02-23 07:29:21','tongchengxian','通城县',NULL),(1794,'421223','崇阳县','114.049958,29.54101','district',1790,0,'C','2018-12-14 00:21:25','2019-02-23 07:29:21','chongyangxian','崇阳县',NULL),(1795,'421224','通山县','114.493163,29.604455','district',1790,0,'T','2018-12-14 00:21:26','2019-02-23 07:29:21','tongshanxian','通山县',NULL),(1796,'421281','赤壁市','113.88366,29.716879','district',1790,0,'C','2018-12-14 00:21:26','2019-02-23 07:29:21','chibi','赤壁',NULL),(1797,'421300','随州市','113.37377,31.717497','city',1697,0,'S','2018-12-14 00:21:26','2019-02-23 07:29:21','suizhou','随州',NULL),(1798,'421303','曾都区','113.374519,31.717521','district',1797,0,'Z','2018-12-14 00:21:26','2019-02-23 07:29:21','zengduqu','曾都区',NULL),(1799,'421321','随县','113.301384,31.854246','district',1797,0,'S','2018-12-14 00:21:26','2019-02-23 07:29:21','suixian','随县',NULL),(1800,'421381','广水市','113.826601,31.617731','district',1797,0,'G','2018-12-14 00:21:26','2019-02-23 07:29:21','guangshui','广水',NULL),(1801,'422800','恩施土家族苗族自治州','109.48699,30.283114','city',1697,0,'E','2018-12-14 00:21:26','2019-02-23 07:29:21','enshitujiazumiaozuzizhizhou','恩施土家族苗族自治州',NULL),(1802,'422801','恩施市','109.486761,30.282406','district',1801,0,'E','2018-12-14 00:21:26','2019-02-23 07:29:21','enshi','恩施',NULL),(1803,'422802','利川市','108.943491,30.294247','district',1801,0,'L','2018-12-14 00:21:26','2019-02-23 07:29:21','lichuan','利川',NULL),(1804,'422822','建始县','109.723822,30.601632','district',1801,0,'J','2018-12-14 00:21:26','2019-02-23 07:29:21','jianshixian','建始县',NULL),(1805,'422823','巴东县','110.336665,31.041403','district',1801,0,'B','2018-12-14 00:21:26','2019-02-23 07:29:21','badongxian','巴东县',NULL),(1806,'422825','宣恩县','109.482819,29.98867','district',1801,0,'X','2018-12-14 00:21:26','2019-02-23 07:29:21','xuanenxian','宣恩县',NULL),(1807,'422826','咸丰县','109.15041,29.678967','district',1801,0,'X','2018-12-14 00:21:26','2019-02-23 07:29:21','xianfengxian','咸丰县',NULL),(1808,'422827','来凤县','109.408328,29.506945','district',1801,0,'L','2018-12-14 00:21:26','2019-02-23 07:29:21','laifengxian','来凤县',NULL),(1809,'422828','鹤峰县','110.033699,29.887298','district',1801,0,'H','2018-12-14 00:21:26','2019-02-23 07:29:21','hefengxian','鹤峰县',NULL),(1810,'429004','仙桃市','113.453974,30.364953','city',1697,0,'X','2018-12-14 00:21:26','2019-02-23 07:29:21','xiantao','仙桃',NULL),(1811,'429004','三伏潭镇','113.207,30.3395','street',1810,0,'S','2018-12-14 00:21:26','2019-02-23 07:29:21','sanfutanzhen','三伏潭镇',NULL),(1812,'429004','九合垸原种场','113.006,30.2473','street',1810,0,'J','2018-12-14 00:21:26','2019-02-23 07:29:21','jiuheyuanyuanzhongchang','九合垸原种场',NULL),(1813,'429004','五湖渔场','113.783,30.161','street',1810,0,'W','2018-12-14 00:21:26','2019-02-23 07:29:21','wuhuyuchang','五湖渔场',NULL),(1814,'429004','工业园区','113.413,30.3233','street',1810,0,'G','2018-12-14 00:21:27','2019-02-23 07:29:21','gongyeyuanqu','工业园区',NULL),(1815,'429004','干河街道','113.451,30.3772','street',1810,0,'G','2018-12-14 00:21:27','2019-02-23 07:29:21','ganhejiedao','干河街道',NULL),(1816,'429004','张沟镇','113.438,30.2968','street',1810,0,'Z','2018-12-14 00:21:27','2019-02-23 07:29:21','zhanggouzhen','张沟镇',NULL),(1817,'429004','彭场镇','113.446,30.2518','street',1810,0,'P','2018-12-14 00:21:27','2019-02-23 07:29:21','pengchangzhen','彭场镇',NULL),(1818,'429004','排湖风景区','113.223,30.2987','street',1810,0,'P','2018-12-14 00:21:27','2019-02-23 07:29:21','paihufengjingqu','排湖风景区',NULL),(1819,'429004','杨林尾镇','113.561,30.2014','street',1810,0,'Y','2018-12-14 00:21:27','2019-02-23 07:29:21','yanglinweizhen','杨林尾镇',NULL),(1820,'429004','毛嘴镇','113.045,30.4188','street',1810,0,'M','2018-12-14 00:21:27','2019-02-23 07:29:21','maozuizhen','毛嘴镇',NULL),(1821,'429004','沔城回族镇','113.201,30.1921','street',1810,0,'M','2018-12-14 00:21:27','2019-02-23 07:29:21','mianchenghuizuzhen','沔城回族镇',NULL),(1822,'429004','沙嘴街道','113.441,30.3596','street',1810,0,'S','2018-12-14 00:21:27','2019-02-23 07:29:21','shazuijiedao','沙嘴街道',NULL),(1823,'429004','沙湖原种场','113.643,30.1482','street',1810,0,'S','2018-12-14 00:21:27','2019-02-23 07:29:21','shahuyuanzhongchang','沙湖原种场',NULL),(1824,'429004','沙湖镇','113.6,30.1698','street',1810,0,'S','2018-12-14 00:21:27','2019-02-23 07:29:21','shahuzhen','沙湖镇',NULL),(1825,'429004','畜禽良种场','113.751,30.1779','street',1810,0,'C','2018-12-14 00:21:27','2019-02-23 07:29:22','chuqinliangzhongchang','畜禽良种场',NULL),(1826,'429004','胡场镇','113.29,30.4278','street',1810,0,'H','2018-12-14 00:21:27','2019-02-23 07:29:22','huchangzhen','胡场镇',NULL),(1827,'429004','西流河镇','113.761,30.297','street',1810,0,'X','2018-12-14 00:21:27','2019-02-23 07:29:22','xiliuhezhen','西流河镇',NULL),(1828,'429004','豆河镇','113,30.37','street',1810,0,'D','2018-12-14 00:21:27','2019-02-23 07:29:22','douhezhen','豆河镇',NULL),(1829,'429004','赵西垸林场','113.027,30.285','street',1810,0,'Z','2018-12-14 00:21:27','2019-02-23 07:29:22','zhaoxiyuanlinchang','赵西垸林场',NULL),(1830,'429004','通海口镇','113.206,30.2722','street',1810,0,'T','2018-12-14 00:21:27','2019-02-23 07:29:22','tonghaikouzhen','通海口镇',NULL),(1831,'429004','郑场镇','112.979,30.4707','street',1810,0,'Z','2018-12-14 00:21:27','2019-02-23 07:29:22','zhengchangzhen','郑场镇',NULL),(1832,'429004','郭河镇','113.304,30.3027','street',1810,0,'G','2018-12-14 00:21:28','2019-02-23 07:29:22','guohezhen','郭河镇',NULL),(1833,'429004','长倘口镇','113.611,30.4752','street',1810,0,'Z','2018-12-14 00:21:28','2019-02-23 07:29:22','zhangtangkouzhen','长倘口镇',NULL),(1834,'429004','陈场镇','113.111,30.2879','street',1810,0,'C','2018-12-14 00:21:28','2019-02-23 07:29:22','chenchangzhen','陈场镇',NULL),(1835,'429004','龙华山街道','113.46,30.3649','street',1810,0,'L','2018-12-14 00:21:28','2019-02-23 07:29:22','longhuashanjiedao','龙华山街道',NULL),(1836,'429005','潜江市','112.896866,30.421215','city',1697,0,'Q','2018-12-14 00:21:28','2019-02-23 07:29:22','qianjiang','潜江',NULL),(1837,'429005','后湖管理区','112.768,30.4049','street',1836,0,'H','2018-12-14 00:21:28','2019-02-23 07:29:22','houhuguanliqu','后湖管理区',NULL),(1838,'429005','周矶管理区','112.826,30.4567','street',1836,0,'Z','2018-12-14 00:21:28','2019-02-23 07:29:22','zhoujiguanliqu','周矶管理区',NULL),(1839,'429005','周矶街道','112.818,30.4576','street',1836,0,'Z','2018-12-14 00:21:28','2019-02-23 07:29:22','zhoujijiedao','周矶街道',NULL),(1840,'429005','园林街道','112.91,30.377','street',1836,0,'Y','2018-12-14 00:21:28','2019-02-23 07:29:22','yuanlinjiedao','园林街道',NULL),(1841,'429005','广华街道','112.666,30.4633','street',1836,0,'G','2018-12-14 00:21:28','2019-02-23 07:29:22','guanghuajiedao','广华街道',NULL),(1842,'429005','张金镇','112.577,30.2389','street',1836,0,'Z','2018-12-14 00:21:28','2019-02-23 07:29:22','zhangjinzhen','张金镇',NULL),(1843,'429005','总口管理区','112.89,30.2581','street',1836,0,'Z','2018-12-14 00:21:28','2019-02-23 07:29:22','zongkouguanliqu','总口管理区',NULL),(1844,'429005','杨市街道','112.915,30.3835','street',1836,0,'Y','2018-12-14 00:21:28','2019-02-23 07:29:22','yangjiedao','杨街道',NULL),(1845,'429005','江汉石油管理局','112.793,30.4635','street',1836,0,'J','2018-12-14 00:21:28','2019-02-23 07:29:22','jianghanshiyouguanliju','江汉石油管理局',NULL),(1846,'429005','泰丰街道','112.981,30.4167','street',1836,0,'T','2018-12-14 00:21:28','2019-02-23 07:29:22','taifengjiedao','泰丰街道',NULL),(1847,'429005','浩口原种场','112.643,30.3784','street',1836,0,'H','2018-12-14 00:21:28','2019-02-23 07:29:22','haokouyuanzhongchang','浩口原种场',NULL),(1848,'429005','浩口镇','112.65,30.3695','street',1836,0,'H','2018-12-14 00:21:29','2019-02-23 07:29:22','haokouzhen','浩口镇',NULL),(1849,'429005','渔洋镇','112.966,30.2392','street',1836,0,'Y','2018-12-14 00:21:29','2019-02-23 07:29:22','yuyangzhen','渔洋镇',NULL),(1850,'429005','潜江经济开发区','112.883,30.4825','street',1836,0,'Q','2018-12-14 00:21:29','2019-02-23 07:29:22','qianjiangjingjikaifaqu','潜江经济开发区',NULL),(1851,'429005','熊口管理区','112.802,30.195','street',1836,0,'X','2018-12-14 00:21:29','2019-02-23 07:29:22','xiongkouguanliqu','熊口管理区',NULL),(1852,'429005','熊口镇','112.724,30.3404','street',1836,0,'X','2018-12-14 00:21:29','2019-02-23 07:29:22','xiongkouzhen','熊口镇',NULL),(1853,'429005','王场镇','112.819,30.4906','street',1836,0,'W','2018-12-14 00:21:29','2019-02-23 07:29:22','wangchangzhen','王场镇',NULL),(1854,'429005','白鹭湖管理区','112.716,30.1788','street',1836,0,'B','2018-12-14 00:21:29','2019-02-23 07:29:22','bailuhuguanliqu','白鹭湖管理区',NULL),(1855,'429005','积玉口镇','112.721,30.4185','street',1836,0,'J','2018-12-14 00:21:29','2019-02-23 07:29:22','jiyukouzhen','积玉口镇',NULL),(1856,'429005','竹根滩镇','112.979,30.4716','street',1836,0,'Z','2018-12-14 00:21:29','2019-02-23 07:29:22','zhugentanzhen','竹根滩镇',NULL),(1857,'429005','老新镇','112.81,30.2185','street',1836,0,'L','2018-12-14 00:21:29','2019-02-23 07:29:22','laoxinzhen','老新镇',NULL),(1858,'429005','运粮湖管理区','112.582,30.252','street',1836,0,'Y','2018-12-14 00:21:29','2019-02-23 07:29:22','yunlianghuguanliqu','运粮湖管理区',NULL),(1859,'429005','高场街道','112.775,30.4076','street',1836,0,'G','2018-12-14 00:21:29','2019-02-23 07:29:23','gaochangjiedao','高场街道',NULL),(1860,'429005','高石碑镇','112.626,30.6203','street',1836,0,'G','2018-12-14 00:21:29','2019-02-23 07:29:23','gaoshibeizhen','高石碑镇',NULL),(1861,'429005','龙湾镇','112.69,30.2848','street',1836,0,'L','2018-12-14 00:21:29','2019-02-23 07:29:23','longwanzhen','龙湾镇',NULL),(1862,'429006','天门市','113.165862,30.653061','city',1697,0,'T','2018-12-14 00:21:29','2019-02-23 07:29:23','tianmen','天门',NULL),(1863,'429006','九真镇','113.206,30.8245','street',1862,0,'J','2018-12-14 00:21:30','2019-02-23 07:29:23','jiuzhenzhen','九真镇',NULL),(1864,'429006','佛子山镇','112.974,30.7608','street',1862,0,'F','2018-12-14 00:21:30','2019-02-23 07:29:23','fozishanzhen','佛子山镇',NULL),(1865,'429006','侨乡街道开发区','113.134,30.652','street',1862,0,'Q','2018-12-14 00:21:30','2019-02-23 07:29:23','qiaoxiangjiedaokaifaqu','侨乡街道开发区',NULL),(1866,'429006','净潭乡','113.451,30.6464','street',1862,0,'J','2018-12-14 00:21:30','2019-02-23 07:29:23','jingtanxiang','净潭乡',NULL),(1867,'429006','卢市镇','113.397,30.6596','street',1862,0,'L','2018-12-14 00:21:30','2019-02-23 07:29:23','luzhen','卢镇',NULL),(1868,'429006','多宝镇','112.614,30.7034','street',1862,0,'D','2018-12-14 00:21:30','2019-02-23 07:29:23','duobaozhen','多宝镇',NULL),(1869,'429006','多祥镇','113.331,30.4446','street',1862,0,'D','2018-12-14 00:21:30','2019-02-23 07:29:23','duoxiangzhen','多祥镇',NULL),(1870,'429006','小板镇','113.264,30.6151','street',1862,0,'X','2018-12-14 00:21:30','2019-02-23 07:29:23','xiaobanzhen','小板镇',NULL),(1871,'429006','岳口镇','113.105,30.5868','street',1862,0,'Y','2018-12-14 00:21:30','2019-02-23 07:29:23','yuekouzhen','岳口镇',NULL),(1872,'429006','干驿镇','113.451,30.503','street',1862,0,'G','2018-12-14 00:21:30','2019-02-23 07:29:23','ganyizhen','干驿镇',NULL),(1873,'429006','张港镇','112.801,30.5529','street',1862,0,'Z','2018-12-14 00:21:30','2019-02-23 07:29:23','zhanggangzhen','张港镇',NULL),(1874,'429006','彭市镇','113.157,30.4315','street',1862,0,'P','2018-12-14 00:21:30','2019-02-23 07:29:23','pengzhen','彭镇',NULL),(1875,'429006','拖市镇','112.856,30.7135','street',1862,0,'T','2018-12-14 00:21:30','2019-02-23 07:29:23','tuozhen','拖镇',NULL),(1876,'429006','杨林街道','113.265,30.6856','street',1862,0,'Y','2018-12-14 00:21:30','2019-02-23 07:29:23','yanglinjiedao','杨林街道',NULL),(1877,'429006','横林镇','113.215,30.5643','street',1862,0,'H','2018-12-14 00:21:30','2019-02-23 07:29:23','henglinzhen','横林镇',NULL),(1878,'429006','汪场镇','112.979,30.638','street',1862,0,'W','2018-12-14 00:21:30','2019-02-23 07:29:23','wangchangzhen','汪场镇',NULL),(1879,'429006','沉湖管委会','113.444,30.4698','street',1862,0,'C','2018-12-14 00:21:30','2019-02-23 07:29:23','chenhuguanweihui','沉湖管委会',NULL),(1880,'429006','渔薪镇','112.879,30.6744','street',1862,0,'Y','2018-12-14 00:21:30','2019-02-23 07:29:23','yuxinzhen','渔薪镇',NULL),(1881,'429006','白茅湖农场','113.063,30.5868','street',1862,0,'B','2018-12-14 00:21:30','2019-02-23 07:29:23','baimaohunongchang','白茅湖农场',NULL),(1882,'429006','皂市镇','113.223,30.7957','street',1862,0,'Z','2018-12-14 00:21:30','2019-02-23 07:29:23','zaozhen','皂镇',NULL),(1883,'429006','石家河镇','113.076,30.8211','street',1862,0,'S','2018-12-14 00:21:30','2019-02-23 07:29:23','shijiahezhen','石家河镇',NULL),(1884,'429006','竟陵街道','113.183,30.7066','street',1862,0,'J','2018-12-14 00:21:30','2019-02-23 07:29:23','jinglingjiedao','竟陵街道',NULL),(1885,'429006','胡市镇','113.422,30.802','street',1862,0,'H','2018-12-14 00:21:31','2019-02-23 07:29:23','huzhen','胡镇',NULL),(1886,'429006','蒋场镇','112.927,30.646','street',1862,0,'J','2018-12-14 00:21:31','2019-02-23 07:29:23','jiangchangzhen','蒋场镇',NULL),(1887,'429006','蒋湖农场','112.802,30.6364','street',1862,0,'J','2018-12-14 00:21:31','2019-02-23 07:29:23','jianghunongchang','蒋湖农场',NULL),(1888,'429006','马湾镇','113.312,30.5993','street',1862,0,'M','2018-12-14 00:21:31','2019-02-23 07:29:23','mawanzhen','马湾镇',NULL),(1889,'429006','麻洋镇','113.309,30.5249','street',1862,0,'M','2018-12-14 00:21:31','2019-02-23 07:29:23','mayangzhen','麻洋镇',NULL),(1890,'429006','黄潭镇','113.039,30.6922','street',1862,0,'H','2018-12-14 00:21:31','2019-02-23 07:29:23','huangtanzhen','黄潭镇',NULL),(1891,'429021','神农架林区','110.671525,31.744449','city',1697,0,'S','2018-12-14 00:21:31','2019-02-23 07:29:23','shennongjialinqu','神农架林区',NULL),(1892,'429021','下谷坪土家族乡','110.113,31.4153','street',1891,0,'X','2018-12-14 00:21:31','2019-02-23 07:29:23','xiagupingtujiazuxiang','下谷坪土家族乡',NULL),(1893,'429021','九湖镇','110.062,31.4095','street',1891,0,'J','2018-12-14 00:21:31','2019-02-23 07:29:23','jiuhuzhen','九湖镇',NULL),(1894,'429021','宋洛乡','110.59,31.7303','street',1891,0,'S','2018-12-14 00:21:31','2019-02-23 07:29:24','songluoxiang','宋洛乡',NULL),(1895,'429021','新华镇','110.842,31.6218','street',1891,0,'X','2018-12-14 00:21:31','2019-02-23 07:29:24','xinhuazhen','新华镇',NULL),(1896,'429021','木鱼镇','110.312,31.3933','street',1891,0,'M','2018-12-14 00:21:31','2019-02-23 07:29:24','muyuzhen','木鱼镇',NULL),(1897,'429021','松柏镇','110.609,31.7041','street',1891,0,'S','2018-12-14 00:21:31','2019-02-23 07:29:24','songbaizhen','松柏镇',NULL),(1898,'429021','红坪镇','110.196,31.4718','street',1891,0,'H','2018-12-14 00:21:31','2019-02-23 07:29:24','hongpingzhen','红坪镇',NULL),(1899,'429021','阳日镇','110.763,31.677','street',1891,0,'Y','2018-12-14 00:21:31','2019-02-23 07:29:24','yangrizhen','阳日镇',NULL),(1900,'430000','湖南省','112.982279,28.19409','province',0,6001,'H','2018-12-14 00:21:31','2019-02-23 07:29:24','hunansheng','湖南省',NULL),(1901,'430100','长沙市','112.982279,28.19409','city',1900,0,'C','2018-12-14 00:21:31','2019-02-23 07:29:24','changsha','长沙',NULL),(1902,'430102','芙蓉区','112.988094,28.193106','district',1901,0,'F','2018-12-14 00:21:31','2019-02-23 07:29:24','furongqu','芙蓉区',NULL),(1903,'430103','天心区','112.97307,28.192375','district',1901,0,'T','2018-12-14 00:21:31','2019-02-23 07:29:24','tianxinqu','天心区',NULL),(1904,'430104','岳麓区','112.911591,28.213044','district',1901,0,'Y','2018-12-14 00:21:31','2019-02-23 07:29:24','yueluqu','岳麓区',NULL),(1905,'430105','开福区','112.985525,28.201336','district',1901,0,'K','2018-12-14 00:21:32','2019-02-23 07:29:24','kaifuqu','开福区',NULL),(1906,'430111','雨花区','113.016337,28.109937','district',1901,0,'Y','2018-12-14 00:21:32','2019-02-23 07:29:24','yuhuaqu','雨花区',NULL),(1907,'430112','望城区','112.819549,28.347458','district',1901,0,'W','2018-12-14 00:21:32','2019-02-23 07:29:24','wangchengqu','望城区',NULL),(1908,'430121','长沙县','113.080098,28.237888','district',1901,0,'C','2018-12-14 00:21:32','2019-02-23 07:29:24','changshaxian','长沙县',NULL),(1909,'430181','浏阳市','113.633301,28.141112','district',1901,0,'L','2018-12-14 00:21:32','2019-02-23 07:29:24','liuyang','浏阳',NULL),(1910,'430182','宁乡市','112.553182,28.253928','district',1901,0,'N','2018-12-14 00:21:32','2019-02-23 07:29:24','ningxiang','宁乡',NULL),(1911,'430200','株洲市','113.151737,27.835806','city',1900,0,'Z','2018-12-14 00:21:32','2019-02-23 07:29:24','zhuzhou','株洲',NULL),(1912,'430202','荷塘区','113.162548,27.833036','district',1911,0,'H','2018-12-14 00:21:32','2019-02-23 07:29:24','hetangqu','荷塘区',NULL),(1913,'430203','芦淞区','113.155169,27.827246','district',1911,0,'L','2018-12-14 00:21:32','2019-02-23 07:29:24','lusongqu','芦淞区',NULL),(1914,'430204','石峰区','113.11295,27.871945','district',1911,0,'S','2018-12-14 00:21:32','2019-02-23 07:29:24','shifengqu','石峰区',NULL),(1915,'430211','天元区','113.136252,27.826909','district',1911,0,'T','2018-12-14 00:21:32','2019-02-23 07:29:24','tianyuanqu','天元区',NULL),(1916,'430221','株洲县','113.146176,27.705844','district',1911,0,'Z','2018-12-14 00:21:32','2019-02-23 07:29:24','zhuzhouxian','株洲县',NULL),(1917,'430223','攸县','113.345774,27.000071','district',1911,0,'Y','2018-12-14 00:21:32','2019-02-23 07:29:24','youxian','攸县',NULL),(1918,'430224','茶陵县','113.546509,26.789534','district',1911,0,'C','2018-12-14 00:21:32','2019-02-23 07:29:24','chalingxian','茶陵县',NULL),(1919,'430225','炎陵县','113.776884,26.489459','district',1911,0,'Y','2018-12-14 00:21:32','2019-02-23 07:29:24','yanlingxian','炎陵县',NULL),(1920,'430281','醴陵市','113.507157,27.657873','district',1911,0,'L','2018-12-14 00:21:32','2019-02-23 07:29:24','liling','醴陵',NULL),(1921,'430300','湘潭市','112.944052,27.82973','city',1900,0,'X','2018-12-14 00:21:32','2019-02-23 07:29:24','xiangtan','湘潭',NULL),(1922,'430302','雨湖区','112.907427,27.86077','district',1921,0,'Y','2018-12-14 00:21:32','2019-02-23 07:29:24','yuhuqu','雨湖区',NULL),(1923,'430304','岳塘区','112.927707,27.828854','district',1921,0,'Y','2018-12-14 00:21:32','2019-02-23 07:29:24','yuetangqu','岳塘区',NULL),(1924,'430321','湘潭县','112.952829,27.778601','district',1921,0,'X','2018-12-14 00:21:32','2019-02-23 07:29:24','xiangtanxian','湘潭县',NULL),(1925,'430381','湘乡市','112.525217,27.734918','district',1921,0,'X','2018-12-14 00:21:33','2019-02-23 07:29:24','xiangxiang','湘乡',NULL),(1926,'430382','韶山市','112.52848,27.922682','district',1921,0,'S','2018-12-14 00:21:33','2019-02-23 07:29:24','shaoshan','韶山',NULL),(1927,'430400','衡阳市','112.607693,26.900358','city',1900,0,'H','2018-12-14 00:21:33','2019-02-23 07:29:24','hengyang','衡阳',NULL),(1928,'430405','珠晖区','112.626324,26.891063','district',1927,0,'Z','2018-12-14 00:21:33','2019-02-23 07:29:24','zhuhuiqu','珠晖区',NULL),(1929,'430406','雁峰区','112.612241,26.893694','district',1927,0,'Y','2018-12-14 00:21:33','2019-02-23 07:29:24','yanfengqu','雁峰区',NULL),(1930,'430407','石鼓区','112.607635,26.903908','district',1927,0,'D','2018-12-14 00:21:33','2019-02-23 07:29:25','danguqu','石鼓区',NULL),(1931,'430408','蒸湘区','112.570608,26.89087','district',1927,0,'Z','2018-12-14 00:21:33','2019-02-23 07:29:25','zhengxiangqu','蒸湘区',NULL),(1932,'430412','南岳区','112.734147,27.240536','district',1927,0,'N','2018-12-14 00:21:33','2019-02-23 07:29:25','nanyuequ','南岳区',NULL),(1933,'430421','衡阳县','112.379643,26.962388','district',1927,0,'H','2018-12-14 00:21:33','2019-02-23 07:29:25','hengyangxian','衡阳县',NULL),(1934,'430422','衡南县','112.677459,26.739973','district',1927,0,'H','2018-12-14 00:21:33','2019-02-23 07:29:25','hengnanxian','衡南县',NULL),(1935,'430423','衡山县','112.86971,27.234808','district',1927,0,'H','2018-12-14 00:21:33','2019-02-23 07:29:25','hengshanxian','衡山县',NULL),(1936,'430424','衡东县','112.950412,27.083531','district',1927,0,'H','2018-12-14 00:21:33','2019-02-23 07:29:25','hengdongxian','衡东县',NULL),(1937,'430426','祁东县','112.111192,26.787109','district',1927,0,'Q','2018-12-14 00:21:33','2019-02-23 07:29:25','qidongxian','祁东县',NULL),(1938,'430481','耒阳市','112.847215,26.414162','district',1927,0,'L','2018-12-14 00:21:33','2019-02-23 07:29:25','leiyang','耒阳',NULL),(1939,'430482','常宁市','112.396821,26.406773','district',1927,0,'C','2018-12-14 00:21:33','2019-02-23 07:29:25','changning','常宁',NULL),(1940,'430500','邵阳市','111.46923,27.237842','city',1900,0,'S','2018-12-14 00:21:33','2019-02-23 07:29:25','shaoyang','邵阳',NULL),(1941,'430502','双清区','111.479756,27.240001','district',1940,0,'S','2018-12-14 00:21:33','2019-02-23 07:29:25','shuangqingqu','双清区',NULL),(1942,'430503','大祥区','111.462968,27.233593','district',1940,0,'D','2018-12-14 00:21:33','2019-02-23 07:29:25','daxiangqu','大祥区',NULL),(1943,'430511','北塔区','111.452315,27.245688','district',1940,0,'B','2018-12-14 00:21:33','2019-02-23 07:29:25','beitaqu','北塔区',NULL),(1944,'430521','邵东县','111.743168,27.257273','district',1940,0,'S','2018-12-14 00:21:33','2019-02-23 07:29:25','shaodongxian','邵东县',NULL),(1945,'430522','新邵县','111.459762,27.311429','district',1940,0,'X','2018-12-14 00:21:33','2019-02-23 07:29:25','xinshaoxian','新邵县',NULL),(1946,'430523','邵阳县','111.2757,26.989713','district',1940,0,'S','2018-12-14 00:21:34','2019-02-23 07:29:25','shaoyangxian','邵阳县',NULL),(1947,'430524','隆回县','111.038785,27.116002','district',1940,0,'L','2018-12-14 00:21:34','2019-02-23 07:29:25','longhuixian','隆回县',NULL),(1948,'430525','洞口县','110.579212,27.062286','district',1940,0,'D','2018-12-14 00:21:34','2019-02-23 07:29:25','dongkouxian','洞口县',NULL),(1949,'430527','绥宁县','110.155075,26.580622','district',1940,0,'S','2018-12-14 00:21:34','2019-02-23 07:29:25','suiningxian','绥宁县',NULL),(1950,'430528','新宁县','110.859115,26.438912','district',1940,0,'X','2018-12-14 00:21:34','2019-02-23 07:29:25','xinningxian','新宁县',NULL),(1951,'430529','城步苗族自治县','110.313226,26.363575','district',1940,0,'C','2018-12-14 00:21:34','2019-02-23 07:29:25','chengbumiaozuzizhixian','城步苗族自治县',NULL),(1952,'430581','武冈市','110.636804,26.732086','district',1940,0,'W','2018-12-14 00:21:34','2019-02-23 07:29:25','wugang','武冈',NULL),(1953,'430600','岳阳市','113.132855,29.37029','city',1900,0,'Y','2018-12-14 00:21:34','2019-02-23 07:29:25','yueyang','岳阳',NULL),(1954,'430602','岳阳楼区','113.120751,29.366784','district',1953,0,'Y','2018-12-14 00:21:34','2019-02-23 07:29:25','yueyanglouqu','岳阳楼区',NULL),(1955,'430603','云溪区','113.27387,29.473395','district',1953,0,'Y','2018-12-14 00:21:34','2019-02-23 07:29:25','yunxiqu','云溪区',NULL),(1956,'430611','君山区','113.004082,29.438062','district',1953,0,'J','2018-12-14 00:21:34','2019-02-23 07:29:25','junshanqu','君山区',NULL),(1957,'430621','岳阳县','113.116073,29.144843','district',1953,0,'Y','2018-12-14 00:21:34','2019-02-23 07:29:25','yueyangxian','岳阳县',NULL),(1958,'430623','华容县','112.559369,29.524107','district',1953,0,'H','2018-12-14 00:21:34','2019-02-23 07:29:25','huarongxian','华容县',NULL),(1959,'430624','湘阴县','112.889748,28.677498','district',1953,0,'X','2018-12-14 00:21:34','2019-02-23 07:29:25','xiangyinxian','湘阴县',NULL),(1960,'430626','平江县','113.593751,28.701523','district',1953,0,'P','2018-12-14 00:21:34','2019-02-23 07:29:25','pingjiangxian','平江县',NULL),(1961,'430681','汨罗市','113.079419,28.803149','district',1953,0,'M','2018-12-14 00:21:34','2019-02-23 07:29:25','miluo','汨罗',NULL),(1962,'430682','临湘市','113.450809,29.471594','district',1953,0,'L','2018-12-14 00:21:34','2019-02-23 07:29:25','linxiang','临湘',NULL),(1963,'430700','常德市','111.691347,29.040225','city',1900,0,'C','2018-12-14 00:21:34','2019-02-23 07:29:25','changde','常德',NULL),(1964,'430702','武陵区','111.690718,29.040477','district',1963,0,'W','2018-12-14 00:21:34','2019-02-23 07:29:25','wulingqu','武陵区',NULL),(1965,'430703','鼎城区','111.685327,29.014426','district',1963,0,'D','2018-12-14 00:21:34','2019-02-23 07:29:26','dingchengqu','鼎城区',NULL),(1966,'430721','安乡县','112.172289,29.414483','district',1963,0,'A','2018-12-14 00:21:34','2019-02-23 07:29:26','anxiangxian','安乡县',NULL),(1967,'430722','汉寿县','111.968506,28.907319','district',1963,0,'H','2018-12-14 00:21:35','2019-02-23 07:29:26','hanshouxian','汉寿县',NULL),(1968,'430723','澧县','111.761682,29.64264','district',1963,0,'L','2018-12-14 00:21:35','2019-02-23 07:29:26','lixian','澧县',NULL),(1969,'430724','临澧县','111.645602,29.443217','district',1963,0,'L','2018-12-14 00:21:35','2019-02-23 07:29:26','linlixian','临澧县',NULL),(1970,'430725','桃源县','111.484503,28.902734','district',1963,0,'T','2018-12-14 00:21:35','2019-02-23 07:29:26','taoyuanxian','桃源县',NULL),(1971,'430726','石门县','111.379087,29.584703','district',1963,0,'S','2018-12-14 00:21:35','2019-02-23 07:29:26','shimenxian','石门县',NULL),(1972,'430781','津市市','111.879609,29.630867','district',1963,0,'J','2018-12-14 00:21:35','2019-02-23 07:29:26','jin','津',NULL),(1973,'430800','张家界市','110.479921,29.127401','city',1900,0,'Z','2018-12-14 00:21:35','2019-02-23 07:29:26','zhangjiajie','张家界',NULL),(1974,'430802','永定区','110.484559,29.125961','district',1973,0,'Y','2018-12-14 00:21:35','2019-02-23 07:29:26','yongdingqu','永定区',NULL),(1975,'430811','武陵源区','110.54758,29.347827','district',1973,0,'W','2018-12-14 00:21:35','2019-02-23 07:29:26','wulingyuanqu','武陵源区',NULL),(1976,'430821','慈利县','111.132702,29.423876','district',1973,0,'C','2018-12-14 00:21:35','2019-02-23 07:29:26','cilixian','慈利县',NULL),(1977,'430822','桑植县','110.164039,29.399939','district',1973,0,'S','2018-12-14 00:21:35','2019-02-23 07:29:26','sangzhixian','桑植县',NULL),(1978,'430900','益阳市','112.355042,28.570066','city',1900,0,'Y','2018-12-14 00:21:35','2019-02-23 07:29:26','yiyang','益阳',NULL),(1979,'430902','资阳区','112.33084,28.592771','district',1978,0,'Z','2018-12-14 00:21:35','2019-02-23 07:29:26','ziyangqu','资阳区',NULL),(1980,'430903','赫山区','112.360946,28.568327','district',1978,0,'H','2018-12-14 00:21:35','2019-02-23 07:29:26','heshanqu','赫山区',NULL),(1981,'430921','南县','112.410399,29.372181','district',1978,0,'N','2018-12-14 00:21:35','2019-02-23 07:29:26','nanxian','南县',NULL),(1982,'430922','桃江县','112.139732,28.520993','district',1978,0,'T','2018-12-14 00:21:35','2019-02-23 07:29:26','taojiangxian','桃江县',NULL),(1983,'430923','安化县','111.221824,28.377421','district',1978,0,'A','2018-12-14 00:21:35','2019-02-23 07:29:26','anhuaxian','安化县',NULL),(1984,'430981','沅江市','112.361088,28.839713','district',1978,0,'Y','2018-12-14 00:21:35','2019-02-23 07:29:26','yuanjiang','沅江',NULL),(1985,'431000','郴州市','113.032067,25.793589','city',1900,0,'C','2018-12-14 00:21:35','2019-02-23 07:29:26','chenzhou','郴州',NULL),(1986,'431002','北湖区','113.032208,25.792628','district',1985,0,'B','2018-12-14 00:21:35','2019-02-23 07:29:26','beihuqu','北湖区',NULL),(1987,'431003','苏仙区','113.038698,25.793157','district',1985,0,'S','2018-12-14 00:21:35','2019-02-23 07:29:26','suxianqu','苏仙区',NULL),(1988,'431021','桂阳县','112.734466,25.737447','district',1985,0,'G','2018-12-14 00:21:36','2019-02-23 07:29:26','guiyangxian','桂阳县',NULL),(1989,'431022','宜章县','112.947884,25.394345','district',1985,0,'Y','2018-12-14 00:21:36','2019-02-23 07:29:26','yizhangxian','宜章县',NULL),(1990,'431023','永兴县','113.114819,26.129392','district',1985,0,'Y','2018-12-14 00:21:36','2019-02-23 07:29:26','yongxingxian','永兴县',NULL),(1991,'431024','嘉禾县','112.370618,25.587309','district',1985,0,'J','2018-12-14 00:21:36','2019-02-23 07:29:26','jiahexian','嘉禾县',NULL),(1992,'431025','临武县','112.564589,25.279119','district',1985,0,'L','2018-12-14 00:21:36','2019-02-23 07:29:26','linwuxian','临武县',NULL),(1993,'431026','汝城县','113.685686,25.553759','district',1985,0,'R','2018-12-14 00:21:36','2019-02-23 07:29:26','ruchengxian','汝城县',NULL),(1994,'431027','桂东县','113.945879,26.073917','district',1985,0,'G','2018-12-14 00:21:36','2019-02-23 07:29:26','guidongxian','桂东县',NULL),(1995,'431028','安仁县','113.27217,26.708625','district',1985,0,'A','2018-12-14 00:21:36','2019-02-23 07:29:26','anrenxian','安仁县',NULL),(1996,'431081','资兴市','113.23682,25.974152','district',1985,0,'Z','2018-12-14 00:21:36','2019-02-23 07:29:26','zixing','资兴',NULL),(1997,'431100','永州市','111.608019,26.434516','city',1900,0,'Y','2018-12-14 00:21:36','2019-02-23 07:29:26','yongzhou','永州',NULL),(1998,'431102','零陵区','111.626348,26.223347','district',1997,0,'L','2018-12-14 00:21:36','2019-02-23 07:29:26','linglingqu','零陵区',NULL),(1999,'431103','冷水滩区','111.607156,26.434364','district',1997,0,'L','2018-12-14 00:21:36','2019-02-23 07:29:26','lengshuitanqu','冷水滩区',NULL),(2000,'431121','祁阳县','111.85734,26.585929','district',1997,0,'Q','2018-12-14 00:21:36','2019-02-23 07:29:27','qiyangxian','祁阳县',NULL),(2001,'431122','东安县','111.313035,26.397278','district',1997,0,'D','2018-12-14 00:21:36','2019-02-23 07:29:27','donganxian','东安县',NULL),(2002,'431123','双牌县','111.662146,25.959397','district',1997,0,'S','2018-12-14 00:21:36','2019-02-23 07:29:27','shuangpaixian','双牌县',NULL),(2003,'431124','道县','111.591614,25.518444','district',1997,0,'D','2018-12-14 00:21:36','2019-02-23 07:29:27','daoxian','道县',NULL),(2004,'431125','江永县','111.346803,25.268154','district',1997,0,'J','2018-12-14 00:21:36','2019-02-23 07:29:27','jiangyongxian','江永县',NULL),(2005,'431126','宁远县','111.944529,25.584112','district',1997,0,'N','2018-12-14 00:21:36','2019-02-23 07:29:27','ningyuanxian','宁远县',NULL),(2006,'431127','蓝山县','112.194195,25.375255','district',1997,0,'L','2018-12-14 00:21:36','2019-02-23 07:29:27','lanshanxian','蓝山县',NULL),(2007,'431128','新田县','112.220341,25.906927','district',1997,0,'X','2018-12-14 00:21:36','2019-02-23 07:29:27','xintianxian','新田县',NULL),(2008,'431129','江华瑶族自治县','111.577276,25.182596','district',1997,0,'J','2018-12-14 00:21:36','2019-02-23 07:29:27','jianghuayaozuzizhixian','江华瑶族自治县',NULL),(2009,'431200','怀化市','109.97824,27.550082','city',1900,0,'H','2018-12-14 00:21:36','2019-02-23 07:29:27','huaihua','怀化',NULL),(2010,'431202','鹤城区','109.982242,27.548474','district',2009,0,'H','2018-12-14 00:21:37','2019-02-23 07:29:27','hechengqu','鹤城区',NULL),(2011,'431221','中方县','109.948061,27.43736','district',2009,0,'Z','2018-12-14 00:21:37','2019-02-23 07:29:27','zhongfangxian','中方县',NULL),(2012,'431222','沅陵县','110.399161,28.455554','district',2009,0,'Y','2018-12-14 00:21:37','2019-02-23 07:29:27','yuanlingxian','沅陵县',NULL),(2013,'431223','辰溪县','110.196953,28.005474','district',2009,0,'C','2018-12-14 00:21:37','2019-02-23 07:29:27','chenxixian','辰溪县',NULL),(2014,'431224','溆浦县','110.593373,27.903802','district',2009,0,'X','2018-12-14 00:21:37','2019-02-23 07:29:27','xupuxian','溆浦县',NULL),(2015,'431225','会同县','109.720785,26.870789','district',2009,0,'H','2018-12-14 00:21:37','2019-02-23 07:29:27','huitongxian','会同县',NULL),(2016,'431226','麻阳苗族自治县','109.802807,27.865991','district',2009,0,'M','2018-12-14 00:21:37','2019-02-23 07:29:27','mayangmiaozuzizhixian','麻阳苗族自治县',NULL),(2017,'431227','新晃侗族自治县','109.174443,27.359897','district',2009,0,'X','2018-12-14 00:21:37','2019-02-23 07:29:27','xinhuangdongzuzizhixian','新晃侗族自治县',NULL),(2018,'431228','芷江侗族自治县','109.687777,27.437996','district',2009,0,'Z','2018-12-14 00:21:37','2019-02-23 07:29:27','zhijiangdongzuzizhixian','芷江侗族自治县',NULL),(2019,'431229','靖州苗族侗族自治县','109.691159,26.573511','district',2009,0,'J','2018-12-14 00:21:37','2019-02-23 07:29:27','jingzhoumiaozudongzuzizhixian','靖州苗族侗族自治县',NULL),(2020,'431230','通道侗族自治县','109.783359,26.158349','district',2009,0,'T','2018-12-14 00:21:37','2019-02-23 07:29:27','tongdaodongzuzizhixian','通道侗族自治县',NULL),(2021,'431281','洪江市','109.831765,27.201876','district',2009,0,'H','2018-12-14 00:21:37','2019-02-23 07:29:27','hongjiang','洪江',NULL),(2022,'431300','娄底市','112.008497,27.728136','city',1900,0,'L','2018-12-14 00:21:37','2019-02-23 07:29:27','loudi','娄底',NULL),(2023,'431302','娄星区','112.008486,27.726643','district',2022,0,'L','2018-12-14 00:21:37','2019-02-23 07:29:27','louxingqu','娄星区',NULL),(2024,'431321','双峰县','112.198245,27.459126','district',2022,0,'S','2018-12-14 00:21:37','2019-02-23 07:29:27','shuangfengxian','双峰县',NULL),(2025,'431322','新化县','111.306747,27.737456','district',2022,0,'X','2018-12-14 00:21:37','2019-02-23 07:29:27','xinhuaxian','新化县',NULL),(2026,'431381','冷水江市','111.434674,27.685759','district',2022,0,'L','2018-12-14 00:21:37','2019-02-23 07:29:27','lengshuijiang','冷水江',NULL),(2027,'431382','涟源市','111.670847,27.692301','district',2022,0,'L','2018-12-14 00:21:37','2019-02-23 07:29:27','lianyuan','涟源',NULL),(2028,'433100','湘西土家族苗族自治州','109.739735,28.314296','city',1900,0,'X','2018-12-14 00:21:37','2019-02-23 07:29:27','xiangxitujiazumiaozuzizhizhou','湘西土家族苗族自治州',NULL),(2029,'433101','吉首市','109.738273,28.314827','district',2028,0,'J','2018-12-14 00:21:37','2019-02-23 07:29:27','jishou','吉首',NULL),(2030,'433122','泸溪县','110.214428,28.214516','district',2028,0,'L','2018-12-14 00:21:38','2019-02-23 07:29:27','luxixian','泸溪县',NULL),(2031,'433123','凤凰县','109.599191,27.948308','district',2028,0,'F','2018-12-14 00:21:38','2019-02-23 07:29:27','fenghuangxian','凤凰县',NULL),(2032,'433124','花垣县','109.479063,28.581352','district',2028,0,'H','2018-12-14 00:21:38','2019-02-23 07:29:27','huayuanxian','花垣县',NULL),(2033,'433125','保靖县','109.651445,28.709605','district',2028,0,'B','2018-12-14 00:21:38','2019-02-23 07:29:27','baojingxian','保靖县',NULL),(2034,'433126','古丈县','109.949592,28.616973','district',2028,0,'G','2018-12-14 00:21:38','2019-02-23 07:29:27','guzhangxian','古丈县',NULL),(2035,'433127','永顺县','109.853292,28.998068','district',2028,0,'Y','2018-12-14 00:21:38','2019-02-23 07:29:27','yongshunxian','永顺县',NULL),(2036,'433130','龙山县','109.441189,29.453438','district',2028,0,'L','2018-12-14 00:21:38','2019-02-23 07:29:27','longshanxian','龙山县',NULL),(2037,'440000','广东省','113.280637,23.125178','province',0,8998,'G','2018-12-14 00:21:38','2019-02-23 07:29:28','guangdongsheng','广东省',NULL),(2038,'440100','广州市','113.280637,23.125178','city',2037,9997,'G','2018-12-14 00:21:38','2019-02-23 07:29:28','guangzhou','广州',1),(2039,'440103','荔湾区','113.243038,23.124943','district',2038,0,'L','2018-12-14 00:21:38','2019-02-23 07:29:28','liwanqu','荔湾区',NULL),(2040,'440104','越秀区','113.280714,23.125624','district',2038,0,'Y','2018-12-14 00:21:38','2019-02-23 07:29:28','yuexiuqu','越秀区',NULL),(2041,'440105','海珠区','113.262008,23.103131','district',2038,0,'H','2018-12-14 00:21:38','2019-02-23 07:29:28','haizhuqu','海珠区',NULL),(2042,'440106','天河区','113.335367,23.13559','district',2038,0,'T','2018-12-14 00:21:38','2019-02-23 07:29:28','tianhequ','天河区',NULL),(2043,'440111','白云区','113.262831,23.162281','district',2038,0,'B','2018-12-14 00:21:38','2019-02-23 07:29:28','baiyunqu','白云区',NULL),(2044,'440112','黄埔区','113.450761,23.103239','district',2038,0,'H','2018-12-14 00:21:38','2019-02-23 07:29:28','huangpuqu','黄埔区',NULL),(2045,'440113','番禺区','113.364619,22.938582','district',2038,0,'P','2018-12-14 00:21:38','2019-02-23 07:29:28','panyuqu','番禺区',NULL),(2046,'440114','花都区','113.211184,23.39205','district',2038,0,'H','2018-12-14 00:21:38','2019-02-23 07:29:28','huaduqu','花都区',NULL),(2047,'440115','南沙区','113.53738,22.794531','district',2038,0,'N','2018-12-14 00:21:38','2019-02-23 07:29:28','nanshaqu','南沙区',NULL),(2048,'440117','从化区','113.587386,23.545283','district',2038,0,'C','2018-12-14 00:21:38','2019-02-23 07:29:28','conghuaqu','从化区',NULL),(2049,'440118','增城区','113.829579,23.290497','district',2038,0,'Z','2018-12-14 00:21:38','2019-02-23 07:29:28','zengchengqu','增城区',NULL),(2050,'440200','韶关市','113.591544,24.801322','city',2037,0,'S','2018-12-14 00:21:39','2019-02-23 07:29:28','shaoguan','韶关',NULL),(2051,'440203','武江区','113.588289,24.80016','district',2050,0,'W','2018-12-14 00:21:39','2019-02-23 07:29:28','wujiangqu','武江区',NULL),(2052,'440204','浈江区','113.599224,24.803977','district',2050,0,'Z','2018-12-14 00:21:39','2019-02-23 07:29:28','zhenjiangqu','浈江区',NULL),(2053,'440205','曲江区','113.605582,24.680195','district',2050,0,'Q','2018-12-14 00:21:39','2019-02-23 07:29:28','qujiangqu','曲江区',NULL),(2054,'440222','始兴县','114.067205,24.948364','district',2050,0,'S','2018-12-14 00:21:39','2019-02-23 07:29:28','shixingxian','始兴县',NULL),(2055,'440224','仁化县','113.748627,25.088226','district',2050,0,'R','2018-12-14 00:21:39','2019-02-23 07:29:28','renhuaxian','仁化县',NULL),(2056,'440229','翁源县','114.131289,24.353887','district',2050,0,'W','2018-12-14 00:21:39','2019-02-23 07:29:28','wengyuanxian','翁源县',NULL),(2057,'440232','乳源瑶族自治县','113.278417,24.776109','district',2050,0,'R','2018-12-14 00:21:39','2019-02-23 07:29:28','ruyuanyaozuzizhixian','乳源瑶族自治县',NULL),(2058,'440233','新丰县','114.207034,24.055412','district',2050,0,'X','2018-12-14 00:21:39','2019-02-23 07:29:28','xinfengxian','新丰县',NULL),(2059,'440281','乐昌市','113.352413,25.128445','district',2050,0,'L','2018-12-14 00:21:39','2019-02-23 07:29:28','lechang','乐昌',NULL),(2060,'440282','南雄市','114.311231,25.115328','district',2050,0,'N','2018-12-14 00:21:39','2019-02-23 07:29:28','nanxiong','南雄',NULL),(2061,'440300','深圳市','114.085947,22.547','city',2037,9996,'S','2018-12-14 00:21:39','2019-02-23 07:29:28','shenzhen','深圳',1),(2062,'440303','罗湖区','114.123885,22.555341','district',2061,0,'L','2018-12-14 00:21:39','2019-02-23 07:29:28','luohuqu','罗湖区',NULL),(2063,'440304','福田区','114.05096,22.541009','district',2061,0,'F','2018-12-14 00:21:39','2019-02-23 07:29:28','futianqu','福田区',NULL),(2064,'440305','南山区','113.92943,22.531221','district',2061,0,'N','2018-12-14 00:21:39','2019-02-23 07:29:28','nanshanqu','南山区',NULL),(2065,'440306','宝安区','113.828671,22.754741','district',2061,0,'B','2018-12-14 00:21:40','2019-02-23 07:29:28','baoanqu','宝安区',NULL),(2066,'440307','龙岗区','114.251372,22.721511','district',2061,0,'L','2018-12-14 00:21:40','2019-02-23 07:29:28','longgangqu','龙岗区',NULL),(2067,'440308','盐田区','114.235366,22.555069','district',2061,0,'Y','2018-12-14 00:21:40','2019-02-23 07:29:28','yantianqu','盐田区',NULL),(2068,'440309','龙华区','114.044346,22.691963','district',2061,0,'L','2018-12-14 00:21:40','2019-02-23 07:29:29','longhuaqu','龙华区',NULL),(2069,'440310','坪山区','114.338441,22.69423','district',2061,0,'P','2018-12-14 00:21:40','2019-02-23 07:29:29','pingshanqu','坪山区',NULL),(2070,'440400','珠海市','113.553986,22.224979','city',2037,0,'Z','2018-12-14 00:21:40','2019-02-23 07:29:29','zhuhai','珠海',NULL),(2071,'440402','香洲区','113.55027,22.271249','district',2070,0,'X','2018-12-14 00:21:40','2019-02-23 07:29:29','xiangzhouqu','香洲区',NULL),(2072,'440403','斗门区','113.297739,22.209117','district',2070,0,'D','2018-12-14 00:21:40','2019-02-23 07:29:29','doumenqu','斗门区',NULL),(2073,'440404','金湾区','113.345071,22.139122','district',2070,0,'J','2018-12-14 00:21:40','2019-02-23 07:29:29','jinwanqu','金湾区',NULL),(2074,'440499','澳门大学横琴校区(由澳门管辖)',',','district',2070,0,'A','2018-12-14 00:21:40','2019-02-23 07:29:29','aomendaxuehengqinxiaoquyouaomenguanxia','澳门大学横琴校区(由澳门管辖)',NULL),(2075,'440500','汕头市','116.708463,23.37102','city',2037,0,'S','2018-12-14 00:21:40','2019-02-23 07:29:29','shantou','汕头',NULL),(2076,'440507','龙湖区','116.732015,23.373754','district',2075,0,'L','2018-12-14 00:21:40','2019-02-23 07:29:29','longhuqu','龙湖区',NULL),(2077,'440511','金平区','116.703583,23.367071','district',2075,0,'J','2018-12-14 00:21:40','2019-02-23 07:29:29','jinpingqu','金平区',NULL),(2078,'440512','濠江区','116.729528,23.279345','district',2075,0,'H','2018-12-14 00:21:40','2019-02-23 07:29:29','haojiangqu','濠江区',NULL),(2079,'440513','潮阳区','116.602602,23.262336','district',2075,0,'C','2018-12-14 00:21:40','2019-02-23 07:29:29','chaoyangqu','潮阳区',NULL),(2080,'440514','潮南区','116.423607,23.249798','district',2075,0,'C','2018-12-14 00:21:40','2019-02-23 07:29:29','chaonanqu','潮南区',NULL),(2081,'440515','澄海区','116.76336,23.46844','district',2075,0,'C','2018-12-14 00:21:41','2019-02-23 07:29:29','chenghaiqu','澄海区',NULL),(2082,'440523','南澳县','117.027105,23.419562','district',2075,0,'N','2018-12-14 00:21:41','2019-02-23 07:29:29','nanaoxian','南澳县',NULL),(2083,'440600','佛山市','113.122717,23.028762','city',2037,0,'F','2018-12-14 00:21:41','2019-02-23 07:29:29','foshan','佛山',NULL),(2084,'440604','禅城区','113.112414,23.019643','district',2083,0,'C','2018-12-14 00:21:41','2019-02-23 07:29:29','chanchengqu','禅城区',NULL),(2085,'440605','南海区','113.145577,23.031562','district',2083,0,'N','2018-12-14 00:21:41','2019-02-23 07:29:29','nanhaiqu','南海区',NULL),(2086,'440606','顺德区','113.281826,22.75851','district',2083,0,'S','2018-12-14 00:21:41','2019-02-23 07:29:29','shundequ','顺德区',NULL),(2087,'440607','三水区','112.899414,23.16504','district',2083,0,'S','2018-12-14 00:21:41','2019-02-23 07:29:29','sanshuiqu','三水区',NULL),(2088,'440608','高明区','112.882123,22.893855','district',2083,0,'G','2018-12-14 00:21:41','2019-02-23 07:29:29','gaomingqu','高明区',NULL),(2089,'440700','江门市','113.094942,22.590431','city',2037,0,'J','2018-12-14 00:21:41','2019-02-23 07:29:29','jiangmen','江门',NULL),(2090,'440703','蓬江区','113.07859,22.59677','district',2089,0,'P','2018-12-14 00:21:41','2019-02-23 07:29:29','pengjiangqu','蓬江区',NULL),(2091,'440704','江海区','113.120601,22.572211','district',2089,0,'J','2018-12-14 00:21:41','2019-02-23 07:29:29','jianghaiqu','江海区',NULL),(2092,'440705','新会区','113.038584,22.520247','district',2089,0,'X','2018-12-14 00:21:41','2019-02-23 07:29:29','xinhuiqu','新会区',NULL),(2093,'440781','台山市','112.793414,22.250713','district',2089,0,'T','2018-12-14 00:21:41','2019-02-23 07:29:29','taishan','台山',NULL),(2094,'440783','开平市','112.692262,22.366286','district',2089,0,'K','2018-12-14 00:21:41','2019-02-23 07:29:29','kaiping','开平',NULL),(2095,'440784','鹤山市','112.961795,22.768104','district',2089,0,'H','2018-12-14 00:21:41','2019-02-23 07:29:30','heshan','鹤山',NULL),(2096,'440785','恩平市','112.314051,22.182956','district',2089,0,'E','2018-12-14 00:21:41','2019-02-23 07:29:30','enping','恩平',NULL),(2097,'440800','湛江市','110.364977,21.274898','city',2037,0,'Z','2018-12-14 00:21:41','2019-02-23 07:29:30','zhanjiang','湛江',NULL),(2098,'440802','赤坎区','110.361634,21.273365','district',2097,0,'C','2018-12-14 00:21:41','2019-02-23 07:29:30','chikanqu','赤坎区',NULL),(2099,'440803','霞山区','110.406382,21.194229','district',2097,0,'X','2018-12-14 00:21:41','2019-02-23 07:29:30','xiashanqu','霞山区',NULL),(2100,'440804','坡头区','110.455632,21.24441','district',2097,0,'P','2018-12-14 00:21:41','2019-02-23 07:29:30','potouqu','坡头区',NULL),(2101,'440811','麻章区','110.329167,21.265997','district',2097,0,'M','2018-12-14 00:21:41','2019-02-23 07:29:30','mazhangqu','麻章区',NULL),(2102,'440823','遂溪县','110.255321,21.376915','district',2097,0,'S','2018-12-14 00:21:42','2019-02-23 07:29:30','suixixian','遂溪县',NULL),(2103,'440825','徐闻县','110.175718,20.326083','district',2097,0,'X','2018-12-14 00:21:42','2019-02-23 07:29:30','xuwenxian','徐闻县',NULL),(2104,'440881','廉江市','110.284961,21.611281','district',2097,0,'L','2018-12-14 00:21:42','2019-02-23 07:29:30','lianjiang','廉江',NULL),(2105,'440882','雷州市','110.088275,20.908523','district',2097,0,'L','2018-12-14 00:21:42','2019-02-23 07:29:30','leizhou','雷州',NULL),(2106,'440883','吴川市','110.780508,21.428453','district',2097,0,'W','2018-12-14 00:21:42','2019-02-23 07:29:30','wuchuan','吴川',NULL),(2107,'440900','茂名市','110.919229,21.659751','city',2037,0,'M','2018-12-14 00:21:42','2019-02-23 07:29:30','maoming','茂名',NULL),(2108,'440902','茂南区','110.920542,21.660425','district',2107,0,'M','2018-12-14 00:21:42','2019-02-23 07:29:30','maonanqu','茂南区',NULL),(2109,'440904','电白区','111.007264,21.507219','district',2107,0,'D','2018-12-14 00:21:42','2019-02-23 07:29:30','dianbaiqu','电白区',NULL),(2110,'440981','高州市','110.853251,21.915153','district',2107,0,'G','2018-12-14 00:21:42','2019-02-23 07:29:30','gaozhou','高州',NULL),(2111,'440982','化州市','110.63839,21.654953','district',2107,0,'H','2018-12-14 00:21:42','2019-02-23 07:29:30','huazhou','化州',NULL),(2112,'440983','信宜市','110.941656,22.352681','district',2107,0,'X','2018-12-14 00:21:42','2019-02-23 07:29:30','xinyi','信宜',NULL),(2113,'441200','肇庆市','112.472529,23.051546','city',2037,0,'Z','2018-12-14 00:21:42','2019-02-23 07:29:30','zhaoqing','肇庆',NULL),(2114,'441202','端州区','112.472329,23.052662','district',2113,0,'D','2018-12-14 00:21:42','2019-02-23 07:29:30','duanzhouqu','端州区',NULL),(2115,'441203','鼎湖区','112.565249,23.155822','district',2113,0,'D','2018-12-14 00:21:42','2019-02-23 07:29:30','dinghuqu','鼎湖区',NULL),(2116,'441204','高要区','112.460846,23.027694','district',2113,0,'G','2018-12-14 00:21:42','2019-02-23 07:29:30','gaoyaoqu','高要区',NULL),(2117,'441223','广宁县','112.440419,23.631486','district',2113,0,'G','2018-12-14 00:21:42','2019-02-23 07:29:30','guangningxian','广宁县',NULL),(2118,'441224','怀集县','112.182466,23.913072','district',2113,0,'H','2018-12-14 00:21:42','2019-02-23 07:29:30','huaijixian','怀集县',NULL),(2119,'441225','封开县','111.502973,23.434731','district',2113,0,'F','2018-12-14 00:21:42','2019-02-23 07:29:30','fengkaixian','封开县',NULL),(2120,'441226','德庆县','111.78156,23.141711','district',2113,0,'D','2018-12-14 00:21:42','2019-02-23 07:29:30','deqingxian','德庆县',NULL),(2121,'441284','四会市','112.695028,23.340324','district',2113,0,'S','2018-12-14 00:21:42','2019-02-23 07:29:30','sihui','四会',NULL),(2122,'441300','惠州市','114.412599,23.079404','city',2037,0,'H','2018-12-14 00:21:43','2019-02-23 07:29:30','huizhou','惠州',NULL),(2123,'441302','惠城区','114.413978,23.079883','district',2122,0,'H','2018-12-14 00:21:43','2019-02-23 07:29:30','huichengqu','惠城区',NULL),(2124,'441303','惠阳区','114.469444,22.78851','district',2122,0,'H','2018-12-14 00:21:43','2019-02-23 07:29:30','huiyangqu','惠阳区',NULL),(2125,'441322','博罗县','114.284254,23.167575','district',2122,0,'B','2018-12-14 00:21:43','2019-02-23 07:29:30','boluoxian','博罗县',NULL),(2126,'441323','惠东县','114.723092,22.983036','district',2122,0,'H','2018-12-14 00:21:43','2019-02-23 07:29:30','huidongxian','惠东县',NULL),(2127,'441324','龙门县','114.259986,23.723894','district',2122,0,'L','2018-12-14 00:21:43','2019-02-23 07:29:31','longmenxian','龙门县',NULL),(2128,'441400','梅州市','116.117582,24.299112','city',2037,0,'M','2018-12-14 00:21:43','2019-02-23 07:29:31','meizhou','梅州',NULL),(2129,'441402','梅江区','116.12116,24.302593','district',2128,0,'M','2018-12-14 00:21:43','2019-02-23 07:29:31','meijiangqu','梅江区',NULL),(2130,'441403','梅县区','116.083482,24.267825','district',2128,0,'M','2018-12-14 00:21:43','2019-02-23 07:29:31','meixianqu','梅县区',NULL),(2131,'441422','大埔县','116.69552,24.351587','district',2128,0,'D','2018-12-14 00:21:43','2019-02-23 07:29:31','dabuxian','大埔县',NULL),(2132,'441423','丰顺县','116.184419,23.752771','district',2128,0,'F','2018-12-14 00:21:43','2019-02-23 07:29:31','fengshunxian','丰顺县',NULL),(2133,'441424','五华县','115.775004,23.925424','district',2128,0,'W','2018-12-14 00:21:43','2019-02-23 07:29:31','wuhuaxian','五华县',NULL),(2134,'441426','平远县','115.891729,24.569651','district',2128,0,'P','2018-12-14 00:21:43','2019-02-23 07:29:31','pingyuanxian','平远县',NULL),(2135,'441427','蕉岭县','116.170531,24.653313','district',2128,0,'J','2018-12-14 00:21:43','2019-02-23 07:29:31','jiaolingxian','蕉岭县',NULL),(2136,'441481','兴宁市','115.731648,24.138077','district',2128,0,'X','2018-12-14 00:21:43','2019-02-23 07:29:31','xingning','兴宁',NULL),(2137,'441500','汕尾市','115.364238,22.774485','city',2037,0,'S','2018-12-14 00:21:43','2019-02-23 07:29:31','shanwei','汕尾',NULL),(2138,'441502','城区','115.363667,22.776227','district',2137,0,'C','2018-12-14 00:21:43','2019-02-23 07:29:31','chengqu','城区',NULL),(2139,'441521','海丰县','115.337324,22.971042','district',2137,0,'H','2018-12-14 00:21:44','2019-02-23 07:29:31','haifengxian','海丰县',NULL),(2140,'441523','陆河县','115.657565,23.302682','district',2137,0,'L','2018-12-14 00:21:44','2019-02-23 07:29:31','luhexian','陆河县',NULL),(2141,'441581','陆丰市','115.644203,22.946104','district',2137,0,'L','2018-12-14 00:21:44','2019-02-23 07:29:31','lufeng','陆丰',NULL),(2142,'441600','河源市','114.697802,23.746266','city',2037,0,'H','2018-12-14 00:21:44','2019-02-23 07:29:31','heyuan','河源',NULL),(2143,'441602','源城区','114.696828,23.746255','district',2142,0,'Y','2018-12-14 00:21:44','2019-02-23 07:29:31','yuanchengqu','源城区',NULL),(2144,'441621','紫金县','115.184383,23.633744','district',2142,0,'Z','2018-12-14 00:21:44','2019-02-23 07:29:31','zijinxian','紫金县',NULL),(2145,'441622','龙川县','115.256415,24.101174','district',2142,0,'L','2018-12-14 00:21:44','2019-02-23 07:29:31','longchuanxian','龙川县',NULL),(2146,'441623','连平县','114.495952,24.364227','district',2142,0,'L','2018-12-14 00:21:44','2019-02-23 07:29:31','lianpingxian','连平县',NULL),(2147,'441624','和平县','114.941473,24.44318','district',2142,0,'H','2018-12-14 00:21:44','2019-02-23 07:29:31','hepingxian','和平县',NULL),(2148,'441625','东源县','114.742711,23.789093','district',2142,0,'D','2018-12-14 00:21:44','2019-02-23 07:29:32','dongyuanxian','东源县',NULL),(2149,'441700','阳江市','111.975107,21.859222','city',2037,0,'Y','2018-12-14 00:21:44','2019-02-23 07:29:32','yangjiang','阳江',NULL),(2150,'441702','江城区','111.968909,21.859182','district',2149,0,'J','2018-12-14 00:21:44','2019-02-23 07:29:32','jiangchengqu','江城区',NULL),(2151,'441704','阳东区','112.011267,21.864728','district',2149,0,'Y','2018-12-14 00:21:44','2019-02-23 07:29:32','yangdongqu','阳东区',NULL),(2152,'441721','阳西县','111.617556,21.75367','district',2149,0,'Y','2018-12-14 00:21:44','2019-02-23 07:29:32','yangxixian','阳西县',NULL),(2153,'441781','阳春市','111.7905,22.169598','district',2149,0,'Y','2018-12-14 00:21:44','2019-02-23 07:29:32','yangchun','阳春',NULL),(2154,'441800','清远市','113.051227,23.685022','city',2037,0,'Q','2018-12-14 00:21:44','2019-02-23 07:29:32','qingyuan','清远',NULL),(2155,'441802','清城区','113.048698,23.688976','district',2154,0,'Q','2018-12-14 00:21:44','2019-02-23 07:29:32','qingchengqu','清城区',NULL),(2156,'441803','清新区','113.015203,23.736949','district',2154,0,'Q','2018-12-14 00:21:44','2019-02-23 07:29:32','qingxinqu','清新区',NULL),(2157,'441821','佛冈县','113.534094,23.866739','district',2154,0,'F','2018-12-14 00:21:45','2019-02-23 07:29:32','fogangxian','佛冈县',NULL),(2158,'441823','阳山县','112.634019,24.470286','district',2154,0,'Y','2018-12-14 00:21:45','2019-02-23 07:29:32','yangshanxian','阳山县',NULL),(2159,'441825','连山壮族瑶族自治县','112.086555,24.567271','district',2154,0,'L','2018-12-14 00:21:45','2019-02-23 07:29:32','lianshanzhuangzuyaozuzizhixian','连山壮族瑶族自治县',NULL),(2160,'441826','连南瑶族自治县','112.290808,24.719097','district',2154,0,'L','2018-12-14 00:21:45','2019-02-23 07:29:32','liannanyaozuzizhixian','连南瑶族自治县',NULL),(2161,'441881','英德市','113.405404,24.18612','district',2154,0,'Y','2018-12-14 00:21:45','2019-02-23 07:29:32','yingde','英德',NULL),(2162,'441882','连州市','112.379271,24.783966','district',2154,0,'L','2018-12-14 00:21:45','2019-02-23 07:29:32','lianzhou','连州',NULL),(2163,'441900','东莞市','113.746262,23.046237','city',2037,0,'D','2018-12-14 00:21:45','2019-02-23 07:29:32','dongguan','东莞',NULL),(2164,'441900','万江街道','113.709,23.0014','street',2163,0,'W','2018-12-14 00:21:45','2019-02-23 07:29:33','wanjiangjiedao','万江街道',NULL),(2165,'441900','东坑镇','113.918,22.995','street',2163,0,'D','2018-12-14 00:21:45','2019-02-23 07:29:33','dongkengzhen','东坑镇',NULL),(2166,'441900','东城街道','113.757,23.0485','street',2163,0,'D','2018-12-14 00:21:45','2019-02-23 07:29:33','dongchengjiedao','东城街道',NULL),(2167,'441900','东莞生态园','113.917,23.0806','street',2163,0,'D','2018-12-14 00:21:45','2019-02-23 07:29:33','dongguanshengtaiyuan','东莞生态园',NULL),(2168,'441900','中堂镇','113.734,23.1164','street',2163,0,'Z','2018-12-14 00:21:45','2019-02-23 07:29:33','zhongtangzhen','中堂镇',NULL),(2169,'441900','企石镇','113.99,23.0541','street',2163,0,'Q','2018-12-14 00:21:45','2019-02-23 07:29:33','qishizhen','企石镇',NULL),(2170,'441900','凤岗镇','114.105,22.7308','street',2163,0,'F','2018-12-14 00:21:45','2019-02-23 07:29:33','fenggangzhen','凤岗镇',NULL),(2171,'441900','南城街道','113.737,23.0249','street',2163,0,'N','2018-12-14 00:21:45','2019-02-23 07:29:33','nanchengjiedao','南城街道',NULL),(2172,'441900','厚街镇','113.776,22.9097','street',2163,0,'H','2018-12-14 00:21:45','2019-02-23 07:29:33','houjiezhen','厚街镇',NULL),(2173,'441900','塘厦镇','114.05,22.7713','street',2163,0,'T','2018-12-14 00:21:45','2019-02-23 07:29:33','tangshazhen','塘厦镇',NULL),(2174,'441900','大岭山镇','113.843,22.9534','street',2163,0,'D','2018-12-14 00:21:45','2019-02-23 07:29:33','dalingshanzhen','大岭山镇',NULL),(2175,'441900','大朗镇','113.939,22.8654','street',2163,0,'D','2018-12-14 00:21:45','2019-02-23 07:29:33','dalangzhen','大朗镇',NULL),(2176,'441900','寮步镇','113.888,22.9529','street',2163,0,'L','2018-12-14 00:21:45','2019-02-23 07:29:33','liaobuzhen','寮步镇',NULL),(2177,'441900','常平镇','114.036,23.0074','street',2163,0,'C','2018-12-14 00:21:46','2019-02-23 07:29:33','changpingzhen','常平镇',NULL),(2178,'441900','望牛墩镇','113.676,23.0683','street',2163,0,'W','2018-12-14 00:21:46','2019-02-23 07:29:33','wangniudunzhen','望牛墩镇',NULL),(2179,'441900','松山湖管委会','113.875,22.869','street',2163,0,'S','2018-12-14 00:21:46','2019-02-23 07:29:33','songshanhuguanweihui','松山湖管委会',NULL),(2180,'441900','桥头镇','114.065,23.0315','street',2163,0,'Q','2018-12-14 00:21:46','2019-02-23 07:29:33','qiaotouzhen','桥头镇',NULL),(2181,'441900','樟木头镇','114.018,22.8704','street',2163,0,'Z','2018-12-14 00:21:46','2019-02-23 07:29:33','zhangmutouzhen','樟木头镇',NULL),(2182,'441900','横沥镇','114.006,23.0504','street',2163,0,'H','2018-12-14 00:21:46','2019-02-23 07:29:33','henglizhen','横沥镇',NULL),(2183,'441900','沙田镇','113.582,22.9426','street',2163,0,'S','2018-12-14 00:21:46','2019-02-23 07:29:33','shatianzhen','沙田镇',NULL),(2184,'441900','洪梅镇','113.607,23.0155','street',2163,0,'H','2018-12-14 00:21:46','2019-02-23 07:29:33','hongmeizhen','洪梅镇',NULL),(2185,'441900','清溪镇','114.11,22.862','street',2163,0,'Q','2018-12-14 00:21:46','2019-02-23 07:29:33','qingxizhen','清溪镇',NULL),(2186,'441900','石排镇','113.988,23.068','street',2163,0,'S','2018-12-14 00:21:46','2019-02-23 07:29:33','shipaizhen','石排镇',NULL),(2187,'441900','石碣镇','113.846,23.1024','street',2163,0,'S','2018-12-14 00:21:46','2019-02-23 07:29:33','shijiezhen','石碣镇',NULL),(2188,'441900','石龙镇','113.833,23.1123','street',2163,0,'S','2018-12-14 00:21:46','2019-02-23 07:29:33','shilongzhen','石龙镇',NULL),(2189,'441900','茶山镇','113.839,23.0813','street',2163,0,'C','2018-12-14 00:21:46','2019-02-23 07:29:33','chashanzhen','茶山镇',NULL),(2190,'441900','莞城街道','113.743,23.0225','street',2163,0,'G','2018-12-14 00:21:46','2019-02-23 07:29:33','guanchengjiedao','莞城街道',NULL),(2191,'441900','虎门港管委会','113.562,22.9718','street',2163,0,'H','2018-12-14 00:21:46','2019-02-23 07:29:33','humengangguanweihui','虎门港管委会',NULL),(2192,'441900','虎门镇','113.797,22.8587','street',2163,0,'H','2018-12-14 00:21:46','2019-02-23 07:29:33','humenzhen','虎门镇',NULL),(2193,'441900','谢岗镇','114.128,22.9901','street',2163,0,'X','2018-12-14 00:21:46','2019-02-23 07:29:33','xiegangzhen','谢岗镇',NULL),(2194,'441900','道滘镇','113.692,23.004','street',2163,0,'D','2018-12-14 00:21:46','2019-02-23 07:29:33','daojiaozhen','道滘镇',NULL),(2195,'441900','长安镇','113.77,22.8195','street',2163,0,'C','2018-12-14 00:21:46','2019-02-23 07:29:33','changanzhen','长安镇',NULL),(2196,'441900','高埗镇','113.773,23.112','street',2163,0,'G','2018-12-14 00:21:46','2019-02-23 07:29:33','gaobuzhen','高埗镇',NULL),(2197,'441900','麻涌镇','113.562,22.9718','street',2163,0,'M','2018-12-14 00:21:46','2019-02-23 07:29:33','mayongzhen','麻涌镇',NULL),(2198,'441900','黄江镇','113.973,22.8121','street',2163,0,'H','2018-12-14 00:21:47','2019-02-23 07:29:33','huangjiangzhen','黄江镇',NULL),(2199,'442000','中山市','113.382391,22.521113','city',2037,0,'Z','2018-12-14 00:21:47','2019-02-23 07:29:33','zhongshan','中山',NULL),(2200,'442000','三乡镇','113.432,22.3879','street',2199,0,'S','2018-12-14 00:21:47','2019-02-23 07:29:34','sanxiangzhen','三乡镇',NULL),(2201,'442000','三角镇','113.416,22.7079','street',2199,0,'S','2018-12-14 00:21:47','2019-02-23 07:29:34','sanjiaozhen','三角镇',NULL),(2202,'442000','东凤镇','113.308,22.6803','street',2199,0,'D','2018-12-14 00:21:47','2019-02-23 07:29:34','dongfengzhen','东凤镇',NULL),(2203,'442000','东区街道','113.4,22.5274','street',2199,0,'D','2018-12-14 00:21:47','2019-02-23 07:29:34','dongqujiedao','东区街道',NULL),(2204,'442000','东升镇','113.321,22.5607','street',2199,0,'D','2018-12-14 00:21:47','2019-02-23 07:29:34','dongshengzhen','东升镇',NULL),(2205,'442000','五桂山街道','113.399,22.4847','street',2199,0,'W','2018-12-14 00:21:47','2019-02-23 07:29:34','wuguishanjiedao','五桂山街道',NULL),(2206,'442000','南区街道','113.367,22.4892','street',2199,0,'N','2018-12-14 00:21:47','2019-02-23 07:29:34','nanqujiedao','南区街道',NULL),(2207,'442000','南头镇','113.328,22.6882','street',2199,0,'N','2018-12-14 00:21:47','2019-02-23 07:29:34','nantouzhen','南头镇',NULL),(2208,'442000','南朗镇','113.482,22.519','street',2199,0,'N','2018-12-14 00:21:47','2019-02-23 07:29:34','nanlangzhen','南朗镇',NULL),(2209,'442000','古镇镇','113.167,22.6751','street',2199,0,'G','2018-12-14 00:21:47','2019-02-23 07:29:34','guzhenzhen','古镇镇',NULL),(2210,'442000','坦洲镇','113.434,22.321','street',2199,0,'T','2018-12-14 00:21:47','2019-02-23 07:29:34','tanzhouzhen','坦洲镇',NULL),(2211,'442000','大涌镇','113.297,22.4834','street',2199,0,'D','2018-12-14 00:21:47','2019-02-23 07:29:34','dayongzhen','大涌镇',NULL),(2212,'442000','小榄镇','113.23,22.7026','street',2199,0,'X','2018-12-14 00:21:47','2019-02-23 07:29:34','xiaolanzhen','小榄镇',NULL),(2213,'442000','板芙镇','113.358,22.4068','street',2199,0,'B','2018-12-14 00:21:47','2019-02-23 07:29:34','banfuzhen','板芙镇',NULL),(2214,'442000','横栏镇','113.224,22.6048','street',2199,0,'H','2018-12-14 00:21:48','2019-02-23 07:29:34','henglanzhen','横栏镇',NULL),(2215,'442000','民众镇','113.499,22.6855','street',2199,0,'M','2018-12-14 00:21:48','2019-02-23 07:29:34','minzhongzhen','民众镇',NULL),(2216,'442000','沙溪镇','113.344,22.5248','street',2199,0,'S','2018-12-14 00:21:48','2019-02-23 07:29:34','shaxizhen','沙溪镇',NULL),(2217,'442000','港口镇','113.354,22.6027','street',2199,0,'G','2018-12-14 00:21:48','2019-02-23 07:29:34','gangkouzhen','港口镇',NULL),(2218,'442000','火炬开发区街道','113.42,22.5577','street',2199,0,'H','2018-12-14 00:21:48','2019-02-23 07:29:34','huojukaifaqujiedao','火炬开发区街道',NULL),(2219,'442000','石岐区街道','113.405,22.5247','street',2199,0,'S','2018-12-14 00:21:48','2019-02-23 07:29:34','shiqiqujiedao','石岐区街道',NULL),(2220,'442000','神湾镇','113.376,22.2768','street',2199,0,'S','2018-12-14 00:21:48','2019-02-23 07:29:34','shenwanzhen','神湾镇',NULL),(2221,'442000','西区街道','113.314,22.5649','street',2199,0,'X','2018-12-14 00:21:48','2019-02-23 07:29:34','xiqujiedao','西区街道',NULL),(2222,'442000','阜沙镇','113.34,22.6406','street',2199,0,'F','2018-12-14 00:21:48','2019-02-23 07:29:34','fushazhen','阜沙镇',NULL),(2223,'442000','黄圃镇','113.329,22.7457','street',2199,0,'H','2018-12-14 00:21:48','2019-02-23 07:29:34','huangpuzhen','黄圃镇',NULL),(2224,'442100','东沙群岛','116.887312,20.617512','city',2037,0,'D','2018-12-14 00:21:48','2019-02-23 07:29:34','dongshaqundao','东沙群岛',NULL),(2225,'445100','潮州市','116.632301,23.661701','city',2037,0,'C','2018-12-14 00:21:48','2019-02-23 07:29:34','chaozhou','潮州',NULL),(2226,'445102','湘桥区','116.63365,23.664675','district',2225,0,'X','2018-12-14 00:21:48','2019-02-23 07:29:35','xiangqiaoqu','湘桥区',NULL),(2227,'445103','潮安区','116.67931,23.461012','district',2225,0,'C','2018-12-14 00:21:48','2019-02-23 07:29:35','chaoanqu','潮安区',NULL),(2228,'445122','饶平县','117.00205,23.668171','district',2225,0,'R','2018-12-14 00:21:48','2019-02-23 07:29:35','raopingxian','饶平县',NULL),(2229,'445200','揭阳市','116.355733,23.543778','city',2037,0,'J','2018-12-14 00:21:48','2019-02-23 07:29:35','jieyang','揭阳',NULL),(2230,'445202','榕城区','116.357045,23.535524','district',2229,0,'R','2018-12-14 00:21:48','2019-02-23 07:29:35','rongchengqu','榕城区',NULL),(2231,'445203','揭东区','116.412947,23.569887','district',2229,0,'J','2018-12-14 00:21:48','2019-02-23 07:29:35','jiedongqu','揭东区',NULL),(2232,'445222','揭西县','115.838708,23.4273','district',2229,0,'J','2018-12-14 00:21:48','2019-02-23 07:29:35','jiexixian','揭西县',NULL),(2233,'445224','惠来县','116.295832,23.029834','district',2229,0,'H','2018-12-14 00:21:49','2019-02-23 07:29:35','huilaixian','惠来县',NULL),(2234,'445281','普宁市','116.165082,23.29788','district',2229,0,'P','2018-12-14 00:21:49','2019-02-23 07:29:35','puning','普宁',NULL),(2235,'445300','云浮市','112.044439,22.929801','city',2037,0,'Y','2018-12-14 00:21:49','2019-02-23 07:29:35','yunfu','云浮',NULL),(2236,'445302','云城区','112.04471,22.930827','district',2235,0,'Y','2018-12-14 00:21:49','2019-02-23 07:29:35','yunchengqu','云城区',NULL),(2237,'445303','云安区','112.005609,23.073152','district',2235,0,'Y','2018-12-14 00:21:49','2019-02-23 07:29:35','yunanqu','云安区',NULL),(2238,'445321','新兴县','112.23083,22.703204','district',2235,0,'X','2018-12-14 00:21:49','2019-02-23 07:29:35','xinxingxian','新兴县',NULL),(2239,'445322','郁南县','111.535921,23.237709','district',2235,0,'Y','2018-12-14 00:21:49','2019-02-23 07:29:35','yunanxian','郁南县',NULL),(2240,'445381','罗定市','111.578201,22.765415','district',2235,0,'L','2018-12-14 00:21:49','2019-02-23 07:29:35','luoding','罗定',NULL),(2241,'450000','广西壮族自治区','108.320004,22.82402','province',0,2800,'G','2018-12-14 00:21:49','2019-02-23 07:29:35','guangxizhuangzuzizhiqu','广西壮族自治区',NULL),(2242,'450100','南宁市','108.320004,22.82402','city',2241,0,'N','2018-12-14 00:21:49','2019-02-23 07:29:35','nanning','南宁',NULL),(2243,'450102','兴宁区','108.320189,22.819511','district',2242,0,'X','2018-12-14 00:21:49','2019-02-23 07:29:35','xingningqu','兴宁区',NULL),(2244,'450103','青秀区','108.346113,22.816614','district',2242,0,'Q','2018-12-14 00:21:49','2019-02-23 07:29:35','qingxiuqu','青秀区',NULL),(2245,'450105','江南区','108.310478,22.799593','district',2242,0,'J','2018-12-14 00:21:49','2019-02-23 07:29:35','jiangnanqu','江南区',NULL),(2246,'450107','西乡塘区','108.306903,22.832779','district',2242,0,'X','2018-12-14 00:21:49','2019-02-23 07:29:35','xixiangtangqu','西乡塘区',NULL),(2247,'450108','良庆区','108.322102,22.75909','district',2242,0,'L','2018-12-14 00:21:49','2019-02-23 07:29:35','liangqingqu','良庆区',NULL),(2248,'450109','邕宁区','108.484251,22.756598','district',2242,0,'Y','2018-12-14 00:21:49','2019-02-23 07:29:35','yongningqu','邕宁区',NULL),(2249,'450110','武鸣区','108.280717,23.157163','district',2242,0,'W','2018-12-14 00:21:49','2019-02-23 07:29:35','wumingqu','武鸣区',NULL),(2250,'450123','隆安县','107.688661,23.174763','district',2242,0,'L','2018-12-14 00:21:49','2019-02-23 07:29:35','longanxian','隆安县',NULL),(2251,'450124','马山县','108.172903,23.711758','district',2242,0,'M','2018-12-14 00:21:49','2019-02-23 07:29:35','mashanxian','马山县',NULL),(2252,'450125','上林县','108.603937,23.431769','district',2242,0,'S','2018-12-14 00:21:49','2019-02-23 07:29:35','shanglinxian','上林县',NULL),(2253,'450126','宾阳县','108.816735,23.216884','district',2242,0,'B','2018-12-14 00:21:50','2019-02-23 07:29:35','binyangxian','宾阳县',NULL),(2254,'450127','横县','109.270987,22.68743','district',2242,0,'H','2018-12-14 00:21:50','2019-02-23 07:29:35','hengxian','横县',NULL),(2255,'450200','柳州市','109.411703,24.314617','city',2241,0,'L','2018-12-14 00:21:50','2019-02-23 07:29:35','liuzhou','柳州',NULL),(2256,'450202','城中区','109.411749,24.312324','district',2255,0,'C','2018-12-14 00:21:50','2019-02-23 07:29:35','chengzhongqu','城中区',NULL),(2257,'450203','鱼峰区','109.415364,24.303848','district',2255,0,'Y','2018-12-14 00:21:50','2019-02-23 07:29:35','yufengqu','鱼峰区',NULL),(2258,'450204','柳南区','109.395936,24.287013','district',2255,0,'L','2018-12-14 00:21:50','2019-02-23 07:29:35','liunanqu','柳南区',NULL),(2259,'450205','柳北区','109.406577,24.359145','district',2255,0,'L','2018-12-14 00:21:50','2019-02-23 07:29:35','liubeiqu','柳北区',NULL),(2260,'450206','柳江区','109.334503,24.257512','district',2255,0,'L','2018-12-14 00:21:50','2019-02-23 07:29:36','liujiangqu','柳江区',NULL),(2261,'450222','柳城县','109.245812,24.655121','district',2255,0,'L','2018-12-14 00:21:50','2019-02-23 07:29:36','liuchengxian','柳城县',NULL),(2262,'450223','鹿寨县','109.740805,24.483405','district',2255,0,'L','2018-12-14 00:21:50','2019-02-23 07:29:36','luzhaixian','鹿寨县',NULL),(2263,'450224','融安县','109.403621,25.214703','district',2255,0,'R','2018-12-14 00:21:50','2019-02-23 07:29:36','ronganxian','融安县',NULL),(2264,'450225','融水苗族自治县','109.252744,25.068812','district',2255,0,'R','2018-12-14 00:21:50','2019-02-23 07:29:36','rongshuimiaozuzizhixian','融水苗族自治县',NULL),(2265,'450226','三江侗族自治县','109.614846,25.78553','district',2255,0,'S','2018-12-14 00:21:50','2019-02-23 07:29:36','sanjiangdongzuzizhixian','三江侗族自治县',NULL),(2266,'450300','桂林市','110.299121,25.274215','city',2241,0,'G','2018-12-14 00:21:50','2019-02-23 07:29:36','guilin','桂林',NULL),(2267,'450302','秀峰区','110.292445,25.278544','district',2266,0,'X','2018-12-14 00:21:50','2019-02-23 07:29:36','xiufengqu','秀峰区',NULL),(2268,'450303','叠彩区','110.300783,25.301334','district',2266,0,'D','2018-12-14 00:21:50','2019-02-23 07:29:36','diecaiqu','叠彩区',NULL),(2269,'450304','象山区','110.284882,25.261986','district',2266,0,'X','2018-12-14 00:21:50','2019-02-23 07:29:36','xiangshanqu','象山区',NULL),(2270,'450305','七星区','110.317577,25.254339','district',2266,0,'Q','2018-12-14 00:21:50','2019-02-23 07:29:36','qixingqu','七星区',NULL),(2271,'450311','雁山区','110.305667,25.077646','district',2266,0,'Y','2018-12-14 00:21:50','2019-02-23 07:29:36','yanshanqu','雁山区',NULL),(2272,'450312','临桂区','110.205487,25.246257','district',2266,0,'L','2018-12-14 00:21:51','2019-02-23 07:29:36','linguiqu','临桂区',NULL),(2273,'450321','阳朔县','110.494699,24.77534','district',2266,0,'Y','2018-12-14 00:21:51','2019-02-23 07:29:36','yangshuoxian','阳朔县',NULL),(2274,'450323','灵川县','110.325712,25.408541','district',2266,0,'L','2018-12-14 00:21:51','2019-02-23 07:29:36','lingchuanxian','灵川县',NULL),(2275,'450324','全州县','111.072989,25.929897','district',2266,0,'Q','2018-12-14 00:21:51','2019-02-23 07:29:36','quanzhouxian','全州县',NULL),(2276,'450325','兴安县','110.670783,25.609554','district',2266,0,'X','2018-12-14 00:21:51','2019-02-23 07:29:36','xinganxian','兴安县',NULL),(2277,'450326','永福县','109.989208,24.986692','district',2266,0,'Y','2018-12-14 00:21:51','2019-02-23 07:29:36','yongfuxian','永福县',NULL),(2278,'450327','灌阳县','111.160248,25.489098','district',2266,0,'G','2018-12-14 00:21:51','2019-02-23 07:29:36','guanyangxian','灌阳县',NULL),(2279,'450328','龙胜各族自治县','110.009423,25.796428','district',2266,0,'L','2018-12-14 00:21:51','2019-02-23 07:29:36','longshenggezuzizhixian','龙胜各族自治县',NULL),(2280,'450329','资源县','110.642587,26.0342','district',2266,0,'Z','2018-12-14 00:21:51','2019-02-23 07:29:36','ziyuanxian','资源县',NULL),(2281,'450330','平乐县','110.642821,24.632216','district',2266,0,'P','2018-12-14 00:21:51','2019-02-23 07:29:36','pinglexian','平乐县',NULL),(2282,'450331','荔浦县','110.400149,24.497786','district',2266,0,'L','2018-12-14 00:21:51','2019-02-23 07:29:36','lipuxian','荔浦县',NULL),(2283,'450332','恭城瑶族自治县','110.82952,24.833612','district',2266,0,'G','2018-12-14 00:21:51','2019-02-23 07:29:36','gongchengyaozuzizhixian','恭城瑶族自治县',NULL),(2284,'450400','梧州市','111.297604,23.474803','city',2241,0,'W','2018-12-14 00:21:51','2019-02-23 07:29:36','wuzhou','梧州',NULL),(2285,'450403','万秀区','111.315817,23.471318','district',2284,0,'W','2018-12-14 00:21:51','2019-02-23 07:29:36','wanxiuqu','万秀区',NULL),(2286,'450405','长洲区','111.275678,23.4777','district',2284,0,'C','2018-12-14 00:21:51','2019-02-23 07:29:36','changzhouqu','长洲区',NULL),(2287,'450406','龙圩区','111.246035,23.40996','district',2284,0,'L','2018-12-14 00:21:51','2019-02-23 07:29:36','longweiqu','龙圩区',NULL),(2288,'450421','苍梧县','111.544008,23.845097','district',2284,0,'C','2018-12-14 00:21:51','2019-02-23 07:29:36','cangwuxian','苍梧县',NULL),(2289,'450422','藤县','110.931826,23.373963','district',2284,0,'T','2018-12-14 00:21:51','2019-02-23 07:29:36','tengxian','藤县',NULL),(2290,'450423','蒙山县','110.5226,24.199829','district',2284,0,'M','2018-12-14 00:21:51','2019-02-23 07:29:36','mengshanxian','蒙山县',NULL),(2291,'450481','岑溪市','110.998114,22.918406','district',2284,0,'C','2018-12-14 00:21:52','2019-02-23 07:29:36','cenxi','岑溪',NULL),(2292,'450500','北海市','109.119254,21.473343','city',2241,0,'B','2018-12-14 00:21:52','2019-02-23 07:29:36','beihai','北海',NULL),(2293,'450502','海城区','109.107529,21.468443','district',2292,0,'H','2018-12-14 00:21:52','2019-02-23 07:29:36','haichengqu','海城区',NULL),(2294,'450503','银海区','109.118707,21.444909','district',2292,0,'Y','2018-12-14 00:21:52','2019-02-23 07:29:36','yinhaiqu','银海区',NULL),(2295,'450512','铁山港区','109.450573,21.5928','district',2292,0,'T','2018-12-14 00:21:52','2019-02-23 07:29:36','tieshangangqu','铁山港区',NULL),(2296,'450521','合浦县','109.200695,21.663554','district',2292,0,'H','2018-12-14 00:21:52','2019-02-23 07:29:37','hepuxian','合浦县',NULL),(2297,'450600','防城港市','108.345478,21.614631','city',2241,0,'F','2018-12-14 00:21:52','2019-02-23 07:29:37','fangchenggang','防城港',NULL),(2298,'450602','港口区','108.346281,21.614406','district',2297,0,'G','2018-12-14 00:21:52','2019-02-23 07:29:37','gangkouqu','港口区',NULL),(2299,'450603','防城区','108.358426,21.764758','district',2297,0,'F','2018-12-14 00:21:52','2019-02-23 07:29:37','fangchengqu','防城区',NULL),(2300,'450621','上思县','107.982139,22.151423','district',2297,0,'S','2018-12-14 00:21:52','2019-02-23 07:29:37','shangsixian','上思县',NULL),(2301,'450681','东兴市','107.97017,21.541172','district',2297,0,'D','2018-12-14 00:21:52','2019-02-23 07:29:37','dongxing','东兴',NULL),(2302,'450700','钦州市','108.624175,21.967127','city',2241,0,'Q','2018-12-14 00:21:52','2019-02-23 07:29:37','qinzhou','钦州',NULL),(2303,'450702','钦南区','108.626629,21.966808','district',2302,0,'Q','2018-12-14 00:21:52','2019-02-23 07:29:37','qinnanqu','钦南区',NULL),(2304,'450703','钦北区','108.44911,22.132761','district',2302,0,'Q','2018-12-14 00:21:52','2019-02-23 07:29:37','qinbeiqu','钦北区',NULL),(2305,'450721','灵山县','109.293468,22.418041','district',2302,0,'L','2018-12-14 00:21:52','2019-02-23 07:29:37','lingshanxian','灵山县',NULL),(2306,'450722','浦北县','109.556341,22.268335','district',2302,0,'P','2018-12-14 00:21:52','2019-02-23 07:29:37','pubeixian','浦北县',NULL),(2307,'450800','贵港市','109.602146,23.0936','city',2241,0,'G','2018-12-14 00:21:52','2019-02-23 07:29:37','guigang','贵港',NULL),(2308,'450802','港北区','109.59481,23.107677','district',2307,0,'G','2018-12-14 00:21:52','2019-02-23 07:29:37','gangbeiqu','港北区',NULL),(2309,'450803','港南区','109.604665,23.067516','district',2307,0,'G','2018-12-14 00:21:53','2019-02-23 07:29:37','gangnanqu','港南区',NULL);
INSERT INTO `districts` VALUES (2310,'450804','覃塘区','109.415697,23.132815','district',2307,0,'T','2018-12-14 00:21:53','2019-02-23 07:29:37','tantangqu','覃塘区',NULL),(2311,'450821','平南县','110.397485,23.544546','district',2307,0,'P','2018-12-14 00:21:53','2019-02-23 07:29:37','pingnanxian','平南县',NULL),(2312,'450881','桂平市','110.074668,23.382473','district',2307,0,'G','2018-12-14 00:21:53','2019-02-23 07:29:37','guiping','桂平',NULL),(2313,'450900','玉林市','110.154393,22.63136','city',2241,0,'Y','2018-12-14 00:21:53','2019-02-23 07:29:37','yulin','玉林',NULL),(2314,'450902','玉州区','110.154912,22.632132','district',2313,0,'Y','2018-12-14 00:21:53','2019-02-23 07:29:37','yuzhouqu','玉州区',NULL),(2315,'450903','福绵区','110.054155,22.58163','district',2313,0,'F','2018-12-14 00:21:53','2019-02-23 07:29:37','fumianqu','福绵区',NULL),(2316,'450921','容县','110.552467,22.856435','district',2313,0,'R','2018-12-14 00:21:53','2019-02-23 07:29:37','rongxian','容县',NULL),(2317,'450922','陆川县','110.264842,22.321054','district',2313,0,'L','2018-12-14 00:21:53','2019-02-23 07:29:37','luchuanxian','陆川县',NULL),(2318,'450923','博白县','109.980004,22.271285','district',2313,0,'B','2018-12-14 00:21:53','2019-02-23 07:29:37','bobaixian','博白县',NULL),(2319,'450924','兴业县','109.877768,22.74187','district',2313,0,'X','2018-12-14 00:21:53','2019-02-23 07:29:37','xingyexian','兴业县',NULL),(2320,'450981','北流市','110.348052,22.701648','district',2313,0,'B','2018-12-14 00:21:53','2019-02-23 07:29:37','beiliu','北流',NULL),(2321,'451000','百色市','106.616285,23.897742','city',2241,0,'B','2018-12-14 00:21:53','2019-02-23 07:29:37','bose','百色',NULL),(2322,'451002','右江区','106.615727,23.897675','district',2321,0,'Y','2018-12-14 00:21:53','2019-02-23 07:29:37','youjiangqu','右江区',NULL),(2323,'451021','田阳区','106.904315,23.736079','district',2321,0,'T','2018-12-14 00:21:53','2019-02-23 07:29:37','tianyangqu','田阳区',NULL),(2324,'451022','田东县','107.12426,23.600444','district',2321,0,'T','2018-12-14 00:21:53','2019-02-23 07:29:37','tiandongxian','田东县',NULL),(2325,'451023','平果县','107.580403,23.320479','district',2321,0,'P','2018-12-14 00:21:53','2019-02-23 07:29:37','pingguoxian','平果县',NULL),(2326,'451024','德保县','106.618164,23.321464','district',2321,0,'D','2018-12-14 00:21:53','2019-02-23 07:29:37','debaoxian','德保县',NULL),(2327,'451026','那坡县','105.833553,23.400785','district',2321,0,'N','2018-12-14 00:21:54','2019-02-23 07:29:37','napoxian','那坡县',NULL),(2328,'451027','凌云县','106.56487,24.345643','district',2321,0,'L','2018-12-14 00:21:54','2019-02-23 07:29:37','lingyunxian','凌云县',NULL),(2329,'451028','乐业县','106.559638,24.782204','district',2321,0,'L','2018-12-14 00:21:54','2019-02-23 07:29:37','leyexian','乐业县',NULL),(2330,'451029','田林县','106.235047,24.290262','district',2321,0,'T','2018-12-14 00:21:54','2019-02-23 07:29:37','tianlinxian','田林县',NULL),(2331,'451030','西林县','105.095025,24.492041','district',2321,0,'X','2018-12-14 00:21:54','2019-02-23 07:29:37','xilinxian','西林县',NULL),(2332,'451031','隆林各族自治县','105.342363,24.774318','district',2321,0,'L','2018-12-14 00:21:54','2019-02-23 07:29:38','longlingezuzizhixian','隆林各族自治县',NULL),(2333,'451081','靖西市','106.417549,23.134766','district',2321,0,'J','2018-12-14 00:21:54','2019-02-23 07:29:38','jingxi','靖西',NULL),(2334,'451100','贺州市','111.552056,24.414141','city',2241,0,'H','2018-12-14 00:21:54','2019-02-23 07:29:38','hezhou','贺州',NULL),(2335,'451102','八步区','111.551991,24.412446','district',2334,0,'B','2018-12-14 00:21:54','2019-02-23 07:29:38','babuqu','八步区',NULL),(2336,'451103','平桂区','111.524014,24.417148','district',2334,0,'P','2018-12-14 00:21:54','2019-02-23 07:29:38','pingguiqu','平桂区',NULL),(2337,'451121','昭平县','110.810865,24.172958','district',2334,0,'Z','2018-12-14 00:21:54','2019-02-23 07:29:38','zhaopingxian','昭平县',NULL),(2338,'451122','钟山县','111.303629,24.528566','district',2334,0,'Z','2018-12-14 00:21:54','2019-02-23 07:29:38','zhongshanxian','钟山县',NULL),(2339,'451123','富川瑶族自治县','111.277228,24.81896','district',2334,0,'F','2018-12-14 00:21:54','2019-02-23 07:29:38','fuchuanyaozuzizhixian','富川瑶族自治县',NULL),(2340,'451200','河池市','108.062105,24.695899','city',2241,0,'H','2018-12-14 00:21:54','2019-02-23 07:29:38','hechi','河池',NULL),(2341,'451202','金城江区','108.062131,24.695625','district',2340,0,'J','2018-12-14 00:21:54','2019-02-23 07:29:38','jinchengjiangqu','金城江区',NULL),(2342,'451203','宜州区','108.653965,24.492193','district',2340,0,'Y','2018-12-14 00:21:55','2019-02-23 07:29:38','yizhouqu','宜州区',NULL),(2343,'451221','南丹县','107.546605,24.983192','district',2340,0,'N','2018-12-14 00:21:55','2019-02-23 07:29:38','nandanxian','南丹县',NULL),(2344,'451222','天峨县','107.174939,24.985964','district',2340,0,'T','2018-12-14 00:21:55','2019-02-23 07:29:38','tianexian','天峨县',NULL),(2345,'451223','凤山县','107.044592,24.544561','district',2340,0,'F','2018-12-14 00:21:55','2019-02-23 07:29:38','fengshanxian','凤山县',NULL),(2346,'451224','东兰县','107.373696,24.509367','district',2340,0,'D','2018-12-14 00:21:55','2019-02-23 07:29:38','donglanxian','东兰县',NULL),(2347,'451225','罗城仫佬族自治县','108.902453,24.779327','district',2340,0,'L','2018-12-14 00:21:55','2019-02-23 07:29:38','luochengmulaozuzizhixian','罗城仫佬族自治县',NULL),(2348,'451226','环江毛南族自治县','108.258669,24.827628','district',2340,0,'H','2018-12-14 00:21:55','2019-02-23 07:29:38','huanjiangmaonanzuzizhixian','环江毛南族自治县',NULL),(2349,'451227','巴马瑶族自治县','107.253126,24.139538','district',2340,0,'B','2018-12-14 00:21:55','2019-02-23 07:29:38','bamayaozuzizhixian','巴马瑶族自治县',NULL),(2350,'451228','都安瑶族自治县','108.102761,23.934964','district',2340,0,'D','2018-12-14 00:21:56','2019-02-23 07:29:38','douanyaozuzizhixian','都安瑶族自治县',NULL),(2351,'451229','大化瑶族自治县','107.9945,23.739596','district',2340,0,'D','2018-12-14 00:21:56','2019-02-23 07:29:38','dahuayaozuzizhixian','大化瑶族自治县',NULL),(2352,'451300','来宾市','109.229772,23.733766','city',2241,0,'L','2018-12-14 00:21:56','2019-02-23 07:29:38','laibin','来宾',NULL),(2353,'451302','兴宾区','109.230541,23.732926','district',2352,0,'X','2018-12-14 00:21:56','2019-02-23 07:29:38','xingbinqu','兴宾区',NULL),(2354,'451321','忻城县','108.667361,24.064779','district',2352,0,'X','2018-12-14 00:21:56','2019-02-23 07:29:38','xinchengxian','忻城县',NULL),(2355,'451322','象州县','109.684555,23.959824','district',2352,0,'X','2018-12-14 00:21:56','2019-02-23 07:29:38','xiangzhouxian','象州县',NULL),(2356,'451323','武宣县','109.66287,23.604162','district',2352,0,'W','2018-12-14 00:21:56','2019-02-23 07:29:38','wuxuanxian','武宣县',NULL),(2357,'451324','金秀瑶族自治县','110.188556,24.134941','district',2352,0,'J','2018-12-14 00:21:56','2019-02-23 07:29:38','jinxiuyaozuzizhixian','金秀瑶族自治县',NULL),(2358,'451381','合山市','108.88858,23.81311','district',2352,0,'H','2018-12-14 00:21:56','2019-02-23 07:29:38','heshan','合山',NULL),(2359,'451400','崇左市','107.353926,22.404108','city',2241,0,'C','2018-12-14 00:21:56','2019-02-23 07:29:38','chongzuo','崇左',NULL),(2360,'451402','江州区','107.354443,22.40469','district',2359,0,'J','2018-12-14 00:21:56','2019-02-23 07:29:38','jiangzhouqu','江州区',NULL),(2361,'451421','扶绥县','107.911533,22.635821','district',2359,0,'F','2018-12-14 00:21:56','2019-02-23 07:29:38','fusuixian','扶绥县',NULL),(2362,'451422','宁明县','107.067616,22.131353','district',2359,0,'N','2018-12-14 00:21:56','2019-02-23 07:29:38','ningmingxian','宁明县',NULL),(2363,'451423','龙州县','106.857502,22.343716','district',2359,0,'L','2018-12-14 00:21:56','2019-02-23 07:29:38','longzhouxian','龙州县',NULL),(2364,'451424','大新县','107.200803,22.833369','district',2359,0,'D','2018-12-14 00:21:56','2019-02-23 07:29:38','daxinxian','大新县',NULL),(2365,'451425','天等县','107.142441,23.082484','district',2359,0,'T','2018-12-14 00:21:56','2019-02-23 07:29:38','tiandengxian','天等县',NULL),(2366,'451481','凭祥市','106.759038,22.108882','district',2359,0,'P','2018-12-14 00:21:56','2019-02-23 07:29:38','pingxiang','凭祥',NULL),(2367,'460000','海南省','110.33119,20.031971','province',0,4001,'H','2018-12-14 00:21:56','2019-02-23 07:29:38','hainansheng','海南省',NULL),(2368,'460100','海口市','110.33119,20.031971','city',2367,0,'H','2018-12-14 00:21:57','2019-02-23 07:29:39','haikou','海口',NULL),(2369,'460105','秀英区','110.282393,20.008145','district',2368,0,'X','2018-12-14 00:21:57','2019-02-23 07:29:39','xiuyingqu','秀英区',NULL),(2370,'460106','龙华区','110.330373,20.031026','district',2368,0,'L','2018-12-14 00:21:57','2019-02-23 07:29:39','longhuaqu','龙华区',NULL),(2371,'460107','琼山区','110.354722,20.001051','district',2368,0,'Q','2018-12-14 00:21:57','2019-02-23 07:29:39','qiongshanqu','琼山区',NULL),(2372,'460108','美兰区','110.356566,20.03074','district',2368,0,'M','2018-12-14 00:21:57','2019-02-23 07:29:39','meilanqu','美兰区',NULL),(2373,'460200','三亚市','109.508268,18.247872','city',2367,0,'S','2018-12-14 00:21:57','2019-02-23 07:29:39','sanya','三亚',NULL),(2374,'460202','海棠区','109.760778,18.407516','district',2373,0,'H','2018-12-14 00:21:57','2019-02-23 07:29:39','haitangqu','海棠区',NULL),(2375,'460203','吉阳区','109.512081,18.247436','district',2373,0,'J','2018-12-14 00:21:57','2019-02-23 07:29:39','jiyangqu','吉阳区',NULL),(2376,'460204','天涯区','109.506357,18.24734','district',2373,0,'T','2018-12-14 00:21:57','2019-02-23 07:29:39','tianyaqu','天涯区',NULL),(2377,'460205','崖州区','109.174306,18.352192','district',2373,0,'Y','2018-12-14 00:21:57','2019-02-23 07:29:39','yazhouqu','崖州区',NULL),(2378,'460300','三沙市','112.34882,16.831039','city',2367,0,'S','2018-12-14 00:21:57','2019-02-23 07:29:39','sansha','三沙',NULL),(2379,'460321','西沙群岛','111.792944,16.204546','district',2378,0,'X','2018-12-14 00:21:57','2019-02-23 07:29:39','xishaqundao','西沙群岛',NULL),(2380,'460322','南沙群岛','116.749998,11.471888','district',2378,0,'N','2018-12-14 00:21:57','2019-02-23 07:29:39','nanshaqundao','南沙群岛',NULL),(2381,'460323','中沙群岛的岛礁及其海域','117.740071,15.112856','district',2378,0,'Z','2018-12-14 00:21:57','2019-02-23 07:29:39','zhongshaqundaodedaojiaojiqihaiyu','中沙群岛的岛礁及其海域',NULL),(2382,'460400','儋州市','109.576782,19.517486','city',2367,0,'D','2018-12-14 00:21:57','2019-02-23 07:29:39','danzhou','儋州',NULL),(2383,'460400','三都镇','109.176,19.7946','street',2382,0,'S','2018-12-14 00:21:57','2019-02-23 07:29:39','sandouzhen','三都镇',NULL),(2384,'460400','东成镇','109.579,19.7102','street',2382,0,'D','2018-12-14 00:21:57','2019-02-23 07:29:39','dongchengzhen','东成镇',NULL),(2385,'460400','中和镇','109.351,19.7747','street',2382,0,'Z','2018-12-14 00:21:57','2019-02-23 07:29:39','zhonghezhen','中和镇',NULL),(2386,'460400','光村镇','109.467,19.9035','street',2382,0,'G','2018-12-14 00:21:58','2019-02-23 07:29:39','guangcunzhen','光村镇',NULL),(2387,'460400','兰洋镇','109.682,19.4833','street',2382,0,'L','2018-12-14 00:21:58','2019-02-23 07:29:39','lanyangzhen','兰洋镇',NULL),(2388,'460400','华南热作学院','109.505,19.573','street',2382,0,'H','2018-12-14 00:21:58','2019-02-23 07:29:39','huananrezuoxueyuan','华南热作学院',NULL),(2389,'460400','南丰镇','109.532,19.4981','street',2382,0,'N','2018-12-14 00:21:58','2019-02-23 07:29:39','nanfengzhen','南丰镇',NULL),(2390,'460400','和庆镇','109.677,19.5887','street',2382,0,'H','2018-12-14 00:21:58','2019-02-23 07:29:39','heqingzhen','和庆镇',NULL),(2391,'460400','国营八一农场','109.23,19.3915','street',2382,0,'G','2018-12-14 00:21:58','2019-02-23 07:29:39','guoyingbayinongchang','国营八一农场',NULL),(2392,'460400','国营蓝洋农场','109.618,19.5107','street',2382,0,'G','2018-12-14 00:21:58','2019-02-23 07:29:39','guoyinglanyangnongchang','国营蓝洋农场',NULL),(2393,'460400','国营西培农场','109.31,19.4969','street',2382,0,'G','2018-12-14 00:21:58','2019-02-23 07:29:39','guoyingxipeinongchang','国营西培农场',NULL),(2394,'460400','国营西联农场','109.537,19.6556','street',2382,0,'G','2018-12-14 00:21:58','2019-02-23 07:29:39','guoyingxiliannongchang','国营西联农场',NULL),(2395,'460400','大成镇','109.345,19.4765','street',2382,0,'D','2018-12-14 00:21:58','2019-02-23 07:29:39','dachengzhen','大成镇',NULL),(2396,'460400','峨蔓镇','109.333,19.8438','street',2382,0,'E','2018-12-14 00:21:58','2019-02-23 07:29:39','emanzhen','峨蔓镇',NULL),(2397,'460400','排浦镇','109.196,19.65','street',2382,0,'P','2018-12-14 00:21:58','2019-02-23 07:29:39','paipuzhen','排浦镇',NULL),(2398,'460400','新州镇','109.321,19.7523','street',2382,0,'X','2018-12-14 00:21:58','2019-02-23 07:29:39','xinzhouzhen','新州镇',NULL),(2399,'460400','木棠镇','109.33,19.8594','street',2382,0,'M','2018-12-14 00:21:58','2019-02-23 07:29:39','mutangzhen','木棠镇',NULL),(2400,'460400','洋浦经济开发区','109.162,19.7962','street',2382,0,'Y','2018-12-14 00:21:58','2019-02-23 07:29:39','yangpujingjikaifaqu','洋浦经济开发区',NULL),(2401,'460400','海头镇','108.948,19.4939','street',2382,0,'H','2018-12-14 00:21:58','2019-02-23 07:29:39','haitouzhen','海头镇',NULL),(2402,'460400','王五镇','109.258,19.6415','street',2382,0,'W','2018-12-14 00:21:59','2019-02-23 07:29:39','wangwuzhen','王五镇',NULL),(2403,'460400','白马井镇','109.268,19.7046','street',2382,0,'B','2018-12-14 00:21:59','2019-02-23 07:29:39','baimajingzhen','白马井镇',NULL),(2404,'460400','那大镇','109.573,19.5907','street',2382,0,'N','2018-12-14 00:21:59','2019-02-23 07:29:40','nadazhen','那大镇',NULL),(2405,'460400','雅星镇','109.156,19.4695','street',2382,0,'Y','2018-12-14 00:21:59','2019-02-23 07:29:40','yaxingzhen','雅星镇',NULL),(2406,'469001','五指山市','109.516662,18.776921','city',2367,0,'W','2018-12-14 00:21:59','2019-02-23 07:29:40','wuzhishan','五指山',NULL),(2407,'469001','南圣镇','109.659,18.841','street',2406,0,'N','2018-12-14 00:21:59','2019-02-23 07:29:40','nanshengzhen','南圣镇',NULL),(2408,'469001','国营畅好农场','109.541,18.7112','street',2406,0,'G','2018-12-14 00:21:59','2019-02-23 07:29:40','guoyingchanghaonongchang','国营畅好农场',NULL),(2409,'469001','毛道乡','109.356,18.7134','street',2406,0,'M','2018-12-14 00:21:59','2019-02-23 07:29:40','maodaoxiang','毛道乡',NULL),(2410,'469001','毛阳镇','109.45,18.8811','street',2406,0,'M','2018-12-14 00:21:59','2019-02-23 07:29:40','maoyangzhen','毛阳镇',NULL),(2411,'469001','水满乡','109.601,18.8995','street',2406,0,'S','2018-12-14 00:21:59','2019-02-23 07:29:40','shuimanxiang','水满乡',NULL),(2412,'469001','畅好乡','109.407,18.6294','street',2406,0,'C','2018-12-14 00:21:59','2019-02-23 07:29:40','changhaoxiang','畅好乡',NULL),(2413,'469001','番阳镇','109.334,18.9132','street',2406,0,'F','2018-12-14 00:21:59','2019-02-23 07:29:40','fanyangzhen','番阳镇',NULL),(2414,'469001','通什镇','109.614,18.8418','street',2406,0,'T','2018-12-14 00:21:59','2019-02-23 07:29:40','tongshizhen','通什镇',NULL),(2415,'469002','琼海市','110.466785,19.246011','city',2367,0,'Q','2018-12-14 00:21:59','2019-02-23 07:29:40','qionghai','琼海',NULL),(2416,'469002','万泉镇','110.364,19.2516','street',2415,0,'W','2018-12-14 00:21:59','2019-02-23 07:29:40','wanquanzhen','万泉镇',NULL),(2417,'469002','中原镇','110.419,19.1765','street',2415,0,'Z','2018-12-14 00:21:59','2019-02-23 07:29:40','zhongyuanzhen','中原镇',NULL),(2418,'469002','会山镇','110.302,19.0792','street',2415,0,'H','2018-12-14 00:21:59','2019-02-23 07:29:40','huishanzhen','会山镇',NULL),(2419,'469002','博鳌镇','110.5,19.1754','street',2415,0,'B','2018-12-14 00:22:00','2019-02-23 07:29:40','boaozhen','博鳌镇',NULL),(2420,'469002','嘉积镇','110.441,19.3208','street',2415,0,'J','2018-12-14 00:22:00','2019-02-23 07:29:40','jiajizhen','嘉积镇',NULL),(2421,'469002','国营东升农场','110.413,19.284','street',2415,0,'G','2018-12-14 00:22:00','2019-02-23 07:29:40','guoyingdongshengnongchang','国营东升农场',NULL),(2422,'469002','国营东太农场','110.367,19.1372','street',2415,0,'G','2018-12-14 00:22:00','2019-02-23 07:29:40','guoyingdongtainongchang','国营东太农场',NULL),(2423,'469002','国营东红农场','110.509,19.364','street',2415,0,'G','2018-12-14 00:22:00','2019-02-23 07:29:40','guoyingdonghongnongchang','国营东红农场',NULL),(2424,'469002','塔洋镇','110.475,19.3404','street',2415,0,'T','2018-12-14 00:22:00','2019-02-23 07:29:40','tayangzhen','塔洋镇',NULL),(2425,'469002','大路镇','110.424,19.354','street',2415,0,'D','2018-12-14 00:22:00','2019-02-23 07:29:40','daluzhen','大路镇',NULL),(2426,'469002','彬村山华侨农场','110.623,19.3022','street',2415,0,'B','2018-12-14 00:22:00','2019-02-23 07:29:40','bincunshanhuaqiaonongchang','彬村山华侨农场',NULL),(2427,'469002','潭门镇','110.546,19.2013','street',2415,0,'T','2018-12-14 00:22:00','2019-02-23 07:29:40','tanmenzhen','潭门镇',NULL),(2428,'469002','石壁镇','110.168,19.167','street',2415,0,'S','2018-12-14 00:22:00','2019-02-23 07:29:40','shibizhen','石壁镇',NULL),(2429,'469002','长坡镇','110.594,19.3213','street',2415,0,'Z','2018-12-14 00:22:00','2019-02-23 07:29:40','zhangpozhen','长坡镇',NULL),(2430,'469002','阳江镇','110.334,19.0558','street',2415,0,'Y','2018-12-14 00:22:00','2019-02-23 07:29:40','yangjiangzhen','阳江镇',NULL),(2431,'469002','龙江镇','110.36,19.1595','street',2415,0,'L','2018-12-14 00:22:00','2019-02-23 07:29:40','longjiangzhen','龙江镇',NULL),(2432,'469005','文昌市','110.753975,19.612986','city',2367,0,'W','2018-12-14 00:22:00','2019-02-23 07:29:40','wenchang','文昌',NULL),(2433,'469005','东路镇','110.658,19.8051','street',2432,0,'D','2018-12-14 00:22:00','2019-02-23 07:29:40','dongluzhen','东路镇',NULL),(2434,'469005','东郊镇','110.91,19.6291','street',2432,0,'D','2018-12-14 00:22:00','2019-02-23 07:29:40','dongjiaozhen','东郊镇',NULL),(2435,'469005','东阁镇','110.799,19.7566','street',2432,0,'D','2018-12-14 00:22:00','2019-02-23 07:29:40','donggezhen','东阁镇',NULL),(2436,'469005','会文镇','110.708,19.4957','street',2432,0,'H','2018-12-14 00:22:00','2019-02-23 07:29:40','huiwenzhen','会文镇',NULL),(2437,'469005','公坡镇','110.836,19.8543','street',2432,0,'G','2018-12-14 00:22:00','2019-02-23 07:29:40','gongpozhen','公坡镇',NULL),(2438,'469005','冯坡镇','110.774,20.0176','street',2432,0,'F','2018-12-14 00:22:01','2019-02-23 07:29:41','fengpozhen','冯坡镇',NULL),(2439,'469005','国营东路农场','110.714,19.8524','street',2432,0,'G','2018-12-14 00:22:01','2019-02-23 07:29:41','guoyingdonglunongchang','国营东路农场',NULL),(2440,'469005','国营南阳农场','110.556,19.4727','street',2432,0,'G','2018-12-14 00:22:01','2019-02-23 07:29:41','guoyingnanyangnongchang','国营南阳农场',NULL),(2441,'469005','国营罗豆农场','110.624,19.9713','street',2432,0,'G','2018-12-14 00:22:01','2019-02-23 07:29:41','guoyingluodounongchang','国营罗豆农场',NULL),(2442,'469005','抱罗镇','110.73,19.889','street',2432,0,'B','2018-12-14 00:22:01','2019-02-23 07:29:41','baoluozhen','抱罗镇',NULL),(2443,'469005','文城镇','110.708,19.4982','street',2432,0,'W','2018-12-14 00:22:01','2019-02-23 07:29:41','wenchengzhen','文城镇',NULL),(2444,'469005','文教镇','110.856,19.7083','street',2432,0,'W','2018-12-14 00:22:01','2019-02-23 07:29:41','wenjiaozhen','文教镇',NULL),(2445,'469005','昌洒镇','111.26,19.9626','street',2432,0,'C','2018-12-14 00:22:01','2019-02-23 07:29:41','changsazhen','昌洒镇',NULL),(2446,'469005','潭牛镇','110.623,19.6785','street',2432,0,'T','2018-12-14 00:22:01','2019-02-23 07:29:41','tanniuzhen','潭牛镇',NULL),(2447,'469005','翁田镇','110.813,19.9295','street',2432,0,'W','2018-12-14 00:22:01','2019-02-23 07:29:41','wengtianzhen','翁田镇',NULL),(2448,'469005','蓬莱镇','110.638,19.5164','street',2432,0,'P','2018-12-14 00:22:01','2019-02-23 07:29:41','penglaizhen','蓬莱镇',NULL),(2449,'469005','重兴镇','110.654,19.4341','street',2432,0,'Z','2018-12-14 00:22:01','2019-02-23 07:29:41','zhongxingzhen','重兴镇',NULL),(2450,'469005','铺前镇','110.675,20.0377','street',2432,0,'P','2018-12-14 00:22:01','2019-02-23 07:29:41','puqianzhen','铺前镇',NULL),(2451,'469005','锦山镇','110.67,20.0418','street',2432,0,'J','2018-12-14 00:22:01','2019-02-23 07:29:41','jinshanzhen','锦山镇',NULL),(2452,'469005','龙楼镇','110.938,19.6606','street',2432,0,'L','2018-12-14 00:22:01','2019-02-23 07:29:41','longlouzhen','龙楼镇',NULL),(2453,'469006','万宁市','110.388793,18.796216','city',2367,0,'W','2018-12-14 00:22:01','2019-02-23 07:29:41','wanning','万宁',NULL),(2454,'469006','万城镇','110.414,18.8276','street',2453,0,'W','2018-12-14 00:22:01','2019-02-23 07:29:41','wanchengzhen','万城镇',NULL),(2455,'469006','三更罗镇','110.214,18.9979','street',2453,0,'S','2018-12-14 00:22:01','2019-02-23 07:29:41','sangengluozhen','三更罗镇',NULL),(2456,'469006','东澳镇','110.429,18.6408','street',2453,0,'D','2018-12-14 00:22:02','2019-02-23 07:29:41','dongaozhen','东澳镇',NULL),(2457,'469006','兴隆华侨农场','110.106,18.8195','street',2453,0,'X','2018-12-14 00:22:02','2019-02-23 07:29:41','xinglonghuaqiaonongchang','兴隆华侨农场',NULL),(2458,'469006','北大镇','110.24,18.9316','street',2453,0,'B','2018-12-14 00:22:02','2019-02-23 07:29:41','beidazhen','北大镇',NULL),(2459,'469006','南桥镇','110.196,18.7201','street',2453,0,'N','2018-12-14 00:22:02','2019-02-23 07:29:41','nanqiaozhen','南桥镇',NULL),(2460,'469006','后安镇','110.374,18.9087','street',2453,0,'H','2018-12-14 00:22:02','2019-02-23 07:29:41','houanzhen','后安镇',NULL),(2461,'469006','和乐镇','110.416,18.9625','street',2453,0,'H','2018-12-14 00:22:02','2019-02-23 07:29:41','helezhen','和乐镇',NULL),(2462,'469006','国营东兴农场','110.375,18.894','street',2453,0,'G','2018-12-14 00:22:02','2019-02-23 07:29:41','guoyingdongxingnongchang','国营东兴农场',NULL),(2463,'469006','国营东和农场','110.217,18.7629','street',2453,0,'G','2018-12-14 00:22:02','2019-02-23 07:29:41','guoyingdonghenongchang','国营东和农场',NULL),(2464,'469006','国营新中农场','110.17,18.6967','street',2453,0,'G','2018-12-14 00:22:02','2019-02-23 07:29:41','guoyingxinzhongnongchang','国营新中农场',NULL),(2465,'469006','地方国营六连林场','110.505,18.9899','street',2453,0,'D','2018-12-14 00:22:02','2019-02-23 07:29:41','difangguoyingliulianlinchang','地方国营六连林场',NULL),(2466,'469006','大茂镇','110.39,18.8759','street',2453,0,'D','2018-12-14 00:22:02','2019-02-23 07:29:41','damaozhen','大茂镇',NULL),(2467,'469006','山根镇','110.483,18.9946','street',2453,0,'S','2018-12-14 00:22:02','2019-02-23 07:29:41','shangenzhen','山根镇',NULL),(2468,'469006','礼纪镇','110.269,18.7354','street',2453,0,'L','2018-12-14 00:22:02','2019-02-23 07:29:41','lijizhen','礼纪镇',NULL),(2469,'469006','长丰镇','110.321,18.7876','street',2453,0,'C','2018-12-14 00:22:02','2019-02-23 07:29:41','changfengzhen','长丰镇',NULL),(2470,'469006','龙滚镇','110.451,19.0536','street',2453,0,'L','2018-12-14 00:22:02','2019-02-23 07:29:41','longgunzhen','龙滚镇',NULL),(2471,'469007','东方市','108.653789,19.10198','city',2367,0,'D','2018-12-14 00:22:02','2019-02-23 07:29:41','dongfang','东方',NULL),(2472,'469007','三家镇','108.798,19.2498','street',2471,0,'S','2018-12-14 00:22:02','2019-02-23 07:29:41','sanjiazhen','三家镇',NULL),(2473,'469007','东方华侨农场','108.696,18.9726','street',2471,0,'D','2018-12-14 00:22:03','2019-02-23 07:29:41','dongfanghuaqiaonongchang','东方华侨农场',NULL),(2474,'469007','东河镇','108.991,19.1321','street',2471,0,'D','2018-12-14 00:22:03','2019-02-23 07:29:42','donghezhen','东河镇',NULL),(2475,'469007','八所镇','108.622,19.0927','street',2471,0,'B','2018-12-14 00:22:03','2019-02-23 07:29:42','basuozhen','八所镇',NULL),(2476,'469007','四更镇','108.606,19.2646','street',2471,0,'S','2018-12-14 00:22:03','2019-02-23 07:29:42','sigengzhen','四更镇',NULL),(2477,'469007','国营广坝农场','108.732,18.8589','street',2471,0,'G','2018-12-14 00:22:03','2019-02-23 07:29:42','guoyingguangbanongchang','国营广坝农场',NULL),(2478,'469007','大田镇','108.976,19.1314','street',2471,0,'D','2018-12-14 00:22:03','2019-02-23 07:29:42','datianzhen','大田镇',NULL),(2479,'469007','天安乡','108.817,18.8803','street',2471,0,'T','2018-12-14 00:22:03','2019-02-23 07:29:42','tiananxiang','天安乡',NULL),(2480,'469007','感城镇','108.83,18.8833','street',2471,0,'G','2018-12-14 00:22:03','2019-02-23 07:29:42','ganchengzhen','感城镇',NULL),(2481,'469007','新龙镇','108.686,18.9263','street',2471,0,'X','2018-12-14 00:22:03','2019-02-23 07:29:42','xinlongzhen','新龙镇',NULL),(2482,'469007','板桥镇','108.87,18.8744','street',2471,0,'B','2018-12-14 00:22:03','2019-02-23 07:29:42','banqiaozhen','板桥镇',NULL),(2483,'469007','江边乡','109.108,18.8945','street',2471,0,'J','2018-12-14 00:22:03','2019-02-23 07:29:42','jiangbianxiang','江边乡',NULL),(2484,'469021','定安县','110.349235,19.684966','city',2367,0,'D','2018-12-14 00:22:03','2019-02-23 07:29:42','dinganxian','定安县',NULL),(2485,'469021','国营中瑞农场','110.244,19.3008','street',2484,0,'G','2018-12-14 00:22:03','2019-02-23 07:29:42','guoyingzhongruinongchang','国营中瑞农场',NULL),(2486,'469021','国营南海农场','110.469,19.4432','street',2484,0,'G','2018-12-14 00:22:03','2019-02-23 07:29:42','guoyingnanhainongchang','国营南海农场',NULL),(2487,'469021','国营金鸡岭农场','110.252,19.5171','street',2484,0,'G','2018-12-14 00:22:03','2019-02-23 07:29:42','guoyingjinjilingnongchang','国营金鸡岭农场',NULL),(2488,'469021','定城镇','110.317,19.7017','street',2484,0,'D','2018-12-14 00:22:03','2019-02-23 07:29:42','dingchengzhen','定城镇',NULL),(2489,'469021','富文镇','110.232,19.521','street',2484,0,'F','2018-12-14 00:22:03','2019-02-23 07:29:42','fuwenzhen','富文镇',NULL),(2490,'469021','岭口镇','110.276,19.3601','street',2484,0,'L','2018-12-14 00:22:03','2019-02-23 07:29:42','lingkouzhen','岭口镇',NULL),(2491,'469021','新竹镇','110.159,19.5843','street',2484,0,'X','2018-12-14 00:22:04','2019-02-23 07:29:43','xinzhuzhen','新竹镇',NULL),(2492,'469021','翰林镇','110.24,19.2982','street',2484,0,'H','2018-12-14 00:22:04','2019-02-23 07:29:43','hanlinzhen','翰林镇',NULL),(2493,'469021','雷鸣镇','110.273,19.5137','street',2484,0,'L','2018-12-14 00:22:04','2019-02-23 07:29:43','leimingzhen','雷鸣镇',NULL),(2494,'469021','黄竹镇','110.528,19.4887','street',2484,0,'H','2018-12-14 00:22:04','2019-02-23 07:29:43','huangzhuzhen','黄竹镇',NULL),(2495,'469021','龙河镇','110.226,19.4221','street',2484,0,'L','2018-12-14 00:22:04','2019-02-23 07:29:43','longhezhen','龙河镇',NULL),(2496,'469021','龙湖镇','110.469,19.5845','street',2484,0,'L','2018-12-14 00:22:04','2019-02-23 07:29:43','longhuzhen','龙湖镇',NULL),(2497,'469021','龙门镇','110.298,19.4997','street',2484,0,'L','2018-12-14 00:22:04','2019-02-23 07:29:43','longmenzhen','龙门镇',NULL),(2498,'469022','屯昌县','110.102773,19.362916','city',2367,0,'T','2018-12-14 00:22:04','2019-02-23 07:29:43','tunchangxian','屯昌县',NULL),(2499,'469022','乌坡镇','110.093,19.1953','street',2498,0,'W','2018-12-14 00:22:04','2019-02-23 07:29:43','wupozhen','乌坡镇',NULL),(2500,'469022','南吕镇','110.05,19.2222','street',2498,0,'N','2018-12-14 00:22:04','2019-02-23 07:29:43','nanlvzhen','南吕镇',NULL),(2501,'469022','南坤镇','109.857,19.2939','street',2498,0,'N','2018-12-14 00:22:04','2019-02-23 07:29:43','nankunzhen','南坤镇',NULL),(2502,'469022','国营中坤农场','109.855,19.2944','street',2498,0,'G','2018-12-14 00:22:04','2019-02-23 07:29:43','guoyingzhongkunnongchang','国营中坤农场',NULL),(2503,'469022','国营中建农场','109.966,19.2466','street',2498,0,'G','2018-12-14 00:22:04','2019-02-23 07:29:43','guoyingzhongjiannongchang','国营中建农场',NULL),(2504,'469022','坡心镇','110.11,19.3302','street',2498,0,'P','2018-12-14 00:22:04','2019-02-23 07:29:43','poxinzhen','坡心镇',NULL),(2505,'469022','屯城镇','110.161,19.4468','street',2498,0,'T','2018-12-14 00:22:04','2019-02-23 07:29:43','tunchengzhen','屯城镇',NULL),(2506,'469022','新兴镇','110.154,19.5707','street',2498,0,'X','2018-12-14 00:22:04','2019-02-23 07:29:43','xinxingzhen','新兴镇',NULL),(2507,'469022','枫木镇','109.994,19.1901','street',2498,0,'F','2018-12-14 00:22:05','2019-02-23 07:29:43','fengmuzhen','枫木镇',NULL),(2508,'469022','西昌镇','110.024,19.4428','street',2498,0,'X','2018-12-14 00:22:05','2019-02-23 07:29:43','xichangzhen','西昌镇',NULL),(2509,'469023','澄迈县','110.007147,19.737095','city',2367,0,'C','2018-12-14 00:22:05','2019-02-23 07:29:43','chengmaixian','澄迈县',NULL),(2510,'469023','中兴镇','109.938,19.5697','street',2509,0,'Z','2018-12-14 00:22:05','2019-02-23 07:29:43','zhongxingzhen','中兴镇',NULL),(2511,'469023','仁兴镇','109.916,19.5062','street',2509,0,'R','2018-12-14 00:22:05','2019-02-23 07:29:43','renxingzhen','仁兴镇',NULL),(2512,'469023','加乐镇','110.042,19.6276','street',2509,0,'J','2018-12-14 00:22:05','2019-02-23 07:29:43','jialezhen','加乐镇',NULL),(2513,'469023','国营和岭农场','109.814,19.5367','street',2509,0,'G','2018-12-14 00:22:05','2019-02-23 07:29:43','guoyinghelingnongchang','国营和岭农场',NULL),(2514,'469023','国营昆仑农场','109.802,19.5127','street',2509,0,'G','2018-12-14 00:22:05','2019-02-23 07:29:43','guoyingkunlunnongchang','国营昆仑农场',NULL),(2515,'469023','国营红光农场','109.957,19.8731','street',2509,0,'G','2018-12-14 00:22:05','2019-02-23 07:29:43','guoyinghongguangnongchang','国营红光农场',NULL),(2516,'469023','国营红岗农场','110.038,19.5642','street',2509,0,'G','2018-12-14 00:22:05','2019-02-23 07:29:43','guoyinghonggangnongchang','国营红岗农场',NULL),(2517,'469023','国营西达农场','109.862,19.4343','street',2509,0,'G','2018-12-14 00:22:05','2019-02-23 07:29:43','guoyingxidanongchang','国营西达农场',NULL),(2518,'469023','国营金安农场','110.123,19.7367','street',2509,0,'G','2018-12-14 00:22:05','2019-02-23 07:29:43','guoyingjinannongchang','国营金安农场',NULL),(2519,'469023','大丰镇','109.989,19.904','street',2509,0,'D','2018-12-14 00:22:05','2019-02-23 07:29:43','dafengzhen','大丰镇',NULL),(2520,'469023','文儒镇','110.121,19.6454','street',2509,0,'W','2018-12-14 00:22:05','2019-02-23 07:29:43','wenruzhen','文儒镇',NULL),(2521,'469023','桥头镇','109.931,19.9171','street',2509,0,'Q','2018-12-14 00:22:05','2019-02-23 07:29:43','qiaotouzhen','桥头镇',NULL),(2522,'469023','永发镇','110.186,19.6424','street',2509,0,'Y','2018-12-14 00:22:05','2019-02-23 07:29:43','yongfazhen','永发镇',NULL),(2523,'469023','瑞溪镇','110.087,19.7731','street',2509,0,'R','2018-12-14 00:22:05','2019-02-23 07:29:43','ruixizhen','瑞溪镇',NULL),(2524,'469023','福山镇','109.919,19.7325','street',2509,0,'F','2018-12-14 00:22:06','2019-02-23 07:29:43','fushanzhen','福山镇',NULL),(2525,'469023','老城镇','110.159,19.9529','street',2509,0,'L','2018-12-14 00:22:06','2019-02-23 07:29:43','laochengzhen','老城镇',NULL),(2526,'469023','金江镇','109.987,19.7817','street',2509,0,'J','2018-12-14 00:22:06','2019-02-23 07:29:44','jinjiangzhen','金江镇',NULL),(2527,'469024','临高县','109.687697,19.908293','city',2367,0,'L','2018-12-14 00:22:06','2019-02-23 07:29:44','lingaoxian','临高县',NULL),(2528,'469024','东英镇','109.613,19.9349','street',2527,0,'D','2018-12-14 00:22:06','2019-02-23 07:29:44','dongyingzhen','东英镇',NULL),(2529,'469024','临城镇','109.673,19.8932','street',2527,0,'L','2018-12-14 00:22:06','2019-02-23 07:29:44','linchengzhen','临城镇',NULL),(2530,'469024','南宝镇','109.638,19.7516','street',2527,0,'N','2018-12-14 00:22:06','2019-02-23 07:29:44','nanbaozhen','南宝镇',NULL),(2531,'469024','博厚镇','109.716,19.893','street',2527,0,'B','2018-12-14 00:22:06','2019-02-23 07:29:44','bohouzhen','博厚镇',NULL),(2532,'469024','和舍镇','109.715,19.6717','street',2527,0,'H','2018-12-14 00:22:06','2019-02-23 07:29:44','heshezhen','和舍镇',NULL),(2533,'469024','国营加来农场','109.651,19.7591','street',2527,0,'G','2018-12-14 00:22:06','2019-02-23 07:29:44','guoyingjialainongchang','国营加来农场',NULL),(2534,'469024','国营红华农场','109.764,19.8244','street',2527,0,'G','2018-12-14 00:22:06','2019-02-23 07:29:44','guoyinghonghuanongchang','国营红华农场',NULL),(2535,'469024','多文镇','109.802,19.7418','street',2527,0,'D','2018-12-14 00:22:06','2019-02-23 07:29:44','duowenzhen','多文镇',NULL),(2536,'469024','新盈镇','109.624,19.8719','street',2527,0,'X','2018-12-14 00:22:06','2019-02-23 07:29:44','xinyingzhen','新盈镇',NULL),(2537,'469024','波莲镇','109.615,19.8555','street',2527,0,'B','2018-12-14 00:22:06','2019-02-23 07:29:44','bolianzhen','波莲镇',NULL),(2538,'469024','皇桐镇','109.816,19.8743','street',2527,0,'H','2018-12-14 00:22:06','2019-02-23 07:29:44','huangtongzhen','皇桐镇',NULL),(2539,'469024','调楼镇','109.61,19.9231','street',2527,0,'D','2018-12-14 00:22:07','2019-02-23 07:29:44','diaolouzhen','调楼镇',NULL),(2540,'469025','白沙黎族自治县','109.452606,19.224584','city',2367,0,'B','2018-12-14 00:22:07','2019-02-23 07:29:44','baishalizuzizhixian','白沙黎族自治县',NULL),(2541,'469025','七坊镇','109.298,19.3459','street',2540,0,'Q','2018-12-14 00:22:07','2019-02-23 07:29:44','qifangzhen','七坊镇',NULL),(2542,'469025','元门乡','109.455,19.0981','street',2540,0,'Y','2018-12-14 00:22:07','2019-02-23 07:29:44','yuanmenxiang','元门乡',NULL),(2543,'469025','南开乡','109.293,19.0596','street',2540,0,'N','2018-12-14 00:22:07','2019-02-23 07:29:44','nankaixiang','南开乡',NULL),(2544,'469025','国营白沙农场','109.429,19.2881','street',2540,0,'G','2018-12-14 00:22:07','2019-02-23 07:29:44','guoyingbaishanongchang','国营白沙农场',NULL),(2545,'469025','国营邦溪农场','109.18,19.4104','street',2540,0,'G','2018-12-14 00:22:07','2019-02-23 07:29:44','guoyingbangxinongchang','国营邦溪农场',NULL),(2546,'469025','国营龙江农场','109.178,19.2369','street',2540,0,'G','2018-12-14 00:22:07','2019-02-23 07:29:44','guoyinglongjiangnongchang','国营龙江农场',NULL),(2547,'469025','打安镇','109.36,19.3756','street',2540,0,'D','2018-12-14 00:22:07','2019-02-23 07:29:44','daanzhen','打安镇',NULL),(2548,'469025','牙叉镇','109.45,19.3004','street',2540,0,'Y','2018-12-14 00:22:07','2019-02-23 07:29:44','yachazhen','牙叉镇',NULL),(2549,'469025','细水乡','109.523,19.2096','street',2540,0,'X','2018-12-14 00:22:07','2019-02-23 07:29:44','xishuixiang','细水乡',NULL),(2550,'469025','荣邦乡','109.064,19.4868','street',2540,0,'R','2018-12-14 00:22:07','2019-02-23 07:29:44','rongbangxiang','荣邦乡',NULL),(2551,'469025','邦溪镇','109.09,19.3912','street',2540,0,'B','2018-12-14 00:22:07','2019-02-23 07:29:44','bangxizhen','邦溪镇',NULL),(2552,'469025','金波乡','109.157,19.2577','street',2540,0,'J','2018-12-14 00:22:07','2019-02-23 07:29:44','jinboxiang','金波乡',NULL),(2553,'469025','阜龙乡','109.436,19.3316','street',2540,0,'F','2018-12-14 00:22:07','2019-02-23 07:29:44','fulongxiang','阜龙乡',NULL),(2554,'469025','青松乡','109.302,19.0689','street',2540,0,'Q','2018-12-14 00:22:07','2019-02-23 07:29:44','qingsongxiang','青松乡',NULL),(2555,'469026','昌江黎族自治县','109.053351,19.260968','city',2367,0,'C','2018-12-14 00:22:07','2019-02-23 07:29:44','changjianglizuzizhixian','昌江黎族自治县',NULL),(2556,'469026','七叉镇','109.069,19.1732','street',2555,0,'Q','2018-12-14 00:22:08','2019-02-23 07:29:44','qichazhen','七叉镇',NULL),(2557,'469026','乌烈镇','108.81,19.3525','street',2555,0,'W','2018-12-14 00:22:08','2019-02-23 07:29:44','wuliezhen','乌烈镇',NULL),(2558,'469026','十月田镇','108.989,19.3818','street',2555,0,'S','2018-12-14 00:22:08','2019-02-23 07:29:44','shiyuetianzhen','十月田镇',NULL),(2559,'469026','叉河镇','108.989,19.2536','street',2555,0,'C','2018-12-14 00:22:08','2019-02-23 07:29:44','chahezhen','叉河镇',NULL),(2560,'469026','国营红林农场','109.088,19.2367','street',2555,0,'G','2018-12-14 00:22:08','2019-02-23 07:29:44','guoyinghonglinnongchang','国营红林农场',NULL),(2561,'469026','国营霸王岭林场','109.03,19.1725','street',2555,0,'G','2018-12-14 00:22:08','2019-02-23 07:29:45','guoyingbawanglinglinchang','国营霸王岭林场',NULL),(2562,'469026','昌化镇','108.732,19.3836','street',2555,0,'C','2018-12-14 00:22:08','2019-02-23 07:29:45','changhuazhen','昌化镇',NULL),(2563,'469026','海南矿业联合有限公司','108.989,19.2538','street',2555,0,'H','2018-12-14 00:22:08','2019-02-23 07:29:45','hainankuangyelianheyouxiangongsi','海南矿业联合有限公司',NULL),(2564,'469026','海尾镇','108.952,19.4945','street',2555,0,'H','2018-12-14 00:22:08','2019-02-23 07:29:45','haiweizhen','海尾镇',NULL),(2565,'469026','王下乡','109.094,18.9052','street',2555,0,'W','2018-12-14 00:22:08','2019-02-23 07:29:45','wangxiaxiang','王下乡',NULL),(2566,'469026','石碌镇','109.05,19.2444','street',2555,0,'S','2018-12-14 00:22:08','2019-02-23 07:29:45','shiluzhen','石碌镇',NULL),(2567,'469027','乐东黎族自治县','109.175444,18.74758','city',2367,0,'L','2018-12-14 00:22:08','2019-02-23 07:29:45','ledonglizuzizhixian','乐东黎族自治县',NULL),(2568,'469027','万冲镇','109.339,18.7838','street',2567,0,'W','2018-12-14 00:22:08','2019-02-23 07:29:45','wanchongzhen','万冲镇',NULL),(2569,'469027','九所镇','108.927,18.5276','street',2567,0,'J','2018-12-14 00:22:08','2019-02-23 07:29:45','jiusuozhen','九所镇',NULL),(2570,'469027','佛罗镇','108.792,18.5833','street',2567,0,'F','2018-12-14 00:22:08','2019-02-23 07:29:45','fuluozhen','佛罗镇',NULL),(2571,'469027','利国镇','108.965,18.529','street',2567,0,'L','2018-12-14 00:22:08','2019-02-23 07:29:45','liguozhen','利国镇',NULL),(2572,'469027','千家镇','109.15,18.6353','street',2567,0,'Q','2018-12-14 00:22:08','2019-02-23 07:29:45','qianjiazhen','千家镇',NULL),(2573,'469027','国营乐光农场','109.192,18.5331','street',2567,0,'G','2018-12-14 00:22:08','2019-02-23 07:29:45','guoyingleguangnongchang','国营乐光农场',NULL),(2574,'469027','国营保国农场','109.245,18.6612','street',2567,0,'G','2018-12-14 00:22:08','2019-02-23 07:29:45','guoyingbaoguonongchang','国营保国农场',NULL),(2575,'469027','国营尖峰岭林业公司','109.027,18.726','street',2567,0,'G','2018-12-14 00:22:09','2019-02-23 07:29:45','guoyingjianfenglinglinyegongsi','国营尖峰岭林业公司',NULL),(2576,'469027','国营山荣农场','109.223,18.7507','street',2567,0,'G','2018-12-14 00:22:09','2019-02-23 07:29:45','guoyingshanrongnongchang','国营山荣农场',NULL),(2577,'469027','国营莺歌海盐场','108.729,18.5523','street',2567,0,'G','2018-12-14 00:22:09','2019-02-23 07:29:45','guoyingyinggehaiyanchang','国营莺歌海盐场',NULL),(2578,'469027','大安镇','109.225,18.5876','street',2567,0,'D','2018-12-14 00:22:09','2019-02-23 07:29:45','daanzhen','大安镇',NULL),(2579,'469027','尖峰镇','108.7,18.7124','street',2567,0,'J','2018-12-14 00:22:09','2019-02-23 07:29:45','jianfengzhen','尖峰镇',NULL),(2580,'469027','志仲镇','109.224,18.5932','street',2567,0,'Z','2018-12-14 00:22:09','2019-02-23 07:29:45','zhizhongzhen','志仲镇',NULL),(2581,'469027','抱由镇','109.138,18.8948','street',2567,0,'B','2018-12-14 00:22:09','2019-02-23 07:29:45','baoyouzhen','抱由镇',NULL),(2582,'469027','莺歌海镇','108.728,18.4959','street',2567,0,'Y','2018-12-14 00:22:09','2019-02-23 07:29:45','yinggehaizhen','莺歌海镇',NULL),(2583,'469027','黄流镇','108.808,18.597','street',2567,0,'H','2018-12-14 00:22:09','2019-02-23 07:29:45','huangliuzhen','黄流镇',NULL),(2584,'469028','陵水黎族自治县','110.037218,18.505006','city',2367,0,'L','2018-12-14 00:22:09','2019-02-23 07:29:45','lingshuilizuzizhixian','陵水黎族自治县',NULL),(2585,'469028','三才镇','109.963,18.4915','street',2584,0,'S','2018-12-14 00:22:09','2019-02-23 07:29:45','sancaizhen','三才镇',NULL),(2586,'469028','光坡镇','110.04,18.5564','street',2584,0,'G','2018-12-14 00:22:09','2019-02-23 07:29:45','guangpozhen','光坡镇',NULL),(2587,'469028','国营南平农场','109.833,18.6336','street',2584,0,'G','2018-12-14 00:22:09','2019-02-23 07:29:45','guoyingnanpingnongchang','国营南平农场',NULL),(2588,'469028','国营吊罗山林业公司','109.948,18.6553','street',2584,0,'G','2018-12-14 00:22:09','2019-02-23 07:29:45','guoyingdiaoluoshanlinyegongsi','国营吊罗山林业公司',NULL),(2589,'469028','国营岭门农场','110.046,18.6244','street',2584,0,'G','2018-12-14 00:22:09','2019-02-23 07:29:45','guoyinglingmennongchang','国营岭门农场',NULL),(2590,'469028','提蒙乡','110.013,18.6404','street',2584,0,'T','2018-12-14 00:22:09','2019-02-23 07:29:45','timengxiang','提蒙乡',NULL),(2591,'469028','文罗镇','109.914,18.5734','street',2584,0,'W','2018-12-14 00:22:09','2019-02-23 07:29:45','wenluozhen','文罗镇',NULL),(2592,'469028','新村镇','110.026,18.446','street',2584,0,'X','2018-12-14 00:22:09','2019-02-23 07:29:45','xincunzhen','新村镇',NULL),(2593,'469028','本号镇','109.856,18.6617','street',2584,0,'B','2018-12-14 00:22:10','2019-02-23 07:29:45','benhaozhen','本号镇',NULL),(2594,'469028','椰林镇','110.02,18.4825','street',2584,0,'Y','2018-12-14 00:22:10','2019-02-23 07:29:45','yelinzhen','椰林镇',NULL),(2595,'469028','群英乡','109.847,18.5697','street',2584,0,'Q','2018-12-14 00:22:10','2019-02-23 07:29:45','qunyingxiang','群英乡',NULL),(2596,'469028','英州镇','109.876,18.4739','street',2584,0,'Y','2018-12-14 00:22:10','2019-02-23 07:29:45','yingzhouzhen','英州镇',NULL),(2597,'469028','隆广镇','109.858,18.4802','street',2584,0,'L','2018-12-14 00:22:10','2019-02-23 07:29:46','longguangzhen','隆广镇',NULL),(2598,'469028','黎安镇','110.146,18.4342','street',2584,0,'L','2018-12-14 00:22:10','2019-02-23 07:29:46','lianzhen','黎安镇',NULL),(2599,'469029','保亭黎族苗族自治县','109.70245,18.636371','city',2367,0,'B','2018-12-14 00:22:10','2019-02-23 07:29:46','baotinglizumiaozuzizhixian','保亭黎族苗族自治县',NULL),(2600,'469029','三道镇','109.66,18.5251','street',2599,0,'S','2018-12-14 00:22:10','2019-02-23 07:29:46','sandaozhen','三道镇',NULL),(2601,'469029','什玲镇','109.74,18.6941','street',2599,0,'S','2018-12-14 00:22:10','2019-02-23 07:29:46','shenlingzhen','什玲镇',NULL),(2602,'469029','保城镇','109.747,18.6854','street',2599,0,'B','2018-12-14 00:22:10','2019-02-23 07:29:46','baochengzhen','保城镇',NULL),(2603,'469029','六弓乡','109.803,18.5393','street',2599,0,'L','2018-12-14 00:22:10','2019-02-23 07:29:46','liugongxiang','六弓乡',NULL),(2604,'469029','加茂镇','109.719,18.5033','street',2599,0,'J','2018-12-14 00:22:10','2019-02-23 07:29:46','jiamaozhen','加茂镇',NULL),(2605,'469029','南林乡','109.577,18.3893','street',2599,0,'N','2018-12-14 00:22:10','2019-02-23 07:29:46','nanlinxiang','南林乡',NULL),(2606,'469029','响水镇','109.565,18.7404','street',2599,0,'X','2018-12-14 00:22:10','2019-02-23 07:29:46','xiangshuizhen','响水镇',NULL),(2607,'469029','国营三道农场','109.649,18.5179','street',2599,0,'G','2018-12-14 00:22:10','2019-02-23 07:29:46','guoyingsandaonongchang','国营三道农场',NULL),(2608,'469029','国营新星农场','109.729,18.6749','street',2599,0,'G','2018-12-14 00:22:10','2019-02-23 07:29:46','guoyingxinxingnongchang','国营新星农场',NULL),(2609,'469029','国营金江农场','109.682,18.547','street',2599,0,'G','2018-12-14 00:22:10','2019-02-23 07:29:46','guoyingjinjiangnongchang','国营金江农场',NULL),(2610,'469029','新政镇','109.578,18.5685','street',2599,0,'X','2018-12-14 00:22:10','2019-02-23 07:29:46','xinzhengzhen','新政镇',NULL),(2611,'469029','毛感乡','109.503,18.5563','street',2599,0,'M','2018-12-14 00:22:10','2019-02-23 07:29:46','maoganxiang','毛感乡',NULL),(2612,'469029','海南保亭热带作物研究所','109.709,18.6282','street',2599,0,'H','2018-12-14 00:22:10','2019-02-23 07:29:46','hainanbaotingredaizuowuyanjiusuo','海南保亭热带作物研究所',NULL),(2613,'469030','琼中黎族苗族自治县','109.839996,19.03557','city',2367,0,'Q','2018-12-14 00:22:11','2019-02-23 07:29:46','qiongzhonglizumiaozuzizhixian','琼中黎族苗族自治县',NULL),(2614,'469030','上安乡','109.731,18.9133','street',2613,0,'S','2018-12-14 00:22:11','2019-02-23 07:29:46','shanganxiang','上安乡',NULL),(2615,'469030','中平镇','110.107,19.0716','street',2613,0,'Z','2018-12-14 00:22:11','2019-02-23 07:29:46','zhongpingzhen','中平镇',NULL),(2616,'469030','什运乡','109.583,18.9237','street',2613,0,'S','2018-12-14 00:22:11','2019-02-23 07:29:46','shenyunxiang','什运乡',NULL),(2617,'469030','吊罗山乡','109.917,18.8198','street',2613,0,'D','2018-12-14 00:22:11','2019-02-23 07:29:46','diaoluoshanxiang','吊罗山乡',NULL),(2618,'469030','和平镇','109.894,18.899','street',2613,0,'H','2018-12-14 00:22:11','2019-02-23 07:29:46','hepingzhen','和平镇',NULL),(2619,'469030','国营乌石农场','109.937,19.0977','street',2613,0,'G','2018-12-14 00:22:11','2019-02-23 07:29:46','guoyingwushinongchang','国营乌石农场',NULL),(2620,'469030','国营加钗农场','109.783,19.0265','street',2613,0,'G','2018-12-14 00:22:11','2019-02-23 07:29:46','guoyingjiachainongchang','国营加钗农场',NULL),(2621,'469030','国营长征农场','109.899,18.9965','street',2613,0,'G','2018-12-14 00:22:11','2019-02-23 07:29:46','guoyingchangzhengnongchang','国营长征农场',NULL),(2622,'469030','国营阳江农场','109.823,19.2127','street',2613,0,'G','2018-12-14 00:22:11','2019-02-23 07:29:46','guoyingyangjiangnongchang','国营阳江农场',NULL),(2623,'469030','国营黎母山林业公司','109.703,19.1542','street',2613,0,'G','2018-12-14 00:22:11','2019-02-23 07:29:46','guoyinglimushanlinyegongsi','国营黎母山林业公司',NULL),(2624,'469030','湾岭镇','109.9,19.1334','street',2613,0,'W','2018-12-14 00:22:11','2019-02-23 07:29:46','wanlingzhen','湾岭镇',NULL),(2625,'469030','红毛镇','109.734,19.0657','street',2613,0,'H','2018-12-14 00:22:11','2019-02-23 07:29:46','hongmaozhen','红毛镇',NULL),(2626,'469030','营根镇','109.733,18.9748','street',2613,0,'Y','2018-12-14 00:22:11','2019-02-23 07:29:46','yinggenzhen','营根镇',NULL),(2627,'469030','长征镇','109.799,18.8976','street',2613,0,'C','2018-12-14 00:22:11','2019-02-23 07:29:46','changzhengzhen','长征镇',NULL),(2628,'469030','黎母山镇','109.704,19.2577','street',2613,0,'L','2018-12-14 00:22:11','2019-02-23 07:29:46','limushanzhen','黎母山镇',NULL),(2629,'500000','重庆市','106.504962,29.533155','province',0,9003,'C','2018-12-14 00:22:11','2019-02-23 07:29:46','chongqing','重庆',NULL),(2630,'500100','重庆市','106.504962,29.533155','city',2629,1,'C','2018-12-14 00:22:11','2019-02-23 07:29:46','chongqing','重庆',1),(2631,'500101','万州区','108.380246,30.807807','district',2630,0,'W','2018-12-14 00:22:11','2019-02-23 07:29:46','wanzhouqu','万州区',NULL),(2632,'500102','涪陵区','107.394905,29.703652','district',2630,0,'F','2018-12-14 00:22:11','2019-02-23 07:29:46','fulingqu','涪陵区',NULL),(2633,'500103','渝中区','106.56288,29.556742','district',2630,0,'Y','2018-12-14 00:22:12','2019-02-23 07:29:47','yuzhongqu','渝中区',NULL),(2634,'500104','大渡口区','106.48613,29.481002','district',2630,0,'D','2018-12-14 00:22:12','2019-02-23 07:29:47','dadukouqu','大渡口区',NULL),(2635,'500105','江北区','106.532844,29.575352','district',2630,0,'J','2018-12-14 00:22:12','2019-02-23 07:29:47','jiangbeiqu','江北区',NULL),(2636,'500106','沙坪坝区','106.4542,29.541224','district',2630,0,'S','2018-12-14 00:22:12','2019-02-23 07:29:47','shapingbaqu','沙坪坝区',NULL),(2637,'500107','九龙坡区','106.480989,29.523492','district',2630,0,'J','2018-12-14 00:22:12','2019-02-23 07:29:47','jiulongpoqu','九龙坡区',NULL),(2638,'500108','南岸区','106.560813,29.523992','district',2630,0,'N','2018-12-14 00:22:12','2019-02-23 07:29:47','nananqu','南岸区',NULL),(2639,'500109','北碚区','106.437868,29.82543','district',2630,0,'B','2018-12-14 00:22:12','2019-02-23 07:29:47','beibeiqu','北碚区',NULL),(2640,'500110','綦江区','106.651417,29.028091','district',2630,0,'Q','2018-12-14 00:22:12','2019-02-23 07:29:47','qijiangqu','綦江区',NULL),(2641,'500111','大足区','105.715319,29.700498','district',2630,0,'D','2018-12-14 00:22:12','2019-02-23 07:29:47','dazuqu','大足区',NULL),(2642,'500112','渝北区','106.512851,29.601451','district',2630,0,'Y','2018-12-14 00:22:12','2019-02-23 07:29:47','yubeiqu','渝北区',NULL),(2643,'500113','巴南区','106.519423,29.381919','district',2630,0,'B','2018-12-14 00:22:12','2019-02-23 07:29:47','bananqu','巴南区',NULL),(2644,'500114','黔江区','108.782577,29.527548','district',2630,0,'Q','2018-12-14 00:22:12','2019-02-23 07:29:47','qianjiangqu','黔江区',NULL),(2645,'500115','长寿区','107.074854,29.833671','district',2630,0,'C','2018-12-14 00:22:12','2019-02-23 07:29:47','changshouqu','长寿区',NULL),(2646,'500116','江津区','106.253156,29.283387','district',2630,0,'J','2018-12-14 00:22:12','2019-02-23 07:29:47','jiangjinqu','江津区',NULL),(2647,'500117','合川区','106.265554,29.990993','district',2630,0,'H','2018-12-14 00:22:12','2019-02-23 07:29:47','hechuanqu','合川区',NULL),(2648,'500118','永川区','105.894714,29.348748','district',2630,0,'Y','2018-12-14 00:22:12','2019-02-23 07:29:47','yongchuanqu','永川区',NULL),(2649,'500119','南川区','107.098153,29.156646','district',2630,0,'N','2018-12-14 00:22:12','2019-02-23 07:29:47','nanchuanqu','南川区',NULL),(2650,'500120','璧山区','106.231126,29.593581','district',2630,0,'B','2018-12-14 00:22:12','2019-02-23 07:29:47','bishanqu','璧山区',NULL),(2651,'500151','铜梁区','106.054948,29.839944','district',2630,0,'T','2018-12-14 00:22:12','2019-02-23 07:29:47','tongliangqu','铜梁区',NULL),(2652,'500152','潼南区','105.841818,30.189554','district',2630,0,'T','2018-12-14 00:22:12','2019-02-23 07:29:47','tongnanqu','潼南区',NULL),(2653,'500153','荣昌区','105.594061,29.403627','district',2630,0,'R','2018-12-14 00:22:12','2019-02-23 07:29:47','rongchangqu','荣昌区',NULL),(2654,'500154','开州区','108.413317,31.167735','district',2630,0,'K','2018-12-14 00:22:13','2019-02-23 07:29:47','kaizhouqu','开州区',NULL),(2655,'500155','梁平区','107.800034,30.672168','district',2630,0,'L','2018-12-14 00:22:13','2019-02-23 07:29:47','liangpingqu','梁平区',NULL),(2656,'500156','武隆区','107.75655,29.32376','district',2630,0,'W','2018-12-14 00:22:13','2019-02-23 07:29:47','wulongqu','武隆区',NULL),(2657,'500200','重庆郊县','108.170255,29.291965','city',2629,0,'C','2018-12-14 00:22:13','2019-02-23 07:29:47','chongqingjiaoxian','重庆郊县',NULL),(2658,'500229','城口县','108.6649,31.946293','district',2657,0,'C','2018-12-14 00:22:13','2019-02-23 07:29:47','chengkouxian','城口县',NULL),(2659,'500230','丰都县','107.73248,29.866424','district',2657,0,'F','2018-12-14 00:22:13','2019-02-23 07:29:47','fengduxian','丰都县',NULL),(2660,'500231','垫江县','107.348692,30.330012','district',2657,0,'D','2018-12-14 00:22:13','2019-02-23 07:29:47','dianjiangxian','垫江县',NULL),(2661,'500233','忠县','108.037518,30.291537','district',2657,0,'Z','2018-12-14 00:22:13','2019-02-23 07:29:47','zhongxian','忠县',NULL),(2662,'500235','云阳县','108.697698,30.930529','district',2657,0,'Y','2018-12-14 00:22:13','2019-02-23 07:29:47','yunyangxian','云阳县',NULL),(2663,'500236','奉节县','109.465774,31.019967','district',2657,0,'F','2018-12-14 00:22:13','2019-02-23 07:29:47','fengjiexian','奉节县',NULL),(2664,'500237','巫山县','109.878928,31.074843','district',2657,0,'W','2018-12-14 00:22:13','2019-02-23 07:29:47','wushanxian','巫山县',NULL),(2665,'500238','巫溪县','109.628912,31.3966','district',2657,0,'W','2018-12-14 00:22:13','2019-02-23 07:29:47','wuxixian','巫溪县',NULL),(2666,'500240','石柱土家族自治县','108.112448,29.99853','district',2657,0,'S','2018-12-14 00:22:13','2019-02-23 07:29:47','shizhutujiazuzizhixian','石柱土家族自治县',NULL),(2667,'500241','秀山土家族苗族自治县','108.996043,28.444772','district',2657,0,'X','2018-12-14 00:22:13','2019-02-23 07:29:47','xiushantujiazumiaozuzizhixian','秀山土家族苗族自治县',NULL),(2668,'500242','酉阳土家族苗族自治县','108.767201,28.839828','district',2657,0,'Y','2018-12-14 00:22:13','2019-02-23 07:29:47','youyangtujiazumiaozuzizhixian','酉阳土家族苗族自治县',NULL),(2669,'500243','彭水苗族土家族自治县','108.166551,29.293856','district',2657,0,'P','2018-12-14 00:22:13','2019-02-23 07:29:48','pengshuimiaozutujiazuzizhixian','彭水苗族土家族自治县',NULL),(2670,'510000','四川省','104.065735,30.659462','province',0,6002,'S','2018-12-14 00:22:13','2019-02-23 07:29:48','sichuansheng','四川省',NULL),(2671,'510100','成都市','104.065735,30.659462','city',2670,1,'C','2018-12-14 00:22:13','2019-02-23 07:29:48','chengdu','成都',1),(2672,'510104','锦江区','104.080989,30.657689','district',2671,0,'J','2018-12-14 00:22:13','2019-02-23 07:29:48','jinjiangqu','锦江区',NULL),(2673,'510105','青羊区','104.055731,30.667648','district',2671,0,'Q','2018-12-14 00:22:14','2019-02-23 07:29:48','qingyangqu','青羊区',NULL),(2674,'510106','金牛区','104.043487,30.692058','district',2671,0,'J','2018-12-14 00:22:14','2019-02-23 07:29:48','jinniuqu','金牛区',NULL),(2675,'510107','武侯区','104.05167,30.630862','district',2671,0,'W','2018-12-14 00:22:14','2019-02-23 07:29:48','wuhouqu','武侯区',NULL),(2676,'510108','成华区','104.103077,30.660275','district',2671,0,'C','2018-12-14 00:22:14','2019-02-23 07:29:48','chenghuaqu','成华区',NULL),(2677,'510112','龙泉驿区','104.269181,30.56065','district',2671,0,'L','2018-12-14 00:22:14','2019-02-23 07:29:48','longquanyiqu','龙泉驿区',NULL),(2678,'510113','青白江区','104.25494,30.883438','district',2671,0,'Q','2018-12-14 00:22:14','2019-02-23 07:29:48','qingbaijiangqu','青白江区',NULL),(2679,'510114','新都区','104.16022,30.824223','district',2671,0,'X','2018-12-14 00:22:14','2019-02-23 07:29:48','xinduqu','新都区',NULL),(2680,'510115','温江区','103.836776,30.697996','district',2671,0,'W','2018-12-14 00:22:14','2019-02-23 07:29:48','wenjiangqu','温江区',NULL),(2681,'510116','双流区','103.922706,30.573243','district',2671,0,'S','2018-12-14 00:22:14','2019-02-23 07:29:48','shuangliuqu','双流区',NULL),(2682,'510117','郫都区','103.887842,30.808752','district',2671,0,'P','2018-12-14 00:22:14','2019-02-23 07:29:48','pidouqu','郫都区',NULL),(2683,'510121','金堂县','104.415604,30.858417','district',2671,0,'J','2018-12-14 00:22:14','2019-02-23 07:29:48','jintangxian','金堂县',NULL),(2684,'510129','大邑县','103.522397,30.586602','district',2671,0,'D','2018-12-14 00:22:14','2019-02-23 07:29:48','dayixian','大邑县',NULL),(2685,'510131','蒲江县','103.511541,30.194359','district',2671,0,'P','2018-12-14 00:22:14','2019-02-23 07:29:48','pujiangxian','蒲江县',NULL),(2686,'510132','新津县','103.812449,30.414284','district',2671,0,'X','2018-12-14 00:22:14','2019-02-23 07:29:48','xinjinxian','新津县',NULL),(2687,'510181','都江堰市','103.627898,30.99114','district',2671,0,'D','2018-12-14 00:22:14','2019-02-23 07:29:48','dujiangyan','都江堰',NULL),(2688,'510182','彭州市','103.941173,30.985161','district',2671,0,'P','2018-12-14 00:22:14','2019-02-23 07:29:48','pengzhou','彭州',NULL),(2689,'510183','邛崃市','103.46143,30.413271','district',2671,0,'Q','2018-12-14 00:22:14','2019-02-23 07:29:48','qionglai','邛崃',NULL),(2690,'510184','崇州市','103.671049,30.631478','district',2671,0,'C','2018-12-14 00:22:15','2019-02-23 07:29:48','chongzhou','崇州',NULL),(2691,'510185','简阳市','104.550339,30.390666','district',2671,0,'J','2018-12-14 00:22:15','2019-02-23 07:29:48','jianyang','简阳',NULL),(2692,'510300','自贡市','104.773447,29.352765','city',2670,0,'Z','2018-12-14 00:22:15','2019-02-23 07:29:48','zigong','自贡',NULL),(2693,'510302','自流井区','104.778188,29.343231','district',2692,0,'Z','2018-12-14 00:22:15','2019-02-23 07:29:48','ziliujingqu','自流井区',NULL),(2694,'510303','贡井区','104.714372,29.345675','district',2692,0,'G','2018-12-14 00:22:15','2019-02-23 07:29:48','gongjingqu','贡井区',NULL),(2695,'510304','大安区','104.783229,29.367136','district',2692,0,'D','2018-12-14 00:22:15','2019-02-23 07:29:48','daanqu','大安区',NULL),(2696,'510311','沿滩区','104.876417,29.272521','district',2692,0,'Y','2018-12-14 00:22:15','2019-02-23 07:29:48','yantanqu','沿滩区',NULL),(2697,'510321','荣县','104.423932,29.454851','district',2692,0,'R','2018-12-14 00:22:15','2019-02-23 07:29:48','rongxian','荣县',NULL),(2698,'510322','富顺县','104.984256,29.181282','district',2692,0,'F','2018-12-14 00:22:15','2019-02-23 07:29:48','fushunxian','富顺县',NULL),(2699,'510400','攀枝花市','101.716007,26.580446','city',2670,0,'P','2018-12-14 00:22:15','2019-02-23 07:29:48','panzhihua','攀枝花',NULL),(2700,'510402','东区','101.715134,26.580887','district',2699,0,'D','2018-12-14 00:22:15','2019-02-23 07:29:48','dongqu','东区',NULL),(2701,'510403','西区','101.637969,26.596776','district',2699,0,'X','2018-12-14 00:22:15','2019-02-23 07:29:48','xiqu','西区',NULL),(2702,'510411','仁和区','101.737916,26.497185','district',2699,0,'R','2018-12-14 00:22:15','2019-02-23 07:29:48','renhequ','仁和区',NULL),(2703,'510421','米易县','102.109877,26.887474','district',2699,0,'M','2018-12-14 00:22:15','2019-02-23 07:29:48','miyixian','米易县',NULL),(2704,'510422','盐边县','101.851848,26.677619','district',2699,0,'Y','2018-12-14 00:22:15','2019-02-23 07:29:48','yanbianxian','盐边县',NULL),(2705,'510500','泸州市','105.443348,28.889138','city',2670,0,'L','2018-12-14 00:22:15','2019-02-23 07:29:49','luzhou','泸州',NULL),(2706,'510502','江阳区','105.445131,28.882889','district',2705,0,'J','2018-12-14 00:22:15','2019-02-23 07:29:49','jiangyangqu','江阳区',NULL),(2707,'510503','纳溪区','105.37721,28.77631','district',2705,0,'N','2018-12-14 00:22:15','2019-02-23 07:29:49','naxiqu','纳溪区',NULL),(2708,'510504','龙马潭区','105.435228,28.897572','district',2705,0,'L','2018-12-14 00:22:16','2019-02-23 07:29:49','longmatanqu','龙马潭区',NULL),(2709,'510521','泸县','105.376335,29.151288','district',2705,0,'L','2018-12-14 00:22:16','2019-02-23 07:29:49','luxian','泸县',NULL),(2710,'510522','合江县','105.834098,28.810325','district',2705,0,'H','2018-12-14 00:22:16','2019-02-23 07:29:49','hejiangxian','合江县',NULL),(2711,'510524','叙永县','105.437775,28.167919','district',2705,0,'X','2018-12-14 00:22:16','2019-02-23 07:29:49','xuyongxian','叙永县',NULL),(2712,'510525','古蔺县','105.813359,28.03948','district',2705,0,'G','2018-12-14 00:22:16','2019-02-23 07:29:49','gulinxian','古蔺县',NULL),(2713,'510600','德阳市','104.398651,31.127991','city',2670,0,'D','2018-12-14 00:22:16','2019-02-23 07:29:49','deyang','德阳',NULL),(2714,'510603','旌阳区','104.389648,31.130428','district',2713,0,'J','2018-12-14 00:22:16','2019-02-23 07:29:49','jingyangqu','旌阳区',NULL),(2715,'510623','中江县','104.677831,31.03681','district',2713,0,'Z','2018-12-14 00:22:16','2019-02-23 07:29:49','zhongjiangxian','中江县',NULL),(2716,'510626','罗江区','104.507126,31.303281','district',2713,0,'L','2018-12-14 00:22:16','2019-02-23 07:29:49','luojiangqu','罗江区',NULL),(2717,'510681','广汉市','104.281903,30.97715','district',2713,0,'G','2018-12-14 00:22:16','2019-02-23 07:29:49','guanghan','广汉',NULL),(2718,'510682','什邡市','104.173653,31.126881','district',2713,0,'S','2018-12-14 00:22:16','2019-02-23 07:29:49','shifang','什邡',NULL),(2719,'510683','绵竹市','104.200162,31.343084','district',2713,0,'M','2018-12-14 00:22:16','2019-02-23 07:29:49','mianzhu','绵竹',NULL),(2720,'510700','绵阳市','104.741722,31.46402','city',2670,0,'M','2018-12-14 00:22:16','2019-02-23 07:29:49','mianyang','绵阳',NULL),(2721,'510703','涪城区','104.740971,31.463557','district',2720,0,'F','2018-12-14 00:22:16','2019-02-23 07:29:49','fuchengqu','涪城区',NULL),(2722,'510704','游仙区','104.770006,31.484772','district',2720,0,'Y','2018-12-14 00:22:16','2019-02-23 07:29:49','youxianqu','游仙区',NULL),(2723,'510705','安州区','104.560341,31.53894','district',2720,0,'A','2018-12-14 00:22:16','2019-02-23 07:29:49','anzhouqu','安州区',NULL),(2724,'510722','三台县','105.090316,31.090909','district',2720,0,'S','2018-12-14 00:22:16','2019-02-23 07:29:49','santaixian','三台县',NULL),(2725,'510723','盐亭县','105.391991,31.22318','district',2720,0,'Y','2018-12-14 00:22:16','2019-02-23 07:29:49','yantingxian','盐亭县',NULL),(2726,'510725','梓潼县','105.16353,31.635225','district',2720,0,'Z','2018-12-14 00:22:17','2019-02-23 07:29:49','zitongxian','梓潼县',NULL),(2727,'510726','北川羌族自治县','104.468069,31.615863','district',2720,0,'B','2018-12-14 00:22:17','2019-02-23 07:29:49','beichuanqiangzuzizhixian','北川羌族自治县',NULL),(2728,'510727','平武县','104.530555,32.407588','district',2720,0,'P','2018-12-14 00:22:17','2019-02-23 07:29:49','pingwuxian','平武县',NULL),(2729,'510781','江油市','104.744431,31.776386','district',2720,0,'J','2018-12-14 00:22:17','2019-02-23 07:29:49','jiangyou','江油',NULL),(2730,'510800','广元市','105.829757,32.433668','city',2670,0,'G','2018-12-14 00:22:17','2019-02-23 07:29:49','guangyuan','广元',NULL),(2731,'510802','利州区','105.826194,32.432276','district',2730,0,'L','2018-12-14 00:22:17','2019-02-23 07:29:49','lizhouqu','利州区',NULL),(2732,'510811','昭化区','105.964121,32.322788','district',2730,0,'Z','2018-12-14 00:22:17','2019-02-23 07:29:50','zhaohuaqu','昭化区',NULL),(2733,'510812','朝天区','105.88917,32.642632','district',2730,0,'C','2018-12-14 00:22:17','2019-02-23 07:29:50','chaotianqu','朝天区',NULL),(2734,'510821','旺苍县','106.290426,32.22833','district',2730,0,'W','2018-12-14 00:22:17','2019-02-23 07:29:50','wangcangxian','旺苍县',NULL),(2735,'510822','青川县','105.238847,32.585655','district',2730,0,'Q','2018-12-14 00:22:17','2019-02-23 07:29:50','qingchuanxian','青川县',NULL),(2736,'510823','剑阁县','105.527035,32.286517','district',2730,0,'J','2018-12-14 00:22:17','2019-02-23 07:29:50','jiangexian','剑阁县',NULL),(2737,'510824','苍溪县','105.939706,31.732251','district',2730,0,'C','2018-12-14 00:22:17','2019-02-23 07:29:50','cangxixian','苍溪县',NULL),(2738,'510900','遂宁市','105.571331,30.513311','city',2670,0,'S','2018-12-14 00:22:17','2019-02-23 07:29:50','suining','遂宁',NULL),(2739,'510903','船山区','105.582215,30.502647','district',2738,0,'C','2018-12-14 00:22:17','2019-02-23 07:29:50','chuanshanqu','船山区',NULL),(2740,'510904','安居区','105.459383,30.346121','district',2738,0,'A','2018-12-14 00:22:17','2019-02-23 07:29:50','anjuqu','安居区',NULL),(2741,'510921','蓬溪县','105.713699,30.774883','district',2738,0,'P','2018-12-14 00:22:17','2019-02-23 07:29:50','pengxixian','蓬溪县',NULL),(2742,'510922','射洪县','105.381849,30.868752','district',2738,0,'S','2018-12-14 00:22:17','2019-02-23 07:29:50','shehongxian','射洪县',NULL),(2743,'510923','大英县','105.252187,30.581571','district',2738,0,'D','2018-12-14 00:22:17','2019-02-23 07:29:50','dayingxian','大英县',NULL),(2744,'511000','内江市','105.066138,29.58708','city',2670,0,'N','2018-12-14 00:22:18','2019-02-23 07:29:50','neijiang','内江',NULL),(2745,'511002','市中区','105.065467,29.585265','district',2744,0,'S','2018-12-14 00:22:18','2019-02-23 07:29:50','zhongqu','中区',NULL),(2746,'511011','东兴区','105.067203,29.600107','district',2744,0,'D','2018-12-14 00:22:18','2019-02-23 07:29:50','dongxingqu','东兴区',NULL),(2747,'511024','威远县','104.668327,29.52686','district',2744,0,'W','2018-12-14 00:22:18','2019-02-23 07:29:50','weiyuanxian','威远县',NULL),(2748,'511025','资中县','104.852463,29.775295','district',2744,0,'Z','2018-12-14 00:22:18','2019-02-23 07:29:50','zizhongxian','资中县',NULL),(2749,'511083','隆昌市','105.288074,29.338162','district',2744,0,'L','2018-12-14 00:22:18','2019-02-23 07:29:50','longchang','隆昌',NULL),(2750,'511100','乐山市','103.761263,29.582024','city',2670,0,'L','2018-12-14 00:22:18','2019-02-23 07:29:50','leshan','乐山',NULL),(2751,'511102','市中区','103.75539,29.588327','district',2750,0,'S','2018-12-14 00:22:18','2019-02-23 07:29:50','zhongqu','中区',NULL),(2752,'511111','沙湾区','103.549961,29.416536','district',2750,0,'S','2018-12-14 00:22:18','2019-02-23 07:29:50','shawanqu','沙湾区',NULL),(2753,'511112','五通桥区','103.816837,29.406186','district',2750,0,'W','2018-12-14 00:22:18','2019-02-23 07:29:50','wutongqiaoqu','五通桥区',NULL),(2754,'511113','金口河区','103.077831,29.24602','district',2750,0,'J','2018-12-14 00:22:18','2019-02-23 07:29:50','jinkouhequ','金口河区',NULL),(2755,'511123','犍为县','103.944266,29.209782','district',2750,0,'Q','2018-12-14 00:22:18','2019-02-23 07:29:50','qianweixian','犍为县',NULL),(2756,'511124','井研县','104.06885,29.651645','district',2750,0,'J','2018-12-14 00:22:18','2019-02-23 07:29:50','jingyanxian','井研县',NULL),(2757,'511126','夹江县','103.578862,29.741019','district',2750,0,'J','2018-12-14 00:22:18','2019-02-23 07:29:50','jiajiangxian','夹江县',NULL),(2758,'511129','沐川县','103.90211,28.956338','district',2750,0,'M','2018-12-14 00:22:18','2019-02-23 07:29:50','muchuanxian','沐川县',NULL),(2759,'511132','峨边彝族自治县','103.262148,29.230271','district',2750,0,'E','2018-12-14 00:22:18','2019-02-23 07:29:50','ebianyizuzizhixian','峨边彝族自治县',NULL),(2760,'511133','马边彝族自治县','103.546851,28.838933','district',2750,0,'M','2018-12-14 00:22:18','2019-02-23 07:29:50','mabianyizuzizhixian','马边彝族自治县',NULL),(2761,'511181','峨眉山市','103.492488,29.597478','district',2750,0,'E','2018-12-14 00:22:18','2019-02-23 07:29:50','emeishan','峨眉山',NULL),(2762,'511300','南充市','106.082974,30.795281','city',2670,0,'N','2018-12-14 00:22:18','2019-02-23 07:29:50','nanchong','南充',NULL),(2763,'511302','顺庆区','106.084091,30.795572','district',2762,0,'S','2018-12-14 00:22:18','2019-02-23 07:29:50','shunqingqu','顺庆区',NULL),(2764,'511303','高坪区','106.108996,30.781809','district',2762,0,'G','2018-12-14 00:22:19','2019-02-23 07:29:50','gaopingqu','高坪区',NULL),(2765,'511304','嘉陵区','106.067027,30.762976','district',2762,0,'J','2018-12-14 00:22:19','2019-02-23 07:29:50','jialingqu','嘉陵区',NULL),(2766,'511321','南部县','106.061138,31.349407','district',2762,0,'N','2018-12-14 00:22:19','2019-02-23 07:29:50','nanbuxian','南部县',NULL),(2767,'511322','营山县','106.564893,31.075907','district',2762,0,'Y','2018-12-14 00:22:19','2019-02-23 07:29:50','yingshanxian','营山县',NULL),(2768,'511323','蓬安县','106.413488,31.027978','district',2762,0,'P','2018-12-14 00:22:19','2019-02-23 07:29:51','penganxian','蓬安县',NULL),(2769,'511324','仪陇县','106.297083,31.271261','district',2762,0,'Y','2018-12-14 00:22:19','2019-02-23 07:29:51','yilongxian','仪陇县',NULL),(2770,'511325','西充县','105.893021,30.994616','district',2762,0,'X','2018-12-14 00:22:19','2019-02-23 07:29:51','xichongxian','西充县',NULL),(2771,'511381','阆中市','105.975266,31.580466','district',2762,0,'L','2018-12-14 00:22:19','2019-02-23 07:29:51','langzhong','阆中',NULL),(2772,'511400','眉山市','103.831788,30.048318','city',2670,0,'M','2018-12-14 00:22:19','2019-02-23 07:29:51','meishan','眉山',NULL),(2773,'511402','东坡区','103.831553,30.048128','district',2772,0,'D','2018-12-14 00:22:19','2019-02-23 07:29:51','dongpoqu','东坡区',NULL),(2774,'511403','彭山区','103.8701,30.192298','district',2772,0,'P','2018-12-14 00:22:19','2019-02-23 07:29:51','pengshanqu','彭山区',NULL),(2775,'511421','仁寿县','104.147646,29.996721','district',2772,0,'R','2018-12-14 00:22:19','2019-02-23 07:29:51','renshouxian','仁寿县',NULL),(2776,'511423','洪雅县','103.375006,29.904867','district',2772,0,'H','2018-12-14 00:22:19','2019-02-23 07:29:51','hongyaxian','洪雅县',NULL),(2777,'511424','丹棱县','103.518333,30.012751','district',2772,0,'D','2018-12-14 00:22:19','2019-02-23 07:29:51','danlengxian','丹棱县',NULL),(2778,'511425','青神县','103.846131,29.831469','district',2772,0,'Q','2018-12-14 00:22:19','2019-02-23 07:29:51','qingshenxian','青神县',NULL),(2779,'511500','宜宾市','104.630825,28.760189','city',2670,0,'Y','2018-12-14 00:22:19','2019-02-23 07:29:51','yibin','宜宾',NULL),(2780,'511502','翠屏区','104.630231,28.760179','district',2779,0,'C','2018-12-14 00:22:19','2019-02-23 07:29:51','cuipingqu','翠屏区',NULL),(2781,'511503','南溪区','104.981133,28.839806','district',2779,0,'N','2018-12-14 00:22:19','2019-02-23 07:29:51','nanxiqu','南溪区',NULL),(2782,'511521','宜宾县','104.541489,28.695678','district',2779,0,'Y','2018-12-14 00:22:19','2019-02-23 07:29:51','yibinxian','宜宾县',NULL),(2783,'511523','江安县','105.068697,28.728102','district',2779,0,'J','2018-12-14 00:22:19','2019-02-23 07:29:51','jianganxian','江安县',NULL),(2784,'511524','长宁县','104.921116,28.577271','district',2779,0,'C','2018-12-14 00:22:19','2019-02-23 07:29:51','changningxian','长宁县',NULL),(2785,'511525','高县','104.519187,28.435676','district',2779,0,'G','2018-12-14 00:22:20','2019-02-23 07:29:51','gaoxian','高县',NULL),(2786,'511526','珙县','104.712268,28.449041','district',2779,0,'G','2018-12-14 00:22:20','2019-02-23 07:29:51','gongxian','珙县',NULL),(2787,'511527','筠连县','104.507848,28.162017','district',2779,0,'J','2018-12-14 00:22:20','2019-02-23 07:29:51','junlianxian','筠连县',NULL),(2788,'511528','兴文县','105.236549,28.302988','district',2779,0,'X','2018-12-14 00:22:20','2019-02-23 07:29:51','xingwenxian','兴文县',NULL),(2789,'511529','屏山县','104.162617,28.64237','district',2779,0,'P','2018-12-14 00:22:20','2019-02-23 07:29:51','pingshanxian','屏山县',NULL),(2790,'511600','广安市','106.633369,30.456398','city',2670,0,'G','2018-12-14 00:22:20','2019-02-23 07:29:51','guangan','广安',NULL),(2791,'511602','广安区','106.632907,30.456462','district',2790,0,'G','2018-12-14 00:22:20','2019-02-23 07:29:51','guanganqu','广安区',NULL),(2792,'511603','前锋区','106.893277,30.4963','district',2790,0,'Q','2018-12-14 00:22:20','2019-02-23 07:29:51','qianfengqu','前锋区',NULL),(2793,'511621','岳池县','106.444451,30.533538','district',2790,0,'Y','2018-12-14 00:22:20','2019-02-23 07:29:51','yuechixian','岳池县',NULL),(2794,'511622','武胜县','106.292473,30.344291','district',2790,0,'W','2018-12-14 00:22:20','2019-02-23 07:29:51','wushengxian','武胜县',NULL),(2795,'511623','邻水县','106.934968,30.334323','district',2790,0,'L','2018-12-14 00:22:20','2019-02-23 07:29:51','linshuixian','邻水县',NULL),(2796,'511681','华蓥市','106.777882,30.380574','district',2790,0,'H','2018-12-14 00:22:20','2019-02-23 07:29:51','huaying','华蓥',NULL),(2797,'511700','达州市','107.502262,31.209484','city',2670,0,'D','2018-12-14 00:22:20','2019-02-23 07:29:51','dazhou','达州',NULL),(2798,'511702','通川区','107.501062,31.213522','district',2797,0,'T','2018-12-14 00:22:20','2019-02-23 07:29:51','tongchuanqu','通川区',NULL),(2799,'511703','达川区','107.507926,31.199062','district',2797,0,'D','2018-12-14 00:22:20','2019-02-23 07:29:51','dachuanqu','达川区',NULL),(2800,'511722','宣汉县','107.722254,31.355025','district',2797,0,'X','2018-12-14 00:22:20','2019-02-23 07:29:51','xuanhanxian','宣汉县',NULL),(2801,'511723','开江县','107.864135,31.085537','district',2797,0,'K','2018-12-14 00:22:20','2019-02-23 07:29:51','kaijiangxian','开江县',NULL),(2802,'511724','大竹县','107.20742,30.736289','district',2797,0,'D','2018-12-14 00:22:20','2019-02-23 07:29:51','dazhuxian','大竹县',NULL),(2803,'511725','渠县','106.970746,30.836348','district',2797,0,'Q','2018-12-14 00:22:20','2019-02-23 07:29:52','quxian','渠县',NULL),(2804,'511781','万源市','108.037548,32.06777','district',2797,0,'W','2018-12-14 00:22:21','2019-02-23 07:29:52','wanyuan','万源',NULL),(2805,'511800','雅安市','103.001033,29.987722','city',2670,0,'Y','2018-12-14 00:22:21','2019-02-23 07:29:52','yaan','雅安',NULL),(2806,'511802','雨城区','103.003398,29.981831','district',2805,0,'Y','2018-12-14 00:22:21','2019-02-23 07:29:52','yuchengqu','雨城区',NULL),(2807,'511803','名山区','103.112214,30.084718','district',2805,0,'M','2018-12-14 00:22:21','2019-02-23 07:29:52','mingshanqu','名山区',NULL),(2808,'511822','荥经县','102.844674,29.795529','district',2805,0,'Y','2018-12-14 00:22:21','2019-02-23 07:29:52','yingjingxian','荥经县',NULL),(2809,'511823','汉源县','102.677145,29.349915','district',2805,0,'H','2018-12-14 00:22:21','2019-02-23 07:29:52','hanyuanxian','汉源县',NULL),(2810,'511824','石棉县','102.35962,29.234063','district',2805,0,'S','2018-12-14 00:22:21','2019-02-23 07:29:52','shimianxian','石棉县',NULL),(2811,'511825','天全县','102.763462,30.059955','district',2805,0,'T','2018-12-14 00:22:21','2019-02-23 07:29:52','tianquanxian','天全县',NULL),(2812,'511826','芦山县','102.924016,30.152907','district',2805,0,'L','2018-12-14 00:22:21','2019-02-23 07:29:52','lushanxian','芦山县',NULL),(2813,'511827','宝兴县','102.813377,30.369026','district',2805,0,'B','2018-12-14 00:22:21','2019-02-23 07:29:52','baoxingxian','宝兴县',NULL),(2814,'511900','巴中市','106.753669,31.858809','city',2670,0,'B','2018-12-14 00:22:21','2019-02-23 07:29:52','bazhong','巴中',NULL),(2815,'511902','巴州区','106.753671,31.858366','district',2814,0,'B','2018-12-14 00:22:21','2019-02-23 07:29:52','bazhouqu','巴州区',NULL),(2816,'511903','恩阳区','106.486515,31.816336','district',2814,0,'E','2018-12-14 00:22:21','2019-02-23 07:29:52','enyangqu','恩阳区',NULL),(2817,'511921','通江县','107.247621,31.91212','district',2814,0,'T','2018-12-14 00:22:21','2019-02-23 07:29:52','tongjiangxian','通江县',NULL),(2818,'511922','南江县','106.843418,32.353164','district',2814,0,'N','2018-12-14 00:22:21','2019-02-23 07:29:52','nanjiangxian','南江县',NULL),(2819,'511923','平昌县','107.101937,31.562814','district',2814,0,'P','2018-12-14 00:22:21','2019-02-23 07:29:52','pingchangxian','平昌县',NULL),(2820,'512000','资阳市','104.641917,30.122211','city',2670,0,'Z','2018-12-14 00:22:21','2019-02-23 07:29:52','ziyang','资阳',NULL),(2821,'512002','雁江区','104.642338,30.121686','district',2820,0,'Y','2018-12-14 00:22:21','2019-02-23 07:29:52','yanjiangqu','雁江区',NULL),(2822,'512021','安岳县','105.336764,30.099206','district',2820,0,'A','2018-12-14 00:22:21','2019-02-23 07:29:52','anyuexian','安岳县',NULL),(2823,'512022','乐至县','105.031142,30.275619','district',2820,0,'L','2018-12-14 00:22:21','2019-02-23 07:29:52','lezhixian','乐至县',NULL),(2824,'513200','阿坝藏族羌族自治州','102.221374,31.899792','city',2670,0,'A','2018-12-14 00:22:22','2019-02-23 07:29:52','abazangzuqiangzuzizhizhou','阿坝藏族羌族自治州',NULL),(2825,'513201','马尔康市','102.221187,31.899761','district',2824,0,'M','2018-12-14 00:22:22','2019-02-23 07:29:52','maerkang','马尔康',NULL),(2826,'513221','汶川县','103.580675,31.47463','district',2824,0,'W','2018-12-14 00:22:22','2019-02-23 07:29:52','wenchuanxian','汶川县',NULL),(2827,'513222','理县','103.165486,31.436764','district',2824,0,'L','2018-12-14 00:22:22','2019-02-23 07:29:52','lixian','理县',NULL),(2828,'513223','茂县','103.850684,31.680407','district',2824,0,'M','2018-12-14 00:22:22','2019-02-23 07:29:52','maoxian','茂县',NULL),(2829,'513224','松潘县','103.599177,32.63838','district',2824,0,'S','2018-12-14 00:22:22','2019-02-23 07:29:52','songpanxian','松潘县',NULL),(2830,'513225','九寨沟市','104.236344,33.262097','district',2824,0,'J','2018-12-14 00:22:22','2019-02-23 07:29:52','jiuzhaigou','九寨沟',NULL),(2831,'513226','金川县','102.064647,31.476356','district',2824,0,'J','2018-12-14 00:22:22','2019-02-23 07:29:52','jinchuanxian','金川县',NULL),(2832,'513227','小金县','102.363193,30.999016','district',2824,0,'X','2018-12-14 00:22:22','2019-02-23 07:29:52','xiaojinxian','小金县',NULL),(2833,'513228','黑水县','102.990805,32.061721','district',2824,0,'H','2018-12-14 00:22:22','2019-02-23 07:29:52','heishuixian','黑水县',NULL),(2834,'513230','壤塘县','100.979136,32.264887','district',2824,0,'R','2018-12-14 00:22:22','2019-02-23 07:29:52','rangtangxian','壤塘县',NULL),(2835,'513231','阿坝县','101.700985,32.904223','district',2824,0,'A','2018-12-14 00:22:22','2019-02-23 07:29:52','abaxian','阿坝县',NULL),(2836,'513232','若尔盖县','102.963726,33.575934','district',2824,0,'R','2018-12-14 00:22:22','2019-02-23 07:29:52','ruoergaixian','若尔盖县',NULL),(2837,'513233','红原县','102.544906,32.793902','district',2824,0,'H','2018-12-14 00:22:22','2019-02-23 07:29:52','hongyuanxian','红原县',NULL),(2838,'513300','甘孜藏族自治州','101.963815,30.050663','city',2670,0,'G','2018-12-14 00:22:22','2019-02-23 07:29:52','ganzizangzuzizhizhou','甘孜藏族自治州',NULL),(2839,'513301','康定市','101.964057,30.050738','district',2838,0,'K','2018-12-14 00:22:22','2019-02-23 07:29:53','kangding','康定',NULL),(2840,'513322','泸定县','102.233225,29.912482','district',2838,0,'L','2018-12-14 00:22:22','2019-02-23 07:29:53','ludingxian','泸定县',NULL),(2841,'513323','丹巴县','101.886125,30.877083','district',2838,0,'D','2018-12-14 00:22:22','2019-02-23 07:29:53','danbaxian','丹巴县',NULL),(2842,'513324','九龙县','101.506942,29.001975','district',2838,0,'J','2018-12-14 00:22:22','2019-02-23 07:29:53','jiulongxian','九龙县',NULL),(2843,'513325','雅江县','101.015735,30.03225','district',2838,0,'Y','2018-12-14 00:22:22','2019-02-23 07:29:53','yajiangxian','雅江县',NULL),(2844,'513326','道孚县','101.123327,30.978767','district',2838,0,'D','2018-12-14 00:22:22','2019-02-23 07:29:53','daofuxian','道孚县',NULL),(2845,'513327','炉霍县','100.679495,31.392674','district',2838,0,'L','2018-12-14 00:22:23','2019-02-23 07:29:53','luhuoxian','炉霍县',NULL),(2846,'513328','甘孜县','99.991753,31.61975','district',2838,0,'G','2018-12-14 00:22:23','2019-02-23 07:29:53','ganzixian','甘孜县',NULL),(2847,'513329','新龙县','100.312094,30.93896','district',2838,0,'X','2018-12-14 00:22:23','2019-02-23 07:29:53','xinlongxian','新龙县',NULL),(2848,'513330','德格县','98.57999,31.806729','district',2838,0,'D','2018-12-14 00:22:23','2019-02-23 07:29:53','degexian','德格县',NULL),(2849,'513331','白玉县','98.824343,31.208805','district',2838,0,'B','2018-12-14 00:22:23','2019-02-23 07:29:53','baiyuxian','白玉县',NULL),(2850,'513332','石渠县','98.100887,32.975302','district',2838,0,'S','2018-12-14 00:22:23','2019-02-23 07:29:53','shiquxian','石渠县',NULL),(2851,'513333','色达县','100.331657,32.268777','district',2838,0,'S','2018-12-14 00:22:23','2019-02-23 07:29:53','shaidaxian','色达县',NULL),(2852,'513334','理塘县','100.269862,29.991807','district',2838,0,'L','2018-12-14 00:22:23','2019-02-23 07:29:53','litangxian','理塘县',NULL),(2853,'513335','巴塘县','99.109037,30.005723','district',2838,0,'B','2018-12-14 00:22:23','2019-02-23 07:29:53','batangxian','巴塘县',NULL),(2854,'513336','乡城县','99.799943,28.930855','district',2838,0,'X','2018-12-14 00:22:23','2019-02-23 07:29:53','xiangchengxian','乡城县',NULL),(2855,'513337','稻城县','100.296689,29.037544','district',2838,0,'D','2018-12-14 00:22:23','2019-02-23 07:29:53','daochengxian','稻城县',NULL),(2856,'513338','得荣县','99.288036,28.71134','district',2838,0,'D','2018-12-14 00:22:23','2019-02-23 07:29:53','derongxian','得荣县',NULL),(2857,'513400','凉山彝族自治州','102.258746,27.886762','city',2670,0,'L','2018-12-14 00:22:23','2019-02-23 07:29:53','liangshanyizuzizhizhou','凉山彝族自治州',NULL),(2858,'513401','西昌市','102.258758,27.885786','district',2857,0,'X','2018-12-14 00:22:23','2019-02-23 07:29:53','xichang','西昌',NULL),(2859,'513422','木里藏族自治县','101.280184,27.926859','district',2857,0,'M','2018-12-14 00:22:23','2019-02-23 07:29:53','mulizangzuzizhixian','木里藏族自治县',NULL),(2860,'513423','盐源县','101.508909,27.423415','district',2857,0,'Y','2018-12-14 00:22:23','2019-02-23 07:29:53','yanyuanxian','盐源县',NULL),(2861,'513424','德昌县','102.178845,27.403827','district',2857,0,'D','2018-12-14 00:22:23','2019-02-23 07:29:53','dechangxian','德昌县',NULL),(2862,'513425','会理县','102.249548,26.658702','district',2857,0,'H','2018-12-14 00:22:23','2019-02-23 07:29:53','huilixian','会理县',NULL),(2863,'513426','会东县','102.578985,26.630713','district',2857,0,'H','2018-12-14 00:22:24','2019-02-23 07:29:53','huidongxian','会东县',NULL),(2864,'513427','宁南县','102.757374,27.065205','district',2857,0,'N','2018-12-14 00:22:24','2019-02-23 07:29:53','ningnanxian','宁南县',NULL),(2865,'513428','普格县','102.541082,27.376828','district',2857,0,'P','2018-12-14 00:22:24','2019-02-23 07:29:53','pugexian','普格县',NULL),(2866,'513429','布拖县','102.808801,27.709062','district',2857,0,'B','2018-12-14 00:22:24','2019-02-23 07:29:53','butuoxian','布拖县',NULL),(2867,'513430','金阳县','103.248704,27.695916','district',2857,0,'J','2018-12-14 00:22:24','2019-02-23 07:29:54','jinyangxian','金阳县',NULL),(2868,'513431','昭觉县','102.843991,28.010554','district',2857,0,'Z','2018-12-14 00:22:24','2019-02-23 07:29:54','zhaojuexian','昭觉县',NULL),(2869,'513432','喜德县','102.412342,28.305486','district',2857,0,'X','2018-12-14 00:22:24','2019-02-23 07:29:54','xidexian','喜德县',NULL),(2870,'513433','冕宁县','102.170046,28.550844','district',2857,0,'M','2018-12-14 00:22:24','2019-02-23 07:29:54','mianningxian','冕宁县',NULL),(2871,'513434','越西县','102.508875,28.639632','district',2857,0,'Y','2018-12-14 00:22:24','2019-02-23 07:29:54','yuexixian','越西县',NULL),(2872,'513435','甘洛县','102.775924,28.977094','district',2857,0,'G','2018-12-14 00:22:24','2019-02-23 07:29:54','ganluoxian','甘洛县',NULL),(2873,'513436','美姑县','103.132007,28.327946','district',2857,0,'M','2018-12-14 00:22:24','2019-02-23 07:29:54','meiguxian','美姑县',NULL),(2874,'513437','雷波县','103.571584,28.262946','district',2857,0,'L','2018-12-14 00:22:24','2019-02-23 07:29:54','leiboxian','雷波县',NULL),(2875,'520000','贵州省','106.713478,26.578343','province',0,5001,'G','2018-12-14 00:22:24','2019-02-23 07:29:54','guizhousheng','贵州省',NULL),(2876,'520100','贵阳市','106.713478,26.578343','city',2875,0,'G','2018-12-14 00:22:24','2019-02-23 07:29:54','guiyang','贵阳',NULL),(2877,'520102','南明区','106.715963,26.573743','district',2876,0,'N','2018-12-14 00:22:24','2019-02-23 07:29:54','nanmingqu','南明区',NULL),(2878,'520103','云岩区','106.713397,26.58301','district',2876,0,'Y','2018-12-14 00:22:24','2019-02-23 07:29:54','yunyanqu','云岩区',NULL),(2879,'520111','花溪区','106.670791,26.410464','district',2876,0,'H','2018-12-14 00:22:24','2019-02-23 07:29:54','huaxiqu','花溪区',NULL),(2880,'520112','乌当区','106.762123,26.630928','district',2876,0,'W','2018-12-14 00:22:24','2019-02-23 07:29:54','wudangqu','乌当区',NULL),(2881,'520113','白云区','106.633037,26.676849','district',2876,0,'B','2018-12-14 00:22:24','2019-02-23 07:29:54','baiyunqu','白云区',NULL),(2882,'520115','观山湖区','106.626323,26.646358','district',2876,0,'G','2018-12-14 00:22:25','2019-02-23 07:29:54','guanshanhuqu','观山湖区',NULL),(2883,'520121','开阳县','106.969438,27.056793','district',2876,0,'K','2018-12-14 00:22:25','2019-02-23 07:29:54','kaiyangxian','开阳县',NULL),(2884,'520122','息烽县','106.737693,27.092665','district',2876,0,'X','2018-12-14 00:22:25','2019-02-23 07:29:54','xifengxian','息烽县',NULL),(2885,'520123','修文县','106.599218,26.840672','district',2876,0,'X','2018-12-14 00:22:25','2019-02-23 07:29:54','xiuwenxian','修文县',NULL),(2886,'520181','清镇市','106.470278,26.551289','district',2876,0,'Q','2018-12-14 00:22:25','2019-02-23 07:29:54','qingzhen','清镇',NULL),(2887,'520200','六盘水市','104.846743,26.584643','city',2875,0,'L','2018-12-14 00:22:25','2019-02-23 07:29:54','liupanshui','六盘水',NULL),(2888,'520201','钟山区','104.846244,26.584805','district',2887,0,'Z','2018-12-14 00:22:25','2019-02-23 07:29:54','zhongshanqu','钟山区',NULL),(2889,'520203','六枝特区','105.474235,26.210662','district',2887,0,'L','2018-12-14 00:22:25','2019-02-23 07:29:54','luzhitequ','六枝特区',NULL),(2890,'520221','水城县','104.95685,26.540478','district',2887,0,'S','2018-12-14 00:22:25','2019-02-23 07:29:54','shuichengxian','水城县',NULL),(2891,'520281','盘州市','104.468367,25.706966','district',2887,0,'P','2018-12-14 00:22:25','2019-02-23 07:29:54','panzhou','盘州',NULL),(2892,'520300','遵义市','106.937265,27.706626','city',2875,0,'Z','2018-12-14 00:22:25','2019-02-23 07:29:54','zunyi','遵义',NULL),(2893,'520302','红花岗区','106.943784,27.694395','district',2892,0,'H','2018-12-14 00:22:25','2019-02-23 07:29:54','honghuagangqu','红花岗区',NULL),(2894,'520303','汇川区','106.937265,27.706626','district',2892,0,'H','2018-12-14 00:22:25','2019-02-23 07:29:54','huichuanqu','汇川区',NULL),(2895,'520304','播州区','106.831668,27.535288','district',2892,0,'B','2018-12-14 00:22:25','2019-02-23 07:29:54','bozhouqu','播州区',NULL),(2896,'520322','桐梓县','106.826591,28.131559','district',2892,0,'T','2018-12-14 00:22:25','2019-02-23 07:29:54','tongzixian','桐梓县',NULL),(2897,'520323','绥阳县','107.191024,27.951342','district',2892,0,'S','2018-12-14 00:22:26','2019-02-23 07:29:54','suiyangxian','绥阳县',NULL),(2898,'520324','正安县','107.441872,28.550337','district',2892,0,'Z','2018-12-14 00:22:26','2019-02-23 07:29:55','zhenganxian','正安县',NULL),(2899,'520325','道真仡佬族苗族自治县','107.605342,28.880088','district',2892,0,'D','2018-12-14 00:22:26','2019-02-23 07:29:55','daozhengelaozumiaozuzizhixian','道真仡佬族苗族自治县',NULL),(2900,'520326','务川仡佬族苗族自治县','107.887857,28.521567','district',2892,0,'W','2018-12-14 00:22:26','2019-02-23 07:29:55','wuchuangelaozumiaozuzizhixian','务川仡佬族苗族自治县',NULL),(2901,'520327','凤冈县','107.722021,27.960858','district',2892,0,'F','2018-12-14 00:22:26','2019-02-23 07:29:55','fenggangxian','凤冈县',NULL),(2902,'520328','湄潭县','107.485723,27.765839','district',2892,0,'M','2018-12-14 00:22:26','2019-02-23 07:29:55','meitanxian','湄潭县',NULL),(2903,'520329','余庆县','107.892566,27.221552','district',2892,0,'Y','2018-12-14 00:22:26','2019-02-23 07:29:55','yuqingxian','余庆县',NULL),(2904,'520330','习水县','106.200954,28.327826','district',2892,0,'X','2018-12-14 00:22:26','2019-02-23 07:29:55','xishuixian','习水县',NULL),(2905,'520381','赤水市','105.698116,28.587057','district',2892,0,'C','2018-12-14 00:22:26','2019-02-23 07:29:55','chishui','赤水',NULL),(2906,'520382','仁怀市','106.412476,27.803377','district',2892,0,'R','2018-12-14 00:22:26','2019-02-23 07:29:55','renhuai','仁怀',NULL),(2907,'520400','安顺市','105.932188,26.245544','city',2875,0,'A','2018-12-14 00:22:26','2019-02-23 07:29:55','anshun','安顺',NULL),(2908,'520402','西秀区','105.946169,26.248323','district',2907,0,'X','2018-12-14 00:22:26','2019-02-23 07:29:55','xixiuqu','西秀区',NULL),(2909,'520403','平坝区','106.259942,26.40608','district',2907,0,'P','2018-12-14 00:22:26','2019-02-23 07:29:55','pingbaqu','平坝区',NULL),(2910,'520422','普定县','105.745609,26.305794','district',2907,0,'P','2018-12-14 00:22:26','2019-02-23 07:29:55','pudingxian','普定县',NULL),(2911,'520423','镇宁布依族苗族自治县','105.768656,26.056096','district',2907,0,'Z','2018-12-14 00:22:26','2019-02-23 07:29:55','zhenningbuyizumiaozuzizhixian','镇宁布依族苗族自治县',NULL),(2912,'520424','关岭布依族苗族自治县','105.618454,25.944248','district',2907,0,'G','2018-12-14 00:22:26','2019-02-23 07:29:55','guanlingbuyizumiaozuzizhixian','关岭布依族苗族自治县',NULL),(2913,'520425','紫云苗族布依族自治县','106.084515,25.751567','district',2907,0,'Z','2018-12-14 00:22:27','2019-02-23 07:29:55','ziyunmiaozubuyizuzizhixian','紫云苗族布依族自治县',NULL),(2914,'520500','毕节市','105.28501,27.301693','city',2875,0,'B','2018-12-14 00:22:27','2019-02-23 07:29:55','bijie','毕节',NULL),(2915,'520502','七星关区','105.284852,27.302085','district',2914,0,'Q','2018-12-14 00:22:27','2019-02-23 07:29:55','qixingguanqu','七星关区',NULL),(2916,'520521','大方县','105.609254,27.143521','district',2914,0,'D','2018-12-14 00:22:27','2019-02-23 07:29:55','dafangxian','大方县',NULL),(2917,'520522','黔西县','106.038299,27.024923','district',2914,0,'Q','2018-12-14 00:22:27','2019-02-23 07:29:55','qianxixian','黔西县',NULL),(2918,'520523','金沙县','106.222103,27.459693','district',2914,0,'J','2018-12-14 00:22:27','2019-02-23 07:29:55','jinshaxian','金沙县',NULL),(2919,'520524','织金县','105.768997,26.668497','district',2914,0,'Z','2018-12-14 00:22:27','2019-02-23 07:29:55','zhijinxian','织金县',NULL),(2920,'520525','纳雍县','105.375322,26.769875','district',2914,0,'N','2018-12-14 00:22:27','2019-02-23 07:29:55','nayongxian','纳雍县',NULL),(2921,'520526','威宁彝族回族苗族自治县','104.286523,26.859099','district',2914,0,'W','2018-12-14 00:22:27','2019-02-23 07:29:55','weiningyizuhuizumiaozuzizhixian','威宁彝族回族苗族自治县',NULL),(2922,'520527','赫章县','104.726438,27.119243','district',2914,0,'H','2018-12-14 00:22:27','2019-02-23 07:29:55','hezhangxian','赫章县',NULL),(2923,'520600','铜仁市','109.191555,27.718346','city',2875,0,'T','2018-12-14 00:22:27','2019-02-23 07:29:55','tongren','铜仁',NULL),(2924,'520602','碧江区','109.192117,27.718745','district',2923,0,'B','2018-12-14 00:22:27','2019-02-23 07:29:55','bijiangqu','碧江区',NULL),(2925,'520603','万山区','109.21199,27.51903','district',2923,0,'W','2018-12-14 00:22:27','2019-02-23 07:29:55','wanshanqu','万山区',NULL),(2926,'520621','江口县','108.848427,27.691904','district',2923,0,'J','2018-12-14 00:22:27','2019-02-23 07:29:55','jiangkouxian','江口县',NULL),(2927,'520622','玉屏侗族自治县','108.917882,27.238024','district',2923,0,'Y','2018-12-14 00:22:27','2019-02-23 07:29:55','yupingdongzuzizhixian','玉屏侗族自治县',NULL),(2928,'520623','石阡县','108.229854,27.519386','district',2923,0,'S','2018-12-14 00:22:28','2019-02-23 07:29:55','shiqianxian','石阡县',NULL),(2929,'520624','思南县','108.255827,27.941331','district',2923,0,'S','2018-12-14 00:22:28','2019-02-23 07:29:55','sinanxian','思南县',NULL),(2930,'520625','印江土家族苗族自治县','108.405517,27.997976','district',2923,0,'Y','2018-12-14 00:22:28','2019-02-23 07:29:55','yinjiangtujiazumiaozuzizhixian','印江土家族苗族自治县',NULL),(2931,'520626','德江县','108.117317,28.26094','district',2923,0,'D','2018-12-14 00:22:28','2019-02-23 07:29:55','dejiangxian','德江县',NULL),(2932,'520627','沿河土家族自治县','108.495746,28.560487','district',2923,0,'Y','2018-12-14 00:22:28','2019-02-23 07:29:55','yanhetujiazuzizhixian','沿河土家族自治县',NULL),(2933,'520628','松桃苗族自治县','109.202627,28.165419','district',2923,0,'S','2018-12-14 00:22:28','2019-02-23 07:29:56','songtaomiaozuzizhixian','松桃苗族自治县',NULL),(2934,'522300','黔西南布依族苗族自治州','104.897971,25.08812','city',2875,0,'Q','2018-12-14 00:22:28','2019-02-23 07:29:56','qianxinanbuyizumiaozuzizhizhou','黔西南布依族苗族自治州',NULL),(2935,'522301','兴义市','104.897982,25.088599','district',2934,0,'X','2018-12-14 00:22:28','2019-02-23 07:29:56','xingyi','兴义',NULL),(2936,'522322','兴仁县','105.192778,25.431378','district',2934,0,'X','2018-12-14 00:22:28','2019-02-23 07:29:56','xingrenxian','兴仁县',NULL),(2937,'522323','普安县','104.955347,25.786404','district',2934,0,'P','2018-12-14 00:22:28','2019-02-23 07:29:56','puanxian','普安县',NULL),(2938,'522324','晴隆县','105.218773,25.832881','district',2934,0,'Q','2018-12-14 00:22:28','2019-02-23 07:29:56','qinglongxian','晴隆县',NULL),(2939,'522325','贞丰县','105.650133,25.385752','district',2934,0,'Z','2018-12-14 00:22:28','2019-02-23 07:29:56','zhenfengxian','贞丰县',NULL),(2940,'522326','望谟县','106.091563,25.166667','district',2934,0,'W','2018-12-14 00:22:28','2019-02-23 07:29:56','wangmoxian','望谟县',NULL),(2941,'522327','册亨县','105.81241,24.983338','district',2934,0,'C','2018-12-14 00:22:28','2019-02-23 07:29:56','cehengxian','册亨县',NULL),(2942,'522328','安龙县','105.471498,25.108959','district',2934,0,'A','2018-12-14 00:22:28','2019-02-23 07:29:56','anlongxian','安龙县',NULL),(2943,'522600','黔东南苗族侗族自治州','107.977488,26.583352','city',2875,0,'Q','2018-12-14 00:22:28','2019-02-23 07:29:56','qiandongnanmiaozudongzuzizhizhou','黔东南苗族侗族自治州',NULL),(2944,'522601','凯里市','107.977541,26.582964','district',2943,0,'K','2018-12-14 00:22:28','2019-02-23 07:29:56','kaili','凯里',NULL),(2945,'522622','黄平县','107.901337,26.896973','district',2943,0,'H','2018-12-14 00:22:28','2019-02-23 07:29:56','huangpingxian','黄平县',NULL),(2946,'522623','施秉县','108.12678,27.034657','district',2943,0,'S','2018-12-14 00:22:29','2019-02-23 07:29:56','shibingxian','施秉县',NULL),(2947,'522624','三穗县','108.681121,26.959884','district',2943,0,'S','2018-12-14 00:22:29','2019-02-23 07:29:56','sansuixian','三穗县',NULL),(2948,'522625','镇远县','108.423656,27.050233','district',2943,0,'Z','2018-12-14 00:22:29','2019-02-23 07:29:56','zhenyuanxian','镇远县',NULL),(2949,'522626','岑巩县','108.816459,27.173244','district',2943,0,'C','2018-12-14 00:22:29','2019-02-23 07:29:56','cengongxian','岑巩县',NULL),(2950,'522627','天柱县','109.212798,26.909684','district',2943,0,'T','2018-12-14 00:22:29','2019-02-23 07:29:56','tianzhuxian','天柱县',NULL),(2951,'522628','锦屏县','109.20252,26.680625','district',2943,0,'J','2018-12-14 00:22:29','2019-02-23 07:29:56','jinpingxian','锦屏县',NULL),(2952,'522629','剑河县','108.440499,26.727349','district',2943,0,'J','2018-12-14 00:22:29','2019-02-23 07:29:56','jianhexian','剑河县',NULL),(2953,'522630','台江县','108.314637,26.669138','district',2943,0,'T','2018-12-14 00:22:29','2019-02-23 07:29:56','taijiangxian','台江县',NULL),(2954,'522631','黎平县','109.136504,26.230636','district',2943,0,'L','2018-12-14 00:22:29','2019-02-23 07:29:56','lipingxian','黎平县',NULL),(2955,'522632','榕江县','108.521026,25.931085','district',2943,0,'R','2018-12-14 00:22:29','2019-02-23 07:29:56','rongjiangxian','榕江县',NULL),(2956,'522633','从江县','108.912648,25.747058','district',2943,0,'C','2018-12-14 00:22:29','2019-02-23 07:29:56','congjiangxian','从江县',NULL),(2957,'522634','雷山县','108.079613,26.381027','district',2943,0,'L','2018-12-14 00:22:29','2019-02-23 07:29:56','leishanxian','雷山县',NULL),(2958,'522635','麻江县','107.593172,26.494803','district',2943,0,'M','2018-12-14 00:22:29','2019-02-23 07:29:56','majiangxian','麻江县',NULL),(2959,'522636','丹寨县','107.794808,26.199497','district',2943,0,'D','2018-12-14 00:22:29','2019-02-23 07:29:56','danzhaixian','丹寨县',NULL),(2960,'522700','黔南布依族苗族自治州','107.517156,26.258219','city',2875,0,'Q','2018-12-14 00:22:29','2019-02-23 07:29:56','qiannanbuyizumiaozuzizhizhou','黔南布依族苗族自治州',NULL),(2961,'522701','都匀市','107.517021,26.258205','district',2960,0,'D','2018-12-14 00:22:29','2019-02-23 07:29:56','duyun','都匀',NULL),(2962,'522702','福泉市','107.513508,26.702508','district',2960,0,'F','2018-12-14 00:22:29','2019-02-23 07:29:56','fuquan','福泉',NULL),(2963,'522722','荔波县','107.8838,25.412239','district',2960,0,'L','2018-12-14 00:22:29','2019-02-23 07:29:56','liboxian','荔波县',NULL),(2964,'522723','贵定县','107.233588,26.580807','district',2960,0,'G','2018-12-14 00:22:29','2019-02-23 07:29:56','guidingxian','贵定县',NULL),(2965,'522725','瓮安县','107.478417,27.066339','district',2960,0,'W','2018-12-14 00:22:30','2019-02-23 07:29:56','wenganxian','瓮安县',NULL),(2966,'522726','独山县','107.542757,25.826283','district',2960,0,'D','2018-12-14 00:22:30','2019-02-23 07:29:57','dushanxian','独山县',NULL),(2967,'522727','平塘县','107.32405,25.831803','district',2960,0,'P','2018-12-14 00:22:30','2019-02-23 07:29:57','pingtangxian','平塘县',NULL),(2968,'522728','罗甸县','106.750006,25.429894','district',2960,0,'L','2018-12-14 00:22:30','2019-02-23 07:29:57','luodianxian','罗甸县',NULL),(2969,'522729','长顺县','106.447376,26.022116','district',2960,0,'C','2018-12-14 00:22:30','2019-02-23 07:29:57','changshunxian','长顺县',NULL),(2970,'522730','龙里县','106.977733,26.448809','district',2960,0,'L','2018-12-14 00:22:30','2019-02-23 07:29:57','longlixian','龙里县',NULL),(2971,'522731','惠水县','106.657848,26.128637','district',2960,0,'H','2018-12-14 00:22:30','2019-02-23 07:29:57','huishuixian','惠水县',NULL),(2972,'522732','三都水族自治县','107.87747,25.985183','district',2960,0,'S','2018-12-14 00:22:30','2019-02-23 07:29:57','sandoushuizuzizhixian','三都水族自治县',NULL),(2973,'530000','云南省','102.712251,25.040609','province',0,3800,'Y','2018-12-14 00:22:30','2019-02-23 07:29:57','yunnansheng','云南省',NULL),(2974,'530100','昆明市','102.712251,25.040609','city',2973,0,'K','2018-12-14 00:22:30','2019-02-23 07:29:57','kunming','昆明',NULL),(2975,'530102','五华区','102.704412,25.042165','district',2974,0,'W','2018-12-14 00:22:30','2019-02-23 07:29:57','wuhuaqu','五华区',NULL),(2976,'530103','盘龙区','102.729044,25.070239','district',2974,0,'P','2018-12-14 00:22:30','2019-02-23 07:29:57','panlongqu','盘龙区',NULL),(2977,'530111','官渡区','102.723437,25.021211','district',2974,0,'G','2018-12-14 00:22:30','2019-02-23 07:29:57','guanduqu','官渡区',NULL),(2978,'530112','西山区','102.705904,25.02436','district',2974,0,'X','2018-12-14 00:22:30','2019-02-23 07:29:57','xishanqu','西山区',NULL),(2979,'530113','东川区','103.182,26.08349','district',2974,0,'D','2018-12-14 00:22:30','2019-02-23 07:29:57','dongchuanqu','东川区',NULL),(2980,'530114','呈贡区','102.801382,24.889275','district',2974,0,'C','2018-12-14 00:22:30','2019-02-23 07:29:57','chenggongqu','呈贡区',NULL),(2981,'530115','晋宁区','102.594987,24.666944','district',2974,0,'J','2018-12-14 00:22:30','2019-02-23 07:29:57','jinningqu','晋宁区',NULL),(2982,'530124','富民县','102.497888,25.219667','district',2974,0,'F','2018-12-14 00:22:30','2019-02-23 07:29:57','fuminxian','富民县',NULL),(2983,'530125','宜良县','103.145989,24.918215','district',2974,0,'Y','2018-12-14 00:22:30','2019-02-23 07:29:57','yiliangxian','宜良县',NULL),(2984,'530126','石林彝族自治县','103.271962,24.754545','district',2974,0,'S','2018-12-14 00:22:31','2019-02-23 07:29:57','shilinyizuzizhixian','石林彝族自治县',NULL),(2985,'530127','嵩明县','103.038777,25.335087','district',2974,0,'S','2018-12-14 00:22:31','2019-02-23 07:29:57','songmingxian','嵩明县',NULL),(2986,'530128','禄劝彝族苗族自治县','102.46905,25.556533','district',2974,0,'L','2018-12-14 00:22:31','2019-02-23 07:29:57','luquanyizumiaozuzizhixian','禄劝彝族苗族自治县',NULL),(2987,'530129','寻甸回族彝族自治县','103.257588,25.559474','district',2974,0,'X','2018-12-14 00:22:31','2019-02-23 07:29:57','xundianhuizuyizuzizhixian','寻甸回族彝族自治县',NULL),(2988,'530181','安宁市','102.485544,24.921785','district',2974,0,'A','2018-12-14 00:22:31','2019-02-23 07:29:57','anning','安宁',NULL),(2989,'530300','曲靖市','103.797851,25.501557','city',2973,0,'Q','2018-12-14 00:22:31','2019-02-23 07:29:57','qujing','曲靖',NULL),(2990,'530302','麒麟区','103.798054,25.501269','district',2989,0,'Q','2018-12-14 00:22:31','2019-02-23 07:29:57','qilinqu','麒麟区',NULL),(2991,'530303','沾益区','103.819262,25.600878','district',2989,0,'Z','2018-12-14 00:22:31','2019-02-23 07:29:57','zhanyiqu','沾益区',NULL),(2992,'530321','马龙县','103.578755,25.429451','district',2989,0,'M','2018-12-14 00:22:31','2019-02-23 07:29:57','malongxian','马龙县',NULL),(2993,'530322','陆良县','103.655233,25.022878','district',2989,0,'L','2018-12-14 00:22:31','2019-02-23 07:29:57','luliangxian','陆良县',NULL),(2994,'530323','师宗县','103.993808,24.825681','district',2989,0,'S','2018-12-14 00:22:31','2019-02-23 07:29:57','shizongxian','师宗县',NULL),(2995,'530324','罗平县','104.309263,24.885708','district',2989,0,'L','2018-12-14 00:22:31','2019-02-23 07:29:57','luopingxian','罗平县',NULL),(2996,'530325','富源县','104.25692,25.67064','district',2989,0,'F','2018-12-14 00:22:31','2019-02-23 07:29:57','fuyuanxian','富源县',NULL),(2997,'530326','会泽县','103.300041,26.412861','district',2989,0,'H','2018-12-14 00:22:31','2019-02-23 07:29:57','huizexian','会泽县',NULL),(2998,'530381','宣威市','104.09554,26.227777','district',2989,0,'X','2018-12-14 00:22:31','2019-02-23 07:29:57','xuanwei','宣威',NULL),(2999,'530400','玉溪市','102.543907,24.350461','city',2973,0,'Y','2018-12-14 00:22:31','2019-02-23 07:29:57','yuxi','玉溪',NULL),(3000,'530402','红塔区','102.543468,24.350753','district',2999,0,'H','2018-12-14 00:22:32','2019-02-23 07:29:57','hongtaqu','红塔区',NULL),(3001,'530403','江川区','102.749839,24.291006','district',2999,0,'J','2018-12-14 00:22:32','2019-02-23 07:29:58','jiangchuanqu','江川区',NULL),(3002,'530422','澄江县','102.916652,24.669679','district',2999,0,'C','2018-12-14 00:22:32','2019-02-23 07:29:58','chengjiangxian','澄江县',NULL),(3003,'530423','通海县','102.760039,24.112205','district',2999,0,'T','2018-12-14 00:22:32','2019-02-23 07:29:58','tonghaixian','通海县',NULL),(3004,'530424','华宁县','102.928982,24.189807','district',2999,0,'H','2018-12-14 00:22:32','2019-02-23 07:29:58','huaningxian','华宁县',NULL),(3005,'530425','易门县','102.16211,24.669598','district',2999,0,'Y','2018-12-14 00:22:32','2019-02-23 07:29:58','yimenxian','易门县',NULL),(3006,'530426','峨山彝族自治县','102.404358,24.173256','district',2999,0,'E','2018-12-14 00:22:32','2019-02-23 07:29:58','eshanyizuzizhixian','峨山彝族自治县',NULL),(3007,'530427','新平彝族傣族自治县','101.990903,24.0664','district',2999,0,'X','2018-12-14 00:22:32','2019-02-23 07:29:58','xinpingyizudaizuzizhixian','新平彝族傣族自治县',NULL),(3008,'530428','元江哈尼族彝族傣族自治县','101.999658,23.597618','district',2999,0,'Y','2018-12-14 00:22:32','2019-02-23 07:29:58','yuanjianghanizuyizudaizuzizhixian','元江哈尼族彝族傣族自治县',NULL),(3009,'530500','保山市','99.167133,25.111802','city',2973,0,'B','2018-12-14 00:22:32','2019-02-23 07:29:58','baoshan','保山',NULL),(3010,'530502','隆阳区','99.165825,25.112144','district',3009,0,'L','2018-12-14 00:22:32','2019-02-23 07:29:58','longyangqu','隆阳区',NULL),(3011,'530521','施甸县','99.183758,24.730847','district',3009,0,'S','2018-12-14 00:22:32','2019-02-23 07:29:58','shidianxian','施甸县',NULL),(3012,'530523','龙陵县','98.693567,24.591912','district',3009,0,'L','2018-12-14 00:22:32','2019-02-23 07:29:58','longlingxian','龙陵县',NULL),(3013,'530524','昌宁县','99.612344,24.823662','district',3009,0,'C','2018-12-14 00:22:32','2019-02-23 07:29:58','changningxian','昌宁县',NULL),(3014,'530581','腾冲市','98.497292,25.01757','district',3009,0,'T','2018-12-14 00:22:32','2019-02-23 07:29:58','tengchong','腾冲',NULL),(3015,'530600','昭通市','103.717216,27.336999','city',2973,0,'Z','2018-12-14 00:22:32','2019-02-23 07:29:58','zhaotong','昭通',NULL),(3016,'530602','昭阳区','103.717267,27.336636','district',3015,0,'Z','2018-12-14 00:22:32','2019-02-23 07:29:58','zhaoyangqu','昭阳区',NULL),(3017,'530621','鲁甸县','103.549333,27.191637','district',3015,0,'L','2018-12-14 00:22:32','2019-02-23 07:29:58','ludianxian','鲁甸县',NULL),(3018,'530622','巧家县','102.929284,26.9117','district',3015,0,'Q','2018-12-14 00:22:33','2019-02-23 07:29:58','qiaojiaxian','巧家县',NULL),(3019,'530623','盐津县','104.23506,28.106923','district',3015,0,'Y','2018-12-14 00:22:33','2019-02-23 07:29:58','yanjinxian','盐津县',NULL),(3020,'530624','大关县','103.891608,27.747114','district',3015,0,'D','2018-12-14 00:22:33','2019-02-23 07:29:58','daguanxian','大关县',NULL),(3021,'530625','永善县','103.63732,28.231526','district',3015,0,'Y','2018-12-14 00:22:33','2019-02-23 07:29:58','yongshanxian','永善县',NULL),(3022,'530626','绥江县','103.961095,28.599953','district',3015,0,'S','2018-12-14 00:22:33','2019-02-23 07:29:58','suijiangxian','绥江县',NULL),(3023,'530627','镇雄县','104.873055,27.436267','district',3015,0,'Z','2018-12-14 00:22:33','2019-02-23 07:29:58','zhenxiongxian','镇雄县',NULL),(3024,'530628','彝良县','104.048492,27.627425','district',3015,0,'Y','2018-12-14 00:22:33','2019-02-23 07:29:58','yiliangxian','彝良县',NULL),(3025,'530629','威信县','105.04869,27.843381','district',3015,0,'W','2018-12-14 00:22:33','2019-02-23 07:29:58','weixinxian','威信县',NULL),(3026,'530630','水富县','104.415376,28.629688','district',3015,0,'S','2018-12-14 00:22:33','2019-02-23 07:29:58','shuifuxian','水富县',NULL),(3027,'530700','丽江市','100.233026,26.872108','city',2973,0,'L','2018-12-14 00:22:33','2019-02-23 07:29:58','lijiang','丽江',NULL),(3028,'530702','古城区','100.234412,26.872229','district',3027,0,'G','2018-12-14 00:22:33','2019-02-23 07:29:58','guchengqu','古城区',NULL),(3029,'530721','玉龙纳西族自治县','100.238312,26.830593','district',3027,0,'Y','2018-12-14 00:22:33','2019-02-23 07:29:58','yulongnaxizuzizhixian','玉龙纳西族自治县',NULL),(3030,'530722','永胜县','100.750901,26.685623','district',3027,0,'Y','2018-12-14 00:22:33','2019-02-23 07:29:58','yongshengxian','永胜县',NULL),(3031,'530723','华坪县','101.267796,26.628834','district',3027,0,'H','2018-12-14 00:22:33','2019-02-23 07:29:59','huapingxian','华坪县',NULL),(3032,'530724','宁蒗彝族自治县','100.852427,27.281109','district',3027,0,'N','2018-12-14 00:22:33','2019-02-23 07:29:59','ninglangyizuzizhixian','宁蒗彝族自治县',NULL),(3033,'530800','普洱市','100.972344,22.777321','city',2973,0,'P','2018-12-14 00:22:33','2019-02-23 07:29:59','puer','普洱',NULL),(3034,'530802','思茅区','100.973227,22.776595','district',3033,0,'S','2018-12-14 00:22:33','2019-02-23 07:29:59','simaoqu','思茅区',NULL),(3035,'530821','宁洱哈尼族彝族自治县','101.04524,23.062507','district',3033,0,'N','2018-12-14 00:22:33','2019-02-23 07:29:59','ningerhanizuyizuzizhixian','宁洱哈尼族彝族自治县',NULL),(3036,'530822','墨江哈尼族自治县','101.687606,23.428165','district',3033,0,'M','2018-12-14 00:22:34','2019-02-23 07:29:59','mojianghanizuzizhixian','墨江哈尼族自治县',NULL),(3037,'530823','景东彝族自治县','100.840011,24.448523','district',3033,0,'J','2018-12-14 00:22:34','2019-02-23 07:29:59','jingdongyizuzizhixian','景东彝族自治县',NULL),(3038,'530824','景谷傣族彝族自治县','100.701425,23.500278','district',3033,0,'J','2018-12-14 00:22:34','2019-02-23 07:29:59','jinggudaizuyizuzizhixian','景谷傣族彝族自治县',NULL),(3039,'530825','镇沅彝族哈尼族拉祜族自治县','101.108512,24.005712','district',3033,0,'Z','2018-12-14 00:22:34','2019-02-23 07:29:59','zhenyuanyizuhanizulahuzuzizhixian','镇沅彝族哈尼族拉祜族自治县',NULL),(3040,'530826','江城哈尼族彝族自治县','101.859144,22.58336','district',3033,0,'J','2018-12-14 00:22:34','2019-02-23 07:29:59','jiangchenghanizuyizuzizhixian','江城哈尼族彝族自治县',NULL),(3041,'530827','孟连傣族拉祜族佤族自治县','99.585406,22.325924','district',3033,0,'M','2018-12-14 00:22:34','2019-02-23 07:29:59','mengliandaizulahuzuwazuzizhixian','孟连傣族拉祜族佤族自治县',NULL),(3042,'530828','澜沧拉祜族自治县','99.931201,22.553083','district',3033,0,'L','2018-12-14 00:22:34','2019-02-23 07:29:59','lancanglahuzuzizhixian','澜沧拉祜族自治县',NULL),(3043,'530829','西盟佤族自治县','99.594372,22.644423','district',3033,0,'X','2018-12-14 00:22:34','2019-02-23 07:29:59','ximengwazuzizhixian','西盟佤族自治县',NULL),(3044,'530900','临沧市','100.08697,23.886567','city',2973,0,'L','2018-12-14 00:22:34','2019-02-23 07:29:59','lincang','临沧',NULL),(3045,'530902','临翔区','100.086486,23.886562','district',3044,0,'L','2018-12-14 00:22:34','2019-02-23 07:29:59','linxiangqu','临翔区',NULL),(3046,'530921','凤庆县','99.91871,24.592738','district',3044,0,'F','2018-12-14 00:22:34','2019-02-23 07:29:59','fengqingxian','凤庆县',NULL),(3047,'530922','云县','100.125637,24.439026','district',3044,0,'Y','2018-12-14 00:22:34','2019-02-23 07:29:59','yunxian','云县',NULL),(3048,'530923','永德县','99.253679,24.028159','district',3044,0,'Y','2018-12-14 00:22:34','2019-02-23 07:29:59','yongdexian','永德县',NULL),(3049,'530924','镇康县','98.82743,23.761415','district',3044,0,'Z','2018-12-14 00:22:34','2019-02-23 07:29:59','zhenkangxian','镇康县',NULL),(3050,'530925','双江拉祜族佤族布朗族傣族自治县','99.824419,23.477476','district',3044,0,'S','2018-12-14 00:22:34','2019-02-23 07:29:59','shuangjianglahuzuwazubulangzudaizuzizhixian','双江拉祜族佤族布朗族傣族自治县',NULL),(3051,'530926','耿马傣族佤族自治县','99.402495,23.534579','district',3044,0,'G','2018-12-14 00:22:34','2019-02-23 07:29:59','gengmadaizuwazuzizhixian','耿马傣族佤族自治县',NULL),(3052,'530927','沧源佤族自治县','99.2474,23.146887','district',3044,0,'C','2018-12-14 00:22:34','2019-02-23 07:29:59','cangyuanwazuzizhixian','沧源佤族自治县',NULL),(3053,'532300','楚雄彝族自治州','101.546046,25.041988','city',2973,0,'C','2018-12-14 00:22:34','2019-02-23 07:29:59','chuxiongyizuzizhizhou','楚雄彝族自治州',NULL),(3054,'532301','楚雄市','101.546145,25.040912','district',3053,0,'C','2018-12-14 00:22:35','2019-02-23 07:29:59','chuxiong','楚雄',NULL),(3055,'532322','双柏县','101.63824,24.685094','district',3053,0,'S','2018-12-14 00:22:35','2019-02-23 07:29:59','shuangbaixian','双柏县',NULL),(3056,'532323','牟定县','101.543044,25.312111','district',3053,0,'M','2018-12-14 00:22:35','2019-02-23 07:29:59','moudingxian','牟定县',NULL),(3057,'532324','南华县','101.274991,25.192408','district',3053,0,'N','2018-12-14 00:22:35','2019-02-23 07:29:59','nanhuaxian','南华县',NULL),(3058,'532325','姚安县','101.238399,25.505403','district',3053,0,'Y','2018-12-14 00:22:35','2019-02-23 07:29:59','yaoanxian','姚安县',NULL),(3059,'532326','大姚县','101.323602,25.722348','district',3053,0,'D','2018-12-14 00:22:35','2019-02-23 07:29:59','dayaoxian','大姚县',NULL),(3060,'532327','永仁县','101.671175,26.056316','district',3053,0,'Y','2018-12-14 00:22:35','2019-02-23 07:29:59','yongrenxian','永仁县',NULL),(3061,'532328','元谋县','101.870837,25.703313','district',3053,0,'Y','2018-12-14 00:22:35','2019-02-23 07:29:59','yuanmouxian','元谋县',NULL),(3062,'532329','武定县','102.406785,25.5301','district',3053,0,'W','2018-12-14 00:22:35','2019-02-23 07:29:59','wudingxian','武定县',NULL),(3063,'532331','禄丰县','102.075694,25.14327','district',3053,0,'L','2018-12-14 00:22:35','2019-02-23 07:29:59','lufengxian','禄丰县',NULL);
INSERT INTO `districts` VALUES (3064,'532500','红河哈尼族彝族自治州','103.384182,23.366775','city',2973,0,'H','2018-12-14 00:22:35','2019-02-23 07:29:59','honghehanizuyizuzizhizhou','红河哈尼族彝族自治州',NULL),(3065,'532501','个旧市','103.154752,23.360383','district',3064,0,'G','2018-12-14 00:22:35','2019-02-23 07:29:59','gejiu','个旧',NULL),(3066,'532502','开远市','103.258679,23.713832','district',3064,0,'K','2018-12-14 00:22:35','2019-02-23 07:29:59','kaiyuan','开远',NULL),(3067,'532503','蒙自市','103.385005,23.366843','district',3064,0,'M','2018-12-14 00:22:35','2019-02-23 07:30:00','mengzi','蒙自',NULL),(3068,'532504','弥勒市','103.436988,24.40837','district',3064,0,'M','2018-12-14 00:22:35','2019-02-23 07:30:00','mile','弥勒',NULL),(3069,'532523','屏边苗族自治县','103.687229,22.987013','district',3064,0,'P','2018-12-14 00:22:35','2019-02-23 07:30:00','pingbianmiaozuzizhixian','屏边苗族自治县',NULL),(3070,'532524','建水县','102.820493,23.618387','district',3064,0,'J','2018-12-14 00:22:35','2019-02-23 07:30:00','jianshuixian','建水县',NULL),(3071,'532525','石屏县','102.484469,23.712569','district',3064,0,'S','2018-12-14 00:22:35','2019-02-23 07:30:00','shipingxian','石屏县',NULL),(3072,'532527','泸西县','103.759622,24.532368','district',3064,0,'L','2018-12-14 00:22:36','2019-02-23 07:30:00','luxixian','泸西县',NULL),(3073,'532528','元阳县','102.837056,23.219773','district',3064,0,'Y','2018-12-14 00:22:36','2019-02-23 07:30:00','yuanyangxian','元阳县',NULL),(3074,'532529','红河县','102.42121,23.369191','district',3064,0,'H','2018-12-14 00:22:36','2019-02-23 07:30:00','honghexian','红河县',NULL),(3075,'532530','金平苗族瑶族傣族自治县','103.228359,22.779982','district',3064,0,'J','2018-12-14 00:22:36','2019-02-23 07:30:00','jinpingmiaozuyaozudaizuzizhixian','金平苗族瑶族傣族自治县',NULL),(3076,'532531','绿春县','102.39286,22.99352','district',3064,0,'L','2018-12-14 00:22:36','2019-02-23 07:30:00','lvchunxian','绿春县',NULL),(3077,'532532','河口瑶族自治县','103.961593,22.507563','district',3064,0,'H','2018-12-14 00:22:36','2019-02-23 07:30:00','hekouyaozuzizhixian','河口瑶族自治县',NULL),(3078,'532600','文山壮族苗族自治州','104.24401,23.36951','city',2973,0,'W','2018-12-14 00:22:36','2019-02-23 07:30:00','wenshanzhuangzumiaozuzizhizhou','文山壮族苗族自治州',NULL),(3079,'532601','文山市','104.244277,23.369216','district',3078,0,'W','2018-12-14 00:22:36','2019-02-23 07:30:00','wenshan','文山',NULL),(3080,'532622','砚山县','104.343989,23.612301','district',3078,0,'Y','2018-12-14 00:22:36','2019-02-23 07:30:00','yanshanxian','砚山县',NULL),(3081,'532623','西畴县','104.675711,23.437439','district',3078,0,'X','2018-12-14 00:22:36','2019-02-23 07:30:00','xichouxian','西畴县',NULL),(3082,'532624','麻栗坡县','104.701899,23.124202','district',3078,0,'M','2018-12-14 00:22:36','2019-02-23 07:30:00','malipoxian','麻栗坡县',NULL),(3083,'532625','马关县','104.398619,23.011723','district',3078,0,'M','2018-12-14 00:22:36','2019-02-23 07:30:00','maguanxian','马关县',NULL),(3084,'532626','丘北县','104.194366,24.040982','district',3078,0,'Q','2018-12-14 00:22:36','2019-02-23 07:30:00','qiubeixian','丘北县',NULL),(3085,'532627','广南县','105.056684,24.050272','district',3078,0,'G','2018-12-14 00:22:36','2019-02-23 07:30:00','guangnanxian','广南县',NULL),(3086,'532628','富宁县','105.62856,23.626494','district',3078,0,'F','2018-12-14 00:22:36','2019-02-23 07:30:00','funingxian','富宁县',NULL),(3087,'532800','西双版纳傣族自治州','100.797941,22.001724','city',2973,0,'X','2018-12-14 00:22:36','2019-02-23 07:30:00','xishuangbannadaizuzizhizhou','西双版纳傣族自治州',NULL),(3088,'532801','景洪市','100.797947,22.002087','district',3087,0,'J','2018-12-14 00:22:36','2019-02-23 07:30:00','jinghong','景洪',NULL),(3089,'532822','勐海县','100.448288,21.955866','district',3087,0,'M','2018-12-14 00:22:37','2019-02-23 07:30:00','menghaixian','勐海县',NULL),(3090,'532823','勐腊县','101.567051,21.479449','district',3087,0,'M','2018-12-14 00:22:37','2019-02-23 07:30:00','menglaxian','勐腊县',NULL),(3091,'532900','大理白族自治州','100.225668,25.589449','city',2973,0,'D','2018-12-14 00:22:37','2019-02-23 07:30:00','dalibaizuzizhizhou','大理白族自治州',NULL),(3092,'532901','大理市','100.241369,25.593067','district',3091,0,'D','2018-12-14 00:22:37','2019-02-23 07:30:00','dali','大理',NULL),(3093,'532922','漾濞彝族自治县','99.95797,25.669543','district',3091,0,'Y','2018-12-14 00:22:37','2019-02-23 07:30:00','yangbiyizuzizhixian','漾濞彝族自治县',NULL),(3094,'532923','祥云县','100.554025,25.477072','district',3091,0,'X','2018-12-14 00:22:37','2019-02-23 07:30:00','xiangyunxian','祥云县',NULL),(3095,'532924','宾川县','100.578957,25.825904','district',3091,0,'B','2018-12-14 00:22:37','2019-02-23 07:30:00','binchuanxian','宾川县',NULL),(3096,'532925','弥渡县','100.490669,25.342594','district',3091,0,'M','2018-12-14 00:22:37','2019-02-23 07:30:00','miduxian','弥渡县',NULL),(3097,'532926','南涧彝族自治县','100.518683,25.041279','district',3091,0,'N','2018-12-14 00:22:37','2019-02-23 07:30:00','nanjianyizuzizhixian','南涧彝族自治县',NULL),(3098,'532927','巍山彝族回族自治县','100.30793,25.230909','district',3091,0,'W','2018-12-14 00:22:37','2019-02-23 07:30:00','weishanyizuhuizuzizhixian','巍山彝族回族自治县',NULL),(3099,'532928','永平县','99.533536,25.461281','district',3091,0,'Y','2018-12-14 00:22:37','2019-02-23 07:30:00','yongpingxian','永平县',NULL),(3100,'532929','云龙县','99.369402,25.884955','district',3091,0,'Y','2018-12-14 00:22:37','2019-02-23 07:30:00','yunlongxian','云龙县',NULL),(3101,'532930','洱源县','99.951708,26.111184','district',3091,0,'E','2018-12-14 00:22:37','2019-02-23 07:30:01','eryuanxian','洱源县',NULL),(3102,'532931','剑川县','99.905887,26.530066','district',3091,0,'J','2018-12-14 00:22:37','2019-02-23 07:30:01','jianchuanxian','剑川县',NULL),(3103,'532932','鹤庆县','100.173375,26.55839','district',3091,0,'H','2018-12-14 00:22:37','2019-02-23 07:30:01','heqingxian','鹤庆县',NULL),(3104,'533100','德宏傣族景颇族自治州','98.578363,24.436694','city',2973,0,'D','2018-12-14 00:22:37','2019-02-23 07:30:01','dehongdaizujingpozuzizhizhou','德宏傣族景颇族自治州',NULL),(3105,'533102','瑞丽市','97.855883,24.010734','district',3104,0,'R','2018-12-14 00:22:37','2019-02-23 07:30:01','ruili','瑞丽',NULL),(3106,'533103','芒市','98.577608,24.436699','district',3104,0,'M','2018-12-14 00:22:38','2019-02-23 07:30:01','mang','芒',NULL),(3107,'533122','梁河县','98.298196,24.80742','district',3104,0,'L','2018-12-14 00:22:38','2019-02-23 07:30:01','lianghexian','梁河县',NULL),(3108,'533123','盈江县','97.93393,24.709541','district',3104,0,'Y','2018-12-14 00:22:38','2019-02-23 07:30:01','yingjiangxian','盈江县',NULL),(3109,'533124','陇川县','97.794441,24.184065','district',3104,0,'L','2018-12-14 00:22:38','2019-02-23 07:30:01','longchuanxian','陇川县',NULL),(3110,'533300','怒江傈僳族自治州','98.854304,25.850949','city',2973,0,'N','2018-12-14 00:22:38','2019-02-23 07:30:01','nujianglisuzuzizhizhou','怒江傈僳族自治州',NULL),(3111,'533301','泸水市','98.854063,25.851142','district',3110,0,'L','2018-12-14 00:22:38','2019-02-23 07:30:01','lushui','泸水',NULL),(3112,'533323','福贡县','98.867413,26.902738','district',3110,0,'F','2018-12-14 00:22:38','2019-02-23 07:30:01','fugongxian','福贡县',NULL),(3113,'533324','贡山独龙族怒族自治县','98.666141,27.738054','district',3110,0,'G','2018-12-14 00:22:38','2019-02-23 07:30:01','gongshandulongzunuzuzizhixian','贡山独龙族怒族自治县',NULL),(3114,'533325','兰坪白族普米族自治县','99.421378,26.453839','district',3110,0,'L','2018-12-14 00:22:38','2019-02-23 07:30:01','lanpingbaizupumizuzizhixian','兰坪白族普米族自治县',NULL),(3115,'533400','迪庆藏族自治州','99.706463,27.826853','city',2973,0,'D','2018-12-14 00:22:38','2019-02-23 07:30:01','diqingzangzuzizhizhou','迪庆藏族自治州',NULL),(3116,'533401','香格里拉市','99.708667,27.825804','district',3115,0,'X','2018-12-14 00:22:38','2019-02-23 07:30:01','xianggelila','香格里拉',NULL),(3117,'533422','德钦县','98.91506,28.483272','district',3115,0,'D','2018-12-14 00:22:38','2019-02-23 07:30:01','deqinxian','德钦县',NULL),(3118,'533423','维西傈僳族自治县','99.286355,27.180948','district',3115,0,'W','2018-12-14 00:22:38','2019-02-23 07:30:01','weixilisuzuzizhixian','维西傈僳族自治县',NULL),(3119,'540000','西藏自治区','91.132212,29.660361','province',0,1001,'X','2018-12-14 00:22:38','2019-02-23 07:30:01','xizangzizhiqu','西藏自治区',NULL),(3120,'540100','拉萨市','91.132212,29.660361','city',3119,0,'L','2018-12-14 00:22:38','2019-02-23 07:30:01','lasa','拉萨',NULL),(3121,'540102','城关区','91.132911,29.659472','district',3120,0,'C','2018-12-14 00:22:38','2019-02-23 07:30:01','chengguanqu','城关区',NULL),(3122,'540103','堆龙德庆区','91.002823,29.647347','district',3120,0,'D','2018-12-14 00:22:39','2019-02-23 07:30:01','duilongdeqingqu','堆龙德庆区',NULL),(3123,'540104','达孜区','91.350976,29.670314','district',3120,0,'D','2018-12-14 00:22:39','2019-02-23 07:30:01','daziqu','达孜区',NULL),(3124,'540121','林周县','91.261842,29.895754','district',3120,0,'L','2018-12-14 00:22:39','2019-02-23 07:30:01','linzhouxian','林周县',NULL),(3125,'540122','当雄县','91.103551,30.474819','district',3120,0,'D','2018-12-14 00:22:39','2019-02-23 07:30:01','dangxiongxian','当雄县',NULL),(3126,'540123','尼木县','90.165545,29.431346','district',3120,0,'N','2018-12-14 00:22:39','2019-02-23 07:30:01','nimuxian','尼木县',NULL),(3127,'540124','曲水县','90.738051,29.349895','district',3120,0,'Q','2018-12-14 00:22:39','2019-02-23 07:30:01','qushuixian','曲水县',NULL),(3128,'540127','墨竹工卡县','91.731158,29.834657','district',3120,0,'M','2018-12-14 00:22:39','2019-02-23 07:30:01','mozhugongkaxian','墨竹工卡县',NULL),(3129,'540200','日喀则市','88.885148,29.267519','city',3119,0,'R','2018-12-14 00:22:39','2019-02-23 07:30:01','rikaze','日喀则',NULL),(3130,'540202','桑珠孜区','88.88667,29.267003','district',3129,0,'S','2018-12-14 00:22:39','2019-02-23 07:30:01','sangzhuziqu','桑珠孜区',NULL),(3131,'540221','南木林县','89.099434,29.680459','district',3129,0,'N','2018-12-14 00:22:39','2019-02-23 07:30:01','nanmulinxian','南木林县',NULL),(3132,'540222','江孜县','89.605044,28.908845','district',3129,0,'J','2018-12-14 00:22:39','2019-02-23 07:30:01','jiangzixian','江孜县',NULL),(3133,'540223','定日县','87.123887,28.656667','district',3129,0,'D','2018-12-14 00:22:39','2019-02-23 07:30:01','dingrixian','定日县',NULL),(3134,'540224','萨迦县','88.023007,28.901077','district',3129,0,'S','2018-12-14 00:22:39','2019-02-23 07:30:01','sajiaxian','萨迦县',NULL),(3135,'540225','拉孜县','87.63743,29.085136','district',3129,0,'L','2018-12-14 00:22:39','2019-02-23 07:30:01','lazixian','拉孜县',NULL),(3136,'540226','昂仁县','87.23578,29.294758','district',3129,0,'A','2018-12-14 00:22:39','2019-02-23 07:30:01','angrenxian','昂仁县',NULL),(3137,'540227','谢通门县','88.260517,29.431597','district',3129,0,'X','2018-12-14 00:22:39','2019-02-23 07:30:02','xietongmenxian','谢通门县',NULL),(3138,'540228','白朗县','89.263618,29.106627','district',3129,0,'B','2018-12-14 00:22:40','2019-02-23 07:30:02','bailangxian','白朗县',NULL),(3139,'540229','仁布县','89.843207,29.230299','district',3129,0,'R','2018-12-14 00:22:40','2019-02-23 07:30:02','renbuxian','仁布县',NULL),(3140,'540230','康马县','89.683406,28.554719','district',3129,0,'K','2018-12-14 00:22:40','2019-02-23 07:30:02','kangmaxian','康马县',NULL),(3141,'540231','定结县','87.767723,28.36409','district',3129,0,'D','2018-12-14 00:22:40','2019-02-23 07:30:02','dingjiexian','定结县',NULL),(3142,'540232','仲巴县','84.032826,29.768336','district',3129,0,'Z','2018-12-14 00:22:40','2019-02-23 07:30:02','zhongbaxian','仲巴县',NULL),(3143,'540233','亚东县','88.906806,27.482772','district',3129,0,'Y','2018-12-14 00:22:40','2019-02-23 07:30:02','yadongxian','亚东县',NULL),(3144,'540234','吉隆县','85.298349,28.852416','district',3129,0,'J','2018-12-14 00:22:40','2019-02-23 07:30:02','jilongxian','吉隆县',NULL),(3145,'540235','聂拉木县','85.981953,28.15595','district',3129,0,'N','2018-12-14 00:22:40','2019-02-23 07:30:02','nielamuxian','聂拉木县',NULL),(3146,'540236','萨嘎县','85.234622,29.328194','district',3129,0,'S','2018-12-14 00:22:40','2019-02-23 07:30:02','sagaxian','萨嘎县',NULL),(3147,'540237','岗巴县','88.518903,28.274371','district',3129,0,'G','2018-12-14 00:22:40','2019-02-23 07:30:02','gangbaxian','岗巴县',NULL),(3148,'540300','昌都市','97.178452,31.136875','city',3119,0,'C','2018-12-14 00:22:40','2019-02-23 07:30:02','changdu','昌都',NULL),(3149,'540302','卡若区','97.178255,31.137035','district',3148,0,'K','2018-12-14 00:22:40','2019-02-23 07:30:02','karuoqu','卡若区',NULL),(3150,'540321','江达县','98.218351,31.499534','district',3148,0,'J','2018-12-14 00:22:40','2019-02-23 07:30:02','jiangdaxian','江达县',NULL),(3151,'540322','贡觉县','98.271191,30.859206','district',3148,0,'G','2018-12-14 00:22:40','2019-02-23 07:30:02','gongjuexian','贡觉县',NULL),(3152,'540323','类乌齐县','96.601259,31.213048','district',3148,0,'L','2018-12-14 00:22:40','2019-02-23 07:30:02','leiwuqixian','类乌齐县',NULL),(3153,'540324','丁青县','95.597748,31.410681','district',3148,0,'D','2018-12-14 00:22:40','2019-02-23 07:30:02','dingqingxian','丁青县',NULL),(3154,'540325','察雅县','97.565701,30.653038','district',3148,0,'C','2018-12-14 00:22:40','2019-02-23 07:30:02','chayaxian','察雅县',NULL),(3155,'540326','八宿县','96.917893,30.053408','district',3148,0,'B','2018-12-14 00:22:40','2019-02-23 07:30:02','basuxian','八宿县',NULL),(3156,'540327','左贡县','97.840532,29.671335','district',3148,0,'Z','2018-12-14 00:22:41','2019-02-23 07:30:02','zuogongxian','左贡县',NULL),(3157,'540328','芒康县','98.596444,29.686615','district',3148,0,'M','2018-12-14 00:22:41','2019-02-23 07:30:02','mangkangxian','芒康县',NULL),(3158,'540329','洛隆县','95.823418,30.741947','district',3148,0,'L','2018-12-14 00:22:41','2019-02-23 07:30:02','luolongxian','洛隆县',NULL),(3159,'540330','边坝县','94.707504,30.933849','district',3148,0,'B','2018-12-14 00:22:41','2019-02-23 07:30:02','bianbaxian','边坝县',NULL),(3160,'540400','林芝市','94.362348,29.654693','city',3119,0,'L','2018-12-14 00:22:41','2019-02-23 07:30:02','linzhi','林芝',NULL),(3161,'540402','巴宜区','94.360987,29.653732','district',3160,0,'B','2018-12-14 00:22:41','2019-02-23 07:30:02','bayiqu','巴宜区',NULL),(3162,'540421','工布江达县','93.246515,29.88447','district',3160,0,'G','2018-12-14 00:22:41','2019-02-23 07:30:02','gongbujiangdaxian','工布江达县',NULL),(3163,'540422','米林县','94.213679,29.213811','district',3160,0,'M','2018-12-14 00:22:41','2019-02-23 07:30:02','milinxian','米林县',NULL),(3164,'540423','墨脱县','95.332245,29.32573','district',3160,0,'M','2018-12-14 00:22:41','2019-02-23 07:30:02','motuoxian','墨脱县',NULL),(3165,'540424','波密县','95.768151,29.858771','district',3160,0,'B','2018-12-14 00:22:41','2019-02-23 07:30:02','bomixian','波密县',NULL),(3166,'540425','察隅县','97.465002,28.660244','district',3160,0,'C','2018-12-14 00:22:41','2019-02-23 07:30:02','chayuxian','察隅县',NULL),(3167,'540426','朗县','93.073429,29.0446','district',3160,0,'L','2018-12-14 00:22:41','2019-02-23 07:30:02','langxian','朗县',NULL),(3168,'540500','山南市','91.766529,29.236023','city',3119,0,'S','2018-12-14 00:22:41','2019-02-23 07:30:02','shannan','山南',NULL),(3169,'540502','乃东区','91.76525,29.236106','district',3168,0,'N','2018-12-14 00:22:41','2019-02-23 07:30:02','naidongqu','乃东区',NULL),(3170,'540521','扎囊县','91.338,29.246476','district',3168,0,'Z','2018-12-14 00:22:41','2019-02-23 07:30:02','zanangxian','扎囊县',NULL),(3171,'540522','贡嘎县','90.985271,29.289078','district',3168,0,'G','2018-12-14 00:22:41','2019-02-23 07:30:02','gonggaxian','贡嘎县',NULL),(3172,'540523','桑日县','92.015732,29.259774','district',3168,0,'S','2018-12-14 00:22:41','2019-02-23 07:30:03','sangrixian','桑日县',NULL),(3173,'540524','琼结县','91.683753,29.025242','district',3168,0,'Q','2018-12-14 00:22:41','2019-02-23 07:30:03','qiongjiexian','琼结县',NULL),(3174,'540525','曲松县','92.201066,29.063656','district',3168,0,'Q','2018-12-14 00:22:41','2019-02-23 07:30:03','qusongxian','曲松县',NULL),(3175,'540526','措美县','91.432347,28.437353','district',3168,0,'C','2018-12-14 00:22:42','2019-02-23 07:30:03','cuomeixian','措美县',NULL),(3176,'540527','洛扎县','90.858243,28.385765','district',3168,0,'L','2018-12-14 00:22:42','2019-02-23 07:30:03','luozhaxian','洛扎县',NULL),(3177,'540528','加查县','92.591043,29.140921','district',3168,0,'J','2018-12-14 00:22:42','2019-02-23 07:30:03','jiachaxian','加查县',NULL),(3178,'540529','隆子县','92.463309,28.408548','district',3168,0,'L','2018-12-14 00:22:42','2019-02-23 07:30:03','longzixian','隆子县',NULL),(3179,'540530','错那县','91.960132,27.991707','district',3168,0,'C','2018-12-14 00:22:42','2019-02-23 07:30:03','cuonaxian','错那县',NULL),(3180,'540531','浪卡子县','90.398747,28.96836','district',3168,0,'L','2018-12-14 00:22:42','2019-02-23 07:30:03','langkazixian','浪卡子县',NULL),(3181,'540600','那曲市','92.060214,31.476004','city',3119,0,'N','2018-12-14 00:22:42','2019-02-23 07:30:03','naqu','那曲',NULL),(3182,'540602','色尼区','92.061862,31.475756','district',3181,0,'S','2018-12-14 00:22:42','2019-02-23 07:30:03','seniqu','色尼区',NULL),(3183,'540621','嘉黎县','93.232907,30.640846','district',3181,0,'J','2018-12-14 00:22:42','2019-02-23 07:30:03','jialixian','嘉黎县',NULL),(3184,'540622','比如县','93.68044,31.479917','district',3181,0,'B','2018-12-14 00:22:42','2019-02-23 07:30:03','biruxian','比如县',NULL),(3185,'540623','聂荣县','92.303659,32.107855','district',3181,0,'N','2018-12-14 00:22:42','2019-02-23 07:30:03','nierongxian','聂荣县',NULL),(3186,'540624','安多县','91.681879,32.260299','district',3181,0,'A','2018-12-14 00:22:42','2019-02-23 07:30:03','anduoxian','安多县',NULL),(3187,'540625','申扎县','88.709777,30.929056','district',3181,0,'S','2018-12-14 00:22:42','2019-02-23 07:30:03','shenzhaxian','申扎县',NULL),(3188,'540626','索县','93.784964,31.886173','district',3181,0,'S','2018-12-14 00:22:42','2019-02-23 07:30:03','suoxian','索县',NULL),(3189,'540627','班戈县','90.011822,31.394578','district',3181,0,'B','2018-12-14 00:22:42','2019-02-23 07:30:03','bangexian','班戈县',NULL),(3190,'540628','巴青县','94.054049,31.918691','district',3181,0,'B','2018-12-14 00:22:42','2019-02-23 07:30:03','baqingxian','巴青县',NULL),(3191,'540629','尼玛县','87.236646,31.784979','district',3181,0,'N','2018-12-14 00:22:42','2019-02-23 07:30:03','nimaxian','尼玛县',NULL),(3192,'540630','双湖县','88.838578,33.18698','district',3181,0,'S','2018-12-14 00:22:42','2019-02-23 07:30:03','shuanghuxian','双湖县',NULL),(3193,'542500','阿里地区','80.105498,32.503187','city',3119,0,'A','2018-12-14 00:22:43','2019-02-23 07:30:03','alidiqu','阿里地区',NULL),(3194,'542521','普兰县','81.177588,30.291896','district',3193,0,'P','2018-12-14 00:22:43','2019-02-23 07:30:03','pulanxian','普兰县',NULL),(3195,'542522','札达县','79.803191,31.478587','district',3193,0,'Z','2018-12-14 00:22:43','2019-02-23 07:30:03','zhadaxian','札达县',NULL),(3196,'542523','噶尔县','80.105005,32.503373','district',3193,0,'G','2018-12-14 00:22:43','2019-02-23 07:30:03','gaerxian','噶尔县',NULL),(3197,'542524','日土县','79.731937,33.382454','district',3193,0,'R','2018-12-14 00:22:43','2019-02-23 07:30:03','rituxian','日土县',NULL),(3198,'542525','革吉县','81.142896,32.389192','district',3193,0,'G','2018-12-14 00:22:43','2019-02-23 07:30:03','gejixian','革吉县',NULL),(3199,'542526','改则县','84.062384,32.302076','district',3193,0,'G','2018-12-14 00:22:43','2019-02-23 07:30:03','gaizexian','改则县',NULL),(3200,'542527','措勤县','85.159254,31.016774','district',3193,0,'C','2018-12-14 00:22:43','2019-02-23 07:30:03','cuoqinxian','措勤县',NULL),(3201,'610000','陕西省','108.948024,34.263161','province',0,5100,'S','2018-12-14 00:22:43','2019-02-23 07:30:03','shanxisheng','陕西省',NULL),(3202,'610100','西安市','108.948024,34.263161','city',3201,0,'X','2018-12-14 00:22:43','2019-02-23 07:30:03','xian','西安',NULL),(3203,'610102','新城区','108.959903,34.26927','district',3202,0,'X','2018-12-14 00:22:43','2019-02-23 07:30:03','xinchengqu','新城区',NULL),(3204,'610103','碑林区','108.946994,34.251061','district',3202,0,'B','2018-12-14 00:22:43','2019-02-23 07:30:03','beilinqu','碑林区',NULL),(3205,'610104','莲湖区','108.933194,34.2656','district',3202,0,'L','2018-12-14 00:22:43','2019-02-23 07:30:03','lianhuqu','莲湖区',NULL),(3206,'610111','灞桥区','109.067261,34.267453','district',3202,0,'B','2018-12-14 00:22:43','2019-02-23 07:30:03','baqiaoqu','灞桥区',NULL),(3207,'610112','未央区','108.946022,34.30823','district',3202,0,'W','2018-12-14 00:22:43','2019-02-23 07:30:03','weiyangqu','未央区',NULL),(3208,'610113','雁塔区','108.926593,34.213389','district',3202,0,'Y','2018-12-14 00:22:43','2019-02-23 07:30:04','yantaqu','雁塔区',NULL),(3209,'610114','阎良区','109.22802,34.662141','district',3202,0,'Y','2018-12-14 00:22:43','2019-02-23 07:30:04','yanliangqu','阎良区',NULL),(3210,'610115','临潼区','109.213986,34.372065','district',3202,0,'L','2018-12-14 00:22:43','2019-02-23 07:30:04','lintongqu','临潼区',NULL),(3211,'610116','长安区','108.941579,34.157097','district',3202,0,'C','2018-12-14 00:22:44','2019-02-23 07:30:04','changanqu','长安区',NULL),(3212,'610117','高陵区','109.088896,34.535065','district',3202,0,'G','2018-12-14 00:22:44','2019-02-23 07:30:04','gaolingqu','高陵区',NULL),(3213,'610118','鄠邑区','108.607385,34.108668','district',3202,0,'H','2018-12-14 00:22:44','2019-02-23 07:30:04','huyiqu','鄠邑区',NULL),(3214,'610122','蓝田县','109.317634,34.156189','district',3202,0,'L','2018-12-14 00:22:44','2019-02-23 07:30:04','lantianxian','蓝田县',NULL),(3215,'610124','周至县','108.216465,34.161532','district',3202,0,'Z','2018-12-14 00:22:44','2019-02-23 07:30:04','zhouzhixian','周至县',NULL),(3216,'610200','铜川市','108.979608,34.916582','city',3201,0,'T','2018-12-14 00:22:44','2019-02-23 07:30:04','tongchuan','铜川',NULL),(3217,'610202','王益区','109.075862,35.069098','district',3216,0,'W','2018-12-14 00:22:44','2019-02-23 07:30:04','wangyiqu','王益区',NULL),(3218,'610203','印台区','109.100814,35.111927','district',3216,0,'Y','2018-12-14 00:22:44','2019-02-23 07:30:04','yintaiqu','印台区',NULL),(3219,'610204','耀州区','108.962538,34.910206','district',3216,0,'Y','2018-12-14 00:22:44','2019-02-23 07:30:04','yaozhouqu','耀州区',NULL),(3220,'610222','宜君县','109.118278,35.398766','district',3216,0,'Y','2018-12-14 00:22:44','2019-02-23 07:30:04','yijunxian','宜君县',NULL),(3221,'610300','宝鸡市','107.14487,34.369315','city',3201,0,'B','2018-12-14 00:22:44','2019-02-23 07:30:04','baoji','宝鸡',NULL),(3222,'610302','渭滨区','107.144467,34.371008','district',3221,0,'W','2018-12-14 00:22:44','2019-02-23 07:30:04','weibinqu','渭滨区',NULL),(3223,'610303','金台区','107.149943,34.375192','district',3221,0,'J','2018-12-14 00:22:44','2019-02-23 07:30:04','jintaiqu','金台区',NULL),(3224,'610304','陈仓区','107.383645,34.352747','district',3221,0,'C','2018-12-14 00:22:44','2019-02-23 07:30:04','chencangqu','陈仓区',NULL),(3225,'610322','凤翔县','107.400577,34.521668','district',3221,0,'F','2018-12-14 00:22:44','2019-02-23 07:30:04','fengxiangxian','凤翔县',NULL),(3226,'610323','岐山县','107.624464,34.44296','district',3221,0,'Q','2018-12-14 00:22:44','2019-02-23 07:30:04','qishanxian','岐山县',NULL),(3227,'610324','扶风县','107.891419,34.375497','district',3221,0,'F','2018-12-14 00:22:44','2019-02-23 07:30:04','fufengxian','扶风县',NULL),(3228,'610326','眉县','107.752371,34.272137','district',3221,0,'M','2018-12-14 00:22:44','2019-02-23 07:30:04','meixian','眉县',NULL),(3229,'610327','陇县','106.857066,34.893262','district',3221,0,'L','2018-12-14 00:22:44','2019-02-23 07:30:04','longxian','陇县',NULL),(3230,'610328','千阳县','107.132987,34.642584','district',3221,0,'Q','2018-12-14 00:22:45','2019-02-23 07:30:04','qianyangxian','千阳县',NULL),(3231,'610329','麟游县','107.796608,34.677714','district',3221,0,'L','2018-12-14 00:22:45','2019-02-23 07:30:04','linyouxian','麟游县',NULL),(3232,'610330','凤县','106.525212,33.912464','district',3221,0,'F','2018-12-14 00:22:45','2019-02-23 07:30:04','fengxian','凤县',NULL),(3233,'610331','太白县','107.316533,34.059215','district',3221,0,'T','2018-12-14 00:22:45','2019-02-23 07:30:04','taibaixian','太白县',NULL),(3234,'610400','咸阳市','108.705117,34.333439','city',3201,0,'X','2018-12-14 00:22:45','2019-02-23 07:30:04','xianyang','咸阳',NULL),(3235,'610402','秦都区','108.698636,34.329801','district',3234,0,'Q','2018-12-14 00:22:45','2019-02-23 07:30:04','qinduqu','秦都区',NULL),(3236,'610403','杨陵区','108.086348,34.27135','district',3234,0,'Y','2018-12-14 00:22:45','2019-02-23 07:30:04','yanglingqu','杨陵区',NULL),(3237,'610404','渭城区','108.730957,34.336847','district',3234,0,'W','2018-12-14 00:22:45','2019-02-23 07:30:04','weichengqu','渭城区',NULL),(3238,'610422','三原县','108.943481,34.613996','district',3234,0,'S','2018-12-14 00:22:45','2019-02-23 07:30:04','sanyuanxian','三原县',NULL),(3239,'610423','泾阳县','108.83784,34.528493','district',3234,0,'J','2018-12-14 00:22:45','2019-02-23 07:30:04','jingyangxian','泾阳县',NULL),(3240,'610424','乾县','108.247406,34.527261','district',3234,0,'Q','2018-12-14 00:22:45','2019-02-23 07:30:04','qianxian','乾县',NULL),(3241,'610425','礼泉县','108.428317,34.482583','district',3234,0,'L','2018-12-14 00:22:45','2019-02-23 07:30:04','liquanxian','礼泉县',NULL),(3242,'610426','永寿县','108.143129,34.692619','district',3234,0,'Y','2018-12-14 00:22:45','2019-02-23 07:30:04','yongshouxian','永寿县',NULL),(3243,'610427','彬县','108.083674,35.034233','district',3234,0,'B','2018-12-14 00:22:45','2019-02-23 07:30:05','binxian','彬县',NULL),(3244,'610428','长武县','107.795835,35.206122','district',3234,0,'C','2018-12-14 00:22:46','2019-02-23 07:30:05','changwuxian','长武县',NULL),(3245,'610429','旬邑县','108.337231,35.112234','district',3234,0,'X','2018-12-14 00:22:46','2019-02-23 07:30:05','xunyixian','旬邑县',NULL),(3246,'610430','淳化县','108.581173,34.79797','district',3234,0,'C','2018-12-14 00:22:46','2019-02-23 07:30:05','chunhuaxian','淳化县',NULL),(3247,'610431','武功县','108.212857,34.259732','district',3234,0,'W','2018-12-14 00:22:46','2019-02-23 07:30:05','wugongxian','武功县',NULL),(3248,'610481','兴平市','108.488493,34.297134','district',3234,0,'X','2018-12-14 00:22:46','2019-02-23 07:30:05','xingping','兴平',NULL),(3249,'610500','渭南市','109.502882,34.499381','city',3201,0,'W','2018-12-14 00:22:46','2019-02-23 07:30:05','weinan','渭南',NULL),(3250,'610502','临渭区','109.503299,34.501271','district',3249,0,'L','2018-12-14 00:22:46','2019-02-23 07:30:05','linweiqu','临渭区',NULL),(3251,'610503','华州区','109.76141,34.511958','district',3249,0,'H','2018-12-14 00:22:46','2019-02-23 07:30:05','huazhouqu','华州区',NULL),(3252,'610522','潼关县','110.24726,34.544515','district',3249,0,'T','2018-12-14 00:22:46','2019-02-23 07:30:05','tongguanxian','潼关县',NULL),(3253,'610523','大荔县','109.943123,34.795011','district',3249,0,'D','2018-12-14 00:22:46','2019-02-23 07:30:05','dalixian','大荔县',NULL),(3254,'610524','合阳县','110.147979,35.237098','district',3249,0,'H','2018-12-14 00:22:46','2019-02-23 07:30:05','heyangxian','合阳县',NULL),(3255,'610525','澄城县','109.937609,35.184','district',3249,0,'C','2018-12-14 00:22:46','2019-02-23 07:30:05','chengchengxian','澄城县',NULL),(3256,'610526','蒲城县','109.589653,34.956034','district',3249,0,'P','2018-12-14 00:22:46','2019-02-23 07:30:05','puchengxian','蒲城县',NULL),(3257,'610527','白水县','109.594309,35.177291','district',3249,0,'B','2018-12-14 00:22:46','2019-02-23 07:30:05','baishuixian','白水县',NULL),(3258,'610528','富平县','109.187174,34.746679','district',3249,0,'F','2018-12-14 00:22:46','2019-02-23 07:30:05','fupingxian','富平县',NULL),(3259,'610581','韩城市','110.452391,35.475238','district',3249,0,'H','2018-12-14 00:22:46','2019-02-23 07:30:05','hancheng','韩城',NULL),(3260,'610582','华阴市','110.08952,34.565359','district',3249,0,'H','2018-12-14 00:22:46','2019-02-23 07:30:05','huayin','华阴',NULL),(3261,'610600','延安市','109.49081,36.596537','city',3201,0,'Y','2018-12-14 00:22:46','2019-02-23 07:30:05','yanan','延安',NULL),(3262,'610602','宝塔区','109.49069,36.596291','district',3261,0,'B','2018-12-14 00:22:46','2019-02-23 07:30:05','baotaqu','宝塔区',NULL),(3263,'610603','安塞区','109.325341,36.86441','district',3261,0,'A','2018-12-14 00:22:46','2019-02-23 07:30:05','ansaiqu','安塞区',NULL),(3264,'610621','延长县','110.012961,36.578306','district',3261,0,'Y','2018-12-14 00:22:47','2019-02-23 07:30:05','yanchangxian','延长县',NULL),(3265,'610622','延川县','110.190314,36.882066','district',3261,0,'Y','2018-12-14 00:22:47','2019-02-23 07:30:05','yanchuanxian','延川县',NULL),(3266,'610623','子长县','109.675968,37.14207','district',3261,0,'Z','2018-12-14 00:22:47','2019-02-23 07:30:05','zichangxian','子长县',NULL),(3267,'610625','志丹县','108.768898,36.823031','district',3261,0,'Z','2018-12-14 00:22:47','2019-02-23 07:30:05','zhidanxian','志丹县',NULL),(3268,'610626','吴起县','108.176976,36.924852','district',3261,0,'W','2018-12-14 00:22:47','2019-02-23 07:30:05','wuqixian','吴起县',NULL),(3269,'610627','甘泉县','109.34961,36.277729','district',3261,0,'G','2018-12-14 00:22:47','2019-02-23 07:30:05','ganquanxian','甘泉县',NULL),(3270,'610628','富县','109.384136,35.996495','district',3261,0,'F','2018-12-14 00:22:47','2019-02-23 07:30:05','fuxian','富县',NULL),(3271,'610629','洛川县','109.435712,35.762133','district',3261,0,'L','2018-12-14 00:22:47','2019-02-23 07:30:05','luochuanxian','洛川县',NULL),(3272,'610630','宜川县','110.175537,36.050391','district',3261,0,'Y','2018-12-14 00:22:47','2019-02-23 07:30:05','yichuanxian','宜川县',NULL),(3273,'610631','黄龙县','109.83502,35.583276','district',3261,0,'H','2018-12-14 00:22:47','2019-02-23 07:30:05','huanglongxian','黄龙县',NULL),(3274,'610632','黄陵县','109.262469,35.580165','district',3261,0,'H','2018-12-14 00:22:47','2019-02-23 07:30:05','huanglingxian','黄陵县',NULL),(3275,'610700','汉中市','107.028621,33.077668','city',3201,0,'H','2018-12-14 00:22:47','2019-02-23 07:30:05','hanzhong','汉中',NULL),(3276,'610702','汉台区','107.028233,33.077674','district',3275,0,'H','2018-12-14 00:22:47','2019-02-23 07:30:05','hantaiqu','汉台区',NULL),(3277,'610703','南郑区','106.942393,33.003341','district',3275,0,'N','2018-12-14 00:22:47','2019-02-23 07:30:05','nanzhengqu','南郑区',NULL),(3278,'610722','城固县','107.329887,33.153098','district',3275,0,'C','2018-12-14 00:22:47','2019-02-23 07:30:05','chengguxian','城固县',NULL),(3279,'610723','洋县','107.549962,33.223283','district',3275,0,'Y','2018-12-14 00:22:47','2019-02-23 07:30:06','yangxian','洋县',NULL),(3280,'610724','西乡县','107.765858,32.987961','district',3275,0,'X','2018-12-14 00:22:47','2019-02-23 07:30:06','xixiangxian','西乡县',NULL),(3281,'610725','勉县','106.680175,33.155618','district',3275,0,'M','2018-12-14 00:22:47','2019-02-23 07:30:06','mianxian','勉县',NULL),(3282,'610726','宁强县','106.25739,32.830806','district',3275,0,'N','2018-12-14 00:22:47','2019-02-23 07:30:06','ningqiangxian','宁强县',NULL),(3283,'610727','略阳县','106.153899,33.329638','district',3275,0,'L','2018-12-14 00:22:48','2019-02-23 07:30:06','lueyangxian','略阳县',NULL),(3284,'610728','镇巴县','107.89531,32.535854','district',3275,0,'Z','2018-12-14 00:22:48','2019-02-23 07:30:06','zhenbaxian','镇巴县',NULL),(3285,'610729','留坝县','106.924377,33.61334','district',3275,0,'L','2018-12-14 00:22:48','2019-02-23 07:30:06','liubaxian','留坝县',NULL),(3286,'610730','佛坪县','107.988582,33.520745','district',3275,0,'F','2018-12-14 00:22:48','2019-02-23 07:30:06','fopingxian','佛坪县',NULL),(3287,'610800','榆林市','109.741193,38.290162','city',3201,0,'Y','2018-12-14 00:22:48','2019-02-23 07:30:06','yulin','榆林',NULL),(3288,'610802','榆阳区','109.74791,38.299267','district',3287,0,'Y','2018-12-14 00:22:48','2019-02-23 07:30:06','yuyangqu','榆阳区',NULL),(3289,'610803','横山区','109.292596,37.964048','district',3287,0,'H','2018-12-14 00:22:48','2019-02-23 07:30:06','hengshanqu','横山区',NULL),(3290,'610822','府谷县','111.069645,39.029243','district',3287,0,'F','2018-12-14 00:22:48','2019-02-23 07:30:06','fuguxian','府谷县',NULL),(3291,'610824','靖边县','108.80567,37.596084','district',3287,0,'J','2018-12-14 00:22:48','2019-02-23 07:30:06','jingbianxian','靖边县',NULL),(3292,'610825','定边县','107.601284,37.59523','district',3287,0,'D','2018-12-14 00:22:48','2019-02-23 07:30:06','dingbianxian','定边县',NULL),(3293,'610826','绥德县','110.265377,37.507701','district',3287,0,'S','2018-12-14 00:22:48','2019-02-23 07:30:06','suidexian','绥德县',NULL),(3294,'610827','米脂县','110.178683,37.759081','district',3287,0,'M','2018-12-14 00:22:48','2019-02-23 07:30:06','mizhixian','米脂县',NULL),(3295,'610828','佳县','110.493367,38.021597','district',3287,0,'J','2018-12-14 00:22:48','2019-02-23 07:30:06','jiaxian','佳县',NULL),(3296,'610829','吴堡县','110.739315,37.451925','district',3287,0,'W','2018-12-14 00:22:48','2019-02-23 07:30:06','wubuxian','吴堡县',NULL),(3297,'610830','清涧县','110.12146,37.087702','district',3287,0,'Q','2018-12-14 00:22:48','2019-02-23 07:30:06','qingjianxian','清涧县',NULL),(3298,'610831','子洲县','110.03457,37.611573','district',3287,0,'Z','2018-12-14 00:22:48','2019-02-23 07:30:06','zizhouxian','子洲县',NULL),(3299,'610881','神木市','110.497005,38.835641','district',3287,0,'S','2018-12-14 00:22:48','2019-02-23 07:30:06','shenmu','神木',NULL),(3300,'610900','安康市','109.029273,32.6903','city',3201,0,'A','2018-12-14 00:22:48','2019-02-23 07:30:06','ankang','安康',NULL),(3301,'610902','汉滨区','109.029098,32.690817','district',3300,0,'H','2018-12-14 00:22:49','2019-02-23 07:30:06','hanbinqu','汉滨区',NULL),(3302,'610921','汉阴县','108.510946,32.891121','district',3300,0,'H','2018-12-14 00:22:49','2019-02-23 07:30:06','hanyinxian','汉阴县',NULL),(3303,'610922','石泉县','108.250512,33.038512','district',3300,0,'S','2018-12-14 00:22:49','2019-02-23 07:30:06','shiquanxian','石泉县',NULL),(3304,'610923','宁陕县','108.313714,33.312184','district',3300,0,'N','2018-12-14 00:22:49','2019-02-23 07:30:06','ningshanxian','宁陕县',NULL),(3305,'610924','紫阳县','108.537788,32.520176','district',3300,0,'Z','2018-12-14 00:22:49','2019-02-23 07:30:06','ziyangxian','紫阳县',NULL),(3306,'610925','岚皋县','108.900663,32.31069','district',3300,0,'L','2018-12-14 00:22:49','2019-02-23 07:30:06','langaoxian','岚皋县',NULL),(3307,'610926','平利县','109.361865,32.387933','district',3300,0,'P','2018-12-14 00:22:49','2019-02-23 07:30:06','pinglixian','平利县',NULL),(3308,'610927','镇坪县','109.526437,31.883395','district',3300,0,'Z','2018-12-14 00:22:49','2019-02-23 07:30:06','zhenpingxian','镇坪县',NULL),(3309,'610928','旬阳县','109.368149,32.833567','district',3300,0,'X','2018-12-14 00:22:49','2019-02-23 07:30:06','xunyangxian','旬阳县',NULL),(3310,'610929','白河县','110.114186,32.809484','district',3300,0,'B','2018-12-14 00:22:49','2019-02-23 07:30:06','baihexian','白河县',NULL),(3311,'611000','商洛市','109.939776,33.868319','city',3201,0,'S','2018-12-14 00:22:49','2019-02-23 07:30:06','shangluo','商洛',NULL),(3312,'611002','商州区','109.937685,33.869208','district',3311,0,'S','2018-12-14 00:22:49','2019-02-23 07:30:06','shangzhouqu','商州区',NULL),(3313,'611021','洛南县','110.145716,34.088502','district',3311,0,'L','2018-12-14 00:22:49','2019-02-23 07:30:06','luonanxian','洛南县',NULL),(3314,'611022','丹凤县','110.33191,33.694711','district',3311,0,'D','2018-12-14 00:22:49','2019-02-23 07:30:06','danfengxian','丹凤县',NULL),(3315,'611023','商南县','110.885437,33.526367','district',3311,0,'S','2018-12-14 00:22:49','2019-02-23 07:30:07','shangnanxian','商南县',NULL),(3316,'611024','山阳县','109.880435,33.530411','district',3311,0,'S','2018-12-14 00:22:49','2019-02-23 07:30:07','shanyangxian','山阳县',NULL),(3317,'611025','镇安县','109.151075,33.423981','district',3311,0,'Z','2018-12-14 00:22:49','2019-02-23 07:30:07','zhenanxian','镇安县',NULL),(3318,'611026','柞水县','109.111249,33.682773','district',3311,0,'Z','2018-12-14 00:22:49','2019-02-23 07:30:07','zhashuixian','柞水县',NULL),(3319,'620000','甘肃省','103.823557,36.058039','province',0,4300,'G','2018-12-14 00:22:50','2019-02-23 07:30:07','gansusheng','甘肃省',NULL),(3320,'620100','兰州市','103.823557,36.058039','city',3319,0,'L','2018-12-14 00:22:50','2019-02-23 07:30:07','lanzhou','兰州',NULL),(3321,'620102','城关区','103.841032,36.049115','district',3320,0,'C','2018-12-14 00:22:50','2019-02-23 07:30:07','chengguanqu','城关区',NULL),(3322,'620103','七里河区','103.784326,36.06673','district',3320,0,'Q','2018-12-14 00:22:50','2019-02-23 07:30:07','qilihequ','七里河区',NULL),(3323,'620104','西固区','103.622331,36.100369','district',3320,0,'X','2018-12-14 00:22:50','2019-02-23 07:30:07','xiguqu','西固区',NULL),(3324,'620105','安宁区','103.724038,36.10329','district',3320,0,'A','2018-12-14 00:22:50','2019-02-23 07:30:07','anningqu','安宁区',NULL),(3325,'620111','红古区','102.861814,36.344177','district',3320,0,'H','2018-12-14 00:22:50','2019-02-23 07:30:07','hongguqu','红古区',NULL),(3326,'620121','永登县','103.262203,36.734428','district',3320,0,'Y','2018-12-14 00:22:50','2019-02-23 07:30:07','yongdengxian','永登县',NULL),(3327,'620122','皋兰县','103.94933,36.331254','district',3320,0,'G','2018-12-14 00:22:50','2019-02-23 07:30:07','gaolanxian','皋兰县',NULL),(3328,'620123','榆中县','104.114975,35.84443','district',3320,0,'Y','2018-12-14 00:22:50','2019-02-23 07:30:07','yuzhongxian','榆中县',NULL),(3329,'620200','嘉峪关市','98.277304,39.786529','city',3319,0,'J','2018-12-14 00:22:50','2019-02-23 07:30:07','jiayuguan','嘉峪关',NULL),(3330,'620200','峪泉镇','98.3204,39.9583','street',3329,0,'Y','2018-12-14 00:22:50','2019-02-23 07:30:07','yuquanzhen','峪泉镇',NULL),(3331,'620200','文殊镇','98.1579,39.6969','street',3329,0,'W','2018-12-14 00:22:50','2019-02-23 07:30:07','wenshuzhen','文殊镇',NULL),(3332,'620200','新城镇','98.3627,39.9581','street',3329,0,'X','2018-12-14 00:22:50','2019-02-23 07:30:07','xinchengzhen','新城镇',NULL),(3333,'620200','镜铁区','98.3342,39.7378','street',3329,0,'J','2018-12-14 00:22:50','2019-02-23 07:30:07','jingtiequ','镜铁区',NULL),(3334,'620200','长城区','98.255,39.8552','street',3329,0,'C','2018-12-14 00:22:50','2019-02-23 07:30:07','changchengqu','长城区',NULL),(3335,'620200','雄关区','98.317,39.8839','street',3329,0,'X','2018-12-14 00:22:50','2019-02-23 07:30:07','xiongguanqu','雄关区',NULL),(3336,'620300','金昌市','102.187888,38.514238','city',3319,0,'J','2018-12-14 00:22:51','2019-02-23 07:30:07','jinchang','金昌',NULL),(3337,'620302','金川区','102.187683,38.513793','district',3336,0,'J','2018-12-14 00:22:51','2019-02-23 07:30:07','jinchuanqu','金川区',NULL),(3338,'620321','永昌县','101.971957,38.247354','district',3336,0,'Y','2018-12-14 00:22:51','2019-02-23 07:30:07','yongchangxian','永昌县',NULL),(3339,'620400','白银市','104.173606,36.54568','city',3319,0,'B','2018-12-14 00:22:51','2019-02-23 07:30:07','baiyin','白银',NULL),(3340,'620402','白银区','104.17425,36.545649','district',3339,0,'B','2018-12-14 00:22:51','2019-02-23 07:30:07','baiyinqu','白银区',NULL),(3341,'620403','平川区','104.819207,36.72921','district',3339,0,'P','2018-12-14 00:22:51','2019-02-23 07:30:07','pingchuanqu','平川区',NULL),(3342,'620421','靖远县','104.686972,36.561424','district',3339,0,'J','2018-12-14 00:22:51','2019-02-23 07:30:07','jingyuanxian','靖远县',NULL),(3343,'620422','会宁县','105.054337,35.692486','district',3339,0,'H','2018-12-14 00:22:51','2019-02-23 07:30:08','huiningxian','会宁县',NULL),(3344,'620423','景泰县','104.066394,37.193519','district',3339,0,'J','2018-12-14 00:22:51','2019-02-23 07:30:08','jingtaixian','景泰县',NULL),(3345,'620500','天水市','105.724998,34.578529','city',3319,0,'T','2018-12-14 00:22:51','2019-02-23 07:30:08','tianshui','天水',NULL),(3346,'620502','秦州区','105.724477,34.578645','district',3345,0,'Q','2018-12-14 00:22:51','2019-02-23 07:30:08','qinzhouqu','秦州区',NULL),(3347,'620503','麦积区','105.897631,34.563504','district',3345,0,'M','2018-12-14 00:22:51','2019-02-23 07:30:08','maijiqu','麦积区',NULL),(3348,'620521','清水县','106.139878,34.75287','district',3345,0,'Q','2018-12-14 00:22:51','2019-02-23 07:30:08','qingshuixian','清水县',NULL),(3349,'620522','秦安县','105.6733,34.862354','district',3345,0,'Q','2018-12-14 00:22:51','2019-02-23 07:30:08','qinanxian','秦安县',NULL),(3350,'620523','甘谷县','105.332347,34.747327','district',3345,0,'G','2018-12-14 00:22:51','2019-02-23 07:30:08','ganguxian','甘谷县',NULL),(3351,'620524','武山县','104.891696,34.721955','district',3345,0,'W','2018-12-14 00:22:51','2019-02-23 07:30:08','wushanxian','武山县',NULL),(3352,'620525','张家川回族自治县','106.212416,34.993237','district',3345,0,'Z','2018-12-14 00:22:51','2019-02-23 07:30:08','zhangjiachuanhuizuzizhixian','张家川回族自治县',NULL),(3353,'620600','武威市','102.634697,37.929996','city',3319,0,'W','2018-12-14 00:22:51','2019-02-23 07:30:08','wuwei','武威',NULL),(3354,'620602','凉州区','102.634492,37.93025','district',3353,0,'L','2018-12-14 00:22:51','2019-02-23 07:30:08','liangzhouqu','凉州区',NULL),(3355,'620621','民勤县','103.090654,38.624621','district',3353,0,'M','2018-12-14 00:22:51','2019-02-23 07:30:08','minqinxian','民勤县',NULL),(3356,'620622','古浪县','102.898047,37.470571','district',3353,0,'G','2018-12-14 00:22:52','2019-02-23 07:30:08','gulangxian','古浪县',NULL),(3357,'620623','天祝藏族自治县','103.142034,36.971678','district',3353,0,'T','2018-12-14 00:22:52','2019-02-23 07:30:08','tianzhuzangzuzizhixian','天祝藏族自治县',NULL),(3358,'620700','张掖市','100.455472,38.932897','city',3319,0,'Z','2018-12-14 00:22:52','2019-02-23 07:30:08','zhangye','张掖',NULL),(3359,'620702','甘州区','100.454862,38.931774','district',3358,0,'G','2018-12-14 00:22:52','2019-02-23 07:30:08','ganzhouqu','甘州区',NULL),(3360,'620721','肃南裕固族自治县','99.617086,38.837269','district',3358,0,'S','2018-12-14 00:22:52','2019-02-23 07:30:08','sunanyuguzuzizhixian','肃南裕固族自治县',NULL),(3361,'620722','民乐县','100.816623,38.434454','district',3358,0,'M','2018-12-14 00:22:52','2019-02-23 07:30:08','minyuexian','民乐县',NULL),(3362,'620723','临泽县','100.166333,39.152151','district',3358,0,'L','2018-12-14 00:22:52','2019-02-23 07:30:08','linzexian','临泽县',NULL),(3363,'620724','高台县','99.81665,39.376308','district',3358,0,'G','2018-12-14 00:22:52','2019-02-23 07:30:08','gaotaixian','高台县',NULL),(3364,'620725','山丹县','101.088442,38.784839','district',3358,0,'S','2018-12-14 00:22:52','2019-02-23 07:30:08','shandanxian','山丹县',NULL),(3365,'620800','平凉市','106.684691,35.54279','city',3319,0,'P','2018-12-14 00:22:52','2019-02-23 07:30:08','pingliang','平凉',NULL),(3366,'620802','崆峒区','106.684223,35.54173','district',3365,0,'K','2018-12-14 00:22:52','2019-02-23 07:30:08','kongtongqu','崆峒区',NULL),(3367,'620821','泾川县','107.365218,35.335283','district',3365,0,'J','2018-12-14 00:22:52','2019-02-23 07:30:08','jingchuanxian','泾川县',NULL),(3368,'620822','灵台县','107.620587,35.064009','district',3365,0,'L','2018-12-14 00:22:52','2019-02-23 07:30:08','lingtaixian','灵台县',NULL),(3369,'620823','崇信县','107.031253,35.304533','district',3365,0,'C','2018-12-14 00:22:52','2019-02-23 07:30:08','chongxinxian','崇信县',NULL),(3370,'620824','华亭县','106.649308,35.215342','district',3365,0,'H','2018-12-14 00:22:52','2019-02-23 07:30:08','huatingxian','华亭县',NULL),(3371,'620825','庄浪县','106.041979,35.203428','district',3365,0,'Z','2018-12-14 00:22:52','2019-02-23 07:30:08','zhuanglangxian','庄浪县',NULL),(3372,'620826','静宁县','105.733489,35.525243','district',3365,0,'J','2018-12-14 00:22:52','2019-02-23 07:30:08','jingningxian','静宁县',NULL),(3373,'620900','酒泉市','98.510795,39.744023','city',3319,0,'J','2018-12-14 00:22:52','2019-02-23 07:30:08','jiuquan','酒泉',NULL),(3374,'620902','肃州区','98.511155,39.743858','district',3373,0,'S','2018-12-14 00:22:53','2019-02-23 07:30:08','suzhouqu','肃州区',NULL),(3375,'620921','金塔县','98.902959,39.983036','district',3373,0,'J','2018-12-14 00:22:53','2019-02-23 07:30:08','jintaxian','金塔县',NULL),(3376,'620922','瓜州县','95.780591,40.516525','district',3373,0,'G','2018-12-14 00:22:53','2019-02-23 07:30:09','guazhouxian','瓜州县',NULL),(3377,'620923','肃北蒙古族自治县','94.87728,39.51224','district',3373,0,'S','2018-12-14 00:22:53','2019-02-23 07:30:09','subeimengguzuzizhixian','肃北蒙古族自治县',NULL),(3378,'620924','阿克塞哈萨克族自治县','94.337642,39.631642','district',3373,0,'A','2018-12-14 00:22:53','2019-02-23 07:30:09','akesaihasakezuzizhixian','阿克塞哈萨克族自治县',NULL),(3379,'620981','玉门市','97.037206,40.28682','district',3373,0,'Y','2018-12-14 00:22:53','2019-02-23 07:30:09','yumen','玉门',NULL),(3380,'620982','敦煌市','94.664279,40.141119','district',3373,0,'D','2018-12-14 00:22:53','2019-02-23 07:30:09','dunhuang','敦煌',NULL),(3381,'621000','庆阳市','107.638372,35.734218','city',3319,0,'Q','2018-12-14 00:22:53','2019-02-23 07:30:09','qingyang','庆阳',NULL),(3382,'621002','西峰区','107.638824,35.733713','district',3381,0,'X','2018-12-14 00:22:53','2019-02-23 07:30:09','xifengqu','西峰区',NULL),(3383,'621021','庆城县','107.885664,36.013504','district',3381,0,'Q','2018-12-14 00:22:53','2019-02-23 07:30:09','qingchengxian','庆城县',NULL),(3384,'621022','环县','107.308754,36.569322','district',3381,0,'H','2018-12-14 00:22:53','2019-02-23 07:30:09','huanxian','环县',NULL),(3385,'621023','华池县','107.986288,36.457304','district',3381,0,'H','2018-12-14 00:22:53','2019-02-23 07:30:09','huachixian','华池县',NULL),(3386,'621024','合水县','108.019865,35.819005','district',3381,0,'H','2018-12-14 00:22:53','2019-02-23 07:30:09','heshuixian','合水县',NULL),(3387,'621025','正宁县','108.361068,35.490642','district',3381,0,'Z','2018-12-14 00:22:53','2019-02-23 07:30:09','zhengningxian','正宁县',NULL),(3388,'621026','宁县','107.921182,35.50201','district',3381,0,'N','2018-12-14 00:22:53','2019-02-23 07:30:09','ningxian','宁县',NULL),(3389,'621027','镇原县','107.195706,35.677806','district',3381,0,'Z','2018-12-14 00:22:53','2019-02-23 07:30:09','zhenyuanxian','镇原县',NULL),(3390,'621100','定西市','104.626294,35.579578','city',3319,0,'D','2018-12-14 00:22:53','2019-02-23 07:30:09','dingxi','定西',NULL),(3391,'621102','安定区','104.62577,35.579764','district',3390,0,'A','2018-12-14 00:22:53','2019-02-23 07:30:09','andingqu','安定区',NULL),(3392,'621121','通渭县','105.250102,35.208922','district',3390,0,'T','2018-12-14 00:22:53','2019-02-23 07:30:09','tongweixian','通渭县',NULL),(3393,'621122','陇西县','104.637554,35.003409','district',3390,0,'L','2018-12-14 00:22:53','2019-02-23 07:30:09','longxixian','陇西县',NULL),(3394,'621123','渭源县','104.211742,35.133023','district',3390,0,'W','2018-12-14 00:22:54','2019-02-23 07:30:09','weiyuanxian','渭源县',NULL),(3395,'621124','临洮县','103.862186,35.376233','district',3390,0,'L','2018-12-14 00:22:54','2019-02-23 07:30:09','lintaoxian','临洮县',NULL),(3396,'621125','漳县','104.466756,34.848642','district',3390,0,'Z','2018-12-14 00:22:54','2019-02-23 07:30:09','zhangxian','漳县',NULL),(3397,'621126','岷县','104.039882,34.439105','district',3390,0,'M','2018-12-14 00:22:54','2019-02-23 07:30:09','minxian','岷县',NULL),(3398,'621200','陇南市','104.929379,33.388598','city',3319,0,'L','2018-12-14 00:22:54','2019-02-23 07:30:09','longnan','陇南',NULL),(3399,'621202','武都区','104.929866,33.388155','district',3398,0,'W','2018-12-14 00:22:54','2019-02-23 07:30:09','wuduqu','武都区',NULL),(3400,'621221','成县','105.734434,33.739863','district',3398,0,'C','2018-12-14 00:22:54','2019-02-23 07:30:09','chengxian','成县',NULL),(3401,'621222','文县','104.682448,32.942171','district',3398,0,'W','2018-12-14 00:22:54','2019-02-23 07:30:09','wenxian','文县',NULL),(3402,'621223','宕昌县','104.394475,34.042655','district',3398,0,'D','2018-12-14 00:22:54','2019-02-23 07:30:09','dangchangxian','宕昌县',NULL),(3403,'621224','康县','105.609534,33.328266','district',3398,0,'K','2018-12-14 00:22:54','2019-02-23 07:30:09','kangxian','康县',NULL),(3404,'621225','西和县','105.299737,34.013718','district',3398,0,'X','2018-12-14 00:22:54','2019-02-23 07:30:09','xihexian','西和县',NULL),(3405,'621226','礼县','105.181616,34.189387','district',3398,0,'L','2018-12-14 00:22:54','2019-02-23 07:30:09','lixian','礼县',NULL),(3406,'621227','徽县','106.085632,33.767785','district',3398,0,'H','2018-12-14 00:22:54','2019-02-23 07:30:09','huixian','徽县',NULL),(3407,'621228','两当县','106.306959,33.910729','district',3398,0,'L','2018-12-14 00:22:54','2019-02-23 07:30:09','liangdangxian','两当县',NULL),(3408,'622900','临夏回族自治州','103.212006,35.599446','city',3319,0,'L','2018-12-14 00:22:54','2019-02-23 07:30:09','linxiahuizuzizhizhou','临夏回族自治州',NULL),(3409,'622901','临夏市','103.211634,35.59941','district',3408,0,'L','2018-12-14 00:22:54','2019-02-23 07:30:09','linxia','临夏',NULL),(3410,'622921','临夏县','102.993873,35.49236','district',3408,0,'L','2018-12-14 00:22:54','2019-02-23 07:30:09','linxiaxian','临夏县',NULL),(3411,'622922','康乐县','103.709852,35.371906','district',3408,0,'K','2018-12-14 00:22:54','2019-02-23 07:30:10','kanglexian','康乐县',NULL),(3412,'622923','永靖县','103.319871,35.938933','district',3408,0,'Y','2018-12-14 00:22:54','2019-02-23 07:30:10','yongjingxian','永靖县',NULL),(3413,'622924','广河县','103.576188,35.481688','district',3408,0,'G','2018-12-14 00:22:55','2019-02-23 07:30:10','guanghexian','广河县',NULL),(3414,'622925','和政县','103.350357,35.425971','district',3408,0,'H','2018-12-14 00:22:55','2019-02-23 07:30:10','hezhengxian','和政县',NULL),(3415,'622926','东乡族自治县','103.389568,35.66383','district',3408,0,'D','2018-12-14 00:22:55','2019-02-23 07:30:10','dongxiangzuzizhixian','东乡族自治县',NULL),(3416,'622927','积石山保安族东乡族撒拉族自治县','102.877473,35.712906','district',3408,0,'J','2018-12-14 00:22:55','2019-02-23 07:30:10','jishishanbaoanzudongxiangzusalazuzizhixian','积石山保安族东乡族撒拉族自治县',NULL),(3417,'623000','甘南藏族自治州','102.911008,34.986354','city',3319,0,'G','2018-12-14 00:22:55','2019-02-23 07:30:10','gannanzangzuzizhizhou','甘南藏族自治州',NULL),(3418,'623001','合作市','102.91149,34.985973','district',3417,0,'H','2018-12-14 00:22:55','2019-02-23 07:30:10','hezuo','合作',NULL),(3419,'623021','临潭县','103.353054,34.69164','district',3417,0,'L','2018-12-14 00:22:55','2019-02-23 07:30:10','lintanxian','临潭县',NULL),(3420,'623022','卓尼县','103.508508,34.588165','district',3417,0,'Z','2018-12-14 00:22:55','2019-02-23 07:30:10','zhuonixian','卓尼县',NULL),(3421,'623023','舟曲县','104.370271,33.782964','district',3417,0,'Z','2018-12-14 00:22:55','2019-02-23 07:30:10','zhouquxian','舟曲县',NULL),(3422,'623024','迭部县','103.221009,34.055348','district',3417,0,'D','2018-12-14 00:22:55','2019-02-23 07:30:10','diebuxian','迭部县',NULL),(3423,'623025','玛曲县','102.075767,33.998068','district',3417,0,'M','2018-12-14 00:22:55','2019-02-23 07:30:10','maquxian','玛曲县',NULL),(3424,'623026','碌曲县','102.488495,34.589591','district',3417,0,'L','2018-12-14 00:22:55','2019-02-23 07:30:10','luquxian','碌曲县',NULL),(3425,'623027','夏河县','102.520743,35.200853','district',3417,0,'X','2018-12-14 00:22:55','2019-02-23 07:30:10','xiahexian','夏河县',NULL),(3426,'630000','青海省','101.778916,36.623178','province',0,2001,'Q','2018-12-14 00:22:55','2019-02-23 07:30:10','qinghaisheng','青海省',NULL),(3427,'630100','西宁市','101.778916,36.623178','city',3426,0,'X','2018-12-14 00:22:55','2019-02-23 07:30:10','xining','西宁',NULL),(3428,'630102','城东区','101.796095,36.616043','district',3427,0,'C','2018-12-14 00:22:55','2019-02-23 07:30:10','chengdongqu','城东区',NULL),(3429,'630103','城中区','101.784554,36.621181','district',3427,0,'C','2018-12-14 00:22:56','2019-02-23 07:30:10','chengzhongqu','城中区',NULL),(3430,'630104','城西区','101.763649,36.628323','district',3427,0,'C','2018-12-14 00:22:56','2019-02-23 07:30:10','chengxiqu','城西区',NULL),(3431,'630105','城北区','101.761297,36.648448','district',3427,0,'C','2018-12-14 00:22:56','2019-02-23 07:30:10','chengbeiqu','城北区',NULL),(3432,'630121','大通回族土族自治县','101.684183,36.931343','district',3427,0,'D','2018-12-14 00:22:56','2019-02-23 07:30:10','datonghuizutuzuzizhixian','大通回族土族自治县',NULL),(3433,'630122','湟中县','101.569475,36.500419','district',3427,0,'H','2018-12-14 00:22:56','2019-02-23 07:30:10','huangzhongxian','湟中县',NULL),(3434,'630123','湟源县','101.263435,36.684818','district',3427,0,'H','2018-12-14 00:22:56','2019-02-23 07:30:10','huangyuanxian','湟源县',NULL),(3435,'630200','海东市','102.10327,36.502916','city',3426,0,'H','2018-12-14 00:22:56','2019-02-23 07:30:10','haidong','海东',NULL),(3436,'630202','乐都区','102.402431,36.480291','district',3435,0,'L','2018-12-14 00:22:56','2019-02-23 07:30:10','ledouqu','乐都区',NULL),(3437,'630203','平安区','102.104295,36.502714','district',3435,0,'P','2018-12-14 00:22:56','2019-02-23 07:30:10','pinganqu','平安区',NULL),(3438,'630222','民和回族土族自治县','102.804209,36.329451','district',3435,0,'M','2018-12-14 00:22:56','2019-02-23 07:30:10','minhehuizutuzuzizhixian','民和回族土族自治县',NULL),(3439,'630223','互助土族自治县','101.956734,36.83994','district',3435,0,'H','2018-12-14 00:22:56','2019-02-23 07:30:10','huzhutuzuzizhixian','互助土族自治县',NULL),(3440,'630224','化隆回族自治县','102.262329,36.098322','district',3435,0,'H','2018-12-14 00:22:56','2019-02-23 07:30:10','hualonghuizuzizhixian','化隆回族自治县',NULL),(3441,'630225','循化撒拉族自治县','102.486534,35.847247','district',3435,0,'X','2018-12-14 00:22:56','2019-02-23 07:30:10','xunhuasalazuzizhixian','循化撒拉族自治县',NULL),(3442,'632200','海北藏族自治州','100.901059,36.959435','city',3426,0,'H','2018-12-14 00:22:56','2019-02-23 07:30:10','haibeizangzuzizhizhou','海北藏族自治州',NULL),(3443,'632221','门源回族自治县','101.618461,37.376627','district',3442,0,'M','2018-12-14 00:22:56','2019-02-23 07:30:10','menyuanhuizuzizhixian','门源回族自治县',NULL),(3444,'632222','祁连县','100.249778,38.175409','district',3442,0,'Q','2018-12-14 00:22:57','2019-02-23 07:30:10','qilianxian','祁连县',NULL),(3445,'632223','海晏县','100.90049,36.959542','district',3442,0,'H','2018-12-14 00:22:57','2019-02-23 07:30:10','haiyanxian','海晏县',NULL),(3446,'632224','刚察县','100.138417,37.326263','district',3442,0,'G','2018-12-14 00:22:57','2019-02-23 07:30:11','gangchaxian','刚察县',NULL),(3447,'632300','黄南藏族自治州','102.019988,35.517744','city',3426,0,'H','2018-12-14 00:22:57','2019-02-23 07:30:11','huangnanzangzuzizhizhou','黄南藏族自治州',NULL),(3448,'632321','同仁县','102.017604,35.516337','district',3447,0,'T','2018-12-14 00:22:57','2019-02-23 07:30:11','tongrenxian','同仁县',NULL),(3449,'632322','尖扎县','102.031953,35.938205','district',3447,0,'J','2018-12-14 00:22:57','2019-02-23 07:30:11','jianzhaxian','尖扎县',NULL),(3450,'632323','泽库县','101.469343,35.036842','district',3447,0,'Z','2018-12-14 00:22:57','2019-02-23 07:30:11','zekuxian','泽库县',NULL),(3451,'632324','河南蒙古族自治县','101.611877,34.734522','district',3447,0,'H','2018-12-14 00:22:57','2019-02-23 07:30:11','henanmengguzuzizhixian','河南蒙古族自治县',NULL),(3452,'632500','海南藏族自治州','100.619542,36.280353','city',3426,0,'H','2018-12-14 00:22:57','2019-02-23 07:30:11','hainanzangzuzizhizhou','海南藏族自治州',NULL),(3453,'632521','共和县','100.619597,36.280286','district',3452,0,'G','2018-12-14 00:22:57','2019-02-23 07:30:11','gonghexian','共和县',NULL),(3454,'632522','同德县','100.579465,35.254492','district',3452,0,'T','2018-12-14 00:22:57','2019-02-23 07:30:11','tongdexian','同德县',NULL),(3455,'632523','贵德县','101.431856,36.040456','district',3452,0,'G','2018-12-14 00:22:57','2019-02-23 07:30:11','guidexian','贵德县',NULL),(3456,'632524','兴海县','99.986963,35.58909','district',3452,0,'X','2018-12-14 00:22:57','2019-02-23 07:30:11','xinghaixian','兴海县',NULL),(3457,'632525','贵南县','100.74792,35.587085','district',3452,0,'G','2018-12-14 00:22:57','2019-02-23 07:30:11','guinanxian','贵南县',NULL),(3458,'632600','果洛藏族自治州','100.242143,34.4736','city',3426,0,'G','2018-12-14 00:22:57','2019-02-23 07:30:11','guoluozangzuzizhizhou','果洛藏族自治州',NULL),(3459,'632621','玛沁县','100.243531,34.473386','district',3458,0,'M','2018-12-14 00:22:58','2019-02-23 07:30:11','maqinxian','玛沁县',NULL),(3460,'632622','班玛县','100.737955,32.931589','district',3458,0,'B','2018-12-14 00:22:58','2019-02-23 07:30:11','banmaxian','班玛县',NULL),(3461,'632623','甘德县','99.902589,33.966987','district',3458,0,'G','2018-12-14 00:22:58','2019-02-23 07:30:11','gandexian','甘德县',NULL),(3462,'632624','达日县','99.651715,33.753259','district',3458,0,'D','2018-12-14 00:22:58','2019-02-23 07:30:11','darixian','达日县',NULL),(3463,'632625','久治县','101.484884,33.430217','district',3458,0,'J','2018-12-14 00:22:58','2019-02-23 07:30:11','jiuzhixian','久治县',NULL),(3464,'632626','玛多县','98.211343,34.91528','district',3458,0,'M','2018-12-14 00:22:58','2019-02-23 07:30:11','maduoxian','玛多县',NULL),(3465,'632700','玉树藏族自治州','97.008522,33.004049','city',3426,0,'Y','2018-12-14 00:22:58','2019-02-23 07:30:11','yushuzangzuzizhizhou','玉树藏族自治州',NULL),(3466,'632701','玉树市','97.008762,33.00393','district',3465,0,'Y','2018-12-14 00:22:58','2019-02-23 07:30:11','yushu','玉树',NULL),(3467,'632722','杂多县','95.293423,32.891886','district',3465,0,'Z','2018-12-14 00:22:58','2019-02-23 07:30:11','zaduoxian','杂多县',NULL),(3468,'632723','称多县','97.110893,33.367884','district',3465,0,'C','2018-12-14 00:22:58','2019-02-23 07:30:11','chenduoxian','称多县',NULL),(3469,'632724','治多县','95.616843,33.852322','district',3465,0,'Z','2018-12-14 00:22:58','2019-02-23 07:30:11','zhiduoxian','治多县',NULL),(3470,'632725','囊谦县','96.479797,32.203206','district',3465,0,'N','2018-12-14 00:22:58','2019-02-23 07:30:11','nangqianxian','囊谦县',NULL),(3471,'632726','曲麻莱县','95.800674,34.12654','district',3465,0,'Q','2018-12-14 00:22:58','2019-02-23 07:30:11','qumalaixian','曲麻莱县',NULL),(3472,'632800','海西蒙古族藏族自治州','97.370785,37.374663','city',3426,0,'H','2018-12-14 00:22:58','2019-02-23 07:30:11','haiximengguzuzangzuzizhizhou','海西蒙古族藏族自治州',NULL),(3473,'632801','格尔木市','94.905777,36.401541','district',3472,0,'G','2018-12-14 00:22:58','2019-02-23 07:30:11','geermu','格尔木',NULL),(3474,'632802','德令哈市','97.370143,37.374555','district',3472,0,'D','2018-12-14 00:22:59','2019-02-23 07:30:11','delingha','德令哈',NULL),(3475,'632821','乌兰县','98.479852,36.930389','district',3472,0,'W','2018-12-14 00:22:59','2019-02-23 07:30:11','wulanxian','乌兰县',NULL),(3476,'632822','都兰县','98.089161,36.298553','district',3472,0,'D','2018-12-14 00:22:59','2019-02-23 07:30:11','dulanxian','都兰县',NULL),(3477,'632823','天峻县','99.02078,37.29906','district',3472,0,'T','2018-12-14 00:22:59','2019-02-23 07:30:11','tianjunxian','天峻县',NULL),(3478,'632825','海西蒙古族藏族自治州直辖','95.357233,37.853631','district',3472,0,'H','2018-12-14 00:22:59','2019-02-23 07:30:11','haiximengguzuzangzuzizhizhouzhixia','海西蒙古族藏族自治州直辖',NULL),(3479,'640000','宁夏回族自治区','106.278179,38.46637','province',0,2002,'N','2018-12-14 00:22:59','2019-02-23 07:30:11','ningxiahuizuzizhiqu','宁夏回族自治区',NULL),(3480,'640100','银川市','106.278179,38.46637','city',3479,0,'Y','2018-12-14 00:22:59','2019-02-23 07:30:12','yinchuan','银川',NULL),(3481,'640104','兴庆区','106.278393,38.46747','district',3480,0,'X','2018-12-14 00:22:59','2019-02-23 07:30:12','xingqingqu','兴庆区',NULL),(3482,'640105','西夏区','106.132116,38.492424','district',3480,0,'X','2018-12-14 00:22:59','2019-02-23 07:30:12','xixiaqu','西夏区',NULL),(3483,'640106','金凤区','106.228486,38.477353','district',3480,0,'J','2018-12-14 00:22:59','2019-02-23 07:30:12','jinfengqu','金凤区',NULL),(3484,'640121','永宁县','106.253781,38.28043','district',3480,0,'Y','2018-12-14 00:22:59','2019-02-23 07:30:12','yongningxian','永宁县',NULL),(3485,'640122','贺兰县','106.345904,38.554563','district',3480,0,'H','2018-12-14 00:22:59','2019-02-23 07:30:12','helanxian','贺兰县',NULL),(3486,'640181','灵武市','106.334701,38.094058','district',3480,0,'L','2018-12-14 00:22:59','2019-02-23 07:30:12','lingwu','灵武',NULL),(3487,'640200','石嘴山市','106.376173,39.01333','city',3479,0,'S','2018-12-14 00:22:59','2019-02-23 07:30:12','shizuishan','石嘴山',NULL),(3488,'640202','大武口区','106.376651,39.014158','district',3487,0,'D','2018-12-14 00:22:59','2019-02-23 07:30:12','dawukouqu','大武口区',NULL),(3489,'640205','惠农区','106.775513,39.230094','district',3487,0,'H','2018-12-14 00:23:00','2019-02-23 07:30:12','huinongqu','惠农区',NULL),(3490,'640221','平罗县','106.54489,38.90674','district',3487,0,'P','2018-12-14 00:23:00','2019-02-23 07:30:12','pingluoxian','平罗县',NULL),(3491,'640300','吴忠市','106.199409,37.986165','city',3479,0,'W','2018-12-14 00:23:00','2019-02-23 07:30:12','wuzhong','吴忠',NULL),(3492,'640302','利通区','106.199419,37.985967','district',3491,0,'L','2018-12-14 00:23:00','2019-02-23 07:30:12','litongqu','利通区',NULL),(3493,'640303','红寺堡区','106.067315,37.421616','district',3491,0,'H','2018-12-14 00:23:00','2019-02-23 07:30:12','hongsibaoqu','红寺堡区',NULL),(3494,'640323','盐池县','107.40541,37.784222','district',3491,0,'Y','2018-12-14 00:23:00','2019-02-23 07:30:12','yanchixian','盐池县',NULL),(3495,'640324','同心县','105.914764,36.9829','district',3491,0,'T','2018-12-14 00:23:00','2019-02-23 07:30:12','tongxinxian','同心县',NULL),(3496,'640381','青铜峡市','106.075395,38.021509','district',3491,0,'Q','2018-12-14 00:23:00','2019-02-23 07:30:12','qingtongxia','青铜峡',NULL),(3497,'640400','固原市','106.285241,36.004561','city',3479,0,'G','2018-12-14 00:23:00','2019-02-23 07:30:12','guyuan','固原',NULL),(3498,'640402','原州区','106.28477,36.005337','district',3497,0,'Y','2018-12-14 00:23:00','2019-02-23 07:30:12','yuanzhouqu','原州区',NULL),(3499,'640422','西吉县','105.731801,35.965384','district',3497,0,'X','2018-12-14 00:23:00','2019-02-23 07:30:12','xijixian','西吉县',NULL),(3500,'640423','隆德县','106.12344,35.618234','district',3497,0,'L','2018-12-14 00:23:00','2019-02-23 07:30:12','longdexian','隆德县',NULL),(3501,'640424','泾源县','106.338674,35.49344','district',3497,0,'J','2018-12-14 00:23:00','2019-02-23 07:30:12','jingyuanxian','泾源县',NULL),(3502,'640425','彭阳县','106.641512,35.849975','district',3497,0,'P','2018-12-14 00:23:00','2019-02-23 07:30:12','pengyangxian','彭阳县',NULL),(3503,'640500','中卫市','105.189568,37.514951','city',3479,0,'Z','2018-12-14 00:23:00','2019-02-23 07:30:12','zhongwei','中卫',NULL),(3504,'640502','沙坡头区','105.190536,37.514564','district',3503,0,'S','2018-12-14 00:23:00','2019-02-23 07:30:12','shapotouqu','沙坡头区',NULL),(3505,'640521','中宁县','105.675784,37.489736','district',3503,0,'Z','2018-12-14 00:23:01','2019-02-23 07:30:12','zhongningxian','中宁县',NULL),(3506,'640522','海原县','105.647323,36.562007','district',3503,0,'H','2018-12-14 00:23:01','2019-02-23 07:30:12','haiyuanxian','海原县',NULL),(3507,'650000','新疆维吾尔自治区','87.617733,43.792818','province',0,2002,'X','2018-12-14 00:23:01','2019-02-23 07:30:12','xinjiangweiwuerzizhiqu','新疆维吾尔自治区',NULL),(3508,'650100','乌鲁木齐市','87.617733,43.792818','city',3507,0,'W','2018-12-14 00:23:01','2019-02-23 07:30:12','wulumuqi','乌鲁木齐',NULL),(3509,'650102','天山区','87.620116,43.796428','district',3508,0,'T','2018-12-14 00:23:01','2019-02-23 07:30:12','tianshanqu','天山区',NULL),(3510,'650103','沙依巴克区','87.596639,43.788872','district',3508,0,'S','2018-12-14 00:23:01','2019-02-23 07:30:12','shayibakequ','沙依巴克区',NULL),(3511,'650104','新市区','87.560653,43.870882','district',3508,0,'X','2018-12-14 00:23:01','2019-02-23 07:30:12','xinqu','新区',NULL),(3512,'650105','水磨沟区','87.613093,43.816747','district',3508,0,'S','2018-12-14 00:23:01','2019-02-23 07:30:13','shuimogouqu','水磨沟区',NULL),(3513,'650106','头屯河区','87.425823,43.876053','district',3508,0,'T','2018-12-14 00:23:01','2019-02-23 07:30:13','toutunhequ','头屯河区',NULL),(3514,'650107','达坂城区','88.30994,43.36181','district',3508,0,'D','2018-12-14 00:23:01','2019-02-23 07:30:13','dabanchengqu','达坂城区',NULL),(3515,'650109','米东区','87.691801,43.960982','district',3508,0,'M','2018-12-14 00:23:01','2019-02-23 07:30:13','midongqu','米东区',NULL),(3516,'650121','乌鲁木齐县','87.505603,43.982546','district',3508,0,'W','2018-12-14 00:23:01','2019-02-23 07:30:13','wulumuqixian','乌鲁木齐县',NULL),(3517,'650200','克拉玛依市','84.873946,45.595886','city',3507,0,'K','2018-12-14 00:23:01','2019-02-23 07:30:13','kelamayi','克拉玛依',NULL),(3518,'650202','独山子区','84.882267,44.327207','district',3517,0,'D','2018-12-14 00:23:01','2019-02-23 07:30:13','dushanziqu','独山子区',NULL),(3519,'650203','克拉玛依区','84.868918,45.600477','district',3517,0,'K','2018-12-14 00:23:01','2019-02-23 07:30:13','kelamayiqu','克拉玛依区',NULL),(3520,'650204','白碱滩区','85.129882,45.689021','district',3517,0,'B','2018-12-14 00:23:02','2019-02-23 07:30:13','baijiantanqu','白碱滩区',NULL),(3521,'650205','乌尔禾区','85.697767,46.08776','district',3517,0,'W','2018-12-14 00:23:02','2019-02-23 07:30:13','wuerhequ','乌尔禾区',NULL),(3522,'650400','吐鲁番市','89.184078,42.947613','city',3507,0,'T','2018-12-14 00:23:02','2019-02-23 07:30:13','tulufan','吐鲁番',NULL),(3523,'650402','高昌区','89.182324,42.947627','district',3522,0,'G','2018-12-14 00:23:02','2019-02-23 07:30:13','gaochangqu','高昌区',NULL),(3524,'650421','鄯善县','90.212692,42.865503','district',3522,0,'S','2018-12-14 00:23:02','2019-02-23 07:30:13','shanshanxian','鄯善县',NULL),(3525,'650422','托克逊县','88.655771,42.793536','district',3522,0,'T','2018-12-14 00:23:02','2019-02-23 07:30:13','tuokexunxian','托克逊县',NULL),(3526,'650500','哈密市','93.51316,42.833248','city',3507,0,'H','2018-12-14 00:23:02','2019-02-23 07:30:13','hami','哈密',NULL),(3527,'650502','伊州区','93.509174,42.833888','district',3526,0,'Y','2018-12-14 00:23:02','2019-02-23 07:30:13','yizhouqu','伊州区',NULL),(3528,'650521','巴里坤哈萨克自治县','93.021795,43.599032','district',3526,0,'B','2018-12-14 00:23:02','2019-02-23 07:30:13','balikunhasakezizhixian','巴里坤哈萨克自治县',NULL),(3529,'650522','伊吾县','94.692773,43.252012','district',3526,0,'Y','2018-12-14 00:23:02','2019-02-23 07:30:13','yiwuxian','伊吾县',NULL),(3530,'652300','昌吉回族自治州','87.304012,44.014577','city',3507,0,'C','2018-12-14 00:23:02','2019-02-23 07:30:13','changjihuizuzizhizhou','昌吉回族自治州',NULL),(3531,'652301','昌吉市','87.304112,44.013183','district',3530,0,'C','2018-12-14 00:23:02','2019-02-23 07:30:13','changji','昌吉',NULL),(3532,'652302','阜康市','87.98384,44.152153','district',3530,0,'F','2018-12-14 00:23:02','2019-02-23 07:30:14','fukang','阜康',NULL),(3533,'652323','呼图壁县','86.888613,44.189342','district',3530,0,'H','2018-12-14 00:23:02','2019-02-23 07:30:14','hutubixian','呼图壁县',NULL),(3534,'652324','玛纳斯县','86.217687,44.305625','district',3530,0,'M','2018-12-14 00:23:02','2019-02-23 07:30:14','manasixian','玛纳斯县',NULL),(3535,'652325','奇台县','89.591437,44.021996','district',3530,0,'Q','2018-12-14 00:23:02','2019-02-23 07:30:14','qitaixian','奇台县',NULL),(3536,'652327','吉木萨尔县','89.181288,43.997162','district',3530,0,'J','2018-12-14 00:23:02','2019-02-23 07:30:14','jimusaerxian','吉木萨尔县',NULL),(3537,'652328','木垒哈萨克自治县','90.282833,43.832442','district',3530,0,'M','2018-12-14 00:23:03','2019-02-23 07:30:14','muleihasakezizhixian','木垒哈萨克自治县',NULL),(3538,'652700','博尔塔拉蒙古自治州','82.074778,44.903258','city',3507,0,'B','2018-12-14 00:23:03','2019-02-23 07:30:14','boertalamengguzizhizhou','博尔塔拉蒙古自治州',NULL),(3539,'652701','博乐市','82.072237,44.903087','district',3538,0,'B','2018-12-14 00:23:03','2019-02-23 07:30:14','bole','博乐',NULL),(3540,'652702','阿拉山口市','82.569389,45.16777','district',3538,0,'A','2018-12-14 00:23:03','2019-02-23 07:30:14','alashankou','阿拉山口',NULL),(3541,'652722','精河县','82.892938,44.605645','district',3538,0,'J','2018-12-14 00:23:03','2019-02-23 07:30:14','jinghexian','精河县',NULL),(3542,'652723','温泉县','81.03099,44.973751','district',3538,0,'W','2018-12-14 00:23:03','2019-02-23 07:30:14','wenquanxian','温泉县',NULL),(3543,'652800','巴音郭楞蒙古自治州','86.150969,41.768552','city',3507,0,'B','2018-12-14 00:23:03','2019-02-23 07:30:14','bayinguolengmengguzizhizhou','巴音郭楞蒙古自治州',NULL),(3544,'652801','库尔勒市','86.145948,41.763122','district',3543,0,'K','2018-12-14 00:23:03','2019-02-23 07:30:14','kuerle','库尔勒',NULL),(3545,'652822','轮台县','84.248542,41.781266','district',3543,0,'L','2018-12-14 00:23:03','2019-02-23 07:30:14','luntaixian','轮台县',NULL),(3546,'652823','尉犁县','86.263412,41.337428','district',3543,0,'Y','2018-12-14 00:23:03','2019-02-23 07:30:14','yulixian','尉犁县',NULL),(3547,'652824','若羌县','88.168807,39.023807','district',3543,0,'R','2018-12-14 00:23:04','2019-02-23 07:30:14','ruoqiangxian','若羌县',NULL),(3548,'652825','且末县','85.532629,38.138562','district',3543,0,'Q','2018-12-14 00:23:04','2019-02-23 07:30:14','qiemoxian','且末县',NULL),(3549,'652826','焉耆回族自治县','86.5698,42.064349','district',3543,0,'Y','2018-12-14 00:23:04','2019-02-23 07:30:14','yanqihuizuzizhixian','焉耆回族自治县',NULL),(3550,'652827','和静县','86.391067,42.31716','district',3543,0,'H','2018-12-14 00:23:04','2019-02-23 07:30:14','hejingxian','和静县',NULL),(3551,'652828','和硕县','86.864947,42.268863','district',3543,0,'H','2018-12-14 00:23:04','2019-02-23 07:30:14','heshuoxian','和硕县',NULL),(3552,'652829','博湖县','86.631576,41.980166','district',3543,0,'B','2018-12-14 00:23:04','2019-02-23 07:30:14','bohuxian','博湖县',NULL),(3553,'652900','阿克苏地区','80.265068,41.170712','city',3507,0,'A','2018-12-14 00:23:04','2019-02-23 07:30:14','akesudiqu','阿克苏地区',NULL),(3554,'652901','阿克苏市','80.2629,41.171272','district',3553,0,'A','2018-12-14 00:23:04','2019-02-23 07:30:14','akesu','阿克苏',NULL),(3555,'652922','温宿县','80.243273,41.272995','district',3553,0,'W','2018-12-14 00:23:04','2019-02-23 07:30:14','wensuxian','温宿县',NULL),(3556,'652923','库车县','82.96304,41.717141','district',3553,0,'K','2018-12-14 00:23:04','2019-02-23 07:30:14','kuchexian','库车县',NULL),(3557,'652924','沙雅县','82.78077,41.226268','district',3553,0,'S','2018-12-14 00:23:04','2019-02-23 07:30:14','shayaxian','沙雅县',NULL),(3558,'652925','新和县','82.610828,41.551176','district',3553,0,'X','2018-12-14 00:23:04','2019-02-23 07:30:14','xinhexian','新和县',NULL),(3559,'652926','拜城县','81.869881,41.796101','district',3553,0,'B','2018-12-14 00:23:04','2019-02-23 07:30:14','baichengxian','拜城县',NULL),(3560,'652927','乌什县','79.230805,41.21587','district',3553,0,'W','2018-12-14 00:23:04','2019-02-23 07:30:14','wushixian','乌什县',NULL),(3561,'652928','阿瓦提县','80.378426,40.638422','district',3553,0,'A','2018-12-14 00:23:04','2019-02-23 07:30:14','awatixian','阿瓦提县',NULL),(3562,'652929','柯坪县','79.04785,40.50624','district',3553,0,'K','2018-12-14 00:23:04','2019-02-23 07:30:14','kepingxian','柯坪县',NULL),(3563,'653000','克孜勒苏柯尔克孜自治州','76.172825,39.713431','city',3507,0,'K','2018-12-14 00:23:04','2019-02-23 07:30:14','kezilesukeerkezizizhizhou','克孜勒苏柯尔克孜自治州',NULL),(3564,'653001','阿图什市','76.173939,39.712898','district',3563,0,'A','2018-12-14 00:23:05','2019-02-23 07:30:14','atushi','阿图什',NULL),(3565,'653022','阿克陶县','75.945159,39.147079','district',3563,0,'A','2018-12-14 00:23:05','2019-02-23 07:30:14','aketaoxian','阿克陶县',NULL),(3566,'653023','阿合奇县','78.450164,40.937567','district',3563,0,'A','2018-12-14 00:23:05','2019-02-23 07:30:14','aheqixian','阿合奇县',NULL),(3567,'653024','乌恰县','75.25969,39.716633','district',3563,0,'W','2018-12-14 00:23:05','2019-02-23 07:30:15','wuqiaxian','乌恰县',NULL),(3568,'653100','喀什地区','75.989138,39.467664','city',3507,0,'K','2018-12-14 00:23:05','2019-02-23 07:30:15','kashidiqu','喀什地区',NULL),(3569,'653101','喀什市','75.98838,39.467861','district',3568,0,'K','2018-12-14 00:23:05','2019-02-23 07:30:15','kashi','喀什',NULL),(3570,'653121','疏附县','75.863075,39.378306','district',3568,0,'S','2018-12-14 00:23:05','2019-02-23 07:30:15','shufuxian','疏附县',NULL),(3571,'653122','疏勒县','76.053653,39.399461','district',3568,0,'S','2018-12-14 00:23:05','2019-02-23 07:30:15','shulexian','疏勒县',NULL),(3572,'653123','英吉沙县','76.174292,38.929839','district',3568,0,'Y','2018-12-14 00:23:05','2019-02-23 07:30:15','yingjishaxian','英吉沙县',NULL),(3573,'653124','泽普县','77.273593,38.191217','district',3568,0,'Z','2018-12-14 00:23:05','2019-02-23 07:30:15','zepuxian','泽普县',NULL),(3574,'653125','莎车县','77.248884,38.414499','district',3568,0,'S','2018-12-14 00:23:05','2019-02-23 07:30:15','shachexian','莎车县',NULL),(3575,'653126','叶城县','77.420353,37.884679','district',3568,0,'Y','2018-12-14 00:23:05','2019-02-23 07:30:15','yechengxian','叶城县',NULL),(3576,'653127','麦盖提县','77.651538,38.903384','district',3568,0,'M','2018-12-14 00:23:05','2019-02-23 07:30:15','maigetixian','麦盖提县',NULL),(3577,'653128','岳普湖县','76.7724,39.235248','district',3568,0,'Y','2018-12-14 00:23:05','2019-02-23 07:30:15','yuepuhuxian','岳普湖县',NULL),(3578,'653129','伽师县','76.741982,39.494325','district',3568,0,'J','2018-12-14 00:23:06','2019-02-23 07:30:15','jiashixian','伽师县',NULL),(3579,'653130','巴楚县','78.55041,39.783479','district',3568,0,'B','2018-12-14 00:23:06','2019-02-23 07:30:15','bachuxian','巴楚县',NULL),(3580,'653131','塔什库尔干塔吉克自治县','75.228068,37.775437','district',3568,0,'T','2018-12-14 00:23:06','2019-02-23 07:30:15','tashenkuergantajikezizhixian','塔什库尔干塔吉克自治县',NULL),(3581,'653200','和田地区','79.92533,37.110687','city',3507,0,'H','2018-12-14 00:23:06','2019-02-23 07:30:15','hetiandiqu','和田地区',NULL),(3582,'653201','和田市','79.927542,37.108944','district',3581,0,'H','2018-12-14 00:23:06','2019-02-23 07:30:15','hetian','和田',NULL),(3583,'653221','和田县','79.81907,37.120031','district',3581,0,'H','2018-12-14 00:23:06','2019-02-23 07:30:15','hetianxian','和田县',NULL),(3584,'653222','墨玉县','79.736629,37.271511','district',3581,0,'M','2018-12-14 00:23:06','2019-02-23 07:30:15','moyuxian','墨玉县',NULL),(3585,'653223','皮山县','78.282301,37.616332','district',3581,0,'P','2018-12-14 00:23:06','2019-02-23 07:30:15','pishanxian','皮山县',NULL),(3586,'653224','洛浦县','80.184038,37.074377','district',3581,0,'L','2018-12-14 00:23:06','2019-02-23 07:30:15','luopuxian','洛浦县',NULL),(3587,'653225','策勒县','80.803572,37.001672','district',3581,0,'C','2018-12-14 00:23:06','2019-02-23 07:30:15','celexian','策勒县',NULL),(3588,'653226','于田县','81.667845,36.854628','district',3581,0,'Y','2018-12-14 00:23:06','2019-02-23 07:30:15','yutianxian','于田县',NULL),(3589,'653227','民丰县','82.692354,37.064909','district',3581,0,'M','2018-12-14 00:23:06','2019-02-23 07:30:15','minfengxian','民丰县',NULL),(3590,'654000','伊犁哈萨克自治州','81.317946,43.92186','city',3507,0,'Y','2018-12-14 00:23:06','2019-02-23 07:30:15','yilihasakezizhizhou','伊犁哈萨克自治州',NULL),(3591,'654002','伊宁市','81.316343,43.922209','district',3590,0,'Y','2018-12-14 00:23:06','2019-02-23 07:30:15','yining','伊宁',NULL),(3592,'654003','奎屯市','84.901602,44.423445','district',3590,0,'K','2018-12-14 00:23:06','2019-02-23 07:30:15','kuitun','奎屯',NULL),(3593,'654004','霍尔果斯市','80.420759,44.201669','district',3590,0,'H','2018-12-14 00:23:06','2019-02-23 07:30:15','huoerguosi','霍尔果斯',NULL),(3594,'654021','伊宁县','81.524671,43.977876','district',3590,0,'Y','2018-12-14 00:23:07','2019-02-23 07:30:15','yiningxian','伊宁县',NULL),(3595,'654022','察布查尔锡伯自治县','81.150874,43.838883','district',3590,0,'C','2018-12-14 00:23:07','2019-02-23 07:30:15','chabuchaerxibozizhixian','察布查尔锡伯自治县',NULL),(3596,'654023','霍城县','80.872508,44.049912','district',3590,0,'H','2018-12-14 00:23:07','2019-02-23 07:30:15','huochengxian','霍城县',NULL),(3597,'654024','巩留县','82.227044,43.481618','district',3590,0,'G','2018-12-14 00:23:07','2019-02-23 07:30:15','gongliuxian','巩留县',NULL),(3598,'654025','新源县','83.258493,43.434249','district',3590,0,'X','2018-12-14 00:23:07','2019-02-23 07:30:15','xinyuanxian','新源县',NULL),(3599,'654026','昭苏县','81.126029,43.157765','district',3590,0,'Z','2018-12-14 00:23:07','2019-02-23 07:30:15','zhaosuxian','昭苏县',NULL),(3600,'654027','特克斯县','81.840058,43.214861','district',3590,0,'T','2018-12-14 00:23:07','2019-02-23 07:30:15','tekesixian','特克斯县',NULL),(3601,'654028','尼勒克县','82.504119,43.789737','district',3590,0,'N','2018-12-14 00:23:07','2019-02-23 07:30:16','nilekexian','尼勒克县',NULL),(3602,'654200','塔城地区','82.985732,46.746301','city',3507,0,'T','2018-12-14 00:23:07','2019-02-23 07:30:16','tachengdiqu','塔城地区',NULL),(3603,'654201','塔城市','82.983988,46.746281','district',3602,0,'T','2018-12-14 00:23:07','2019-02-23 07:30:16','tacheng','塔城',NULL),(3604,'654202','乌苏市','84.677624,44.430115','district',3602,0,'W','2018-12-14 00:23:07','2019-02-23 07:30:16','wusu','乌苏',NULL),(3605,'654221','额敏县','83.622118,46.522555','district',3602,0,'E','2018-12-14 00:23:07','2019-02-23 07:30:16','eminxian','额敏县',NULL),(3606,'654223','沙湾县','85.622508,44.329544','district',3602,0,'S','2018-12-14 00:23:07','2019-02-23 07:30:16','shawanxian','沙湾县',NULL),(3607,'654224','托里县','83.60469,45.935863','district',3602,0,'T','2018-12-14 00:23:07','2019-02-23 07:30:16','tuolixian','托里县',NULL),(3608,'654225','裕民县','82.982157,46.202781','district',3602,0,'Y','2018-12-14 00:23:07','2019-02-23 07:30:16','yuminxian','裕民县',NULL),(3609,'654226','和布克赛尔蒙古自治县','85.733551,46.793001','district',3602,0,'H','2018-12-14 00:23:07','2019-02-23 07:30:16','hebukesaiermengguzizhixian','和布克赛尔蒙古自治县',NULL),(3610,'654300','阿勒泰地区','88.13963,47.848393','city',3507,0,'A','2018-12-14 00:23:08','2019-02-23 07:30:16','aletaidiqu','阿勒泰地区',NULL),(3611,'654301','阿勒泰市','88.138743,47.848911','district',3610,0,'A','2018-12-14 00:23:08','2019-02-23 07:30:16','aletai','阿勒泰',NULL),(3612,'654321','布尔津县','86.86186,47.70453','district',3610,0,'B','2018-12-14 00:23:08','2019-02-23 07:30:16','buerjinxian','布尔津县',NULL),(3613,'654322','富蕴县','89.524993,46.993106','district',3610,0,'F','2018-12-14 00:23:08','2019-02-23 07:30:16','fuyunxian','富蕴县',NULL),(3614,'654323','福海县','87.494569,47.113128','district',3610,0,'F','2018-12-14 00:23:08','2019-02-23 07:30:16','fuhaixian','福海县',NULL),(3615,'654324','哈巴河县','86.418964,48.059284','district',3610,0,'H','2018-12-14 00:23:08','2019-02-23 07:30:16','habahexian','哈巴河县',NULL),(3616,'654325','青河县','90.381561,46.672446','district',3610,0,'Q','2018-12-14 00:23:08','2019-02-23 07:30:16','qinghexian','青河县',NULL),(3617,'654326','吉木乃县','85.876064,47.434633','district',3610,0,'J','2018-12-14 00:23:08','2019-02-23 07:30:16','jimunaixian','吉木乃县',NULL),(3618,'659001','石河子市','86.041075,44.305886','city',3507,0,'S','2018-12-14 00:23:08','2019-02-23 07:30:16','shihezi','石河子',NULL),(3619,'659001','东城街道','86.0687,44.2873','street',3618,0,'D','2018-12-14 00:23:08','2019-02-23 07:30:16','dongchengjiedao','东城街道',NULL),(3620,'659001','兵团一五二团','86.0704,44.2827','street',3618,0,'B','2018-12-14 00:23:08','2019-02-23 07:30:16','bingtuanyiwuertuan','兵团一五二团',NULL),(3621,'659001','北泉镇','86.0983,44.4346','street',3618,0,'B','2018-12-14 00:23:08','2019-02-23 07:30:16','beiquanzhen','北泉镇',NULL),(3622,'659001','向阳街道','86.0397,44.3429','street',3618,0,'X','2018-12-14 00:23:08','2019-02-23 07:30:16','xiangyangjiedao','向阳街道',NULL),(3623,'659001','新城街道','85.9823,44.2893','street',3618,0,'X','2018-12-14 00:23:08','2019-02-23 07:30:16','xinchengjiedao','新城街道',NULL),(3624,'659001','石河子乡','86.1022,44.1352','street',3618,0,'S','2018-12-14 00:23:08','2019-02-23 07:30:16','shihezixiang','石河子乡',NULL),(3625,'659001','红山街道','86.048,44.2682','street',3618,0,'H','2018-12-14 00:23:08','2019-02-23 07:30:16','hongshanjiedao','红山街道',NULL),(3626,'659001','老街街道','85.9909,44.3496','street',3618,0,'L','2018-12-14 00:23:08','2019-02-23 07:30:16','laojiejiedao','老街街道',NULL),(3627,'659002','阿拉尔市','81.285884,40.541914','city',3507,0,'A','2018-12-14 00:23:09','2019-02-23 07:30:16','alaer','阿拉尔',NULL),(3628,'659002','中心监狱','81.2766,40.6692','street',3627,0,'Z','2018-12-14 00:23:09','2019-02-23 07:30:16','zhongxinjianyu','中心监狱',NULL),(3629,'659002','兵团七团','80.6543,40.6569','street',3627,0,'B','2018-12-14 00:23:09','2019-02-23 07:30:17','bingtuanqituan','兵团七团',NULL),(3630,'659002','兵团八团','80.7996,40.5973','street',3627,0,'B','2018-12-14 00:23:09','2019-02-23 07:30:17','bingtuanbatuan','兵团八团',NULL),(3631,'659002','兵团十一团','81.5619,40.6277','street',3627,0,'B','2018-12-14 00:23:09','2019-02-23 07:30:17','bingtuanshiyituan','兵团十一团',NULL),(3632,'659002','兵团十三团','81.4734,40.5742','street',3627,0,'B','2018-12-14 00:23:09','2019-02-23 07:30:17','bingtuanshisantuan','兵团十三团',NULL),(3633,'659002','兵团十二团','81.1109,40.4977','street',3627,0,'B','2018-12-14 00:23:09','2019-02-23 07:30:17','bingtuanshiertuan','兵团十二团',NULL),(3634,'659002','兵团十六团','80.7871,40.4163','street',3627,0,'B','2018-12-14 00:23:09','2019-02-23 07:30:17','bingtuanshiliutuan','兵团十六团',NULL),(3635,'659002','兵团十四团','81.8688,40.9423','street',3627,0,'B','2018-12-14 00:23:09','2019-02-23 07:30:17','bingtuanshisituan','兵团十四团',NULL),(3636,'659002','兵团十团','81.259,40.6387','street',3627,0,'B','2018-12-14 00:23:09','2019-02-23 07:30:17','bingtuanshituan','兵团十团',NULL),(3637,'659002','兵团第一师塔里木灌区水利管理处','81.2876,40.5454','street',3627,0,'B','2018-12-14 00:23:09','2019-02-23 07:30:17','bingtuandiyishitalimuguanqushuiliguanlichu','兵团第一师塔里木灌区水利管理处',NULL),(3638,'659002','兵团第一师幸福农场','80.9904,40.7025','street',3627,0,'B','2018-12-14 00:23:09','2019-02-23 07:30:17','bingtuandiyishixingfunongchang','兵团第一师幸福农场',NULL),(3639,'659002','兵团第一师水利水电工程处','81.2858,40.5496','street',3627,0,'B','2018-12-14 00:23:09','2019-02-23 07:30:17','bingtuandiyishishuilishuidiangongchengchu','兵团第一师水利水电工程处',NULL),(3640,'659002','南口街道','81.2988,40.5154','street',3627,0,'N','2018-12-14 00:23:09','2019-02-23 07:30:17','nankoujiedao','南口街道',NULL),(3641,'659002','工业园区','81.2448,40.5461','street',3627,0,'G','2018-12-14 00:23:09','2019-02-23 07:30:17','gongyeyuanqu','工业园区',NULL),(3642,'659002','幸福路街道','81.2681,40.577','street',3627,0,'X','2018-12-14 00:23:10','2019-02-23 07:30:17','xingfulujiedao','幸福路街道',NULL),(3643,'659002','托喀依乡','81.3541,40.5818','street',3627,0,'T','2018-12-14 00:23:10','2019-02-23 07:30:17','tuokayixiang','托喀依乡',NULL),(3644,'659002','金银川路街道','81.2613,40.5355','street',3627,0,'J','2018-12-14 00:23:10','2019-02-23 07:30:17','jinyinchuanlujiedao','金银川路街道',NULL),(3645,'659002','阿拉尔农场','81.0627,40.5567','street',3627,0,'A','2018-12-14 00:23:10','2019-02-23 07:30:17','alaernongchang','阿拉尔农场',NULL),(3646,'659002','青松路街道','81.2545,40.542','street',3627,0,'Q','2018-12-14 00:23:10','2019-02-23 07:30:17','qingsonglujiedao','青松路街道',NULL),(3647,'659003','图木舒克市','79.077978,39.867316','city',3507,0,'T','2018-12-14 00:23:10','2019-02-23 07:30:17','tumushuke','图木舒克',NULL),(3648,'659003','兵团五十一团','79.2902,39.9888','street',3647,0,'B','2018-12-14 00:23:10','2019-02-23 07:30:17','bingtuanwushiyituan','兵团五十一团',NULL),(3649,'659003','兵团五十三团','79.3214,40.0318','street',3647,0,'B','2018-12-14 00:23:10','2019-02-23 07:30:17','bingtuanwushisantuan','兵团五十三团',NULL),(3650,'659003','兵团五十团','79.2315,39.9549','street',3647,0,'B','2018-12-14 00:23:10','2019-02-23 07:30:17','bingtuanwushituan','兵团五十团',NULL),(3651,'659003','兵团四十九团','78.756,39.8224','street',3647,0,'B','2018-12-14 00:23:10','2019-02-23 07:30:17','bingtuansishijiutuan','兵团四十九团',NULL),(3652,'659003','兵团四十四团','79.1926,39.9168','street',3647,0,'B','2018-12-14 00:23:10','2019-02-23 07:30:17','bingtuansishisituan','兵团四十四团',NULL),(3653,'659003','兵团图木舒克市喀拉拜勒镇','79.0112,39.8526','street',3647,0,'B','2018-12-14 00:23:10','2019-02-23 07:30:17','bingtuantumushukekalabaileizhen','兵团图木舒克喀拉拜勒镇',NULL),(3654,'659003','兵团图木舒克市永安坝','79.0133,39.8385','street',3647,0,'B','2018-12-14 00:23:10','2019-02-23 07:30:17','bingtuantumushukeyonganba','兵团图木舒克永安坝',NULL),(3655,'659003','前海街道','79.0778,39.855','street',3647,0,'Q','2018-12-14 00:23:10','2019-02-23 07:30:17','qianhaijiedao','前海街道',NULL),(3656,'659003','永安坝街道','79.0229,39.8507','street',3647,0,'Y','2018-12-14 00:23:10','2019-02-23 07:30:17','yonganbajiedao','永安坝街道',NULL),(3657,'659003','齐干却勒街道','79.0906,39.8753','street',3647,0,'Q','2018-12-14 00:23:10','2019-02-23 07:30:17','qiganqueleijiedao','齐干却勒街道',NULL),(3658,'659004','五家渠市','87.526884,44.167401','city',3507,0,'W','2018-12-14 00:23:10','2019-02-23 07:30:17','wujiaqu','五家渠',NULL),(3659,'659004','人民路街道','87.5728,44.1822','street',3658,0,'R','2018-12-14 00:23:11','2019-02-23 07:30:17','renminlujiedao','人民路街道',NULL),(3660,'659004','兵团一零一团','87.5562,44.1752','street',3658,0,'B','2018-12-14 00:23:11','2019-02-23 07:30:17','bingtuanyilingyituan','兵团一零一团',NULL),(3661,'659004','兵团一零三团','87.4075,44.5317','street',3658,0,'B','2018-12-14 00:23:11','2019-02-23 07:30:17','bingtuanyilingsantuan','兵团一零三团',NULL),(3662,'659004','兵团一零二团','87.5925,44.2694','street',3658,0,'B','2018-12-14 00:23:11','2019-02-23 07:30:17','bingtuanyilingertuan','兵团一零二团',NULL),(3663,'659004','军垦路街道','87.5084,44.1889','street',3658,0,'J','2018-12-14 00:23:11','2019-02-23 07:30:17','junkenlujiedao','军垦路街道',NULL),(3664,'659004','青湖路街道','87.5245,44.1764','street',3658,0,'Q','2018-12-14 00:23:11','2019-02-23 07:30:17','qinghulujiedao','青湖路街道',NULL),(3665,'659005','北屯市','87.824932,47.353177','city',3507,0,'B','2018-12-14 00:23:12','2019-02-23 07:30:18','beitun','北屯',NULL),(3666,'659005','兵团一八七团','87.761,47.1948','street',3665,0,'B','2018-12-14 00:23:12','2019-02-23 07:30:18','bingtuanyibaqituan','兵团一八七团',NULL),(3667,'659005','兵团一八三团','88.1187,47.1285','street',3665,0,'B','2018-12-14 00:23:12','2019-02-23 07:30:18','bingtuanyibasantuan','兵团一八三团',NULL),(3668,'659005','兵团一八八团','87.5186,47.4099','street',3665,0,'B','2018-12-14 00:23:12','2019-02-23 07:30:18','bingtuanyibabatuan','兵团一八八团',NULL),(3669,'659005','北屯镇','87.7224,47.4017','street',3665,0,'B','2018-12-14 00:23:12','2019-02-23 07:30:18','beitunzhen','北屯镇',NULL),(3670,'659006','铁门关市','85.501218,41.827251','city',3507,0,'T','2018-12-14 00:23:12','2019-02-23 07:30:18','tiemenguan','铁门关',NULL),(3671,'659006','兵团二十九团','85.5849,41.8825','street',3670,0,'B','2018-12-14 00:23:13','2019-02-23 07:30:18','bingtuanershijiutuan','兵团二十九团',NULL),(3672,'659006','农二师三十团','85.5849,41.8825','street',3670,0,'N','2018-12-14 00:23:13','2019-02-23 07:30:18','nongershisanshituan','农二师三十团',NULL),(3673,'659007','双河市','82.353656,44.840524','city',3507,0,'S','2018-12-14 00:23:13','2019-02-23 07:30:18','shuanghe','双河',NULL),(3674,'659007','兵团九十团','82.6473,44.7651','street',3673,0,'B','2018-12-14 00:23:13','2019-02-23 07:30:18','bingtuanjiushituan','兵团九十团',NULL),(3675,'659007','兵团八十一团','82.4908,44.7469','street',3673,0,'B','2018-12-14 00:23:13','2019-02-23 07:30:18','bingtuanbashiyituan','兵团八十一团',NULL),(3676,'659007','兵团八十九团','82.2853,45.0582','street',3673,0,'B','2018-12-14 00:23:13','2019-02-23 07:30:18','bingtuanbashijiutuan','兵团八十九团',NULL),(3677,'659007','兵团八十六团','82.1787,44.8089','street',3673,0,'B','2018-12-14 00:23:13','2019-02-23 07:30:18','bingtuanbashiliutuan','兵团八十六团',NULL),(3678,'659007','兵团八十四团','82.215,45.1246','street',3673,0,'B','2018-12-14 00:23:13','2019-02-23 07:30:18','bingtuanbashisituan','兵团八十四团',NULL),(3679,'659008','可克达拉市','80.63579,43.6832','city',3507,0,'K','2018-12-14 00:23:13','2019-02-23 07:30:18','kekedala','可克达拉',NULL),(3680,'659008','兵团六十七团','80.6068,43.7652','street',3679,0,'B','2018-12-14 00:23:13','2019-02-23 07:30:18','bingtuanliushiqituan','兵团六十七团',NULL),(3681,'659008','兵团六十三团','80.484,43.9314','street',3679,0,'B','2018-12-14 00:23:13','2019-02-23 07:30:18','bingtuanliushisantuan','兵团六十三团',NULL),(3682,'659008','兵团六十八团','80.9903,43.8897','street',3679,0,'B','2018-12-14 00:23:13','2019-02-23 07:30:18','bingtuanliushibatuan','兵团六十八团',NULL),(3683,'659008','兵团六十六团','81.086,43.9599','street',3679,0,'B','2018-12-14 00:23:13','2019-02-23 07:30:18','bingtuanliushiliutuan','兵团六十六团',NULL),(3684,'659008','兵团六十四团','80.6749,44.0986','street',3679,0,'B','2018-12-14 00:23:14','2019-02-23 07:30:18','bingtuanliushisituan','兵团六十四团',NULL),(3685,'659008','都拉塔口岸','80.6882,43.7131','street',3679,0,'D','2018-12-14 00:23:14','2019-02-23 07:30:18','doulatakouan','都拉塔口岸',NULL),(3686,'659009','昆玉市','79.287372,37.207994','city',3507,0,'K','2018-12-14 00:23:14','2019-02-23 07:30:18','kunyu','昆玉',NULL),(3687,'659009','乌尔其乡','79.5866,37.332','street',3686,0,'W','2018-12-14 00:23:14','2019-02-23 07:30:18','wuerqixiang','乌尔其乡',NULL),(3688,'659009','乌鲁克萨依乡','80.8148,36.2925','street',3686,0,'W','2018-12-14 00:23:14','2019-02-23 07:30:18','wulukesayixiang','乌鲁克萨依乡',NULL),(3689,'659009','兵团一牧场','81.0295,36.3152','street',3686,0,'B','2018-12-14 00:23:14','2019-02-23 07:30:18','bingtuanyimuchang','兵团一牧场',NULL),(3690,'659009','兵团二二四团','79.3499,37.3602','street',3686,0,'B','2018-12-14 00:23:14','2019-02-23 07:30:18','bingtuanerersituan','兵团二二四团',NULL),(3691,'659009','兵团四十七团','79.6039,37.3666','street',3686,0,'B','2018-12-14 00:23:14','2019-02-23 07:30:18','bingtuansishiqituan','兵团四十七团',NULL),(3692,'659009','兵团皮山农场','78.5171,37.563','street',3686,0,'B','2018-12-14 00:23:14','2019-02-23 07:30:18','bingtuanpishannongchang','兵团皮山农场',NULL),(3693,'659009','博斯坦乡','81.3298,36.4124','street',3686,0,'B','2018-12-14 00:23:14','2019-02-23 07:30:18','bositanxiang','博斯坦乡',NULL),(3694,'659009','喀拉喀什镇','79.7678,37.2867','street',3686,0,'K','2018-12-14 00:23:14','2019-02-23 07:30:18','kalakashizhen','喀拉喀什镇',NULL),(3695,'659009','奴尔乡','81.0072,36.2605','street',3686,0,'N','2018-12-14 00:23:14','2019-02-23 07:30:18','nuerxiang','奴尔乡',NULL),(3696,'659009','普恰克其乡','79.783,37.5805','street',3686,0,'P','2018-12-14 00:23:14','2019-02-23 07:30:18','puqiakeqixiang','普恰克其乡',NULL),(3697,'659009','阔依其乡','79.6876,37.3691','street',3686,0,'K','2018-12-14 00:23:14','2019-02-23 07:30:18','kuoyiqixiang','阔依其乡',NULL),(3698,'710000','台湾省','121.509062,25.044332','province',0,1,'T','2018-12-14 00:23:14','2019-02-23 07:30:18','taiwansheng','台湾省',NULL),(3699,'810000','香港特别行政区','114.173355,22.320048','province',0,3,'X','2018-12-14 00:23:14','2019-02-23 07:30:18','xianggangtebiexingzhengqu','香港特别行政区',NULL),(3700,'810001','中西区','114.154334,22.281931','district',3699,0,'Z','2018-12-14 00:23:14','2019-02-23 07:30:18','zhongxiqu','中西区',NULL),(3701,'810002','湾仔区','114.18299,22.276345','district',3699,0,'W','2018-12-14 00:23:14','2019-02-23 07:30:19','wanzaiqu','湾仔区',NULL),(3702,'810003','东区','114.225965,22.279779','district',3699,0,'D','2018-12-14 00:23:15','2019-02-23 07:30:19','dongqu','东区',NULL),(3703,'810004','南区','114.160023,22.245811','district',3699,0,'N','2018-12-14 00:23:15','2019-02-23 07:30:19','nanqu','南区',NULL),(3704,'810005','油尖旺区','114.173347,22.311632','district',3699,0,'Y','2018-12-14 00:23:15','2019-02-23 07:30:19','youjianwangqu','油尖旺区',NULL),(3705,'810006','深水埗区','114.163349,22.333775','district',3699,0,'S','2018-12-14 00:23:15','2019-02-23 07:30:19','shenshuibuqu','深水埗区',NULL),(3706,'810007','九龙城区','114.193047,22.312373','district',3699,0,'J','2018-12-14 00:23:15','2019-02-23 07:30:19','jiulongchengqu','九龙城区',NULL),(3707,'810008','黄大仙区','114.203985,22.336112','district',3699,0,'H','2018-12-14 00:23:15','2019-02-23 07:30:19','huangdaxianqu','黄大仙区',NULL),(3708,'810009','观塘区','114.214083,22.320679','district',3699,0,'G','2018-12-14 00:23:15','2019-02-23 07:30:19','guantangqu','观塘区',NULL),(3709,'810010','荃湾区','114.121234,22.368458','district',3699,0,'Q','2018-12-14 00:23:15','2019-02-23 07:30:19','quanwanqu','荃湾区',NULL),(3710,'810011','屯门区','113.976308,22.393896','district',3699,0,'T','2018-12-14 00:23:15','2019-02-23 07:30:19','tunmenqu','屯门区',NULL),(3711,'810012','元朗区','114.032528,22.44132','district',3699,0,'Y','2018-12-14 00:23:15','2019-02-23 07:30:19','yuanlangqu','元朗区',NULL),(3712,'810013','北区','114.147404,22.496143','district',3699,0,'B','2018-12-14 00:23:15','2019-02-23 07:30:19','beiqu','北区',NULL),(3713,'810014','大埔区','114.171713,22.44573','district',3699,0,'D','2018-12-14 00:23:15','2019-02-23 07:30:19','dabuqu','大埔区',NULL),(3714,'810015','西贡区','114.264813,22.314203','district',3699,0,'X','2018-12-14 00:23:15','2019-02-23 07:30:19','xigongqu','西贡区',NULL),(3715,'810016','沙田区','114.195126,22.379715','district',3699,0,'S','2018-12-14 00:23:15','2019-02-23 07:30:19','shatianqu','沙田区',NULL),(3716,'810017','葵青区','114.13918,22.363908','district',3699,0,'K','2018-12-14 00:23:15','2019-02-23 07:30:19','kuiqingqu','葵青区',NULL),(3717,'810018','离岛区','113.946059,22.286371','district',3699,0,'L','2018-12-14 00:23:16','2019-02-23 07:30:19','lidaoqu','离岛区',NULL),(3718,'820000','澳门特别行政区','113.54909,22.198951','province',0,2,'A','2018-12-14 00:23:16','2019-02-23 07:30:19','aomentebiexingzhengqu','澳门特别行政区',NULL),(3719,'820001','花地玛堂区','113.552965,22.207882','district',3718,0,'H','2018-12-14 00:23:16','2019-02-23 07:30:19','huadimatangqu','花地玛堂区',NULL),(3720,'820002','花王堂区','113.549052,22.199175','district',3718,0,'H','2018-12-14 00:23:16','2019-02-23 07:30:19','huawangtangqu','花王堂区',NULL),(3721,'820003','望德堂区','113.550252,22.193791','district',3718,0,'W','2018-12-14 00:23:16','2019-02-23 07:30:19','wangdetangqu','望德堂区',NULL),(3722,'820004','大堂区','113.55374,22.188119','district',3718,0,'D','2018-12-14 00:23:16','2019-02-23 07:30:19','datangqu','大堂区',NULL),(3723,'820005','风顺堂区','113.54167,22.187778','district',3718,0,'F','2018-12-14 00:23:16','2019-02-23 07:30:19','fengshuntangqu','风顺堂区',NULL),(3724,'820006','嘉模堂区','113.558783,22.154124','district',3718,0,'J','2018-12-14 00:23:16','2019-02-23 07:30:19','jiamotangqu','嘉模堂区',NULL),(3725,'820007','路凼填海区','113.56925,22.136546','district',3718,0,'L','2018-12-14 00:23:16','2019-02-23 07:30:19','ludangtianhaiqu','路凼填海区',NULL),(3726,'820008','圣方济各堂区','113.559954,22.124049','district',3718,0,'S','2018-12-14 00:23:16','2019-02-23 07:30:19','shengfangjigetangqu','圣方济各堂区',NULL);

#
# Structure for table "failed_jobs"
#

DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "failed_jobs"
#


#
# Structure for table "feedback_categories"
#

DROP TABLE IF EXISTS `feedback_categories`;
CREATE TABLE `feedback_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '分类名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "feedback_categories"
#


#
# Structure for table "feedback_replies"
#

DROP TABLE IF EXISTS `feedback_replies`;
CREATE TABLE `feedback_replies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `feedback_id` int(11) NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `user_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "feedback_replies"
#


#
# Structure for table "feedbacks"
#

DROP TABLE IF EXISTS `feedbacks`;
CREATE TABLE `feedbacks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL,
  `phone` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `feedback_category_id` int(11) NOT NULL DEFAULT '0' COMMENT '反馈分类id',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '反馈内容',
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '渠道码',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'true:已回复; false:待回复',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `type` tinyint(2) DEFAULT '1' COMMENT '反馈分类：1广告主，2媒体主',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "feedbacks"
#


#
# Structure for table "helps"
#

DROP TABLE IF EXISTS `helps`;
CREATE TABLE `helps` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '问题标题',
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '回答内容',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "helps"
#


#
# Structure for table "hot_cities"
#

DROP TABLE IF EXISTS `hot_cities`;
CREATE TABLE `hot_cities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `city_id` int(11) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "hot_cities"
#


#
# Structure for table "icons"
#

DROP TABLE IF EXISTS `icons`;
CREATE TABLE `icons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unicode` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'unicode 字符',
  `class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '类名',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=141 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "icons"
#

INSERT INTO `icons` VALUES (1,'&#xe6c9;','layui-icon-rate-half','半星',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(2,'&#xe67b;','layui-icon-rate','星星-空心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(3,'&#xe67a;','layui-icon-rate-solid','星星-实心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(4,'&#xe678;','layui-icon-cellphone','手机',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(5,'&#xe679;','layui-icon-vercode','验证码',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(6,'&#xe677;','layui-icon-login-wechat','微信',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(7,'&#xe676;','layui-icon-login-qq','QQ',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(8,'&#xe675;','layui-icon-login-weibo','微博',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(9,'&#xe673;','layui-icon-password','密码',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(10,'&#xe66f;','layui-icon-username','用户名',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(11,'&#xe9aa;','layui-icon-refresh-3','刷新-粗',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(12,'&#xe672;','layui-icon-auz','授权',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(13,'&#xe66b;','layui-icon-spread-left','左向右伸缩菜单',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(14,'&#xe668;','layui-icon-shrink-right','右向左伸缩菜单',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(15,'&#xe6b1;','layui-icon-snowflake','雪花',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(16,'&#xe702;','layui-icon-tips','提示说明',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(17,'&#xe66e;','layui-icon-note','便签',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(18,'&#xe68e;','layui-icon-home','主页',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(19,'&#xe674;','layui-icon-senior','高级',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(20,'&#xe669;','layui-icon-refresh','刷新',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(21,'&#xe666;','layui-icon-refresh-1','刷新',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(22,'&#xe66c;','layui-icon-flag','旗帜',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(23,'&#xe66a;','layui-icon-theme','主题',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(24,'&#xe667;','layui-icon-notice','消息-通知',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(25,'&#xe7ae;','layui-icon-website','网站',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(26,'&#xe665;','layui-icon-console','控制台',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(27,'&#xe664;','layui-icon-face-surprised','表情-惊讶',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(28,'&#xe716;','layui-icon-set','设置-空心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(29,'&#xe656;','layui-icon-template-1','模板',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(30,'&#xe653;','layui-icon-app','应用',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(31,'&#xe663;','layui-icon-template','模板',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(32,'&#xe6c6;','layui-icon-praise','赞',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(33,'&#xe6c5;','layui-icon-tread','踩',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(34,'&#xe662;','layui-icon-male','男',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(35,'&#xe661;','layui-icon-female','女',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(36,'&#xe660;','layui-icon-camera','相机-空心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(37,'&#xe65d;','layui-icon-camera-fill','相机-实心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(38,'&#xe65f;','layui-icon-more','菜单-水平',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(39,'&#xe671;','layui-icon-more-vertical','菜单-垂直',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(40,'&#xe65e;','layui-icon-rmb','金额-人民币',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(41,'&#xe659;','layui-icon-dollar','金额-美元',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(42,'&#xe735;','layui-icon-diamond','钻石-等级',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(43,'&#xe756;','layui-icon-fire','火',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(44,'&#xe65c;','layui-icon-return','返回',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(45,'&#xe715;','layui-icon-location','位置-地图',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(46,'&#xe705;','layui-icon-read','办公-阅读',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(47,'&#xe6b2;','layui-icon-survey','调查',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(48,'&#xe6af;','layui-icon-face-smile','表情-微笑',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(49,'&#xe69c;','layui-icon-face-cry','表情-哭泣',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(50,'&#xe698;','layui-icon-cart-simple','购物车',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(51,'&#xe657;','layui-icon-cart','购物车',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(52,'&#xe65b;','layui-icon-next','下一页',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(53,'&#xe65a;','layui-icon-prev','上一页',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(54,'&#xe681;','layui-icon-upload-drag','上传-空心-拖拽',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(55,'&#xe67c;','layui-icon-upload','上传-实心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(56,'&#xe601;','layui-icon-download-circle','下载-圆圈',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(57,'&#xe857;','layui-icon-component','组件',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(58,'&#xe655;','layui-icon-file-b','文件-粗',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(59,'&#xe770;','layui-icon-user','用户',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(60,'&#xe670;','layui-icon-find-fill','发现-实心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(61,'&#xe63d;','layui-icon-loading','loading',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(62,'&#xe63e;','layui-icon-loading-1','loading',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(63,'&#xe654;','layui-icon-add-1','添加',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(64,'&#xe652;','layui-icon-play','播放',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(65,'&#xe651;','layui-icon-pause','暂停',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(66,'&#xe6fc;','layui-icon-headset','音频-耳机',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(67,'&#xe6ed;','layui-icon-video','视频',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(68,'&#xe688;','layui-icon-voice','语音-声音',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(69,'&#xe645;','layui-icon-speaker','消息-通知-喇叭',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(70,'&#xe64f;','layui-icon-fonts-del','删除线',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(71,'&#xe64e;','layui-icon-fonts-code','代码',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(72,'&#xe64b;','layui-icon-fonts-html','HTML',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(73,'&#xe62b;','layui-icon-fonts-strong','字体加粗',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(74,'&#xe64d;','layui-icon-unlink','删除链接',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(75,'&#xe64a;','layui-icon-picture','图片',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(76,'&#xe64c;','layui-icon-link','链接',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(77,'&#xe650;','layui-icon-face-smile-b','表情-笑-粗',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(78,'&#xe649;','layui-icon-align-left','左对齐',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(79,'&#xe648;','layui-icon-align-right','右对齐',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(80,'&#xe647;','layui-icon-align-center','居中对齐',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(81,'&#xe646;','layui-icon-fonts-u','字体-下划线',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(82,'&#xe644;','layui-icon-fonts-i','字体-斜体',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(83,'&#xe62a;','layui-icon-tabs','Tabs 选项卡',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(84,'&#xe643;','layui-icon-radio','单选框-选中',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(85,'&#xe63f;','layui-icon-circle','单选框-候选',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(86,'&#xe642;','layui-icon-edit','编辑',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(87,'&#xe641;','layui-icon-share','分享',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(88,'&#xe640;','layui-icon-delete','删除',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(89,'&#xe63c;','layui-icon-form','表单',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(90,'&#xe63b;','layui-icon-cellphone-fine','手机-细体',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(91,'&#xe63a;','layui-icon-dialogue','聊天 对话 沟通',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(92,'&#xe639;','layui-icon-fonts-clear','文字格式化',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(93,'&#xe638;','layui-icon-layer','窗口',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(94,'&#xe637;','layui-icon-date','日期',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(95,'&#xe636;','layui-icon-water','水 下雨',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(96,'&#xe635;','layui-icon-code-circle','代码-圆圈',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(97,'&#xe634;','layui-icon-carousel','轮播组图',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(98,'&#xe633;','layui-icon-prev-circle','翻页',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(99,'&#xe632;','layui-icon-layouts','布局',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(100,'&#xe631;','layui-icon-util','工具',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(101,'&#xe630;','layui-icon-templeate-1','选择模板',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(102,'&#xe62f;','layui-icon-upload-circle','上传-圆圈',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(103,'&#xe62e;','layui-icon-tree','树',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(104,'&#xe62d;','layui-icon-table','表格',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(105,'&#xe62c;','layui-icon-chart','图表',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(106,'&#xe629;','layui-icon-chart-screen','图标 报表 屏幕',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(107,'&#xe628;','layui-icon-engine','引擎',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(108,'&#xe625;','layui-icon-triangle-d','下三角',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(109,'&#xe623;','layui-icon-triangle-r','右三角',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(110,'&#xe621;','layui-icon-file','文件',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(111,'&#xe620;','layui-icon-set-sm','设置-小型',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(112,'&#xe61f;','layui-icon-add-circle','添加-圆圈',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(113,'&#xe61c;','layui-icon-404','404',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(114,'&#xe60b;','layui-icon-about','关于',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(115,'&#xe619;','layui-icon-up','箭头 向上',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(116,'&#xe61a;','layui-icon-down','箭头 向下',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(117,'&#xe603;','layui-icon-left','箭头 向左',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(118,'&#xe602;','layui-icon-right','箭头 向右',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(119,'&#xe617;','layui-icon-circle-dot','圆点',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(120,'&#xe615;','layui-icon-search','搜索',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(121,'&#xe614;','layui-icon-set-fill','设置-实心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(122,'&#xe613;','layui-icon-group','群组',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(123,'&#xe612;','layui-icon-friends','好友',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(124,'&#xe611;','layui-icon-reply-fill','回复 评论 实心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(125,'&#xe60f;','layui-icon-menu-fill','菜单 隐身 实心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(126,'&#xe60e;','layui-icon-log','记录',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(127,'&#xe60d;','layui-icon-picture-fine','图片-细体',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(128,'&#xe60c;','layui-icon-face-smile-fine','表情-笑-细体',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(129,'&#xe60a;','layui-icon-list','列表',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(130,'&#xe609;','layui-icon-release','发布 纸飞机',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(131,'&#xe605;','layui-icon-ok','对 OK',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(132,'&#xe607;','layui-icon-help','帮助',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(133,'&#xe606;','layui-icon-chat','客服',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(134,'&#xe604;','layui-icon-top','top 置顶',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(135,'&#xe600;','layui-icon-star','收藏-空心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(136,'&#xe658;','layui-icon-star-fill','收藏-实心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(137,'&#x1007;','layui-icon-close-fill','关闭-实心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(138,'&#x1006;','layui-icon-close','关闭-空心',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(139,'&#x1005;','layui-icon-ok-circle','正确',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(140,'&#xe608;','layui-icon-add-circle-fine','添加-圆圈-细体',0,'2019-03-19 06:19:13','2019-03-19 06:19:13');

#
# Structure for table "images"
#

DROP TABLE IF EXISTS `images`;
CREATE TABLE `images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('startup','guide','alert','banner','pcbanner') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '图片类型',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '图片地址',
  `redirect_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '点击图片跳转地址',
  `redirect_type` enum('inside','outside') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '点击图片跳转类型:内链外链',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态:0=>停用,1=>启用',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "images"
#


#
# Structure for table "member_charges"
#

DROP TABLE IF EXISTS `member_charges`;
CREATE TABLE `member_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL,
  `charge_no` varchar(255) DEFAULT NULL COMMENT '充值订单号',
  `money` decimal(10,2) NOT NULL,
  `status` tinyint(2) DEFAULT '0' COMMENT '支付状态：0未支付，1已支付',
  `pay_type` varchar(20) NOT NULL,
  `pay_at` timestamp NULL DEFAULT NULL COMMENT '支付时间',
  `mark` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `pay_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "member_charges"
#


#
# Structure for table "member_files"
#

DROP TABLE IF EXISTS `member_files`;
CREATE TABLE `member_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) DEFAULT NULL,
  `type_id` int(11) DEFAULT NULL COMMENT '素材分类ID',
  `path` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1' COMMENT '0,1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `type` tinyint(1) DEFAULT '1' COMMENT '1：附件2：自定义编辑内容',
  `content` text COMMENT '自定义编辑内容',
  `mark` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "member_files"
#


#
# Structure for table "member_has_levels"
#

DROP TABLE IF EXISTS `member_has_levels`;
CREATE TABLE `member_has_levels` (
  `member_id` int(11) NOT NULL,
  `level_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "member_has_levels"
#


#
# Structure for table "member_infos"
#

DROP TABLE IF EXISTS `member_infos`;
CREATE TABLE `member_infos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `mid` int(11) DEFAULT NULL,
  `qq` varchar(50) DEFAULT NULL,
  `pay_pass` varchar(255) DEFAULT NULL COMMENT '支付密码',
  `phone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `email` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `alipay_name` varchar(255) DEFAULT NULL COMMENT '支付宝姓名',
  `alipay_account` varchar(255) DEFAULT NULL COMMENT '支付宝账号',
  `alipay_phone` varchar(20) DEFAULT NULL COMMENT '支付宝绑定手机',
  `industry` varchar(255) DEFAULT NULL COMMENT '行业',
  `promote` varchar(255) DEFAULT NULL COMMENT '推广内容',
  `need` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

#
# Data for table "member_infos"
#

INSERT INTO `member_infos` VALUES (1,'123455','',1,'123455',NULL,NULL,'123@123.com','2019-05-08 13:04:56','2019-05-08 13:04:56',NULL,NULL,NULL,'','','');

#
# Structure for table "member_level_logs"
#

DROP TABLE IF EXISTS `member_level_logs`;
CREATE TABLE `member_level_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL,
  `mark` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `charge_no` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "member_level_logs"
#


#
# Structure for table "member_levels"
#

DROP TABLE IF EXISTS `member_levels`;
CREATE TABLE `member_levels` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL COMMENT '等级名称',
  `limit` decimal(10,2) DEFAULT '0.00' COMMENT '最低限制',
  `status` tinyint(2) unsigned DEFAULT '1' COMMENT '启用状态：1启用，0停用',
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `sale` int(10) DEFAULT NULL COMMENT '优惠比例%',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "member_levels"
#


#
# Structure for table "member_logs"
#

DROP TABLE IF EXISTS `member_logs`;
CREATE TABLE `member_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '设备码',
  `user_agent` text COLLATE utf8mb4_unicode_ci COMMENT '浏览器UA',
  `ip` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'ip地址',
  `method` enum('GET','POST','PUT','PATCH') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ip地址',
  `route` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '请求路由',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '请求参数',
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '渠道码',
  `platform` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '平台',
  `page_id` int(11) NOT NULL DEFAULT '0' COMMENT '分发页id',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "member_logs"
#


#
# Structure for table "member_money_records"
#

DROP TABLE IF EXISTS `member_money_records`;
CREATE TABLE `member_money_records` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL,
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '交易金额',
  `type` tinyint(2) unsigned DEFAULT '1' COMMENT '类型：',
  `total_money` decimal(10,2) DEFAULT '0.00',
  `mark` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `freeze_money` decimal(10,2) DEFAULT '0.00' COMMENT '冻结金额',
  `order_id` int(11) unsigned DEFAULT '0' COMMENT '订单id：用户下单时保存',
  `pay_id` int(11) DEFAULT '0' COMMENT '支付记录：充值时保存',
  `uid` int(11) unsigned DEFAULT NULL COMMENT '管理员id',
  `cash_id` int(11) DEFAULT NULL COMMENT '提现ID',
  `refund_id` int(11) DEFAULT NULL COMMENT '退款ID',
  `order_no` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "member_money_records"
#


#
# Structure for table "member_tokens"
#

DROP TABLE IF EXISTS `member_tokens`;
CREATE TABLE `member_tokens` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `identifier` varchar(255) NOT NULL COMMENT '设备码',
  `key_identifier` varchar(255) NOT NULL COMMENT '验证关键字',
  `member_token` varchar(255) NOT NULL COMMENT '用户token',
  `expire_at` timestamp NULL DEFAULT NULL COMMENT '失效时间',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "member_tokens"
#


#
# Structure for table "members"
#

DROP TABLE IF EXISTS `members`;
CREATE TABLE `members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `application_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用id',
  `app_id` int(11) NOT NULL DEFAULT '0' COMMENT 'app id',
  `phone` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '手机',
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '密码',
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'uuid',
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '头像',
  `platform_register` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform_login` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL,
  `identifier_register` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '注册时的设备码',
  `identifier_login` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '最后登陆的设备码',
  `identifier_push` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '推送所用的设备码',
  `login_count` int(11) NOT NULL DEFAULT '0' COMMENT '登陆次数',
  `channel_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(11) NOT NULL DEFAULT '0',
  `credit_id` int(11) DEFAULT NULL COMMENT '信用卡id,预留',
  `page_id` int(11) NOT NULL DEFAULT '0' COMMENT '通过分发页完成注册时的分发页id',
  `reduce_type` enum('register','apply_register') COLLATE utf8mb4_unicode_ci NOT NULL,
  `reduce_rate` int(11) NOT NULL DEFAULT '100' COMMENT '注册扣量或申请注册扣量值',
  `last_apply_at` datetime DEFAULT NULL COMMENT '最后申请时间',
  `nick` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '昵称',
  `remember_token` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '记住我',
  `register_ip` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '注册ip',
  `last_login_ip` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '最后登陆ip',
  `last_login_at` datetime NOT NULL COMMENT '最后登陆时间',
  `package` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '包名',
  `system_version` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '系统版本',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(3) DEFAULT '1' COMMENT '状态：1正常2冻结0禁用',
  `type` tinyint(1) DEFAULT '1' COMMENT '1广告主2媒体主',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "members"
#

INSERT INTO `members` VALUES (1,0,0,'13012345678','$2y$10$sXQ2d6.Dc8J8hjYvVXWrGe1o3o6dLTGjQl2lWTrHw/ma7oXYroFJO',NULL,NULL,'android','android','','','',0,'1',0,NULL,0,'register',100,NULL,NULL,NULL,'','','1899-12-30 01:00:00','',NULL,NULL,NULL,1,1);

#
# Structure for table "message_appends"
#

DROP TABLE IF EXISTS `message_appends`;
CREATE TABLE `message_appends` (
  `message_id` int(11) NOT NULL,
  `phone` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '追加的手机号',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '类型:1=>textarea,2=>excel'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "message_appends"
#


#
# Structure for table "message_applications"
#

DROP TABLE IF EXISTS `message_applications`;
CREATE TABLE `message_applications` (
  `message_id` int(11) NOT NULL DEFAULT '0' COMMENT '消息id',
  `application_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "message_applications"
#


#
# Structure for table "message_devices"
#

DROP TABLE IF EXISTS `message_devices`;
CREATE TABLE `message_devices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_id` int(11) NOT NULL DEFAULT '0' COMMENT '消息id',
  `device_id` int(11) NOT NULL DEFAULT '0' COMMENT '设备主键id',
  `is_reached` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否到达:0=>否,1=>是',
  `is_clicked` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否点击:0=>否,1=>是',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "message_devices"
#


#
# Structure for table "message_guests"
#

DROP TABLE IF EXISTS `message_guests`;
CREATE TABLE `message_guests` (
  `message_id` int(11) NOT NULL,
  `guest_id` tinyint(4) NOT NULL DEFAULT '0' COMMENT '游客id,即排除有注册用户的设备的id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "message_guests"
#


#
# Structure for table "message_members"
#

DROP TABLE IF EXISTS `message_members`;
CREATE TABLE `message_members` (
  `message_id` int(11) NOT NULL,
  `mid` tinyint(4) NOT NULL DEFAULT '0' COMMENT '用户id',
  `numbers` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '自定义号码'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "message_members"
#


#
# Structure for table "message_user_models"
#

DROP TABLE IF EXISTS `message_user_models`;
CREATE TABLE `message_user_models` (
  `message_id` int(11) NOT NULL,
  `user_model_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "message_user_models"
#


#
# Structure for table "messages"
#

DROP TABLE IF EXISTS `messages`;
CREATE TABLE `messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('push','system') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '消息类型',
  `title` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '标题',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '推送内容',
  `send_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '发送类型:1=>即时发送,2=>定时发送',
  `fixed_at` datetime DEFAULT NULL COMMENT '定时时间,仅send_type=2时有值',
  `send_object` tinyint(4) NOT NULL DEFAULT '0' COMMENT '发送对象:',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '发送状态:0=>未发送,1=>已发送',
  `redirect_model` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '跳转页面类型',
  `redirect_model_detail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `counts` int(11) DEFAULT NULL COMMENT '预计人数：为创建时间的用户模型人数',
  `send_at` datetime DEFAULT NULL COMMENT '执行时间',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "messages"
#


#
# Structure for table "migrations"
#

DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "migrations"
#


#
# Structure for table "operate_logs"
#

DROP TABLE IF EXISTS `operate_logs`;
CREATE TABLE `operate_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `path` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method` enum('GET','POST','PUT','DELETE') COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `input` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=154 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "operate_logs"
#

INSERT INTO `operate_logs` VALUES (1,1,'login','GET','127.0.0.1','[]','2019-05-08 13:05:15','2019-05-08 13:05:15',NULL),(2,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 13:05:15','2019-05-08 13:05:15',NULL),(3,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 13:05:16','2019-05-08 13:05:16',NULL),(4,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 13:05:29','2019-05-08 13:05:29',NULL),(5,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 13:05:29','2019-05-08 13:05:29',NULL),(6,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 13:06:30','2019-05-08 13:06:30',NULL),(7,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 13:06:30','2019-05-08 13:06:30',NULL),(8,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:53:03','2019-05-08 13:53:03',NULL),(9,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:53:04','2019-05-08 13:53:04',NULL),(10,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:53:09','2019-05-08 13:53:09',NULL),(11,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:53:09','2019-05-08 13:53:09',NULL),(12,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 13:53:11','2019-05-08 13:53:11',NULL),(13,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 13:53:11','2019-05-08 13:53:11',NULL),(14,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 13:53:13','2019-05-08 13:53:13',NULL),(15,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:53:18','2019-05-08 13:53:18',NULL),(16,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:53:18','2019-05-08 13:53:18',NULL),(17,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:53:45','2019-05-08 13:53:45',NULL),(18,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:53:46','2019-05-08 13:53:46',NULL),(19,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 13:53:51','2019-05-08 13:53:51',NULL),(20,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 13:53:52','2019-05-08 13:53:52',NULL),(21,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:53:56','2019-05-08 13:53:56',NULL),(22,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:53:56','2019-05-08 13:53:56',NULL),(23,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 13:58:18','2019-05-08 13:58:18',NULL),(24,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 13:58:18','2019-05-08 13:58:18',NULL),(25,1,'admin/product/batch','GET','127.0.0.1','[]','2019-05-08 13:58:25','2019-05-08 13:58:25',NULL),(26,1,'admin/product/batch/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:58:26','2019-05-08 13:58:26',NULL),(27,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:54:11','2019-05-08 13:54:11',NULL),(28,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:54:11','2019-05-08 13:54:11',NULL),(29,1,'admin/pay','GET','127.0.0.1','[]','2019-05-08 13:58:31','2019-05-08 13:58:31',NULL),(30,1,'admin/pay/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:58:32','2019-05-08 13:58:32',NULL),(31,1,'admin/pay/1/edit','GET','127.0.0.1','[]','2019-05-08 13:58:35','2019-05-08 13:58:35',NULL),(32,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:54:21','2019-05-08 13:54:21',NULL),(33,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:54:22','2019-05-08 13:54:22',NULL),(34,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:54:52','2019-05-08 13:54:52',NULL),(35,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:54:52','2019-05-08 13:54:52',NULL),(36,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:55:04','2019-05-08 13:55:04',NULL),(37,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:55:04','2019-05-08 13:55:04',NULL),(38,1,'admin/product/batch','GET','127.0.0.1','[]','2019-05-08 13:59:29','2019-05-08 13:59:29',NULL),(39,1,'admin/product/batch/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:59:29','2019-05-08 13:59:29',NULL),(40,1,'admin/product/set/price/store','GET','127.0.0.1','[]','2019-05-08 13:59:30','2019-05-08 13:59:30',NULL),(41,1,'admin/sms','GET','127.0.0.1','[]','2019-05-08 13:59:34','2019-05-08 13:59:34',NULL),(42,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:55:17','2019-05-08 13:55:17',NULL),(43,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:55:17','2019-05-08 13:55:17',NULL),(44,1,'admin/sms/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:59:34','2019-05-08 13:59:34',NULL),(45,1,'admin/sms/recharge','GET','127.0.0.1','[]','2019-05-08 13:59:36','2019-05-08 13:59:36',NULL),(46,1,'admin/sms/recharge/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:59:36','2019-05-08 13:59:36',NULL),(47,1,'admin/sms/template','GET','127.0.0.1','[]','2019-05-08 13:59:37','2019-05-08 13:59:37',NULL),(48,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 13:55:27','2019-05-08 13:55:27',NULL),(49,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 13:55:27','2019-05-08 13:55:27',NULL),(50,1,'admin/pay','GET','127.0.0.1','[]','2019-05-08 13:59:54','2019-05-08 13:59:54',NULL),(51,1,'admin/pay/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:59:55','2019-05-08 13:59:55',NULL),(52,1,'admin/account','GET','127.0.0.1','[]','2019-05-08 13:59:57','2019-05-08 13:59:57',NULL),(53,1,'admin/account/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:59:57','2019-05-08 13:59:57',NULL),(54,1,'admin/refund','GET','127.0.0.1','[]','2019-05-08 13:59:58','2019-05-08 13:59:58',NULL),(55,1,'admin/refund/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:59:59','2019-05-08 13:59:59',NULL),(56,1,'admin/pay/1/edit','GET','127.0.0.1','[]','2019-05-08 14:00:01','2019-05-08 14:00:01',NULL),(57,1,'admin/pay','GET','127.0.0.1','[]','2019-05-08 14:00:10','2019-05-08 14:00:10',NULL),(58,1,'admin/pay/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 14:00:10','2019-05-08 14:00:10',NULL),(59,1,'admin/pay/2/edit','GET','127.0.0.1','[]','2019-05-08 14:00:12','2019-05-08 14:00:12',NULL),(60,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 13:56:09','2019-05-08 13:56:09',NULL),(61,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:56:12','2019-05-08 13:56:12',NULL),(62,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:56:12','2019-05-08 13:56:12',NULL),(63,1,'admin/work/single','GET','127.0.0.1','[]','2019-05-08 13:56:24','2019-05-08 13:56:24',NULL),(64,1,'admin/work/single/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 13:56:24','2019-05-08 13:56:24',NULL),(65,1,'admin/pay','GET','127.0.0.1','[]','2019-05-08 14:01:11','2019-05-08 14:01:11',NULL),(66,1,'admin/pay/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 14:01:12','2019-05-08 14:01:12',NULL),(67,1,'admin/pay/1/edit','GET','127.0.0.1','[]','2019-05-08 14:01:13','2019-05-08 14:01:13',NULL),(68,1,'admin/pay','GET','127.0.0.1','[]','2019-05-08 14:02:30','2019-05-08 14:02:30',NULL),(69,1,'admin/pay/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 14:02:30','2019-05-08 14:02:30',NULL),(70,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 14:04:26','2019-05-08 14:04:26',NULL),(71,1,'admin/pay','GET','127.0.0.1','[]','2019-05-08 14:04:28','2019-05-08 14:04:28',NULL),(72,1,'admin/pay/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 14:04:29','2019-05-08 14:04:29',NULL),(73,1,'admin/website','GET','127.0.0.1','[]','2019-05-08 14:04:46','2019-05-08 14:04:46',NULL),(74,1,'admin/page','GET','127.0.0.1','[]','2019-05-08 14:05:18','2019-05-08 14:05:18',NULL),(75,1,'admin/page/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\",\"model\":\"role\"}','2019-05-08 14:05:19','2019-05-08 14:05:19',NULL),(76,1,'admin/website','GET','127.0.0.1','[]','2019-05-08 14:05:27','2019-05-08 14:05:27',NULL),(77,1,'uploadImage','POST','127.0.0.1','{\"_token\":\"zmYC7TxxsAMu04kltS6Z8StnfVimEzEIzL4qvoVI\",\"maxSize\":\"1\",\"filename\":\"weixin\",\"file\":{}}','2019-05-08 14:06:20','2019-05-08 14:06:20',NULL),(78,1,'admin/website/update','PUT','127.0.0.1','{\"_token\":\"zmYC7TxxsAMu04kltS6Z8StnfVimEzEIzL4qvoVI\",\"_method\":\"put\",\"company_name\":\"oem\",\"phone\":\"028 8888 8888\",\"record_num\":\"****\",\"base_loan\":\"1\",\"base_today_loan\":\"1\",\"keywords\":\"1\",\"introduce\":\"1\",\"qrcode_weixin\":\"\\/images\\/file\\/dfMdWdetyI36LnQMGBixIuz0yIGkR68tlUzdl1Jx.png\"}','2019-05-08 14:06:21','2019-05-08 14:06:21',NULL),(79,1,'admin/website','GET','127.0.0.1','[]','2019-05-08 14:06:22','2019-05-08 14:06:22',NULL),(80,1,'uploadImage','POST','127.0.0.1','{\"_token\":\"zmYC7TxxsAMu04kltS6Z8StnfVimEzEIzL4qvoVI\",\"maxSize\":\"1\",\"filename\":\"weixin\",\"file\":{}}','2019-05-08 14:07:02','2019-05-08 14:07:02',NULL),(81,1,'admin/website/update','PUT','127.0.0.1','{\"_token\":\"zmYC7TxxsAMu04kltS6Z8StnfVimEzEIzL4qvoVI\",\"_method\":\"put\",\"company_name\":\"oem\",\"phone\":\"028 8888 8888\",\"record_num\":\"****\",\"base_loan\":\"1\",\"base_today_loan\":\"1\",\"keywords\":\"1\",\"introduce\":\"1\",\"qrcode_weixin\":\"\\/images\\/file\\/CScUCPNWLCNiUF9WToYJP93RRgLe5YYVEljBPjtz.png\"}','2019-05-08 14:07:03','2019-05-08 14:07:03',NULL),(82,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 14:07:15','2019-05-08 14:07:15',NULL),(83,1,'admin/setting/manager','GET','127.0.0.1','[]','2019-05-08 14:07:16','2019-05-08 14:07:16',NULL),(84,1,'admin/setting/manager/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 14:07:17','2019-05-08 14:07:17',NULL),(85,1,'admin/website','GET','127.0.0.1','[]','2019-05-08 14:07:17','2019-05-08 14:07:17',NULL),(86,1,'admin/website','GET','127.0.0.1','[]','2019-05-08 14:07:31','2019-05-08 14:07:31',NULL),(87,1,'admin/pay','GET','127.0.0.1','[]','2019-05-08 14:07:50','2019-05-08 14:07:50',NULL),(88,1,'admin/pay/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 14:07:51','2019-05-08 14:07:51',NULL),(89,1,'admin/pay/1/edit','GET','127.0.0.1','[]','2019-05-08 14:07:53','2019-05-08 14:07:53',NULL),(90,1,'admin/pay/1/edit','GET','127.0.0.1','[]','2019-05-08 14:08:03','2019-05-08 14:08:03',NULL),(91,1,'admin/pay/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 14:08:05','2019-05-08 14:08:05',NULL),(92,1,'admin/pay/1/edit','GET','127.0.0.1','[]','2019-05-08 14:08:07','2019-05-08 14:08:07',NULL),(93,1,'admin/pay','GET','127.0.0.1','[]','2019-05-08 14:08:11','2019-05-08 14:08:11',NULL),(94,1,'admin/pay/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 14:08:12','2019-05-08 14:08:12',NULL),(95,1,'admin/pay/2/edit','GET','127.0.0.1','[]','2019-05-08 14:08:13','2019-05-08 14:08:13',NULL),(96,0,'login','GET','127.0.0.1','[]','2019-05-08 14:12:14','2019-05-08 14:12:14',NULL),(97,0,'login','GET','127.0.0.1','[]','2019-05-08 14:16:21','2019-05-08 14:16:21',NULL),(98,0,'login','POST','127.0.0.1','{\"_token\":\"spDH3tA5t1VYJb5hhR6qeXy0XpCoJeXovGWuyOHv\",\"username\":\"admin\",\"password\":\"123456\",\"captcha\":\"q4cz\"}','2019-05-08 14:16:51','2019-05-08 14:16:51',NULL),(99,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 14:16:52','2019-05-08 14:16:52',NULL),(100,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 14:16:52','2019-05-08 14:16:52',NULL),(101,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 14:17:07','2019-05-08 14:17:07',NULL),(102,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 14:17:08','2019-05-08 14:17:08',NULL),(103,1,'admin/sms','GET','127.0.0.1','[]','2019-05-08 14:17:11','2019-05-08 14:17:11',NULL),(104,1,'admin/sms/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 14:17:11','2019-05-08 14:17:11',NULL),(105,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 16:09:29','2019-05-08 16:09:29',NULL),(106,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 16:09:29','2019-05-08 16:09:29',NULL),(107,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 16:11:28','2019-05-08 16:11:28',NULL),(108,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 16:11:28','2019-05-08 16:11:28',NULL),(109,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 16:15:00','2019-05-08 16:15:00',NULL),(110,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 16:15:00','2019-05-08 16:15:00',NULL),(111,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 16:16:54','2019-05-08 16:16:54',NULL),(112,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 16:16:54','2019-05-08 16:16:54',NULL),(113,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 16:18:08','2019-05-08 16:18:08',NULL),(114,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 16:18:08','2019-05-08 16:18:08',NULL),(115,1,'admin/cash','GET','127.0.0.1','[]','2019-05-08 16:19:56','2019-05-08 16:19:56',NULL),(116,1,'admin/cash/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 16:19:56','2019-05-08 16:19:56',NULL),(117,1,'admin/pay','GET','127.0.0.1','[]','2019-05-08 16:19:57','2019-05-08 16:19:57',NULL),(118,1,'admin/pay/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 16:19:57','2019-05-08 16:19:57',NULL),(119,1,'admin/account','GET','127.0.0.1','[]','2019-05-08 16:19:58','2019-05-08 16:19:58',NULL),(120,1,'admin/account/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 16:19:59','2019-05-08 16:19:59',NULL),(121,1,'admin/refund','GET','127.0.0.1','[]','2019-05-08 16:20:00','2019-05-08 16:20:00',NULL),(122,1,'admin/refund/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 16:20:00','2019-05-08 16:20:00',NULL),(123,1,'admin/cash/rate','GET','127.0.0.1','[]','2019-05-08 16:20:01','2019-05-08 16:20:01',NULL),(124,1,'admin/cash/rate/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 16:20:02','2019-05-08 16:20:02',NULL),(125,1,'admin/cloud/cash','GET','127.0.0.1','[]','2019-05-08 16:20:03','2019-05-08 16:20:03',NULL),(126,1,'admin/cloud/cash/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 16:20:04','2019-05-08 16:20:04',NULL),(127,1,'admin/website','GET','127.0.0.1','[]','2019-05-08 16:20:09','2019-05-08 16:20:09',NULL),(128,1,'admin/website/image','GET','127.0.0.1','[]','2019-05-08 16:20:11','2019-05-08 16:20:11',NULL),(129,1,'admin/website/image/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\",\"model\":\"image\"}','2019-05-08 16:20:11','2019-05-08 16:20:11',NULL),(130,1,'admin/setting/manager','GET','127.0.0.1','[]','2019-05-08 16:20:12','2019-05-08 16:20:12',NULL),(131,1,'admin/setting/manager/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 16:20:13','2019-05-08 16:20:13',NULL),(132,1,'admin/user','GET','127.0.0.1','[]','2019-05-08 16:20:16','2019-05-08 16:20:16',NULL),(133,1,'admin/role','GET','127.0.0.1','[]','2019-05-08 16:20:18','2019-05-08 16:20:18',NULL),(134,1,'admin/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\",\"model\":\"role\"}','2019-05-08 16:20:18','2019-05-08 16:20:18',NULL),(135,1,'admin/permission','GET','127.0.0.1','[]','2019-05-08 16:20:19','2019-05-08 16:20:19',NULL),(136,1,'admin/page','GET','127.0.0.1','[]','2019-05-08 16:20:24','2019-05-08 16:20:24',NULL),(137,1,'admin/page/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\",\"model\":\"role\"}','2019-05-08 16:20:25','2019-05-08 16:20:25',NULL),(138,1,'admin/district','GET','127.0.0.1','[]','2019-05-08 16:20:26','2019-05-08 16:20:26',NULL),(139,1,'admin/district/data','GET','127.0.0.1','{\"parent_id\":\"0\",\"level\":null,\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 16:20:27','2019-05-08 16:20:27',NULL),(140,1,'admin/home','GET','127.0.0.1','[]','2019-05-08 16:20:47','2019-05-08 16:20:47',NULL),(141,1,'admin/index','GET','127.0.0.1','[]','2019-05-08 16:20:47','2019-05-08 16:20:47',NULL),(142,1,'admin/page','GET','127.0.0.1','[]','2019-05-08 16:20:49','2019-05-08 16:20:49',NULL),(143,1,'admin/page/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\",\"model\":\"role\"}','2019-05-08 16:20:50','2019-05-08 16:20:50',NULL),(144,1,'admin/sms','GET','127.0.0.1','[]','2019-05-08 16:20:53','2019-05-08 16:20:53',NULL),(145,1,'admin/sms/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 16:20:53','2019-05-08 16:20:53',NULL),(146,1,'admin/sms/recharge','GET','127.0.0.1','[]','2019-05-08 16:20:54','2019-05-08 16:20:54',NULL),(147,1,'admin/sms/recharge/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 16:20:55','2019-05-08 16:20:55',NULL),(148,1,'admin/sms/template','GET','127.0.0.1','[]','2019-05-08 16:20:55','2019-05-08 16:20:55',NULL),(149,1,'admin/page','GET','127.0.0.1','[]','2019-05-08 16:21:00','2019-05-08 16:21:00',NULL),(150,1,'admin/page/data','GET','127.0.0.1','{\"page\":\"1\",\"limit\":\"10\",\"model\":\"role\"}','2019-05-08 16:21:01','2019-05-08 16:21:01',NULL),(151,1,'admin/page/1/edit','GET','127.0.0.1','[]','2019-05-08 16:21:02','2019-05-08 16:21:02',NULL),(152,1,'admin/district','GET','127.0.0.1','[]','2019-05-08 16:21:27','2019-05-08 16:21:27',NULL),(153,1,'admin/district/data','GET','127.0.0.1','{\"parent_id\":\"0\",\"level\":null,\"page\":\"1\",\"limit\":\"10\"}','2019-05-08 16:21:28','2019-05-08 16:21:28',NULL);

#
# Structure for table "order_actives"
#

DROP TABLE IF EXISTS `order_actives`;
CREATE TABLE `order_actives` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `source_type` varchar(255) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `upload` varchar(255) DEFAULT NULL,
  `action_type` varchar(255) DEFAULT NULL,
  `start_time` timestamp NULL DEFAULT NULL,
  `end_time` timestamp NULL DEFAULT NULL,
  `mark` text COMMENT '备注',
  `type` varchar(255) DEFAULT NULL COMMENT '资源类型',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `file_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单活动信息';

#
# Data for table "order_actives"
#


#
# Structure for table "order_pay_logs"
#

DROP TABLE IF EXISTS `order_pay_logs`;
CREATE TABLE `order_pay_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_pay_logs` varchar(255) DEFAULT NULL COMMENT '支付订单号',
  `pay_way` varchar(255) DEFAULT NULL COMMENT 'wx|zfb',
  `order_no` varchar(255) DEFAULT NULL COMMENT '关联订单号',
  `site` varchar(255) DEFAULT NULL COMMENT '站点信息',
  `userinfo` varchar(255) DEFAULT NULL COMMENT '支付人信息',
  `uid` int(11) DEFAULT NULL COMMENT '付款人id',
  `touid` int(11) DEFAULT NULL COMMENT '收款人',
  `title` varchar(255) DEFAULT NULL COMMENT '商品信息',
  `url` varchar(255) DEFAULT NULL COMMENT '商品地址',
  `money` decimal(10,2) DEFAULT NULL COMMENT '需支付金额',
  `pay_money` decimal(10,2) DEFAULT NULL COMMENT '支付金额',
  `status` tinyint(1) DEFAULT '0' COMMENT '支付状态',
  `result` text COMMENT '服务商返回信息',
  `pay_time` datetime DEFAULT NULL COMMENT '支付时间',
  `created_at` datetime DEFAULT NULL COMMENT '创建时间',
  `updated_at` datetime DEFAULT NULL,
  `recharge_type` tinyint(1) DEFAULT '2' COMMENT '1充值:recharge|2订单：order',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='支付信息';

#
# Data for table "order_pay_logs"
#


#
# Structure for table "pages"
#

DROP TABLE IF EXISTS `pages`;
CREATE TABLE `pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '管理员id',
  `slug` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '页面标识',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '标题',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '正文',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "pages"
#

INSERT INTO `pages` VALUES (1,0,'reg','用户注册协议','<p style=\"margin-left: 0;text-indent: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">尊敬的用户，欢迎注册成为平台用户。在注册前请仔细阅读如下服务条款：</span></span></strong></p><p style=\"margin-left: 0;text-indent: 0;line-height: 20px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><span style=\"font-family:微软雅黑\">依据本协议的规定提供服务，本协议具有合同效力。用户必须完全同意本协议，才能够享受本平台提供的服务。用户在注册成功即表示用户完全接受本协议的全部条款。注册用户时请用户认真阅读本服务协议，用户可以选择</span>“接受”或“拒绝”本服务协议（未成年人应在法定监护人陪同下审阅）。用户只有在接受本服务协议的情况下，才有权使用平台提供的相关服务。用户的实际使用行为将视为对本服务协议的接受，并同意接受本服务协议的约束。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">一、定义</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><span style=\"font-family:微软雅黑\">在本协议中所使用的下列词语，除非另有定义，应具有以下含义：</span></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、&quot;用户&quot;指符合本协议所规定的条件，同意遵守本服务协议、条款（包括但不限于本协议），并实际使用平台的个人或机构。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">二、用户资格</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、 只有根据中国法律或设立地法律、法规和/或规章成立并合法存在的公司、企事业单位、社团组织和其他组织才能申请成为本平台用户，可以使用平台的服务。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、无民事行为能力人、限制民事行为能力人以及无经营或特定经营资格的组织不当注册成为平台用户或超过其民事权利或行为能力范围从事交易的，其与平台之间的协议自始无效，平台一经发现，有权立即注销该用户，并追究其使用平台服务的一切法律责任。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">三、用户的权利和义务</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、用户有权根据本协议及平台发布的相关规则，利用平台交易平台发布任务信息、查询媒介资源信息、制作报价单、下发稿、广告等订单、参加平台的活动及有权享受平台提供的其他的有关资讯及信息服务。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、用户有权根据需要更改登录密码和支付密码。用户应对以该用户名进行的所有活动和事件负全部责任。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3、用户有义务确保向平台提供的任何资料、注册信息真实准确，包括但不限于真实的公司名称、联系人姓名、身份证号、联系电话、地址、邮政编码等。保证平台可以通过上述联系方式与用户进行联系。同时，用户也有义务在相关资料实际变更时及时更新有关注册资料。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">4、用户不得以任何形式擅自转让或授权他人使用自己在平台的用户帐号。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">5、用户有义务确保在平台交易平台下的订单信息的真实、准确，无误导性。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">6、用户不得在平台发布国家禁止信息、不得发布侵犯他人知识产权或其他合法权益的信息，也不得发布违背社会公共利益或公共道德的信息。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">7、用户在平台交易中应当遵守诚实信用原则，不得以不正当竞争方式扰乱网上交易秩序，不得从事与网上交易无关的不当行为，不得在交易平台上发布任何违法信息。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">8、用户承诺自己在使用平台交易平台实施的所有行为遵守国家法律、法规和平台的相关规定以及各种社会公共利益或公共道德。对于任何法律后果，用户将独立承担所有法律责任。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">9、用户在平台网上交易过程中如与其他用户因交易产生纠纷，可以请求平台从中予以协调。用户如发现其他用户有违法或违反本协议的行为，可以向平台举报。如用户因网上交易与其他用户产生诉讼的，用户有权通过司法部门要求平台提供相关资料。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">10、用户应承担因交易产生的相关费用，并依法纳税。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">11、未经平台书面允许，用户不得将平台的媒介信息以及在平台上所展示的任何信息以复制、修改、翻译等形式（包含但不限于于以上形式）制作衍生作品、分发或公开展示。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">12、用户不得使用以下方式登录网站或破坏网站所提供的服务：</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 以机器人软件、蜘蛛软件、爬虫软件、刷屏软件或其它自动方式访问或登录平台；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 通过任何方式对平台网站结构造成或可能造成不良影响的行为；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3) 通过任何方式干扰或试图干扰平台的交易行为；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">13、用户同意其提供给平台的邮箱和手机接收来自平台的信息，包括但不限于活动信息、交易信息、促销信息等。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">四、平台的权利和义务</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、平台仅为用户提供一个交易平台，用户必须保证所有信息真实有效合法</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、平台有义务在现有技术水平的基础上确保整个网上交易平台的正常运行，避免服务中断或将中断时间限制在最短时间内，保证用户网上交易活动的顺利进行。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3、平台有义务对用户在注册使用平台平台所遇到的问题及时作出解答。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">4、平台有权对用户的注册资料进行查阅，对存在任何问题或怀疑的注册资料，平台有权发出通知询问用户并要求用户做出解释、改正，或不通知用户直接做出处罚、删除信息、删除账号等处理。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">5、用户因在平台上交易与其他用户产生质检纠纷的，用户同意平台根据事前制定的系统质检流程对纠纷进行判断、裁决，在判断过程中，平台有权通过电子邮件及电话联系向纠纷双方了解纠纷情况，并将根据了解的情况进行协调沟通，最终作出裁决。用户同意接受平台裁决所导致的补款或扣款处理。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">6、平台没有义务对所有用户的注册资料、所有的交易行为以及与交易有关的其他事项进行事先审查，但如发生以下情形，平台有权限制用户的活动、向用户核实有关资料、发出警告通知、暂时中止、无限期地中止及拒绝向该用户提供服务：</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 用户违反本协议或因被提及而纳入本协议的文件；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 存在用户或其他第三方通知平台，认为某个用户或具体交易事项存在违法或不当行为，并提供相关证据，而平台无法联系到该用户核实该用户向平台提供的任何资料；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3) 存在用户或其他第三方通知平台，认为某个用户或具体交易事项存在违法或不当行为，并提供相关证据。平台以普通非专业交易者的知识水平标准对相关内容进行判别，可以明显认为这些内容或行为可能对平台用户或平台造成财务损失或法律责任。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">7、根据国家法律法规、本协议的内容和平台所掌握的事实依据，可以认定用户存在违法或违反本协议行为以及在平台平台上的其他不当行为，平台有权在平台平台以网络发布形式公布用户的违法行为，并有权随时作出删除相关信息、终止服务提供等处理，而无须征得用户的同意。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">8、平台有权在不通知用户的前提下删除或采取其他限制性措施处理下列信息：包括但不限于以规避费用为目的；以炒作信用为目的；存在欺诈等恶意或虚假内容；与网上交易无关或不是以交易为目的；存在恶意下单或其他试图扰乱正常交易秩序因素；该信息违反公共利益或可能严重损害平台和其他用户合法利益的。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">五、服务的中断和终止</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、在平台未向用户收取相关服务费用的情况下，平台可自行全权决定以任何理由 (包括但不限于平台认为用户已违反本协议的字面意义和精神，或用户在超过180天内未登录平台等) 终止对用户的服务，并不再保存用户在平台的全部资料（包括但不限于用户信息、稿件信息、交易信息等）。同时平台可自行全权决定，在发出通知或不发出通知的情况下，随时停止提供全部或部分服务。服务终止后，平台没有义务为用户保留原用户资料或与之相关的任何信息，或转发任何未曾阅读或发送的信息给用户或第三方。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、如用户向平台提出注销平台注册用户身份，需经平台审核同意，由平台注销该注册用户，用户即解除与平台的协议关系，但平台仍保留下列权利：</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 用户注销后，平台有权保留该用户的资料，包括但不限于以前的用户资料、交易记录等。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 用户注销后，如用户在注销前在平台交易平台上存在违法行为或违反本协议的行为，平台仍可行使本协议所规定的权利。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3、如存在下列情况，平台可以通过注销用户的方式终止服务：</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 在用户违反本协议相关规定时，平台有权终止向该用户提供服务。平台将在中断服务时通知用户。但如该用户在被平台终止提供服务后，再一次直接或间接或以他人名义注册为平台用户的，平台有权再次单方面终止为该用户提供服务；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 一旦平台发现用户提供的注册资料存在虚假的情况，平台有权随时终止为该用户提供服务；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3) 用户出现作弊行为，网站可根据情况作出处理，甚至注销用户。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">4) 其它平台认为需终止服务的情况。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">六、平台的责任范围</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><span style=\"font-family:微软雅黑\">当用户接受该协议时，用户应明确了解并同意</span>∶</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、用户使用平台之风险由用户个人负担。平台是在现有技术基础上提供的。平台不保证以下事项∶</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 平台将符合用户的要求。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 平台不受干扰、能够及时提供、安全可靠或免于出错。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3) 本服务使用权的取得结果是正确或可靠的。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、是否经由平台下载或取得任何资料，由用户自行考虑、衡量并且自负风险，因下载任何资料而导致用户电脑系统的任何损坏或资料流失，用户应负完全责任。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3、用户经由平台取得的建议和资讯，无论其形式或表现，绝不构成本协议未明示规定的任何保证。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">4、基于以下原因而造成的利润、商誉、使用、资料损失或其它无形损失，平台不承担任何直接、间接、附带、特别、衍生性或惩罚性赔偿（即使平台已被告知前款赔偿的可能性）：</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 平台的使用或无法使用。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 用户的传输或资料遭到未获授权的存取或变更。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3) 平台中任何第三方之声明或行为。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">4) 平台其它相关事宜。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">5、平台只是为用户提供一个服务交易的平台，对于用户所发布的任务和合法性、真实性及其品质，以及用户履行交易的能力等，平台一律不负任何担保责任。用户如果因使用平台，或因购买刊登于平台的任何物品，而受到损害时，平台不负任何补偿或赔偿责任。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">6、平台提供与其它互联网上的网站或资源的链接，用户可能会因此连结至其它运营商经营的网站，但不表示平台与这些运营商有任何关系。其它运营商经营的网站均由各经营者自行负责，不属于平台控制及负责范围之内。对于存在或来源于此类网站或资源的任何内容、广告、产品或其它资料，平台亦不予保证或负责。因使用或依赖任何此类网站或资源发布的或经由此类网站或资源获得的任何内容、物品或服务所产生的任何损害或损失，平台不负任何直接或间接的责任。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">七、知识产权</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、平台及平台所使用的任何相关软件、程序、内容，包括但不限于作品、图片、档案、资料、网站构架、网站版面的安排、网页设计、经由平台或广告商向用户呈现的广告或资讯，均由平台或其它权利人依法享有相应的知识产权，包括但不限于著作权、商标权、专利权或其它专属权利等，受到相关法律的保护。未经平台或权利人明示授权，用户保证不修改、出租、出借、出售、散布平台及平台所使用的上述任何资料和资源，或根据上述资料和资源制作成任何种类物品。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、平台授予用户不可转移及非专属的使用权，使用户可以通过单机计算机使用平台的目标代码（以下简称&quot;软件&quot;），但用户不得且不得允许任何第三方，复制、修改、创作衍生作品、进行还原工程、反向组译，或以其它方式破译或试图破译源代码，或出售、转让&quot;软件&quot;或对&quot;软件 &quot;进行再授权，或以其它方式移转&quot;软件&quot;之任何权利。用户同意不以任何方式修改&quot;软件&quot;，或使用修改后的&quot;软件&quot;。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3、用户不得经由非平台所提供的界面使用平台。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">八、不可抗力</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><span style=\"font-family:微软雅黑\">因不可抗力或者其他意外事件，使得本协议的履行不可能、不必要或者无意义的，双方均不承担责任。本合同所称之不可抗力意指不能预见、不能避免并不能克服的客观情况，包括但不限于战争、台风、水灾、火灾、雷击或地震、罢工、暴动、法定疾病、黑客攻击、网络病毒、电信部门技术管制、政府行为或任何其它自然或人为造成的灾难等客观情况。</span></span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">九、争议解决方式</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、本协议及其修订本的有效性、履行和与本协议及其修订本效力有关的所有事宜，将受中华人民共和国法律管辖，任何争议仅适用中华人民共和国法律。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、因使用平台服务所引起与平台的任何争议，均应提交相应官方仲裁机关进行仲裁。相关争议应单独仲裁，不得与任何其它方的争议在任何仲裁中合并处理，该仲裁裁决是终局，对各方均有约束力。如果所涉及的争议不适于仲裁解决，用户同意一切争议由具有管辖权的法院管辖。本协议可由平台随时修订，并将修订后的协议公告于平台网站顶部显眼位置，修订后的条款内容自公告时起生效，并成为本协议的一部分。</span></p><p><span style=\";font-family:Calibri;font-size:14px\">&nbsp;</span></p><p><br/></p>',0,NULL,'2019-03-25 18:10:06'),(2,0,'privacy','隐私条款','<p style=\"margin-left: 0;text-indent: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">尊敬的用户，欢迎注册成为平台用户。在注册前请仔细阅读如下服务条款：</span></span></strong></p><p style=\"margin-left: 0;text-indent: 0;line-height: 20px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><span style=\"font-family:微软雅黑\">依据本协议的规定提供服务，本协议具有合同效力。用户必须完全同意本协议，才能够享受本平台提供的服务。用户在注册成功即表示用户完全接受本协议的全部条款。注册用户时请用户认真阅读本服务协议，用户可以选择</span>“接受”或“拒绝”本服务协议（未成年人应在法定监护人陪同下审阅）。用户只有在接受本服务协议的情况下，才有权使用平台提供的相关服务。用户的实际使用行为将视为对本服务协议的接受，并同意接受本服务协议的约束。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">一、定义</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><span style=\"font-family:微软雅黑\">在本协议中所使用的下列词语，除非另有定义，应具有以下含义：</span></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、&quot;用户&quot;指符合本协议所规定的条件，同意遵守本服务协议、条款（包括但不限于本协议），并实际使用平台的个人或机构。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">二、用户资格</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、 只有根据中国法律或设立地法律、法规和/或规章成立并合法存在的公司、企事业单位、社团组织和其他组织才能申请成为本平台用户，可以使用平台的服务。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、无民事行为能力人、限制民事行为能力人以及无经营或特定经营资格的组织不当注册成为平台用户或超过其民事权利或行为能力范围从事交易的，其与平台之间的协议自始无效，平台一经发现，有权立即注销该用户，并追究其使用平台服务的一切法律责任。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">三、用户的权利和义务</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、用户有权根据本协议及平台发布的相关规则，利用平台交易平台发布任务信息、查询媒介资源信息、制作报价单、下发稿、广告等订单、参加平台的活动及有权享受平台提供的其他的有关资讯及信息服务。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、用户有权根据需要更改登录密码和支付密码。用户应对以该用户名进行的所有活动和事件负全部责任。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3、用户有义务确保向平台提供的任何资料、注册信息真实准确，包括但不限于真实的公司名称、联系人姓名、身份证号、联系电话、地址、邮政编码等。保证平台可以通过上述联系方式与用户进行联系。同时，用户也有义务在相关资料实际变更时及时更新有关注册资料。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">4、用户不得以任何形式擅自转让或授权他人使用自己在平台的用户帐号。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">5、用户有义务确保在平台交易平台下的订单信息的真实、准确，无误导性。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">6、用户不得在平台发布国家禁止信息、不得发布侵犯他人知识产权或其他合法权益的信息，也不得发布违背社会公共利益或公共道德的信息。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">7、用户在平台交易中应当遵守诚实信用原则，不得以不正当竞争方式扰乱网上交易秩序，不得从事与网上交易无关的不当行为，不得在交易平台上发布任何违法信息。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">8、用户承诺自己在使用平台交易平台实施的所有行为遵守国家法律、法规和平台的相关规定以及各种社会公共利益或公共道德。对于任何法律后果，用户将独立承担所有法律责任。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">9、用户在平台网上交易过程中如与其他用户因交易产生纠纷，可以请求平台从中予以协调。用户如发现其他用户有违法或违反本协议的行为，可以向平台举报。如用户因网上交易与其他用户产生诉讼的，用户有权通过司法部门要求平台提供相关资料。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">10、用户应承担因交易产生的相关费用，并依法纳税。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">11、未经平台书面允许，用户不得将平台的媒介信息以及在平台上所展示的任何信息以复制、修改、翻译等形式（包含但不限于于以上形式）制作衍生作品、分发或公开展示。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">12、用户不得使用以下方式登录网站或破坏网站所提供的服务：</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 以机器人软件、蜘蛛软件、爬虫软件、刷屏软件或其它自动方式访问或登录平台；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 通过任何方式对平台网站结构造成或可能造成不良影响的行为；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3) 通过任何方式干扰或试图干扰平台的交易行为；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">13、用户同意其提供给平台的邮箱和手机接收来自平台的信息，包括但不限于活动信息、交易信息、促销信息等。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">四、平台的权利和义务</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、平台仅为用户提供一个交易平台，用户必须保证所有信息真实有效合法</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、平台有义务在现有技术水平的基础上确保整个网上交易平台的正常运行，避免服务中断或将中断时间限制在最短时间内，保证用户网上交易活动的顺利进行。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3、平台有义务对用户在注册使用平台平台所遇到的问题及时作出解答。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">4、平台有权对用户的注册资料进行查阅，对存在任何问题或怀疑的注册资料，平台有权发出通知询问用户并要求用户做出解释、改正，或不通知用户直接做出处罚、删除信息、删除账号等处理。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">5、用户因在平台上交易与其他用户产生质检纠纷的，用户同意平台根据事前制定的系统质检流程对纠纷进行判断、裁决，在判断过程中，平台有权通过电子邮件及电话联系向纠纷双方了解纠纷情况，并将根据了解的情况进行协调沟通，最终作出裁决。用户同意接受平台裁决所导致的补款或扣款处理。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">6、平台没有义务对所有用户的注册资料、所有的交易行为以及与交易有关的其他事项进行事先审查，但如发生以下情形，平台有权限制用户的活动、向用户核实有关资料、发出警告通知、暂时中止、无限期地中止及拒绝向该用户提供服务：</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 用户违反本协议或因被提及而纳入本协议的文件；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 存在用户或其他第三方通知平台，认为某个用户或具体交易事项存在违法或不当行为，并提供相关证据，而平台无法联系到该用户核实该用户向平台提供的任何资料；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3) 存在用户或其他第三方通知平台，认为某个用户或具体交易事项存在违法或不当行为，并提供相关证据。平台以普通非专业交易者的知识水平标准对相关内容进行判别，可以明显认为这些内容或行为可能对平台用户或平台造成财务损失或法律责任。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">7、根据国家法律法规、本协议的内容和平台所掌握的事实依据，可以认定用户存在违法或违反本协议行为以及在平台平台上的其他不当行为，平台有权在平台平台以网络发布形式公布用户的违法行为，并有权随时作出删除相关信息、终止服务提供等处理，而无须征得用户的同意。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">8、平台有权在不通知用户的前提下删除或采取其他限制性措施处理下列信息：包括但不限于以规避费用为目的；以炒作信用为目的；存在欺诈等恶意或虚假内容；与网上交易无关或不是以交易为目的；存在恶意下单或其他试图扰乱正常交易秩序因素；该信息违反公共利益或可能严重损害平台和其他用户合法利益的。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">五、服务的中断和终止</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、在平台未向用户收取相关服务费用的情况下，平台可自行全权决定以任何理由 (包括但不限于平台认为用户已违反本协议的字面意义和精神，或用户在超过180天内未登录平台等) 终止对用户的服务，并不再保存用户在平台的全部资料（包括但不限于用户信息、稿件信息、交易信息等）。同时平台可自行全权决定，在发出通知或不发出通知的情况下，随时停止提供全部或部分服务。服务终止后，平台没有义务为用户保留原用户资料或与之相关的任何信息，或转发任何未曾阅读或发送的信息给用户或第三方。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、如用户向平台提出注销平台注册用户身份，需经平台审核同意，由平台注销该注册用户，用户即解除与平台的协议关系，但平台仍保留下列权利：</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 用户注销后，平台有权保留该用户的资料，包括但不限于以前的用户资料、交易记录等。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 用户注销后，如用户在注销前在平台交易平台上存在违法行为或违反本协议的行为，平台仍可行使本协议所规定的权利。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3、如存在下列情况，平台可以通过注销用户的方式终止服务：</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 在用户违反本协议相关规定时，平台有权终止向该用户提供服务。平台将在中断服务时通知用户。但如该用户在被平台终止提供服务后，再一次直接或间接或以他人名义注册为平台用户的，平台有权再次单方面终止为该用户提供服务；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 一旦平台发现用户提供的注册资料存在虚假的情况，平台有权随时终止为该用户提供服务；</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3) 用户出现作弊行为，网站可根据情况作出处理，甚至注销用户。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">4) 其它平台认为需终止服务的情况。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">六、平台的责任范围</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><span style=\"font-family:微软雅黑\">当用户接受该协议时，用户应明确了解并同意</span>∶</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、用户使用平台之风险由用户个人负担。平台是在现有技术基础上提供的。平台不保证以下事项∶</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 平台将符合用户的要求。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 平台不受干扰、能够及时提供、安全可靠或免于出错。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3) 本服务使用权的取得结果是正确或可靠的。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、是否经由平台下载或取得任何资料，由用户自行考虑、衡量并且自负风险，因下载任何资料而导致用户电脑系统的任何损坏或资料流失，用户应负完全责任。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3、用户经由平台取得的建议和资讯，无论其形式或表现，绝不构成本协议未明示规定的任何保证。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">4、基于以下原因而造成的利润、商誉、使用、资料损失或其它无形损失，平台不承担任何直接、间接、附带、特别、衍生性或惩罚性赔偿（即使平台已被告知前款赔偿的可能性）：</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1) 平台的使用或无法使用。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2) 用户的传输或资料遭到未获授权的存取或变更。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3) 平台中任何第三方之声明或行为。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">4) 平台其它相关事宜。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">5、平台只是为用户提供一个服务交易的平台，对于用户所发布的任务和合法性、真实性及其品质，以及用户履行交易的能力等，平台一律不负任何担保责任。用户如果因使用平台，或因购买刊登于平台的任何物品，而受到损害时，平台不负任何补偿或赔偿责任。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">6、平台提供与其它互联网上的网站或资源的链接，用户可能会因此连结至其它运营商经营的网站，但不表示平台与这些运营商有任何关系。其它运营商经营的网站均由各经营者自行负责，不属于平台控制及负责范围之内。对于存在或来源于此类网站或资源的任何内容、广告、产品或其它资料，平台亦不予保证或负责。因使用或依赖任何此类网站或资源发布的或经由此类网站或资源获得的任何内容、物品或服务所产生的任何损害或损失，平台不负任何直接或间接的责任。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">七、知识产权</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、平台及平台所使用的任何相关软件、程序、内容，包括但不限于作品、图片、档案、资料、网站构架、网站版面的安排、网页设计、经由平台或广告商向用户呈现的广告或资讯，均由平台或其它权利人依法享有相应的知识产权，包括但不限于著作权、商标权、专利权或其它专属权利等，受到相关法律的保护。未经平台或权利人明示授权，用户保证不修改、出租、出借、出售、散布平台及平台所使用的上述任何资料和资源，或根据上述资料和资源制作成任何种类物品。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、平台授予用户不可转移及非专属的使用权，使用户可以通过单机计算机使用平台的目标代码（以下简称&quot;软件&quot;），但用户不得且不得允许任何第三方，复制、修改、创作衍生作品、进行还原工程、反向组译，或以其它方式破译或试图破译源代码，或出售、转让&quot;软件&quot;或对&quot;软件 &quot;进行再授权，或以其它方式移转&quot;软件&quot;之任何权利。用户同意不以任何方式修改&quot;软件&quot;，或使用修改后的&quot;软件&quot;。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">3、用户不得经由非平台所提供的界面使用平台。</span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">八、不可抗力</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><span style=\"font-family:微软雅黑\">因不可抗力或者其他意外事件，使得本协议的履行不可能、不必要或者无意义的，双方均不承担责任。本合同所称之不可抗力意指不能预见、不能避免并不能克服的客观情况，包括但不限于战争、台风、水灾、火灾、雷击或地震、罢工、暴动、法定疾病、黑客攻击、网络病毒、电信部门技术管制、政府行为或任何其它自然或人为造成的灾难等客观情况。</span></span></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;padding: 0;background: rgb(255, 255, 255)\"><strong><span style=\"font-family: 微软雅黑;color: rgb(221, 0, 0);letter-spacing: 0;font-size: 15px\"><span style=\"font-family:微软雅黑\">九、争议解决方式</span></span></strong></p><p style=\"margin-top: 28px;margin-left: 0;text-indent: 0;line-height: 16px;background: rgb(255, 255, 255)\"><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">1、本协议及其修订本的有效性、履行和与本协议及其修订本效力有关的所有事宜，将受中华人民共和国法律管辖，任何争议仅适用中华人民共和国法律。</span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\"><br/></span><span style=\"font-family: 微软雅黑;color: rgb(102, 102, 102);letter-spacing: 0;font-size: 11px\">2、因使用平台服务所引起与平台的任何争议，均应提交相应官方仲裁机关进行仲裁。相关争议应单独仲裁，不得与任何其它方的争议在任何仲裁中合并处理，该仲裁裁决是终局，对各方均有约束力。如果所涉及的争议不适于仲裁解决，用户同意一切争议由具有管辖权的法院管辖。本协议可由平台随时修订，并将修订后的协议公告于平台网站顶部显眼位置，修订后的条款内容自公告时起生效，并成为本协议的一部分。</span></p><p><span style=\";font-family:Calibri;font-size:14px\">&nbsp;</span></p><p><br/></p>',0,NULL,'2019-03-23 03:23:33'),(3,0,'about','关于我们','<p>测试中测试中</p>',0,NULL,'2019-04-30 20:07:37');

#
# Structure for table "password_resets"
#

DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "password_resets"
#


#
# Structure for table "pay_settings"
#

DROP TABLE IF EXISTS `pay_settings`;
CREATE TABLE `pay_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `app_id` varchar(255) DEFAULT NULL,
  `mch_id` varchar(255) DEFAULT NULL COMMENT '微信商户id',
  `notify_url` varchar(255) DEFAULT NULL,
  `return_url` varchar(255) DEFAULT NULL,
  `setting` text,
  `status` tinyint(1) DEFAULT '0' COMMENT '1正常2未启用',
  `secret` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `qrcode` varchar(255) DEFAULT NULL COMMENT '支付图片',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

#
# Data for table "pay_settings"
#

INSERT INTO `pay_settings` VALUES (1,'weixin',NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'2019-05-07 15:34:44','/images/file/RKVdY2MH0v7Ynfr4TKR9RNLN2O2wO3k41V2DSLOb.jpeg'),(2,'alipay',NULL,NULL,'/api/v1/alipay/notify','/success',NULL,1,NULL,NULL,'2019-05-07 15:26:11','/images/file/NchO2csr1KlsCk7YggPvHBZXV6T843bwS11uTLPE.jpeg');

#
# Structure for table "permissions"
#

DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `route` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '路由名称',
  `icon_id` int(11) DEFAULT NULL COMMENT '图标ID',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(2) DEFAULT '0' COMMENT '0为显示，1为隐藏',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=138 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "permissions"
#

INSERT INTO `permissions` VALUES (1,'system.manage','web','系统管理','',100,0,15,'2019-03-19 06:19:04','2019-03-19 06:19:04',0),(2,'system.user','web','账户管理','admin.user',123,1,0,'2019-03-19 06:19:04','2019-03-19 06:19:04',0),(3,'system.user.create','web','添加用户','admin.user.create',1,2,0,'2019-03-19 06:19:04','2019-03-19 06:19:04',0),(4,'system.user.edit','web','编辑用户','admin.user.edit',1,2,0,'2019-03-19 06:19:04','2019-03-19 06:19:04',0),(5,'system.user.destroy','web','删除用户','admin.user.destroy',1,2,0,'2019-03-19 06:19:04','2019-03-19 06:19:04',0),(6,'system.user.role','web','分配角色','admin.user.role',1,2,0,'2019-03-19 06:19:04','2019-03-19 06:19:04',0),(7,'system.user.permission','web','分配权限','admin.user.permission',1,2,0,'2019-03-19 06:19:04','2019-03-19 06:19:04',0),(8,'system.user.status','web','启用禁用','admin.user.status',1,2,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(9,'system.role','web','角色管理','admin.role',121,1,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(10,'system.role.create','web','添加角色','admin.role.create',1,9,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(11,'system.role.edit','web','编辑角色','admin.role.edit',1,9,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(12,'system.role.destroy','web','删除角色','admin.role.destroy',1,9,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(13,'system.role.permission','web','分配权限','admin.role.permission',1,9,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(14,'system.permission','web','权限管理','admin.permission',12,1,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(15,'system.permission.create','web','添加权限','admin.permission.create',1,14,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(16,'system.permission.edit','web','编辑权限','admin.permission.edit',1,14,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(17,'system.permission.destroy','web','删除权限','admin.permission.destroy',1,14,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(18,'order.manage','web','订单管理','',123,0,20,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(20,'admin.pay','web','支付配置','admin.pay',1,90,1,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(23,'member.manage','web','用户管理','',123,0,18,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(24,'admin.member.member','web','广告主管理','admin.member',1,23,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(25,'admin.member.member.toExcel','web','导出用户信息','admin.member.toExcel',1,24,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(26,'admin.member.userModel','web','用户模型','admin.userModel',1,100,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(27,'admin.member.userModel.create','web','添加用户模型','admin.userModel.create',1,26,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(28,'admin.member.userModel.edit','web','编辑用户模型','admin.userModel.edit',1,26,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(30,'website.manage','web','门户管理','',28,0,16,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(31,'admin.website.website','web','门户设置','admin.website',13,30,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(32,'admin.website.update','web','编辑门户','admin.website.update',1,31,0,'2019-03-19 06:19:05','2019-03-19 06:19:05',0),(33,'admin.website.article','web','发现管理','admin.website.article',13,30,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',1),(34,'admin.website.article.create','web','添加发现','admin.website.article.create',1,33,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(35,'admin.website.article.edit','web','修改发现','admin.website.article.edit',1,33,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(36,'admin.website.article.destroy','web','删除发现','admin.website.article.destroy',1,33,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(37,'admin.website.help','web','帮助管理','admin.website.help',13,30,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',1),(38,'admin.website.help.create','web','添加帮助','admin.website.help.create',1,37,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(39,'admin.website.help.edit','web','编辑帮助','admin.website.help.edit',1,37,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(40,'admin.website.help.destroy','web','删除帮助','admin.website.help.destroy',1,37,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(41,'admin.website.circle','web','圈子管理','admin.website.circle',13,30,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',1),(42,'admin.website.circle.create','web','添加圈子','admin.website.circle.create',1,41,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(43,'admin.website.circle.edit','web','编辑圈子','admin.website.circle.edit',1,41,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(44,'admin.website.circle.destroy','web','删除圈子','admin.website.circle.destroy',1,41,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(45,'admin.website.image','web','营销位管理','admin.website.image',13,30,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(46,'admin.website.image.create','web','添加营销位','admin.website.image.store',1,45,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(47,'admin.website.image.edit','web','编辑营销位','admin.website.image.edit',1,45,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(48,'admin.website.image.destroy','web','删除营销位','admin.website.image.destroy',1,45,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(49,'data.manage','web','基础数据','',29,0,14,'2019-03-19 06:19:06','2019-03-19 06:19:06',0),(50,'data.dictionary','web','数据字典','admin.dictionary',1,49,0,'2019-03-19 06:19:06','2019-03-19 06:19:06',1),(51,'data.dictionary.edit','web','数据字典-编辑','',1,50,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(52,'data.operateLog','web','操作日志','admin.operateLog',1,49,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',1),(53,'data.operateLog.destroy','web','操作日志-删除','admin.operateLog.destroy',1,52,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(54,'data.operateLog.excel','web','操作日志-导出','admin.operateLog.excel',1,52,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(55,'data.page','web','单页管理','admin.page',1,49,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(56,'data.page.edit','web','单页管理-编辑','admin.page.edit',1,55,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(57,'data.virtualPhone','web','虚拟号码池','admin.virtualPhone',1,100,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(58,'data.virtualPhone.create','web','虚拟号码导入','admin.virtualPhone.create',1,57,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(59,'data.virtualPhone.destroy','web','虚拟号码删除','admin.virtualPhone.destroy',1,57,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(60,'data.virtualPhone.destroyAll','web','一键清空','admin.virtualPhone.destroyAll',1,57,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(61,'data.district','web','省市区管理','admin.district',1,49,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(62,'data.hotCity','web','热门城市管理','admin.hotCity',1,49,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(63,'data.hotCity.create','web','添加热门城市','admin.hotCity.create',1,62,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(64,'data.hotCity.edit','web','编辑热门城市','admin.hotCity.edit',1,62,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(65,'data.hotCity.destroy','web','移除热门城市','admin.hotCity.destroy',1,62,0,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(66,'product.manage','web','资源管理','',22,0,19,'2019-03-19 06:19:07','2019-03-19 06:19:07',0),(83,'admin.member.cloud','web','云资源管理','admin.product.cloud',1,66,0,'2019-03-19 06:19:09','2019-03-19 06:19:09',0),(90,'account.manager','web','财务管理','',42,0,17,'2019-03-19 06:19:09','2019-03-19 06:19:09',0),(91,'admin.account','web','财务管理','admin.account',1,90,30,'2019-03-19 06:19:10','2019-03-19 06:19:10',0),(92,'admin.refund','web','退款管理','admin.refund',1,90,28,'2019-03-19 06:19:10','2019-03-19 06:19:10',0),(93,'admin.cash','web','提现申请','admin.cash',1,100,26,'2019-03-19 06:19:10','2019-03-19 06:19:10',0),(94,'admin.cash.rate','web','财务比例配置','admin.cash.rate',1,100,24,'2019-03-19 06:19:10','2019-03-19 06:19:10',0),(95,'admin.cloud.cash','web','云资源财务管理','admin.cloud.cash',1,100,22,'2019-03-19 06:19:10','2019-03-19 06:19:10',0),(119,'sysmsg.manage','web','短信管理','',24,0,10,'2019-03-19 06:19:12','2019-03-19 06:19:12',0),(120,'admin.sysmsg','web','短信配置','admin.sysmsg',1,119,0,'2019-03-19 06:19:12','2019-03-19 06:19:12',0),(121,'admin.sysmsg.recharge','web','短信充值','admin.sysmsg.recharge',1,119,0,'2019-03-19 06:19:12','2019-03-19 06:19:12',0),(122,'admin.sysmsg.template','web','短信模板','admin.sysmsg.template',1,119,0,'2019-03-19 06:19:12','2019-03-19 06:19:12',0),(123,'admin.setting.manager','web','客户经理','admin.setting.manager',10,30,0,'2019-03-24 16:19:36','2019-05-01 02:03:11',0),(124,'admin.setting.manager.update','web','编辑','admin.setting.manager.update',46,123,0,'2019-03-24 16:20:30','2019-03-24 16:20:30',0),(125,'admin.agent','web','会员管理','admin.agent',10,23,0,'2019-03-26 13:54:41','2019-05-01 02:20:30',0),(126,'admin.agent.setting','web','会员设置','admin.agent.setting',42,23,0,'2019-03-26 13:55:12','2019-05-01 02:20:38',0),(127,'admin.agent.account','web','代理财务','admin.agent.account',NULL,100,0,'2019-03-26 13:55:50','2019-03-26 13:55:50',0),(128,'cloud.order.manager','web','云订单管理','admin.apply.cloud',NULL,18,0,'2019-04-24 15:46:58','2019-04-24 15:46:58',0),(129,'admin.member.apply','web','平台订单','admin.apply',NULL,500,1,'2019-04-25 19:03:13','2019-04-25 19:07:12',0),(130,'admin.cloudconfig','web','云资源配置','admin.cloudconfig.index',NULL,66,0,'2019-05-01 00:07:38','2019-05-01 00:07:38',0),(135,'batch.manage','web','批量调价',NULL,42,0,0,'2019-05-03 12:15:13','2019-05-03 12:15:13',0),(136,'admin.product.batch','web','调价记录','admin.product.batch',42,135,0,'2019-05-03 12:15:33','2019-05-03 12:15:33',0),(137,'admin.product.price','web','批量调价','admin.product.price',42,135,0,'2019-05-03 12:15:44','2019-05-03 12:15:44',0);

#
# Structure for table "model_has_permissions"
#

DROP TABLE IF EXISTS `model_has_permissions`;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`) USING BTREE,
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`) USING BTREE,
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "model_has_permissions"
#

INSERT INTO `model_has_permissions` VALUES (1,'App\\Models\\User',1),(2,'App\\Models\\User',1),(3,'App\\Models\\User',1),(4,'App\\Models\\User',1),(5,'App\\Models\\User',1),(6,'App\\Models\\User',1),(7,'App\\Models\\User',1),(8,'App\\Models\\User',1),(9,'App\\Models\\User',1),(10,'App\\Models\\User',1),(11,'App\\Models\\User',1),(12,'App\\Models\\User',1),(13,'App\\Models\\User',1),(14,'App\\Models\\User',1),(15,'App\\Models\\User',1),(16,'App\\Models\\User',1),(17,'App\\Models\\User',1),(18,'App\\Models\\User',1),(20,'App\\Models\\User',1),(23,'App\\Models\\User',1),(24,'App\\Models\\User',1),(25,'App\\Models\\User',1),(26,'App\\Models\\User',1),(27,'App\\Models\\User',1),(28,'App\\Models\\User',1),(30,'App\\Models\\User',1),(31,'App\\Models\\User',1),(32,'App\\Models\\User',1),(33,'App\\Models\\User',1),(34,'App\\Models\\User',1),(35,'App\\Models\\User',1),(36,'App\\Models\\User',1),(37,'App\\Models\\User',1),(38,'App\\Models\\User',1),(39,'App\\Models\\User',1),(40,'App\\Models\\User',1),(41,'App\\Models\\User',1),(42,'App\\Models\\User',1),(43,'App\\Models\\User',1),(44,'App\\Models\\User',1),(45,'App\\Models\\User',1),(46,'App\\Models\\User',1),(47,'App\\Models\\User',1),(48,'App\\Models\\User',1),(49,'App\\Models\\User',1),(50,'App\\Models\\User',1),(51,'App\\Models\\User',1),(52,'App\\Models\\User',1),(53,'App\\Models\\User',1),(54,'App\\Models\\User',1),(55,'App\\Models\\User',1),(56,'App\\Models\\User',1),(57,'App\\Models\\User',1),(58,'App\\Models\\User',1),(59,'App\\Models\\User',1),(60,'App\\Models\\User',1),(61,'App\\Models\\User',1),(62,'App\\Models\\User',1),(63,'App\\Models\\User',1),(64,'App\\Models\\User',1),(65,'App\\Models\\User',1),(66,'App\\Models\\User',1),(83,'App\\Models\\User',1),(90,'App\\Models\\User',1),(91,'App\\Models\\User',1),(92,'App\\Models\\User',1),(93,'App\\Models\\User',1),(94,'App\\Models\\User',1),(95,'App\\Models\\User',1),(119,'App\\Models\\User',1),(120,'App\\Models\\User',1),(121,'App\\Models\\User',1),(122,'App\\Models\\User',1),(123,'App\\Models\\User',1),(124,'App\\Models\\User',1),(125,'App\\Models\\User',1),(126,'App\\Models\\User',1),(127,'App\\Models\\User',1),(128,'App\\Models\\User',1),(129,'App\\Models\\User',1),(130,'App\\Models\\User',1),(135,'App\\Models\\User',1),(136,'App\\Models\\User',1),(137,'App\\Models\\User',1);

#
# Structure for table "product_account"
#

DROP TABLE IF EXISTS `product_account`;
CREATE TABLE `product_account` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `account` varchar(255) DEFAULT NULL COMMENT '账户',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_account"
#


#
# Structure for table "product_article_attributes"
#

DROP TABLE IF EXISTS `product_article_attributes`;
CREATE TABLE `product_article_attributes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `accept_type` enum('1','2') NOT NULL DEFAULT '1' COMMENT '1:周一-周五，2，周一-周日',
  `from_type` int(11) DEFAULT NULL COMMENT '入口类型',
  `image_count` tinyint(3) DEFAULT NULL COMMENT '图片数量',
  `link_type` enum('1','2') NOT NULL DEFAULT '1' COMMENT '1:带链接，2不带链接',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_article_attributes"
#


#
# Structure for table "product_article_from_types"
#

DROP TABLE IF EXISTS `product_article_from_types`;
CREATE TABLE `product_article_from_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_article_from_types"
#

INSERT INTO `product_article_from_types` VALUES (1,'无入口',1,NULL,'2019-03-30 20:10:19',9),(2,'网站首页',1,NULL,'2019-03-30 20:10:19',8),(3,'频道首页',1,NULL,'2019-03-30 20:10:19',7),(4,'二级频道首页',1,NULL,'2019-03-30 20:10:19',6),(5,'三级频道首页',1,NULL,'2019-03-30 20:10:19',5),(6,'列表页入口',1,NULL,'2019-03-30 20:10:19',4);

#
# Structure for table "product_batch_prices"
#

DROP TABLE IF EXISTS `product_batch_prices`;
CREATE TABLE `product_batch_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `set_type` enum('rate_value','price_value') NOT NULL DEFAULT 'rate_value' COMMENT '调价类型：rate_value比例上调，price_value单价上调',
  `rate_value` decimal(10,2) NOT NULL DEFAULT '0.00',
  `price_value` decimal(10,2) NOT NULL DEFAULT '0.00',
  `uid` int(11) NOT NULL DEFAULT '0',
  `ids` text,
  `product_type` enum('article','zimeiti','weibo','weixin','video','redbook') DEFAULT NULL COMMENT 'article,zimeiti,weibo,weixin,video,redbook',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0' COMMENT '0未执行，1执行完成',
  `success_ids` text COMMENT '操作成功id',
  `set_number` int(11) DEFAULT NULL COMMENT '设置数量',
  `success_number` int(11) DEFAULT NULL COMMENT '成功数量',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_batch_prices"
#


#
# Structure for table "product_categories"
#

DROP TABLE IF EXISTS `product_categories`;
CREATE TABLE `product_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '标签名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'icon图标地址',
  `banner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'banner图片地址',
  `redirect_type` enum('inside','outside') COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '跳转类型',
  `redirect_slug` enum('product','credit','article','help','about') COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '跳转页面标识',
  `redirect_id` int(11) DEFAULT NULL,
  `banner_redirect` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'banner跳转地址',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_categories"
#

INSERT INTO `product_categories` VALUES (6,'全国软文',0,'images/file/r18ogVW0XWohgbiJ0xNV0RPZ0u9ZCbXgmuRxWBdj.png','images/file/TzySj9FKg7Maja53upHajJQ4m0RXYW6h3FoBrpWe.png',NULL,'credit',0,NULL,'2019-03-20 08:23:22','2019-03-20 08:23:22'),(7,'公众号',0,'images/file/Oibnr755DFOJ635vAhC6tg3vpMH2Rukn6gq7KJmB.jpeg','images/file/ouyHe4EhxF7I5RawvLiPLd1cHJRoQawWibn9pYC1.png',NULL,NULL,NULL,NULL,'2019-03-20 08:24:49','2019-03-20 08:24:49'),(8,'自媒体',0,'images/file/mhIC0THd55aTApYOovdp5sYsTIDX5iRIbH3kyupT.png','images/file/hsDQ7ltRibvRKlEZM6D0QubN5zYbsitpxHgdxiSm.png',NULL,NULL,NULL,NULL,'2019-03-20 08:28:53','2019-03-20 08:28:53'),(10,'短视频',0,'images/file/pX9s7llihDIY4K4SVAVNHvBLVk3IM3itii8XDYNK.jpeg','images/file/pqiXtBLzRIOGoTz2ihY4ROgtavhPEq3ZZZ36zLEh.png',NULL,NULL,NULL,NULL,'2019-03-20 08:29:36','2019-03-20 08:29:36'),(11,'小红书',0,'images/file/dfNjA5FaOCACRbu8DRd05bsF0mNhubakl9ceJzA6.jpeg','images/file/EIJyh3JwJqa2SvHtuazFIpzCu4W7JDGUlIVmFEgI.png',NULL,NULL,NULL,NULL,'2019-03-20 08:56:38','2019-03-20 08:56:38'),(12,'微信朋友圈',0,'/images/file/x9w0egMAe3eV0OmRCut49e8JpZYhfdGxBoEVkSbp.png','/images/file/c9xcIje38UB63BBzpFv8VuSbQwRrL9PPTNGH4FuJ.png',NULL,NULL,NULL,NULL,'2019-03-25 22:03:43','2019-03-25 22:03:43');

#
# Structure for table "product_channels"
#

DROP TABLE IF EXISTS `product_channels`;
CREATE TABLE `product_channels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_channels"
#

INSERT INTO `product_channels` VALUES (1,'新闻',0,'2019-01-13 04:52:38','2019-01-13 22:05:58',NULL),(2,'财经',0,'2019-01-13 04:54:00','2019-01-13 22:05:58',NULL),(3,'IT',0,'2019-01-13 04:54:00','2019-01-13 22:05:58',NULL),(4,'科技',0,'2019-01-13 04:54:00','2019-01-13 22:05:58',NULL),(5,'娱乐',0,'2019-01-13 04:54:00','2019-01-13 22:05:58',NULL),(6,'旅游',0,'2019-01-13 04:54:00','2019-01-13 22:05:58',NULL),(7,'教育',0,'2019-01-13 04:54:00','2019-01-13 22:05:58',NULL),(8,'房产',0,'2019-01-13 04:54:00','2019-01-13 22:05:58',NULL),(9,'家居',0,'2019-01-13 04:54:00','2019-01-13 22:05:58',NULL),(10,'汽车',0,'2019-01-13 04:54:00','2019-01-13 22:05:58',NULL),(11,'女性',0,'2019-01-13 04:54:00','2019-01-13 22:05:58',NULL),(12,'时尚',0,'2019-01-13 18:01:41','2019-01-13 22:05:58',NULL),(13,'美容',0,'2019-01-13 18:01:41','2019-01-13 22:05:58',NULL),(14,'母婴育儿',0,'2019-01-13 18:01:41','2019-01-13 22:05:58',NULL),(15,'健康',0,'2019-01-13 18:01:41','2019-01-13 22:05:58',NULL),(16,'艺术',0,'2019-01-13 18:01:41','2019-01-13 22:05:58',NULL),(17,'家电数码',0,'2019-01-13 18:01:41','2019-01-13 22:05:58',NULL),(18,'游戏动漫',0,'2019-01-13 18:01:41','2019-01-13 22:05:58',NULL),(19,'体育',0,'2019-01-13 18:01:41','2019-01-13 22:05:58',NULL),(20,'资讯',0,'2019-01-13 18:01:41','2019-01-13 22:05:58',NULL),(21,'生活',0,'2019-01-13 22:05:58','2019-01-13 22:05:58',NULL),(22,'食品',0,'2019-01-13 22:05:58','2019-01-13 22:05:58',NULL),(23,'文化环保',0,'2019-01-13 22:05:58','2019-01-13 22:05:58',NULL),(24,'公益',0,'2019-01-13 22:05:58','2019-01-13 22:05:58',NULL),(25,'法律',0,'2019-01-13 22:05:58','2019-01-13 22:05:58',NULL);

#
# Structure for table "product_cloud_syncs"
#

DROP TABLE IF EXISTS `product_cloud_syncs`;
CREATE TABLE `product_cloud_syncs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `min_money` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `max_money` decimal(10,2) DEFAULT NULL,
  `uuid` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_cloud_syncs"
#


#
# Structure for table "product_collection_names"
#

DROP TABLE IF EXISTS `product_collection_names`;
CREATE TABLE `product_collection_names` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL COMMENT '收藏名称',
  `sort` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_collection_names"
#

INSERT INTO `product_collection_names` VALUES (1,'新闻源',0,'2018-12-31 02:20:39','2018-12-31 02:20:39',NULL),(2,'网页收录',0,'2018-12-31 02:20:39','2018-12-31 02:20:39',NULL);

#
# Structure for table "product_collections"
#

DROP TABLE IF EXISTS `product_collections`;
CREATE TABLE `product_collections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `product_id` int(11) NOT NULL DEFAULT '0' COMMENT '产品id',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_collections"
#


#
# Structure for table "product_columns"
#

DROP TABLE IF EXISTS `product_columns`;
CREATE TABLE `product_columns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '栏目名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `banners` json NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_columns"
#


#
# Structure for table "product_fans"
#

DROP TABLE IF EXISTS `product_fans`;
CREATE TABLE `product_fans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL DEFAULT '0',
  `fans` int(11) DEFAULT NULL COMMENT '粉丝数量（万）',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_fans"
#


#
# Structure for table "product_has_categories"
#

DROP TABLE IF EXISTS `product_has_categories`;
CREATE TABLE `product_has_categories` (
  `product_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  KEY `product_has_categories_category_id_foreign` (`category_id`) USING BTREE,
  CONSTRAINT `product_has_categories_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_has_categories"
#


#
# Structure for table "product_has_channels"
#

DROP TABLE IF EXISTS `product_has_channels`;
CREATE TABLE `product_has_channels` (
  `product_id` int(11) DEFAULT NULL,
  `channel_id` int(11) DEFAULT NULL,
  KEY `channel_id` (`channel_id`) USING BTREE,
  CONSTRAINT `product_has_channels_ibfk_1` FOREIGN KEY (`channel_id`) REFERENCES `product_channels` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_has_channels"
#


#
# Structure for table "product_has_columns"
#

DROP TABLE IF EXISTS `product_has_columns`;
CREATE TABLE `product_has_columns` (
  `product_id` int(10) unsigned NOT NULL,
  `column_id` int(10) unsigned NOT NULL,
  KEY `product_has_columns_column_id_foreign` (`column_id`) USING BTREE,
  CONSTRAINT `product_has_columns_column_id_foreign` FOREIGN KEY (`column_id`) REFERENCES `product_columns` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_has_columns"
#


#
# Structure for table "product_has_districts"
#

DROP TABLE IF EXISTS `product_has_districts`;
CREATE TABLE `product_has_districts` (
  `product_id` int(10) unsigned NOT NULL,
  `district_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_has_districts"
#


#
# Structure for table "product_has_redbook_channels"
#

DROP TABLE IF EXISTS `product_has_redbook_channels`;
CREATE TABLE `product_has_redbook_channels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `redbook_channel_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_has_redbook_channels"
#


#
# Structure for table "product_has_zimeiti_channels"
#

DROP TABLE IF EXISTS `product_has_zimeiti_channels`;
CREATE TABLE `product_has_zimeiti_channels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `zimeiti_channel_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_has_zimeiti_channels"
#


#
# Structure for table "product_labels"
#

DROP TABLE IF EXISTS `product_labels`;
CREATE TABLE `product_labels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '标签名称',
  `color` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '颜色',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_labels"
#

INSERT INTO `product_labels` VALUES (1,'最新资源','#FF5722',0,'2019-01-07 23:09:46','2019-02-17 01:33:07'),(2,'官方认证','#FF5722',0,'2019-01-07 23:10:03','2019-02-17 01:33:07'),(3,'个人认证','#5FB878',0,'2019-02-17 01:33:07','2019-02-17 01:33:07');

#
# Structure for table "product_has_labels"
#

DROP TABLE IF EXISTS `product_has_labels`;
CREATE TABLE `product_has_labels` (
  `product_id` int(10) unsigned NOT NULL,
  `label_id` int(10) unsigned NOT NULL,
  KEY `product_has_labels_label_id_foreign` (`label_id`) USING BTREE,
  CONSTRAINT `product_has_labels_label_id_foreign` FOREIGN KEY (`label_id`) REFERENCES `product_labels` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_has_labels"
#


#
# Structure for table "product_materials"
#

DROP TABLE IF EXISTS `product_materials`;
CREATE TABLE `product_materials` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '个人资质名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_materials"
#

INSERT INTO `product_materials` VALUES (1,'个人认证',0,'2019-01-04 02:32:32','2019-01-08 20:50:36'),(2,'企业认证',0,'2019-01-08 20:50:36','2019-01-08 20:50:36');

#
# Structure for table "product_has_materials"
#

DROP TABLE IF EXISTS `product_has_materials`;
CREATE TABLE `product_has_materials` (
  `product_id` int(10) unsigned NOT NULL,
  `material_id` int(10) unsigned NOT NULL,
  KEY `product_has_materials_material_id_foreign` (`material_id`) USING BTREE,
  CONSTRAINT `product_has_materials_material_id_foreign` FOREIGN KEY (`material_id`) REFERENCES `product_materials` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_has_materials"
#


#
# Structure for table "product_range_fans"
#

DROP TABLE IF EXISTS `product_range_fans`;
CREATE TABLE `product_range_fans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '类型:1=>小于,2=>区间,3=>大于',
  `min` int(11) NOT NULL DEFAULT '0' COMMENT '小值',
  `max` int(11) NOT NULL DEFAULT '0' COMMENT '大值',
  `per_value` int(11) NOT NULL DEFAULT '0' COMMENT '单值',
  `unit` enum('wan') CHARACTER SET utf8mb4 NOT NULL DEFAULT 'wan' COMMENT '单位',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_range_fans"
#

INSERT INTO `product_range_fans` VALUES (4,1,0,0,10,'wan',10,'2019-03-29 12:46:12','2019-03-29 12:46:12'),(5,2,10,50,0,'wan',0,'2019-03-29 12:46:12','2019-03-29 12:46:12'),(6,2,50,100,0,'wan',0,'2019-03-29 12:46:12','2019-03-29 12:46:12'),(7,3,0,0,100,'wan',0,'2019-03-29 12:46:12','2019-03-29 12:46:12');

#
# Structure for table "product_range_moneys"
#

DROP TABLE IF EXISTS `product_range_moneys`;
CREATE TABLE `product_range_moneys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '类型:1=>小于,2=>区间,3=>大于',
  `min` int(11) NOT NULL DEFAULT '0' COMMENT '小值',
  `max` int(11) NOT NULL DEFAULT '0' COMMENT '大值',
  `per_value` int(11) NOT NULL DEFAULT '0' COMMENT '单值',
  `unit` enum('yuan','wan') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '单位',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_range_moneys"
#

INSERT INTO `product_range_moneys` VALUES (1,1,0,0,50,'yuan',0,'2019-01-23 20:53:26','2019-01-23 20:53:26'),(2,2,50,200,0,'yuan',0,'2019-01-23 20:53:26','2019-01-23 20:53:26'),(3,3,200,0,200,'yuan',0,'2019-01-23 20:53:26','2019-01-23 20:53:26');

#
# Structure for table "product_range_periods"
#

DROP TABLE IF EXISTS `product_range_periods`;
CREATE TABLE `product_range_periods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `min` int(11) NOT NULL DEFAULT '0' COMMENT '小值',
  `max` int(11) NOT NULL DEFAULT '0' COMMENT '大值',
  `per_value` int(11) NOT NULL DEFAULT '0' COMMENT '单值',
  `unit` enum('day','hour') CHARACTER SET utf8mb4 NOT NULL DEFAULT 'day' COMMENT '时间单位',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_range_periods"
#

INSERT INTO `product_range_periods` VALUES (1,1,0,0,8,'hour',0,'2019-01-23 20:55:21','2019-03-14 05:10:02'),(2,2,8,24,0,'hour',0,'2019-01-23 20:55:21','2019-03-14 05:10:02'),(3,3,24,0,24,'hour',0,'2019-01-23 20:55:21','2019-03-14 05:10:02');

#
# Structure for table "product_range_views"
#

DROP TABLE IF EXISTS `product_range_views`;
CREATE TABLE `product_range_views` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `min` int(11) NOT NULL DEFAULT '0' COMMENT '小值',
  `max` int(11) NOT NULL DEFAULT '0' COMMENT '大值',
  `per_value` int(11) NOT NULL DEFAULT '0' COMMENT '单值',
  `unit` enum('wan') CHARACTER SET utf8mb4 NOT NULL DEFAULT 'wan' COMMENT '单位',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_range_views"
#

INSERT INTO `product_range_views` VALUES (4,1,0,0,10,'wan',0,'2019-03-29 12:04:37','2019-03-29 12:04:37'),(5,2,10,50,0,'wan',0,'2019-03-29 12:04:37','2019-03-29 12:04:37'),(6,3,0,0,50,'wan',0,'2019-03-29 12:04:37','2019-03-29 12:04:37');

#
# Structure for table "product_redbook_channels"
#

DROP TABLE IF EXISTS `product_redbook_channels`;
CREATE TABLE `product_redbook_channels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_redbook_channels"
#


#
# Structure for table "product_resources"
#

DROP TABLE IF EXISTS `product_resources`;
CREATE TABLE `product_resources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_resources"
#

INSERT INTO `product_resources` VALUES (1,'娱乐',0,'2019-01-13 04:55:00','2019-01-13 22:06:45',NULL),(2,'音乐',0,'2019-01-13 04:55:00','2019-01-13 22:06:45',NULL),(3,'美食',0,'2019-01-13 04:55:00','2019-01-13 22:06:45',NULL),(4,'电影',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(5,'休闲',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(6,'时尚',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(7,'美容',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(8,'购物',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(9,'家居生活',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(10,'星座命理',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(11,'情感心理',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(12,'新闻资讯',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(13,'宠物 ',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(14,'文艺',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(15,'生活/百科',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(16,'IT/互联网',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(17,'摄影旅游',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(18,'幽默搞笑',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(19,'母婴育儿',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(20,'财经',0,'2019-01-13 18:04:02','2019-01-13 22:06:45',NULL),(21,'汽车',0,'2019-01-13 22:06:45','2019-01-13 22:06:45',NULL),(22,'广告/营销',0,'2019-01-13 22:06:45','2019-01-13 22:06:45',NULL),(23,'游戏动漫',0,'2019-01-13 22:06:45','2019-01-13 22:06:45',NULL),(24,'健康养生',0,'2019-01-13 22:06:45','2019-01-13 22:06:45',NULL),(25,'体育/健身',0,'2019-01-13 22:06:45','2019-01-13 22:06:45',NULL),(26,'教育培训',0,'2019-01-13 22:06:45','2019-01-13 22:06:45',NULL),(27,' 微商',0,'2019-01-13 22:06:45','2019-01-13 22:06:45',NULL),(28,'军事',0,'2019-01-13 22:06:45','2019-01-13 22:06:45',NULL),(29,'两性',0,'2019-01-13 22:06:45','2019-01-13 22:06:45',NULL);

#
# Structure for table "product_has_resources"
#

DROP TABLE IF EXISTS `product_has_resources`;
CREATE TABLE `product_has_resources` (
  `product_id` int(11) NOT NULL,
  `resource_id` int(11) DEFAULT NULL,
  KEY `resource_id` (`resource_id`) USING BTREE,
  CONSTRAINT `product_has_resources_ibfk_1` FOREIGN KEY (`resource_id`) REFERENCES `product_resources` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_has_resources"
#


#
# Structure for table "product_shares"
#

DROP TABLE IF EXISTS `product_shares`;
CREATE TABLE `product_shares` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `product_id` int(11) NOT NULL DEFAULT '0' COMMENT '产品id',
  `link` text COLLATE utf8mb4_unicode_ci COMMENT '分享链接',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_shares"
#


#
# Structure for table "product_trades"
#

DROP TABLE IF EXISTS `product_trades`;
CREATE TABLE `product_trades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COMMENT='视频行业';

#
# Data for table "product_trades"
#

INSERT INTO `product_trades` VALUES (1,'明星',NULL,0,'2019-01-13 04:56:44','2019-01-13 22:07:17'),(2,'名人/网红',NULL,0,'2019-01-13 04:56:44','2019-01-13 22:07:17'),(3,'媒体',NULL,0,'2019-01-13 04:56:44','2019-01-13 22:07:17'),(4,'搞笑',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(5,'时尚',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(6,'游戏/动漫',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(7,'音乐',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(8,'美食',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(9,'舞蹈',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(10,'母婴',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(11,'萌宠',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(12,' 运动健身',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(13,'八卦娱乐',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(14,'影视',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(15,'旅行',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(16,'绘画',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(17,'汽车',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(18,'教育',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(19,'综艺',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(20,'科技',NULL,0,'2019-01-13 18:06:09','2019-01-13 22:07:17'),(21,'财经',NULL,0,'2019-01-13 22:07:17','2019-01-13 22:07:17'),(22,'户外探索',NULL,0,'2019-01-13 22:07:17','2019-01-13 22:07:17');

#
# Structure for table "product_has_trades"
#

DROP TABLE IF EXISTS `product_has_trades`;
CREATE TABLE `product_has_trades` (
  `product_id` int(11) NOT NULL,
  `trade_id` int(11) DEFAULT NULL,
  KEY `trade_id` (`trade_id`) USING BTREE,
  CONSTRAINT `product_has_trades_ibfk_1` FOREIGN KEY (`trade_id`) REFERENCES `product_trades` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_has_trades"
#


#
# Structure for table "product_types"
#

DROP TABLE IF EXISTS `product_types`;
CREATE TABLE `product_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `tag` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_types"
#

INSERT INTO `product_types` VALUES (1,'软文',1,'2018-12-31 02:21:24','2019-03-27 15:21:46',0,'article'),(2,'公众号',1,'2018-12-31 02:21:24','2019-03-27 15:21:46',0,'weixin'),(3,'微博',1,'2018-12-31 02:21:24','2019-03-27 15:21:46',0,'weibo'),(4,'视频/直播',1,'2018-12-31 02:21:24','2019-03-27 15:21:46',0,'video'),(5,'小红书',1,NULL,'2019-03-27 15:21:46',0,'redbook'),(6,'自媒体',1,'2019-03-27 15:21:46','2019-03-27 15:21:46',0,'zimeiti');

#
# Structure for table "product_has_types"
#

DROP TABLE IF EXISTS `product_has_types`;
CREATE TABLE `product_has_types` (
  `product_id` int(10) NOT NULL DEFAULT '0',
  `type_id` int(11) DEFAULT NULL,
  KEY `type_id` (`type_id`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE,
  CONSTRAINT `product_has_types_ibfk_1` FOREIGN KEY (`type_id`) REFERENCES `product_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_has_types"
#


#
# Structure for table "product_videos"
#

DROP TABLE IF EXISTS `product_videos`;
CREATE TABLE `product_videos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COMMENT='视频平台';

#
# Data for table "product_videos"
#

INSERT INTO `product_videos` VALUES (1,'抖音',NULL,0,'2019-01-13 04:55:39','2019-02-18 06:03:21'),(2,'火山',NULL,0,'2019-01-13 04:55:39','2019-02-18 06:03:21'),(3,'西瓜',NULL,0,'2019-01-13 04:55:39','2019-02-18 06:03:21'),(4,'微视',NULL,0,'2019-01-13 04:55:39','2019-02-18 06:03:21'),(5,'快手',NULL,0,'2019-02-18 06:03:21','2019-02-18 06:03:21');

#
# Structure for table "product_has_videos"
#

DROP TABLE IF EXISTS `product_has_videos`;
CREATE TABLE `product_has_videos` (
  `product_id` int(11) NOT NULL,
  `video_id` int(11) DEFAULT NULL,
  KEY `video_id` (`video_id`) USING BTREE,
  CONSTRAINT `product_has_videos_ibfk_1` FOREIGN KEY (`video_id`) REFERENCES `product_videos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_has_videos"
#


#
# Structure for table "product_views"
#

DROP TABLE IF EXISTS `product_views`;
CREATE TABLE `product_views` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL DEFAULT '0',
  `views` int(11) DEFAULT NULL COMMENT '浏览数（万）',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_views"
#

INSERT INTO `product_views` VALUES (1,49,5000,'2019-03-30 14:38:44','2019-03-30 14:38:44'),(2,54,300,'2019-04-01 18:24:56','2019-04-01 18:24:56'),(3,55,20,'2019-04-02 10:57:19','2019-04-02 10:57:19'),(4,57,200,'2019-04-02 11:57:51','2019-04-02 11:57:51'),(5,94,78454,'2019-04-08 21:07:00','2019-04-08 21:07:00'),(6,95,500,'2019-04-09 11:59:48','2019-04-09 11:59:48'),(7,98,200,'2019-04-09 13:36:16','2019-04-09 13:36:16'),(8,99,2300,'2019-04-09 13:36:56','2019-04-09 13:36:56'),(9,100,300,'2019-04-09 13:37:23','2019-04-09 13:37:23'),(10,123,15,'2019-04-14 16:15:47','2019-04-14 16:15:47'),(11,124,52,'2019-04-16 13:56:29','2019-04-16 13:56:29'),(12,217,30,'2019-04-17 10:40:15','2019-04-17 10:40:15'),(13,235,1111,'2019-04-30 20:19:49','2019-04-30 20:19:49');

#
# Structure for table "product_websites"
#

DROP TABLE IF EXISTS `product_websites`;
CREATE TABLE `product_websites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_websites"
#

INSERT INTO `product_websites` VALUES (1,'门户',0,NULL,'2018-12-31 02:19:42','2018-12-31 02:19:42'),(2,'垂直行业',0,NULL,'2018-12-31 02:19:42','2018-12-31 02:19:42'),(3,'新闻客户端',0,NULL,'2018-12-31 02:19:42','2018-12-31 02:19:42');

#
# Structure for table "product_has_websites"
#

DROP TABLE IF EXISTS `product_has_websites`;
CREATE TABLE `product_has_websites` (
  `product_id` int(11) NOT NULL DEFAULT '0',
  `website_id` int(11) DEFAULT NULL,
  KEY `website_id` (`website_id`) USING BTREE,
  CONSTRAINT `product_has_websites_ibfk_1` FOREIGN KEY (`website_id`) REFERENCES `product_websites` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_has_websites"
#


#
# Structure for table "product_zimeiti_channels"
#

DROP TABLE IF EXISTS `product_zimeiti_channels`;
CREATE TABLE `product_zimeiti_channels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4;

#
# Data for table "product_zimeiti_channels"
#

INSERT INTO `product_zimeiti_channels` VALUES (1,'百家号',0,'2019-03-27 14:57:35','2019-03-29 10:51:23',NULL),(2,'今日头条',0,'2019-03-29 10:51:23','2019-03-29 10:51:23',NULL),(3,'东方头条',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(4,'搜狐网',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(5,'新浪网',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(6,'网易号',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(7,'一点资讯',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(8,'UC头条',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(9,'腾讯号',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(10,'凤凰号',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(11,'知乎号',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(12,'豆瓣',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(13,'简书',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(14,'东方财富号',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(15,'中金在线号',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL),(16,'趣头条',NULL,'2019-04-11 14:36:50','2019-04-11 14:36:50',NULL);

#
# Structure for table "products"
#

DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `market_element` json DEFAULT NULL COMMENT '营销元素:fire,money',
  `corner_id` int(11) DEFAULT '0' COMMENT '角标id',
  `slogan` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '产品摘要,',
  `rate_unit` enum('day','month','year','hour') COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate_value` double(6,3) NOT NULL DEFAULT '0.000' COMMENT '利率值',
  `repay_unit` enum('day','hour') COLLATE utf8mb4_unicode_ci NOT NULL,
  `repay_min` int(11) NOT NULL DEFAULT '0',
  `repay_max` int(11) NOT NULL DEFAULT '0',
  `quota_min` int(11) NOT NULL DEFAULT '0',
  `quota_max` int(11) NOT NULL DEFAULT '0',
  `fast_lend_unit` enum('minute','hour','day') COLLATE utf8mb4_unicode_ci NOT NULL,
  `fast_lend_value` int(11) DEFAULT '0',
  `fast_lend_sort` int(11) NOT NULL DEFAULT '0',
  `success_rate` int(11) DEFAULT '100' COMMENT '成功率',
  `redirect_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `platform` json DEFAULT NULL COMMENT '上线平台',
  `apply_condition` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '申请条件',
  `auto_down_sale_num` int(11) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态:0=>下架,1=>上架',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `base_apply_num` int(11) NOT NULL DEFAULT '0',
  `guess_like` json DEFAULT NULL COMMENT ':product,article',
  `deal_type` enum('cpa','cps') COLLATE utf8mb4_unicode_ci NOT NULL,
  `deal_price` decimal(6,2) NOT NULL DEFAULT '0.00' COMMENT '结算单价',
  `first_onsale_at` datetime NOT NULL COMMENT '初次上架时间',
  `district_limit` text COLLATE utf8mb4_unicode_ci COMMENT '方便回显,纯文本',
  `district_code` text COLLATE utf8mb4_unicode_ci COMMENT '产品限制地区前端编码',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_from` varchar(20) CHARACTER SET utf8mb4 DEFAULT 'platform' COMMENT ' 平台：platform,媒体主：media,云资源：cloud',
  `member_id` int(11) DEFAULT NULL COMMENT '媒体主ID',
  `is_agent` tinyint(1) DEFAULT '1' COMMENT '是否允许代理：1是0否',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "products"
#


#
# Structure for table "product_has_platforms"
#

DROP TABLE IF EXISTS `product_has_platforms`;
CREATE TABLE `product_has_platforms` (
  `product_id` int(10) unsigned NOT NULL,
  `platform` enum('android','ios','wap','pc') COLLATE utf8mb4_unicode_ci NOT NULL,
  KEY `product_has_platforms_product_id_foreign` (`product_id`) USING BTREE,
  CONSTRAINT `product_has_platforms_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_has_platforms"
#


#
# Structure for table "product_has_collections"
#

DROP TABLE IF EXISTS `product_has_collections`;
CREATE TABLE `product_has_collections` (
  `product_id` int(10) unsigned NOT NULL,
  `collection_id` int(11) NOT NULL DEFAULT '0',
  KEY `product_has_collections_product_id_foreign` (`product_id`) USING BTREE,
  CONSTRAINT `product_has_collections_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "product_has_collections"
#


#
# Structure for table "reduce_records"
#

DROP TABLE IF EXISTS `reduce_records`;
CREATE TABLE `reduce_records` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channel_reduce_id` int(11) NOT NULL,
  `reduce_type` enum('register','apply_register') COLLATE utf8mb4_unicode_ci NOT NULL,
  `reduce_rate` int(11) NOT NULL,
  `reduce_status` tinyint(4) NOT NULL,
  `effect_start` datetime DEFAULT NULL,
  `effect_end` datetime DEFAULT NULL,
  `effect_on` datetime DEFAULT NULL,
  `mark` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `before_modify` int(11) NOT NULL,
  `after_modify` int(11) NOT NULL,
  `modifier_id` int(11) NOT NULL,
  `modifier_name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "reduce_records"
#


#
# Structure for table "report_categories"
#

DROP TABLE IF EXISTS `report_categories`;
CREATE TABLE `report_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '分类名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "report_categories"
#

INSERT INTO `report_categories` VALUES (1,'资源不真实',0,'2019-02-22 12:48:32','2019-02-22 12:48:32');

#
# Structure for table "reports"
#

DROP TABLE IF EXISTS `reports`;
CREATE TABLE `reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `mid` int(11) DEFAULT NULL COMMENT '用户id',
  `phone` varchar(20) DEFAULT NULL,
  `content` text COMMENT '举报内容',
  `category_id` int(11) DEFAULT NULL COMMENT '举报类型',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1' COMMENT '状态：1待处理2已处理',
  `deal_uid` int(11) DEFAULT NULL COMMENT '处理人',
  `deal_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `deal_content` varchar(255) DEFAULT NULL COMMENT '处理意见',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "reports"
#


#
# Structure for table "roles"
#

DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('admin','channel') COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_invisible` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据脱敏:0=>不脱敏,1=>脱敏',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "roles"
#

INSERT INTO `roles` VALUES (1,'root','web','超级管理员','admin',0,'2019-03-19 06:19:04','2019-03-19 06:19:04'),(2,'business','web','商务','admin',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(3,'assessor','web','审核员','admin',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(4,'channel','web','渠道专员','channel',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(5,'editor','web','编辑人员','admin',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(6,'admin','web','管理员','admin',0,'2019-03-19 06:19:13','2019-03-19 06:19:13'),(7,'代理','web','代理','channel',0,'2019-03-20 04:09:52','2019-03-20 04:09:52');

#
# Structure for table "role_has_permissions"
#

DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`) USING BTREE,
  KEY `role_has_permissions_role_id_foreign` (`role_id`) USING BTREE,
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "role_has_permissions"
#

INSERT INTO `role_has_permissions` VALUES (1,1),(1,6),(2,1),(2,6),(3,1),(3,6),(4,1),(4,6),(5,1),(5,6),(6,1),(6,6),(7,1),(7,6),(8,1),(8,6),(9,1),(9,6),(10,1),(10,6),(11,1),(11,6),(12,1),(12,6),(13,1),(13,6),(14,1),(14,6),(15,1),(15,6),(16,1),(16,6),(17,1),(17,6),(18,1),(18,6),(20,1),(20,6),(23,1),(23,6),(24,1),(24,6),(25,1),(25,6),(26,1),(26,6),(27,1),(27,6),(28,1),(28,6),(30,1),(30,6),(31,1),(31,6),(32,1),(32,6),(33,1),(33,6),(34,1),(34,6),(35,1),(35,6),(36,1),(36,6),(37,1),(37,6),(38,1),(38,6),(39,1),(39,6),(40,1),(40,6),(41,1),(41,6),(42,1),(42,6),(43,1),(43,6),(44,1),(44,6),(45,1),(45,6),(46,1),(46,6),(47,1),(47,6),(48,1),(48,6),(49,1),(49,6),(50,1),(50,6),(51,1),(51,6),(52,1),(52,6),(53,1),(53,6),(54,1),(54,6),(55,1),(55,6),(56,1),(56,6),(57,1),(57,6),(58,1),(58,6),(59,1),(59,6),(60,1),(60,6),(61,1),(61,6),(62,1),(62,6),(63,1),(63,6),(64,1),(64,6),(65,1),(65,6),(66,1),(66,6),(83,1),(83,6),(90,1),(90,6),(91,1),(91,6),(92,1),(92,6),(93,1),(93,6),(94,1),(94,6),(95,1),(95,6),(119,1),(119,6),(120,1),(120,6),(121,1),(121,6),(122,1),(122,6),(123,1),(123,6),(124,1),(124,6),(125,1),(125,6),(126,1),(126,6),(127,1),(127,6),(128,1),(128,6),(129,1),(129,6),(130,1),(135,1),(136,1),(137,1);

#
# Structure for table "model_has_roles"
#

DROP TABLE IF EXISTS `model_has_roles`;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`) USING BTREE,
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`) USING BTREE,
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "model_has_roles"
#

INSERT INTO `model_has_roles` VALUES (1,'App\\Models\\User',1),(1,'App\\Models\\User',2),(1,'App\\Models\\User',3),(1,'App\\Models\\User',4),(1,'App\\Models\\User',5),(1,'App\\Models\\User',6),(1,'App\\Models\\User',7);

#
# Structure for table "send_code"
#

DROP TABLE IF EXISTS `send_code`;
CREATE TABLE `send_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL,
  `code` varchar(255) DEFAULT NULL COMMENT '验证码',
  `status` tinyint(2) DEFAULT '0' COMMENT '状态:0发送中，1成功，2失败',
  `type` tinyint(2) unsigned DEFAULT '1' COMMENT '类型：1注册，2登录，3找回密码，4快捷登录，5绑定验证',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "send_code"
#


#
# Structure for table "setting_level_options"
#

DROP TABLE IF EXISTS `setting_level_options`;
CREATE TABLE `setting_level_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `mark` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "setting_level_options"
#


#
# Structure for table "setting_managers"
#

DROP TABLE IF EXISTS `setting_managers`;
CREATE TABLE `setting_managers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '媒介经理',
  `type` tinyint(2) NOT NULL COMMENT '类型：1广告主，2媒体主',
  `phone` varchar(20) DEFAULT NULL COMMENT '联系手机',
  `email` varchar(255) DEFAULT NULL COMMENT '邮箱',
  `qq` varchar(20) DEFAULT NULL COMMENT 'qq',
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

#
# Data for table "setting_managers"
#

INSERT INTO `setting_managers` VALUES (1,'OEM',1,'13012345678','123456@yahu.com','123456','2019-05-13 14:54:04','2019-05-13 14:54:04'),(2,'OEM',2,'13012345678','123456@yahu.com','123456','2019-05-13 14:54:06','2019-05-13 14:54:06');

#
# Structure for table "setting_member_levels"
#

DROP TABLE IF EXISTS `setting_member_levels`;
CREATE TABLE `setting_member_levels` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '名称',
  `type` tinyint(2) unsigned NOT NULL COMMENT '类型：1单笔，2累计',
  `category` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

#
# Data for table "setting_member_levels"
#

INSERT INTO `setting_member_levels` VALUES (1,'用户等级计算',1,'1,6','2019-03-30 11:59:29','2019-03-30 11:56:29');

#
# Structure for table "sms_records"
#

DROP TABLE IF EXISTS `sms_records`;
CREATE TABLE `sms_records` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '手机号',
  `captcha` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '验证码',
  `content` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `channel_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `platform` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'pc',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "sms_records"
#


#
# Structure for table "sms_settings"
#

DROP TABLE IF EXISTS `sms_settings`;
CREATE TABLE `sms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL COMMENT '姓名',
  `phone` varchar(20) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `appkey` varchar(255) DEFAULT NULL,
  `appsecret` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL COMMENT '短信签名',
  `status` tinyint(1) DEFAULT NULL COMMENT '1启用2禁用',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# Data for table "sms_settings"
#


#
# Structure for table "system_message_backs"
#

DROP TABLE IF EXISTS `system_message_backs`;
CREATE TABLE `system_message_backs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '消息标题',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '消息内容',
  `message_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '消息类型|system|feedback_reply|comment_reply',
  `send_user_type` tinyint(4) NOT NULL DEFAULT '2' COMMENT '发送对象类型|2全部注册用户|3指定用户',
  `numbers` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '接收号码',
  `object_id` int(11) NOT NULL COMMENT '消息id',
  `send_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '发送时间|1即时|2自定义',
  `send_at` datetime DEFAULT NULL COMMENT '自定义发送时间',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "system_message_backs"
#


#
# Structure for table "system_message_clicks"
#

DROP TABLE IF EXISTS `system_message_clicks`;
CREATE TABLE `system_message_clicks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `system_id` int(11) NOT NULL COMMENT '系统消息id',
  `mid` int(11) NOT NULL COMMENT '用户id',
  `is_read` tinyint(4) NOT NULL DEFAULT '0' COMMENT '消息已读状态',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "system_message_clicks"
#


#
# Structure for table "token_devices"
#

DROP TABLE IF EXISTS `token_devices`;
CREATE TABLE `token_devices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `identifier` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '操作设备码',
  `platform` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '平台',
  `system` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '操作系统版本',
  `version` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'App版本',
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'token',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "token_devices"
#


#
# Structure for table "user_model_snapshots"
#

DROP TABLE IF EXISTS `user_model_snapshots`;
CREATE TABLE `user_model_snapshots` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_model_id` int(11) NOT NULL DEFAULT '0' COMMENT '模型id',
  `refresh_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '刷新类型:1=>新增模型,2=>修改模型规则,3=>列表刷新按钮,4=>凌晨3点定时器',
  `client_user_ids` json NOT NULL COMMENT '用户id合集',
  `client_user_num` int(11) NOT NULL DEFAULT '0' COMMENT '当前快照总用户数',
  `config` json NOT NULL COMMENT '当前快照的条件配置',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "user_model_snapshots"
#


#
# Structure for table "users"
#

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '登录名',
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '密码',
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '电话',
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '显示名称',
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '头像',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'uuid',
  `role_slug` enum('admin','channel') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '角色类型',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态:0=>禁用,1=>启用',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `users_username_unique` (`username`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "users"
#

INSERT INTO `users` VALUES (1,'admin','$2y$10$kDOiYKJD4RdMh4S5r1Xp7umsTlqyIGXSgOUGOJEOn/xrg4atgIjqW','13900000000','admin@admin.com','超级管理员','','auIuTZMp553yhVj491OQwajazgUPWR3x2cqTZ8KERWOppsXKVwgGL6jaVJ3m','04c7fff0-7763-3332-a8cf-f7197d8f1216','admin',1,'2019-03-19 06:19:04','2019-03-19 06:19:04',NULL);

#
# Structure for table "virtual_comments"
#

DROP TABLE IF EXISTS `virtual_comments`;
CREATE TABLE `virtual_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '回复内容',
  `star` double(3,1) NOT NULL DEFAULT '5.0' COMMENT '评分',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "virtual_comments"
#


#
# Structure for table "virtual_phones"
#

DROP TABLE IF EXISTS `virtual_phones`;
CREATE TABLE `virtual_phones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '虚拟号码',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "virtual_phones"
#

INSERT INTO `virtual_phones` VALUES (1,'17300810082','2019-03-23 03:24:56','2019-03-23 03:24:56'),(2,'17300810083','2019-03-23 03:24:56','2019-03-23 03:24:56'),(3,'17300810084','2019-03-23 03:24:56','2019-03-23 03:24:56'),(4,'17300810085','2019-03-23 03:24:56','2019-03-23 03:24:56'),(5,'17300810086','2019-03-23 03:24:56','2019-03-23 03:24:56'),(6,'17300810087','2019-03-23 03:24:56','2019-03-23 03:24:56'),(7,'17300810088','2019-03-23 03:24:56','2019-03-23 03:24:56'),(8,'17300810089','2019-03-23 03:24:56','2019-03-23 03:24:56'),(9,'17300810090','2019-03-23 03:24:56','2019-03-23 03:24:56'),(10,'17300810091','2019-03-23 03:24:56','2019-03-23 03:24:56'),(11,'17300810092','2019-03-23 03:24:56','2019-03-23 03:24:56'),(12,'17300810093','2019-03-23 03:24:56','2019-03-23 03:24:56'),(13,'17300810094','2019-03-23 03:24:56','2019-03-23 03:24:56'),(14,'17300810095','2019-03-23 03:24:56','2019-03-23 03:24:56'),(15,'17300810096','2019-03-23 03:24:56','2019-03-23 03:24:56'),(16,'17300810097','2019-03-23 03:24:56','2019-03-23 03:24:56'),(17,'17300810098','2019-03-23 03:24:56','2019-03-23 03:24:56'),(18,'17300810099','2019-03-23 03:24:56','2019-03-23 03:24:56'),(19,'17300810100','2019-03-23 03:24:56','2019-03-23 03:24:56'),(20,'17300810101','2019-03-23 03:24:56','2019-03-23 03:24:56'),(21,'17300810102','2019-03-23 03:24:56','2019-03-23 03:24:56'),(22,'17300810103','2019-03-23 03:24:56','2019-03-23 03:24:56'),(23,'17300810104','2019-03-23 03:24:56','2019-03-23 03:24:56'),(24,'17300810105','2019-03-23 03:24:56','2019-03-23 03:24:56'),(25,'17300810106','2019-03-23 03:24:56','2019-03-23 03:24:56'),(26,'17300810107','2019-03-23 03:24:56','2019-03-23 03:24:56'),(27,'17300810108','2019-03-23 03:24:56','2019-03-23 03:24:56');

#
# Structure for table "websites"
#

DROP TABLE IF EXISTS `websites`;
CREATE TABLE `websites` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '公司名称',
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '电话',
  `record_num` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '备案号',
  `base_loan` int(11) NOT NULL DEFAULT '0' COMMENT '累计借款基数',
  `base_today_loan` int(11) NOT NULL DEFAULT '0' COMMENT '今日借款基数',
  `qrcode_weixin` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '微信二维码图片地址',
  `qrcode_app` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'app二维码图片地址',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `qq` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '客服电话',
  `manager` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '媒介经理',
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'seo关键字',
  `introduce` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '网站描述',
  `oemid` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_secret` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_type` enum('pay','qrcode') COLLATE utf8mb4_unicode_ci DEFAULT 'qrcode' COMMENT '支付方式',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# Data for table "websites"
#

INSERT INTO `websites` VALUES (1,'oem','028 8888 8888','****',1,1,'/images/file/CScUCPNWLCNiUF9WToYJP93RRgLe5YYVEljBPjtz.png','','2019-05-08 14:07:03','2019-05-08 14:07:03',NULL,NULL,NULL,'1','1',NULL,NULL,NULL,'qrcode');
