// reg = 2
// reset = 16

//====================================================
//      用户注册之后及登录之后 设置LOCALSTORAGE
//====================================================
var _SLS_ = _SLS_ || {};
_SLS_ = (function(){
	return {
		init : function(obj){
			// y-z-m.c-r
			// 向缓存内写入flagData
			localStorage.setItem(
				'flagData'
				,JSON.stringify({
					// 登录类型 - 注册-REG|登录-LOGIN
					type : obj.type || ''
					// 账单充值记录
					,recharge : obj.recharge || 0
					// 登录后 - 用户资料 - 初始默认已完善资料
					,userInfo : 1
					// 登录后 - 新手指引-弹出层 - 初始不显示
					,novice : 0
					// 登录后 - 新手指引关闭点击为 - 初始为0
					,noviceCloseClick : 0
					// 登录后 - 图片广告-弹出层 - 初始显示
					,popSsImg : obj.popSsImg || 1
					// 登录后 - 图片广告关闭点击为 - 1为还未关闭可以点击 0为已点击关闭过
					,popSsImgCloseClick : 1
					// 登录后 - 优惠券列表
					,couponList : obj.couponList || []
					// 登录后 - 优惠券-弹出层 - 初始不显示
					,coupon : 0
					// 登录后 - 充值次数 0为未充值过 1为首次充值 2为多次充值
					,rechargeCount : 0
					// 登录后 - 用以判断首充成功后派发优惠券 1为派发 0为不派发 默认为1派发
					,couponAddF : 1
					// 登录后 - 用以判断单次充成功后派发优惠券 1为派发 0为不派发 默认为1派发
					,couponAddS : 1
				})
			);
		}
	}
})();








//====================================================
//              用户公共模块
//====================================================
var _LRF_ = _LRF_ || {};
_LRF_ = (function(){
	return {
		// 验证码方式 1图片验证码 2极验验证码 3螺丝帽人机验证
		yzmType : 0
		,userRLFqq : '<em class="qq"><a href="http://wpa.b.qq.com/cgi/wpa.php?ln=2&amp;uin=4008160560" target="_blank"></a></em>'
		,userType : getUrlRequest('userType') || ''
		,inputBlur : $('input.blur')
		,typeChose : $('.typeChose')
		,typeChoseSpan : $('.typeChose').find('span')
		,con : $('.userRegLoginContain').find('.con')
		,asTxt : $('.txts.asTxt')
		,formEx : $('.userRegLoginContain').find('.userRegLoginform.ex')
		,formEd : $('.userRegLoginContain').find('.userRegLoginform.ed')
		,userData : {}
		,imgCode : $('img.imgCode')
		,smsTime : 90
		,geetest_challenge : ''
		,geetest_validate : ''
		,geetest_seccode : ''

		,init : function(){
			// 获取用户数据
			this.getUserData();
			// 获取用户类型
			this.getUserType();
			// typeChoseBtn点击事件
			$(document).on('click','.typeChose span',this.typeChoseBtnClick);
			// 登录框显示
			this.userRegLoginContainShow();
			// 失焦校验
			this.inputBlur.on('blur',this.inputBlurCheck);
			// 图形验证码点击事件
			this.imgCode.on('click',this.imgCodeClick);
		}

		// 获取用户数据
		,getUserData : function(){
			this.userDataStr = localStorage.USRINFO || '';
			// 如果缓存中有userData 并且 不为空对象
			if(this.userDataStr && JSON.stringify(this.userDataStr) != '{}'){
				// 生成userData
				this.userData = JSON.parse(this.userDataStr);
				// 渲染登录后界面
				this.renderFormEd();
			}
		}
		// 渲染登录后界面
		,renderFormEd : function(){
			// 渲染名字
			this.formEd.find('.theUserName').html(this.userData.data.companyNm || this.userData.data.nickname);
			// 渲染头像
			if(this.userData.data.img){
				this.formEd.find('.theUserTx').attr('src', this.userData.data.img);
			}
		}
		// 获取用户类型userType
		,getUserType : function(){
			this.typeChose.find('span').removeClass('active');
			if(this.userType){
				if(this.userType == 1){this.userTypen = 'website'}
				else if(this.userType == 2){this.userTypen = 'company'}
				this.typeChose.find('span[data-value="'+this.userType+'"]').addClass('active');
			}else{
				this.typeChose.find('span.company').addClass('active');
				this.typeChose.find('span').each(function(){
					if($(this).hasClass('active')){
						_LRF_.userType = $(this).data('value');
						_LRF_.userTypen = $(this).data('valuen');
					}
				});
			}
			$('.txts.asTxt').addClass('hide');
			$('.txts.asTxt.' + this.userTypen).removeClass('hide');
		}
		// typeChoseBtn点击事件 - userType选择事件
		,typeChoseBtnClick : function(){
			var btn = $(this);
			if(btn.hasClass('disabled')) return;

			btn.addClass('active').siblings().removeClass('active');
			_LRF_.userType = btn.data('value');
			_LRF_.userTypen = btn.data('valuen');
			$('.txts.asTxt').addClass('hide');
			$('.txts.asTxt.'+_LRF_.userTypen).removeClass('hide');
			// if(yzmType == 2){_L_.geetestImgCode()}
			// else if(yzmType == 3){LUOCAPTCHA.reset()}
		}

		// 登录框显示
		,userRegLoginContainShow : function(){
			$('.userRegLoginContain').removeClass('hide');
		}

		,tipsError: function(input,tips){
			input.addClass('error');
			input.next('.tip').addClass('error');
			input.next('.tip').children('font').html(tips);
		}
		,tipsOk: function(input){
			input.removeClass('error');
			input.next('.tip').removeClass('error');
			input.next('.tip').children('font').html('');
		}

		//失焦校验
		,inputBlurCheck : function(){
			var input = $(this), value = input.val() || '';
			//----- 校验登录用户名 -----
			if(input.hasClass('loginName')){
				if(!value){_LRF_.tipsOk(input)}
				else{
					if(reg.num.test(value)){
						if(!reg.mobile.test(value)){_LRF_.tipsError(input,'请输入正确的手机号码')}
						else{_LRF_.tipsOk(input)}
					}else{
						if(!reg.email.test(value)){_LRF_.tipsError(input,'请输入正确的邮箱地址')}
						else{_LRF_.tipsOk(input)}
					}
				}
			}

			//----- 校验手机号 -----
			if(input.hasClass('mobile')){
				if(!value){_LRF_.tipsError(input,'请输入手机号码')}
				else if(!reg.mobile.test(value)){_LRF_.tipsError(input,'请输入正确的手机号码')}
				else{_LRF_.tipsOk(input)}
			}

			//----- 校验短信验证码 -----
			if(input.hasClass('smsCode')){
				if(!value){_LRF_.tipsError(input,'请输入短信验证码')}
				else{_LRF_.tipsOk(input)}
			}
			//----- 校验图形验证码 -----
			if(input.hasClass('yzmCode')){
				if(!value){_LRF_.tipsError(input, '请输入图形验证码')}
				else if(!reg.num.test(value) || value.length != 4){_LRF_.tipsError(input, '请正确输入图形验证码')}
				else{_LRF_.tipsOk(input)}
			}
			//----- 校验密码 -----
			if(input.hasClass('password')){
				if(!value){_LRF_.tipsError(input, '请输入密码')}
				else if(value.length < 6 || value.length > 20){_LRF_.tipsError(input, '密码长度在6~20位之间')}
				else{_LRF_.tipsOk(input)}
			}
			//----- 校验密码1 -----
			if(input.hasClass('password1')){
				if(!value){_LRF_.tipsError(input, '请输入新的登陆密码')}
				else if(value.length < 6 || value.length > 20){_LRF_.tipsError(input, '密码长度在6~20位之间')}
				else{_LRF_.tipsOk(input)}
			}
			//----- 校验密码2 -----
			if(input.hasClass('password2')){
				var password1 = $('input[type="password"].password1').val();
				if(!value){_LRF_.tipsError(input, '请输入确认密码')}
				else if(value != password1){_LRF_.tipsError(input, '两次输入密码不一致')}
				else{_LRF_.tipsOk(input)}
			}
		}
		,judgeYzmShow: function(callback){
			var judgeType = /index|login|(^\/$)/i.test(location.pathname) ? 'login' : 'sms';
			var param = {theUrl: api.user.isOverflow, theData: {type: judgeType}};
			doPostAjax(param,function(data){
				if(data.success == 'true'){
					// 需要开启验证
					_LRF_.yzmType = 3;
				}
				_LRF_.yzmTypeShow();
				callback();
			});
		}
		// 验证方式显示
		,yzmTypeShow : function(){
			$('.yzmType').addClass('hide');
			if(_LRF_.yzmType == 1){$('.yzmType.img').removeClass('hide')}
			else if(_LRF_.yzmType == 2){$('.yzmType.geet').removeClass('hide')}
			else if(_LRF_.yzmType == 3){$('.yzmType.luosimao').removeClass('hide')}
		}
		// 图形验证码点击事件
		,imgCodeClick : function(){_LRF_.imgCodeChange()}
		,imgCodeChange : function(){
			var src = '/imgCode.html?'+Math.random();
			$('img.imgCode').attr('src',src);
		}

		,smsBlueGetBtnToGray : function(){
			$('.getyzm').find('.sms.get').removeClass('blue').addClass('disabled');
			this.smsTimeDown();
		}
		,smsTimeDown : function(){
			this.smsTime--;
			if(this.smsTime > 0){
				$('.getyzm').find('.sms.get').html(this.smsTime + '秒后重新发送');
				setTimeout(function(){_LRF_.smsTimeDown()},1000);
			}else{
				$('.getyzm').find('.sms.get').addClass('blue').removeClass('disabled').html('获取验证码');
				this.smsTime = 90;
			}
		}
	};
})();






//====================================================
//              用户登录模块
//====================================================
var _L_ = _L_ || {};
_L_ = (function(){
	return {
		loginBtn : $('.loginBtn.orange')
		,regFree : $('.regFree')
		,goPageBtn : $('.btn.red.goPage')
		,eye : $('.eye')
		,device : 'web'
		,popCloseBtn : $('.popMid').find('.close')
		,yzmRedSendBtn : $('.btn.red.yzm.send')

		,init : function(){
			// 判断用户是否登录
			this.userIsLogin();
			// 眼睛鼠标移入移出事件
			this.eye.on('mouseover',this.eyeHover).on('mouseout',this.eyeOut);
			// 登录按钮点击事件
			this.loginBtn.on('click',this.loginBtnClick);
			// 免费注册按钮点击事件
			this.regFree.on('click',this.regFreeClick);
			// 进入广告主|媒介主按钮点击事件
			this.goPageBtn.on('click',this.goPageBtnClick);
			// 弹出层关闭按钮点击事件
			this.popCloseBtn.on('click',this.popCloseBtnClick);
			// 弹出层确定按钮点击事件
			this.yzmRedSendBtn.on('click',this.yzmRedSendBtnClick);
			// 按回车键
			$(document).on('keydown',this.documentKeydown);
			// 忘记密码点击事件
			$('.forgetPass').on('click',this.forgetPassClick);
		}

		//判断用户是否登录
		,userIsLogin : function(){
			var ut = localStorage.userType;
			// 如果已登录
			if(ut > 0){
				_LRF_.formEx.addClass('hide');
				_LRF_.formEd.removeClass('hide');
				_LRF_.typeChose.children('span').removeClass('active').addClass('disabled');
				_LRF_.typeChose.children('span[data-value="'+ut+'"]').addClass('active');
				_LRF_.userType = ut;
				if(ut == 1){_LRF_.userTypen = 'website'}
				else if(ut == 2){_LRF_.userTypen = 'company'}

				var zhu = ut == 1 ? '媒介主' : '广告主';
				this.goPageBtn.html('进入'+zhu+'平台');
			}
			// 如果未登录
			else{
				_LRF_.formEx.removeClass('hide');
				_LRF_.formEd.addClass('hide');
			}
		}

		// 眼睛鼠标移入移出事件
		,eyeHover : function(){$(this).next('input').prop('type','text')}
		,eyeOut : function(){$(this).next('input').prop('type','password')}

		// 简单验证
		,simplenessVerify : function(){
			//----------校验登录名----------
			var loginNameInput = $('input[type="text"].loginName'), loginNameInput_val = loginNameInput.val() || '';
			if(!loginNameInput_val){return 0}
			else{
				if(reg.num.test(loginNameInput_val)){
					if(!reg.mobile.test(loginNameInput_val)){
						_LRF_.tipsError(loginNameInput,'请输入正确的手机号码');
						return 0;
					}
				}else{
					if(!reg.email.test(loginNameInput_val)){
						_LRF_.tipsError(loginNameInput,'请输入正确的邮箱地址');
						return 0;
					}
				}
			}
			//----------校验密码----------
			var passwordInput = $('input.password'), passwordInput_val = passwordInput.val() || '';
			if(!passwordInput_val){return 0}
			return 1;
		}

		//--------------------------------
		//      登录按钮点击事件
		//--------------------------------
		,loginBtnClick : function(){
			var btn = $(this);
			//----------校验登录名----------
			var loginNameInput = $('input[type="text"].loginName'), loginNameInput_val = loginNameInput.val() || '';
			_L_.loginType = '';
			_L_.loginName = '';
			if(!loginNameInput_val){_LRF_.tipsError(loginNameInput,'请输入登录名'); return}
			else{
				if(reg.num.test(loginNameInput_val)){
					if(!reg.mobile.test(loginNameInput_val)){_LRF_.tipsError(loginNameInput, '请输入正确的手机号码'); return}
					_L_.loginType = 'mobile';
				}
				else{
					if(!reg.email.test(loginNameInput_val)){_LRF_.tipsError(loginNameInput, '请输入正确的邮箱地址'); return}
					_L_.loginType = 'email';
				}
				_L_.loginName = loginNameInput_val;
			}

			//----------校验密码----------
			var passwordInput = $("input.password"), passwordInput_val = passwordInput.val() || '';
			_L_.pwd = '';
			if(!passwordInput_val){_LRF_.tipsError(passwordInput,'请输入密码'); return}
			_L_.pwd = $.md5(passwordInput_val);

			//----------校验图形验证码----------
			// 判断是否开启验证
			_LRF_.judgeYzmShow(function(){
				// 验证码Type为1时候校验图形验证码
				if(_LRF_.yzmType == 1){
					var yzmCodeInput = $('input.yzmCode'), yzmCodeInput_val = yzmCodeInput.val() || '';
					_L_.yzmCode = '';
					if(!yzmCodeInput_val){_LRF_.tipsError(yzmCodeInput,'请输入验证码'); return}
					_L_.yzmCode = yzmCodeInput_val;
				}
				// 验证码Type为2时候极验验证码
				else if(_LRF_.yzmType == 2){
					var result = captchaObjData.getValidate(), geetBox = $('.geetBox');
					if(!result){_LRF_.tipsError(geetBox,'请先完成验证'); return}
					_LRF_.geetest_challenge = result.geetest_challenge;
					_LRF_.geetest_validate = result.geetest_validate;
					_LRF_.geetest_seccode = result.geetest_seccode;
				}
				// 验证码Type为3时螺丝帽验证
				else if(_LRF_.yzmType == 3){
					$('.popMid.popImgYzm').show();
					var result = $('input[name="luotest_response"]').val(), luosimaoBox = $('.luosimaoBox');
					if(!result){
						// _LRF_.tipsError(luosimaoBox,'请先完成验证');
						return;
					}
				}
				// 构造数据
				_L_.createUserLoginData();
				// 用户登录
				_L_.userLogin();
			});
		}

		// 构造数据
		,createUserLoginData : function(){
			this.loginData = {};
			this.loginData.device = this.device;
			this.loginData.userType = _LRF_.userType;
			this.loginData.loginType = this.loginType;
			this.loginData.loginName = this.loginName;
			this.loginData.pwd = this.pwd;
			this.loginData.referer = document.referrer;
			
			if(_LRF_.yzmType == 0) this.loginData.imgType = 'luosimao';
			if(_LRF_.yzmType == 1){
				this.loginData.code = this.yzmCode;
			}else if(_LRF_.yzmType == 2){
				this.loginData.imgType = this.imgType;
				this.loginData.geetest_challenge = _LRF_.geetest_challenge;
				this.loginData.geetest_validate = _LRF_.geetest_validate;
				this.loginData.geetest_seccode = _LRF_.geetest_seccode;
			}else if(_LRF_.yzmType == 3){
				this.loginData.imgType = 'luosimao';
				this.loginData.code = $('input[name="luotest_response"]').val();
			}
		}
		// 用户登录
		,userLogin : function(){
			var param = {theUrl: api.user.login, theData: this.loginData};
			doPostAjax(param,this.userLoginFn);
		}

		//------------------------------------
		//      用户登录成功后的跳转相关
		//------------------------------------
		,userLoginFn : function(data){
			if(data.success == 'true'){
				var referer = data.referer;
				// 如果是广告主
				if(_LRF_.userType == 2){
					// 添加优惠券
					_L_.couponAdd();
				}
				// 如果是媒介主
				else if(_LRF_.userType == 1){
					// 向缓存内写入flagData
					_SLS_.init({type : 'LOGIN'});
					localStorage.setItem('theflag',1);
					localStorage.setItem('logined',1);
					location.href = '/websiteHome/userProfilePg.html';
				}
			}
			else{
				if(_LRF_.yzmType == 1){}
				else if(_LRF_.yzmType == 2){_L_.geetestImgCode()}
				else if(_LRF_.yzmType == 3){LUOCAPTCHA.reset()}

				var input = '', tips = '';
				if(data.msg == '短信验证码失效'){input = $('input.smsCode'); tips = '短信验证码失效'}
				else if(data.msg == '短信验证码不正确'){input = $('input.smsCode'); tips = '短信验证码不正确'}
				else if(data.msg == '图形验证码错误'){input = $('input.yzmCode'); tips = '图形验证码错误'; _LRF_.imgCodeChange()}
				else if(data.msg == '密码错误'){input = $('input.password'); tips = '密码错误'}
				else if(data.msg == '用户不存在'){input = $('input.loginName'); tips = '用户不存在'}
				else{alert(data.msg)}

				if(input){_LRF_.tipsError(input,tips)}
			}
		}
		// 添加优惠券
		,couponAdd : function(){
			var param = {theUrl : '/companyHome/couponAddDt.json', theData : {couponRuleAction : 'LOGIN'}};
			doPostAjax(param,this.couponAddFn);
		}
		,couponAddFn : function(data){
			if(data.success == 'true'){
				_L_.couponList = data.data.list;
			}else{
				_L_.couponList = [];
			}
			// 获取账单充值记录
			_L_.getBillList();
		}
		// 获取账单充值记录
		,getBillList : function(){
			var param = {theUrl : '/companyHome/billListDt.json', theData : {page : 1, pageSize : 1, types : 1}};
			doPostAjax(param,this.getBillListFn);
		}
		,getBillListFn : function(data){
			if(data.success == 'true'){
				_L_.billList = data.data.list;
				_L_.billTotalCount = data.data.totalCount;
				_L_.judgeRechange();
			}else{
				console.log(data.msg);
			}
		}
		,judgeRechange : function(){
			var recharge = (this.billList.length || this.billTotalCount) ? 1 : 0;
			_SLS_.init({
				type : 'LOGIN'
				,popSsImg : 1
				,recharge : recharge
				,couponList : this.couponList
			});

			var refer = getUrlRequest('refer'), toUrl = decodeURIComponent(refer);
			// 跳转到原来的地址
			if(refer && /companyHome/.test(toUrl)){location.href = toUrl}
			else{location.href = '/companyHome/articleResListPg.html'}
		}

		,luosimaoGetResponse: function(resp){
			//验证成功后直接登录,统一使用广告主的按钮
			if(resp) $('.loginBtn.orange').click();
		}
		// 弹出层关闭按钮点击事件
		,popCloseBtnClick : function(){
			$(this).parents('.popMid').hide();
		}
		// 弹出层确定按钮点击事件
		,yzmRedSendBtnClick : function(){
			var result = $('input[name="luotest_response"]').val(), luosimaoBox = $('.luosimaoBox');
			if(!result){_LRF_.tipsError(luosimaoBox,'请先完成验证')}
			else{$('.close').parents('.popMid').hide()}
		}
		//免费注册按钮点击事件
		,regFreeClick : function(){location.href = '/userRegPg.html?userType='+_LRF_.userType}
		,documentKeydown : function(event){
			// keyCode=13是回车键
			if(event.keyCode == 13){_L_.loginBtn.click()}
		}
		// 忘记密码点击事件
		,forgetPassClick : function(){
			location.href = '/userPwdResetPg.html?userType='+_LRF_.userType;
		}

		// 进入广告主|媒介主按钮点击事件
		,goPageBtnClick : function(){
			if(_LRF_.userType == 2){location.href = '/companyHome/articleResListPg.html'}
			else if(_LRF_.userType == 1){location.href = '/websiteHome/userProfilePg.html'}
		}

		,geetestImgCode : function(){
			var param = {theUrl : api.geetestImgCode, theData : {imgType : _L_.imgType}};
			doPostAjax(param,this.geetestImgCodeFn);
		}
		,geetestImgCodeFn : function(data){
			var data = JSON.parse(data);
			if(data.success == 1){
				initGeetest({
					gt : data.gt
					,challenge : data.challenge
					,new_captcha : data.new_captcha // 用于宕机时表示是新验证码的宕机
					,offline : !data.success // 表示用户后台检测极验服务器是否宕机，一般不需要关注
					,product : 'popup' // 产品形式，包括：float，popup
					,width : '100%'
					// 更多配置参数请参见：http://www.geetest.com/install/sections/idx-client-sdk.html#config
				},_L_.handler2);
			}
			else{console.log('geetestImgCode-false')}
		}
		,handler2 : function(captchaObj){
			captchaObjData = captchaObj;
			$(".geetBox").html('');
			captchaObj.appendTo('.geetBox');
			captchaObj.onReady(function(){
				// $("#wait2").hide();
			});
			captchaObj.onSuccess(function(){
				var geetBox = $('.geetBox');
				_LRF_.tipsOk(geetBox);
			});
		}
	};
})();




//====================================================
//              用户注册模块
//====================================================
var _R_ = _R_ || {};
_R_ = (function(){
		// 要监控的目标的类型名称-必填
	var bdCategory = ''
		// 用户跟目标交互的行为-必填
		,bdAction = ''
		// 事件的一些额外信息-非必填
		,baidu_opt_label = ''
		// 事件的一些数值信息-非必填
		,baidu_opt_value = ''
	;

	return {
		smsBlueGetBtn : $('span.sms.get.blue')
		,smsRedSendBtn : $('.btn.red.sms.send')
		,imgCode : $('img.imgCode')
		,popImgYzm : $('.popMid.popImgYzm')
		,popCloseBtn : $('.popMid').find('.close')
		,viewPopXieyiBtn : $('.viewPopXieyi')
		,redRegBtn : $('.btn.red.regBtn')
		,type : 'reg'
		,sourceInner : getUrlRequest('source_inner') || ''
		,luosimaoTF : false
		,regBtnCheck : true

		//百度统计事件跟踪
		,baiduPush : function(){
			_hmt.push([
				'_trackEvent'
				,bdCategory
				,bdAction
				,baidu_opt_label
				,baidu_opt_value
			]);
		}

		,init : function(){
			// 保存推荐人ID
			setTimeout(function(){
				if(getUrlRequest('referId')) localStorage.setItem('referId',getUrlRequest('referId'));
			},500);

			// 判断用户是否登录
			this.userIsLogin();
			// 极验验证
			// this.geetestImgCode();
			// 获取短信验证码按钮点击事件
			this.smsBlueGetBtn.on('click',this.smsBlueGetBtnClick);
			// 查看协议按钮点击事件
			this.viewPopXieyiBtn.on('click',this.viewPopXieyiBtnClick);
			// 弹出层红色发送短信验证码按钮点击事件
			this.smsRedSendBtn.on('click',this.smsRedSendBtnClick);
			// 弹出层关闭按钮点击事件
			this.popCloseBtn.on('click',this.popCloseBtnClick);
			// 免费注册按钮点击事件
			this.redRegBtn.on('click',this.redRegBtnClick);
			// 协议CheckBox点击事件
			$('input[type="checkbox"].xyCheckBox').on('click',this.xyCheckBoxClick);
			// 马上登录按钮点击事件
			$('a.goLogin').on('click',this.goLoginBtnClick);
		}

		// 判断用户是否登录
		,userIsLogin : function(){
			if(localStorage.userType > 0) location.href = '/userLoginPg.html';
		}

		// 获取短信验证码按钮点击事件
		,smsBlueGetBtnClick : function(){
			var btn = $(this), input = _LRF_.con.find('input.mobile'), val = input.val();
			_R_.mobile = '';
			if(btn.hasClass("disabled")) return;
			if(!val){_LRF_.tipsError(input,'请输入手机号码'); return}
			else if(!reg.mobile.test(val)){_LRF_.tipsError(input,'请输入正确的手机号码'); return}
			else{
				_LRF_.tipsOk(input);
				_R_.mobile = val;
				//检查短信是否关闭
				_R_.smsConfig(input);
			}
		}
		// 检查短信是否关闭
		,smsConfig : function(input){
			var param = {theUrl: api.sms.config, theData : {type: 2}};
			doPostAjax(param,this.smsConfigFn,input);
		}
		,smsConfigFn : function(data,input){
			if(data.success == 'true'){
				_LRF_.tipsOk(input);
				// 发送短信前判断是否开启验证
				_LRF_.judgeYzmShow(function(){
					if(_LRF_.yzmType == 0){_R_.createSendSmsData(); _R_.sendSmsCode(); return}
					else if(_LRF_.yzmType == 1){}
					else if(_LRF_.yzmType == 2){_R_.geetestImgCode()}
					else if(_LRF_.yzmType == 3){LUOCAPTCHA.reset()}
					(_LRF_.yzmType == 3) && _R_.popImgYzm.show();
				});
			}
			else{_LRF_.tipsError(input, data.msg+'，请联系客服'+_LRF_.userRLFqq)}
		}

		// 查看协议按钮点击事件
		,viewPopXieyiBtnClick : function(){$('.popMid.popAgreement').show()}

		// 协议CheckBox点击事件
		,xyCheckBoxClick : function(){
			if($(this).is(':checked')){$(this).next('label').find('b').css({opacity : 1})}
			else{$(this).next('label').find('b').css({opacity : 0})}
		}

		// 马上登录按钮点击事件
		,goLoginBtnClick : function(){location.href = '/userLoginPg.html?userType='+_LRF_.userType}

		// 弹出层红色发送短信验证码按钮点击事件
		,smsRedSendBtnClick : function(){
			if(_LRF_.yzmType == 1){
				var input = $('input.yzmCode'), val = input.val();
				_R_.code = '';
				if(!val){_LRF_.tipsError(input,'请输入图形验证码'); return}
				else if(!reg.num.test(val) || val.length != 4){_LRF_.tipsError(input,'请正确输入图形验证码'); return}
				_LRF_.tipsOk(input);
				_R_.code = val;
			}
			else if(_LRF_.yzmType == 2){
				var result = captchaObjData.getValidate(), geetBox = $('.geetBox');
				if(!result){_LRF_.tipsError(geetBox,'请先完成验证'); return}
				_LRF_.geetest_challenge = result.geetest_challenge;
				_LRF_.geetest_validate = result.geetest_validate;
				_LRF_.geetest_seccode = result.geetest_seccode;
			}
			else if(_LRF_.yzmType == 3){
				var luosimaoResp = $('input[name="luotest_response"]').val();
				if(!_R_.luosimaoTF){_R_.luosimaoGetResponse(luosimaoResp)}
			}
			_R_.createSendSmsData();
			_R_.sendSmsCode();
		}

		,luosimaoGetResponse: function(resp){
			var luosimaoBox = $('.luosimaoBox');
			if(!resp){_R_.luosimaoTF = false; _LRF_.tipsError(luosimaoBox,'请先完成验证'); return}
			else{
				_R_.luosimaoTF = true;
				_LRF_.tipsOk(luosimaoBox);
				setTimeout(function(){_R_.smsRedSendBtnClick()},1000);
			}
		}

		,createSendSmsData : function(){
			this.sendSmsData = {};
			this.sendSmsData.userType = _LRF_.userType;
			this.sendSmsData.type = this.type;
			this.sendSmsData.mobile = this.mobile;

			if(_LRF_.yzmType == 0) this.sendSmsData.imgType = 'luosimao';
			if(_LRF_.yzmType == 1){
				this.sendSmsData.code = this.code;
			}else if(_LRF_.yzmType == 2){
				this.sendSmsData.imgType = 'geetestReg';
				this.sendSmsData.geetest_challenge = _LRF_.geetest_challenge;
				this.sendSmsData.geetest_validate = _LRF_.geetest_validate;
				this.sendSmsData.geetest_seccode = _LRF_.geetest_seccode;
			}else if(_LRF_.yzmType == 3){
				this.sendSmsData.imgType = 'luosimao';
				this.sendSmsData.code = $('input[name="luotest_response"]').val();
			}
		}
		,sendSmsCode : function(){
			var param = {theUrl : api.sms.codeSend0, theData : this.sendSmsData};
			doPostAjax(param,this.sendSmsCodeFn);
		}
		,sendSmsCodeFn : function(data){
			_LRF_.imgCodeChange();
			if(data.success == 'true'){
				_R_.smsTipShow();
				_R_.popCloseBtn.click();
				_LRF_.smsBlueGetBtnToGray();
				bdCategory = '短信验证码发送成功';
				bdAction = '发送短信AJAX返回';
				_R_.baiduPush(); //百度统计事件跟踪
			}
			else{
				if(data.msg == '图形验证码错误'){
					// 图形验证码错误
					var input = $('input.yzmCode'), tips = '图形验证码错误';
					_LRF_.tipsError(input,tips);
					input.val('');
					_LRF_.imgCodeChange();
					bdCategory = '图形验证码错误';
					bdAction = '发送短信AJAX返回';
					_R_.baiduPush(); //百度统计事件跟踪
				}
				else if(data.msg == "手机已注册"){
					// 手机已注册
					_R_.popCloseBtn.click();
					var input = $('input.mobile'), tips = '该手机号码已注册';
					_LRF_.tipsError(input,tips);
					bdCategory = '手机已注册';
					bdAction = '发送短信AJAX返回';
					_R_.baiduPush(); //百度统计事件跟踪
				}
				else if(data.msg == "短信不可用"){
					_R_.popCloseBtn.click();
					_LRF_.tipsError($('input.mobile'),data.msg+'，请联系客服'+_LRF_.userRLFqq);
				}
				else if(data.msg == '发送太频繁'){
					_R_.popCloseBtn.click();
					_LRF_.tipsError($('input.smsCode'),'发送太频繁，请稍后再试');
				}
				else{alert(data.msg)}
			}
		}

		,smsTipShow : function(){
			var smsTip = $('.userRegLoginform').find('.smsTip');
			smsTip.fadeIn();
			setTimeout(function(){smsTip.fadeOut(800)},1500);
		}

		// 弹出层关闭按钮点击事件
		,popCloseBtnClick : function(){$(this).parents('.popMid').hide()}

		// 免费注册按钮点击事件
		,redRegBtnClick : function(){
			var btn = $(this)
				,parents = btn.parents('ul.userRegLoginform')
				,mobileInput = parents.find('input.mobile')
				,mobile_val = mobileInput.val()
				,smsCodeInput = parents.find('input.smsCode')
				,smsCode_val = smsCodeInput.val()
				,passwordInput = parents.find('input.password')
				,password_val = passwordInput.val()
				,xyCheckBox = parents.find('input[type="checkbox"].xyCheckBox')
			;
			//----- 校验手机号 -----
			_R_.mobile = '';
			if(!mobile_val){_LRF_.tipsError(mobileInput,'请输入手机号码'); bdCategory = '手机号码未输入'; bdAction = '立即注册按钮点击'; _R_.baiduPush(); return}
			else if(!reg.mobile.test(mobile_val)){_LRF_.tipsError(mobileInput, '请输入正确的手机号码'); bdCategory = '手机号码输入不正确'; bdAction = '立即注册按钮点击'; _R_.baiduPush(); return}
			_R_.mobile = mobile_val;

			//----- 校验短信验证码 -----
			_R_.smsCode = '';
			if(!smsCode_val){_LRF_.tipsError(smsCodeInput, '请输入短信验证码'); bdCategory = '未输入短信验证码'; bdAction = '立即注册按钮点击'; _R_.baiduPush(); return}
			_R_.smsCode = smsCode_val;

			//----- 校验密码 -----
			_R_.pwd = '';
			if(!password_val){_LRF_.tipsError(passwordInput, '请输入密码'); bdCategory = '未输入密码'; bdAction = '立即注册按钮点击'; _R_.baiduPush(); return}
			else if(password_val.length < 6 || password_val.length > 20){
				_LRF_.tipsError(passwordInput, '密码长度在6~20位之间');
				bdCategory = '密码小于6位或大于20位';
				bdAction = '立即注册按钮点击';
				_R_.baiduPush(); //百度统计事件跟踪
				return;
			}
			_R_.pwd = $.md5(password_val);

			if(!xyCheckBox.is(':checked')){
				alert('请同意《云自媒服务协议》');
				bdCategory = '未同意《云自媒服务协议》';
				bdAction = '立即注册按钮点击';
				_R_.baiduPush(); //百度统计事件跟踪
				return;
			}
			$('.pageLoading').fadeIn();
			// 只执行一次，避免重复发送数据
			if(_R_.regBtnCheck){
				_R_.createRegData();
				_R_.userReg();
			}
		}
		,createRegData : function(){
			this.regData = {};
			this.regData.userType = _LRF_.userType;
			this.regData.pwd = this.pwd;
			this.regData.mobile = this.mobile;
			this.regData.smsCode = this.smsCode;
			this.regData.sourceInner = this.sourceInner;
			// 推荐人ID
			this.regData.referId = getUrlRequest('referId') || localStorage.getItem('referId');
		}
		,userReg : function(){
			var param = {theUrl : api.user.reg, theData : this.regData};
			doPostAjax(param,this.userRegFn);
		}

		//------------------------------------
		//      用户注册成功后的跳转相关
		//------------------------------------
		,userRegFn : function(data){
			if(data.success == 'true'){
				localStorage.clear();
				_R_.regBtnCheck = false;

				if(_LRF_.userType == 2){
					// 添加优惠券
					_R_.couponAdd();
				}
				else if(_LRF_.userType == 1){
					bdCategory = "媒介主注册成功";
					bdAction = "立即注册AJAX返回";
					_R_.baiduPush(); //百度统计事件跟踪
					location.href = '/websiteHome/userProfilePg.html?regOk';
				}
			}else{
				$('.pageLoading').fadeOut();
				var input = '', tips = '';
				if(data.msg == '短信验证码不正确'){
					input = $('input.smsCode');
					tips = '短信验证码不正确';
					bdCategory = '短信验证码不正确';
					bdAction = '立即注册AJAX返回';
					_R_.baiduPush(); //百度统计事件跟踪
				}else if(data.msg == '短信验证码失效'){
					input = $('input.smsCode');
					tips = '短信验证码失效';
					bdCategory = '短信验证码失效';
					bdAction = '立即注册AJAX返回';
					_R_.baiduPush(); //百度统计事件跟踪
				}
				if(input){_LRF_.tipsError(input,tips)}
			}
		}

		// 添加优惠券
		,couponAdd : function(){
			var param = {theUrl : '/companyHome/couponAddDt.json', theData : {couponRuleAction : 'REG'}};
			doPostAjax(param,this.couponAddFn);
		}
		,couponAddFn : function(data){
			if(data.success == 'true'){
				bdCategory = '广告主注册成功';
				bdAction = '立即注册AJAX返回';
				_R_.baiduPush(); //百度统计事件跟踪
				_SLS_.init({
					type : 'REG'
					,popSsImg : 0
					,recharge : 0
					,couponList : data.data.list
				});
				location.href = '/companyHome/articleResListPg.html?regOk';
			}else{
				console.log(data.msg);
			}
		}

		,geetestImgCode : function(){
			var param = {theUrl : api.geetestImgCode, theData : {imgType : 'geetestReg'}};
			doPostAjax(param,this.geetestImgCodeFn);
		}
		,geetestImgCodeFn : function(data){
			var data = JSON.parse(data);
			if(data.success == 1){
				initGeetest({
					gt : data.gt
					,challenge : data.challenge
					,new_captcha : data.new_captcha // 用于宕机时表示是新验证码的宕机
					,offline : !data.success // 表示用户后台检测极验服务器是否宕机，一般不需要关注
					,product : 'popup' // 产品形式，包括：float，popup
					,width : '100%'
					// 更多配置参数请参见：http://www.geetest.com/install/sections/idx-client-sdk.html#config
				},_R_.handler2);
			}else{
				console.log('geetestImgCode-false');
			}
		}
		,handler2: function(captchaObj){
			captchaObjData = captchaObj;
			$('.geetBox').html('');
			captchaObj.appendTo('.geetBox');
			captchaObj.onReady(function(){
				// $("#wait2").hide();
			});
			captchaObj.onSuccess(function(){
				var geetBox = $('.geetBox');
				_LRF_.tipsOk(geetBox);
			});
		}
	};
})();




//====================================================
//              用户找回密码模块
//====================================================
var _F_ = _F_ || {};
_F_ = (function(){
	var userType = getUrlRequest('userType') || 2
		,userTypen = ''
		,typeChose = $('.typeChose')
		,hasMobileData = {}
		,mobile = ''
		,sendSmsData = {}
		,sendSmsData2 = {}
		,imgType = 'geetestLogin'
		,sendSmsData3 = {}
		,captchaObjData
		,type = 'reset'
		,code = ''
		,submitData = {}
		,checkSmsData = {}
		,smsCode = ''
		,newPwd = ''
		,newPwd2 = ''
		,token = ''
		,clock
		,smsTime = 90
	;

	return {
		redNextBtn : $('.btn.red.nextBtn')
		,popImgYzm : $('.popMid.popImgYzm')
		,popCloseBtn : $('.popMid').find('.close')
		,smsRedSendBtn : $('.btn.red.sms.send')
		,smsBlueGetBtn : $('span.sms.get.blue')
		,submitBtn : $('.btn.red.submit')
		,type : 'reset'

		,init : function(){
			// 极验验证
			// this.geetestImgCode();
			// 弹出层关闭按钮点击事件
			this.popCloseBtn.on('click',this.popCloseBtnClick);
			// 弹出层红色发送短信验证码按钮点击事件
			this.smsRedSendBtn.on('click',this.smsRedSendBtnClick);
			// 下一步按钮点击事件
			this.redNextBtn.on('click',this.redNextBtnClick);
			// 获取短信验证码按钮点击事件
			this.smsBlueGetBtn.on('click',this.smsBlueGetBtnClick);
			// 提交按钮点击事件
			this.submitBtn.on('click',this.submitBtnClick);
		}

		// 下一步按钮点击事件
		,redNextBtnClick : function(){
			//----------校验手机号----------
			var mobileInput = $('input.mobile'), mobile_val = mobileInput.val();
			_F_.mobile = '';
			if(!mobile_val){_LRF_.tipsError(mobileInput,'请输入手机号码'); return}
			else if(!reg.mobile.test(mobile_val)){_LRF_.tipsError(mobileInput,'请输入正确的手机号码'); return}
			_F_.mobile = mobile_val;
			// hasMobileData
			_F_.createHasMobileData();
			_F_.userHasMobile();
		}
		,createHasMobileData : function(){
			this.hasMobileData = {};
			this.hasMobileData.userType = _LRF_.userType;
			this.hasMobileData.mobile = this.mobile;
		}
		,userHasMobile : function(){
			var param = {theUrl : api.user.hasMobile, theData : this.hasMobileData};
			doPostAjax(param,this.userHasMobileFn);
		}
		,userHasMobileFn : function(data){
			if(data.success == 'true'){
				var data = data.data, mobileExtist = data.mobileExtist || '';

				if(!mobileExtist){
					var input = $('input.mobile');
					_LRF_.tipsError(input,'手机号码不存在');
				}else{
					_F_.showStep(2);
					_F_.showStepForm(2);
					$('span.mobile').html(_F_.mobile);
				}
			}
		}
		,showStep: function(n){$('.fg-steps').find('.step.s'+n).addClass('active').siblings().removeClass('active')}
		,showStepForm: function(n){$('.stepForm.step'+n).removeClass('hide').siblings('.stepForm').addClass('hide')}
		
		// 弹出层关闭按钮点击事件
		,popCloseBtnClick : function(){$(this).parents('.popMid').hide()}

		// 获取短信验证码按钮点击事件  检查短信是否关闭
		,smsBlueGetBtnClick : function(){_F_.smsConfig()}

		// 检查短信是否关闭
		,smsConfig : function(){
			var param = {theUrl : api.sms.config, theData : {type: 16}};
			doPostAjax(param,this.smsConfigFn);
		}
		,smsConfigFn : function(data){
			if(data.success == 'true'){
				_F_.checkCode(); //校验验证码
			}else{
				_LRF_.tipsError($("input.smsCode"),data.msg+'，请联系客服'+_LRF_.userRLFqq);
			}
		}
		// 校验验证码
		,checkCode : function(){
			_LRF_.judgeYzmShow(function(){
				// 显示验证码
				(_LRF_.yzmType == 3) && _F_.popImgYzm.show();

				if(_LRF_.yzmType == 1){
					//----------校验图形验证码----------
					var yzmCodeInput = $('input.yzmCode'), yzmCode_val = yzmCodeInput.val();
					_F_.code = '';
					if(!yzmCode_val){_LRF_.tipsError(yzmCodeInput, '请输入图形验证码'); return}
					else if(!reg.num.test(yzmCode_val) || yzmCode_val.length != 4){_LRF_.tipsError(yzmCodeInput, '请输入正确的图形验证码'); return}
					_F_.code = yzmCode_val;
				}
				else if(_LRF_.yzmType == 2){
					var result = captchaObjData.getValidate(), geetBox = $('.geetBox');
					if(!result){_LRF_.tipsError(geetBox, '请先完成验证'); return;}
					_LRF_.geetest_challenge = result.geetest_challenge;
					_LRF_.geetest_validate = result.geetest_validate;
					_LRF_.geetest_seccode = result.geetest_seccode;
				}
				else if(_LRF_.yzmType == 3){
					var result = $('input[name="luotest_response"]').val(), luosimaoBox = $('.luosimaoBox');
					if(!result){
						// _LRF_.tipsError(luosimaoBox,'请先完成验证');
						return;
					}
				}
				_F_.createSendSmsData();
				_F_.sendSmsCode();
			});
		}
		,createSendSmsData : function(){
			this.sendSmsData = {};
			this.sendSmsData.userType = _LRF_.userType;
			this.sendSmsData.mobile = this.mobile;
			this.sendSmsData.type = this.type;
			this.sendSmsData.imgType = 'luosimao';

			if(_LRF_.yzmType == 1){
				this.sendSmsData.code = this.code;
			}else if(_LRF_.yzmType == 2){
				this.sendSmsData.imgType = 'geetestLogin';
				this.sendSmsData.geetest_challenge = _LRF_.geetest_challenge;
				this.sendSmsData.geetest_validate = _LRF_.geetest_validate;
				this.sendSmsData.geetest_seccode = _LRF_.geetest_seccode;
			}else if(_LRF_.yzmType == 3){
				this.sendSmsData.imgType = 'luosimao';
				this.sendSmsData.code = $('input[name="luotest_response"]').val();
			}
		}
		,sendSmsCode : function(){
			var param = {theUrl : api.sms.codeSend0, theData : this.sendSmsData};
			doPostAjax(param,this.sendSmsCodeFn);
		}
		,sendSmsCodeFn : function(data){
			_LRF_.imgCodeChange();
			if(data.success == 'true'){
				_F_.smsTipShow();
				_LRF_.smsBlueGetBtnToGray();
			}else{
				if(data.msg == '非法操作'){_LRF_.tipsError($("input.smsCode"),'此帐号今日发送短信太频繁，请改天再试')}
				else if(data.msg == '图形验证码错误'){_LRF_.tipsError($('input.yzmCode'), '图形验证码错误')}
				else if(data.msg == '发送太频繁'){_LRF_.tipsError($('input.smsCode'),'此帐号今日发送短信太频繁，请改天再试')}
				else if(data.msg == '短信不可用'){_LRF_.tipsError($('input.smsCode'),'短信不可用，请联系客服'+_LRF_.userRLFqq)}
				else{alert(data.msg)}
			}
		}
		,luosimaoGetResponse : function(resp){
			if(resp){
				_LRF_.tipsOk($('.luosimaoBox'));
				$('.close').parents('.popMid').hide();
			}
			$('.sms.get.blue').click();
		}
		,smsRedSendBtnClick : function(){
			var result = $('input[name="luotest_response"]').val(), luosimaoBox = $(".luosimaoBox");
			if(!result){
				_LRF_.tipsError(luosimaoBox,'请先完成验证');
			}else{
				$('.close').parents('.popMid').hide();
				$('.sms.get.blue').click();
			}
		}
		,smsTipShow : function(){
			var smsTip = $('.userRegLoginform').find('.smsTip');
			smsTip.fadeIn();
			setTimeout(function(){smsTip.fadeOut(800)},1500);
		}

		// 提交按钮点击事件
		,submitBtnClick : function(){
			//----------校验短信验证码----------
			var smsCodeInput = $('input.smsCode'), smsCode_val = smsCodeInput.val();
			_F_.smsCode = '';
			if(!smsCode_val){_LRF_.tipsError(smsCodeInput,'请输入短信验证码'); return}
			else if(!reg.num.test(smsCode_val) || smsCode_val.length != 6){_LRF_.tipsError(smsCodeInput,'请输入正确的短信验证码'); return}
			_F_.smsCode = smsCode_val;

			//----------校验密码1----------
			var password1Input = $('input.password1'), password1_val = password1Input.val();
			_F_.newPwd = '';
			if(!password1_val){_LRF_.tipsError(password1Input, '请输入新的登陆密码'); return}
			else if(password1_val.length < 6 || password1_val.length > 20){_LRF_.tipsError(password1Input, '密码长度在6~20位之间'); return}
			_F_.newPwd = $.md5(password1_val);

			//----------校验密码2----------
			var password2Input = $('input.password2'), password2_val = password2Input.val();
			_F_.newPwd2 = '';
			if(!password2_val){_LRF_.tipsError(password2Input, '请输入确认密码'); return}
			else if(password2_val != password1_val){_LRF_.tipsError(password2Input, '两次输入密码不一致'); return}
			_F_.newPwd2 = $.md5(password2_val);

			_F_.createCheckSmsData();
			_F_.checkSms();
		}
		,createCheckSmsData : function(){
			this.checkSmsData = {};
			this.checkSmsData.mobile = this.mobile;
			this.checkSmsData.smsCode = this.smsCode;
		}
		,checkSms : function(){
			var param = {theUrl : api.sms.codeCheck, theData : this.checkSmsData};
			doPostAjax(param,this.checkSmsFn);
		}
		,checkSmsFn : function(data){
			if(data.success == 'true'){
				_F_.token = data.data.toke;
				_F_.createSubmitData();
				_F_.setUserPwd();
			}else{
				alert(data.msg);
			}
		}
		,createSubmitData : function(){
			this.submitData = {};
			this.submitData.userType = _LRF_.userType;
			this.submitData.mobile = this.mobile;
			this.submitData.newPwd = this.newPwd;
			this.submitData.newPwd2 = this.newPwd2;
			this.submitData.token = this.token;
		}
		,setUserPwd : function(){
			var param = {theUrl : api.user.pwdReset, theData : this.submitData};
			doPostAjax(param,this.setUserPwdFn);
		}
		,setUserPwdFn : function(data){
			if(data.success == 'true'){
				_F_.showStep(3);
				_F_.showStepForm(3);
				$('a.goLogin').attr('href','/userLoginPg.html?userType='+_LRF_.userType);
			}else{
				var input, tips;
				if(data.msg == '短信验证码不正确'){_LRF_.tipsError($('input.smsCode'),'短信验证码不正确')}
				else if(data.msg == '短信验证码失效'){_LRF_.tipsError($('input.smsCode'),'短信验证码失效')}
			}
		}

		,geetestImgCode : function(){
			var param = {theUrl : api.geetestImgCode, theData : {imgType : imgType}};
			doPostAjax(param,this.geetestImgCodeFn);
		}
		,geetestImgCodeFn : function(data){
			data = JSON.parse(data);
			if(data.success == 1){
				initGeetest({
					gt: data.gt
					,challenge: data.challenge
					,new_captcha: data.new_captcha // 用于宕机时表示是新验证码的宕机
					,offline: !data.success // 表示用户后台检测极验服务器是否宕机，一般不需要关注
					,product: 'popup' // 产品形式，包括：float，popup
					,width: '100%'
					// 更多配置参数请参见：http://www.geetest.com/install/sections/idx-client-sdk.html#config
				},_F_.handler2);
			}else{
				console.log('geetestImgCode-false');
			}
		}
		,handler2 : function(captchaObj){
			captchaObjData = captchaObj;
			$('.geetBox').html('');
			captchaObj.appendTo('.geetBox');
			captchaObj.onReady(function(){
				// $("#wait2").hide();
			});
			captchaObj.onSuccess(function(){
				var geetBox = $('.geetBox');
				_LRF_.tipsOk(geetBox);
			});
		}
	};
})();


(function(){
	var changeUserTypeLoginBox = $('.userRegLoginContain .typeChose span'), loginBtn = $('ul.userRegLoginform .bigBtn .loginBtn');
	changeUserTypeLoginBox.on('click',function(){
		if($(this).hasClass('website')){loginBtn.addClass('realOrange')}
		else{loginBtn.removeClass('realOrange')}
	});
})();
