@extends('admin.layouts.base')
<style>
    .layui-table-cell .layui-form-checkbox[lay-skin="primary"], .layui-table-cell .layui-form-radio[lay-skin="primary"] {
        top:5px !important;
    }

</style>
@section('content')
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto layui-form">
            <form class="layui-form-item" id="search-form">
                <div class="layui-inline">
                    <label class="layui-form-label">类型</label>
                    <div class="layui-input-inline">
                        <select name="type"  id="type">
                            <option value="">请选择</option>
                            <option value="1">申请中</option>
                            <option value="2">处理中</option>
                            <option value="3">已完成</option>
                            <option value="0">已拒绝</option>
                        </select>
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">时间区间</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" placeholder="开始时间" name="create_start" id="start_time" autocomplete="off">
                    </div>
                    <div class="layui-form-mid">至</div>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" placeholder="结束时间" name="create_end" id="end_time" autocomplete="off">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">用户电话</label>
                    <div class="layui-input-inline">
                        <input type="text" name="phone" id="phone"  placeholder="请输入用户电话" class="layui-input">
                    </div>
                </div>
                <div class="layui-inline">
                    <button class="layui-btn layuiadmin-btn-useradmin" lay-submit="" lay-filter="searchBtn">
                        <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
                    </button>
                </div>

            </form>
            <div>
                <div class="layui-btn-group">
                    {{--@can('admin.cash.excel')--}}
                    <button class="layui-btn layui-btn-sm" id="toExcel">导 出</button>
                    {{--@endcan--}}
                </div>
            </div>

        </div>
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    @{{#  if(d.status === 3) { }}
                    <a class="layui-btn layui-btn-sm" lay-event="edit">查看</a>
                    @{{#  } else { }}
                    <a class="layui-btn layui-btn-sm" lay-event="edit">处理</a>
                    @{{#  } }}
                </div>
            </script>
            <script type="text/html" id="thumb">
                <a href="@{{d.thumb}}" target="_blank" title="点击查看"><img src="@{{d.thumb}}" alt="" width="28" height="28"></a>
            </script>
        </div>
    </div>
    @endsection
            <!-- 首先引入css, 和js, 唯一依赖: jQuery -->
    <link href="/static/admin/layuiadmin/layui/dist/formSelects-v4.css" rel="stylesheet" />
    <script src="/static/admin/layuiadmin/layui/dist/jquery.min.js"></script>
    <script src="/static/admin/layuiadmin/layui/dist/formSelects-v4.min.js"></script>
@section('script')
    @can('admin.member.member')

    <script>
        layui.use(['layer','table','form','laydate'],function () {
            var layer = layui.layer;
            var form = layui.form;
            var table = layui.table;
            var laydate = layui.laydate;


            formSelects.render('selectId');
            //用户表格初始化
            var dataTable = table.render({
                elem: '#dataTable'
                // ,height: 500
                ,url: "{{ route('admin.cash.data') }}" //数据接口
                ,page: true //开启分页
                ,cols: [[ //表头
                    {checkbox: true,fixed: true}
                    ,{field: 'id', title: 'ID', sort: true,width:80}
                    ,{field: 'phone', title: '用户电话',templet:function (d) {
                        return d.member.phone
                    }
                    }
                    ,{field: 'money', title: '申请金额',templet:function (d) {
                        if(d.money){
                            return d.money+'元';
                        }else{
                            return ''
                        }}}
                    ,{field: 'money', title: '实际金额',templet:function (d) {
                        if(d.money){
                            return d.money+'元';
                        }else{
                            return ''
                        }}}
                    ,{field: 'status', title: '状态',templet:function (d) {
                        switch(d.status) {
                            case 1:
                                return '申请中'
                                break;
                            case 2:
                                return '处理中'
                                break;
                            case 3:
                                return '处理完成'
                                break;
                            case 0:
                                return '拒绝'
                                break;
                            default :
                                return ''
                                break;
                        }
                    }}
                    ,{field: 'account', title: '支付宝账号'}
                    ,{field: 'mark', title: '处理意见'}
                    ,{field: 'deal_at', title: '打款时间', sort: true}
                    ,{field: 'image', title: '打款凭证',templet: function(d){
                        return '<img style="display: inline-block; width: 50%; height: 100%;" src="{{ env('IMG_URL') }}'+ d.image+'">';
                    }}
                    ,{field: 'created_at', title: '申请时间', sort: true}
                    ,{fixed: 'right', title:'操作',width: 100, align:'center', toolbar: '#options'}
                ]]
            });


            //监听是否显示
            form.on('switch(isShow)', function(obj){
                var index = layer.load();
                var url = $(obj.elem).attr('url')
                var data = {
                    "is_show" : obj.elem.checked==true?1:0,
                    "_method" : "put"
                }
                $.post(url,data,function (res) {
                    layer.close(index)
                    layer.msg(res.msg)
                },'json');
            });

            //按钮批量删除
            $("#listDelete").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                if (ids.length>0){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("{{--{{ route('admin.member.member.destroy') }}--}}",{_method:'delete',ids:ids},function (result) {
                            if (result.code==0){
                                dataTable.reload()
                            }
                            layer.close(index);
                            layer.msg(result.msg,{icon:6})
                        });
                    })
                }else {
                    layer.msg('请选择删除项',{icon:5})
                }
            })


            //导出
            $("#toExcel").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                var phone = $("#phone").val();
                var start_time = $("#create_start").val();
                var end_time = $("#create_end").val();
                var type = $("#type").val();
                var u = '{{ route('admin.cash.excel') }}';
                u = u+'?type='+type+'&start_time='+start_time+'&end_time='+end_time+'&phone='+phone+'&ids='+ids;
                window.location.href=u;
            })
            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                        ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent === 'edit'){
                    location.href = '/admin/cash/'+data.id+'/edit';
                }
            });
            //监听搜索
            form.on('submit(searchBtn)', function(data){
                var field = data.field;

                //执行重载
                table.reload('dataTable', {
                    where: field
                    ,page: {
                        curr: 1 //重新从第 1 页开始
                    }
                });
                return false;
            });


            laydate.render({
                elem: '#start_time' //指定元素
                ,type: 'datetime'
            });
            laydate.render({
                elem: '#end_time' //指定元素
                ,type: 'datetime'
            });
        });

    </script>
    @endcan
@endsection