@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header">@if($info->type == 1)提现比例@else退款比例@endif配置</div>
        <div class="layui-card-body" style="padding: 15px;">
            <form class="layui-form" method="post">
                {{ csrf_field() }}
                <input type="hidden" name="id" value="{{ $id }}">
                <div style="border:1px solid green; margin-top: 20px;padding: 20px 0px 20px 0px;">
                    <div class="layui-form-item">
                        <label class="layui-form-label"><strong class="item-required"></strong>@if($info->type == 1)提现比例@else退款比例@endif</label>
                        <div class="layui-input-block">
                            <input type="text" name="rate" lay-verify="rate" autocomplete="on" placeholder="请输入提现比例" class="layui-input" value="{{ $info->rate??'' }}" maxlength="5"  >%
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label"><strong class="item-required"></strong>最低金额</label>
                        <div class="layui-input-block">
                            <input type="text" name="limit" @if($info->type == 1) lay-verify="required" @endif autocomplete="on" placeholder="请输入最低金额" class="layui-input" value="{{ $info->rate??'' }}" maxlength="5"  >
                        </div>
                    </div>
                    <div class="layui-form-item layui-layout-admin">
                        <div class="layui-input-block">
                            <div class="layui-footer" style="left: 0;">
                                <button type="submit" class="layui-btn" lay-submit="" lay-filter="*">确 认</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('script')
    <script>
        layui.use(['form'],function () {
            var form = layui.form;

            form.verify({
                rate: function(value, item){ //value：表单的值、item：表单的DOM对象
                    if(value == ''){
                        return '比例不能为空！';
                    }
                    if(value > 100 ){
                        return '比例不能超过100'
                    }
                }
            });
        });
    </script>
@endsection