@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto">
            <h2>详情</h2>
        </div>
        <div class="layui-card-body">
            <form class="layui-form" action="" method="post">
                {{csrf_field()}}
                <div class="layui-form-item">
                    <label for="" class="layui-form-label"><strong class="item-required"></strong>订单编号</label>
                    <div class="layui-input-block">
                        <input type="text" name="" maxlength="255" value="{{ $info->order_no }}" lay-verify="" placeholder="请输入链接" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item">
                    <label for="" class="layui-form-label"><strong class="item-required"></strong>购买资源</label>
                    <div class="layui-input-block">
                        <input type="text" name="" maxlength="255" value="{{ $info->product['name'] }}" lay-verify="" placeholder="请输入链接" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item">
                    <label for="" class="layui-form-label"><strong class="item-required"></strong>资源价格</label>
                    <div class="layui-input-block">
                        <input type="text" name="" maxlength="255" value="{{ $info->product['quota_min'] }}" lay-verify="" placeholder="请输入链接" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item">
                    <label for="" class="layui-form-label"><strong class="item-required"></strong>当前状态</label>
                    <div class="layui-input-block">
                        <input type="text" name="" maxlength="255" value="<?php
                        switch ($info->status) {
                            case 1:
                                echo '待支付';
                                break;
                            case 2:
                                echo '已支付';
                                break;
                            case 3:
                                echo '已取消';
                                break;
                            case 4:
                                echo '已经执行';
                                break;
                            case 5:
                                echo '接单收款';
                                break;
                            case 6:
                                echo '退单退款';
                                break;
                            case 7:
                                echo '媒体主完成';
                                break;
                            default :
                                echo '';
                                break;
                        }
                        ?>" lay-verify="" placeholder="" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item" style="display: @if($info->status > 1)  block @else none @endif ;">
                    <label for="" class="layui-form-label"><strong class="item-required"></strong>支付金额</label>
                    <div class="layui-input-block">
                        <input type="text" name="" maxlength="255" value="{{ $info->money }}" lay-verify="" placeholder="请输入链接" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item" style="display: @if($info->status >= 2)  block @else none @endif ;">
                    <label class="layui-form-label"><strong class="item-required">*</strong>操作订单</label>
                    <div class="layui-input-block">
                        @if($info->status < 4)
                            <input type="radio" name="status"  lay-filter="" value="4" title="开始执行订单" >
                            <div class="layui-unselect layui-form-radio layui-form-radioed"><i class="layui-anim layui-icon"></i>
                                <div>开始执行订单</div>
                            </div>
                        @endif
                        @if(in_array($info->status,[7]))
                            <input type="radio" name="status"  lay-filter="" value="5" title="结单收款" >
                            <div class="layui-unselect layui-form-radio layui-form-radioed"><i class="layui-anim layui-icon"></i>
                                <div>完成订单/确认收款</div>
                            </div>
                        @endif
                       {{-- @if($info->status < 6)
                            <input type="radio" name="status" lay-filter="" value="6" title="退单退款" >
                            <div class="layui-unselect layui-form-radio"><i class="layui-anim layui-icon"></i>
                                <div>退单退款</div>
                            </div>
                        @endif--}}
                        @if($info->status == 2)
                            <input type="radio" name="status" lay-filter="" value="3" title="取消订单" >
                            <div class="layui-unselect layui-form-radio"><i class="layui-anim layui-icon"></i>
                                <div>取消订单</div>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label" style="width:116px;">素材</label>
                    <div class="layui-input-inline">
                        @if(count($info->orderActive) && $info->orderActive->source_type == 'link')
                            <span> <a href="{{$info->orderActive->link}}" target="view_window">{{$info->orderActive->link}}</a></span>
                        @else
                            <a href="{{$info->file}}" type="button" class="layui-btn" id="show"  download> {{$info->file}} 查看</a>
                        @endif
                    </div>
                </div>

                <div class="layui-form-item reason" style="display: none;">
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>取消原因</label>
                    <div class="layui-input-block">
                        <textarea name="reason"  maxlength="255" placeholder="请输入取消原因"  class="layui-textarea"></textarea>
                    </div>
                </div>

                <div class="layui-form-item" style="display: @if($info->status >= 2)  block @else none @endif ;">
                    <label for="" class="layui-form-label"><strong class="item-required"></strong>备注</label>
                    <div class="layui-input-block">
                        <textarea name="mark" maxlength="1000" placeholder="请输入完成备注" lay-verify="" class="layui-textarea"></textarea>
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">查看余额</label>
                    <div class="layui-input-inline">
                        <span>
                          <a href="http://yun.kouhaobang.com/member" class="layui-btn layui-btn-danger" target="view_window">
                          查看余额
                          </a>
                        </span>
                    </div>
                </div>
                <div class="layui-form-item" style="display: @if(isset($info->cloudInfo) && $info->product->created_from == 'cloud' && $info->cloudInfo->status == 0&& $info->cloudInfo->out_trade_no)  block @else none @endif ;">
                    <label for="" class="layui-form-label"><strong class="item-required"></strong>云订单支付</label>
                    <div class="layui-input-block">
                        <span  class="layui-btn" id="again_go_pay">重新发起支付</span>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-input-block">
                        <button type="submit" class="layui-btn" lay-submit="" lay-filter="formDemo">确 认</button>
                        <a  class="layui-btn" href="{{route('admin.apply.cloud')}}" >返 回</a>

                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('script')
    <script>
        layui.use(['form','upload'],function () {
            var form = layui.form;
            var upload = layui.upload;
            //logo上传
            var uploadInst = upload.render({
                elem: '#logo'
                ,url: '/uploadImage'
                ,size:1024
                ,data:{"_token":"{{ csrf_token() }}"}
                ,before: function(obj){
                    //预读本地文件示例，不支持ie8
                    obj.preview(function(index, file, result){
                        $('#logoImg').attr('src', result); //图片链接（base64）
                        $('#logoRemove').show();
                    });
                    $('#logoRemove').on('click',function () {
                        $('#logoImg').attr('src',null);
                        $('#logoRemove').hide();
                        $('input[name="logo"]').val('');
                    });
                }
                ,done: function(res){
                    if(res.code === 0){
                        $('input[name="logo"]').val(res.url);
                    }else {
                        return layer.msg('上传失败');
                    }
                }
                ,error: function(){
                    //演示失败状态，并实现重传
                    var demoText = $('#logoText');
                    demoText.html('<span style="color: #FF5722;">上传失败</span> <a class="layui-btn layui-btn-xs demo-reload">重试</a>');
                    demoText.find('.demo-reload').on('click', function(){
                        uploadInst.upload();
                    });
                }
            });
            form.on('submit(formDemo)', function(data){
                var post_status = $("input[name='status']:checked").val();
                var finish_url =  $("input[name=url]").val();
                var finish_img =  $("input[name=logo]").val();
                var reason =      $("textarea[name=reason]").val();
               /* if((post_status == 7 || post_status == 5) && (!finish_url || !finish_img))
                {
                    layer.msg('填写完成凭证或完成链接');
                    return false;
                }*/
                if((post_status == 6 || post_status == 3) && !reason)
                {
                    layer.msg('填写拒单或流单原因');
                    return false;
                }
                if(!post_status)
                {
                    layer.msg('请选择处理状态');
                    return false;
                }
                return true;
            });
            form.on('radio', function(data){
                var status = data.value;

                if(status == 7 || status == 5)
                {
                    $(".reason").hide();
                    $(".finish_img").show();
                    $(".finish_url").show();
                }

                if(status == 2 ||  status == 4)
                {
                    $(".reason").hide();
                    $(".finish_img").hide();
                    $(".finish_url").hide();
                }

                if(status == 6 || status == 3)
                {
                    $(".reason").show();
                    $(".finish_img").hide();
                    $(".finish_url").hide();
                }
            });
            $("#again_go_pay").click(function () {
                layer.confirm('确定重新发起支付吗？', function(index){
                    var id = "{{$info->id}}"
                    $.post("{{ route('admin.apply.cloud.pay') }}",{id:id},function (result) {
                        if (result.type === '200'){
                            layer.msg(result.info);
                        }else {
                            layer.msg(result.info);
                        }
                    });
                })
            })
        });
    </script>

@endsection