@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto layui-form">
            <form class="layui-form-item" id="search-form">
                <div class="layui-inline">
                    <label class="layui-form-label">举报时间</label>
                    <div class="layui-input-block">
                        <div class="layui-input-inline">
                            <input type="text" name="start_time" placeholder="开始时间" autocomplete="off" class="layui-input" id="start_time">
                        </div>
                        <div class="layui-form-mid">至</div>
                        <div class="layui-input-inline">
                            <input type="text" name="end_time" placeholder="结束时间" autocomplete="off" class="layui-input" id="end_time">
                        </div>
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">举报分类</label>
                    <div class="layui-input-inline">
                        <select name="channel_id" lay-verify="" id="channel_id">
                            <option value="">请选择分类</option>
                            @foreach($channels as $item)
                                <option value="{{ $item->id }}" >{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">举报人号码</label>
                    <div class="layui-input-inline">
                        <input type="text" name="phone" id="phone" placeholder="反馈人号码" class="layui-input" >
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">处理状态</label>
                    <div class="layui-input-inline">
                        <select name="reply_status" lay-verify="" id="reply_status">
                            <option value="">处理状态</option>
                            <option value="2" >已处理</option>
                            <option value="1" >未处理</option>
                        </select>
                    </div>
                </div>
                <div class="layui-inline">
                    <button class="layui-btn layuiadmin-btn-useradmin" lay-submit="" lay-filter="searchBtn">
                        <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
                    </button>
                </div>

            </form>
            <div>
                <div class="layui-btn-group">
                    {{--<button class="layui-btn layui-btn-sm" id="listExport">导 出</button>--}}
                    <button class="layui-btn layui-btn-sm" id="listDelete">批量删除</button>
                </div>
            </div>
        </div>
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    {{--@can('zixun.article.edit')--}}
                    <a class="layui-btn layui-btn-sm" lay-event="edit">处理</a>
                    <a class="layui-btn layui-btn-sm layui-btn-danger" lay-event="del">删除</a>
                    {{--@endcan--}}
                </div>
            </script>
            <script type="text/html" id="thumb">
                <a href="@{{d.thumb}}" target="_blank" title="点击查看"><img src="@{{d.thumb}}" alt="" width="28" height="28"></a>
            </script>
            <script type="text/html" id="category">
                @{{ d.category.name }}
            </script>
        </div>
    </div>
@endsection

@section('script')
    {{--@can('zixun.article')--}}
    <script>
        layui.use(['layer','table','form','laydate'],function () {
            var layer = layui.layer;
            var form = layui.form;
            var table = layui.table;
            var laydate = layui.laydate;
            //用户表格初始化
            var dataTable = table.render({
                elem: '#dataTable'
                ,url: "{{ route('admin.report.data') }}" //数据接口
                ,page: true //开启分页
                ,limits: [50,100,200]
                ,limit: 50 //每页默认显示的数量
                ,cols: [[ //表头
                    {checkbox: true,fixed: true}
                    ,{field: 'id', title: 'ID',width:50}
                    ,{field: 'phone', title: '举报人'}
                    ,{field: 'category', title: '举报分类'}
                    ,{field: 'content', title: '举报内容'}
                    ,{field: 'product_name', title: '资源名称'}
                    ,{field: 'status', title: '处理状态',templet: function(d){
                        if(d.status == 1){
                            return '未处理';
                        }else{
                            return '已处理';
                        }
                    }
                    }
                    ,{field: 'created_at', title: '举报时间'}
                    ,{field: 'deal_content', title: '处理意见'}
                    ,{field: 'deal_at', title: '处理时间'}
                    ,{fixed: 'right', title:'操作',width: 150, align:'center', toolbar: '#options'}
                ]]
            });

            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                        ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent === 'del'){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("{{ route('admin.report.destroy') }}",{ids:[data.id]},function (result) {
                            if (result.code==0){
                                obj.del(); //删除对应行（tr）的DOM结构
                            }
                            layer.close(index);
                            layer.msg(result.msg,{icon:6})
                        });
                    });
                }
                else if(layEvent === 'edit'){
                    if(data.status == 2){
                        layer.msg('已经处理过了', {'icon': 2, 'time': 2000});
                    }else {
                        layer.open({
                            type: 0,
                            title: '编辑',
                            anim: 0,
                            scrollbar: false,
                            area: ["550px", "450px"],
                            content: '<form class="layui-form" id="addEmployeeForm">' +
                            ' <div class="layui-row layui-col-space10 layui-form-item">' +
                            '<div class="layui-col-lg9">' +
                            '<label class="layui-form-label">处理意见：</label>' +
                            '<div class="layui-input-block">' +
                            '<textarea  id="edit_content" onkeyup="onfo($(this))" class="layui-input" style="height: 150px;resize:none"></textarea>' +
                            '<span style=" position: absolute; color: #ccc;top: 125px;left: 200px;"><span id="count"></span></span>' +
                            '</div>' +
                            '</div>' +
                            '</div>' +
                            '</form>',
                            btn: ['确定'],
                            yes: function (index, layero) {
                                var edit_content = $("#edit_content").val();
                                if (!edit_content) {
                                    layer.msg("请输入处理意见", {icon: 2, time: 2000});
                                    return false;
                                } else if (edit_content.length > 255) {
                                    layer.msg("请输入255个字以内处理意见", {icon: 2, time: 2000});
                                    return false;
                                }
                                $.post('{{route('admin.report.update')}}',
                                        {
                                            edit_content: edit_content,
                                            id: data.id
                                        },
                                        function (data) {
                                            if (data.code == 0) {
                                                layer.msg(data.info, {'icon': 1, 'time': 2000});
                                                window.setTimeout(function () {
                                                    window.location.href = '/admin/report'
                                                }, 2000)
                                            } else {
                                                layer.msg(data.info, {'icon': 2, 'time': 2000});
                                            }
                                        })
                            }
                        });
                    }
                }
            });
            //按钮批量删除
            $("#listDelete").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                if (ids.length>0){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("{{ route('admin.report.destroy') }}",{ids:ids},function (result) {
                            if (result.code==0){
                                dataTable.reload()
                            }
                            layer.close(index);
                            layer.msg(result.msg,{icon:6})
                        });
                    })
                } else {
                    layer.msg('请选择删除项',{icon:5})
                }
            })
            //按钮批量导出
            $("#listExport").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                var idStr = '';
                if (ids.length>0){
                    idStr =  ids.join(",")
                }else{
                    idStr = '';
                }
                var channels_id = $("#channels_id").val()
                var reply_status = $("#reply_status").val();
                var start_time = $("#start_time").val();
                var end_time = $("#end_time").val();
                var phone = $("#phone").val();
                var u = '{{ route('admin.report.export') }}'
                u = u+'?channels_id='+channels_id+'&reply_status='+reply_status+'&start_time='+start_time+'&end_time='+end_time+'&phone='+phone+'&ids='+idStr
                window.location.href=u;
            })

            //监听搜索
            form.on('submit(searchBtn)', function(data){
                var field = data.field;
                console.log(data.field)
                //执行重载
                table.reload('dataTable', {
                    where: field
                    ,page: {
                        curr: 1 //重新从第 1 页开始
                    }
                });
                return false;
            });
            laydate.render({
                elem: '#start_time' //指定元素
                ,type: 'datetime'
            });
            laydate.render({
                elem: '#end_time' //指定元素
                ,type: 'datetime'
            });
        });

    </script>
    {{--@endcan--}}
@endsection