@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto">

            <div class="layui-form" >
                <div class="layui-btn-group">
                    {{--@can('system.role.destroy')--}}
                    {{--<button class="layui-btn layui-btn-sm layui-btn-danger" id="listDelete">删 除</button>--}}
                    {{--@endcan--}}
                    @can('system.role.create')
                        <a class="layui-btn layui-btn-sm" href="{{ route('admin.role.create') }}">添 加</a>
                    @endcan
                </div>
                <div class="layui-inline" style="float:right;margin-right:5%;">
                    <div class="layui-input-inline">
                        <select name="type">
                            <option value="">全部类型</option>
                            <option value="admin">后台管理员</option>
                            <option value="channel">渠道管理员</option>
                        </select>
                    </div>
                    <button class="layui-btn layui-btn-normal" lay-filter="LAY-user-back-search" lay-submit>搜索</button>
                </div>
            </div>

        </div>
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            <script type="text/html" id="options">
                {{--<div class="layui-btn-group">--}}
                    {{--@can('system.role.edit')--}}
                        {{--<a class="layui-btn layui-btn-sm" lay-event="edit">编辑</a>--}}
                    {{--@endcan--}}
                    {{--@can('system.role.permission')--}}
                        {{--<a class="layui-btn layui-btn-sm" lay-event="permission">权限</a>--}}
                    {{--@endcan--}}
                    {{--@can('system.role.destroy')--}}
                        {{--<a class="layui-btn layui-btn-danger layui-btn-sm" lay-event="del">删除</a>--}}
                    {{--@endcan--}}
                {{--</div>--}}
            </script>
        </div>
    </div>
@endsection

@section('script')
    @can('system.role')
    <script>
        layui.use(['layer','table','form'],function () {
            var layer = layui.layer;
            var form = layui.form;
            var table = layui.table;
            //用户表格初始化
            var dataTable = table.render({
                elem: '#dataTable'
                // ,height: 500
                ,url: "{{ route('admin.data') }}" //数据接口
                ,where:{model:"role"}
                ,page: true //开启分页
                ,cols: [[ //表头
                    // {checkbox: true,fixed: true},
                    // {field: 'id', title: 'ID',width:50}
                    {field: 'name', title: '角色标识'}
                    ,{field: 'display_name', title: '显示名称'}
                    ,{field: 'type', title: '角色类型',templet:function (item) {
                            return item.type==='admin'?'后台管理员':'渠道管理员';
                    }}
                    ,{field: 'created_at', title: '创建时间'}
                    ,{field: 'updated_at', title: '更新时间'}
//                    ,{title:'操作',width: 200, toolbar: '#options'}
                ]]
            });


            //监听搜索
            form.on('submit(LAY-user-back-search)', function(data){
                var field = data.field;

                //执行重载
                table.reload('dataTable', {
                    where: field
                    ,page:{
                        curr:1
                    }
                });
            });


            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                    ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent === 'del'){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("{{ route('admin.role.destroy') }}",{_method:'delete',ids:[data.id]},function (result) {
                            if (result.code==0){
                                delReload(dataTable)
                                layer.msg(result.msg,{icon:1})
                            }else {
                                layer.msg(result.msg,{icon:2})
                            }
                            layer.close(index);
                        });
                    });
                } else if(layEvent === 'edit'){
                    location.href = '/admin/role/'+data.id+'/edit';
                } else if (layEvent === 'permission'){
                    location.href = '/admin/role/'+data.id+'/permission';
                }
            });

            //按钮批量删除
            $("#listDelete").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                if (ids.length>0){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("{{ route('admin.role.destroy') }}",{_method:'delete',ids:ids},function (result) {
                            if (result.code==0){
                                delReload(dataTable,ids.length)
                            }
                            layer.close(index);
                            layer.msg(result.msg,{icon:6})
                        });
                    })
                }else {
                    layer.msg('请选择删除项',{icon:5})
                }
            })
        })
    </script>
    @endcan
@endsection