<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="pkg/lib.css">
    {{--<link rel="stylesheet" href="/admin/xx.css">--}}
    <link rel="stylesheet" href="pkg/common.css">
    <title>登录</title>
    <style>
        body,html{
            height: 100%;
            width:100%;
        }
        .logo-bg{
            position: relative;
            width:100%;
            height:100%;
            background: url('/images/1.jpg') no-repeat center center;
            background-size: 100% 100%;
        }
        .position-middle-center {
            border-radius: 4px;
            box-shadow:0 0 4px rgba(0,0,0,.1);
            width:560px;
            height:460px;
            background: rgba(17,105,170,0.2);
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%,-50%);
            -webkit-transform: translate(-50%,-50%);
            -o-transform: translate(-50%,-50%);
            -moz-transform: translate(-50%,-50%);
            -ms-transform: translate(-50%,-50%);
            border-radius: 4px;
        }
        .loginWraper{
            background: none;
            background-color: #fff;
            position: absolute;
            width: 100%;
            left: 0;
            top: 0;
            bottom: 0;
            right: 0;
        }
        .loginWraper>div{
            float: left;
            width: 50%;
            height: 100%;
            position: relative;
        }
        .banner_ img{
            width: 100%;
            height: 100%;
        }
        .loginWraper h3{
            font-size: 50px;
            letter-spacing: 2px;
            color: #1b203e;
            text-align: center;
            margin-top: 100px;
        }
        .loginBox{
            background: none;
            position: absolute;
            width: 617px;
            /*height: 330px;*/
            left: 50%;
            top: 50%;
            margin-left: -309px;
            margin-top: -184px;
            padding-top: 38px;
        }
        .form_item{
            width: 400px;
            margin: 0 auto 40px;
            border-bottom: 1px solid #ccc;
            line-height: 1.6;
            /* padding-bottom: 10px; */
        }
        .form_item input,
        .form_item input:hover{
            outline:none;
            border: none;
            font-size: 16px;
            height: 41px;
            padding: 8px;
            width: 360px;
        }
        .action{
            text-align: center;
        }
        .action input,
        .action input:hover{
            width: 200px;
            height: 60px;
            background-color: #004ae0;
            color: #fff;
            font-size: 20px;
            letter-spacing: 10px;
            text-align: center;
        }
    </style>
</head>

<body>

<div class="logo-bg">
    <div class="position-middle-center">
        <h2 style="text-align: center;padding: 20px 0;">后台管理系统登录</h2>
        <div id="loginform" class="loginBox">
            <form class="form form-horizontal" action="{{ url('login') }}" method="post">
                {!! csrf_field() !!}
                <div class="form_item">
                    <img src="/images/zhanghu.png" alt="">
                    <input type="text" class="txt" name="username" value="{{ old('username') }}" placeholder="输入您的账号">
                    <span></span>
                </div>
                <div class="form_item">
                    <img src="/images/mima.png" alt="">
                    <input type="password" class="txt" name="password" value="{{ old('password') }}" placeholder="输入您的密码">
                    <span></span>
                </div>
                <div class="form_item">
                    <img src="/images/yanzhengma.png" alt="">
                    <input type="text" class="txt txt1" name="captcha" value="" style="width:200px;" placeholder="输入验证码">
                    <img src="{{ captcha_src('flat') }}" class="yzm" title="点击更换验证码">
                    <a id="login-captcha" href="javascript:;" ></a>
                </div>
                <div class="action">
                    <input type="submit" value="登&nbsp;录" class="btn">
                </div>
            </form>
        </div>
    </div>
</div>
<script src="pkg/lib.js"></script>
<script src="pkg/common.js"></script>
<script>


    @if (count($errors) > 0)
        @foreach ($errors->all() as $key=>$error)
            @if($key==0)
                layer.msg("{{ $error }}", {icon: 2, time: 2000});
    @endif
@endforeach
@endif


$(function(){
        $(".yzm").click(function(){
            $(this).attr("src", "{{ captcha_src('flat') }}?_t" + Math.random());
        });
    });
</script>
</body>

</html>