@if ($paginator->hasPages())
    <div class="page bgff wrap tx-c" >
        <div class="layui-box layui-laypage layui-laypage-default" id="layui-laypage-2">
        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
            <a href="javascript:;" class="layui-laypage-prev layui-disabled" data-page="">首页</a>
        @else
            <a href="{{ $paginator->previousPageUrl() }}" class="layui-laypage-prev" data-page="0">上一页</a>
        @endif

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
            {{-- "Three Dots" Separator --}}
            {{-- Array Of Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <span class="layui-laypage-curr"><em class="layui-laypage-em"></em><em>{{ $page }}</em></span>
                    @else
                        <a href="{{ $url }}" data-page="{{ $page }}">{{ $page }}</a>
                    @endif
                @endforeach
            @else
                <span>...</span>
            @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())

            <a href="{{ $paginator->nextPageUrl() }}" class="layui-laypage-next" data-page="">下一页</a>
        @else

            <a href="javascript:;" class="layui-laypage-last" title="尾页" data-page="">尾页</a>
        @endif
    </div>
    </div>
@endif
