@extends('layouts.advert.member')
@section('title','购物车列表')
@section('content')
    <div>
        <div class="fz18 bb-e0e0e0 pb10">购物车列表</div>
        <form class="layui-form mt20">
            <form class="layui-form-item">
                <label class="layui-form-label" style="width:88px;">资源类型</label>
                <div class="layui-inline" style="min-width:195px;">
                    <select name="type" id="platform_register">
                        <option value="">全部</option>
                        @if($productType)
                            @foreach($productType as $item)
                            <option value="{{ $item->id }}" data-type="{{$item->tag}}">{{ $item->name }}</option>
                            @endforeach
                        @endif
                    </select>
                </div>
                <div class="layui-inline">
                    <button class="layui-btn layuiadmin-btn-useradmin" lay-submit="" lay-filter="searchBtn">
                        <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
                    </button>
                </div>
            </form>
        </form>
        <div class="section_mol mt20" >
            <button class="layui-btn " id="listPay"  data-type="add">批量下单</button>
            <button class="layui-btn layui-btn-danger" id="listDelete" data-type="add">批量删除</button>
        </div>
        <table id="dataTable" lay-filter="dataTable" ></table>
    </div>
@endsection
@section('script')
<script type="text/html" id="options">
    <div class="layui-btn-group">
        @{{# if(d.product.status == 1){}}
        <a class="layui-btn layui-btn-sm" lay-event="order_pay">下单</a>
        @{{# }}}
    </div>
</script>

<script>
    var   list  = [];
    var string = '提示'
    $.ajax({
        type: "get",
        url:"{{ url('advert/member/get/fodder')}}",
        dataType: "json",
        async:false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(data){
            list = data.data
        },
    });

    layui.use(['form','table','layer'], function () {
        var form = layui.form;
        var layer = layui.layer;
        var table = layui.table;
        //各种基于事件的操作，下面会有进一步介绍\
        var dataTable = table.render({
            elem: '#dataTable'
            ,autoSort: false //禁用前端自动排序。注意：该参数为 layui 2.4.4 新增
            ,url: "{{ url('advert/member/cart/data') }}" //数据接口
            ,page: true //开启分页
            ,limits: [50,100,200]
            ,limit: 20 //每页默认显示的数量
            ,cols: [[ //表头
                {checkbox: true,fixed: false}
                ,{field: 'id', title: '编号',width:80,templet: function(d){
                    return d.id
                }}
                ,{field: 'name', title: '资源名称',templet: function(d){
                    return d.product.name
                }}

                ,{field: 'status', title: '资源状态',templet: function(d){
                    if(d.product.status ==1 ){
                        return '正常'
                    }else{
                        return '已下架'
                    }
                }}
                ,{field: 'created_at', title: '加入时间'}
                ,{field: 'money', title: '价格',templet: function(d){
                    return d.product.quota_min+'元'
                }}
                ,{title:'操作',width: 80, toolbar: '#options'}
            ]]

        });

        //监听工具条
        table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data //获得当前行数据
                ,layEvent = obj.event; //获得 lay-event 对应的值
            if(layEvent === 'del'){
                layer.confirm('确认删除吗？', function(index){
                    var  ids = [];
                    ids[0] =data.id;
                    $.ajax({
                        type: "get",
                        url:"/advert/member/cart/destroy",
                        dataType: "json",
                        data:{'ids':ids},
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(data){
                            layer.close(index);
                            if(data.code == '200')
                            {
                                layer.msg(data.info);
                                setTimeout(function(){
                                    window.parent.location.reload();
                                },1000);
                            }else{
                                layer.msg(data.info);
                            }
                        },
                    });
                });
            }else if(layEvent==='order_pay'){
                var  type = $("#platform_register").find("option:selected").attr("data-type");
                var t = 'article'
                if(type){
                   t = type;
                }
                window.location.href = allAPI.order.create+'/'+t+'?ids='+data.id+'&type_id='+data.type;
            }
        });
        //监听搜索
        form.on('submit(searchBtn)', function(data){
            var field = data.field;
            //执行重载
            table.reload('dataTable', {
                where: field
                ,page: {
                    curr: 1 //重新从第 1 页开始
                }
            });
            return false;
        });

        //按钮批量
        $("#listDelete").click(function () {
            var ids = []
            var hasCheck = table.checkStatus('dataTable')
            var hasCheckData = hasCheck.data
            if (hasCheckData.length>0){
                $.each(hasCheckData,function (index,element) {
                    ids.push(element.id)
                })
            }
            if (ids.length>0){
                layer.confirm('确认删除？', function(index){
                    $.ajax({
                        type: "get",
                        url:"/advert/member/cart/destroy",
                        dataType: "json",
                        data:{'ids':ids},
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(data){
                            if(data.code == '200')
                            {
                                layer.msg(data.info);
                                setTimeout(function(){
                                    window.parent.location.reload();
                                },1000);
                            }else{
                                layer.msg(data.info);
                            }
                        }
                    });
                })
            }else {
                layer.msg('请选择删除项')
            }
        })
        //批量下单
        $("#listPay").click(function () {
            var ids = []
            var hasCheck = table.checkStatus('dataTable')
            var hasCheckData = hasCheck.data
            var all_money = 0;
            if (hasCheckData.length>0){
                $.each(hasCheckData,function (index,element) {
                    ids.push(element.id)
                    all_money+= element.product.quota_min
                })
            }
            if (ids.length>0 && $('#platform_register').val()){
                var type = $("#platform_register").find("option:selected").attr("data-type")
                var type_id = $("#platform_register").find("option:selected").val()
                window.location.href = allAPI.order.create+'/'+type+'?ids='+ids.join()+'&type_id='+type_id;
            }else {
                if(!$('#platform_register').val()){
                    layer.msg('批量下单只支持同一种类型,请先选择！')
                }else{
                    layer.msg('请选择下单编号')
                }

            }
        })

    });
    //拼接支付信息
    function  fileContent(all_money) {
        var contents = '<div id="files">' +
            '<div class="layui-form-item cus">' +
            '<div class="layui-inline">' +
            '<label class="layui-form-label">' +
            '<i style="color: red">*</i>选择素材</label>' +
            '<select  id="fodder" name="modules" lay-verify="required" class="layui-form-label" style="width:200px;">'+
            '<option value="">请选择</option>'
        jQuery.each(list, function(i,el) {
            contents  += ' <option value="'+el.id+'">'+el.file_name+'</option>'
        });
        contents+='</select></div></div>'
        contents +='<div class="layui-form-item pas">'+
            ' <label class="layui-form-label">' +
            '<i style="color: red">*</i>密码</label>'+
            '<div class="layui-input-block">'+
            ' <input type="password" placeholder="请输入" id="pay_pass" autocomplete="off" class="layui-input" style="width:200px;">'+
            ' </div>'+
            '</div>'
        contents +='<div class="layui-form-item pas">'+
            ' <label class="layui-form-label">金额</label>'+
            '<div class="layui-input-block">'+
            ' <input type="number"  value="'+all_money+'" id="pay_pass"  readonly  class="layui-input" style="width:200px;">'+
            ' </div>'+
            '</div>'+
            '</div>';

        return contents;
    }
    //验证密码
    function  toVerity(pay_pass,platform,type,channel,file_id,apply_id) {
        $.ajax({
            type: "post",
            url:"{{ url('advert/member/verify/pass')}}",
            dataType: "json",
            data:{'pay_pass':pay_pass,'platform':platform,'type': type,'channel':channel,'file_id':file_id,'apply_id':apply_id},
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(data){
                if(data.code == 1)
                {
                    if(data.message =='请先设置支付密码')
                    {
                        layer.msg(data.message);
                        setTimeout(function(){
                            window.location.href='/index/member/pay/pass';
                        },2000);
                    }else{
                        layer.msg(data.message);
                        return
                    }
                }else{
                    //发起支付
                    goPay(platform,type,channel,file_id,apply_id)
                }
            },
        });
    }
    //发起支付
    function goPay(platform,type,channel,file_id,apply_id) {
        $.ajax({
            type: "post",
            url:"{{ url('/advert/member/order/pay')}}",
            dataType: "json",
            data:{'platform':platform,'type': type,'channel':channel,'file_id':file_id,'apply_id':apply_id},
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(data){
                if(data.code == '200')
                {
                    layer.msg(data.info);
                    setTimeout(function(){
                        window.parent.location.reload();
                    },2000);
                }else{
                    layer.msg(data.info);
                }
            },
        });
    }
</script>
@endsection