@extends('layouts.advert.member')
@section('title','新增素材')
@section('content')
    <style>
        .list_Box li{
            padding: 15px 0 15px 15px;
            border-left: 2px solid #fff;
            cursor: pointer;
        }
        .list_Box li.active {
            border-left-color: #009688;
            color: #009688;
            background: #f0f0f0;
        }
    </style>
    <div class="fr bgff p20" style="width:1040px;">
        <div class="layui-tab layui-tab-brief" lay-filter="docDemoTabBrief">
            <ul class="layui-tab-title">
                <li class="layui-this">创建素材</li>
            </ul>
            <div class="w1200 clearfix mb80">
                <div class="w890">
                    <!--rank_nav end -->
                    <div class="section_mol plr30">
                        <form class="layui-form" action="/advert/member/file/update" method="post">
                            <div class="layui-form-item">
                                <input type="hidden" name="id" value="{{$file->id}}">
                                <label class="layui-form-label" style="width: 86px">资源名称</label>
                                <div class="layui-input-block">
                                    <input type="text" name="title" value="{{$file->title}}" required lay-verify="required" placeholder="请输入标题" autocomplete="off" class="layui-input">
                                </div>
                            </div>
                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                            <div class="layui-form-item layui-form-text type_online">
                                <label class="layui-form-label" style="width: 86px">在线编辑</label>
                                <div class="layui-input-block">
                                    @if($file->type == 2)
                                        <textarea name="content" placeholder="请输入内容" id="container" class="layui-textarea">{{$file->content}}</textarea>
                                    @else
                                        <textarea name="content" placeholder="请输入内容" id="container" class="layui-textarea">{{$file->content}}</textarea>
                                    @endif
                                </div>
                            </div>
                            <div class="layui-form-item ">
                                <div class="layui-input-block">
                                    <button class="layui-btn" lay-submit lay-filter="formDemo" onclick="postFile()">立即提交</button>
                                    <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    @include('vendor.ueditor.assets')
    <script type="text/javascript">
        var ue = UE.getEditor('container',{  toolbars: [
            ['fullscreen', 'source', 'undo', 'redo','bold', 'italic', 'underline', 'simpleupload', 'fontborder', 'cleardoc']
        ],
            initialFrameWidth : 800,
            initialFrameHeight: 400,
            autoHeightEnabled: false
        });

        ue.ready(function() {
            ue.execCommand('serverparam', '_token', '{{ csrf_token() }}'); // 设置 CSRF token.
        });
    </script>
    <!-- 编辑器容器 -->
    <script id="container" name="content" type="text/plain"></script>
    <script>
        layui.use(['form','upload'], function () {
            var form = layui.form;
            //监听提交
            form.on('submit(formDemo)', function(data){
                var type = data.field.type;
                /* if(type == 1 && data.field.file == '')
                 {
                 layer.msg('请上传附件');
                 return false;
                 }else*/ if(type == 2 && data.field.content == '')
                {
                    layer.msg('请编辑内容');
                    return false;
                }
                return true;
            });
            //各种基于事件的操作，下面会有进一步介绍
            var upload = layui.upload;
            upload.render({
                elem: '#test8', // 文件选择
                accept: 'file',
                multiple: false,
                url: '/uploadFile',
                auto: true, // 设置不自动提交
                exts: 'doc|docx|zip', //只允许上传word
                size:'102400',
                done: function (res) {
                    if(res.code == 0) {
                        $('#fileupload').val(res.data.url)
                        $('#uploadName').html(res.data.name)
                        $('#uploadName1').val(res.data.name)
                        layer.msg('上传成功', {icon: 1});
                    }else{
                        layer.msg('上传失败', {icon: 2});
                    }
                },
                error: function (res) {
                    layer.msg('上传失败', {icon: 2});
                }
            });
            form.on('radio(click_type)', function (data) {
                var click_type =data.value;
                if(click_type == 1)
                {
                    $('.type_online').hide()
                    $('.type_file').show()
                }else{
                    $('.type_file').hide()
                    $('.type_online').show()
                }
            });
        });

    </script>
@endsection