@extends('layouts.advert.member')
@section('title','订单列表')
@section('content')
<div>
    <div class="fz18 bb-e0e0e0 pb10">订单列表</div>
    <button class="layui-btn layui-btn-danger mt20" id="listDelete" data-type="add">订单删除</button>
    <table id="dataTable" lay-filter="dataTable" ></table>  
</div>
@endsection
@section('script')
<script type="text/html" id="options">
        <div class="layui-btn-group">
                @{{# if(d.status == 1){}}
                         <a class="layui-btn layui-btn-sm layui-btn-warm" lay-event="add">去支付</a>
                    {{--@{{# if(d.type_id == 1 || d.type_id == 6 || d.type_id == 4 ){}}
                        <a class="layui-btn layui-btn-sm layui-btn-warm" lay-event="add" data="min">去支付</a>
                    @{{# }else {}}
                        @{{# if(d.type_id == 2 || d.type_id == 3  ){}}
                             <a class="layui-btn layui-btn-sm layui-btn-warm" lay-event="add" data="min">硬广支付</a>
                             <a class="layui-btn layui-btn-sm layui-btn-warm" lay-event="add" data="max">软广支付</a>
                        @{{# }else {}}
                             <a class="layui-btn layui-btn-sm layui-btn-warm" lay-event="add" data="min">笔记支付</a>
                             <a class="layui-btn layui-btn-sm layui-btn-warm" lay-event="add" data="max">视频支付</a>
                        @{{# }}}
                    @{{# }}}--}}
                @{{# }else {}}
                <a class="layui-btn layui-btn-sm" lay-event="">已支付</a>
                @{{# }}}
            @{{# if(d.status > 1){}}
                <a class="layui-btn layui-btn-sm layui-btn-normal" style="margin-left:2px!important;" lay-event="edit">查看</a>
            @{{# }}}
        </div>
</script>
<script>
    $(function(){
        t = "{{$type}}";
    })

    layui.use(['form','table'], function () {
        var form = layui.form;
        var table = layui.table;
        //各种基于事件的操作，下面会有进一步介绍\
        var dataTable = table.render({
            elem: '#dataTable'
            ,autoSort: false //禁用前端自动排序。注意：该参数为 layui 2.4.4 新增
            ,url: "{{ url('/advert/member/order/post') }}"+'?t='+t //数据接口
            ,page: true //开启分页
            ,limits: [50,100,200]
            ,limit: 20 //每页默认显示的数量
            ,cols: [[ //表头
                {checkbox:true ,fixed: false,width:40}
               /* ,{field: 'id', title: '订单号',width:80}*/
                ,{field: 'order_no', title: '订单号',width:150}
                ,{field: 'product_name', title: '资源名称',templet: function(d){
                    if(d.product)
                    {
                        return  d.product.name;
                    }else{
                        return  '';
                    }

                }}
               // ,{field: 'type_id', title: '资源类型'}
                ,{field: 'type', title: '完成链接',templet: function(d){
                    if(d.result_url){
                        return '<a href="'+d.result_url+'" target="view_frame"  style="color: #00b7ee">'+d.result_url+'</a>';
                    }else{
                        return '';
                    }
                }}
                ,{field: 'created_at', title: '下单时间'}
                ,{field: 'file_name', title: '素材',templet: function(d){
                    if(d.order_active)
                    {
                        if (d.order_active.source_type == 'link') {

                            return '<a href="' + d.order_active.link + '" target="view_frame"  style="color: #00b7ee">' + d.order_active.link + '</a>';
                        }else if (d.order_active.source_type == 'file') {

                            return d.file_name;
                        }
                        else if (d.order_active.source_type == 'upload') {
                            return  d.order_active.title;
                        }else{
                             return '暂无内容'
                        }
                    }else{
                        return '';
                    }

                }
                }
                ,{field: 'money', title: '支付金额',templet: function(d){
                    if(d.money) {
                        return d.money + '元';
                    }else{
                        return '';
                    }
                }
                }
                ,{field: 'status', title: '执行状态',width:80,templet: function(d){
                    if(d.status){
                        if(d.status == 3){
                            return '已拒单';
                        }
                        if(d.status == 4){
                            return '执行中';
                        }
                        if(d.status == 5){
                            return '已完成';
                        }
                        if(d.status == 6){
                            return '已退单';
                        }
                        if(d.status == 7){
                            return '媒体主已完成';
                        }else{
                            return '待执行';
                        }
                    }else{
                        return '未支付';
                    }
                }}
                ,{title:'操作',width: 165, toolbar: '#options'}
            ]]

        });
        //监听工具条
        table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data //获得当前行数据
                ,layEvent = obj.event; //获得 lay-event 对应的值
            if(layEvent==='edit'){
                location.href = '/advert/member/order/detail/'+data.id;
            }
            if(layEvent==='add'){
                //获取当前的数据
                location.href = allAPI.order.repay+'/'+data.id;
            }
        });
        //按钮批量删除
        $("#listDelete").click(function () {
            var ids = []
            var hasCheck = table.checkStatus('dataTable')
            var hasCheckData = hasCheck.data
            if (hasCheckData.length>0){
                $.each(hasCheckData,function (index,element) {
                    ids.push(element.id)
                })
            }
            if (ids.length>0){
                layer.confirm('确认删除吗？', function(index){
                    $.ajax({
                        type: "post",
                        url:"/advert/member/order/destroy/"+ids,
                        dataType: "json",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(data){
                            if(data.code == '200')
                            {
                                setTimeout(function(){
                                    window.parent.location.reload();
                                },1000);
                            }else{
                                layer.msg(data.info);
                            }
                        },
                    });
                })
            }else {
                layer.msg('请选择删除项')
            }
        })
    });
</script>
@endsection