@extends('layouts.advert.member')
@section('title','余额流水')
@section('content')
    <div>
        <div class="fz18 bb-e0e0e0 pb10">余额流水</div>
        <table id="dataTable" class="mt20" lay-filter="dataTable" ></table>
    </div>
@endsection
@section('script')
    <script>
        layui.use(['form','table'], function () {
            var form = layui.form;
            var table = layui.table;
            //各种基于事件的操作，下面会有进一步介绍\
            var dataTable = table.render({
                elem: '#dataTable'
                ,autoSort: false //禁用前端自动排序。注意：该参数为 layui 2.4.4 新增
                ,url: "{{ url('advert/member/money/record/data') }}" //数据接口
                ,page: true //开启分页
                ,limits: [50,100,200]
                ,limit: 20 //每页默认显示的数量
                ,cols: [[ //表头
                    {field: 'id', title: '编号',width:80}
                    ,{field: 'money', title: '金额',width:100}
                    ,{field: 'pay_type',width:100, title: '类型',templet: function(d){
                        if(d.type == '1') {
                            return '<span style="color:orangered">支出</span>';
                        }else if(d.type == '2'){
                            return '<span style="color:green">充值</span>';
                        }else if(d.type == '3'){
                            return '<span style="color:green">退单退款</span>';
                        }else if(d.type == '4'){
                            return '<span style="color:green">结算冻结金额</span>';
                        }else if(d.type == '5'){
                            return '<span style="color:green">后台充值</span>';
                        }else if(d.type == '6'){
                            return '<span style="color:green">广告主申请退款</span>';
                        }else{
                            return '<span style="color:dodgerblue">媒体主提现</span>';
                        }
                    }
                    }
                    ,{field: 'total_money', title: '可用余额',width:150}
                    ,{field: 'freeze_money', title: '冻结金额',width:100}
                    ,{field: 'mark', title: '明细'}
                    ,{field: 'created_at', title: '时间'}

                ]]
            });
            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                    ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent === 'del'){
                }else if(layEvent==='edit'){
                    location.href = '/index/loan/'+data.product.id;
                }
            });

        });

    </script>
@endsection