@extends('layouts.advert.member')
@section('title','安全设置')
@section('content')
    <style>
       .layui-form-label {
            width:110px;
        }
    </style>
    <div>
        <div class="fz18 bb-e0e0e0 pb10">登录密码</div>
        <form class="layui-form pt20" action="/advert/member/safe/edit" method="post">
            <input type="hidden" name="_token" value="{{ csrf_token() }}">
            <div class="layui-form-item">
                <label class="layui-form-label"><span class="span-dot">*</span>旧密码</label>
                <div class="layui-input-inline">
                    <input type="password" name="old_password" lay-verify="required" minlength="6"  maxlength="16" placeholder="请输入密码" autocomplete="off" class="layui-input">
                </div>
                <div class="layui-form-mid layui-word-aux">请填写6到16位旧密码</div>
            </div>
            <div class="layui-form-item">
                <label class="layui-form-label"><span class="span-dot">*</span>新密码</label>
                <div class="layui-input-inline">
                    <input type="password" name="new_password" lay-verify="required" minlength="6"  maxlength="16"  placeholder="请输入密码" autocomplete="off" class="layui-input">
                </div>
                <div class="layui-form-mid layui-word-aux">请填写6到16位新密码,且只能是数字、字符</div>
            </div>
            <div class="layui-form-item pt20">
                <div class="layui-input-block">
                    <button class="layui-btn" lay-submit="" lay-filter="demo1">立即提交</button>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('script')
    <script>
        layui.use(['form','table'], function () {
            var form = layui.form;
            //监听提交
            form.on('submit(demo1)', function(data){
                var pay_pass = data.field.new_password;
                var Regx = /^[A-Za-z0-9]*$/;
                if (Regx.test(pay_pass)) {
                    return true;
                }
                else {
                    layer.msg('密码不能包含特殊字符');
                    return false;
                }
            });
        });
    </script>
@endsection

