@extends('layouts.advert.member')
@section('title','会员中心')
@section('content')
   
    <div>
        <div class="fz18 bb-e0e0e0 pb10 ">素材列表</div>
        <table class="mt20" id="dataTable" lay-filter="dataTable" ></table>
    </div>
@endsection
@section('script')
    <script type="text/html" id="options">
        <div class="layui-btn-group">
            {{-- @{{# if(d.type == 2){}}--}}
            <a class="layui-btn layui-btn-sm" lay-event="edit">查看详情</a>
            {{--  @{{# }}}--}}
        </div>
    </script>
    <script>
        layui.use(['form','table'], function () {
            var form = layui.form;
            var table = layui.table;
            //各种基于事件的操作，下面会有进一步介绍\
            var dataTable = table.render({
                elem: '#dataTable'
                ,autoSort: false //禁用前端自动排序。注意：该参数为 layui 2.4.4 新增
                ,url: "{{ url('/advert/member/resource/data') }}" //数据接口
                ,page: true //开启分页
                ,limits: [50,100,200]
                ,limit: 20 //每页默认显示的数量
                ,cols: [[ //表头
                    {field: 'id', title: '编号',width:150}
                    ,{field: 'title', title: '标题'}
                    ,{field: 'type', title: '类型',templet: function(d){
                        if(d.type == 1){
                            return '附件'
                        }else{
                            return '在线编辑';
                        }
                    }}
                    ,{field: 'file_name', title: '文件名称'}
                    ,{field: 'type_info', title: '资源类型',templet: function(d){
                        if(d.type_info){
                            return d.type_info.name
                        }else{
                            return '';
                        }
                    }}
                    ,{field: 'created_at', title: '创建时间'}
                    ,{title:'操作',width: 100, toolbar: '#options'}
                ]]

            });
            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                    ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent==='edit'){
                    location.href = '/advert/member/file/'+data.id;
                }
            });

        });

    </script>
@endsection