<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>找回密码 - {{ $web_site ? $web_site->company_name :'宗师堂' }}</title>
    <link rel="stylesheet" href="/assets/css/reset.css">
    <link rel="stylesheet" href="/assets/css/header.css">
    <link rel="stylesheet" href="/layui/css/layui.css">
    <link rel="stylesheet" href="/assets/css/loginbox.css">
    <script src="/assets/js/jquery-3.3.1.min.js"></script>
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>
</head>
<body>
<!-- 顶部导航1 -->
<section class="bgff">
    <div class="wrap">
        <div class="top-logo pcub">
            <div class="pcub pcub-ac pcub-f1">
                <img class="logo-img mr40" src="/images/logo.png" alt="">
            </div>
            <div class="pcub pcub-ac tx-r fz20">
                <a class="logo-nav-li pointer _h100 plr10 ml40" href="{{ url('/') }}">首页</a>
                <a class="logo-nav-li pointer _h100 plr10 ml40" href="{{ url('/') }}">软文发稿</a>
                <a class="logo-nav-li pointer _h100 plr10 ml40" href="{{ url('/') }}">自媒体</a>
                <a class="logo-nav-li pointer _h100 plr10 ml40" href="{{ url('/') }}">微信推广</a>
                <a class="logo-nav-li pointer _h100 plr10 ml40" href="{{ url('/') }}">微博推广</a>
                <a class="logo-nav-li pointer _h100 plr10 ml40" href="{{ url('/') }}">小红书</a>
                <a class="logo-nav-li pointer _h100 plr10 ml40" href="{{ url('/') }}">直播/短视频</a>
            </div>
        </div>
    </div>
</section>
<!-- 找回密码 -->
<section id="find-password" class="wrap bgff p20 mtb20 minh" style="height:500px;">
    <div class="bb-e0e0e0 h40 fz20 mb20">
        找回密码
    </div>
    <ul class="steps fz12">
        <li class="item s1 active">
            <b>1</b>
            <span>身份验证</span>
        </li>
        <li class="item s2">
            <b>2</b>
            <span>设置新密码</span>
        </li>
        <li class="item s3">
            <b>3</b>
            <span>完成</span>
        </li>
    </ul>
    <div class="content tx-c fz16 content-s1" >
        <div class="pcub h40 fptitle" data-type="1">
            <div class="pcub-f1">
                <span class="pointer active" data-type="1">广告主</span>
            </div>
            <div class="pcub-f1">
                <span class="pointer" data-type="2">媒体主</span>
            </div>
        </div>
        <ul>
            <li class="item user mt20">
                <input type="text" placeholder="请输入手机号" maxlength="11">
            </li>
            <li class="mt20 fz12">
                <button class="btn" onclick="nextStep(1)" type="button">获取验证码</button>
            </li>
        </ul>
    </div>
    <div class="content tx-c fz16 content-s2" style="display:none;">
        <div class="pcub pcub-ac fz14 reph">找回手机号：<span></span></div>
        <ul>
            <li class="item code mt20 position-re">
                <input type="text" placeholder="请输入验证码">
            </li>
            <li class="item password pw1 mt20">
                <input type="password" placeholder="请输入新密码">
            </li>
            <!-- <li class="item password pw2 mt20">
                <input type="password" placeholder="请输入密码">
            </li> -->
            <li class="mt20 fz12">
                <button class="btn" onclick="nextStep(2)" type="button">下一步</button>
            </li>
        </ul>
    </div>
    <div class="content tx-c fz16 content-s3" style="display:none;">
        <ul>
            <li class="mt20 pcub pcub-pc tx-l">
                <img src="/images/car01.png" alt="" style="width:80px;height:80px;">
                <div class="ml20">
                    <p class="fz24 mt10">密码设置成功</p>
                    <p class="fz14 mt10">请使用新密码登录，感谢您的支持</p>
                </div>
            </li>
            <li class="mt40">
                <a class="btn" href="{{ url('/index') }}">马上登录</a>
            </li>
        </ul>
    </div>
</section>
@include('layouts.advert.footer')
<script src="/layui/layui.js"></script>
<script src="/assets/js/check.js"></script>
<script src="/assets/js/global.js"></script>
<script src="/assets/js/common.js"></script>
<script src="/assets/js/forgot.js"></script>
</body>

</html>