<?php
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/', function () {
    return redirect('/index');
});

Route::group(['namespace'=>'Admin','prefix'=>'admin'],function (){
    //登录、注销
    Route::get('admin/login','LoginController@showLoginForm')->name('admin.loginForm');
    Route::post('admin/login','LoginController@login')->name('admin.login');
    Route::post('admin/logout','LoginController@logout')->name('admin.logout');

});
Route::group(['middleware'=>['log']],function (){
    Auth::routes();
    Route::post('uploadImage','Admin\PublicController@uploadImage')->name('uploadImage');
    Route::post('commonUpload','Admin\PublicController@commonUpload')->name('upload');
    Route::post('uploadFile','Admin\PublicController@uploadFile')->name('uploadFile');
    Route::post('uploadApk','Admin\PublicController@uploadApk')->name('uploadApk');
});

Route::group(['namespace'=>'Admin','middleware'=>['auth','admin'],'prefix'=>'admin'],function (\Illuminate\Routing\Router $router){

    $router->get('home','HomeController@layout')->name('admin.home');
    $router->get('index','HomeController@index')->name('admin.index');
    $router->get('icons','IndexController@icons')->name('admin.icons');

    $router->get('password','UserController@showPasswordForm')->name('admin.getPassword');
    $router->post('password','UserController@password')->name('admin.postPassword');

    //工单系统
    $router->get('work/single','WorkSingleController@index')->name('admin.work.single');//列表
    $router->get('work/single/data','WorkSingleController@data')->name('admin.work.single.data');//数据
    $router->get('work/single/create','WorkSingleController@create')->name('admin.work.single.create');//申请
    $router->post('work/single/store','WorkSingleController@store')->name('admin.work.single.store');//提交
});
//系统管理
Route::group(['namespace'=>'Admin','prefix'=>'admin','middleware'=>['auth','admin','permission:system.manage']],function (){
    //数据表格接口
    Route::get('data','IndexController@data')->name('admin.data')->middleware('permission:system.role|system.user|system.permission');
    //用户管理
    Route::group(['middleware'=>['permission:system.user']],function (){
        Route::get('user','UserController@index')->name('admin.user');
        //添加
        Route::get('user/create','UserController@create')->name('admin.user.create')->middleware('permission:system.user.create');
        Route::post('user/store','UserController@store')->name('admin.user.store')->middleware('permission:system.user.create');
        //编辑
        Route::get('user/{id}/edit','UserController@edit')->name('admin.user.edit')->middleware('permission:system.user.edit');
        Route::put('user/{id}/update','UserController@update')->name('admin.user.update')->middleware('permission:system.user.edit');
        //启用禁用
        Route::post('user/status','UserController@status')->name('admin.user.status')->middleware('permission:system.user.status');
        //删除
        Route::delete('user/destroy/{id?}','UserController@destroy')->name('admin.user.destroy')->middleware('permission:system.user.destroy');
        //分配角色
        Route::get('user/{id}/role','UserController@role')->name('admin.user.role')->middleware('permission:system.user.role');
        Route::put('user/{id}/assignRole','UserController@assignRole')->name('admin.user.assignRole')->middleware('permission:system.user.role');
        //分配权限
        Route::get('user/{id}/permission','UserController@permission')->name('admin.user.permission')->middleware('permission:system.user.permission');
        Route::put('user/{id}/assignPermission','UserController@assignPermission')->name('admin.user.assignPermission')->middleware('permission:system.user.permission');
    });
    //角色管理
    Route::group(['middleware'=>'permission:system.role'],function (){
        Route::get('role','RoleController@index')->name('admin.role');
        //添加
        Route::get('role/create','RoleController@create')->name('admin.role.create')->middleware('permission:system.role.create');
        Route::post('role/store','RoleController@store')->name('admin.role.store')->middleware('permission:system.role.create');
        //编辑
        Route::get('role/{id}/edit','RoleController@edit')->name('admin.role.edit')->middleware('permission:system.role.edit');
        Route::put('role/{id}/update','RoleController@update')->name('admin.role.update')->middleware('permission:system.role.edit');
        //删除
        Route::delete('role/destroy','RoleController@destroy')->name('admin.role.destroy')->middleware('permission:system.role.destroy');
        //分配权限
        Route::get('role/{id}/permission','RoleController@permission')->name('admin.role.permission')->middleware('permission:system.role.permission');
        Route::put('role/{id}/assignPermission','RoleController@assignPermission')->name('admin.role.assignPermission')->middleware('permission:system.role.permission');
    });
    //权限管理
    Route::group(['middleware'=>'permission:system.permission'],function (){
        Route::get('permission','PermissionController@index')->name('admin.permission');
        //添加
        Route::get('permission/create','PermissionController@create')->name('admin.permission.create')->middleware('permission:system.permission.create');
        Route::post('permission/store','PermissionController@store')->name('admin.permission.store')->middleware('permission:system.permission.create');
        //编辑
        Route::get('permission/{id}/edit','PermissionController@edit')->name('admin.permission.edit')->middleware('permission:system.permission.edit');
        Route::put('permission/{id}/update','PermissionController@update')->name('admin.permission.update')->middleware('permission:system.permission.edit');
        //删除
//        Route::delete('permission/destroy','PermissionController@destroy')->name('admin.permission.destroy')->middleware('permission:system.permission.destroy');
        Route::delete('permission/destroy/{id?}','PermissionController@destroy')->name('admin.permission.destroy')->middleware('permission:system.permission.destroy');
        Route::post('permission/sort','PermissionController@sort')->name('admin.permission.sort');
    });
    //菜单管理
});


//会员管理
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth', 'permission:member.manage']], function () {
//Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth','admin']], function () {
    //用户信息
//    Route::group(['middleware' => 'permission:member.member'], function () {
    Route::get('member/data', 'MemberController@data')->name('admin.member.data');
    Route::get('member', 'MemberController@index')->name('admin.member')->middleware('permission:admin.member.member');
    /*媒体列表*/
    Route::get('member/media', 'MemberController@media')->name('admin.member.media')->middleware('permission:admin.member.member');
    /*代理管理*/
    Route::get('member/agent', 'MemberController@agent')->name('admin.member.agent')->middleware('permission:admin.member.member');
    /*媒体列表*/
    Route::get('member/toExcel', 'MemberController@toExcel')->name('admin.member.toExcel')->middleware('permission:admin.member.member.toExcel');
    Route::delete('member/destroy', 'MemberController@destroy')->name('admin.member.destroy');
    Route::post('member/set', 'MemberController@setStatus')->name('admin.member.set');
    Route::post('member/disable', 'MemberController@disable')->name('admin.member.disable');

    /**代理模块**/
    Route::get('agent','UserAgentController@index')->name('admin.agent');//代理列表
    Route::get('agent/data','UserAgentController@data')->name('admin.agent.data');//代理列表数据
    Route::get('agent/setting','UserAgentController@setting')->name('admin.agent.setting');//代理设置
    Route::get('agent/setting/create','UserAgentController@create')->name('admin.agent.setting.create');//代理设置创建
    Route::get('agent/setting/{id}/edit','UserAgentController@edit')->name('admin.agent.setting.edit');//代理设置编辑
    Route::get('agent/setting/data','UserAgentController@settingData')->name('admin.agent.setting.data');//代理设置数据
    Route::post('agent/setting/update','UserAgentController@update')->name('admin.agent.setting.update');//代理设置上传

    Route::get('agent/charge/setting','UserAgentController@chargeSetting')->name('admin.agent.charge.setting');//代理充值类型设置
    Route::post('agent/charge/setting/update','UserAgentController@settingUpdate')->name('admin.charge.agent.setting.update');//代理设置
    Route::get('agent/account','UserAgentController@account')->name('admin.agent.account');//代理财务
//    });
    //意向管理
    /*平台订单*/
    Route::get('apply', 'ApplyController@index')->name('admin.apply')->middleware('permission:admin.member.apply');
    /*媒体主订单*/
    Route::get('apply/media', 'ApplyController@media')->name('admin.apply.media')->middleware('permission:admin.member.apply');
    /*云资源订单*/
    Route::get('apply/cloud', 'ApplyController@cloud')->name('admin.apply.cloud')->middleware('permission:admin.member.apply');
    Route::get('apply/cloud/type', 'ApplyController@typeCloud')->name('admin.apply.cloud.type');
    Route::get('apply/data', 'ApplyController@data')->name('admin.apply.data');
    Route::get('apply/{id}/edit', 'ApplyController@edit')->name('admin.apply.edit');
    Route::post('apply/{id}/edit', 'ApplyController@update')->name('admin.apply.edit');
    Route::post('apply/cancel', 'ApplyController@cancel')->name('admin.apply.cancel');
    Route::post('apply/go/pay', 'ApplyController@againOrderPay')->name('admin.apply.cloud.pay');
    Route::post('apply/cloud/show', 'ApplyController@cloudOrderShow')->name('admin.apply.cloud.show');
    Route::get('apply/toExcel', 'ApplyController@toExcel')->name('admin.apply.toExcel')->middleware('permission:admin.member.apply.toExcel');
    //云资源配置
    Route::get('cloud/config/index', 'CloudConfigController@index')->name('admin.cloudconfig.index');
    Route::post('cloud/config/update', 'CloudConfigController@update')->name('admin.cloudconfig.update');

    //综合行为日志
    Route::get('behaviorlog','BehaviorLogController@index')->name('admin.behaviorlog')->middleware('permission:admin.member.behaviorlog');
    Route::get('behaviorlog/data','BehaviorLogController@data')->name('admin.behaviorlog.data');
    Route::get('behaviorlog/toExcel','BehaviorLogController@toExcel')->name('admin.behaviorlog.toExcel')->middleware('permission:admin.member.behaviorlog.toExcel');

    //用户模型
    Route::get('userModel','UserModelController@index')->name('admin.userModel')->middleware('permission:admin.member.userModel');
    Route::get('userModel/data','UserModelController@data')->name('admin.userModel.data');

    Route::get('userModel/create','UserModelController@create')->name('admin.userModel.create')->middleware('permission:admin.member.userModel.create');
    Route::post('userModel/store','UserModelController@store')->name('admin.userModel.store')->middleware('permission:admin.member.userModel.create');

    Route::get('userModel/{id}/edit','UserModelController@edit')->name('admin.userModel.edit')->middleware('permission:admin.member.userModel.edit');
    Route::put('userModel/{id}/update','UserModelController@update')->name('admin.userModel.update')->middleware('permission:admin.member.userModel.edit');

    Route::get('userModel/refreshSnapshot','UserModelController@refreshSnapshot')->name('admin.userModel.refreshSnapshot'); //手动刷新全部模型快照
    Route::get('userModel/cronRefreshSnapshot','UserModelController@cronRefreshSnapshot'); //定时任务刷新全部模型快照
});

//渠道管理
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth','admin','permission:channel.manage']], function () {
    Route::post('channel/viaDepartmentGetChannel','ChannelController@viaDepartmentGetChannel')->name('channel.viaDepartmentGetChannel');

    //部门管理
    Route::get('channel/department','DepartmentController@index')->name('admin.channel.department')->middleware('permission:admin.channel.department');
    Route::get('channel/department/data','DepartmentController@data')->name('admin.channel.department.data');

    Route::get('channel/department/create','DepartmentController@create')->name('admin.channel.department.create')->middleware('permission:admin.channel.department.create');
    Route::post('channel/department/store','DepartmentController@store')->name('admin.channel.department.store')->middleware('permission:admin.channel.department.create');

    Route::get('channel/department/{id}/edit','DepartmentController@edit')->name('admin.channel.department.edit')->middleware('permission:admin.channel.department.edit');
    Route::put('channel/department/{id}/update','DepartmentController@update')->name('admin.channel.department.update')->middleware('permission:admin.channel.department.edit');

    Route::delete('channel/department/destroy', 'DepartmentController@destroy')->name('admin.channel.department.destroy')->middleware('permission:admin.channel.department.destroy');


    //渠道管理
    Route::get('channel','ChannelController@index')->name('admin.channel')->middleware('permission:admin.channel.channel');
    Route::get('channel/data','ChannelController@data')->name('admin.channel.data');

    Route::get('channel/create','ChannelController@create')->name('admin.channel.create')->middleware('permission:admin.channel.channel.create');
    Route::post('channel/store','ChannelController@store')->name('admin.channel.store')->middleware('permission:admin.channel.channel.create');

    Route::post('channel/status','ChannelController@status')->name('admin.channel.status')->middleware('permission:admin.channel.channel.status');//停用状态
    Route::post('channel/redirect_status','ChannelController@redirect_status')->name('admin.channel.redirect_status')->middleware('permission:admin.channel.channel.redirect_status');//跳转状态
    Route::post('channel/dealAtSet','ChannelController@dealAtSet')->name('admin.channel.dealAtSet')->middleware('permission:admin.channel.channel.dealAtSet');//结算时间
    Route::post('channel/disable','ChannelController@disable')->name('admin.channel.disable')->middleware('permission:admin.channel.channel.status');//批量停用
    Route::get('channel/toExcel','ChannelController@toExcel')->name('admin.channel.toExcel')->middleware('permission:admin.channel.channel.toExcel');//导出

    Route::get('channel/{id}/edit','ChannelController@edit')->name('admin.channel.edit')->middleware('permission:admin.channel.channel.edit');
//    Route::put('channel/{id}/update','ChannelController@update')->name('admin.channel.update');
    Route::put('channel/{id}/update','ChannelController@update')->name('admin.channel.update')->middleware('permission:admin.channel.channel.edit');

    Route::delete('channel/destroy', 'ChannelController@destroy')->name('admin.channel.destroy')->middleware('permission:admin.channel.channel.destroy');

    //模板管理
    Route::get('distributeTemplate','DistributeTemplateController@index')->name('admin.channel.distributeTemplate')->middleware('permission:admin.channel.distributeTemplate');
    Route::get('distributeTemplate/data','DistributeTemplateController@data')->name('admin.channel.distributeTemplate.data');

    Route::get('distributeTemplate/create','DistributeTemplateController@create')->name('admin.channel.distributeTemplate.create')->middleware('permission:admin.channel.distributeTemplate.create');
    Route::post('distributeTemplate/store','DistributeTemplateController@store')->name('admin.channel.distributeTemplate.store')->middleware('permission:admin.channel.distributeTemplate.create');

    Route::get('distributeTemplate/{id}/edit','DistributeTemplateController@edit')->name('admin.channel.distributeTemplate.edit')->middleware('permission:admin.channel.distributeTemplate.edit');
    Route::put('distributeTemplate/{id}/update','DistributeTemplateController@update')->name('admin.channel.distributeTemplate.update')->middleware('permission:admin.channel.distributeTemplate.edit');


    //分发管理

    Route::get('distribute/{id}','DistributeController@index')->name('admin.channel.distribute')->middleware('permission:admin.channel.distribute');//显示app和分发页

    Route::get('distribute/{id}/data','DistributeController@data')->name('admin.channel.distribute.data');//分发data

    Route::get('distribute/{id}/create','DistributeController@create')->name('admin.channel.distribute.create')->middleware('permission:admin.channel.distribute.create');//添加app
    Route::post('distribute/{id}/store','DistributeController@store')->name('admin.channel.distribute.store')->middleware('permission:admin.channel.distribute.create');//保存app

    Route::get('distribute/{id}/edit','DistributeController@edit')->name('admin.channel.distribute.edit')->middleware('permission:admin.channel.distribute.edit');//修改app
    Route::put('distribute/{id}/update','DistributeController@update')->name('admin.channel.distribute.update')->middleware('permission:admin.channel.distribute.edit');//保存app

    Route::delete('distribute/destroy', 'DistributeController@destroy')->name('admin.channel.distribute.destroy')->middleware('permission:admin.channel.distribute.destroy');//删除app


    Route::get('distribute/{id}/createDistribute','DistributeController@createDistribute')->name('admin.channel.distribute.createDistribute')->middleware('permission:admin.channel.distribute.createDistribute');//添加分发页
    Route::post('distribute/{id}/storeDistribute','DistributeController@storeDistribute')->name('admin.channel.distribute.storeDistribute')->middleware('permission:admin.channel.distribute.createDistribute');//保存分发页

    Route::get('distribute/{id}/editDistribute','DistributeController@editDistribute')->name('admin.channel.distribute.editDistribute')->middleware('permission:admin.channel.distribute.editDistribute');//修改分发页
    Route::post('distribute/status','DistributeController@status')->name('admin.channel.distribute.status')->middleware('permission:admin.channel.distribute.status');//修改分发页状态
    Route::put('distribute/{id}/updateDistribute','DistributeController@updateDistribute')->name('admin.channel.distribute.updateDistribute')->middleware('permission:admin.channel.distribute.editDistribute');//保存分发页

    Route::delete('distribute/destroyDistribute', 'DistributeController@destroyDistribute')->name('admin.channel.distribute.destroyDistribute')->middleware('permission:admin.channel.distribute.destroyDistribute');//删除分发页

    //扣量设置
    Route::get('channelReduce','ChannelReduceController@index')->name('admin.channel.channelReduce')->middleware('permission:admin.channel.channelReduce');
    Route::get('channelReduce/data','ChannelReduceController@data')->name('admin.channel.channelReduce.data');

    Route::get('channelReduce/toExcel','ChannelReduceController@toExcel')->name('admin.channel.channelReduce.toExcel')->middleware('permission:admin.channel.channelReduce.toExcel');

    //扣量修改
    Route::put('channelReduce/{id}/update','ChannelReduceController@update')->name('admin.channel.channelReduce.update')->middleware('permission:admin.channel.channelReduce.edit');
    //扣量记录
    Route::get('channelReduce/{id}/reduceRecord','ChannelReduceController@reduceRecord')->name('admin.channel.channelReduce.reduceRecord')->middleware('permission:admin.channel.channelReduce.reduceRecord');
    Route::get('channelReduce/{id}/reduceRecordData','ChannelReduceController@reduceRecordData')->name('admin.channel.channelReduce.reduceRecordData');




});


//消息管理
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth','admin', 'permission:message.manage']], function () {
    //消息管理
    Route::group(['middleware' => 'permission:message.message'], function () {
        Route::get('message/data', 'MessageController@data')->name('admin.message.data');
        Route::get('message/getUser', 'MessageController@getUser')->name('admin.message.getUser');
        Route::get('message', 'MessageController@index')->name('admin.message');
        //添加
        Route::get('message/create', 'MessageController@create')->name('admin.message.create')->middleware('permission:message.message.create');
        Route::post('message/store', 'MessageController@store')->name('admin.message.store')->middleware('permission:message.message.create');
        //删除
        Route::delete('message/destroy', 'MessageController@destroy')->name('admin.message.destroy')->middleware('permission:message.message.destroy');
        //我的消息
        Route::get('mine/message', 'MessageController@mine')->name('admin.message.mine')->middleware('permission:message.message.mine');
        Route::post('message/{id}/read', 'MessageController@read')->name('admin.message.read')->middleware('permission:message.message.mine');

        Route::get('message/count', 'MessageController@getMessageCount')->name('admin.message.get_count');
    });
});

/*批量调价*/
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth', 'admin','permission:batch.manage']], function () {
    Route::get('product/set/price/{type}', 'ProductBatchController@create')->name('admin.product.price');
    Route::post('product/set/price/store', 'ProductBatchController@store')->name('admin.product.price');
    Route::get('product/batch', 'ProductBatchController@index')->name('admin.product.batch');
    Route::get('product/batch/data', 'ProductBatchController@data')->name('admin.product.batch.data');

});

//门户管理
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth', 'admin','permission:website.manage']], function () {

    //门户管理
    Route::get('website', 'WebSiteController@index')->name('admin.website')->middleware('permission:admin.website.website');
    Route::put('website/update', 'WebSiteController@update')->name('admin.website.update')->middleware('permission:admin.website.update');

    //营销位
    Route::get('website/image', 'ImageController@index')->name('admin.website.image')->middleware('permission:admin.website.image');
    Route::get('website/image/data', 'ImageController@data')->name('admin.website.image.data');

    Route::get('website/image/{id}/edit', 'ImageController@edit')->name('admin.website.image.edit')->middleware('permission:admin.website.image.edit');
    Route::post('website/image/store', 'ImageController@store')->name('admin.website.image.store')->middleware('permission:admin.website.image.create');
    Route::put('website/image/{id}/update', 'ImageController@update')->name('admin.website.image.update')->middleware('permission:admin.website.image.edit');
    Route::delete('website/image/destroy/{id?}', 'ImageController@destroy')->name('admin.website.image.destroy')->middleware('permission:admin.website.image.destroy');

    //发现管理
    Route::get('website/article','ArticleController@index')->name('admin.website.article')->middleware('permission:admin.website.article');
    Route::get('website/article/data','ArticleController@data')->name('admin.website.article.data');

    //修改状态
    Route::post('website/article/status','ArticleController@status')->name('admin.website.article.status');
    //添加
    Route::get('website/article/create','ArticleController@create')->name('admin.website.article.create')->middleware('permission:admin.website.article.create');
    Route::post('website/article/store','ArticleController@store')->name('admin.website.article.store')->middleware('permission:admin.website.article.create');
    //修改
    Route::get('website/article/{id}/edit','ArticleController@edit')->name('admin.website.article.edit')->middleware('permission:admin.website.article.edit');
    Route::put('website/article/{id}/update','ArticleController@update')->name('admin.website.article.update')->middleware('permission:admin.website.article.edit');
    //删除
    Route::delete('website/article/destroy/{id?}','ArticleController@destroy')->name('admin.website.article.destroy')->middleware('permission:admin.website.article.destroy');

    //帮助管理
    Route::get('website/help','HelpController@index')->name('admin.website.help')->middleware('permission:admin.website.help');
    Route::get('website/help/data','HelpController@data')->name('admin.website.help.data');
    //添加
    Route::get('website/help/create','HelpController@create')->name('admin.website.help.create')->middleware('permission:admin.website.help.create');
    Route::post('website/help/store','HelpController@store')->name('admin.website.help.store')->middleware('permission:admin.website.help.create');
    //编辑
    Route::get('website/help/{id}/edit','HelpController@edit')->name('admin.website.help.edit')->middleware('permission:admin.website.help.edit');
    Route::put('website/help/{id}/update','HelpController@update')->name('admin.website.help.update')->middleware('permission:admin.website.help.edit');
    //删除
    Route::delete('website/help/destroy/{id?}','HelpController@destroy')->name('admin.website.help.destroy')->middleware('permission:admin.website.help.destroy');


    //圈子管理
    Route::get('website/circle','CircleController@index')->name('admin.website.circle')->middleware('permission:admin.website.circle');
    Route::get('website/circle/data','CircleController@data')->name('admin.website.circle.data');
    //添加
    Route::get('website/circle/create','CircleController@create')->name('admin.website.circle.create')->middleware('permission:admin.website.circle.create');
    Route::post('website/circle/store','CircleController@store')->name('admin.website.circle.store')->middleware('permission:admin.website.circle.create');
    //编辑
    Route::get('website/circle/{id}/edit','CircleController@edit')->name('admin.website.circle.edit')->middleware('permission:admin.website.circle.edit');
    Route::put('website/circle/{id}/update','CircleController@update')->name('admin.website.circle.update')->middleware('permission:admin.website.circle.edit');
    //删除
    Route::delete('website/circle/destroy/{id?}','CircleController@destroy')->name('admin.website.circle.destroy')->middleware('permission:admin.website.circle.destroy');

    //媒介经理
    Route::get('setting/manager', 'SettingManagerController@index')->name('admin.setting.manager')->middleware('permission:admin.setting.manager');
    Route::get('setting/manager/data', 'SettingManagerController@data')->name('admin.setting.manager.data');
    Route::get('setting/manager/{id}/edit', 'SettingManagerController@edit')->name('admin.setting.manager.edit')->middleware('permission:admin.setting.manager.update');
    Route::post('setting/manager/update', 'SettingManagerController@update')->name('admin.setting.manager.update')->middleware('permission:admin.setting.manager.update');


//    });

});

//资源
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth','admin']], function () {
    Route::get('credit', 'CreditController@index')->name('admin.credit');
    Route::get('credit/create', 'CreditController@create')->name('admin.credit.create');
    Route::post('credit/create', 'CreditController@store')->name('admin.credit.create');

    Route::get('credit/data', 'CreditController@data')->name('admin.credit.data');

    Route::get('credit/{id}/edit', 'CreditController@edit')->name('admin.credit.edit');
    Route::post('credit/{id}/edit', 'CreditController@update')->name('admin.credit.edit');

    Route::post('credit/set', 'CreditController@setStatus')->name('admin.credit.set');
    Route::get('credit/excel', 'CreditController@exportExcelData')->name('admin.credit.excel');
});

//财务管理
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth','admin']], function () {
    Route::get('account', 'MemberAccountController@index')->name('admin.account');
    Route::get('account/data', 'MemberAccountController@data')->name('admin.account.data');
    Route::get('account/excel', 'MemberAccountController@exportExcelData')->name('admin.account.excel');
    Route::get('account/{id}/edit', 'MemberAccountController@edit')->name('admin.account.edit');
    Route::get('account/create', 'MemberAccountController@create')->name('admin.account.create');
    Route::post('account/create', 'MemberAccountController@store')->name('admin.account.create');
    Route::post('account/check', 'MemberAccountController@checkPhone')->name('admin.account.check');
    Route::post('account/refund/check', 'MemberAccountController@refundCheck')->name('admin.account.refund');
    Route::post('account/refund/cash', 'MemberAccountController@cashCheck')->name('admin.account.cash');
    /*支付配置*/
    Route::get('pay', 'PayController@index')->name('admin.pay');
    Route::get('pay/data', 'PayController@data')->name('admin.pay.data');
    Route::get('pay/{id}/edit', 'PayController@edit')->name('admin.pay.edit');
    Route::post('pay/{id}/edit', 'PayController@update')->name('admin.pay.edit');
    /*支付配置*/
    /*资源举报*/
    Route::get('report', 'ReportController@index')->name('admin.report');
    Route::get('report/data', 'ReportController@data')->name('admin.report.data');
    Route::post('report/update', 'ReportController@update')->name('admin.report.update');
    Route::get('report/export', 'ReportController@export')->name('admin.report.export');
    Route::post('report/destroy', 'ReportController@destroy')->name('admin.report.destroy');
    /*资源举报*/
    /*短信配置*/
    Route::get('sms', 'SmsController@index')->name('admin.sysmsg');
    Route::get('version', 'SmsController@getVersion')->name('admin.version');
    Route::get('sms/data', 'SmsController@data')->name('admin.sysmsg.data');
    Route::get('sms/{id}/edit', 'SmsController@edit')->name('admin.sysmsg.edit');
    Route::post('sms/{id}/edit', 'SmsController@update')->name('admin.sysmsg.edit');
    Route::get('sms/create', 'SmsController@create')->name('admin.sysmsg.create');
    Route::post('sms/create', 'SmsController@store')->name('admin.sysmsg.create');
    Route::get('sms/recharge', 'SmsController@recharge')->name('admin.sysmsg.recharge');//充值列表
    Route::get('sms/recharge/data', 'SmsController@rechargeData')->name('admin.sysmsg.recharge.data');//充值列表
    Route::get('sms/charge', 'SmsController@charge')->name('admin.sysmsg.charge');//充值
    Route::get('sms/template', 'SmsController@getTemplate')->name('admin.sysmsg.template');//充值
    /*短信配置*/
    /*退款申请*/
    Route::get('refund', 'RefundController@index')->name('admin.refund');
    Route::get('refund/create', 'RefundController@create')->name('admin.refund.create');
    Route::post('refund/create', 'RefundController@store')->name('admin.refund.create');
    Route::get('refund/{id}/edit', 'RefundController@edit')->name('admin.refund.edit');
    Route::post('refund/{id}/edit', 'RefundController@update')->name('admin.refund.edit');
    Route::post('refund/create', 'RefundController@store')->name('admin.refund.create');
    Route::get('refund/data', 'RefundController@data')->name('admin.refund.data');
    Route::get('refund/excel', 'RefundController@exportExcelData')->name('admin.refund.excel');
    /*提现申请*/
    Route::get('cash', 'CashOutController@index')->name('admin.cash');
    Route::get('cash/data', 'CashOutController@data')->name('admin.cash.data');
    Route::get('cash/{id}/edit', 'CashOutController@edit')->name('admin.cash.edit');
    Route::post('cash/{id}/edit', 'CashOutController@update')->name('admin.cash.edit');
    Route::get('cash/excel', 'CashOutController@exportExcelData')->name('admin.cash.excel');
    /*提现退款比例*/
    Route::get('cash/rate', 'CashRateController@index')->name('admin.cash.rate');
    Route::get('cash/rate/data', 'CashRateController@data')->name('admin.cash.rate.data');
    Route::get('cash/rate/{id}/edit', 'CashRateController@edit')->name('admin.cash.rate.edit');
    Route::post('cash/rate/{id}/edit', 'CashRateController@store')->name('admin.cash.rate.edit');
    /*云资源财务列表*/
    Route::get('cloud/cash', 'CloudCashController@index')->name('admin.cloud.cash');
    Route::get('cloud/cash/data', 'CloudCashController@data')->name('admin.cloud.cash.data');
    Route::get('cloud/cash/excel', 'CloudCashController@excel')->name('admin.cloud.cash.excel');
});


//推送消息
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth','admin']], function () {
    Route::get('push', 'MessageController@index')->name('admin.push');
    Route::get('push/create', 'MessageController@create')->name('admin.push.create');
    Route::post('push/create', 'MessageController@store')->name('admin.push.create');

    Route::get('system/create', 'MessageController@system')->name('admin.system.create');
    Route::post('system/create', 'MessageController@systemSave')->name('admin.system.create');

    Route::get('system/{id}/edit', 'MessageController@edit')->name('admin.system.edit');
    Route::post('system/{id}/edit', 'MessageController@systemUpdate')->name('admin.system.edit');

    Route::get('push/data', 'MessageController@data')->name('admin.push.data');
    Route::get('push/excel', 'MessageController@exportExcelData')->name('admin.push.excel');

    Route::get('push/{id}/edit', 'MessageController@edit')->name('admin.push.edit');
    Route::post('push/{id}/edit', 'MessageController@update')->name('admin.push.edit');

    Route::post('push/get/count', 'MessageController@getCountsOfSelect')->name('admin.push.count');//异步查询号码数量

    Route::post('push/set', 'MessageController@setStatus')->name('admin.push.set');
    Route::post('push/excel', 'MessageController@importExcelData')->name('admin.push.import');//数据导入
});
//反馈管理
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth','admin']], function () {
    Route::get('feedback', 'FeedBackController@index')->name('admin.feedback');
    Route::post('feedback', 'FeedBackController@store')->name('admin.feedback');

    Route::get('feedback/export', 'FeedBackController@export')->name('admin.feedback.export');//导出

    Route::get('feedback/data', 'FeedBackController@data')->name('admin.feedback.data');

    Route::get('feedback/{id}/edit', 'FeedBackController@edit')->name('admin.feedback.edit');
    Route::post('feedback/{id}/edit', 'FeedBackController@update')->name('admin.feedback.edit');

    //评论管理
    Route::get('comment', 'CommentController@index')->name('admin.comment');//评论管理
    Route::get('comment/data', 'CommentController@data')->name('admin.comment.data');//评论数据
    Route::get('comment/{id}/edit', 'CommentController@edit')->name('admin.comment.edit');//评论回复
    Route::post('comment/update', 'CommentController@update')->name('admin.comment.update');//评论回复提交
    Route::post('comment/auditPass', 'CommentController@batchAuditPass')->name('admin.comment.auditPass');//批量通过
    Route::post('comment/notAuditPass', 'CommentController@batchNotAuditPass')->name('admin.comment.notAuditPass');//批量不予通过
    Route::post('comment/auditDestroy', 'CommentController@batchDestroy')->name('admin.comment.auditDestroy');//批量删除
    Route::get('comment/export', 'CommentController@batchExport')->name('admin.comment.export');//导出
    Route::delete('comment/destroy', 'CommentController@destroy')->name('admin.comment.destroy');//删除评论
    //评论池管理
    Route::get('virtual/comment/index', 'VirtualCommentController@index')->name('admin.virtual.comment.index');//评论池管理
    Route::get('virtual/comment/data', 'VirtualCommentController@data')->name('admin.virtual.comment.data');//评论池数据
    Route::post('virtual/comment/update', 'VirtualCommentController@update')->name('admin.virtual.comment.update');//编辑提交
    Route::get('virtual/comment/down/template', 'VirtualCommentController@downTemplate')->name('admin.virtual.comment.down.template');//下载模板
    Route::post('virtual/comment/import/template', 'VirtualCommentController@importTemplate')->name('admin.virtual.comment.import.template');//导入数据
    Route::get('virtual/comment/export', 'VirtualCommentController@export')->name('admin.virtual.comment.export');//导出
    Route::delete('virtual/comment/destroy', 'VirtualCommentController@destroy')->name('admin.virtual.comment.destroy');//删除评论
    Route::post('virtual/comment/audit/destroy', 'VirtualCommentController@VirtualDestroy')->name('admin.virtual.comment.audit.destroy');//批量删除
    //新增评论
    Route::get('virtual/comment/create', 'VirtualCommentController@create')->name('admin.virtual.comment.create');//评论池管理
    Route::get('virtual/comment/product/data', 'VirtualCommentController@productData')->name('admin.virtual.comment.product.data');//获取产品
    Route::post('virtual/comment/post/data', 'VirtualCommentController@postData')->name('admin.virtual.comment.post.data');//编辑提交


});
//基础数据
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth', 'permission:data.manage','admin']], function () {
    //数据字典
    Route::group(['middleware' => 'permission:data.dictionary'], function () {

        Route::get('dictionary', 'DictionaryController@index')->name('admin.dictionary');
        Route::get('dictionary/data', 'DictionaryController@data')->name('admin.dictionary.data');

        Route::post('dictionary/sync', 'DictionaryController@sync')->name('admin.dictionary.sync');//字典同步

        Route::get('dictionary/create', 'DictionaryController@create')->name('admin.dictionary.create')->middleware('permission:data.dictionary.edit');
        Route::post('dictionary/store','DictionaryController@store')->name('admin.dictionary.store')->middleware('permission:data.dictionary.edit');

        Route::get('product/material','ProductMaterialController@index')->name('admin.product.material')->middleware('permission:data.dictionary.edit');
        Route::post('product/material/store','ProductMaterialController@store')->name('admin.product.material.store')->middleware('permission:data.dictionary.edit');

        //频道
        Route::get('product/channel','ProductChannelController@index')->name('admin.product.channel')->middleware('permission:data.dictionary.edit');
        Route::post('product/channel/store','ProductChannelController@store')->name('admin.product.channel.store')->middleware('permission:data.dictionary.edit');
        //资源类别
        Route::get('product/resource','ProductResourceController@index')->name('admin.product.resource')->middleware('permission:data.dictionary.edit');
        Route::post('product/resource/store','ProductResourceController@store')->name('admin.product.resource.store')->middleware('permission:data.dictionary.edit');
        //资源视频平台
        Route::get('product/video','ProductVideoController@index')->name('admin.product.video')->middleware('permission:data.dictionary.edit');
        Route::post('product/video/store','ProductVideoController@store')->name('admin.product.video.store')->middleware('permission:data.dictionary.edit');
        //资源视频行业
        Route::get('product/trade','ProductTradeController@index')->name('admin.product.trade')->middleware('permission:data.dictionary.edit');
        Route::post('product/trade/store','ProductTradeController@store')->name('admin.product.trade.store')->middleware('permission:data.dictionary.edit');
        //自媒体
        Route::get('product/zimeiti','ProductZimeitiChannelController@index')->name('admin.product.zimeiti');
        Route::post('product/zimeiti/store','ProductZimeitiChannelController@store')->name('admin.product.zimeiti.store');
        //标签
        Route::get('product/label','ProductLabelController@index')->name('admin.product.label')->middleware('permission:data.dictionary.edit');
        Route::post('product/label/store','ProductLabelController@store')->name('admin.product.label.store')->middleware('permission:data.dictionary.edit');

        //入口形式
        Route::get('product/from/type','ProductArticleFromTypeController@index')->name('admin.product.from.type')->middleware('permission:data.dictionary.edit');
        Route::post('product/from/type/store','ProductArticleFromTypeController@store')->name('admin.product.from.type.store')->middleware('permission:data.dictionary.edit');

        //区间
        Route::get('product/quota','ProductQuotaController@index')->name('admin.product.quota')->middleware('permission:data.dictionary.edit');
        Route::post('product/quota/store','ProductQuotaController@store')->name('admin.product.quota.store')->middleware('permission:data.dictionary.edit');
        //fans
        Route::get('product/fans','ProductRangeFanController@index')->name('admin.product.fans')->middleware('permission:data.dictionary.edit');
        Route::post('product/fans/store','ProductRangeFanController@store')->name('admin.product.fans.store')->middleware('permission:data.dictionary.edit');
        //views
        Route::get('product/views','ProductRangeViewController@index')->name('admin.product.views')->middleware('permission:data.dictionary.edit');
        Route::post('product/views/store','ProductRangeViewController@store')->name('admin.product.views.store')->middleware('permission:data.dictionary.edit');
        //还款周期
        Route::get('product/repay','ProductRepayController@index')->name('admin.product.repay')->middleware('permission:data.dictionary.edit');
        Route::post('product/repay/store','ProductRepayController@store')->name('admin.product.repay.store')->middleware('permission:data.dictionary.edit');
        //
        Route::get('product/website','ProductWebsiteController@index')->name('admin.product.website')->middleware('permission:data.dictionary.edit');
        Route::post('product/website/store','ProductWebsiteController@store')->name('admin.product.website.store')->middleware('permission:data.dictionary.edit');
        //

        Route::get('product/type','ProductTypeController@index')->name('admin.product.type')->middleware('permission:data.dictionary.edit');
        Route::post('product/type/store','ProductTypeController@store')->name('admin.product.type.store')->middleware('permission:data.dictionary.edit');

        Route::get('product/collection','ProductCollectionNameController@index')->name('admin.product.collection')->middleware('permission:data.dictionary.edit');
        Route::post('product/collection/store','ProductCollectionNameController@store')->name('admin.product.collection.store')->middleware('permission:data.dictionary.edit');

        Route::get('product/corner','CornerController@product')->name('admin.product.corner')->middleware('permission:data.dictionary.edit');
        Route::post('product/corner/store','CornerController@storeProduct')->name('admin.product.corner.store')->middleware('permission:data.dictionary.edit');

        Route::get('credit/corner','CornerController@credit')->name('admin.credit.corner')->middleware('permission:data.dictionary.edit');
        Route::post('credit/corner/store','CornerController@storeCredit')->name('admin.credit.corner.store')->middleware('permission:data.dictionary.edit');

        Route::get('credit/bank','CreditBankController@index')->name('admin.credit.bank')->middleware('permission:data.dictionary.edit');
        Route::post('credit/bank/store','CreditBankController@store')->name('admin.credit.bank.store')->middleware('permission:data.dictionary.edit');

        Route::get('credit/level','CreditLevelController@index')->name('admin.credit.level')->middleware('permission:data.dictionary.edit');
        Route::post('credit/level/store','CreditLevelController@store')->name('admin.credit.level.store')->middleware('permission:data.dictionary.edit');

        Route::get('credit/organization','CreditOrgController@index')->name('admin.credit.organization')->middleware('permission:data.dictionary.edit');
        Route::post('credit/organization/store','CreditOrgController@store')->name('admin.credit.organization.store')->middleware('permission:data.dictionary.edit');

        Route::get('article/corner','CornerController@article')->name('admin.article.corner')->middleware('permission:data.dictionary.edit');
        Route::post('article/corner/store','CornerController@storeArticle')->name('admin.article.corner.store')->middleware('permission:data.dictionary.edit');

        Route::get('article/category','ArticleCategoryController@index')->name('admin.article.category')->middleware('permission:data.dictionary.edit');
        Route::post('article/category/store','ArticleCategoryController@store')->name('admin.article.category.store')->middleware('permission:data.dictionary.edit');

        Route::get('feedback/category','FeedbackCategoryController@index')->name('admin.feedback.category')->middleware('permission:data.dictionary.edit');
        Route::post('feedback/category/store','FeedbackCategoryController@store')->name('admin.feedback.category.store')->middleware('permission:data.dictionary.edit');

        Route::get('report/category','ReportCategoryController@index')->name('admin.report.category')->middleware('permission:data.dictionary.edit');
        Route::post('report/category/store','ReportCategoryController@store')->name('admin.report.category.store')->middleware('permission:data.dictionary.edit');


    });

    //单页管理
    Route::group(['middleware' => 'permission:data.page'], function () {

        //列表
        Route::get('page', 'PageController@index')->name('admin.page');
        Route::get('page/data', 'PageController@data')->name('admin.page.data');
        //添加
        Route::get('page/create', 'PageController@create')->name('admin.page.create')->middleware('permission:data.page.create');
        Route::post('page/store', 'PageController@store')->name('admin.page.store')->middleware('permission:data.page.create');
        Route::get('page/{id}/edit', 'PageController@edit')->name('admin.page.edit')->middleware('permission:data.page.edit');
        Route::put('page/{id}/update', 'PageController@update')->name('admin.page.update')->middleware('permission:data.page.edit');
        //删除
        Route::delete('page/destroy', 'PageController@destroy')->name('admin.page.destroy')->middleware('permission:data.page.destroy');

    });

    //虚拟号码池
    Route::group(['middleware' => 'permission:data.virtualPhone'], function () {

        //列表
        Route::get('virtualPhone', 'VirtualPhoneController@index')->name('admin.virtualPhone');
        Route::get('virtualPhone/data', 'VirtualPhoneController@data')->name('admin.virtualPhone.data');
        //添加
        Route::get('virtualPhone/create', 'VirtualPhoneController@create')->name('admin.virtualPhone.create')->middleware('permission:data.virtualPhone.create');
        Route::post('virtualPhone/store', 'VirtualPhoneController@store')->name('admin.virtualPhone.store')->middleware('permission:data.virtualPhone.create');
        Route::get('virtualPhone/{id}/edit', 'VirtualPhoneController@edit')->name('admin.virtualPhone.edit')->middleware('permission:data.virtualPhone.edit');
        Route::put('virtualPhone/{id}/update', 'VirtualPhoneController@update')->name('admin.virtualPhone.update')->middleware('permission:data.virtualPhone.edit');
        //删除
        Route::delete('virtualPhone/destroy', 'VirtualPhoneController@destroy')->name('admin.virtualPhone.destroy')->middleware('permission:data.virtualPhone.destroy');
        Route::delete('virtualPhone/destroyAll', 'VirtualPhoneController@destroyAll')->name('admin.virtualPhone.destroyAll')->middleware('permission:data.virtualPhone.destroyAll');

    });

    //省市区管理
    Route::group(['middleware' => 'permission:data.district'], function () {

        //省份列表
        Route::get('district', 'DistrictController@index')->name('admin.district');
        Route::get('district/data', 'DistrictController@data')->name('admin.district.data');

    });

    //热门城市
    Route::group(['middleware' => 'permission:data.hotCity'], function () {

        Route::get('hotCity', 'DistrictController@hotCity')->name('admin.hotCity');
        Route::get('hotCity/data', 'DistrictController@hotCityData')->name('admin.hotCity.data');
        Route::get('hotCity/create', 'DistrictController@hotCityCreate')->name('admin.hotCity.create')->middleware('permission:data.hotCity.create');
        Route::post('hotCity/store', 'DistrictController@hotCityStore')->name('admin.hotCity.store')->middleware('permission:data.hotCity.create');
        Route::get('hotCity/{id?}/edit', 'DistrictController@hotCityEdit')->name('admin.hotCity.edit')->middleware('permission:data.hotCity.edit');
        Route::put('hotCity/{id?}/update', 'DistrictController@hotCityUpdate')->name('admin.hotCity.update')->middleware('permission:data.hotCity.edit');
        Route::delete('hotCity/destroy', 'DistrictController@hotCityDestroy')->name('admin.hotCity.destroy')->middleware('permission:data.hotCity.destroy');

    });

});


Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth', 'permission:data.manage']], function () {
    Route::group(['middleware' => 'permission:data.operateLog'], function () {

        Route::get('operateLog', 'OperateLogController@index')->name('admin.operateLog');
        Route::get('operateLog/data', 'OperateLogController@data')->name('admin.operateLog.data');
        Route::delete('operateLog/destroy', 'OperateLogController@destroy')->name('admin.operateLog.destroy')->middleware('permission:data.operateLog.destroy');
        Route::get('operateLog/excel', 'OperateLogController@excel')->name('admin.operateLog.excel')->middleware('permission:data.operateLog.excel');

    });
});


//产品管理
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth', 'permission:product.manage','admin']], function () {

    //产品
    Route::group(['middleware' => 'permission:product.manage'], function () {
        /*平台产品*/
        Route::get('product', 'ProductController@index')->name('admin.product');
        Route::get('product/data/{type?}', 'ProductController@data')->name('admin.product.data');
        //导入
        Route::post('product/import/template', 'ProductController@uploadExcel')->name('admin.import.template');//导入数据
        /*媒体主产品*/
        Route::get('product/media', 'ProductController@media')->name('admin.product.media');
        /*云资源产品*/
        Route::get('product/cloud', 'ProductController@cloud')->name('admin.product.cloud');
        Route::get('product/cloud/type', 'ProductCloudController@index')->name('admin.product.cloud.type');
        Route::get('product/cloud/{id}/edit', 'ProductCloudController@edit')->name('admin.product.cloud.edit');
        Route::get('product/cloud/data', 'ProductCloudController@cloudData')->name('admin.product.cloud.data');
        /*同步云资源*/
        Route::post('product/cloud/fit', 'ProductCloudController@store')->name('admin.product.cloud.fit');
        Route::post('product/cloud/sync', 'ProductCloudController@cloudProductSync')->name('admin.product.cloud.sync');
        /**/
        Route::get('product/create', 'ProductController@create')->name('admin.product.create');
        Route::post('product/store', 'ProductController@store')->name('admin.product.store');
        Route::get('product/{id?}/edit', 'ProductController@edit')->name('admin.product.edit');
        Route::put('product/{id?}/update', 'ProductController@update')->name('admin.product.update');
        Route::delete('product/destroy', 'ProductController@destroy')->name('admin.product.destroy');

        Route::post('product/status', 'ProductController@status')->name('admin.product.status');
        Route::get('product/excel', 'ProductController@excel')->name('admin.product.excel');

        /*产品回收站*/
        Route::get('product/delete', 'ProductController@isDelete')->name('admin.product.delete');
        Route::post('product/restore', 'ProductController@reStore')->name('admin.product.restore');//恢复
        Route::get('product/delete/data', 'ProductController@getDeleteData')->name('admin.product.delete.data');
    });

    //资源类目
    Route::group(['middleware' => 'permission:product.category'], function () {

        Route::get('productCategory', 'ProductCategoryController@index')->name('admin.productCategory');
        Route::get('productCategory/data', 'ProductCategoryController@data')->name('admin.productCategory.data');

        Route::get('productCategory/create', 'ProductCategoryController@create')->name('admin.productCategory.create')->middleware('permission:product.category.create');
        Route::post('productCategory/store', 'ProductCategoryController@store')->name('admin.productCategory.store')->middleware('permission:product.category.create');
        Route::get('productCategory/{id?}/edit', 'ProductCategoryController@edit')->name('admin.productCategory.edit')->middleware('permission:product.category.edit');
        Route::put('productCategory/{id?}/update', 'ProductCategoryController@update')->name('admin.productCategory.update')->middleware('permission:product.category.edit');
        Route::delete('productCategory/destroy', 'ProductCategoryController@destroy')->name('admin.productCategory.destroy')->middleware('permission:product.category.destroy');

    });

    //资源栏目
    Route::group(['middleware' => 'permission:product.column'], function () {

        Route::get('productColumn', 'ProductColumnController@index')->name('admin.productColumn');
        Route::get('productColumn/data', 'ProductColumnController@data')->name('admin.productColumn.data');

        Route::get('productColumn/create', 'ProductColumnController@create')->name('admin.productColumn.create')->middleware('permission:product.column.create');
        Route::post('productColumn/store', 'ProductColumnController@store')->name('admin.productColumn.store')->middleware('permission:product.column.create');
        Route::get('productColumn/{id?}/edit', 'ProductColumnController@edit')->name('admin.productColumn.edit')->middleware('permission:product.column.edit');
        Route::put('productColumn/{id?}/update', 'ProductColumnController@update')->name('admin.productColumn.update')->middleware('permission:product.column.edit');
        Route::delete('productColumn/destroy', 'ProductColumnController@destroy')->name('admin.productColumn.destroy')->middleware('permission:product.column.destroy');

    });

});



//统计中心
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth', 'permission:access.manage','admin']], function () {

    //渠道综合统计
    Route::group(['middleware' => 'permission:access.channel'], function () {

        Route::get('access/channel', 'AccessChannelController@index')->name('admin.access.channel');
        Route::get('access/channel/data', 'AccessChannelController@data')->name('admin.access.channel.data');

        Route::get('access/channel/show', 'AccessChannelController@show')->name('admin.access.channel.show')->middleware('permission:access.channel.show');
        Route::get('access/channel/showData', 'AccessChannelController@showData')->name('admin.access.channel.showData')->middleware('permission:access.channel.show');

        Route::get('access/channel/excel', 'AccessChannelController@excel')->name('admin.access.channel.excel')->middleware('permission:access.channel.excel');
        Route::get('access/channel/excelChildren', 'AccessChannelController@excelChildren')->name('admin.access.channel.excelChildren')->middleware('permission:access.channel.excelChildren');

    });

    //资源产品统计
    Route::group(['middleware' => 'permission:access.product'], function () {

        Route::get('access/product', 'AccessProductController@index')->name('admin.access.product');
        Route::get('access/product/data', 'AccessProductController@data')->name('admin.access.product.data');

        Route::get('access/product/excel', 'AccessProductController@excel')->name('admin.access.product.excel')->middleware('permission:access.product.excel');

    });

    //分发页统计
    Route::group(['middleware' => 'permission:access.page'], function () {

        Route::get('access/page', 'AccessPageController@index')->name('admin.access.page');
        Route::get('access/page/data', 'AccessPageController@data')->name('admin.access.page.data');

        Route::get('access/page/excel', 'AccessPageController@excel')->name('admin.access.page.excel')->middleware('permission:access.page.excel');

    });

    //App活跃统计
    Route::group(['middleware' => 'permission:access.app'], function () {

        Route::get('access/app', 'AccessAppController@index')->name('admin.access.app');
        Route::get('access/app/data', 'AccessAppController@data')->name('admin.access.app.data');

        Route::get('access/app/excel', 'AccessAppController@excel')->name('admin.access.app.excel')->middleware('permission:access.app.excel');

    });

    //渠道注册统计(超管)
    Route::group(['middleware' => 'permission:access.reg'], function () {

        Route::get('access/reg', 'AccessRegController@index')->name('admin.access.reg');
        Route::get('access/reg/data', 'AccessRegController@data')->name('admin.access.reg.data');
        Route::get('access/reg/show', 'AccessRegController@show')->name('admin.access.reg.show')->middleware('permission:access.reg.show');
        Route::get('access/reg/showData', 'AccessRegController@showData')->name('admin.access.reg.showData')->middleware('permission:access.reg.show');

        Route::get('access/reg/sync', 'AccessRegController@sync')->name('admin.access.reg.sync')->middleware('permission:access.reg.sync');
        Route::get('access/reg/excel', 'AccessRegController@excel')->name('admin.access.reg.excel')->middleware('permission:access.reg.excel');

    });

    //渠道注册统计(渠道)
    Route::group(['middleware' => 'permission:access.reg.channel'], function () {

        Route::get('access/reg/channel', 'AccessRegController@channel')->name('admin.access.regChannel');
        Route::get('access/reg/channelData', 'AccessRegController@channelData')->name('admin.access.reg.channelData');

    });

    //实时注册清单(超管)
    Route::group(['middleware' => 'permission:access.deduct'], function () {

        Route::get('access/deduct', 'AccessDeductController@index')->name('admin.access.deduct');
        Route::get('access/deduct/data', 'AccessDeductController@data')->name('admin.access.deduct.data');
        Route::get('access/deduct/excel', 'AccessDeductController@excel')->name('admin.access.deduct.excel')->middleware('permission:access.deduct.excel');

    });

    //实时注册清单(渠道)
    Route::group(['middleware' => 'permission:access.deduct.channel'], function () {

        Route::get('access/deduct/channel', 'AccessDeductController@channel')->name('admin.access.deduct.channel');
        Route::get('access/deduct/channelData', 'AccessDeductController@channelData')->name('admin.access.deduct.channelData');

    });

    //每日注册统计(超管)
    Route::group(['middleware' => 'permission:access.reg.day'], function () {

        Route::get('access/reg/day', 'AccessRegController@day')->name('admin.access.reg.day');
        Route::get('access/reg/dayData', 'AccessRegController@dayData')->name('admin.access.reg.dayData');

        Route::get('access/reg/day/show/{id}', 'AccessRegController@dayShow')->name('admin.access.reg.dayShow')->middleware('permission:access.reg.day.show');
        Route::get('access/reg/day/excel', 'AccessRegController@dayExcel')->name('admin.access.reg.dayExcel')->middleware('permission:access.reg.day.excel');

    });

    //每日注册统计(渠道)
    Route::group(['middleware' => 'permission:access.reg.day.channel'], function () {

        Route::get('access/reg/dayChannel', 'AccessRegController@dayChannel')->name('admin.access.reg.dayChannel');
        Route::get('access/reg/dayChannelData', 'AccessRegController@dayChannelData')->name('admin.access.reg.dayChannelData');

    });


});
Route::group(['namespace'=>'Admin'],function (){
    Route::get('getCityByProvince','DistrictController@getCityByProvince')->name('getCityByProvince');//省市联动
});