<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

$api = app('Dingo\Api\Routing\Router');
$api->version('v1', function ($api) {
    $api->group(['prefix'=>'v1','namespace'=>'App\Http\Controllers\Api\V1'],function($api){
        $api->any('alipay/notify','PayController@aliNotify');//支付宝回调
        $api->any('wechat/notify','PayController@wechatNotify');//微信回调
        $api->any('cloud/order/pull','PayController@cloudOrderStatusPull');//云资源回调
        $api->any('cloud/product/pull','PayController@cloudProductStatusPull');//云资源产品变更
    });
});
