<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect('/index');
});

Route::post('upload/images','BaseController@commonUpload');//图片上传
Route::post('ue/images','BaseController@commonUE');//图片上传
Route::post('upload/file','BaseController@uploadFile');//文件上传
Route::post('get/code','BaseController@getCode');
Route::get('active/preview','BaseController@activePreview');//预览

Route::group(['namespace'=>'Web'],function($router) {
    $router->get('success', 'IndexController@success');//成功
    $router->get('test', 'IndexController@test');//成功
    $router->get('index', 'IndexController@index');//首页
    $router->get('weibo', 'IndexController@weibo');//微博
    $router->get('weixin', 'IndexController@weixin');//微信
    $router->get('zimeiti', 'IndexController@wemedia');//自媒体
    $router->get('article', 'IndexController@article');//软文
    $router->get('video', 'IndexController@video');//视频
    $router->get('redbook', 'IndexController@redbook');//小红书
});
Route::group(['namespace'=>'Web','prefix'=>'member'],function($router){
    $router->get('login','LoginController@login');//登录
    $router->post('login','LoginController@loginCheck');//登录
    $router->get('register','LoginController@register');//注册
    $router->post('register','LoginController@store');//注册保存
    $router->get('forgot','LoginController@forgot');//忘记密码
    $router->post('forgot','LoginController@resetPass');//忘记密码
});

Route::group(['namespace'=>'Web','prefix'=>'member'],function($router){
    $router->get('logout','LoginController@logout');//退出登录
});
Route::group(['prefix'=>'advert','namespace'=>'Web\Advert','middleware'=>['advert']],function($router){
    //发起支付
    //$router->post('pay', 'PayController@Pay');//支付
    $router->get('alipay/{charge_no}', 'PayController@alipay');//支付
    $router->get('wechat', 'PayController@wechat');//微信支付
    $router->get('message/number', 'IndexController@checkMessageNumbers');//获取信息条数
});
Route::group(['prefix'=>'advert','namespace'=>'Web\Advert','middleware'=>['authCheck','advert']],function($router){

    $router->get('index','IndexController@index');
    $router->get('weixin','IndexController@weixin');
    $router->get('weibo','IndexController@weibo');
    $router->get('video','IndexController@video');
    $router->get('redbook','IndexController@redbook');
    $router->get('zimeiti','IndexController@wemedia');
    $router->get('show/{id}','IndexController@show');
    $router->post('index/info','IndexController@indexInfoStore');
    /*广告主个人中心*/
    $router->get('member','MemberController@index');//信息编辑
    $router->post('member/edit','MemberController@update');//信息保存
    $router->get('/message','MemberController@message');//系统消息
    $router->get('/message/data','MemberController@messageData');//
    $router->get('member/safe','MemberController@safe');//安全资料
    $router->post('member/safe/edit','MemberController@updateSafe');//安全资料保存

    $router->get('member/pay/pass','MemberController@payPass');//支付密码
    $router->post('member/set/pay/pass','MemberController@setPayPass');//支付密码保存

    $router->get('member/order','MemberOrderController@index');//订单中心(包含分类)
    $router->get('member/order/post','MemberOrderController@orderPost');//订单列表数据
    $router->get('member/order/detail/{id}','MemberOrderController@orderDetail');//订单详情
    $router->post('member/order/plan','MemberOrderController@orderPlanData');//订单详情步骤
    $router->post('member/order/pay','MemberOrderController@pay');//订单详情步骤
    $router->post('member/order/destroy/{ids}','MemberOrderController@destroy');//订单详情步骤

    $router->get('member/pay/charge','MemberChargeController@charge');//充值
    $router->get('member/charge','MemberChargeController@index');//订单中心(包含分类)
    $router->get('member/charge/data','MemberChargeController@data');//订单列表数据
    $router->get('member/money/record','MemberChargeController@moneyRecord');//用户流水
    $router->get('member/money/record/data','MemberChargeController@recordData');//用户流水数据
    $router->post('member/charge/pay','MemberChargeController@goPayCharge');//充值发起
    $router->post('wechart/check','PayController@wechatCheck');//查询支付

    $router->get('member/cart','MemberCartController@index');//购物车列表
    $router->get('member/cart/data','MemberCartController@cartData');//购物车数据
    $router->post('member/verify/pass', 'MemberCartController@verifyPass');//密码验证
    $router->get('member/get/fodder', 'MemberCartController@getFodder');//获取素材
    $router->get('member/cart/destroy', 'MemberCartController@destroy');//购物车删除

    $router->get('member/resource','MemberFileController@index');//素材列表
    $router->get('member/resource/data','MemberFileController@data');//素材列表数据
    $router->get('member/file','MemberFileController@file');//素材创建
    $router->post('member/file/store','MemberFileController@store');//素材新增保存
    $router->get('member/file/{id}','MemberFileController@edit');//信息保存
    $router->post('member/file/update','MemberFileController@update');//素材编辑保存
    $router->post('member/get/content','MemberFileController@getFileContent');//素材在线查看

    /*购物车*/
    $router->post('cart/list','CartController@index');//列表
    $router->post('cart','CartController@store');//添加
    $router->post('cart/destroy','CartController@destroy');//删除


    /*下单*/
    $router->get('order/{type}','OrderController@create');
    $router->get('order/repay/{order_id}','OrderController@repay');//重新支付：页面
    $router->post('order/update/{id}','OrderController@update');//订单重新：保存
    $router->post('order/repay/{id}','OrderController@orderRepay');//重新支付：保存
    $router->post('order/store','OrderController@store');//订单保存
    /*下单检查*/
    $router->post('order/pay','OrderController@orderPay');//账户检查
    $router->post('set/pass','OrderController@setPass');//密码设置
});




