

<?php $__env->startSection('content'); ?>
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto layui-form">
            <form class="layui-form-item" id="search-form">
                <div class="layui-inline">
                    <label class="layui-form-label">产品类型</label>
                    <div class="layui-input-block">
                        <select name="type" id="productType">
                            <option value="">不限</option>
                            <?php $__currentLoopData = $type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>" data-type="<?php echo e($item->tag); ?>"><?php echo e($item->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

            </form>
            <div>
                <div class="layui-btn-group">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin.product.price')): ?>
                    <a class="layui-btn   layui-btn-sm" id="listModify">批量调价</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    <a class="layui-btn layui-btn-sm" lay-event="edit">配置</a>
                </div>
            </script>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        layui.use(['layer','table','form'],function () {
            var table = layui.table;

            //用户表格初始化
            var dataTable = table.render({
                elem: '#dataTable'
                // ,height: 500
                ,url: "<?php echo e(route('admin.product.batch.data')); ?>" //数据接口
//                ,page: true //开启分页
                ,cols: [[ //表头
                    {field: 'id', title: '编号'}
                    ,{field: 'set_type', title: '操作类型',templet:function (d) {
                        if(d.set_type == 'rate_value'){
                            return '比例上调';
                        }else{
                            return '单价上调';
                        }
                    }},{field: 'product_type', title: '资源类型',templet:function (d) {
                        switch(d.product_type){
                            case 'article':
                                return '软文';
                            break;
                            case 'zimeiti':
                                return '自媒体';
                            break;
                            case 'weixin':
                                return '微信';
                            break;
                            case 'weibo':
                                return '微博';
                            break;
                            case 'video':
                                return '短视频';
                            break;
                            case 'redbook':
                                return '小红书';
                            break;
                        }
                    }}
                    ,{field: 'status', title: '执行状态',templet:function (d) {
                        if(d.status == 1){
                            return '完成';
                        }else{
                            return '待执行';
                        }
                        }
                    },{field: 'rate_value', title: '上调比例',templet:function (d) {
                            if(d.set_type == 'rate_value') {
                                return d.rate_value
                            }else{
                                return ''
                            }
                        }
                    },{field: 'price_value', title: '上调单价',templet:function (d) {
                        if(d.set_type == 'price_value') {
                            return d.price_value
                        }else{
                            return ''
                        }
                        }
                    },
                    {field: 'ids', title: '选定',templet:function (d) {
                        return d.ids;
                        }
                    },
                    {field: 'success_ids', title: '执行结果',templet:function (d) {
                        return d.success_ids;
                        }
                    },
                    {field: 'ids', title: '设定数量',templet:function (d) {
                        return d.set_number;
                    }
                    },
                    {field: 'success_ids', title: '成功数量',templet:function (d) {
                        return d.success_number;
                    }
                    }
                    ,{field: 'rate', title: '操作人',templet:function (d) {
                        if(d.user){
                            return d.user.name;
                        }else{
                            return '';
                        }
                    }}
                        ,{field: 'created_at', title: '操作时间'}
//                    ,{fixed: 'right', title:'操作',width: 100, align:'center', toolbar: '#options'}
                ]]
            });

            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                        ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent === 'edit'){
                    location.href = '/admin/cash/rate/'+data.id+'/edit';
                }
            });
            /*批量调价*/
            $("#listModify").click(function () {
                if($("#productType").val()==''){
                    layer.msg('请先选择资源类别')
                }else {
                    var ids = []
                    var typeName = $("#productType option:selected").text();
                    var t = $("#productType option:selected").data('type');

                    layer.confirm(`确认操作选中${typeName}吗？`, function (index) {
                        window.location.href = '/admin/product/set/price/'+t
                    })

                }
            })
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.base', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>