<?php namespace Phpcmf\Controllers\Admin;

class Cloud extends \Phpcmf\Common
{
    public function index() {

		if (!is_file(FCPATH.'cloud.db')) {
			$this->_admin_msg(0, dr_lang('无法通过云端服务器验证，请确保程序是否绑定授权账号，请确定程序是否来自官网下载'));
		}

        $zy = \Phpcmf\Service::M()->table(SITE_ID.'_form')->getAll();
        $list = [];
        foreach ($zy as $i => $t) {
            $t['setting'] = dr_string2array($t['setting']);
            if ($t['setting']['dev']) {
               $list[] = $t;
            }
        }


        \Phpcmf\Service::V()->assign([
            'menu' => \Phpcmf\Service::M('auth')->_admin_menu(
                [
                    '媒体资源管理' => ['media/zy/index', 'fa fa-th-large'],
                ]
            ),
            'list' => $list,
        ]);
        \Phpcmf\Service::V()->display('zy_list.html');
    }

    public function edit() {

        $id = intval($_GET['id']);
        $zy = \Phpcmf\Service::M()->table(SITE_ID.'_form')->get($id);
        if (!$zy) {
            $this->_json(0, '资源不存在');
        }

        if (IS_POST) {

            $post = \Phpcmf\Service::L('input')->post('data', true);
            \Phpcmf\Service::M()->table(SITE_ID.'_form')->update($id, [
                'name' => $post['name'],
            ]);
            \Phpcmf\Service::M()->db->table('admin_menu')->where('uri', 'media/'.$zy['table'].'_verify/index')->update([
                'name' => $post['name'],
            ]);
            \Phpcmf\Service::M()->db->table('admin_menu')->where('uri', 'media/'.$zy['table'].'/index')->update([
                'name' => $post['name'],
            ]);

            $this->_json(1, '修改成功，请更新缓存生效');
        }


        \Phpcmf\Service::V()->assign([
            'zy' => $zy,
        ]);
        \Phpcmf\Service::V()->display('zy_edit.html');exit;
    }

    public function field_edit() {

        $id = intval($_GET['rid']);
        $zy = \Phpcmf\Service::M()->table(SITE_ID.'_form')->get($id);
        if (!$zy) {
            $this->_admin_msg(0, '资源不存在');
        }

        $list = [];
        $field = \Phpcmf\Service::M()->table('field')->where('disabled', 0)->where('relatedid', $id)->where('relatedname', 'form-'.SITE_ID)->getAll();
        foreach ($field as $t) {
            if (!in_array($t['fieldname'], ['zt', ''])) {
                $t['setting'] = dr_string2array($t['setting']);
                $list[] = $t;
            }
        }


        \Phpcmf\Service::V()->assign([
            'list' => $list,
            'menu' => \Phpcmf\Service::M('auth')->_admin_menu(
                [
                    '['.$zy['name'].']字段选项修改' => ['media/zy/field_edit:rid='.$id, 'fa fa-code'],
                ]
            ),
        ]);
        \Phpcmf\Service::V()->display('zy_field_list.html');exit;
    }

    public function field_option_edit() {

        $id = intval($_GET['id']);
        $field = \Phpcmf\Service::M()->table('field')->get($id);
        if (!$field) {
            $this->_json(0, '字段不存在');
        }

        $field['setting'] = dr_string2array($field['setting']);
        $is_option = in_array($field['fieldtype'], ['Checkbox', 'Select', 'Radio']);

        if (IS_POST) {

            $post = \Phpcmf\Service::L('input')->post('data', true);
            if (!$post['name']) {
                $this->_json(0, '字段名称不能留空');
            }

            if ($is_option) {
                $field['setting']['option']['options'] = $post['options'];
            }

            \Phpcmf\Service::M()->table('field')->update($id, [
                'name' => $post['name'],
                'setting' => dr_array2string($field['setting']),
            ]);
            $this->_json(1, '修改成功，请更新缓存生效');
        }


        \Phpcmf\Service::V()->assign([
            'field' => $field,
            'is_option' => $is_option,
        ]);
        \Phpcmf\Service::V()->display('zy_field_edit.html');exit;
    }


}
