<?php namespace Phpcmf\Controllers\Admin;

class Item extends \Phpcmf\Table
{

    protected $mfield;

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        $this->name = dr_lang('订单管理');
        // 模板前缀(避免混淆)
        $this->tpl_prefix = 'order_';
        // 入库字段，实例中用到两个字段录入
        $this->mfield = array(
            'sn' => array(
                'ismain' => 1,
                'name' => dr_lang('订单号'),
                'fieldname' => 'sn',
                'fieldtype' => 'Text',
            ),
            'title' => array(
                'ismain' => 1,
                'name' => dr_lang('活动名称'),
                'fieldname' => 'title',
                'fieldtype' => 'Text',
            ),
            'sell_username' => array(
                'ismain' => 1,
                'name' => dr_lang('媒体账号'),
                'fieldname' => 'sell_username',
                'fieldtype' => 'Text',
            ),
            'buy_username' => array(
                'ismain' => 1,
                'name' => dr_lang('广告主账号'),
                'fieldname' => 'buy_username',
                'fieldtype' => 'Text',
            ),
        );

        // 初始化数据表
        $this->_init([
            'table' => 'rw_item', // 表的名字
            'field' => $this->mfield, // 设置入库字段
            'show_field' => 'title', // 表的主字段
            'order_by' => 'inputtime desc', // 列表排序显示方式
        ]);
        \Phpcmf\Service::V()->assign([
            'menu' => \Phpcmf\Service::M('auth')->_admin_menu(
                [
                    $this->name => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', 'fa fa-gg-circle'],
                    '详情' => ['hide:'.APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/edit', 'fa fa-edit'],
                ])
        ]);
    }

    public function index() {

        $tid = dr_safe_filename(\Phpcmf\Service::L('input')->get('tid'));
        $status = \Phpcmf\Service::L('input')->get('status');
        $where = [];
        if ($tid) {
            $where[] = '`tid`="'.$tid.'"';
        }
        if (strlen($status)) {
            $where[] = '`status`='.intval($status);
        }


        $where && \Phpcmf\Service::M()->set_where_list(implode(' AND ', $where));

        $this->_List([
            'tid' => $tid,
            'status' => strlen($status) ? $status : '',
        ]);


        \Phpcmf\Service::V()->assign([
            'tid' => $tid,
            'field' => $this->mfield,
            'status' => $status,
            'mt_form' => \Phpcmf\Service::L('cache')->get('form-'.SITE_ID),
            'search_url' => dr_url(APP_DIR.'/item/index', ['tid' => $tid]),
        ]);
        \Phpcmf\Service::V()->display('order_list.html'); // 设定显示模板
    }


    // 订单详情
    public function edit() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $data = \Phpcmf\Service::M()->table('rw_item')->get($id);
        if (!$data) {
            $this->_msg(0, '此订单不存在');
        }

        $content = dr_string2array($data['content']);
        unset($data['content']);

        \Phpcmf\Service::V()->assign([
            'order' => $data,
            'content' => $content,
            'ajax_url' => dr_url(APP_DIR.'/item/add'),
            'order_log' => \Phpcmf\Service::M('morder', 'rw')->get_item_logs($id),
            'uriprefix' => APP_DIR.'/'.\Phpcmf\Service::L('Router')->class,
            'reply_url' => \Phpcmf\Service::L('Router')->get_back(\Phpcmf\Service::L('Router')->uri('index'), $this->url_params),
            'rw_field_file' => APPSPATH.'Zy/Field/'.ucfirst($data['tid']).'/info.html',
        ]);
        \Phpcmf\Service::V()->display('order_show.html');
    }


    // 订单操作
    public function add() {

        $at = \Phpcmf\Service::L('Input')->get('at');
        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        $item = \Phpcmf\Service::M('morder', 'rw')->get_order_item($id);

        if (IS_AJAX_POST) {
            \Phpcmf\Service::M('member')->todo_admin_notice( 'media/order/edit:id/'.$item['oid'], SITE_ID);
        }

        switch ($at) {


            case 'zt':
                // 设置状态

                $status_name = $this->order_status;

                if (IS_AJAX_POST) {
                    $post = \Phpcmf\Service::L('input')->post('data');
                    $status = \Phpcmf\Service::L('input')->post('status');
                    if (!$post['content']) {
                        $this->_json(0, dr_lang('未填写变更理由'));
                    } elseif (!$status) {
                        $this->_json(0, dr_lang('状态值未选择'));
                    }
                    \Phpcmf\Service::M('morder', 'rw')->add_item_log($item, '平台将订单状态从（'.$status_name[$item['status']].'）改变为（'.$status_name[$status].'）', $post['content']);
                    \Phpcmf\Service::M()->db->table('rw_item')->where('id', $id)->update([
                        'status' => $status,
                    ]);
                    \Phpcmf\Service::M('mstatus', 'rw')->item_status($item, $status);
                    $this->_json(1, dr_lang('操作成功'));
                }

                \Phpcmf\Service::V()->assign([
                    'status' => $status_name,
                ]);
                break;

            case 'ys': // 验收审核

                if (IS_AJAX_POST) {
                    $post = \Phpcmf\Service::L('input')->post('data');
                    if (!$post['zt']) {
                        $this->_json(0, dr_lang('请选择审核状态'));
                    }
                    if ($post['zt'] > 0) {
                        $status = 11; // 待结算
                        \Phpcmf\Service::M('morder', 'rw')->add_item_log($item, '平台验收审核成功', $post['content']);
                    } else {
                        $status = 12; // 退回
                        \Phpcmf\Service::M('morder', 'rw')->add_item_log($item, '平台验收审核不通过', $post['content']);
                    }
                    \Phpcmf\Service::M()->db->table('rw_item')->where('id', $id)->update([
                        'status' => $status,
                    ]);
                    \Phpcmf\Service::M('mstatus', 'rw')->item_status($item, $status);
                    $this->_json(1, dr_lang('操作成功'));
                }
                break;

            case 'js': // 结算订单

                //
                if (IS_AJAX_POST) {
                    $post = \Phpcmf\Service::L('input')->post('data');
                    $status = 99; // 完成订单
                    \Phpcmf\Service::M('morder', 'rw')->add_item_log($item, '平台结算，交易完成', $post['content']);
                    \Phpcmf\Service::M()->db->table('rw_item')->where('id', $id)->update([
                        'status' => $status,
                    ]);
                    \Phpcmf\Service::M('mstatus', 'rw')->item_status($item, $status);
                    // 打款
                    \Phpcmf\Service::M('morder', 'rw')->dakuan_item($item);
                    $this->_json(1, dr_lang('操作成功'));
                }
                break;

            case 'tk':
                // 退款
                if ($item['mstatus'] == 0) {
                    $this->_json(0, dr_lang('广告主未付款，无法退款'));
                } else if ($item['mstatus'] == 2) {
                    $this->_json(0, dr_lang('已经退款了'));
                } else if ($item['mstatus'] == 3) {
                    $this->_json(0, dr_lang('已经付款给了媒体主，无法退款'));
                }
                \Phpcmf\Service::M('morder', 'rw')->tuikuan_item($item);
                $this->_json(1, dr_lang('操作成功'));
                break;

            case 'fk':
                // 付款
                if ($item['mstatus'] == 0) {
                    $this->_json(0, dr_lang('广告主未付款，无法付款'));
                } else if ($item['mstatus'] == 3) {
                    $this->_json(0, dr_lang('已经付款了'));
                } else if ($item['mstatus'] == 2) {
                    $this->_json(0, dr_lang('已经退款给了广告主，无法付款'));
                }
                \Phpcmf\Service::M('morder', 'rw')->dakuan_item($item);
                $this->_json(1, dr_lang('操作成功'));
                break;

        }
        \Phpcmf\Service::V()->assign([
            'item' => $item,
            'content_field' => dr_field_form(array(
                'fieldtype' => 'Ueditor',
                'fieldname' => 'content',
                'setting' => array(
                    'option' => array(
                        'mode' => 2,
                        'height' => 300,
                        'width' => '100%'
                    )
                )), '', 0, 1),
        ]);
        \Phpcmf\Service::V()->display('ajax_'.$at.'.html');
        exit;
    }


    // 后台删除内容
    public function del() {
        $this->_Del(
            \Phpcmf\Service::L('Input')->get_post_ids(),
            function ($rows) {
                // 删除之前验证
                foreach ($rows as $t) {
                    if ($t['mstatus'] !=0 ) {
                        $this->_json(0, dr_lang('订单['.$t['title'].']不符合删除条件，只有未付款的订单才能删除'));
                    }
                }
                return dr_return_data(1);
            },
            function ($rows) {
                // 对应删除提醒
                foreach ($rows as $t) {

                }

            },
            \Phpcmf\Service::M()->dbprefix($this->init['table'])
        );
    }
}
