<?php namespace Phpcmf\Controllers;

// 购物车信息
class Cart extends \Phpcmf\Common
{

    public function index() {

        $tid = dr_safe_filename($_GET['tid']);
        if (!$this->rw_media[$tid]) {
            $this->_json(0, dr_lang('媒体资源库【%s】不存在', $tid));
        } elseif (!in_array(1, $this->member['groupid'])) {
            $this->_json(0, '只有广告主才能下单');
        }

        $price = dr_safe_replace($_GET['price']);
        $price == 'undefined' && $price = '';
        $list = \Phpcmf\Service::M('morder', 'rw')->init($tid)->get_cart_list($price);

        ob_start();
        \Phpcmf\Service::V()->assign([
            'list' => $list,
            'rw_id' => $tid,
            'rw_price' => dr_rw_price(\Phpcmf\Service::C()->rw_media[$tid]['field'], $tid),
            'price_type' => $price,
        ]);
        \Phpcmf\Service::V()->display('cart_list.html');
        $html = ob_get_contents();
        ob_clean();

        $this->_json(1, $html, [
            'count' => count($list),
        ]);

    }


    // 加入购物车
    public function add() {

        if (!in_array(1, $this->member['groupid'])) {
            $this->_json(0, '只有广告主才能下单');
        }

        $id = intval($_GET['id']);
        $tid = dr_safe_filename($_GET['tid']);

        if (!$tid) {
            $this->_json(0, '媒体资源表不存在');
        } elseif (!$id) {
            $this->_json(0, '媒体资源ID不存在');
        }

        $data = \Phpcmf\Service::M('mdata', 'rw')->init($tid)->get_data($id);
        if (!$data) {
            $this->_json(0, '媒体资源内容不存在');
        }

        \Phpcmf\Service::M('morder', 'rw')->init($tid)->add_cart($id);

        $this->_json(1, '加入购物车');

    }

    public function del() {

        $id = intval($_GET['id']);
        $tid = dr_safe_filename($_GET['tid']);

        if (!$tid) {
            $this->_json(0, '媒体资源表不存在');
        } elseif (!$id) {
            $this->_json(0, '媒体资源ID不存在');
        }

        \Phpcmf\Service::M('morder', 'rw')->init($tid)->del_cart($id);

        $this->_json(1, '移除购物车');
    }





}
