<?php namespace Phpcmf\Controllers;

class Home extends \Phpcmf\Common
{

    public function index() {

        $tid = dr_safe_filename($_GET['tid']);
        if (!$this->rw_media[$tid]) {
            $this->_msg(0, dr_lang('媒体资源库【%s】不存在', $tid));
        }

        // 条件
        $where = [
            'zt=1',
            'status=1',
        ];

        // 价格组合
        $price = dr_rw_price($this->rw_media[$tid]['field'], $tid);

        // 获取条件
        $get = $this->_get_param();

        // 关键字匹配条件
        if ($get['keyword'] != '') {
            $search_keyword = str_replace([' ', '_'], '%', dr_safe_replace($get['keyword']));
            $where[] = '`title` LIKE "%'.$search_keyword.'%"';
        }

        // 字段过滤
        $myfield = $this->rw_media[$tid]['field'];
        foreach ($this->rw_media[$tid]['field'] as $name => $field) {
            if (isset($field['ismain']) && !$field['ismain']) {
                unset($myfield[$name]);
                continue;
            }
            if (isset($get[$name]) && strlen($get[$name])) {
                $where[] = $this->_where($name, $get[$name], $field);
            }
        }

        // 来自自定义价格组合
        if ($get['price_type'] && $get['price']) {
            if ($price[$get['price_type']]) {
                $where[] = $this->_where($get['price_type'], $get['price'], $field);
            }
        }

        // 筛选空值
        foreach ($where as $i => $t) {
            if (!$t) {
                unset($where[$i]);
            }
        }

        $order = $this->_order($get['order'], $myfield);
        if (!$order) {
            $order = 'inputtime desc';
        }

        $sql = 'select * from `'.\Phpcmf\Service::M()->dbprefix(SITE_ID.'_form_'.$tid).'`  where '.implode(' AND ', $where).' order by '.$order;

        // 可用于搜索的选项字段
        $select = [];
        foreach ($this->rw_media[$tid]['field'] as $t) {
            if ($t['ismain']
                && in_array($t['fieldtype'], ['Select', 'Checkbox', 'Radio'])
                && !in_array($t['fieldname'], ['zt'])
            ) {
                $select[$t['fieldname']] = [
                    'name' => $t['name'],
                    'value' => dr_format_option_array($t['setting']['option']['options']),
                ];
            }
        }

        \Phpcmf\Service::V()->assign([
            'rw_id' => $tid,
            'params' => $get,
            'rw_name' => $this->rw_media[$tid]['name'],
            'urlrule' => dr_rw_search_url($tid, $get, 'page', '[page]'),
            'rw_price' => $price,
            'search_sql' => urlencode($sql),
            'meta_title' => $this->rw_media[$tid]['name'].'_'.SITE_NAME,
            'search_select' => $select,
        ]);
        \Phpcmf\Service::V()->display($tid.'_search.html');
    }


    // 获取搜索参数
    private function _get_param() {

        $get = dr_search_rewrite_decode($_GET['search'], [
            'param_join' => '-',
            'param_rule' => '',
        ]);
        $get && $get = \Phpcmf\Service::L('input')->xss_clean($get);

        $_GET['page'] = $get['page'];
        $get['keyword'] = dr_get_keyword($get['keyword']);

        $get['s'] = $get['c'] = $get['m'] = $get['id'] = null;
        unset($get['s'], $get['c'], $get['m'], $get['id']);

        return $get;
    }


    // 条件组合
    private function _where($name, $value, $field) {
        $name = dr_safe_replace($name, ['\\', '/']);
        if (strpos($value, '%') === 0 && strrchr($value, '%') === '%') {
            // like 条件
            return '`'.$name.'` LIKE "%'.\Phpcmf\Service::M()->db->escapeString($value, true).'%"';
        } elseif (preg_match('/[0-9]+,[0-9]+/', $value)) {
            // BETWEEN 条件
            list($s, $e) = explode(',', $value);
            return '`'.$name.'` BETWEEN '.(int)$s.' AND '.intval($e ? $e : SYS_TIME);
        } elseif (isset($field['fieldtype']) && $field['fieldtype'] == 'Linkage') {
            // 联动菜单
            $data = dr_linkage($field['setting']['option']['linkage'], $value);
            if ($data) {
                if ($data['child']) {
                    return '`'.$name.'` IN ('.$data['childids'].')';
                } else {
                    return '`'.$name.'`='.intval($data['ii']);
                }
            }
        } elseif (isset($field['fieldtype']) && $field['fieldtype'] == 'Checkbox') {
            return '`'.$name.'` LIKE "%'.\Phpcmf\Service::M()->db->escapeString(str_replace('\\', '\\\\\\', json_encode($value)), true).'%"';
        } elseif (is_numeric($value)) {
            return '`'.$name.'`='.$value;
        } else {
            return '`'.$name.'`="'.dr_safe_replace($value, ['\\', '/']).'"';
        }
    }

    // 排序
    private function _order($order, $field) {

        if ($order) {
            $my = [];
            $array = explode(',', $order);
            foreach ($array as $i => $t) {
                list($a, $b) = explode('_', strtolower($t));
                if ($b && !in_array($b, ['desc', 'asc'])) {
                    $b = ''; // 排查后者
                }
                if (isset($field[$a])) {
                    $my[$i] = "`$a` ".($b ? $b : "DESC");
                }
            }
            if ($my) {
                return implode(',', $my);
            }
        }

        return '';
    }


}
