<?php namespace Phpcmf\Controllers;

class Show extends \Phpcmf\Common
{

    public function index() {

        $id = intval($_GET['id']);
        $tid = dr_safe_filename($_GET['tid']);

        if (!$this->rw_media[$tid]) {
            $this->_msg(0, dr_lang('媒体资源库【%s】不存在', $this->tid));
        }

        $this->form = $this->rw_media[$tid];

        $name = 'from_'.$this->form['table'].'_show_id_'.$id;
        $data = \Phpcmf\Service::L('cache')->init()->get($name);
        if (!$data) {
            $data = \Phpcmf\Service::M('mdata', 'rw')->init($this->form['table'])->get_data($id);
            !$data && $this->_msg(0, dr_lang('媒体资源内容【%s】不存在', $id));
            // 格式化输出自定义字段
            $fields = $this->form['field'];
            $fields['inputtime'] = ['fieldtype' => 'Date'];
            // 格式化字段
            $data = \Phpcmf\Service::L('Field')->format_value($fields, $data);
            \Phpcmf\Service::L('cache')->init()->save($name, $data, SYS_CACHE_SHOW * 3600);
        }

        // 可用于搜索的选项字段
        $select = [];
        foreach ($this->form['field'] as $t) {
            if (in_array($t['fieldtype'], ['Select', 'Checkbox', 'Radio'])
                && !in_array($t['fieldname'], ['zt'])
            ) {
                $select[$t['fieldname']] = [
                    'name' => $t['name'],
                    'value' => dr_format_option_array($t['setting']['option']['options']),
                ];
            }
        }

        $price = dr_rw_price($this->rw_media[$tid]['field'], $tid);

        \Phpcmf\Service::V()->assign([
            'data' => $data,
            'rw_id' => $this->form['table'],
            'rw_url' => dr_rw_media_url($this->form['table']),
            'rw_name' => $this->form['name'],
            'rw_price' => $price,
            'meta_title' => $data['title'].'_'.$this->rw_media[$tid]['name'].'_'.SITE_NAME,
            'search_select' => $select,
        ]);

        \Phpcmf\Service::V()->display('rw/'.$this->form['table'].'_show.html');
    }

}
