<?php namespace Phpcmf\Model;

// 资源类
class Mdata extends \Phpcmf\Model {


    // 初始化主表
    public function init($tid) {
        $this->mytable = SITE_ID.'_form_'.$tid;
        return $this;
    }

    /**
     * 查询数据并设置缓存
     */
    public function get_data($id) {

        $data = $this->table($this->mytable)->get($id);
        if (!$data) {
            return ;
        }

        return $data;

    }

    // 执行任务
    public function run_cron() {


        $order = \Phpcmf\Service::C()->myorder;

        // 广告主超时未支付关闭订单
        $time = (int)$order['ggz_wzf'] * 3600;
        if ($time) {
            $sql = 'select * from '.$this->dbprefix('rw_item').' where status=3 and inputtime < '.(SYS_TIME-$time);
            $rt = $this->db->query($sql)->getResultArray();
            if ($rt) {
                foreach ($rt as $item) {
                    \Phpcmf\Service::M()->db->table('rw_item')->where('id', $item['id'])->update([
                        'status' => 0, // 关闭订单
                    ]);

                    // 发送通知
                    \Phpcmf\Service::M('mstatus', 'rw')->item_status($item, 0);
                    // 写入日志
                    \Phpcmf\Service::M('morder', 'rw')->add_item_log($item, '广告主超时未支付关闭订单');
                }
            }
        }


        // 媒体主没有提交执行情况
        $sql = 'select * from '.$this->dbprefix('rw_item').' where status=6 and `zxtime`=0 and `etime` < '.(SYS_TIME);
        $rt = $this->db->query($sql)->getResultArray();
        if ($rt) {
            foreach ($rt as $item) {
                // 接单超时
                \Phpcmf\Service::M()->db->table('rw_item')->where('id', $item['id'])->update([
                    'status' => 10, // 已经超时
                ]);
                // 发送通知
                \Phpcmf\Service::M('mstatus', 'rw')->item_status($item, 10);
                // 写入日志
                \Phpcmf\Service::M('morder', 'rw')->add_item_log($item, '媒体主未在指定时间内执行订单，已超时');
                // 退款
                //\Phpcmf\Service::M('morder', 'rw')->tuikuan_item($item);
            }
        }

        // 指定是时间内未接单
        $sql = 'select * from '.$this->dbprefix('rw_item').' where status=4 and `stime` < '.(SYS_TIME);
        $rt = $this->db->query($sql)->getResultArray();
        if ($rt) {
            foreach ($rt as $item) {
                // 接单超时
                \Phpcmf\Service::M()->db->table('rw_item')->where('id', $item['id'])->update([
                    'status' => 5, // 已流单
                ]);
                // 发送通知
                \Phpcmf\Service::M('mstatus', 'rw')->item_status($item, 5);
                // 写入日志
                \Phpcmf\Service::M('morder', 'rw')->add_item_log($item, '媒体主未在指定接单时间内接单，已流单');
                // 退款
                \Phpcmf\Service::M('morder', 'rw')->tuikuan_item($item);
            }
        }

        return;


    }


    // 缓存更新
    public function cache($siteid = SITE_ID) {

        // 可用媒体资源
        $zy = $this->table(SITE_ID.'_form')->getAll();
        foreach ($zy as $i => $t) {
            $t['setting'] = dr_string2array($t['setting']);
            if ($t['setting']['dev']) {
                // 安装到菜单之中

                // 后台菜单
                $menu = $this->table('admin_menu')->where('mark', 'content-zy-'.$t['table'])->getRow();
                $left = $this->table('admin_menu')->where('mark', 'content-zy')->getRow();
                if (!$menu && $left) {
                    $save = [
                        'uri' => 'zy/'.$t['table'].'/index',
                        'mark' => 'content-zy-'.$t['table'],
                        'name' => $t['name'],
                        'icon' => dr_icon($t['setting']['icon']),
                        'displayorder' => 0,
                    ];
                    \Phpcmf\Service::M('menu')->_add('admin', $left['id'], $save);
                }
                // 后台审核
                $menu = $this->table('admin_menu')->where('mark', 'shenghei-zy-'.$t['table'])->getRow();
                $left = $this->table('admin_menu')->where('mark', 'shenghei-zy')->getRow();
                if (!$menu && $left) {
                    $save = [
                        'uri' => 'zy/'.$t['table'].'_verify/index',
                        'mark' => 'shenghei-zy-'.$t['table'],
                        'name' => $t['name'],
                        'icon' => dr_icon($t['setting']['icon']),
                        'displayorder' => 0,
                    ];
                    \Phpcmf\Service::M('menu')->_add('admin', $left['id'], $save);
                }

                // 会员菜单
                $menu = $this->table('member_menu')->where('mark', 'content-zy-'.$t['table'])->getRow();
                $left = $this->table('member_menu')->where('mark', 'content-zy')->getRow();
                if (!$menu && $left) {
                    $save = [
                        'uri' => 'zy/'.$t['table'].'/index',
                        'mark' => 'content-zy-'.$t['table'],
                        'name' => $t['name'],
                        'icon' => dr_icon($t['setting']['icon']),
                        'displayorder' => 0,
                    ];
                    \Phpcmf\Service::M('menu')->_add('member', $left['id'], $save);
                }
                // 广告主订单
                $menu = $this->table('member_menu')->where('mark', 'ggz-order-'.$t['table'])->getRow();
                $left = $this->table('member_menu')->where('mark', 'ggz-order')->getRow();
                if (!$menu && $left) {
                    $save = [
                        'uri' => 'zy/'.$t['table'].'_buy/index',
                        'mark' => 'ggz-order-'.$t['table'],
                        'name' => $t['name'],
                        'icon' => dr_icon($t['setting']['icon']),
                        'displayorder' => 0,
                    ];
                    \Phpcmf\Service::M('menu')->_add('member', $left['id'], $save);
                }
                // 媒体主订单
                $menu = $this->table('member_menu')->where('mark', 'mtz-order-'.$t['table'])->getRow();
                $left = $this->table('member_menu')->where('mark', 'mtz-order')->getRow();
                if (!$menu && $left) {
                    $save = [
                        'uri' => 'zy/'.$t['table'].'_sell/index',
                        'mark' => 'mtz-order-'.$t['table'],
                        'name' => $t['name'],
                        'icon' => dr_icon($t['setting']['icon']),
                        'displayorder' => 0,
                    ];
                    \Phpcmf\Service::M('menu')->_add('member', $left['id'], $save);
                }
            }
        }

        $cache = [
            'field_image' => [], // 单图
            'field_array' => [],
        ];

        // 创建图片上传字段
        $cache['field_image'] = $this->table('field')->where('fieldname', 'image')->where('relatedname', 'order-image')->getRow();
        if (!$cache['field_image']) {
            $sql = 'INSERT INTO `'.$this->dbprefix('field').'` (`id`, `name`, `fieldname`, `fieldtype`, `relatedid`, `relatedname`, `isedit`, `ismain`, `issystem`, `ismember`, `issearch`, `disabled`, `setting`, `displayorder`) VALUES (NULL, \'图片\', \'image\', \'Files\', \'10\', \'order-image\', \'1\', \'1\', \'0\', \'1\', \'0\', \'0\', \'{\"option\":{\"ext\":\"jpg,jpeg,png,gif\",\"size\":\"5\",\"count\":\"5\",\"attachment\":\"0\",\"css\":\"\"},\"validate\":{\"required\":\"0\",\"pattern\":\"\",\"errortips\":\"\",\"check\":\"\",\"filter\":\"\",\"formattr\":\"\",\"tips\":\"\"},\"is_right\":\"0\"}\', \'0\');';
            $this->db->query($sql);
            $cache['field_image'] = $this->table('field')->where('fieldname', 'image')->where('relatedname', 'order-image')->getRow();
        }

        $cache['field_image']['setting'] = dr_string2array($cache['field_image']['setting']);

        $array = $this->table('field')->where('fieldtype', 'Checkbox')->where('relatedname', 'form-'.$siteid)->getAll();
        foreach ($array as $t) {
            $cache['field_array'][] = $t['fieldname'];
        }

        \Phpcmf\Service::L('cache')->set_file('rw-'.$siteid, $cache);
    }



}