<?php namespace Phpcmf\Model;


class Morder extends \Phpcmf\Model {

    public $tid;
    public $tmp_order;

    public function init($tid) {
        $this->tid = $tid;
        return $this;
    }

    public function del_cart($id) {
        $this->db->table('rw_cart')->where('cid', $id)->where('tid', $this->tid)->where('uid', $this->uid)->delete();
    }

    public function del_cart_all() {
        $this->db->table('rw_cart')->where('uid', $this->uid)->where('tid', $this->tid)->delete();
    }

    public function add_cart($id) {

        $rt = $this->table('rw_cart')->where('cid', $id)->where('tid', $this->tid)->where('uid', $this->uid)->counts();
        if (!$rt) {
            $this->table('rw_cart')->replace([
                'tid' => $this->tid,
                'uid' => $this->uid,
                'cid' => $id,
            ]);
        }

        return;
    }

    public function get_cart_list($price = '') {

        if (!$price) {
            $price = dr_rw_default_price($this->tid);
        }

        $rt = $this->db->query('SELECT * FROM '.$this->dbprefix(SITE_ID.'_form_'.$this->tid)
            .' WHERE id IN (SELECT cid from '.$this->dbprefix('rw_cart').' where tid="'.$this->tid.'" and uid="'.$this->uid.'") and status=1 and zt=1 order by inputtime desc')->getResultArray();

        if ($rt && $price) {
            foreach ($rt as $i => $t) {
                $rt[$i]['price'] = dr_rw_member_price(dr_buy_price($t[$price]), $this->member['levelid'][1]);
            }
        }

        return $rt;
    }


    public function get_list($ids, $price_type) {

        $ids = is_array($ids) ? $ids : explode(',', $ids);
        if (!$ids) {
            return [];
        }

        $rt = $this->table(SITE_ID.'_form_'.$this->tid)->where_in('id', $ids)->where('status=1 and zt=1')->getAll();
        if (!$rt) {
            return [];
        }

        $list = [];
        foreach ($rt as $t) {
            if (!$price_type) {
                $price_type = dr_rw_default_price($this->tid);
            }
            $price = $t[$price_type];
            $data = [
                'id' => $t['id'],
                'title' => $t['title'],
                'thumb' => $t['thumb'],
                'uid' => $t['uid'],
                'author' => $t['author'],
                'price' => dr_rw_member_price(dr_buy_price($price), $this->member['levelid'][1]),
                'sku_name' => \Phpcmf\Service::C()->rw_media[$this->tid]['field'][$price_type]['name'],
                'cb_price' => $price, // 成本价格
            ];


            $list[] = $data;
        }

        return $list;
    }


    public function get_order_item($id) {

        $rt = $this->table('rw_item')->where('id', $id)->getRow();
        if (!$rt) {
            return [];
        }

        $rt['content'] = dr_string2array($rt['content']);

        return $rt;
    }


    // 合并付款
    public function hbfk($items) {

        // 订单存储表
        $save = [
            'tid' => $this->tid,
            'cid' => '',
            'uid' => $this->uid,
            'paytime' => 0,
            'inputtime' => SYS_TIME,
            'status' => 0,
        ];

        $ids = [];
        $money = 0;

        // 统计价格
        foreach ($items as $t) {
            if ($t['money'] > 0) {
                $money+= $t['money'];
                $ids[] = $t['id'];
            }
        }

        $save['money'] = $money;
        $save['cid'] = dr_array2string($ids);

        $rt = $this->table('rw_order')->replace($save);
        return $rt['code'];
    }

    // 订单下单开始
    public function save_order($ids, $items, $post, $content) {

        // 统计价格
        $money = 0;
        foreach ($items as $t) {
            if ($t['price'] > 0) {
                $money+= $t['price'];
            }
        }
        if ($money <= 0) {
            return dr_return_data(0, '媒体资源不支持下单');
        }

        $post['stime'] = strtotime($post['stime']);
        $post['etime'] = strtotime($post['etime']);
        if ($post['stime'] == $post['etime']) {
            return dr_return_data(0, '开始时间和结束时间不能相同');
        } elseif ($post['stime'] > $post['etime']) {
            return dr_return_data(0, '开始时间不能大于结束时间');
        } elseif (date('ymd', $post['stime']) == date('ymd')) {
            return dr_return_data(0, '开始时间不能是今天');
        }

        $sn = date('YmdHis').$this->uid.rand(10000, 99999);

        // 更新到订单资源表
        $hb = [];
        foreach ($items as $i => $t) {

            $status = 3; // 待付款状态

            $item = [
                'sn' => $sn.$i,
                'tid' => $this->tid,
                'sell_uid' => $t['uid'],
                'sell_username' => $t['author'],
                'buy_uid' => $this->member['uid'],
                'buy_username' => $this->member['username'],
                'zy_id' => $t['id'],
                'zy_title' => $t['title'],
                'zy_thumb' => $t['thumb'],
                'sku_name' => $t['sku_name'],
                'money' => (float)$t['price'],
                'cb_money' => (float)$t['cb_price'],
                'status' => $status,
                'title' => $post['title'],
                'stime' => $post['stime'],
                'etime' => $post['etime'],
                'note' => $post['note'],
                'content' => dr_array2string($content),
                'inputtime' => SYS_TIME,
                'paytime' => 0,
            ];

            $rt = $this->table('rw_item')->replace($item);
            $item['id'] = $rt['code'];
            \Phpcmf\Service::M('mstatus', 'rw')->item_status($item, $status);
            $hb[] = $item;
        }


        if ($status == 3) {
            // 合并付款
            $oid = $this->hbfk($hb);
            return dr_return_data(1, dr_member_url('zy/'.$this->tid.'_buy/pay_order', ['id' => $oid]));
        } else {
            // 返回订单页面
            return dr_return_data(1, dr_member_url('zy/'.$this->tid.'_buy/index', ['status' => $status]));

        }

    }


    // 批量付款成功
    public function pay_order($data) {

        // 付款成功
        $this->table('rw_order')->update($data['id'], [
            'status' => 1,
            'paytime' => SYS_TIME,
        ]);

        $ids = dr_string2array($data['cid']);
        $items = $this->table('rw_item')->where_in('id', $ids)->where('buy_uid', $data['uid'])->getAll();
        foreach ($items as $item) {
            $this->pay_item($item);
        }
    }

    // 单付款成功
    public function pay_item($data) {

        if ($data['status'] != 3) {
            return;
        }

        // 冻结资金
        \Phpcmf\Service::M('member')->add_freeze($data['buy_uid'], $data['money']);

        $this->db->table('rw_item')->where('id', $data['id'])->update([
            'paytime' => SYS_TIME,
            'status' => 4, // 付款之后进入待接单
            'mstatus' => 1, // 冻结中
        ]);
        \Phpcmf\Service::M('mstatus', 'rw')->item_status($data, 4);
        $this->add_item_log($data, '广告主已付款');
    }

    // 广告主关闭
    public function guanbi_item($data, $note) {

        $this->db->table('rw_item')->where('id', $data['id'])->update([
            'status' => 0, // 变更为关闭
        ]);

        \Phpcmf\Service::M('mstatus', 'rw')->item_status($data, 0);

        $this->add_item_log($data, '广告主关闭订单', $note);

        // 退钱
        $this->tuikuan_item($data);
    }

    // 媒体主接单
    public function jiedan_item($data) {

        $this->db->table('rw_item')->where('id', $data['id'])->update([
            'status' => 6, // 变更为执行中
        ]);

        \Phpcmf\Service::M('mstatus', 'rw')->item_status($data, 6);

        $this->add_item_log($data, '媒体主已接单');
    }

    // 媒体主拒单
    public function judan_item($data, $note) {

        $this->db->table('rw_item')->where('id', $data['id'])->update([
            'status' => 8, // 拒单状态
        ]);

        $this->add_item_log($data, '媒体主拒单，订单作废', $note);

        \Phpcmf\Service::M('mstatus', 'rw')->item_status($data, 8);

        // 拒单退钱
        $this->tuikuan_item($data);

    }

    // 媒体主执行完成
    public function wancheng_item($data, $post) {

        $this->db->table('rw_item')->where('id', $data['id'])->update([
            'zxtime' => SYS_TIME, // 执行时间值
            'status' => 7, // 执行完成进入审核状态
        ]);

        \Phpcmf\Service::M('mstatus', 'rw')->item_status($data, 7);

        $this->add_item_log($data, '媒体主提交执行完成，等待平台验收审核', $post);

    }




    // 订单日志
    public function add_item_log($item, $title, $content = '') {
        $this->db->table('rw_log')->replace([
            'iid' => $item['id'],
            'title' => $title,
            'content' => $content,
            'inputtime' => SYS_TIME,
        ]);
    }

    // 读取日志
    public function get_item_logs($id) {

        $rt = $this->table('rw_log')->where('iid', $id)->order_by('inputtime asc')->getAll();
        if (!$rt) {
            return [];
        }

        return $rt;
    }

    // 退款给广告主
    public function tuikuan_item($item) {

        if (in_array($item['mstatus'], [0, 2, 3])) {
            return;
        }

        // 取消冻结资金
        \Phpcmf\Service::M('member')->cancel_freeze($item['buy_uid'], $item['money']);

        $this->db->table('rw_item')->where('id', $item['id'])->update([
            'mstatus' => 2,
        ]);

        $this->add_item_log($item, '退款给广告主');


        \Phpcmf\Service::M('mstatus', 'rw')->item_status($item, 'tuikuan');
    }

    // 打款给媒体主
    public function dakuan_item($item) {

        if (in_array($item['mstatus'], [0, 2, 3])) {
            return;
        }


        // 使用冻结资金
        \Phpcmf\Service::M('member')->use_freeze($item['buy_uid'], $item['money']);

        $this->db->table('rw_item')->where('id', $item['id'])->update([
            'mstatus' => 3,
        ]);

        $mark = 'order-'.$item['id'];
        // 打款记录
        // 转移给媒体主
        \Phpcmf\Service::M('member')->add_money($item['sell_uid'], $item['cb_money']);
        // 增加到媒体主交易流水
        \Phpcmf\Service::M('Pay')->add_paylog([
            'uid' => $item['sell_uid'],
            'username' => $item['sell_username'],
            'touid' => $item['buy_uid'],
            'tousername' => $item['buy_username'],
            'mid' => $mark,
            'title' => '<'.$item['title'].'>交易成功',
            'value' => $item['cb_money'],
            'type' => 'finecms',
            'status' => 1,
            'result' => '订单编号：'.$item['sn'],
            'paytime' => SYS_TIME,
            'inputtime' => SYS_TIME,
        ]);
        // 增加广告主交易流水
        \Phpcmf\Service::M('Pay')->add_paylog([
            'uid' => $item['buy_uid'],
            'username' => $item['buy_username'],
            'touid' => 0,
            'tousername' => '',
            'mid' => $mark,
            'title' => '<'.$item['title'].'>交易成功',
            'value' => -$item['money'],
            'type' => 'finecms',
            'status' => 1,
            'result' => '订单编号：'.$item['sn'],
            'paytime' => SYS_TIME,
            'inputtime' => SYS_TIME,
        ]);

        \Phpcmf\Service::M('morder', 'rw')->add_item_log($item, '付款给媒体主');
        \Phpcmf\Service::M('mstatus', 'rw')->item_status($item, 'dakuan');

    }
}