<?php

/**
 * 菜单配置
 */


return [

    'admin' => [

        'home' => [
            'name' => '首页',
            'icon' => 'fa fa-home',
            'left' => [
                'home-my' => [
                    'name' => '我的面板',
                    'icon' => 'fa fa-home',
                    'link' => [
                        [
                            'name' => '后台首页',
                            'icon' => 'fa fa-home',
                            'uri' => 'home/main',
                        ],
                        [
                            'name' => '资料修改',
                            'icon' => 'fa fa-user',
                            'uri' => 'api/my',
                        ],
                        [
                            'name' => '系统更新',
                            'icon' => 'fa fa-refresh',
                            'uri' => 'cache/index',
                        ],
                    ]
                ],
            ],
        ],


        'system' => [
            'name' => '系统',
            'icon' => 'fa fa-globe',
            'left' => [
                'system-wh' => [
                    'name' => '系统维护',
                    'icon' => 'fa fa-cog',
                    'link' => [
                        [
                            'name' => '系统环境',
                            'icon' => 'fa fa-cog',
                            'uri' => 'system/index',
                        ],
                        [
                            'name' => '系统缓存',
                            'icon' => 'fa fa-clock-o',
                            'uri' => 'system_cache/index',
                        ],
                        [
                            'name' => '短信设置',
                            'icon' => 'fa fa-envelope',
                            'uri' => 'sms/index',
                        ],
                        [
                            'name' => '邮件设置',
                            'icon' => 'fa fa-envelope-open',
                            'uri' => 'email/index',
                        ],
                        [
                            'name' => '系统提醒',
                            'icon' => 'fa fa-bell',
                            'uri' => 'notice/index',
                        ],
                        [
                            'name' => '数据字典',
                            'icon' => 'fa fa-database',
                            'uri' => 'db/index',
                        ],
                        [
                            'name' => 'Bom检测',
                            'icon' => 'fa fa-code',
                            'uri' => 'check_bom/index',
                        ],
                        [
                            'name' => '系统体检',
                            'icon' => 'fa fa-wrench',
                            'uri' => 'check/index',
                        ],
                    ]
                ],
                'system-log' => [
                    'name' => '日志管理',
                    'icon' => 'fa fa-calendar',
                    'link' => [
                        [
                            'name' => 'PHP错误',
                            'icon' => 'fa fa-bug',
                            'uri' => 'error_php/index',
                        ],
                        [
                            'name' => '系统错误',
                            'icon' => 'fa fa-shield',
                            'uri' => 'error/index',
                        ],
                        [
                            'name' => '操作日志',
                            'icon' => 'fa fa-calendar',
                            'uri' => 'system_log/index',
                        ],
                        [
                            'name' => '短信日志',
                            'icon' => 'fa fa-envelope',
                            'uri' => 'sms_log/index',
                        ],
                        [
                            'name' => '邮件日志',
                            'icon' => 'fa fa-envelope-open',
                            'uri' => 'email_log/index',
                        ],
                    ]
                ],
            ],
        ],

        'config' => [
            'name' => '设置',
            'icon' => 'fa fa-cogs',
            'left' => [
                'config-web' => [
                    'name' => '网站设置',
                    'icon' => 'fa fa-cog',
                    'link' => [
                        [
                            'name' => '网站设置',
                            'icon' => 'fa fa-cog',
                            'uri' => 'site_config/index',
                        ],
                        [
                            'name' => '媒体资源',
                            'icon' => 'fa fa-th-large',
                            'uri' => 'rw/zy/index',
                        ],
                        [
                            'name' => '手机设置',
                            'icon' => 'fa fa-mobile',
                            'uri' => 'site_mobile/index',
                        ],
                        [
                            'name' => '域名绑定',
                            'icon' => 'fa fa-globe',
                            'uri' => 'site_domain/index',
                        ],
                        [
                            'name' => '站点SEO',
                            'icon' => 'fa fa-cog',
                            'uri' => 'seo_site/index',
                        ],
                    ]
                ],

                'config-member' => [
                    'name' => '用户设置',
                    'icon' => 'fa fa-user',
                    'link' => [
                        [
                            'name' => '用户设置',
                            'icon' => 'fa fa-cog',
                            'uri' => 'member_setting/index',
                        ],
                        [
                            'name' => '字段划分',
                            'icon' => 'fa fa-code',
                            'uri' => 'member_field/index',
                        ],
                        [
                            'name' => '通知设置',
                            'icon' => 'fa fa-volume-up',
                            'uri' => 'member_setting_notice/index',
                        ],
                    ]
                ],
                'config-pay' => [
                    'name' => '支付设置',
                    'icon' => 'fa fa-rmb',
                    'link' => [
                        [
                            'name' => '支付设置',
                            'icon' => 'fa fa-cog',
                            'uri' => 'member_payconfig/index',
                        ],
                        [
                            'name' => '支付接口',
                            'icon' => 'fa fa-code',
                            'uri' => 'member_payapi/index',
                        ],
                    ],
                ],
            ],
        ],

        'auth' => [
            'name' => '权限',
            'icon' => 'fa fa-user-circle',
            'left' => [
                'auth-admin' => [
                    'name' => '后台权限',
                    'icon' => 'fa fa-cog',
                    'link' => [
                        [
                            'name' => '后台菜单',
                            'icon' => 'fa fa-list-alt',
                            'uri' => 'menu/index',
                        ],
                        [
                            'name' => '角色权限',
                            'icon' => 'fa fa-users',
                            'uri' => 'role/index',
                        ],
                        [
                            'name' => '角色账号',
                            'icon' => 'fa fa-user',
                            'uri' => 'root/index',
                        ],
                    ]
                ],
                'auth-member' => [
                    'name' => '用户权限',
                    'icon' => 'fa fa-user',
                    'link' => [
                        [
                            'name' => '用户菜单',
                            'icon' => 'fa fa-list-alt',
                            'uri' => 'member_menu/index',
                        ],
                        [
                            'name' => '用户组权限',
                            'icon' => 'fa fa-group',
                            'uri' => 'member_setting_group/index',
                        ],
                    ]
                ],
            ],
        ],

        'content' => [
            'name' => '内容',
            'icon' => 'fa fa-th-large',
            'left' => [

                'content-zy' => [
                    'name' => '资源管理',
                    'icon' => 'fa fa-th-large',
                    'link' => [
                        [
                            'name' => '云端资源库',
                            'icon' => 'fa fa-cloud',
                            'uri' => 'rw/cloud/index',
                            'displayorder' => '99',
                        ],

                    ]
                ],
                'shenghei-zy' => [
                    'name' => '资源审核',
                    'icon' => 'fa fa-edit',
                    'link' => [

                    ]
                ],


                'content-module2' => [
                    'name' => '内容管理',
                    'icon' => 'fa fa-th-large',
                    'link' => [

                    ]
                ],
            ],
        ],


        'morder' => [
            'name' => '订单',
            'icon' => 'fa fa-gg-circle',
            'left' => [
                'morder-one' => [
                    'name' => '订单管理',
                    'icon' => 'fa fa-gg-circle',
                    'link' => [
                        [
                            'name' => '订单管理',
                            'uri' => 'rw/item/index',
                        ],
                        [
                            'name' => '订单设置',
                            'icon' => 'fa fa-cog',
                            'uri' => 'rw/order/index',
                        ],
                        [
                            'name' => '价格配置',
                            'icon' => 'fa fa-cog',
                            'uri' => 'rw/price/index',
                        ],
                    ]
                ],
            ],
        ],


        'code' => [
            'name' => '界面',
            'icon' => 'fa fa-html5',
            'left' => [
                'code-html' => [
                    'name' => '模板管理',
                    'icon' => 'fa fa-home',
                    'link' => [
                        [
                            'name' => '电脑模板',
                            'icon' => 'fa fa-desktop',
                            'uri' => 'tpl_pc/index',
                        ],
                        [
                            'name' => '手机模板',
                            'icon' => 'fa fa-mobile',
                            'uri' => 'tpl_mobile/index',
                        ],
                    ]
                ],
                'code-css' => [
                    'name' => '风格管理',
                    'icon' => 'fa fa-css3',
                    'link' => [
                        [
                            'name' => '系统文件',
                            'icon' => 'fa fa-chrome',
                            'uri' => 'system_theme/index',
                        ],
                        [
                            'name' => '网站风格',
                            'icon' => 'fa fa-photo',
                            'uri' => 'theme/index',
                        ],
                    ],
                    'displayorder' => 99
                ],
            ],
        ],


        'member' => [
            'name' => '用户',
            'icon' => 'fa fa-user',
            'left' => [
                'member-list' => [
                    'name' => '用户管理',
                    'icon' => 'fa fa-user',
                    'link' => [
                        [
                            'name' => '用户管理',
                            'icon' => 'fa fa-user',
                            'uri' => 'member/index',
                        ],
                        [
                            'name' => '用户组管理',
                            'icon' => 'fa fa-users',
                            'uri' => 'member_group/index',
                        ],
                        [
                            'name' => '提醒消息',
                            'icon' => 'fa fa-bell',
                            'uri' => 'member_notice/index',
                        ],
                        [
                            'name' => '授权账号管理',
                            'icon' => 'fa fa-qq',
                            'uri' => 'member_oauth/index',
                        ],
                    ]
                ],
                'member-verify' => [
                    'name' => '审核管理',
                    'icon' => 'fa fa-edit',
                    'link' => [
                        [
                            'name' => '注册审核',
                            'icon' => 'fa fa-edit',
                            'uri' => 'member_verify/index',
                        ],
                    ]
                ],

            ],
        ],

        'pay' => [
            'name' => '财务',
            'icon' => 'fa fa-rmb',
            'left' => [
                'pay-list' => [
                    'name' => '财务管理',
                    'icon' => 'fa fa-rmb',
                    'link' => [
                        [
                            'name' => '已付流水',
                            'icon' => 'fa fa-calendar-check-o',
                            'uri' => 'member_paylog/index',
                        ],
                        [
                            'name' => '未付流水',
                            'icon' => 'fa fa-calendar-times-o',
                            'uri' => 'member_paylog/not_index',
                        ],
                        [
                            'name' => '转账汇款',
                            'icon' => 'fa fa-credit-card',
                            'uri' => 'member_payremit/index',
                        ],
                        [
                            'name' => '上门收款',
                            'icon' => 'fa fa-user',
                            'uri' => 'member_paymeet/index',
                        ],
                        [
                            'name' => '提现管理',
                            'icon' => 'fa fa-credit-card',
                            'uri' => 'member_cash/index',
                        ],
                        [
                            'name' => '用户充值',
                            'icon' => 'fa fa-plus',
                            'uri' => 'member_pay/index',
                        ],
                    ]
                ],

            ],
        ],

        'app' => [
            'name' => '插件',
            'icon' => 'fa fa-puzzle-piece',
            'left' => [
                'app-plugin' => [
                    'name' => '功能插件',
                    'icon' => 'fa fa-puzzle-piece',
                    'link' => [
                        [
                            'name' => '本地插件',
                            'icon' => 'fa fa-folder',
                            'uri' => 'cloud/local',
                        ],
                        [
                            'name' => '联动菜单',
                            'icon' => 'fa fa-columns',
                            'uri' => 'linkage/index',
                        ],
                        [
                            'name' => '任务队列',
                            'icon' => 'fa fa-indent',
                            'uri' => 'cron/index',
                        ],
                        [
                            'name' => '附件管理',
                            'icon' => 'fa fa-folder',
                            'uri' => 'attachments/index',
                        ],
                    ]
                ],
            ],
        ],



        'cloud' => [
			'name' => '程序',
            'icon' => 'fa fa-cloud',
            'displayorder' => 99,
            'left' => [
                'cloud-dayrui' => [
                    'name' => '网站管理',
                    'icon' => 'fa fa-cloud',
                    'link' => [
                        [
                            'name' => '我的网站',
                            'icon' => 'fa fa-cog',
                            'uri' => 'cloud/index',
                        ],
                        [
                            'name' => '服务工单',
                            'icon' => 'fa fa-user-md',
                            'uri' => 'cloud/service',
                        ],
                        [
                            'name' => '插件商城',
                            'icon' => 'fa fa-puzzle-piece',
                            'uri' => 'cloud/app',
                        ],
                        [
                            'name' => '组件商城',
                            'icon' => 'fa fa-plug',
                            'uri' => 'cloud/func',
                        ],
                        [
                            'name' => '版本升级',
                            'icon' => 'fa fa-refresh',
                            'uri' => 'cloud/update',
                        ],
                        [
                            'name' => '网站备份',
                            'icon' => 'fa fa-copy',
                            'uri' => 'backup/index',
                        ],
                    ]
                ],
            ],
        ],





    ],



    'member' => [

        'user' => [
            'name' => '账号管理',
            'icon' => 'fa fa-user',
            'link' => [
                [
                    'name' => '资料修改',
                    'icon' => 'fa fa-cog',
                    'uri' => 'account/index',
                ],
                [
                    'name' => '头像设置',
                    'icon' => 'fa fa-smile-o',
                    'uri' => 'account/avatar',
                ],
                [
                    'name' => '手机认证',
                    'icon' => 'fa fa-mobile',
                    'uri' => 'account/mobile',
                ],
                [
                    'name' => '修改密码',
                    'icon' => 'fa fa-expeditedssl',
                    'uri' => 'account/password',
                ],
                [
                    'name' => '账号绑定',
                    'icon' => 'fa fa-qq',
                    'uri' => 'account/oauth',
                ],
                [
                    'name' => '登录记录',
                    'icon' => 'fa fa-calendar',
                    'uri' => 'account/login',
                ],
                [
                    'name' => '提醒消息',
                    'icon' => 'fa fa-bell',
                    'uri' => 'notice/index',
                ],
            ],
        ],

        'pay' => [
            'name' => '财务管理',
            'icon' => 'fa fa-rmb',
            'link' => [
                [
                    'name' => '在线充值',
                    'icon' => 'fa fa-rmb',
                    'uri' => 'recharge/index',
                ],
                [
                    'name' => '我的交易',
                    'icon' => 'fa fa-calendar',
                    'uri' => 'paylog/index',
                ],
                [
                    'name' => '申请提现',
                    'icon' => 'fa fa-credit-card',
                    'uri' => 'cash/index',
                ],
            ],
        ],


        'content-zy' => [
            'name' => '媒体资源',
            'icon' => 'fa fa-th-large',
            'group' => [2],
            'link' => [
            ],
        ],


        'ggz-order' => [
            'name' => '我的订单',
            'icon' => 'fa fa-gg',
            'group' => [1],
            'link' => [
            ],
        ],

        'mtz-order' => [
            'name' => '订单管理',
            'icon' => 'fa fa-gg',
            'group' => [2],
            'link' => [
            ],
        ],



    ],


];