<?php namespace My\Admin;

// 媒体资源操作
class Rw extends \Phpcmf\Table
{
    private $form;
    private $is_verify;

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        // 判断是否来自审核控制器
        $this->is_verify = strpos(\Phpcmf\Service::L('Router')->class, '_verify') !== false;
        // 判断表单是否操作
        $cache = \Phpcmf\Service::L('cache')->get('form-'.SITE_ID);
        $this->form = $cache[str_replace('_verify', '',\Phpcmf\Service::L('Router')->class)];
        !$this->form && $this->_admin_msg(0, dr_lang('网站表单【%s】不存在', str_replace('_verify', '',\Phpcmf\Service::L('Router')->class)));
        // 支持附表存储
        $this->is_data = 1;
        // 模板前缀(避免混淆)
        $this->tpl_prefix = 'media_';
        // 单独模板命名
        $this->tpl_name = $this->form['table'];
        // 表单显示名称
        $this->name = dr_lang('网站表单（%s）', $this->form['name']);
        $sysfield = ['inputtime', 'inputip', 'displayorder', 'author'];
        if ($this->is_verify) {
            $sysfield[] = 'mtstatus';
        }
        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_form_'.$this->form['table'],
            'field' => $this->form['field'],
            'sys_field' => $sysfield,
            'date_field' => 'inputtime',
            'show_field' => 'title',
            'list_field' => $this->form['setting']['list_field'],
            'order_by' => 'inputtime desc',
            'where_list' => $this->is_verify ? 'status=2' : 'status=1',
        ]);
        $menu = $this->is_verify ? \Phpcmf\Service::M('auth')->_admin_menu([
            '审核管理' => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', 'fa fa-edit'],
        ]) : \Phpcmf\Service::M('auth')->_admin_menu(
            [
                dr_lang('%s管理', $this->form['name']) => ['zy/'.\Phpcmf\Service::L('Router')->class.'/index', dr_icon($this->form['setting']['icon'])],
                '添加' => ['zy/'.\Phpcmf\Service::L('Router')->class.'/add', 'fa fa-plus'],
                '修改' => ['hide:zy/'.\Phpcmf\Service::L('Router')->class.'/edit', 'fa fa-edit'],
                '查看' => ['hide:zy/'.\Phpcmf\Service::L('Router')->class.'/show_index', 'fa fa-search'],
                '下载云端资源' => ['zy/'.\Phpcmf\Service::L('Router')->class.'/cloud', 'fa fa-cloud'],
            ]
        );
        \Phpcmf\Service::V()->assign([
            'menu' => $menu,
            'field' => $this->init['field'],
            'form_list' => $cache,
            'form_name' => $this->form['name'],
            'tid' => $this->form['table'],
            'is_verify' => $this->is_verify,
        ]);
    }
	
	function cloud() {
		$this->_admin_msg(0, dr_lang('无法通过云端服务器验证，请确保程序是否绑定授权账号'));
	}

    // 后台添加表单内容
    protected function _Admin_Add() {
        list($tpl) = $this->_Post(0);
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台修改表单内容
    protected function _Admin_Edit() {
        $id = intval(\Phpcmf\Service::L('Input')->get('id'));
        list($tpl, $data) = $this->_Post($id);
        !$data && $this->_admin_msg(0, dr_lang('数据不存在: '.$id));
        //$this->is_verify && $data['status'] && $this->_admin_msg(0, dr_lang('已经通过了审核'));
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台查看表单内容
    protected function _Admin_Show() {
        list($tpl, $data) = $this->_Show(intval(\Phpcmf\Service::L('Input')->get('id')));
        !$data && $this->_admin_msg(0, dr_lang('数据#%s不存在', $_GET['id']));
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台查看表单列表
    protected function _Admin_List() {
        list($tpl) = $this->_List();
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台删除表单内容
    protected function _Admin_Del() {
        $this->_Del(
            \Phpcmf\Service::L('Input')->get_post_ids(),
            null,
            function ($rows) {
                // 对应删除提醒
                foreach ($rows as $t) {
                    \Phpcmf\Service::M('member')->delete_admin_notice('zy/'.$this->form['table'].'_verify/edit:id/'.$t['id'], SITE_ID);
                    \Phpcmf\Service::L('cache')->clear('from_'.$this->form['table'].'_show_id_'.$t['id']);
                }

            },
            \Phpcmf\Service::M()->dbprefix($this->init['table'])
        );
    }

    // 后台批量审核
    protected function _Admin_Status() {

        $ids = \Phpcmf\Service::L('Input')->get_post_ids();
        !$ids && $this->_json(0, dr_lang('所选数据不存在'));

        // 格式化
        $in = [];
        foreach ($ids as $i) {
            $i && $in[] = intval($i);
        }
        !$in && $this->_json(0, dr_lang('所选数据不存在'));

        $rows = \Phpcmf\Service::M()->db->table($this->init['table'])->whereIn('id', $in)->get()->getResultArray();
        !$rows && $this->_json(0, dr_lang('所选数据不存在'));

        foreach ($rows as $row) {
            $this->_verify($row);
        }

        $this->_json(1, dr_lang('操作成功'));
    }

    // 后台批量保存排序值
    protected function _Admin_Order() {
        $this->_Display_Order(
            intval(\Phpcmf\Service::L('Input')->get('id')),
            intval(\Phpcmf\Service::L('Input')->get('value'))
        );
    }

    // 格式化保存数据 保存之前
    protected function _Format_Data($id, $data, $old) {

        // 后台添加时默认通过
        !$id && !$this->is_verify && $data[1]['status'] = 1;
        !$id && $data[1]['tableid'] = 0;

        if ($this->is_verify) {
            if ($_POST['data']['mtstatus']) {
                $data[1]['status'] = 1;
            } else {
                $data[1]['status'] = 3;
            }
            unset($data[1]['mtstatus']);
        }

        return $data;
    }

    /**
     * 保存内容
     * $id      内容id,新增为0
     * $data    提交内容数组,留空为自动获取
     * $func    格式化提交的数据
     * */
    protected function _Save($id = 0, $data = [], $old = [], $func = null, $func2 = null) {

        return parent::_Save($id, $data, $old, null,
            function ($id, $data, $old) {
                $data[1]['status'] == 1 && $this->is_verify && $this->_verify([
                    'id' => (int)$data[1]['id'],
                    'uid' => (int)$data[1]['uid'],
                    'status' => 0,
                ]);
                //\Phpcmf\Service::M('member')->todo_admin_notice('form/'.$this->form['table'].'_verify/edit:id/'.$id, SITE_ID);// clear
                \Phpcmf\Service::L('cache')->clear('from_'.$this->form['table'].'_show_id_'.$id);
            }
        );
    }

    public function yzzy_edit() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $row = \Phpcmf\Service::M()->init($this->init)->get($id);
        !$row && $this->_json(0, dr_lang('数据不存在'));

        $v = $row['is_yzzy'] ? 0 : 1;
        \Phpcmf\Service::M()->init($this->init)->update($id, ['is_yzzy' => $v]);

        exit($this->_json(1, dr_lang($v ? '已设置推荐资源' : '已取消推荐资源'), ['value' => $v]));
    }

    public function zt_edit() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $row = \Phpcmf\Service::M()->init($this->init)->get($id);
        !$row && $this->_json(0, dr_lang('数据不存在'));

        $v = $row['zt'] == 1 ? 2 : 1;
        \Phpcmf\Service::M()->init($this->init)->update($id, ['zt' => $v]);

        exit($this->_json(1, dr_lang($v == 1 ? '上架资源' : '下架资源'), ['value' => $v]));
    }

    // 审核表单
    protected function _verify($row) {

        if ($row['status'] == 1) {
            return;
        }


        \Phpcmf\Service::M()->db->table($this->init['table'])->where('id', $row['id'])->update(['status' => 1]);

        // 任务执行成功
        \Phpcmf\Service::M('member')->todo_admin_notice('zy/'.$this->form['table'].'_verify/edit:id/'.$row['id'], SITE_ID);

        // 提醒
        \Phpcmf\Service::M('member')->notice($row['uid'], 3, dr_lang('%s审核成功', $this->form['name']));

        // 挂钩点 程序初始化之后
        \Phpcmf\Hooks::trigger('form_verify', $row);
    }

}
