<?php namespace My\Member;

// 媒体主资源管理
class Rw extends \Phpcmf\Table
{

    private $tid;
    private $form;

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        // 判断控制器名称
        $this->tid = \Phpcmf\Service::L('Router')->class;
        if (!$this->rw_media[$this->tid]) {
            $this->_msg(0, dr_lang('媒体资源库【%s】不存在', $this->tid));
        } elseif (!in_array(2, $this->member['groupid'])) {
            $this->_msg(0, '只有媒体主才能管理资源');
        }
        $this->form = $this->rw_media[$this->tid];
        // 支持附表存储
        $this->is_data = 1;
        // 模板前缀(避免混淆)
        $this->tpl_prefix = 'media_';
        // 单独模板命名
        $this->tpl_name = $this->form['table'];
        // 表单显示名称
        $this->name = dr_lang('网站表单（%s）', $this->form['name']);
        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_form_'.$this->form['table'],
            'field' => $this->form['field'],
            'sys_field' => [],
            'date_field' => 'inputtime',
            'show_field' => 'title',
            'order_by' => 'inputtime desc',
            'where_list' => 'uid='.$this->uid,
        ]);
        \Phpcmf\Service::V()->assign([
            'tid' => $this->form['table'],
            'field' => $this->form['field'],
        ]);
    }

    // 媒体资源列表
    public function index() {
        list($tpl) = $this->_List();
        \Phpcmf\Service::V()->display($tpl);
    }


    // 后台添加表单内容
    public function add() {
        list($tpl) = $this->_Post(0);
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台修改表单内容
    public function edit() {
        $this->edit_where = 'uid='.$this->uid;
        $id = intval(\Phpcmf\Service::L('Input')->get('id'));
        list($tpl, $data) = $this->_Post($id);
        !$data && $this->_admin_msg(0, dr_lang('数据不存在: '.$id));
        \Phpcmf\Service::V()->display($tpl);
    }


    // 后台删除表单内容
    public function del() {
        $this->delete_where = 'uid='.$this->uid;
        $this->_Del(
            \Phpcmf\Service::L('Input')->get_post_ids(),
            null,
            function ($rows) {
                // 对应删除提醒
                foreach ($rows as $t) {
                    \Phpcmf\Service::M('member')->delete_admin_notice('zy/'.$this->form['table'].'_verify/edit:id/'.$t['id'], SITE_ID);
                    \Phpcmf\Service::L('cache')->clear('from_'.$this->form['table'].'_show_id_'.$t['id']);
                }

            },
            \Phpcmf\Service::M()->dbprefix($this->init['table'])
        );
    }

    // 后台批量审核
    public function zt_edit() {


        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $row = \Phpcmf\Service::M()->init($this->init)->get($id);
        !$row && $this->_json(0, dr_lang('数据不存在'));

        $v = $row['zt'] == 1 ? 2 : 1;
        \Phpcmf\Service::M()->init($this->init)->where('uid', $this->uid)->update($id, ['zt' => $v]);

        exit($this->_json(1, dr_lang($v == 1 ? '上架资源' : '下架资源'), ['value' => $v]));
    }

    // 格式化保存数据 保存之前
    protected function _Format_Data($id, $data, $old) {


        // 审核状态
        $data[1]['status'] = 2;

        // 默认数据
        $data[0]['uid'] = $data[1]['uid'] = (int)$this->member['uid'];
        $data[1]['author'] = $this->member['username'] ? $this->member['username'] : 'guest';
        $data[1]['inputip'] = \Phpcmf\Service::L('Input')->ip_address();
        $data[1]['inputtime'] = SYS_TIME;
        $data[1]['tableid'] = 0;
        $data[1]['displayorder'] = 0;

        return $data;
    }

}

