<?php namespace My\Member;

// 广告主订单管理
class Rw_buy extends \Phpcmf\Table
{

    private $tid;
    private $form;

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        // 判断控制器名称
        list($this->tid, $b) = explode('_', \Phpcmf\Service::L('Router')->class);
        if (!$this->rw_media[$this->tid]) {
            $this->_msg(0, dr_lang('媒体资源库【%s】不存在', $this->tid));
        } elseif (!in_array(1, $this->member['groupid'])) {
            $this->_msg(0, '只有广告主才能下单');
        }
        $this->form = $this->rw_media[$this->tid];
    }

    // 订单列表
    public function index() {

        $this->mfield = array(
            'sn' => array(
                'ismain' => 1,
                'name' => dr_lang('订单号'),
                'fieldname' => 'sn',
                'fieldtype' => 'Text',
            ),
            'title' => array(
                'ismain' => 1,
                'name' => dr_lang('活动名称'),
                'fieldname' => 'title',
                'fieldtype' => 'Text',
            ),
            'zy_title' => array(
                'ismain' => 1,
                'name' => dr_lang('媒体名称'),
                'fieldname' => 'zy_title',
                'fieldtype' => 'Text',
            ),
        );

        $this->_init([
            'table' => 'rw_item',
            'field' => $this->mfield,
            'show_field' => 'title',
            'order_by' => 'inputtime desc', // 列表排序显示方式
        ]);

        $zt = \Phpcmf\Service::L('input')->get('status');
        $where = ['buy_uid='.$this->uid.' AND tid="'.$this->tid.'"'];
        if (strlen($zt)) {
            $where[] = '`status`='.intval($zt);
        }

        $where && \Phpcmf\Service::M()->set_where_list(implode(' AND ', $where));

        $this->_List([
            'status' => strlen($zt) ? $zt : '',
        ]);

        \Phpcmf\Service::V()->assign([
            'field' => $this->mfield,
            'status' => $zt,
            'search_url' => dr_member_url(APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index'),
        ]);
        \Phpcmf\Service::V()->display('rw/buy_list.html');
    }


    // 订单详情
    public function info() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $data = \Phpcmf\Service::M()->table('rw_item')->get($id);
        if (!$data) {
            $this->_msg(0, '此订单不存在');
        } elseif ($data['buy_uid'] != $this->uid) {
            $this->_msg(0, '此订单不属于你');
        }

        $content = dr_string2array($data['content']);
        unset($data['content']);

        \Phpcmf\Service::V()->assign([
            'order' => $data,
            'content' => $content,
            'pay_url' => dr_member_url('zy/'.$data['tid'].'_buy/pay_item', ['id' => $id]),
            'uriprefix' => APP_DIR.'/'.\Phpcmf\Service::L('Router')->class,
            'order_log' => \Phpcmf\Service::M('morder', 'rw')->init($this->form['table'])->get_item_logs($id),
            'reply_url' => \Phpcmf\Service::L('Router')->get_back(\Phpcmf\Service::L('Router')->uri('index'), $this->url_params),
            'rw_field_file' => APPSPATH.'Zy/Field/'.ucfirst($this->tid).'/info.html',
        ]);
        \Phpcmf\Service::V()->display('rw/buy_info.html');
    }

    // 处理订单
    public function edit() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $data = \Phpcmf\Service::M()->table('rw_item')->get($id);
        if (!$data) {
            $this->_json(0, '此订单不存在');
        } elseif ($data['buy_uid'] != $this->uid) {
            $this->_json(0, '此订单不属于你');
        }

        $status = (int)\Phpcmf\Service::L('input')->get('status');
        switch ($status) {

            // 关闭订单
            case 0:
                if ($data['status'] != 4) {
                    $this->_json(0, '订单状态需要在[待接单]状态才能关闭');
                }
                if (IS_POST) {
                    $post = \Phpcmf\Service::L('input')->post('data');
                    if (!$post['content']) {
                        $this->_json(0, '未填写关闭理由');
                    }
                    \Phpcmf\Service::M('morder', 'rw')->init($this->form['table'])->guanbi_item($data, $post['content']);
                    $this->_json(1, '操作成功');
                }
                \Phpcmf\Service::V()->display('rw/buy_ajax_gb.html');
                break;


            default:
                $this->_json(0, '未定义的操作');
                break;
        }


        exit;
    }

    // 订单付款
    public function pay_item() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $data = \Phpcmf\Service::M()->table('rw_item')->get($id);
        if (!$data) {
            $this->_msg(0, '此订单不存在');
        } elseif ($data['buy_uid'] != $this->uid) {
            $this->_msg(0, '此订单不属于你');
        } elseif ($data['mstatus']) {
            $this->_msg(0, '此订单已经付款成功');
        } elseif ((float)$data['money'] <= 0 ) {
            $this->_msg(0, '订单金额不正确');
        } elseif ((float)$this->member['money'] <= 0 ) {
            $this->_msg(0, '账户余额不足');
        } elseif ($this->member['money'] - $data['money'] < 0) {
            $this->_msg(0, '账户可用余额不足');
        }

        // 付款操作
        \Phpcmf\Service::M('morder', 'rw')->init($data['tid'])->pay_item($data);

        $this->_msg(1, '付款成功', dr_member_url(APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/info', ['id' => $id]));
    }


    // 订单合并付款
    public function pay_order() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $data = \Phpcmf\Service::M()->table('rw_order')->get($id);
        if (!$data) {
            $this->_msg(0, '此付款订单不存在');
        } elseif ($data['uid'] != $this->uid) {
            $this->_msg(0, '此付款订单不属于你');
        } elseif ($data['status']) {
            $this->_msg(0, '此付款订单已经付款成功', dr_member_url(APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', ['status' => 4]));
        } elseif ((float)$data['money'] <= 0 ) {
            $this->_msg(0, '订单金额不正确');
        } elseif ((float)$this->member['money'] <= 0 ) {
            $this->_msg(0, '账户余额不足', dr_member_url(APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', ['status' => 3]));
        } elseif ($this->member['money'] - $data['money'] < 0) {
            $this->_msg(0, '账户可用余额不足', dr_member_url(APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', ['status' => 3]));
        }

        // 付款操作
        \Phpcmf\Service::M('morder', 'rw')->init($this->form['table'])->pay_order($data);

        $this->_msg(1, '付款成功', dr_member_url(APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', ['status' => 4]));

    }

    // 批量付款
    public function pay_all() {

        $ids = \Phpcmf\Service::L('Input')->get_post_ids();
        !$ids && $this->_json(0, dr_lang('所选订单不存在'));

        // 格式化
        $in = [];
        foreach ($ids as $i) {
            $i && $in[] = intval($i);
        }
        !$in && $this->_json(0, dr_lang('付款失败：所选订单不存在'));

        $rows = \Phpcmf\Service::M()->db->table('rw_item')->whereIn('id', $in)->get()->getResultArray();
        !$rows && $this->_json(0, dr_lang('付款失败：所选订单不存在'));

        $money = 0;
        foreach ($rows as $row) {
            if ($row['mstatus']) {
                $this->_json(0, dr_lang('付款失败：存在已经支付过了的订单'));
            }
            if ($row['buy_uid'] != $this->uid) {
                $this->_json(0, dr_lang('付款失败：存在他人订单'));
            }
            $money+= $row['money'];
        }

        if ($money <= 0 ) {
            $this->_json(0, '付款失败：订单金额不正确');
        } elseif ((float)$this->member['money'] <= 0 ) {
            $this->_json(0, '付款失败：账户余额不足');
        } elseif ($this->member['money'] - $money < 0) {
            $this->_json(0, '付款失败：账户可用余额不足');
        }


        // 合并付款
        $oid = \Phpcmf\Service::M('morder', 'rw')->init($this->form['table'])->hbfk($rows);
        $data = \Phpcmf\Service::M()->table('rw_order')->get($oid);
        \Phpcmf\Service::M('morder', 'rw')->init($this->form['table'])->pay_order($data);
        $this->_msg(1, '付款成功');

    }

    // 订单下单开始
    public function checkout() {

        $pid = dr_safe_replace($_GET['pid']);
        $arr = explode('-', dr_safe_replace($_GET['ids']));
        if (!$arr) {
            $this->_msg(0, '媒体资源参数不正确');
        }

        $ids = [];
        foreach ($arr as $v) {
            $v = intval($v);
            $v && $ids[] = $v;
        }

        if (!$ids) {
            $this->_msg(0, '媒体资源参数不正确');
        }

        $zy_list = \Phpcmf\Service::M('morder', 'rw')->init($this->form['table'])->get_list($ids, $pid);

        if (IS_POST) {
            $post = \Phpcmf\Service::L('input')->post('order', true);
            $content = \Phpcmf\Service::L('input')->post('data', true);
            if (!$content) {
                $this->_json(0, '活动内容未填写完整');
            } elseif (!$post['title']) {
                $this->_json(0, '活动标题未填写');
            }
            $rt = \Phpcmf\Service::M('morder', 'rw')->init($this->form['table'])->save_order($ids, $zy_list, $post, $content);
            if (!$rt['code']) {
                $this->_json(0, $rt['msg']);
            }
            $this->_json(1, '下单成功', [
                'url' => $rt['msg']
            ]);
            exit;
        }

        \Phpcmf\Service::V()->assign([
            'rw_id' => $this->form['table'],
            'rw_name' => $this->form['name'],
            'rw_zy_list' => $zy_list,
            'rw_field_file' => APPSPATH.'Zy/Field/'.ucfirst($this->tid).'/checkout.html',
        ]);
        \Phpcmf\Service::V()->display('rw/buy_checkout.html');
    }


}

