<?php namespace My\Member;

// 媒体主订单管理
class Rw_sell extends \Phpcmf\Table
{

    private $tid;
    private $form;

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        // 判断控制器名称
        list($this->tid, $b) = explode('_', \Phpcmf\Service::L('Router')->class);
        if (!$this->rw_media[$this->tid]) {
            $this->_msg(0, dr_lang('媒体资源库【%s】不存在', $this->tid));
        } elseif (!in_array(2, $this->member['groupid'])) {
            $this->_msg(0, '只有媒体主才能管理订单');
        }
        $this->form = $this->rw_media[$this->tid];
    }

    // 订单列表
    public function index() {

        $this->mfield = array(
            'sn' => array(
                'ismain' => 1,
                'name' => dr_lang('订单号'),
                'fieldname' => 'sn',
                'fieldtype' => 'Text',
            ),
            'title' => array(
                'ismain' => 1,
                'name' => dr_lang('活动名称'),
                'fieldname' => 'title',
                'fieldtype' => 'Text',
            ),
            'zy_title' => array(
                'ismain' => 1,
                'name' => dr_lang('媒体名称'),
                'fieldname' => 'zy_title',
                'fieldtype' => 'Text',
            ),
        );

        $this->_init([
            'table' => 'rw_item',
            'field' => $this->mfield,
            'show_field' => 'title',
            'order_by' => 'inputtime desc', // 列表排序显示方式
        ]);

        $zt = \Phpcmf\Service::L('input')->get('status');
        $where = ['sell_uid='.$this->uid.' AND tid="'.$this->tid.'"'];
        if (strlen($zt)) {
            $where[] = '`status`='.intval($zt);
        }

        $where && \Phpcmf\Service::M()->set_where_list(implode(' AND ', $where));

        $this->_List([
            'status' => strlen($zt) ? $zt : '',
        ]);

        \Phpcmf\Service::V()->assign([
            'field' => $this->mfield,
            'status' => $zt,
            'search_url' => dr_member_url(APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index'),
        ]);
        \Phpcmf\Service::V()->display('rw/sell_list.html');
    }


    // 订单详情
    public function info() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $data = \Phpcmf\Service::M()->table('rw_item')->get($id);
        if (!$data) {
            $this->_msg(0, '此订单不存在');
        } elseif ($data['sell_uid'] != $this->uid) {
            $this->_msg(0, '此订单不属于你');
        }

        $content = dr_string2array($data['content']);
        unset($data['content']);

        \Phpcmf\Service::V()->assign([
            'order' => $data,
            'content' => $content,
            'order_log' => \Phpcmf\Service::M('morder', 'rw')->init($this->form['table'])->get_item_logs($id),
            'uriprefix' => APP_DIR.'/'.\Phpcmf\Service::L('Router')->class,
            'reply_url' => \Phpcmf\Service::L('Router')->get_back(\Phpcmf\Service::L('Router')->uri('index'), $this->url_params),
            'rw_field_file' => APPSPATH.'Zy/Field/'.ucfirst($this->tid).'/info.html',
        ]);
        \Phpcmf\Service::V()->display('rw/sell_info.html');
    }

    // 处理订单
    public function edit() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $data = \Phpcmf\Service::M()->table('rw_item')->get($id);
        if (!$data) {
            $this->_json(0, '此订单不存在');
        } elseif ($data['sell_uid'] != $this->uid) {
            $this->_json(0, '此订单不属于你');
        }

        $status = (int)\Phpcmf\Service::L('input')->get('status');
        switch ($status) {

            // 接单
            case 6:
                if ($data['status'] != 4) {
                    $this->_json(0, '订单状态需要在[待接单]状态才能接单');
                }
                // 开始接单
                \Phpcmf\Service::M('morder', 'rw')->init($this->form['table'])->jiedan_item($data);
                $this->_json(1, '接单成功');
                break;

            // 拒单
            case 8:
                if ($data['status'] != 4) {
                    $this->_json(0, '订单状态需要在[待接单]状态才能拒单');
                }
                if (IS_POST) {
                    $post = \Phpcmf\Service::L('input')->post('data');
                    if (!$post['content']) {
                        $this->_json(0, '未填写拒单理由');
                    }
                    \Phpcmf\Service::M('morder', 'rw')->init($this->form['table'])->judan_item($data, $post['content']);
                    $this->_json(1, '拒单成功');
                }
                \Phpcmf\Service::V()->assign('content_field', dr_field_form(array(
                    'fieldtype' => 'Ueditor',
                    'fieldname' => 'content',
                    'setting' => array(
                        'option' => array(
                            'mode' => 2,
                            'height' => 300,
                            'width' => '100%'
                        )
                    )), '', 0, 1));
                \Phpcmf\Service::V()->display('rw/sell_ajax_jd.html');
                break;


            // 完成 平台验收
            case 7:
                if (!in_array($data['status'], [6, 12])) {
                    $this->_json(0, '订单状态需要在[执行中、被退回]状态才能完成订单');
                }
                if (IS_POST) {
                    $post = \Phpcmf\Service::L('input')->post('data');
                    if (!$post['content']) {
                        $this->_json(0, '未填写完成凭证信息');
                    }
                    \Phpcmf\Service::M('morder', 'rw')->init($this->form['table'])->wancheng_item($data, $post['content']);
                    $this->_json(1, '提交成功，等待平台验收');
                }
                \Phpcmf\Service::V()->assign('content_field', dr_field_form(array(
                    'fieldtype' => 'Ueditor',
                    'fieldname' => 'content',
                    'setting' => array(
                        'option' => array(
                            'mode' => 2,
                            'height' => 300,
                            'width' => '100%'
                        )
                    )), '', 0, 1));
                \Phpcmf\Service::V()->display('rw/sell_ajax_wc.html');
                break;


            default:
                $this->_json(0, '未定义的操作');
                break;
        }


        exit;
    }



}

