<?php

if (!function_exists('dr_rw_media_url')) {
    function dr_rw_media_url($name) {
        return '/index.php?s=rw&tid='.$name;
    }
}

if (!function_exists('dr_rw_show_url')) {
    function dr_rw_show_url($name, $id) {
        return '/index.php?s=rw&c=show&tid='.$name.'&id='.$id;
    }
}

if (!function_exists('dr_rw_search_url')) {
    function dr_rw_search_url($tid, $params, $name, $value) {

        !$params && $params = [];

        if ($name) {
            if (is_array($name)) {
                foreach ($name as $i => $_name) {
                    if (isset($value[$i]) && strlen($value[$i])) {
                        $params[$_name] = $value[$i];
                    } else {
                        unset($params[$_name]);
                    }
                }
            } else {
                if (strlen($value)) {
                    $params[$name] = $value;
                } else {
                    unset($params[$name]);
                }
            }

        }

        if (is_array($params)) {
            foreach ($params as $i => $t) {
                if (strlen($t) == 0) {
                    unset($params[$i]);
                }
            }
        }

        $search = dr_search_rewrite_encode($params, [
            'param_join' => '-',
            'param_rule' => '',
        ]);

        return $search ? '/index.php?s=rw&tid='.$tid.'&search='.$search : dr_rw_media_url($tid);
    }
}

// 购买价格计算
function dr_buy_price($price) {

    if (\Phpcmf\Service::C()->myprice['bfb']) {
        $price = $price * (1 + \Phpcmf\Service::C()->myprice['bfb']/100);
    }

    return $price;
}
// 会员折扣价格
function dr_rw_member_price($price, $lv) {

    if (\Phpcmf\Service::C()->myprice['user'][$lv]) {
        $price = $price * (1 - (100-\Phpcmf\Service::C()->myprice['user'][$lv])/100);
    }

    return $price;
}


// 价格配置文件
function dr_rw_price($field, $tid) {

    if (is_file(APPSPATH.'Zy/Field/'.ucfirst($tid).'/price.php')) {
        $rt = [];
        $config = require APPSPATH.'Zy/Field/'.ucfirst($tid).'/price.php';
        foreach ($config as $key) {
            if ($field[$key]) {
                $rt[$key] = $field[$key]['name'];
            }
        }
        return $rt;
    } else {
        return [
            'price' => '价格'
        ];
    }
}

// 获取默认价格字段
function dr_rw_default_price($tid) {

    $price = dr_rw_price(\Phpcmf\Service::C()->rw_media[$tid]['field'], $tid);
    reset($price);

    return key($price);
}

// 订单状态 order
function dr_order_status($id) {
    return \Phpcmf\Service::C()->order_status[$id] ? \Phpcmf\Service::C()->order_status[$id] : '未知('.$id.')';
}
// 资金状态
function dr_money_status($id) {
    return \Phpcmf\Service::C()->money_status[$id] ? \Phpcmf\Service::C()->money_status[$id] : '未知('.$id.')';
}



function dr_rw_shuliang($hits) {

    $b=1000;
    $c=10000;

    if($hits>$b){
        if ($hits<$c) {

            return floor($hits/$b).'千';
        } else {

            return (floor(($hits/$c)*10)/10).'万';
        }
    } else {
        return $hits;
    }

}


if(!function_exists('mime_content_type')) {

    function mime_content_type($filename) {

        $mime_types = array(

            'txt' => 'text/plain',
            'htm' => 'text/html',
            'html' => 'text/html',
            'php' => 'text/html',
            'css' => 'text/css',
            'js' => 'application/javascript',
            'json' => 'application/json',
            'xml' => 'application/xml',
            'swf' => 'application/x-shockwave-flash',
            'flv' => 'video/x-flv',

            // images
            'png' => 'image/png',
            'jpe' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'jpg' => 'image/jpeg',
            'gif' => 'image/gif',
            'bmp' => 'image/bmp',
            'ico' => 'image/vnd.microsoft.icon',
            'tiff' => 'image/tiff',
            'tif' => 'image/tiff',
            'svg' => 'image/svg+xml',
            'svgz' => 'image/svg+xml',

            // archives
            'zip' => 'application/zip',
            'rar' => 'application/x-rar-compressed',
            'exe' => 'application/x-msdownload',
            'msi' => 'application/x-msdownload',
            'cab' => 'application/vnd.ms-cab-compressed',

            // audio/video
            'mp3' => 'audio/mpeg',
            'qt' => 'video/quicktime',
            'mov' => 'video/quicktime',

            // adobe
            'pdf' => 'application/pdf',
            'psd' => 'image/vnd.adobe.photoshop',
            'ai' => 'application/postscript',
            'eps' => 'application/postscript',
            'ps' => 'application/postscript',

            // ms office
            'doc' => 'application/msword',
            'rtf' => 'application/rtf',
            'xls' => 'application/vnd.ms-excel',
            'ppt' => 'application/vnd.ms-powerpoint',

            // open office
            'odt' => 'application/vnd.oasis.opendocument.text',
            'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
        );

        $ext = strtolower(array_pop(explode('.',$filename)));
        if (array_key_exists($ext, $mime_types)) {
            return $mime_types[$ext];
        }
        elseif (function_exists('finfo_open')) {
            $finfo = finfo_open(FILEINFO_MIME);
            $mimetype = finfo_file($finfo, $filename);
            finfo_close($finfo);
            return $mimetype;
        }
        else {
            return 'application/octet-stream';
        }
    }
}
