<?php

namespace App\Http\Controllers\Admin;

use App\Models\Category;
use App\Models\Setting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class CategoryController extends Controller
{

    /**
     * 描述：栏目分类首页
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  index()
    {
        $page= Category::with('pid')->get()->toArray();
        foreach ($page as $key => $item)
        {
            $speed = '';
            $ids = explode('，',$item['speed_ids']);
            foreach ($ids as $k => $val)
            {
                $speed.=Setting::where('id',$val)->first(['name'])['name'].'、';
            }
            $page[$key]['speed'] =  substr($speed,0,strlen($speed)-3);
        }
        return view('Admin.Category.index',compact('page'));
    }

    /**
     * 描述：添加分类
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  create()
    {
        $settings = Setting::all();
        $groups = Category::where('pid',0)->get();
        return view('Admin.Category.create',compact('groups','settings'));
    }
    /**
     * 描述：新增栏目提交
     * @param Request $request
     */
    public  function  store(Request $request)
    {


        $validates = Validator::make($request->all(),[
            'name' => 'required',
            'key' => 'required',
            'url' => 'required',
        ]);
        if(!$validates->fails()){
            $data = $request->all();
            $data['speed_ids'] = implode('，',$data['speed_ids']);
            $result = Category::create($data);
            if($result)
            {
                $this->set('code',0);
                $this->set('message','新增成功');
            }else{
                $this->set('code',1);
                $this->set('message','新增失败');
            }
        }else{
            $this->set('code',1);
            $this->set('message','请填写完整内容');
        }
        return $this->ajaxResponse();
    }

    /**
     * 描述：修改栏目
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit($id)
    {
        $settings = Setting::all();
        $groups = Category::where('pid',0)->get();
        $show = Category::where('id',$id)->first();
        if( $show->speed_ids){
            $show->speed_ids = explode('，',$show->speed_ids);
        }
        return view('Admin.Category.edit',compact('show','groups','settings'));
    }

    /**
     * 描述：提交修改
     * @param Request $request
     */
    public  function  update(Request $request,$id)
    {
        $validates = Validator::make($request->all(),[
          'name' => 'required',
        ]);
        if(!$validates->fails()){
            $data = $request->all();
            $data['speed_ids'] = implode('，',$data['speed_ids']);
            unset($data['_method']);
            $result = Category::where('id',$id)->update($data);
            if($result)
            {
                $this->set('code',0);
                $this->set('message','编辑成功');
            }else{
                $this->set('code',1);
                $this->set('message','编辑失败');
            }
        }else{
            $this->set('code',1);
            $this->set('message','请填写完整内容');
        }
        return $this->ajaxResponse();
    }






}
