<?php

namespace App\Http\Controllers\Admin;

use App\Models\AdminUser;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

/**
 * Class LoginController
 * @package App\Http\Controllers\Admin
 */
class LoginController extends Controller
{
    use AuthenticatesUsers;
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * 登录
     */
    public function login()
    {
        if(Session::get('admin.username') && Session::get('admin.id'))
        {
            return redirect(url('admin/index'));
        }
        return view('Admin.Login.login');
    }

    /**
     * @param Request $request
     * 登录验证
     */
    public function checkLogin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'captcha' => 'required|captcha',
            'username'=>'required|min:3',
            'password'=>'required|min:5',
        ]);
        if(!$validator->fails())
        {
            $user = AdminUser::where(['username'=>$request->username])->where(['status'=>1])->first();
            if($user){
                if (Auth::guard('admin')->attempt(['username' => $request->username, 'password' => $request->password])) {
//                $user = AdminUser::where(['username'=>$request->username])->first();
                    Session::put('admin.username','admin');
                    Session::put('admin.id',$user->id);
                    Session::save();
                    return redirect(url('admin/index'));
                }else{
                    return back()->withInput();
                }
            }else{
                return back()->withInput();
            }
        }else{
            return back()->withInput();
        }
    }
    /**
     * @param Request $request
     * @return array
     * 点击更换图片
     */
    public function generateCaptcha(){
        return ['captcha'=>captcha_src()];
    }

    /**
     * 登出
     */
    public function logout()
    {
        Session::flush();
        return redirect(url('admin/login'));
    }

}
