<?php

namespace App\Http\Controllers\Admin;

use App\Models\Setting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class SettingController extends Controller
{
    //
    protected $pageSize = 10;
    /**
     * 描述：栏目分类首页
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  index(Request $request)
    {
      $page = Setting::all();
        return view('Admin.Setting.index',compact('page'));
    }

    /**
     * 描述：添加分类
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  create()
    {

        return view('Admin.Setting.create');
    }
    /**
     * 描述：新增栏目提交
     * @param Request $request
     */
    public  function  store(Request $request)
    {
        $validates = Validator::make($request->all(),[
            'name' => 'required',
            'value' => 'required',
        ]);
        if(!$validates->fails()){
           $data = $request->all();
           $data['up']  = $data['up'] ? $data['up'] : 0;
           $data['down']  = $data['down'] ? $data['down'] : 0;
           $data['value']  = $data['value'] ? $data['value'] : 'null';
           $data['remark']  = $data['remark'] ? $data['remark'] : 'null';
           $result = Setting::create($data);
           if($result)
           {
               $this->set('code',0);
               $this->set('message','新增成功');
           }else{
               $this->set('code',1);
               $this->set('message','新增失败');
           }
        }else{
            $this->set('code',1);
            $this->set('message','请填写完整内容');
        }
        return $this->ajaxResponse();
    }

    /**
     * 描述：修改栏目
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit($id)
    {
        $show= Setting::where('id',$id)->first();
        return view('Admin.Setting.edit',compact('show'));
    }

    /**
     * 描述：提交修改
     * @param Request $request
     */
    public  function  update(Request $request,$id)
    {
        $validates = Validator::make($request->all(),[
          'name' => 'required',
          'value' => 'required',
        ]);
        if(!$validates->fails()){
            $data = $request->all();
             unset($data['_method']);
            $result = Setting::where('id',$id)->update($data);
            if($result)
            {
                $this->set('code',0);
                $this->set('message','编辑成功');
            }else{
                $this->set('code',1);
                $this->set('message','编辑失败');
            }
        }else{
            $this->set('code',1);
            $this->set('message','请填写完整内容');
        }
        return $this->ajaxResponse();
    }



    /**
     * 描述：单条删除
     * @param Request $request
     * @return array
     */
    public  function  destroy($id)
    {
        $query = Setting::where('id',$id)->delete();
        if($query)
        {
            $this->set('code',0);
            $this->set('info','删除成功');
        }else
        {
            $this->set('code', 1);
            $this->set('info', '删除失败');
        }
        return $this->ajaxResponse();
    }

}
