<?php

namespace App\Http\Controllers\Admin;

use App\Models\Tag;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TagController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tags=Tag::select()->with(['child'=>function($query){
            $query->select()->get();
        }])->where(['pid'=>0])->get();
        return view('Admin.Tag.index',compact('tags'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $tags=Tag::where(['pid'=>0])->get();
        return view('Admin.Tag.create',compact('tags'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'pid'=>'required',
            'name'=>'required|unique:tags'
        ],[
            'pid.required'=>'请选择标签类别',
            'name.required'=>'请填写标签名称',
            'name.unique'=>'该标签已存在'
        ]);
//        dd($request->all());
        if(Tag::create($request->all())){
            die("<script>parent.location.href='".route('tag.index')."'</script>");
        }else{
            return redirect()->back()->withInput()->withErrors('添加失败');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tags=Tag::where(['pid'=>0])->get();
        $model=Tag::findOrFail($id);
        return view('Admin.Tag.edit',compact(['tags','model']));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'pid'=>'required',
            'name'=>'required|unique:tags,name,'.$id
        ],[
            'pid.required'=>'请选择标签类别',
            'name.required'=>'请填写标签名称',
            'name.unique'=>'该标签已存在'
        ]);
        $model=Tag::findOrFail($id);
        $model->pid=$request->pid;
        $model->name=$request->name;
        if($model->save()){
            die("<script>parent.location.href='".route('tag.index')."'</script>");
        }else{
            return redirect()->back()->withInput()->withErrors('添加失败');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $flag=Tag::where(['pid'=>$id])->first();
        if($flag){
            return response()->json(['status'=>201,'msg'=>'该标签分类下有子标签,不能直接删除']);
        }
        $tag=Tag::find($id);
        if(!$tag){
            return response()->json(['status'=>202,'msg'=>'该标签已经被删除,请刷新页面']);
        }
        if($tag->delete()){
            return response()->json(['status'=>200,'msg'=>'删除成功']);
        }else{
            return response()->json(['status'=>203,'msg'=>'删除失败']);
        }
    }
}
