<?php

namespace App\Http\Controllers\Admin;

use App\Models\Category;
use App\Models\Crontab;
use App\Models\Setting;
use App\Models\TrillTask;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TrillTaskController extends Controller
{
    public  function date($request,$type)
    {

        $model = TrillTask::where('type',$type)->with('speed')->with('acceptInfo')->with('crontab');
        if ($request->get('start')){
            $model = $model->where('created_at','>=',$request->get('start'));
        }
        if ($request->get('end')){
            $model = $model->where('created_at','<=',$request->get('end'));;
        }

       /* if ($request->get('url')){
            $model = $model->where('url','like','%'.$request->get('url').'%');
        }

        if ($request->get('status')  && $request->get('status') != null){
            $model = $model->where('status',$request->get('status'));
        }*/
        $page = $model->orderBy('created_at','desc')->paginate(20);
        return $page;
    }
    /**
     * 描述：任务修改
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  edit($id)
    {
        $show = TrillTask::with('userInfo')->with('speed')->with('acceptInfo')->find($id);
        $crontab = Crontab::where('type',3)->where('task_id',$id)->first();
        if($show->type == 1)
        {
            $cate = Category::where('key','trill_fans')->first();
            $rout = "trill.fans";
        }elseif($show->type == 2){
            $cate = Category::where('key','trill_like')->first();
            $rout = "trill.like";
        }elseif($show->type == 3){
            $cate = Category::where('key','trill_comment')->first();
            $rout = "trill.comment";
        }elseif($show->type == 4){
            $cate = Category::where('key','trill_transmit')->first();
            $rout = "trill.transmit";
        } elseif($show->type == 5){
            $cate = Category::where('key','trill_watch')->first();
            $rout = "trill.watch";
        }
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }

        return view('Admin.Trill.edit',compact('show','speeds','rout','crontab'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        $trill= TrillTask::where('id',$id)->with('userInfo')->with('acceptInfo')->with('crontab')->with('speed')->first();
        $price = Setting::where('id',$trill->speed_id)->first(['value'])->value;

        $data['trill_id'] = $request->input('trill_id');
        $data['require_like'] = $request->input('require_like');
        $data['speed_id'] = $trill->speed_id;
        $data['content'] =$request->content ? $request->content : $trill->content ;
        $data['accept_uid'] = $trill->speed_id;
        $data['content'] = $request->input('content');
        $data['price']   = $data['require_like'] * $price /100;


        //任务表的数据

        $crontab['pay_status'] = $request->pay_status ? $request->pay_status : ($trill->crontab ?  $trill->crontab->pay_status : 0);

        $crontab['status'] = $request->status ? $request->status :($trill->crontab ?  $trill->crontab->status : 0);
        $crontab['price'] = $request->price ? $request->price : ($trill->crontab ?  $trill->crontab->price : 0);
        $crontab['type'] = 3;
        $crontab['accept_time'] = date('Y-m-d H:i:s',time());

        if($request->accept_uid)
        {
            $accept_id = User::where('mobile',$request->accept_uid)->first(['id'])->id;
            $data['accept_uid'] =$accept_id;
            if(Crontab::where('task_id',$id)->where('type',3)->first())
            {
                $cron_result = Crontab::where('id',$trill->crontab->id)->update($crontab);
            }else{
                $crontab['task_id'] = $id;
                $cron_result = Crontab::create($crontab);
            }
        }else{
            $cron_result = true;
        }
        $trill_result =  TrillTask::where('id',$id)->update($data);
        if($trill_result && $cron_result)
        {
            $this->set('code',0);
            $this->set('message','修改成功');
        }else
        {
            $this->set('code',1);
            $this->set('message','修改失败');
        }
        return $this->ajaxResponse();
    }
    /**
     * 描述：单条删除

     * @return array
     */
    public  function  destroy($id)
    {
        $query = TrillTask::where('id',$id)->delete();
        if($query)
        {
            $this->set('code',0);
            $this->set('info','删除成功');
        }else
        {
            $this->set('code', 1);
            $this->set('info', '删除失败');
        }
        return $this->ajaxResponse();
    }

    /**
     * 描述：描述：粉丝
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillFans(Request $request,$type)
    {
        $page = $this->date($request,$type);
        $data= $request->all();
        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.Trill.trillFans',compact('page','data'));
    }
    /**
     * 描述：点赞
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillLike(Request $request,$type)
    {
        $page = $this->date($request,$type);
        $data= $request->all();
        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.Trill.trillLike',compact('page','data'));
    }
    /**
     * 描述：评论
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillComment(Request $request,$type)
    {
        $page = $this->date($request,$type);
        $data= $request->all();
        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.Trill.trillComment',compact('page','data'));
    }
    /**
     * 描述：转发
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillTransmit(Request $request,$type)
    {
        $page = $this->date($request,$type);
        $data= $request->all();
        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.Trill.trillTransmit',compact('page','data'));
    }
    /**
     * 描述：观看量
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillWatch(Request $request,$type)
    {
        $page = $this->date($request,$type);
        $data= $request->all();
        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.Trill.trillWatch',compact('page','data'));
    }



}
